Abort::usage = "\!\(\*RowBox[{\"Abort\", \"[\", \"]\"}]\) generates an interrupt to abort a computation. "
AbortProtect::usage = "\!\(\*RowBox[{\"AbortProtect\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\), saving any aborts until the evaluation is complete. "
Above::usage = "Above is used to specify alignment in printforms such as ColumnForm and TableForm."
Abs::usage = "\!\(\*RowBox[{\"Abs\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the absolute value of the real or complex number \!\(\*StyleBox[\"z\", \"TI\"]\). "
AbsoluteCurrentValue::usage = "\!\(\*RowBox[{\"AbsoluteCurrentValue\", \"[\", StyleBox[\"item\", \"TI\"], \"]\"}]\) gives the absolute current value of \!\(\*StyleBox[\"item\", \"TI\"]\) at a location in the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) system and interface. \n\!\(\*RowBox[{\"AbsoluteCurrentValue\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"item\", \"TI\"], \",\", StyleBox[\"spec\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the absolute current value for the feature of \!\(\*StyleBox[\"item\", \"TI\"]\) specified by \!\(\*StyleBox[\"spec\", \"TI\"]\).\n\!\(\*RowBox[{\"AbsoluteCurrentValue\", \"[\", RowBox[{StyleBox[\"obj\", \"TI\"], \",\", StyleBox[\"item\", \"TI\"]}], \"]\"}]\) gives the absolute current value of \!\(\*StyleBox[\"item\", \"TI\"]\) associated with the object \!\(\*StyleBox[\"obj\", \"TI\"]\). "
AbsoluteDashing::usage = "\!\(\*RowBox[{\"AbsoluteDashing\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) is a graphics directive which specifies that lines which follow are to be drawn dashed, with successive segments having absolute lengths \!\(\*SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \[Ellipsis] (repeated cyclically). \n\!\(\*RowBox[{\"AbsoluteDashing\", \"[\", StyleBox[\"d\", \"TI\"], \"]\"}]\) is equivalent to \!\(\*RowBox[{\"AbsoluteDashing\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"d\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"}\"}], \"]\"}]\). "
AbsoluteOptions::usage = "\!\(\*RowBox[{\"AbsoluteOptions\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the absolute settings of options specified in an expression such as a graphics object. \n\!\(\*RowBox[{\"AbsoluteOptions\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"name\", \"TI\"]}], \"]\"}]\) gives the absolute setting for the option \!\(\*StyleBox[\"name\", \"TI\"]\). \n\!\(\*RowBox[{\"AbsoluteOptions\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"name\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"name\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a list of the absolute settings for the options \!\(\*SubscriptBox[StyleBox[\"name\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"AbsoluteOptions\", \"[\", StyleBox[\"object\", \"TI\"], \"]\"}]\) gives the absolute settings for options associated with an external object such as a NotebookObject. "
AbsolutePointSize::usage = "\!\(\*RowBox[{\"AbsolutePointSize\", \"[\", StyleBox[\"d\", \"TI\"], \"]\"}]\) is a graphics directive which specifies that points which follow are to be shown if possible as circular regions with absolute diameter \!\(\*StyleBox[\"d\", \"TI\"]\). "
AbsoluteThickness::usage = "\!\(\*RowBox[{\"AbsoluteThickness\", \"[\", StyleBox[\"d\", \"TI\"], \"]\"}]\) is a graphics directive which specifies that lines which follow are to be drawn with absolute thickness \!\(\*StyleBox[\"d\", \"TI\"]\). "
AbsoluteTime::usage = "\!\(\*RowBox[{\"AbsoluteTime\", \"[\", \"]\"}]\) gives the total number of seconds since the beginning of January 1, 1900, in your time zone.\n\!\(\*RowBox[{\"AbsoluteTime\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the absolute time specification corresponding to a date list. \n\!\(\*RowBox[{\"AbsoluteTime\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the absolute time specification corresponding to a date string.\n\!\(\*RowBox[{\"AbsoluteTime\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"}\"}], \"]\"}]\) takes the date string to contain the elements \"\!\(\*SubscriptBox[\nStyleBox[\"e\", \"TI\"], \nStyleBox[\"i\", \"TI\"]]\)\"."
AbsoluteTiming::usage = "\!\(\*RowBox[{\"AbsoluteTiming\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\), returning a list of the absolute number of seconds in real time that have elapsed, together with the result obtained. "
AccountingForm::usage = "\!\(\*RowBox[{\"AccountingForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints with all numbers in \!\(\*StyleBox[\"expr\", \"TI\"]\) given in standard accounting notation. \n\!\(\*RowBox[{\"AccountingForm\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) prints with numbers given to \!\(\*StyleBox[\"n\", \"TI\"]\)\[Hyphen]digit precision. "
Accumulate::usage = "\!\(\*RowBox[{\"Accumulate\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives a list of the successive accumulated totals of elements in \!\(\*StyleBox[\"list\", \"TI\"]\). "
AccuracyGoal::usage = "AccuracyGoal is an option for various numerical operations which specifies how many effective digits of accuracy should be sought in the final result. "
Accuracy::usage = "\!\(\*RowBox[{\"Accuracy\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives the effective number of digits to the right of the decimal point in the number \!\(\*StyleBox[\"x\", \"TI\"]\). "
ActionDelay::usage = "ActionDelay is an option for objects such as Tooltip that specifies how long to delay after the mouse is in position before taking action. "
ActionMenu::usage = "\!\(\*RowBox[{\"ActionMenu\", \"[\", RowBox[{StyleBox[\"name\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]], \":>\", SubscriptBox[StyleBox[\"act\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]], \":>\", SubscriptBox[StyleBox[\"act\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents an action menu with label \!\(\*StyleBox[\"name\", \"TI\"]\), and with items labeled \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"i\", \"TI\"]]\), that evaluates the expression \!\(\*SubscriptBox[StyleBox[\"act\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) if the corresponding item is chosen."
Active::usage = "Active is an option for ButtonBox, Cell and Notebook which specifies whether a button should be active. "
AddOnHelpPath::usage = "AddOnHelpPath is a global option that specifies which directories are searched for additional help files used within the help system."
AddTo::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"+=\", StyleBox[\"dx\", \"TI\"]}]\) adds \!\(\*StyleBox[\"dx\", \"TI\"]\) to \!\(\*StyleBox[\"x\", \"TI\"]\) and returns the new value of \!\(\*StyleBox[\"x\", \"TI\"]\). "
AdjustmentBox::usage = "\!\(\*RowBox[{AdjustmentBox, \"[\", RowBox[{StyleBox[\"box\", \"TI\"], \",\", StyleBox[\"opts\", \"TI\"]}], \"]\"}]\) is a low-level box construct which displays with the placement of \!\(\*StyleBox[\"box\", \"TI\"]\) adjusted using the options given. "
AffineTransform::usage = "\!\(\*RowBox[{\"AffineTransform\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives a TransformationFunction that represents an affine transform that maps \!\(\*StyleBox[\"r\", \"TI\"]\) to \!\(\*RowBox[{StyleBox[\"m\", \"TI\"], \".\", StyleBox[\"r\", \"TI\"]}]\). \n\!\(\*RowBox[{\"AffineTransform\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"}\"}], \"]\"}]\) gives an affine transform that maps \!\(\*StyleBox[\"r\", \"TI\"]\) to \!\(\*RowBox[{RowBox[{StyleBox[\"m\", \"TI\"], \".\", StyleBox[\"r\", \"TI\"]}], \"+\", StyleBox[\"v\", \"TI\"]}]\)."
AiryAi::usage = "\!\(\*RowBox[{\"AiryAi\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the Airy function \!\(\*RowBox[{\"Ai\", \"(\", \"z\", \")\"}]\). "
AiryAiPrime::usage = "\!\(\*RowBox[{\"AiryAiPrime\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the derivative of the Airy function \!\(\*RowBox[{SuperscriptBox[\"Ai\", \"\[Prime]\"], \"(\", \"z\", \")\"}]\). "
AiryAiZero::usage = "\!\(\*RowBox[{\"AiryAiZero\", \"[\", StyleBox[\"k\", \"TI\"], \"]\"}]\) represents the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) zero of the Airy function \!\(\*RowBox[{\"Ai\", \"(\", \"x\", \")\"}]\).\n\!\(\*RowBox[{\"AiryAiZero\", \"[\", RowBox[{StyleBox[\"k\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"]\"}]\) represents the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) zero less than \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]\)."
AiryBi::usage = "\!\(\*RowBox[{\"AiryBi\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the Airy function \!\(\*RowBox[{\"Bi\", \"(\", \"z\", \")\"}]\). "
AiryBiPrime::usage = "\!\(\*RowBox[{\"AiryBiPrime\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the derivative of the Airy function \!\(\*RowBox[{SuperscriptBox[\"Bi\", \"\[Prime]\"], \"(\", \"z\", \")\"}]\). "
AiryBiZero::usage = "\!\(\*RowBox[{\"AiryBiZero\", \"[\", StyleBox[\"k\", \"TI\"], \"]\"}]\) represents the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) zero of the Airy function \!\(\*RowBox[{\"Bi\", \"(\", \"x\", \")\"}]\).\n\!\(\*RowBox[{\"AiryBiZero\", \"[\", RowBox[{StyleBox[\"k\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"]\"}]\) represents the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) zero less than \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]\)."
AlgebraicIntegerQ::usage = "\!\(\*RowBox[{\"AlgebraicIntegerQ\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) yields True if \!\(\*StyleBox[\"a\", \"TI\"]\) is an algebraic integer, and yields False otherwise."
AlgebraicNumberDenominator::usage = "\!\(\*RowBox[{\"AlgebraicNumberDenominator\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) gives the smallest positive integer \!\(\*StyleBox[\"n\", \"TI\"]\) such that \!\(\*RowBox[{StyleBox[\"n\", \"TI\"], \" \", StyleBox[\"a\", \"TI\"]}]\) is an algebraic integer."
AlgebraicNumber::usage = "\!\(\*RowBox[{\"AlgebraicNumber\", \"[\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) represents the algebraic number in the field \!\(\*RowBox[{\"\[DoubleStruckCapitalQ]\", \"[\", \"\[Theta]\", \"]\"}]\) given by \!\(\*RowBox[{SubscriptBox[\"c\", \"0\"], \"+\", RowBox[{SubscriptBox[\"c\", \"1\"], \"\[Theta]\"}], \" \", \"+\", \"\[Ellipsis]\", \"+\", RowBox[{SubscriptBox[\"c\", \"n\"], \" \", SuperscriptBox[\"\[Theta]\", \"n\"]}]}]\)."
AlgebraicNumberNorm::usage = "\!\(\*RowBox[{\"AlgebraicNumberNorm\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) gives the norm of the algebraic number \!\(\*StyleBox[\"a\", \"TI\"]\)."
AlgebraicNumberPolynomial::usage = "\!\(\*RowBox[{\"AlgebraicNumberPolynomial\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the polynomial in \!\(\*StyleBox[\"x\", \"TI\"]\) corresponding to the AlgebraicNumber object \!\(\*StyleBox[\"a\", \"TI\"]\)."
AlgebraicNumberTrace::usage = "\!\(\*RowBox[{\"AlgebraicNumberTrace\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) gives the trace of the algebraic number \!\(\*StyleBox[\"a\", \"TI\"]\)."
AlgebraicRulesData::usage = "AlgebraicRulesData is an object returned by AlgebraicRules. Its OutputForm appears to be a list of rules, but the rules will be used algebraically rather than syntactically by Replace and related functions."
Algebraics::usage = "Algebraics represents the domain of algebraic numbers, as in \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], StyleBox[\"\[Element]\", \"TR\"], \"Algebraics\"}]\). "
AlgebraicUnitQ::usage = "\!\(\*RowBox[{\"AlgebraicUnitQ\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) yields True if \!\(\*StyleBox[\"a\", \"TI\"]\) is an algebraic unit, and yields False otherwise."
Alignment::usage = "Alignment is an option which specifies how the contents of a displayed object should be aligned within the available area in the object."
AlignmentPoint::usage = "AlignmentPoint is an option which specifies how objects should by default be aligned when they appear in Inset."
All::usage = "All is a setting used for certain options. In Part and related functions, All specifies all parts at a particular level. "
AllowInlineCells::usage = "AllowInlineCells is an option for cells that specifies whether inline cells are permitted within a cell."
AllowScriptLevelChange::usage = "AllowScriptLevelChange is an option for fractions and grids that controls whether certain operators, such as \[Sum], \[Product], and \[Integral], always appear smaller than normal size."
Alternatives::usage = "\!\(\*RowBox[{SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"|\", SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"|\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\) is a pattern object which represents any of the patterns \!\(\*SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
AmbientLight::usage = "AmbientLight is an option for Graphics3D and related functions that gives the level of simulated ambient illumination in a three\[Hyphen]dimensional picture. "
Analytic::usage = "Analytic is an option for Limit and Series. With \!\(\*RowBox[{\"Analytic\", \" \", \"->\", \" \", \"True\"}]\), unrecognized functions are treated as analytic, and processed using Taylor series expansions; with \!\(\*RowBox[{\"Analytic\", \" \", \"->\", \" \", \"False\"}]\), Taylor series are not used unless the function is recognized as analytic."
AnchoredSearch::usage = "AnchoredSearch is an option for Find and FindList which specifies whether the text searched for must be at the beginning of a record. "
And::usage = "\!\(\*RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"&&\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"&&\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\) is the logical AND function. It evaluates its arguments in order, giving False immediately if any of them are False, and True if they are all True. "
AngleBracket::usage = "\!\(\*RowBox[{\"AngleBracket\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"\[LeftAngleBracket]\", RowBox[{\"x\", \",\", \"y\", \",\", \"\[Ellipsis]\"}], \"\[RightAngleBracket]\"}]\)."
Animate::usage = "\!\(\*RowBox[{\"Animate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates an animation of \!\(\*StyleBox[\"expr\", \"TI\"]\) in which \!\(\*StyleBox[\"u\", \"TI\"]\) varies continuously from \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"Animate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"du\", \"TI\"]}], \"}\"}]}], \"]\"}]\) takes \!\(\*StyleBox[\"u\", \"TI\"]\) to vary in steps \!\(\*StyleBox[\"du\", \"TI\"]\). \n\!\(\*RowBox[{\"Animate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"}\"}]}], \"]\"}]\) makes \!\(\*StyleBox[\"u\", \"TI\"]\) take on discrete values \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \[Ellipsis]. \n\!\(\*RowBox[{\"Animate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) varies all the variables \!\(\*StyleBox[\"u\", \"TI\"]\), \!\(\*StyleBox[\"v\", \"TI\"]\), \[Ellipsis]. "
AnimationCycleOffset::usage = "AnimationCycleOffset is an option for cells that specifies the relative position of the next graphic to be used in an animation sequence."
AnimationCycleRepetitions::usage = "AnimationCycleRepetitions is an option for cells that specifies the number of times a given animation cycle should be repeated."
AnimationDirection::usage = "AnimationDirection is an option which specifies the direction to run an animation. "
AnimationDisplayTime::usage = "AnimationDisplayTime is an option for Cell which specifies the minimum time in seconds for which a cell should be displayed in the course of an animation that runs through a sequence of selected cells. "
AnimationRate::usage = "AnimationRate is an option for Animate and Animator that specifies at what rate an animation should run, in units per second. "
AnimationRepetitions::usage = "AnimationRepetitions is an option to Animate and related functions that specifies how many times the animation they create runs before stopping."
AnimationRunning::usage = "AnimationRunning is an option to Animate and related functions that specifies whether the animation they create is running."
Animator::usage = "\!\(\*RowBox[{\"Animator\", \"[\", StyleBox[\"u\", \"TI\"], \"]\"}]\) represents an object which displays with the value of \!\(\*StyleBox[\"u\", \"TI\"]\) being continually increased from 0 to 1 with time. \n\!\(\*RowBox[{\"Animator\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) makes \!\(\*StyleBox[\"u\", \"TI\"]\) vary from \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"Animator\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"du\", \"TI\"]}], \"}\"}]}], \"]\"}]\) makes \!\(\*StyleBox[\"u\", \"TI\"]\) vary in steps \!\(\*StyleBox[\"du\", \"TI\"]\). \n\!\(\*RowBox[{\"Animator\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"ups\", \"TI\"]}], \"]\"}]\) makes the value of \!\(\*StyleBox[\"u\", \"TI\"]\) increase at a rate of \!\(\*StyleBox[\"ups\", \"TI\"]\) units per second. "
Annotation::usage = "\!\(\*RowBox[{\"Annotation\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"]}], \"]\"}]\) represents an expression \!\(\*StyleBox[\"expr\", \"TI\"]\), with annotation \!\(\*StyleBox[\"data\", \"TI\"]\).\n\!\(\*RowBox[{\"Annotation\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"type\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) specifies the type of annotation being given."
Antialiasing::usage = "Antialiasing is a Style option which specifies whether antialiasing should be done in rendering 2D graphics. "
Apart::usage = "\!\(\*RowBox[{\"Apart\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) rewrites a rational expression as a sum of terms with minimal denominators. \n\!\(\*RowBox[{\"Apart\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"var\", \"TI\"]}], \"]\"}]\) treats all variables other than \!\(\*StyleBox[\"var\", \"TI\"]\) as constants. "
ApartSquareFree::usage = "\!\(\*RowBox[{\"ApartSquareFree\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) rewrites a rational expression as a sum of terms whose denominators have no multiple factors. \n\!\(\*RowBox[{\"ApartSquareFree\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"var\", \"TI\"]}], \"]\"}]\) treats all variables other than \!\(\*StyleBox[\"var\", \"TI\"]\) as constants. "
AppearanceElements::usage = "AppearanceElements is an option for functions like Manipulate that specifies what elements should be included in the displayed form of the object generated."
Appearance::usage = "Appearance is an option for displayed objects such as Button and Slider which specifies the general type of appearance they should have. "
AppellF1::usage = "\!\(\*RowBox[{\"AppellF1\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) is the Appell hypergeometric function of two variables \!\(\*RowBox[{SubscriptBox[\"F\", \"1\"], RowBox[{\"(\", RowBox[{\"a\", \";\", SubscriptBox[\"b\", \"1\"], \",\", SubscriptBox[\"b\", \"2\"], \";\", \"c\", \";\", \"x\", \",\", \"y\"}], \")\"}]}]\). "
Append::usage = "\!\(\*RowBox[{\"Append\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"elem\", \"TI\"]}], \"]\"}]\) gives \!\(\*StyleBox[\"expr\", \"TI\"]\) with \!\(\*StyleBox[\"elem\", \"TI\"]\) appended. "
AppendTo::usage = "\!\(\*RowBox[{\"AppendTo\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"elem\", \"TI\"]}], \"]\"}]\) appends \!\(\*StyleBox[\"elem\", \"TI\"]\) to the value of \!\(\*StyleBox[\"s\", \"TI\"]\), and resets \!\(\*StyleBox[\"s\", \"TI\"]\) to the result. "
Apply::usage = "\!\(\*RowBox[{\"Apply\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) or \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"@@\", StyleBox[\"expr\", \"TI\"]}]\) replaces the head of \!\(\*StyleBox[\"expr\", \"TI\"]\) by \!\(\*StyleBox[\"f\", \"TI\"]\). \n\!\(\*RowBox[{\"Apply\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"]}], \"]\"}]\) replaces heads in parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) specified by \!\(\*StyleBox[\"levelspec\", \"TI\"]\). "
ArcCosh::usage = "\!\(\*RowBox[{\"ArcCosh\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the inverse hyperbolic cosine \!\(\*RowBox[{SuperscriptBox[\"cosh\", RowBox[{\"-\", \"1\"}]], \"(\", \"z\", \")\"}]\) of the complex number z. "
ArcCos::usage = "\!\(\*RowBox[{\"ArcCos\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the arc cosine \!\(\*RowBox[{SuperscriptBox[\"cos\", RowBox[{\"-\", \"1\"}]], \"(\", \"z\", \")\"}]\) of the complex number z. "
ArcCoth::usage = "\!\(\*RowBox[{\"ArcCoth\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the inverse hyperbolic cotangent \!\(\*RowBox[{SuperscriptBox[\"coth\", RowBox[{\"-\", \"1\"}]], \"(\", \"z\", \")\"}]\) of the complex number z. "
ArcCot::usage = "\!\(\*RowBox[{\"ArcCot\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the arc cotangent \!\(\*RowBox[{SuperscriptBox[\"cot\", RowBox[{\"-\", \"1\"}]], \"(\", \"z\", \")\"}]\) of the complex number z. "
ArcCsch::usage = "\!\(\*RowBox[{\"ArcCsch\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the inverse hyperbolic cosecant \!\(\*RowBox[{SuperscriptBox[\"csch\", RowBox[{\"-\", \"1\"}]], \"(\", \"z\", \")\"}]\) of the complex number z. "
ArcCsc::usage = "\!\(\*RowBox[{\"ArcCsc\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the arc cosecant \!\(\*RowBox[{SuperscriptBox[\"csc\", RowBox[{\"-\", \"1\"}]], \"(\", \"z\", \")\"}]\) of the complex number z. "
ArcSech::usage = "\!\(\*RowBox[{\"ArcSech\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the inverse hyperbolic secant \!\(\*RowBox[{SuperscriptBox[\"sech\", RowBox[{\"-\", \"1\"}]], \"(\", \"z\", \")\"}]\) of the complex number z. "
ArcSec::usage = "\!\(\*RowBox[{\"ArcSec\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the arc secant \!\(\*RowBox[{SuperscriptBox[\"sec\", RowBox[{\"-\", \"1\"}]], \"(\", \"z\", \")\"}]\) of the complex number z. "
ArcSinh::usage = "\!\(\*RowBox[{\"ArcSinh\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the inverse hyperbolic sine \!\(\*RowBox[{SuperscriptBox[\"sinh\", RowBox[{\"-\", \"1\"}]], \"(\", \"z\", \")\"}]\) of the complex number z. "
ArcSin::usage = "\!\(\*RowBox[{\"ArcSin\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the arc sine \!\(\*RowBox[{SuperscriptBox[\"sin\", RowBox[{\"-\", \"1\"}]], \"(\", \"z\", \")\"}]\) of the complex number z. "
ArcTanh::usage = "\!\(\*RowBox[{\"ArcTanh\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the hyperbolic arc tangent \!\(\*RowBox[{SuperscriptBox[\"tanh\", RowBox[{\"-\", \"1\"}]], \"(\", \"z\", \")\"}]\) of the complex number z. "
ArcTan::usage = "\!\(\*RowBox[{\"ArcTan\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the arc tangent \!\(\*RowBox[{SuperscriptBox[\"tan\", RowBox[{\"-\", \"1\"}]], \"(\", \"z\", \")\"}]\) of the complex number z. \n\!\(\*RowBox[{\"ArcTan\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) gives the arc tangent of \!\(\*FractionBox[\"y\", \"x\"]\), taking into account which quadrant the point \!\(\*RowBox[{\"(\", RowBox[{\"x\", \",\", \"y\"}], \")\"}]\) is in. "
Arg::usage = "\!\(\*RowBox[{\"Arg\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the argument of the complex number z. "
ArgumentCountQ::usage = "\!\(\*RowBox[{\"ArgumentCountQ\", \"[\", RowBox[{StyleBox[\"head\", \"TI\"], \",\", \" \", StyleBox[\"len\", \"TI\"], \",\", \" \", StyleBox[\"min\", \"TI\"], \",\", \" \", StyleBox[\"max\", \"TI\"]}], \"]\"}]\) tests whether the number \!\(\*StyleBox[\"len\", \"TI\"]\) of arguments of a function \!\(\*StyleBox[\"head\", \"TI\"]\) is between \!\(\*StyleBox[\"min\", \"TI\"]\) and \!\(\*StyleBox[\"max\", \"TI\"]\)."
ArithmeticGeometricMean::usage = "\!\(\*RowBox[{\"ArithmeticGeometricMean\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives the arithmetic\[Hyphen]geometric mean of \!\(\*StyleBox[\"a\", \"TI\"]\) and \!\(\*StyleBox[\"b\", \"TI\"]\). "
ArrayDepth::usage = "\!\(\*RowBox[{\"ArrayDepth\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the depth to which \!\(\*StyleBox[\"expr\", \"TI\"]\) is a full array, with all the parts at a particular level being lists of the same length, or is a SparseArray object. "
ArrayFlatten::usage = "\!\(\*RowBox[{\"ArrayFlatten\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"21\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"22\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) creates a single flattened matrix from a matrix of matrices \!\(\*SubscriptBox[\"m\", RowBox[{\"i\", \"\[InvisibleSpace]\", \"j\"}]]\). \n\!\(\*RowBox[{\"ArrayFlatten\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) flattens out r pairs of levels in the array a."
Array::usage = "\!\(\*RowBox[{\"Array\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) generates a list of length \!\(\*StyleBox[\"n\", \"TI\"]\), with elements \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"i\", \"TI\"], \"]\"}]\). \n\!\(\*RowBox[{\"Array\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) generates an \!\(\*RowBox[{SubscriptBox[\"n\", \"1\"], \"\[Cross]\", SubscriptBox[\"n\", \"2\"], \"\[Cross]\", \"...\"}]\) array of nested lists, with elements \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\). \n\!\(\*RowBox[{\"Array\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) generates a list using the index origins \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) (default 1). \n\!\(\*RowBox[{\"Array\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"dims\", \"TI\"], \",\", StyleBox[\"origin\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) uses head \!\(\*StyleBox[\"h\", \"TI\"]\), rather than List, for each level of the array. "
ArrayPlot::usage = "\!\(\*RowBox[{\"ArrayPlot\", \"[\", StyleBox[\"array\", \"TI\"], \"]\"}]\) generates a plot in which the values in an array are shown in a discrete array of squares. "
ArrayQ::usage = "\!\(\*RowBox[{\"ArrayQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a full array or a SparseArray object, and gives False otherwise. \n\!\(\*RowBox[{\"ArrayQ\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"patt\", \"TI\"]}], \"]\"}]\) requires \!\(\*StyleBox[\"expr\", \"TI\"]\) to be a full array with a depth that matches the pattern \!\(\*StyleBox[\"patt\", \"TI\"]\). \n\!\(\*RowBox[{\"ArrayQ\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"patt\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"]}], \"]\"}]\) requires also that \!\(\*StyleBox[\"test\", \"TI\"]\) yield True when applied to each of the array elements in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
ArrayRules::usage = "\!\(\*RowBox[{\"ArrayRules\", \"[\", RowBox[{\"SparseArray\", \"[\", StyleBox[\"\[Ellipsis]\", \"TR\"], \"]\"}], \"]\"}]\) gives the rules \!\(\*RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\) specifying elements in a sparse array. \n\!\(\*RowBox[{\"ArrayRules\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives rules for \!\(\*RowBox[{\"SparseArray\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\). "
Arrowheads::usage = "\!\(\*RowBox[{\"Arrowheads\", \"[\", StyleBox[\"spec\", \"TI\"], \"]\"}]\) is a graphics directive which specifies that arrows which follow should have arrowheads with sizes, positions and forms specified by \!\(\*StyleBox[\"spec\", \"TI\"]\). "
Arrow::usage = "\!\(\*RowBox[{\"Arrow\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"}\"}], \"]\"}]\) is a graphics primitive which represents an arrow from \!\(\*RowBox[{\"(\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \")\"}]\) to \!\(\*RowBox[{\"(\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \")\"}]\). \n\!\(\*RowBox[{\"Arrow\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) represents an arrow with its ends set back from \!\(\*SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) by a distance \!\(\*StyleBox[\"s\", \"TI\"]\). \n\!\(\*RowBox[{\"Arrow\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) sets back by \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) from \!\(\*SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) from \!\(\*SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]]\). "
AspectRatioFixed::usage = "AspectRatioFixed is an option for Cell which specifies whether graphics in the cell should be constrained to stay the same shape when they are interactively resized using the front end. "
AspectRatio::usage = "AspectRatio is an option for Graphics and related functions which specifies the ratio of height to width for a plot. "
Assuming::usage = "\!\(\*RowBox[{\"Assuming\", \"[\", RowBox[{StyleBox[\"assum\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\) with \!\(\*StyleBox[\"assum\", \"TI\"]\) appended to $Assumptions, so that \!\(\*StyleBox[\"assum\", \"TI\"]\) is included in the default assumptions used by functions such as Refine, Simplify and Integrate. "
Assumptions::usage = "Assumptions is an option for functions such as Simplify, Refine and Integrate which specifies default assumptions to be made about symbolic quantities. "
AstronomicalData::usage = "\!\(\*RowBox[{\"AstronomicalData\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", \" \", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the value of the specified property of the astronomical object with the specified name."
AtomQ::usage = "\!\(\*RowBox[{\"AtomQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) yields True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is an expression which cannot be divided into subexpressions, and yields False otherwise. "
Attributes::usage = "\!\(\*RowBox[{\"Attributes\", \"[\", StyleBox[\"symbol\", \"TI\"], \"]\"}]\) gives the list of attributes for a symbol. "
AutoAction::usage = "AutoAction is an option for objects such as Slider, Locator and Button that specifies whether they should automatically take action whenever the mouse pointer is over them, even if they are not clicked. "
AutoDelete::usage = "AutoDelete is an option for boxes that specifies whether a box is automatically deleted when its contents are edited."
AutoGeneratedPackage::usage = "AutoGeneratedPackage is an option for notebooks that specifies whether a package is automatically created when a notebook that contains initialization cells is saved."
AutoIndent::usage = "AutoIndent is an option for Style and Cell which specifies what automatic indentation should be done at the beginning of a new line after an explicit return character has been entered. "
AutoItalicWords::usage = "AutoItalicWords is an option for Cell which gives a list of words which should automatically be put in italics when they are entered. "
AutoloadPath::usage = "AutoloadPath is a global option that specifies from which directories packages are automatically loaded when \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) is started."
Automatic::usage = "Automatic represents an option or other value that is to be chosen automatically by a built\[Hyphen]in function. "
AutoMultiplicationSymbol::usage = "AutoMultiplicationSymbol is an option for objects such as Cell and Notebook which specifies whether to automatically display a multiplication symbol between numbers which would be multiplied if evaluated."
AutoOpenNotebooks::usage = "AutoOpenNotebooks is a global option that specifies which notebooks should be automatically opened when \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) is started."
AutoOpenPalettes::usage = "AutoOpenPalettes is a global option that specifies the palettes that are automatically opened when \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) is started."
AutorunSequencing::usage = "AutorunSequencing is an option for Manipulate that specifies how autorun should use the controls provided."
AutoScroll::usage = "AutoScroll is an option to SelectionMove and related functions that specifies whether a notebook should automatically be scrolled to display the current selection."
AutoSpacing::usage = "AutoSpacing is an option for Style and Cell which specifies whether spaces between successive characters should be adjusted automatically. "
AxesEdge::usage = "AxesEdge is an option for three\[Hyphen]dimensional graphics functions that specifies on which edges of the bounding box axes should be drawn. "
AxesLabel::usage = "AxesLabel is an option for graphics functions that specifies labels for axes. "
Axes::usage = "Axes is an option for graphics functions that specifies whether axes should be drawn. "
AxesOrigin::usage = "AxesOrigin is an option for two\[Hyphen]dimensional graphics functions which specifies where any axes drawn should cross. "
AxesStyle::usage = "AxesStyle is an option for graphics functions which specifies how axes should be rendered. "
Axis::usage = "Axis is a symbol that represents the axis for purposes of alignment and positioning. "
Background::usage = "Background is an option which specifies what background color to use. "
Backslash::usage = "\!\(\*RowBox[{\"Backslash\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Backslash]\", \"y\", \"\[Backslash]\", \"\[Ellipsis]\"}]\)."
Backward::usage = "Backward is a symbol that represents the backward direction for purposes of motion and animation."
Band::usage = "\!\(\*RowBox[{\"Band\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"]}], \"}\"}], \"]\"}]\) represents the sequence of positions on the diagonal band that starts with \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"]}], \"}\"}]\) in a sparse array.\n\!\(\*RowBox[{\"Band\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents the positions between \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\) and \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\).\n\!\(\*RowBox[{\"Band\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"di\", \"TI\"], \",\", StyleBox[\"dj\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents positions starting with \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\) and then moving with step \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"di\", \"TI\"], \",\", StyleBox[\"dj\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\)."
BaseForm::usage = "\!\(\*RowBox[{\"BaseForm\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) prints with the numbers in \!\(\*StyleBox[\"expr\", \"TI\"]\) given in base \!\(\*StyleBox[\"n\", \"TI\"]\). "
Baseline::usage = "Baseline is a symbol that represents the baseline for purposes of alignment and positioning. "
BaselinePosition::usage = "BaselinePosition is an option which specifies where the baseline of an object is considered to be for purposes of alignment with surrounding text or other expressions. "
BaseStyle::usage = "BaseStyle is an option for formatting and related constructs that specifies the base style to use for them. "
Because::usage = "\!\(\*RowBox[{\"Because\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Because]\", \"y\"}]\)."
Beep::usage = "\!\(\*RowBox[{\"Beep\", \"[\", \"]\"}]\) generates an audible beep when evaluated. "
BeginDialogPacket::usage = "\!\(\*RowBox[{\"BeginDialogPacket\", \"[\", StyleBox[\"integer\", \"TI\"], \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet that indicates the start of the Dialog subsession referenced by \!\(\*StyleBox[\"integer\", \"TI\"]\)."
Begin::usage = "\!\(\*RowBox[{\"Begin\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"context\\\",\\\"TI\\\"]\\)`\\\"\", ShowStringCharacters->True], \"]\"}]\) resets the current context. "
BeginPackage::usage = "\!\(\*RowBox[{\"BeginPackage\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"context\\\",\\\"TI\\\"]\\)`\\\"\", ShowStringCharacters->True], \"]\"}]\) makes \!\(\*StyleBox[RowBox[{StyleBox[\"context\", \"TI\"], \"`\"}]]\) and System` the only active contexts. \n\!\(\*RowBox[{\"BeginPackage\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"context\\\",\\\"TI\\\"]\\)`\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"need\\\",\\\"TI\\\"]\\_StyleBox[1, TR]\\)`\\\"\",ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"need\\\",\\\"TI\\\"]\\_StyleBox[2, TR]\\)`\\\"\",ShowStringCharacters->True], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) calls Needs on the \!\(\*SubscriptBox[StyleBox[\"need\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
BellB::usage = "\!\(\*RowBox[{\"BellB\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the Bell number \!\(\*SubscriptBox[\"B\", \"n\"]\). \n\!\(\*RowBox[{\"BellB\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the Bell polynomial \!\(\*RowBox[{SubscriptBox[\"B\", \"n\"], \"(\", \"x\", \")\"}]\). "
Below::usage = "Below is used to specify alignment in printforms such as ColumnForm and TableForm."
BernoulliB::usage = "\!\(\*RowBox[{\"BernoulliB\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the Bernoulli number \!\(\*SubscriptBox[\"B\", \"n\"]\). \n\!\(\*RowBox[{\"BernoulliB\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the Bernoulli polynomial \!\(\*RowBox[{SubscriptBox[\"B\", \"n\"], \"(\", \"x\", \")\"}]\). "
BernoulliDistribution::usage = "\!\(\*RowBox[{\"BernoulliDistribution\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) represents a Bernoulli distribution with probability parameter \!\(\*StyleBox[\"p\", \"TI\"]\)."
BesselI::usage = "\!\(\*RowBox[{\"BesselI\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the modified Bessel function of the first kind \!\(\*RowBox[{SubscriptBox[\"I\", \"n\"], \"(\", \"z\", \")\"}]\). "
BesselJ::usage = "\!\(\*RowBox[{\"BesselJ\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the Bessel function of the first kind \!\(\*RowBox[{SubscriptBox[\"J\", \"n\"], \"(\", \"z\", \")\"}]\). "
BesselJZero::usage = "\!\(\*RowBox[{\"BesselJZero\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) represents the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) zero of the Bessel function \!\(\*RowBox[{SubscriptBox[\"J\", \"n\"], \"(\", \"x\", \")\"}]\).\n\!\(\*RowBox[{\"BesselJZero\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"]\"}]\) represents the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) zero greater than \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]\)."
BesselK::usage = "\!\(\*RowBox[{\"BesselK\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the modified Bessel function of the second kind \!\(\*RowBox[{SubscriptBox[\"K\", \"n\"], \"(\", \"z\", \")\"}]\). "
BesselY::usage = "\!\(\*RowBox[{\"BesselY\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the Bessel function of the second kind \!\(\*RowBox[{SubscriptBox[\"Y\", \"n\"], \"(\", \"z\", \")\"}]\). "
BesselYZero::usage = "\!\(\*RowBox[{\"BesselYZero\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) represents the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) zero of the Bessel function of the second kind \!\(\*RowBox[{SubscriptBox[\"Y\", \"n\"], \"(\", \"x\", \")\"}]\).\n\!\(\*RowBox[{\"BesselYZero\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"]\"}]\) represents the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) zero greater than \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]\)."
BetaBinomialDistribution::usage = "\!\(\*RowBox[{\"BetaBinomialDistribution\", \"[\", RowBox[{StyleBox[\"\[Alpha]\", \"TR\"], \",\", StyleBox[\"\[Beta]\", \"TR\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) represents a beta binomial mixture distribution with beta distribution parameters \[Alpha] and \[Beta], and n binomial trials."
BetaDistribution::usage = "\!\(\*RowBox[{\"BetaDistribution\", \"[\", RowBox[{StyleBox[\"\[Alpha]\", \"TR\"], \",\", StyleBox[\"\[Beta]\", \"TR\"]}], \"]\"}]\) represents a continuous beta distribution with shape parameters \!\(\*StyleBox[\"\[Alpha]\", \"TR\"]\) and \!\(\*StyleBox[\"\[Beta]\", \"TR\"]\)."
Beta::usage = "\!\(\*RowBox[{\"Beta\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives the Euler beta function \!\(\*RowBox[{\"\[CapitalBeta]\", \"(\", RowBox[{\"a\", \",\", \"b\"}], \")\"}]\). \n\!\(\*RowBox[{\"Beta\", \"[\", RowBox[{StyleBox[\"z\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives the incomplete beta function \!\(\*RowBox[{SubscriptBox[\"\[CapitalBeta]\", \"z\"], \"(\", RowBox[{\"a\", \",\", \"b\"}], \")\"}]\). "
BetaNegativeBinomialDistribution::usage = "\!\(\*RowBox[{\"BetaNegativeBinomialDistribution\", \"[\", RowBox[{StyleBox[\"\[Alpha]\", \"TR\"], \",\", StyleBox[\"\[Beta]\", \"TR\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) represents a beta negative binomial mixture distribution with beta distribution parameters \[Alpha] and \[Beta], and n successful trials."
BetaRegularized::usage = "\!\(\*RowBox[{\"BetaRegularized\", \"[\", RowBox[{StyleBox[\"z\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives the regularized incomplete beta function \!\(\*RowBox[{SubscriptBox[\"I\", \"z\"], \"(\", RowBox[{\"a\", \",\", \"b\"}], \")\"}]\). "
BinaryFormat::usage = "BinaryFormat is an option for OpenRead and related functions which specifies that a stream should be opened in binary format, so that no textual interpretation of newlines or other data is done."
BinaryReadList::usage = "\!\(\*RowBox[{\"BinaryReadList\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) reads all remaining bytes from a file, and returns them as a list of integers from 0 to 255. \n\!\(\*RowBox[{\"BinaryReadList\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"type\", \"TI\"]}], \"]\"}]\) reads objects of the specified type from a file, until the end of the file is reached. The list of objects read is returned. \n\!\(\*RowBox[{\"BinaryReadList\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"type\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"type\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) reads objects with a sequence of types, until the end of the file is reached. \n\!\(\*RowBox[{\"BinaryReadList\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"types\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) reads only the first \!\(\*StyleBox[\"n\", \"TI\"]\) objects of the specified types. "
BinaryRead::usage = "\!\(\*RowBox[{\"BinaryRead\", \"[\", StyleBox[\"stream\", \"TI\"], \"]\"}]\) reads one byte of raw binary data from an input stream, and returns an integer from 0 to 255. \n\!\(\*RowBox[{\"BinaryRead\", \"[\", RowBox[{StyleBox[\"stream\", \"TI\"], \",\", StyleBox[\"type\", \"TI\"]}], \"]\"}]\) reads an object of the specified type. \n\!\(\*RowBox[{\"BinaryRead\", \"[\", RowBox[{StyleBox[\"stream\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"type\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"type\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) reads a sequence of objects of the specified types. "
BinaryWrite::usage = "\!\(\*RowBox[{\"BinaryWrite\", \"[\", RowBox[{StyleBox[\"channel\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) writes a byte of data, specified as an integer from 0 to 255. \n\!\(\*RowBox[{\"BinaryWrite\", \"[\", RowBox[{StyleBox[\"channel\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) writes a sequence of bytes. \n\!\(\*RowBox[{\"BinaryWrite\", \"[\", RowBox[{StyleBox[\"channel\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) writes the raw sequence of characters in a string. \n\!\(\*RowBox[{\"BinaryWrite\", \"[\", RowBox[{StyleBox[\"channel\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"type\", \"TI\"]}], \"]\"}]\) writes an object of the specified type. \n\!\(\*RowBox[{\"BinaryWrite\", \"[\", RowBox[{StyleBox[\"channel\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"type\", \"TI\"]}], \"]\"}]\) writes a sequence of objects of the specified type. \n\!\(\*RowBox[{\"BinaryWrite\", \"[\", RowBox[{StyleBox[\"channel\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"type\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"type\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) writes a sequence of objects with a sequence of types. "
BinCounts::usage = "\!\(\*RowBox[{\"BinCounts\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) counts the number of elements \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) whose values lie in successive integer bins.\n\!\(\*RowBox[{\"BinCounts\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"dx\", \"TI\"]}], \"]\"}]\) counts the number of elements \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) whose values lie in successive bins of width \!\(\*StyleBox[\"dx\", \"TI\"]\).\n\!\(\*RowBox[{\"BinCounts\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"dx\", \"TI\"]}], \"}\"}]}], \"]\"}]\) counts the number of \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) in successive bins of width \!\(\*StyleBox[\"dx\", \"TI\"]\) from \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"BinCounts\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"}\"}]}], \"]\"}]\) counts the number of \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) in the intervals \!\(\*RowBox[{\"(\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \")\"}]\), \!\(\*RowBox[{\"(\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"3\", \"TR\"]]}], \")\"}]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\). \n\!\(\*RowBox[{\"BinCounts\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"xbins\", \"TI\"], \",\", StyleBox[\"ybins\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives an array of counts where the first index corresponds to \!\(\*StyleBox[\"x\", \"TI\"]\) bins, the second to \!\(\*StyleBox[\"y\", \"TI\"]\), and so on. "
BinLists::usage = "\!\(\*RowBox[{\"BinLists\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives lists of the elements \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) whose values lie in successive integer bins.\n\!\(\*RowBox[{\"BinLists\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"dx\", \"TI\"]}], \"]\"}]\) gives lists of the elements \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) whose values lie in successive bins of width \!\(\*StyleBox[\"dx\", \"TI\"]\).\n\!\(\*RowBox[{\"BinLists\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"dx\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives lists of the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) that lie in successive bins of width \!\(\*StyleBox[\"dx\", \"TI\"]\) from \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"BinLists\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"}\"}]}], \"]\"}]\) gives lists of the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) that lie in the intervals \!\(\*RowBox[{\"(\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \")\"}]\), \!\(\*RowBox[{\"(\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"3\", \"TR\"]]}], \")\"}]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\). \n\!\(\*RowBox[{\"BinLists\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"xbins\", \"TI\"], \",\", StyleBox[\"ybins\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives an array of lists where the first index corresponds to \!\(\*StyleBox[\"x\", \"TI\"]\) bins, the second to \!\(\*StyleBox[\"y\", \"TI\"]\), and so on. "
BinomialDistribution::usage = "\!\(\*RowBox[{\"BinomialDistribution\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) represents a binomial distribution with \!\(\*StyleBox[\"n\", \"TI\"]\) trials and success probability \!\(\*StyleBox[\"p\", \"TI\"]\)."
Binomial::usage = "\!\(\*RowBox[{\"Binomial\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the binomial coefficient \!\(\*RowBox[{\"(\", GridBox[{{\"n\"}, {\"m\"}}], \")\"}]\). "
BitAnd::usage = "\!\(\*RowBox[{\"BitAnd\", \"[\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the bitwise AND of the integers \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
BitClear::usage = "\!\(\*RowBox[{\"BitClear\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) sets to 0 the bit corresponding to the coefficient of \!\(\*SuperscriptBox[\"2\", \"k\"]\) in the integer \!\(\*StyleBox[\"n\", \"TI\"]\). "
BitGet::usage = "\!\(\*RowBox[{\"BitGet\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gets the bit corresponding to the coefficient of \!\(\*SuperscriptBox[\"2\", \"k\"]\) in the integer \!\(\*StyleBox[\"n\", \"TI\"]\). "
BitLength::usage = "\!\(\*RowBox[{\"BitLength\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the number of binary bits necessary to represent the integer \!\(\*StyleBox[\"n\", \"TI\"]\). "
BitNot::usage = "\!\(\*RowBox[{\"BitNot\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the bitwise NOT of the integer \!\(\*StyleBox[\"n\", \"TI\"]\). "
BitOr::usage = "\!\(\*RowBox[{\"BitOr\", \"[\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the bitwise OR of the integers \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
BitSet::usage = "\!\(\*RowBox[{\"BitSet\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) sets to 1 the bit corresponding to the coefficient of \!\(\*SuperscriptBox[\"2\", \"k\"]\) in the integer \!\(\*StyleBox[\"n\", \"TI\"]\). "
BitShiftLeft::usage = "\!\(\*RowBox[{\"BitShiftLeft\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) shifts the binary bits in the integer \!\(\*StyleBox[\"n\", \"TI\"]\) to the left by \!\(\*StyleBox[\"k\", \"TI\"]\) places, padding with zeros on the right. "
BitShiftRight::usage = "\!\(\*RowBox[{\"BitShiftRight\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) shifts the binary bits in the integer \!\(\*StyleBox[\"n\", \"TI\"]\) to the right by \!\(\*StyleBox[\"k\", \"TI\"]\) places, dropping bits that are shifted past the unit's position on the right. \n\!\(\*RowBox[{\"BitShiftRight\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) shifts one bit to the right."
BitXor::usage = "\!\(\*RowBox[{\"BitXor\", \"[\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the bitwise XOR of the integers \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
Black::usage = "Black represents the color black in graphics or style specifications. "
BlankForm::usage = "BlankForm is an internal symbol used for formatting and printing."
Blank::usage = "_ or \!\(\*RowBox[{\"Blank\", \"[\", \"]\"}]\) is a pattern object that can stand for any \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) expression. \n\!\(\*StyleBox[RowBox[{\"_\", StyleBox[\"h\", \"TI\"]}]]\) or \!\(\*RowBox[{\"Blank\", \"[\", StyleBox[\"h\", \"TI\"], \"]\"}]\) can stand for any expression with head \!\(\*StyleBox[\"h\", \"TI\"]\). "
BlankNullSequence::usage = "___ (three _ characters) or \!\(\*RowBox[{\"BlankNullSequence\", \"[\", \"]\"}]\) is a pattern object that can stand for any sequence of zero or more \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) expressions. \n\!\(\*StyleBox[RowBox[{\"___\", StyleBox[\"h\", \"TI\"]}]]\) or \!\(\*RowBox[{\"BlankNullSequence\", \"[\", StyleBox[\"h\", \"TI\"], \"]\"}]\) can stand for any sequence of expressions, all of which have head \!\(\*StyleBox[\"h\", \"TI\"]\). "
BlankSequence::usage = "__ (two _ characters) or \!\(\*RowBox[{\"BlankSequence\", \"[\", \"]\"}]\) is a pattern object that can stand for any sequence of one or more \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) expressions. \n\!\(\*StyleBox[RowBox[{\"__\", StyleBox[\"h\", \"TI\"]}]]\) or \!\(\*RowBox[{\"BlankSequence\", \"[\", StyleBox[\"h\", \"TI\"], \"]\"}]\) can stand for any sequence of one or more expressions, all of which have head \!\(\*StyleBox[\"h\", \"TI\"]\). "
Blend::usage = "\!\(\*RowBox[{\"Blend\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives a color obtained by blending a fraction \!\(\*RowBox[{\"1\", \"-\", \"x\"}]\) of color \!\(\*SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*StyleBox[\"x\", \"TI\"]\) of color \!\(\*SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"2\", \"TR\"]]\).\n\!\(\*RowBox[{\"Blend\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"3\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) linearly interpolates between colors \!\(\*SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) as \!\(\*StyleBox[\"x\", \"TI\"]\) varies from 0 to 1.\n\!\(\*RowBox[{\"Blend\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) interpolates to give \!\(\*SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) when \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]}]\).\n\!\(\*RowBox[{\"Blend\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) blends all the \!\(\*SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"i\", \"TI\"]]\), using fraction \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) of color \!\(\*SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Blend\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) blends equal fractions of all the \!\(\*SubscriptBox[StyleBox[\"col\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
Block::usage = "\!\(\*RowBox[{\"Block\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) specifies that \!\(\*StyleBox[\"expr\", \"TI\"]\) is to be evaluated with local values for the symbols \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"y\", \"TI\"]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\) . \n\!\(\*RowBox[{\"Block\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{StyleBox[\"x\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) defines initial local values for \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\) . "
BlockRandom::usage = "\!\(\*RowBox[{\"BlockRandom\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\) with all pseudorandom generators localized, so that uses of SeedRandom, RandomInteger and related functions within the evaluation of \!\(\*StyleBox[\"expr\", \"TI\"]\) do not affect subsequent pseudorandom sequences."
Blue::usage = "Blue represents the color blue in graphics or style specifications. "
Bold::usage = "Bold represents a bold font weight."
Booleans::usage = "Booleans represents the domain of Booleans, as in \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], StyleBox[\"\[Element]\", \"TR\"], \"Booleans\"}]\). "
Boole::usage = "\!\(\*RowBox[{\"Boole\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) yields 1 if \!\(\*StyleBox[\"expr\", \"TI\"]\) is True and 0 if it is False. "
Bottom::usage = "Bottom is a symbol that represents the bottom for purposes of alignment and positioning. "
BoundaryStyle::usage = "BoundaryStyle is an option for plotting functions that specifies the style in which boundaries of regions should be drawn. "
BoxBaselineShift::usage = "BoxBaselineShift is an option for AdjustmentBox that specifies how much the baseline of the box should be shifted relative to those of neighboring characters."
Boxed::usage = "Boxed is an option for Graphics3D which specifies whether to draw the edges of the bounding box in a three\[Hyphen]dimensional picture. "
BoxFormFormatTypes::usage = "BoxFormFormatTypes is a global option that specifies the list of typeset format types that are currently defined."
BoxFrame::usage = "BoxFrame is an option for FrameBox objects that specifies whether to draw a frame around the contents of the box."
BoxMargins::usage = "BoxMargins is an option for AdjustmentBox objects that specifies the margins to leave around the contents of the box."
BoxRatios::usage = "BoxRatios is an option for Graphics3D which gives the ratios of side lengths for the bounding box of the three\[Hyphen]dimensional picture. "
BoxStyle::usage = "BoxStyle is an option for three\[Hyphen]dimensional graphics functions which specifies how the bounding box should be rendered. "
BracketingBar::usage = "\!\(\*RowBox[{\"BracketingBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", \" \", StyleBox[\"y\", \"TI\"], \",\", \" \", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"\[LeftBracketingBar]\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"\[RightBracketingBar]\"}]\)."
BrayCurtisDistance::usage = "\!\(\*RowBox[{\"BrayCurtisDistance\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the Bray\[Hyphen]Curtis distance between vectors u and v."
Break::usage = "\!\(\*RowBox[{\"Break\", \"[\", \"]\"}]\) exits the nearest enclosing Do, For or While. "
Brown::usage = "Brown represents the color brown in graphics or style specifications. "
ButtonBox::usage = "\!\(\*RowBox[{ButtonBox, \"[\", StyleBox[\"boxes\", \"TI\"], \"]\"}]\) is a low-level box construct that represents a button in a notebook expression."
ButtonBoxOptions::usage = "\!\(\*RowBox[{ButtonBoxOptions, \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for cells that specifies settings for buttons within the cell."
ButtonData::usage = "ButtonData is an option for the low-level function ButtonBox which specifies the second argument to give to the ButtonFunction for the button when the button is active and is clicked. "
ButtonEvaluator::usage = "ButtonEvaluator is an option for the low-level function ButtonBox which specifies where the expression constructed from ButtonFunction should be sent for evaluation. "
ButtonExpandable::usage = "ButtonExpandable is an option for the low-level function ButtonBox which specifies whether the button should expand to fill any GridBox position in which it appears. "
ButtonFrame::usage = "ButtonFrame is an option for the low-level function ButtonBox which specifies the type of frame to display around a button. "
ButtonFunction::usage = "ButtonFunction is an option for the low-level function ButtonBox which specifies the function to execute when the button is active and is clicked. "
ButtonMargins::usage = "ButtonMargins is an option for ButtonBox which specifies how much space in printer\[CloseCurlyQuote]s points to leave around the contents of a button when the button is displayed. "
ButtonMinHeight::usage = "ButtonMinHeight is an option for the low-level function ButtonBox which specifies the minimum total height in units of font size that should be allowed for the button. "
Button::usage = "\!\(\*RowBox[{\"Button\", \"[\", RowBox[{StyleBox[\"label\", \"TI\"], \",\", StyleBox[\"action\", \"TI\"]}], \"]\"}]\) represents a button that is labeled with \!\(\*StyleBox[\"label\", \"TI\"]\), and evaluates \!\(\*StyleBox[\"action\", \"TI\"]\) whenever it is pressed. "
ButtonNotebook::usage = "\!\(\*RowBox[{\"ButtonNotebook\", \"[\", \"]\"}]\) gives the notebook, if any, that contains the button which initiated the current evaluation. "
ButtonNote::usage = "ButtonNote is an option for ButtonBox which specifies what should be displayed in the status line of the current notebook window when the button is active and the cursor is placed on top of it. "
ButtonSource::usage = "ButtonSource is an option for the low-level function ButtonBox which specifies the first argument to give to the ButtonFunction for the button when the button is active and is clicked. "
ButtonStyle::usage = "ButtonStyle is an option for ButtonBox which specifies the default properties for the button. "
ByteCount::usage = "\!\(\*RowBox[{\"ByteCount\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the number of bytes used internally by \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) to store \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Byte::usage = "Byte represents a single byte of data in Read. "
ByteOrdering::usage = "ByteOrdering is an option for BinaryRead, BinaryWrite and related functions that specifies what ordering of bytes should be assumed for your computer system."
CallPacket::usage = "\!\(\*RowBox[{\"CallPacket\", \"[\", RowBox[{StyleBox[\"integer\", \"TI\"], \",\", \" \", StyleBox[\"list\", \"TI\"]}], \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet encapsulating a request to invoke the external function numbered \!\(\*StyleBox[\"integer\", \"TI\"]\) with the arguments contained in \!\(\*StyleBox[\"list\", \"TI\"]\)."
CanberraDistance::usage = "\!\(\*RowBox[{\"CanberraDistance\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the Canberra distance between vectors u and v."
CancelButton::usage = "\!\(\*RowBox[{\"CancelButton\", \"[\", \"]\"}]\) represents a \!\(\*StyleBox[\"Cancel\", \"DialogElementName\"]\) button in a dialog that closes the dialog window when pressed.\n\!\(\*RowBox[{\"CancelButton\", \"[\", StyleBox[\"action\", \"TI\"], \"]\"}]\) represents a button labeled \!\(\*StyleBox[\"Cancel\", \"DialogElementName\"]\) that evaluates \!\(\*StyleBox[\"action\", \"TI\"]\) when pressed.\n\!\(\*RowBox[{\"CancelButton\", \"[\", RowBox[{StyleBox[\"label\", \"TI\"], \",\", StyleBox[\"action\", \"TI\"]}], \"]\"}]\) uses \!\(\*StyleBox[\"label\", \"TI\"]\) as the label for the button."
Cancel::usage = "\!\(\*RowBox[{\"Cancel\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) cancels out common factors in the numerator and denominator of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
CapitalDifferentialD::usage = "\!\(\*RowBox[{\"CapitalDifferentialD\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) displays as \!\(\*RowBox[{\"\[CapitalDifferentialD]\", StyleBox[\"x\", \"TI\"]}]\)."
Cap::usage = "\!\(\*RowBox[{\"Cap\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[Cap]\", StyleBox[\"y\", \"TI\"], \"\[Cap]\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\)."
CarmichaelLambda::usage = "\!\(\*RowBox[{\"CarmichaelLambda\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the Carmichael function \!\(\*RowBox[{\"\[Lambda]\", \"(\", \"n\", \")\"}]\), defined as the smallest integer \!\(\*StyleBox[\"m\", \"TI\"]\) such that \!\(\*RowBox[{SuperscriptBox[\"k\", \"m\"], \"\[Congruent]\", RowBox[{\"1\", \"mod\", \" \", \"n\"}]}]\) for all \!\(\*StyleBox[\"k\", \"TI\"]\) relatively prime to \!\(\*StyleBox[\"n\", \"TI\"]\). "
Cases::usage = "\!\(\*RowBox[{\"Cases\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"pattern\", \"TI\"]}], \"]\"}]\) gives a list of the \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) that match the pattern. \n\!\(\*RowBox[{\"Cases\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{StyleBox[\"pattern\", \"TI\"], \"->\", StyleBox[\"rhs\", \"TI\"]}]}], \"]\"}]\) gives a list of the values of \!\(\*StyleBox[\"rhs\", \"TI\"]\) corresponding to the \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) that match the pattern. \n\!\(\*RowBox[{\"Cases\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"pattern\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"]}], \"]\"}]\) gives a list of all parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) on levels specified by \!\(\*StyleBox[\"levelspec\", \"TI\"]\) which match the pattern. \n\!\(\*RowBox[{\"Cases\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{StyleBox[\"pattern\", \"TI\"], \"->\", StyleBox[\"rhs\", \"TI\"]}], \",\", StyleBox[\"levelspec\", \"TI\"]}], \"]\"}]\) gives the values of \!\(\*StyleBox[\"rhs\", \"TI\"]\) which match the pattern. \n\!\(\*RowBox[{\"Cases\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"pattern\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the first \!\(\*StyleBox[\"n\", \"TI\"]\) parts in \!\(\*StyleBox[\"expr\", \"TI\"]\) which match the pattern. "
Catalan::usage = "Catalan is Catalan\[CloseCurlyQuote]s constant, with numerical value \!\(\*RowBox[{\"\[TildeEqual]\", \"0.915966\"}]\). "
CatalanNumber::usage = "\!\(\*RowBox[{\"CatalanNumber\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) Catalan number \!\(\*SubscriptBox[\"C\", \"n\"]\)."
Catch::usage = "\!\(\*RowBox[{\"Catch\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) returns the argument of the first Throw generated in the evaluation of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Catch\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) returns \!\(\*StyleBox[\"value\", \"TI\"]\) from the first \!\(\*RowBox[{\"Throw\", \"[\", RowBox[{StyleBox[\"value\", \"TI\"], \",\", StyleBox[\"tag\", \"TI\"]}], \"]\"}]\) for which \!\(\*StyleBox[\"form\", \"TI\"]\) matches \!\(\*StyleBox[\"tag\", \"TI\"]\). \n\!\(\*RowBox[{\"Catch\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) returns \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{StyleBox[\"value\", \"TI\"], \",\", StyleBox[\"tag\", \"TI\"]}], \"]\"}]\). "
CauchyDistribution::usage = "\!\(\*RowBox[{\"CauchyDistribution\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) represents a Cauchy distribution with location parameter \!\(\*StyleBox[\"a\", \"TI\"]\) and scale parameter \!\(\*StyleBox[\"b\", \"TI\"]\)."
CDF::usage = "\!\(\*RowBox[{\"CDF\", \"[\", RowBox[{StyleBox[\"dist\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the cumulative distribution function for the symbolic distribution \!\(\*StyleBox[\"dist\", \"TI\"]\) evaluated at \!\(\*StyleBox[\"x\", \"TI\"]\).\n\!\(\*RowBox[{\"CDF\", \"[\", StyleBox[\"dist\", \"TI\"], \"]\"}]\) gives the CDF as a pure function."
Ceiling::usage = "\!\(\*RowBox[{\"Ceiling\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives the smallest integer greater than or equal to \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"Ceiling\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"]\"}]\) gives the smallest multiple of \!\(\*StyleBox[\"a\", \"TI\"]\) greater than or equal to \!\(\*StyleBox[\"x\", \"TI\"]\). "
CellAutoOverwrite::usage = "CellAutoOverwrite is an option for Cell which specifies whether new output obtained by evaluating this cell should overwrite old output. "
CellBaseline::usage = "CellBaseline is an option for Cell which specifies where the baseline of the cell should be assumed to be when it appears inside another cell. "
CellBracketOptions::usage = "\!\(\*RowBox[{\"CellBracketOptions\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for cells that specifies settings for cell brackets."
CellChangeTimes::usage = "CellChangeTimes is an option to Cell that specifies when changes were made to the cell."
CellContext::usage = "CellContext is an option for Cell which specifies the context to use for the evaluation of the contents of the cell."
CellDingbat::usage = "CellDingbat is an option for Cell which specifies what dingbat to use to emphasize a cell. "
CellEditDuplicate::usage = "CellEditDuplicate is an option for Cell which specifies whether the front end should make a copy of the cell before actually applying any changes in its contents that you request. "
CellEpilog::usage = "CellEpilog is an option for Cell which gives an expression to evaluate after each ordinary evaluation of the contents of the cell."
CellEvaluationDuplicate::usage = "CellEvaluationDuplicate is an option for Cell which specifies whether the front end should make a copy of the cell before performing any evaluation of its contents that you request. "
CellEvaluationFunction::usage = "CellEvaluationFunction is an option to Cell which gives a function to be applied to every expression from the cell that is sent to the kernel for ordinary evaluation. "
CellEventActions::usage = "CellEventActions is an option for Cell that gives a list of actions to perform when specified events occur in connection with a cell in a notebook. "
CellFrameColor::usage = "CellFrameColor is an option that specifies the color of the frame around a cell."
CellFrameLabelMargins::usage = "CellFrameLabelMargins is an option for cells that specifies the absolute margins in printer\[CloseCurlyQuote]s points between a cell\[CloseCurlyQuote]s frame and the labels around the frame."
CellFrameLabels::usage = "CellFrameLabels is an option that specifies the labels associated with the frame around a cell."
CellFrameMargins::usage = "CellFrameMargins is an option for Cell which specifies the absolute margins in printer\[CloseCurlyQuote]s points to leave inside a frame that is drawn around a cell. "
CellFrame::usage = "CellFrame is an option for Cell which specifies whether a frame should be drawn around a cell. "
CellGroupData::usage = "\!\(\*RowBox[{\"CellGroupData\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) is a low-level construct that represents an open group of cells in a notebook. \n\!\(\*RowBox[{\"CellGroupData\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", \"1\"}], \"]\"}]\) represents a cell group in which only the first cell is open.\n\!\(\*RowBox[{\"CellGroupData\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents a cell group with cells at positions \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\) open. "
CellGrouping::usage = "CellGrouping is a notebook option which specifies how cells in the notebook should be assembled into groups. "
CellGroupingRules::usage = "CellGroupingRules is an option for cells that specifies the rules used for grouping a cell."
CellGroup::usage = "\!\(\*RowBox[{\"CellGroup\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives an open group of cells that can appear in a \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) notebook.\n\!\(\*RowBox[{\"CellGroup\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", \"1\"}], \"]\"}]\) gives a cell group in which only the first cell is open.\n\!\(\*RowBox[{\"CellGroup\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"-\", \"1\"}]}], \"]\"}]\) gives a cell group in which only the last cell is open.\n\!\(\*RowBox[{\"CellGroup\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a cell group in which cells \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \[Ellipsis] are open. "
CellHorizontalScrolling::usage = "CellHorizontalScrolling is an option for cells that specifies whether the contents of a cell can be scrolled from left to right using the horizontal scroll bar of the notebook."
CellLabelAutoDelete::usage = "CellLabelAutoDelete is an option for Cell which specifies whether a label for the cell should be automatically deleted if the contents of the cell are modified or the notebook containing the cell is saved in a file. "
CellLabelMargins::usage = "CellLabelMargins is an option for cells that specifies the absolute margins in printer\[CloseCurlyQuote]s points around a cell label."
CellLabel::usage = "CellLabel is an option for Cell which gives the label to use for a particular cell. "
CellLabelPositioning::usage = "CellLabelPositioning is an option for cells that specifies where the label for a cell is positioned."
CellMargins::usage = "CellMargins is an option for Cell which specifies the absolute margins in printer\[CloseCurlyQuote]s points to leave around a cell. "
Cell::usage = "\!\(\*RowBox[{\"Cell\", \"[\", StyleBox[\"contents\", \"TI\"], \"]\"}]\) is the low-level representation of a cell inside a \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) notebook. \n\!\(\*RowBox[{\"Cell\", \"[\", RowBox[{StyleBox[\"contents\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"style\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) represents a cell in the specified style."
CellOpen::usage = "CellOpen is an option for Cell which specifies whether the contents of a cell should be explicitly displayed. "
CellPrint::usage = "\!\(\*RowBox[{\"CellPrint\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) inserts \!\(\*StyleBox[\"expr\", \"TI\"]\) as a complete cell in the current notebook just below the cell being evaluated. \n\!\(\*RowBox[{\"CellPrint\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) inserts a sequence of cells. "
CellProlog::usage = "CellProlog is an option to Cell which gives an expression to evaluate before each ordinary evaluation of the contents of the cell."
CellSize::usage = "CellSize is an option for cells that specifies the width and height of an inline cell."
CellTags::usage = "CellTags is an option for Cell which gives a list of tags to associate with a cell. "
CellularAutomaton::usage = "\!\(\*RowBox[{\"CellularAutomaton\", \"[\", RowBox[{StyleBox[\"rule\", \"TI\"], \",\", StyleBox[\"init\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) generates a list representing the evolution of the cellular automaton with the specified rule from initial condition \!\(\*StyleBox[\"init\", \"TI\"]\) for \!\(\*StyleBox[\"t\", \"TI\"]\) steps. \n\!\(\*RowBox[{\"CellularAutomaton\", \"[\", RowBox[{StyleBox[\"rule\", \"TI\"], \",\", StyleBox[\"init\", \"TI\"]}], \"]\"}]\) gives the result of evolving \!\(\*StyleBox[\"init\", \"TI\"]\) for one step. \n\!\(\*RowBox[{\"CellularAutomaton\", \"[\", RowBox[{StyleBox[\"rule\", \"TI\"], \",\", StyleBox[\"init\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"tspec\", \"TI\"], \",\", StyleBox[\"xspec\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives only those parts of the evolution specified by \!\(\*StyleBox[\"tspec\", \"TI\"]\), \!\(\*StyleBox[\"xspec\", \"TI\"]\), etc. \n\!\(\*RowBox[{\"CellularAutomaton\", \"[\", RowBox[{StyleBox[\"rule\", \"TI\"], \",\", StyleBox[\"init\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", \"All\", \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) includes at each step all cells that could be affected over the course of \!\(\*StyleBox[\"t\", \"TI\"]\) steps. "
CenterDot::usage = "\!\(\*RowBox[{\"CenterDot\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[CenterDot]\", \"y\", \"\[CenterDot]\", \"\[Ellipsis]\"}]\)."
Center::usage = "Center is a symbol that represents the center for purposes of alignment and positioning. "
CentralMoment::usage = "\!\(\*RowBox[{\"CentralMoment\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[\"r\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) central moment of the elements in \!\(\*StyleBox[\"list\", \"TI\"]\) with respect to their mean."
CForm::usage = "\!\(\*RowBox[{\"CForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints as a C language version of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
CharacterEncoding::usage = "CharacterEncoding is an option for input and output functions which specifies what raw character encoding should be used. "
CharacterEncodingsPath::usage = "CharacterEncodingsPath is a global option that specifies which directories are searched for character encoding files."
CharacteristicFunction::usage = "\!\(\*RowBox[{\"CharacteristicFunction\", \"[\", RowBox[{StyleBox[\"dist\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) gives the characteristic function for the symbolic distribution \!\(\*StyleBox[\"dist\", \"TI\"]\) as a function of the variable \!\(\*StyleBox[\"t\", \"TI\"]\)."
CharacteristicPolynomial::usage = "\!\(\*RowBox[{\"CharacteristicPolynomial\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the characteristic polynomial for the matrix \!\(\*StyleBox[\"m\", \"TI\"]\). \n\!\(\*RowBox[{\"CharacteristicPolynomial\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the generalized characteristic polynomial with respect to \!\(\*StyleBox[\"a\", \"TI\"]\). "
Character::usage = "Character represents a single character in Read. "
CharacterRange::usage = "\!\(\*RowBox[{\"CharacterRange\", \"[\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], \"1\"], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], \"2\"]}], \"]\"}]\) yields a list of the characters in the range from \"\!\(\*SubscriptBox[\nStyleBox[\"c\", \"TI\"], \"1\"]\)\" to \"\!\(\*SubscriptBox[\nStyleBox[\"c\", \"TI\"], \"2\"]\)\". "
Characters::usage = "\!\(\*RowBox[{\"Characters\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a list of the characters in a string. "
ChebyshevDistance::usage = "\!\(\*RowBox[{\"ChebyshevDistance\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the Chebyshev or sup norm distance between vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
ChebyshevT::usage = "\!\(\*RowBox[{\"ChebyshevT\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the Chebyshev polynomial of the first kind \!\(\*RowBox[{SubscriptBox[\"T\", \"n\"], \"(\", \"x\", \")\"}]\). "
ChebyshevU::usage = "\!\(\*RowBox[{\"ChebyshevU\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the Chebyshev polynomial of the second kind \!\(\*RowBox[{SubscriptBox[\"U\", \"n\"], \"(\", \"x\", \")\"}]\). "
CheckAbort::usage = "\!\(\*RowBox[{\"CheckAbort\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"failexpr\", \"TI\"]}], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\), returning \!\(\*StyleBox[\"failexpr\", \"TI\"]\) if an abort occurs. "
CheckAll::usage = "\!\(\*RowBox[{\"CheckAll\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", \" \", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) evaluates expr and returns \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", \" \", RowBox[{\"HoldComplete\", \"[\", RowBox[{SubscriptBox[StyleBox[\"control\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", \" \", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]}], \"]\"}]\) where the control-i expressions are aborts, throws, or other flow control commands currently being executed (but stopped by CheckAll)."
CheckboxBar::usage = "\!\(\*RowBox[{\"CheckboxBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents a checkbox bar with setting \!\(\*StyleBox[\"x\", \"TI\"]\) and with checkboxes for values \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) to include in the list \!\(\*StyleBox[\"x\", \"TI\"]\).\n\!\(\*RowBox[{\"CheckboxBar\", \"[\", RowBox[{RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\), with the values in the list \!\(\*StyleBox[\"x\", \"TI\"]\) being reset every time a checkbox is clicked.\n\!\(\*RowBox[{\"CheckboxBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents a checkbox bar in which the checkbox associated with value \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) has label \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
Checkbox::usage = "\!\(\*RowBox[{\"Checkbox\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) represents a checkbox with setting \!\(\*StyleBox[\"x\", \"TI\"]\), displayed as \!\(\*CheckboxBox[True]\) when \!\(\*StyleBox[\"x\", \"TI\"]\) is True and \!\(\*CheckboxBox[False]\) when \!\(\*StyleBox[\"x\", \"TI\"]\) is False. \n\!\(\*RowBox[{\"Checkbox\", \"[\", RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\), with the value of \!\(\*StyleBox[\"x\", \"TI\"]\) being toggled if the checkbox is clicked. \n\!\(\*RowBox[{\"Checkbox\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) represents a checkbox that toggles between values \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), and displays as \!\(\*CheckboxBox[True]\) and \!\(\*CheckboxBox[False]\) respectively. \n\!\(\*RowBox[{\"Checkbox\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"3\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents a checkbox that cycles through values \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\), and displays as \!\(\*CheckboxBox[3, {1, 2, 3}]\) for all \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) with \!\(\*RowBox[{StyleBox[\"i\", \"TI\"], \">\", \"2\"}]\). "
Check::usage = "\!\(\*RowBox[{\"Check\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"failexpr\", \"TI\"]}], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\), and returns the result, unless messages were generated, in which case it evaluates and returns \!\(\*StyleBox[\"failexpr\", \"TI\"]\). \n\!\(\*RowBox[{\"Check\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"failexpr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"::\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"::\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) checks only for the specified messages. "
ChemicalData::usage = "\!\(\*RowBox[{\"ChemicalData\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the value of the specified property for the chemical \"\!\(\*\nStyleBox[\"name\", \"TI\"]\)\".\n\!\(\*RowBox[{\"ChemicalData\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a structure diagram for the chemical with the specified name.\n\!\(\*RowBox[{\"ChemicalData\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"class\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a list of available chemicals in the specified class."
ChiDistribution::usage = "\!\(\*RowBox[{\"ChiDistribution\", \"[\", StyleBox[\"\[Nu]\", \"TR\"], \"]\"}]\) represents a \!\(\*StyleBox[\"\[Chi]\", \"TR\"]\) distribution with \!\(\*StyleBox[\"\[Nu]\", \"TR\"]\) degrees of freedom."
ChineseRemainder::usage = "\!\(\*RowBox[{\"ChineseRemainder\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the smallest positive \!\(\*StyleBox[\"x\", \"TI\"]\) that satisfies all the integer congruences \!\(\*StyleBox[\"x\", \"TI\"]\) mod \!\(\*SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) = \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) mod \!\(\*SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
ChiSquareDistribution::usage = "\!\(\*RowBox[{\"ChiSquareDistribution\", \"[\", StyleBox[\"\[Nu]\", \"TR\"], \"]\"}]\) represents a \!\(\*SuperscriptBox[\"\[Chi]\", \"2\"]\) distribution with \!\(\*StyleBox[\"\[Nu]\", \"TR\"]\) degrees of freedom."
ChoiceDialog::usage = "\!\(\*RowBox[{\"ChoiceDialog\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) puts up a standard choice dialog that displays \!\(\*StyleBox[\"expr\", \"TI\"]\) together with \!\(\*StyleBox[\"OK\", \"DialogElementName\"]\) and \!\(\*StyleBox[\"Cancel\", \"DialogElementName\"]\) buttons, and returns True if \!\(\*StyleBox[\"OK\", \"DialogElementName\"]\) is pressed, and False if \!\(\*StyleBox[\"Cancel\", \"DialogElementName\"]\) is pressed.\n\!\(\*RowBox[{\"ChoiceDialog\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) includes buttons with labels \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"i\", \"TI\"]]\), and returns the corresponding \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) for the button pressed."
CholeskyDecomposition::usage = "\!\(\*RowBox[{\"CholeskyDecomposition\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the Cholesky decomposition of a matrix \!\(\*StyleBox[\"m\", \"TI\"]\). "
Chop::usage = "\!\(\*RowBox[{\"Chop\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) replaces approximate real numbers in \!\(\*StyleBox[\"expr\", \"TI\"]\) that are close to zero by the exact integer 0. "
CircleDot::usage = "\!\(\*RowBox[{\"CircleDot\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[CircleDot]\", \"y\", \"\[CircleDot]\", \"\[Ellipsis]\"}]\)."
CircleMinus::usage = "\!\(\*RowBox[{\"CircleMinus\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{RowBox[{\"x\", \"\[CircleMinus]\", \"y\"}], \"\[CircleMinus]\", \"\[Ellipsis]\"}]\). "
Circle::usage = "\!\(\*RowBox[{\"Circle\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) is a two\[Hyphen]dimensional graphics primitive that represents a circle of radius \!\(\*StyleBox[\"r\", \"TI\"]\) centered at the point \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"y\", \"TI\"]\). \n\!\(\*RowBox[{\"Circle\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \"]\"}]\) gives a circle of radius 1. \n\!\(\*RowBox[{\"Circle\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"r\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[\"\[Theta]\", StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[\"\[Theta]\", StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) gives a circular arc. \n\!\(\*RowBox[{\"Circle\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives an ellipse with semi\[Hyphen]axes of lengths \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"x\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"y\", \"TI\"]]\), oriented parallel to the coordinate axes. "
CirclePlus::usage = "\!\(\*RowBox[{\"CirclePlus\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[CirclePlus]\", \"y\", \"\[CirclePlus]\", \"\[Ellipsis]\"}]\)."
CircleTimes::usage = "\!\(\*RowBox[{\"CircleTimes\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) displays as \!\(\*RowBox[{\"\[CircleTimes]\", \"x\"}]\).\n\!\(\*RowBox[{\"CircleTimes\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[CircleTimes]\", \"y\", \"\[CircleTimes]\", \"\[Ellipsis]\"}]\)."
CityData::usage = "\!\(\*RowBox[{\"CityData\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the value of the specified property for the city with the specified name.\n\!\(\*RowBox[{\"CityData\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a list of the full specifications of cities whose names are consistent with \!\(\*StyleBox[\"name\", \"TI\"]\)."
ClearAll::usage = "\!\(\*RowBox[{\"ClearAll\", \"[\", RowBox[{SubscriptBox[StyleBox[\"symb\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"symb\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) clears all values, definitions, attributes, messages and defaults associated with symbols. \n\!\(\*RowBox[{\"ClearAll\", \"[\", RowBox[{SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) clears all symbols whose names textually match any of the \!\(\*SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
ClearAttributes::usage = "\!\(\*RowBox[{\"ClearAttributes\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"attr\", \"TI\"]}], \"]\"}]\) removes \!\(\*StyleBox[\"attr\", \"TI\"]\) from the list of attributes of the symbol \!\(\*StyleBox[\"s\", \"TI\"]\). "
Clear::usage = "\!\(\*RowBox[{\"Clear\", \"[\", RowBox[{SubscriptBox[StyleBox[\"symbol\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"symbol\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) clears values and definitions for the \!\(\*SubscriptBox[StyleBox[\"symbol\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Clear\", \"[\", RowBox[{SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) clears values and definitions for all symbols whose names match any of the string patterns \!\(\*SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
ClearSystemCache::usage = "\!\(\*RowBox[{\"ClearSystemCache\", \"[\", \"]\"}]\) clears internal system caches of stored results."
ClebschGordan::usage = "\!\(\*RowBox[{\"ClebschGordan\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives the Clebsch\[Hyphen]Gordan coefficient for the decomposition of \!\(\*RowBox[{RowBox[{RowBox[{\"\[VerticalSeparator]\", \"j\"}], \",\", \"m\"}], \"\[RightAngleBracket]\"}]\) in terms of \!\(\*RowBox[{RowBox[{RowBox[{RowBox[{RowBox[{RowBox[{\"\[VerticalSeparator]\", SubscriptBox[\"j\", \"1\"]}], \",\", SubscriptBox[\"m\", \"1\"]}], \"\[RightAngleBracket]\"}], \"\[VerticalSeparator]\", SubscriptBox[\"j\", \"2\"]}], \",\", SubscriptBox[\"m\", \"2\"]}], \"\[RightAngleBracket]\"}]\). "
ClickPane::usage = "\!\(\*RowBox[{\"ClickPane\", \"[\", RowBox[{StyleBox[\"image\", \"TI\"], \",\", StyleBox[\"func\", \"TI\"]}], \"]\"}]\) represents a clickable pane that displays as \!\(\*StyleBox[\"image\", \"TI\"]\) and applies \!\(\*StyleBox[\"func\", \"TI\"]\) to the \!\(\*RowBox[{\"x\", \",\", \"y\"}]\) coordinates of each click within the pane.\n\!\(\*RowBox[{\"ClickPane\", \"[\", RowBox[{StyleBox[\"image\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"}\"}], \",\", StyleBox[\"func\", \"TI\"]}], \"]\"}]\) specifies the range of coordinates to use."
ClipFill::usage = "ClipFill is an option for plotting functions that specifies what should be shown where curves or surfaces would extend beyond the plot range. "
Clip::usage = "\!\(\*RowBox[{\"Clip\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives \!\(\*StyleBox[\"x\", \"TI\"]\) clipped to be between \!\(\*RowBox[{\"-\", \"1\"}]\) and \!\(\*RowBox[{\"+\", \"1\"}]\). \n\!\(\*RowBox[{\"Clip\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"min\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives \!\(\*StyleBox[\"x\", \"TI\"]\) for \!\(\*RowBox[{StyleBox[\"min\", \"TI\"], \"\[LessEqual]\", StyleBox[\"x\", \"TI\"], \"\[LessEqual]\", StyleBox[\"max\", \"TI\"]}]\), \!\(\*StyleBox[\"min\", \"TI\"]\) for \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"<\", StyleBox[\"min\", \"TI\"]}]\) and \!\(\*StyleBox[\"max\", \"TI\"]\) for \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \">\", StyleBox[\"max\", \"TI\"]}]\). \n\!\(\*RowBox[{\"Clip\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"min\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) for \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"<\", StyleBox[\"min\", \"TI\"]}]\) and \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) for \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \">\", StyleBox[\"max\", \"TI\"]}]\). "
ClippingStyle::usage = "ClippingStyle is an option for plotting functions that specifies the style of what should be drawn when curves or surfaces would extend beyond the plot range. "
Clock::usage = "\!\(\*RowBox[{\"Clock\", \"[\", \"]\"}]\) represents a clock variable whose value cycles continuously from 0 to 1 once per second when it appears inside a dynamically updated object such as a Dynamic. \n\!\(\*RowBox[{\"Clock\", \"[\", StyleBox[\"t\", \"TI\"], \"]\"}]\) cycles from 0 to \!\(\*StyleBox[\"t\", \"TI\"]\) every \!\(\*StyleBox[\"t\", \"TI\"]\) seconds.\n\!\(\*RowBox[{\"Clock\", \"[\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) cycles from 0 to \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) every \!\(\*StyleBox[\"t\", \"TI\"]\) seconds.\n\!\(\*RowBox[{\"Clock\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) cycles through the range \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) every \!\(\*StyleBox[\"t\", \"TI\"]\) seconds.\n\!\(\*RowBox[{\"Clock\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \"]\"}]\) cycles through the range \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) over the course of \!\(\*RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]], \"-\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]]}]\) seconds.\n\!\(\*RowBox[{\"Clock\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"dv\", \"TI\"]}], \"}\"}], \"]\"}]\) cycles from \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) in steps of \!\(\*StyleBox[\"dv\", \"TI\"]\), spending \!\(\*StyleBox[\"dv\", \"TI\"]\) seconds at each value.\n\!\(\*RowBox[{\"Clock\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"dv\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) cycles from \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) in steps \!\(\*StyleBox[\"dv\", \"TI\"]\) every \!\(\*StyleBox[\"t\", \"TI\"]\) seconds.\n\!\(\*RowBox[{\"Clock\", \"[\", RowBox[{StyleBox[\"vals\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) goes through the cycle only \!\(\*StyleBox[\"n\", \"TI\"]\) times, then always yields only the maximum value."
Close::usage = "\!\(\*RowBox[{\"Close\", \"[\", StyleBox[\"stream\", \"TI\"], \"]\"}]\) closes a stream. "
ClosingAutoSave::usage = "ClosingAutoSave is an option for notebooks that specifies whether a notebook is automatically saved when it is closed."
CMYKColor::usage = "\!\(\*RowBox[{\"CMYKColor\", \"[\", RowBox[{StyleBox[\"cyan\", \"TI\"], \",\", StyleBox[\"magenta\", \"TI\"], \",\", StyleBox[\"yellow\", \"TI\"], \",\", StyleBox[\"black\", \"TI\"]}], \"]\"}]\) is a graphics directive which specifies that graphical objects which follow are to be displayed in the color given. \n\!\(\*RowBox[{\"CMYKColor\", \"[\", RowBox[{StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"]\"}]\) specifies opacity \!\(\*StyleBox[\"a\", \"TI\"]\). "
C::usage = "\!\(\*RowBox[{\"C\", \"[\", StyleBox[\"i\", \"TI\"], \"]\"}]\) is the default form for the \!\(\*StyleBox[RowBox[{StyleBox[\"i\", \"TI\"], \"\[Null]\"}]]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) parameter or constant generated in representing the results of various symbolic computations. "
CoefficientArrays::usage = "\!\(\*RowBox[{\"CoefficientArrays\", \"[\", RowBox[{StyleBox[\"polys\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"]}], \"]\"}]\) gives the arrays of coefficients of the variables \!\(\*StyleBox[\"vars\", \"TI\"]\) in the polynomials \!\(\*StyleBox[\"polys\", \"TI\"]\). "
CoefficientDomain::usage = "CoefficientDomain is an option for GroebnerBasis, PolynomialReduce and PolynomialMod which specifies the domain for polynomial coefficients."
CoefficientList::usage = "\!\(\*RowBox[{\"CoefficientList\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", StyleBox[\"var\", \"TI\"]}], \"]\"}]\) gives a list of coefficients of powers of \!\(\*StyleBox[\"var\", \"TI\"]\) in \!\(\*StyleBox[\"poly\", \"TI\"]\), starting with power \!\(\*StyleBox[\"0\", \"TR\"]\). \n\!\(\*RowBox[{\"CoefficientList\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"var\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"var\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives an array of coefficients of the \!\(\*SubscriptBox[StyleBox[\"var\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
Coefficient::usage = "\!\(\*RowBox[{\"Coefficient\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) gives the coefficient of \!\(\*StyleBox[\"form\", \"TI\"]\) in the polynomial \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Coefficient\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the coefficient of \!\(\*RowBox[{StyleBox[\"form\", \"TI\"], \"^\", StyleBox[\"n\", \"TI\"]}]\) in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Collect::usage = "\!\(\*RowBox[{\"Collect\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) collects together terms involving the same powers of objects matching \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"Collect\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) collects together terms that involve the same powers of objects matching \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \[Ellipsis] . \n\!\(\*RowBox[{\"Collect\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"var\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"h\", \"TI\"]\) to the expression that forms the coefficient of each term obtained. "
ColonForm::usage = "\!\(\*RowBox[{\"ColonForm\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) prints as \!\(\*RowBox[{StyleBox[\"a\", \"TI\"], \":\", \" \", StyleBox[\"b\", \"TI\"]}]\)."
Colon::usage = "\!\(\*RowBox[{\"Colon\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Colon]\", \"y\", \"\[Colon]\", \"\[Ellipsis]\"}]\)."
ColorDataFunction::usage = "\!\(\*RowBox[{\"ColorDataFunction\", \"[\", RowBox[{StyleBox[\"range\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) is a function that represents a color scheme. "
ColorData::usage = "\!\(\*RowBox[{\"ColorData\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"scheme\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a function that generates colors in the named color scheme when applied to parameter values. \n\!\(\*RowBox[{\"ColorData\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"scheme\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the specified property of a color scheme.\n\!\(\*RowBox[{\"ColorData\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"collection\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a list of color schemes in a named collection.\n\!\(\*RowBox[{\"ColorData\", \"[\", \"]\"}]\) gives a list of named collections of color schemes."
ColorFunction::usage = "ColorFunction is an option for graphics functions which specifies a function to apply to determine colors of elements. "
ColorFunctionScaling::usage = "ColorFunctionScaling is an option for graphics functions which specifies whether arguments supplied to a color function should be scaled to lie between 0 and 1. "
ColorOutput::usage = "ColorOutput is an option for graphics functions which specifies the type of color output to produce. "
ColorRules::usage = "ColorRules is an option for ArrayPlot which specifies how colors of cells should be determined from values. "
ColorSelectorSettings::usage = "\!\(\*RowBox[{\"ColorSelectorSettings\", \"->\", RowBox[{\"{\", RowBox[{StyleBox[\"opt\", \"TI\"], \"->\", StyleBox[\"val\", \"TI\"]}], \"}\"}]}]\) is a global option that specifies settings for the \!\(\*StyleBox[\"Color\", \"DialogElementName\"]\) dialog box."
ColorSetter::usage = "\!\(\*RowBox[{\"ColorSetter\", \"[\", StyleBox[\"color\", \"TI\"], \"]\"}]\) represents a color setter which displays as a swatch of the specified color and when clicked brings up a system color picker dialog.\n\!\(\*RowBox[{\"ColorSetter\", \"[\", RowBox[{\"Dynamic\", \"[\", StyleBox[\"color\", \"TI\"], \"]\"}], \"]\"}]\) uses the dynamically updated current value of \!\(\*StyleBox[\"color\", \"TI\"]\), with the value of \!\(\*StyleBox[\"color\", \"TI\"]\) being reset if the color is modified.\n\!\(\*RowBox[{\"ColorSetter\", \"[\", \"]\"}]\) gives a color setter with initial color gray."
ColorSlider::usage = "\!\(\*RowBox[{\"ColorSlider\", \"[\", StyleBox[\"color\", \"TI\"], \"]\"}]\) represents a color slider currently set to the color corresponding to \!\(\*StyleBox[\"color\", \"TI\"]\).\n\!\(\*RowBox[{\"ColorSlider\", \"[\", RowBox[{\"Dynamic\", \"[\", StyleBox[\"color\", \"TI\"], \"]\"}], \"]\"}]\) uses the dynamically updated current value of \!\(\*StyleBox[\"color\", \"TI\"]\), with the value of \!\(\*StyleBox[\"color\", \"TI\"]\) being reset if the color is modified.\n\!\(\*RowBox[{\"ColorSlider\", \"[\", \"]\"}]\) represents a color slider with an initial gray color."
ColumnAlignments::usage = "ColumnAlignments is an option for the low-level function GridBox which specifies how entries in each column should be aligned. "
ColumnForm::usage = "\!\(\*RowBox[{\"ColumnForm\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) prints as a column with \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) above \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), etc. \n\!\(\*RowBox[{\"ColumnForm\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"horiz\", \"TI\"]}], \"]\"}]\) specifies the horizontal alignment of each element. \n\!\(\*RowBox[{\"ColumnForm\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"horiz\", \"TI\"], \",\", StyleBox[\"vert\", \"TI\"]}], \"]\"}]\) also specifies the vertical alignment of the whole column. "
ColumnLines::usage = "ColumnLines is an option for the low-level function GridBox which specifies whether lines should be drawn between adjacent columns. "
Column::usage = "\!\(\*RowBox[{\"Column\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) is an object that formats with the \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) arranged in a column, with \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) above \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), etc. \n\!\(\*RowBox[{\"Column\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"alignment\", \"TI\"]}], \"]\"}]\) aligns each element horizontally in the specified way. \n\!\(\*RowBox[{\"Column\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"alignment\", \"TI\"], \",\", StyleBox[\"spacing\", \"TI\"]}], \"]\"}]\) leaves the specified number of x-heights of spacing between successive elements."
ColumnsEqual::usage = "ColumnsEqual is an option for the low-level function GridBox which specifies whether all columns in the grid should be assigned equal width. "
ColumnSpacings::usage = "ColumnSpacings is an option for the low-level function GridBox which specifies the spaces in ems that should be inserted between adjacent columns. "
ColumnWidths::usage = "ColumnWidths is an option for the low-level function GridBox which specifies the widths to use for columns. "
CommonDefaultFormatTypes::usage = "\!\(\*RowBox[{\"CommonDefaultFormatTypes\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option that specifies default formats for newly created cells."
Commonest::usage = "\!\(\*RowBox[{\"Commonest\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives a list of the elements that are the most common in \!\(\*StyleBox[\"list\", \"TI\"]\).\n\!\(\*RowBox[{\"Commonest\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a list of the \!\(\*StyleBox[\"n\", \"TI\"]\) most common elements in \!\(\*StyleBox[\"list\", \"TI\"]\)."
CompiledFunction::usage = "\!\(\*RowBox[{\"CompiledFunction\", \"[\", RowBox[{StyleBox[\"args\", \"TI\"], \",\", StyleBox[\"argregs\", \"TI\"], \",\", StyleBox[\"nregs\", \"TI\"], \",\", StyleBox[\"instr\", \"TI\"], \",\", StyleBox[\"func\", \"TI\"]}], \"]\"}]\) represents compiled code for evaluating a compiled function. "
Compiled::usage = "Compiled is an option for various numerical and plotting functions which specifies whether the expressions they work with should automatically be compiled. "
Compile::usage = "\!\(\*RowBox[{\"Compile\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) creates a compiled function which evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\) assuming numerical values of the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Compile\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) assumes that \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) is of a type which matches \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Compile\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) assumes that \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) is a rank \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) array of objects each of a type which matches \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Compile\", \"[\", RowBox[{StyleBox[\"vars\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) assumes that subexpressions in \!\(\*StyleBox[\"expr\", \"TI\"]\) which match \!\(\*SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) are of types which match \!\(\*SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
Complement::usage = "\!\(\*RowBox[{\"Complement\", \"[\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"all\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the elements in \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"all\", \"TI\"]]\) which are not in any of the \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
Complexes::usage = "Complexes represents the domain of complex numbers, as in \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], StyleBox[\"\[Element]\", \"TR\"], \"Complexes\"}]\). "
ComplexExpand::usage = "\!\(\*RowBox[{\"ComplexExpand\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) expands \!\(\*StyleBox[\"expr\", \"TI\"]\) assuming that all variables are real. \n\!\(\*RowBox[{\"ComplexExpand\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) expands \!\(\*StyleBox[\"expr\", \"TI\"]\) assuming that variables matching any of the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) are complex. "
ComplexInfinity::usage = "ComplexInfinity represents a quantity with infinite magnitude, but undetermined complex phase. "
ComplexityFunction::usage = "ComplexityFunction is an option for Simplify and FullSimplify which gives a function to rank the complexity of different forms of an expression. "
Complex::usage = "Complex is the head used for complex numbers. "
ComposeList::usage = "\!\(\*RowBox[{\"ComposeList\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) generates a list of the form \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \",\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"[\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \"]\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\). "
ComposeSeries::usage = "\!\(\*RowBox[{\"ComposeSeries\", \"[\", RowBox[{SubscriptBox[StyleBox[\"series\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"series\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) composes several power series. "
Composition::usage = "\!\(\*RowBox[{\"Composition\", \"[\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"3\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) represents a composition of the functions \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"3\", \"TR\"]]\), \[Ellipsis] . "
CompoundExpression::usage = "\!\(\*RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \";\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \";\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\) evaluates the \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) in turn, giving the last one as the result. "
Compress::usage = "\!\(\*RowBox[{\"Compress\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives a compressed representation of \!\(\*StyleBox[\"expr\", \"TI\"]\) as a string. "
Condition::usage = "\!\(\*RowBox[{StyleBox[\"patt\", \"TI\"], \"/;\", StyleBox[\"test\", \"TI\"]}]\) is a pattern which matches only if the evaluation of \!\(\*StyleBox[\"test\", \"TI\"]\) yields True. \n\!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \":>\", RowBox[{StyleBox[\"rhs\", \"TI\"], \"/;\", StyleBox[\"test\", \"TI\"]}]}]\) represents a rule which applies only if the evaluation of \!\(\*StyleBox[\"test\", \"TI\"]\) yields True. \n\!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \":=\", RowBox[{StyleBox[\"rhs\", \"TI\"], \"/;\", StyleBox[\"test\", \"TI\"]}]}]\) is a definition to be used only if \!\(\*StyleBox[\"test\", \"TI\"]\) yields True. "
ConfigurationPath::usage = "ConfigurationPath is a global option that specifies which directories are searched for systemwide configuration information."
Congruent::usage = "\!\(\*RowBox[{\"Congruent\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\", FontSize -> 10]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Congruent]\", \"y\", \"\[Congruent]\", \"\[Ellipsis]\"}]\)."
Conjugate::usage = "\!\(\*RowBox[{\"Conjugate\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) or \!\(\*RowBox[{StyleBox[\"z\", \"TI\"], \"\[Conjugate]\"}]\) gives the complex conjugate of the complex number \!\(\*StyleBox[\"z\", \"TI\"]\). "
ConjugateTranspose::usage = "\!\(\*RowBox[{\"ConjugateTranspose\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) or \!\(\*SuperscriptBox[\"m\", \"\[ConjugateTranspose]\"]\) gives the conjugate transpose of m. "
ConstantArray::usage = "\!\(\*RowBox[{\"ConstantArray\", \"[\", RowBox[{StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) generates a list of \!\(\*StyleBox[\"n\", \"TI\"]\) copies of the element \!\(\*StyleBox[\"c\", \"TI\"]\).\n\!\(\*RowBox[{\"ConstantArray\", \"[\", RowBox[{StyleBox[\"c\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) generates an \!\(\*RowBox[{SubscriptBox[\"n\", \"1\"], \"\[Cross]\", SubscriptBox[\"n\", \"2\"], \"\[Cross]\", \"...\"}]\) array of nested lists containing copies of the element \!\(\*StyleBox[\"c\", \"TI\"]\)."
Constant::usage = "Constant is an attribute which indicates zero derivative of a symbol with respect to all parameters. "
Constants::usage = "Constants is an option for Dt which gives a list of objects to be taken as constants. "
ContentSelectable::usage = "ContentSelectable is an option to constructs such as Inset, Graphics and GraphicsGroup that specifies whether and how content within them should be selectable. "
Context::usage = "\!\(\*RowBox[{\"Context\", \"[\", \"]\"}]\) gives the current context. \n\!\(\*RowBox[{\"Context\", \"[\", StyleBox[\"symbol\", \"TI\"], \"]\"}]\) gives the context in which a symbol appears. "
Contexts::usage = "\!\(\*RowBox[{\"Contexts\", \"[\", \"]\"}]\) gives a list of all contexts. \n\!\(\*RowBox[{\"Contexts\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a list of the contexts which match the string. "
ContextToFileName::usage = "\!\(\*RowBox[{\"ContextToFileName\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"context\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the string specifying the file name that is by convention associated with a particular context."
ContinuedFraction::usage = "\!\(\*RowBox[{\"ContinuedFraction\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) generates a list of the first \!\(\*StyleBox[\"n\", \"TI\"]\) terms in the continued fraction representation of\[NonBreakingSpace]\!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"ContinuedFraction\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) generates a list of all terms that can be obtained given the precision of\[NonBreakingSpace]\!\(\*StyleBox[\"x\", \"TI\"]\). "
Continue::usage = "\!\(\*RowBox[{\"Continue\", \"[\", \"]\"}]\) exits to the nearest enclosing Do, For or While in a procedural program. "
ContinuousAction::usage = "ContinuousAction is an option for Manipulate, Slider and related functions which specifies whether action should be taken continuously while controls are being moved."
ContourGraphics::usage = "\!\(\*RowBox[{\"ContourGraphics\", \"[\", StyleBox[\"array\", \"TI\"], \"]\"}]\) is a representation of a contour plot. "
ContourLabels::usage = "ContourLabels is an option for contour plots which specifies how to label contours. "
ContourLines::usage = "ContourLines is an option for contour plots which specifies whether to draw explicit contour lines. "
ContourPlot3D::usage = "\!\(\*RowBox[{\"ContourPlot3D\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"z\", \"TI\"], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) produces a three\[Hyphen]dimensional contour plot of f as a function of x, y and z. \n\!\(\*RowBox[{\"ContourPlot3D\", \"[\", RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"==\", StyleBox[\"g\", \"TI\"]}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"z\", \"TI\"], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) plots the contour surface for which \!\(\*RowBox[{\"f\", \"=\", \"g\"}]\). "
ContourPlot::usage = "\!\(\*RowBox[{\"ContourPlot\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a contour plot of \!\(\*StyleBox[\"f\", \"TI\"]\) as a function of \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\). \n\!\(\*RowBox[{\"ContourPlot\", \"[\", RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"==\", StyleBox[\"g\", \"TI\"]}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) plots contour lines for which \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"=\", StyleBox[\"g\", \"TI\"]}]\). \n\!\(\*RowBox[{\"ContourPlot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"==\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"==\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) plots several contour lines. "
ContourShading::usage = "ContourShading is an option for contour plots which specifies how the regions between contour lines should be shaded. "
Contours::usage = "Contours is an option for contour plots that specifies the contours to draw. "
ContourStyle::usage = "ContourStyle is an option for contour plots that specifies the style in which contour lines or surfaces should be drawn. "
ControlActive::usage = "\!\(\*RowBox[{\"ControlActive\", \"[\", RowBox[{StyleBox[\"act\", \"TI\"], \",\", StyleBox[\"norm\", \"TI\"]}], \"]\"}]\) evaluates to \!\(\*StyleBox[\"act\", \"TI\"]\) if a control that affects \!\(\*StyleBox[\"act\", \"TI\"]\) is actively being used, and to \!\(\*StyleBox[\"norm\", \"TI\"]\) otherwise."
ControllerInformation::usage = "\!\(\*RowBox[{\"ControllerInformation\", \"[\", \"]\"}]\) gives dynamically updated information on currently connected controller devices."
ControllerLinking::usage = "ControllerLinking is an option for Manipulate, Graphics3D, Plot3D and related functions which specifies whether to allow interactive control by external controllers."
ControllerManipulate::usage = "\!\(\*RowBox[{\"ControllerManipulate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a version of \!\(\*StyleBox[\"expr\", \"TI\"]\) set up to allow interactive manipulation of the value of \!\(\*StyleBox[\"u\", \"TI\"]\) using an external controller device.\n\!\(\*RowBox[{\"ControllerManipulate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"du\", \"TI\"]}], \"}\"}]}], \"]\"}]\) allows the value of \!\(\*StyleBox[\"u\", \"TI\"]\) to vary between \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) in steps \!\(\*StyleBox[\"du\", \"TI\"]\). \n\!\(\*RowBox[{\"ControllerManipulate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"init\", \"TI\"]]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) takes the initial value of \!\(\*StyleBox[\"u\", \"TI\"]\) to be \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"init\", \"TI\"]]\). \n\!\(\*RowBox[{\"ControllerManipulate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"}\"}]}], \"]\"}]\) allows \!\(\*StyleBox[\"u\", \"TI\"]\) to take on discrete values \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\). \n\!\(\*RowBox[{\"ControllerManipulate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) allows each of the \!\(\*StyleBox[\"u\", \"TI\"]\), \!\(\*StyleBox[\"v\", \"TI\"]\), \[Ellipsis] to be manipulated by the external controller device. \n\!\(\*RowBox[{\"ControllerManipulate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"u\", \"TI\"]], \"->\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \",\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"v\", \"TI\"]], \"->\", RowBox[{\"{\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) links the parameters to the specified controllers on the external controller device."
ControllerMethod::usage = "ControllerMethod is an option for Manipulate, Graphics3D, Plot3D and related functions that specifies the default way that controls on an external controller device should apply."
ControllerPath::usage = "ControllerPath is an option which gives a list of external controllers or classes of controllers to try for functions such as ControllerState, Manipulate and Graphics3D."
ControllerState::usage = "\!\(\*RowBox[{\"ControllerState\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"c\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the state of the control \!\(\*StyleBox[\"c\", \"TI\"]\) for the first connected controller device on which it is supported.\n\!\(\*RowBox[{\"ControllerState\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives the states of several controls.\n\!\(\*RowBox[{\"ControllerState\", \"[\", RowBox[{StyleBox[\"id\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"c\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the state of control \!\(\*StyleBox[\"c\", \"TI\"]\) for controller devices with the specified identifier.\n\!\(\*RowBox[{\"ControllerState\", \"[\", RowBox[{StyleBox[\"id\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the states of several controls for several controller devices."
ControlPlacement::usage = "ControlPlacement is an option for Manipulate, TabView and other control objects that specifies where controls should be placed."
ControlsRendering::usage = "ControlsRendering is a Style option that specifies how controls should be rendered."
ControlType::usage = "ControlType is an option for Manipulate and related functions that specifies what type of controls should be displayed."
Convergents::usage = "\!\(\*RowBox[{\"Convergents\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives a list of the convergents corresponding to the continued fraction terms \!\(\*StyleBox[\"list\", \"TI\"]\).\n\!\(\*RowBox[{\"Convergents\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the first \!\(\*StyleBox[\"n\", \"TI\"]\) convergents for a number \!\(\*StyleBox[\"x\", \"TI\"]\).\n\!\(\*RowBox[{\"Convergents\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives if possible all convergents leading to the number \!\(\*StyleBox[\"x\", \"TI\"]\)."
ConversionOptions::usage = "ConversionOptions is an option to Import and Export used to pass special options to a particular format."
ConversionRules::usage = "ConversionRules is an option for Cell which can be set to a list of rules specifying how the contents of the cell are to be converted to external formats. "
ConvertToPostScriptPacket::usage = "ConvertToPostScriptPacket is an internal symbol used for formatting."
CoprimeQ::usage = "\!\(\*RowBox[{\"CoprimeQ\", \"[\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) yields True if \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) are relatively prime, and yields False otherwise. \n\!\(\*RowBox[{\"CoprimeQ\", \"[\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) yields True if all pairs of the \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) are relatively prime, and yields False otherwise. "
Coproduct::usage = "\!\(\*RowBox[{\"Coproduct\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Coproduct]\", \"y\", \"\[Coproduct]\", \"\[Ellipsis]\"}]\)."
Copyable::usage = "Copyable is an option for Cell which specifies whether a cell can be copied interactively using the front end. "
CopyDirectory::usage = "\!\(\*RowBox[{\"CopyDirectory\", \"[\", RowBox[{SubscriptBox[StyleBox[\"dir\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"dir\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) copies the directory \!\(\*SubscriptBox[StyleBox[\"dir\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) to \!\(\*SubscriptBox[StyleBox[\"dir\", \"TI\"], StyleBox[\"2\", \"TR\"]]\). "
CopyFile::usage = "\!\(\*RowBox[{\"CopyFile\", \"[\", RowBox[{SubscriptBox[StyleBox[\"file\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"file\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) copies \!\(\*SubscriptBox[StyleBox[\"file\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) to \!\(\*SubscriptBox[StyleBox[\"file\", \"TI\"], StyleBox[\"2\", \"TR\"]]\). "
CorrelationDistance::usage = "\!\(\*RowBox[{\"CorrelationDistance\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the correlation coefficient distance between vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
Correlation::usage = "\!\(\*RowBox[{\"Correlation\", \"[\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) gives the correlation between the vectors \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]]\).\n\!\(\*RowBox[{\"Correlation\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the correlation matrix for the matrix \!\(\*StyleBox[\"m\", \"TI\"]\).\n\!\(\*RowBox[{\"Correlation\", \"[\", RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) gives the correlation matrix for the matrices \!\(\*SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"m\", \"TI\"], \"2\"]\)."
CoshIntegral::usage = "\!\(\*RowBox[{\"CoshIntegral\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the hyperbolic cosine integral \!\(\*RowBox[{\"Chi\", \"(\", \"z\", \")\"}]\)."
Cosh::usage = "\!\(\*RowBox[{\"Cosh\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the hyperbolic cosine of \!\(\*StyleBox[\"z\", \"TI\"]\). "
CosineDistance::usage = "\!\(\*RowBox[{\"CosineDistance\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the angular cosine distance between vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
CosIntegral::usage = "\!\(\*RowBox[{\"CosIntegral\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the cosine integral function \!\(\*RowBox[{\"Ci\", \"(\", \"z\", \")\"}]\). "
Cos::usage = "\!\(\*RowBox[{\"Cos\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the cosine of \!\(\*StyleBox[\"z\", \"TI\"]\). "
Coth::usage = "\!\(\*RowBox[{\"Coth\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the hyperbolic cotangent of \!\(\*StyleBox[\"z\", \"TI\"]\). "
Cot::usage = "\!\(\*RowBox[{\"Cot\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the cotangent of \!\(\*StyleBox[\"z\", \"TI\"]\). "
CounterAssignments::usage = "CounterAssignments is an option for selections that sets the value of a specified counter."
CounterFunction::usage = "CounterFunction is an option for counters that specifies the symbols used to display the value of the counter."
CounterIncrements::usage = "CounterIncrements is an option for selections that specifies whether the value of a specified counter is incremented by one."
CounterStyleMenuListing::usage = "CounterStyleMenuListing is an option for cells that specifies what counter styles are listed in the \!\(\*StyleBox[\"Counter\", \"DialogElementName\"]\) popup menu of the \!\(\*StyleBox[\"Create Automatic Numbering Object\", \"DialogElementName\"]\) dialog box."
Count::usage = "\!\(\*RowBox[{\"Count\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"pattern\", \"TI\"]}], \"]\"}]\) gives the number of elements in \!\(\*StyleBox[\"list\", \"TI\"]\) that match \!\(\*StyleBox[\"pattern\", \"TI\"]\). \n\!\(\*RowBox[{\"Count\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"pattern\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"]}], \"]\"}]\) gives the total number of subexpressions matching \!\(\*StyleBox[\"pattern\", \"TI\"]\) that appear at the levels in \!\(\*StyleBox[\"expr\", \"TI\"]\) specified by \!\(\*StyleBox[\"levelspec\", \"TI\"]\). "
CountRoots::usage = "\!\(\*RowBox[{\"CountRoots\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the number of real roots of the polynomial \!\(\*StyleBox[\"poly\", \"TI\"]\) in \!\(\*StyleBox[\"x\", \"TI\"]\).\n\!\(\*RowBox[{\"CountRoots\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives the number of roots between \!\(\*StyleBox[\"a\", \"TI\"]\) and \!\(\*StyleBox[\"b\", \"TI\"]\). "
CountryData::usage = "\!\(\*RowBox[{\"CountryData\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"tag\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the value of the specified property for the country, country-like entity, or group of countries specified by \"\!\(\*\nStyleBox[\"tag\", \"TI\"]\)\".\n\!\(\*RowBox[{\"CountryData\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"tag\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"property\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", StyleBox[\"dates\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives time series for certain economic and other properties."
Covariance::usage = "\!\(\*RowBox[{\"Covariance\", \"[\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) gives the covariance between lists \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]]\).\n\!\(\*RowBox[{\"Covariance\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the covariance matrix for the matrix \!\(\*StyleBox[\"m\", \"TI\"]\).\n\!\(\*RowBox[{\"Covariance\", \"[\", RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) gives the covariance matrix for the matrices \!\(\*SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"m\", \"TI\"], \"2\"]\)."
CreateDialog::usage = "\!\(\*RowBox[{\"CreateDialog\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) creates a dialog notebook containing \!\(\*StyleBox[\"expr\", \"TI\"]\), and opens it in the front end.\n\!\(\*RowBox[{\"CreateDialog\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"obj\", \"TI\"]}], \"]\"}]\) replaces the notebook represented by the notebook object \!\(\*StyleBox[\"obj\", \"TI\"]\) with the one obtained from \!\(\*StyleBox[\"expr\", \"TI\"]\)."
CreateDirectory::usage = "\!\(\*RowBox[{\"CreateDirectory\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"dir\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) creates a directory with name \!\(\*StyleBox[\"dir\", \"TI\"]\). \n\!\(\*RowBox[{\"CreateDirectory\", \"[\", \"]\"}]\) creates a directory in the default area for temporary directories on your computer system."
CreateDocument::usage = "\!\(\*RowBox[{\"CreateDocument\", \"[\", \"]\"}]\) creates an empty document notebook, and opens it in the front end.\n\!\(\*RowBox[{\"CreateDocument\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) creates and opens a document notebook containing the expression \!\(\*StyleBox[\"expr\", \"TI\"]\).\n\!\(\*RowBox[{\"CreateDocument\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) creates and opens a document notebook consisting of a sequence of cells containing the \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\).\n\!\(\*RowBox[{\"CreateDocument\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"obj\", \"TI\"]}], \"]\"}]\) replaces the notebook represented by the notebook object \!\(\*StyleBox[\"obj\", \"TI\"]\) with the one obtained from \!\(\*StyleBox[\"expr\", \"TI\"]\)."
CreatePalette::usage = "\!\(\*RowBox[{\"CreatePalette\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) creates a palette notebook containing \!\(\*StyleBox[\"expr\", \"TI\"]\), and opens it in the front end.\n\!\(\*RowBox[{\"CreatePalette\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) creates and opens a palette notebook consisting of a sequence of cells containing the \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\).\n\!\(\*RowBox[{\"CreatePalette\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"obj\", \"TI\"]}], \"]\"}]\) replaces the notebook represented by the notebook object \!\(\*StyleBox[\"obj\", \"TI\"]\) with the one obtained from \!\(\*StyleBox[\"expr\", \"TI\"]\)."
CreateWindow::usage = "\!\(\*RowBox[{\"CreateWindow\", \"[\", \"]\"}]\) creates an empty window in the front end.\n\!\(\*RowBox[{\"CreateWindow\", \"[\", StyleBox[\"nb\", \"TI\"], \"]\"}]\) creates a window displaying the notebook expression \!\(\*StyleBox[\"nb\", \"TI\"]\), and opens it in the front end.\n\!\(\*RowBox[{\"CreateWindow\", \"[\", RowBox[{StyleBox[\"nb\", \"TI\"], \",\", StyleBox[\"obj\", \"TI\"]}], \"]\"}]\) replaces the notebook represented by the notebook object \!\(\*StyleBox[\"obj\", \"TI\"]\) with the one obtained from \!\(\*StyleBox[\"expr\", \"TI\"]\)."
Cross::usage = "\!\(\*RowBox[{\"Cross\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives the vector cross product of a and b. "
Csch::usage = "\!\(\*RowBox[{\"Csch\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the hyperbolic cosecant of \!\(\*StyleBox[\"z\", \"TI\"]\). "
Csc::usage = "\!\(\*RowBox[{\"Csc\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the cosecant of \!\(\*StyleBox[\"z\", \"TI\"]\). "
Cubics::usage = "Cubics is an option for functions that involve solving algebraic equations, that specifies whether explicit forms for solutions to cubic equations should be given."
Cuboid::usage = "\!\(\*RowBox[{\"Cuboid\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"min\", \"TI\"]]}], \"}\"}], \"]\"}]\) is a three\[Hyphen]dimensional graphics primitive that represents a unit cuboid, oriented parallel to the axes. \n\!\(\*RowBox[{\"Cuboid\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"min\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) specifies a cuboid by giving the coordinates of opposite corners. "
CupCap::usage = "\!\(\*RowBox[{\"CupCap\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[CupCap]\", StyleBox[\"y\", \"TI\"], \"\[CupCap]\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\)."
Cup::usage = "\!\(\*RowBox[{\"Cup\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Cup]\", \"y\", \"\[Cup]\", \"\[Ellipsis]\"}]\)."
CurrentValue::usage = "\!\(\*RowBox[{\"CurrentValue\", \"[\", StyleBox[\"item\", \"TI\"], \"]\"}]\) gives the current value of \!\(\*StyleBox[\"item\", \"TI\"]\) at a location in the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) system and interface. \n\!\(\*RowBox[{\"CurrentValue\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"item\", \"TI\"], \",\", StyleBox[\"spec\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the current value for the feature of \!\(\*StyleBox[\"item\", \"TI\"]\) specified by \!\(\*StyleBox[\"spec\", \"TI\"]\).\n\!\(\*RowBox[{\"CurrentValue\", \"[\", RowBox[{StyleBox[\"obj\", \"TI\"], \",\", StyleBox[\"item\", \"TI\"]}], \"]\"}]\) gives the current value of \!\(\*StyleBox[\"item\", \"TI\"]\) associated with the object \!\(\*StyleBox[\"obj\", \"TI\"]\). "
Cyan::usage = "Cyan represents the color cyan in graphics or style specifications. "
Cyclotomic::usage = "\!\(\*RowBox[{\"Cyclotomic\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) cyclotomic polynomial in x. "
Cylinder::usage = "\!\(\*RowBox[{\"Cylinder\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"}\"}], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) represents a cylinder of radius \!\(\*StyleBox[\"r\", \"TI\"]\) around the line from \!\(\*RowBox[{\"(\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \")\"}]\) to \!\(\*RowBox[{\"(\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \")\"}]\). \n\!\(\*RowBox[{\"Cylinder\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"}\"}], \"]\"}]\) represents a cylinder of radius 1. "
CylindricalDecomposition::usage = "\!\(\*RowBox[{\"CylindricalDecomposition\", \"[\", RowBox[{StyleBox[\"ineqs\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) finds a decomposition of the region represented by the inequalities \!\(\*StyleBox[\"ineqs\", \"TI\"]\) into cylindrical parts whose directions correspond to the successive \!\(\*SubscriptBox[\"x\", \"i\"]\). "
DampingFactor::usage = "DampingFactor is an option for FindRoot, which can be used to control convergence behavior. \!\(\*RowBox[{\"DampingFactor\", \" \", \"->\", \" \", StyleBox[\"n\", \"TI\"]}]\) uses a damping factor of \!\(\*StyleBox[\"n\", \"TI\"]\) in Newton's method."
Darker::usage = "\!\(\*RowBox[{\"Darker\", \"[\", StyleBox[\"color\", \"TI\"], \"]\"}]\) represents a darker version of the specified color. \n\!\(\*RowBox[{\"Darker\", \"[\", RowBox[{StyleBox[\"color\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) represents a version of the specified color darkened by a fraction \!\(\*StyleBox[\"f\", \"TI\"]\). "
Dashed::usage = "Dashed is a graphics directive that specifies that lines which follow should be drawn dashed."
Dashing::usage = "\!\(\*RowBox[{\"Dashing\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) is a two\[Hyphen]dimensional graphics directive which specifies that lines which follow are to be drawn dashed, with successive segments of lengths \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \[Ellipsis] (repeated cyclically). The \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) are given as a fraction of the total width of the graph. \n\!\(\*RowBox[{\"Dashing\", \"[\", StyleBox[\"r\", \"TI\"], \"]\"}]\) is equivalent to \!\(\*RowBox[{\"Dashing\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", StyleBox[\"r\", \"TI\"]}], \"}\"}], \"]\"}]\). "
DataRange::usage = "DataRange is an option for functions such as ListPlot and ListDensityPlot, that specifies what range of actual coordinates the data should be assumed to occupy. "
DataReversed::usage = "DataReversed is an option for ArrayPlot and related functions which specifies whether data should be plotted in reverse order."
DateDifference::usage = "\!\(\*RowBox[{\"DateDifference\", \"[\", RowBox[{SubscriptBox[StyleBox[\"date\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"date\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) gives the number of days from \!\(\*SubscriptBox[StyleBox[\"date\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) to \!\(\*SubscriptBox[StyleBox[\"date\", \"TI\"], StyleBox[\"2\", \"TR\"]]\).\n\!\(\*RowBox[{\"DateDifference\", \"[\", RowBox[{SubscriptBox[StyleBox[\"date\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", \" \", SubscriptBox[StyleBox[\"date\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"unit\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the difference between \!\(\*SubscriptBox[StyleBox[\"date\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"date\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) in the specified unit.\n\!\(\*RowBox[{\"DateDifference\", \"[\", RowBox[{SubscriptBox[StyleBox[\"date\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"date\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"unit\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"unit\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the difference as a list with elements corresponding to the successive \"\!\(\*SubscriptBox[\nStyleBox[\"unit\", \"TI\"], \nStyleBox[\"i\", \"TI\"]]\)\"."
DateFunction::usage = "DateFunction is an option for DateListPlot which specifies how dates given as input should be converted to date lists."
DateList::usage = "\!\(\*RowBox[{\"DateList\", \"[\", \"]\"}]\) gives the current local date and time in the form \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"], \",\", StyleBox[\"hour\", \"TI\"], \",\", StyleBox[\"minute\", \"TI\"], \",\", StyleBox[\"second\", \"TI\"]}], \"}\"}]\). \n\!\(\*RowBox[{\"DateList\", \"[\", StyleBox[\"time\", \"TI\"], \"]\"}]\) gives a date list corresponding to an AbsoluteTime specification.\n\!\(\*RowBox[{\"DateList\", \"[\", RowBox[{StyleBox[\"{\", \"TI\"], RowBox[{StyleBox[\"y\", \"TI\"], StyleBox[\",\", \"TI\"], StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"}\"}], \"]\"}]\) converts a date list to standard normalized form. \n\!\(\*RowBox[{\"DateList\", \"[\", StyleBox[\"\\\"string\\\"\",\"TI\",ShowStringCharacters->True], \"]\"}]\) converts a date string to a date list. \n\!\(\*RowBox[{\"DateList\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"}\"}], \"]\"}]\) gives the date list obtained by extracting elements \"\!\(\*SubscriptBox[\nStyleBox[\"e\", \"TI\"], \nStyleBox[\"i\", \"TI\"]]\)\" from \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\"."
DateListPlot::usage = "\!\(\*RowBox[{\"DateListPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"date\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"date\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots points with values \!\(\*SubscriptBox[\"v\", \"i\"]\) at a sequence of dates.\n\!\(\*RowBox[{\"DateListPlot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"datespec\", \"TI\"]}], \"]\"}]\) plots points with dates at equal intervals specified by \!\(\*StyleBox[\"datespec\", \"TI\"]\).\n\!\(\*RowBox[{\"DateListPlot\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots several lists of values."
Date::usage = "\!\(\*RowBox[{\"Date\", \"[\", \"]\"}]\) gives the current local date and time in the form \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"year\", \"TI\"], \",\", StyleBox[\"month\", \"TI\"], \",\", StyleBox[\"day\", \"TI\"], \",\", StyleBox[\"hour\", \"TI\"], \",\", StyleBox[\"minute\", \"TI\"], \",\", StyleBox[\"second\", \"TI\"]}], \"}\"}]\). "
DatePattern::usage = "\!\(\*RowBox[{\"DatePattern\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents the characters of a date with elements of type \"\!\(\*SubscriptBox[\nStyleBox[\"e\", \"TI\"], \nStyleBox[\"i\", \"TI\"]]\)\" in StringExpression.\n\!\(\*RowBox[{\"DatePattern\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"sep\", \"TI\"]}], \"]\"}]\) allows separators that match the string expression \!\(\*StyleBox[\"sep\", \"TI\"]\)."
DatePlus::usage = "\!\(\*RowBox[{\"DatePlus\", \"[\", RowBox[{StyleBox[\"date\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the date \!\(\*StyleBox[\"n\", \"TI\"]\) days after \!\(\*StyleBox[\"date\", \"TI\"]\).\n\!\(\*RowBox[{\"DatePlus\", \"[\", RowBox[{StyleBox[\"date\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"unit\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"}\"}]}], \"]\"}]\) gives the date \!\(\*StyleBox[\"n\", \"TI\"]\) units after \!\(\*StyleBox[\"date\", \"TI\"]\).\n\!\(\*RowBox[{\"DatePlus\", \"[\", RowBox[{StyleBox[\"date\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"unit\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"unit\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a date offset by \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) units of each specified size. \n\!\(\*RowBox[{\"DatePlus\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the date \!\(\*StyleBox[\"n\", \"TI\"]\) days after the current date.\n\!\(\*RowBox[{\"DatePlus\", \"[\", StyleBox[\"offset\", \"TI\"], \"]\"}]\) gives the date with the specified offset from the current date."
DateString::usage = "\!\(\*RowBox[{\"DateString\", \"[\", \"]\"}]\) gives a string representing the complete current local date and time. \n\!\(\*RowBox[{\"DateString\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"elem\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the specified element or format for date and time.\n\!\(\*RowBox[{\"DateString\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"elem\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"elem\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) concatenates the specified elements in the order given.\n\!\(\*RowBox[{\"DateString\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", \" \", StyleBox[\"m\", \"TI\"], \",\", \" \", StyleBox[\"d\", \"TI\"], \",\", \" \", StyleBox[\"h\", \"TI\"], \",\", \" \", StyleBox[\"m\", \"TI\"], \",\", \" \", StyleBox[\"s\", \"TI\"]}], \"}\"}], \"]\"}]\) gives a string corresponding to a DateList specification.\n\!\(\*RowBox[{\"DateString\", \"[\", StyleBox[\"time\", \"TI\"], \"]\"}]\) gives a string corresponding to an AbsoluteTime specification.\n\!\(\*RowBox[{\"DateString\", \"[\", RowBox[{StyleBox[\"spec\", \"TI\"], \",\", StyleBox[\"elems\", \"TI\"]}], \"]\"}]\) gives elements \!\(\*StyleBox[\"elems\", \"TI\"]\) of the date or time specification \!\(\*StyleBox[\"spec\", \"TI\"]\)."
DateTicksFormat::usage = "DateTicksFormat is an option for DateListPlot which specifies how date tick labels should be formatted."
Decimal::usage = "Decimal is a setting for the ColumnAlignments option of GridBox which states that numbers should align along the decimal place."
DeclarePackage::usage = "\!\(\*RowBox[{\"DeclarePackage\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"context\\\",\\\"TI\\\"]\\)`\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"name\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"name\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) declares that \!\(\*RowBox[{\"Needs\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"context\\\",\\\"TI\\\"]\\)`\\\"\", ShowStringCharacters->True], \"]\"}]\) should automatically be executed if a symbol with any of the specified names is ever used. "
Decompose::usage = "\!\(\*RowBox[{\"Decompose\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) decomposes a polynomial, if possible, into a composition of simpler polynomials. "
Decrement::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"--\"}]\) decreases the value of \!\(\*StyleBox[\"x\", \"TI\"]\) by 1, returning the old value of \!\(\*StyleBox[\"x\", \"TI\"]\). "
DedekindEta::usage = "\!\(\*RowBox[{\"DedekindEta\", \"[\", \"\[Tau]\", \"]\"}]\) gives the Dedekind eta modular elliptic function \!\(\*RowBox[{\"\[Eta]\", RowBox[{\"(\", \"\[Tau]\", \")\"}]}]\). "
DefaultButton::usage = "\!\(\*RowBox[{\"DefaultButton\", \"[\", \"]\"}]\) represents an OK button that closes a dialog, and is the default when \!\(\*StyleBox[\"Enter\", \"KeyEvent\"]\) is pressed in the dialog.\n\!\(\*RowBox[{\"DefaultButton\", \"[\", StyleBox[\"action\", \"TI\"], \"]\"}]\) represents a button that is labeled \!\(\*StyleBox[\"OK\", \"DialogElementName\"]\), and whose action is to evaluate \!\(\*StyleBox[\"action\", \"TI\"]\).\n\!\(\*RowBox[{\"DefaultButton\", \"[\", RowBox[{StyleBox[\"label\", \"TI\"], \",\", StyleBox[\"action\", \"TI\"]}], \"]\"}]\) uses \!\(\*StyleBox[\"label\", \"TI\"]\) as the label for the button."
DefaultColor::usage = "DefaultColor is an option for graphics functions which specifies the default color to use for lines, points, etc. "
DefaultDuplicateCellStyle::usage = "DefaultDuplicateCellStyle is a notebook option which specifies the default style to use for cells created by automatic duplication of other cells in the notebook. "
DefaultDuration::usage = "DefaultDuration is an option to Animate and related functions which specifies the default total duration of the animation in seconds."
DefaultElement::usage = "DefaultElement is an option for Grid and related constructs which specifies what to insert when a new element is interactively created."
DefaultFontProperties::usage = "DefaultFontProperties is a global option that specifies various properties of a font family, such as its character encoding and whether it is monospaced."
DefaultFormatType::usage = "DefaultFormatType is an option for cells that specifies the format used for displaying expressions in a newly created cell."
DefaultInlineFormatType::usage = "DefaultInlineFormatType is an option for cells that specifies the format used for displaying expressions in a newly created inline cell."
DefaultNaturalLanguage::usage = "DefaultNaturalLanguage is an option for character selections that specifies the language used when checking the spelling of a word in a human natural language selection."
Default::usage = "\!\(\*RowBox[{\"Default\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) gives the default value for arguments of the function \!\(\*StyleBox[\"f\", \"TI\"]\) obtained with a _. pattern object. \n\!\(\*RowBox[{\"Default\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"i\", \"TI\"]}], \"]\"}]\) gives the default value to use when _. appears as the \!\(\*SuperscriptBox[StyleBox[\"i\", \"TI\"], \"th\"]\) argument of \!\(\*StyleBox[\"f\", \"TI\"]\). \n\!\(\*RowBox[{\"Default\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the default value for the \!\(\*SuperscriptBox[StyleBox[\"i\", \"TI\"], \"th\"]\) argument out of a total of \!\(\*StyleBox[\"n\", \"TI\"]\) arguments. \n\!\(\*RowBox[{RowBox[{\"Default\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}], \"=\", StyleBox[\"val\", \"TI\"]}]\) defines default values for arguments of \!\(\*StyleBox[\"f\", \"TI\"]\)."
DefaultNewCellStyle::usage = "DefaultNewCellStyle is a notebook option which specifies the default style to use for new cells created in the notebook. "
DefaultNewInlineCellStyle::usage = "DefaultNewInlineCellStyle is an option for cells which specifies the default style to use for new inline cells created in the notebook."
DefaultNotebook::usage = "DefaultNotebook is a global option that specifies which notebook is used as a template for all new notebooks."
DefaultOptions::usage = "DefaultOptions is a style option which allows default options to be specified for particular formatting and related constructs. "
DefaultStyleDefinitions::usage = "DefaultStyleDefinitions is a global option that specifies the default stylesheet for all new notebooks."
DefaultValues::usage = "\!\(\*RowBox[{\"DefaultValues\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) gives a list of transformation rules corresponding to all defaults (values for \!\(\*RowBox[{\"Default\", \"[\", RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\), etc.) defined for the symbol \!\(\*StyleBox[\"f\", \"TI\"]\)."
Defer::usage = "\!\(\*RowBox[{\"Defer\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) yields an object that displays as the unevaluated form of \!\(\*StyleBox[\"expr\", \"TI\"]\), but which is evaluated if it is explicitly given as \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) input. "
Definition::usage = "\!\(\*RowBox[{\"Definition\", \"[\", StyleBox[\"symbol\", \"TI\"], \"]\"}]\) prints as the definitions given for a symbol. "
DegreeLexicographic::usage = "DegreeLexicographic represents the degree lexicographic ordering of monomials."
Degree::usage = "Degree gives the number of radians in one degree. It has a numerical value of \!\(\*FractionBox[\"\[Pi]\", \"180\"]\). "
DegreeReverseLexicographic::usage = "DegreeReverseLexicographic represents the degree reverse lexicographic ordering of monomials."
Deinitialization::usage = "Deinitialization is an option for Dynamic, DynamicModule, Manipulate and related constructs, which specifies an expression to be evaluated when the construct can no longer be displayed or used. "
Deletable::usage = "Deletable is an option for Cell which specifies whether the cell can be deleted interactively using the front end. "
DeleteCases::usage = "\!\(\*RowBox[{\"DeleteCases\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"pattern\", \"TI\"]}], \"]\"}]\) removes all elements of \!\(\*StyleBox[\"expr\", \"TI\"]\) which match \!\(\*StyleBox[\"pattern\", \"TI\"]\). \n\!\(\*RowBox[{\"DeleteCases\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"pattern\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"]}], \"]\"}]\) removes all parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) on levels specified by \!\(\*StyleBox[\"levelspec\", \"TI\"]\) which match \!\(\*StyleBox[\"pattern\", \"TI\"]\). \n\!\(\*RowBox[{\"DeleteCases\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"pattern\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) removes the first \!\(\*StyleBox[\"n\", \"TI\"]\) parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) which match \!\(\*StyleBox[\"pattern\", \"TI\"]\). "
DeleteContents::usage = "DeleteContents is an option for DeleteDirectory that specifies whether the contents of directories should automatically be deleted."
DeleteDirectory::usage = "\!\(\*RowBox[{\"DeleteDirectory\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"dir\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) deletes the specified directory. "
DeleteFile::usage = "\!\(\*RowBox[{\"DeleteFile\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) deletes a file. \n\!\(\*RowBox[{\"DeleteFile\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"file\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"file\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) deletes a list of files. "
Delete::usage = "\!\(\*RowBox[{\"Delete\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) deletes the element at position \!\(\*StyleBox[\"n\", \"TI\"]\) in \!\(\*StyleBox[\"expr\", \"TI\"]\). If \!\(\*StyleBox[\"n\", \"TI\"]\) is negative, the position is counted from the end. \n\!\(\*RowBox[{\"Delete\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) deletes the part at position \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\). \n\!\(\*RowBox[{\"Delete\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) deletes parts at several positions. "
DeletionWarning::usage = "DeletionWarning is an option for InterpretationBox or TagBox objects that specifies whether a warning is issued if the box is deleted."
DelimiterFlashTime::usage = "DelimiterFlashTime is an option for cells and notebooks which specifies how long in seconds a delimiter should flash when its matching delimiter is entered. "
DelimiterMatching::usage = "DelimiterMatching is an option for selections that specifies whether an opening delimiter will match only its respective closing delimiter or any closing delimiter."
Delimiter::usage = "Delimiter represents a delimiter to be displayed in objects such as PopupMenu and Manipulate. "
Delimiters::usage = "Delimiters is an option to Splice that specifies the delimiters to look for. The default is \!\(\*RowBox[{\"Delimiters\", \" \", \"->\", \" \", RowBox[{\"{\", StyleBox[RowBox[{\"\\\"<*\\\"\", \",\", \" \", \"\\\"*>\\\"\"}], ShowStringCharacters -> True], \"}\"}]}]\)."
Del::usage = "\!\(\*RowBox[{\"Del\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) displays as \!\(\*RowBox[{\"\[Del]\", \"x\"}]\)."
Denominator::usage = "\!\(\*RowBox[{\"Denominator\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the denominator of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
DensityGraphics::usage = "\!\(\*RowBox[{\"DensityGraphics\", \"[\", StyleBox[\"array\", \"TI\"], \"]\"}]\) is a representation of a density plot. "
DensityPlot::usage = "\!\(\*RowBox[{\"DensityPlot\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) makes a density plot of \!\(\*StyleBox[\"f\", \"TI\"]\) as a function of \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\). "
DependentVariables::usage = "DependentVariables is an option to NDSolve which specifies the list of all objects that should be considered as dependent variables in the equations supplied."
Deployed::usage = "Deployed is an option for displayed objects, cells and notebooks which specifies whether their contents should be considered deployed, so that elements such as Slider, InputField, Locator and Button are active, but general editing and selection is disabled. "
Deploy::usage = "\!\(\*RowBox[{\"Deploy\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) yields a deployed version of \!\(\*StyleBox[\"expr\", \"TI\"]\) in which elements such as Slider, InputField, Locator and Button are active, but general editing and selection is disabled. "
Depth::usage = "\!\(\*RowBox[{\"Depth\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the maximum number of indices needed to specify any part of \!\(\*StyleBox[\"expr\", \"TI\"]\), plus one. "
Derivative::usage = "\!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"'\"}]\) represents the derivative of a function \!\(\*StyleBox[\"f\", \"TI\"]\) of one argument. \n\!\(\*RowBox[{RowBox[{\"Derivative\", \"[\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}], \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) is the general form, representing a function obtained from \!\(\*StyleBox[\"f\", \"TI\"]\) by differentiating \!\(\*SubscriptBox[\"n\", \"1\"]\) times with respect to the first argument, \!\(\*SubscriptBox[\"n\", \"2\"]\) times with respect to the second argument, and so on. "
Det::usage = "\!\(\*RowBox[{\"Det\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the determinant of the square matrix \!\(\*StyleBox[\"m\", \"TI\"]\). "
DiacriticalPositioning::usage = "DiacriticalPositioning is an option for UnderscriptBox and related boxes that specifies how close diacritical characters are drawn to the base character."
DiagonalMatrix::usage = "\!\(\*RowBox[{\"DiagonalMatrix\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives a matrix with the elements of \!\(\*StyleBox[\"list\", \"TI\"]\) on the leading diagonal, and 0 elsewhere. \n\!\(\*RowBox[{\"DiagonalMatrix\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives a matrix with the elements of \!\(\*StyleBox[\"list\", \"TI\"]\) on the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) diagonal."
Diagonal::usage = "\!\(\*RowBox[{\"Diagonal\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the list of elements on the leading diagonal of the matrix \!\(\*StyleBox[\"m\", \"TI\"]\).\n\!\(\*RowBox[{\"Diagonal\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the elements on the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) diagonal of \!\(\*StyleBox[\"m\", \"TI\"]\)."
DialogInput::usage = "\!\(\*RowBox[{\"DialogInput\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) interactively puts up \!\(\*StyleBox[\"expr\", \"TI\"]\) as a dialog notebook, waits until a \!\(\*RowBox[{\"DialogReturn\", \"[\", StyleBox[\"e\", \"TI\"], \"]\"}]\) is evaluated from within it, and then returns the result \!\(\*StyleBox[\"e\", \"TI\"]\). \n\!\(\*RowBox[{\"DialogInput\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{StyleBox[\"x\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \",\", RowBox[{StyleBox[\"y\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) sets up local variables \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"y\", \"TI\"]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\) in \!\(\*StyleBox[\"expr\", \"TI\"]\)."
Dialog::usage = "\!\(\*RowBox[{\"Dialog\", \"[\", \"]\"}]\) initiates a dialog. \n\!\(\*RowBox[{\"Dialog\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) initiates a dialog with \!\(\*StyleBox[\"expr\", \"TI\"]\) as the current value of %. "
DialogNotebook::usage = "\!\(\*RowBox[{\"DialogNotebook\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents a dialog notebook that can be manipulated by the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) front end. "
DialogProlog::usage = "DialogProlog is an option for Dialog which can give an expression to evaluate before the dialog starts. "
DialogReturn::usage = "\!\(\*RowBox[{\"DialogReturn\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) closes a dialog window, returning the expression \!\(\*StyleBox[\"expr\", \"TI\"]\) from the dialog.\n\!\(\*RowBox[{\"DialogReturn\", \"[\", \"]\"}]\) closes a dialog window, returning Null."
DialogSymbols::usage = "DialogSymbols is an option for Dialog which gives a list of symbols whose values should be localized in the dialog. "
Diamond::usage = "\!\(\*RowBox[{\"Diamond\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[Diamond]\", StyleBox[\"y\", \"TI\"], \"\[Diamond]\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\)."
DiceDissimilarity::usage = "\!\(\*RowBox[{\"DiceDissimilarity\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) gives the dice dissimilarity between Boolean vectors \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\)."
DictionaryLookup::usage = "\!\(\*RowBox[{\"DictionaryLookup\", \"[\", StyleBox[\"patt\", \"TI\"], \"]\"}]\) finds all words in an English dictionary that match the string pattern \!\(\*StyleBox[\"patt\", \"TI\"]\).\n\!\(\*RowBox[{\"DictionaryLookup\", \"[\", RowBox[{StyleBox[\"patt\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives only the first \!\(\*StyleBox[\"n\", \"TI\"]\) words found."
DifferenceOrder::usage = "DifferenceOrder is an option for NDSolve. For ordinary differential equations, it controls the order of the method used. If it is Automatic, methods with variable order may be used. For partial differential equations, it determines the order of finite difference approximations for spatial derivatives."
Differences::usage = "\!\(\*RowBox[{\"Differences\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the successive differences of elements in \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Differences\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) differences of \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Differences\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the successive \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"k\", \"TI\"]]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) differences at level \!\(\*StyleBox[\"k\", \"TI\"]\) in a nested list. "
DifferentialD::usage = "\!\(\*RowBox[{\"DifferentialD\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) displays as \!\(\*RowBox[{\"\[DifferentialD]\", StyleBox[\"x\", \"TI\"]}]\)."
DigitBlock::usage = "DigitBlock is an option for NumberForm and related functions which specifies the maximum length of blocks of digits between breaks. "
DigitCharacter::usage = "DigitCharacter represents a digit character 0\[Dash]9 in StringExpression. "
DigitCount::usage = "\!\(\*RowBox[{\"DigitCount\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"]\"}]\) gives the number of \!\(\*StyleBox[\"d\", \"TI\"]\) digits in the base \!\(\*StyleBox[\"b\", \"TI\"]\) representation of \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"DigitCount\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives a list of the numbers of 1, 2, \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\), \!\(\*RowBox[{StyleBox[\"b\", \"TI\"], \"-\", \"1\"}]\), 0 digits in the base \!\(\*StyleBox[\"b\", \"TI\"]\) representation of \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"DigitCount\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives a list of the numbers of 1, 2, \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\), 9, 0 digits in the base 10 representation of \!\(\*StyleBox[\"n\", \"TI\"]\). "
DigitQ::usage = "\!\(\*RowBox[{\"DigitQ\", \"[\", StyleBox[\"string\", \"TI\"], \"]\"}]\) yields True if all the characters in the string are digits in the range 0 through\[NonBreakingSpace]9, and yields False otherwise. "
Dimensions::usage = "\!\(\*RowBox[{\"Dimensions\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives a list of the dimensions of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Dimensions\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a list of the dimensions of \!\(\*StyleBox[\"expr\", \"TI\"]\) down to level \!\(\*StyleBox[\"n\", \"TI\"]\). "
DiracDelta::usage = "\!\(\*RowBox[{\"DiracDelta\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) represents the Dirac delta function \!\(\*RowBox[{\"\[Delta]\", \"(\", \"x\", \")\"}]\). \n\!\(\*RowBox[{\"DiracDelta\", \"[\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) represents the multidimensional Dirac delta function \!\(\*RowBox[{\"\[Delta]\", \"(\", RowBox[{SubscriptBox[\"x\", \"1\"], \",\", SubscriptBox[\"x\", \"2\"], \",\", \"\[Ellipsis]\"}], \")\"}]\). "
DirectedEdges::usage = "DirectedEdges is an option for GraphPlot and related functions which specifies whether edges should by default be drawn as directed arrows, or as undirected lines."
DirectedInfinity::usage = "\!\(\*RowBox[{\"DirectedInfinity\", \"[\", \"]\"}]\) represents an infinite numerical quantity whose direction in the complex plane is unknown. \n\!\(\*RowBox[{\"DirectedInfinity\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) represents an infinite numerical quantity that is a positive real multiple of the complex number \!\(\*StyleBox[\"z\", \"TI\"]\). "
Direction::usage = "Direction is an option for Limit that specifies the direction in which the limit is taken."
Directive::usage = "\!\(\*RowBox[{\"Directive\", \"[\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) represents a single graphics directive composed of the directives \!\(\*SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\)."
DirectoryName::usage = "\!\(\*RowBox[{\"DirectoryName\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) extracts the directory name from the specification for a file. "
Directory::usage = "\!\(\*RowBox[{\"Directory\", \"[\", \"]\"}]\) gives the current working directory. "
DirectoryStack::usage = "\!\(\*RowBox[{\"DirectoryStack\", \"[\", \"]\"}]\) gives the directory stack which represents the sequence of current directories used. "
DiscreteDelta::usage = "\!\(\*RowBox[{\"DiscreteDelta\", \"[\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the discrete delta function \!\(\*RowBox[{\"\[Delta]\", RowBox[{\"(\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", \"\[Ellipsis]\"}], \")\"}]}]\), equal to 1 if all the \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) are zero, and 0 otherwise. "
DiscreteUniformDistribution::usage = "\!\(\*RowBox[{\"DiscreteUniformDistribution\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TR\"]]}], \"}\"}], \"]\"}]\) represents a discrete uniform distribution over the integers from \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TR\"]]\) to \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TR\"]]\)."
Discriminant::usage = "\!\(\*RowBox[{\"Discriminant\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", StyleBox[\"var\", \"TI\"]}], \"]\"}]\) computes the discriminant of the polynomial \!\(\*StyleBox[\"poly\", \"TI\"]\) with respect to the variable \!\(\*StyleBox[\"var\", \"TI\"]\).\n\!\(\*RowBox[{\"Discriminant\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", StyleBox[\"var\", \"TI\"], \",\", RowBox[{\"Modulus\", \"->\", StyleBox[\"p\", \"TI\"]}]}], \"]\"}]\) computes the discriminant modulo p."
Disk::usage = "\!\(\*RowBox[{\"Disk\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) is a two\[Hyphen]dimensional graphics primitive that represents a filled disk of radius \!\(\*StyleBox[\"r\", \"TI\"]\) centered at the point \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"y\", \"TI\"]\). \n\!\(\*RowBox[{\"Disk\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \"]\"}]\) gives a disk of radius 1. \n\!\(\*RowBox[{\"Disk\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"r\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[\"\[Theta]\", StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[\"\[Theta]\", StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) gives a segment of a disk. \n\!\(\*RowBox[{\"Disk\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives an elliptical disk with semi\[Hyphen]axes of lengths \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"x\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"y\", \"TI\"]]\), oriented parallel to the coordinate axes. "
Dispatch::usage = "\!\(\*RowBox[{\"Dispatch\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"lhs\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"rhs\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"lhs\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"rhs\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates an optimized dispatch table representation of a list of rules. The object produced by Dispatch can be used to give the rules in \!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \"/.\", StyleBox[\"rules\", \"TI\"]}]\). "
DisplayAllSteps::usage = "DisplayAllSteps is an option to Animate and related functions which specifies whether all frames should be displayed in an animation, even if to do so would slow the animation down."
DisplayEndPacket::usage = "\!\(\*RowBox[{\"DisplayEndPacket\", \"[\", \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet that indicates the end of a series of expressions relating to a postscript graphic."
DisplayForm::usage = "\!\(\*RowBox[{\"DisplayForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints with low-level boxes inside \!\(\*StyleBox[\"expr\", \"TI\"]\) shown in explicit two\[Hyphen]dimensional or other form. "
DisplayFunction::usage = "DisplayFunction is an option for graphics and sound functions that specifies a function to apply to graphics and sound objects before returning them."
Display::usage = "\!\(\*RowBox[{\"Display\", \"[\", RowBox[{StyleBox[\"channel\", \"TI\"], \",\", StyleBox[\"graphics\", \"TI\"]}], \"]\"}]\) writes graphics or sound to the specified output channel in PostScript format. \n\!\(\*RowBox[{\"Display\", \"[\", RowBox[{StyleBox[\"channel\", \"TI\"], \",\", StyleBox[\"graphics\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"format\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) writes graphics or sound in the specified format. \n\!\(\*RowBox[{\"Display\", \"[\", RowBox[{StyleBox[\"channel\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"format\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) writes boxes, cells or notebook expressions in the specified format. "
DisplayPacket::usage = "\!\(\*RowBox[{\"DisplayPacket\", \"[\", \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet that indicates the beginning of a series of expressions related to a postscript graphic."
DisplayString::usage = "\!\(\*RowBox[{\"DisplayString\", \"[\", StyleBox[\"graphics\", \"TI\"], \"]\"}]\) generates a string giving graphics or sound in PostScript format. \n\!\(\*RowBox[{\"DisplayString\", \"[\", RowBox[{StyleBox[\"graphics\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"format\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) generates a string giving graphics or sound in the specified format. \n\!\(\*RowBox[{\"DisplayString\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"format\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) generates a string giving boxes, cells or notebook expressions in the specified format. "
DistanceFunction::usage = "DistanceFunction is an option for functions such as Nearest that specifies the distance value to assume between any two specified points."
Distribute::usage = "\!\(\*RowBox[{\"Distribute\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}], \"]\"}]\) distributes \!\(\*StyleBox[\"f\", \"TI\"]\) over Plus appearing in any of the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Distribute\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"g\", \"TI\"]}], \"]\"}]\) distributes over \!\(\*StyleBox[\"g\", \"TI\"]\). \n\!\(\*RowBox[{\"Distribute\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) performs the distribution only if the head of \!\(\*StyleBox[\"expr\", \"TI\"]\) is \!\(\*StyleBox[\"f\", \"TI\"]\). "
DivideBy::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"/=\", StyleBox[\"c\", \"TI\"]}]\) divides \!\(\*StyleBox[\"x\", \"TI\"]\) by \!\(\*StyleBox[\"c\", \"TI\"]\) and returns the new value of \!\(\*StyleBox[\"x\", \"TI\"]\). "
Divide::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"/\", StyleBox[\"y\", \"TI\"]}]\) or \!\(\*RowBox[{\"Divide\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) is equivalent to \!\(\*RowBox[{\"x\", \" \", RowBox[{\"y\", \"^\", RowBox[{\"-\", \"1\"}]}]}]\). "
Dividers::usage = "Dividers is an option for Grid and related constructs that specifies where and how to draw divider lines."
Divisible::usage = "\!\(\*RowBox[{\"Divisible\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) yields True if \!\(\*StyleBox[\"n\", \"TI\"]\) is divisible by \!\(\*StyleBox[\"m\", \"TI\"]\), and yields False if it is not. "
DivisorSigma::usage = "\!\(\*RowBox[{\"DivisorSigma\", \"[\", RowBox[{StyleBox[\"k\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the divisor function \!\(\*RowBox[{SubscriptBox[\"\[Sigma]\", \"k\"], \"(\", \"n\", \")\"}]\). "
Divisors::usage = "\!\(\*RowBox[{\"Divisors\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives a list of the integers that divide \!\(\*StyleBox[\"n\", \"TI\"]\). "
D::usage = "\!\(\*RowBox[{\"D\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the partial derivative \!\(\*RowBox[{\"\[PartialD]\", \"f\", \"/\", \"\[PartialD]\", \"x\"}]\). \n\!\(\*RowBox[{\"D\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives the multiple derivative \!\(\*RowBox[{SuperscriptBox[\"\[PartialD]\", \"n\"], \"f\", \"/\", \"\[PartialD]\", SuperscriptBox[\"x\", \"n\"]}]\). \n\!\(\*RowBox[{\"D\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) differentiates f successively with respect to \!\(\*RowBox[{\"x\", \",\", \"y\", \",\", \"\[Ellipsis]\"}]\).\n\!\(\*RowBox[{\"D\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"}\"}]}], \"]\"}]\) for a scalar f gives the vector derivative \!\(\*RowBox[{\"(\", RowBox[{RowBox[{\"\[PartialD]\", RowBox[{\"f\", \"/\", RowBox[{\"\[PartialD]\", SubscriptBox[\"x\", \"1\"]}]}]}], \",\", RowBox[{\"\[PartialD]\", RowBox[{\"f\", \"/\", RowBox[{\"\[PartialD]\", SubscriptBox[\"x\", \"2\"]}]}]}], \",\", \"\[Ellipsis]\"}], \")\"}]\). "
DockedCells::usage = "DockedCells is an option for notebooks which gives a list of cells that are to be displayed \"docked\" at the top of the notebook."
DocumentNotebook::usage = "\!\(\*RowBox[{\"DocumentNotebook\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents a complete document notebook in the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) front end. "
Do::usage = "\!\(\*RowBox[{\"Do\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \"}\"}]}], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\) \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) times. \n\!\(\*RowBox[{\"Do\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\) with the variable \!\(\*StyleBox[\"i\", \"TI\"]\) successively taking on the values 1 through \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) (in steps of 1). \n\!\(\*RowBox[{\"Do\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) starts with \!\(\*RowBox[{StyleBox[\"i\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]]}]\). \n\!\(\*RowBox[{\"Do\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"di\", \"TI\"]}], \"}\"}]}], \"]\"}]\) uses steps \!\(\*StyleBox[\"di\", \"TI\"]\). \n\!\(\*RowBox[{\"Do\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"}\"}]}], \"]\"}]\) uses the successive values \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\).\n\!\(\*RowBox[{\"Do\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"j\", \"TI\"], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\) looping over different values of \!\(\*StyleBox[\"j\", \"TI\"]\), etc. for each \!\(\*StyleBox[\"i\", \"TI\"]\). "
DOSTextFormat::usage = "DOSTextFormat is an option for OpenRead, OpenWrite, and OpenAppend that specifies whether files should be opened in text mode. With \!\(\*RowBox[{\"DOSTextFormat\", \" \", \"->\", \" \", \"True\"}]\), \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) uses the normal text format for the type of computer on which \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) is running. Text mode typically entails translation of a text file's line-ending characters into the newline character \"\\n\". With \!\(\*RowBox[{\"DOSTextFormat\", \" \", \"->\", \" \", \"False\"}]\), files are opened in \"binary mode\", in which no such translation is performed. On some systems, there is no difference between text mode and binary mode."
DotDashed::usage = "DotDashed is a graphics directive that specifies that lines which follow should be drawn dot-dashed."
DotEqual::usage = "\!\(\*RowBox[{\"DotEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[DotEqual]\", StyleBox[\"y\", \"TI\"], \"\[DotEqual]\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\)."
Dot::usage = "\!\(\*RowBox[{StyleBox[\"a\", \"TI\"], \".\", StyleBox[\"b\", \"TI\"], \".\", StyleBox[\"c\", \"TI\"]}]\) or \!\(\*RowBox[{\"Dot\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"c\", \"TI\"]}], \"]\"}]\) gives products of vectors, matrices and tensors. "
Dotted::usage = "Dotted is a graphics directive that specifies that lines which follow should be drawn dotted."
DoubleBracketingBar::usage = "\!\(\*RowBox[{\"DoubleBracketingBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"\[LeftDoubleBracketingBar]\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", \"\[Ellipsis]\"}], \"\[RightDoubleBracketingBar]\"}]\)."
DoubleDownArrow::usage = "\!\(\*RowBox[{\"DoubleDownArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[DoubleDownArrow]\", StyleBox[RowBox[{StyleBox[\"y\", \"TI\"], StyleBox[\"\[Ellipsis]\", \"TR\"]}]]}]\)."
DoubleLeftArrow::usage = "\!\(\*RowBox[{\"DoubleLeftArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DoubleLeftArrow]\", \"y\", \"\[DoubleLeftArrow]\", \"\[Ellipsis]\"}]\)."
DoubleLeftRightArrow::usage = "\!\(\*RowBox[{\"DoubleLeftRightArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DoubleLeftRightArrow]\", \"y\", \"\[DoubleLeftRightArrow]\", \"\[Ellipsis]\"}]\)."
DoubleLeftTee::usage = "\!\(\*RowBox[{\"DoubleLeftTee\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DoubleLeftTee]\", \"y\"}]\)."
DoubleLongLeftArrow::usage = "\!\(\*RowBox[{\"DoubleLongLeftArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DoubleLongLeftArrow]\", \"y\", \"\[DoubleLongLeftArrow]\", \"\[Ellipsis]\"}]\)."
DoubleLongLeftRightArrow::usage = "\!\(\*RowBox[{\"DoubleLongLeftRightArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DoubleLongLeftRightArrow]\", \"y\", \"\[DoubleLongLeftRightArrow]\", \"\[Ellipsis]\"}]\)."
DoubleLongRightArrow::usage = "\!\(\*RowBox[{\"DoubleLongRightArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DoubleLongRightArrow]\", \"y\", \"\[DoubleLongRightArrow]\", \"\[Ellipsis]\"}]\)."
DoubleRightArrow::usage = "\!\(\*RowBox[{\"DoubleRightArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DoubleRightArrow]\", \"y\", \"\[DoubleRightArrow]\", \"\[Ellipsis]\"}]\)."
DoubleRightTee::usage = "\!\(\*RowBox[{\"DoubleRightTee\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DoubleRightTee]\", \"y\"}]\)."
DoubleUpArrow::usage = "\!\(\*RowBox[{\"DoubleUpArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DoubleUpArrow]\", \"y\", \"\[DoubleUpArrow]\", \"\[Ellipsis]\"}]\)."
DoubleUpDownArrow::usage = "\!\(\*RowBox[{\"DoubleUpDownArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DoubleUpDownArrow]\", \"y\", \"\[DoubleUpDownArrow]\", \"\[Ellipsis]\"}]\)."
DoubleVerticalBar::usage = "\!\(\*RowBox[{\"DoubleVerticalBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DoubleVerticalBar]\", \"y\", \"\[DoubleVerticalBar]\", \"\[Ellipsis]\"}]\)."
DoublyInfinite::usage = "DoublyInfinite is an option for LerchPhi. With \!\(\*RowBox[{\"DoublyInfinite\", \" \", \"->\", \" \", \"True\"}]\), the summation is taken from -Infinity to Infinity. With \!\(\*RowBox[{\"DoublyInfinite\", \" \", \"->\", \" \", \"False\"}]\), the summation is taken from zero to Infinity."
DownArrowBar::usage = "\!\(\*RowBox[{\"DownArrowBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DownArrowBar]\", \"y\", \"\[DownArrowBar]\", \"\[Ellipsis]\"}]\)."
DownArrow::usage = "\!\(\*RowBox[{\"DownArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DownArrow]\", \"y\", \"\[DownArrow]\", \"\[Ellipsis]\"}]\)."
DownArrowUpArrow::usage = "\!\(\*RowBox[{\"DownArrowUpArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[DownArrowUpArrow]\", StyleBox[\"y\", \"TI\"], \"\[DownArrowUpArrow]\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\)."
DownLeftRightVector::usage = "\!\(\*RowBox[{\"DownLeftRightVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DownLeftRightVector]\", \"y\", \"\[DownLeftRightVector]\", \"\[Ellipsis]\"}]\)."
DownLeftTeeVector::usage = "\!\(\*RowBox[{\"DownLeftTeeVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DownLeftTeeVector]\", \"y\", \"\[DownLeftTeeVector]\", \"\[Ellipsis]\"}]\)."
DownLeftVectorBar::usage = "\!\(\*RowBox[{\"DownLeftVectorBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DownLeftVectorBar]\", \"y\", \"\[DownLeftVectorBar]\", \"\[Ellipsis]\"}]\)."
DownLeftVector::usage = "\!\(\*RowBox[{\"DownLeftVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[DownLeftVector]\", StyleBox[\"y\", \"TI\"], \"\[DownLeftVector]\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\)."
DownRightTeeVector::usage = "\!\(\*RowBox[{\"DownRightTeeVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DownRightTeeVector]\", \"y\", \"\[DownRightTeeVector]\", \"\[Ellipsis]\"}]\)."
DownRightVectorBar::usage = "\!\(\*RowBox[{\"DownRightVectorBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DownRightVectorBar]\", \"y\", \"\[DownRightVectorBar]\", \"\[Ellipsis]\"}]\)."
DownRightVector::usage = "\!\(\*RowBox[{\"DownRightVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DownRightVector]\", \"y\", \"\[DownRightVector]\", \"\[Ellipsis]\"}]\)."
DownTeeArrow::usage = "\!\(\*RowBox[{\"DownTeeArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DownTeeArrow]\", \"y\", \"\[DownTeeArrow]\", \"\[Ellipsis]\"}]\)."
DownTee::usage = "\!\(\*RowBox[{\"DownTee\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[DownTee]\", \"y\"}]\)."
DownValues::usage = "\!\(\*RowBox[{\"DownValues\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) gives a list of transformation rules corresponding to all downvalues defined for the symbol \!\(\*StyleBox[\"f\", \"TI\"]\). "
DragAndDrop::usage = "DragAndDrop is an option for Cell which specifies whether to allow drag\[Hyphen]and\[Hyphen]drop editing on the contents of the cell. "
Drop::usage = "\!\(\*RowBox[{\"Drop\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives \!\(\*StyleBox[\"list\", \"TI\"]\) with its first \!\(\*StyleBox[\"n\", \"TI\"]\) elements dropped. \n\!\(\*RowBox[{\"Drop\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"-\", StyleBox[\"n\", \"TI\"]}]}], \"]\"}]\) gives \!\(\*StyleBox[\"list\", \"TI\"]\) with its last \!\(\*StyleBox[\"n\", \"TI\"]\) elements dropped. \n\!\(\*RowBox[{\"Drop\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", StyleBox[\"n\", \"TI\"], \"}\"}]}], \"]\"}]\) gives \!\(\*StyleBox[\"list\", \"TI\"]\) with its \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) element dropped. \n\!\(\*RowBox[{\"Drop\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives \!\(\*StyleBox[\"list\", \"TI\"]\) with elements \!\(\*StyleBox[\"m\", \"TI\"]\) through \!\(\*StyleBox[\"n\", \"TI\"]\) dropped. \n\!\(\*RowBox[{\"Drop\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives \!\(\*StyleBox[\"list\", \"TI\"]\) with elements \!\(\*StyleBox[\"m\", \"TI\"]\) through \!\(\*StyleBox[\"n\", \"TI\"]\) in steps of \!\(\*StyleBox[\"s\", \"TI\"]\) dropped. \n\!\(\*RowBox[{\"Drop\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", SubscriptBox[StyleBox[\"seq\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"seq\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives a nested list in which elements specified by \!\(\*SubscriptBox[StyleBox[\"seq\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) have been dropped at level \!\(\*StyleBox[\"i\", \"TI\"]\) in \!\(\*StyleBox[\"list\", \"TI\"]\). "
DSolve::usage = "\!\(\*RowBox[{\"DSolve\", \"[\", RowBox[{StyleBox[\"eqn\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) solves a differential equation for the function \!\(\*StyleBox[\"y\", \"TI\"]\), with independent variable\[NonBreakingSpace]\!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"DSolve\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"eqn\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"eqn\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) solves a list of differential equations. \n\!\(\*RowBox[{\"DSolve\", \"[\", RowBox[{StyleBox[\"eqn\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) solves a partial differential equation. "
Dt::usage = "\!\(\*RowBox[{\"Dt\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the total derivative \!\(\*RowBox[{StyleBox[\"d\", \"TI\"], StyleBox[\"f\", \"TI\"], \"/\", StyleBox[\"d\", \"TI\"], StyleBox[\"x\", \"TI\"]}]\). \n\!\(\*RowBox[{\"Dt\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) gives the total differential \!\(\*StyleBox[RowBox[{\"d\", \"f\"}], \"TI\"]\). \n\!\(\*RowBox[{\"Dt\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives the multiple derivative \!\(\*RowBox[{SuperscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"n\", \"TI\"]], StyleBox[\"f\", \"TI\"], \"/\", StyleBox[\"d\", \"TI\"], SuperscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"n\", \"TI\"]]}]\). \n\!\(\*RowBox[{\"Dt\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives \!\(\*RowBox[{StyleBox[\"d\", \"TI\"], \"/\", RowBox[{StyleBox[\"d\", \"TI\"], SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \" \", RowBox[{StyleBox[\"d\", \"TI\"], \"/\", StyleBox[\"d\", \"TI\"]}], SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \" \", \"\[Ellipsis]\", \" \", \"f\"}]}]\). "
DumpGet::usage = "\!\(\*RowBox[{\"DumpGet\", \"[\", \" \", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"filename\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) reads in a file saved with DumpSave."
DumpSave::usage = "\!\(\*RowBox[{\"DumpSave\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\).mx\\\"\",ShowStringCharacters->True], \",\", StyleBox[\"symbol\", \"TI\"]}], \"]\"}]\) writes definitions associated with a symbol to a file in internal \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) format. \n\!\(\*RowBox[{\"DumpSave\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\).mx\\\"\",ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"context\\\",\\\"TI\\\"]\\)`\\\"\", ShowStringCharacters->True]}], \"]\"}]\) writes out definitions associated with all symbols in the specified context. \n\!\(\*RowBox[{\"DumpSave\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\).mx\\\"\",ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"object\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"object\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) writes out definitions for several symbols or contexts. \n\!\(\*RowBox[{\"DumpSave\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"package\\\",\\\"TI\\\"]\\)`\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"objects\", \"TI\"]}], \"]\"}]\) chooses the name of the output file based on the computer system used. "
DynamicModule::usage = "\!\(\*RowBox[{\"DynamicModule\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) represents an object which maintains the same local instance of the symbols \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"y\", \"TI\"]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\) in the course of all evaluations of Dynamic objects in \!\(\*StyleBox[\"expr\", \"TI\"]\). Symbols specified in a DynamicModule will by default have their values maintained even across \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) sessions. \n\!\(\*RowBox[{\"DynamicModule\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{StyleBox[\"x\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \",\", RowBox[{StyleBox[\"y\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) specifies initial values for \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"y\", \"TI\"]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\). "
DynamicModuleValues::usage = "DynamicModuleValues is an option for DynamicModule which stores downvalues of local symbols."
Dynamic::usage = "\!\(\*RowBox[{\"Dynamic\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) represents an object that displays as the dynamically updated current value of \!\(\*StyleBox[\"expr\", \"TI\"]\). If the displayed form of \!\(\*RowBox[{\"Dynamic\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) is interactively changed or edited, an assignment \!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \"=\", StyleBox[\"val\", \"TI\"]}]\) is done to give \!\(\*StyleBox[\"expr\", \"TI\"]\) the new value \!\(\*StyleBox[\"val\", \"TI\"]\) that corresponds to the displayed form. \n\!\(\*RowBox[{\"Dynamic\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", \"None\"}], \"]\"}]\) does not allow interactive changing or editing. \n\!\(\*RowBox[{\"Dynamic\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) continually evaluates \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{StyleBox[\"val\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) during interactive changing or editing of \!\(\*StyleBox[\"val\", \"TI\"]\). \n\!\(\*RowBox[{\"Dynamic\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"end\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) also evaluates \!\(\*RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"end\", \"TI\"]], \"[\", RowBox[{StyleBox[\"val\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) when interactive changing or editing is complete. \n\!\(\*RowBox[{\"Dynamic\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"start\", \"TI\"]], \",\", StyleBox[\"f\", \"TI\"], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"end\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) also evaluates \!\(\*RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"start\", \"TI\"]], \"[\", RowBox[{StyleBox[\"val\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) when interactive changing or editing begins. "
DynamicSetting::usage = "\!\(\*RowBox[{\"DynamicSetting\", \"[\", StyleBox[\"e\", \"TI\"], \"]\"}]\) represents an object which displays as \!\(\*StyleBox[\"e\", \"TI\"]\), but is interpreted as the dynamically updated current value of \!\(\*RowBox[{\"Setting\", \"[\", StyleBox[\"e\", \"TI\"], \"]\"}]\) if supplied as \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) input.\n\!\(\*RowBox[{\"DynamicSetting\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"e\", \"TI\"]}], \"]\"}]\) displays as e, but is interpreted as \!\(\*RowBox[{\"f\", \"(\", \"e\", \")\"}]\) if supplied as input."
EdgeForm::usage = "\!\(\*RowBox[{\"EdgeForm\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) is a graphics directive which specifies that edges of polygons and other filled graphics objects are to be drawn using the graphics directive or list of directives \!\(\*StyleBox[\"g\", \"TI\"]\). "
EdgeLabeling::usage = "EdgeLabeling is an option for GraphPlot and related functions which specifies whether labeling specified for edges should be displayed by default."
EdgeRenderingFunction::usage = "EdgeRenderingFunction is an option for GraphPlot and related functions which gives a function to generate the graphics primitives to use in rendering each edge."
Editable::usage = "Editable is an option for displayed objects, cells and notebooks which specifies whether their contents can be edited interactively using the front end. "
EditCellTagsSettings::usage = "\!\(\*RowBox[{\"EditCellTagsSettings\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}]}], \"}\"}]}]\) is a global option that specifies settings for the \!\(\*StyleBox[\"Edit Cell Tags\", \"DialogElementName\"]\) dialog box."
EditDefinition::usage = "\!\(\*RowBox[{\"EditDefinition\", \"[\", RowBox[{StyleBox[\"syms\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) lets you edit the rules attached to the symbols \!\(\*RowBox[{StyleBox[\"syms\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\)."
EditDistance::usage = "\!\(\*RowBox[{\"EditDistance\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the edit or Levenshtein distance between strings or vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
EditIn::usage = "\!\(\*RowBox[{\"EditIn\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) lets you edit input lines \!\(\*RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\). \!\(\*RowBox[{\"EditIn\", \"[\", \"]\"}]\) edits the previous input line."
Edit::usage = "\!\(\*RowBox[{\"Edit\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) lets you edit the expressions \!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\)."
Eigensystem::usage = "\!\(\*RowBox[{\"Eigensystem\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives a list \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"values\", \"TI\"], \",\", StyleBox[\"vectors\", \"TI\"]}], \"}\"}]\) of the eigenvalues and eigenvectors of the square matrix \!\(\*StyleBox[\"m\", \"TI\"]\). \n\!\(\*RowBox[{\"Eigensystem\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the generalized eigenvalues and eigenvectors of \!\(\*StyleBox[\"m\", \"TI\"]\) with respect to\[NonBreakingSpace]\!\(\*StyleBox[\"a\", \"TI\"]\). \n\!\(\*RowBox[{\"Eigensystem\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the eigenvalues and eigenvectors for the first \!\(\*StyleBox[\"k\", \"TI\"]\) eigenvalues of \!\(\*StyleBox[\"m\", \"TI\"]\). \n\!\(\*RowBox[{\"Eigensystem\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the first \!\(\*StyleBox[\"k\", \"TI\"]\) generalized eigenvalues and eigenvectors."
Eigenvalues::usage = "\!\(\*RowBox[{\"Eigenvalues\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives a list of the eigenvalues of the square matrix m. \n\!\(\*RowBox[{\"Eigenvalues\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the generalized eigenvalues of m with respect to a. \n\!\(\*RowBox[{\"Eigenvalues\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the first k eigenvalues of m. \n\!\(\*RowBox[{\"Eigenvalues\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the first k generalized eigenvalues."
Eigenvectors::usage = "\!\(\*RowBox[{\"Eigenvectors\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives a list of the eigenvectors of the square matrix \!\(\*StyleBox[\"m\", \"TI\"]\). \n\!\(\*RowBox[{\"Eigenvectors\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the generalized eigenvectors of \!\(\*StyleBox[\"m\", \"TI\"]\) with respect to \!\(\*StyleBox[\"a\", \"TI\"]\). \n\!\(\*RowBox[{\"Eigenvectors\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the first \!\(\*StyleBox[\"k\", \"TI\"]\) eigenvectors of \!\(\*StyleBox[\"m\", \"TI\"]\). \n\!\(\*RowBox[{\"Eigenvectors\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the first \!\(\*StyleBox[\"k\", \"TI\"]\) generalized eigenvectors."
ElementData::usage = "\!\(\*RowBox[{\"ElementData\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the value of the specified property for the chemical element \"\!\(\*\nStyleBox[\"name\", \"TI\"]\)\".\n\!\(\*RowBox[{\"ElementData\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the specified property for the \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) chemical element."
Element::usage = "\!\(\*RowBox[{\"Element\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"dom\", \"TI\"]}], \"]\"}]\) or \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], StyleBox[\"\[Element]\", \"TR\"], StyleBox[\"dom\", \"TI\"]}]\) asserts that \!\(\*StyleBox[\"x\", \"TI\"]\) is an element of the domain \!\(\*StyleBox[\"dom\", \"TI\"]\). \n\!\(\*RowBox[{\"Element\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"dom\", \"TI\"]}], \"]\"}]\) asserts that all the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) are elements of \!\(\*StyleBox[\"dom\", \"TI\"]\). \n\!\(\*RowBox[{\"Element\", \"[\", RowBox[{StyleBox[\"patt\", \"TI\"], \",\", StyleBox[\"dom\", \"TI\"]}], \"]\"}]\) asserts that any expression matching the pattern \!\(\*StyleBox[\"patt\", \"TI\"]\) is an element of \!\(\*StyleBox[\"dom\", \"TI\"]\). "
Eliminate::usage = "\!\(\*RowBox[{\"Eliminate\", \"[\", RowBox[{StyleBox[\"eqns\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"]}], \"]\"}]\) eliminates variables between a set of simultaneous equations. "
EliminationOrder::usage = "EliminationOrder represents the elimination ordering of monomials."
EllipticE::usage = "\!\(\*RowBox[{\"EllipticE\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the complete elliptic integral \!\(\*RowBox[{\"E\", \"(\", \"m\", \")\"}]\). \n\!\(\*RowBox[{\"EllipticE\", \"[\", RowBox[{StyleBox[\"\[Phi]\", \"TR\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the elliptic integral of the second kind \!\(\*RowBox[{\"E\", \"(\", RowBox[{RowBox[{\"\[Phi]\", \"\[VerticalSeparator]\"}], \"m\"}], \")\"}]\). "
EllipticExp::usage = "\!\(\*RowBox[{\"EllipticExp\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"}\"}]}], \"]\"}]\) is the inverse for EllipticLog. It produces a list \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}]\) such that \!\(\*RowBox[{StyleBox[\"u\", \"TI\"], \"==\", RowBox[{\"EllipticLog\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"}\"}]}], \"]\"}]}]\). "
EllipticExpPrime::usage = "\!\(\*RowBox[{\"EllipticExpPrime\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives the derivative of \!\(\*RowBox[{\"EllipticExp\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"}\"}]}], \"]\"}]\) with respect to \!\(\*StyleBox[\"u\", \"TI\"]\)."
EllipticF::usage = "\!\(\*RowBox[{\"EllipticF\", \"[\", RowBox[{StyleBox[\"\[Phi]\", \"TR\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the elliptic integral of the first kind \!\(\*RowBox[{\"F\", \"(\", RowBox[{\"\[Phi]\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\). "
EllipticK::usage = "\!\(\*RowBox[{\"EllipticK\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the complete elliptic integral of the first kind \!\(\*RowBox[{\"K\", \"(\", \"m\", \")\"}]\). "
EllipticLog::usage = "\!\(\*RowBox[{\"EllipticLog\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives the generalized logarithm associated with the elliptic curve \!\(\*RowBox[{SuperscriptBox[\"y\", \"2\"], \"=\", RowBox[{SuperscriptBox[\"x\", \"3\"], \"+\", RowBox[{\"a\", \" \", SuperscriptBox[\"x\", \"2\"]}], \"+\", RowBox[{\"b\", \" \", \"x\"}]}]}]\). "
EllipticNomeQ::usage = "\!\(\*RowBox[{\"EllipticNomeQ\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the nome \!\(\*StyleBox[\"q\", \"TI\"]\) corresponding to the parameter \!\(\*StyleBox[\"m\", \"TI\"]\) in an elliptic function. "
EllipticPi::usage = "\!\(\*RowBox[{\"EllipticPi\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the complete elliptic integral of the third kind \!\(\*RowBox[{StyleBox[\"\[CapitalPi]\", \"TR\"], RowBox[{\"(\", RowBox[{StyleBox[\"n\", \"TI\"], \"\[VerticalSeparator]\", StyleBox[\"m\", \"TI\"]}], \")\"}]}]\). \n\!\(\*RowBox[{\"EllipticPi\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"\[Phi]\", \"TR\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the incomplete elliptic integral \!\(\*RowBox[{StyleBox[\"\[CapitalPi]\", \"TR\"], RowBox[{\"(\", RowBox[{StyleBox[\"n\", \"TI\"], \";\", RowBox[{StyleBox[\"\[Phi]\", \"TR\"], \"\[VerticalSeparator]\", StyleBox[\"m\", \"TI\"]}]}], \")\"}]}]\). "
EllipticReducedHalfPeriods::usage = "\!\(\*RowBox[{\"EllipticReducedHalfPeriods\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", \" \", StyleBox[\"v\", \"TI\"]}], \"}\"}], \"]\"}]\) gives a reduced pair of half periods \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"w\", \"TI\"], \",\", \" \", RowBox[{StyleBox[\"w\", \"TI\"], \"'\"}]}], \"}\"}]\) corresponding to the same lattice as that of \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", \" \", StyleBox[\"v\", \"TI\"]}], \"}\"}]\)."
EllipticTheta::usage = "\!\(\*RowBox[{\"EllipticTheta\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"]}], \"]\"}]\) gives the theta function \!\(\*RowBox[{SubscriptBox[\"\[CurlyTheta]\", \"a\"], \"(\", RowBox[{\"u\", \",\", \"q\"}], \")\"}]\) (\!\(\*RowBox[{RowBox[{\"a\", \"=\", \"1\"}], \",\", \"\[Ellipsis]\", \",\", \"4\"}]\)). "
EllipticThetaPrime::usage = "\!\(\*RowBox[{\"EllipticThetaPrime\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"]}], \"]\"}]\) gives the derivative with respect to \!\(\*StyleBox[\"u\", \"TI\"]\) of the theta function \!\(\*RowBox[{SubscriptBox[\"\[CurlyTheta]\", \"a\"], \"(\", RowBox[{\"u\", \",\", \"q\"}], \")\"}]\) (\!\(\*RowBox[{RowBox[{\"a\", \"=\", \"1\"}], \",\", \"\[Ellipsis]\", \",\", \"4\"}]\)). "
EmitSound::usage = "\!\(\*RowBox[{\"EmitSound\", \"[\", StyleBox[\"snd\", \"TI\"], \"]\"}]\) emits the sound \!\(\*StyleBox[\"snd\", \"TI\"]\) when evaluated. \n\!\(\*RowBox[{\"EmitSound\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"snd\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"snd\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) emits each of the sounds \!\(\*SubscriptBox[StyleBox[\"snd\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) in sequence. "
Enabled::usage = "Enabled is an option for objects such as Slider which specifies whether the objects should be enabled for interactive manipulation. "
E::usage = "E is the exponential constant \!\(\*StyleBox[\"e\", \"TI\"]\) (base of natural logarithms), with numerical value \!\(\*RowBox[{\"\[TildeEqual]\", \"2.71828\"}]\). "
Encode::usage = "\!\(\*RowBox[{\"Encode\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"source\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"dest\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) writes an encoded version of the file \!\(\*StyleBox[\"source\", \"TI\"]\) to the file \!\(\*StyleBox[\"dest\", \"TI\"]\). \n\!\(\*RowBox[{\"<<\", StyleBox[\"dest\", \"TI\"]}]\) decodes the file before reading its contents. \n\!\(\*RowBox[{\"Encode\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"source\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"dest\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"key\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) produces an encoded file which must be read in using \!\(\*RowBox[{\"Get\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"dest\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"key\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\). "
EndAdd::usage = "\!\(\*RowBox[{\"EndAdd\", \"[\", \" \", \"]\"}]\) returns the present context, and reverts to the previous one, prepending the present context to $ContextPath."
EndDialogPacket::usage = "\!\(\*RowBox[{\"EndDialogPacket\", \"[\", StyleBox[\"integer\", \"TI\"], \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet indicating the end of the Dialog subsession referenced by \!\(\*StyleBox[\"integer\", \"TI\"]\)."
End::usage = "\!\(\*RowBox[{\"End\", \"[\", \"]\"}]\) returns the present context, and reverts to the previous one. "
EndOfFile::usage = "EndOfFile is a symbol returned by Read when it reaches the end of a file. "
EndOfLine::usage = "EndOfLine represents the end of a line in a string for purposes of matching in StringExpression."
EndOfString::usage = "EndOfString represents the end of a string for purposes of matching in StringExpression."
EndPackage::usage = "\!\(\*RowBox[{\"EndPackage\", \"[\", \"]\"}]\) restores $Context and $ContextPath to their values before the preceding BeginPackage, and prepends the current context to the list $ContextPath. "
EngineeringForm::usage = "\!\(\*RowBox[{\"EngineeringForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints with all real numbers in \!\(\*StyleBox[\"expr\", \"TI\"]\) given in engineering notation. \n\!\(\*RowBox[{\"EngineeringForm\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) prints with numbers given to \!\(\*StyleBox[\"n\", \"TI\"]\)\[Hyphen]digit precision. "
EnterExpressionPacket::usage = "\!\(\*RowBox[{\"EnterExpressionPacket\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet request the evaluation of \!\(\*StyleBox[\"expr\", \"TI\"]\)."
EnterTextPacket::usage = "\!\(\*RowBox[{\"EnterTextPacket\", \"[\", StyleBox[\"string\", \"TI\"], \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet that requests the parsing and evaluation of \!\(\*StyleBox[\"string\", \"TI\"]\) as an expression."
Environment::usage = "\!\(\*RowBox[{\"Environment\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"var\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the value of an operating system environment variable. "
Epilog::usage = "Epilog is an option for graphics functions which gives a list of graphics primitives to be rendered after the main part of the graphics is rendered. "
EqualColumns::usage = "EqualColumns is an option to GridBox which specifies whether the size of the columns are all set to the size of the largest column. The default value of EqualColumns is False."
Equal::usage = "\!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"==\", StyleBox[\"rhs\", \"TI\"]}]\) returns True if \!\(\*StyleBox[\"lhs\", \"TI\"]\) and \!\(\*StyleBox[\"rhs\", \"TI\"]\) are identical. "
EqualRows::usage = "EqualRows is an option to GridBox which specifies whether the size of the rows are all set to the size of the largest row. The default value of EqualRows is False."
EqualTilde::usage = "\!\(\*RowBox[{\"EqualTilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[EqualTilde]\", \"y\", \"\[EqualTilde]\", \"\[Ellipsis]\"}]\)."
EquatedTo::usage = "EquatedTo is an option for Roots, which specifies an expression to use in place of the variable in the solution."
Equilibrium::usage = "\!\(\*RowBox[{\"Equilibrium\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Equilibrium]\", \"y\", \"\[Equilibrium]\", \"\[Ellipsis]\"}]\)."
Erfc::usage = "\!\(\*RowBox[{\"Erfc\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the complementary error function \!\(\*RowBox[{\"erfc\", \"(\", \"z\", \")\"}]\). "
Erfi::usage = "\!\(\*RowBox[{\"Erfi\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the imaginary error function \!\(\*RowBox[{RowBox[{\"erf\", \"(\", RowBox[{\"i\", \"\[InvisibleSpace]\", \"z\"}], \")\"}], \"/\", \"i\"}]\). "
Erf::usage = "\!\(\*RowBox[{\"Erf\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the error function \!\(\*RowBox[{\"erf\", \"(\", \"z\", \")\"}]\). \n\!\(\*RowBox[{\"Erf\", \"[\", RowBox[{SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"]\"}]\) gives the generalized error function \!\(\*RowBox[{RowBox[{\"erf\", \"(\", SubscriptBox[\"z\", \"1\"], \")\"}], \"-\", RowBox[{\"erf\", \"(\", SubscriptBox[\"z\", \"0\"], \")\"}]}]\). "
ErrorBox::usage = "\!\(\*RowBox[{ErrorBox, \"[\", StyleBox[\"boxes\", \"TI\"], \"]\"}]\) is a low-level box construct that represents boxes that cannot be interpreted in input or output. "
ErrorBoxOptions::usage = "\!\(\*RowBox[{ErrorBoxOptions, \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) applies options and corresponding values."
EuclideanDistance::usage = "\!\(\*RowBox[{\"EuclideanDistance\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the Euclidean distance between vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
EulerE::usage = "\!\(\*RowBox[{\"EulerE\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the Euler number \!\(\*SubscriptBox[\"E\", \"n\"]\). \n\!\(\*RowBox[{\"EulerE\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the Euler polynomial \!\(\*RowBox[{SubscriptBox[\"E\", \"n\"], \"(\", \"x\", \")\"}]\). "
EulerGamma::usage = "EulerGamma is Euler\[CloseCurlyQuote]s constant \!\(\*StyleBox[\"\[Gamma]\", \"TR\"]\), with numerical value \!\(\*RowBox[{\"\[TildeEqual]\", \"0.577216\"}]\). "
EulerPhi::usage = "\!\(\*RowBox[{\"EulerPhi\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the Euler totient function \!\(\*RowBox[{\"\[Phi]\", \"(\", \"n\", \")\"}]\). "
Evaluatable::usage = "Evaluatable is an option for Cell which specifies whether a cell should be used as input to be evaluated by the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) kernel. "
Evaluate::usage = "\!\(\*RowBox[{\"Evaluate\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) causes \!\(\*StyleBox[\"expr\", \"TI\"]\) to be evaluated even if it appears as the argument of a function whose attributes specify that it should be held unevaluated. "
EvaluatePacket::usage = "\!\(\*RowBox[{\"EvaluatePacket\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet requesting evaluation of \!\(\*StyleBox[\"expr\", \"TI\"]\)."
EvaluationCompletionAction::usage = "EvaluationCompletionAction is an option for notebooks that specifies the action taken when an evaluation is completed."
EvaluationMonitor::usage = "EvaluationMonitor is an option for various numerical computation and plotting functions that gives an expression to evaluate whenever functions derived from the input are evaluated numerically. "
EvaluationNotebook::usage = "\!\(\*RowBox[{\"EvaluationNotebook\", \"[\", \"]\"}]\) gives the notebook in which this function is being evaluated. "
EvaluatorNames::usage = "EvaluatorNames is a global option that specifies the kernels that are currently configured to perform evaluations."
Evaluator::usage = "Evaluator is an option for objects such as Button, Dynamic and Cell which gives the name of the kernel to use to evaluate their contents. "
EvenQ::usage = "\!\(\*RowBox[{\"EvenQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is an even integer, and False otherwise. "
EventHandler::usage = "\!\(\*RowBox[{\"EventHandler\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"event\", \"TI\"], StyleBox[\"1\", \"TR\"]], \":>\", SubscriptBox[StyleBox[\"action\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", \" \", RowBox[{SubscriptBox[StyleBox[\"event\", \"TI\"], StyleBox[\"2\", \"TR\"]], \":>\", SubscriptBox[StyleBox[\"action\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", \" \", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) displays as \!\(\*StyleBox[\"expr\", \"TI\"]\), evaluating \!\(\*SubscriptBox[StyleBox[\"action\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) whenever \"\!\(\*SubscriptBox[\nStyleBox[\"event\", \"TI\"], \nStyleBox[\"i\", \"TI\"]]\)\" occurs in connection with \!\(\*StyleBox[\"expr\", \"TI\"]\). "
ExactNumberQ::usage = "\!\(\*RowBox[{\"ExactNumberQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) returns True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is an exact real or complex number, and returns False otherwise."
ExactRootIsolation::usage = "ExactRootIsolation is an option for Root, which specifies whether exact isolating intervals rather then numeric approximations should be used to identify algebraic numbers."
ExampleData::usage = "\!\(\*RowBox[{\"ExampleData\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"type\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a list of names of examples of the specified type.\n\!\(\*RowBox[{\"ExampleData\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"type\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"}\"}], \"]\"}]\) gives the default form of the named example of the specified type.\n\!\(\*RowBox[{\"ExampleData\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"type\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"}\"}], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"elem\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the specified element or property of an example."
Except::usage = "\!\(\*RowBox[{\"Except\", \"[\", StyleBox[\"c\", \"TI\"], \"]\"}]\) is a pattern object which represents any expression except one that matches \!\(\*StyleBox[\"c\", \"TI\"]\). \n\!\(\*RowBox[{\"Except\", \"[\", RowBox[{StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) represents any expression that matches \!\(\*StyleBox[\"p\", \"TI\"]\) but not \!\(\*StyleBox[\"c\", \"TI\"]\). "
ExcludedForms::usage = "ExcludedForms is an option for FullSimplify which can be set to a list of patterns for expressions that should not be touched if they are encountered at intermediate steps in the operation of FullSimplify. "
Exclusions::usage = "Exclusions is an option that specifies where to exclude in regions used by functions like Plot, Plot3D and NIntegrate."
ExclusionsStyle::usage = "ExclusionsStyle is an option to plotting functions that specifies how to render subregions excluded according to Exclusions. "
Exists::usage = "\!\(\*RowBox[{\"Exists\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) represents the statement that there exists a value of x for which \!\(\*StyleBox[\"expr\", \"TI\"]\) is True. \n\!\(\*RowBox[{\"Exists\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"cond\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) states that there exists an x satisfying the condition \!\(\*StyleBox[\"cond\", \"TI\"]\) for which \!\(\*StyleBox[\"expr\", \"TI\"]\) is True. \n\!\(\*RowBox[{\"Exists\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) states that there exist values for all the \!\(\*SubscriptBox[\"x\", \"i\"]\) for which \!\(\*StyleBox[\"expr\", \"TI\"]\) is True. "
Exit::usage = "\!\(\*RowBox[{\"Exit\", \"[\", \"]\"}]\) terminates a \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) kernel session. "
ExpandAll::usage = "\!\(\*RowBox[{\"ExpandAll\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) expands out all products and integer powers in any part of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"ExpandAll\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"patt\", \"TI\"]}], \"]\"}]\) avoids expanding parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) that do not contain terms matching the pattern \!\(\*StyleBox[\"patt\", \"TI\"]\). "
ExpandDenominator::usage = "\!\(\*RowBox[{\"ExpandDenominator\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) expands out products and powers that appear as denominators in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Expand::usage = "\!\(\*RowBox[{\"Expand\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) expands out products and positive integer powers in \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Expand\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"patt\", \"TI\"]}], \"]\"}]\) leaves unexpanded any parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) that are free of the pattern \!\(\*StyleBox[\"patt\", \"TI\"]\). "
ExpandNumerator::usage = "\!\(\*RowBox[{\"ExpandNumerator\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) expands out products and powers that appear in the numerator of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
ExpectedValue::usage = "\!\(\*RowBox[{\"ExpectedValue\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"dist\", \"TI\"]}], \"]\"}]\) gives the expected value of the pure function \!\(\*StyleBox[\"f\", \"TI\"]\) with respect to the symbolic distribution \!\(\*StyleBox[\"dist\", \"TI\"]\).\n\!\(\*RowBox[{\"ExpectedValue\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"dist\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the expected value of the function \!\(\*StyleBox[\"f\", \"TI\"]\) of \!\(\*StyleBox[\"x\", \"TI\"]\) with respect to the symbolic distribution \!\(\*StyleBox[\"dist\", \"TI\"]\)."
ExpIntegralEi::usage = "\!\(\*RowBox[{\"ExpIntegralEi\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the exponential integral function \!\(\*RowBox[{\"Ei\", \"(\", \"z\", \")\"}]\). "
ExpIntegralE::usage = "\!\(\*RowBox[{\"ExpIntegralE\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the exponential integral function \!\(\*RowBox[{SubscriptBox[StyleBox[\"E\", \"TI\"], StyleBox[\"n\", \"TI\"]], RowBox[{\"(\", StyleBox[\"z\", \"TI\"], \")\"}]}]\). "
Exp::usage = "\!\(\*RowBox[{\"Exp\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) is the exponential function. "
ExponentFunction::usage = "ExponentFunction is an option for NumberForm and related functions which determines the exponent to use in printing approximate real numbers. "
ExponentialDistribution::usage = "\!\(\*RowBox[{\"ExponentialDistribution\", \"[\", StyleBox[\"\[Lambda]\", \"TR\"], \"]\"}]\) represents an exponential distribution with scale inversely proportional to parameter \[Lambda]."
ExponentialMovingAverage::usage = "\!\(\*RowBox[{\"ExponentialMovingAverage\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"\[Alpha]\", \"TR\"]}], \"]\"}]\) gives the exponential moving average of \!\(\*StyleBox[\"list\", \"TI\"]\) with smoothing constant \[Alpha]."
Exponent::usage = "\!\(\*RowBox[{\"Exponent\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) gives the maximum power with which \!\(\*StyleBox[\"form\", \"TI\"]\) appears in the expanded form of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Exponent\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"h\", \"TI\"]\) to the set of exponents with which \!\(\*StyleBox[\"form\", \"TI\"]\) appears in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
ExponentPosition::usage = "ExponentPosition is an option for RadicalBox that specifies the placement of the index outside a radical sign."
ExponentStep::usage = "ExponentStep is an option for NumberForm and related functions which determines in what steps exponents are taken to increase when scientific notation is used."
ExportAutoReplacements::usage = "ExportAutoReplacements is an option for cells that specifies which replacement rules \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) automatically applies when exporting text."
Export::usage = "\!\(\*RowBox[{\"Export\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\).\\!\\(\\*StyleBox[\\\"ext\\\",\\\"TI\\\"]\\)\\\"\",ShowStringCharacters->True], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) exports data to a file, converting it to the format corresponding to the file extension \!\(\*StyleBox[\"ext\", \"TI\"]\). \n\!\(\*RowBox[{\"Export\", \"[\", RowBox[{StyleBox[\"file\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"format\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) exports data in the specified format.\n\!\(\*RowBox[{\"Export\", \"[\", RowBox[{StyleBox[\"file\", \"TI\"], \",\", StyleBox[\"exprs\", \"TI\"], \",\", StyleBox[\"elems\", \"TI\"]}], \"]\"}]\) exports data by treating \!\(\*StyleBox[\"exprs\", \"TI\"]\) as elements specified by \!\(\*StyleBox[\"elems\", \"TI\"]\)."
ExportString::usage = "\!\(\*RowBox[{\"ExportString\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"format\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) generates a string corresponding to \!\(\*StyleBox[\"expr\", \"TI\"]\) exported in the specified format. \n\!\(\*RowBox[{\"ExportString\", \"[\", RowBox[{StyleBox[\"rules\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"format\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"Rules\\\"\",ShowStringCharacters->True]}], \"}\"}]}], \"]\"}]\) gives explicit rules for different elements of the data to be exported. \n\!\(\*RowBox[{\"ExportString\", \"[\", RowBox[{StyleBox[\"exprs\", \"TI\"], \",\", StyleBox[\"elems\", \"TI\"]}], \"]\"}]\) generates a string by treating \!\(\*StyleBox[\"exprs\", \"TI\"]\) as elements specified by \!\(\*StyleBox[\"elems\", \"TI\"]\)."
ExpressionCell::usage = "\!\(\*RowBox[{\"ExpressionCell\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives an expression cell that can appear in a \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) notebook. \n\!\(\*RowBox[{\"ExpressionCell\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"style\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives an expression cell with the specified style."
Expression::usage = "Expression is a symbol that represents an ordinary \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) expression in Read and related functions. "
ExpToTrig::usage = "\!\(\*RowBox[{\"ExpToTrig\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) converts exponentials in \!\(\*StyleBox[\"expr\", \"TI\"]\) to trigonometric functions. "
ExtendedGCD::usage = "\!\(\*RowBox[{\"ExtendedGCD\", \"[\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the extended greatest common divisor of the integers \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
Extension::usage = "Extension is an option for various polynomial and algebraic functions that specifies generators for the algebraic number field to be used. "
ExternalDataCharacterEncoding::usage = "ExternalDataCharacterEncoding is a global option that specifies the character encoding used in reading and writing plain text data outside of \!\(\*StyleBox[\"Mathematica\", \"IT\"]\)."
Extract::usage = "\!\(\*RowBox[{\"Extract\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"]}], \"]\"}]\) extracts the part of \!\(\*StyleBox[\"expr\", \"TI\"]\) at the position specified by \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Extract\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) extracts a list of parts of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Extract\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) extracts parts of \!\(\*StyleBox[\"expr\", \"TI\"]\), wrapping each of them with head \!\(\*StyleBox[\"h\", \"TI\"]\) before evaluation. "
ExtremeValueDistribution::usage = "\!\(\*RowBox[{\"ExtremeValueDistribution\", \"[\", RowBox[{StyleBox[\"\[Alpha]\", \"TR\"], \",\", StyleBox[\"\[Beta]\", \"TR\"]}], \"]\"}]\) represents an extreme value distribution with location parameter \!\(\*StyleBox[\"\[Alpha]\", \"TR\"]\) and scale parameter \!\(\*StyleBox[\"\[Beta]\", \"TR\"]\)."
FaceForm::usage = "\!\(\*RowBox[{\"FaceForm\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) is a graphics directive which specifies that faces of polygons and other filled graphics objects are to be drawn using the graphics directive or list of directives \!\(\*StyleBox[\"g\", \"TI\"]\). \n\!\(\*RowBox[{\"FaceForm\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"gback\", \"TI\"]}], \"]\"}]\) specifies that the front faces of three\[Hyphen]dimensional polygons should be drawn with directives \!\(\*StyleBox[\"g\", \"TI\"]\), and the backs with directives \!\(\*StyleBox[\"gback\", \"TI\"]\). "
FaceGrids::usage = "FaceGrids is an option for three\[Hyphen]dimensional graphics functions that specifies grid lines to draw on the faces of the bounding box. "
FaceGridsStyle::usage = "FaceGridsStyle is an option for 3D graphics functions that specifies how face grids should be rendered."
Factorial2::usage = "\!\(\*RowBox[{StyleBox[\"n\", \"TI\"], \"!!\"}]\) gives the double factorial of \!\(\*StyleBox[\"n\", \"TI\"]\). "
Factorial::usage = "\!\(\*RowBox[{StyleBox[\"n\", \"TI\"], \"!\"}]\) gives the factorial of \!\(\*StyleBox[\"n\", \"TI\"]\). "
FactorInteger::usage = "\!\(\*RowBox[{\"FactorInteger\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives a list of the prime factors of the integer \!\(\*StyleBox[\"n\", \"TI\"]\), together with their exponents. \n\!\(\*RowBox[{\"FactorInteger\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) does partial factorization, pulling out at most \!\(\*StyleBox[\"k\", \"TI\"]\) distinct factors."
FactorList::usage = "\!\(\*RowBox[{\"FactorList\", \"[\", StyleBox[\"poly\", \"TI\"], \"]\"}]\) gives a list of the factors of a polynomial, together with their exponents. "
Factor::usage = "\!\(\*RowBox[{\"Factor\", \"[\", StyleBox[\"poly\", \"TI\"], \"]\"}]\) factors a polynomial over the integers. \n\!\(\*RowBox[{\"Factor\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", RowBox[{\"Modulus\", \"->\", StyleBox[\"p\", \"TI\"]}]}], \"]\"}]\) factors a polynomial modulo a prime \!\(\*StyleBox[\"p\", \"TI\"]\). \n\!\(\*RowBox[{\"Factor\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", RowBox[{\"Extension\", \"->\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]}], \"]\"}]\) factors a polynomial allowing coefficients that are rational combinations of the algebraic numbers \!\(\*SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
FactorSquareFreeList::usage = "\!\(\*RowBox[{\"FactorSquareFreeList\", \"[\", StyleBox[\"poly\", \"TI\"], \"]\"}]\) gives a list of square\[Hyphen]free factors of a polynomial, together with their exponents. "
FactorSquareFree::usage = "\!\(\*RowBox[{\"FactorSquareFree\", \"[\", StyleBox[\"poly\", \"TI\"], \"]\"}]\) pulls out any multiple factors in a polynomial. "
FactorTermsList::usage = "\!\(\*RowBox[{\"FactorTermsList\", \"[\", StyleBox[\"poly\", \"TI\"], \"]\"}]\) gives a list in which the first element is the overall numerical factor in \!\(\*StyleBox[\"poly\", \"TI\"]\), and the second element is the polynomial with the overall factor removed.\n\!\(\*RowBox[{\"FactorTermsList\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a list of factors of \!\(\*StyleBox[\"poly\", \"TI\"]\). The first element in the list is the overall numerical factor. The second element is a factor that does not depend on any of the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). Subsequent elements are factors which depend on progressively more of the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
FactorTerms::usage = "\!\(\*RowBox[{\"FactorTerms\", \"[\", StyleBox[\"poly\", \"TI\"], \"]\"}]\) pulls out any overall numerical factor in \!\(\*StyleBox[\"poly\", \"TI\"]\). \n\!\(\*RowBox[{\"FactorTerms\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) pulls out any overall factor in \!\(\*StyleBox[\"poly\", \"TI\"]\) that does not depend on \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"FactorTerms\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) pulls out any overall factor in \!\(\*StyleBox[\"poly\", \"TI\"]\) that does not depend on any of the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
False::usage = "False is the symbol for the Boolean value false. "
Fibonacci::usage = "\!\(\*RowBox[{\"Fibonacci\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the Fibonacci number \!\(\*SubscriptBox[\"F\", \"n\"]\). \n\!\(\*RowBox[{\"Fibonacci\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the Fibonacci polynomial \!\(\*RowBox[{SubscriptBox[\"F\", \"n\"], \"(\", \"x\", \")\"}]\). "
FieldSize::usage = "FieldSize is an option for InputField, PopupMenu and related functions, which specifies the size of the field allowed for input or contents. "
FileByteCount::usage = "\!\(\*RowBox[{\"FileByteCount\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the number of bytes in a file. "
FileDate::usage = "\!\(\*RowBox[{\"FileDate\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the date and time at which a file was last modified. "
FileFormat::usage = "\!\(\*RowBox[{\"FileFormat\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) attempts to determine what Import format could be used to import the file or URL corresponding to \"\!\(\*\nStyleBox[\"name\", \"TI\"]\)\". "
FileHash::usage = "\!\(\*RowBox[{\"FileHash\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives an integer hash code for the contents of the specified file.\n\!\(\*RowBox[{\"FileHash\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"type\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives an integer hash of the specified type."
FileInformation::usage = "\!\(\*RowBox[{\"FileInformation\", \"[\", StyleBox[\"file\", \"TI\"], \"]\"}]\) gives information about a file."
FileNameDialogSettings::usage = "\!\(\*RowBox[{\"FileNameDialogSettings\", \"->\", RowBox[{\"{\", RowBox[{StyleBox[\"opt\", \"TI\"], \"->\", StyleBox[\"val\", \"TI\"]}], \"}\"}]}]\) is a global option that specifies settings for the \!\(\*StyleBox[\"Insert File Path\", \"DialogElementName\"]\) dialog box."
FileNameSetter::usage = "\!\(\*RowBox[{\"FileNameSetter\", \"[\", StyleBox[\"name\", \"TI\"], \"]\"}]\) represents a file name setter which displays as a \!\(\*StyleBox[\"Browse\", \"MenuName\"]\) button and when clicked brings up a system file opening dialog, starting from the location corresponding to \!\(\*StyleBox[\"name\", \"TI\"]\). \n\!\(\*RowBox[{\"FileNameSetter\", \"[\", RowBox[{\"Dynamic\", \"[\", StyleBox[\"name\", \"TI\"], \"]\"}], \"]\"}]\) uses the dynamically updated current value of \!\(\*StyleBox[\"name\", \"TI\"]\), with the value of \!\(\*StyleBox[\"name\", \"TI\"]\) being reset if a different file is chosen.\n\!\(\*RowBox[{\"FileNameSetter\", \"[\", RowBox[{StyleBox[\"name\", \"TI\"], \",\", StyleBox[\"\\\"Save\\\"\",ShowStringCharacters->True]}], \"]\"}]\) brings up a file saving dialog.\n\!\(\*RowBox[{\"FileNameSetter\", \"[\", RowBox[{StyleBox[\"name\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"spec\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"type\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \",\", RowBox[{SubscriptBox[StyleBox[\"type\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", RowBox[{\"{\", StyleBox[\"\[Ellipsis]\", \"TR\"], \"}\"}]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) looks for files of types \!\(\*SubscriptBox[StyleBox[\"type\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) with names matching the file patterns \!\(\*SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"ij\", \"TI\"]]\). "
FileNames::usage = "\!\(\*RowBox[{\"FileNames\", \"[\", \"]\"}]\) lists all files in the current working directory. \n\!\(\*RowBox[{\"FileNames\", \"[\", StyleBox[\"form\", \"TI\"], \"]\"}]\) lists all files in the current working directory whose names match the string pattern \!\(\*StyleBox[\"form\", \"TI\"]\). \n\!\(\*RowBox[{\"FileNames\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"form\", \"TI\"], \"1\"], \",\", SubscriptBox[StyleBox[\"form\", \"TI\"], \"2\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) lists all files whose names match any of the \!\(\*SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"FileNames\", \"[\", RowBox[{StyleBox[\"forms\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"dir\", \"TI\"], \"1\"], \",\", SubscriptBox[StyleBox[\"dir\", \"TI\"], \"2\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) lists files with names matching \!\(\*StyleBox[\"forms\", \"TI\"]\) in any of the directories \!\(\*SubscriptBox[StyleBox[\"dir\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"FileNames\", \"[\", RowBox[{StyleBox[\"forms\", \"TI\"], \",\", StyleBox[\"dirs\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) includes files that are in subdirectories up to \!\(\*StyleBox[\"n\", \"TI\"]\) levels down. "
FilePrint::usage = "\!\(\*RowBox[{\"FilePrint\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) prints out the raw textual contents of \!\(\*StyleBox[\"file\", \"TI\"]\)."
FileType::usage = "\!\(\*RowBox[{\"FileType\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the type of a file, typically File, Directory, or None. "
Filling::usage = "Filling is an option for ListPlot, Plot, Plot3D and related functions which specifies what filling to add under points, curves and surfaces. "
FillingStyle::usage = "FillingStyle is an option for ListPlot, Plot, Plot3D and related functions that specifies the default style of filling to be used. "
FilterRules::usage = "\!\(\*RowBox[{\"FilterRules\", \"[\", RowBox[{StyleBox[\"rules\", \"TI\"], \",\", StyleBox[\"patt\", \"TI\"]}], \"]\"}]\) filters the list \!\(\*StyleBox[\"rules\", \"TI\"]\) by picking out only those rules whose left-hand sides match \!\(\*StyleBox[\"patt\", \"TI\"]\).\n\!\(\*RowBox[{\"FilterRules\", \"[\", RowBox[{StyleBox[\"rules\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) picks out rules whose left-hand sides match any of the \!\(\*SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
FinancialData::usage = "\!\(\*RowBox[{\"FinancialData\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the last known price or value for the financial entity specified by \"\!\(\*\nStyleBox[\"name\", \"TI\"]\)\".\n\!\(\*RowBox[{\"FinancialData\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"start\", \"TI\"]}], \"]\"}]\) gives a list of dates and daily closing values for \"\!\(\*\nStyleBox[\"name\", \"TI\"]\)\" from \!\(\*StyleBox[\"start\", \"TI\"]\) until the current date.\n\!\(\*RowBox[{\"FinancialData\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"start\", \"TI\"], \",\", StyleBox[\"end\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives a list of dates and daily closing values for dates from \!\(\*StyleBox[\"start\", \"TI\"]\) to \!\(\*StyleBox[\"end\", \"TI\"]\).\n\!\(\*RowBox[{\"FinancialData\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"start\", \"TI\"], \",\", StyleBox[\"end\", \"TI\"], \",\", StyleBox[\"period\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives a list of dates and prices for the specified periods lying between \!\(\*StyleBox[\"start\", \"TI\"]\) and \!\(\*StyleBox[\"end\", \"TI\"]\). \n\!\(\*RowBox[{\"FinancialData\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"prop\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the value of the specified property for the financial entity \"\!\(\*\nStyleBox[\"name\", \"TI\"]\)\". \n\!\(\*RowBox[{\"FinancialData\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"prop\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"start\", \"TI\"], \",\", StyleBox[\"end\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a list of dates and values of a property for a sequence of dates or periods. "
FindClusters::usage = "\!\(\*RowBox[{\"FindClusters\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) partitions the \!\(\*SubscriptBox[\"e\", \"i\"]\) into clusters of similar elements. \n\!\(\*RowBox[{\"FindClusters\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) returns the \!\(\*SubscriptBox[\"v\", \"i\"]\) corresponding to the \!\(\*SubscriptBox[\"e\", \"i\"]\) in each cluster. \n\!\(\*RowBox[{\"FindClusters\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"->\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the same result. \n\!\(\*RowBox[{\"FindClusters\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) partitions the \!\(\*SubscriptBox[\"e\", \"i\"]\) into exactly n clusters. "
FindFit::usage = "\!\(\*RowBox[{\"FindFit\", \"[\", RowBox[{StyleBox[\"data\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"pars\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"]}], \"]\"}]\) finds numerical values of the parameters \!\(\*StyleBox[\"pars\", \"TI\"]\) that make \!\(\*StyleBox[\"expr\", \"TI\"]\) give a best fit to \!\(\*StyleBox[\"data\", \"TI\"]\) as a function of \!\(\*StyleBox[\"vars\", \"TI\"]\). The data can have the form \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\), where the number of coordinates \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"y\", \"TI\"]\), \[Ellipsis] is equal to the number of variables in the list \!\(\*StyleBox[\"vars\", \"TI\"]\). The data can also be of the form \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\), with a single coordinate assumed to take values 1, 2, \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\). \n\!\(\*RowBox[{\"FindFit\", \"[\", RowBox[{StyleBox[\"data\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"cons\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"pars\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"]}], \"]\"}]\) finds a best fit subject to the parameter constraints \!\(\*StyleBox[\"cons\", \"TI\"]\)."
FindInstance::usage = "\!\(\*RowBox[{\"FindInstance\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"]}], \"]\"}]\) finds an instance of \!\(\*StyleBox[\"vars\", \"TI\"]\) that makes the statement \!\(\*StyleBox[\"expr\", \"TI\"]\) be True. \n\!\(\*RowBox[{\"FindInstance\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"], \",\", StyleBox[\"dom\", \"TI\"]}], \"]\"}]\) finds an instance over the domain \!\(\*StyleBox[\"dom\", \"TI\"]\). Common choices of \!\(\*StyleBox[\"dom\", \"TI\"]\) are Complexes, Reals, Integers and Booleans. \n\!\(\*RowBox[{\"FindInstance\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"], \",\", StyleBox[\"dom\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) finds \!\(\*StyleBox[\"n\", \"TI\"]\) instances. "
FindList::usage = "\!\(\*RowBox[{\"FindList\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"text\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives a list of lines in the file that contain the specified string. \n\!\(\*RowBox[{\"FindList\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"text\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"text\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a list of all lines that contain any of the specified strings. \n\!\(\*RowBox[{\"FindList\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"file\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives a list of lines containing the specified strings in any of the \!\(\*SubscriptBox[StyleBox[\"file\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"FindList\", \"[\", RowBox[{StyleBox[\"files\", \"TI\"], \",\", StyleBox[\"text\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) includes only the first \!\(\*StyleBox[\"n\", \"TI\"]\) lines found. "
FindMaximum::usage = "\!\(\*RowBox[{\"FindMaximum\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) searches for a local maximum in \!\(\*StyleBox[\"f\", \"TI\"]\), starting from the point \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}]\). \n\!\(\*RowBox[{\"FindMaximum\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) searches for a local maximum in a function of several variables. \n\!\(\*RowBox[{\"FindMaximum\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"cons\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) searches for a local maximum subject to the constraints \!\(\*StyleBox[\"cons\", \"TI\"]\).\n\!\(\*RowBox[{\"FindMaximum\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"cons\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) starts from a point within the region defined by the constraints."
FindMinimum::usage = "\!\(\*RowBox[{\"FindMinimum\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) searches for a local minimum in \!\(\*StyleBox[\"f\", \"TI\"]\), starting from the point \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}]\). \n\!\(\*RowBox[{\"FindMinimum\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) searches for a local minimum in a function of several variables. \n\!\(\*RowBox[{\"FindMinimum\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"cons\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) searches for a local minimum subject to the constraints \!\(\*StyleBox[\"cons\", \"TI\"]\).\n\!\(\*RowBox[{\"FindMinimum\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"cons\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) starts from a point within the region defined by the constraints."
Find::usage = "\!\(\*RowBox[{\"Find\", \"[\", RowBox[{StyleBox[\"stream\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"text\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) finds the first line in an input stream that contains the specified string. \n\!\(\*RowBox[{\"Find\", \"[\", RowBox[{StyleBox[\"stream\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"text\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"text\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) finds the first line that contains any of the specified strings. "
FindRoot::usage = "\!\(\*RowBox[{\"FindRoot\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) searches for a numerical root of \!\(\*StyleBox[\"f\", \"TI\"]\), starting from the point \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}]\).\n\!\(\*RowBox[{\"FindRoot\", \"[\", RowBox[{RowBox[{StyleBox[\"lhs\", \"TI\"], \"==\", StyleBox[\"rhs\", \"TI\"]}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) searches for a numerical solution to the equation \!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"==\", StyleBox[\"rhs\", \"TI\"]}]\). \n\!\(\*RowBox[{\"FindRoot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) searches for a simultaneous numerical root of all the \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"i\", \"TI\"]]\).\n\!\(\*RowBox[{\"FindRoot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"eqn\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"eqn\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) searches for a numerical solution to the simultaneous equations \!\(\*SubscriptBox[StyleBox[\"eqn\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
FindSettings::usage = "\!\(\*RowBox[{\"FindSettings\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is a global option that specifies settings for the \!\(\*StyleBox[\"Find\", \"MenuName\"]\) dialog box."
FindShortestTour::usage = "\!\(\*RowBox[{\"FindShortestTour\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) attempts to find an ordering of the \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) that minimizes the total distance on a tour that visits all the \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) once."
FinishDynamic::usage = "\!\(\*RowBox[{\"FinishDynamic\", \"[\", \"]\"}]\) finishes updating and displaying all currently visible Dynamic objects. "
First::usage = "\!\(\*RowBox[{\"First\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the first element in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Fit::usage = "\!\(\*RowBox[{\"Fit\", \"[\", RowBox[{StyleBox[\"data\", \"TI\"], \",\", StyleBox[\"funs\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"]}], \"]\"}]\) finds a least\[Hyphen]squares fit to a list of data as a linear combination of the functions \!\(\*StyleBox[\"funs\", \"TI\"]\) of variables \!\(\*StyleBox[\"vars\", \"TI\"]\). "
FixedPointList::usage = "\!\(\*RowBox[{\"FixedPointList\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) generates a list giving the results of applying \!\(\*StyleBox[\"f\", \"TI\"]\) repeatedly, starting with \!\(\*StyleBox[\"expr\", \"TI\"]\), until the results no longer change. "
FixedPoint::usage = "\!\(\*RowBox[{\"FixedPoint\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) starts with \!\(\*StyleBox[\"expr\", \"TI\"]\), then applies \!\(\*StyleBox[\"f\", \"TI\"]\) repeatedly until the result no longer changes. "
Flat::usage = "Flat is an attribute that can be assigned to a symbol \!\(\*StyleBox[\"f\", \"TI\"]\) to indicate that all expressions involving nested functions \!\(\*StyleBox[\"f\", \"TI\"]\) should be flattened out. This property is accounted for in pattern matching. "
FlattenAt::usage = "\!\(\*RowBox[{\"FlattenAt\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) flattens out a sublist that appears as the \!\(\*SuperscriptBox[StyleBox[RowBox[{StyleBox[\"n\", \"TI\"], \"\[Null]\"}]], \"th\"]\) element of \!\(\*StyleBox[\"list\", \"TI\"]\). If \!\(\*StyleBox[\"n\", \"TI\"]\) is negative, the position is counted from the end. \n\!\(\*RowBox[{\"FlattenAt\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) flattens out the part of \!\(\*StyleBox[\"expr\", \"TI\"]\) at position \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\). \n\!\(\*RowBox[{\"FlattenAt\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) flattens out parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) at several positions. "
Flatten::usage = "\!\(\*RowBox[{\"Flatten\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) flattens out nested lists. \n\!\(\*RowBox[{\"Flatten\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) flattens to level \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"Flatten\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) flattens subexpressions with head \!\(\*StyleBox[\"h\", \"TI\"]\). \n\!\(\*RowBox[{\"Flatten\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"21\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"22\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) flattens \!\(\*StyleBox[\"list\", \"TI\"]\) by combining all levels \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"ij\", \"TI\"]]\) to make each level \!\(\*StyleBox[\"i\", \"TI\"]\) in the result. "
FlipView::usage = "\!\(\*RowBox[{\"FlipView\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \"]\"}]\) represents an object which flips between displaying \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) each time it is clicked.\n\!\(\*RowBox[{\"FlipView\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) cyclically flips through successive \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\).\n\!\(\*RowBox[{\"FlipView\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"i\", \"TI\"]}], \"]\"}]\) makes \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) be the object currently displayed."
Floor::usage = "\!\(\*RowBox[{\"Floor\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives the greatest integer less than or equal to \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"Floor\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"]\"}]\) gives the greatest multiple of \!\(\*StyleBox[\"a\", \"TI\"]\) less than or equal to \!\(\*StyleBox[\"x\", \"TI\"]\). "
FoldList::usage = "\!\(\*RowBox[{\"FoldList\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"]\"}], \",\", RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"]\"}], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\). "
Fold::usage = "\!\(\*RowBox[{\"Fold\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"]}], \"]\"}]\) gives the last element of \!\(\*RowBox[{\"FoldList\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"]}], \"]\"}]\). "
FontColor::usage = "FontColor is an option for Style, Cell and related constructs which specifies the default color in which to render text. "
FontFamily::usage = "FontFamily is an option for Style and Cell which specifies the font family in which text should be rendered. "
FontName::usage = "FontName is an option to StyleBox which changes the current font family and face. A sample specification of FontName is \!\(\*RowBox[{\"FontName\", \" \", \"->\", \" \", RowBox[{\"Times\", \"-\", \"Roman\"}]}]\). The default value of FontName is Automatic."
FontPostScriptName::usage = "FontPostScriptName is an option to StyleBox which changes the current font. A sample specification is \!\(\*RowBox[{\"FontPostScriptName\", \" \", \"->\", \" \", RowBox[{\"Times\", \"-\", \"Roman\"}]}]\). The default value is Automatic."
FontProperties::usage = "\!\(\*RowBox[{\"FontProperties\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}]}], \"}\"}]}]\) specifies font properties."
FontSize::usage = "FontSize is an option for Style and Cell which specifies the default size in printer\[CloseCurlyQuote]s points of the font in which to render text. "
FontSlant::usage = "FontSlant is an option for Style, Cell and related constructs which specifies how slanted characters in text should be. "
FontSubstitutions::usage = "FontSubstitutions is an option for Style and Cell which gives a list of substitutions to try for font family names. "
FontTracking::usage = "FontTracking is an option for Style and Cell which specifies how condensed or expanded you want the font in which text is rendered to be. "
FontVariations::usage = "FontVariations is an option for Style, Cell and related constructs which specifies what font variations should be used."
FontWeight::usage = "FontWeight is an option for Style, Cell and related constructs which specifies how heavy the characters in a font should be. "
ForAll::usage = "\!\(\*RowBox[{\"ForAll\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) represents the statement that \!\(\*StyleBox[\"expr\", \"TI\"]\) is True for all values of x. \n\!\(\*RowBox[{\"ForAll\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"cond\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) states that \!\(\*StyleBox[\"expr\", \"TI\"]\) is True for all \!\(\*StyleBox[\"x\", \"TI\"]\) satisfying the condition \!\(\*StyleBox[\"cond\", \"TI\"]\). \n\!\(\*RowBox[{\"ForAll\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) states that \!\(\*StyleBox[\"expr\", \"TI\"]\) is True for all values of all the \!\(\*SubscriptBox[\"x\", \"i\"]\). "
Format::usage = "\!\(\*RowBox[{\"Format\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints as the formatted form of \!\(\*StyleBox[\"expr\", \"TI\"]\). Assigning values to \!\(\*RowBox[{\"Format\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) defines print forms for expressions. \n\!\(\*RowBox[{\"Format\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) gives a format for the specified form of output. "
FormatTypeAutoConvert::usage = "FormatTypeAutoConvert is an option for cells that specifies whether the contents of a cell are automatically converted into a different format when the style of that cell is changed."
FormatType::usage = "FormatType is an option for output streams, graphics and functions such as Text which specifies the default format type to use when outputting expressions. "
FormatValues::usage = "\!\(\*RowBox[{\"FormatValues\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) gives a list of transformation rules corresponding to all printing formats (values for \!\(\*RowBox[{\"Format\", \"[\", RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\), etc.) defined for the symbol \!\(\*StyleBox[\"f\", \"TI\"]\)."
FormBox::usage = "\!\(\*RowBox[{FormBox, \"[\", RowBox[{StyleBox[\"boxes\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) is a low-level box construct which displays as \!\(\*StyleBox[\"boxes\", \"TI\"]\) but specifies that rules associated with \!\(\*StyleBox[\"form\", \"TI\"]\) should be used to interpret \!\(\*StyleBox[\"boxes\", \"TI\"]\) on input. "
FormBoxOptions::usage = "\!\(\*RowBox[{FormBoxOptions, \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}]}], \"}\"}]}]\) is an option for cells that specifies settings for FormBox objects within the cell."
For::usage = "\!\(\*RowBox[{\"For\", \"[\", RowBox[{StyleBox[\"start\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"], \",\", StyleBox[\"incr\", \"TI\"], \",\", StyleBox[\"body\", \"TI\"]}], \"]\"}]\) executes \!\(\*StyleBox[\"start\", \"TI\"]\), then repeatedly evaluates \!\(\*StyleBox[\"body\", \"TI\"]\) and \!\(\*StyleBox[\"incr\", \"TI\"]\) until \!\(\*StyleBox[\"test\", \"TI\"]\) fails to give True. "
FortranForm::usage = "\!\(\*RowBox[{\"FortranForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints as a Fortran language version of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
ForwardBackward::usage = "ForwardBackward is a symbol that represents alternate forward and backward motion or animation."
Forward::usage = "Forward is a symbol that represents the forward direction for purposes of motion and animation."
FourierCosTransform::usage = "\!\(\*RowBox[{\"FourierCosTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"\[Omega]\", \"TR\"]}], \"]\"}]\) gives the symbolic Fourier cosine transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"FourierCosTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"\[Omega]\", \"TR\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"\[Omega]\", \"TR\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the multidimensional Fourier cosine transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
FourierDCT::usage = "\!\(\*RowBox[{\"FourierDCT\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) finds the Fourier discrete cosine transform of a list of real numbers.\n\!\(\*RowBox[{\"FourierDCT\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) finds the Fourier discrete cosine transform of type m."
FourierDST::usage = "\!\(\*RowBox[{\"FourierDST\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) finds the Fourier discrete sine transform of a list of real numbers.\n\!\(\*RowBox[{\"FourierDST\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) finds the Fourier discrete sine transform of type m."
Fourier::usage = "\!\(\*RowBox[{\"Fourier\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) finds the discrete Fourier transform of a list of complex numbers. "
FourierParameters::usage = "FourierParameters is an option to Fourier and related functions that specifies the conventions to use in computing Fourier transforms."
FourierSinTransform::usage = "\!\(\*RowBox[{\"FourierSinTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"\[Omega]\", \"TR\"]}], \"]\"}]\) gives the symbolic Fourier sine transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"FourierSinTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"\[Omega]\", \"TR\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"\[Omega]\", \"TR\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the multidimensional Fourier sine transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
FourierTransform::usage = "\!\(\*RowBox[{\"FourierTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", \"\[Omega]\"}], \"]\"}]\) gives the symbolic Fourier transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"FourierTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[\"\[Omega]\", StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[\"\[Omega]\", StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the multidimensional Fourier transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
FractionalPart::usage = "\!\(\*RowBox[{\"FractionalPart\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives the fractional part of \!\(\*StyleBox[\"x\", \"TI\"]\). "
FractionBox::usage = "\!\(\*RowBox[{FractionBox, \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) is a low-level formatting construct that represents \!\(\*FractionBox[StyleBox[\"x\", \"TI\"], StyleBox[\"y\", \"TI\"]]\) in notebook expressions. "
FractionBoxOptions::usage = "\!\(\*RowBox[{FractionBoxOptions, \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for cells that specifies settings for FractionBox objects within the cell."
FractionLine::usage = "FractionLine is an option for fractions that specifies the thickness of the line separating the numerator and denominator."
FrameBox::usage = "\!\(\*RowBox[{FrameBox, \"[\", StyleBox[\"box\", \"TI\"], \"]\"}]\) is a low-level box construct which represents \!\(\*StyleBox[\"box\", \"TI\"]\) with a frame drawn around it. "
FrameBoxOptions::usage = "\!\(\*RowBox[{FrameBoxOptions, \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for cells that specifies default settings."
Framed::usage = "\!\(\*RowBox[{\"Framed\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays a framed version of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
FrameLabel::usage = "FrameLabel is an option for Graphics, Manipulate and related functions that specifies labels to be placed on the edges of a frame. "
FrameMargins::usage = "FrameMargins is an option for objects that can be displayed with frames which specifies the absolute margins in printer\[CloseCurlyQuote]s points to leave inside the frame. "
Frame::usage = "Frame is an option for Graphics, Grid and other constructs that specifies whether to include a frame. "
FrameStyle::usage = "FrameStyle is an option for Graphics, Grid and other constructs that specifies the style in which to draw frames."
FrameTicks::usage = "FrameTicks is an option for 2D graphics functions that specifies tick marks for the edges of a frame. "
FrameTicksStyle::usage = "FrameTicksStyle is an option for 2D graphics functions which specifies how frame ticks should be rendered."
FRatioDistribution::usage = "\!\(\*RowBox[{\"FRatioDistribution\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) represents an F-ratio distribution with \!\(\*StyleBox[\"n\", \"TI\"]\) numerator and \!\(\*StyleBox[\"m\", \"TI\"]\) denominator degrees of freedom."
FreeQ::usage = "\!\(\*RowBox[{\"FreeQ\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) yields True if no subexpression in \!\(\*StyleBox[\"expr\", \"TI\"]\) matches \!\(\*StyleBox[\"form\", \"TI\"]\), and yields False otherwise. \n\!\(\*RowBox[{\"FreeQ\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"]}], \"]\"}]\) tests only those parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) on levels specified by \!\(\*StyleBox[\"levelspec\", \"TI\"]\). "
FresnelC::usage = "\!\(\*RowBox[{\"FresnelC\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the Fresnel integral \!\(\*RowBox[{\"C\", \"(\", \"z\", \")\"}]\). "
FresnelS::usage = "\!\(\*RowBox[{\"FresnelS\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the Fresnel integral \!\(\*RowBox[{\"S\", \"(\", \"z\", \")\"}]\). "
FrobeniusNumber::usage = "\!\(\*RowBox[{\"FrobeniusNumber\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}], \"]\"}]\) gives the Frobenius number of \!\(\*RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"n\", \"TI\"]]}]\)."
FrobeniusSolve::usage = "\!\(\*RowBox[{\"FrobeniusSolve\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives a list of all solutions of the Frobenius equation \!\(\*RowBox[{RowBox[{RowBox[{SubscriptBox[\"a\", \"1\"], SubscriptBox[\"x\", \"1\"]}], \"+\", \"\[Ellipsis]\", \"+\", RowBox[{SubscriptBox[\"a\", \"n\"], SubscriptBox[\"x\", \"n\"]}]}], \"=\", \"b\"}]\).\n\!\(\*RowBox[{\"FrobeniusSolve\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives at most \!\(\*StyleBox[\"m\", \"TI\"]\) solutions."
FromCharacterCode::usage = "\!\(\*RowBox[{\"FromCharacterCode\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives a string consisting of the character with integer code \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"FromCharacterCode\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives a string consisting of the sequence of characters with codes \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"FromCharacterCode\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"21\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives a list of strings. \n\!\(\*RowBox[{\"FromCharacterCode\", \"[\", RowBox[{StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"encoding\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) uses the specified character encoding. "
FromContinuedFraction::usage = "\!\(\*RowBox[{\"FromContinuedFraction\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) reconstructs a number from the list of its continued fraction terms. "
FromDate::usage = "\!\(\*RowBox[{\"FromDate\", \"[\", StyleBox[\"date\", \"TI\"], \"]\"}]\) converts a date of the form \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"}\"}]\) to an absolute number of seconds since the beginning of January 1, 1900. "
FromDigits::usage = "\!\(\*RowBox[{\"FromDigits\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) constructs an integer from the list of its decimal digits. \n\!\(\*RowBox[{\"FromDigits\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) takes the digits to be given in base \!\(\*StyleBox[\"b\", \"TI\"]\). \n\!\(\*RowBox[{\"FromDigits\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) constructs an integer from a string of digits.\n\!\(\*RowBox[{\"FromDigits\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"Roman\\\"\",ShowStringCharacters->True]}], \"]\"}]\) constructs an integer from Roman numerals."
FrontEndEventActions::usage = "FrontEndEventActions is an option for the notebook front end that gives a list of actions to perform when specified user-interface events occur. "
FrontEndExecute::usage = "\!\(\*RowBox[{\"FrontEndExecute\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) sends \!\(\*StyleBox[\"expr\", \"TI\"]\) to be executed by the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) front end. "
FrontEndStackSize::usage = "FrontEndStackSize is a global option that specifies the size of the stack used to store data in the front end (Macintosh only)."
FrontEndTokenExecute::usage = "\!\(\*RowBox[{\"FrontEndTokenExecute\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"cmd\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) executes the specified front end command token, typically corresponding to a front end menu item. "
FrontEndToken::usage = "\!\(\*RowBox[{\"FrontEndToken\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"cmd\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) is an object which represents a front end command token, typically corresponding to a front end menu item, to be executed by FrontEndExecute. \n\!\(\*RowBox[{\"FrontEndToken\", \"[\", RowBox[{StyleBox[\"nb\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"cmd\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) represents a command which targets the specified notebook. \n\!\(\*RowBox[{\"FrontEndToken\", \"[\", RowBox[{StyleBox[\"nb\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"cmd\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"param\", \"TI\"]}], \"]\"}]\) represents a command with a parameter."
FullAxes::usage = "\!\(\*RowBox[{\"FullAxes\", \"[\", StyleBox[\"graphics\", \"TI\"], \"]\"}]\) returns the axes options of a graphics object."
FullDefinition::usage = "\!\(\*RowBox[{\"FullDefinition\", \"[\", StyleBox[\"symbol\", \"TI\"], \"]\"}]\) prints as the definitions given for \!\(\*StyleBox[\"symbol\", \"TI\"]\), and all symbols on which these depend. "
FullForm::usage = "\!\(\*RowBox[{\"FullForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints as the full form of \!\(\*StyleBox[\"expr\", \"TI\"]\), with no special syntax. "
FullGraphics::usage = "\!\(\*RowBox[{\"FullGraphics\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) takes a graphics object, and generates a new one in which objects specified by graphics options are given as explicit lists of graphics primitives. "
Full::usage = "Full is a setting used for certain options, typically indicating that a full range of values should be included. "
FullSimplify::usage = "\!\(\*RowBox[{\"FullSimplify\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) tries a wide range of transformations on \!\(\*StyleBox[\"expr\", \"TI\"]\) involving elementary and special functions, and returns the simplest form it finds. \n\!\(\*RowBox[{\"FullSimplify\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"assum\", \"TI\"]}], \"]\"}]\) does simplification using assumptions. "
FunctionExpand::usage = "\!\(\*RowBox[{\"FunctionExpand\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) tries to expand out special and certain other functions in \!\(\*StyleBox[\"expr\", \"TI\"]\), when possible reducing compound arguments to simpler ones. \n\!\(\*RowBox[{\"FunctionExpand\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"assum\", \"TI\"]}], \"]\"}]\) expands using assumptions. "
FunctionInterpolation::usage = "\!\(\*RowBox[{\"FunctionInterpolation\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\) with \!\(\*StyleBox[\"x\", \"TI\"]\) running from \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) and constructs an InterpolatingFunction object which represents an approximate function corresponding to the result. \n\!\(\*RowBox[{\"FunctionInterpolation\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) constructs an InterpolatingFunction object with several arguments. "
Function::usage = "\!\(\*RowBox[{\"Function\", \"[\", StyleBox[\"body\", \"TI\"], \"]\"}]\) or \!\(\*RowBox[{StyleBox[\"body\", \"TI\"], \"&\"}]\) is a pure function. The formal parameters are # (or #1), #2, etc. \n\!\(\*RowBox[{\"Function\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"body\", \"TI\"]}], \"]\"}]\) is a pure function with a single formal parameter \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"Function\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"body\", \"TI\"]}], \"]\"}]\) is a pure function with a list of formal parameters. "
GammaDistribution::usage = "\!\(\*RowBox[{\"GammaDistribution\", \"[\", RowBox[{StyleBox[\"\[Alpha]\", \"TR\"], \",\", StyleBox[\"\[Beta]\", \"TR\"]}], \"]\"}]\) represents a gamma distribution with shape parameter \!\(\*StyleBox[\"\[Alpha]\", \"TR\"]\) and scale parameter \!\(\*StyleBox[\"\[Beta]\", \"TR\"]\)."
Gamma::usage = "\!\(\*RowBox[{\"Gamma\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) is the Euler gamma function \!\(\*RowBox[{\"\[CapitalGamma]\", \"(\", \"z\", \")\"}]\). \n\!\(\*RowBox[{\"Gamma\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the plica function \!\(\*RowBox[{\"\[CapitalGamma]\", \"(\", RowBox[{\"a\", \",\", \"z\"}], \")\"}]\). \n\!\(\*RowBox[{\"Gamma\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"]\"}]\) is the generalized plica function \!\(\*RowBox[{RowBox[{\"\[CapitalGamma]\", \"(\", RowBox[{\"a\", \",\", SubscriptBox[\"z\", \"0\"]}], \")\"}], \"-\", RowBox[{\"\[CapitalGamma]\", \"(\", RowBox[{\"a\", \",\", SubscriptBox[\"z\", \"1\"]}], \")\"}]}]\). "
GammaRegularized::usage = "\!\(\*RowBox[{\"GammaRegularized\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the regularized incomplete gamma function \!\(\*RowBox[{\"Q\", \"(\", RowBox[{\"a\", \",\", \"z\"}], \")\"}]\). "
GaussianIntegers::usage = "GaussianIntegers is an option for FactorInteger, PrimeQ, Factor and related functions which specifies whether factorization should be done over Gaussian integers. "
GCD::usage = "\!\(\*RowBox[{\"GCD\", \"[\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the greatest common divisor of the integers \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
GegenbauerC::usage = "\!\(\*RowBox[{\"GegenbauerC\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the Gegenbauer polynomial \!\(\*RowBox[{SubsuperscriptBox[\"C\", \"n\", RowBox[{\"(\", \"m\", \")\"}]], \"(\", \"x\", \")\"}]\). \n\!\(\*RowBox[{\"GegenbauerC\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the renormalized form \!\(\*RowBox[{UnderscriptBox[\"lim\", RowBox[{\"m\", \"\[Rule]\", \"0\"}], LimitsPositioning -> True], RowBox[{RowBox[{SubsuperscriptBox[\"C\", \"n\", RowBox[{\"(\", \"m\", \")\"}]], \"(\", \"x\", \")\"}], \"/\", \"m\"}]}]\). "
General::usage = "General is a symbol to which general system messages are attached. "
GenerateConditions::usage = "GenerateConditions is an option for Integrate that specifies whether explicit conditions on parameters should be generated in the results of definite integrals. "
GeneratedCell::usage = "GeneratedCell is an option for Cell which indicates whether the cell was generated from the kernel. "
GeneratedParameters::usage = "GeneratedParameters is an option which specifies how parameters generated to represent the results of various symbolic operations should be named. "
GenericCylindricalDecomposition::usage = "\!\(\*RowBox[{\"GenericCylindricalDecomposition\", \"[\", RowBox[{StyleBox[\"ineqs\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) finds the full-dimensional part of the decomposition of the region represented by the inequalities \!\(\*StyleBox[\"ineqs\", \"TI\"]\) into cylindrical parts whose directions correspond to the successive \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\), together with any hypersurfaces containing the rest of the region."
Generic::usage = "Generic is a setting for the Mode option of Solve and related functions."
GeometricDistribution::usage = "\!\(\*RowBox[{\"GeometricDistribution\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) represents a geometric distribution with probability parameter \!\(\*StyleBox[\"p\", \"TI\"]\). "
GeometricMean::usage = "\!\(\*RowBox[{\"GeometricMean\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the geometric mean of the values in \!\(\*StyleBox[\"list\", \"TI\"]\)."
GeometricTransformation::usage = "\!\(\*RowBox[{\"GeometricTransformation\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"tfun\", \"TI\"]}], \"]\"}]\) represents the result of applying the transformation function \!\(\*StyleBox[\"tfun\", \"TI\"]\) to the geometric objects corresponding to the primitives \!\(\*StyleBox[\"g\", \"TI\"]\).\n\!\(\*RowBox[{\"GeometricTransformation\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) transforms geometric objects in \!\(\*StyleBox[\"g\", \"TI\"]\) by effectively replacing every point \!\(\*StyleBox[\"r\", \"TI\"]\) by \!\(\*RowBox[{StyleBox[\"m\", \"TI\"], \".\", StyleBox[\"r\", \"TI\"]}]\). \n\!\(\*RowBox[{\"GeometricTransformation\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"}\"}]}], \"]\"}]\) effectively replaces every point \!\(\*StyleBox[\"r\", \"TI\"]\) by \!\(\*RowBox[{RowBox[{StyleBox[\"m\", \"TI\"], \".\", StyleBox[\"r\", \"TI\"]}], \"+\", StyleBox[\"v\", \"TI\"]}]\)."
GetContext::usage = "\!\(\*RowBox[{\"GetContext\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"context`\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) loads the file named by \!\(\*RowBox[{\"ContextToFileName\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"context`\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\), which gives the conventional filename for a package that defines \"\!\(\*\nStyleBox[\"context`\", \"TI\"]\)\"."
Get::usage = "\!\(\*RowBox[{\"<<\", StyleBox[\"name\", \"TI\"]}]\) reads in a file, evaluating each expression in it, and returning the last one. "
Glaisher::usage = "Glaisher is Glaisher's constant with numerical value \!\(\*RowBox[{\"\[TildeEqual]\", \"1.28243\"}]\). "
Glow::usage = "\!\(\*RowBox[{\"Glow\", \"[\", StyleBox[\"col\", \"TI\"], \"]\"}]\) is a graphics directive which specifies that surfaces of 3D graphics objects which follow are to be taken to glow with color \!\(\*StyleBox[\"col\", \"TI\"]\). \n\!\(\*RowBox[{\"Glow\", \"[\", \"]\"}]\) specifies that there is no glow. "
GoldenRatio::usage = "GoldenRatio is the golden ratio \!\(\*RowBox[{\"\[Phi]\", \"=\", RowBox[{FractionBox[\"1\", \"2\"], \" \", RowBox[{\"(\", RowBox[{SqrtBox[\"5\"], \"+\", \"1\"}], \")\"}]}]}]\), with numerical value \!\(\*RowBox[{\"\[TildeEqual]\", \"1.61803\"}]\). "
Goto::usage = "\!\(\*RowBox[{\"Goto\", \"[\", StyleBox[\"tag\", \"TI\"], \"]\"}]\) scans for \!\(\*RowBox[{\"Label\", \"[\", StyleBox[\"tag\", \"TI\"], \"]\"}]\), and transfers control to that point. "
Gradient::usage = "Gradient is an option for FindMinimum, which can be used to specify the gradient of the function whose minimum is being sought. With \!\(\*RowBox[{\"Gradient\", \"->\", \" \", \"Automatic\"}]\), the gradient is computed symbolically. A typical setting is \!\(\*RowBox[{\"Gradient\", \" \", \"->\", \" \", RowBox[{\"{\", RowBox[{RowBox[{\"2\", \" \", StyleBox[\"x\", \"TI\"]}], \",\", \" \", RowBox[{\"Sign\", \"[\", StyleBox[\"y\", \"TI\"], \"]\"}]}], \"}\"}]}]\). Gradient is also an allowed value for the Method option for FindMinimum."
GraphData::usage = "\!\(\*RowBox[{\"GraphData\", \"[\", StyleBox[\"name\", \"TI\"], \"]\"}]\) gives an image of the graph with the specified name.\n\!\(\*RowBox[{\"GraphData\", \"[\", RowBox[{StyleBox[\"name\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the value for the specified property for a named graph.\n\!\(\*RowBox[{\"GraphData\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"class\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a list of named graphs in the specified class.\n\!\(\*RowBox[{\"GraphData\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives a list of named graphs with \!\(\*StyleBox[\"n\", \"TI\"]\) vertices."
Graphics3D::usage = "\!\(\*RowBox[{\"Graphics3D\", \"[\", RowBox[{StyleBox[\"primitives\", \"TI\"], \",\", StyleBox[\"options\", \"TI\"]}], \"]\"}]\) represents a three\[Hyphen]dimensional graphical image. "
GraphicsArray::usage = "\!\(\*RowBox[{\"GraphicsArray\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents a row of graphics objects.\n\!\(\*RowBox[{\"GraphicsArray\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents a two-dimensional array of graphical objects."
GraphicsColumn::usage = "\!\(\*RowBox[{\"GraphicsColumn\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a graphic in which the \!\(\*SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) are laid out in a column, with \!\(\*SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) above \!\(\*SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), etc. \n\!\(\*RowBox[{\"GraphicsColumn\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"alignment\", \"TI\"]}], \"]\"}]\) aligns each element horizontally in the specified way. \n\!\(\*RowBox[{\"GraphicsColumn\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"alignment\", \"TI\"], \",\", StyleBox[\"spacing\", \"TI\"]}], \"]\"}]\) leaves the specified spacing between successive elements."
GraphicsComplex::usage = "\!\(\*RowBox[{\"GraphicsComplex\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"data\", \"TI\"]}], \"]\"}]\) represents a graphics complex in which coordinates given as integers \!\(\*StyleBox[\"i\", \"TI\"]\) in graphics primitives in \!\(\*StyleBox[\"data\", \"TI\"]\) are taken to be \!\(\*SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
GraphicsGrid::usage = "\!\(\*RowBox[{\"GraphicsGrid\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a graphic in which the \!\(\*SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"ij\", \"TI\"]]\) are laid out in a two-dimensional grid."
GraphicsGroup::usage = "\!\(\*RowBox[{\"GraphicsGroup\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents a collection of graphics objects grouped together for purposes of interactive selection in a notebook. "
Graphics::usage = "\!\(\*RowBox[{\"Graphics\", \"[\", RowBox[{StyleBox[\"primitives\", \"TI\"], \",\", StyleBox[\"options\", \"TI\"]}], \"]\"}]\) represents a two\[Hyphen]dimensional graphical image. "
GraphicsRow::usage = "\!\(\*RowBox[{\"GraphicsRow\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a graphic in which the \!\(\*SubscriptBox[\"g\", \"i\"]\) are laid out in a row.\n\!\(\*RowBox[{\"GraphicsRow\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"spacing\", \"TI\"]}], \"]\"}]\) leaves the specified spacing between successive elements."
GraphicsSpacing::usage = "GraphicsSpacing is an option for GraphicsGrid which specifies the spacing between elements in the array. "
GraphPlot3D::usage = "\!\(\*RowBox[{\"GraphPlot3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"i\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"j\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"i\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"2\", \"TR\"]}]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"j\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"2\", \"TR\"]}]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a 3D plot of the graph in which vertex \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"ik\", \"TI\"]]\) is connected to vertex \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"jk\", \"TI\"]]\).\n\!\(\*RowBox[{\"GraphPlot3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"i\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"j\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]]}], \",\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) associates labels \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"k\", \"TI\"]]\) with edges in the graph.\n\!\(\*RowBox[{\"GraphPlot\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) generates a plot of the graph represented by the adjacency matrix \!\(\*StyleBox[\"m\", \"TI\"]\)."
GraphPlot::usage = "\!\(\*RowBox[{\"GraphPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"i\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"j\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"i\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"2\", \"TR\"]}]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"j\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"2\", \"TR\"]}]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a plot of the graph in which vertex \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"ik\", \"TI\"]]\) is connected to vertex \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"jk\", \"TI\"]]\).\n\!\(\*RowBox[{\"GraphPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"i\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"j\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]]}], \",\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) associates labels \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"k\", \"TI\"]]\) with edges in the graph.\n\!\(\*RowBox[{\"GraphPlot\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) generates a plot of the graph represented by the adjacency matrix \!\(\*StyleBox[\"m\", \"TI\"]\)."
GrayLevel::usage = "\!\(\*RowBox[{\"GrayLevel\", \"[\", StyleBox[\"level\", \"TI\"], \"]\"}]\) is a graphics directive which specifies the gray\[Hyphen]level intensity with which objects that follow should be displayed. \n\!\(\*RowBox[{\"GrayLevel\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"]\"}]\) specifies opacity \!\(\*StyleBox[\"a\", \"TI\"]\). "
Gray::usage = "Gray represents the color gray in graphics or style specifications. "
GreaterEqualLess::usage = "\!\(\*RowBox[{\"GreaterEqualLess\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[GreaterEqualLess]\", \"y\", \"\[GreaterEqualLess]\", \"\[Ellipsis]\"}]\)."
GreaterEqual::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \">=\", StyleBox[\"y\", \"TI\"]}]\) or \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[GreaterEqual]\", StyleBox[\"y\", \"TI\"]}]\) yields True if x is determined to be greater than or equal to y. \n\!\(\*RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"\[GreaterEqual]\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"\[GreaterEqual]\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"3\", \"TR\"]]}]\) yields True if the \!\(\*SubscriptBox[\"x\", \"i\"]\) form a non\[Hyphen]increasing sequence. "
GreaterFullEqual::usage = "\!\(\*RowBox[{\"GreaterFullEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[GreaterFullEqual]\", \"y\", \"\[GreaterFullEqual]\", \"\[Ellipsis]\"}]\)."
GreaterGreater::usage = "\!\(\*RowBox[{\"GreaterGreater\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[GreaterGreater]\", \"y\", \"\[GreaterGreater]\", \"\[Ellipsis]\"}]\)."
GreaterLess::usage = "\!\(\*RowBox[{\"GreaterLess\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[GreaterLess]\", \"y\", \"\[GreaterLess]\", \"\[Ellipsis]\"}]\)."
Greater::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \">\", StyleBox[\"y\", \"TI\"]}]\) yields True if x is determined to be greater than y. \n\!\(\*RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \">\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \">\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"3\", \"TR\"]]}]\) yields True if the \!\(\*SubscriptBox[\"x\", \"i\"]\) form a strictly decreasing sequence. "
GreaterSlantEqual::usage = "\!\(\*RowBox[{\"GreaterSlantEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[GreaterEqual]\", \"y\", \"\[GreaterEqual]\", \"\[Ellipsis]\"}]\)."
GreaterTilde::usage = "\!\(\*RowBox[{\"GreaterTilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[GreaterTilde]\", \"y\", \"\[GreaterTilde]\", \"\[Ellipsis]\"}]\)."
Green::usage = "Green represents the color green in graphics or style specifications. "
GridBaseline::usage = "GridBaseline is an option for GridBox which specifies what place in the grid should be considered its baseline for purposes of alignment with surrounding objects. "
GridBox::usage = "\!\(\*RowBox[{GridBox, \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"box\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"box\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"box\", \"TI\"], StyleBox[\"21\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"box\", \"TI\"], StyleBox[\"22\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) is a low-level box construct that represents a two\[Hyphen]dimensional grid of boxes or strings in notebook expressions."
GridCreationSettings::usage = "\!\(\*RowBox[{\"GridCreationSettings\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is a global option that specifies settings for the \!\(\*StyleBox[\"Create Table/Matrix\", \"DialogElementName\"]\) dialog."
GridDefaultElement::usage = "GridDefaultElement is an option for the low-level function GridBox which specifies what to insert when a new element is created interactively in a GridBox. "
GridFrameMargins::usage = "GridFrameMargins is an option for grids that specifies the spacing between the content of the grid and the frame surrounding it."
GridFrame::usage = "GridFrame is an option for grids that specifies whether a surrounding frame is drawn."
GridLines::usage = "GridLines is an option for two\[Hyphen]dimensional graphics functions that specifies grid lines. "
GridLinesStyle::usage = "GridLinesStyle is an option for 2D graphics functions that specifies how grid lines should be rendered."
Grid::usage = "\!\(\*RowBox[{\"Grid\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"21\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"22\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) is an object that formats with the \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"ij\", \"TI\"]]\) arranged in a two\[Hyphen]dimensional grid. "
GroebnerBasis::usage = "\!\(\*RowBox[{\"GroebnerBasis\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a list of polynomials that form a Gr\[ODoubleDot]bner basis for the set of polynomials \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"GroebnerBasis\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) finds a Gr\[ODoubleDot]bner basis in which the \!\(\*SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) have been eliminated. "
GroupPageBreakWithin::usage = "GroupPageBreakWithin is an option for Cell which specifies whether a page break should be allowed within the group of cells if the notebook that contains the group is printed. "
GumbelDistribution::usage = "\!\(\*RowBox[{\"GumbelDistribution\", \"[\", RowBox[{StyleBox[\"\[Alpha]\", \"TR\"], \",\", StyleBox[\"\[Beta]\", \"TR\"]}], \"]\"}]\) represents a Gumbel distribution with location parameter \!\(\*StyleBox[\"\[Alpha]\", \"TR\"]\) and scale parameter \!\(\*StyleBox[\"\[Beta]\", \"TR\"]\)."
HalfNormalDistribution::usage = "\!\(\*RowBox[{\"HalfNormalDistribution\", \"[\", StyleBox[\"\[Theta]\", \"TR\"], \"]\"}]\) represents a half-normal distribution with scale inversely proportional to parameter \!\(\*StyleBox[\"\[Theta]\", \"TR\"]\)."
HammingDistance::usage = "\!\(\*RowBox[{\"HammingDistance\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the Hamming distance between strings or vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
HankelH1::usage = "\!\(\*RowBox[{\"HankelH1\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the Hankel function of the first kind \!\(\*RowBox[{SubsuperscriptBox[\"H\", \"n\", RowBox[{\"(\", \"1\", \")\"}]], \"(\", \"z\", \")\"}]\). "
HankelH2::usage = "\!\(\*RowBox[{\"HankelH2\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the Hankel function of the second kind \!\(\*RowBox[{SubsuperscriptBox[\"H\", \"n\", RowBox[{\"(\", \"2\", \")\"}]], \"(\", \"z\", \")\"}]\). "
HankelMatrix::usage = "\!\(\*RowBox[{\"HankelMatrix\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the \!\(\*StyleBox[\"n\", \"TI\"]\)\[Times]\!\(\*StyleBox[\"n\", \"TI\"]\) Hankel matrix with first row and first column being successive integers.\n\!\(\*RowBox[{\"HankelMatrix\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}], \"]\"}]\) gives the Hankel matrix whose first column consists of elements \!\(\*SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\).\n\!\(\*RowBox[{\"HankelMatrix\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"m\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", \" \", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives the Hankel matrix with elements \!\(\*SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) down the first column, and \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) across the last row."
HarmonicMean::usage = "\!\(\*RowBox[{\"HarmonicMean\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the harmonic mean of the values in \!\(\*StyleBox[\"list\", \"TI\"]\)."
HarmonicNumber::usage = "\!\(\*RowBox[{\"HarmonicNumber\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) harmonic number \!\(\*SubscriptBox[\"H\", \"n\"]\). \n\!\(\*RowBox[{\"HarmonicNumber\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) gives the harmonic number \!\(\*SubsuperscriptBox[\"H\", \"n\", RowBox[{\"(\", \"r\", \")\"}]]\) of order \!\(\*StyleBox[\"r\", \"TI\"]\). "
Hash::usage = "\!\(\*RowBox[{\"Hash\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives an integer hash code for the expression \!\(\*StyleBox[\"expr\", \"TI\"]\).\n\!\(\*RowBox[{\"Hash\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"type\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives an integer hash code of the specified type for \!\(\*StyleBox[\"expr\", \"TI\"]\)."
HashTable::usage = "HashTable is a part of the object which is returned by Dispatch."
HeadCompose::usage = "\!\(\*RowBox[{\"HeadCompose\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", \" \", StyleBox[\"b\", \"TI\"], \",\", \" \", StyleBox[\"c\", \"TI\"], \",\", \" \", StyleBox[\"d\", \"TI\"]}], \"]\"}]\) gives \!\(\*RowBox[{RowBox[{RowBox[{StyleBox[\"a\", \"TI\"], \"[\", StyleBox[\"b\", \"TI\"], \"]\"}], \"[\", StyleBox[\"c\", \"TI\"], \"]\"}], \"[\", StyleBox[\"d\", \"TI\"], \"]\"}]\)."
Head::usage = "\!\(\*RowBox[{\"Head\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the head of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Heads::usage = "Heads is an option for functions which use level specifications that specifies whether heads of expressions should be included. "
HeavisideTheta::usage = "\!\(\*RowBox[{\"HeavisideTheta\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) represents the Heaviside theta function \!\(\*RowBox[{\"\[Theta]\", \"(\", \"x\", \")\"}]\), equal to 0 for \!\(\*RowBox[{\"x\", \"<\", \"0\"}]\) and 1 for \!\(\*RowBox[{\"x\", \">\", \"0\"}]\). \n\!\(\*RowBox[{\"HeavisideTheta\", \"[\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) represents the multidimensional Heaviside theta function which is 1 only if none of the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) are not positive. "
HelpBrowserSettings::usage = "\!\(\*RowBox[{\"HelpBrowserSettings\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is a global option that specifies settings for the legacy Help Browser."
HermiteDecomposition::usage = "\!\(\*RowBox[{\"HermiteDecomposition\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the Hermite normal form decomposition of an integer matrix m."
HermiteH::usage = "\!\(\*RowBox[{\"HermiteH\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the Hermite polynomial \!\(\*RowBox[{SubscriptBox[\"H\", \"n\"], \"(\", \"x\", \")\"}]\). "
HermitianMatrixQ::usage = "\!\(\*RowBox[{\"HermitianMatrixQ\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) tests whether \!\(\*StyleBox[\"m\", \"TI\"]\) is a Hermitian matrix."
HessenbergDecomposition::usage = "\!\(\*RowBox[{\"HessenbergDecomposition\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the Hessenberg decomposition of a matrix \!\(\*StyleBox[\"m\", \"TI\"]\). "
HiddenSurface::usage = "HiddenSurface is an option for GraphicsComplex which specifies whether hidden surfaces are to be eliminated. "
HilbertMatrix::usage = "\!\(\*RowBox[{\"HilbertMatrix\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the \!\(\*StyleBox[\"n\", \"TI\"]\)\[Times]\!\(\*StyleBox[\"n\", \"TI\"]\) Hilbert matrix with elements of the form \!\(\*RowBox[{\"1\", \"/\", RowBox[{\"(\", RowBox[{\"i\", \"+\", \"j\", \"-\", \"1\"}], \")\"}]}]\).\n\!\(\*RowBox[{\"HilbertMatrix\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the \!\(\*StyleBox[\"m\", \"TI\"]\)\[Times]\!\(\*StyleBox[\"n\", \"TI\"]\) Hilbert matrix."
HoldAllComplete::usage = "HoldAllComplete is an attribute which specifies that all arguments to a function are not to be modified or looked at in any way in the process of evaluation. "
HoldAll::usage = "HoldAll is an attribute which specifies that all arguments to a function are to be maintained in an unevaluated form. "
HoldComplete::usage = "\!\(\*RowBox[{\"HoldComplete\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) shields \!\(\*StyleBox[\"expr\", \"TI\"]\) completely from the standard \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) evaluation process, preventing even upvalues associated with \!\(\*StyleBox[\"expr\", \"TI\"]\) from being used. "
HoldFirst::usage = "HoldFirst is an attribute which specifies that the first argument to a function is to be maintained in an unevaluated form. "
HoldForm::usage = "\!\(\*RowBox[{\"HoldForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints as the expression \!\(\*StyleBox[\"expr\", \"TI\"]\), with \!\(\*StyleBox[\"expr\", \"TI\"]\) maintained in an unevaluated form. "
Hold::usage = "\!\(\*RowBox[{\"Hold\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) maintains \!\(\*StyleBox[\"expr\", \"TI\"]\) in an unevaluated form. "
HoldPattern::usage = "\!\(\*RowBox[{\"HoldPattern\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) is equivalent to \!\(\*StyleBox[\"expr\", \"TI\"]\) for pattern matching, but maintains \!\(\*StyleBox[\"expr\", \"TI\"]\) in an unevaluated form. "
HoldRest::usage = "HoldRest is an attribute which specifies that all but the first argument to a function are to be maintained in an unevaluated form. "
HorizontalForm::usage = "HorizontalForm is an internal symbol used for formatting and printing."
HornerForm::usage = "\!\(\*RowBox[{\"HornerForm\", \"[\", StyleBox[\"poly\", \"TI\"], \"]\"}]\) puts the polynomial \!\(\*StyleBox[\"poly\", \"TI\"]\) in Horner form.\n\!\(\*RowBox[{\"HornerForm\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"]}], \"]\"}]\) puts \!\(\*StyleBox[\"poly\", \"TI\"]\) in Horner form with respect to the variable or variable list \!\(\*StyleBox[\"vars\", \"TI\"]\).\n\!\(\*RowBox[{\"HornerForm\", \"[\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"/\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) puts the rational function \!\(\*RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"/\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]]}]\) in Horner form by nesting \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]]\).\n\!\(\*RowBox[{\"HornerForm\", \"[\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"/\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", SubscriptBox[StyleBox[\"vars\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"vars\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) puts \!\(\*RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"/\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]]}]\) in Horner form using the variables or variable lists \!\(\*SubscriptBox[StyleBox[\"vars\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"vars\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) for \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) respectively."
HTMLSave::usage = "\!\(\*RowBox[{\"HTMLSave\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\).html\\\"\",ShowStringCharacters->True], \"]\"}]\) saves an HTML version of the current input notebook in the front end. \n\!\(\*RowBox[{\"HTMLSave\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\).html\\\"\",ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"source\\\",\\\"TI\\\"]\\).nb\\\"\",ShowStringCharacters->True]}], \"]\"}]\) saves an HTML version of the notebook from the file \!\(\*RowBox[{StyleBox[\"source\", \"TI\"], \".\"}]\)nb.\n\!\(\*RowBox[{\"HTMLSave\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\).html\\\"\",ShowStringCharacters->True], \",\", StyleBox[\"notebook\", \"TI\"]}], \"]\"}]\) saves an HTML version of the notebook corresponding to the specified notebook object. "
Hue::usage = "\!\(\*RowBox[{\"Hue\", \"[\", StyleBox[\"h\", \"TI\"], \"]\"}]\) is a graphics directive which specifies that objects which follow are to be displayed, if possible, in a color corresponding to hue \!\(\*StyleBox[\"h\", \"TI\"]\). \n\!\(\*RowBox[{\"Hue\", \"[\", RowBox[{StyleBox[\"h\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) specifies colors in terms of hue, saturation and brightness. \n\!\(\*RowBox[{\"Hue\", \"[\", RowBox[{StyleBox[\"h\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"]\"}]\) specifies opacity \!\(\*StyleBox[\"a\", \"TI\"]\). "
HumpDownHump::usage = "\!\(\*RowBox[{\"HumpDownHump\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[HumpDownHump]\", \"y\", \"\[HumpDownHump]\", \"\[Ellipsis]\"}]\)."
HumpEqual::usage = "\!\(\*RowBox[{\"HumpEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[HumpEqual]\", StyleBox[\"y\", \"TI\"], \"\[HumpEqual]\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\)."
Hypergeometric0F1::usage = "\!\(\*RowBox[{\"Hypergeometric0F1\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the confluent hypergeometric function \!\(\*RowBox[{SubscriptBox[\"\[Null]\", \"0\"], \"\[InvisibleSpace]\", SubscriptBox[\"F\", \"1\"], \"(\", RowBox[{\";\", \"a\", \";\", \"z\"}], \")\"}]\). "
Hypergeometric0F1Regularized::usage = "\!\(\*RowBox[{\"Hypergeometric0F1Regularized\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the regularized confluent hypergeometric function \!\(\*RowBox[{RowBox[{SubscriptBox[\"\[Null]\", \"0\"], \"\[InvisibleSpace]\", SubscriptBox[\"F\", \"1\"], \"(\", RowBox[{\"a\", \";\", \"z\"}], \")\"}], \"/\", RowBox[{\"\[CapitalGamma]\", \"(\", \"a\", \")\"}]}]\). "
Hypergeometric1F1::usage = "\!\(\*RowBox[{\"Hypergeometric1F1\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the Kummer confluent hypergeometric function \!\(\*RowBox[{SubscriptBox[\"\[Null]\", \"1\"], \"\[InvisibleSpace]\", SubscriptBox[\"F\", \"1\"], \"(\", RowBox[{\"a\", \";\", \"b\", \";\", \"z\"}], \")\"}]\). "
Hypergeometric1F1Regularized::usage = "\!\(\*RowBox[{\"Hypergeometric1F1Regularized\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the regularized confluent hypergeometric function \!\(\*RowBox[{RowBox[{SubscriptBox[\"\[Null]\", \"1\"], \"\[InvisibleSpace]\", SubscriptBox[\"F\", \"1\"], \"(\", RowBox[{\"a\", \";\", \"b\", \";\", \"z\"}], \")\"}], \"/\", RowBox[{\"\[CapitalGamma]\", \"(\", \"b\", \")\"}]}]\). "
Hypergeometric2F1::usage = "\!\(\*RowBox[{\"Hypergeometric2F1\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the hypergeometric function \!\(\*RowBox[{RowBox[{SubscriptBox[\"\[InvisiblePrefixScriptBase]\", \"2\"], SubscriptBox[\"F\", \"1\"]}], \"(\", RowBox[{\"a\", \",\", \"b\", \";\", \"c\", \";\", \"z\"}], \")\"}]\). "
Hypergeometric2F1Regularized::usage = "\!\(\*RowBox[{\"Hypergeometric2F1Regularized\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the regularized hypergeometric function \!\(\*RowBox[{RowBox[{SubscriptBox[\"\[Null]\", \"2\"], \"\[InvisibleSpace]\", SubscriptBox[\"F\", \"1\"], \"(\", RowBox[{\"a\", \",\", \"b\", \";\", \"c\", \";\", \"z\"}], \")\"}], \"/\", RowBox[{\"\[CapitalGamma]\", \"(\", \"c\", \")\"}]}]\). "
HypergeometricDistribution::usage = "\!\(\*RowBox[{\"HypergeometricDistribution\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"succ\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"tot\", \"TI\"]]}], \"]\"}]\) represents a hypergeometric distribution."
HypergeometricPFQ::usage = "\!\(\*RowBox[{\"HypergeometricPFQ\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"p\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"q\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the generalized hypergeometric function \!\(\*RowBox[{SubscriptBox[\"\[Null]\", \"p\"], \"\[InvisibleSpace]\", SubscriptBox[\"F\", \"q\"], \"(\", RowBox[{\"a\", \";\", \"b\", \";\", \"z\"}], \")\"}]\). "
HypergeometricPFQRegularized::usage = "\!\(\*RowBox[{\"HypergeometricPFQRegularized\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"p\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"q\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the regularized generalized hypergeometric function \!\(\*RowBox[{RowBox[{SubscriptBox[\"\[Null]\", \"p\"], \"\[InvisibleSpace]\", SubscriptBox[\"F\", \"q\"], \"(\", RowBox[{\"a\", \";\", \"b\", \";\", \"z\"}], \")\"}], \"/\", RowBox[{\"(\", RowBox[{\"\[CapitalGamma]\", \"(\", RowBox[{SubscriptBox[\"b\", \"1\"], \")\"}], \"\[Ellipsis]\", RowBox[{\"\[CapitalGamma]\", \"(\", SubscriptBox[\"b\", \"q\"]}], \")\"}], \")\"}]}]\). "
HypergeometricU::usage = "\!\(\*RowBox[{\"HypergeometricU\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the confluent hypergeometric function \!\(\*RowBox[{\"U\", \"(\", RowBox[{\"a\", \",\", \"b\", \",\", \"z\"}], \")\"}]\). "
Hyperlink::usage = "\!\(\*RowBox[{\"Hyperlink\", \"[\", StyleBox[\"uri\", \"TI\"], \"]\"}]\) represents a hyperlink that jumps to the specified URI when clicked. \n\!\(\*RowBox[{\"Hyperlink\", \"[\", RowBox[{StyleBox[\"label\", \"TI\"], \",\", StyleBox[\"uri\", \"TI\"]}], \"]\"}]\) represents a hyperlink to be displayed as \!\(\*StyleBox[\"label\", \"TI\"]\). "
Hyphenation::usage = "Hyphenation is an option for Cell which specifies whether to allow hyphenation for words of text. "
IdentityMatrix::usage = "\!\(\*RowBox[{\"IdentityMatrix\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the \!\(\*RowBox[{StyleBox[\"n\", \"TI\"], \"\[Cross]\", StyleBox[\"n\", \"TI\"]}]\) identity matrix. "
Identity::usage = "\!\(\*RowBox[{\"Identity\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives \!\(\*StyleBox[\"expr\", \"TI\"]\) (the identity operation). "
If::usage = "\!\(\*RowBox[{\"If\", \"[\", RowBox[{StyleBox[\"condition\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) gives \!\(\*StyleBox[\"t\", \"TI\"]\) if \!\(\*StyleBox[\"condition\", \"TI\"]\) evaluates to True, and \!\(\*StyleBox[\"f\", \"TI\"]\) if it evaluates to False. \n\!\(\*RowBox[{\"If\", \"[\", RowBox[{StyleBox[\"condition\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"u\", \"TI\"]}], \"]\"}]\) gives \!\(\*StyleBox[\"u\", \"TI\"]\) if \!\(\*StyleBox[\"condition\", \"TI\"]\) evaluates to neither True nor False. "
IgnoreCase::usage = "IgnoreCase is an option for string manipulation and searching functions which specifies whether lower\[Hyphen] and upper\[Hyphen]case letters should be treated as equivalent. "
ImageMargins::usage = "ImageMargins is an option which specifies the absolute margins to leave around the image displayed for an object. "
ImagePadding::usage = "ImagePadding is an option for graphics functions that specifies what absolute extra padding should be left for extended objects such as thick lines and annotations such as tick and axis labels."
ImageRegion::usage = "ImageRegion is an option for cells that specifies the size and position of the bounding box within which a graphic is rendered."
ImageResolution::usage = "ImageResolution is an option for Export and Rasterize which specifies at what resolution bitmap images should be rendered. "
ImageRotated::usage = "ImageRotated is an option for Export which specifies whether images should be rotated into landscape mode. "
ImageScaled::usage = "\!\(\*RowBox[{\"ImageScaled\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the position of a graphical object in terms of coordinates scaled to run from 0 to 1 across the whole image region in each direction. \n\!\(\*RowBox[{\"ImageScaled\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"dx\", \"TI\"], \",\", StyleBox[\"dy\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) gives a position obtained by starting at ordinary coordinates \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}]\), then moving by an image\[Hyphen]scaled offset \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"dx\", \"TI\"], \",\", StyleBox[\"dy\", \"TI\"]}], \"}\"}]\). "
ImageSizeAction::usage = "ImageSizeAction is an option for Pane and related constructs which specifies what to do if the specified ImageSize setting does not match the size of the contents."
ImageSizeMultipliers::usage = "ImageSizeMultipliers is an option which specifies how much smaller to render graphics that appear within other constructs."
ImageSize::usage = "ImageSize is an option which specifies the overall size of an image to display for an object. "
Im::usage = "\!\(\*RowBox[{\"Im\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the imaginary part of the complex number z. "
Implies::usage = "\!\(\*RowBox[{\"Implies\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"]}], \"]\"}]\) represents the logical implication \!\(\*RowBox[{\"p\", \"\[DoubleRightArrow]\", \"q\"}]\). "
ImportAutoReplacements::usage = "ImportAutoReplacements is an option for cells that specifies which replacement rules \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) automatically applies when importing text."
Import::usage = "\!\(\*RowBox[{\"Import\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) imports data from a file, returning a complete \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) version of it. \n\!\(\*RowBox[{\"Import\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"elements\", \"TI\"]}], \"]\"}]\) imports the specified elements from a file.\n\!\(\*RowBox[{\"Import\", \"[\", RowBox[{StyleBox[\"\\\"http://\\!\\(\\*StyleBox[\\\"url\\\",\\\"TI\\\"]\\)\\\"\",ShowStringCharacters->True], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) and \!\(\*RowBox[{\"Import\", \"[\", RowBox[{StyleBox[\"\\\"ftp://\\!\\(\\*StyleBox[\\\"url\\\",\\\"TI\\\"]\\)\\\"\",ShowStringCharacters->True], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) imports from any accessible URL. "
ImportString::usage = "\!\(\*RowBox[{\"ImportString\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"data\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"format\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) imports data in the specified format from a string. \n\!\(\*RowBox[{\"ImportString\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"data\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"elements\", \"TI\"]}], \"]\"}]\) imports the specified elements.\n\!\(\*RowBox[{\"ImportString\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"data\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) attempts to determine the format of the string from its contents."
I::usage = "I represents the imaginary unit \!\(\*SqrtBox[RowBox[{\"-\", \"1\"}]]\). "
IncludeFileExtension::usage = "IncludeFileExtension is an option for notebooks that specifies whether the suffix \[OpenCurlyDoubleQuote].nb\[CloseCurlyDoubleQuote] is automatically appended to a notebook\[CloseCurlyQuote]s name when it is first saved."
IncludeSingularTerm::usage = "IncludeSingularTerm is an option for LerchPhi and Zeta. With \!\(\*RowBox[{\"IncludeSingularTerm\", \" \", \"->\", \" \", \"True\"}]\), terms involving \!\(\*SuperscriptBox[RowBox[{\"(\", SuperscriptBox[RowBox[{\"(\", RowBox[{StyleBox[\"k\", \"TI\"], \" \", \"+\", \" \", StyleBox[\"a\", \"TI\"]}], \")\"}], \"2\"], \")\"}], RowBox[{RowBox[{\"-\", StyleBox[\"s\", \"TI\"]}], \"/\", \"2\"}]]\) with \!\(\*RowBox[{RowBox[{StyleBox[\"k\", \"TI\"], \" \", \"+\", \" \", StyleBox[\"a\", \"TI\"]}], \" \", \"==\", \" \", \"0\"}]\) are included. With \!\(\*RowBox[{\"IncludeSingularTerm\", \" \", \"->\", \" \", \"False\"}]\), they are not."
Increment::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"++\"}]\) increases the value of \!\(\*StyleBox[\"x\", \"TI\"]\) by 1, returning the old value of \!\(\*StyleBox[\"x\", \"TI\"]\). "
IndentMaxFraction::usage = "IndentMaxFraction is an option for selections that specifies the maximum amount of indentation that can be automatically added to a line."
Indeterminate::usage = "Indeterminate is a symbol that represents a numerical quantity whose magnitude cannot be determined. "
Inequality::usage = "Inequality represents a sequence of relational statements."
InexactNumberQ::usage = "\!\(\*RowBox[{\"InexactNumberQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) returns True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is an inexact real or complex number, and returns False otherwise."
InexactNumbers::usage = "InexactNumbers represents an option value for CoefficientDomain which specifies that the computation should be done using approximate coefficient arithmetic."
Infinity::usage = "Infinity or \[Infinity] is a symbol that represents a positive infinite quantity. "
Infix::usage = "\!\(\*RowBox[{\"Infix\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}], \"]\"}]\) prints with \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) given in default infix form: \!\(\*RowBox[{RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"~\", StyleBox[\"f\", \"TI\"], \"~\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"~\", StyleBox[\"f\", \"TI\"], \"~\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"3\", \"TR\"]]}], StyleBox[\"\[Ellipsis]\", \"TR\"]}]\). \n\!\(\*RowBox[{\"Infix\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) prints with arguments separated by \!\(\*StyleBox[\"h\", \"TI\"]\): \!\(\*RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \" \", StyleBox[\"h\", \"TI\"], \" \", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \" \", StyleBox[\"h\", \"TI\"], \" \", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"3\", \"TR\"]], StyleBox[\"\[Ellipsis]\", \"TR\"]}]\). "
Information::usage = "\!\(\*RowBox[{\"Information\", \"[\", StyleBox[\"symbol\", \"TI\"], \"]\"}]\) prints information about a symbol. "
Inherited::usage = "Inherited represents an option value to be inherited from an enclosing style, cell or notebook. "
InitializationCellEvaluation::usage = "InitializationCellEvaluation is an option for notebooks that specifies whether initialization cells in a notebook are automatically evaluated when the notebook is opened."
InitializationCell::usage = "InitializationCell is an option for Cell which specifies whether the cell should be tagged to be evaluated by the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) kernel when the notebook that contains it is opened. "
InitializationCellWarning::usage = "InitializationCellWarning is an option for notebooks that specifies whether a warning should be given when a notebook containing initialization cells is opened."
Initialization::usage = "Initialization is an option for Dynamic, DynamicModule, Manipulate and related constructs, which specifies an expression to be evaluated when the construct is first used or displayed. "
In::usage = "\!\(\*RowBox[{\"In\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) is a global object that is assigned to have a delayed value of the \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) input line. "
Inner::usage = "\!\(\*RowBox[{\"Inner\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"g\", \"TI\"]}], \"]\"}]\) is a generalization of Dot in which \!\(\*StyleBox[\"f\", \"TI\"]\) plays the role of multiplication and \!\(\*StyleBox[\"g\", \"TI\"]\) of addition. "
InputAliases::usage = "InputAliases is an option for cells and notebooks which specifies additional \!\(\*StyleBox[\"Esc\", \"KeyEvent\"]\)\!\(\*StyleBox[\"\[ThinSpace]\", \"InlineCode\"]\)\!\(\*StyleBox[\"name\", \"TI\"]\)\!\(\*StyleBox[\"\[ThinSpace]\", \"InlineCode\"]\)\!\(\*StyleBox[\"Esc\", \"KeyEvent\"]\) aliases to be allowed on input. "
InputAutoReplacements::usage = "InputAutoReplacements is an option for cells and notebooks which specifies strings of characters that should be replaced immediately on input. "
InputField::usage = "\!\(\*RowBox[{\"InputField\", \"[\", \"]\"}]\) represents a blank editable input field. \n\!\(\*RowBox[{\"InputField\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) represents an editable input field that currently contains the expression \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"InputField\", \"[\", RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \"]\"}]\) takes the contents of the input field to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\), with the value of \!\(\*StyleBox[\"x\", \"TI\"]\) being reset if new contents are entered. \n\!\(\*RowBox[{\"InputField\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", \"String\"}], \"]\"}]\) represents an input field whose contents are taken to be a string. \n\!\(\*RowBox[{\"InputField\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", \"Number\"}], \"]\"}]\) represents an input field whose contents are taken to be a number. \n\!\(\*RowBox[{\"InputField\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"type\", \"TI\"]}], \"]\"}]\) represents an input field whose contents are taken to be of the specified type. "
InputForm::usage = "\!\(\*RowBox[{\"InputForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints as a version of \!\(\*StyleBox[\"expr\", \"TI\"]\) suitable for input to \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\). "
InputNamePacket::usage = "\!\(\*RowBox[{\"InputNamePacket\", \"[\", StyleBox[\"string\", \"TI\"], \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet that contains in \!\(\*StyleBox[\"string\", \"TI\"]\) the name to be assigned to the next input."
Input::usage = "\!\(\*RowBox[{\"Input\", \"[\", \"]\"}]\) interactively reads in one \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) expression. \n\!\(\*RowBox[{\"Input\", \"[\", StyleBox[\"prompt\", \"TI\"], \"]\"}]\) requests input, displaying \!\(\*StyleBox[\"prompt\", \"TI\"]\) as a \"prompt\".\n\!\(\*RowBox[{\"Input\", \"[\", RowBox[{StyleBox[\"prompt\", \"TI\"], \",\", StyleBox[\"init\", \"TI\"]}], \"]\"}]\) in a notebook front end uses \!\(\*StyleBox[\"init\", \"TI\"]\) as the initial contents of the input field."
InputNotebook::usage = "\!\(\*RowBox[{\"InputNotebook\", \"[\", \"]\"}]\) gives the current notebook into which keyboard input in the front end will be directed. "
InputPacket::usage = "\!\(\*RowBox[{\"InputPacket\", \"[\", \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet that indicates a prompt for input as generated by Input."
InputStream::usage = "\!\(\*RowBox[{\"InputStream\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) is an object that represents an input stream for functions such as Read and Find. "
InputString::usage = "\!\(\*RowBox[{\"InputString\", \"[\", \"]\"}]\) interactively reads in a character string. \n\!\(\*RowBox[{\"InputString\", \"[\", StyleBox[\"prompt\", \"TI\"], \"]\"}]\) requests input, displaying \!\(\*StyleBox[\"prompt\", \"TI\"]\) as a \"prompt\". \n\!\(\*RowBox[{\"InputString\", \"[\", RowBox[{StyleBox[\"prompt\", \"TI\"], \",\", StyleBox[\"init\", \"TI\"]}], \"]\"}]\) in a notebook front end uses \!\(\*StyleBox[\"init\", \"TI\"]\) as the initial contents of the input field."
InputStringPacket::usage = "\!\(\*RowBox[{\"InputStringPacket\", \"[\", \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet that requests input in string form."
InputToBoxFormPacket::usage = "InputToBoxFormPacket is an internal symbol used for formatting."
Insert::usage = "\!\(\*RowBox[{\"Insert\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"elem\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) inserts \!\(\*StyleBox[\"elem\", \"TI\"]\) at position \!\(\*StyleBox[\"n\", \"TI\"]\) in \!\(\*StyleBox[\"list\", \"TI\"]\). If \!\(\*StyleBox[\"n\", \"TI\"]\) is negative, the position is counted from the end. \n\!\(\*RowBox[{\"Insert\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"elem\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) inserts \!\(\*StyleBox[\"elem\", \"TI\"]\) at position \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\) in \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Insert\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"elem\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) inserts \!\(\*StyleBox[\"elem\", \"TI\"]\) at several positions. "
Inset::usage = "\!\(\*RowBox[{\"Inset\", \"[\", StyleBox[\"obj\", \"TI\"], \"]\"}]\) represents an object \!\(\*StyleBox[\"obj\", \"TI\"]\) inset in a graphic. \n\!\(\*RowBox[{\"Inset\", \"[\", RowBox[{StyleBox[\"obj\", \"TI\"], \",\", StyleBox[\"pos\", \"TI\"]}], \"]\"}]\) specifies that the inset should be placed at position \!\(\*StyleBox[\"pos\", \"TI\"]\) in the graphic. \n\!\(\*RowBox[{\"Inset\", \"[\", RowBox[{StyleBox[\"obj\", \"TI\"], \",\", StyleBox[\"pos\", \"TI\"], \",\", StyleBox[\"opos\", \"TI\"]}], \"]\"}]\) aligns the inset so that position \!\(\*StyleBox[\"opos\", \"TI\"]\) in the object lies at position \!\(\*StyleBox[\"pos\", \"TI\"]\) in the enclosing graphic. \n\!\(\*RowBox[{\"Inset\", \"[\", RowBox[{StyleBox[\"obj\", \"TI\"], \",\", StyleBox[\"pos\", \"TI\"], \",\", StyleBox[\"opos\", \"TI\"], \",\", StyleBox[\"size\", \"TI\"]}], \"]\"}]\) specifies the size of the inset in the coordinate system of the enclosing graphic. \n\!\(\*RowBox[{\"Inset\", \"[\", RowBox[{StyleBox[\"obj\", \"TI\"], \",\", StyleBox[\"pos\", \"TI\"], \",\", StyleBox[\"opos\", \"TI\"], \",\", StyleBox[\"size\", \"TI\"], \",\", StyleBox[\"dirs\", \"TI\"]}], \"]\"}]\) specifies that the axes of the inset should be oriented in directions \!\(\*StyleBox[\"dirs\", \"TI\"]\). "
Install::usage = "\!\(\*RowBox[{\"Install\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) starts a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\)-compatible external program and installs \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) definitions to call functions in it. "
InstallService::usage = "\!\(\*RowBox[{\"InstallService\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"url\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) installs the web service operations in the WSDL description at the URL given.\n\!\(\*RowBox[{\"InstallService\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"url\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", \" \", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"context`\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) installs web service operations, creating functions in the specified context."
InString::usage = "\!\(\*RowBox[{\"InString\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) is a global object that is assigned to be the text of the \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) input line. "
IntegerDigits::usage = "\!\(\*RowBox[{\"IntegerDigits\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives a list of the decimal digits in the integer \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"IntegerDigits\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives a list of the base\[Hyphen]\!\(\*StyleBox[\"b\", \"TI\"]\) digits in the integer \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"IntegerDigits\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"len\", \"TI\"]}], \"]\"}]\) pads the list on the left with zeros to give a list of length \!\(\*StyleBox[\"len\", \"TI\"]\). "
IntegerExponent::usage = "\!\(\*RowBox[{\"IntegerExponent\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives the highest power of \!\(\*StyleBox[\"b\", \"TI\"]\) that divides \!\(\*StyleBox[\"n\", \"TI\"]\). "
IntegerLength::usage = "\!\(\*RowBox[{\"IntegerLength\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the number of digits in the base 10 representation of the integer \!\(\*StyleBox[\"n\", \"TI\"]\).\n\!\(\*RowBox[{\"IntegerLength\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives the number of digits in the base \!\(\*StyleBox[\"b\", \"TI\"]\) representation of \!\(\*StyleBox[\"n\", \"TI\"]\)."
Integer::usage = "Integer is the head used for integers. "
IntegerPartitions::usage = "\!\(\*RowBox[{\"IntegerPartitions\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives a list of all possible ways to partition the integer \!\(\*StyleBox[\"n\", \"TI\"]\) into smaller integers. \n\!\(\*RowBox[{\"IntegerPartitions\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives partitions into at most \!\(\*StyleBox[\"k\", \"TI\"]\) integers. \n\!\(\*RowBox[{\"IntegerPartitions\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", RowBox[{\"{\", StyleBox[\"k\", \"TI\"], \"}\"}]}], \"]\"}]\) gives partitions into exactly \!\(\*StyleBox[\"k\", \"TI\"]\) integers. \n\!\(\*RowBox[{\"IntegerPartitions\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives partitions into between \!\(\*SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) integers. \n\!\(\*RowBox[{\"IntegerPartitions\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"kspec\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives partitions involving only the \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
IntegerPart::usage = "\!\(\*RowBox[{\"IntegerPart\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives the integer part of \!\(\*StyleBox[\"x\", \"TI\"]\). "
IntegerQ::usage = "\!\(\*RowBox[{\"IntegerQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is an integer, and False otherwise. "
Integers::usage = "Integers represents the domain of integers, as in \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[Element]\", \"Integers\"}]\). "
IntegerString::usage = "\!\(\*RowBox[{\"IntegerString\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives a string consisting of the decimal digits in the integer \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"IntegerString\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives a string consisting of the base b digits in the integer \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"IntegerString\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"len\", \"TI\"]}], \"]\"}]\) pads the string on the left with zero digits to give a string of length \!\(\*StyleBox[\"len\", \"TI\"]\). \n\!\(\*RowBox[{\"IntegerString\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"\\\"Roman\\\"\",ShowStringCharacters->True]}], \"]\"}]\) gives the Roman numeral form of \!\(\*StyleBox[\"n\", \"TI\"]\)."
Integrate::usage = "\!\(\*RowBox[{\"Integrate\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the indefinite integral \!\(\*RowBox[{\"\[Integral]\", \"f\", \" \", \"d\", \"x\"}]\). \n\!\(\*RowBox[{\"Integrate\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives the definite integral \!\(\*RowBox[{SubsuperscriptBox[\"\[Integral]\", SubscriptBox[\"x\", StyleBox[\"min\", \"TI\"]], SubscriptBox[\"x\", StyleBox[\"max\", \"TI\"]]], \" \", \"f\", \" \", \"d\", \"x\"}]\). \n\!\(\*RowBox[{\"Integrate\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the multiple integral \!\(\*RowBox[{SubsuperscriptBox[\"\[Integral]\", SubscriptBox[\"x\", StyleBox[\"min\", \"TI\"]], SubscriptBox[\"x\", StyleBox[\"max\", \"TI\"]]], RowBox[{\"d\", \"x\", RowBox[{SubsuperscriptBox[\"\[Integral]\", SubscriptBox[\"y\", StyleBox[\"min\", \"TI\"]], SubscriptBox[\"y\", StyleBox[\"max\", \"TI\"]]], RowBox[{\"d\", \"\[InvisibleSpace]\", \"y\", \" \", \"\[Ellipsis]\", \" \", \"f\"}]}]}]}]\). "
InterpolatingFunction::usage = "\!\(\*RowBox[{\"InterpolatingFunction\", \"[\", RowBox[{StyleBox[\"domain\", \"TI\"], \",\", StyleBox[\"table\", \"TI\"]}], \"]\"}]\) represents an approximate function whose values are found by interpolation. "
InterpolatingPolynomial::usage = "\!\(\*RowBox[{\"InterpolatingPolynomial\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) constructs an interpolating polynomial in \!\(\*StyleBox[\"x\", \"TI\"]\) which reproduces the function values \!\(\*SubscriptBox[\"f\", \"i\"]\) at successive integer values \!\(\*RowBox[{\"1\", \",\", \"2\", \",\", \"\[Ellipsis]\"}]\) of x. \n\!\(\*RowBox[{\"InterpolatingPolynomial\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) constructs an interpolating polynomial for the function values \!\(\*SubscriptBox[\"f\", \"i\"]\) corresponding to x values \!\(\*SubscriptBox[\"x\", \"i\"]\).\n\!\(\*RowBox[{\"InterpolatingPolynomial\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) constructs a multidimensional interpolating polynomial in the variables \!\(\*RowBox[{\"x\", \",\", \"y\", \",\", \"\[Ellipsis]\"}]\).\n\!\(\*RowBox[{\"InterpolatingPolynomial\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"df\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) constructs an interpolating polynomial that reproduces derivatives as well as function values."
Interpolation::usage = "\!\(\*RowBox[{\"Interpolation\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) constructs an interpolation of the function values \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"i\", \"TI\"]]\), assumed to correspond to \!\(\*StyleBox[\"x\", \"TI\"]\) values 1, 2, \[Ellipsis] . \n\!\(\*RowBox[{\"Interpolation\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) constructs an interpolation of the function values \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) corresponding to \!\(\*StyleBox[\"x\", \"TI\"]\) values \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\).\n\!\(\*RowBox[{\"Interpolation\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) constructs an interpolation of multidimensional data.\n\!\(\*RowBox[{\"Interpolation\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"df\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) constructs an interpolation that reproduces derivatives as well as function values."
InterpolationOrder::usage = "InterpolationOrder is an option for Interpolation, as well as ListLinePlot, ListPlot3D, ListContourPlot and related functions, that specifies what order of interpolation to use."
InterpolationPoints::usage = "InterpolationPoints is an option to \!\(\*RowBox[{\"FunctionInterpolation\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", \" \", StyleBox[\"range\", \"TI\"]}], \"]\"}]\) when elements of \!\(\*StyleBox[\"range\", \"TI\"]\) are of the form \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", \" \", StyleBox[\"x1\", \"TI\"], \",\", \" \", StyleBox[\"x2\", \"TI\"]}], \"}\"}]\) or \!\(\*StyleBox[\"x\", \"TI\"]\). It gives the number of points used in the new InterpolatingFunction."
InterpretationBox::usage = "\!\(\*RowBox[{InterpretationBox, \"[\", RowBox[{StyleBox[\"boxes\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) is a low-level box construct that displays as \!\(\*StyleBox[\"boxes\", \"TI\"]\) but is interpreted on input as \!\(\*StyleBox[\"expr\", \"TI\"]\). "
InterpretationBoxOptions::usage = "\!\(\*RowBox[{InterpretationBoxOptions, \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for selections that specifies settings for InterpretationBox constructs."
Interpretation::usage = "\!\(\*RowBox[{\"Interpretation\", \"[\", RowBox[{StyleBox[\"e\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) represents an object which displays as \!\(\*StyleBox[\"e\", \"TI\"]\), but is interpreted as the unevaluated form of \!\(\*StyleBox[\"expr\", \"TI\"]\) if supplied as input. \n\!\(\*RowBox[{\"Interpretation\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{StyleBox[\"x\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \",\", RowBox[{StyleBox[\"y\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"e\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) allows local variables \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"y\", \"TI\"]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\) in \!\(\*StyleBox[\"e\", \"TI\"]\) and \!\(\*StyleBox[\"expr\", \"TI\"]\)."
InterpretTemplate::usage = "InterpretTemplate is an experimental function used for interpreting \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) input."
InterquartileRange::usage = "\!\(\*RowBox[{\"InterquartileRange\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the difference between the upper and lower quartiles for the elements in \!\(\*StyleBox[\"list\", \"TI\"]\)."
Interrupt::usage = "\!\(\*RowBox[{\"Interrupt\", \"[\", \"]\"}]\) generates an interrupt. "
Intersection::usage = "\!\(\*RowBox[{\"Intersection\", \"[\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives a sorted list of the elements common to all the \!\(\*SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
IntervalIntersection::usage = "\!\(\*RowBox[{\"IntervalIntersection\", \"[\", RowBox[{SubscriptBox[StyleBox[\"interval\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"interval\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the interval representing all points common to each of the \!\(\*SubscriptBox[StyleBox[\"interval\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
IntervalMemberQ::usage = "\!\(\*RowBox[{\"IntervalMemberQ\", \"[\", RowBox[{StyleBox[\"interval\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives True if the number \!\(\*StyleBox[\"x\", \"TI\"]\) lies within the specified interval, and False otherwise. \n\!\(\*RowBox[{\"IntervalMemberQ\", \"[\", RowBox[{SubscriptBox[StyleBox[\"interval\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"interval\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) gives True if \!\(\*SubscriptBox[StyleBox[\"interval\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) is completely contained within \!\(\*SubscriptBox[StyleBox[\"interval\", \"TI\"], StyleBox[\"1\", \"TR\"]]\). "
Interval::usage = "\!\(\*RowBox[{\"Interval\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"min\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"]}], \"}\"}], \"]\"}]\) represents the range of values between \!\(\*StyleBox[\"min\", \"TI\"]\) and \!\(\*StyleBox[\"max\", \"TI\"]\). \n\!\(\*RowBox[{\"Interval\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"min\", \"TI\"], StyleBox[\"1\", \"TR\"]], RowBox[{\",\", SubscriptBox[StyleBox[\"max\", \"TI\"], StyleBox[\"1\", \"TR\"]]}]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"min\", \"TI\"], StyleBox[\"2\", \"TR\"]], RowBox[{\",\", SubscriptBox[StyleBox[\"max\", \"TI\"], StyleBox[\"2\", \"TR\"]]}]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) represents the union of the ranges \!\(\*SubscriptBox[StyleBox[\"min\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) to \!\(\*SubscriptBox[StyleBox[\"max\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"min\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) to \!\(\*SubscriptBox[StyleBox[\"max\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\). "
IntervalUnion::usage = "\!\(\*RowBox[{\"IntervalUnion\", \"[\", RowBox[{SubscriptBox[StyleBox[\"interval\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"interval\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the interval representing the set of all points in any of the \!\(\*SubscriptBox[StyleBox[\"interval\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
InverseBetaRegularized::usage = "\!\(\*RowBox[{\"InverseBetaRegularized\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives the inverse of the regularized incomplete beta function. "
InverseCDF::usage = "\!\(\*RowBox[{\"InverseCDF\", \"[\", RowBox[{StyleBox[\"dist\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"]}], \"]\"}]\) gives the inverse of the cumulative distribution function for the symbolic distribution \!\(\*StyleBox[\"dist\", \"TI\"]\) as a function of the variable \!\(\*StyleBox[\"q\", \"TI\"]\)."
InverseEllipticNomeQ::usage = "\!\(\*RowBox[{\"InverseEllipticNomeQ\", \"[\", StyleBox[\"q\", \"TI\"], \"]\"}]\) gives the parameter \!\(\*StyleBox[\"m\", \"TI\"]\) corresponding to the nome \!\(\*StyleBox[\"q\", \"TI\"]\) in an elliptic function. "
InverseErfc::usage = "\!\(\*RowBox[{\"InverseErfc\", \"[\", StyleBox[\"s\", \"TI\"], \"]\"}]\) gives the inverse complementary error function obtained as the solution for \!\(\*StyleBox[\"z\", \"TI\"]\) in \!\(\*RowBox[{\"s\", \"=\", RowBox[{\"erfc\", \"(\", \"z\", \")\"}]}]\). "
InverseErf::usage = "\!\(\*RowBox[{\"InverseErf\", \"[\", StyleBox[\"s\", \"TI\"], \"]\"}]\) gives the inverse error function obtained as the solution for \!\(\*StyleBox[\"z\", \"TI\"]\) in \!\(\*RowBox[{\"s\", \"=\", RowBox[{\"erf\", \"(\", \"z\", \")\"}]}]\). "
InverseFourierCosTransform::usage = "\!\(\*RowBox[{\"InverseFourierCosTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\[Omega]\", \"TR\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) gives the symbolic inverse Fourier cosine transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"InverseFourierCosTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"\[Omega]\", \"TR\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"\[Omega]\", \"TR\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the multidimensional inverse Fourier cosine transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
InverseFourier::usage = "\!\(\*RowBox[{\"InverseFourier\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) finds the discrete inverse Fourier transform of a list of complex numbers. "
InverseFourierSinTransform::usage = "\!\(\*RowBox[{\"InverseFourierSinTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\[Omega]\", \"TR\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) gives the symbolic inverse Fourier sine transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"InverseFourierSinTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"\[Omega]\", \"TR\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"\[Omega]\", \"TR\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the multidimensional inverse Fourier sine transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
InverseFourierTransform::usage = "\!\(\*RowBox[{\"InverseFourierTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", \"\[Omega]\", \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) gives the symbolic inverse Fourier transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"InverseFourierTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[\"\[Omega]\", StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[\"\[Omega]\", StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the multidimensional inverse Fourier transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
InverseFunction::usage = "\!\(\*RowBox[{\"InverseFunction\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) represents the inverse of the function \!\(\*StyleBox[\"f\", \"TI\"]\), defined so that \!\(\*RowBox[{RowBox[{\"InverseFunction\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}], \"[\", StyleBox[\"y\", \"TI\"], \"]\"}]\) gives the value of \!\(\*StyleBox[\"x\", \"TI\"]\) for which \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) is equal to \!\(\*StyleBox[\"y\", \"TI\"]\). \n\!\(\*RowBox[{\"InverseFunction\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"tot\", \"TI\"]}], \"]\"}]\) represents the inverse with respect to the \!\(\*StyleBox[RowBox[{StyleBox[\"n\", \"TI\"], \"\[Null]\"}]]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) argument when there are \!\(\*StyleBox[\"tot\", \"TI\"]\) arguments in all. "
InverseFunctions::usage = "InverseFunctions is an option for Solve and related functions which specifies whether inverse functions should be used. "
InverseGammaRegularized::usage = "\!\(\*RowBox[{\"InverseGammaRegularized\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives the inverse of the regularized incomplete gamma function. "
InverseGaussianDistribution::usage = "\!\(\*RowBox[{RowBox[{\"InverseGaussianDistribution\", \"[\", RowBox[{StyleBox[\"\[Mu]\", \"TR\"], \",\", StyleBox[\"\[Lambda]\", \"TR\"]}], \"]\"}], \" \"}]\) represents an inverse Gaussian distribution with mean \!\(\*StyleBox[\"\[Mu]\", \"TR\"]\) and scale parameter \!\(\*StyleBox[\"\[Lambda]\", \"TR\"]\)."
InverseJacobiCD::usage = "\!\(\*RowBox[{\"InverseJacobiCD\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the inverse Jacobi elliptic function \!\(\*RowBox[{SuperscriptBox[\"cd\", RowBox[{\"-\", \"1\"}]], \"(\", RowBox[{\"v\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\)."
InverseJacobiCN::usage = "\!\(\*RowBox[{\"InverseJacobiCN\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the inverse Jacobi elliptic function \!\(\*RowBox[{SuperscriptBox[\"cn\", RowBox[{\"-\", \"1\"}]], \"(\", RowBox[{\"v\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\)."
InverseJacobiCS::usage = "\!\(\*RowBox[{\"InverseJacobiCS\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the inverse Jacobi elliptic function \!\(\*RowBox[{SuperscriptBox[\"cs\", RowBox[{\"-\", \"1\"}]], \"(\", RowBox[{\"v\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\)."
InverseJacobiDC::usage = "\!\(\*RowBox[{\"InverseJacobiDC\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the inverse Jacobi elliptic function \!\(\*RowBox[{SuperscriptBox[\"dc\", RowBox[{\"-\", \"1\"}]], \"(\", RowBox[{\"v\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\)."
InverseJacobiDN::usage = "\!\(\*RowBox[{\"InverseJacobiDN\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the inverse Jacobi elliptic function \!\(\*RowBox[{SuperscriptBox[\"dn\", RowBox[{\"-\", \"1\"}]], \"(\", RowBox[{\"v\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\)."
InverseJacobiDS::usage = "\!\(\*RowBox[{\"InverseJacobiDS\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the inverse Jacobi elliptic function \!\(\*RowBox[{SuperscriptBox[\"ds\", RowBox[{\"-\", \"1\"}]], \"(\", RowBox[{\"v\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\)."
InverseJacobiNC::usage = "\!\(\*RowBox[{\"InverseJacobiNC\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the inverse Jacobi elliptic function \!\(\*RowBox[{SuperscriptBox[\"nc\", RowBox[{\"-\", \"1\"}]], \"(\", RowBox[{\"v\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\)."
InverseJacobiND::usage = "\!\(\*RowBox[{\"InverseJacobiND\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the inverse Jacobi elliptic function \!\(\*RowBox[{SuperscriptBox[\"nd\", RowBox[{\"-\", \"1\"}]], \"(\", RowBox[{\"v\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\)."
InverseJacobiNS::usage = "\!\(\*RowBox[{\"InverseJacobiNS\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the inverse Jacobi elliptic function \!\(\*RowBox[{SuperscriptBox[\"ns\", RowBox[{\"-\", \"1\"}]], \"(\", RowBox[{\"v\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\)."
InverseJacobiSC::usage = "\!\(\*RowBox[{\"InverseJacobiSC\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the inverse Jacobi elliptic function \!\(\*RowBox[{SuperscriptBox[\"sc\", RowBox[{\"-\", \"1\"}]], \"(\", RowBox[{\"v\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\)."
InverseJacobiSD::usage = "\!\(\*RowBox[{\"InverseJacobiSD\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the inverse Jacobi elliptic function \!\(\*RowBox[{SuperscriptBox[\"sd\", RowBox[{\"-\", \"1\"}]], \"(\", RowBox[{\"v\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\)."
InverseJacobiSN::usage = "\!\(\*RowBox[{\"InverseJacobiSN\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the inverse Jacobi elliptic function \!\(\*RowBox[{SuperscriptBox[\"sn\", RowBox[{\"-\", \"1\"}]], \"(\", RowBox[{\"v\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\)."
InverseLaplaceTransform::usage = "\!\(\*RowBox[{\"InverseLaplaceTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) gives the inverse Laplace transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"InverseLaplaceTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the multidimensional inverse Laplace transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Inverse::usage = "\!\(\*RowBox[{\"Inverse\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the inverse of a square matrix \!\(\*StyleBox[\"m\", \"TI\"]\). "
InverseSeries::usage = "\!\(\*RowBox[{\"InverseSeries\", \"[\", StyleBox[\"s\", \"TI\"], \"]\"}]\) takes the series \!\(\*StyleBox[\"s\", \"TI\"]\), and gives a series for the inverse of the function represented by \!\(\*StyleBox[\"s\", \"TI\"]\). \n\!\(\*RowBox[{\"InverseSeries\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) uses the variable \!\(\*StyleBox[\"x\", \"TI\"]\) in the inverse series."
InverseWeierstrassP::usage = "\!\(\*RowBox[{\"InverseWeierstrassP\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"3\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) gives a value of \!\(\*StyleBox[\"u\", \"TI\"]\) for which the Weierstrass function \!\(\*RowBox[{\"\[WeierstrassP]\", RowBox[{\"(\", RowBox[{\"u\", \";\", SubscriptBox[\"g\", \"2\"], \",\", SubscriptBox[\"g\", \"3\"]}], \")\"}]}]\) is equal to \!\(\*StyleBox[\"p\", \"TI\"]\). "
InverseZTransform::usage = "\!\(\*RowBox[{\"InverseZTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the inverse Z transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Invisible::usage = "\!\(\*RowBox[{\"Invisible\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays as space that is the same size as the formatted version of \!\(\*StyleBox[\"expr\", \"TI\"]\)."
IsolatingInterval::usage = "\!\(\*RowBox[{\"IsolatingInterval\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) gives a rational isolating interval for the algebraic number \!\(\*StyleBox[\"a\", \"TI\"]\).\n\!\(\*RowBox[{\"IsolatingInterval\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"dx\", \"TI\"]}], \"]\"}]\) gives an isolating interval of width at most \!\(\*StyleBox[\"dx\", \"TI\"]\)."
IsotopeData::usage = "\!\(\*RowBox[{\"IsotopeData\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"Z\", \"TI\"], \",\", StyleBox[\"A\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the value of the specified property for the isotope with atomic number \!\(\*StyleBox[\"Z\", \"TI\"]\) and mass number \!\(\*StyleBox[\"A\", \"TI\"]\).\n\!\(\*RowBox[{\"IsotopeData\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the value of the property for the named isotope."
Italic::usage = "Italic represents an italic font slant."
ItemAspectRatio::usage = "ItemAspectRatio is an option for GraphicsGrid which specifies the ratio of height to width for the regions in which items are placed in the graphics grid."
Item::usage = "\!\(\*RowBox[{\"Item\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"options\", \"TI\"]}], \"]\"}]\) represents an item within constructs such as Grid, PopupMenu or TabView that displays with \!\(\*StyleBox[\"expr\", \"TI\"]\) as the content, and with the specified options applied to the region containing \!\(\*StyleBox[\"expr\", \"TI\"]\). "
ItemSize::usage = "ItemSize is an option for Grid, Column and related constructs that specifies the sizes to allow for items."
ItemStyle::usage = "ItemStyle is an option for Grid, Column and related constructs that specifies styles to use for items."
JaccardDissimilarity::usage = "\!\(\*RowBox[{\"JaccardDissimilarity\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the Jaccard dissimilarity between Boolean vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
JacobiAmplitude::usage = "\!\(\*RowBox[{\"JacobiAmplitude\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the amplitude \!\(\*RowBox[{\"am\", \"(\", RowBox[{\"u\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\) for Jacobi elliptic functions. "
Jacobian::usage = "Jacobian is an option for FindRoot. \!\(\*RowBox[{\"Jacobian\", \" \", \"->\", \" \", \"Automatic\"}]\) attempts symbolic computation of the Jacobian of the system of functions whose root is being sought. A typical setting is \!\(\*RowBox[{\"Jacobian\", \" \", \"->\", \" \", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"2\", \" \", StyleBox[\"x\", \"TI\"]}], \",\", \" \", RowBox[{\"Sign\", \"[\", StyleBox[\"y\", \"TI\"], \"]\"}]}], \"}\"}], \",\", \" \", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", \" \", StyleBox[\"x\", \"TI\"]}], \"}\"}]}], \"}\"}]}]\)."
JacobiCD::usage = "\!\(\*RowBox[{\"JacobiCD\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi elliptic function \!\(\*RowBox[{\"cd\", \"(\", RowBox[{\"u\", \"|\", \"m\"}], \")\"}]\)."
JacobiCN::usage = "JacobiCN\!\(\*RowBox[{\"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi elliptic function \!\(\*RowBox[{\"cn\", \"(\", RowBox[{\"u\", \"|\", \"m\"}], \")\"}]\)."
JacobiCS::usage = "\!\(\*RowBox[{\"JacobiCS\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi elliptic function \!\(\*RowBox[{\"cs\", \"(\", RowBox[{\"u\", \"|\", \"m\"}], \")\"}]\)."
JacobiDC::usage = "\!\(\*RowBox[{\"JacobiDC\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi elliptic function \!\(\*RowBox[{\"dc\", \"(\", RowBox[{\"u\", \"|\", \"m\"}], \")\"}]\)."
JacobiDN::usage = "\!\(\*RowBox[{\"JacobiDN\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi elliptic function \!\(\*RowBox[{\"dn\", \"(\", RowBox[{\"u\", \"|\", \"m\"}], \")\"}]\)."
JacobiDS::usage = "\!\(\*RowBox[{\"JacobiDS\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi elliptic function \!\(\*RowBox[{\"ds\", \"(\", RowBox[{\"u\", \"|\", \"m\"}], \")\"}]\)."
JacobiNC::usage = "\!\(\*RowBox[{\"JacobiNC\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi elliptic function \!\(\*RowBox[{\"nc\", \"(\", RowBox[{\"u\", \"|\", \"m\"}], \")\"}]\)."
JacobiND::usage = "\!\(\*RowBox[{\"JacobiND\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi elliptic function \!\(\*RowBox[{\"nd\", \"(\", RowBox[{\"u\", \"|\", \"m\"}], \")\"}]\)."
JacobiNS::usage = "\!\(\*RowBox[{\"JacobiNS\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi elliptic function \!\(\*RowBox[{\"ns\", \"(\", RowBox[{\"u\", \"|\", \"m\"}], \")\"}]\)."
JacobiP::usage = "\!\(\*RowBox[{\"JacobiP\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the Jacobi polynomial \!\(\*RowBox[{SubsuperscriptBox[\"P\", \"n\", RowBox[{\"(\", RowBox[{\"a\", \",\", \"b\"}], \")\"}]], \"(\", \"x\", \")\"}]\). "
JacobiSC::usage = "\!\(\*RowBox[{\"JacobiSC\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi elliptic function \!\(\*RowBox[{\"sc\", \"(\", RowBox[{\"u\", \"|\", \"m\"}], \")\"}]\)."
JacobiSD::usage = "\!\(\*RowBox[{\"JacobiSD\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi elliptic function \!\(\*RowBox[{\"sd\", \"(\", RowBox[{\"u\", \"|\", \"m\"}], \")\"}]\)."
JacobiSN::usage = "\!\(\*RowBox[{\"JacobiSN\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi elliptic function \!\(\*RowBox[{\"sn\", \"(\", RowBox[{\"u\", \"|\", \"m\"}], \")\"}]\)."
JacobiSymbol::usage = "\!\(\*RowBox[{\"JacobiSymbol\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi symbol \!\(\*RowBox[{\"(\", FractionBox[\"n\", \"m\"], \")\"}]\). "
JacobiZeta::usage = "\!\(\*RowBox[{\"JacobiZeta\", \"[\", RowBox[{StyleBox[\"\[Phi]\", \"TR\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Jacobi zeta function \!\(\*RowBox[{\"Z\", \"(\", RowBox[{\"\[Phi]\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]\). "
Joined::usage = "Joined is an option for ListPlot and related functions which specifies whether points in each dataset should be joined into a line, or should be plotted as separate points. "
Join::usage = "\!\(\*RowBox[{\"Join\", \"[\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) concatenates lists or other expressions that share the same head.\n\!\(\*RowBox[{\"Join\", \"[\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) joins the objects at level \!\(\*StyleBox[\"n\", \"TI\"]\) in each of the \!\(\*SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
JordanDecomposition::usage = "\!\(\*RowBox[{\"JordanDecomposition\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) yields the Jordan decomposition of a square matrix \!\(\*StyleBox[\"m\", \"TI\"]\). The result is a list \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"]}], \"}\"}]\) where \!\(\*StyleBox[\"s\", \"TI\"]\) is a similarity matrix and \!\(\*StyleBox[\"j\", \"TI\"]\) is the Jordan canonical form of \!\(\*StyleBox[\"m\", \"TI\"]\). "
KelvinBei::usage = "\!\(\*RowBox[{\"KelvinBei\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the Kelvin function \!\(\*RowBox[{\"bei\", \"(\", \"z\", \")\"}]\).\n\!\(\*RowBox[{\"KelvinBei\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the Kelvin function \!\(\*RowBox[{SubscriptBox[\"bei\", \"n\"], \"(\", \"z\", \")\"}]\). "
KelvinBer::usage = "\!\(\*RowBox[{\"KelvinBer\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the Kelvin function \!\(\*RowBox[{\"ber\", \"(\", \"z\", \")\"}]\).\n\!\(\*RowBox[{\"KelvinBer\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the Kelvin function \!\(\*RowBox[{SubscriptBox[\"ber\", \"n\"], \"(\", \"z\", \")\"}]\). "
KelvinKei::usage = "\!\(\*RowBox[{\"KelvinKei\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the Kelvin function \!\(\*RowBox[{\"kei\", \"(\", \"z\", \")\"}]\).\n\!\(\*RowBox[{\"KelvinKei\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the Kelvin function \!\(\*RowBox[{SubscriptBox[\"kei\", \"n\"], \"(\", \"z\", \")\"}]\). "
KelvinKer::usage = "\!\(\*RowBox[{\"KelvinKer\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the Kelvin function \!\(\*RowBox[{\"ker\", \"(\", \"z\", \")\"}]\).\n\!\(\*RowBox[{\"KelvinKer\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the Kelvin function \!\(\*RowBox[{SubscriptBox[\"ker\", \"n\"], \"(\", \"z\", \")\"}]\). "
Khinchin::usage = "Khinchin is Khinchin's constant, with numerical value \!\(\*RowBox[{\"\[TildeEqual]\", \"2.68545\"}]\). "
KleinInvariantJ::usage = "\!\(\*RowBox[{\"KleinInvariantJ\", \"[\", StyleBox[\"\[Tau]\", \"TR\"], \"]\"}]\) gives the Klein invariant modular elliptic function \!\(\*RowBox[{\"J\", \"(\", \"\[Tau]\", \")\"}]\). "
K::usage = "K is a default generic name for a summation index in a symbolic sum."
KnotData::usage = "\!\(\*RowBox[{\"KnotData\", \"[\", RowBox[{StyleBox[\"knot\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the specified property for a knot.\n\!\(\*RowBox[{\"KnotData\", \"[\", StyleBox[\"knot\", \"TI\"], \"]\"}]\) gives an image of the knot.\n\!\(\*RowBox[{\"KnotData\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"class\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a list of knots in the specified class."
KroneckerDelta::usage = "\!\(\*RowBox[{\"KroneckerDelta\", \"[\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the Kronecker delta \!\(\*SubscriptBox[\"\[Delta]\", RowBox[{SubscriptBox[\"n\", \"1\"], \" \", SubscriptBox[\"n\", \"2\"], \" \", \"\[Ellipsis]\"}]]\), equal to 1 if all the \!\(\*SubscriptBox[\"n\", \"i\"]\) are equal, and 0 otherwise. "
KroneckerProduct::usage = "\!\(\*RowBox[{\"KroneckerProduct\", \"[\", RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) constructs the Kronecker product of the arrays \!\(\*SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
KroneckerSymbol::usage = "\!\(\*RowBox[{\"KroneckerSymbol\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Kronecker symbol \!\(\*RowBox[{\"(\", FractionBox[\"n\", \"m\"], \")\"}]\). "
Kurtosis::usage = "\!\(\*RowBox[{\"Kurtosis\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the coefficient of kurtosis for the elements in \!\(\*StyleBox[\"list\", \"TI\"]\).\n\!\(\*RowBox[{\"Kurtosis\", \"[\", StyleBox[\"dist\", \"TI\"], \"]\"}]\) gives the coefficient of kurtosis for the symbolic distribution \!\(\*StyleBox[\"dist\", \"TI\"]\)."
Labeled::usage = "\!\(\*RowBox[{\"Labeled\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"lbl\", \"TI\"]}], \"]\"}]\) displays \!\(\*StyleBox[\"expr\", \"TI\"]\) labeled with \!\(\*StyleBox[\"lbl\", \"TI\"]\). \n\!\(\*RowBox[{\"Labeled\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"lbl\", \"TI\"], \",\", StyleBox[\"pos\", \"TI\"]}], \"]\"}]\) places \!\(\*StyleBox[\"lbl\", \"TI\"]\) at a position specified by \!\(\*StyleBox[\"pos\", \"TI\"]\). \n\!\(\*RowBox[{\"Labeled\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) places the \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) at positions \!\(\*SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
Label::usage = "\!\(\*RowBox[{\"Label\", \"[\", StyleBox[\"tag\", \"TI\"], \"]\"}]\) represents a point in a compound expression to which control can be transferred using Goto. "
LabelStyle::usage = "LabelStyle is an option for formatting and related constructs that specifies the style to use in displaying their label-like elements. "
LaguerreL::usage = "\!\(\*RowBox[{\"LaguerreL\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the Laguerre polynomial \!\(\*RowBox[{SubscriptBox[\"L\", \"n\"], \"(\", \"x\", \")\"}]\). \n\!\(\*RowBox[{\"LaguerreL\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the generalized Laguerre polynomial \!\(\*RowBox[{SubsuperscriptBox[\"L\", \"n\", \"a\"], \"(\", \"x\", \")\"}]\). "
LanguageCategory::usage = "LanguageCategory is an option for Cell which determines in what category of language the contents of the cell should be assumed to be for purposes of spell checking and hyphenation. "
Language::usage = "Language is a global option that specifies the language in which menus, dialog boxes, error messages, and help files are displayed."
LaplaceDistribution::usage = "\!\(\*RowBox[{\"LaplaceDistribution\", \"[\", RowBox[{StyleBox[\"\[Mu]\", \"TR\"], \",\", StyleBox[\"\[Beta]\", \"TR\"]}], \"]\"}]\) represents a Laplace double exponential distribution with mean \[Mu] and scale parameter \!\(\*StyleBox[\"\[Beta]\", \"TR\"]\)."
LaplaceTransform::usage = "\!\(\*RowBox[{\"LaplaceTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives the Laplace transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"LaplaceTransform\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the multidimensional Laplace transform of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Large::usage = "Large is a style or option setting that specifies that objects should be large."
Larger::usage = "Larger is a style or option setting that specifies that objects should be larger."
Last::usage = "\!\(\*RowBox[{\"Last\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the last element in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
LatticeData::usage = "\!\(\*RowBox[{\"LatticeData\", \"[\", RowBox[{StyleBox[\"lattice\", \"TI\"], \",\", \" \", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the specified property for a lattice.\n\!\(\*RowBox[{\"LatticeData\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives a list of named lattices of dimension n."
LatticeReduce::usage = "\!\(\*RowBox[{\"LatticeReduce\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives a reduced basis for the set of vectors \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
LayeredGraphPlot::usage = "\!\(\*RowBox[{\"LayeredGraphPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"i\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"j\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"i\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"2\", \"TR\"]}]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"j\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"2\", \"TR\"]}]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a layered plot of the graph in which vertex \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"ik\", \"TI\"]]\) is connected to vertex \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"jk\", \"TI\"]]\).\n\!\(\*RowBox[{\"LayeredGraphPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"i\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"j\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]]}], \",\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) associates labels \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"k\", \"TI\"]]\) with edges in the graph.\n\!\(\*RowBox[{\"LayeredGraphPlot\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"pos\", \"TI\"]}], \"]\"}]\) places the dominant vertices in the plot at position \!\(\*StyleBox[\"pos\", \"TI\"]\).\n\!\(\*RowBox[{\"LayeredGraphPlot\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) generates a layered plot of the graph represented by the adjacency matrix \!\(\*StyleBox[\"m\", \"TI\"]\)."
LayerSizeFunction::usage = "LayerSizeFunction is an option for TreePlot that gives a function to specify the relative height to allow for each layer."
LCM::usage = "\!\(\*RowBox[{\"LCM\", \"[\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the least common multiple of the integers \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
LeafCount::usage = "\!\(\*RowBox[{\"LeafCount\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the total number of indivisible subexpressions in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
LeastSquares::usage = "\!\(\*RowBox[{\"LeastSquares\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) finds an \!\(\*StyleBox[\"x\", \"TI\"]\) which solves the linear least-squares problem for the matrix equation \!\(\*RowBox[{RowBox[{StyleBox[\"m\", \"TI\"], \".\", StyleBox[\"x\", \"TI\"]}], \"==\", StyleBox[\"b\", \"TI\"]}]\)."
LeftArrowBar::usage = "\!\(\*RowBox[{\"LeftArrowBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftArrowBar]\", \"y\", \"\[LeftArrowBar]\", \"\[Ellipsis]\"}]\)."
LeftArrow::usage = "\!\(\*RowBox[{\"LeftArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftArrow]\", \"y\", \"\[LeftArrow]\", \"\[Ellipsis]\"}]\)."
LeftArrowRightArrow::usage = "\!\(\*RowBox[{\"LeftArrowRightArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftArrowRightArrow]\", \"y\", \"\[LeftArrowRightArrow]\", \"\[Ellipsis]\"}]\)."
LeftDownTeeVector::usage = "\!\(\*RowBox[{\"LeftDownTeeVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftDownTeeVector]\", \"y\", \"\[LeftDownTeeVector]\", \"\[Ellipsis]\"}]\)."
LeftDownVectorBar::usage = "\!\(\*RowBox[{\"LeftDownVectorBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftDownVectorBar]\", \"y\", \"\[LeftDownVectorBar]\", \"\[Ellipsis]\"}]\)."
LeftDownVector::usage = "\!\(\*RowBox[{\"LeftDownVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftDownVector]\", \"y\", \"\[LeftDownVector]\", \"\[Ellipsis]\"}]\)."
Left::usage = "Left is a symbol that represents the left-hand side for purposes of alignment and positioning. "
LeftRightArrow::usage = "\!\(\*RowBox[{\"LeftRightArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftRightArrow]\", \"y\", \"\[LeftRightArrow]\", \"\[Ellipsis]\"}]\)."
LeftRightVector::usage = "\!\(\*RowBox[{\"LeftRightVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftRightVector]\", \"y\", \"\[LeftRightVector]\", \"\[Ellipsis]\"}]\)."
LeftTeeArrow::usage = "\!\(\*RowBox[{\"LeftTeeArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftTeeArrow]\", \"y\", \"\[LeftTeeArrow]\", \"\[Ellipsis]\"}]\)."
LeftTee::usage = "\!\(\*RowBox[{\"LeftTee\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftTee]\", \"y\"}]\)."
LeftTeeVector::usage = "\!\(\*RowBox[{\"LeftTeeVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftTeeVector]\", \"y\", \"\[LeftTeeVector]\", \"\[Ellipsis]\"}]\)."
LeftTriangleBar::usage = "\!\(\*RowBox[{\"LeftTriangleBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftTriangleBar]\", \"y\", \"\[LeftTriangleBar]\", \"\[Ellipsis]\"}]\)."
LeftTriangleEqual::usage = "\!\(\*RowBox[{\"LeftTriangleEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftTriangleEqual]\", \"y\", \"\[LeftTriangleEqual]\", \"\[Ellipsis]\"}]\)."
LeftTriangle::usage = "\!\(\*RowBox[{\"LeftTriangle\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftTriangle]\", \"y\", \"\[LeftTriangle]\", \"\[Ellipsis]\"}]\)."
LeftUpDownVector::usage = "\!\(\*RowBox[{\"LeftUpDownVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftUpDownVector]\", \"y\", \"\[LeftUpDownVector]\", \"\[Ellipsis]\"}]\)."
LeftUpTeeVector::usage = "\!\(\*RowBox[{\"LeftUpTeeVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftUpTeeVector]\", \"y\", \"\[LeftUpTeeVector]\", \"\[Ellipsis]\"}]\)."
LeftUpVectorBar::usage = "\!\(\*RowBox[{\"LeftUpVectorBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftUpVectorBar]\", \"y\", \"\[LeftUpVectorBar]\", \"\[Ellipsis]\"}]\)."
LeftUpVector::usage = "\!\(\*RowBox[{\"LeftUpVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftUpVector]\", \"y\", \"\[LeftUpVector]\", \"\[Ellipsis]\"}]\)."
LeftVectorBar::usage = "\!\(\*RowBox[{\"LeftVectorBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftVectorBar]\", \"y\", \"\[LeftVectorBar]\", \"\[Ellipsis]\"}]\)."
LeftVector::usage = "\!\(\*RowBox[{\"LeftVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LeftVector]\", \"y\", \"\[LeftVector]\", \"\[Ellipsis]\"}]\)."
LegendreP::usage = "\!\(\*RowBox[{\"LegendreP\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the Legendre polynomial \!\(\*RowBox[{SubscriptBox[\"P\", \"n\"], \"(\", \"x\", \")\"}]\). \n\!\(\*RowBox[{\"LegendreP\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the associated Legendre polynomial \!\(\*RowBox[{SubsuperscriptBox[\"P\", \"n\", \"m\"], \"(\", \"x\", \")\"}]\). "
LegendreQ::usage = "\!\(\*RowBox[{\"LegendreQ\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the Legendre function of the second kind \!\(\*RowBox[{SubscriptBox[\"Q\", \"n\"], \"(\", \"z\", \")\"}]\). \n\!\(\*RowBox[{\"LegendreQ\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the associated Legendre function of the second kind \!\(\*RowBox[{SubsuperscriptBox[\"Q\", \"n\", \"m\"], \"(\", \"z\", \")\"}]\). "
Length::usage = "\!\(\*RowBox[{\"Length\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the number of elements in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
LengthWhile::usage = "\!\(\*RowBox[{\"LengthWhile\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"crit\", \"TI\"]}], \"]\"}]\) gives the number of continuous elements \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) starting at the beginning of \!\(\*StyleBox[\"list\", \"TI\"]\) for which \!\(\*RowBox[{StyleBox[\"crit\", \"TI\"], \"[\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]], \"]\"}]\) is True."
LerchPhi::usage = "\!\(\*RowBox[{\"LerchPhi\", \"[\", RowBox[{StyleBox[\"z\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"]\"}]\) gives the Lerch transcendent \!\(\*RowBox[{StyleBox[\"\[CapitalPhi]\", \"TR\"], RowBox[{\"(\", RowBox[{StyleBox[\"z\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \")\"}]}]\). "
LessEqualGreater::usage = "\!\(\*RowBox[{\"LessEqualGreater\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LessEqualGreater]\", \"y\", \"\[LessEqualGreater]\", \"\[Ellipsis]\"}]\)."
LessEqual::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"<=\", StyleBox[\"y\", \"TI\"]}]\) or \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[LessEqual]\", StyleBox[\"y\", \"TI\"]}]\) yields True if x is determined to be less than or equal to y. \n\!\(\*RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"\[LessEqual]\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"\[LessEqual]\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"3\", \"TR\"]]}]\) yields True if the \!\(\*SubscriptBox[\"x\", \"i\"]\) form a nondecreasing sequence. "
LessFullEqual::usage = "\!\(\*RowBox[{\"LessFullEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LessFullEqual]\", \"y\", \"\[LessFullEqual]\", \"\[Ellipsis]\"}]\)."
LessGreater::usage = "\!\(\*RowBox[{\"LessGreater\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LessGreater]\", \"y\", \"\[LessGreater]\", \"\[Ellipsis]\"}]\)."
LessLess::usage = "\!\(\*RowBox[{\"LessLess\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LessLess]\", \"y\", \"\[LessLess]\", \"\[Ellipsis]\"}]\)."
Less::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"<\", StyleBox[\"y\", \"TI\"]}]\) yields True if x is determined to be less than y. \n\!\(\*RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"<\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"<\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"3\", \"TR\"]]}]\) yields True if the \!\(\*SubscriptBox[\"x\", \"i\"]\) form a strictly increasing sequence. "
LessSlantEqual::usage = "\!\(\*RowBox[{\"LessSlantEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LessEqual]\", \"y\", \"\[LessEqual]\", \"\[Ellipsis]\"}]\)."
LessTilde::usage = "\!\(\*RowBox[{\"LessTilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LessTilde]\", \"y\", \"\[LessTilde]\", \"\[Ellipsis]\"}]\)."
LetterCharacter::usage = "LetterCharacter represents a letter character in StringExpression."
LetterQ::usage = "\!\(\*RowBox[{\"LetterQ\", \"[\", StyleBox[\"string\", \"TI\"], \"]\"}]\) yields True if all the characters in the string are letters, and yields False otherwise. "
Level::usage = "\!\(\*RowBox[{\"Level\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"]}], \"]\"}]\) gives a list of all subexpressions of \!\(\*StyleBox[\"expr\", \"TI\"]\) on levels specified by \!\(\*StyleBox[\"levelspec\", \"TI\"]\). \n\!\(\*RowBox[{\"Level\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to the sequence of subexpressions. "
Lexicographic::usage = "Lexicographic represents the lexicographic ordering of monomials."
LicenseID::usage = "LicenseID is an option to Encode which specifies the required value of $LicenseID on the computer that reads the encoded file. If no value is specified, any value of $LicenseID is allowed on the file-reading computer. A setting for LicenseID must be a string."
LightBlue::usage = "LightBlue represents a light blue color in graphics or style specifications."
LightBrown::usage = "LightBrown represents a light brown color in graphics or style specifications."
LightCyan::usage = "LightCyan represents a light cyan color in graphics or style specifications."
Lighter::usage = "\!\(\*RowBox[{\"Lighter\", \"[\", StyleBox[\"color\", \"TI\"], \"]\"}]\) represents a lighter version of the specified color. \n\!\(\*RowBox[{\"Lighter\", \"[\", RowBox[{StyleBox[\"color\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) represents a version of the specified color lightened by a fraction \!\(\*StyleBox[\"f\", \"TI\"]\). "
LightGray::usage = "LightGray represents a light gray color in graphics or style specifications."
LightGreen::usage = "LightGreen represents a light green color in graphics or style specifications."
LightingAngle::usage = "LightingAngle is an option for ReliefPlot which specifies the angle from which simulated illumination is taken to come."
Lighting::usage = "Lighting is an option for Graphics3D and related functions that specifies what simulated lighting to use in coloring 3D surfaces. "
LightMagenta::usage = "LightMagenta represents a light magenta color in graphics or style specifications."
LightOrange::usage = "LightOrange represents a light orange color in graphics or style specifications."
LightPink::usage = "LightPink represents a light pink color in graphics or style specifications."
LightPurple::usage = "LightPurple represents a light purple color in graphics or style specifications."
LightRed::usage = "LightRed represents a light red color in graphics or style specifications."
LightSources::usage = "LightSources is an option for Graphics3D and related functions that specifies the properties of point light sources for simulated illumination. "
LightYellow::usage = "LightYellow represents a light yellow color in graphics or style specifications."
Limit::usage = "\!\(\*RowBox[{\"Limit\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{StyleBox[\"x\", \"TI\"], \"->\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}]}], \"]\"}]\) finds the limiting value of \!\(\*StyleBox[\"expr\", \"TI\"]\) when \!\(\*StyleBox[\"x\", \"TI\"]\) approaches \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]\). "
LimitsPositioning::usage = "LimitsPositioning is an option for UnderoverscriptBox and related boxes which specifies whether to change the positioning of underscripts and overscripts in the way conventional for limits. "
LimitsPositioningTokens::usage = "LimitsPositioningTokens is an option for selections that specifies a set of characters for which the option LimitsPositioning is set to True by default."
LinearFractionalTransform::usage = "\!\(\*RowBox[{\"LinearFractionalTransform\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives a TransformationFunction that represents a linear fractional transformation defined by the homogeneous matrix \!\(\*StyleBox[\"m\", \"TI\"]\). \n\!\(\*RowBox[{\"LinearFractionalTransform\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"}\"}], \"]\"}]\) represents a linear fractional transformation that maps r to \!\(\*RowBox[{RowBox[{\"(\", RowBox[{RowBox[{\"a\", \".\", \"r\"}], \"+\", \"b\"}], \")\"}], \"/\", RowBox[{\"(\", RowBox[{RowBox[{\"c\", \".\", \"r\"}], \"+\", \"d\"}], \")\"}]}]\). "
LinearProgramming::usage = "\!\(\*RowBox[{\"LinearProgramming\", \"[\", RowBox[{StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) finds a vector \!\(\*StyleBox[\"x\", \"TI\"]\) which minimizes the quantity \!\(\*RowBox[{StyleBox[\"c\", \"TI\"], \".\", StyleBox[\"x\", \"TI\"]}]\) subject to the constraints \!\(\*RowBox[{StyleBox[\"m\", \"TI\"], \".\", StyleBox[\"x\", \"TI\"], \"\[GreaterEqual]\", StyleBox[\"b\", \"TI\"]}]\) and \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[GreaterEqual]\", \"0\"}]\). \n\!\(\*RowBox[{\"LinearProgramming\", \"[\", RowBox[{StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) finds a vector \!\(\*StyleBox[\"x\", \"TI\"]\) which minimizes \!\(\*RowBox[{StyleBox[\"c\", \"TI\"], \".\", StyleBox[\"x\", \"TI\"]}]\) subject to \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[GreaterEqual]\", \"0\"}]\) and linear constraints specified by the matrix \!\(\*StyleBox[\"m\", \"TI\"]\) and the pairs \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"i\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]}], \"}\"}]\). For each row \!\(\*SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) of \!\(\*StyleBox[\"m\", \"TI\"]\), the corresponding constraint is \!\(\*RowBox[{RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"i\", \"TI\"]], \".\", StyleBox[\"x\", \"TI\"]}], \"\[GreaterEqual]\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"i\", \"TI\"]]}]\) if \!\(\*RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]], \"==\", \"1\"}]\), or \!\(\*RowBox[{RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"i\", \"TI\"]], \".\", StyleBox[\"x\", \"TI\"]}], \"==\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"i\", \"TI\"]]}]\) if \!\(\*RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]], \"==\", \"0\"}]\), or \!\(\*RowBox[{RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"i\", \"TI\"]], \".\", StyleBox[\"x\", \"TI\"]}], \"\[LessEqual]\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"i\", \"TI\"]]}]\) if \!\(\*RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]], \"==\", RowBox[{\"-\", \"1\"}]}]\). \n\!\(\*RowBox[{\"LinearProgramming\", \"[\", RowBox[{StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"l\", \"TI\"]}], \"]\"}]\) minimizes \!\(\*RowBox[{StyleBox[\"c\", \"TI\"], \".\", StyleBox[\"x\", \"TI\"]}]\) subject to the constraints specified by \!\(\*StyleBox[\"m\", \"TI\"]\) and \!\(\*StyleBox[\"b\", \"TI\"]\) and \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[GreaterEqual]\", StyleBox[\"l\", \"TI\"]}]\). \n\!\(\*RowBox[{\"LinearProgramming\", \"[\", RowBox[{StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"l\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"l\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) minimizes \!\(\*RowBox[{StyleBox[\"c\", \"TI\"], \".\", StyleBox[\"x\", \"TI\"]}]\) subject to the constraints specified by \!\(\*StyleBox[\"m\", \"TI\"]\) and \!\(\*StyleBox[\"b\", \"TI\"]\) and \!\(\*RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]], \"\[GreaterEqual]\", SubscriptBox[StyleBox[\"l\", \"TI\"], StyleBox[\"i\", \"TI\"]]}]\). \n\!\(\*RowBox[{\"LinearProgramming\", \"[\", RowBox[{StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"l\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"l\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) minimizes \!\(\*RowBox[{StyleBox[\"c\", \"TI\"], \".\", StyleBox[\"x\", \"TI\"]}]\) subject to the constraints specified by \!\(\*StyleBox[\"m\", \"TI\"]\) and \!\(\*StyleBox[\"b\", \"TI\"]\) and \!\(\*RowBox[{SubscriptBox[StyleBox[\"l\", \"TI\"], StyleBox[\"i\", \"TI\"]], \"\[LessEqual]\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]], \"\[LessEqual]\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"i\", \"TI\"]]}]\). \n\!\(\*RowBox[{\"LinearProgramming\", \"[\", RowBox[{StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"lu\", \"TI\"], \",\", StyleBox[\"dom\", \"TI\"]}], \"]\"}]\) takes the elements of \!\(\*StyleBox[\"x\", \"TI\"]\) to be in the domain \!\(\*StyleBox[\"dom\", \"TI\"]\), either Reals or Integers.\n\!\(\*RowBox[{\"LinearProgramming\", \"[\", RowBox[{StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"lu\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"dom\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"dom\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) takes \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) to be in the domain \!\(\*SubscriptBox[StyleBox[\"dom\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
LinearSolveFunction::usage = "\!\(\*RowBox[{\"LinearSolveFunction\", \"[\", RowBox[{StyleBox[\"dimensions\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"]}], \"]\"}]\) represents a function for providing solutions to a matrix equation. "
LinearSolve::usage = "\!\(\*RowBox[{\"LinearSolve\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) finds an \!\(\*StyleBox[\"x\", \"TI\"]\) which solves the matrix equation \!\(\*RowBox[{RowBox[{StyleBox[\"m\", \"TI\"], \".\", StyleBox[\"x\", \"TI\"]}], \"==\", StyleBox[\"b\", \"TI\"]}]\). \n\!\(\*RowBox[{\"LinearSolve\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) generates a \!\(\*RowBox[{\"LinearSolveFunction\", \"[\", StyleBox[\"\[Ellipsis]\", \"TR\"], \"]\"}]\) which can be applied repeatedly to different \!\(\*StyleBox[\"b\", \"TI\"]\). "
LinebreakAdjustments::usage = "LinebreakAdjustments is an option for selections that sets parameters used for calculating where automatic line breaks should be inserted."
LineBreakWithin::usage = "LineBreakWithin is an option for selections that specifies whether line breaks occur automatically when the end of a line is reached."
LineForm::usage = "\!\(\*RowBox[{\"LineForm\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) is a three-dimensional graphics directive that specifies that lines are to be drawn with the graphics directive \!\(\*StyleBox[\"g\", \"TI\"]\) or the list of graphics directives \!\(\*StyleBox[\"g\", \"TI\"]\)."
LineIndentMaxFraction::usage = "LineIndentMaxFraction is an option for Cell, StyleBox and Style which specifies the maximum fraction of the total page width to indent at the beginnings of lines. "
LineIndent::usage = "LineIndent is an option for Style and Cell which specifies how many ems of indentation to add at the beginnings of lines for each level of nesting in an expression. "
Line::usage = "\!\(\*RowBox[{\"Line\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) is a graphics primitive which represents a line joining a sequence of points. \n\!\(\*RowBox[{\"Line\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"21\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents a collection of lines. "
LineSpacing::usage = "LineSpacing is an option for Style and Cell which specifies the spacing between successive lines of text. "
LinkClose::usage = "\!\(\*RowBox[{\"LinkClose\", \"[\", StyleBox[\"link\", \"TI\"], \"]\"}]\) closes an open \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) connection. "
LinkConnect::usage = "\!\(\*RowBox[{\"LinkConnect\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) connects to a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) link created by another program. "
LinkCreate::usage = "\!\(\*RowBox[{\"LinkCreate\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) creates a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) link with the specified name for another program to connect to. \n\!\(\*RowBox[{\"LinkCreate\", \"[\", \"]\"}]\) creates a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) link and picks an unused name for the link."
LinkError::usage = "\!\(\*RowBox[{\"LinkError\", \"[\", StyleBox[\"link\", \"TI\"], \"]\"}]\) returns error information for link in the form \!\(\*RowBox[{\"{\", \" \", RowBox[{StyleBox[\"errorNumber\", \"TI\"], \",\", \" \", StyleBox[\"errorExplanation\", \"TI\"]}], \" \", \"}\"}]\)."
LinkFlush::usage = "\!\(\*RowBox[{\"LinkFlush\", \"[\", StyleBox[\"link\", \"TI\"], \"]\"}]\) transmits immediately any locally buffered outgoing expressions."
LinkInterrupt::usage = "\!\(\*RowBox[{\"LinkInterrupt\", \"[\", StyleBox[\"link\", \"TI\"], \"]\"}]\) sends an interrupt to the program at the other end of the specified \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) connection. "
LinkLaunch::usage = "\!\(\*RowBox[{\"LinkLaunch\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"prog\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) starts the external program \!\(\*StyleBox[\"prog\", \"TI\"]\) and opens a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) connection to it. "
LinkObject::usage = "\!\(\*RowBox[{\"LinkObject\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) is an object that represents an active \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) connection for functions such as LinkRead and LinkWrite. "
LinkPatterns::usage = "\!\(\*RowBox[{\"LinkPatterns\", \"[\", StyleBox[\"link\", \"TI\"], \"]\"}]\) gives a list of the patterns for which definitions were set up when the external program associated with the specified \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) connection was installed. "
LinkProtocol::usage = "LinkProtocol is an option to LinkLaunch, Install and related functions which specifies the underlying data transport protocol to use for a new \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) link. "
LinkReadHeld::usage = "\!\(\*RowBox[{\"LinkReadHeld\", \"[\", StyleBox[\"link\", \"TI\"], \"]\"}]\) reads an expression via \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) from \!\(\*StyleBox[\"link\", \"TI\"]\) and returns it wrapped in Hold."
LinkRead::usage = "\!\(\*RowBox[{\"LinkRead\", \"[\", StyleBox[\"link\", \"TI\"], \"]\"}]\) reads one expression from the specified \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) connection. \n\!\(\*RowBox[{\"LinkRead\", \"[\", RowBox[{StyleBox[\"link\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) wraps \!\(\*StyleBox[\"h\", \"TI\"]\) around the expression read before evaluating it. "
LinkReadyQ::usage = "\!\(\*RowBox[{\"LinkReadyQ\", \"[\", StyleBox[\"link\", \"TI\"], \"]\"}]\) tests whether there is an expression ready to read from the specified \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) connection. \n\!\(\*RowBox[{\"LinkReadyQ\", \"[\", RowBox[{StyleBox[\"link\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) waits for up to \!\(\*StyleBox[\"t\", \"TI\"]\) seconds to see if an expression becomes ready to read.\n\!\(\*RowBox[{\"LinkReadyQ\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"link\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"link\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) tests all the \!\(\*SubscriptBox[StyleBox[\"link\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) in parallel, returning as soon as any of them are ready to read from."
Links::usage = "\!\(\*RowBox[{\"Links\", \"[\", \"]\"}]\) gives a list of all \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) connections that are currently open. \n\!\(\*RowBox[{\"Links\", \"[\", StyleBox[\"patt\", \"TI\"], \"]\"}]\) lists only links whose names match the specified string pattern."
LinkWriteHeld::usage = "\!\(\*RowBox[{\"LinkWriteHeld\", \"[\", RowBox[{StyleBox[\"link\", \"TI\"], \",\", \" \", RowBox[{\"Hold\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}], \",\", \" \", RowBox[{\"(\", RowBox[{StyleBox[\"flush\", \"TI\"], \":\", \"True\"}], \")\"}]}], \"]\"}]\) writes \!\(\*StyleBox[\"expr\", \"TI\"]\) (without the Hold) via \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) to link (synchronizing unless \!\(\*StyleBox[\"flush\", \"TI\"]\) is False)."
LinkWrite::usage = "\!\(\*RowBox[{\"LinkWrite\", \"[\", RowBox[{StyleBox[\"link\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) writes \!\(\*StyleBox[\"expr\", \"TI\"]\) to the specified \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) connection. "
Listable::usage = "Listable is an attribute that can be assigned to a symbol \!\(\*StyleBox[\"f\", \"TI\"]\) to indicate that the function \!\(\*StyleBox[\"f\", \"TI\"]\) should automatically be threaded over lists that appear as its arguments. "
ListAnimate::usage = "\!\(\*RowBox[{\"ListAnimate\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates an animation whose frames are the successive \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"ListAnimate\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"fps\", \"TI\"]}], \"]\"}]\) displays \!\(\*StyleBox[\"fps\", \"TI\"]\) frames per second. "
ListContourPlot3D::usage = "\!\(\*RowBox[{\"ListContourPlot3D\", \"[\", StyleBox[\"array\", \"TI\"], \"]\"}]\) generates a contour plot from a three\[Hyphen]dimensional array of values. \n\!\(\*RowBox[{\"ListContourPlot3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a contour plot from values defined at specified points in three\[Hyphen]dimensional space. "
ListContourPlot::usage = "\!\(\*RowBox[{\"ListContourPlot\", \"[\", StyleBox[\"array\", \"TI\"], \"]\"}]\) generates a contour plot from an array of height values. \n\!\(\*RowBox[{\"ListContourPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a contour plot from values defined at specified points. "
ListConvolve::usage = "\!\(\*RowBox[{\"ListConvolve\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"]}], \"]\"}]\) forms the convolution of the kernel \!\(\*StyleBox[\"ker\", \"TI\"]\) with \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"ListConvolve\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) forms the cyclic convolution in which the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) element of \!\(\*StyleBox[\"ker\", \"TI\"]\) is aligned with each element in \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"ListConvolve\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"L\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"R\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) forms the cyclic convolution whose first element contains \!\(\*RowBox[{RowBox[{StyleBox[\"list\", \"TI\"], \"[\", RowBox[{\"[\", \"1\", \"]\"}], \"]\"}], RowBox[{StyleBox[\"ker\", \"TI\"], \"[\", RowBox[{\"[\", SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"L\", \"TI\"]], \"]\"}], \"]\"}]}]\) and whose last element contains \!\(\*RowBox[{RowBox[{StyleBox[\"list\", \"TI\"], \"[\", RowBox[{\"[\", RowBox[{\"-\", \"1\"}], \"]\"}], \"]\"}], RowBox[{StyleBox[\"ker\", \"TI\"], \"[\", RowBox[{\"[\", SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"R\", \"TI\"]], \"]\"}], \"]\"}]}]\). \n\!\(\*RowBox[{\"ListConvolve\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"klist\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) forms the convolution in which \!\(\*StyleBox[\"list\", \"TI\"]\) is padded at each end with repetitions of the element \!\(\*StyleBox[\"p\", \"TI\"]\). \n\!\(\*RowBox[{\"ListConvolve\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"klist\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) forms the convolution in which \!\(\*StyleBox[\"list\", \"TI\"]\) is padded at each end with cyclic repetitions of the \!\(\*SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"ListConvolve\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"klist\", \"TI\"], \",\", StyleBox[\"padding\", \"TI\"], \",\", StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) forms a generalized convolution in which \!\(\*StyleBox[\"g\", \"TI\"]\) is used in place of Times and \!\(\*StyleBox[\"h\", \"TI\"]\) in place of Plus. \n\!\(\*RowBox[{\"ListConvolve\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"klist\", \"TI\"], \",\", StyleBox[\"padding\", \"TI\"], \",\", StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"], \",\", StyleBox[\"lev\", \"TI\"]}], \"]\"}]\) forms a convolution using elements at level \!\(\*StyleBox[\"lev\", \"TI\"]\) in \!\(\*StyleBox[\"ker\", \"TI\"]\) and \!\(\*StyleBox[\"list\", \"TI\"]\). "
ListCorrelate::usage = "\!\(\*RowBox[{\"ListCorrelate\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"]}], \"]\"}]\) forms the correlation of the kernel \!\(\*StyleBox[\"ker\", \"TI\"]\) with \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"ListCorrelate\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) forms the cyclic correlation in which the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) element of \!\(\*StyleBox[\"ker\", \"TI\"]\) is aligned with each element in \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"ListCorrelate\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"L\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"R\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) forms the cyclic correlation whose first element contains \!\(\*RowBox[{RowBox[{StyleBox[\"list\", \"TI\"], \"[\", RowBox[{\"[\", \"1\", \"]\"}], \"]\"}], RowBox[{StyleBox[\"ker\", \"TI\"], \"[\", RowBox[{\"[\", SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"L\", \"TI\"]], \"]\"}], \"]\"}]}]\) and whose last element contains \!\(\*RowBox[{RowBox[{StyleBox[\"list\", \"TI\"], \"[\", RowBox[{\"[\", RowBox[{\"-\", \"1\"}], \"]\"}], \"]\"}], RowBox[{StyleBox[\"ker\", \"TI\"], \"[\", RowBox[{\"[\", SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"R\", \"TI\"]], \"]\"}], \"]\"}]}]\). \n\!\(\*RowBox[{\"ListCorrelate\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"klist\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) forms the correlation in which \!\(\*StyleBox[\"list\", \"TI\"]\) is padded at each end with repetitions of the element \!\(\*StyleBox[\"p\", \"TI\"]\). \n\!\(\*RowBox[{\"ListCorrelate\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"klist\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) forms the correlation in which \!\(\*StyleBox[\"list\", \"TI\"]\) is padded at each end with cyclic repetitions of the \!\(\*SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"ListCorrelate\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"klist\", \"TI\"], \",\", StyleBox[\"padding\", \"TI\"], \",\", StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) forms a generalized correlation in which \!\(\*StyleBox[\"g\", \"TI\"]\) is used in place of Times and \!\(\*StyleBox[\"h\", \"TI\"]\) in place of Plus. \n\!\(\*RowBox[{\"ListCorrelate\", \"[\", RowBox[{StyleBox[\"ker\", \"TI\"], \",\", StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"klist\", \"TI\"], \",\", StyleBox[\"padding\", \"TI\"], \",\", StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"], \",\", StyleBox[\"lev\", \"TI\"]}], \"]\"}]\) forms a correlation using elements at level \!\(\*StyleBox[\"lev\", \"TI\"]\) in \!\(\*StyleBox[\"ker\", \"TI\"]\) and \!\(\*StyleBox[\"list\", \"TI\"]\). "
ListDensityPlot::usage = "\!\(\*RowBox[{\"ListDensityPlot\", \"[\", StyleBox[\"array\", \"TI\"], \"]\"}]\) generates a smooth density plot from an array of values. \n\!\(\*RowBox[{\"ListDensityPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a density plot with values defined at specified points. "
ListInterpolation::usage = "\!\(\*RowBox[{\"ListInterpolation\", \"[\", StyleBox[\"array\", \"TI\"], \"]\"}]\) constructs an InterpolatingFunction object which represents an approximate function that interpolates the array of values given. \n\!\(\*RowBox[{\"ListInterpolation\", \"[\", RowBox[{StyleBox[\"array\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) specifies the domain of the grid from which the values in \!\(\*StyleBox[\"array\", \"TI\"]\) are assumed to come. "
ListLinePlot::usage = "\!\(\*RowBox[{\"ListLinePlot\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots a line through a list of values, assumed to correspond to \!\(\*StyleBox[\"x\", \"TI\"]\) coordinates 1, 2, \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\). \n\!\(\*RowBox[{\"ListLinePlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots a line through specific \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\) positions. \n\!\(\*RowBox[{\"ListLinePlot\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots several lines. "
ListLogLinearPlot::usage = "\!\(\*RowBox[{\"ListLogLinearPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) makes a log-linear plot of the specified list of \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\) values.\n\!\(\*RowBox[{\"ListLogLinearPlot\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots several lists of values."
ListLogLogPlot::usage = "\!\(\*RowBox[{\"ListLogLogPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) makes a log-log plot of the specified list of \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\) values.\n\!\(\*RowBox[{\"ListLogLogPlot\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots several lists of values."
ListLogPlot::usage = "\!\(\*RowBox[{\"ListLogPlot\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) makes a log plot of the \!\(\*SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"i\", \"TI\"]]\), assumed to correspond to \!\(\*StyleBox[\"x\", \"TI\"]\) coordinates 1, 2, \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\).\n\!\(\*RowBox[{\"ListLogPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) makes a log plot of the specified list of \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\) values.\n\!\(\*RowBox[{\"ListLogPlot\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots several lists of values."
List::usage = "\!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\) is a list of elements. "
ListPlay::usage = "\!\(\*RowBox[{\"ListPlay\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) creates an object that plays as a sound whose amplitude is given by the sequence of levels \!\(\*SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
ListPlot3D::usage = "\!\(\*RowBox[{\"ListPlot3D\", \"[\", StyleBox[\"array\", \"TI\"], \"]\"}]\) generates a three\[Hyphen]dimensional plot of a surface representing an array of height values. \n\!\(\*RowBox[{\"ListPlot3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a plot of the surface with heights \!\(\*SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) at positions \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"i\", \"TI\"]]}], \"}\"}]\). \n\!\(\*RowBox[{\"ListPlot3D\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"data\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"data\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots the surfaces corresponding to each of the \!\(\*SubscriptBox[StyleBox[\"data\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
ListPlot::usage = "\!\(\*RowBox[{\"ListPlot\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots points corresponding to a list of values, assumed to correspond to \!\(\*StyleBox[\"x\", \"TI\"]\) coordinates 1, 2, \[Ellipsis]. \n\!\(\*RowBox[{\"ListPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots a list of points with specified \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\) coordinates. \n\!\(\*RowBox[{\"ListPlot\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots several lists of points. "
ListPointPlot3D::usage = "\!\(\*RowBox[{\"ListPointPlot3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a 3D scatter plot of points with coordinates \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"i\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"i\", \"TI\"]]}], \"}\"}]\). \n\!\(\*RowBox[{\"ListPointPlot3D\", \"[\", StyleBox[\"array\", \"TI\"], \"]\"}]\) generates a 3D scatter plot of points with a 2D array of height values.\n\!\(\*RowBox[{\"ListPointPlot3D\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"data\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"data\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots several collections of points, by default in different colors. "
ListPolarPlot::usage = "\!\(\*RowBox[{\"ListPolarPlot\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots points equally spaced in angle at radii \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"i\", \"TI\"]]\).\n\!\(\*RowBox[{\"ListPolarPlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots points at polar coordinates \!\(\*SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"i\", \"TI\"]]\), \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"i\", \"TI\"]]\).\n\!\(\*RowBox[{\"ListPolarPlot\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots several lists of values."
ListQ::usage = "\!\(\*RowBox[{\"ListQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a list, and False otherwise."
ListSurfacePlot3D::usage = "\!\(\*RowBox[{\"ListSurfacePlot3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) plots a three\[Hyphen]dimensional surface constructed to fit the specified points. "
LocalizeVariables::usage = "LocalizeVariables is an option to Manipulate which determines whether the values of variables associated with controls should be localized."
LocatorAutoCreate::usage = "LocatorAutoCreate is an option for LocatorPane, Manipulate and related functions which specifies whether new locators should be created when clicking away from existing locators."
Locator::usage = "\!\(\*RowBox[{\"Locator\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \"]\"}]\) represents a locator object at position \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}]\) in a graphic. \n\!\(\*RowBox[{\"Locator\", \"[\", RowBox[{\"Dynamic\", \"[\", StyleBox[\"pos\", \"TI\"], \"]\"}], \"]\"}]\) takes the position to be the dynamically updated current value of \!\(\*StyleBox[\"pos\", \"TI\"]\), with this value being reset if the locator object is moved. \n\!\(\*RowBox[{\"Locator\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"obj\", \"TI\"]}], \"]\"}]\) displays \!\(\*StyleBox[\"obj\", \"TI\"]\) as the locator object. \n\!\(\*RowBox[{\"Locator\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \",\", \"None\"}], \"]\"}]\) displays nothing visible as the locator object. "
LocatorPane::usage = "\!\(\*RowBox[{\"LocatorPane\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"back\", \"TI\"]}], \"]\"}]\) represents a pane with a locator at position \!\(\*RowBox[{\"{\", RowBox[{\"x\", \",\", \"y\"}], \"}\"}]\) and background \!\(\*StyleBox[\"back\", \"TI\"]\).\n\!\(\*RowBox[{\"LocatorPane\", \"[\", RowBox[{RowBox[{\"Dynamic\", \"[\", StyleBox[\"pt\", \"TI\"], \"]\"}], \",\", StyleBox[\"back\", \"TI\"]}], \"]\"}]\) takes the locator position to be the dynamically updated current value of \!\(\*StyleBox[\"pt\", \"TI\"]\), with the value of \!\(\*StyleBox[\"pt\", \"TI\"]\) being reset if the locator is moved.\n\!\(\*RowBox[{\"LocatorPane\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"back\", \"TI\"]}], \"]\"}]\) sets up multiple locators at positions \!\(\*RowBox[{RowBox[{\"p\", \"\[InvisibleSpace]\", SubscriptBox[\"t\", \"1\"]}], \",\", RowBox[{\"p\", \"\[InvisibleSpace]\", SubscriptBox[\"t\", \"2\"]}], \",\", \"\[Ellipsis]\"}]\). \n\!\(\*RowBox[{\"LocatorPane\", \"[\", RowBox[{RowBox[{\"Dynamic\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}], \",\", StyleBox[\"back\", \"TI\"]}], \"]\"}]\) takes the locator positions to be dynamically updated current values of the \!\(\*RowBox[{\"p\", \"\[InvisibleSpace]\", SubscriptBox[\"t\", \"i\"]}]\).\n\!\(\*RowBox[{\"LocatorPane\", \"[\", RowBox[{StyleBox[\"pts\", \"TI\"], \",\", StyleBox[\"back\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"}\"}]}], \"]\"}]\) specifies the range of coordinates for the locator.\n\!\(\*RowBox[{\"LocatorPane\", \"[\", RowBox[{StyleBox[\"pts\", \"TI\"], \",\", StyleBox[\"back\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"dx\", \"TI\"], \",\", StyleBox[\"dy\", \"TI\"]}], \"}\"}]}], \"}\"}]}], \"]\"}]\) uses jumps \!\(\*StyleBox[\"dx\", \"TI\"]\), \!\(\*StyleBox[\"dy\", \"TI\"]\). "
LocatorRegion::usage = "LocatorRegion is an option for Locator which specifies where the locator object should by default be allowed to go when it is dragged."
Locked::usage = "Locked is an attribute which, once assigned, prevents modification of any attributes of a symbol. "
LogGamma::usage = "\!\(\*RowBox[{\"LogGamma\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the logarithm of the gamma function \!\(\*RowBox[{\"log\", \" \", RowBox[{\"\[CapitalGamma]\", \"(\", \"z\", \")\"}]}]\). "
LogicalExpand::usage = "\!\(\*RowBox[{\"LogicalExpand\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) expands out expressions containing logical connectives such as && and\[NonBreakingSpace]||. "
LogIntegral::usage = "\!\(\*RowBox[{\"LogIntegral\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) is the logarithmic integral function \!\(\*RowBox[{\"li\", \"(\", \"z\", \")\"}]\). "
LogisticDistribution::usage = "\!\(\*RowBox[{\"LogisticDistribution\", \"[\", RowBox[{StyleBox[\"\[Mu]\", \"TR\"], \",\", StyleBox[\"\[Beta]\", \"TR\"]}], \"]\"}]\) represents a logistic distribution with mean \!\(\*StyleBox[\"\[Mu]\", \"TR\"]\) and scale parameter \!\(\*StyleBox[\"\[Beta]\", \"TR\"]\)."
LogLinearPlot::usage = "\!\(\*RowBox[{\"LogLinearPlot\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a log-linear plot of \!\(\*StyleBox[\"f\", \"TI\"]\) as a function of \!\(\*StyleBox[\"x\", \"TI\"]\) from \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"LogLinearPlot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates log-linear plots of several functions \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
LogLogPlot::usage = "\!\(\*RowBox[{\"LogLogPlot\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a log-log plot of \!\(\*StyleBox[\"f\", \"TI\"]\) as function of \!\(\*StyleBox[\"x\", \"TI\"]\) from \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"LogLogPlot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates log-log plots of several functions \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
Log::usage = "\!\(\*RowBox[{\"Log\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the natural logarithm of \!\(\*StyleBox[\"z\", \"TI\"]\) (logarithm to base \!\(\*StyleBox[\"e\", \"TI\"]\)). \n\!\(\*RowBox[{\"Log\", \"[\", RowBox[{StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the logarithm to base \!\(\*StyleBox[\"b\", \"TI\"]\). "
LogNormalDistribution::usage = "\!\(\*RowBox[{\"LogNormalDistribution\", \"[\", RowBox[{StyleBox[\"\[Mu]\", \"TR\"], \",\", StyleBox[\"\[Sigma]\", \"TR\"]}], \"]\"}]\) represents a lognormal distribution derived from a normal distribution with mean \!\(\*StyleBox[\"\[Mu]\", \"TR\"]\) and standard deviation \!\(\*StyleBox[\"\[Sigma]\", \"TR\"]\)."
LogPlot::usage = "\!\(\*RowBox[{\"LogPlot\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a log plot of \!\(\*StyleBox[\"f\", \"TI\"]\) as a function of \!\(\*StyleBox[\"x\", \"TI\"]\) from \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"LogPlot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates log plots of several functions \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
LogSeriesDistribution::usage = "\!\(\*RowBox[{\"LogSeriesDistribution\", \"[\", StyleBox[\"\[Theta]\", \"TR\"], \"]\"}]\) represents a logarithmic series distribution with parameter \!\(\*StyleBox[\"\[Theta]\", \"TR\"]\)."
LongestMatch::usage = "LongestMatch[\!\(\*StyleBox[\"p\", \"TI\"]\)] is a string pattern object matching the longest sequence of characters consistent with the string pattern \!\(\*StyleBox[\"p\", \"TI\"]\)."
Longest::usage = "\!\(\*RowBox[{\"Longest\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) is a pattern object that matches the longest sequence consistent with the pattern \!\(\*StyleBox[\"p\", \"TI\"]\). "
LongForm::usage = "LongForm is an option for Information. With \!\(\*RowBox[{\"LongForm\", \" \", \"->\", \" \", \"True\"}]\), the full information of a symbol is printed. With \!\(\*RowBox[{\"LongForm\", \" \", \"->\", \" \", \"False\"}]\) the usage of a symbol is printed."
LongLeftArrow::usage = "\!\(\*RowBox[{\"LongLeftArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LongLeftArrow]\", \"y\", \"\[LongLeftArrow]\", \"\[Ellipsis]\"}]\)."
LongLeftRightArrow::usage = "\!\(\*RowBox[{\"LongLeftRightArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LongLeftRightArrow]\", \"y\", \"\[LongLeftRightArrow]\", \"\[Ellipsis]\"}]\)."
LongRightArrow::usage = "\!\(\*RowBox[{\"LongRightArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LongRightArrow]\", \"y\", \"\[LongRightArrow]\", \"\[Ellipsis]\"}]\)."
LowerCaseQ::usage = "\!\(\*RowBox[{\"LowerCaseQ\", \"[\", StyleBox[\"string\", \"TI\"], \"]\"}]\) yields True if all the characters in the string are lowercase letters, and yields False otherwise. "
LowerLeftArrow::usage = "\!\(\*RowBox[{\"LowerLeftArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LowerLeftArrow]\", \"y\", \"\[LowerLeftArrow]\", \"\[Ellipsis]\"}]\)."
LowerRightArrow::usage = "\!\(\*RowBox[{\"LowerRightArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[LowerRightArrow]\", \"y\", \"\[LowerRightArrow]\", \"\[Ellipsis]\"}]\)."
LucasL::usage = "\!\(\*RowBox[{\"LucasL\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the Lucas number \!\(\*SubscriptBox[\"L\", \"n\"]\)."
LUDecomposition::usage = "\!\(\*RowBox[{\"LUDecomposition\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) generates a representation of the LU decomposition of a square matrix\[NonBreakingSpace]\!\(\*StyleBox[\"m\", \"TI\"]\). "
MachineID::usage = "MachineID is an option to Encode which specifies the required value of $MachineID on the computer that reads the encoded file. If no value is specified, any value of $MachineID is allowed on the file-reading computer. A setting for MachineID must be a string."
MachineName::usage = "MachineName is an option to Encode which specifies the required value of $MachineName on the computer that reads the encoded file. If no value is specified, any value of $MachineName is allowed on the file-reading computer. A setting for MachineName must be a string."
MachineNumberQ::usage = "\!\(\*RowBox[{\"MachineNumberQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) returns True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a machine\[Hyphen]precision real or complex number, and returns False otherwise. "
MachinePrecision::usage = "MachinePrecision is a symbol used to indicate machine\[Hyphen]number precision. "
Magenta::usage = "Magenta represents the color magenta in graphics or style specifications. "
Magnification::usage = "Magnification is an option for Style and Cell which specifies what magnification to use for display. "
Magnify::usage = "\!\(\*RowBox[{\"Magnify\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) represents an object to be displayed with magnification \!\(\*StyleBox[\"r\", \"TI\"]\). \n\!\(\*RowBox[{\"Magnify\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) display with \!\(\*StyleBox[\"expr\", \"TI\"]\) magnified by a fixed factor."
MainSolve::usage = "\!\(\*RowBox[{\"MainSolve\", \"[\", StyleBox[\"eqns\", \"TI\"], \"]\"}]\) is the underlying function for transforming systems of equations. Solve and Eliminate call it. The equations must be of the form \!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \" \", \"==\", \" \", StyleBox[\"rhs\", \"TI\"]}]\). They can be combined using && and ||. MainSolve returns False if no solutions to the equations exist, and True if all values of variables are solutions. MainSolve rearranges the equations using certain directives. \!\(\*RowBox[{\"MainSolve\", \"[\", RowBox[{StyleBox[\"eqns\", \"TI\"], \",\", \" \", StyleBox[\"vars\", \"TI\"], \",\", \" \", StyleBox[\"elim\", \"TI\"], \",\", \" \", StyleBox[\"rest\", \"TI\"]}], \"]\"}]\) attempts to rearrange the equations \!\(\*StyleBox[\"eqns\", \"TI\"]\) so as to solve for the variables \!\(\*StyleBox[\"vars\", \"TI\"]\), and eliminate the variables \!\(\*StyleBox[\"elim\", \"TI\"]\). The list \!\(\*StyleBox[\"rest\", \"TI\"]\) can be included to specify the elimination order for any remaining variables."
MakeBoxes::usage = "\!\(\*RowBox[{MakeBoxes, \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) is the low\[Hyphen]level function used in \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) sessions to convert expressions into boxes. \n\!\(\*RowBox[{MakeBoxes, \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) is the function to convert \!\(\*StyleBox[\"expr\", \"TI\"]\) to StandardForm boxes."
MakeExpression::usage = "\!\(\*RowBox[{\"MakeExpression\", \"[\", RowBox[{StyleBox[\"boxes\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) is the low\[Hyphen]level function used in \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) sessions to construct expressions from boxes. "
MakeRules::usage = "MakeRules is an option to Solve and related functions. With \!\(\*RowBox[{\"MakeRules\", \" \", \"->\", \" \", \"True\"}]\), the result is presented as an AlgebraicRulesData object. With \!\(\*RowBox[{\"MakeRules\", \" \", \"->\", \" \", \"False\"}]\), the result is presented as a list of rules."
ManhattanDistance::usage = "\!\(\*RowBox[{\"ManhattanDistance\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the Manhattan or \"city block\" distance between vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
Manipulate::usage = "\!\(\*RowBox[{\"Manipulate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a version of \!\(\*StyleBox[\"expr\", \"TI\"]\) with controls added to allow interactive manipulation of the value of \!\(\*StyleBox[\"u\", \"TI\"]\). \n\!\(\*RowBox[{\"Manipulate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"du\", \"TI\"]}], \"}\"}]}], \"]\"}]\) allows the value of \!\(\*StyleBox[\"u\", \"TI\"]\) to vary between \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) in steps \!\(\*StyleBox[\"du\", \"TI\"]\). \n\!\(\*RowBox[{\"Manipulate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"init\", \"TI\"]]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) takes the initial value of \!\(\*StyleBox[\"u\", \"TI\"]\) to be \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"init\", \"TI\"]]\). \n\!\(\*RowBox[{\"Manipulate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"init\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"lbl\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) labels the controls for \!\(\*StyleBox[\"u\", \"TI\"]\) with \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"lbl\", \"TI\"]]\). \n\!\(\*RowBox[{\"Manipulate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"}\"}]}], \"]\"}]\) allows \!\(\*StyleBox[\"u\", \"TI\"]\) to take on discrete values \!\(\*RowBox[{SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\). \n\!\(\*RowBox[{\"Manipulate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) provides controls to manipulate each of the \!\(\*RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\). \n\!\(\*RowBox[{\"Manipulate\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"u\", \"TI\"]], \"->\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \",\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"v\", \"TI\"]], \"->\", RowBox[{\"{\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) links the controls to the specified controllers on an external device."
Manipulator::usage = "\!\(\*RowBox[{\"Manipulator\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) represents a manipulator with setting \!\(\*StyleBox[\"x\", \"TI\"]\) in the range 0 to 1. \n\!\(\*RowBox[{\"Manipulator\", \"[\", RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\), with the value of \!\(\*StyleBox[\"x\", \"TI\"]\) being reset if the manipulator is moved. \n\!\(\*RowBox[{\"Manipulator\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) represents a manipulator with range \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"Manipulator\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"dx\", \"TI\"]}], \"}\"}]}], \"]\"}]\) represents a manipulator that jumps in steps \!\(\*StyleBox[\"dx\", \"TI\"]\). "
MantissaExponent::usage = "\!\(\*RowBox[{\"MantissaExponent\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives a list containing the mantissa and exponent of a number \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"MantissaExponent\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives the base\[Hyphen]\!\(\*StyleBox[\"b\", \"TI\"]\) mantissa and exponent of \!\(\*StyleBox[\"x\", \"TI\"]\). "
Manual::usage = "Manual represents an option or other value that is to be selected manually, usually by some form of interactive manipulation."
MapAll::usage = "\!\(\*RowBox[{\"MapAll\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) or \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"//@\", StyleBox[\"expr\", \"TI\"]}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to every subexpression in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
MapAt::usage = "\!\(\*RowBox[{\"MapAt\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to the element at position \!\(\*StyleBox[\"n\", \"TI\"]\) in \!\(\*StyleBox[\"expr\", \"TI\"]\). If \!\(\*StyleBox[\"n\", \"TI\"]\) is negative, the position is counted from the end. \n\!\(\*RowBox[{\"MapAt\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to the part of \!\(\*StyleBox[\"expr\", \"TI\"]\) at position \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\). \n\!\(\*RowBox[{\"MapAt\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) at several positions. "
MapIndexed::usage = "\!\(\*RowBox[{\"MapIndexed\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to the elements of \!\(\*StyleBox[\"expr\", \"TI\"]\), giving the part specification of each element as a second argument to \!\(\*StyleBox[\"f\", \"TI\"]\). \n\!\(\*RowBox[{\"MapIndexed\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to all parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) on levels specified by \!\(\*StyleBox[\"levelspec\", \"TI\"]\). "
Map::usage = "\!\(\*RowBox[{\"Map\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) or \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"/@\", StyleBox[\"expr\", \"TI\"]}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to each element on the first level in \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Map\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) specified by \!\(\*StyleBox[\"levelspec\", \"TI\"]\). "
MapThread::usage = "\!\(\*RowBox[{\"MapThread\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives \!\(\*RowBox[{\"{\", RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}], \",\", RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\). \n\!\(\*RowBox[{\"MapThread\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to the parts of the \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) at level \!\(\*StyleBox[\"n\", \"TI\"]\). "
MatchingDissimilarity::usage = "\!\(\*RowBox[{\"MatchingDissimilarity\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the matching dissimilarity between Boolean vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
MatchLocalNameQ::usage = "MatchLocalNameQ is an internal symbol."
MatchLocalNames::usage = "MatchLocalNames is an option for Trace and related functions which specifies whether symbols such as \!\(\*StyleBox[\"x\", \"TI\"]\) should match symbols with local names of the form \!\(\*StyleBox[RowBox[{StyleBox[\"x\", \"TI\"], \"$\", StyleBox[\"nnn\", \"TI\"]}]]\). "
MatchQ::usage = "\!\(\*RowBox[{\"MatchQ\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) returns True if the pattern \!\(\*StyleBox[\"form\", \"TI\"]\) matches \!\(\*StyleBox[\"expr\", \"TI\"]\), and returns False otherwise. "
MathieuCharacteristicA::usage = "\!\(\*RowBox[{\"MathieuCharacteristicA\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"]}], \"]\"}]\) gives the characteristic value \!\(\*SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"r\", \"TI\"]]\) for even Mathieu functions with characteristic exponent \!\(\*StyleBox[\"r\", \"TI\"]\) and parameter \!\(\*StyleBox[\"q\", \"TI\"]\). "
MathieuCharacteristicB::usage = "\!\(\*RowBox[{\"MathieuCharacteristicB\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"]}], \"]\"}]\) gives the characteristic value \!\(\*SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"r\", \"TI\"]]\) for odd Mathieu functions with characteristic exponent \!\(\*StyleBox[\"r\", \"TI\"]\) and parameter \!\(\*StyleBox[\"q\", \"TI\"]\). "
MathieuCharacteristicExponent::usage = "\!\(\*RowBox[{\"MathieuCharacteristicExponent\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"]}], \"]\"}]\) gives the characteristic exponent \!\(\*StyleBox[\"r\", \"TI\"]\) for Mathieu functions with characteristic value \!\(\*StyleBox[\"a\", \"TI\"]\) and parameter \!\(\*StyleBox[\"q\", \"TI\"]\). "
MathieuC::usage = "\!\(\*RowBox[{\"MathieuC\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the even Mathieu function with characteristic value \!\(\*StyleBox[\"a\", \"TI\"]\) and parameter\[NonBreakingSpace]\!\(\*StyleBox[\"q\", \"TI\"]\). "
MathieuCPrime::usage = "\!\(\*RowBox[{\"MathieuCPrime\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the derivative with respect to \!\(\*StyleBox[\"z\", \"TI\"]\) of the even Mathieu function with characteristic value \!\(\*StyleBox[\"a\", \"TI\"]\) and parameter \!\(\*StyleBox[\"q\", \"TI\"]\). "
MathieuS::usage = "\!\(\*RowBox[{\"MathieuS\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the odd Mathieu function with characteristic value \!\(\*StyleBox[\"a\", \"TI\"]\) and parameter\[NonBreakingSpace]\!\(\*StyleBox[\"q\", \"TI\"]\). "
MathieuSPrime::usage = "\!\(\*RowBox[{\"MathieuSPrime\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the derivative with respect to \!\(\*StyleBox[\"z\", \"TI\"]\) of the odd Mathieu function with characteristic value \!\(\*StyleBox[\"a\", \"TI\"]\) and parameter \!\(\*StyleBox[\"q\", \"TI\"]\). "
MathMLForm::usage = "\!\(\*RowBox[{\"MathMLForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints as a MathML form of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
MatrixExp::usage = "\!\(\*RowBox[{\"MatrixExp\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the matrix exponential of \!\(\*StyleBox[\"m\", \"TI\"]\). \n\!\(\*RowBox[{\"MatrixExp\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the matrix exponential of \!\(\*StyleBox[\"m\", \"TI\"]\) applied to the vector \!\(\*StyleBox[\"v\", \"TI\"]\)."
MatrixForm::usage = "\!\(\*RowBox[{\"MatrixForm\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) prints with the elements of \!\(\*StyleBox[\"list\", \"TI\"]\) arranged in a regular array. "
MatrixPlot::usage = "\!\(\*RowBox[{\"MatrixPlot\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) generates a plot that gives a visual representation of the values of elements in a matrix."
MatrixPower::usage = "\!\(\*RowBox[{\"MatrixPower\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[RowBox[{StyleBox[\"n\", \"TI\"], \"\[Null]\"}]]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) matrix power of the matrix \!\(\*StyleBox[\"m\", \"TI\"]\). \n\!\(\*RowBox[{\"MatrixPower\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) matrix power of the matrix \!\(\*StyleBox[\"m\", \"TI\"]\) applied to the vector \!\(\*StyleBox[\"v\", \"TI\"]\)."
MatrixQ::usage = "\!\(\*RowBox[{\"MatrixQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a list of lists or a two\[Hyphen]dimensional SparseArray object that can represent a matrix, and gives False otherwise. \n\!\(\*RowBox[{\"MatrixQ\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"]}], \"]\"}]\) gives True only if \!\(\*StyleBox[\"test\", \"TI\"]\) yields True when applied to each of the matrix elements in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
MatrixRank::usage = "\!\(\*RowBox[{\"MatrixRank\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the rank of the matrix \!\(\*StyleBox[\"m\", \"TI\"]\). "
Maximize::usage = "\!\(\*RowBox[{\"Maximize\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) maximizes \!\(\*StyleBox[\"f\", \"TI\"]\) with respect to \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"y\", \"TI\"]\), \[Ellipsis]. \n\!\(\*RowBox[{\"Maximize\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"cons\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) maximizes \!\(\*StyleBox[\"f\", \"TI\"]\) subject to the constraints \!\(\*StyleBox[\"cons\", \"TI\"]\). \n\!\(\*RowBox[{\"Maximize\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"cons\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"dom\", \"TI\"]}], \"]\"}]\) maximizes with variables over the domain \!\(\*StyleBox[\"dom\", \"TI\"]\), typically Reals or Integers."
MaxIterations::usage = "MaxIterations is an option that specifies the maximum number of iterations that should be tried in various built-in functions and algorithms."
MaxMemoryUsed::usage = "\!\(\*RowBox[{\"MaxMemoryUsed\", \"[\", \"]\"}]\) gives the maximum number of bytes used to store all data for the current \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) session. "
Max::usage = "\!\(\*RowBox[{\"Max\", \"[\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) yields the numerically largest of the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Max\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) yields the largest element of any of the lists. "
MaxPlotPoints::usage = "MaxPlotPoints is an option for plotting functions like ArrayPlot and ListPlot3D that specifies the maximum number of points that will explicitly be included in the output. "
MaxPoints::usage = "MaxPoints is an option for NIntegrate specifying the maximum total number of times to sample the integrand."
MaxRecursion::usage = "MaxRecursion is an option for functions like NIntegrate and Plot that specifies how many recursive subdivisions can be made. "
MaxStepFraction::usage = "MaxStepFraction is an option to functions like NDSolve that specifies the maximum fraction of the total range to cover in a single step."
MaxStepSize::usage = "MaxStepSize is an option to functions like NDSolve that specifies the maximum size of a single step used in generating a result."
MaxSteps::usage = "MaxSteps is an option to functions like NDSolve that specifies the maximum number of steps to take in generating a result."
MaxwellDistribution::usage = "\!\(\*RowBox[{\"MaxwellDistribution\", \"[\", StyleBox[\"\[Sigma]\", \"TR\"], \"]\"}]\) represents a Maxwell distribution with scale parameter \!\(\*StyleBox[\"\[Sigma]\", \"TR\"]\)."
MeanDeviation::usage = "\!\(\*RowBox[{\"MeanDeviation\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the mean absolute deviation from the mean of the elements in \!\(\*StyleBox[\"list\", \"TI\"]\)."
Mean::usage = "\!\(\*RowBox[{\"Mean\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the statistical mean of the elements in \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Mean\", \"[\", StyleBox[\"dist\", \"TI\"], \"]\"}]\) gives the mean of the symbolic distribution \!\(\*StyleBox[\"dist\", \"TI\"]\)."
MedianDeviation::usage = "\!\(\*RowBox[{\"MedianDeviation\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the median absolute deviation from the median of the elements in \!\(\*StyleBox[\"list\", \"TI\"]\)."
Median::usage = "\!\(\*RowBox[{\"Median\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the median of the elements in \!\(\*StyleBox[\"list\", \"TI\"]\). "
Medium::usage = "Medium is a style or option setting that specifies that objects should be medium-sized."
MeijerG::usage = "\!\(\*RowBox[{\"MeijerG\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], RowBox[{StyleBox[\"n\", \"TI\"], \"+\", StyleBox[\"1\", \"TR\"]}]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"p\", \"TI\"]]}], \"}\"}]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"m\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"b\", \"TI\"], RowBox[{StyleBox[\"m\", \"TI\"], \"+\", StyleBox[\"1\", \"TR\"]}]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"q\", \"TI\"]]}], \"}\"}]}], \"}\"}], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the Meijer G function \!\(\*RowBox[{SubsuperscriptBox[\"G\", RowBox[{\"p\", \"q\"}], RowBox[{\"m\", \"n\"}]], \"(\", RowBox[{\"z\", \"\[VerticalSeparator]\", GridBox[{{RowBox[{SubscriptBox[\"a\", \"1\"], \",\", \"\[Ellipsis]\", \",\", SubscriptBox[\"a\", \"p\"]}]}, {RowBox[{SubscriptBox[\"b\", \"1\"], \",\", \"\[Ellipsis]\", \",\", SubscriptBox[\"b\", \"q\"]}]}}]}], \")\"}]\). "
MemberQ::usage = "\!\(\*RowBox[{\"MemberQ\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) returns True if an element of \!\(\*StyleBox[\"list\", \"TI\"]\) matches \!\(\*StyleBox[\"form\", \"TI\"]\), and False otherwise. \n\!\(\*RowBox[{\"MemberQ\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"]}], \"]\"}]\) tests all parts of \!\(\*StyleBox[\"list\", \"TI\"]\) specified by \!\(\*StyleBox[\"levelspec\", \"TI\"]\). "
MemoryConstrained::usage = "\!\(\*RowBox[{\"MemoryConstrained\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\), stopping if more than \!\(\*StyleBox[\"b\", \"TI\"]\) bytes of memory are requested. \n\!\(\*RowBox[{\"MemoryConstrained\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"failexpr\", \"TI\"]}], \"]\"}]\) returns \!\(\*StyleBox[\"failexpr\", \"TI\"]\) if the memory constraint is not met. "
MemoryInUse::usage = "\!\(\*RowBox[{\"MemoryInUse\", \"[\", \"]\"}]\) gives the number of bytes currently being used to store all data in the current \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) kernel session. \n\!\(\*RowBox[{\"MemoryInUse\", \"[\", \"$FrontEnd\", \"]\"}]\) gives the number of bytes used in the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) front end."
MenuPacket::usage = "\!\(\*RowBox[{\"MenuPacket\", \"[\", RowBox[{StyleBox[\"integer\", \"TI\"], \",\", StyleBox[\"string\", \"TI\"]}], \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet indicating a menu request with title \!\(\*StyleBox[\"string\", \"TI\"]\)."
MenuView::usage = "\!\(\*RowBox[{\"MenuView\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", \" \", RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", \" \", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents an object in which selecting the menu item with label \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) displays \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"MenuView\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", \" \", RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", \" \", \"\[Ellipsis]\"}], \"}\"}], \",\", StyleBox[\"i\", \"TI\"]}], \"]\"}]\) makes the \!\(\*StyleBox[\"i\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) item be the one currently selected.\n\!\(\*RowBox[{\"MenuView\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]}]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]}]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) associates values \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) with successive menu items, and makes the item with value \!\(\*StyleBox[\"v\", \"TI\"]\) be the one currently selected. \n\!\(\*RowBox[{\"MenuView\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) takes the menu items\[CloseCurlyQuote] labels to be successive integers."
MeshFunctions::usage = "MeshFunctions is an option for plotting functions that specifies functions to use to determine the placement of mesh divisions. "
Mesh::usage = "Mesh is an option for Plot3D, DensityPlot and other plotting functions that specifies what mesh should be drawn. "
MeshShading::usage = "MeshShading is an option for plotting functions that gives lists of colors to use for regions between mesh divisions. "
MeshStyle::usage = "MeshStyle is an option for Plot3D, DensityPlot and other plotting functions that specifies the style in which to draw a mesh. "
MessageDialog::usage = "\!\(\*RowBox[{\"MessageDialog\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) puts up a standard message dialog that displays \!\(\*StyleBox[\"expr\", \"TI\"]\) together with an \!\(\*StyleBox[\"OK\", \"DialogElementName\"]\) button.\n\!\(\*RowBox[{\"MessageDialog\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]], \":>\", SubscriptBox[StyleBox[\"act\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]], \":>\", SubscriptBox[StyleBox[\"act\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) includes buttons with labels \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"i\", \"TI\"]]\), which evaluate the corresponding \!\(\*SubscriptBox[StyleBox[\"act\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) if clicked."
MessageList::usage = "\!\(\*RowBox[{\"MessageList\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) is a global object assigned to be a list of the names of messages generated during the processing of the \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) input line. "
MessageName::usage = "\!\(\*RowBox[{StyleBox[\"symbol\", \"TI\"], \"::\", StyleBox[\"tag\", \"TI\"]}]\) is a name for a message. "
Message::usage = "\!\(\*RowBox[{\"Message\", \"[\", RowBox[{StyleBox[\"symbol\", \"TI\"], \"::\", StyleBox[\"tag\", \"TI\"]}], \"]\"}]\) prints the message \!\(\*RowBox[{StyleBox[\"symbol\", \"TI\"], \"::\", StyleBox[\"tag\", \"TI\"]}]\) unless it has been switched off. \n\!\(\*RowBox[{\"Message\", \"[\", RowBox[{RowBox[{StyleBox[\"symbol\", \"TI\"], \"::\", StyleBox[\"tag\", \"TI\"]}], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) prints a message, inserting the values of the \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) as needed. "
MessagePacket::usage = "\!\(\*RowBox[{\"MessagePacket\", \"[\", RowBox[{StyleBox[\"symbol\", \"TI\"], \",\", StyleBox[\"string\", \"TI\"]}], \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet containing a \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) message identifier of the form \!\(\*StyleBox[\"symbol\", \"TI\"]\)::\!\(\*StyleBox[\"string\", \"TI\"]\)\!\(\*StyleBox[\".\", \"TR\"]\)"
Messages::usage = "\!\(\*RowBox[{\"Messages\", \"[\", StyleBox[\"symbol\", \"TI\"], \"]\"}]\) gives all the messages assigned to a particular symbol. "
MetaCharacters::usage = "MetaCharacters is an option to StringPosition. With \!\(\*RowBox[{\"MetaCharacters\", \" \", \"->\", \" \", \"None\"}]\), no strings have special meanings. \!\(\*RowBox[{\"MetaCharacters\", \" \", \"->\", \" \", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", \" \", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", \" \", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"3\", \"TR\"]]}], \"}\"}]}]\) specifies the metacharacters for pattern escape, single character matching and multiple character matching. \!\(\*RowBox[{\"MetaCharacters\", \" \", \"->\", \" \", \"Automatic\"}]\) is equivalent to MetaCharacters -> {\"\\\\\", \".\", \"*\"}."
Method::usage = "Method is an option for various algorithm-intensive functions that specifies what internal methods they should use."
MinimalPolynomial::usage = "\!\(\*RowBox[{\"MinimalPolynomial\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the minimal polynomial in \!\(\*StyleBox[\"x\", \"TI\"]\) for which the algebraic number \!\(\*StyleBox[\"s\", \"TI\"]\) is a root. "
Minimize::usage = "\!\(\*RowBox[{\"Minimize\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) minimizes \!\(\*StyleBox[\"f\", \"TI\"]\) with respect to \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"y\", \"TI\"]\), \[Ellipsis]. \n\!\(\*RowBox[{\"Minimize\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"cons\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) minimizes \!\(\*StyleBox[\"f\", \"TI\"]\) subject to the constraints \!\(\*StyleBox[\"cons\", \"TI\"]\). \n\!\(\*RowBox[{\"Minimize\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"cons\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"dom\", \"TI\"]}], \"]\"}]\) minimizes with variables over the domain \!\(\*StyleBox[\"dom\", \"TI\"]\), typically Reals or Integers."
Min::usage = "\!\(\*RowBox[{\"Min\", \"[\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) yields the numerically smallest of the \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Min\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) yields the smallest element of any of the lists. "
Minors::usage = "\!\(\*RowBox[{\"Minors\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the minors of a matrix \!\(\*StyleBox[\"m\", \"TI\"]\). \n\!\(\*RowBox[{\"Minors\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives \!\(\*StyleBox[RowBox[{StyleBox[\"k\", \"TI\"], \"\[Null]\"}]]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) minors. "
MinRecursion::usage = "MinRecursion is an option for NIntegrate and other numerical functions that use a recursive algorithm. With \!\(\*RowBox[{\"MinRecursion\", \" \", \"->\", \" \", StyleBox[\"n\", \"TI\"]}]\), a minimum depth of recursion of \!\(\*StyleBox[\"n\", \"TI\"]\) is used before tests for convergence begin."
MinSize::usage = "MinSize is an option of certain BoxForm primitives."
Minus::usage = "\!\(\*RowBox[{\"-\", StyleBox[\"x\", \"TI\"]}]\) is the arithmetic negation of \!\(\*StyleBox[\"x\", \"TI\"]\). "
MinusPlus::usage = "\!\(\*RowBox[{\"MinusPlus\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) displays as \!\(\*RowBox[{\"\[MinusPlus]\", \"x\"}]\).\n\!\(\*RowBox[{\"MinusPlus\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{RowBox[{\"x\", \"\[MinusPlus]\", \"y\"}], \"\[MinusPlus]\", \"\[Ellipsis]\"}]\)."
Missing::usage = "\!\(\*RowBox[{\"Missing\", \"[\", \"]\"}]\) represents data that is missing.\n\!\(\*RowBox[{\"Missing\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"reason\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) specifies a reason for the data being missing.\n\!\(\*RowBox[{\"Missing\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"reason\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) associates the expression \!\(\*StyleBox[\"expr\", \"TI\"]\) with the missing data. "
Modal::usage = "Modal is an option to functions such as CreateDialog, which specifies whether the dialog that is created should be modal to the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) front end."
Mode::usage = "Mode is an option to Solve and related functions that specifies in what sense the equations are to be solved. The possible settings for Mode are Generic, Modular, and Rational."
Mod::usage = "\!\(\*RowBox[{\"Mod\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the remainder on division of m by n. \n\!\(\*RowBox[{\"Mod\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"]\"}]\) uses an offset d. "
ModularLambda::usage = "\!\(\*RowBox[{\"ModularLambda\", \"[\", StyleBox[\"\[Tau]\", \"TR\"], \"]\"}]\) gives the modular lambda elliptic function \!\(\*RowBox[{\"\[Lambda]\", \"(\", \"\[Tau]\", \")\"}]\). "
Modular::usage = "Modular is a setting for the option Mode in Solve and related functions, which specifies that equations need be satisfied only modulo an integer."
Module::usage = "\!\(\*RowBox[{\"Module\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) specifies that occurrences of the symbols \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"y\", \"TI\"]\), \[Ellipsis] in \!\(\*StyleBox[\"expr\", \"TI\"]\) should be treated as local. \n\!\(\*RowBox[{\"Module\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{StyleBox[\"x\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) defines initial values for \!\(\*StyleBox[\"x\", \"TI\"]\), \[Ellipsis]. "
Modulus::usage = "\!\(\*RowBox[{\"Modulus\", \"->\", StyleBox[\"n\", \"TI\"]}]\) is an option that can be given in certain algebraic functions to specify that integers should be treated modulo \!\(\*StyleBox[\"n\", \"TI\"]\). "
MoebiusMu::usage = "\!\(\*RowBox[{\"MoebiusMu\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the M\[ODoubleDot]bius function \!\(\*RowBox[{\"\[Mu]\", \"(\", \"n\", \")\"}]\). "
Monitor::usage = "\!\(\*RowBox[{\"Monitor\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"mon\", \"TI\"]}], \"]\"}]\) generates a temporary monitor cell in which the continually updated current value of \!\(\*StyleBox[\"mon\", \"TI\"]\) is displayed during the course of evaluation of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
MonomialOrder::usage = "MonomialOrder is an option for GroebnerBasis, PolynomialReduce and NSolve which specifies the monomial order to be used in computations."
Most::usage = "\!\(\*RowBox[{\"Most\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives \!\(\*StyleBox[\"expr\", \"TI\"]\) with the last element removed. "
MouseAnnotation::usage = "\!\(\*RowBox[{\"MouseAnnotation\", \"[\", \"]\"}]\) gives any mouse annotation associated with the expression at the current mouse position. "
MouseButtons::usage = "\!\(\*RowBox[{\"MouseButtons\", \"[\", \"]\"}]\) gives a list of the mouse buttons currently being pressed."
Mouseover::usage = "\!\(\*RowBox[{\"Mouseover\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"over\", \"TI\"]}], \"]\"}]\) represents an object that displays as \!\(\*StyleBox[\"over\", \"TI\"]\) when the mouse pointer is over it, and as \!\(\*StyleBox[\"expr\", \"TI\"]\) otherwise. "
MousePosition::usage = "\!\(\*RowBox[{\"MousePosition\", \"[\", \"]\"}]\) gives the current mouse position in the notebook front end. \n\!\(\*RowBox[{\"MousePosition\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"coords\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the mouse position with respect to the specified coordinate system.\n\!\(\*RowBox[{\"MousePosition\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"coords\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"def\", \"TI\"]}], \"]\"}]\) returns \!\(\*StyleBox[\"def\", \"TI\"]\) if the mouse is not over an object that defines the specified coordinate system."
MovingAverage::usage = "\!\(\*RowBox[{\"MovingAverage\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) gives the moving average of \!\(\*StyleBox[\"list\", \"TI\"]\), computed by averaging runs of \!\(\*StyleBox[\"r\", \"TI\"]\) elements.\n\!\(\*RowBox[{\"MovingAverage\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"w\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"w\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"w\", \"TI\"], StyleBox[\"r\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives the moving average of \!\(\*StyleBox[\"list\", \"TI\"]\), computed with weights \!\(\*SubscriptBox[StyleBox[\"w\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
MovingMedian::usage = "\!\(\*RowBox[{\"MovingMedian\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) gives the moving median of \!\(\*StyleBox[\"list\", \"TI\"]\), computed using spans of r elements."
MultiedgeStyle::usage = "MultiedgeStyle is an option for GraphPlot and related functions which specifies how to draw multiple edges."
MultilaunchWarning::usage = "MultilaunchWarning is a global option that specifies whether a warning is given when you try to modify user preferences while running two copies of \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) simultaneously."
MultilineFunction::usage = "MultilineFunction is an option for UnderscriptBox and related box objects which specifies what to do when the contents of a box object are too long to fit on one line."
Multinomial::usage = "\!\(\*RowBox[{\"Multinomial\", \"[\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the multinomial coefficient \!\(\*RowBox[{RowBox[{RowBox[{\"(\", RowBox[{SubscriptBox[\"n\", \"1\"], \"+\", SubscriptBox[\"n\", \"2\"], \"+\", \"\[Ellipsis]\"}], \")\"}], \"!\"}], \"/\", RowBox[{\"(\", RowBox[{RowBox[{SubscriptBox[\"n\", \"1\"], \"!\"}], \" \", RowBox[{SubscriptBox[\"n\", \"2\"], \"!\"}], \" \", \"\[Ellipsis]\"}], \")\"}]}]\). "
MultiplicativeOrder::usage = "\!\(\*RowBox[{\"MultiplicativeOrder\", \"[\", RowBox[{StyleBox[\"k\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the multiplicative order of \!\(\*StyleBox[\"k\", \"TI\"]\) modulo \!\(\*StyleBox[\"n\", \"TI\"]\), defined as the smallest integer \!\(\*StyleBox[\"m\", \"TI\"]\) such that \!\(\*RowBox[{SuperscriptBox[\"k\", \"m\"], \"\[Congruent]\", RowBox[{\"1\", \"mod\", \" \", \"n\"}]}]\). \n\!\(\*RowBox[{\"MultiplicativeOrder\", \"[\", RowBox[{StyleBox[\"k\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives the generalized multiplicative order of \!\(\*StyleBox[\"k\", \"TI\"]\) modulo \!\(\*StyleBox[\"n\", \"TI\"]\), defined as the smallest integer \!\(\*StyleBox[\"m\", \"TI\"]\) such that \!\(\*RowBox[{SuperscriptBox[\"k\", \"m\"], \"\[Congruent]\", RowBox[{SubscriptBox[\"r\", \"i\"], \"mod\", \" \", \"n\"}]}]\) for some \!\(\*StyleBox[\"i\", \"TI\"]\). "
Multiplicity::usage = "Multiplicity is an option to Roots. \!\(\*RowBox[{\"Multiplicity\", \" \", \"->\", \" \", StyleBox[\"n\", \"TI\"]}]\) specifies that the multiplicity of each of the roots is \!\(\*StyleBox[\"n\", \"TI\"]\) in the final result."
NameQ::usage = "\!\(\*RowBox[{\"NameQ\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) yields True if there are any symbols whose names match the string pattern given, and yields False otherwise. "
Names::usage = "\!\(\*RowBox[{\"Names\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a list of the names of symbols which match the string. \n\!\(\*RowBox[{\"Names\", \"[\", StyleBox[\"patt\", \"TI\"], \"]\"}]\) gives a list of names matching the arbitrary string pattern \!\(\*StyleBox[\"patt\", \"TI\"]\)."
Nand::usage = "\!\(\*RowBox[{\"Nand\", \"[\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) is the logical NAND function. It evaluates its arguments in order, giving True immediately if any of them are False, and False if they are all True. "
NBernoulliB::usage = "\!\(\*RowBox[{\"NBernoulliB\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the numerical value of the \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) Bernoulli number. \n\!\(\*RowBox[{\"NBernoulliB\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", \" \", StyleBox[\"d\", \"TI\"]}], \"]\"}]\) gives the result to \!\(\*StyleBox[\"d\", \"TI\"]\)-digit precision."
NCache::usage = "\!\(\*RowBox[{\"NCache\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"xn\", \"TI\"]}], \"]\"}]\) represents a numeric cache object for a quantity with exact value \!\(\*StyleBox[\"x\", \"TI\"]\) and approximate numerical value \!\(\*StyleBox[\"xn\", \"TI\"]\)."
NDSolve::usage = "\!\(\*RowBox[{\"NDSolve\", \"[\", RowBox[{StyleBox[\"eqns\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) finds a numerical solution to the ordinary differential equations \!\(\*StyleBox[\"eqns\", \"TI\"]\) for the function \!\(\*StyleBox[\"y\", \"TI\"]\) with the independent variable \!\(\*StyleBox[\"x\", \"TI\"]\) in the range \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"NDSolve\", \"[\", RowBox[{StyleBox[\"eqns\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) finds a numerical solution to the partial differential equations \!\(\*StyleBox[\"eqns\", \"TI\"]\). \n\!\(\*RowBox[{\"NDSolve\", \"[\", RowBox[{StyleBox[\"eqns\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) finds numerical solutions for the functions\[NonBreakingSpace]\!\(\*SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
NearestFunction::usage = "\!\(\*RowBox[{\"NearestFunction\", \"[\", StyleBox[\"data\", \"TI\"], \"]\"}]\) represents a function whose values give the elements closest to an element that is supplied."
Nearest::usage = "\!\(\*RowBox[{\"Nearest\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"elem\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"elem\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the list of \!\(\*SubscriptBox[StyleBox[\"elem\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) to which \!\(\*StyleBox[\"x\", \"TI\"]\) is nearest. \n\!\(\*RowBox[{\"Nearest\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"elem\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"elem\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) corresponding to the \!\(\*SubscriptBox[StyleBox[\"elem\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) to which \!\(\*StyleBox[\"x\", \"TI\"]\) is nearest. \n\!\(\*RowBox[{\"Nearest\", \"[\", RowBox[{RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"elem\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"elem\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"->\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the same result. \n\!\(\*RowBox[{\"Nearest\", \"[\", RowBox[{RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"elem\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"elem\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"->\", \"Automatic\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) takes the \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) to be successive integers \!\(\*StyleBox[\"i\", \"TI\"]\). \n\!\(\*RowBox[{\"Nearest\", \"[\", RowBox[{StyleBox[\"data\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[\"n\", \"TI\"]\) nearest \!\(\*SubscriptBox[StyleBox[\"elem\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) to \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"Nearest\", \"[\", StyleBox[\"data\", \"TI\"], \"]\"}]\) generates a \!\(\*RowBox[{\"NearestFunction\", \"[\", StyleBox[\"\[Ellipsis]\", \"TR\"], \"]\"}]\) which can be applied repeatedly to different \!\(\*StyleBox[\"x\", \"TI\"]\). "
Needs::usage = "\!\(\*RowBox[{\"Needs\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"context\\\",\\\"TI\\\"]\\)`\\\"\", ShowStringCharacters->True], \"]\"}]\) loads an appropriate file if the specified context is not already in $Packages. \n\!\(\*RowBox[{\"Needs\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"context\\\",\\\"TI\\\"]\\)`\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) loads \!\(\*StyleBox[\"file\", \"TI\"]\) if the specified context is not already in $Packages. "
NegativeBinomialDistribution::usage = "\!\(\*RowBox[{\"NegativeBinomialDistribution\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) represents a negative binomial distribution with parameters \!\(\*StyleBox[\"n\", \"TI\"]\) and \!\(\*StyleBox[\"p\", \"TI\"]\)."
Negative::usage = "\!\(\*RowBox[{\"Negative\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"x\", \"TI\"]\) is a negative number. "
NestedGreaterGreater::usage = "\!\(\*RowBox[{\"NestedGreaterGreater\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[NestedGreaterGreater]\", StyleBox[\"y\", \"TI\"], \"\[NestedGreaterGreater]\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\)."
NestedLessLess::usage = "\!\(\*RowBox[{\"NestedLessLess\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NestedLessLess]\", \"y\", \"\[NestedLessLess]\", \"\[Ellipsis]\"}]\)."
NestList::usage = "\!\(\*RowBox[{\"NestList\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a list of the results of applying \!\(\*StyleBox[\"f\", \"TI\"]\) to \!\(\*StyleBox[\"expr\", \"TI\"]\) 0 through \!\(\*StyleBox[\"n\", \"TI\"]\) times. "
Nest::usage = "\!\(\*RowBox[{\"Nest\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives an expression with \!\(\*StyleBox[\"f\", \"TI\"]\) applied \!\(\*StyleBox[\"n\", \"TI\"]\) times to \!\(\*StyleBox[\"expr\", \"TI\"]\). "
NestWhileList::usage = "\!\(\*RowBox[{\"NestWhileList\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"]}], \"]\"}]\) generates a list of the results of applying \!\(\*StyleBox[\"f\", \"TI\"]\) repeatedly, starting with \!\(\*StyleBox[\"expr\", \"TI\"]\), and continuing until applying \!\(\*StyleBox[\"test\", \"TI\"]\) to the result no longer yields True. \n\!\(\*RowBox[{\"NestWhileList\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) supplies the most recent \!\(\*StyleBox[\"m\", \"TI\"]\) results as arguments for \!\(\*StyleBox[\"test\", \"TI\"]\) at each step. \n\!\(\*RowBox[{\"NestWhileList\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"], \",\", \"All\"}], \"]\"}]\) supplies all results so far as arguments for \!\(\*StyleBox[\"test\", \"TI\"]\) at each step. \n\!\(\*RowBox[{\"NestWhileList\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) at most \!\(\*StyleBox[\"max\", \"TI\"]\) times. "
NestWhile::usage = "\!\(\*RowBox[{\"NestWhile\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"]}], \"]\"}]\) starts with \!\(\*StyleBox[\"expr\", \"TI\"]\), then repeatedly applies \!\(\*StyleBox[\"f\", \"TI\"]\) until applying \!\(\*StyleBox[\"test\", \"TI\"]\) to the result no longer yields True. \n\!\(\*RowBox[{\"NestWhile\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) supplies the most recent \!\(\*StyleBox[\"m\", \"TI\"]\) results as arguments for \!\(\*StyleBox[\"test\", \"TI\"]\) at each step. \n\!\(\*RowBox[{\"NestWhile\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"], \",\", \"All\"}], \"]\"}]\) supplies all results so far as arguments for \!\(\*StyleBox[\"test\", \"TI\"]\) at each step. \n\!\(\*RowBox[{\"NestWhile\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) at most \!\(\*StyleBox[\"max\", \"TI\"]\) times. \n\!\(\*RowBox[{\"NestWhile\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) an extra \!\(\*StyleBox[\"n\", \"TI\"]\) times. \n\!\(\*RowBox[{\"NestWhile\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"], \",\", RowBox[{\"-\", StyleBox[\"n\", \"TI\"]}]}], \"]\"}]\) returns the result found when \!\(\*StyleBox[\"f\", \"TI\"]\) had been applied \!\(\*StyleBox[\"n\", \"TI\"]\) fewer times. "
NevilleThetaC::usage = "\!\(\*RowBox[{\"NevilleThetaC\", \"[\", RowBox[{StyleBox[\"z\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Neville theta function \!\(\*RowBox[{SubscriptBox[\"\[CurlyTheta]\", \"c\"], \" \", RowBox[{\"(\", RowBox[{\"z\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]}]\). "
NevilleThetaD::usage = "\!\(\*RowBox[{\"NevilleThetaD\", \"[\", RowBox[{StyleBox[\"z\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Neville theta function \!\(\*RowBox[{SubscriptBox[\"\[CurlyTheta]\", \"d\"], \" \", RowBox[{\"(\", RowBox[{\"z\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]}]\). "
NevilleThetaN::usage = "\!\(\*RowBox[{\"NevilleThetaN\", \"[\", RowBox[{StyleBox[\"z\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Neville theta function \!\(\*RowBox[{SubscriptBox[\"\[CurlyTheta]\", \"n\"], \" \", RowBox[{\"(\", RowBox[{\"z\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]}]\). "
NevilleThetaS::usage = "\!\(\*RowBox[{\"NevilleThetaS\", \"[\", RowBox[{StyleBox[\"z\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Neville theta function \!\(\*RowBox[{SubscriptBox[\"\[CurlyTheta]\", \"s\"], \" \", RowBox[{\"(\", RowBox[{\"z\", \"\[VerticalSeparator]\", \"m\"}], \")\"}]}]\). "
NextPrime::usage = "\!\(\*RowBox[{\"NextPrime\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the next prime above n.\n\!\(\*RowBox[{\"NextPrime\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the k\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) prime above n."
NHoldAll::usage = "NHoldAll is an attribute which specifies that none of the arguments to a function should be affected by N. "
NHoldFirst::usage = "NHoldFirst is an attribute which specifies that the first argument to a function should not be affected by N. "
NHoldRest::usage = "NHoldRest is an attribute which specifies that all but the first argument to a function should not be affected by N. "
NIntegrate::usage = "\!\(\*RowBox[{\"NIntegrate\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives a numerical approximation to the integral \!\(\*RowBox[{SubsuperscriptBox[\"\[Integral]\", SubscriptBox[\"x\", StyleBox[\"min\", FontSlant -> \"Italic\"]], SubscriptBox[\"x\", StyleBox[\"max\", FontSlant -> \"Italic\"]]], \" \", RowBox[{\"f\", \" \", \"d\", \"\[InvisibleSpace]\", \"x\"}]}]\). \n\!\(\*RowBox[{\"NIntegrate\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives a numerical approximation to the multiple integral \!\(\*RowBox[{SubsuperscriptBox[\"\[Integral]\", SubscriptBox[\"x\", StyleBox[\"min\", FontSlant -> \"Italic\"]], SubscriptBox[\"x\", StyleBox[\"max\", FontSlant -> \"Italic\"]]], RowBox[{\"d\", \"x\", RowBox[{SubsuperscriptBox[\"\[Integral]\", SubscriptBox[\"y\", StyleBox[\"min\", FontSlant -> \"Italic\"]], SubscriptBox[\"y\", StyleBox[\"max\", FontSlant -> \"Italic\"]]], RowBox[{\"d\", \"\[InvisibleSpace]\", \"y\", \" \", \"\[Ellipsis]\", \" \", \"f\"}]}]}]}]\)."
NMaximize::usage = "\!\(\*RowBox[{\"NMaximize\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) maximizes \!\(\*StyleBox[\"f\", \"TI\"]\) numerically with respect to \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"y\", \"TI\"]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\). \n\!\(\*RowBox[{\"NMaximize\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"cons\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) maximizes \!\(\*StyleBox[\"f\", \"TI\"]\) numerically subject to the constraints \!\(\*StyleBox[\"cons\", \"TI\"]\). "
NMinimize::usage = "\!\(\*RowBox[{\"NMinimize\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) minimizes \!\(\*StyleBox[\"f\", \"TI\"]\) numerically with respect to \!\(\*StyleBox[\"x\", \"TI\"]\), \!\(\*StyleBox[\"y\", \"TI\"]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\). \n\!\(\*RowBox[{\"NMinimize\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"cons\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) minimizes \!\(\*StyleBox[\"f\", \"TI\"]\) numerically subject to the constraints \!\(\*StyleBox[\"cons\", \"TI\"]\). "
N::usage = "\!\(\*RowBox[{\"N\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the numerical value of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"N\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) attempts to give a result with \!\(\*StyleBox[\"n\", \"TI\"]\)\[Hyphen]digit precision. "
NonAssociative::usage = "NonAssociative is a symbol that represents a non-associative operator in formatting functions."
NoncentralChiSquareDistribution::usage = "\!\(\*RowBox[{\"NoncentralChiSquareDistribution\", \"[\", RowBox[{StyleBox[\"\[Nu]\", \"TR\"], \",\", StyleBox[\"\[Lambda]\", \"TR\"]}], \"]\"}]\) represents a noncentral \!\(\*SuperscriptBox[\"\[Chi]\", \"2\"]\) distribution with \[Nu] degrees of freedom and noncentrality parameter \[Lambda]."
NoncentralFRatioDistribution::usage = "\!\(\*RowBox[{\"NoncentralFRatioDistribution\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"\[Lambda]\", \"TR\"]}], \"]\"}]\) represents a noncentral \!\(\*StyleBox[\"F\", FontSlant -> \"Italic\"]\)-ratio distribution with \!\(\*StyleBox[\"n\", \"TI\"]\) numerator degrees of freedom and \!\(\*StyleBox[\"m\", \"TI\"]\) denominator degrees of freedom and numerator noncentrality parameter \!\(\*StyleBox[\"\[Lambda]\", \"TR\"]\)."
NoncentralStudentTDistribution::usage = "\!\(\*RowBox[{\"NoncentralStudentTDistribution\", \"[\", RowBox[{StyleBox[\"\[Nu]\", \"TR\"], \",\", StyleBox[\"\[Delta]\", \"TR\"]}], \"]\"}]\) represents a noncentral Student \!\(\*StyleBox[\"t\", \"TI\"]\) distribution with \!\(\*StyleBox[\"\[Nu]\", \"TR\"]\) degrees of freedom and noncentrality parameter \!\(\*StyleBox[\"\[Delta]\", \"TR\"]\)."
NonCommutativeMultiply::usage = "\!\(\*RowBox[{StyleBox[\"a\", \"TI\"], \"**\", StyleBox[\"b\", \"TI\"], \"**\", StyleBox[\"c\", \"TI\"]}]\) is a general associative, but non\[Hyphen]commutative, form of multiplication. "
NonConstants::usage = "NonConstants is an option for D which gives a list of objects to be taken to depend implicitly on the differentiation variables. "
None::usage = "None is a setting used for certain options. "
NonNegative::usage = "\!\(\*RowBox[{\"NonNegative\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"x\", \"TI\"]\) is a non\[Hyphen]negative number. "
NonPositive::usage = "\!\(\*RowBox[{\"NonPositive\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"x\", \"TI\"]\) is a non\[Hyphen]positive number. "
NorlundB::usage = "\!\(\*RowBox[{\"NorlundB\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"]\"}]\) gives N\[ODoubleDot]rlund polynomials \!\(\*SubsuperscriptBox[\"B\", \"n\", RowBox[{\"(\", \"a\", \")\"}]]\) of degree \!\(\*StyleBox[\"n\", \"TI\"]\) in \!\(\*StyleBox[\"a\", \"TI\"]\).\n\!\(\*RowBox[{\"NorlundB\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives generalized Bernoulli polynomials \!\(\*RowBox[{SubsuperscriptBox[\"B\", \"n\", RowBox[{\"(\", \"a\", \")\"}]], \"(\", \"x\", \")\"}]\)."
NormalDistribution::usage = "\!\(\*RowBox[{\"NormalDistribution\", \"[\", RowBox[{StyleBox[\"\[Mu]\", \"TR\"], \",\", StyleBox[\"\[Sigma]\", \"TR\"]}], \"]\"}]\) represents a normal (Gaussian) distribution with mean \[Mu] and standard deviation \[Sigma].\n\!\(\*RowBox[{\"NormalDistribution\", \"[\", \"]\"}]\) represents a normal distribution with zero mean and unit standard deviation."
Normalize::usage = "\!\(\*RowBox[{\"Normalize\", \"[\", StyleBox[\"v\", \"TI\"], \"]\"}]\) gives the normalized form of a vector \!\(\*StyleBox[\"v\", \"TI\"]\). \n\!\(\*RowBox[{\"Normalize\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the normalized form a complex number \!\(\*StyleBox[\"z\", \"TI\"]\).\n\!\(\*RowBox[{\"Normalize\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) normalizes with respect to the norm function \!\(\*StyleBox[\"f\", \"TI\"]\)."
Normal::usage = "\!\(\*RowBox[{\"Normal\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) converts \!\(\*StyleBox[\"expr\", \"TI\"]\) to a normal expression, from a variety of special forms. "
NormalsFunction::usage = "NormalsFunction is an option for Plot3D and related functions that specifies a function to apply to determine the effective surface normals at every point."
NormFunction::usage = "NormFunction is an option for functions such as FindFit and NDSolve which gives a function to be minimized in generating results."
Norm::usage = "\!\(\*RowBox[{\"Norm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the norm of a number or array. \n\!\(\*RowBox[{\"Norm\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[\"p\", \"TI\"]\)\[Hyphen]norm. "
Nor::usage = "\!\(\*RowBox[{\"Nor\", \"[\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) is the logical NOR function. It evaluates its arguments in order, giving False immediately if any of them are True, and True if they are all False. "
NotCongruent::usage = "\!\(\*RowBox[{\"NotCongruent\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotCongruent]\", \"y\", \"\[NotCongruent]\", \"\[Ellipsis]\"}]\)."
NotCupCap::usage = "\!\(\*RowBox[{\"NotCupCap\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotCupCap]\", \"y\", \"\[NotCupCap]\", \"\[Ellipsis]\"}]\)."
NotDoubleVerticalBar::usage = "\!\(\*RowBox[{\"NotDoubleVerticalBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotDoubleVerticalBar]\", \"y\", \"\[NotDoubleVerticalBar]\", \"\[Ellipsis]\"}]\)."
NotebookApply::usage = "\!\(\*RowBox[{\"NotebookApply\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"]}], \"]\"}]\) writes data into a notebook at the current selection, replacing the first selection placeholder in \!\(\*StyleBox[\"data\", \"TI\"]\) by the current selection, and then setting the current selection to be just after the data written. \n\!\(\*RowBox[{\"NotebookApply\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"], \",\", StyleBox[\"sel\", \"TI\"]}], \"]\"}]\) writes data into a notebook and then sets the current selection to be as specified by \!\(\*StyleBox[\"sel\", \"TI\"]\). "
NotebookAutoSave::usage = "NotebookAutoSave is a notebook option which specifies whether the notebook should automatically be saved after each piece of output generated by evaluation in it. "
NotebookClose::usage = "\!\(\*RowBox[{\"NotebookClose\", \"[\", StyleBox[\"notebook\", \"TI\"], \"]\"}]\) closes the notebook corresponding to the specified notebook object. \n\!\(\*RowBox[{\"NotebookClose\", \"[\", \"]\"}]\) closes the current evaluation notebook."
NotebookConvertSettings::usage = "\!\(\*RowBox[{\"NotebookConvertSettings\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is a global option that specifies settings for converting imported legacy notebooks."
NotebookCreate::usage = "\!\(\*RowBox[{\"NotebookCreate\", \"[\", \"]\"}]\) creates a new open notebook in the front end. \n\!\(\*RowBox[{\"NotebookCreate\", \"[\", StyleBox[\"options\", \"TI\"], \"]\"}]\) sets up the specified options for the new notebook. "
NotebookDelete::usage = "\!\(\*RowBox[{\"NotebookDelete\", \"[\", StyleBox[\"notebook\", \"TI\"], \"]\"}]\) deletes the current selection in the notebook corresponding to the specified notebook object. \n\!\(\*RowBox[{\"NotebookDelete\", \"[\", \"]\"}]\) deletes the current selection in the current evaluation notebook."
NotebookDirectory::usage = "\!\(\*RowBox[{\"NotebookDirectory\", \"[\", \"]\"}]\) gives the directory of the current evaluation notebook. \n\!\(\*RowBox[{\"NotebookDirectory\", \"[\", StyleBox[\"nb\", \"TI\"], \"]\"}]\) gives the directory for the notebook specified by \!\(\*StyleBox[\"nb\", \"TI\"]\). "
NotebookEventActions::usage = "NotebookEventActions is a notebook option that gives a list of actions to perform when specified events occur in connection with the notebook. "
NotebookFind::usage = "\!\(\*RowBox[{\"NotebookFind\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"]}], \"]\"}]\) sets the current selection in the specified notebook object to be the next occurrence of \!\(\*StyleBox[\"data\", \"TI\"]\). \n\!\(\*RowBox[{\"NotebookFind\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"], \",\", \"Previous\"}], \"]\"}]\) sets the current selection to be the previous occurrence. \n\!\(\*RowBox[{\"NotebookFind\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"], \",\", \"All\"}], \"]\"}]\) sets the current selection to be all occurrences. \n\!\(\*RowBox[{\"NotebookFind\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"], \",\", StyleBox[\"dir\", \"TI\"], \",\", StyleBox[\"elems\", \"TI\"]}], \"]\"}]\) searches the elements of cells specified by \!\(\*StyleBox[\"elems\", \"TI\"]\). "
NotebookGet::usage = "\!\(\*RowBox[{\"NotebookGet\", \"[\", StyleBox[\"obj\", \"TI\"], \"]\"}]\) gets the raw expression corresponding to the notebook represented by the notebook object \!\(\*StyleBox[\"obj\", \"TI\"]\). \n\!\(\*RowBox[{\"NotebookGet\", \"[\", \"]\"}]\) gets the raw expression corresponding to the currently selected notebook. "
NotebookInformation::usage = "\!\(\*RowBox[{\"NotebookInformation\", \"[\", \"]\"}]\) gives a list of properties of the current evaluation notebook.\n\!\(\*RowBox[{\"NotebookInformation\", \"[\", StyleBox[\"notebook\", \"TI\"], \"]\"}]\) gives a list of properties for the specified notebook."
NotebookLocate::usage = "\!\(\*RowBox[{\"NotebookLocate\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"tag\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) locates all cells with the specified tag in your current input notebook, selecting the cells and scrolling to the position of the first one. \n\!\(\*RowBox[{\"NotebookLocate\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"tag\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"}\"}], \"]\"}]\) if necessary opens the notebook stored in \!\(\*StyleBox[\"file\", \"TI\"]\), then locates cells with the specified tag. "
Notebook::usage = "\!\(\*RowBox[{\"Notebook\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) is the low\[Hyphen]level construct that represents a notebook manipulated by the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) front end. "
NotebookObject::usage = "\!\(\*RowBox[{\"NotebookObject\", \"[\", RowBox[{StyleBox[\"fe\", \"TI\"], \",\", StyleBox[\"id\", \"TI\"]}], \"]\"}]\) is an object that represents an open notebook in the front end. "
NotebookOpen::usage = "\!\(\*RowBox[{\"NotebookOpen\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) opens an existing notebook with the specified name, returning the corresponding notebook object. \n\!\(\*RowBox[{\"NotebookOpen\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"options\", \"TI\"]}], \"]\"}]\) opens a notebook using the options given. \n\!\(\*RowBox[{\"NotebookOpen\", \"[\", RowBox[{StyleBox[\"\\\"http://\\!\\(\\*StyleBox[\\\"url\\\",\\\"TI\\\"]\\)\\\"\",ShowStringCharacters->True], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) opens a notebook from any accessible URL. "
NotebookPath::usage = "NotebookPath\!\(\*StyleBox[\" \", FontWeight -> \"Bold\"]\) is a global option that determines which directories are searched when a specified notebook is needed."
NotebookPrint::usage = "\!\(\*RowBox[{\"NotebookPrint\", \"[\", StyleBox[\"notebook\", \"TI\"], \"]\"}]\) sends the specified notebook to your default printer. \n\!\(\*RowBox[{\"NotebookPrint\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\).\\!\\(\\*StyleBox[\\\"ext\\\",\\\"TI\\\"]\\)\\\"\",ShowStringCharacters->True]}], \"]\"}]\) saves a print\[Hyphen]ready form of the notebook to a file in the format indicated by the file extension \!\(\*StyleBox[\"ext\", \"TI\"]\). \n\!\(\*RowBox[{\"NotebookPrint\", \"[\", \"]\"}]\) sends the current evaluation notebook to your default printer."
NotebookPut::usage = "\!\(\*RowBox[{\"NotebookPut\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) creates a notebook corresponding to \!\(\*StyleBox[\"expr\", \"TI\"]\) and makes it the currently selected notebook in the front end. \n\!\(\*RowBox[{\"NotebookPut\", \"[\", \"]\"}]\) creates a new empty notebook.\n\!\(\*RowBox[{\"NotebookPut\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"obj\", \"TI\"]}], \"]\"}]\) replaces the notebook represented by the notebook object \!\(\*StyleBox[\"obj\", \"TI\"]\) with one corresponding to \!\(\*StyleBox[\"expr\", \"TI\"]\). "
NotebookRead::usage = "\!\(\*RowBox[{\"NotebookRead\", \"[\", StyleBox[\"notebook\", \"TI\"], \"]\"}]\) gives the expression corresponding to the current selection in the specified notebook object. "
NotebookSave::usage = "\!\(\*RowBox[{\"NotebookSave\", \"[\", StyleBox[\"notebook\", \"TI\"], \"]\"}]\) saves the current version of the specified notebook. \n\!\(\*RowBox[{\"NotebookSave\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) saves the notebook in the specified file. \n\!\(\*RowBox[{\"NotebookSave\", \"[\", \"]\"}]\) saves the current version of the current evaluation notebook in a file."
NotebookSelection::usage = "\!\(\*RowBox[{\"NotebookSelection\", \"[\", \"]\"}]\) represents the current selection in the current evaluation notebook in the front end.\n\!\(\*RowBox[{\"NotebookSelection\", \"[\", StyleBox[\"nb\", \"TI\"], \"]\"}]\) represents the current selection associated with the open notebook \!\(\*StyleBox[\"nb\", \"TI\"]\). "
NotebooksMenu::usage = "NotebooksMenu is a global option that specifies which recently opened notebooks are listed under the File menu."
Notebooks::usage = "\!\(\*RowBox[{\"Notebooks\", \"[\", \"]\"}]\) gives a list of notebooks currently open in the front end. "
NotebookWrite::usage = "\!\(\*RowBox[{\"NotebookWrite\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"]}], \"]\"}]\) writes data into a notebook at the current selection, setting the current selection to be just after the data written. \n\!\(\*RowBox[{\"NotebookWrite\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"data\", \"TI\"], \",\", StyleBox[\"sel\", \"TI\"]}], \"]\"}]\) writes data into a notebook setting the current selection to be as specified by \!\(\*StyleBox[\"sel\", \"TI\"]\). "
NotElement::usage = "\!\(\*RowBox[{\"NotElement\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"dom\", \"TI\"]}], \"]\"}]\) or \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[NotElement]\", StyleBox[\"dom\", \"TI\"]}]\) asserts that x is not an element of the domain \!\(\*StyleBox[\"dom\", \"TI\"]\).\n\!\(\*RowBox[{\"NotElement\", \"[\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"|\", StyleBox[\"\[Ellipsis]\", \"TR\"], \"|\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \",\", StyleBox[\"dom\", \"TI\"]}], \"]\"}]\) asserts that none of the \!\(\*SubscriptBox[\"x\", \"i\"]\) are elements of \!\(\*StyleBox[\"dom\", \"TI\"]\).\n\!\(\*RowBox[{\"NotElement\", \"[\", RowBox[{StyleBox[\"patt\", \"TI\"], \",\", StyleBox[\"dom\", \"TI\"]}], \"]\"}]\) asserts that any expression matching the pattern \!\(\*StyleBox[\"patt\", \"TI\"]\) is not an element of the domain \!\(\*StyleBox[\"dom\", \"TI\"]\)."
NotEqualTilde::usage = "\!\(\*RowBox[{\"NotEqualTilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotEqualTilde]\", \"y\", \"\[NotEqualTilde]\", \"\[Ellipsis]\"}]\)."
NotExists::usage = "\!\(\*RowBox[{\"NotExists\", \"[\", StyleBox[RowBox[{\"x\", \",\", \" \", \"y\"}], \"TI\"], \"]\"}]\) displays as \!\(\*RowBox[{SubscriptBox[\"\[NotExists]\", \"x\"], \"y\"}]\)."
NotGreaterEqual::usage = "\!\(\*RowBox[{\"NotGreaterEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotGreaterEqual]\", \"y\", \"\[NotGreaterEqual]\", \"\[Ellipsis]\"}]\)."
NotGreaterFullEqual::usage = "\!\(\*RowBox[{\"NotGreaterFullEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotGreaterFullEqual]\", \"y\", \"\[NotGreaterFullEqual]\", \"\[Ellipsis]\"}]\)."
NotGreaterGreater::usage = "\!\(\*RowBox[{\"NotGreaterGreater\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotGreaterGreater]\", \"y\", \"\[NotGreaterGreater]\", \"\[Ellipsis]\"}]\)."
NotGreaterLess::usage = "\!\(\*RowBox[{\"NotGreaterLess\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotGreaterLess]\", \"y\", \"\[NotGreaterLess]\", \"\[Ellipsis]\"}]\)."
NotGreater::usage = "\!\(\*RowBox[{\"NotGreater\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotGreater]\", \"y\", \"\[NotGreater]\", \"\[Ellipsis]\"}]\)."
NotGreaterSlantEqual::usage = "\!\(\*RowBox[{\"NotGreaterSlantEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotGreaterSlantEqual]\", \"y\", \"\[NotGreaterSlantEqual]\", \"\[Ellipsis]\"}]\)."
NotGreaterTilde::usage = "\!\(\*RowBox[{\"NotGreaterTilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotGreaterTilde]\", \"y\", \"\[NotGreaterTilde]\", \"\[Ellipsis]\"}]\)."
NotHumpDownHump::usage = "\!\(\*RowBox[{\"NotHumpDownHump\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotHumpDownHump]\", \"y\", \"\[NotHumpDownHump]\", \"\[Ellipsis]\"}]\)."
NotHumpEqual::usage = "\!\(\*RowBox[{\"NotHumpEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotHumpEqual]\", \"y\", \"\[NotHumpEqual]\", \"\[Ellipsis]\"}]\)."
NotLeftTriangleBar::usage = "\!\(\*RowBox[{\"NotLeftTriangleBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotLeftTriangleBar]\", \"y\", \"\[NotLeftTriangleBar]\", \"\[Ellipsis]\"}]\)."
NotLeftTriangleEqual::usage = "\!\(\*RowBox[{\"NotLeftTriangleEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotLeftTriangleEqual]\", \"y\", \"\[NotLeftTriangleEqual]\", \"\[Ellipsis]\"}]\)."
NotLeftTriangle::usage = "\!\(\*RowBox[{\"NotLeftTriangle\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotLeftTriangle]\", \"y\", \"\[NotLeftTriangle]\", \"\[Ellipsis]\"}]\)."
NotLessEqual::usage = "\!\(\*RowBox[{\"NotLessEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotLessEqual]\", \"y\", \"\[NotLessEqual]\", \"\[Ellipsis]\"}]\)."
NotLessFullEqual::usage = "\!\(\*RowBox[{\"NotLessFullEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotLessFullEqual]\", \"y\", \"\[NotLessFullEqual]\", \"\[Ellipsis]\"}]\)."
NotLessGreater::usage = "\!\(\*RowBox[{\"NotLessGreater\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotLessGreater]\", \"y\", \"\[NotLessGreater]\", \"\[Ellipsis]\"}]\)."
NotLessLess::usage = "\!\(\*RowBox[{\"NotLessLess\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotLessLess]\", \"y\", \"\[NotLessLess]\", \"\[Ellipsis]\"}]\)."
NotLess::usage = "\!\(\*RowBox[{\"NotLess\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotLess]\", \"y\", \"\[NotLess]\", \"\[Ellipsis]\"}]\)."
NotLessSlantEqual::usage = "\!\(\*RowBox[{\"NotLessSlantEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotLessSlantEqual]\", \"y\", \"\[NotLessSlantEqual]\", \"\[Ellipsis]\"}]\)."
NotLessTilde::usage = "\!\(\*RowBox[{\"NotLessTilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotLessTilde]\", \"y\", \"\[NotLessTilde]\", \"\[Ellipsis]\"}]\)."
Not::usage = "\!\(\*RowBox[{\"!\", StyleBox[\"expr\", \"TI\"]}]\) is the logical NOT function. It gives False if \!\(\*StyleBox[\"expr\", \"TI\"]\) is True, and True if it is False. "
NotNestedGreaterGreater::usage = "\!\(\*RowBox[{\"NotNestedGreaterGreater\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotNestedGreaterGreater]\", \"y\", \"\[NotNestedGreaterGreater]\", \"\[Ellipsis]\"}]\)."
NotNestedLessLess::usage = "\!\(\*RowBox[{\"NotNestedLessLess\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotNestedLessLess]\", \"y\", \"\[NotNestedLessLess]\", \"\[Ellipsis]\"}]\)."
NotPrecedesEqual::usage = "\!\(\*RowBox[{\"NotPrecedesEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotPrecedesEqual]\", \"y\", \"\[NotPrecedesEqual]\", \"\[Ellipsis]\"}]\)."
NotPrecedes::usage = "\!\(\*RowBox[{\"NotPrecedes\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotPrecedes]\", \"y\", \"\[NotPrecedes]\", \"\[Ellipsis]\"}]\)."
NotPrecedesSlantEqual::usage = "\!\(\*RowBox[{\"NotPrecedesSlantEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotPrecedesSlantEqual]\", \"y\", \"\[NotPrecedesSlantEqual]\", \"\[Ellipsis]\"}]\)."
NotPrecedesTilde::usage = "\!\(\*RowBox[{\"NotPrecedesTilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotPrecedesTilde]\", \"y\", \"\[NotPrecedesTilde]\", \"\[Ellipsis]\"}]\)."
NotReverseElement::usage = "\!\(\*RowBox[{\"NotReverseElement\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotReverseElement]\", \"y\", \"\[NotReverseElement]\", \"\[Ellipsis]\"}]\)."
NotRightTriangleBar::usage = "\!\(\*RowBox[{\"NotRightTriangleBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotRightTriangleBar]\", \"y\", \"\[NotRightTriangleBar]\", \"\[Ellipsis]\"}]\)."
NotRightTriangleEqual::usage = "\!\(\*RowBox[{\"NotRightTriangleEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotRightTriangleEqual]\", \"y\", \"\[NotRightTriangleEqual]\", \"\[Ellipsis]\"}]\)."
NotRightTriangle::usage = "\!\(\*RowBox[{\"NotRightTriangle\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotRightTriangle]\", \"y\", \"\[NotRightTriangle]\", \"\[Ellipsis]\"}]\)."
NotSquareSubsetEqual::usage = "\!\(\*RowBox[{\"NotSquareSubsetEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotSquareSubsetEqual]\", \"y\", \"\[NotSquareSubsetEqual]\", \"\[Ellipsis]\"}]\)."
NotSquareSubset::usage = "\!\(\*RowBox[{\"NotSquareSubset\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotSquareSubset]\", \"y\", \"\[NotSquareSubset]\", \"\[Ellipsis]\"}]\)."
NotSquareSupersetEqual::usage = "\!\(\*RowBox[{\"NotSquareSupersetEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotSquareSupersetEqual]\", \"y\", \"\[NotSquareSupersetEqual]\", \"\[Ellipsis]\"}]\)."
NotSquareSuperset::usage = "\!\(\*RowBox[{\"NotSquareSuperset\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotSquareSuperset]\", \"y\", \"\[NotSquareSuperset]\", \"\[Ellipsis]\"}]\)."
NotSubsetEqual::usage = "\!\(\*RowBox[{\"NotSubsetEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotSubsetEqual]\", \"y\", \"\[NotSubsetEqual]\", \"\[Ellipsis]\"}]\)."
NotSubset::usage = "\!\(\*RowBox[{\"NotSubset\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotSubset]\", \"y\", \"\[NotSubset]\", \"\[Ellipsis]\"}]\)."
NotSucceedsEqual::usage = "\!\(\*RowBox[{\"NotSucceedsEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotSucceedsEqual]\", \"y\", \"\[NotSucceedsEqual]\", \"\[Ellipsis]\"}]\)."
NotSucceeds::usage = "\!\(\*RowBox[{\"NotSucceeds\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotSucceeds]\", \"y\", \"\[NotSucceeds]\", \"\[Ellipsis]\"}]\)."
NotSucceedsSlantEqual::usage = "\!\(\*RowBox[{\"NotSucceedsSlantEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotSucceedsSlantEqual]\", \"y\", \"\[NotSucceedsSlantEqual]\", \"\[Ellipsis]\"}]\)."
NotSucceedsTilde::usage = "\!\(\*RowBox[{\"NotSucceedsTilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotSucceedsTilde]\", \"y\", \"\[NotSucceedsTilde]\", \"\[Ellipsis]\"}]\)."
NotSupersetEqual::usage = "\!\(\*RowBox[{\"NotSupersetEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotSupersetEqual]\", \"y\", \"\[NotSupersetEqual]\", \"\[Ellipsis]\"}]\)."
NotSuperset::usage = "\!\(\*RowBox[{\"NotSuperset\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotSuperset]\", \"y\", \"\[NotSuperset]\", \"\[Ellipsis]\"}]\)."
NotTildeEqual::usage = "\!\(\*RowBox[{\"NotTildeEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotTildeEqual]\", \"y\", \"\[NotTildeEqual]\", \"\[Ellipsis]\"}]\)."
NotTildeFullEqual::usage = "\!\(\*RowBox[{\"NotTildeFullEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotTildeFullEqual]\", \"y\", \"\[NotTildeFullEqual]\", \"\[Ellipsis]\"}]\)."
NotTilde::usage = "\!\(\*RowBox[{\"NotTilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotTilde]\", \"y\", \"\[NotTilde]\", \"\[Ellipsis]\"}]\)."
NotTildeTilde::usage = "\!\(\*RowBox[{\"NotTildeTilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotTildeTilde]\", \"y\", \"\[NotTildeTilde]\", \"\[Ellipsis]\"}]\)."
NotVerticalBar::usage = "\!\(\*RowBox[{\"NotVerticalBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[NotVerticalBar]\", \"y\", \"\[NotVerticalBar]\", \"\[Ellipsis]\"}]\)."
NProductFactors::usage = "NProductFactors is an option for NProduct. \!\(\*RowBox[{\"NProductFactors\", \" \", \"->\", \" \", StyleBox[\"n\", \"TI\"]}]\) explicitly includes \!\(\*StyleBox[\"n\", \"TI\"]\) factors in the product before extrapolation."
NProduct::usage = "\!\(\*RowBox[{\"NProduct\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives a numerical approximation to the product \!\(\*RowBox[{UnderoverscriptBox[\"\[Product]\", RowBox[{StyleBox[\"i\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]]}], SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], LimitsPositioning -> True], \" \", StyleBox[\"f\", \"TI\"]}]\). \n\!\(\*RowBox[{\"NProduct\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"di\", \"TI\"]}], \"}\"}]}], \"]\"}]\) uses a step \!\(\*StyleBox[\"di\", \"TI\"]\) in the product. "
NRoots::usage = "\!\(\*RowBox[{\"NRoots\", \"[\", RowBox[{RowBox[{StyleBox[\"lhs\", \"TI\"], \"==\", StyleBox[\"rhs\", \"TI\"]}], \",\", StyleBox[\"var\", \"TI\"]}], \"]\"}]\) yields a disjunction of equations which represent numerical approximations to the roots of a polynomial equation. "
NSolve::usage = "\!\(\*RowBox[{\"NSolve\", \"[\", RowBox[{RowBox[{StyleBox[\"lhs\", \"TI\"], \"==\", StyleBox[\"rhs\", \"TI\"]}], \",\", StyleBox[\"var\", \"TI\"]}], \"]\"}]\) gives a list of numerical approximations to the roots of a polynomial equation. \n\!\(\*RowBox[{\"NSolve\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"eqn\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"eqn\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"var\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"var\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) solves a system of polynomial equations. "
NSum::usage = "\!\(\*RowBox[{\"NSum\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives a numerical approximation to the sum \!\(\*RowBox[{UnderoverscriptBox[\"\[Sum]\", RowBox[{StyleBox[\"i\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]]}], SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], LimitsPositioning -> True], \" \", StyleBox[\"f\", \"TI\"]}]\). \n\!\(\*RowBox[{\"NSum\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"di\", \"TI\"]}], \"}\"}]}], \"]\"}]\) uses a step \!\(\*StyleBox[\"di\", \"TI\"]\) in the sum. "
NSumTerms::usage = "NSumTerms is an option for NSum. \!\(\*RowBox[{\"NSumTerms\", \" \", \"->\", \" \", StyleBox[\"n\", \"TI\"]}]\) explicitly includes \!\(\*StyleBox[\"n\", \"TI\"]\) terms in the sum before extrapolation."
Null::usage = "Null is a symbol used to indicate the absence of an expression or a result. It is not displayed in ordinary output.  When Null appears as a complete output expression, no output is printed. "
NullRecords::usage = "NullRecords is an option for Read and related functions which specifies whether null records should be taken to exist between repeated record separators. "
NullSpace::usage = "\!\(\*RowBox[{\"NullSpace\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives a list of vectors that forms a basis for the null space of the matrix \!\(\*StyleBox[\"m\", \"TI\"]\). "
NullWords::usage = "NullWords is an option for Read and related functions which specifies whether null words should be taken to exist between repeated word separators. "
NumberFieldClassNumber::usage = "\!\(\*RowBox[{\"NumberFieldClassNumber\", \"[\", StyleBox[\"\[Theta]\", \"TR\"], \"]\"}]\) gives the class number for the algebraic number field \!\(\*RowBox[{\"\[DoubleStruckCapitalQ]\", \"[\", \"\[Theta]\", \"]\"}]\) generated by \[Theta]."
NumberFieldDiscriminant::usage = "\!\(\*RowBox[{\"NumberFieldDiscriminant\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) gives the discriminant of the field \!\(\*RowBox[{\"\[DoubleStruckCapitalQ]\", \"[\", \"a\", \"]\"}]\) generated by the algebraic number a."
NumberFieldFundamentalUnits::usage = "\!\(\*RowBox[{\"NumberFieldFundamentalUnits\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) gives a list of fundamental units for the field \!\(\*RowBox[{\"\[DoubleStruckCapitalQ]\", \"[\", \"a\", \"]\"}]\) generated by the algebraic number a."
NumberFieldIntegralBasis::usage = "\!\(\*RowBox[{\"NumberFieldIntegralBasis\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) gives an integral basis for the field \!\(\*RowBox[{\"\[DoubleStruckCapitalQ]\", \"[\", \"a\", \"]\"}]\) generated by the algebraic number a."
NumberFieldNormRepresentatives::usage = "\!\(\*RowBox[{\"NumberFieldNormRepresentatives\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives a list of representatives of classes of algebraic integers of norm \!\(\*RowBox[{\"\[PlusMinus]\", \"m\"}]\) in the field \!\(\*RowBox[{\"\[DoubleStruckCapitalQ]\", \"[\", \"a\", \"]\"}]\) generated by the algebraic number a."
NumberFieldRegulator::usage = "\!\(\*RowBox[{\"NumberFieldRegulator\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) gives the regulator of the field \!\(\*RowBox[{\"\[DoubleStruckCapitalQ]\", \"[\", \"a\", \"]\"}]\) generated by the algebraic number a."
NumberFieldRootsOfUnity::usage = "\!\(\*RowBox[{\"NumberFieldRootsOfUnity\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) gives the roots of unity for the field \!\(\*RowBox[{\"\[DoubleStruckCapitalQ]\", \"[\", \"a\", \"]\"}]\) generated by the algebraic number \!\(\*StyleBox[\"a\", \"TI\"]\)."
NumberFieldSignature::usage = "\!\(\*RowBox[{\"NumberFieldSignature\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) gives the signature of the field \!\(\*RowBox[{\"\[DoubleStruckCapitalQ]\", \"[\", \"a\", \"]\"}]\) generated by the algebraic number a."
NumberFormat::usage = "NumberFormat is an option for NumberForm and related functions which specifies how the mantissa, base and exponent should be assembled into a final print form. "
NumberForm::usage = "\!\(\*RowBox[{\"NumberForm\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) prints with approximate real numbers in \!\(\*StyleBox[\"expr\", \"TI\"]\) given to \!\(\*StyleBox[\"n\", \"TI\"]\)\[Hyphen]digit precision. "
NumberMarks::usage = "NumberMarks is an option for InputForm and related functions that specifies whether ` marks should be included in the printed forms of approximate numbers. "
NumberMultiplier::usage = "NumberMultiplier is an option for NumberForm and related functions which gives the string to use as a multiplication sign in scientific notation. "
Number::usage = "Number represents an exact integer or an approximate real number in Read. "
NumberPadding::usage = "NumberPadding is an option for NumberForm and related functions which gives strings to use as padding on the left\[Hyphen] and right\[Hyphen]hand sides of numbers. "
NumberPoint::usage = "NumberPoint is an option for NumberForm and related functions which gives the string to use as a decimal point. "
NumberQ::usage = "\!\(\*RowBox[{\"NumberQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a number, and False otherwise. "
NumberSeparator::usage = "NumberSeparator is an option for NumberForm and related functions which gives the string to insert at breaks between digits. "
NumberSigns::usage = "NumberSigns is an option for NumberForm and related functions which gives strings to use as signs for negative and positive numbers. "
NumberString::usage = "NumberString represents the characters of a number in StringExpression."
Numerator::usage = "\!\(\*RowBox[{\"Numerator\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the numerator of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
NumericFunction::usage = "NumericFunction is an attribute that can be assigned to a symbol \!\(\*StyleBox[\"f\", \"TI\"]\) to indicate that \!\(\*RowBox[{\"f\", \"[\", RowBox[{SubscriptBox[StyleBox[\"arg\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"arg\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) should be considered a numeric quantity whenever all the \!\(\*SubscriptBox[StyleBox[\"arg\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) are numeric quantities. "
NumericQ::usage = "\!\(\*RowBox[{\"NumericQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a numeric quantity, and False otherwise. "
NValues::usage = "\!\(\*RowBox[{\"NValues\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) gives a list of transformation rules corresponding to all numerical values (values for \!\(\*RowBox[{\"N\", \"[\", RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\), etc.) defined for the symbol \!\(\*StyleBox[\"f\", \"TI\"]\)."
OddQ::usage = "\!\(\*RowBox[{\"OddQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is an odd integer, and False otherwise. "
Off::usage = "\!\(\*RowBox[{\"Off\", \"[\", RowBox[{StyleBox[\"symbol\", \"TI\"], \"::\", StyleBox[\"tag\", \"TI\"]}], \"]\"}]\) switches off a message, so that it is no longer printed. \n\!\(\*RowBox[{\"Off\", \"[\", StyleBox[\"s\", \"TI\"], \"]\"}]\) switches off tracing messages associated with the symbol \!\(\*StyleBox[\"s\", \"TI\"]\). \n\!\(\*RowBox[{\"Off\", \"[\", RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) switches off several messages. \n\!\(\*RowBox[{\"Off\", \"[\", \"]\"}]\) switches off all tracing messages. "
Offset::usage = "\!\(\*RowBox[{\"Offset\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"dx\", \"TI\"], \",\", StyleBox[\"dy\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"position\", \"TI\"]}], \"]\"}]\) gives the position of a graphical object obtained by starting at the specified position and then moving by absolute offset \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"dx\", \"TI\"], \",\", StyleBox[\"dy\", \"TI\"]}], \"}\"}]\). "
O::usage = "\!\(\*RowBox[{RowBox[{\"O\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \"^\", StyleBox[\"n\", \"TI\"]}]\) represents a term of order \!\(\*SuperscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"n\", \"TI\"]]\). \n\!\(\*RowBox[{RowBox[{\"O\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \"^\", StyleBox[\"n\", \"TI\"]}]\) is generated to represent omitted higher\[Hyphen]order terms in power series. \n\!\(\*RowBox[{RowBox[{\"O\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"]\"}], \"^\", StyleBox[\"n\", \"TI\"]}]\) represents a term of order \!\(\*SuperscriptBox[RowBox[{\"(\", RowBox[{StyleBox[\"x\", \"TI\"], \"-\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \")\"}], StyleBox[\"n\", \"TI\"]]\). "
OneIdentity::usage = "OneIdentity is an attribute that can be assigned to a symbol \!\(\*StyleBox[\"f\", \"TI\"]\) to indicate that \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\), \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \"]\"}]\), etc. are all equivalent to \!\(\*StyleBox[\"x\", \"TI\"]\) for the purpose of pattern matching. "
On::usage = "\!\(\*RowBox[{\"On\", \"[\", RowBox[{StyleBox[\"symbol\", \"TI\"], \"::\", StyleBox[\"tag\", \"TI\"]}], \"]\"}]\) switches on a message, so that it can be printed. \n\!\(\*RowBox[{\"On\", \"[\", StyleBox[\"s\", \"TI\"], \"]\"}]\) switches on tracing for the symbol \!\(\*StyleBox[\"s\", \"TI\"]\). \n\!\(\*RowBox[{\"On\", \"[\", RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) switches on several messages. \n\!\(\*RowBox[{\"On\", \"[\", \"]\"}]\) switches on tracing for all symbols. "
Opacity::usage = "\!\(\*RowBox[{\"Opacity\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) is a graphics directive which specifies that graphical objects which follow are to be displayed, if possible, with opacity \!\(\*StyleBox[\"a\", \"TI\"]\). \n\!\(\*RowBox[{\"Opacity\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"color\", \"TI\"]}], \"]\"}]\) uses the specified color with opacity \!\(\*StyleBox[\"a\", \"TI\"]\)."
OpenAppend::usage = "\!\(\*RowBox[{\"OpenAppend\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) opens a file to append output to it, and returns an OutputStream object. "
Opener::usage = "\!\(\*RowBox[{\"Opener\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) represents an opener with setting \!\(\*StyleBox[\"x\", \"TI\"]\), displayed as \!\(\*OpenerBox[True]\) when \!\(\*StyleBox[\"x\", \"TI\"]\) is True and \!\(\*OpenerBox[False]\) when \!\(\*StyleBox[\"x\", \"TI\"]\) is False. \n\!\(\*RowBox[{\"Opener\", \"[\", RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\), with the value of \!\(\*StyleBox[\"x\", \"TI\"]\) being toggled if the opener is clicked. "
OpenerView::usage = "\!\(\*RowBox[{\"OpenerView\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \"]\"}]\) represents an object which displays as an opener, together with \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) if the opener is closed, and both \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) if it is open.\n\!\(\*RowBox[{\"OpenerView\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"state\", \"TI\"]}], \"]\"}]\) specifies the state of the opener, with False being closed, and True being open."
OpenRead::usage = "\!\(\*RowBox[{\"OpenRead\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) opens a file to read data from, and returns an InputStream object. "
OpenTemporary::usage = "\!\(\*RowBox[{\"OpenTemporary\", \"[\", \"]\"}]\) opens a temporary file to which output can be written, and returns an OutputStream object. "
OpenWrite::usage = "\!\(\*RowBox[{\"OpenWrite\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) opens a file to write output to it, and returns an OutputStream object. \n\!\(\*RowBox[{\"OpenWrite\", \"[\", \"]\"}]\) opens a new file in the default area for temporary files on your computer system."
Operate::usage = "\!\(\*RowBox[{\"Operate\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]}], \"]\"}]\) gives \!\(\*RowBox[{RowBox[{StyleBox[\"p\", \"TI\"], \"[\", StyleBox[\"f\", \"TI\"], \"]\"}], \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\). \n\!\(\*RowBox[{\"Operate\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"p\", \"TI\"]\) at level \!\(\*StyleBox[\"n\", \"TI\"]\) in the head of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Optional::usage = "\!\(\*RowBox[{StyleBox[\"p\", \"TI\"], \":\", StyleBox[\"v\", \"TI\"]}]\) is a pattern object which represents an expression of the form \!\(\*StyleBox[\"p\", \"TI\"]\), which, if omitted, should be replaced by \!\(\*StyleBox[\"v\", \"TI\"]\). "
OptionInspectorSettings::usage = "\!\(\*RowBox[{\"OptionInspectorSettings\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is a global option that specifies the display of options in the Option Inspector."
OptionQ::usage = "\!\(\*RowBox[{\"OptionQ\", \"[\", StyleBox[\"e\", \"TI\"], \"]\"}]\) returns True if \!\(\*StyleBox[\"e\", \"TI\"]\) can be considered an option or list of options, and False otherwise."
Options::usage = "\!\(\*RowBox[{\"Options\", \"[\", StyleBox[\"symbol\", \"TI\"], \"]\"}]\) gives the list of default options assigned to a symbol. \n\!\(\*RowBox[{\"Options\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the options explicitly specified in a particular expression such as a graphics object. \n\!\(\*RowBox[{\"Options\", \"[\", StyleBox[\"stream\", \"TI\"], \"]\"}]\) or \!\(\*RowBox[{\"Options\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"sname\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives options associated with a particular stream. \n\!\(\*RowBox[{\"Options\", \"[\", StyleBox[\"object\", \"TI\"], \"]\"}]\) gives options associated with an external object such as a NotebookObject. \n\!\(\*RowBox[{\"Options\", \"[\", RowBox[{StyleBox[\"obj\", \"TI\"], \",\", StyleBox[\"name\", \"TI\"]}], \"]\"}]\) gives the setting for the option \!\(\*StyleBox[\"name\", \"TI\"]\). \n\!\(\*RowBox[{\"Options\", \"[\", RowBox[{StyleBox[\"obj\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"name\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"name\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a list of the settings for the options \!\(\*SubscriptBox[StyleBox[\"name\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
OptionsPattern::usage = "\!\(\*RowBox[{\"OptionsPattern\", \"[\", \"]\"}]\) is a pattern object that represents a collection of options given as rules, where the values of the options can be accessed using OptionValue. \n\!\(\*RowBox[{\"OptionsPattern\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) takes default option values from \!\(\*RowBox[{\"Options\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\).\n\!\(\*RowBox[{\"OptionsPattern\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) uses an explicit list of default option values."
OptionValue::usage = "\!\(\*RowBox[{\"OptionValue\", \"[\", StyleBox[\"name\", \"TI\"], \"]\"}]\) gives the value of \!\(\*StyleBox[\"name\", \"TI\"]\) in options matched by OptionsPattern. \n\!\(\*RowBox[{\"OptionValue\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"name\", \"TI\"]}], \"]\"}]\) gives the value of \!\(\*StyleBox[\"name\", \"TI\"]\) for options associated with the head \!\(\*StyleBox[\"f\", \"TI\"]\). \n\!\(\*RowBox[{\"OptionValue\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"opts\", \"TI\"], \",\", StyleBox[\"name\", \"TI\"]}], \"]\"}]\) extracts option values from the explicit list of rules \!\(\*StyleBox[\"opts\", \"TI\"]\)."
Orange::usage = "Orange represents the color orange in graphics or style specifications. "
OrderedQ::usage = "\!\(\*RowBox[{\"OrderedQ\", \"[\", RowBox[{StyleBox[\"h\", \"TI\"], \"[\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}], \"]\"}]\) gives True if the \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) are in canonical order, and False otherwise. "
Ordering::usage = "\!\(\*RowBox[{\"Ordering\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the positions in \!\(\*StyleBox[\"list\", \"TI\"]\) at which each successive element of \!\(\*RowBox[{\"Sort\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) appears. \n\!\(\*RowBox[{\"Ordering\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the positions in \!\(\*StyleBox[\"list\", \"TI\"]\) at which the first \!\(\*StyleBox[\"n\", \"TI\"]\) elements of \!\(\*RowBox[{\"Sort\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) appear. \n\!\(\*RowBox[{\"Ordering\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"-\", StyleBox[\"n\", \"TI\"]}]}], \"]\"}]\) gives the positions of the last \!\(\*StyleBox[\"n\", \"TI\"]\) elements of \!\(\*RowBox[{\"Sort\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\). \n\!\(\*RowBox[{\"Ordering\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) uses \!\(\*RowBox[{\"Sort\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\). "
Orderless::usage = "Orderless is an attribute that can be assigned to a symbol \!\(\*StyleBox[\"f\", \"TI\"]\) to indicate that the elements \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) in expressions of the form \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) should automatically be sorted into canonical order. This property is accounted for in pattern matching. "
Order::usage = "\!\(\*RowBox[{\"Order\", \"[\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) gives 1 if \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) is before \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) in canonical order, and \!\(\*RowBox[{\"-\", \"1\"}]\) if \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) is after \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) in canonical order. It gives 0 if \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) is identical to \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]\). "
Or::usage = "\!\(\*RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"||\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"||\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\) is the logical OR function. It evaluates its arguments in order, giving True immediately if any of them are True, and False if they are all False. "
Orthogonalize::usage = "\!\(\*RowBox[{\"Orthogonalize\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives an orthonormal basis found by orthogonalizing the vectors \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"i\", \"TI\"]]\).\n\!\(\*RowBox[{\"Orthogonalize\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) gives a basis for the \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) orthonormal with respect to the inner product function \!\(\*StyleBox[\"f\", \"TI\"]\)."
Outer::usage = "\!\(\*RowBox[{\"Outer\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the generalized outer product of the \!\(\*SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"i\", \"TI\"]]\), forming all possible combinations of the lowest\[Hyphen]level elements in each of them, and feeding them as arguments to \!\(\*StyleBox[\"f\", \"TI\"]\). \n\!\(\*RowBox[{\"Outer\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) treats as separate elements only sublists at level \!\(\*StyleBox[\"n\", \"TI\"]\) in the \!\(\*SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Outer\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) treats as separate elements only sublists at level \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) in the corresponding \!\(\*SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
Out::usage = "\!\(\*RowBox[{\"%\", StyleBox[\"n\", \"TI\"]}]\) or \!\(\*RowBox[{\"Out\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) is a global object that is assigned to be the value produced on the \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) output line. \n% gives the last result generated. \n%% gives the result before last. \!\(\*RowBox[{\"%%\", StyleBox[\"\[Ellipsis]\", \"TR\"], \"%\"}]\) (\!\(\*StyleBox[\"k\", \"TI\"]\) times) gives the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) previous result. "
OutputAutoOverwrite::usage = "OutputAutoOverwrite is an option for notebooks that specifies whether the output of a command should replace any existing output from a previous evaluation."
OutputForm::usage = "\!\(\*RowBox[{\"OutputForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints as a two\[Hyphen]dimensional representation of \!\(\*StyleBox[\"expr\", \"TI\"]\) using only keyboard characters. "
OutputMathEditExpression::usage = "OutputMathEditExpression is an internal symbol used for formatting."
OutputNamePacket::usage = "\!\(\*RowBox[{\"OutputNamePacket\", \"[\", StyleBox[\"string\", \"TI\"], \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet that contains in \!\(\*StyleBox[\"string\", \"TI\"]\) the name assigned to the next output."
OutputSizeLimit::usage = "OutputSizeLimit is an option for notebooks which specifies the maximum size in bytes of expressions that will automatically be output in their entirety."
OutputStream::usage = "\!\(\*RowBox[{\"OutputStream\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) is an object that represents an output stream for functions such as Write. "
OverBar::usage = "\!\(\*RowBox[{\"OverBar\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays with a bar over \!\(\*StyleBox[\"expr\", \"TI\"]\)."
OverDot::usage = "\!\(\*RowBox[{\"OverDot\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays with a dot over \!\(\*StyleBox[\"expr\", \"TI\"]\)."
Overflow::usage = "\!\(\*RowBox[{\"Overflow\", \"[\", \"]\"}]\) represents a number too large to represent explicitly on your computer system."
OverHat::usage = "\!\(\*RowBox[{\"OverHat\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays with a hat over \!\(\*StyleBox[\"expr\", \"TI\"]\)."
Overlaps::usage = "Overlaps is an option to StringCases, StringCount and StringPosition that specifies how to treat overlapping substrings. "
OverscriptBox::usage = "\!\(\*RowBox[{OverscriptBox, \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) is the low\[Hyphen]level box representation for \!\(\*OverscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"y\", \"TI\"]]\) in notebook expressions. "
OverscriptBoxOptions::usage = "\!\(\*RowBox[{OverscriptBoxOptions, \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is a option that specifies the style and display of OverscriptBox constructs."
Overscript::usage = "\!\(\*RowBox[{\"Overscript\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) is an object that formats as \!\(\*OverscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"y\", \"TI\"]]\). "
OverTilde::usage = "\!\(\*RowBox[{\"OverTilde\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays with a tilde over \!\(\*StyleBox[\"expr\", \"TI\"]\)."
OverVector::usage = "\!\(\*RowBox[{\"OverVector\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays with a right vector over \!\(\*StyleBox[\"expr\", \"TI\"]\)."
OwnValues::usage = "\!\(\*RowBox[{\"OwnValues\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives the rule corresponding to any ownvalue defined for the symbol \!\(\*StyleBox[\"x\", \"TI\"]\)."
PackingMethod::usage = "PackingMethod is an option for GraphPlot and related functions which specifies how disconnected components should be packed together in the layout produced."
PaddedForm::usage = "\!\(\*RowBox[{\"PaddedForm\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) prints with all numbers in \!\(\*StyleBox[\"expr\", \"TI\"]\) padded to leave room for a total of \!\(\*StyleBox[\"n\", \"TI\"]\) digits. \n\!\(\*RowBox[{\"PaddedForm\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"}\"}]}], \"]\"}]\) prints with approximate real numbers having exactly \!\(\*StyleBox[\"f\", \"TI\"]\) digits to the right of the decimal point. "
PadeApproximant::usage = "\!\(\*RowBox[{\"PadeApproximant\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], StyleBox[\"}\", \"TI\"]}]}], \"}\"}]}], \"]\"}]\) gives the Pad\[EAcute] approximant to \!\(\*StyleBox[\"expr\", \"TI\"]\) about the point \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}]\), with numerator order \!\(\*StyleBox[\"m\", \"TI\"]\) and denominator order \!\(\*StyleBox[\"n\", \"TI\"]\).\n\!\(\*RowBox[{\"PadeApproximant\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives the diagonal Pad\[EAcute] approximant to \!\(\*StyleBox[\"expr\", \"TI\"]\) about the point \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}]\) of order \!\(\*StyleBox[\"n\", \"TI\"]\)."
PadLeft::usage = "\!\(\*RowBox[{\"PadLeft\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) makes a list of length \!\(\*StyleBox[\"n\", \"TI\"]\) by padding \!\(\*StyleBox[\"list\", \"TI\"]\) with zeros on the left. \n\!\(\*RowBox[{\"PadLeft\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) pads by repeating the element \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"PadLeft\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) pads by cyclically repeating the elements \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"PadLeft\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"padding\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) leaves a margin of \!\(\*StyleBox[\"m\", \"TI\"]\) elements of padding on the right. \n\!\(\*RowBox[{\"PadLeft\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) makes a nested list with length \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) at level \!\(\*StyleBox[\"i\", \"TI\"]\). \n\!\(\*RowBox[{\"PadLeft\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) pads a ragged array \!\(\*StyleBox[\"list\", \"TI\"]\) with zeros to make it full. "
PadRight::usage = "\!\(\*RowBox[{\"PadRight\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) makes a list of length \!\(\*StyleBox[\"n\", \"TI\"]\) by padding \!\(\*StyleBox[\"list\", \"TI\"]\) with zeros on the right. \n\!\(\*RowBox[{\"PadRight\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) pads by repeating the element \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"PadRight\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) pads by cyclically repeating the elements \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"PadRight\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"padding\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) leaves a margin of \!\(\*StyleBox[\"m\", \"TI\"]\) elements of padding on the left. \n\!\(\*RowBox[{\"PadRight\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) makes a nested list with length \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) at level \!\(\*StyleBox[\"i\", \"TI\"]\). \n\!\(\*RowBox[{\"PadRight\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) pads a ragged array \!\(\*StyleBox[\"list\", \"TI\"]\) with zeros to make it full. "
PageBreakAbove::usage = "PageBreakAbove is an option for Cell which specifies whether a page break should be made immediately above the cell if the notebook that contains the cell is printed. "
PageBreakBelow::usage = "PageBreakBelow is an option for Cell which specifies whether a page break should be made immediately below the cell if the notebook that contains the cell is printed. "
PageBreakWithin::usage = "PageBreakWithin is an option for Cell which specifies whether a page break should be allowed within the cell if the notebook that contains the cell is printed. "
PageFooterLines::usage = "PageFooterLines is an option for notebooks that specifies whether a horizontal line is inserted at the bottom of each page when the notebook is printed."
PageFooters::usage = "PageFooters is an option for notebooks that specifies what should be inserted as the footer of each page of a notebook when it is printed."
PageHeaderLines::usage = "PageHeaderLines is an option for notebooks that specifies whether a horizontal line is inserted at the top of each page when the notebook is printed."
PageHeaders::usage = "PageHeaders is an option for notebooks that specifies what should be inserted as the header of each page of a notebook when it is printed."
PageWidth::usage = "PageWidth is an option for output streams and for cells which specifies how wide each line of text should be allowed to be. "
PaletteNotebook::usage = "\!\(\*RowBox[{\"PaletteNotebook\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cell\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents a palette notebook that can be manipulated by the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) front end. "
PalettePath::usage = "PalettePath is a global option that specifies which directories \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) searches for palettes on startup."
Paneled::usage = "Paneled is an option for Manipulate and related functions that specifies whether to give the output inside a panel."
Panel::usage = "\!\(\*RowBox[{\"Panel\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays as a panel containing \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Panel\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"title\", \"TI\"]}], \"]\"}]\) gives the panel the specified title. \n\!\(\*RowBox[{\"Panel\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"title\", \"TI\"], \",\", StyleBox[\"pos\", \"TI\"]}], \"]\"}]\) places \!\(\*StyleBox[\"title\", \"TI\"]\) at a position specified by \!\(\*StyleBox[\"pos\", \"TI\"]\). \n\!\(\*RowBox[{\"Panel\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"title\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"title\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) places \!\(\*SubscriptBox[StyleBox[\"title\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) at position \!\(\*SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Panel\", \"[\", \"]\"}]\) displays an empty panel. "
Pane::usage = "\!\(\*RowBox[{\"Pane\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays as a pane containing \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Pane\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"w\", \"TI\"]}], \"]\"}]\) makes the pane be \!\(\*StyleBox[\"w\", \"TI\"]\) printer's points wide, line\[Hyphen]wrapping the contents if necessary.\n\!\(\*RowBox[{\"Pane\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"w\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"}\"}]}], \"]\"}]\) makes the pane be \!\(\*StyleBox[\"w\", \"TI\"]\) points wide, and \!\(\*StyleBox[\"h\", \"TI\"]\) points high, shrinking the contents if necessary."
PaneSelector::usage = "\!\(\*RowBox[{\"PaneSelector\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) represents an object that displays as a pane containing the \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) for which \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) is equal to \!\(\*StyleBox[\"v\", \"TI\"]\). "
ParabolicCylinderD::usage = "\!\(\*RowBox[{\"ParabolicCylinderD\", \"[\", RowBox[{StyleBox[\"\[Nu]\", \"TR\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the parabolic cylinder function \!\(\*RowBox[{SubscriptBox[\"D\", \"\[Nu]\"], \"(\", \"z\", \")\"}]\). "
ParagraphIndent::usage = "ParagraphIndent is an option for Cell which specifies how far in printer\[CloseCurlyQuote]s points to indent the first line of each paragraph of text. "
ParagraphSpacing::usage = "ParagraphSpacing is an option for Cell, StyleBox and Style which specifies how much extra space to leave between successive paragraphs of text. "
ParameterVariables::usage = "ParameterVariables is an option for GroebnerBasis and PolynomialReduce. These variables will always be last in the ordering. By default, all variables that are not otherwise classified will become parameter variables. By specifying them explicitly one fixes their relative positions in the overall variable ordering."
ParametricPlot3D::usage = "\!\(\*RowBox[{\"ParametricPlot3D\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"z\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) produces a three\[Hyphen]dimensional space curve parametrized by a variable \!\(\*StyleBox[\"u\", \"TI\"]\) which runs from \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"ParametricPlot3D\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"z\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) produces a three\[Hyphen]dimensional surface parametrized by \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\). \n\!\(\*RowBox[{\"ParametricPlot3D\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"z\", \"TI\"]]}], \"}\"}], \",\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"y\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"z\", \"TI\"]]}], \"}\"}], StyleBox[\"\[Ellipsis]\", \"TR\"]}]}], \"}\"}], StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) plots several objects together. "
ParametricPlot::usage = "\!\(\*RowBox[{\"ParametricPlot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a parametric plot of a curve with \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\) coordinates \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]]\) as a function of \!\(\*StyleBox[\"u\", \"TI\"]\). \n\!\(\*RowBox[{\"ParametricPlot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) plots several parametric curves. \n\!\(\*RowBox[{\"ParametricPlot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) plots a parametric region. \n\!\(\*RowBox[{\"ParametricPlot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) plots several parametric regions. "
ParentDirectory::usage = "\!\(\*RowBox[{\"ParentDirectory\", \"[\", \"]\"}]\) gives the parent of the current working directory. \n\!\(\*RowBox[{\"ParentDirectory\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"dir\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the parent of the directory \!\(\*StyleBox[\"dir\", \"TI\"]\). "
ParentForm::usage = "ParentForm sets the parent form for a boxes format."
Parenthesize::usage = "\!\(\*RowBox[{\"Parenthesize\", \"[\", \" \", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", \" \", StyleBox[\"fmt\", \"TI\"], \",\", \" \", StyleBox[\"prec\", \"TI\"], \",\", \" \", StyleBox[\"group\", \"TI\"]}], \"]\"}]\) will represent \!\(\*StyleBox[\"expr\", \"TI\"]\) in format \!\(\*StyleBox[\"fmt\", \"TI\"]\) and parenthesize it if necessary."
ParetoDistribution::usage = "\!\(\*RowBox[{\"ParetoDistribution\", \"[\", RowBox[{StyleBox[\"k\", \"TI\"], \",\", StyleBox[\"\[Alpha]\", \"TR\"]}], \"]\"}]\) represents a Pareto distribution with minimum value parameter \!\(\*StyleBox[\"k\", \"TI\"]\) and shape parameter \!\(\*StyleBox[\"\[Alpha]\", \"TR\"]\)."
ParticleData::usage = "\!\(\*RowBox[{\"ParticleData\", \"[\", RowBox[{StyleBox[\"name\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the specified property for a subatomic particle or family of particles with the specified name. \n\!\(\*RowBox[{\"ParticleData\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"name\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the specified property for a version of the particle with charge \!\(\*StyleBox[\"q\", \"TI\"]\)."
Partition::usage = "\!\(\*RowBox[{\"Partition\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) partitions \!\(\*StyleBox[\"list\", \"TI\"]\) into non\[Hyphen]overlapping sublists of length \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"Partition\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"]\"}]\) generates sublists with offset \!\(\*StyleBox[\"d\", \"TI\"]\). \n\!\(\*RowBox[{\"Partition\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) partitions a nested list into blocks of size \!\(\*RowBox[{SubscriptBox[\"n\", \"1\"], \" \", \"\[Cross]\", \" \", SubscriptBox[\"n\", RowBox[{\"2\", \" \"}]], \"\[Cross]\", \" \", \"\[Ellipsis]\"}]\). \n\!\(\*RowBox[{\"Partition\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) uses offset \!\(\*SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) at level \!\(\*StyleBox[\"i\", \"TI\"]\) in \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Partition\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"L\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"R\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) specifies that the first element of \!\(\*StyleBox[\"list\", \"TI\"]\) should appear at position \!\(\*SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"L\", \"TI\"]]\) in the first sublist, and the last element of \!\(\*StyleBox[\"list\", \"TI\"]\) should appear at or after position \!\(\*SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"R\", \"TI\"]]\) in the last sublist. If additional elements are needed, Partition fills them in by treating \!\(\*StyleBox[\"list\", \"TI\"]\) as cyclic. \n\!\(\*RowBox[{\"Partition\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"L\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"R\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) pads if necessary by repeating the element \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"Partition\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"L\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"R\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) pads if necessary by cyclically repeating the elements \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Partition\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"L\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"k\", \"TI\"], StyleBox[\"R\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", \"}\"}]}], \"]\"}]\) uses no padding, and so can yield sublists of different lengths. \n\!\(\*RowBox[{\"Partition\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"nlist\", \"TI\"], \",\", StyleBox[\"dlist\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"klist\", \"TI\"], StyleBox[\"L\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"klist\", \"TI\"], StyleBox[\"R\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"padlist\", \"TI\"]}], \"]\"}]\) specifies alignments and padding in a nested list. "
PartitionsP::usage = "\!\(\*RowBox[{\"PartitionsP\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the number \!\(\*RowBox[{StyleBox[\"p\", \"TI\"], RowBox[{\"(\", StyleBox[\"n\", \"TI\"], \")\"}]}]\) of unrestricted partitions of the integer \!\(\*StyleBox[\"n\", \"TI\"]\). "
PartitionsQ::usage = "\!\(\*RowBox[{\"PartitionsQ\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the number \!\(\*RowBox[{StyleBox[\"q\", \"TI\"], RowBox[{\"(\", StyleBox[\"n\", \"TI\"], \")\"}]}]\) of partitions of the integer \!\(\*StyleBox[\"n\", \"TI\"]\) into distinct parts. "
Part::usage = "\!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \"[\", RowBox[{\"[\", StyleBox[\"i\", \"TI\"], \"]\"}], \"]\"}]\) or \!\(\*RowBox[{\"Part\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"i\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[\"i\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) part of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \"[\", RowBox[{\"[\", RowBox[{\"-\", StyleBox[\"i\", \"TI\"]}], \"]\"}], \"]\"}]\) counts from the end. \n\!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \"[\", RowBox[{\"[\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}], \"]\"}]\) or \!\(\*RowBox[{\"Part\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) is equivalent to \!\(\*RowBox[{RowBox[{RowBox[{StyleBox[\"expr\", \"TI\"], \"[\", RowBox[{\"[\", StyleBox[\"i\", \"TI\"], \"]\"}], \"]\"}], \"[\", RowBox[{\"[\", StyleBox[\"j\", \"TI\"], \"]\"}], \"]\"}], StyleBox[\"\[Ellipsis]\", \"TR\"]}]\). \n\!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \"[\", RowBox[{\"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}], \"]\"}]\) gives a list of the parts \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\) of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \"[\", RowBox[{\"[\", RowBox[{StyleBox[\"m\", \"TI\"], \";;\", StyleBox[\"n\", \"TI\"]}], \"]\"}], \"]\"}]\) gives parts \!\(\*StyleBox[\"m\", \"TI\"]\) through \!\(\*StyleBox[\"n\", \"TI\"]\).\n\!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \"[\", RowBox[{\"[\", RowBox[{StyleBox[\"m\", \"TI\"], \";;\", StyleBox[\"n\", \"TI\"], \";;\", StyleBox[\"s\", \"TI\"]}], \"]\"}], \"]\"}]\) gives parts \!\(\*StyleBox[\"m\", \"TI\"]\) through \!\(\*StyleBox[\"n\", \"TI\"]\) in steps of \!\(\*StyleBox[\"s\", \"TI\"]\)."
PassEventsDown::usage = "PassEventsDown is an option to EventHandler which specifies whether events handled by a particular event handler should be passed down to event handlers nested inside."
PassEventsUp::usage = "PassEventsUp is an option to EventHandler which specifies whether events handled by a particular event handler should be passed up to event handlers in outer expressions."
PasteBoxFormInlineCells::usage = "PasteBoxFormInlineCells is an option for cells that specifies whether a new inline cell is created when a typeset expression is pasted into a non-box-type cell."
PasteButton::usage = "\!\(\*RowBox[{\"PasteButton\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) represents a button that pastes \!\(\*StyleBox[\"expr\", \"TI\"]\) whenever it is pressed. \n\!\(\*RowBox[{\"PasteButton\", \"[\", RowBox[{StyleBox[\"label\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) displays with \!\(\*StyleBox[\"label\", \"TI\"]\) on the button. "
Path::usage = "Path is an option for Get and related functions which gives a list of directories to search in attempting to find an external file. "
Pattern::usage = "\!\(\*RowBox[{StyleBox[\"s\", \"TI\"], \":\", StyleBox[\"obj\", \"TI\"]}]\) represents the pattern object \!\(\*StyleBox[\"obj\", \"TI\"]\), assigned the name \!\(\*StyleBox[\"s\", \"TI\"]\). "
PatternSequence::usage = "\!\(\*RowBox[{\"PatternSequence\", \"[\", RowBox[{SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) is a pattern object which represents a sequence of arguments matching \!\(\*SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\)."
PatternTest::usage = "\!\(\*RowBox[{StyleBox[\"p\", \"TI\"], \"?\", StyleBox[\"test\", \"TI\"]}]\) is a pattern object that stands for any expression which matches \!\(\*StyleBox[\"p\", \"TI\"]\), and on which the application of \!\(\*StyleBox[\"test\", \"TI\"]\) gives True. "
Pause::usage = "\!\(\*RowBox[{\"Pause\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) pauses for at least \!\(\*StyleBox[\"n\", \"TI\"]\) seconds. "
PDF::usage = "\!\(\*RowBox[{\"PDF\", \"[\", RowBox[{StyleBox[\"dist\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the probability density function for the symbolic distribution \!\(\*StyleBox[\"dist\", \"TI\"]\) evaluated at \!\(\*StyleBox[\"x\", \"TI\"]\).\n\!\(\*RowBox[{\"PDF\", \"[\", StyleBox[\"dist\", \"TI\"], \"]\"}]\) gives the PDF as a pure function."
PerformanceGoal::usage = "PerformanceGoal is an option for plotting and various other algorithmic functions that specifies what aspect of performance to try to optimize with Automatic settings for options."
Permutations::usage = "\!\(\*RowBox[{\"Permutations\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) generates a list of all possible permutations of the elements in \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Permutations\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives all permutations containing at most \!\(\*StyleBox[\"n\", \"TI\"]\) elements.\n\!\(\*RowBox[{\"Permutations\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", StyleBox[\"n\", \"TI\"], \"}\"}]}], \"]\"}]\) gives all permutations containing exactly \!\(\*StyleBox[\"n\", \"TI\"]\) elements."
Pick::usage = "\!\(\*RowBox[{\"Pick\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"sel\", \"TI\"]}], \"]\"}]\) picks out those elements of \!\(\*StyleBox[\"list\", \"TI\"]\) for which the corresponding element of \!\(\*StyleBox[\"sel\", \"TI\"]\) is True. \n\!\(\*RowBox[{\"Pick\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"sel\", \"TI\"], \",\", StyleBox[\"patt\", \"TI\"]}], \"]\"}]\) picks out those elements of \!\(\*StyleBox[\"list\", \"TI\"]\) for which the corresponding element of \!\(\*StyleBox[\"sel\", \"TI\"]\) matches \!\(\*StyleBox[\"patt\", \"TI\"]\). "
PiecewiseExpand::usage = "\!\(\*RowBox[{\"PiecewiseExpand\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) expands nested piecewise functions in \!\(\*StyleBox[\"expr\", \"TI\"]\) to give a single piecewise function. \n\!\(\*RowBox[{\"PiecewiseExpand\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"assum\", \"TI\"]}], \"]\"}]\) expands piecewise functions using assumptions. \n\!\(\*RowBox[{\"PiecewiseExpand\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"assum\", \"TI\"], \",\", StyleBox[\"dom\", \"TI\"]}], \"]\"}]\) does the expansion over the domain \!\(\*StyleBox[\"dom\", \"TI\"]\). "
Piecewise::usage = "\!\(\*RowBox[{\"Piecewise\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cond\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cond\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents a piecewise function with values \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) in the regions defined by the conditions \!\(\*SubscriptBox[StyleBox[\"cond\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Piecewise\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"cond\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"val\", \"TI\"]}], \"]\"}]\) uses default value \!\(\*StyleBox[\"val\", \"TI\"]\) if none of the \!\(\*SubscriptBox[StyleBox[\"cond\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) apply. The default for \!\(\*StyleBox[\"val\", \"TI\"]\) is 0. "
Pi::usage = "Pi is \!\(\*StyleBox[\"\[Pi]\", \"TR\"]\), with numerical value \!\(\*RowBox[{\"\[TildeEqual]\", \"3.14159\"}]\). "
Pink::usage = "Pink represents the color pink in graphics or style specifications. "
Pivoting::usage = "Pivoting is an option to certain matrix decomposition functions. With \!\(\*RowBox[{\"Pivoting\", \" \", \"->\", \" \", \"False\"}]\), no pivoting is done. With \!\(\*RowBox[{\"Pivoting\", \" \", \"->\", \" \", \"True\"}]\), column pivoting is carried out and the list of matrices returned is augmented by the appropriate permutation matrix."
PixelConstrained::usage = "PixelConstrained is an option for ArrayPlot which specifies how to constrain cells to align with displayed pixels."
Plain::usage = "Plain represents a font that is not bold, italic or underlined."
Play::usage = "\!\(\*RowBox[{\"Play\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) creates an object that plays as a sound whose amplitude is given by \!\(\*StyleBox[\"f\", \"TI\"]\) as a function of time \!\(\*StyleBox[\"t\", \"TI\"]\) in seconds between \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). "
PlayRange::usage = "PlayRange is an option for Play and related functions which specifies what range of sound amplitude levels should be included. "
Plot3D::usage = "\!\(\*RowBox[{\"Plot3D\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a three\[Hyphen]dimensional plot of \!\(\*StyleBox[\"f\", \"TI\"]\) as a function of \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\). \n\!\(\*RowBox[{\"Plot3D\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) plots several functions. "
PlotDivision::usage = "PlotDivision is an option for Plot that specifies the maximum amount of subdivision to be used."
PlotJoined::usage = "PlotJoined is an option for ListPlot that specifies whether the points plotted should be joined by a line. "
PlotLabel::usage = "PlotLabel is an option for graphics functions that specifies an overall label for a plot. "
PlotMarkers::usage = "PlotMarkers is an option for graphics functions like ListPlot and ListLinePlot that specifies what markers to draw at the points plotted. "
Plot::usage = "\!\(\*RowBox[{\"Plot\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a plot of \!\(\*StyleBox[\"f\", \"TI\"]\) as a function of \!\(\*StyleBox[\"x\", \"TI\"]\) from \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"Plot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) plots several functions \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
PlotPoints::usage = "PlotPoints is an option for plotting functions that specifies how many initial sample points to use. "
PlotRangeClipping::usage = "PlotRangeClipping is an option for graphics functions that specifies whether graphics objects should be clipped at the edge of the region defined by PlotRange, or should be allowed to extend to the actual edge of the image. "
PlotRange::usage = "PlotRange is an option for graphics functions that specifies what range of coordinates to include in a plot. "
PlotRangePadding::usage = "PlotRangePadding is an option for graphics functions that specifies how much further axes etc. should extend beyond the range of coordinates specified by PlotRange. "
PlotRegion::usage = "PlotRegion is an option for graphics functions that specifies what region of the final display area a plot should fill. "
PlotStyle::usage = "PlotStyle is an option for plotting and related functions that specifies styles in which objects are to be drawn. "
PlusMinus::usage = "\!\(\*RowBox[{\"PlusMinus\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) displays as \!\(\*RowBox[{\"\[PlusMinus]\", StyleBox[\"x\", \"TI\"]}]\).\n\!\(\*RowBox[{\"PlusMinus\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", \"\[Ellipsis]\"}], \"]\"}]\) displays as \!\(\*RowBox[{RowBox[{\"x\", \"\[PlusMinus]\", \"y\"}], \"\[PlusMinus]\", \"\[Ellipsis]\"}]\)."
Plus::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"+\", StyleBox[\"y\", \"TI\"], \"+\", StyleBox[\"z\", \"TI\"]}]\) represents a sum of terms. "
Pochhammer::usage = "\!\(\*RowBox[{\"Pochhammer\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the Pochhammer symbol \!\(\*SubscriptBox[RowBox[{\"(\", \"a\", \")\"}], \"n\"]\). "
PointForm::usage = "\!\(\*RowBox[{\"PointForm\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) is a three-dimensional graphics directive that specifies that points are to be drawn with the graphics directive \!\(\*StyleBox[\"g\", \"TI\"]\) or the list of graphics directives \!\(\*StyleBox[\"g\", \"TI\"]\)."
Point::usage = "\!\(\*RowBox[{\"Point\", \"[\", StyleBox[\"coords\", \"TI\"], \"]\"}]\) is a graphics primitive that represents a point. \n\!\(\*RowBox[{\"Point\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"coords\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"coords\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents a collection of points. "
PointSize::usage = "\!\(\*RowBox[{\"PointSize\", \"[\", StyleBox[\"d\", \"TI\"], \"]\"}]\) is a graphics directive which specifies that points which follow are to be shown if possible as circular regions with diameter \!\(\*StyleBox[\"d\", \"TI\"]\). The diameter \!\(\*StyleBox[\"d\", \"TI\"]\) is given as a fraction of the total width of the plot. "
PoissonDistribution::usage = "\!\(\*RowBox[{\"PoissonDistribution\", \"[\", StyleBox[\"\[Mu]\", \"TR\"], \"]\"}]\) represents a Poisson distribution with mean \!\(\*StyleBox[\"\[Mu]\", \"TR\"]\)."
PolarPlot::usage = "\!\(\*RowBox[{\"PolarPlot\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a polar plot of a curve with radius \!\(\*StyleBox[\"r\", \"TI\"]\) as a function of angle \!\(\*StyleBox[\"\[Theta]\", \"TR\"]\).\n\!\(\*RowBox[{\"PolarPlot\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) makes a polar plot of curves with radius functions \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\)."
PolyGamma::usage = "\!\(\*RowBox[{\"PolyGamma\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the digamma function \!\(\*RowBox[{\"\[Psi]\", \"(\", \"z\"}]\)). \n\!\(\*RowBox[{\"PolyGamma\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the \!\(\*SuperscriptBox[StyleBox[\"n\", \"TI\"], \"th\"]\) derivative of the digamma function \!\(\*RowBox[{SuperscriptBox[\"\[Psi]\", RowBox[{\"(\", \"n\", \")\"}]], \"(\", \"z\", \")\"}]\). "
PolygonIntersections::usage = "PolygonIntersections is an option for Graphics3D which specifies whether intersecting polygons should be left unchanged. "
Polygon::usage = "\!\(\*RowBox[{\"Polygon\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) is a graphics primitive that represents a filled polygon. \n\!\(\*RowBox[{\"Polygon\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"21\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents a collection of polygons. "
PolyhedronData::usage = "\!\(\*RowBox[{\"PolyhedronData\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"property\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the value of the specified property for the polyhedron named \!\(\*StyleBox[\"poly\", \"TI\"]\).\n\!\(\*RowBox[{\"PolyhedronData\", \"[\", StyleBox[\"poly\", \"TI\"], \"]\"}]\) gives an image of the polyhedron named \!\(\*StyleBox[\"poly\", \"TI\"]\).\n\!\(\*RowBox[{\"PolyhedronData\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"class\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a list of the polyhedra in the specified class."
PolyLog::usage = "\!\(\*RowBox[{\"PolyLog\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the polylogarithm function \!\(\*RowBox[{SubscriptBox[\"Li\", \"n\"], \"(\", \"z\", \")\"}]\).\n\!\(\*RowBox[{\"PolyLog\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the Nielsen generalized polylogarithm function \!\(\*RowBox[{SubscriptBox[\"S\", RowBox[{\"n\", \",\", \"p\"}]], \"(\", \"z\", \")\"}]\). "
PolynomialExtendedGCD::usage = "\!\(\*RowBox[{\"PolynomialExtendedGCD\", \"[\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the extended GCD of \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) treated as univariate polynomials in \!\(\*StyleBox[\"x\", \"TI\"]\).\n\!\(\*RowBox[{\"PolynomialExtendedGCD\", \"[\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"Modulus\", \"->\", StyleBox[\"p\", \"TI\"]}]}], \"]\"}]\) gives the extended GCD over the integers mod prime \!\(\*StyleBox[\"p\", \"TI\"]\)."
PolynomialGCD::usage = "\!\(\*RowBox[{\"PolynomialGCD\", \"[\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the greatest common divisor of the polynomials \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"PolynomialGCD\", \"[\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", RowBox[{\"Modulus\", \"->\", StyleBox[\"p\", \"TI\"]}]}], \"]\"}]\) evaluates the GCD modulo the prime \!\(\*StyleBox[\"p\", \"TI\"]\). "
PolynomialLCM::usage = "\!\(\*RowBox[{\"PolynomialLCM\", \"[\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives the least common multiple of the polynomials \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"PolynomialLCM\", \"[\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", RowBox[{\"Modulus\", \"->\", StyleBox[\"p\", \"TI\"]}]}], \"]\"}]\) evaluates the LCM modulo the prime \!\(\*StyleBox[\"p\", \"TI\"]\). "
PolynomialMod::usage = "\!\(\*RowBox[{\"PolynomialMod\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the polynomial \!\(\*StyleBox[\"poly\", \"TI\"]\) reduced modulo \!\(\*StyleBox[\"m\", \"TI\"]\). \n\!\(\*RowBox[{\"PolynomialMod\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) reduces modulo all of the \!\(\*SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
PolynomialQ::usage = "\!\(\*RowBox[{\"PolynomialQ\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"var\", \"TI\"]}], \"]\"}]\) yields True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a polynomial in \!\(\*StyleBox[\"var\", \"TI\"]\), and yields False otherwise. \n\!\(\*RowBox[{\"PolynomialQ\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"var\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) tests whether \!\(\*StyleBox[\"expr\", \"TI\"]\) is a polynomial in the \!\(\*SubscriptBox[StyleBox[\"var\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
PolynomialQuotient::usage = "\!\(\*RowBox[{\"PolynomialQuotient\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the quotient of \!\(\*StyleBox[\"p\", \"TI\"]\) and \!\(\*StyleBox[\"q\", \"TI\"]\), treated as polynomials in \!\(\*StyleBox[\"x\", \"TI\"]\), with any remainder dropped. "
PolynomialQuotientRemainder::usage = "\!\(\*RowBox[{\"PolynomialQuotientRemainder\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives a list of the quotient and remainder of \!\(\*StyleBox[\"p\", \"TI\"]\) and \!\(\*StyleBox[\"q\", \"TI\"]\), treated as polynomials in \!\(\*StyleBox[\"x\", \"TI\"]\). "
PolynomialReduce::usage = "\!\(\*RowBox[{\"PolynomialReduce\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) yields a list representing a reduction of \!\(\*StyleBox[\"poly\", \"TI\"]\) in terms of the \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). The list has the form \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"b\", \"TI\"]}], \"}\"}]\), where \!\(\*StyleBox[\"b\", \"TI\"]\) is minimal and \!\(\*RowBox[{RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \" \", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"+\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"2\", \"TR\"]], \" \", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"+\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\) \!\(\*RowBox[{\"+\", StyleBox[\"b\", \"TI\"]}]\) is exactly \!\(\*StyleBox[\"poly\", \"TI\"]\). "
PolynomialRemainder::usage = "\!\(\*RowBox[{\"PolynomialRemainder\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives the remainder from dividing \!\(\*StyleBox[\"p\", \"TI\"]\) by \!\(\*StyleBox[\"q\", \"TI\"]\), treated as polynomials in \!\(\*StyleBox[\"x\", \"TI\"]\). "
Polynomials::usage = "\!\(\*RowBox[{\"Polynomials\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) represents the domain of polynomials in \!\(\*StyleBox[\"x\", \"TI\"]\)."
PopupMenu::usage = "\!\(\*RowBox[{\"PopupMenu\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents a popup menu with setting \!\(\*StyleBox[\"x\", \"TI\"]\) and possible values \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"PopupMenu\", \"[\", RowBox[{RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\), with the value of \!\(\*StyleBox[\"x\", \"TI\"]\) being reset every time an item is selected from the menu. \n\!\(\*RowBox[{\"PopupMenu\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents a popup menu in which possible value \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) is indicated by \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"PopupMenu\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"dlbl\", \"TI\"]}], \"]\"}]\) displays the menu item as \!\(\*StyleBox[\"dlbl\", \"TI\"]\) if \!\(\*StyleBox[\"x\", \"TI\"]\) is none of the \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"PopupMenu\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", StyleBox[\"\[Ellipsis]\", \"TR\"], \"}\"}], \",\", StyleBox[\"dlbl\", \"TI\"], \",\", StyleBox[\"base\", \"TI\"]}], \"]\"}]\) displays as \!\(\*StyleBox[\"base\", \"TI\"]\) when it is not being clicked. "
PopupView::usage = "\!\(\*RowBox[{\"PopupView\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents an object which displays as a popup menu whose items are the \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\).\n\!\(\*RowBox[{\"PopupView\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"i\", \"TI\"]}], \"]\"}]\) makes the \!\(\*StyleBox[\"i\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) entry be the one currently chosen.\n\!\(\*RowBox[{\"PopupView\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"base\", \"TI\"]}], \"]\"}]\) displays as \!\(\*StyleBox[\"base\", \"TI\"]\) if it is not being clicked."
PopupWindow::usage = "\!\(\*RowBox[{\"PopupWindow\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"contents\", \"TI\"]}], \"]\"}]\) displays as \!\(\*StyleBox[\"expr\", \"TI\"]\), but pops up a window containing \!\(\*StyleBox[\"contents\", \"TI\"]\) when clicked."
Position::usage = "\!\(\*RowBox[{\"Position\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"pattern\", \"TI\"]}], \"]\"}]\) gives a list of the positions at which objects matching \!\(\*StyleBox[\"pattern\", \"TI\"]\) appear in \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Position\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"pattern\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"]}], \"]\"}]\) finds only objects that appear on levels specified by \!\(\*StyleBox[\"levelspec\", \"TI\"]\). \n\!\(\*RowBox[{\"Position\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"pattern\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the positions of the first \!\(\*StyleBox[\"n\", \"TI\"]\) objects found. "
PositiveDefiniteMatrixQ::usage = "\!\(\*RowBox[{\"PositiveDefiniteMatrixQ\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) tests whether \!\(\*StyleBox[\"m\", \"TI\"]\) is a positive definite matrix."
Positive::usage = "\!\(\*RowBox[{\"Positive\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"x\", \"TI\"]\) is a positive number. "
PossibleZeroQ::usage = "\!\(\*RowBox[{\"PossibleZeroQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives True if basic symbolic and numerical methods suggest that \!\(\*StyleBox[\"expr\", \"TI\"]\) has value zero, and gives False otherwise. "
Postfix::usage = "\!\(\*RowBox[{\"Postfix\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}], \"]\"}]\) prints with \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) given in default postfix form: \!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \"//\", StyleBox[\"f\", \"TI\"]}]\). \n\!\(\*RowBox[{\"Postfix\", \"[\", RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) prints as \!\(\*StyleBox[\"exprh\", \"TI\"]\). "
PowerExpand::usage = "\!\(\*RowBox[{\"PowerExpand\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) expands all powers of products and powers. \n\!\(\*RowBox[{\"PowerExpand\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) expands only with respect to the variables \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
PowerModList::usage = "\!\(\*RowBox[{\"PowerModList\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", RowBox[{StyleBox[\"s\", \"TI\"], \"/\", StyleBox[\"r\", \"TI\"]}], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives a list of all \!\(\*StyleBox[\"x\", \"TI\"]\) modulo \!\(\*StyleBox[\"m\", \"TI\"]\) for which \!\(\*RowBox[{SuperscriptBox[\"x\", \"r\"], \"\[Congruent]\", SuperscriptBox[\"a\", \"s\"]}]\) mod \!\(\*StyleBox[\"m\", \"TI\"]\)."
PowerMod::usage = "\!\(\*RowBox[{\"PowerMod\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives \!\(\*RowBox[{SuperscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"b\", \"TI\"]], \" \", \"mod\", \" \", StyleBox[\"m\", \"TI\"]}]\). \n\!\(\*RowBox[{\"PowerMod\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", RowBox[{\"-\", \"1\"}], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) finds the modular inverse of \!\(\*StyleBox[\"a\", \"TI\"]\) modulo \!\(\*StyleBox[\"m\", \"TI\"]\).\n\!\(\*RowBox[{\"PowerMod\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", RowBox[{\"1\", \"/\", StyleBox[\"r\", \"TI\"]}], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) finds the smallest modular root of \!\(\*StyleBox[\"a\", \"TI\"]\)."
Power::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"^\", StyleBox[\"y\", \"TI\"]}]\) gives x to the power y. "
PowersRepresentations::usage = "\!\(\*RowBox[{\"PowersRepresentations\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives the distinct representations of the integer \!\(\*StyleBox[\"n\", \"TI\"]\) as a sum of \!\(\*StyleBox[\"k\", \"TI\"]\) non-negative \!\(\*StyleBox[\"p\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) integer powers."
PrecedenceForm::usage = "\!\(\*RowBox[{\"PrecedenceForm\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"prec\", \"TI\"]}], \"]\"}]\) prints with \!\(\*StyleBox[\"expr\", \"TI\"]\) parenthesized as it would be if it contained an operator with precedence \!\(\*StyleBox[\"prec\", \"TI\"]\). "
PrecedesEqual::usage = "\!\(\*RowBox[{\"PrecedesEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[PrecedesEqual]\", \"y\", \"\[PrecedesEqual]\", \"\[Ellipsis]\"}]\)."
Precedes::usage = "\!\(\*RowBox[{\"Precedes\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Precedes]\", \"y\", \"\[Precedes]\", \"\[Ellipsis]\"}]\)."
PrecedesSlantEqual::usage = "\!\(\*RowBox[{\"PrecedesSlantEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[PrecedesSlantEqual]\", \"y\", \"\[PrecedesSlantEqual]\", \"\[Ellipsis]\"}]\)."
PrecedesTilde::usage = "\!\(\*RowBox[{\"PrecedesTilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[PrecedesTilde]\", \"y\", \"\[PrecedesTilde]\", \"\[Ellipsis]\"}]\)."
PrecisionGoal::usage = "PrecisionGoal is an option for various numerical operations which specifies how many effective digits of precision should be sought in the final result. "
Precision::usage = "\!\(\*RowBox[{\"Precision\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives the effective number of digits of precision in the number \!\(\*StyleBox[\"x\", \"TI\"]\). "
PreDecrement::usage = "\!\(\*RowBox[{\"--\", StyleBox[\"x\", \"TI\"]}]\) decreases the value of \!\(\*StyleBox[\"x\", \"TI\"]\) by 1, returning the new value of \!\(\*StyleBox[\"x\", \"TI\"]\). "
PreferencesPath::usage = "PreferencesPath is a global option that specifies which directories are searched for user-specific settings when \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) is started."
Prefix::usage = "\!\(\*RowBox[{\"Prefix\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}], \"]\"}]\) prints with \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) given in default prefix form: \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"@\", StyleBox[\"expr\", \"TI\"]}]\). \n\!\(\*RowBox[{\"Prefix\", \"[\", RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) prints as \!\(\*StyleBox[\"hexpr\", \"TI\"]\). "
PreIncrement::usage = "\!\(\*RowBox[{\"++\", StyleBox[\"x\", \"TI\"]}]\) increases the value of \!\(\*StyleBox[\"x\", \"TI\"]\) by 1, returning the new value of \!\(\*StyleBox[\"x\", \"TI\"]\). "
Prepend::usage = "\!\(\*RowBox[{\"Prepend\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"elem\", \"TI\"]}], \"]\"}]\) gives \!\(\*StyleBox[\"expr\", \"TI\"]\) with \!\(\*StyleBox[\"elem\", \"TI\"]\) prepended. "
PrependTo::usage = "\!\(\*RowBox[{\"PrependTo\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"elem\", \"TI\"]}], \"]\"}]\) prepends \!\(\*StyleBox[\"elem\", \"TI\"]\) to the value of \!\(\*StyleBox[\"s\", \"TI\"]\), and resets \!\(\*StyleBox[\"s\", \"TI\"]\) to the result. "
PreserveImageOptions::usage = "PreserveImageOptions is an option to graphics and related functions that specifies whether image size and certain other options should be preserved from the previous version of a graphic if the graphic is replaced by a new one in output."
Prime::usage = "\!\(\*RowBox[{\"Prime\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the \!\(\*SuperscriptBox[StyleBox[\"n\", \"TI\"], \"th\"]\) prime number. "
PrimePi::usage = "\!\(\*RowBox[{\"PrimePi\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives the number of primes \!\(\*RowBox[{StyleBox[\"\[Pi]\", \"TR\"], RowBox[{\"(\", StyleBox[\"x\", \"TI\"], \")\"}]}]\) less than or equal to \!\(\*StyleBox[\"x\", \"TI\"]\). "
PrimePowerQ::usage = "\!\(\*RowBox[{\"PrimePowerQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) yields True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a power of a prime number, and yields False otherwise. "
PrimeQ::usage = "\!\(\*RowBox[{\"PrimeQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) yields True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a prime number, and yields False otherwise. "
Primes::usage = "Primes represents the domain of prime numbers, as in \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[Element]\", \"Primes\"}]\). "
PrimitiveRoot::usage = "\!\(\*RowBox[{\"PrimitiveRoot\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives a primitive root of \!\(\*StyleBox[\"n\", \"TI\"]\)."
PrincipalValue::usage = "PrincipalValue is an option for Integrate that specifies whether the Cauchy principal value should be found for a definite integral. "
PrintAction::usage = "PrintAction is an option for notebooks that specifies the action taken when a \!\(\*RowBox[{\"Print\", \"[\", \"]\"}]\) command is evaluated by the kernel."
PrintingCopies::usage = "PrintingCopies is an option for notebooks that specifies the number of copies of a notebook printed when a print command is given."
PrintingOptions::usage = "\!\(\*RowBox[{\"PrintingOptions\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option that specifies settings for printing."
PrintingPageRange::usage = "PrintingPageRange is an option for notebooks that specifies the range of pages of a notebook to be printed."
PrintingStartingPageNumber::usage = "PrintingStartingPageNumber is an option for notebooks that specifies what number to assign to the first page of a notebook when printed."
PrintingStyleEnvironment::usage = "PrintingStyleEnvironment is an option for notebooks which specifies the style environment to be used in printing the notebook on paper. "
Print::usage = "\!\(\*RowBox[{\"Print\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints \!\(\*StyleBox[\"expr\", \"TI\"]\) as output. "
PrintPrecision::usage = "PrintPrecision is an option for selections that specifies the maximum number of digits used for displaying a machine-precision number."
PrintTemporary::usage = "\!\(\*RowBox[{\"PrintTemporary\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints \!\(\*StyleBox[\"expr\", \"TI\"]\) as a temporary cell in a notebook, removing it when the evaluation of the current input line is complete."
PrivateEvaluationOptions::usage = "\!\(\*RowBox[{\"PrivateEvaluationOptions\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}]}], \"}\"}]}]\) is an option for selections that specifies settings for evaluation-related suboptions."
PrivateFontOptions::usage = "\!\(\*RowBox[{\"PrivateFontOptions\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for selections that specifies settings for various font suboptions."
PrivateNotebookOptions::usage = "\!\(\*RowBox[{\"PrivateNotebookOptions\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for notebooks that specifies various low-level notebook settings."
PrivatePaths::usage = "\!\(\*RowBox[{\"PrivatePaths\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is a global option that specifies settings for paths private to the notebook front end."
ProductLog::usage = "\!\(\*RowBox[{\"ProductLog\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the principal solution for \!\(\*StyleBox[\"w\", \"TI\"]\) in \!\(\*RowBox[{\"z\", \"=\", RowBox[{\"w\", \"\[InvisibleSpace]\", SuperscriptBox[\"e\", \"w\"]}]}]\). \n\!\(\*RowBox[{\"ProductLog\", \"[\", RowBox[{StyleBox[\"k\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) solution. "
Product::usage = "\!\(\*RowBox[{\"Product\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) evaluates the product \!\(\*RowBox[{UnderoverscriptBox[\"\[Product]\", RowBox[{StyleBox[\"i\", \"TI\"], \"=\", \"1\"}], SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], LimitsPositioning -> True], \" \", StyleBox[\"f\", \"TI\"]}]\). \n\!\(\*RowBox[{\"Product\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) starts with \!\(\*RowBox[{StyleBox[\"i\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]]}]\). \n\!\(\*RowBox[{\"Product\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"di\", \"TI\"]}], \"}\"}]}], \"]\"}]\) uses steps \!\(\*StyleBox[\"di\", \"TI\"]\). \n\!\(\*RowBox[{\"Product\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"}\"}]}], \"]\"}]\) uses successive values \!\(\*RowBox[{SubscriptBox[\"i\", \"1\"], \",\", SubscriptBox[\"i\", \"2\"], \",\", \"\[Ellipsis]\"}]\).\n\!\(\*RowBox[{\"Product\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"j\", \"TI\"], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) evaluates the multiple product \!\(\*RowBox[{UnderoverscriptBox[\"\[Product]\", RowBox[{StyleBox[\"i\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]]}], SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], LimitsPositioning -> True], RowBox[{UnderoverscriptBox[\"\[Product]\", RowBox[{StyleBox[\"j\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"min\", \"TI\"]]}], SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"max\", \"TI\"]], LimitsPositioning -> True], RowBox[{StyleBox[\"\[Ellipsis]\", \"TR\"], \" \", StyleBox[\"f\", \"TI\"]}]}]}]\). "
ProgressIndicator::usage = "\!\(\*RowBox[{\"ProgressIndicator\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) represents a progress indicator with setting \!\(\*StyleBox[\"x\", \"TI\"]\) in the range 0 to 1. \n\!\(\*RowBox[{\"ProgressIndicator\", \"[\", RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"ProgressIndicator\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) represents a progress indicator with range \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"ProgressIndicator\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", \"Indeterminate\"}], \"]\"}]\) represents a progress indicator with indeterminate range. "
Projection::usage = "\!\(\*RowBox[{\"Projection\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) finds the projection of the vector \!\(\*StyleBox[\"u\", \"TI\"]\) onto the vector \!\(\*StyleBox[\"v\", \"TI\"]\).\n\!\(\*RowBox[{\"Projection\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) finds projections with respect to the inner product function \!\(\*StyleBox[\"f\", \"TI\"]\)."
Prolog::usage = "Prolog is an option for graphics functions which gives a list of graphics primitives to be rendered before the main part of the graphics is rendered. "
PromptForm::usage = "\!\(\*RowBox[{\"PromptForm\", \"[\", RowBox[{StyleBox[\"prompt\", \"TI\"], \",\", \" \", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) prints as an output prompt and expression."
Proportional::usage = "\!\(\*RowBox[{\"Proportional\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Proportional]\", \"y\", \"\[Proportional]\", \"\[Ellipsis]\"}]\)."
Proportion::usage = "\!\(\*RowBox[{\"Proportion\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Proportion]\", \"y\", \"\[Proportion]\", \"\[Ellipsis]\"}]\)."
Protected::usage = "Protected is an attribute which prevents any values associated with a symbol from being modified. "
Protect::usage = "\!\(\*RowBox[{\"Protect\", \"[\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) sets the attribute Protected for the symbols \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Protect\", \"[\", RowBox[{SubscriptBox[StyleBox[\"form\", \"TI\"], \"1\"], \",\", SubscriptBox[StyleBox[\"form\", \"TI\"], \"2\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) protects all symbols whose names match any of the string patterns \!\(\*SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
PseudoInverse::usage = "\!\(\*RowBox[{\"PseudoInverse\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) finds the pseudoinverse of a rectangular matrix. "
Purple::usage = "Purple represents the color purple in graphics or style specifications. "
PutAppend::usage = "\!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \">>>\", StyleBox[\"filename\", \"TI\"]}]\) appends \!\(\*StyleBox[\"expr\", \"TI\"]\) to a file. \n\!\(\*RowBox[{\"PutAppend\", \"[\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"filename\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) appends a sequence of expressions \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) to a file. "
Put::usage = "\!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \">>\", StyleBox[\"filename\", \"TI\"]}]\) writes \!\(\*StyleBox[\"expr\", \"TI\"]\) to a file. \n\!\(\*RowBox[{\"Put\", \"[\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"filename\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) writes a sequence of expressions \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) to a file. \n\!\(\*RowBox[{\"Put\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"filename\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) creates an empty file with the specified name."
QRDecomposition::usage = "\!\(\*RowBox[{\"QRDecomposition\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) yields the QR decomposition for a numerical matrix \!\(\*StyleBox[\"m\", \"TI\"]\). The result is a list \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"q\", \"TI\"], \",\", StyleBox[\"r\", \"TI\"]}], \"}\"}]\), where \!\(\*StyleBox[\"q\", \"TI\"]\) is an orthogonal matrix and \!\(\*StyleBox[\"r\", \"TI\"]\) is an upper\[Hyphen]triangular matrix. "
QuadraticIrrationalQ::usage = "\!\(\*RowBox[{\"QuadraticIrrationalQ\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"x\", \"TI\"]\) is a quadratic irrational and False otherwise."
Quantile::usage = "\!\(\*RowBox[{\"Quantile\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"]}], \"]\"}]\) gives the \!\(\*SuperscriptBox[StyleBox[RowBox[{StyleBox[\"q\", \"TI\"], \"\[Null]\"}]], \"th\"]\) quantile of \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Quantile\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"q\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"q\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a list of quantiles \!\(\*SubscriptBox[StyleBox[\"q\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"q\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\) . \n\!\(\*RowBox[{\"Quantile\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"c\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"}\"}]}], \"}\"}]}], \"]\"}]\) uses the quantile definition specified by parameters \!\(\*StyleBox[\"a\", \"TI\"]\), \!\(\*StyleBox[\"b\", \"TI\"]\), \!\(\*StyleBox[\"c\", \"TI\"]\), \!\(\*StyleBox[\"d\", \"TI\"]\). \n\!\(\*RowBox[{\"Quantile\", \"[\", RowBox[{StyleBox[\"dist\", \"TI\"], \",\", StyleBox[\"q\", \"TI\"]}], \"]\"}]\) gives a quantile of the symbolic distribution \!\(\*StyleBox[\"dist\", \"TI\"]\)."
Quartics::usage = "Quartics is an option for functions that involve solving algebraic equations, that specifies whether explicit forms for solutions to quartic equations should be given."
QuartileDeviation::usage = "\!\(\*RowBox[{\"QuartileDeviation\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the quartile deviation, or semi-interquartile range of the elements in \!\(\*StyleBox[\"list\", \"TI\"]\)."
QuartileSkewness::usage = "\!\(\*RowBox[{\"QuartileSkewness\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the coefficient of quartile skewness for the elements in \!\(\*StyleBox[\"list\", \"TI\"]\)."
Quartiles::usage = "\!\(\*RowBox[{\"Quartiles\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives a list of the 1/4, 1/2, and 3/4 quantiles of the elements in \!\(\*StyleBox[\"list\", \"TI\"]\)."
Quiet::usage = "\!\(\*RowBox[{\"Quiet\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\) \"quietly\", without actually outputting any messages generated.\n\!\(\*RowBox[{\"Quiet\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"::\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"::\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) quietens only the specified messages during the evaluation of \!\(\*StyleBox[\"expr\", \"TI\"]\)."
Quit::usage = "\!\(\*RowBox[{\"Quit\", \"[\", \"]\"}]\) terminates a \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) kernel session. "
Quotient::usage = "\!\(\*RowBox[{\"Quotient\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the integer quotient of \!\(\*StyleBox[\"m\", \"TI\"]\) and \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"Quotient\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"]\"}]\) uses an offset \!\(\*StyleBox[\"d\", \"TI\"]\). "
QuotientRemainder::usage = "\!\(\*RowBox[{\"QuotientRemainder\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a list of the quotient and remainder from division of \!\(\*StyleBox[\"m\", \"TI\"]\) by \!\(\*StyleBox[\"n\", \"TI\"]\)."
RadicalBox::usage = "\!\(\*RowBox[{RadicalBox, \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) is a low-level box construct that represents the displayed object \!\(\*RadicalBox[\"x\", \"n\"]\) in notebook expressions. "
RadicalBoxOptions::usage = "\!\(\*RowBox[{RadicalBoxOptions, \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an options for selections that specifies settings for RadicalBox objects."
RadioButtonBar::usage = "\!\(\*RowBox[{\"RadioButtonBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents a radio button bar with setting \!\(\*StyleBox[\"x\", \"TI\"]\) and with labeled radio buttons for values \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\).\n\!\(\*RowBox[{\"RadioButtonBar\", \"[\", RowBox[{RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\), with the value of \!\(\*StyleBox[\"x\", \"TI\"]\) being reset every time a radio button is pressed.\n\!\(\*RowBox[{\"RadioButtonBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents a radio button bar in which the radio button giving value \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) is given label \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
RadioButton::usage = "\!\(\*RowBox[{\"RadioButton\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"val\", \"TI\"]}], \"]\"}]\) represents a radio button whose setting \!\(\*StyleBox[\"x\", \"TI\"]\) is set to \!\(\*StyleBox[\"val\", \"TI\"]\) when the button is clicked. \n\!\(\*RowBox[{\"RadioButton\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"val\", \"TI\"]}], \"]\"}]\) is displayed as \!\(\*RadioButtonBox[0, {0}]\) when \!\(\*StyleBox[\"x\", \"TI\"]\) is \!\(\*StyleBox[\"val\", \"TI\"]\), and as \!\(\*RadioButtonBox[1, {0}]\) otherwise. \n\!\(\*RowBox[{\"RadioButton\", \"[\", RowBox[{RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \",\", StyleBox[\"val\", \"TI\"]}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\), with the value of \!\(\*StyleBox[\"x\", \"TI\"]\) being reset if the button is clicked. "
RamanujanTauL::usage = "\!\(\*RowBox[{\"RamanujanTauL\", \"[\", StyleBox[\"s\", \"TI\"], \"]\"}]\) gives the Ramanujan tau Dirichlet L-function \!\(\*RowBox[{\"L\", \"(\", \"s\", \")\"}]\)."
RamanujanTau::usage = "\!\(\*RowBox[{\"RamanujanTau\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the Ramanujan \[Tau] function \!\(\*RowBox[{\"\[Tau]\", \"(\", \"n\", \")\"}]\)."
RamanujanTauTheta::usage = "\!\(\*RowBox[{\"RamanujanTauTheta\", \"[\", StyleBox[\"t\", \"TI\"], \"]\"}]\) gives the Ramanujan tau theta function \!\(\*RowBox[{\"\[Theta]\", \"(\", \"t\", \")\"}]\)."
RamanujanTauZ::usage = "\!\(\*RowBox[{\"RamanujanTauZ\", \"[\", StyleBox[\"t\", \"TI\"], \"]\"}]\) gives the Ramanujan tau Z-function \!\(\*RowBox[{\"Z\", \"(\", \"t\", \")\"}]\)."
RandomChoice::usage = "\!\(\*RowBox[{\"RandomChoice\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives a pseudorandom choice of one of the \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"RandomChoice\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a list of \!\(\*StyleBox[\"n\", \"TI\"]\) pseudorandom choices. \n\!\(\*RowBox[{\"RandomChoice\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives an \!\(\*RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"\[Cross]\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"\[Cross]\", RowBox[{\"\[Ellipsis]\", \" \"}]}]\) array of pseudorandom choices. \n\!\(\*RowBox[{\"RandomChoice\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"w\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"w\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"->\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a pseudorandom choice weighted by the \!\(\*SubscriptBox[StyleBox[\"w\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"RandomChoice\", \"[\", RowBox[{RowBox[{StyleBox[\"wlist\", \"TI\"], \"->\", StyleBox[\"elist\", \"TI\"]}], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a list of \!\(\*StyleBox[\"n\", \"TI\"]\) weighted choices.\n\!\(\*RowBox[{\"RandomChoice\", \"[\", RowBox[{RowBox[{StyleBox[\"wlist\", \"TI\"], \"->\", StyleBox[\"elist\", \"TI\"]}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives an \!\(\*RowBox[{SubscriptBox[\"n\", \"1\"], \"\[Cross]\", SubscriptBox[\"n\", \"2\"], \"\[Cross]\", \"\[Ellipsis]\"}]\) array of weighted choices."
RandomComplex::usage = "\!\(\*RowBox[{\"RandomComplex\", \"[\", \"]\"}]\) gives a pseudorandom complex number with real and imaginary parts in the range 0 to 1.\n\!\(\*RowBox[{\"RandomComplex\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \"]\"}]\) gives a pseudorandom complex number in the rectangle with corners given by the complex numbers \!\(\*SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"max\", \"TI\"]]\).\n\!\(\*RowBox[{\"RandomComplex\", \"[\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"max\", \"TI\"]], \"]\"}]\) gives a pseudorandom complex number in the rectangle whose corners are the origin and \!\(\*SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"max\", \"TI\"]]\).\n\!\(\*RowBox[{\"RandomComplex\", \"[\", RowBox[{StyleBox[\"range\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a list of n pseudorandom complex numbers.\n\!\(\*RowBox[{\"RandomComplex\", \"[\", RowBox[{StyleBox[\"range\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives an \!\(\*RowBox[{SubscriptBox[\"n\", \"1\"], \"\[Cross]\", SubscriptBox[\"n\", \"2\"], \"\[Cross]\", \"\[Ellipsis]\"}]\) array of pseudorandom complex numbers. "
RandomInteger::usage = "\!\(\*RowBox[{\"RandomInteger\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \"]\"}]\) gives a pseudorandom integer in the range \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[\"i\", \"min\"], \",\", \"\[Ellipsis]\", \",\", SubscriptBox[\"i\", \"max\"]}], \"}\"}]\). \n\!\(\*RowBox[{\"RandomInteger\", \"[\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \"]\"}]\) gives a pseudorandom integer in the range \!\(\*RowBox[{\"{\", RowBox[{\"0\", \",\", \"\[Ellipsis]\", \",\", SubscriptBox[\"i\", \"max\"]}], \"}\"}]\). \n\!\(\*RowBox[{\"RandomInteger\", \"[\", \"]\"}]\) pseudorandomly gives 0 or 1. \n\!\(\*RowBox[{\"RandomInteger\", \"[\", RowBox[{StyleBox[\"range\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a list of \!\(\*StyleBox[\"n\", \"TI\"]\) pseudorandom integers. \n\!\(\*RowBox[{\"RandomInteger\", \"[\", RowBox[{StyleBox[\"range\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives an \!\(\*RowBox[{SubscriptBox[\"n\", \"1\"], \"\[Cross]\", SubscriptBox[\"n\", \"2\"], \"\[Cross]\", \"\[Ellipsis]\", \" \"}]\) array of pseudorandom integers. \n\!\(\*RowBox[{\"RandomInteger\", \"[\", RowBox[{StyleBox[\"dist\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) samples from the symbolic discrete distribution \!\(\*StyleBox[\"dist\", \"TI\"]\)."
Random::usage = "\!\(\*RowBox[{\"Random\", \"[\", \"]\"}]\) gives a uniformly distributed pseudorandom Real in the range 0 to 1. \n\!\(\*RowBox[{\"Random\", \"[\", RowBox[{StyleBox[\"type\", \"TI\"], \",\", StyleBox[\"range\", \"TI\"]}], \"]\"}]\) gives a pseudorandom number of the specified type, lying in the specified range. Possible types are: Integer, Real and Complex. The default range is 0 to 1. You can give the range \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"min\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"]}], \"}\"}]\) explicitly; a range specification of \!\(\*StyleBox[\"max\", \"TI\"]\) is equivalent to \!\(\*RowBox[{\"{\", RowBox[{\"0\", \",\", StyleBox[\"max\", \"TI\"]}], \"}\"}]\). "
RandomPrime::usage = "\!\(\*RowBox[{\"RandomPrime\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \"]\"}]\) gives a pseudorandom prime number in the range \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]\).\n\!\(\*RowBox[{\"RandomPrime\", \"[\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \"]\"}]\) gives a pseudorandom prime number in the range 2 to \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]\).\n\!\(\*RowBox[{\"RandomPrime\", \"[\", RowBox[{StyleBox[\"range\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a list of n pseudorandom primes."
RandomReal::usage = "\!\(\*RowBox[{\"RandomReal\", \"[\", \"]\"}]\) gives a pseudorandom real number in the range 0 to 1. \n\!\(\*RowBox[{\"RandomReal\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \"]\"}]\) gives a pseudorandom real number in the range \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"RandomReal\", \"[\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \"]\"}]\) gives a pseudorandom real number in the range 0 to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"RandomReal\", \"[\", RowBox[{StyleBox[\"range\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a list of \!\(\*StyleBox[\"n\", \"TI\"]\) pseudorandom reals. \n\!\(\*RowBox[{\"RandomReal\", \"[\", RowBox[{StyleBox[\"range\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives an \!\(\*RowBox[{SubscriptBox[\"n\", \"1\"], \"\[Cross]\", SubscriptBox[\"n\", \"2\"], \"\[Cross]\", \"\[Ellipsis]\", \" \"}]\) array of pseudorandom reals. \n\!\(\*RowBox[{\"RandomReal\", \"[\", RowBox[{StyleBox[\"dist\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) samples from the symbolic continuous distribution \!\(\*StyleBox[\"dist\", \"TI\"]\)."
RandomSample::usage = "\!\(\*RowBox[{\"RandomSample\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a pseudorandom sample of n of the \!\(\*SubscriptBox[\"e\", \"i\"]\).\n\!\(\*RowBox[{\"RandomSample\", \"[\", RowBox[{RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"w\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"w\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"->\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a pseudorandom sample of n of the \!\(\*SubscriptBox[\"e\", \"i\"]\) chosen using weights \!\(\*SubscriptBox[\"w\", \"i\"]\).\n\!\(\*RowBox[{\"RandomSample\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives a pseudorandom permutation of the \!\(\*SubscriptBox[\"e\", \"i\"]\)."
Range::usage = "\!\(\*RowBox[{\"Range\", \"[\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \"]\"}]\) generates the list \!\(\*RowBox[{\"{\", RowBox[{\"1\", \",\", \"2\", \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]\). \n\!\(\*RowBox[{\"Range\", \"[\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"]\"}]\) generates the list \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]\). \n\!\(\*RowBox[{\"Range\", \"[\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"di\", \"TI\"]}], \"]\"}]\) uses step \!\(\*StyleBox[\"di\", \"TI\"]\)."
RasterArray::usage = "\!\(\*RowBox[{\"RasterArray\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) is a two\[Hyphen]dimensional graphics primitive which represents a rectangular array of cells colored according to the graphics directives \!\(\*SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[RowBox[{\"i\", \"j\"}], \"TI\"]]\). "
Rasterize::usage = "\!\(\*RowBox[{\"Rasterize\", \"[\", StyleBox[\"g\", \"TI\"], \"]\"}]\) returns a rasterized graphic of \!\(\*StyleBox[\"g\", \"TI\"]\). \n\!\(\*RowBox[{\"Rasterize\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"elem\", \"TI\"]}], \"]\"}]\) gives the element \!\(\*StyleBox[\"elem\", \"TI\"]\) associated with the rasterized form of \!\(\*StyleBox[\"g\", \"TI\"]\). "
Raster::usage = "\!\(\*RowBox[{\"Raster\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) is a two\[Hyphen]dimensional graphics primitive which represents a rectangular array of gray cells. \n\!\(\*RowBox[{\"Raster\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"11\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents an array of RGB color cells. \n\!\(\*RowBox[{\"Raster\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[\"\[Alpha]\", StyleBox[\"11\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents an array of color cells with opacity \!\(\*SubscriptBox[\"\[Alpha]\", StyleBox[\"ij\", \"TI\"]]\). \n\!\(\*RowBox[{\"Raster\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[\"\[Alpha]\", StyleBox[\"11\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents an array of gray cells with the specified opacities. "
RasterSize::usage = "RasterSize is an option for Rasterize which determines the absolute pixel size of the raster generated."
RationalFunctions::usage = "RationalFunctions represents the domain of rational functions"
Rationalize::usage = "\!\(\*RowBox[{\"Rationalize\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) converts an approximate number \!\(\*StyleBox[\"x\", \"TI\"]\) to a nearby rational with small denominator. \n\!\(\*RowBox[{\"Rationalize\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"dx\", \"TI\"]}], \"]\"}]\) yields the rational number with smallest denominator that lies within \!\(\*StyleBox[\"dx\", \"TI\"]\) of \!\(\*StyleBox[\"x\", \"TI\"]\). "
Rational::usage = "Rational is the head used for rational numbers. "
Rationals::usage = "Rationals represents the domain of rational numbers, as in \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], StyleBox[\"\[Element]\", \"TR\"], \"Rationals\"}]\). "
RawBoxes::usage = "\!\(\*RowBox[{RawBoxes, \"[\", StyleBox[\"boxes\", \"TI\"], \"]\"}]\) is a low-level construct which is formatted as \!\(\*StyleBox[\"boxes\", \"TI\"]\) without further interpretation. "
RawMedium::usage = "RawMedium is an internal symbol."
Raw::usage = "\!\(\*RowBox[{\"Raw\", \"[\", RowBox[{StyleBox[\"h\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"hexstring\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) constructs a raw data object with head \!\(\*StyleBox[\"h\", \"TI\"]\), and with contents corresponding to the binary bit pattern represented by the string \!\(\*StyleBox[\"hexstring\", \"TI\"]\), interpreted as a hexadecimal number."
RayleighDistribution::usage = "\!\(\*RowBox[{\"RayleighDistribution\", \"[\", StyleBox[\"\[Sigma]\", \"TR\"], \"]\"}]\) represents the Rayleigh distribution with scale parameter \[Sigma]."
ReadList::usage = "\!\(\*RowBox[{\"ReadList\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) reads all the remaining expressions in a file, and returns a list of them. \n\!\(\*RowBox[{\"ReadList\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"type\", \"TI\"]}], \"]\"}]\) reads objects of the specified type from a file, until the end of the file is reached. The list of objects read is returned. \n\!\(\*RowBox[{\"ReadList\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"type\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"type\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) reads objects with a sequence of types, until the end of the file is reached. \n\!\(\*RowBox[{\"ReadList\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"types\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) reads only the first \!\(\*StyleBox[\"n\", \"TI\"]\) objects of the specified types. "
Read::usage = "\!\(\*RowBox[{\"Read\", \"[\", StyleBox[\"stream\", \"TI\"], \"]\"}]\) reads one expression from an input stream, and returns the expression. \n\!\(\*RowBox[{\"Read\", \"[\", RowBox[{StyleBox[\"stream\", \"TI\"], \",\", StyleBox[\"type\", \"TI\"]}], \"]\"}]\) reads one object of the specified type. \n\!\(\*RowBox[{\"Read\", \"[\", RowBox[{StyleBox[\"stream\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"type\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"type\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) reads a sequence of objects of the specified types. "
ReadProtected::usage = "ReadProtected is an attribute which prevents values associated with a symbol from being seen. "
RealBlockForm::usage = "RealBlockForm is an option of SchurDecomposition which specifies whether complex eigenvalues of a real input matrix should be returned as 2x2 real blocks or as complex values."
RealDigits::usage = "\!\(\*RowBox[{\"RealDigits\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives a list of the digits in the approximate real number \!\(\*StyleBox[\"x\", \"TI\"]\), together with the number of digits that are to the left of the decimal point. \n\!\(\*RowBox[{\"RealDigits\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives a list of base\[Hyphen]\!\(\*StyleBox[\"b\", \"TI\"]\) digits in \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"RealDigits\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"len\", \"TI\"]}], \"]\"}]\) gives a list of \!\(\*StyleBox[\"len\", \"TI\"]\) digits. \n\!\(\*RowBox[{\"RealDigits\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"len\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives \!\(\*StyleBox[\"len\", \"TI\"]\) digits starting with the coefficient of \!\(\*SuperscriptBox[StyleBox[\"b\", \"TI\"], StyleBox[\"n\", \"TI\"]]\). "
RealExponent::usage = "\!\(\*RowBox[{\"RealExponent\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives \!\(\*RowBox[{SubscriptBox[\"log\", \"10\"], \"(\", RowBox[{\"\[LeftBracketingBar]\", \"x\", \"\[RightBracketingBar]\"}], \")\"}]\).\n\!\(\*RowBox[{\"RealExponent\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"]}], \"]\"}]\) gives \!\(\*RowBox[{SubscriptBox[\"log\", \"b\"], \"(\", RowBox[{\"\[LeftBracketingBar]\", \"x\", \"\[RightBracketingBar]\"}], \")\"}]\)."
Real::usage = "Real is the head used for real (floating\[Hyphen]point) numbers. "
Reals::usage = "Reals represents the domain of real numbers, as in \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], StyleBox[\"\[Element]\", \"TR\"], \"Reals\"}]\). "
Reap::usage = "\!\(\*RowBox[{\"Reap\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives the value of \!\(\*StyleBox[\"expr\", \"TI\"]\) together with all expressions to which Sow has been applied during its evaluation. Expressions sown using \!\(\*RowBox[{\"Sow\", \"[\", StyleBox[\"e\", \"TI\"], \"]\"}]\) or \!\(\*RowBox[{\"Sow\", \"[\", RowBox[{StyleBox[\"e\", \"TI\"], \",\", SubscriptBox[StyleBox[\"tag\", \"TI\"], StyleBox[\"i\", \"TI\"]]}], \"]\"}]\) with different tags are given in different lists. \n\!\(\*RowBox[{\"Reap\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"patt\", \"TI\"]}], \"]\"}]\) reaps only expressions sown with tags that match \!\(\*StyleBox[\"patt\", \"TI\"]\). \n\!\(\*RowBox[{\"Reap\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) puts expressions associated with each of the \!\(\*SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) in a separate list. \n\!\(\*RowBox[{\"Reap\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"patt\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) returns \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{SubscriptBox[StyleBox[\"tag\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"}\"}]\). "
RecordLists::usage = "RecordLists is an option for ReadList which specifies whether objects from separate records should be returned in separate sublists. "
Record::usage = "Record represents a record in Read, Find and related functions. "
RecordSeparators::usage = "RecordSeparators is an option for Read, Find and related functions which specifies the list of strings to be taken as delimiters for records. "
Rectangle::usage = "\!\(\*RowBox[{\"Rectangle\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) is a two\[Hyphen]dimensional graphics primitive that represents a filled rectangle, oriented parallel to the axes. \n\!\(\*RowBox[{\"Rectangle\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]]}], \"}\"}], \"]\"}]\) corresponds to a unit square. "
Red::usage = "Red represents the color red in graphics or style specifications. "
Reduce::usage = "\!\(\*RowBox[{\"Reduce\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"]}], \"]\"}]\) reduces the statement \!\(\*StyleBox[\"expr\", \"TI\"]\) by solving equations or inequalities for \!\(\*StyleBox[\"vars\", \"TI\"]\) and eliminating quantifiers. \n\!\(\*RowBox[{\"Reduce\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"], \",\", StyleBox[\"dom\", \"TI\"]}], \"]\"}]\) does the reduction over the domain \!\(\*StyleBox[\"dom\", \"TI\"]\). Common choices of \!\(\*StyleBox[\"dom\", \"TI\"]\) are Reals, Integers and Complexes. "
Refine::usage = "\!\(\*RowBox[{\"Refine\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"assum\", \"TI\"]}], \"]\"}]\) gives the form of \!\(\*StyleBox[\"expr\", \"TI\"]\) that would be obtained if symbols in it were replaced by explicit numerical expressions satisfying the assumptions \!\(\*StyleBox[\"assum\", \"TI\"]\). \n\!\(\*RowBox[{\"Refine\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) uses default assumptions specified by any enclosing Assuming constructs. "
ReflectionMatrix::usage = "\!\(\*RowBox[{\"ReflectionMatrix\", \"[\", StyleBox[\"v\", \"TI\"], \"]\"}]\) gives the matrix that represents reflection of points in a mirror normal to the vector \!\(\*StyleBox[\"v\", \"TI\"]\)."
ReflectionTransform::usage = "\!\(\*RowBox[{\"ReflectionTransform\", \"[\", StyleBox[\"v\", \"TI\"], \"]\"}]\) gives a TransformationFunction that represents a reflection in a mirror through the origin, normal to the vector \!\(\*StyleBox[\"v\", \"TI\"]\).\n\!\(\*RowBox[{\"ReflectionTransform\", \"[\", RowBox[{StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives a reflection in a mirror through the point \!\(\*StyleBox[\"p\", \"TI\"]\), normal to the vector \!\(\*StyleBox[\"v\", \"TI\"]\)."
Refresh::usage = "\!\(\*RowBox[{\"Refresh\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"opts\", \"TI\"]}], \"]\"}]\) represents an object whose value in a Dynamic should be refreshed at times specified by the options \!\(\*StyleBox[\"opts\", \"TI\"]\). \n\!\(\*RowBox[{\"Refresh\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", \"None\"}], \"]\"}]\) specifies that the value of \!\(\*StyleBox[\"expr\", \"TI\"]\) should never automatically be refreshed. "
RefreshRate::usage = "RefreshRate is an option to Animate and related functions which specifies the refresh rate for frames in animations."
RegionFunction::usage = "RegionFunction is an option for plotting functions which specifies the region to include in the plot drawn. "
RegionPlot3D::usage = "\!\(\*RowBox[{\"RegionPlot3D\", \"[\", RowBox[{StyleBox[\"pred\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"z\", \"TI\"], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) makes a plot showing the three\[Hyphen]dimensional region in which \!\(\*StyleBox[\"pred\", \"TI\"]\) is True. "
RegionPlot::usage = "\!\(\*RowBox[{\"RegionPlot\", \"[\", RowBox[{StyleBox[\"pred\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) makes a plot showing the region in which \!\(\*StyleBox[\"pred\", \"TI\"]\) is True. "
RegularExpression::usage = "\!\(\*RowBox[{\"RegularExpression\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"regex\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) represents the generalized regular expression specified by the string \"\!\(\*\nStyleBox[\"regex\", \"TI\"]\)\". "
Reinstall::usage = "\!\(\*RowBox[{\"Reinstall\", \"[\", StyleBox[\"link\", \"TI\"], \"]\"}]\) un-installs the specified external package and installs it again."
ReleaseHold::usage = "\!\(\*RowBox[{\"ReleaseHold\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) removes Hold, HoldForm, HoldPattern and HoldComplete in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
ReliefPlot::usage = "\!\(\*RowBox[{\"ReliefPlot\", \"[\", StyleBox[\"array\", \"TI\"], \"]\"}]\) generates a relief plot of an array of height values. "
Removed::usage = "\!\(\*RowBox[{\"Removed\", \"[\", StyleBox[\"string\", \"TI\"], \"]\"}]\) is printed to indicate a symbol that has been removed."
Remove::usage = "\!\(\*RowBox[{\"Remove\", \"[\", RowBox[{SubscriptBox[StyleBox[\"symbol\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) removes symbols completely, so that their names are no longer recognized by \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\). \n\!\(\*RowBox[{\"Remove\", \"[\", RowBox[{SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) removes all symbols whose names match any of the string patterns \!\(\*SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
RenameDirectory::usage = "\!\(\*RowBox[{\"RenameDirectory\", \"[\", RowBox[{SubscriptBox[StyleBox[\"dir\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"dir\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) renames the directory \!\(\*SubscriptBox[StyleBox[\"dir\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) to \!\(\*SubscriptBox[StyleBox[\"dir\", \"TI\"], StyleBox[\"2\", \"TR\"]]\). "
RenameFile::usage = "\!\(\*RowBox[{\"RenameFile\", \"[\", RowBox[{SubscriptBox[StyleBox[\"file\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"file\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}]\) renames \!\(\*SubscriptBox[StyleBox[\"file\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) to \!\(\*SubscriptBox[StyleBox[\"file\", \"TI\"], StyleBox[\"2\", \"TR\"]]\). "
Re::usage = "\!\(\*RowBox[{\"Re\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the real part of the complex number \!\(\*StyleBox[\"z\", \"TI\"]\). "
RenderAll::usage = "RenderAll is an option for Graphics3D which specifies whether or not PostScript should be generated for \!\(\*StyleBox[\"all\", \"TI\"]\) polygons. "
Repeated::usage = "\!\(\*RowBox[{StyleBox[\"p\", \"TI\"], \"..\"}]\) or \!\(\*RowBox[{\"Repeated\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) is a pattern object which represents a sequence of one or more expressions, each matching\[NonBreakingSpace]\!\(\*StyleBox[\"p\", \"TI\"]\). \n\!\(\*RowBox[{\"Repeated\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"]}], \"]\"}]\) represents up to \!\(\*StyleBox[\"max\", \"TI\"]\) expressions matching \!\(\*StyleBox[\"p\", \"TI\"]\).\n\!\(\*RowBox[{\"Repeated\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"min\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"]}], \"}\"}]}], \"]\"}]\) represents between \!\(\*StyleBox[\"min\", \"TI\"]\) and \!\(\*StyleBox[\"max\", \"TI\"]\) expressions matching \!\(\*StyleBox[\"p\", \"TI\"]\).\n\!\(\*RowBox[{\"Repeated\", \"[\", RowBox[{StyleBox[\"p\", \"TI\"], \",\", RowBox[{\"{\", StyleBox[\"n\", \"TI\"], \"}\"}]}], \"]\"}]\) represents exactly \!\(\*StyleBox[\"n\", \"TI\"]\) expressions matching \!\(\*StyleBox[\"p\", \"TI\"]\)."
RepeatedNull::usage = "\!\(\*RowBox[{StyleBox[\"p\", \"TI\"], \"...\"}]\) or \!\(\*RowBox[{\"RepeatedNull\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) is a pattern object which represents a sequence of zero or more expressions, each matching \!\(\*StyleBox[\"p\", \"TI\"]\). "
RepeatedString::usage = "RepeatedString is an internal symbol used for formatting and printing."
ReplaceAll::usage = "\!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \"/.\", StyleBox[\"rules\", \"TI\"]}]\) applies a rule or list of rules in an attempt to transform each subpart of an expression \!\(\*StyleBox[\"expr\", \"TI\"]\). "
ReplaceList::usage = "\!\(\*RowBox[{\"ReplaceList\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"rules\", \"TI\"]}], \"]\"}]\) attempts to transform the entire expression \!\(\*StyleBox[\"expr\", \"TI\"]\) by applying a rule or list of rules in all possible ways, and returns a list of the results obtained. \n\!\(\*RowBox[{\"ReplaceList\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"rules\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a list of at most \!\(\*StyleBox[\"n\", \"TI\"]\) results. "
Replace::usage = "\!\(\*RowBox[{\"Replace\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"rules\", \"TI\"]}], \"]\"}]\) applies a rule or list of rules in an attempt to transform the entire expression \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Replace\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"rules\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"]}], \"]\"}]\) applies rules to parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) specified by \!\(\*StyleBox[\"levelspec\", \"TI\"]\). "
ReplacePart::usage = "\!\(\*RowBox[{\"ReplacePart\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{StyleBox[\"i\", \"TI\"], \"->\", StyleBox[\"new\", \"TI\"]}]}], \"]\"}]\) yields an expression in which the \!\(\*StyleBox[RowBox[{StyleBox[\"i\", \"TI\"], \"\[Null]\"}]]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) part of \!\(\*StyleBox[\"expr\", \"TI\"]\) is replaced by \!\(\*StyleBox[\"new\", \"TI\"]\). \n\!\(\*RowBox[{\"ReplacePart\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"new\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"new\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) replaces parts at positions \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"n\", \"TI\"]]\) by \!\(\*SubscriptBox[StyleBox[\"new\", \"TI\"], StyleBox[\"n\", \"TI\"]]\).\n\!\(\*RowBox[{\"ReplacePart\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"->\", StyleBox[\"new\", \"TI\"]}]}], \"]\"}]\) replaces the part at position \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\).\n \!\(\*RowBox[{\"ReplacePart\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"->\", SubscriptBox[StyleBox[\"new\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) replaces parts at positions \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"n\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"n\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\) by \!\(\*SubscriptBox[StyleBox[\"new\", \"TI\"], StyleBox[\"n\", \"TI\"]]\). \n\!\(\*RowBox[{\"ReplacePart\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"->\", StyleBox[\"new\", \"TI\"]}]}], \"]\"}]\) replaces all parts at positions \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"n\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"n\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\) by \!\(\*StyleBox[\"new\", \"TI\"]\). "
ReplaceRepeated::usage = "\!\(\*RowBox[{StyleBox[\"expr\", \"TI\"], \"//.\", StyleBox[\"rules\", \"TI\"]}]\) repeatedly performs replacements until \!\(\*StyleBox[\"expr\", \"TI\"]\) no longer changes. "
Rescale::usage = "\!\(\*RowBox[{\"Rescale\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"min\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives \!\(\*StyleBox[\"x\", \"TI\"]\) rescaled to run from 0 to 1 over the range \!\(\*StyleBox[\"min\", \"TI\"]\) to \!\(\*StyleBox[\"max\", \"TI\"]\). \n\!\(\*RowBox[{\"Rescale\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"min\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives \!\(\*StyleBox[\"x\", \"TI\"]\) rescaled to run from \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) over the range \!\(\*StyleBox[\"min\", \"TI\"]\) to \!\(\*StyleBox[\"max\", \"TI\"]\). \n\!\(\*RowBox[{\"Rescale\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) rescales each element of \!\(\*StyleBox[\"list\", \"TI\"]\) to run from 0 to 1 over the range \!\(\*RowBox[{\"Min\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) to \!\(\*RowBox[{\"Max\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\). "
RescalingTransform::usage = "\!\(\*RowBox[{\"RescalingTransform\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"xp\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"xp\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a TransformationFunction that rescales the region with coordinate ranges \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\), etc. to the region with coordinate ranges \!\(\*SubscriptBox[StyleBox[\"xp\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"xp\", \"TI\"], StyleBox[\"max\", \"TI\"]]\), etc.\n\!\(\*RowBox[{\"RescalingTransform\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives a TransformationFunction that rescales to the unit square, cube, etc."
ResetDirectory::usage = "\!\(\*RowBox[{\"ResetDirectory\", \"[\", \"]\"}]\) resets the current working directory to its previous value. "
Residue::usage = "\!\(\*RowBox[{\"Residue\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"z\", \"TI\"], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) finds the residue of \!\(\*StyleBox[\"expr\", \"TI\"]\) at the point \!\(\*RowBox[{StyleBox[\"z\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"0\", \"TR\"]]}]\). "
Resolve::usage = "\!\(\*RowBox[{\"Resolve\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) attempts to resolve \!\(\*StyleBox[\"expr\", \"TI\"]\) into a form that eliminates ForAll and Exists quantifiers. \n\!\(\*RowBox[{\"Resolve\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"dom\", \"TI\"]}], \"]\"}]\) works over the domain \!\(\*StyleBox[\"dom\", \"TI\"]\). Common choices of \!\(\*StyleBox[\"dom\", \"TI\"]\) are Complexes, Reals and Booleans. "
Rest::usage = "\!\(\*RowBox[{\"Rest\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives \!\(\*StyleBox[\"expr\", \"TI\"]\) with the first element removed. "
Resultant::usage = "\!\(\*RowBox[{\"Resultant\", \"[\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"var\", \"TI\"]}], \"]\"}]\) computes the resultant of the polynomials \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) with respect to the variable \!\(\*StyleBox[\"var\", \"TI\"]\). \n\!\(\*RowBox[{\"Resultant\", \"[\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"var\", \"TI\"], \",\", RowBox[{\"Modulus\", \"->\", StyleBox[\"p\", \"TI\"]}]}], \"]\"}]\) computes the resultant modulo the prime \!\(\*StyleBox[\"p\", \"TI\"]\). "
ResumePacket::usage = "\!\(\*RowBox[{\"ResumePacket\", \"[\", \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet used for synchronization with the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) kernel."
ReturnExpressionPacket::usage = "\!\(\*RowBox[{\"ReturnExpressionPacket\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet that contains the expression \!\(\*StyleBox[\"expr\", \"TI\"]\), the result of an EnterExpressionPacket evaluation."
ReturnInputFormPacket::usage = "ReturnInputFormPacket is an internal symbol used for formatting."
Return::usage = "\!\(\*RowBox[{\"Return\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) returns the value \!\(\*StyleBox[\"expr\", \"TI\"]\) from a function. \n\!\(\*RowBox[{\"Return\", \"[\", \"]\"}]\) returns the value Null. "
ReturnPacket::usage = "\!\(\*RowBox[{\"ReturnPacket\", \"[\", \"expr\", \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet that contains the expression \!\(\*StyleBox[\"expr\", \"TI\"]\), the result of an EvaluatePacket evaluation."
ReturnTextPacket::usage = "\!\(\*RowBox[{\"ReturnTextPacket\", \"[\", StyleBox[\"string\", \"TI\"], \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet containing \!\(\*StyleBox[\"string\", \"TI\"]\), the result of an EnterTextPacket evaluation."
ReverseElement::usage = "\!\(\*RowBox[{\"ReverseElement\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[ReverseElement]\", \"y\", \"\[ReverseElement]\", \"\[Ellipsis]\"}]\)."
ReverseEquilibrium::usage = "\!\(\*RowBox[{\"ReverseEquilibrium\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[ReverseEquilibrium]\", \"y\", \"\[ReverseEquilibrium]\", \"\[Ellipsis]\"}]\)."
Reverse::usage = "\!\(\*RowBox[{\"Reverse\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) reverses the order of the elements in \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Reverse\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) reverses elements at level \!\(\*StyleBox[\"n\", \"TI\"]\) in \!\(\*StyleBox[\"expr\", \"TI\"]\).\n\!\(\*RowBox[{\"Reverse\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) reverses elements at levels \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\) in \!\(\*StyleBox[\"expr\", \"TI\"]\)."
ReverseUpEquilibrium::usage = "\!\(\*RowBox[{\"ReverseUpEquilibrium\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[ReverseUpEquilibrium]\", \"y\", \"\[ReverseUpEquilibrium]\", \"\[Ellipsis]\"}]\)."
RevolutionPlot3D::usage = "\!\(\*RowBox[{\"RevolutionPlot3D\", \"[\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"z\", \"TI\"]], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a plot of the surface of revolution with height \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"z\", \"TI\"]]\) at radius \!\(\*StyleBox[\"t\", \"TI\"]\).\n\!\(\*RowBox[{\"RevolutionPlot3D\", \"[\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"z\", \"TI\"]], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) takes the azimuthal angle \!\(\*StyleBox[\"\[Theta]\", \"TR\"]\) to vary between \!\(\*SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"min\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"max\", \"TI\"]]\).\n\!\(\*RowBox[{\"RevolutionPlot3D\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"z\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a plot of the surface obtained by rotating the parametric curve with \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}]\) coordinates \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"z\", \"TI\"]]}], \"}\"}]\) around the \!\(\*StyleBox[\"z\", \"TI\"]\) axis.\n\!\(\*RowBox[{\"RevolutionPlot3D\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"z\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"t\", \"TI\"], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) takes the azimuthal angle \!\(\*StyleBox[\"\[Theta]\", \"TR\"]\) to vary from \!\(\*SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"max\", \"TI\"]]\).\n\!\(\*RowBox[{\"RevolutionPlot3D\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"z\", \"TI\"]]}], \"}\"}], \",\", RowBox[{StyleBox[\"{\", \"TR\"], RowBox[{StyleBox[\"t\", \"TI\"], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) plots the surface obtained by rotating the parametric curve with \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}]\) coordinates \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"y\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"z\", \"TI\"]]}], \"}\"}]\)."
RGBColor::usage = "\!\(\*RowBox[{\"RGBColor\", \"[\", RowBox[{StyleBox[\"red\", \"TI\"], \",\", StyleBox[\"green\", \"TI\"], \",\", StyleBox[\"blue\", \"TI\"]}], \"]\"}]\) is a graphics directive which specifies that objects which follow are to be displayed, if possible, in the color given. \n\!\(\*RowBox[{\"RGBColor\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"b\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"]\"}]\) specifies opacity \!\(\*StyleBox[\"a\", \"TI\"]\). "
RiemannSiegelTheta::usage = "\!\(\*RowBox[{\"RiemannSiegelTheta\", \"[\", StyleBox[\"t\", \"TI\"], \"]\"}]\) gives the Riemann\[Hyphen]Siegel function \!\(\*RowBox[{\"\[CurlyTheta]\", \"(\", \"t\", \")\"}]\). "
RiemannSiegelZ::usage = "\!\(\*RowBox[{\"RiemannSiegelZ\", \"[\", StyleBox[\"t\", \"TI\"], \"]\"}]\) gives the Riemann\[Hyphen]Siegel function \!\(\*RowBox[{\"Z\", \"(\", \"t\", \")\"}]\). "
Riffle::usage = "\!\(\*RowBox[{\"Riffle\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"x\", \"TI\"]}], \"]\"}]\) gives \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\). \n\!\(\*RowBox[{\"Riffle\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\). \n\!\(\*RowBox[{\"Riffle\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) yields a list in which every \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) element is \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"Riffle\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) yields a list in which \!\(\*StyleBox[\"x\", \"TI\"]\) appears if possible at positions \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]]\), \!\(\*RowBox[{Cell[BoxData[SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]]], \"InlineFormula\"], \"+\", StyleBox[\"n\", \"TI\"]}]\), \!\(\*RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \"+\", RowBox[{\"2\", StyleBox[\"n\", \"TI\"]}]}]\), \[Ellipsis] , \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). "
RightArrowBar::usage = "\!\(\*RowBox[{\"RightArrowBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightArrowBar]\", \"y\", \"\[RightArrowBar]\", \"\[Ellipsis]\"}]\)."
RightArrowLeftArrow::usage = "\!\(\*RowBox[{\"RightArrowLeftArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightArrowLeftArrow]\", \"y\", \"\[RightArrowLeftArrow]\", \"\[Ellipsis]\"}]\)."
RightArrow::usage = "\!\(\*RowBox[{\"RightArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightArrow]\", \"y\", \"\[RightArrow]\", \"\[Ellipsis]\"}]\)."
RightDownTeeVector::usage = "\!\(\*RowBox[{\"RightDownTeeVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightDownTeeVector]\", \"y\", \"\[RightDownTeeVector]\", \"\[Ellipsis]\"}]\)."
RightDownVectorBar::usage = "\!\(\*RowBox[{\"RightDownVectorBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightDownVectorBar]\", \"y\", \"\[RightDownVectorBar]\", \"\[Ellipsis]\"}]\)."
RightDownVector::usage = "\!\(\*RowBox[{\"RightDownVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightDownVector]\", \"y\", \"\[RightDownVector]\", \"\[Ellipsis]\"}]\)."
Right::usage = "Right is a symbol that represents the right-hand side for purposes of alignment and positioning. "
RightTeeArrow::usage = "\!\(\*RowBox[{\"RightTeeArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightTeeArrow]\", \"y\", \"\[RightTeeArrow]\", \"\[Ellipsis]\"}]\)."
RightTee::usage = "\!\(\*RowBox[{\"RightTee\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightTee]\", \"y\"}]\)."
RightTeeVector::usage = "\!\(\*RowBox[{\"RightTeeVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightTeeVector]\", \"y\", \"\[RightTeeVector]\", \"\[Ellipsis]\"}]\)."
RightTriangleBar::usage = "\!\(\*RowBox[{\"RightTriangleBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightTriangleBar]\", \"y\", \"\[RightTriangleBar]\", \"\[Ellipsis]\"}]\)."
RightTriangleEqual::usage = "\!\(\*RowBox[{\"RightTriangleEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightTriangleEqual]\", \"y\", \"\[RightTriangleEqual]\", \"\[Ellipsis]\"}]\)."
RightTriangle::usage = "\!\(\*RowBox[{\"RightTriangle\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightTriangle]\", \"y\", \"\[RightTriangle]\", \"\[Ellipsis]\"}]\)."
RightUpDownVector::usage = "\!\(\*RowBox[{\"RightUpDownVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightUpDownVector]\", \"y\", \"\[RightUpDownVector]\", \"\[Ellipsis]\"}]\)."
RightUpTeeVector::usage = "\!\(\*RowBox[{\"RightUpTeeVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightUpTeeVector]\", \"y\", \"\[RightUpTeeVector]\", \"\[Ellipsis]\"}]\)."
RightUpVectorBar::usage = "\!\(\*RowBox[{\"RightUpVectorBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightUpVectorBar]\", \"y\", \"\[RightUpVectorBar]\", \"\[Ellipsis]\"}]\)."
RightUpVector::usage = "\!\(\*RowBox[{\"RightUpVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightUpVector]\", \"y\", \"\[RightUpVector]\", \"\[Ellipsis]\"}]\)."
RightVectorBar::usage = "\!\(\*RowBox[{\"RightVectorBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightVectorBar]\", \"y\", \"\[RightVectorBar]\", \"\[Ellipsis]\"}]\)."
RightVector::usage = "\!\(\*RowBox[{\"RightVector\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[RightVector]\", \"y\", \"\[RightVector]\", \"\[Ellipsis]\"}]\)."
RogersTanimotoDissimilarity::usage = "\!\(\*RowBox[{\"RogersTanimotoDissimilarity\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the Rogers\[Dash]Tanimoto dissimilarity between Boolean vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
RootApproximant::usage = "\!\(\*RowBox[{\"RootApproximant\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) converts the number \!\(\*StyleBox[\"x\", \"TI\"]\) to one of the \[OpenCurlyDoubleQuote]simplest\[CloseCurlyDoubleQuote] algebraic numbers that approximates it well.\n\!\(\*RowBox[{\"RootApproximant\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) finds an algebraic number of degree at most \!\(\*StyleBox[\"n\", \"TI\"]\) that approximates \!\(\*StyleBox[\"x\", \"TI\"]\)."
RootIntervals::usage = "\!\(\*RowBox[{\"RootIntervals\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives a list of isolating intervals for the real roots of any of the \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"i\", \"TI\"]]\), together with a list of which polynomials actually have each successive root.\n\!\(\*RowBox[{\"RootIntervals\", \"[\", StyleBox[\"poly\", \"TI\"], \"]\"}]\) gives isolating intervals for real roots of a single polynomial. \n\!\(\*RowBox[{\"RootIntervals\", \"[\", RowBox[{StyleBox[\"polys\", \"TI\"], \",\", \"Complexes\"}], \"]\"}]\) gives bounding rectangles for complex roots."
RootMeanSquare::usage = "\!\(\*RowBox[{\"RootMeanSquare\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the root mean square of values in \!\(\*StyleBox[\"list\", \"TI\"]\)."
Root::usage = "\!\(\*RowBox[{\"Root\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) represents the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) root of the polynomial equation \!\(\*RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \"==\", \"0\"}]\). \n\!\(\*RowBox[{\"Root\", \"[\", RowBox[{StyleBox[\"poly\", \"TI\"], \",\", StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) root of the polynomial \!\(\*StyleBox[\"poly\", \"TI\"]\) in \!\(\*StyleBox[\"x\", \"TI\"]\)."
RootOfUnityQ::usage = "\!\(\*RowBox[{\"RootOfUnityQ\", \"[\", StyleBox[\"a\", \"TI\"], \"]\"}]\) yields True if \!\(\*StyleBox[\"a\", \"TI\"]\) is a root of unity, and yields False otherwise."
RootReduce::usage = "\!\(\*RowBox[{\"RootReduce\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) attempts to reduce \!\(\*StyleBox[\"expr\", \"TI\"]\) to a single Root object. "
Roots::usage = "\!\(\*RowBox[{\"Roots\", \"[\", RowBox[{RowBox[{StyleBox[\"lhs\", \"TI\"], \"==\", StyleBox[\"rhs\", \"TI\"]}], \",\", StyleBox[\"var\", \"TI\"]}], \"]\"}]\) yields a disjunction of equations which represent the roots of a polynomial equation. "
RootSum::usage = "\!\(\*RowBox[{\"RootSum\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) represents the sum of \!\(\*RowBox[{StyleBox[\"form\", \"TI\"], \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) for all \!\(\*StyleBox[\"x\", \"TI\"]\) that satisfy the polynomial equation \!\(\*RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], StyleBox[\"==\", \"TR\"], StyleBox[\"0\", \"TR\"]}]\). "
RotateLabel::usage = "RotateLabel is an option for graphics and related functions which specifies whether labels on vertical frame axes should be rotated to be vertical. "
RotateLeft::usage = "\!\(\*RowBox[{\"RotateLeft\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) cycles the elements in \!\(\*StyleBox[\"expr\", \"TI\"]\) \!\(\*StyleBox[\"n\", \"TI\"]\) positions to the left. \n\!\(\*RowBox[{\"RotateLeft\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) cycles one position to the left. \n\!\(\*RowBox[{\"RotateLeft\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) cycles elements at successive levels \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) positions to the left. "
Rotate::usage = "\!\(\*RowBox[{\"Rotate\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"\[Theta]\", \"TR\"]}], \"]\"}]\) represents 2D graphics primitives \!\(\*StyleBox[\"g\", \"TI\"]\) rotated counterclockwise by \!\(\*StyleBox[\"\[Theta]\", \"TR\"]\) radians about the center of their bounding box. \n\!\(\*RowBox[{\"Rotate\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"\[Theta]\", \"TR\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}]}], \"]\"}]\) rotates 2D graphics primitives about the point \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}]\). \n\!\(\*RowBox[{\"Rotate\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"\[Theta]\", \"TR\"], \",\", StyleBox[\"w\", \"TI\"]}], \"]\"}]\) rotates 3D graphics primitives by \!\(\*StyleBox[\"\[Theta]\", \"TR\"]\) radians around the 3D vector \!\(\*StyleBox[\"w\", \"TI\"]\) anchored at the origin.\n\!\(\*RowBox[{\"Rotate\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"\[Theta]\", \"TR\"], \",\", StyleBox[\"w\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) rotates around the 3D vector \!\(\*StyleBox[\"w\", \"TI\"]\) anchored at \!\(\*StyleBox[\"p\", \"TI\"]\).\n\!\(\*RowBox[{\"Rotate\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"}\"}]}], \"]\"}]\) rotates around the origin transforming the 3D vector \!\(\*StyleBox[\"u\", \"TI\"]\) to \!\(\*StyleBox[\"v\", \"TI\"]\).\n\!\(\*RowBox[{\"Rotate\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"\[Theta]\", \"TR\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"}\"}]}], \"]\"}]\) rotates by angle \!\(\*StyleBox[\"\[Theta]\", \"TR\"]\) in the plane spanned by 3D vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
RotateRight::usage = "\!\(\*RowBox[{\"RotateRight\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) cycles the elements in \!\(\*StyleBox[\"expr\", \"TI\"]\) \!\(\*StyleBox[\"n\", \"TI\"]\) positions to the right. \n\!\(\*RowBox[{\"RotateRight\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) cycles one position to the right. \n\!\(\*RowBox[{\"RotateRight\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) cycles elements at successive levels \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) positions to the right. "
RotationAction::usage = "RotationAction is an option for three\[Hyphen]dimensional graphics functions which specifies how to render 3D objects when they are interactively rotated."
RotationMatrix::usage = "\!\(\*RowBox[{\"RotationMatrix\", \"[\", StyleBox[\"\[Theta]\", \"TR\"], \"]\"}]\) gives the 2D rotation matrix that rotates 2D vectors counterclockwise by \[Theta] radians.\n\!\(\*RowBox[{\"RotationMatrix\", \"[\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", StyleBox[\"w\", \"TI\"]}], \"]\"}]\) gives the 3D rotation matrix for a counterclockwise rotation around the 3D vector \!\(\*StyleBox[\"w\", \"TI\"]\).\n\!\(\*RowBox[{\"RotationMatrix\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the matrix that rotates the vector \!\(\*StyleBox[\"u\", \"TI\"]\) to the direction of the vector \!\(\*StyleBox[\"v\", \"TI\"]\) in any dimension.\n\!\(\*RowBox[{\"RotationMatrix\", \"[\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives the matrix that rotates by \[Theta] radians in the hyperplane spanned by \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
RotationTransform::usage = "\!\(\*RowBox[{\"RotationTransform\", \"[\", StyleBox[\"\[Theta]\", \"TR\"], \"]\"}]\) gives a TransformationFunction that represents a rotation in 2D by \[Theta] radians about the origin.\n\!\(\*RowBox[{\"RotationTransform\", \"[\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives a 2D rotation about the 2D point \!\(\*StyleBox[\"p\", \"TI\"]\).\n\!\(\*RowBox[{\"RotationTransform\", \"[\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", StyleBox[\"w\", \"TI\"]}], \"]\"}]\) gives a 3D rotation around the direction of the 3D vector \!\(\*StyleBox[\"w\", \"TI\"]\).\n\!\(\*RowBox[{\"RotationTransform\", \"[\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", StyleBox[\"w\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives a 3D rotation around the axis \!\(\*StyleBox[\"w\", \"TI\"]\) anchored at the point \!\(\*StyleBox[\"p\", \"TI\"]\).\n\!\(\*RowBox[{\"RotationTransform\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"}\"}], \"]\"}]\) gives a rotation about the origin that transforms the vector \!\(\*StyleBox[\"u\", \"TI\"]\) to the direction of the vector \!\(\*StyleBox[\"v\", \"TI\"]\).\n\!\(\*RowBox[{\"RotationTransform\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives a rotation about the point \!\(\*StyleBox[\"p\", \"TI\"]\) that transforms \!\(\*StyleBox[\"u\", \"TI\"]\) to the direction of \!\(\*StyleBox[\"v\", \"TI\"]\).\n\!\(\*RowBox[{\"RotationTransform\", \"[\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives a rotation by \[Theta] radians in the hyperplane spanned by \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
Round::usage = "\!\(\*RowBox[{\"Round\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives the integer closest to \!\(\*StyleBox[\"x\", \"TI\"]\). \n\!\(\*RowBox[{\"Round\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"]\"}]\) rounds to the nearest multiple of \!\(\*StyleBox[\"a\", \"TI\"]\). "
RowAlignments::usage = "RowAlignments is an option for the low-level function GridBox which specifies how entries in each row should be aligned. "
RowBox::usage = "\!\(\*RowBox[{RowBox, \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"box\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"box\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) is a low-level box construct that represents a row of boxes or strings in a notebook expression. "
RowLines::usage = "RowLines is an option for the low-level function GridBox which specifies whether lines should be drawn between adjacent rows. "
RowMinHeight::usage = "RowMinHeight is an option for the low-level function GridBox which specifies the minimum total height in units of font size that should be allowed for each row. "
Row::usage = "\!\(\*RowBox[{\"Row\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) is an object that formats with the \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) arranged in a row, potentially extending over several lines. \n\!\(\*RowBox[{\"Row\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) inserts \!\(\*StyleBox[\"s\", \"TI\"]\) as a separator between successive elements. "
RowReduce::usage = "\!\(\*RowBox[{\"RowReduce\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the row\[Hyphen]reduced form of the matrix \!\(\*StyleBox[\"m\", \"TI\"]\). "
RowsEqual::usage = "RowsEqual is an option for the low-level function GridBox which specifies whether all rows in the grid should be assigned equal total height. "
RowSpacings::usage = "RowSpacings is an option for the low-level function GridBox which specifies the spaces in \!\(\*StyleBox[\"x\", \"TI\"]\) heights that should be inserted between successive rows. "
RSolve::usage = "\!\(\*RowBox[{\"RSolve\", \"[\", RowBox[{StyleBox[\"eqn\", \"TI\"], \",\", RowBox[{StyleBox[\"a\", \"TI\"], \"[\", StyleBox[\"n\", \"TI\"], \"]\"}], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) solves a recurrence equation for \!\(\*RowBox[{StyleBox[\"a\", \"TI\"], \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\). \n\!\(\*RowBox[{\"RSolve\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"eqn\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"eqn\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"[\", StyleBox[\"n\", \"TI\"], \"]\"}], \",\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"[\", StyleBox[\"n\", \"TI\"], \"]\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) solves a system of recurrence equations. \n\!\(\*RowBox[{\"RSolve\", \"[\", RowBox[{StyleBox[\"eqn\", \"TI\"], \",\", RowBox[{StyleBox[\"a\", \"TI\"], \"[\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) solves a partial recurrence equation. "
RuleCondition::usage = "RuleCondition is an internal symbol."
RuleDelayed::usage = "\!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \":>\", StyleBox[\"rhs\", \"TI\"]}]\) or \!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"\[RuleDelayed]\", \"rhs\"}]\) represents a rule that transforms \!\(\*StyleBox[\"lhs\", \"TI\"]\) to \!\(\*StyleBox[\"rhs\", \"TI\"]\), evaluating \!\(\*StyleBox[\"rhs\", \"TI\"]\) only after the rule is used. "
RuleForm::usage = "RuleForm is an internal symbol used for formatting and printing."
Rule::usage = "\!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"->\", StyleBox[\"rhs\", \"TI\"]}]\) or \!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"\[Rule]\", StyleBox[\"rhs\", \"TI\"]}]\) represents a rule that transforms \!\(\*StyleBox[\"lhs\", \"TI\"]\) to \!\(\*StyleBox[\"rhs\", \"TI\"]\). "
RulerUnits::usage = "RulerUnits is an option for notebooks that specifies the units in the ruler toolbar."
Run::usage = "\!\(\*RowBox[{\"Run\", \"[\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) generates the printed form of the expressions \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\), separated by spaces, and runs it as an external operating system command. "
RunThrough::usage = "\!\(\*RowBox[{\"RunThrough\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"command\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) executes an external command, giving the printed form of \!\(\*StyleBox[\"expr\", \"TI\"]\) as input, and taking the output, reading it as \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) input, and returning the result. \n"
RussellRaoDissimilarity::usage = "\!\(\*RowBox[{\"RussellRaoDissimilarity\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the Russell\[Dash]Rao dissimilarity between Boolean vectors u and v."
SameQ::usage = "\!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"===\", StyleBox[\"rhs\", \"TI\"]}]\) yields True if the expression \!\(\*StyleBox[\"lhs\", \"TI\"]\) is identical to \!\(\*StyleBox[\"rhs\", \"TI\"]\), and yields False otherwise. "
SameTest::usage = "SameTest is an option whose setting gives a pairwise comparison function to determine whether expressions should be considered the same."
SampleDepth::usage = "SampleDepth is an option for sound primitives which specifies how many bits should be used to encode sound amplitude levels. "
SampledSoundFunction::usage = "\!\(\*RowBox[{\"SampledSoundFunction\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) is a sound primitive, which represents a sound whose amplitude sampled \!\(\*StyleBox[\"r\", \"TI\"]\) times a second is generated by applying the function \!\(\*StyleBox[\"f\", \"TI\"]\) to successive integers from 1 to \!\(\*StyleBox[\"n\", \"TI\"]\). "
SampledSoundList::usage = "\!\(\*RowBox[{\"SampledSoundList\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) is a sound primitive, which represents a sound whose amplitude has levels \!\(\*SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) sampled \!\(\*StyleBox[\"r\", \"TI\"]\) times a second. "
SampleRate::usage = "SampleRate is an option for sound primitives which specifies the number of samples per second to generate for sounds. "
Saveable::usage = "Saveable is an option for notebooks that specifies whether a notebook can be saved."
SaveAutoDelete::usage = "SaveAutoDelete is an option for ErrorBox objects that specifies whether the ErrorBox is automatically deleted when the notebook containing it is saved."
SaveDefinitions::usage = "SaveDefinitions is an option to Manipulate and related functions which specifies whether current definitions relevant for the evaluation of the expression being manipulated should automatically be saved."
Save::usage = "\!\(\*RowBox[{\"Save\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"filename\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"symbol\", \"TI\"]}], \"]\"}]\) appends definitions associated with the specified symbol to a file. \n\!\(\*RowBox[{\"Save\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"filename\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"form\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) appends definitions associated with all symbols whose names match the string pattern \!\(\*StyleBox[\"form\", \"TI\"]\). \n\!\(\*RowBox[{\"Save\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"filename\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"context\\\",\\\"TI\\\"]\\)`\\\"\", ShowStringCharacters->True]}], \"]\"}]\) appends definitions associated with all symbols in the specified context. \n\!\(\*RowBox[{\"Save\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"filename\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"object\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"object\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) appends definitions associated with several objects. "
Scaled::usage = "\!\(\*RowBox[{\"Scaled\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives the position of a graphical object in terms of coordinates scaled to run from 0 to 1 across the whole plot range in each direction. \n\!\(\*RowBox[{\"Scaled\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"dx\", \"TI\"], \",\", StyleBox[\"dy\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a position obtained by starting at ordinary coordinates \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\), then moving by a scaled offset \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"dx\", \"TI\"], \",\", StyleBox[\"dy\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\). "
Scale::usage = "\!\(\*RowBox[{\"Scale\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) represents graphics primitives \!\(\*StyleBox[\"g\", \"TI\"]\) scaled by a factor \!\(\*StyleBox[\"s\", \"TI\"]\). \n\!\(\*RowBox[{\"Scale\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) scales with the point \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\) kept fixed. \n\!\(\*RowBox[{\"Scale\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"y\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) scales by different factors along different axes. "
ScalingMatrix::usage = "\!\(\*RowBox[{\"ScalingMatrix\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"y\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives the matrix corresponding to scaling by a factor \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) along each coordinate axis.\n\!\(\*RowBox[{\"ScalingMatrix\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the matrix corresponding to scaling by a factor \!\(\*StyleBox[\"s\", \"TI\"]\) along the direction of the vector \!\(\*StyleBox[\"v\", \"TI\"]\)."
ScalingTransform::usage = "\!\(\*RowBox[{\"ScalingTransform\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"y\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) gives a TransformationFunction that represents scaling by a factor \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) along each coordinate axis from the origin.\n\!\(\*RowBox[{\"ScalingTransform\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"x\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"y\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives scaling centered at the point \!\(\*StyleBox[\"p\", \"TI\"]\).\n\!\(\*RowBox[{\"ScalingTransform\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives scaling by a factor \!\(\*StyleBox[\"s\", \"TI\"]\) along the direction of the vector \!\(\*StyleBox[\"v\", \"TI\"]\).\n\!\(\*RowBox[{\"ScalingTransform\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives scaling along the direction of \!\(\*StyleBox[\"v\", \"TI\"]\), centered at the point \!\(\*StyleBox[\"p\", \"TI\"]\)."
Scan::usage = "\!\(\*RowBox[{\"Scan\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) evaluates \!\(\*StyleBox[\"f\", \"TI\"]\) applied to each element of \!\(\*StyleBox[\"expr\", \"TI\"]\) in turn. \n\!\(\*RowBox[{\"Scan\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"levelspec\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) specified by \!\(\*StyleBox[\"levelspec\", \"TI\"]\). "
SchurDecomposition::usage = "\!\(\*RowBox[{\"SchurDecomposition\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) yields the Schur decomposition for a numerical matrix \!\(\*StyleBox[\"m\", \"TI\"]\), given as a list \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"q\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"}\"}]\) where \!\(\*StyleBox[\"q\", \"TI\"]\) is an orthonormal matrix and \!\(\*StyleBox[\"t\", \"TI\"]\) is a block upper\[Hyphen]triangular matrix. \n\!\(\*RowBox[{\"SchurDecomposition\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the generalized Schur decomposition of \!\(\*StyleBox[\"m\", \"TI\"]\) with respect to \!\(\*StyleBox[\"a\", \"TI\"]\). "
ScientificForm::usage = "\!\(\*RowBox[{\"ScientificForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints with all real numbers in \!\(\*StyleBox[\"expr\", \"TI\"]\) given in scientific notation. \n\!\(\*RowBox[{\"ScientificForm\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) prints with numbers given to \!\(\*StyleBox[\"n\", \"TI\"]\)\[Hyphen]digit precision. "
ScreenRectangle::usage = "ScreenRectangle is a global option that specifies the position of the screen by giving the coordinates of two diagonally opposite corners."
ScreenStyleEnvironment::usage = "ScreenStyleEnvironment is an option for notebooks which specifies the style environment to be used in displaying a notebook on the screen. "
ScriptBaselineShifts::usage = "ScriptBaselineShifts is an option for Style which specifies the minimum distance in x\[Hyphen]heights to shift subscripts and superscripts. "
ScriptLevel::usage = "ScriptLevel is an option for selections that is used in determining the font size of modifiers such as subscripts and superscripts in a nested expression."
ScriptMinSize::usage = "ScriptMinSize is an option for Style which specifies the minimum font size to use in rendering subscripts, etc. "
ScriptSizeMultipliers::usage = "ScriptSizeMultipliers is an option for Style which specifies how much smaller to render each successive level of subscripts, etc. "
ScrollingOptions::usage = "\!\(\*RowBox[{\"ScrollingOptions\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for notebooks that specifies settings for scrolling."
Sech::usage = "\!\(\*RowBox[{\"Sech\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the hyperbolic secant of \!\(\*StyleBox[\"z\", \"TI\"]\). "
Sec::usage = "\!\(\*RowBox[{\"Sec\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the secant of \!\(\*StyleBox[\"z\", \"TI\"]\). "
SeedRandom::usage = "\!\(\*RowBox[{\"SeedRandom\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) resets the pseudorandom generator, using \!\(\*StyleBox[\"n\", \"TI\"]\) as a seed. \n\!\(\*RowBox[{\"SeedRandom\", \"[\", \"]\"}]\) resets the generator, using as a seed the time of day and certain attributes of the current \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) session. "
Selectable::usage = "Selectable is an option for displayed objects, cells and notebooks which specifies whether their contents can be selected interactively using the front end. "
SelectedNotebook::usage = "\!\(\*RowBox[{\"SelectedNotebook\", \"[\", \"]\"}]\) gives the currently selected notebook in the front end. "
SelectionAnimate::usage = "\!\(\*RowBox[{\"SelectionAnimate\", \"[\", StyleBox[\"notebook\", \"TI\"], \"]\"}]\) animates graphics in the current selection in a notebook. \n\!\(\*RowBox[{\"SelectionAnimate\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) animates graphics for \!\(\*StyleBox[\"t\", \"TI\"]\) seconds. "
SelectionCreateCell::usage = "\!\(\*RowBox[{\"SelectionCreateCell\", \"[\", StyleBox[\"notebook\", \"TI\"], \"]\"}]\) copies the contents of the current selection in a notebook into a new cell. \n\!\(\*RowBox[{\"SelectionCreateCell\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"sel\", \"TI\"]}], \"]\"}]\) sets the current selection after the copy to be as specified by \!\(\*StyleBox[\"sel\", \"TI\"]\). "
SelectionEvaluateCreateCell::usage = "\!\(\*RowBox[{\"SelectionEvaluateCreateCell\", \"[\", StyleBox[\"notebook\", \"TI\"], \"]\"}]\) takes the current selection in a notebook and creates a new cell containing the result obtained by evaluating the contents of the selection using the kernel. \n\!\(\*RowBox[{\"SelectionEvaluateCreateCell\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"sel\", \"TI\"]}], \"]\"}]\) sets the current selection after the evaluation to be as specified by \!\(\*StyleBox[\"sel\", \"TI\"]\). "
SelectionEvaluate::usage = "\!\(\*RowBox[{\"SelectionEvaluate\", \"[\", StyleBox[\"notebook\", \"TI\"], \"]\"}]\) replaces the current selection in a notebook with the result obtained by evaluating the contents of the selection in the kernel. \n\!\(\*RowBox[{\"SelectionEvaluate\", \"[\", RowBox[{StyleBox[\"notebook\", \"TI\"], \",\", StyleBox[\"sel\", \"TI\"]}], \"]\"}]\) sets the current selection after the evaluation to be as specified by \!\(\*StyleBox[\"sel\", \"TI\"]\). "
SelectionMove::usage = "\!\(\*RowBox[{\"SelectionMove\", \"[\", RowBox[{StyleBox[\"obj\", \"TI\"], \",\", StyleBox[\"dir\", \"TI\"], \",\", StyleBox[\"unit\", \"TI\"]}], \"]\"}]\) moves the current selection in an open notebook in the front end in the direction \!\(\*StyleBox[\"dir\", \"TI\"]\) by the specified unit. \n\!\(\*RowBox[{\"SelectionMove\", \"[\", RowBox[{StyleBox[\"obj\", \"TI\"], \",\", StyleBox[\"dir\", \"TI\"], \",\", StyleBox[\"unit\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) repeats the move \!\(\*StyleBox[\"n\", \"TI\"]\) times. "
Select::usage = "\!\(\*RowBox[{\"Select\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"crit\", \"TI\"]}], \"]\"}]\) picks out all elements \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) of \!\(\*StyleBox[\"list\", \"TI\"]\) for which \!\(\*RowBox[{StyleBox[\"crit\", \"TI\"], \"[\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]], \"]\"}]\) is True. \n\!\(\*RowBox[{\"Select\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"crit\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) picks out the first \!\(\*StyleBox[\"n\", \"TI\"]\) elements for which \!\(\*RowBox[{StyleBox[\"crit\", \"TI\"], \"[\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]], \"]\"}]\) is True. "
SelfLoopStyle::usage = "SelfLoopStyle is an option for GraphPlot and related functions which specifies how to draw self-loops that connect a vertex to itself."
SemialgebraicComponentInstances::usage = "\!\(\*RowBox[{\"SemialgebraicComponentInstances\", \"[\", RowBox[{StyleBox[\"ineqs\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives at least one sample point in each connected component of the semialgebraic set defined by the inequalities \!\(\*StyleBox[\"ineqs\", \"TI\"]\) in the variables \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\)."
SequenceForm::usage = "\!\(\*RowBox[{\"SequenceForm\", \"[\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) prints as the textual concatenation of the printed forms of the \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
SequenceHold::usage = "SequenceHold is an attribute which specifies that Sequence objects appearing in the arguments of a function should not automatically be flattened out. "
SequenceLimit::usage = "\!\(\*RowBox[{\"SequenceLimit\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) returns the approximation given by Wynn's epsilon algorithm to the limit of a sequence whose first few terms are given by list. Warning: Wynn's epsilon algorithm can give finite results for divergent sequences."
Sequence::usage = "\!\(\*RowBox[{\"Sequence\", \"[\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) represents a sequence of arguments to be spliced automatically into any function. "
SeriesCoefficient::usage = "\!\(\*RowBox[{\"SeriesCoefficient\", \"[\", RowBox[{StyleBox[\"series\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) finds the coefficient of the \!\(\*StyleBox[RowBox[{StyleBox[\"n\", \"TI\"], \"\[Null]\"}]]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) order term in a power series in the form generated by Series. \n\!\(\*RowBox[{\"SeriesCoefficient\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) finds the coefficient of \!\(\*SuperscriptBox[RowBox[{\"(\", RowBox[{\"x\", \"-\", SubscriptBox[\"x\", \"0\"]}], \")\"}], \"n\"]\) in the expansion of \!\(\*StyleBox[\"f\", \"TI\"]\) about the point \!\(\*RowBox[{\"x\", \"=\", SubscriptBox[\"x\", \"0\"]}]\).\n\!\(\*RowBox[{\"SeriesCoefficient\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"x\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) finds a coefficient in a multivariate series. "
SeriesData::usage = "\!\(\*RowBox[{\"SeriesData\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"den\", \"TI\"]}], \"]\"}]\) represents a power series in the variable \!\(\*StyleBox[\"x\", \"TI\"]\) about the point \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]\). The \!\(\*SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) are the coefficients in the power series. The powers of \!\(\*RowBox[{\"(\", RowBox[{StyleBox[\"x\", \"TI\"], \"-\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \")\"}]\) that appear are \!\(\*RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"min\", \"TI\"]], \"/\", StyleBox[\"den\", \"TI\"]}]\), \!\(\*RowBox[{RowBox[{\"(\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"min\", \"TI\"]], \"+\", \"1\"}], \")\"}], \"/\", StyleBox[\"den\", \"TI\"]}]\), \[Ellipsis] , \!\(\*RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"max\", \"TI\"]], \"/\", StyleBox[\"den\", \"TI\"]}]\). "
Series::usage = "\!\(\*RowBox[{\"Series\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) generates a power series expansion for \!\(\*StyleBox[\"f\", \"TI\"]\) about the point \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}]\) to order \!\(\*SuperscriptBox[RowBox[{\"(\", RowBox[{StyleBox[\"x\", \"TI\"], \"-\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]]}], \")\"}], StyleBox[\"n\", \"TI\"]]\). \n\!\(\*RowBox[{\"Series\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"x\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"0\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"y\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) successively finds series expansions with respect to \!\(\*StyleBox[\"x\", \"TI\"]\), then \!\(\*StyleBox[\"y\", \"TI\"]\). "
SessionTime::usage = "\!\(\*RowBox[{\"SessionTime\", \"[\", \"]\"}]\) gives the total number of seconds of real time that have elapsed since the beginning of your \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) session. "
SetAccuracy::usage = "\!\(\*RowBox[{\"SetAccuracy\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"]\"}]\) yields a version of \!\(\*StyleBox[\"expr\", \"TI\"]\) in which all numbers have been set to have accuracy \!\(\*StyleBox[\"a\", \"TI\"]\). "
SetAttributes::usage = "\!\(\*RowBox[{\"SetAttributes\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"attr\", \"TI\"]}], \"]\"}]\) adds \!\(\*StyleBox[\"attr\", \"TI\"]\) to the list of attributes of the symbol \!\(\*StyleBox[\"s\", \"TI\"]\). "
SetDelayed::usage = "\!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \":=\", StyleBox[\"rhs\", \"TI\"]}]\) assigns \!\(\*StyleBox[\"rhs\", \"TI\"]\) to be the delayed value of \!\(\*StyleBox[\"lhs\", \"TI\"]\). \!\(\*StyleBox[\"rhs\", \"TI\"]\) is maintained in an unevaluated form. When \!\(\*StyleBox[\"lhs\", \"TI\"]\) appears, it is replaced by \!\(\*StyleBox[\"rhs\", \"TI\"]\), evaluated afresh each time. "
SetDirectory::usage = "\!\(\*RowBox[{\"SetDirectory\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"dir\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) sets the current working directory. "
SetFileDate::usage = "\!\(\*RowBox[{\"SetFileDate\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) sets the modification date for a file to be the current date. "
Set::usage = "\!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"=\", StyleBox[\"rhs\", \"TI\"]}]\) evaluates \!\(\*StyleBox[\"rhs\", \"TI\"]\) and assigns the result to be the value of \!\(\*StyleBox[\"lhs\", \"TI\"]\). From then on, \!\(\*StyleBox[\"lhs\", \"TI\"]\) is replaced by \!\(\*StyleBox[\"rhs\", \"TI\"]\) whenever it appears. \n\!\(\*RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"l\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"l\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"=\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) evaluates the \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"i\", \"TI\"]]\), and assigns the results to be the values of the corresponding \!\(\*SubscriptBox[StyleBox[\"l\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
SetOptions::usage = "\!\(\*RowBox[{\"SetOptions\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", RowBox[{SubscriptBox[StyleBox[\"name\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"value\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"name\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"value\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) sets the specified default options for a symbol \!\(\*StyleBox[\"s\", \"TI\"]\). \n\!\(\*RowBox[{\"SetOptions\", \"[\", RowBox[{StyleBox[\"stream\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) or \!\(\*RowBox[{\"SetOptions\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) sets options associated with a particular stream. \n\!\(\*RowBox[{\"SetOptions\", \"[\", RowBox[{StyleBox[\"object\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) sets options associated with an external object such as a NotebookObject. "
SetPrecision::usage = "\!\(\*RowBox[{\"SetPrecision\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) yields a version of \!\(\*StyleBox[\"expr\", \"TI\"]\) in which all numbers have been set to have precision \!\(\*StyleBox[\"p\", \"TI\"]\). "
SetSelectedNotebook::usage = "\!\(\*RowBox[{\"SetSelectedNotebook\", \"[\", StyleBox[\"notebook\", \"TI\"], \"]\"}]\) makes the specified notebook be the currently selected one in the front end. "
SetStreamPosition::usage = "\!\(\*RowBox[{\"SetStreamPosition\", \"[\", RowBox[{StyleBox[\"stream\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) sets the current point in an open stream. "
SetSystemOptions::usage = "\!\(\*RowBox[{\"SetSystemOptions\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"->\", StyleBox[\"value\", \"TI\"]}], \"]\"}]\) resets the value for the internal system option with the specified name."
SetterBar::usage = "\!\(\*RowBox[{\"SetterBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents a setter bar with setting \!\(\*StyleBox[\"x\", \"TI\"]\) and with setter buttons for values \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\).\n\!\(\*RowBox[{\"SetterBar\", \"[\", RowBox[{RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\), with the value of \!\(\*StyleBox[\"x\", \"TI\"]\) being reset every time a setter button is clicked.\n\!\(\*RowBox[{\"SetterBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents a setter bar in which the setter button giving value \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) has label \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
Setter::usage = "\!\(\*RowBox[{\"Setter\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"val\", \"TI\"]}], \"]\"}]\) represents a setter button whose setting \!\(\*StyleBox[\"x\", \"TI\"]\) is set to \!\(\*StyleBox[\"val\", \"TI\"]\) when the button is clicked. The button is labeled with \!\(\*StyleBox[\"val\", \"TI\"]\), and appears pressed if the value of \!\(\*StyleBox[\"x\", \"TI\"]\) is \!\(\*StyleBox[\"val\", \"TI\"]\), and unpressed otherwise.\n\!\(\*RowBox[{\"Setter\", \"[\", RowBox[{RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \",\", StyleBox[\"val\", \"TI\"]}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\), with the value of \!\(\*StyleBox[\"x\", \"TI\"]\) being reset if the button is clicked.\n\!\(\*RowBox[{\"Setter\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"val\", \"TI\"], \",\", StyleBox[\"label\", \"TI\"]}], \"]\"}]\) labels the setter button with \!\(\*StyleBox[\"label\", \"TI\"]\).\n\!\(\*RowBox[{\"Setter\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"label\", \"TI\"]}], \"]\"}]\) represents a setter button which sets \!\(\*StyleBox[\"x\", \"TI\"]\) to \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"n\", \"TI\"]]\) if multi-clicked \!\(\*StyleBox[\"n\", \"TI\"]\) times. "
Setting::usage = "\!\(\*RowBox[{\"Setting\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) replaces control objects such as sliders or popup menus in \!\(\*StyleBox[\"expr\", \"TI\"]\) by their settings. "
Shading::usage = "Shading is an option for SurfaceGraphics that specifies whether the surfaces should be shaded. "
Shallow::usage = "\!\(\*RowBox[{\"Shallow\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints as a shallow form of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Shallow\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"depth\", \"TI\"]}], \"]\"}]\) prints with all parts of \!\(\*StyleBox[\"expr\", \"TI\"]\) below the specified depth given in skeleton form. \n\!\(\*RowBox[{\"Shallow\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"depth\", \"TI\"], \",\", StyleBox[\"length\", \"TI\"]}], \"}\"}]}], \"]\"}]\) also gives parts whose lengths are above the specified limit in skeleton form. \n\!\(\*RowBox[{\"Shallow\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"depth\", \"TI\"], \",\", StyleBox[\"length\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) uses skeleton form for any parts which match the pattern \!\(\*StyleBox[\"form\", \"TI\"]\). "
Share::usage = "\!\(\*RowBox[{\"Share\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) changes the way \!\(\*StyleBox[\"expr\", \"TI\"]\) is stored internally, to try and minimize the amount of memory used. \n\!\(\*RowBox[{\"Share\", \"[\", \"]\"}]\) tries to minimize the memory used to store all expressions. "
ShearingMatrix::usage = "\!\(\*RowBox[{\"ShearingMatrix\", \"[\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the matrix corresponding to shearing by \!\(\*StyleBox[\"\[Theta]\", \"TR\"]\) radians along the direction of the vector \!\(\*StyleBox[\"v\", \"TI\"]\), and normal to the vector \!\(\*StyleBox[\"n\", \"TI\"]\). "
ShearingTransform::usage = "\!\(\*RowBox[{\"ShearingTransform\", \"[\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a TransformationFunction that represents a shear by \!\(\*StyleBox[\"\[Theta]\", \"TR\"]\) radians along the direction of the vector \!\(\*StyleBox[\"v\", \"TI\"]\), normal to the vector \!\(\*StyleBox[\"n\", \"TI\"]\), and keeping the origin fixed.\n\!\(\*RowBox[{\"ShearingTransform\", \"[\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", StyleBox[\"v\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives a shear that keeps the point \!\(\*StyleBox[\"p\", \"TI\"]\) fixed, rather than the origin."
ShortDownArrow::usage = "\!\(\*RowBox[{\"ShortDownArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[ShortDownArrow]\", \"y\", \"\[ShortDownArrow]\", \"\[Ellipsis]\"}]\)."
ShortestMatch::usage = "\!\(\*RowBox[{\"ShortestMatch\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) is a string pattern object matching the shortest sequence of characters consistent with the string pattern \!\(\*StyleBox[\"p\", \"TI\"]\)."
Shortest::usage = "\!\(\*RowBox[{\"Shortest\", \"[\", StyleBox[\"p\", \"TI\"], \"]\"}]\) is a pattern object that matches the shortest sequence consistent with the pattern \!\(\*StyleBox[\"p\", \"TI\"]\). "
ShortLeftArrow::usage = "\!\(\*RowBox[{\"ShortLeftArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[ShortLeftArrow]\", \"y\", \"\[ShortLeftArrow]\", \"\[Ellipsis]\"}]\)."
Short::usage = "\!\(\*RowBox[{\"Short\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints as a short form of \!\(\*StyleBox[\"expr\", \"TI\"]\), less than about one line long. \n\!\(\*RowBox[{\"Short\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) prints as a form of \!\(\*StyleBox[\"expr\", \"TI\"]\) about \!\(\*StyleBox[\"n\", \"TI\"]\) lines long. "
ShortRightArrow::usage = "\!\(\*RowBox[{\"ShortRightArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[ShortRightArrow]\", \"y\", \"\[ShortRightArrow]\", \"\[Ellipsis]\"}]\)."
ShortUpArrow::usage = "\!\(\*RowBox[{\"ShortUpArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[ShortUpArrow]\", \"y\", \"\[ShortUpArrow]\", \"\[Ellipsis]\"}]\)."
ShowAutoStyles::usage = "ShowAutoStyles is an option for Cell which specifies whether styles that are specified to be automatically used for various syntactic and other constructs should be shown. "
ShowCellBracket::usage = "ShowCellBracket is an option for Cell which specifies whether to display the bracket that indicates the extent of the cell. "
ShowCellLabel::usage = "ShowCellLabel is an option for Cell which specifies whether to display the label for a cell. "
ShowCellTags::usage = "ShowCellTags is an option for Cell which specifies whether to display tags for a cell. "
ShowClosedCellArea::usage = "ShowClosedCellArea is an option for cells that specifies whether a rectangular bar is displayed next to a closed cell group to indicate the number of cells in the group."
ShowContents::usage = "ShowContents is an option for selections that specifies whether an object represented by a StyleBox should be displayed on the screen or replaced by blank space."
ShowCursorTracker::usage = "ShowCursorTracker is an option for Cell which specifies whether an elliptical spot should appear momentarily to guide the eye if the cursor position jumps. "
ShowGroupOpenCloseIcon::usage = "ShowGroupOpenCloseIcon is an option for cells that specifies whether a triangular icon is displayed next to the leading cell in a cell group to indicate whether the cell group is open or closed."
ShowGroupOpener::usage = "ShowGroupOpener is an option for cells that specifies whether an opener icon is displayed next to the leading cell in a cell group to indicate whether the cell group is open or closed."
Show::usage = "\!\(\*RowBox[{\"Show\", \"[\", RowBox[{StyleBox[\"graphics\", \"TI\"], \",\", StyleBox[\"options\", \"TI\"]}], \"]\"}]\) shows graphics with the specified options added. \n\!\(\*RowBox[{\"Show\", \"[\", RowBox[{SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"g\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) shows several graphics combined. "
ShowPageBreaks::usage = "ShowPageBreaks is a notebook option which specifies whether to indicate in the on\[Hyphen]screen display of a notebook where page breaks would occur if the notebook were printed. "
ShowSelection::usage = "ShowSelection is an option to Notebook, Cell and Style which specifies whether to show the current selection highlighted. "
ShowShortBoxForm::usage = "ShowShortBoxForm is an option for cells that specifies whether box expressions, which are used to represent two-dimensional forms in a cell, are displayed in a more compact notation when the expression for that cell is viewed."
ShowSpecialCharacters::usage = "ShowSpecialCharacters is an option for Style and Cell which specifies whether to replace \[Backslash]\!\(\*RowBox[{\"[\", StyleBox[\"Name\", \"TI\"], \"]\"}]\), \[Backslash]\!\(\*RowBox[{\":\", StyleBox[\"nnnn\", \"TI\"]}]\), etc. by explicit special characters. "
ShowStringCharacters::usage = "ShowStringCharacters is an option for Cell which specifies whether to display \" when a string is entered. "
ShrinkingDelay::usage = "ShrinkingDelay is an option for dynamic objects that specifies how long to delay before shrinking the size of the region in which the object is displayed to the actual size of the object. "
SiegelTheta::usage = "\!\(\*RowBox[{\"SiegelTheta\", \"[\", RowBox[{StyleBox[\"\[CapitalOmega]\", \"TR\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives the Siegel theta function \!\(\*RowBox[{\"\[CapitalTheta]\", \"(\", RowBox[{StyleBox[\"\[CapitalOmega]\", \"TR\"], \",\", \"s\"}], \")\"}]\) with Riemann modular matrix \!\(\*StyleBox[\"\[CapitalOmega]\", \"TR\"]\) and vector \!\(\*StyleBox[\"s\", \"TI\"]\).\n\!\(\*RowBox[{\"SiegelTheta\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"\[Nu]\", \"TR\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"\[Nu]\", \"TR\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[CapitalOmega]\", \"TR\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives the Siegel theta function \!\(\*RowBox[{RowBox[{\"\[CapitalTheta]\", \"[\", RowBox[{SubscriptBox[\"\[Nu]\", \"1\"], \",\", SubscriptBox[\"\[Nu]\", \"2\"]}], \"]\"}], RowBox[{\"(\", \" \", RowBox[{StyleBox[\"\[CapitalOmega]\", \"TR\"], \",\", \"s\"}], \")\"}]}]\) with characteristics \!\(\*SubscriptBox[\"\[Nu]\", \"1\"]\) and \!\(\*SubscriptBox[\"\[Nu]\", \"2\"]\)."
Signature::usage = "\!\(\*RowBox[{\"Signature\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the signature of the permutation needed to place the elements of \!\(\*StyleBox[\"list\", \"TI\"]\) in canonical order. "
Sign::usage = "\!\(\*RowBox[{\"Sign\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives \!\(\*RowBox[{\"-\", \"1\"}]\), 0 or 1 depending on whether \!\(\*StyleBox[\"x\", \"TI\"]\) is negative, zero, or positive. "
SignPadding::usage = "SignPadding is an option for NumberForm and related functions which specifies whether padding should be inserted after signs. "
Simplify::usage = "\!\(\*RowBox[{\"Simplify\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) performs a sequence of algebraic and other transformations on \!\(\*StyleBox[\"expr\", \"TI\"]\), and returns the simplest form it finds. \n\!\(\*RowBox[{\"Simplify\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"assum\", \"TI\"]}], \"]\"}]\) does simplification using assumptions. "
Sinc::usage = "\!\(\*RowBox[{\"Sinc\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives \!\(\*RowBox[{\"sinc\", \"(\", \"z\", \")\"}]\). "
SingleLetterItalics::usage = "SingleLetterItalics is an option for Cell which specifies whether single\[Hyphen]letter names should be displayed in italics. "
SingularityDepth::usage = "SingularityDepth is an option for NIntegrate. \!\(\*RowBox[{\"SingularityDepth\", \" \", \"->\", \" \", StyleBox[\"n\", \"TI\"]}]\) specifies that \!\(\*StyleBox[\"n\", \"TI\"]\) recursive subdivisions can be done before a change of variable is used at the endpoints of the interval of integration."
SingularValueDecomposition::usage = "\!\(\*RowBox[{\"SingularValueDecomposition\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives the singular value decomposition for a numerical matrix \!\(\*StyleBox[\"m\", \"TI\"]\), as a list of matrices \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"w\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"}\"}]\), where \!\(\*StyleBox[\"w\", \"TI\"]\) is a diagonal matrix, and \!\(\*StyleBox[\"m\", \"TI\"]\) can be written as \!\(\*RowBox[{StyleBox[\"u\", \"TI\"], \".\", StyleBox[\"w\", \"TI\"], \".\", RowBox[{\"Conjugate\", \"[\", RowBox[{\"Transpose\", \"[\", StyleBox[\"v\", \"TI\"], \"]\"}], \"]\"}]}]\). \n\!\(\*RowBox[{\"SingularValueDecomposition\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the generalized singular value decomposition of \!\(\*StyleBox[\"m\", \"TI\"]\) with respect to \!\(\*StyleBox[\"a\", \"TI\"]\). \n\!\(\*RowBox[{\"SingularValueDecomposition\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the singular value decomposition associated with the \!\(\*StyleBox[\"k\", \"TI\"]\) largest singular values of \!\(\*StyleBox[\"m\", \"TI\"]\). \n\!\(\*RowBox[{\"SingularValueDecomposition\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the generalized singular value decomposition associated with the \!\(\*StyleBox[\"k\", \"TI\"]\) largest singular values."
SingularValueList::usage = "\!\(\*RowBox[{\"SingularValueList\", \"[\", StyleBox[\"m\", \"TI\"], \"]\"}]\) gives a list of the nonzero singular values of a matrix \!\(\*StyleBox[\"m\", \"TI\"]\). \n\!\(\*RowBox[{\"SingularValueList\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}], \"]\"}]\) gives the generalized singular values of \!\(\*StyleBox[\"m\", \"TI\"]\) with respect to \!\(\*StyleBox[\"a\", \"TI\"]\). \n\!\(\*RowBox[{\"SingularValueList\", \"[\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[\"k\", \"TI\"]\) largest singular values of \!\(\*StyleBox[\"m\", \"TI\"]\). \n\!\(\*RowBox[{\"SingularValueList\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"a\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[\"k\", \"TI\"]\) largest generalized singular values of \!\(\*StyleBox[\"m\", \"TI\"]\)."
SingularValues::usage = "\!\(\*RowBox[{\"SingularValues\", \"[\", \"m\", \"]\"}]\) gives the singular value decomposition for a numerical matrix m\!\(\*StyleBox[\".\", \"TI\", FontSlant -> \"Plain\"]\) The result is a list \!\(\*RowBox[{\"{\", RowBox[{\"u\", \",\", \"w\", \",\", \"v\"}], \"}\"}]\), where w is the list of singular values, and m can be written as \!\(\*StyleBox[\"Conjugate[Transpose[\", \"MR\"]\)\!\(\*StyleBox[\"u\", \"TI\"]\)\!\(\*StyleBox[\"]]. DiagonalMatrix[\", \"MR\"]\)\!\(\*StyleBox[\"w\", \"TI\"]\)\!\(\*StyleBox[\"].\", \"MR\"]\)\!\(\*StyleBox[\"v\", \"TI\"]\)"
SinhIntegral::usage = "\!\(\*RowBox[{\"SinhIntegral\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the hyperbolic sine integral function \!\(\*RowBox[{\"Shi\", \"(\", \"z\", \")\"}]\). "
Sinh::usage = "\!\(\*RowBox[{\"Sinh\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the hyperbolic sine of \!\(\*StyleBox[\"z\", \"TI\"]\). "
SinIntegral::usage = "\!\(\*RowBox[{\"SinIntegral\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the sine integral function \!\(\*RowBox[{\"Si\", \"(\", \"z\"}]\)). "
Sin::usage = "\!\(\*RowBox[{\"Sin\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the sine of \!\(\*StyleBox[\"z\", \"TI\"]\). "
SixJSymbol::usage = "\!\(\*RowBox[{\"SixJSymbol\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"3\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"4\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"5\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"6\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) gives the values of the Racah 6\[Hyphen]j symbol. "
Skeleton::usage = "\!\(\*RowBox[{\"Skeleton\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) represents a sequence of \!\(\*StyleBox[\"n\", \"TI\"]\) omitted elements in an expression printed with Short or Shallow. The standard print form for Skeleton is \!\(\*RowBox[{\"\[LeftSkeleton]\", StyleBox[\"n\", \"TI\"], \"\[RightSkeleton]\"}]\). "
Skewness::usage = "\!\(\*RowBox[{\"Skewness\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the coefficient of skewness for the elements in \!\(\*StyleBox[\"list\", \"TI\"]\).\n\!\(\*RowBox[{\"Skewness\", \"[\", StyleBox[\"dist\", \"TI\"], \"]\"}]\) gives the coefficient of skewness for the symbolic distribution \!\(\*StyleBox[\"dist\", \"TI\"]\)."
Skip::usage = "\!\(\*RowBox[{\"Skip\", \"[\", RowBox[{StyleBox[\"stream\", \"TI\"], \",\", StyleBox[\"type\", \"TI\"]}], \"]\"}]\) skips one object of the specified type in an input stream. \n\!\(\*RowBox[{\"Skip\", \"[\", RowBox[{StyleBox[\"stream\", \"TI\"], \",\", StyleBox[\"type\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) skips \!\(\*StyleBox[\"n\", \"TI\"]\) objects of the specified type. "
Slider2D::usage = "\!\(\*RowBox[{\"Slider2D\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"}\"}], \"]\"}]\) represents a 2D slider with settings \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\) in the range 0 to 1. \n\!\(\*RowBox[{\"Slider2D\", \"[\", RowBox[{\"Dynamic\", \"[\", StyleBox[\"pt\", \"TI\"], \"]\"}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"pt\", \"TI\"]\), with the value of \!\(\*StyleBox[\"pt\", \"TI\"]\) being reset if the slider is moved. \n\!\(\*RowBox[{\"Slider2D\", \"[\", RowBox[{StyleBox[\"pt\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"min\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"]}], \"}\"}]}], \"]\"}]\) represents a 2D slider with range \!\(\*StyleBox[\"min\", \"TI\"]\) to \!\(\*StyleBox[\"max\", \"TI\"]\) in each direction. \n\!\(\*RowBox[{\"Slider2D\", \"[\", RowBox[{StyleBox[\"pt\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"min\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"]}], \"}\"}]}], \"]\"}]\) represents a 2D slider that jumps in steps \!\(\*StyleBox[\"d\", \"TI\"]\) in each direction. \n\!\(\*RowBox[{\"Slider2D\", \"[\", RowBox[{StyleBox[\"pt\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"}\"}]}], \"]\"}]\) specifies different ranges in \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\) directions. \n\!\(\*RowBox[{\"Slider2D\", \"[\", RowBox[{StyleBox[\"pt\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"min\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"dx\", \"TI\"], \",\", StyleBox[\"dy\", \"TI\"]}], \"}\"}]}], \"}\"}]}], \"]\"}]\) uses jumps \!\(\*StyleBox[\"dx\", \"TI\"]\), \!\(\*StyleBox[\"dy\", \"TI\"]\)."
Slider::usage = "\!\(\*RowBox[{\"Slider\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) represents a slider with setting \!\(\*StyleBox[\"x\", \"TI\"]\) in the range 0 to 1. \n\!\(\*RowBox[{\"Slider\", \"[\", RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\), with the value of \!\(\*StyleBox[\"x\", \"TI\"]\) being reset if the slider is moved. \n\!\(\*RowBox[{\"Slider\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) represents a slider with range \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"Slider\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"dx\", \"TI\"]}], \"}\"}]}], \"]\"}]\) represents a slider that jumps in steps \!\(\*StyleBox[\"dx\", \"TI\"]\). \n\!\(\*RowBox[{\"Slider\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"}\"}]}], \"]\"}]\) represents a slider in which equally spaced intervals correspond to successive settings \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Slider\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"w\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"w\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"}\"}]}], \"]\"}]\) uses intervals of relative widths \!\(\*SubscriptBox[StyleBox[\"w\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) for the \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
SlideView::usage = "\!\(\*RowBox[{\"SlideView\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents an object in which the \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) are set up to be displayed on successive slides. \n\!\(\*RowBox[{\"SlideView\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"i\", \"TI\"]}], \"]\"}]\) makes the i\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) slide be the one currently displayed."
Slot::usage = "# represents the first argument supplied to a pure function. \n\!\(\*RowBox[{\"#\", StyleBox[\"n\", \"TI\"]}]\) represents the \!\(\*SuperscriptBox[StyleBox[RowBox[{StyleBox[\"n\", \"TI\"], \"\[Null]\"}]], \"th\"]\) argument. "
SlotSequence::usage = "## represents the sequence of arguments supplied to a pure function. \n\!\(\*RowBox[{\"##\", StyleBox[\"n\", \"TI\"]}]\) represents the sequence of arguments supplied to a pure function, starting with the \!\(\*SuperscriptBox[StyleBox[RowBox[{StyleBox[\"n\", \"TI\"], \"\[Null]\"}]], \"th\"]\) argument. "
SmallCircle::usage = "\!\(\*RowBox[{\"SmallCircle\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[SmallCircle]\", \"y\", \"\[SmallCircle]\", \"\[Ellipsis]\"}]\)."
Smaller::usage = "Smaller is a style or option setting that specifies that objects should be smaller."
Small::usage = "Small is a style or option setting that specifies that objects should be small."
Socket::usage = "Socket is a possible value returned by FileType and related functions."
SokalSneathDissimilarity::usage = "\!\(\*RowBox[{\"SokalSneathDissimilarity\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the Sokal\[Dash]Sneath dissimilarity between Boolean vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
SolveAlways::usage = "\!\(\*RowBox[{\"SolveAlways\", \"[\", RowBox[{StyleBox[\"eqns\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"]}], \"]\"}]\) gives the values of parameters that make the equations \!\(\*StyleBox[\"eqns\", \"TI\"]\) valid for all values of the variables \!\(\*StyleBox[\"vars\", \"TI\"]\). "
SolveDelayed::usage = "SolveDelayed is an option to NDSolve. \!\(\*RowBox[{\"SolveDelayed\", \" \", \"->\", \" \", \"False\"}]\) causes the derivatives to be solved for symbolically at the beginning. \!\(\*RowBox[{\"SolveDelayed\", \" \", \"->\", \" \", \"True\"}]\) causes the ODEs to be evaluated numerically and the derivatives solved for at each step."
Solve::usage = "\!\(\*RowBox[{\"Solve\", \"[\", RowBox[{StyleBox[\"eqns\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"]}], \"]\"}]\) attempts to solve an equation or set of equations for the variables \!\(\*StyleBox[\"vars\", \"TI\"]\). \n\!\(\*RowBox[{\"Solve\", \"[\", RowBox[{StyleBox[\"eqns\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"], \",\", StyleBox[\"elims\", \"TI\"]}], \"]\"}]\) attempts to solve the equations for \!\(\*StyleBox[\"vars\", \"TI\"]\), eliminating the variables \!\(\*StyleBox[\"elims\", \"TI\"]\). "
SortBy::usage = "\!\(\*RowBox[{\"SortBy\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) sorts the elements of \!\(\*StyleBox[\"list\", \"TI\"]\) in the order defined by applying \!\(\*StyleBox[\"f\", \"TI\"]\) to each of them. "
Sort::usage = "\!\(\*RowBox[{\"Sort\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) sorts the elements of \!\(\*StyleBox[\"list\", \"TI\"]\) into canonical order. \n\!\(\*RowBox[{\"Sort\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) sorts using the ordering function \!\(\*StyleBox[\"p\", \"TI\"]\). "
Sound::usage = "\!\(\*RowBox[{\"Sound\", \"[\", StyleBox[\"primitives\", \"TI\"], \"]\"}]\) represents a sound. \n\!\(\*RowBox[{\"Sound\", \"[\", RowBox[{StyleBox[\"primitives\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) specifies that the sound should have duration \!\(\*StyleBox[\"t\", \"TI\"]\).\n\!\(\*RowBox[{\"Sound\", \"[\", RowBox[{StyleBox[\"primitives\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) specifies that the sound should extend from time \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to time \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]\)."
SoundNote::usage = "\!\(\*RowBox[{\"SoundNote\", \"[\", StyleBox[\"pitch\", \"TI\"], \"]\"}]\) represents a music-like sound note with the specified pitch.\n\!\(\*RowBox[{\"SoundNote\", \"[\", RowBox[{StyleBox[\"pitch\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) takes the note to have duration \!\(\*StyleBox[\"t\", \"TI\"]\).\n\!\(\*RowBox[{\"SoundNote\", \"[\", RowBox[{StyleBox[\"pitch\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) takes the note to occupy the time interval \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"t\", \"TI\"], StyleBox[\"max\", \"TI\"]]\).\n\!\(\*RowBox[{\"SoundNote\", \"[\", RowBox[{StyleBox[\"pitch\", \"TI\"], \",\", StyleBox[\"tspec\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"style\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) takes the note to be in the specified style.\n\!\(\*RowBox[{\"SoundNote\", \"[\", RowBox[{StyleBox[\"pitch\", \"TI\"], \",\", StyleBox[\"tspec\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"style\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"opts\", \"TI\"]}], \"]\"}]\) uses the specified rendering options for the note."
SoundVolume::usage = "SoundVolume is an option to Sound and SoundNote and related functions that specifies the relative volume of the sound produced."
Sow::usage = "\!\(\*RowBox[{\"Sow\", \"[\", StyleBox[\"e\", \"TI\"], \"]\"}]\) specifies that \!\(\*StyleBox[\"e\", \"TI\"]\) should be collected by the nearest enclosing Reap. \n\!\(\*RowBox[{\"Sow\", \"[\", RowBox[{StyleBox[\"e\", \"TI\"], \",\", StyleBox[\"tag\", \"TI\"]}], \"]\"}]\) specifies that \!\(\*StyleBox[\"e\", \"TI\"]\) should be collected by the nearest enclosing Reap whose pattern matches \!\(\*StyleBox[\"tag\", \"TI\"]\). \n\!\(\*RowBox[{\"Sow\", \"[\", RowBox[{StyleBox[\"e\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"tag\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"tag\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) specifies that \!\(\*StyleBox[\"e\", \"TI\"]\) should be collected once for each pattern that matches a \!\(\*SubscriptBox[StyleBox[\"tag\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
SpaceForm::usage = "\!\(\*RowBox[{\"SpaceForm\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) prints as \!\(\*StyleBox[\"n\", \"TI\"]\) spaces."
Spacer::usage = "\!\(\*RowBox[{\"Spacer\", \"[\", StyleBox[\"w\", \"TI\"], \"]\"}]\) displays as a spacer \!\(\*StyleBox[\"w\", \"TI\"]\) printer's points wide.\n\!\(\*RowBox[{\"Spacer\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"w\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"}\"}], \"]\"}]\) displays as a spacer \!\(\*StyleBox[\"w\", \"TI\"]\) points wide and a total of \!\(\*StyleBox[\"h\", \"TI\"]\) points high.\n\!\(\*RowBox[{\"Spacer\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"w\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"], \",\", StyleBox[\"dh\", \"TI\"]}], \"}\"}], \"]\"}]\) makes the spacer extend \!\(\*StyleBox[\"dh\", \"TI\"]\) points below the baseline. "
Spacings::usage = "Spacings is an option to Grid and related constructs which specifies the spacings to leave between successive objects."
SpanAdjustments::usage = "SpanAdjustments is an option for selections that specifies the height and width of spanning characters."
SpanCharacterRounding::usage = "SpanCharacterRounding is an option for selections that specifies the method used for rounding a spanning character when its size is to be adjusted."
SpanFromAbove::usage = "SpanFromAbove is a symbol that can appear at a particular position in a Grid or related construct to indicate that the corresponding position is occupied by a spanning element that appears above it."
SpanFromBoth::usage = "SpanFromBoth is a symbol that can appear at a particular position in a Grid or related construct to indicate that the corresponding position is occupied by a spanning element that appears above and to its left."
SpanFromLeft::usage = "SpanFromLeft is a symbol that can appear at a particular position in a Grid or related construct to indicate that the corresponding position is occupied by a spanning element that appears to its left."
SpanLineThickness::usage = "SpanLineThickness is an option for selections that specifies the thickness in printer's points of line-spanning characters such as \!\(\*StyleBox[\"\[Backslash][VerticalLine]\", \"MR\"]\) and \!\(\*StyleBox[\"\[Backslash][HorizontalLine]\", \"MR\"]\)."
SpanMaxSize::usage = "SpanMaxSize is an option for selections that specifies the maximum size of spanning characters such as parentheses and brackets."
SpanMinSize::usage = "SpanMinSize is an option for selections that specifies the minimum size of spanning characters such as parentheses and brackets."
Span::usage = "\!\(\*RowBox[{StyleBox[\"i\", \"TI\"], \";;\", StyleBox[\"j\", \"TI\"]}]\) represents a span of elements \!\(\*StyleBox[\"i\", \"TI\"]\) through \!\(\*StyleBox[\"j\", \"TI\"]\).\n\!\(\*RowBox[{StyleBox[\"i\", \"TI\"], \";;\"}]\) a span from \!\(\*StyleBox[\"i\", \"TI\"]\) to the end.\n\!\(\*RowBox[{\";;\", StyleBox[\"j\", \"TI\"]}]\) a span from the beginning to \!\(\*StyleBox[\"j\", \"TI\"]\).\n;; a span that includes all elements.\n\!\(\*RowBox[{StyleBox[\"i\", \"TI\"], \";;\", StyleBox[\"j\", \"TI\"], \";;\", StyleBox[\"k\", \"TI\"]}]\) a span from \!\(\*StyleBox[\"i\", \"TI\"]\) through \!\(\*StyleBox[\"j\", \"TI\"]\) in steps of \!\(\*StyleBox[\"k\", \"TI\"]\).\n\!\(\*RowBox[{StyleBox[\"i\", \"TI\"], \";;\", \";;\", StyleBox[\"k\", \"TI\"]}]\) from \!\(\*StyleBox[\"i\", \"TI\"]\) to the end in steps of \!\(\*StyleBox[\"k\", \"TI\"]\).\n\!\(\*RowBox[{\";;\", StyleBox[\"j\", \"TI\"], \";;\", StyleBox[\"k\", \"TI\"]}]\) from the beginning to \!\(\*StyleBox[\"j\", \"TI\"]\) in steps of \!\(\*StyleBox[\"k\", \"TI\"]\).\n\!\(\*RowBox[{\";;\", \";;\", StyleBox[\"k\", \"TI\"]}]\) from the beginning to the end in steps of \!\(\*StyleBox[\"k\", \"TI\"]\). "
SpanSymmetric::usage = "SpanSymmetric is an option for selections that specifies whether vertically expandable characters are symmetric about the axis of the selection."
SparseArray::usage = "\!\(\*RowBox[{\"SparseArray\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) yields a sparse array in which values \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) appear at positions \!\(\*SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"SparseArray\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"->\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) yields the same sparse array. \n\!\(\*RowBox[{\"SparseArray\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) yields a sparse array version of \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"SparseArray\", \"[\", RowBox[{StyleBox[\"data\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) yields a sparse array representing a \!\(\*RowBox[{SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"\[Cross]\", SubscriptBox[StyleBox[\"d\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"\[Cross]\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\) array. \n\!\(\*RowBox[{\"SparseArray\", \"[\", RowBox[{StyleBox[\"data\", \"TI\"], \",\", StyleBox[\"dims\", \"TI\"], \",\", StyleBox[\"val\", \"TI\"]}], \"]\"}]\) yields a sparse array in which unspecified elements are taken to have value \!\(\*StyleBox[\"val\", \"TI\"]\). "
Specularity::usage = "\!\(\*RowBox[{\"Specularity\", \"[\", StyleBox[\"s\", \"TI\"], \"]\"}]\) is a graphics directive which specifies that surfaces of 3D graphics objects which follow are to be taken to have specularity \!\(\*StyleBox[\"s\", \"TI\"]\). \n\!\(\*RowBox[{\"Specularity\", \"[\", RowBox[{StyleBox[\"s\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) uses specular exponent \!\(\*StyleBox[\"n\", \"TI\"]\). "
SpellingCorrection::usage = "SpellingCorrection is an option for StringMatchQ, Names and related functions which specifies whether strings should be considered to match even when a small fraction of the characters in them are different. "
SpellingDictionaries::usage = "\!\(\*RowBox[{\"SpellingDictionaries\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is a global option that specifies settings for spellchecking."
SpellingDictionariesPath::usage = "SpellingDictionariesPath is a global option that specifies which directories are searched for spelling dictionaries when the \!\(\*StyleBox[\"Edit\", \"MenuName\"]\)\!\(\*StyleBox[\" \[FilledRightTriangle] \", \"MenuNameDelimiter\"]\)\!\(\*StyleBox[\"Check Spelling\", \"MenuName\"]\) menu item is used."
SpellingOptions::usage = "\!\(\*RowBox[{\"SpellingOptions\", \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for notebooks that specifies settings for spell checking."
Sphere::usage = "\!\(\*RowBox[{\"Sphere\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"}\"}], \",\", StyleBox[\"r\", \"TI\"]}], \"]\"}]\) represents a sphere of radius \!\(\*StyleBox[\"r\", \"TI\"]\) centered at \!\(\*RowBox[{\"(\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \")\"}]\). \n\!\(\*RowBox[{\"Sphere\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"}\"}], \"]\"}]\) represents a sphere of radius 1. "
SphericalBesselJ::usage = "\!\(\*RowBox[{\"SphericalBesselJ\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the spherical Bessel function of the first kind \!\(\*RowBox[{SubscriptBox[\"j\", \"n\"], \"(\", \"z\", \")\"}]\). "
SphericalBesselY::usage = "\!\(\*RowBox[{\"SphericalBesselY\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the spherical Bessel function of the second kind \!\(\*RowBox[{SubscriptBox[\"y\", \"n\"], \"(\", \"z\", \")\"}]\). "
SphericalHankelH1::usage = "\!\(\*RowBox[{\"SphericalHankelH1\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the spherical Hankel function of the first kind \!\(\*RowBox[{SubsuperscriptBox[\"h\", \"n\", RowBox[{\"(\", \"1\", \")\"}]], \"(\", \"z\", \")\"}]\). "
SphericalHankelH2::usage = "\!\(\*RowBox[{\"SphericalHankelH2\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the spherical Hankel function of the second kind \!\(\*RowBox[{SubsuperscriptBox[\"h\", \"n\", RowBox[{\"(\", \"2\", \")\"}]], \"(\", \"z\", \")\"}]\). "
SphericalHarmonicY::usage = "\!\(\*RowBox[{\"SphericalHarmonicY\", \"[\", RowBox[{StyleBox[\"l\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"\[Theta]\", \"TR\"], \",\", StyleBox[\"\[Phi]\", \"TR\"]}], \"]\"}]\) gives the spherical harmonic \!\(\*RowBox[{SubsuperscriptBox[\"Y\", \"l\", \"m\"], \"(\", RowBox[{\"\[Theta]\", \",\", \"\[Phi]\"}], \")\"}]\). "
SphericalPlot3D::usage = "\!\(\*RowBox[{\"SphericalPlot3D\", \"[\", RowBox[{StyleBox[\"r\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"\[Phi]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"\[Phi]\", \"TR\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"\[Phi]\", \"TR\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a 3D plot with a spherical radius r as a function of spherical coordinates \[Theta] and \[Phi]. \n\!\(\*RowBox[{\"SphericalPlot3D\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"\[Theta]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"\[Theta]\", \"TR\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"\[Phi]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"\[Phi]\", \"TR\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"\[Phi]\", \"TR\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a 3D spherical plot with multiple surfaces."
SphericalRegion::usage = "SphericalRegion is an option for three\[Hyphen]dimensional graphics functions which specifies whether the final image should be scaled so that a sphere drawn around the three\[Hyphen]dimensional bounding box would fit in the display area specified. "
SpheroidalEigenvalue::usage = "\!\(\*RowBox[{\"SpheroidalEigenvalue\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"\[Gamma]\", \"TR\"]}], \"]\"}]\) gives the spheroidal eigenvalue with degree n and order m."
SpheroidalJoiningFactor::usage = "\!\(\*RowBox[{\"SpheroidalJoiningFactor\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"\[Gamma]\", \"TR\"]}], \"]\"}]\) gives the spheroidal joining factor with degree n and order m."
SpheroidalPS::usage = "\!\(\*RowBox[{\"SpheroidalPS\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"\[Gamma]\", \"TR\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the angular spheroidal function \!\(\*RowBox[{SubscriptBox[StyleBox[\"PS\", FontSlant -> \"Italic\"], RowBox[{\"n\", \",\", \"m\"}]], \"(\", RowBox[{\"\[Gamma]\", \",\", \"z\"}], \")\"}]\) of the first kind."
SpheroidalPSPrime::usage = "\!\(\*RowBox[{\"SpheroidalPSPrime\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"\[Gamma]\", \"TR\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the derivative with respect to z of the angular spheroidal function \!\(\*RowBox[{SubscriptBox[StyleBox[\"PS\", FontSlant -> \"Italic\"], RowBox[{\"n\", \",\", \"m\"}]], \"(\", RowBox[{\"\[Gamma]\", \",\", \"z\"}], \")\"}]\) of the first kind."
SpheroidalQS::usage = "\!\(\*RowBox[{\"SpheroidalQS\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"\[Gamma]\", \"TR\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the angular spheroidal function \!\(\*RowBox[{SubscriptBox[StyleBox[\"QS\", FontSlant -> \"Italic\"], RowBox[{\"n\", \",\", \"m\"}]], \"(\", RowBox[{\"\[Gamma]\", \",\", \"z\"}], \")\"}]\) of the second kind."
SpheroidalQSPrime::usage = "\!\(\*RowBox[{\"SpheroidalQSPrime\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"\[Gamma]\", \"TR\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the derivative with respect to z of the angular spheroidal function \!\(\*RowBox[{SubscriptBox[StyleBox[\"QS\", FontSlant -> \"Italic\"], RowBox[{\"n\", \",\", \"m\"}]], \"(\", RowBox[{\"\[Gamma]\", \",\", \"z\"}], \")\"}]\) of the second kind."
SpheroidalRadialFactor::usage = "\!\(\*RowBox[{\"SpheroidalRadialFactor\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"c\", \"TI\"]}], \"]\"}]\) gives the spheroidal radial factor with degree n and order m."
SpheroidalS1::usage = "\!\(\*RowBox[{\"SpheroidalS1\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"\[Gamma]\", \"TR\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the radial spheroidal function \!\(\*RowBox[{SubsuperscriptBox[\"S\", RowBox[{\"n\", \",\", \"m\"}], RowBox[{\"(\", \"1\", \")\"}]], \"(\", RowBox[{\"\[Gamma]\", \",\", \"z\"}], \")\"}]\) of the first kind."
SpheroidalS1Prime::usage = "\!\(\*RowBox[{\"SpheroidalS1Prime\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"\[Gamma]\", \"TR\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the derivative with respect to z of the radial spheroidal function \!\(\*RowBox[{SubsuperscriptBox[\"S\", RowBox[{\"n\", \",\", \"m\"}], RowBox[{\"(\", \"1\", \")\"}]], \"(\", RowBox[{\"\[Gamma]\", \",\", \"z\"}], \")\"}]\) of the first kind."
SpheroidalS2::usage = "\!\(\*RowBox[{\"SpheroidalS2\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"\[Gamma]\", \"TR\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the radial spheroidal function \!\(\*RowBox[{SubsuperscriptBox[\"S\", RowBox[{\"n\", \",\", \"m\"}], RowBox[{\"(\", \"2\", \")\"}]], \"(\", RowBox[{\"\[Gamma]\", \",\", \"z\"}], \")\"}]\) of the second kind."
SpheroidalS2Prime::usage = "\!\(\*RowBox[{\"SpheroidalS2Prime\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"\[Gamma]\", \"TR\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the derivative with respect to z of the radial spheroidal function \!\(\*RowBox[{SubsuperscriptBox[\"S\", RowBox[{\"n\", \",\", \"m\"}], RowBox[{\"(\", \"2\", \")\"}]], \"(\", RowBox[{\"\[Gamma]\", \",\", \"z\"}], \")\"}]\) of the second kind."
Splice::usage = "\!\(\*RowBox[{\"Splice\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) splices \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) output into an external file. It takes text enclosed between \!\(\*RowBox[{\"<\", \"*\"}]\) and \!\(\*RowBox[{\"*\", \">\"}]\) in the file, evaluates the text as \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) input, and replaces the text with the resulting \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) output. "
Split::usage = "\!\(\*RowBox[{\"Split\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) splits \!\(\*StyleBox[\"list\", \"TI\"]\) into sublists consisting of runs of identical elements. \n\!\(\*RowBox[{\"Split\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"]}], \"]\"}]\) treats pairs of adjacent elements as identical whenever applying the function \!\(\*StyleBox[\"test\", \"TI\"]\) to them yields True. "
SqrtBox::usage = "\!\(\*RowBox[{SqrtBox, \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) is a low-level box construct that represents the displayed object \!\(\*SqrtBox[StyleBox[\"x\", \"TI\"]]\) in notebook expressions. "
Sqrt::usage = "\!\(\*RowBox[{\"Sqrt\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) or \!\(\*SqrtBox[StyleBox[\"z\", \"TI\"]]\) gives the square root of \!\(\*StyleBox[\"z\", \"TI\"]\). "
SquaredEuclideanDistance::usage = "\!\(\*RowBox[{\"SquaredEuclideanDistance\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the squared Euclidean distance between vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
SquareFreeQ::usage = "\!\(\*RowBox[{\"SquareFreeQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a square-free polynomial or number, and False otherwise.\n\!\(\*RowBox[{\"SquareFreeQ\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"vars\", \"TI\"]}], \"]\"}]\) gives True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is square-free with respect to the variables \!\(\*StyleBox[\"vars\", \"TI\"]\). "
SquareIntersection::usage = "\!\(\*RowBox[{\"SquareIntersection\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[SquareIntersection]\", \"y\", \"\[SquareIntersection]\", \"\[Ellipsis]\"}]\)."
Square::usage = "\!\(\*RowBox[{\"Square\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) displays as \!\(\*RowBox[{\"\[Square]\", \"x\"}]\)."
SquaresR::usage = "\!\(\*RowBox[{\"SquaresR\", \"[\", RowBox[{StyleBox[\"d\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the number of ways \!\(\*RowBox[{SubscriptBox[\"r\", \"d\"], \"(\", \"n\", \")\"}]\) to represent the integer \!\(\*StyleBox[\"n\", \"TI\"]\) as a sum of \!\(\*StyleBox[\"d\", \"TI\"]\) squares."
SquareSubsetEqual::usage = "\!\(\*RowBox[{\"SquareSubsetEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[SquareSubsetEqual]\", \"y\", \"\[SquareSubsetEqual]\", \"\[Ellipsis]\"}]\)."
SquareSubset::usage = "\!\(\*RowBox[{\"SquareSubset\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[SquareSubset]\", \"y\", \"\[SquareSubset]\", \"\[Ellipsis]\"}]\)."
SquareSupersetEqual::usage = "\!\(\*RowBox[{\"SquareSupersetEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[SquareSupersetEqual]\", \"y\", \"\[SquareSupersetEqual]\", \"\[Ellipsis]\"}]\)."
SquareSuperset::usage = "\!\(\*RowBox[{\"SquareSuperset\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[SquareSuperset]\", \"y\", \"\[SquareSuperset]\", \"\[Ellipsis]\"}]\)."
SquareUnion::usage = "\!\(\*RowBox[{\"SquareUnion\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[SquareUnion]\", \"y\", \"\[SquareUnion]\", \"\[Ellipsis]\"}]\)."
StackBegin::usage = "\!\(\*RowBox[{\"StackBegin\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\), starting a fresh evaluation stack. "
StackComplete::usage = "\!\(\*RowBox[{\"StackComplete\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\) with intermediate expressions in evaluation chains included on the stack. "
StackInhibit::usage = "\!\(\*RowBox[{\"StackInhibit\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\) without modifying the evaluation stack. "
Stack::usage = "\!\(\*RowBox[{\"Stack\", \"[\", \"]\"}]\) shows the current evaluation stack, giving a list of the tags associated with evaluations that are currently being done. \n\!\(\*RowBox[{\"Stack\", \"[\", StyleBox[\"pattern\", \"TI\"], \"]\"}]\) gives a list of expressions currently being evaluated which match the pattern. "
StandardDeviation::usage = "\!\(\*RowBox[{\"StandardDeviation\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the standard deviation of the elements in \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"StandardDeviation\", \"[\", StyleBox[\"dist\", \"TI\"], \"]\"}]\) gives the standard deviation of the symbolic distribution \!\(\*StyleBox[\"dist\", \"TI\"]\)."
StandardForm::usage = "\!\(\*RowBox[{\"StandardForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints as the standard \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) two\[Hyphen]dimensional representation of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Star::usage = "\!\(\*RowBox[{\"Star\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Star]\", \"y\", \"\[Star]\", \"\[Ellipsis]\"}]\)."
StartingStepSize::usage = "StartingStepSize is an option to NDSolve and related functions that specifies the initial step size to use in trying to generate results."
StartOfLine::usage = "StartOfLine represents the start of a line in a string for purposes of matching in StringExpression."
StartOfString::usage = "StartOfString represents the start of a string for purposes of matching in StringExpression."
StartupSound::usage = "StartupSound is a global option that specifies whether \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) plays a sound when it is launched."
StatusArea::usage = "\!\(\*RowBox[{\"StatusArea\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"string\", \"TI\"]}], \"]\"}]\) displays \!\(\*StyleBox[\"string\", \"TI\"]\) in the status area of the current notebook when the mouse pointer is in the region where \!\(\*StyleBox[\"expr\", \"TI\"]\) appears. "
StepMonitor::usage = "StepMonitor is an option for iterative numerical computation functions that gives an expression to evaluate whenever a step is taken by the numerical method used. "
StieltjesGamma::usage = "\!\(\*RowBox[{\"StieltjesGamma\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the Stieltjes constant \!\(\*SubscriptBox[\"\[Gamma]\", \"n\"]\). "
StirlingS1::usage = "\!\(\*RowBox[{\"StirlingS1\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Stirling number of the first kind \!\(\*SubsuperscriptBox[\"S\", \"n\", RowBox[{\"(\", \"m\", \")\"}]]\). "
StirlingS2::usage = "\!\(\*RowBox[{\"StirlingS2\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"]}], \"]\"}]\) gives the Stirling number of the second kind \!\(\*SubsuperscriptBox[\"\[ScriptCapitalS]\", \"n\", RowBox[{\"(\", \"m\", \")\"}]]\). "
StoppingTest::usage = "StoppingTest is an option for NDSolve that can be used to stop the integration of the ode when a certain condition is found to be True. The condition can evaluate to True/False only and should contain the dependent and independent variables explicitly. This option cannot be used for linear boundary value problems."
StreamPosition::usage = "\!\(\*RowBox[{\"StreamPosition\", \"[\", StyleBox[\"stream\", \"TI\"], \"]\"}]\) returns an integer which specifies the position of the current point in an open stream. "
Streams::usage = "\!\(\*RowBox[{\"Streams\", \"[\", \"]\"}]\) gives a list of all streams that are currently open. \n\!\(\*RowBox[{\"Streams\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) lists only streams with the specified name. "
StringByteCount::usage = "\!\(\*RowBox[{\"StringByteCount\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the total number of bytes used to store the characters in a string."
StringCases::usage = "\!\(\*RowBox[{\"StringCases\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"patt\", \"TI\"]}], \"]\"}]\) gives a list of the substrings in \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\" that match the string expression \!\(\*StyleBox[\"patt\", \"TI\"]\). \n\!\(\*RowBox[{\"StringCases\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{StyleBox[\"lhs\", \"TI\"], \"->\", StyleBox[\"rhs\", \"TI\"]}]}], \"]\"}]\) gives a list of the values of \!\(\*StyleBox[\"rhs\", \"TI\"]\) corresponding to the substrings that match the string expression \!\(\*StyleBox[\"lhs\", \"TI\"]\). \n\!\(\*RowBox[{\"StringCases\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"p\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) includes only the first \!\(\*StyleBox[\"n\", \"TI\"]\) substrings that match. \n\!\(\*RowBox[{\"StringCases\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives substrings that match any of the \!\(\*SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"StringCases\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives the list of results for each of the \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
StringCount::usage = "\!\(\*RowBox[{\"StringCount\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"sub\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives a count of the number of times \"\!\(\*\nStyleBox[\"sub\", \"TI\"]\)\" appears as a substring of \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\". \n\!\(\*RowBox[{\"StringCount\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"patt\", \"TI\"]}], \"]\"}]\) gives the number of substrings in \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\" that match the general string expression \!\(\*StyleBox[\"patt\", \"TI\"]\). \n\!\(\*RowBox[{\"StringCount\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) counts the number of occurrences of any of the \!\(\*SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"StringCount\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives the list of results for each of the \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
StringDrop::usage = "\!\(\*RowBox[{\"StringDrop\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\" with its first \!\(\*StyleBox[\"n\", \"TI\"]\) characters dropped. \n\!\(\*RowBox[{\"StringDrop\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"-\", StyleBox[\"n\", \"TI\"]}]}], \"]\"}]\) gives \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\" with its last \!\(\*StyleBox[\"n\", \"TI\"]\) characters dropped. \n\!\(\*RowBox[{\"StringDrop\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", StyleBox[\"n\", \"TI\"], \"}\"}]}], \"]\"}]\) gives \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\" with its \!\(\*StyleBox[\"n\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) character dropped. \n\!\(\*RowBox[{\"StringDrop\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\" with characters \!\(\*StyleBox[\"m\", \"TI\"]\) through \!\(\*StyleBox[\"n\", \"TI\"]\) dropped. \n\!\(\*RowBox[{\"StringDrop\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"spec\", \"TI\"]}], \"]\"}]\) gives the list of results for each of the \!\(\*SubscriptBox[\"s\", \"i\"]\). "
StringExpression::usage = "\!\(\*RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"~~\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"~~\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]}]\) or \!\(\*RowBox[{\"StringExpression\", \"[\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) represents a sequence of strings and symbolic string objects \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
StringFormat::usage = "\!\(\*RowBox[{\"StringFormat\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) attempts to determine what ImportString format could be used to import the string \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\"."
StringForm::usage = "\!\(\*RowBox[{\"StringForm\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"controlstring\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) prints as the text of the \!\(\*StyleBox[\"controlstring\", \"TI\"]\), with the printed forms of the \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) embedded. "
StringFreeQ::usage = "\!\(\*RowBox[{\"StringFreeQ\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"patt\", \"TI\"]}], \"]\"}]\) yields True if no substring in \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\" matches the string expression \!\(\*StyleBox[\"patt\", \"TI\"]\), and yields False otherwise. \n\!\(\*RowBox[{\"StringFreeQ\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) yields True if no substring matches any of the \!\(\*SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"StringFreeQ\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives the list of results for each of the \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
StringInsert::usage = "\!\(\*RowBox[{\"StringInsert\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"snew\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) yields a string with \"\!\(\*\nStyleBox[\"snew\", \"TI\"]\)\" inserted starting at position n in \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\". \n\!\(\*RowBox[{\"StringInsert\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"snew\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"-\", StyleBox[\"n\", \"TI\"]}]}], \"]\"}]\) inserts at position n from the end of \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\". \n\!\(\*RowBox[{\"StringInsert\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"snew\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) inserts a copy of \"\!\(\*\nStyleBox[\"snew\", \"TI\"]\)\" at each of the positions \!\(\*SubscriptBox[\"n\", \"i\"]\). \n\!\(\*RowBox[{\"StringInsert\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"snew\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the list of results for each of the \!\(\*SubscriptBox[\"s\", \"i\"]\). "
StringJoin::usage = "\!\(\*RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"<>\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"<>\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\), \!\(\*RowBox[{\"StringJoin\", \"[\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) or \!\(\*RowBox[{\"StringJoin\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) yields a string consisting of a concatenation of the \!\(\*SubscriptBox[\"s\", \"i\"]\). "
StringLength::usage = "\!\(\*RowBox[{\"StringLength\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the number of characters in a string. "
StringMatchQ::usage = "\!\(\*RowBox[{\"StringMatchQ\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"patt\", \"TI\"]}], \"]\"}]\) tests whether \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\" matches the string pattern \!\(\*StyleBox[\"patt\", \"TI\"]\). \n\!\(\*RowBox[{\"StringMatchQ\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"RegularExpression\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"regex\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]}], \"]\"}]\) tests whether \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\" matches the specified regular expression. \n\!\(\*RowBox[{\"StringMatchQ\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives the list of results for each of the \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
String::usage = "String is the head of a character string \"\!\(\*\nStyleBox[\"text\", \"TI\"]\)\". "
StringPosition::usage = "\!\(\*RowBox[{\"StringPosition\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"sub\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives a list of the starting and ending character positions at which \"\!\(\*\nStyleBox[\"sub\", \"TI\"]\)\" appears as a substring of \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\". \n\!\(\*RowBox[{\"StringPosition\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"patt\", \"TI\"]}], \"]\"}]\) gives all positions at which substrings matching the general string expression \!\(\*StyleBox[\"patt\", \"TI\"]\) appear in \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\". \n\!\(\*RowBox[{\"StringPosition\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"patt\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) includes only the first \!\(\*StyleBox[\"n\", \"TI\"]\) occurrences of \!\(\*StyleBox[\"patt\", \"TI\"]\). \n\!\(\*RowBox[{\"StringPosition\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives positions of all the \!\(\*SubscriptBox[StyleBox[\"patt\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"StringPosition\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives the list of results for each of the \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
StringQ::usage = "\!\(\*RowBox[{\"StringQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a string, and False otherwise."
StringReplaceList::usage = "\!\(\*RowBox[{\"StringReplaceList\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{StyleBox[\"s\", \"TI\"], \"->\", StyleBox[\"sp\", \"TI\"]}]}], \"]\"}]\) or \!\(\*RowBox[{\"StringReplaceList\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"sp\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"sp\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a list of the strings obtained by replacing each individual occurrence of substrings in \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\" matching the string expressions \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"StringReplaceList\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"srules\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a list of the first \!\(\*StyleBox[\"n\", \"TI\"]\) results obtained. \n\!\(\*RowBox[{\"StringReplaceList\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"srules\", \"TI\"]}], \"]\"}]\) gives the list of results for each of the \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
StringReplace::usage = "\!\(\*RowBox[{\"StringReplace\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{StyleBox[\"s\", \"TI\"], \"->\", StyleBox[\"sp\", \"TI\"]}]}], \"]\"}]\) or \!\(\*RowBox[{\"StringReplace\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"sp\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"sp\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) replaces the string expressions \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) by \!\(\*SubscriptBox[StyleBox[\"sp\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) whenever they appear as substrings of \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\". \n\!\(\*RowBox[{\"StringReplace\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"srules\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) does only the first \!\(\*StyleBox[\"n\", \"TI\"]\) replacements. \n\!\(\*RowBox[{\"StringReplace\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"srules\", \"TI\"]}], \"]\"}]\) gives the list of results for each of the \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
StringReplacePart::usage = "\!\(\*RowBox[{\"StringReplacePart\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"snew\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) replaces the characters at positions \!\(\*StyleBox[\"m\", \"TI\"]\) through \!\(\*StyleBox[\"n\", \"TI\"]\) in \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\" by \"\!\(\*\nStyleBox[\"snew\", \"TI\"]\)\". \n\!\(\*RowBox[{\"StringReplacePart\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"snew\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) inserts copies of \"\!\(\*\nStyleBox[\"snew\", \"TI\"]\)\" at several positions. \n\!\(\*RowBox[{\"StringReplacePart\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"snew\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"snew\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) replaces characters at positions \!\(\*SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) through \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) in \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\" by \"\!\(\*SubscriptBox[\nStyleBox[\"snew\", \"TI\"], \nStyleBox[\"i\", \"TI\"]]\)\". "
StringReverse::usage = "\!\(\*RowBox[{\"StringReverse\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) reverses the order of the characters in \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\". "
StringSkeleton::usage = "\!\(\*RowBox[{\"StringSkeleton\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) represents a sequence of \!\(\*StyleBox[\"n\", \"TI\"]\) omitted characters in a string printed with Short. The standard print form for StringSkeleton is an ellipsis. "
StringSplit::usage = "\!\(\*RowBox[{\"StringSplit\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) splits \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\" into a list of substrings separated by whitespace. \n\!\(\*RowBox[{\"StringSplit\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"patt\", \"TI\"]}], \"]\"}]\) splits into substrings separated by delimiters matching the string expression \!\(\*StyleBox[\"patt\", \"TI\"]\). \n\!\(\*RowBox[{\"StringSplit\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) splits at any of the \!\(\*SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"StringSplit\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{StyleBox[\"patt\", \"TI\"], \"->\", StyleBox[\"val\", \"TI\"]}]}], \"]\"}]\) inserts \!\(\*StyleBox[\"val\", \"TI\"]\) at the position of each delimiter. \n\!\(\*RowBox[{\"StringSplit\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) inserts \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) at the position of each delimiter \!\(\*SubscriptBox[StyleBox[\"p\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"StringSplit\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"patt\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) splits into at most \!\(\*StyleBox[\"n\", \"TI\"]\) substrings. \n\!\(\*RowBox[{\"StringSplit\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"p\", \"TI\"]}], \"]\"}]\) gives the list of results for each of the \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
StringTake::usage = "\!\(\*RowBox[{\"StringTake\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives a string containing the first \!\(\*StyleBox[\"n\", \"TI\"]\) characters in \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\". \n\!\(\*RowBox[{\"StringTake\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"-\", StyleBox[\"n\", \"TI\"]}]}], \"]\"}]\) gives the last \!\(\*StyleBox[\"n\", \"TI\"]\) characters in \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\". \n\!\(\*RowBox[{\"StringTake\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", StyleBox[\"n\", \"TI\"], \"}\"}]}], \"]\"}]\) gives the \!\(\*StyleBox[RowBox[{StyleBox[\"n\", \"TI\"], \"\[Null]\"}]]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) character in \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\". \n\!\(\*RowBox[{\"StringTake\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives characters \!\(\*StyleBox[\"m\", \"TI\"]\) through \!\(\*StyleBox[\"n\", \"TI\"]\) in \"\!\(\*\nStyleBox[\"string\", \"TI\"]\)\". \n\!\(\*RowBox[{\"StringTake\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"spec\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"spec\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) gives a list of the substrings specified by the \!\(\*SubscriptBox[StyleBox[\"spec\", \"TI\"], StyleBox[\"i\", \"TI\"]]\).\n\!\(\*RowBox[{\"StringTake\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"spec\", \"TI\"]}], \"]\"}]\) gives the list of results for each of the \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
StringToStream::usage = "\!\(\*RowBox[{\"StringToStream\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) opens an input stream for reading from a string. "
StripBoxes::usage = "\!\(\*RowBox[{StripBoxes, \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) will strip out unnecessary boxes, spaces, and options from a format expression."
StripWrapperBoxes::usage = "StripWrapperBoxes is an option to TagBox."
StructuredSelection::usage = "StructuredSelection is an option for Cell which specifies whether to allow only complete subexpressions in the cell to be selected interactively using the front end. "
StruveH::usage = "\!\(\*RowBox[{\"StruveH\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the Struve function \!\(\*RowBox[{SubscriptBox[StyleBox[\"H\", SingleLetterItalics -> False, FontWeight -> \"Bold\"], \"n\"], \"(\", \"z\", \")\"}]\). "
StruveL::usage = "\!\(\*RowBox[{\"StruveL\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) gives the modified Struve function \!\(\*RowBox[{SubscriptBox[StyleBox[\"L\", SingleLetterItalics -> False, FontWeight -> \"Bold\"], \"n\"], \"(\", \"z\", \")\"}]\). "
Stub::usage = "Stub is an attribute which specifies that if a symbol is ever used, Needs should automatically be called on the context of the symbol. "
StudentTDistribution::usage = "\!\(\*RowBox[{\"StudentTDistribution\", \"[\", StyleBox[\"\[Nu]\", \"TR\"], \"]\"}]\) represents a Student \!\(\*StyleBox[\"t\", \"TI\"]\) distribution with \!\(\*StyleBox[\"\[Nu]\", \"TR\"]\) degrees of freedom."
StyleBoxAutoDelete::usage = "StyleBoxAutoDelete is an option for selections that specifies whether a StyleBox wrapped around them should be automatically removed when the expression is edited."
StyleBox::usage = "\!\(\*RowBox[{StyleBox, \"[\", RowBox[{StyleBox[\"boxes\", \"TI\"], \",\", StyleBox[\"options\", \"TI\"]}], \"]\"}]\) is a low-level representation of \!\(\*StyleBox[\"boxes\", \"TI\"]\) to be shown with the specified option settings. \n\!\(\*RowBox[{StyleBox, \"[\", RowBox[{StyleBox[\"boxes\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"style\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) uses the option setting for the specified style in the current notebook. "
StyleDefinitions::usage = "StyleDefinitions is an option for notebooks which gives definitions for the styles that can be used in a notebook. "
StyleForm::usage = "\!\(\*RowBox[{\"StyleForm\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"options\", \"TI\"]}], \"]\"}]\) prints using the specified style options. \n\!\(\*RowBox[{\"StyleForm\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"style\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) prints using the specified cell style in the current notebook. "
StyleMenuListing::usage = "StyleMenuListing is an option for cells that specifies whether a given cell style is listed in the \!\(\*StyleBox[\"Format \[FilledRightTriangle] Style\", \"MenuName\"]\) submenu."
StyleNameDialogSettings::usage = "\!\(\*RowBox[{\"StyleNameDialogSettings\", \"->\", RowBox[{\"{\", RowBox[{StyleBox[\"opt\", \"TI\"], \"->\", StyleBox[\"val\", \"TI\"]}], \"}\"}]}]\) is a global option that specifies the cell style displayed in the \!\(\*StyleBox[\"Custom Style\", \"DialogElementName\"]\) dialog box."
Style::usage = "\!\(\*RowBox[{\"Style\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"options\", \"TI\"]}], \"]\"}]\) displays with \!\(\*StyleBox[\"expr\", \"TI\"]\) formatted using the specified option settings. \n\!\(\*RowBox[{\"Style\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"style\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) uses the option settings for the specified style in the current notebook. \n\!\(\*RowBox[{\"Style\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"color\", \"TI\"]}], \"]\"}]\) displays using the specified color. \n\!\(\*RowBox[{\"Style\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", \"Bold\"}], \"]\"}]\) displays with fonts made bold. \n\!\(\*RowBox[{\"Style\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", \"Italic\"}], \"]\"}]\) displays with fonts made italic. \n\!\(\*RowBox[{\"Style\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", \"Underlined\"}], \"]\"}]\) displays with fonts underlined. \n\!\(\*RowBox[{\"Style\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", \"Larger\"}], \"]\"}]\) displays with fonts made larger. \n\!\(\*RowBox[{\"Style\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", \"Smaller\"}], \"]\"}]\) displays with fonts made smaller. \n\!\(\*RowBox[{\"Style\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) displays with font size \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"Style\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", \"Tiny\"}], \"]\"}]\), \!\(\*RowBox[{\"Style\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", \"Small\"}], \"]\"}]\), etc. display with fonts that are tiny, small, etc. "
StylePrint::usage = "\!\(\*RowBox[{\"StylePrint\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"style\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) creates a new cell in the current notebook with the specified style, and prints \!\(\*StyleBox[\"expr\", \"TI\"]\) into it. \n\!\(\*RowBox[{\"StylePrint\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) uses the default style for the current notebook. "
StyleSheetPath::usage = "StyleSheetPath is a global option that specifies which directories \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) searches to find stylesheets."
Subfactorial::usage = "\!\(\*RowBox[{\"Subfactorial\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the number of permutations of \!\(\*StyleBox[\"n\", \"TI\"]\) objects that leave no object fixed."
SubMinus::usage = "\!\(\*RowBox[{\"SubMinus\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays as \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"-\", \"TR\"]]\)."
SubPlus::usage = "\!\(\*RowBox[{\"SubPlus\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays as \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], \"+\"]\)."
Subresultants::usage = "\!\(\*RowBox[{\"Subresultants\", \"[\", RowBox[{SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"var\", \"TI\"]}], \"]\"}]\) generates a list of the principal subresultant coefficients of the polynomials \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) and \!\(\*SubscriptBox[StyleBox[\"poly\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) with respect to the variable \!\(\*StyleBox[\"var\", \"TI\"]\). "
SubscriptBox::usage = "\!\(\*RowBox[{SubscriptBox, \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) is the low\[Hyphen]level box representation for \!\(\*SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"y\", \"TI\"]]\) in notebook expressions. "
SubscriptBoxOptions::usage = "\!\(\*RowBox[{SubscriptBoxOptions, \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for selections that specifies settings for SubscriptBox objects."
Subscript::usage = "\!\(\*RowBox[{\"Subscript\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) is an object that formats as \!\(\*SubscriptBox[\"x\", \"y\"]\). \n\!\(\*RowBox[{\"Subscript\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) formats as \!\(\*SubscriptBox[\"x\", RowBox[{SubscriptBox[\"y\", \"1\"], \",\", SubscriptBox[\"y\", \"2\"], \",\", \"\[Ellipsis]\"}]]\)."
SubsetEqual::usage = "\!\(\*RowBox[{\"SubsetEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[SubsetEqual]\", \"y\", \"\[SubsetEqual]\", \"\[Ellipsis]\"}]\)."
Subset::usage = "\!\(\*RowBox[{\"Subset\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Subset]\", \"y\", \"\[Subset]\", \"\[Ellipsis]\"}]\)."
Subsets::usage = "\!\(\*RowBox[{\"Subsets\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives a list of all possible subsets of \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Subsets\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives all subsets containing at most \!\(\*StyleBox[\"n\", \"TI\"]\) elements. \n\!\(\*RowBox[{\"Subsets\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", StyleBox[\"n\", \"TI\"], \"}\"}]}], \"]\"}]\) gives all subsets containing exactly \!\(\*StyleBox[\"n\", \"TI\"]\) elements. \n\!\(\*RowBox[{\"Subsets\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives all subsets containing between \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) and \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) elements. \n\!\(\*RowBox[{\"Subsets\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"nspec\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) gives the first \!\(\*StyleBox[\"s\", \"TI\"]\) subsets. \n\!\(\*RowBox[{\"Subsets\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"nspec\", \"TI\"], \",\", RowBox[{\"{\", StyleBox[\"s\", \"TI\"], \"}\"}]}], \"]\"}]\) gives the \!\(\*StyleBox[RowBox[{StyleBox[\"s\", \"TI\"], \"\[Null]\"}]]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) subset. "
SubStar::usage = "\!\(\*RowBox[{\"SubStar\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays as \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], \"*\"]\)."
SubsuperscriptBox::usage = "\!\(\*RowBox[{SubsuperscriptBox, \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the low\[Hyphen]level box representation for \!\(\*SubsuperscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"y\", \"TI\"], StyleBox[\"z\", \"TI\"]]\) in notebook expressions. "
SubsuperscriptBoxOptions::usage = "\!\(\*RowBox[{SubsuperscriptBoxOptions, \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for selections that specifies settings for SubsuperscriptBox objects."
Subsuperscript::usage = "\!\(\*RowBox[{\"Subsuperscript\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is an object that formats as \!\(\*SubsuperscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"y\", \"TI\"], StyleBox[\"z\", \"TI\"]]\). "
SubtractFrom::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"-=\", StyleBox[\"dx\", \"TI\"]}]\) subtracts \!\(\*StyleBox[\"dx\", \"TI\"]\) from \!\(\*StyleBox[\"x\", \"TI\"]\) and returns the new value of x. "
Subtract::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"-\", StyleBox[\"y\", \"TI\"]}]\) is equivalent to \!\(\*RowBox[{\"x\", \"+\", RowBox[{\"(\", RowBox[{RowBox[{\"-\", \"1\"}], \"*\", \"y\"}], \")\"}]}]\). "
SubValues::usage = "\!\(\*RowBox[{\"SubValues\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) gives a list of transformation rules corresponding to all subvalues (values for \!\(\*RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}], \"[\", StyleBox[\"\[Ellipsis]\", \"TR\"], \"]\"}]\), etc.) defined for the symbol \!\(\*StyleBox[\"f\", \"TI\"]\)."
SucceedsEqual::usage = "\!\(\*RowBox[{\"SucceedsEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[SucceedsEqual]\", \"y\", \"\[SucceedsEqual]\", \"\[Ellipsis]\"}]\)."
Succeeds::usage = "\!\(\*RowBox[{\"Succeeds\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Succeeds]\", \"y\", \"\[Succeeds]\", \"\[Ellipsis]\"}]\)."
SucceedsSlantEqual::usage = "\!\(\*RowBox[{\"SucceedsSlantEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[SucceedsSlantEqual]\", \"y\", \"\[SucceedsSlantEqual]\", \"\[Ellipsis]\"}]\)."
SucceedsTilde::usage = "\!\(\*RowBox[{\"SucceedsTilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[SucceedsTilde]\", \"y\", \"\[SucceedsTilde]\", \"\[Ellipsis]\"}]\)."
SuchThat::usage = "\!\(\*RowBox[{\"SuchThat\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[SuchThat]\", \"y\"}]\)."
Sum::usage = "\!\(\*RowBox[{\"Sum\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) evaluates the sum \!\(\*RowBox[{UnderoverscriptBox[\"\[Sum]\", RowBox[{\"i\", \"=\", \"1\"}], SubscriptBox[\"i\", StyleBox[\"max\", FontSlant -> \"Italic\"]], LimitsPositioning -> True], \"f\"}]\). \n\!\(\*RowBox[{\"Sum\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) starts with \!\(\*RowBox[{\"i\", \"=\", SubscriptBox[\"i\", StyleBox[\"min\", FontSlant -> \"Italic\"]]}]\). \n\!\(\*RowBox[{\"Sum\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"di\", \"TI\"]}], \"}\"}]}], \"]\"}]\) uses steps \!\(\*RowBox[{\"d\", \"\[InvisibleSpace]\", \"i\"}]\). \n\!\(\*RowBox[{\"Sum\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"}\"}]}], \"]\"}]\) uses successive values \!\(\*RowBox[{SubscriptBox[\"i\", \"1\"], \",\", SubscriptBox[\"i\", \"2\"], \",\", \"\[Ellipsis]\"}]\).\n\!\(\*RowBox[{\"Sum\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"j\", \"TI\"], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) evaluates the multiple sum \!\(\*RowBox[{UnderoverscriptBox[\"\[Sum]\", RowBox[{\"i\", \"=\", SubscriptBox[\"i\", StyleBox[\"min\", FontSlant -> \"Italic\"]]}], SubscriptBox[\"i\", StyleBox[\"max\", FontSlant -> \"Italic\"]], LimitsPositioning -> True], RowBox[{UnderoverscriptBox[\"\[Sum]\", RowBox[{\"j\", \"=\", SubscriptBox[\"j\", StyleBox[\"min\", FontSlant -> \"Italic\"]]}], SubscriptBox[\"j\", StyleBox[\"max\", FontSlant -> \"Italic\"]], LimitsPositioning -> True], RowBox[{\"\[Ellipsis]\", \"f\"}]}]}]\). "
SuperDagger::usage = "\!\(\*RowBox[{\"SuperDagger\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays as \!\(\*SuperscriptBox[StyleBox[\"expr\", \"TI\"], \"\[Dagger]\"]\)."
SuperMinus::usage = "\!\(\*RowBox[{\"SuperMinus\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays as \!\(\*SuperscriptBox[StyleBox[\"expr\", \"TI\"], \"-\"]\)."
SuperPlus::usage = "\!\(\*RowBox[{\"SuperPlus\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays as \!\(\*SuperscriptBox[StyleBox[\"expr\", \"TI\"], \"+\"]\)."
SuperscriptBox::usage = "\!\(\*RowBox[{SuperscriptBox, \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) is the low\[Hyphen]level box representation for \!\(\*SuperscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"y\", \"TI\"]]\) in notebook expressions. "
SuperscriptBoxOptions::usage = "\!\(\*RowBox[{SuperscriptBoxOptions, \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for selections that specifies settings for SuperscriptBox objects."
Superscript::usage = "\!\(\*RowBox[{\"Superscript\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) is an object that formats as \!\(\*SuperscriptBox[\"x\", \"y\"]\). "
SupersetEqual::usage = "\!\(\*RowBox[{\"SupersetEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[SupersetEqual]\", \"y\", \"\[SupersetEqual]\", \"\[Ellipsis]\"}]\)."
Superset::usage = "\!\(\*RowBox[{\"Superset\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Superset]\", \"y\", \"\[Superset]\", \"\[Ellipsis]\"}]\)."
SuperStar::usage = "\!\(\*RowBox[{\"SuperStar\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays as \!\(\*SuperscriptBox[StyleBox[\"expr\", \"TI\"], \"*\"]\)."
SurfaceColor::usage = "\!\(\*RowBox[{\"SurfaceColor\", \"[\", StyleBox[\"dcol\", \"TI\"], \"]\"}]\) is a three\[Hyphen]dimensional graphics directive which specifies that the surfaces which follow should act as diffuse reflectors of light with a color given by \!\(\*StyleBox[\"dcol\", \"TI\"]\). \n\!\(\*RowBox[{\"SurfaceColor\", \"[\", RowBox[{StyleBox[\"dcol\", \"TI\"], \",\", StyleBox[\"scol\", \"TI\"]}], \"]\"}]\) specifies that a specular reflection component should be included, with a color given by \!\(\*StyleBox[\"scol\", \"TI\"]\). \n\!\(\*RowBox[{\"SurfaceColor\", \"[\", RowBox[{StyleBox[\"dcol\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"scol\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) specifies that the reflection should occur with specular exponent\[NonBreakingSpace]\!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"SurfaceColor\", \"[\", RowBox[{StyleBox[\"dcol\", \"TI\"], \",\", StyleBox[\"scol\", \"TI\"], \",\", StyleBox[\"gcol\", \"TI\"]}], \"]\"}]\) specifies that a color \!\(\*StyleBox[\"gcol\", \"TI\"]\) should be added as if there was an intrinsic glow in the polygon. "
SurfaceGraphics::usage = "\!\(\*RowBox[{\"SurfaceGraphics\", \"[\", StyleBox[\"array\", \"TI\"], \"]\"}]\) is a representation of a three\[Hyphen]dimensional plot of a surface, with heights of each point on a grid specified by values in \!\(\*StyleBox[\"array\", \"TI\"]\). \n\!\(\*RowBox[{\"SurfaceGraphics\", \"[\", RowBox[{StyleBox[\"array\", \"TI\"], \",\", StyleBox[\"shades\", \"TI\"]}], \"]\"}]\) represents a surface, whose parts are shaded according to the array \!\(\*StyleBox[\"shades\", \"TI\"]\). "
SuspendPacket::usage = "\!\(\*RowBox[{\"SuspendPacket\", \"[\", \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet used for synchronization with the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) kernel."
Switch::usage = "\!\(\*RowBox[{\"Switch\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"value\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"value\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\), then compares it with each of the \!\(\*SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) in turn, evaluating and returning the \!\(\*SubscriptBox[StyleBox[\"value\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) corresponding to the first match found. "
SymbolName::usage = "\!\(\*RowBox[{\"SymbolName\", \"[\", StyleBox[\"symbol\", \"TI\"], \"]\"}]\) gives the name of the specified symbol. "
Symbol::usage = "\!\(\*RowBox[{\"Symbol\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) refers to a symbol with the specified name. "
SymmetricPolynomial::usage = "\!\(\*RowBox[{\"SymmetricPolynomial\", \"[\", RowBox[{StyleBox[\"k\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) elementary symmetric polynomial in the variables \!\(\*RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"n\", \"TI\"]]}]\)."
SymmetricReduction::usage = "\!\(\*RowBox[{\"SymmetricReduction\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives a pair of polynomials \!\(\*RowBox[{\"{\", RowBox[{\"p\", \",\", \"q\"}], \"}\"}]\) in \!\(\*RowBox[{SubscriptBox[\"x\", \"1\"], \",\", \"\[Ellipsis]\", \",\", SubscriptBox[\"x\", \"n\"]}]\) such that \!\(\*RowBox[{\"f\", \"==\", RowBox[{\"p\", \"+\", \"q\"}]}]\), where p is the symmetric part and q is the remainder.\n\!\(\*RowBox[{\"SymmetricReduction\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives the pair \!\(\*RowBox[{\"{\", RowBox[{\"p\", \",\", \"q\"}], \"}\"}]\) with the elementary symmetric polynomials in p replaced by \!\(\*RowBox[{SubscriptBox[\"s\", \"1\"], \",\", \"\[Ellipsis]\", \",\", SubscriptBox[\"s\", \"n\"]}]\)."
SynchronousInitialization::usage = "SynchronousInitialization is an option for Manipulate, DynamicModule and related functions which specifies whether or not to evaluate the expression given as the setting for Initialization synchronously."
SynchronousUpdating::usage = "SynchronousUpdating is an option for Manipulate, Dynamic and related functions which specifies whether or not to evaluate their contents synchronously. "
SyntaxForm::usage = "SyntaxForm is an option for InterpretationBox and TagBox objects that specifies the precedence level to use when the InterpretationBox or TagBox is considered as an operator."
SyntaxInformation::usage = "\!\(\*RowBox[{\"SyntaxInformation\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) gives information used to generate syntax coloring and other advisories when \!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"\[Ellipsis]\", \"TR\"], \"]\"}]\) is entered as input. "
SyntaxLength::usage = "\!\(\*RowBox[{\"SyntaxLength\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) finds the number of characters starting at the beginning of a string that correspond to syntactically correct input for a single \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) expression. "
SyntaxPacket::usage = "\!\(\*RowBox[{\"SyntaxPacket\", \"[\", StyleBox[\"integer\", \"TI\"], \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet where \!\(\*StyleBox[\"integer\", \"TI\"]\) indicates the position at which a syntax error was detected in the input line."
SyntaxQ::usage = "\!\(\*RowBox[{\"SyntaxQ\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) returns True if the string corresponds to syntactically correct input for a single \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) expression, and returns False otherwise. "
SystemDialogInput::usage = "\!\(\*RowBox[{\"SystemDialogInput\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"type\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) brings up an interactive system dialog and returns the value chosen in the dialog. \n\!\(\*RowBox[{\"SystemDialogInput\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"type\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"init\", \"TI\"]}], \"]\"}]\) uses \!\(\*StyleBox[\"init\", \"TI\"]\) as the initial setting in the dialog."
SystemHelpPath::usage = "SystemHelpPath is a global option that specifies which directories are searched for the help notebooks used within the help system."
SystemInformation::usage = "\!\(\*RowBox[{\"SystemInformation\", \"[\", \"]\"}]\) gives detailed information about the \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) system being run. \n\!\(\*RowBox[{\"SystemInformation\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"comp\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a list of rules with information about the component \"\!\(\*\nStyleBox[\"comp\", \"TI\"]\)\". \n\!\(\*RowBox[{\"SystemInformation\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"comp\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"prop\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives the value of property \"\!\(\*\nStyleBox[\"prop\", \"TI\"]\)\" for component \"\!\(\*\nStyleBox[\"comp\", \"TI\"]\)\"."
SystemOptions::usage = "\!\(\*RowBox[{\"SystemOptions\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives the current setting for the internal system option with the specified name.\n\!\(\*RowBox[{\"SystemOptions\", \"[\", \"]\"}]\) gives the current settings for all settable internal system options."
TabFilling::usage = "TabFilling is an option for character selections that specifies how a \!\(\*StyleBox[\"Tab\", \"KeyEvent\"]\) character is represented on the screen."
TableAlignments::usage = "TableAlignments is an option for TableForm and MatrixForm which specifies how entries in each dimension should be aligned. "
TableDepth::usage = "TableDepth is an option for TableForm and MatrixForm which specifies the maximum number of levels to be printed in tabular or matrix format. "
TableDirections::usage = "TableDirections is an option for TableForm and MatrixForm which specifies whether successive dimensions should be arranged as rows or columns. "
TableForm::usage = "\!\(\*RowBox[{\"TableForm\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) prints with the elements of \!\(\*StyleBox[\"list\", \"TI\"]\) arranged in an array of rectangular cells. "
TableHeadings::usage = "TableHeadings is an option for TableForm and MatrixForm which gives the labels to be printed for entries in each dimension of a table or matrix. "
Table::usage = "\!\(\*RowBox[{\"Table\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \"}\"}]}], \"]\"}]\) generates a list of \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) copies of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Table\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) generates a list of the values of \!\(\*StyleBox[\"expr\", \"TI\"]\) when \!\(\*StyleBox[\"i\", \"TI\"]\) runs from 1 to \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]\). \n\!\(\*RowBox[{\"Table\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) starts with \!\(\*RowBox[{StyleBox[\"i\", \"TI\"], \"=\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]]}]\). \n\!\(\*RowBox[{\"Table\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"di\", \"TI\"]}], \"}\"}]}], \"]\"}]\) uses steps \!\(\*StyleBox[\"di\", \"TI\"]\). \n\!\(\*RowBox[{\"Table\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"}\"}]}], \"]\"}]\) uses the successive values \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\).\n\!\(\*RowBox[{\"Table\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"i\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"j\", \"TI\"], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives a nested list. The list associated with \!\(\*StyleBox[\"i\", \"TI\"]\) is outermost. "
TableSpacing::usage = "TableSpacing is an option for TableForm and MatrixForm which specifies how many spaces should be left between each successive row or column. "
TabSpacings::usage = "TabSpacings is an option for character selections that specifies the number of spaces in ems that the cursor advances when the \!\(\*StyleBox[\"Tab\", \"KeyEvent\"]\) key is pressed."
TabView::usage = "\!\(\*RowBox[{\"TabView\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", \" \", RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", \" \", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) represents an object in which clicking the tab with label \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) displays \!\(\*SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"TabView\", \"[\", RowBox[{StyleBox[RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", \" \", RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", \" \", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"TI\"], \",\", StyleBox[\"i\", \"TI\"]}], \"]\"}]\) makes the \!\(\*StyleBox[\"i\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) tab be the one currently selected.\n\!\(\*RowBox[{\"TabView\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]]}]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", RowBox[{SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]]}]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) associates values \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) with successive tabs, and makes the tab with value \!\(\*StyleBox[\"v\", \"TI\"]\) be the one currently selected. \n\!\(\*RowBox[{\"TabView\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"expr\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) takes the tab labels to be successive integers."
TagBox::usage = "\!\(\*RowBox[{TagBox, \"[\", RowBox[{StyleBox[\"boxes\", \"TI\"], \",\", StyleBox[\"tag\", \"TI\"]}], \"]\"}]\) is a low-level box construct that displays as \!\(\*StyleBox[\"boxes\", \"TI\"]\) but maintains \!\(\*StyleBox[\"tag\", \"TI\"]\) to guide the interpretation of \!\(\*StyleBox[\"boxes\", \"TI\"]\) on input. "
TaggingRules::usage = "TaggingRules is an option for selections that specifies a list of strings to be associated with a selection."
TagSetDelayed::usage = "\!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"/:\", StyleBox[\"lhs\", \"TI\"], \":=\", StyleBox[\"rhs\", \"TI\"]}]\) assigns \!\(\*StyleBox[\"rhs\", \"TI\"]\) to be the delayed value of \!\(\*StyleBox[\"lhs\", \"TI\"]\), and associates the assignment with the symbol \!\(\*StyleBox[\"f\", \"TI\"]\). "
TagSet::usage = "\!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"/:\", StyleBox[\"lhs\", \"TI\"], \"=\", StyleBox[\"rhs\", \"TI\"]}]\) assigns \!\(\*StyleBox[\"rhs\", \"TI\"]\) to be the value of \!\(\*StyleBox[\"lhs\", \"TI\"]\), and associates the assignment with the symbol \!\(\*StyleBox[\"f\", \"TI\"]\). "
TagUnset::usage = "\!\(\*RowBox[{StyleBox[\"f\", \"TI\"], \"/:\", RowBox[{StyleBox[\"lhs\", \"TI\"], \"=.\"}]}]\) removes any rules defined for \!\(\*StyleBox[\"lhs\", \"TI\"]\), associated with the symbol \!\(\*StyleBox[\"f\", \"TI\"]\). "
Take::usage = "\!\(\*RowBox[{\"Take\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) gives the first \!\(\*StyleBox[\"n\", \"TI\"]\) elements of \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Take\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"-\", StyleBox[\"n\", \"TI\"]}]}], \"]\"}]\) gives the last \!\(\*StyleBox[\"n\", \"TI\"]\) elements of \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Take\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"}\"}]}], \"]\"}]\) gives elements \!\(\*StyleBox[\"m\", \"TI\"]\) through \!\(\*StyleBox[\"n\", \"TI\"]\) of \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Take\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", SubscriptBox[StyleBox[\"seq\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"seq\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives a nested list in which elements specified by \!\(\*SubscriptBox[StyleBox[\"seq\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) are taken at level \!\(\*StyleBox[\"i\", \"TI\"]\) in \!\(\*StyleBox[\"list\", \"TI\"]\). "
TakeWhile::usage = "\!\(\*RowBox[{\"TakeWhile\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"crit\", \"TI\"]}], \"]\"}]\) gives elements \!\(\*SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) from the beginning of \!\(\*StyleBox[\"list\", \"TI\"]\), continuing so long as \!\(\*RowBox[{StyleBox[\"crit\", \"TI\"], \"[\", SubscriptBox[StyleBox[\"e\", \"TI\"], StyleBox[\"i\", \"TI\"]], \"]\"}]\) is True."
Tally::usage = "\!\(\*RowBox[{\"Tally\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) tallies the elements in \!\(\*StyleBox[\"list\", \"TI\"]\), listing all distinct elements together with their multiplicities.\n\!\(\*RowBox[{\"Tally\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"]}], \"]\"}]\) uses \!\(\*StyleBox[\"test\", \"TI\"]\) to determine whether pairs of elements should be considered equivalent, and gives a list of the first representatives of each equivalence class, together with their multiplicities."
Tanh::usage = "\!\(\*RowBox[{\"Tanh\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the hyperbolic tangent of z. "
Tan::usage = "\!\(\*RowBox[{\"Tan\", \"[\", StyleBox[\"z\", \"TI\"], \"]\"}]\) gives the tangent of z. "
TargetFunctions::usage = "TargetFunctions is an option for functions such as ComplexExpand that specifies what functions to attempt to generate in the output."
Temporary::usage = "Temporary is an attribute assigned to symbols which are created as local variables by Module. "
TeXForm::usage = "\!\(\*RowBox[{\"TeXForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints as a \!\(\*StyleBox[RowBox[{\"T\", AdjustmentBox[\"E\", BoxBaselineShift -> 0.5, BoxMargins -> {{-0.3, 0}, {0, 0}}], \"X\"}], \"TR\", SingleLetterItalics -> False]\) version of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
TeXSave::usage = "\!\(\*RowBox[{\"TeXSave\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\).tex\\\"\",ShowStringCharacters->True], \"]\"}]\) saves a TeX version of the current input notebook in the front end. \n\!\(\*RowBox[{\"TeXSave\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\).tex\\\"\",ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"source\\\",\\\"TI\\\"]\\).nb\\\"\",ShowStringCharacters->True]}], \"]\"}]\) saves a TeX version of the notebook from the file \!\(\*RowBox[{StyleBox[\"source\", \"TI\"], \".\", \"nb\"}]\). \n\!\(\*RowBox[{\"TeXSave\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"file\\\",\\\"TI\\\"]\\).tex\\\"\",ShowStringCharacters->True], \",\", StyleBox[\"notebook\", \"TI\"]}], \"]\"}]\) saves a TeX version of the notebook corresponding to the specified notebook object. "
TextAlignment::usage = "TextAlignment is an option for Cell, Pane and related constructs which specifies how successive lines of text should be aligned. "
TextCell::usage = "\!\(\*RowBox[{\"TextCell\", \"[\", StyleBox[\"\\\"string\\\"\",\"TI\",ShowStringCharacters->True], \"]\"}]\) gives a text cell that can appear in a \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) notebook.\n\!\(\*RowBox[{\"TextCell\", \"[\", RowBox[{StyleBox[\"\\\"string\\\"\",\"TI\",ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"style\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives a text cell with the specified style."
TextJustification::usage = "TextJustification is an option for Cell and Inset which specifies how much lines of text can be stretched in order to make them be the same length. "
Text::usage = "\!\(\*RowBox[{\"Text\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays with \!\(\*StyleBox[\"expr\", \"TI\"]\) in plain text format. \n\!\(\*RowBox[{\"Text\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"coords\", \"TI\"]}], \"]\"}]\) is a graphics primitive that displays the textual form of \!\(\*StyleBox[\"expr\", \"TI\"]\) centered at the point specified by \!\(\*StyleBox[\"coords\", \"TI\"]\). "
TextPacket::usage = "\!\(\*RowBox[{\"TextPacket\", \"[\", \"string\", \"]\"}]\) is a \!\(\*StyleBox[\"MathLink\", FontSlant -> \"Italic\"]\) packet containing \!\(\*StyleBox[\"string\", \"TI\"]\), the text output from \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) as produced by functions such as Print."
TextRendering::usage = "TextRendering is an obsolete option for OpenWrite etc. which specifies how text is to be rendered in a particular output file. This option is not supported in Version 2.0 or later."
TextStyle::usage = "TextStyle is an option for graphics functions and for Text which specifies the default style and font options with which text should be rendered. "
Therefore::usage = "\!\(\*RowBox[{\"Therefore\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Therefore]\", \"y\"}]\)."
Thick::usage = "Thick is a graphics directive that specifies that lines which follow should be drawn thick."
Thickness::usage = "\!\(\*RowBox[{\"Thickness\", \"[\", StyleBox[\"r\", \"TI\"], \"]\"}]\) is a graphics directive which specifies that lines which follow are to be drawn with thickness \!\(\*StyleBox[\"r\", \"TI\"]\). The thickness \!\(\*StyleBox[\"r\", \"TI\"]\) is given as a fraction of the total width of the graphic. "
Thin::usage = "Thin is a graphics directive that specifies that lines which follow should be drawn thin."
ThisLink::usage = "ThisLink is used in patterns for external packages to distinguish between several instances of the same package."
Thread::usage = "\!\(\*RowBox[{\"Thread\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"args\", \"TI\"], \"]\"}], \"]\"}]\) \[OpenCurlyDoubleQuote]threads\[CloseCurlyDoubleQuote] \!\(\*StyleBox[\"f\", \"TI\"]\) over any lists that appear in \!\(\*StyleBox[\"args\", \"TI\"]\). \n\!\(\*RowBox[{\"Thread\", \"[\", RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"args\", \"TI\"], \"]\"}], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) threads \!\(\*StyleBox[\"f\", \"TI\"]\) over any objects with head \!\(\*StyleBox[\"h\", \"TI\"]\) that appear in \!\(\*StyleBox[\"args\", \"TI\"]\). \n\!\(\*RowBox[{\"Thread\", \"[\", RowBox[{RowBox[{StyleBox[\"f\", \"TI\"], \"[\", StyleBox[\"args\", \"TI\"], \"]\"}], \",\", StyleBox[\"h\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) threads \!\(\*StyleBox[\"f\", \"TI\"]\) over objects with head \!\(\*StyleBox[\"h\", \"TI\"]\) that appear in the first \!\(\*StyleBox[\"n\", \"TI\"]\) \!\(\*StyleBox[\"args\", \"TI\"]\). "
ThreeJSymbol::usage = "\!\(\*RowBox[{\"ThreeJSymbol\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"j\", \"TI\"], StyleBox[\"3\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"m\", \"TI\"], StyleBox[\"3\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) gives the values of the Wigner 3\[Hyphen]j symbol. "
Through::usage = "\!\(\*RowBox[{\"Through\", \"[\", RowBox[{RowBox[{StyleBox[\"p\", \"TI\"], \"[\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"]\"}], \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \"]\"}]\) gives \!\(\*RowBox[{StyleBox[\"p\", \"TI\"], \"[\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \",\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]}], \"]\"}]\). \n\!\(\*RowBox[{\"Through\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) performs the transformation wherever \!\(\*StyleBox[\"h\", \"TI\"]\) occurs in the head of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Throw::usage = "\!\(\*RowBox[{\"Throw\", \"[\", StyleBox[\"value\", \"TI\"], \"]\"}]\) stops evaluation and returns \!\(\*StyleBox[\"value\", \"TI\"]\) as the value of the nearest enclosing Catch. \n\!\(\*RowBox[{\"Throw\", \"[\", RowBox[{StyleBox[\"value\", \"TI\"], \",\", StyleBox[\"tag\", \"TI\"]}], \"]\"}]\) is caught only by \!\(\*RowBox[{\"Catch\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) where \!\(\*StyleBox[\"form\", \"TI\"]\) is a pattern that matches \!\(\*StyleBox[\"tag\", \"TI\"]\). "
Ticks::usage = "Ticks is an option for graphics functions that specifies tick marks for axes. "
TicksStyle::usage = "TicksStyle is an option for graphics functions which specifies how ticks should be rendered."
TildeEqual::usage = "\!\(\*RowBox[{\"TildeEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[TildeEqual]\", \"y\", \"\[TildeEqual]\", \"\[Ellipsis]\"}]\)."
TildeFullEqual::usage = "\!\(\*RowBox[{\"TildeFullEqual\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[TildeFullEqual]\", \"y\", \"\[TildeFullEqual]\", \"\[Ellipsis]\"}]\)."
Tilde::usage = "\!\(\*RowBox[{\"Tilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Tilde]\", \"y\", \"\[Tilde]\", \"\[Ellipsis]\"}]\)."
TildeTilde::usage = "\!\(\*RowBox[{\"TildeTilde\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[TildeTilde]\", \"y\", \"\[TildeTilde]\", \"\[Ellipsis]\"}]\)."
TimeConstrained::usage = "\!\(\*RowBox[{\"TimeConstrained\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\), stopping after \!\(\*StyleBox[\"t\", \"TI\"]\) seconds. \n\!\(\*RowBox[{\"TimeConstrained\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"], \",\", StyleBox[\"failexpr\", \"TI\"]}], \"]\"}]\) returns \!\(\*StyleBox[\"failexpr\", \"TI\"]\) if the time constraint is not met. "
TimeConstraint::usage = "TimeConstraint is an option for various algorithmic functions which specifies how long to spend trying a particular transformation or part of an algorithm. "
TimesBy::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"*=\", StyleBox[\"c\", \"TI\"]}]\) multiplies \!\(\*StyleBox[\"x\", \"TI\"]\) by \!\(\*StyleBox[\"c\", \"TI\"]\) and returns the new value of \!\(\*StyleBox[\"x\", \"TI\"]\). "
Times::usage = "\!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"*\", StyleBox[\"y\", \"TI\"], \"*\", StyleBox[\"z\", \"TI\"]}]\), \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \"\[Times]\", StyleBox[\"y\", \"TI\"], \"\[Times]\", StyleBox[\"z\", \"TI\"]}]\) or \!\(\*RowBox[{StyleBox[\"x\", \"TI\"], \" \", StyleBox[\"y\", \"TI\"], \" \", StyleBox[\"z\", \"TI\"]}]\) represents a product of terms. "
TimeUsed::usage = "\!\(\*RowBox[{\"TimeUsed\", \"[\", \"]\"}]\) gives the total number of seconds of CPU time used so far in the current \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) session. "
TimeZone::usage = "TimeZone is an option for DateString, AbsoluteTime and related functions that specifies the time zone to use for dates and times. "
Timing::usage = "\!\(\*RowBox[{\"Timing\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) evaluates \!\(\*StyleBox[\"expr\", \"TI\"]\), and returns a list of the time in seconds used, together with the result obtained. "
Tiny::usage = "Tiny is a style or option setting that specifies that objects should be tiny."
ToBoxes::usage = "\!\(\*RowBox[{ToBoxes, \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) generates boxes corresponding to the printed form of \!\(\*StyleBox[\"expr\", \"TI\"]\) in StandardForm. \n\!\(\*RowBox[{ToBoxes, \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) gives the boxes corresponding to output in the specified form. "
ToCharacterCode::usage = "\!\(\*RowBox[{\"ToCharacterCode\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) gives a list of the integer codes corresponding to the characters in a string. \n\!\(\*RowBox[{\"ToCharacterCode\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"encoding\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) gives integer codes according to the specified encoding. "
ToColor::usage = "\!\(\*RowBox[{\"ToColor\", \"[\", RowBox[{StyleBox[\"color\", \"TI\"], \",\", \" \", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) converts \!\(\*StyleBox[\"color\", \"TI\"]\) to \!\(\*StyleBox[\"form\", \"TI\"]\) if \!\(\*StyleBox[\"form\", \"TI\"]\) is GrayLevel, RGBColor or CMYKColor. Otherwise \!\(\*RowBox[{StyleBox[\"form\", \"TI\"], \"[\", StyleBox[\"color\", \"TI\"], \"]\"}]\) is evaluated and the result is expected to be a valid color directive."
ToDate::usage = "\!\(\*RowBox[{\"ToDate\", \"[\", StyleBox[\"time\", \"TI\"], \"]\"}]\) converts an absolute time in seconds since the beginning of January 1, 1900 to a date of the form \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"d\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"], \",\", StyleBox[\"m\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"}\"}]\). "
ToeplitzMatrix::usage = "\!\(\*RowBox[{\"ToeplitzMatrix\", \"[\", StyleBox[\"n\", \"TI\"], \"]\"}]\) gives the \!\(\*StyleBox[\"n\", \"TI\"]\)\[Times]\!\(\*StyleBox[\"n\", \"TI\"]\) Toeplitz matrix with first row and first column being successive integers.\n\!\(\*RowBox[{\"ToeplitzMatrix\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}], \"]\"}]\) gives the Toeplitz matrix whose first column consists of elements \!\(\*SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"1\", \"TR\"]]\), \!\(\*SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"2\", \"TR\"]]\), \!\(\*StyleBox[\"\[Ellipsis]\", \"TR\"]\).\n\!\(\*RowBox[{\"ToeplitzMatrix\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"m\", \"TI\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", \"\[Ellipsis]\", \",\", \" \", SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"n\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) gives the Toeplitz matrix with elements \!\(\*SubscriptBox[StyleBox[\"c\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) down the first column, and \!\(\*SubscriptBox[StyleBox[\"r\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) across the first row."
ToExpression::usage = "\!\(\*RowBox[{\"ToExpression\", \"[\", StyleBox[\"input\", \"TI\"], \"]\"}]\) gives the expression obtained by interpreting strings or boxes as \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) input. \n\!\(\*RowBox[{\"ToExpression\", \"[\", RowBox[{StyleBox[\"input\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) uses interpretation rules corresponding to the specified form. \n\!\(\*RowBox[{\"ToExpression\", \"[\", RowBox[{StyleBox[\"input\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"], \",\", StyleBox[\"h\", \"TI\"]}], \"]\"}]\) wraps the head \!\(\*StyleBox[\"h\", \"TI\"]\) around the expression produced before evaluating it. "
ToFileName::usage = "\!\(\*RowBox[{\"ToFileName\", \"[\", RowBox[{StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"directory\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \",\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"name\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True]}], \"]\"}]\) assembles a full file name from a directory name and a file name. \n\!\(\*RowBox[{\"ToFileName\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"dir\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"dir\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"name\", \"TI\"]}], \"]\"}]\) assembles a full file name from a hierarchy of directory names. \n\!\(\*RowBox[{\"ToFileName\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"dir\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"dir\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) assembles a single directory name from a hierarchy of directory names. "
Together::usage = "\!\(\*RowBox[{\"Together\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) puts terms in a sum over a common denominator, and cancels factors in the result. "
TogglerBar::usage = "\!\(\*RowBox[{\"TogglerBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents a toggler bar with setting \!\(\*StyleBox[\"x\", \"TI\"]\) and with toggler buttons for values \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) to include in the list \!\(\*StyleBox[\"x\", \"TI\"]\).\n\!\(\*RowBox[{\"TogglerBar\", \"[\", RowBox[{RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\), with the values in the list \!\(\*StyleBox[\"x\", \"TI\"]\) being reset every time a toggler button is clicked.\n\!\(\*RowBox[{\"TogglerBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents a toggler bar in which the toggler button associated with value \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) has label \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"i\", \"TI\"]]\)."
Toggler::usage = "\!\(\*RowBox[{\"Toggler\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) represents a toggler button with setting \!\(\*StyleBox[\"x\", \"TI\"]\), that toggles between True and False. \n\!\(\*RowBox[{\"Toggler\", \"[\", RowBox[{\"Dynamic\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}], \"]\"}]\) takes the setting to be the dynamically updated current value of \!\(\*StyleBox[\"x\", \"TI\"]\), with the value of \!\(\*StyleBox[\"x\", \"TI\"]\) being toggled if the button is clicked. \n\!\(\*RowBox[{\"Toggler\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents a toggler button that cycles through any sequence of values \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Toggler\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"pict\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"pict\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) cycles through values \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) displaying them as \!\(\*SubscriptBox[StyleBox[\"pict\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Toggler\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"vlist\", \"TI\"], \",\", StyleBox[\"dpict\", \"TI\"]}], \"]\"}]\) displays as \!\(\*StyleBox[\"dpict\", \"TI\"]\) if \!\(\*StyleBox[\"x\", \"TI\"]\) is none of the \!\(\*SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
TokenWords::usage = "TokenWords is an option for Read and related functions which gives a list of token words to be used to delimit words. "
Tolerance::usage = "Tolerance is an option for various numerical options which specifies the tolerance that should be allowed in computing results."
ToLowerCase::usage = "\!\(\*RowBox[{\"ToLowerCase\", \"[\", StyleBox[\"string\", \"TI\"], \"]\"}]\) yields a string in which all letters have been converted to lowercase. "
ToNumberField::usage = "\!\(\*RowBox[{\"ToNumberField\", \"[\", RowBox[{StyleBox[\"a\", \"TI\"], \",\", StyleBox[\"\[Theta]\", \"TR\"]}], \"]\"}]\) expresses the algebraic number \!\(\*StyleBox[\"a\", \"TI\"]\) in the number field generated by \[Theta]. \n\!\(\*RowBox[{\"ToNumberField\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Theta]\", \"TR\"]}], \"]\"}]\) expresses the \!\(\*SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) in the field generated by \!\(\*StyleBox[\"\[Theta]\", \"TR\"]\).\n\!\(\*RowBox[{\"ToNumberField\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) expresses the \!\(\*SubscriptBox[StyleBox[\"a\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) in a common extension field generated by a single algebraic number."
TooBig::usage = "TooBig is an internal symbol."
Tooltip::usage = "\!\(\*RowBox[{\"Tooltip\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"label\", \"TI\"]}], \"]\"}]\) displays \!\(\*StyleBox[\"label\", \"TI\"]\) as a tooltip while the mouse pointer is in the area where \!\(\*StyleBox[\"expr\", \"TI\"]\) is displayed. "
Top::usage = "Top is a symbol that represents the top for purposes of alignment and positioning. "
ToRadicals::usage = "\!\(\*RowBox[{\"ToRadicals\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) attempts to express all Root objects in \!\(\*StyleBox[\"expr\", \"TI\"]\) in terms of radicals. "
ToRules::usage = "\!\(\*RowBox[{\"ToRules\", \"[\", StyleBox[\"eqns\", \"TI\"], \"]\"}]\) takes logical combinations of equations, in the form generated by Roots and Reduce, and converts them to lists of rules, of the form produced by Solve. "
ToString::usage = "\!\(\*RowBox[{\"ToString\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives a string corresponding to the printed form of \!\(\*StyleBox[\"expr\", \"TI\"]\) in OutputForm. \n\!\(\*RowBox[{\"ToString\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) gives the string corresponding to output in the specified form. "
Total::usage = "\!\(\*RowBox[{\"Total\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the total of the elements in \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Total\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) totals all elements down to level \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"Total\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", StyleBox[\"n\", \"TI\"], \"}\"}]}], \"]\"}]\) totals elements at level \!\(\*StyleBox[\"n\", \"TI\"]\). \n\!\(\*RowBox[{\"Total\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) totals elements at levels \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) through \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]]\). "
TotalWidth::usage = "TotalWidth is an option which can be set for output streams to specify the maximum total number of characters of text that should be printed for each output expression. Short forms of expressions are given if the number of characters needed to print the whole expression is too large. "
ToUpperCase::usage = "\!\(\*RowBox[{\"ToUpperCase\", \"[\", StyleBox[\"string\", \"TI\"], \"]\"}]\) yields a string in which all letters have been converted to uppercase. "
TraceAbove::usage = "TraceAbove is an option for Trace and related functions which specifies whether to include evaluation chains which contain the evaluation chain containing the pattern \!\(\*StyleBox[\"form\", \"TI\"]\) sought. "
TraceAction::usage = "TraceAction is an option for TracePrint and TraceDialog that specifies the function to be applied to each expression they trace."
TraceBackward::usage = "TraceBackward is an option for Trace and related functions which specifies whether to include preceding expressions on the evaluation chain that contains the pattern \!\(\*StyleBox[\"form\", \"TI\"]\) sought. "
TraceDepth::usage = "TraceDepth is an option for Trace and related functions which specifies the maximum nesting of evaluation chains that are to be included. "
TraceDialog::usage = "\!\(\*RowBox[{\"TraceDialog\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) initiates a dialog for every expression used in the evaluation of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"TraceDialog\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) initiates a dialog only for expressions which match \!\(\*StyleBox[\"form\", \"TI\"]\). \n\!\(\*RowBox[{\"TraceDialog\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) initiates dialogs only for expressions whose evaluations use transformation rules associated with the symbol \!\(\*StyleBox[\"s\", \"TI\"]\). "
TraceForward::usage = "TraceForward is an option for Trace and related functions which specifies whether to include later expressions on the evaluation chain that contains the pattern \!\(\*StyleBox[\"form\", \"TI\"]\) sought. "
TraceInternal::usage = "TraceInternal is an option for Trace and related functions which, if True or False, specifies whether to trace evaluations of expressions generated internally by \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\). The intermediate Automatic setting traces a selected set of internal evaluations including Messages and sets or unsets of visible symbols."
TraceLevel::usage = "\!\(\*RowBox[{\"TraceLevel\", \"[\", \"]\"}]\) returns the level currently being traced when it appears within Trace and related functions."
Trace::usage = "\!\(\*RowBox[{\"Trace\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) generates a list of all expressions used in the evaluation of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"Trace\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) includes only those expressions which match \!\(\*StyleBox[\"form\", \"TI\"]\). \n\!\(\*RowBox[{\"Trace\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) includes all evaluations which use transformation rules associated with the symbol \!\(\*StyleBox[\"s\", \"TI\"]\). "
TraceOff::usage = "TraceOff is an option for Trace and related functions which specifies forms inside which tracing should be switched off. "
TraceOn::usage = "TraceOn is an option for Trace and related functions which specifies when tracing should be switched on. "
TraceOriginal::usage = "TraceOriginal is an option for Trace and related functions which specifies whether to test the form of each expression before its head and arguments are evaluated. "
TracePrint::usage = "\!\(\*RowBox[{\"TracePrint\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints all expressions used in the evaluation of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"TracePrint\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) includes only those expressions which match \!\(\*StyleBox[\"form\", \"TI\"]\). \n\!\(\*RowBox[{\"TracePrint\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) includes all evaluations which use transformation rules associated with the symbol \!\(\*StyleBox[\"s\", \"TI\"]\). "
TraceScan::usage = "\!\(\*RowBox[{\"TraceScan\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) to all expressions used in the evaluation of \!\(\*StyleBox[\"expr\", \"TI\"]\). \n\!\(\*RowBox[{\"TraceScan\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"]}], \"]\"}]\) includes only those expressions which match \!\(\*StyleBox[\"form\", \"TI\"]\). \n\!\(\*RowBox[{\"TraceScan\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"s\", \"TI\"]}], \"]\"}]\) includes all evaluations which use transformation rules associated with the symbol \!\(\*StyleBox[\"s\", \"TI\"]\). \n\!\(\*RowBox[{\"TraceScan\", \"[\", RowBox[{StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"form\", \"TI\"], \",\", StyleBox[\"fp\", \"TI\"]}], \"]\"}]\) applies \!\(\*StyleBox[\"f\", \"TI\"]\) before evaluation and \!\(\*StyleBox[\"fp\", \"TI\"]\) after evaluation to expressions used in the evaluation of \!\(\*StyleBox[\"expr\", \"TI\"]\). "
TrackedSymbols::usage = "TrackedSymbols is an option to Refresh, Manipulate and related functions that specifies which symbols should trigger updates when their values are changed."
TraditionalForm::usage = "\!\(\*RowBox[{\"TraditionalForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) prints as an approximation to the traditional mathematical notation for \!\(\*StyleBox[\"expr\", \"TI\"]\). "
TraditionalFunctionNotation::usage = "TraditionalFunctionNotation is an option for selections that specifies whether input of the form \!\(\*RowBox[{\"f\", \"(\", \"x\", \")\"}]\) is interpreted by the kernel as a function or as a product."
TransformationFunction::usage = "\!\(\*RowBox[{\"TransformationFunction\", \"[\", StyleBox[\"data\", \"TI\"], \"]\"}]\) represents a transformation function that applies geometric and other transformations."
TransformationFunctions::usage = "TransformationFunctions is an option for Simplify and FullSimplify which gives the list of functions to apply to try to transform parts of an expression. "
TransformationMatrix::usage = "\!\(\*RowBox[{\"TransformationMatrix\", \"[\", StyleBox[\"tfun\", \"TI\"], \"]\"}]\) gives the homogeneous matrix associated with a TransformationFunction object."
Translate::usage = "\!\(\*RowBox[{\"Translate\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) represents graphics primitives \!\(\*StyleBox[\"g\", \"TI\"]\) translated by the vector \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\). "
TranslationTransform::usage = "\!\(\*RowBox[{\"TranslationTransform\", \"[\", StyleBox[\"v\", \"TI\"], \"]\"}]\) gives a TransformationFunction that represents translation of points by a vector \!\(\*StyleBox[\"v\", \"TI\"]\)."
Transpose::usage = "\!\(\*RowBox[{\"Transpose\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) transposes the first two levels in \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Transpose\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}], \"]\"}]\) transposes \!\(\*StyleBox[\"list\", \"TI\"]\) so that the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) level in \!\(\*StyleBox[\"list\", \"TI\"]\) is the \!\(\*SubscriptBox[StyleBox[\"n\", \"TI\"], StyleBox[\"k\", \"TI\"]]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) level in the result. "
TreeForm::usage = "\!\(\*RowBox[{\"TreeForm\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays \!\(\*StyleBox[\"expr\", \"TI\"]\) as a tree with different levels at different depths. \n\!\(\*RowBox[{\"TreeForm\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) displays \!\(\*StyleBox[\"expr\", \"TI\"]\) as a tree only down to level \!\(\*StyleBox[\"n\", \"TI\"]\)."
TreePlot::usage = "\!\(\*RowBox[{\"TreePlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"i\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"j\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"i\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"2\", \"TR\"]}]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"j\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"2\", \"TR\"]}]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a tree plot of the graph in which vertex \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"ik\", \"TI\"]]\) is connected to vertex \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"jk\", \"TI\"]]\).\n\!\(\*RowBox[{\"TreePlot\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"i\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]], \"->\", SubscriptBox[StyleBox[\"v\", \"TI\"], RowBox[{StyleBox[\"j\", \"TI\"], \"\[InvisibleSpace]\", StyleBox[\"1\", \"TR\"]}]]}], \",\", SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) associates labels \!\(\*SubscriptBox[StyleBox[\"lbl\", \"TI\"], StyleBox[\"k\", \"TI\"]]\) with edges in the graph.\n\!\(\*RowBox[{\"TreePlot\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"pos\", \"TI\"]}], \"]\"}]\) places roots of trees in the plot at position \!\(\*StyleBox[\"pos\", \"TI\"]\).\n\!\(\*RowBox[{\"TreePlot\", \"[\", RowBox[{StyleBox[\"g\", \"TI\"], \",\", StyleBox[\"pos\", \"TI\"], \",\", SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"k\", \"TI\"]]}], \"]\"}]\) uses vertex \!\(\*SubscriptBox[StyleBox[\"v\", \"TI\"], StyleBox[\"k\", \"TI\"]]\) as the root node in the tree plot."
TriangularDistribution::usage = "\!\(\*RowBox[{\"TriangularDistribution\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"min\", \"TI\"], \",\", \" \", StyleBox[\"max\", \"TI\"]}], \"}\"}], \"]\"}]\) represents a symmetric triangular statistical distribution giving values between \!\(\*StyleBox[\"min\", \"TI\"]\) and \!\(\*StyleBox[\"max\", \"TI\"]\). \n\!\(\*RowBox[{\"TriangularDistribution\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{StyleBox[\"min\", \"TI\"], \",\", \" \", StyleBox[\"max\", \"TI\"]}], \"}\"}], \",\", \" \", StyleBox[\"c\", \"TI\"]}], \"]\"}]\) represents a triangular distribution with a maximum at \!\(\*StyleBox[\"c\", \"TI\"]\)."
TrigExpand::usage = "\!\(\*RowBox[{\"TrigExpand\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) expands out trigonometric functions in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
TrigFactorList::usage = "\!\(\*RowBox[{\"TrigFactorList\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) factors trigonometric functions in \!\(\*StyleBox[\"expr\", \"TI\"]\), yielding a list of lists containing trigonometric monomials and exponents. "
TrigFactor::usage = "\!\(\*RowBox[{\"TrigFactor\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) factors trigonometric functions in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Trigger::usage = "\!\(\*RowBox[{\"Trigger\", \"[\", RowBox[{\"Dynamic\", \"[\", StyleBox[\"u\", \"TI\"], \"]\"}], \"]\"}]\) represents a trigger that can be pressed to make the dynamically updated value of \!\(\*StyleBox[\"u\", \"TI\"]\) be continually increased with time from 0 to 1. \n\!\(\*RowBox[{\"Trigger\", \"[\", RowBox[{RowBox[{\"Dynamic\", \"[\", StyleBox[\"u\", \"TI\"], \"]\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}]}], \"]\"}]\) makes \!\(\*StyleBox[\"u\", \"TI\"]\) vary from \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]]\) to \!\(\*SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]\) when triggered. \n\!\(\*RowBox[{\"Trigger\", \"[\", RowBox[{RowBox[{\"Dynamic\", \"[\", StyleBox[\"u\", \"TI\"], \"]\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]], \",\", StyleBox[\"du\", \"TI\"]}], \"}\"}]}], \"]\"}]\) makes \!\(\*StyleBox[\"u\", \"TI\"]\) vary in steps \!\(\*StyleBox[\"du\", \"TI\"]\) when triggered. \n\!\(\*RowBox[{\"Trigger\", \"[\", RowBox[{RowBox[{\"Dynamic\", \"[\", StyleBox[\"u\", \"TI\"], \"]\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"min\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"u\", \"TI\"], StyleBox[\"max\", \"TI\"]]}], \"}\"}], \",\", StyleBox[\"ups\", \"TI\"]}], \"]\"}]\) makes the value of \!\(\*StyleBox[\"u\", \"TI\"]\) increase at a rate of \!\(\*StyleBox[\"ups\", \"TI\"]\) units per second when triggered. "
Trig::usage = "Trig is an option for various polynomial manipulation functions that specifies whether trigonometric functions should be treated like polynomial elements."
TrigReduce::usage = "\!\(\*RowBox[{\"TrigReduce\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) rewrites products and powers of trigonometric functions in \!\(\*StyleBox[\"expr\", \"TI\"]\) in terms of trigonometric functions with combined arguments. "
TrigToExp::usage = "\!\(\*RowBox[{\"TrigToExp\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) converts trigonometric functions in \!\(\*StyleBox[\"expr\", \"TI\"]\) to exponentials. "
TrimmedMean::usage = "\!\(\*RowBox[{\"TrimmedMean\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) gives the mean of the elements in \!\(\*StyleBox[\"list\", \"TI\"]\) after dropping a fraction \!\(\*StyleBox[\"f\", \"TI\"]\) of the smallest and largest elements.\n\!\(\*RowBox[{\"TrimmedMean\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"]\"}]\) gives the mean when a fraction \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]]\) of the smallest elements and a fraction \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]]\) of the largest elements are removed.\n\!\(\*RowBox[{\"TrimmedMean\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the 5% trimmed mean \!\(\*RowBox[{\"TrimmedMean\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", \"0.05\"}], \"]\"}]\)."
Tr::usage = "\!\(\*RowBox[{\"Tr\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) finds the trace of the matrix or tensor \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Tr\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"]}], \"]\"}]\) finds a generalized trace, combining terms with \!\(\*StyleBox[\"f\", \"TI\"]\) instead of Plus. \n\!\(\*RowBox[{\"Tr\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"f\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) goes down to level \!\(\*StyleBox[\"n\", \"TI\"]\) in \!\(\*StyleBox[\"list\", \"TI\"]\). "
True::usage = "True is the symbol for the Boolean value true. "
TrueQ::usage = "\!\(\*RowBox[{\"TrueQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) yields True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is True, and yields False otherwise. "
Tuples::usage = "\!\(\*RowBox[{\"Tuples\", \"[\", RowBox[{StyleBox[\"list\", \"TI\"], \",\", StyleBox[\"n\", \"TI\"]}], \"]\"}]\) generates a list of all possible \!\(\*StyleBox[\"n\", \"TI\"]\)\[Hyphen]tuples of elements from \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Tuples\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a list of all possible tuples whose \!\(\*StyleBox[\"i\", \"TI\"]\)\!\(\*RowBox[{\"\[Null]\", SuperscriptBox[\"\[Null]\", \"th\"]}]\) element is from \!\(\*SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
TuringMachine::usage = "\!\(\*RowBox[{\"TuringMachine\", \"[\", RowBox[{StyleBox[\"rule\", \"TI\"], \",\", StyleBox[\"init\", \"TI\"], \",\", StyleBox[\"t\", \"TI\"]}], \"]\"}]\) generates a list representing the evolution of the Turing machine with the specified rule from initial condition \!\(\*StyleBox[\"init\", \"TI\"]\) for \!\(\*StyleBox[\"t\", \"TI\"]\) steps. \n\!\(\*RowBox[{\"TuringMachine\", \"[\", RowBox[{StyleBox[\"rule\", \"TI\"], \",\", StyleBox[\"init\", \"TI\"]}], \"]\"}]\) gives the result of evolving \!\(\*StyleBox[\"init\", \"TI\"]\) for one step. "
Uncompress::usage = "\!\(\*RowBox[{\"Uncompress\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"string\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) recovers an expression from a compressed string representation generated by Compress."
UnderBar::usage = "\!\(\*RowBox[{\"UnderBar\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) displays with a bar under \!\(\*StyleBox[\"expr\", \"TI\"]\)."
Underflow::usage = "\!\(\*RowBox[{\"Underflow\", \"[\", \"]\"}]\) represents a number too small to represent explicitly on your computer system."
Underlined::usage = "Underlined represents an underlined font."
UnderoverscriptBox::usage = "\!\(\*RowBox[{UnderoverscriptBox, \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is the low\[Hyphen]level box representation for \!\(\*UnderoverscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"y\", \"TI\"], StyleBox[\"z\", \"TI\"]]\) in notebook expressions. "
UnderoverscriptBoxOptions::usage = "\!\(\*RowBox[{UnderoverscriptBoxOptions, \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for selections that specifies settings for UnderoverscriptBox objects."
Underoverscript::usage = "\!\(\*RowBox[{\"Underoverscript\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"z\", \"TI\"]}], \"]\"}]\) is an object that formats as \!\(\*UnderoverscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"y\", \"TI\"], StyleBox[\"z\", \"TI\"]]\). "
UnderscriptBox::usage = "\!\(\*RowBox[{UnderscriptBox, \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) is the low\[Hyphen]level box representation for \!\(\*UnderscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"y\", \"TI\"]]\) in notebook expressions. "
UnderscriptBoxOptions::usage = "\!\(\*RowBox[{UnderscriptBoxOptions, \"->\", RowBox[{\"{\", RowBox[{RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \",\", RowBox[{SubscriptBox[StyleBox[\"opt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \"->\", SubscriptBox[StyleBox[\"val\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]}]\) is an option for selections that specifies settings for UnderscriptBox objects."
Underscript::usage = "\!\(\*RowBox[{\"Underscript\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) is an object that formats as \!\(\*UnderscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"y\", \"TI\"]]\). "
Unequal::usage = "\!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"!=\", StyleBox[\"rhs\", \"TI\"]}]\) or \!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"\[NotEqual]\", StyleBox[\"rhs\", \"TI\"]}]\) returns False if \!\(\*StyleBox[\"lhs\", \"TI\"]\) and \!\(\*StyleBox[\"rhs\", \"TI\"]\) are identical. "
Unevaluated::usage = "\!\(\*RowBox[{\"Unevaluated\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) represents the unevaluated form of \!\(\*StyleBox[\"expr\", \"TI\"]\) when it appears as the argument to a function. "
UniformDistribution::usage = "\!\(\*RowBox[{\"UniformDistribution\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"min\", \"TI\"], \",\", StyleBox[\"max\", \"TI\"]}], \"}\"}], \"]\"}]\) represents a continuous uniform statistical distribution giving values between \!\(\*StyleBox[\"min\", \"TI\"]\) and \!\(\*StyleBox[\"max\", \"TI\"]\). "
Uninstall::usage = "\!\(\*RowBox[{\"Uninstall\", \"[\", StyleBox[\"link\", \"TI\"], \"]\"}]\) terminates an external program started by Install, and removes \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) definitions set up by it. "
Union::usage = "\!\(\*RowBox[{\"Union\", \"[\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) gives a sorted list of all the distinct elements that appear in any of the \!\(\*SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Union\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives a sorted version of a list, in which all duplicated elements have been dropped. "
UnionPlus::usage = "\!\(\*RowBox[{\"UnionPlus\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[UnionPlus]\", \"y\", \"\[UnionPlus]\", \"\[Ellipsis]\"}]\)."
Unique::usage = "\!\(\*RowBox[{\"Unique\", \"[\", \"]\"}]\) generates a new symbol, whose name is of the form \!\(\*StyleBox[RowBox[{\"$\", StyleBox[\"nnn\", \"TI\"]}]]\). \n\!\(\*RowBox[{\"Unique\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) generates a new symbol, with a name of the form \!\(\*StyleBox[RowBox[{StyleBox[\"x\", \"TI\"], \"$\", StyleBox[\"nnn\", \"TI\"]}]]\). \n\!\(\*RowBox[{\"Unique\", \"[\", RowBox[{\"{\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a list of new symbols. \n\!\(\*RowBox[{\"Unique\", \"[\", StyleBox[\"\\\"\\!\\(\\*StyleBox[\\\"xxx\\\",\\\"TI\\\"]\\)\\\"\", ShowStringCharacters->True], \"]\"}]\) generates a new symbol, with a name of the form \!\(\*StyleBox[\"xxxnnn\", \"TI\"]\). "
Unitize::usage = "\!\(\*RowBox[{\"Unitize\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) gives 0 when \!\(\*StyleBox[\"x\", \"TI\"]\) is zero, and 1 when \!\(\*StyleBox[\"x\", \"TI\"]\) has any other numerical value."
UnitStep::usage = "\!\(\*RowBox[{\"UnitStep\", \"[\", StyleBox[\"x\", \"TI\"], \"]\"}]\) represents the unit step function, equal to 0 for \!\(\*RowBox[{\"x\", \"<\", \"0\"}]\) and 1 for \!\(\*RowBox[{\"x\", \"\[GreaterEqual]\", \"0\"}]\). \n\!\(\*RowBox[{\"UnitStep\", \"[\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) represents the multidimensional unit step function which is 1 only if none of the \!\(\*SubscriptBox[\"x\", \"i\"]\) are negative. "
UnitVector::usage = "\!\(\*RowBox[{\"UnitVector\", \"[\", StyleBox[\"k\", \"TI\"], \"]\"}]\) gives the two-dimensional unit vector in the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) direction.\n\!\(\*RowBox[{\"UnitVector\", \"[\", RowBox[{StyleBox[\"n\", \"TI\"], \",\", StyleBox[\"k\", \"TI\"]}], \"]\"}]\) gives the \!\(\*StyleBox[\"n\", \"TI\"]\)-dimensional unit vector in the \!\(\*StyleBox[\"k\", \"TI\"]\)\!\(\*SuperscriptBox[\"\[Null]\", \"th\"]\) direction."
Unprotect::usage = "\!\(\*RowBox[{\"Unprotect\", \"[\", RowBox[{SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) removes the attribute Protected for the symbols \!\(\*SubscriptBox[StyleBox[\"s\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). \n\!\(\*RowBox[{\"Unprotect\", \"[\", RowBox[{SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) unprotects all symbols whose names textually match any of the \!\(\*SubscriptBox[StyleBox[\"form\", \"TI\"], StyleBox[\"i\", \"TI\"]]\). "
UnsameQ::usage = "\!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"=!=\", StyleBox[\"rhs\", \"TI\"]}]\) yields True if the expression \!\(\*StyleBox[\"lhs\", \"TI\"]\) is not identical to \!\(\*StyleBox[\"rhs\", \"TI\"]\), and yields False otherwise. "
Unset::usage = "\!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"=.\"}]\) removes any rules defined for \!\(\*StyleBox[\"lhs\", \"TI\"]\). "
UpArrowBar::usage = "\!\(\*RowBox[{\"UpArrowBar\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[UpArrowBar]\", \"y\", \"\[UpArrowBar]\", \"\[Ellipsis]\"}]\)."
UpArrowDownArrow::usage = "\!\(\*RowBox[{\"UpArrowDownArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[UpArrowDownArrow]\", \"y\", \"\[UpArrowDownArrow]\", \"\[Ellipsis]\"}]\)."
UpArrow::usage = "\!\(\*RowBox[{\"UpArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[UpArrow]\", \"y\", \"\[UpArrow]\", \"\[Ellipsis]\"}]\)."
UpdateInterval::usage = "UpdateInterval is an option to Refresh and Dynamic that specifies at what time interval to do updates."
Update::usage = "\!\(\*RowBox[{\"Update\", \"[\", StyleBox[\"symbol\", \"TI\"], \"]\"}]\) tells \!\(\*StyleBox[\"Mathematica\", FontSlant -> \"Italic\"]\) that hidden changes have been made which could affect values associated with a symbol. \n\!\(\*RowBox[{\"Update\", \"[\", \"]\"}]\) specifies that the value of any symbol could be affected. "
UpDownArrow::usage = "\!\(\*RowBox[{\"UpDownArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[UpDownArrow]\", \"y\", \"\[UpDownArrow]\", \"\[Ellipsis]\"}]\)."
UpEquilibrium::usage = "\!\(\*RowBox[{\"UpEquilibrium\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[UpEquilibrium]\", \"y\", \"\[UpEquilibrium]\", \"\[Ellipsis]\"}]\)."
UpperCaseQ::usage = "\!\(\*RowBox[{\"UpperCaseQ\", \"[\", StyleBox[\"string\", \"TI\"], \"]\"}]\) yields True if all the characters in the string are uppercase letters, and yields False otherwise. "
UpperLeftArrow::usage = "\!\(\*RowBox[{\"UpperLeftArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[UpperLeftArrow]\", \"y\", \"\[UpperLeftArrow]\", \"\[Ellipsis]\"}]\)."
UpperRightArrow::usage = "\!\(\*RowBox[{\"UpperRightArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[UpperRightArrow]\", \"y\", \"\[UpperRightArrow]\", \"\[Ellipsis]\"}]\)."
UpSetDelayed::usage = "\!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"^:=\", StyleBox[\"rhs\", \"TI\"]}]\) assigns \!\(\*StyleBox[\"rhs\", \"TI\"]\) to be the delayed value of \!\(\*StyleBox[\"lhs\", \"TI\"]\), and associates the assignment with symbols that occur at level one in \!\(\*StyleBox[\"lhs\", \"TI\"]\). "
UpSet::usage = "\!\(\*RowBox[{StyleBox[\"lhs\", \"TI\"], \"^=\", StyleBox[\"rhs\", \"TI\"]}]\) assigns \!\(\*StyleBox[\"rhs\", \"TI\"]\) to be the value of \!\(\*StyleBox[\"lhs\", \"TI\"]\), and associates the assignment with symbols that occur at level one in \!\(\*StyleBox[\"lhs\", \"TI\"]\). "
UpTeeArrow::usage = "\!\(\*RowBox[{\"UpTeeArrow\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[UpTeeArrow]\", \"y\", \"\[UpTeeArrow]\", \"\[Ellipsis]\"}]\)."
UpTee::usage = "\!\(\*RowBox[{\"UpTee\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[UpTee]\", \"y\"}]\)."
UpValues::usage = "\!\(\*RowBox[{\"UpValues\", \"[\", StyleBox[\"f\", \"TI\"], \"]\"}]\) gives a list of transformation rules corresponding to all upvalues defined for the symbol \!\(\*StyleBox[\"f\", \"TI\"]\). "
Using::usage = "Using is an option to Roots that specifies any subsidiary equations that are to be used."
V2Get::usage = "\!\(\*RowBox[{\"V2Get\", \"[\", StyleBox[\"name\", \"TI\"], \"]\"}]\) reads in a file written by the V2.x versions."
ValueForm::usage = "ValueForm is an internal symbol."
ValueQ::usage = "\!\(\*RowBox[{\"ValueQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives True if a value has been defined for \!\(\*StyleBox[\"expr\", \"TI\"]\), and gives False otherwise. "
Variables::usage = "\!\(\*RowBox[{\"Variables\", \"[\", StyleBox[\"poly\", \"TI\"], \"]\"}]\) gives a list of all independent variables in a polynomial. "
Variance::usage = "\!\(\*RowBox[{\"Variance\", \"[\", StyleBox[\"list\", \"TI\"], \"]\"}]\) gives the statistical variance of the elements in \!\(\*StyleBox[\"list\", \"TI\"]\). \n\!\(\*RowBox[{\"Variance\", \"[\", StyleBox[\"dist\", \"TI\"], \"]\"}]\) gives the variance of the symbolic distribution \!\(\*StyleBox[\"dist\", \"TI\"]\)."
VectorAngle::usage = "\!\(\*RowBox[{\"VectorAngle\", \"[\", RowBox[{StyleBox[\"u\", \"TI\"], \",\", StyleBox[\"v\", \"TI\"]}], \"]\"}]\) gives the angle between the vectors \!\(\*StyleBox[\"u\", \"TI\"]\) and \!\(\*StyleBox[\"v\", \"TI\"]\)."
VectorQ::usage = "\!\(\*RowBox[{\"VectorQ\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) gives True if \!\(\*StyleBox[\"expr\", \"TI\"]\) is a list or a one\[Hyphen]dimensional SparseArray object, none of whose elements are themselves lists, and gives False otherwise. \n\!\(\*RowBox[{\"VectorQ\", \"[\", RowBox[{StyleBox[\"expr\", \"TI\"], \",\", StyleBox[\"test\", \"TI\"]}], \"]\"}]\) gives True only if \!\(\*StyleBox[\"test\", \"TI\"]\) yields True when applied to each of the elements in \!\(\*StyleBox[\"expr\", \"TI\"]\). "
Vee::usage = "\!\(\*RowBox[{\"Vee\", \"[\", RowBox[{StyleBox[\"x\", \"TI\"], \",\", StyleBox[\"y\", \"TI\"], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"]\"}]\) displays as \!\(\*RowBox[{\"x\", \"\[Vee]\", \"y\", \"\[Vee]\", \"\[Ellipsis]\"}]\)."
Verbatim::usage = "\!\(\*RowBox[{\"Verbatim\", \"[\", StyleBox[\"expr\", \"TI\"], \"]\"}]\) represents \!\(\*StyleBox[\"expr\", \"TI\"]\) in pattern matching, requiring that \!\(\*StyleBox[\"expr\", \"TI\"]\) be matched exactly as it appears, with no substitutions for blanks or other transformations. "
VerifyConvergence::usage = "VerifyConvergence is an option to NSum and NProduct. \!\(\*RowBox[{\"VerifyConvergence\", \" \", \"->\", \" \", \"True\"}]\) causes the limit of the terms and the limit of the ratio of the terms to be checked in the case of infinite sums and products. With \!\(\*RowBox[{\"VerifyConvergence\", \" \", \"->\", \" \", \"False\"}]\) no checking is done."
VerifySolutions::usage = "VerifySolutions is an option to Solve and related functions. With \!\(\*RowBox[{\"VerifySol