(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24187,        817]
NotebookOptionsPosition[     18601,        621]
NotebookOutlinePosition[     21360,        709]
CellTagsIndexPosition[     21247,        703]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Scripting GUIs in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/InteractionWithMathematica"], 
          "Scoping of Scripts in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/Scoping#335606158"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Scripting GUIs in GUIKit User Guide\"\>", 
       3->"\<\"Scoping of Scripts in GUIKit User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InvokeMethod" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/InvokeMethod"], 
          "Script" :> Documentation`HelpLookup["paclet:GUIKit/ref/Script"], 
          "Widget" :> Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], 
          "WidgetReference" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetReference"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"InvokeMethod\"\>", 
       2->"\<\"Script\"\>", 3->"\<\"Widget\"\>", 
       4->"\<\"WidgetReference\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BindEvent", "ObjectName",
 CellID->9616],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BindEvent", "[", 
       RowBox[{
        RowBox[{
         StyleBox["name", "TI"], "|", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["target", "TI"], ",", 
           StyleBox["name", "TI"]}], "}"}], "|", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["target", "TI"], ",", 
           StyleBox["name", "TI"], ",", 
           StyleBox["filter", "TI"]}], "}"}]}], ",", 
        RowBox[{
         StyleBox["object", "TI"], "|", 
         StyleBox["script", "TI"], "|", 
         StyleBox["call", "TI"]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]binds an event from one object to a listener or to a \
script."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24524]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["BindEvent"], "InlineFormula"],
 " causes script code or other method calls to be executed when an event is \
triggered from the targeted widget."
}], "Notes",
 CellTags->"BindEvent",
 CellID->12129],

Cell[TextData[{
 Cell[BoxData["BindEvent"], "InlineFormula"],
 " returns the object instance listener that is created as a result of \
requesting the binding. "
}], "Notes",
 CellID->27442],

Cell[TextData[{
 Cell[BoxData["BindEvent"], "InlineFormula"],
 " is typically used with a ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " block that gets evaluated in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when an action occurs."
}], "Notes",
 CellID->1984],

Cell[TextData[{
 "If there is no ",
 Cell[BoxData[
  StyleBox["target", "TI"]], "InlineFormula"],
 " specified, the wrapping context ",
 Cell[BoxData[
  ButtonBox["Widget",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Widget"]], "InlineFormula"],
 " is the target. "
}], "Notes",
 CellTags->"BindEvent",
 CellID->4872],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"BindEvent", "[", " ", 
   RowBox[{
    RowBox[{
     StyleBox["name", "TI"], "|", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["target", "TI"], ",", 
       StyleBox["name", "TI"]}], "}"}], "|", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["target", "TI"], ",", 
       StyleBox["name", "TI"], ",", 
       StyleBox["filter", "TI"]}], "}"}]}], ",", 
    RowBox[{
     ButtonBox["Script",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/Script"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}]], "InlineFormula"],
 ", when the event ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " occurs, the script is processed."
}], "Notes",
 CellTags->"BindEvent",
 CellID->7049],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"BindEvent", "[", " ", 
   RowBox[{
    RowBox[{
     StyleBox["name", "TI"], "|", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["target", "TI"], ",", 
       StyleBox["name", "TI"]}], "}"}], "|", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["target", "TI"], ",", 
       StyleBox["name", "TI"], ",", 
       StyleBox["filter", "TI"]}], "}"}]}], ",", 
    RowBox[{
     ButtonBox["WidgetReference",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/WidgetReference"], "[", 
     StyleBox["listener", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  ButtonBox["WidgetReference",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetReference"]], "InlineFormula"],
 " must resolve to an object that implements the appropriate listener \
interface."
}], "Notes",
 CellTags->"BindEvent",
 CellID->23396],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["filter", "TI"]], "InlineFormula"],
 " is specified, then only events that match that filter cause the script to \
be processed. In general, the filter is used to name a method in a listener \
type that has multiple methods (e.g., ",
 "WindowEvent",
 "). "
}], "Notes",
 CellID->18026],

Cell[TextData[{
 "For event names ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"propertyChange\", \"TI\"]\)\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"vetoableChange\", \"TI\"]\)\>\""], "InlineFormula"],
 ", the filter is the name of the property for which the binding should be \
done. "
}], "Notes",
 CellID->8582],

Cell[TextData[{
 "Each time a ",
 Cell[BoxData[
  ButtonBox["BindEvent",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/BindEvent"]], "InlineFormula"],
 " action is triggered and the ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " code is executed, specially registered objects associated with the current \
event are registered with the names ",
 Cell[BoxData["\"\<#\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<#1\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<#2\>\""], "InlineFormula"],
 " and so on, depending upon the number of arguments associated with the \
event listener callbacks. Almost all events register at least one object as \
",
 Cell[BoxData["\"\<#\>\""], "InlineFormula"],
 " representing the event object associated with this action.",
 " ",
 "Typically, you might request properties of the event object as in the case \
of mouse events that provide properties, such as ",
 Cell[BoxData["\"\<x\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<y\>\""], "InlineFormula"],
 ", the location of the mouse."
}], "Notes",
 CellTags->"BindEvent",
 CellID->10202],

Cell[TextData[{
 "In some rare cases it will be beneficial to trigger code execution that \
does not require evaluation in the kernel, specifically when a user interface \
would like to abort a currently executing evaluation through the user \
interface, typically with a ",
 StyleBox["Cancel", "DialogElementName"],
 " button. This can be accomplished by associating an ",
 Cell[BoxData[
  ButtonBox["InvokeMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/InvokeMethod"]], "InlineFormula"],
 " request on a specially registered evaluator object referenced as ",
 Cell[BoxData["\"\<ScriptEvaluator\>\""], "InlineFormula"],
 ", using ",
 Cell[BoxData[
  RowBox[{"BindEvent", "[", 
   RowBox[{"\"\<action\>\"", ",", 
    RowBox[{
     ButtonBox["InvokeMethod",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/InvokeMethod"], "[", 
     RowBox[{"{", 
      RowBox[{"\"\<ScriptEvaluator\>\"", ",", "\"\<abort\>\""}], "}"}], 
     "]"}]}], "]"}]], "InlineFormula"],
 ". The framework will always make sure such a reference is defined for any \
live user interfaces to allow the user to programmatically abort current ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluations."
}], "Notes",
 CellTags->"BindEvent",
 CellID->18775],

Cell["The following option can be given:", "Notes",
 CellID->5416],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Name",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/Name"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
the name with which to register the new listener in the object registry\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->30665],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Name",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Name"], " ", "->", " ", "\"\<\!\(\*
StyleBox[\"myName\", \"TI\"]\)\>\""}]], "InlineFormula"],
 " registers the new listener in the object registry for future lookup using \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WidgetReference",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetReference"], "[", "\"\<\!\(\*
StyleBox[\"myName\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 ". This naming and lookup could be useful if you want to dynamically add or \
remove the listener from the bound widget, essentially providing a way to \
remove the binding listener."
}], "Notes",
 CellTags->"BindEvent",
 CellID->14552]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->274753095],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->392608791],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->205257257],

Cell[TextData[{
 "Bind a script to the button ",
 Cell[BoxData["\"\<Action\>\""], "InlineFormula"],
 " event:"
}], "ExampleText",
 CellTags->"BindEvent",
 CellID->15733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\[IndentingNewLine]", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Button\>\"", ",", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<Text\>\"", "\[Rule]", "\"\<Update\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"BindEvent", "[", 
       RowBox[{"\"\<Action\>\"", ",", "\[IndentingNewLine]", 
        RowBox[{"Script", "[", " ", 
         RowBox[{"Print", "[", "\"\<button pressed\>\"", "]"}], "]"}]}], 
       "]"}]}], "\[IndentingNewLine]", " ", "}"}]}], "]"}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellTags->"BindEvent",
 CellLabel->"In[2]:=",
 CellID->31413],

Cell[CellGroupData[{

Cell[BoxData["\<\"button pressed\"\>"], "Print",
 CellTags->"BindEvent",
 CellLabel->"During evaluation of In[3]:=",
 CellID->19917],

Cell[BoxData["\<\"button pressed\"\>"], "Print",
 CellTags->"BindEvent",
 CellLabel->"During evaluation of In[3]:=",
 CellID->15793],

Cell[BoxData["\<\"button pressed\"\>"], "Print",
 CellTags->"BindEvent",
 CellLabel->"During evaluation of In[3]:=",
 CellID->21873]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Bind a script to the ",
 Cell[BoxData["\"\<MouseMoved\>\""], "InlineFormula"],
 " event that prints the ",
 Cell[BoxData["\"\<x\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<y\>\""], "InlineFormula"],
 " property values of the mouse event:"
}], "ExampleText",
 CellID->12060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\[IndentingNewLine]", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Button\>\"", ",", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<Text\>\"", "\[Rule]", "\"\<Button\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"BindEvent", "[", 
       RowBox[{"\"\<MouseMoved\>\"", ",", 
        RowBox[{"Script", "[", "\[IndentingNewLine]", " ", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<x = \>\"", ",", " ", 
           RowBox[{"PropertyValue", "[", 
            RowBox[{"{", 
             RowBox[{"\"\<#\>\"", ",", "\"\<x\>\""}], "}"}], "]"}], ",", " ", 
           "\[IndentingNewLine]", "\"\< y = \>\"", ",", " ", 
           RowBox[{"PropertyValue", "[", 
            RowBox[{"{", 
             RowBox[{"\"\<#\>\"", ",", "\"\<y\>\""}], "}"}], "]"}]}], "]"}], 
         "\[IndentingNewLine]", "   ", "]"}]}], " ", "]"}]}], 
     "\[IndentingNewLine]", " ", "}"}]}], "]"}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellTags->"BindEvent",
 CellLabel->"In[3]:=",
 CellID->31175],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "58", 
   "\[InvisibleSpace]", "\<\" y = \"\>", "\[InvisibleSpace]", "8"}],
  SequenceForm["x = ", 58, " y = ", 8],
  Editable->False]], "Print",
 CellTags->"BindEvent",
 CellLabel->"During evaluation of In[4]:=",
 CellID->9074],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "57", 
   "\[InvisibleSpace]", "\<\" y = \"\>", "\[InvisibleSpace]", "14"}],
  SequenceForm["x = ", 57, " y = ", 14],
  Editable->False]], "Print",
 CellTags->"BindEvent",
 CellLabel->"During evaluation of In[4]:=",
 CellID->5985],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = \"\>", "\[InvisibleSpace]", "57", 
   "\[InvisibleSpace]", "\<\" y = \"\>", "\[InvisibleSpace]", "12"}],
  SequenceForm["x = ", 57, " y = ", 12],
  Editable->False]], "Print",
 CellTags->"BindEvent",
 CellLabel->"During evaluation of In[4]:=",
 CellID->32501]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3554],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InvokeMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/InvokeMethod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetReference",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetReference"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19443]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18759],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->12755],

Cell[TextData[{
 ButtonBox["Scripting GUIs in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/InteractionWithMathematica"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/InteractionWithMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/InteractionWithMathematica"]
}], "Tutorials",
 CellID->133710995],

Cell[TextData[{
 ButtonBox["Scoping of Scripts in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Scoping#335606158"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Scoping#335606158"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Scoping#335606158"]
}], "Tutorials",
 CellID->1631901]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BindEvent - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 22, 42.3231144}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "BindEvent[name | {target, name} | {target, name, filter}, object | \
script | call, ...] binds an event from one object to a listener or to a \
script.", "synonyms" -> {"bind event"}, "title" -> "BindEvent", "type" -> 
    "Symbol", "uri" -> "GUIKit/ref/BindEvent"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "BindEvent"->{
  Cell[4065, 125, 229, 6, 70, "Notes",
   CellTags->"BindEvent",
   CellID->12129],
  Cell[4845, 154, 329, 12, 70, "Notes",
   CellTags->"BindEvent",
   CellID->4872],
  Cell[5177, 168, 771, 27, 70, "Notes",
   CellTags->"BindEvent",
   CellID->7049],
  Cell[5951, 197, 903, 30, 70, "Notes",
   CellTags->"BindEvent",
   CellID->23396],
  Cell[7537, 253, 1179, 32, 70, "Notes",
   CellTags->"BindEvent",
   CellID->10202],
  Cell[8719, 287, 1263, 31, 70, "Notes",
   CellTags->"BindEvent",
   CellID->18775],
  Cell[10617, 341, 749, 20, 70, "Notes",
   CellTags->"BindEvent",
   CellID->14552],
  Cell[12071, 392, 169, 6, 70, "ExampleText",
   CellTags->"BindEvent",
   CellID->15733],
  Cell[12265, 402, 651, 16, 70, "Input",
   CellTags->"BindEvent",
   CellID->31413],
  Cell[12941, 422, 132, 3, 70, "Print",
   CellTags->"BindEvent",
   CellID->19917],
  Cell[13076, 427, 132, 3, 70, "Print",
   CellTags->"BindEvent",
   CellID->15793],
  Cell[13211, 432, 132, 3, 70, "Print",
   CellTags->"BindEvent",
   CellID->21873],
  Cell[13696, 452, 1065, 25, 70, "Input",
   CellTags->"BindEvent",
   CellID->31175],
  Cell[14786, 481, 309, 8, 70, "Print",
   CellTags->"BindEvent",
   CellID->9074],
  Cell[15098, 491, 311, 8, 70, "Print",
   CellTags->"BindEvent",
   CellID->5985],
  Cell[15412, 501, 312, 8, 70, "Print",
   CellTags->"BindEvent",
   CellID->32501]},
 "PrimaryExamplesSection"->{
  Cell[11403, 366, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->274753095]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"BindEvent", 19706, 647},
 {"PrimaryExamplesSection", 21103, 696}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1921, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2544, 71, 46, 1, 70, "ObjectName",
 CellID->9616],
Cell[2593, 74, 957, 29, 70, "Usage",
 CellID->24524]
}, Open  ]],
Cell[CellGroupData[{
Cell[3587, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4065, 125, 229, 6, 70, "Notes",
 CellTags->"BindEvent",
 CellID->12129],
Cell[4297, 133, 189, 5, 70, "Notes",
 CellID->27442],
Cell[4489, 140, 353, 12, 70, "Notes",
 CellID->1984],
Cell[4845, 154, 329, 12, 70, "Notes",
 CellTags->"BindEvent",
 CellID->4872],
Cell[5177, 168, 771, 27, 70, "Notes",
 CellTags->"BindEvent",
 CellID->7049],
Cell[5951, 197, 903, 30, 70, "Notes",
 CellTags->"BindEvent",
 CellID->23396],
Cell[6857, 229, 335, 10, 70, "Notes",
 CellID->18026],
Cell[7195, 241, 339, 10, 70, "Notes",
 CellID->8582],
Cell[7537, 253, 1179, 32, 70, "Notes",
 CellTags->"BindEvent",
 CellID->10202],
Cell[8719, 287, 1263, 31, 70, "Notes",
 CellTags->"BindEvent",
 CellID->18775],
Cell[9985, 320, 66, 1, 70, "Notes",
 CellID->5416],
Cell[10054, 323, 560, 16, 70, "3ColumnTableMod",
 CellID->30665],
Cell[10617, 341, 749, 20, 70, "Notes",
 CellTags->"BindEvent",
 CellID->14552]
}, Closed]],
Cell[CellGroupData[{
Cell[11403, 366, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->274753095],
Cell[CellGroupData[{
Cell[11788, 380, 148, 5, 70, "ExampleSection",
 CellID->392608791],
Cell[11939, 387, 129, 3, 70, "Input",
 CellID->205257257],
Cell[12071, 392, 169, 6, 70, "ExampleText",
 CellTags->"BindEvent",
 CellID->15733],
Cell[CellGroupData[{
Cell[12265, 402, 651, 16, 70, "Input",
 CellTags->"BindEvent",
 CellID->31413],
Cell[CellGroupData[{
Cell[12941, 422, 132, 3, 70, "Print",
 CellTags->"BindEvent",
 CellID->19917],
Cell[13076, 427, 132, 3, 70, "Print",
 CellTags->"BindEvent",
 CellID->15793],
Cell[13211, 432, 132, 3, 70, "Print",
 CellTags->"BindEvent",
 CellID->21873]
}, Open  ]]
}, Open  ]],
Cell[13370, 439, 301, 9, 70, "ExampleText",
 CellID->12060],
Cell[CellGroupData[{
Cell[13696, 452, 1065, 25, 70, "Input",
 CellTags->"BindEvent",
 CellID->31175],
Cell[CellGroupData[{
Cell[14786, 481, 309, 8, 70, "Print",
 CellTags->"BindEvent",
 CellID->9074],
Cell[15098, 491, 311, 8, 70, "Print",
 CellTags->"BindEvent",
 CellID->5985],
Cell[15412, 501, 312, 8, 70, "Print",
 CellTags->"BindEvent",
 CellID->32501]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15797, 517, 310, 9, 70, "SeeAlsoSection",
 CellID->3554],
Cell[16110, 528, 983, 35, 70, "SeeAlso",
 CellID->19443]
}, Open  ]],
Cell[CellGroupData[{
Cell[17130, 568, 314, 9, 70, "TutorialsSection",
 CellID->18759],
Cell[17447, 579, 269, 9, 70, "Tutorials",
 CellID->12755],
Cell[17719, 590, 431, 12, 70, "Tutorials",
 CellID->133710995],
Cell[18153, 604, 406, 12, 70, "Tutorials",
 CellID->1631901]
}, Open  ]],
Cell[18574, 619, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

