(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17821,        650]
NotebookOptionsPosition[     11785,        442]
NotebookOutlinePosition[     14553,        527]
CellTagsIndexPosition[     14435,        521]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "GUI Lifecycles in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/GUILifecycles"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"GUI Lifecycles in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIObject"], "GUIRun" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIRun"], 
          "ReleaseGUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/ReleaseGUIObject"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"GUIObject\"\>", 
       2->"\<\"GUIRun\"\>", 
       3->"\<\"ReleaseGUIObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CloseGUIObject", "ObjectName",
 CellID->16453],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CloseGUIObject", "[", 
       StyleBox["interface", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]closes a live ",
     Cell[BoxData[
      ButtonBox["GUIObject",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
     " instance."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CloseGUIObject", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]requests that an interface close, when called within a \
",
     Cell[BoxData[
      ButtonBox["Script",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
     " block."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->9503]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["CloseGUIObject"], "InlineFormula"],
 " programmatically initiates a close action (which is normally initiated \
interactively by user actions such as closing the window)."
}], "Notes",
 CellID->2307],

Cell[TextData[{
 Cell[BoxData["CloseGUIObject"], "InlineFormula"],
 " will not necessarily force the removal of all interface resources (like ",
 Cell[BoxData[
  ButtonBox["ReleaseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"]], "InlineFormula"],
 ") if an initial ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " has requested that the interface live on past its closing by using the \
option ",
 Cell[BoxData[
  RowBox[{"ReleaseMethod", " ", "->", " ", 
   ButtonBox["Manual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manual"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25518],

Cell[TextData[{
 "Use ",
 Cell[BoxData["CloseGUIObject"], "InlineFormula"],
 " instead of ",
 Cell[BoxData[
  ButtonBox["ReleaseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"]], "InlineFormula"],
 " to ensure the original lifecycle intent of a ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " call."
}], "Notes",
 CellID->18333]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->144230363],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->174656882],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->249568405],

Cell["Create a live interface object: ", "ExampleText",
 CellID->20645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]}]], "Input",
 CellTags->"CloseGUIObject",
 CellLabel->"In[2]:=",
 CellID->3592],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject101402147815425, 
   JLink`Objects`vm1`JavaObject412479062540289]]], "Output",
 CellTags->"CloseGUIObject",
 CellLabel->"Out[2]=",
 CellID->482302236]
}, Open  ]],

Cell["Verify that the interface is active:", "ExampleText",
 CellID->24196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", " ", "]"}]], "Input",
 CellTags->"CloseGUIObject",
 CellLabel->"In[3]:=",
 CellID->6811],

Cell[BoxData["True"], "Output",
 CellTags->"CloseGUIObject",
 CellLabel->"Out[3]=",
 CellID->15535]
}, Open  ]],

Cell["Request that the window close:", "ExampleText",
 CellID->15835],

Cell[BoxData[
 RowBox[{"CloseGUIObject", "[", "ref", " ", "]"}]], "Input",
 CellTags->"CloseGUIObject",
 CellLabel->"In[4]:=",
 CellID->1229],

Cell["Confirm that the interface is no longer valid:", "ExampleText",
 CellID->3716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", " ", "]"}]], "Input",
 CellTags->"CloseGUIObject",
 CellLabel->"In[5]:=",
 CellID->23532],

Cell[BoxData["False"], "Output",
 CellTags->"CloseGUIObject",
 CellLabel->"Out[5]=",
 CellID->24956]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29749],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->160911545],

Cell["Create an interface that stays active after being closed:", \
"ExampleText",
 CellID->23296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"\"\<Wolfram/Example/Calculator\>\"", ",", " ", 
    RowBox[{"ReleaseMethod", "\[Rule]", "Manual"}]}], "]"}]}]], "Input",
 CellTags->"CloseGUIObject",
 CellLabel->"In[2]:=",
 CellID->19724],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject249506578825217, 
   JLink`Objects`vm1`JavaObject48481439842305]]], "Output",
 CellTags->"CloseGUIObject",
 CellLabel->"Out[2]=",
 CellID->252025463]
}, Open  ]],

Cell["Request that the window close:", "ExampleText",
 CellID->24526],

Cell[BoxData[
 RowBox[{"CloseGUIObject", "[", "ref", " ", "]"}]], "Input",
 CellTags->"CloseGUIObject",
 CellLabel->"In[3]:=",
 CellID->16406],

Cell["Verify that the interface is still active:", "ExampleText",
 CellID->8983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", " ", "]"}]], "Input",
 CellTags->"CloseGUIObject",
 CellLabel->"In[4]:=",
 CellID->3445],

Cell[BoxData["True"], "Output",
 CellTags->"CloseGUIObject",
 CellLabel->"Out[4]=",
 CellID->459511350]
}, Open  ]],

Cell["Force complete termination of the interface:", "ExampleText",
 CellID->21691],

Cell[BoxData[
 RowBox[{"ReleaseGUIObject", "[", "ref", " ", "]"}]], "Input",
 CellTags->"CloseGUIObject",
 CellLabel->"In[5]:=",
 CellID->26588],

Cell["Verify that the interface is no longer active:", "ExampleText",
 CellID->30538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", " ", "]"}]], "Input",
 CellTags->"CloseGUIObject",
 CellLabel->"In[6]:=",
 CellID->20664],

Cell[BoxData["False"], "Output",
 CellTags->"CloseGUIObject",
 CellLabel->"Out[6]=",
 CellID->312947457]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23144],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIRun",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIRun"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseGUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17659]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27437],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->20695],

Cell[TextData[{
 ButtonBox["GUI Lifecycles in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/GUILifecycles"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/GUILifecycles"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/GUILifecycles"]
}], "Tutorials",
 CellID->314964108]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CloseGUIObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 22, 43.8230376}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "CloseGUIObject[interface] closes a live GUIObject instance. \
CloseGUIObject[] requests that an interface close, when called within a \
Script block.", "synonyms" -> {"close object"}, "title" -> "CloseGUIObject", 
    "type" -> "Symbol", "uri" -> "GUIKit/ref/CloseGUIObject"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5126, 169, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->144230363]},
 "CloseGUIObject"->{
  Cell[5890, 200, 197, 6, 70, "Input",
   CellTags->"CloseGUIObject",
   CellID->3592],
  Cell[6090, 208, 307, 8, 70, "Output",
   CellTags->"CloseGUIObject",
   CellID->482302236],
  Cell[6512, 224, 137, 4, 70, "Input",
   CellTags->"CloseGUIObject",
   CellID->6811],
  Cell[6652, 230, 99, 3, 70, "Output",
   CellTags->"CloseGUIObject",
   CellID->15535],
  Cell[6838, 239, 141, 4, 70, "Input",
   CellTags->"CloseGUIObject",
   CellID->1229],
  Cell[7091, 250, 138, 4, 70, "Input",
   CellTags->"CloseGUIObject",
   CellID->23532],
  Cell[7232, 256, 100, 3, 70, "Output",
   CellTags->"CloseGUIObject",
   CellID->24956],
  Cell[7855, 285, 272, 7, 70, "Input",
   CellTags->"CloseGUIObject",
   CellID->19724],
  Cell[8130, 294, 306, 8, 70, "Output",
   CellTags->"CloseGUIObject",
   CellID->252025463],
  Cell[8523, 308, 142, 4, 70, "Input",
   CellTags->"CloseGUIObject",
   CellID->16406],
  Cell[8773, 319, 137, 4, 70, "Input",
   CellTags->"CloseGUIObject",
   CellID->3445],
  Cell[8913, 325, 103, 3, 70, "Output",
   CellTags->"CloseGUIObject",
   CellID->459511350],
  Cell[9117, 334, 144, 4, 70, "Input",
   CellTags->"CloseGUIObject",
   CellID->26588],
  Cell[9374, 345, 138, 4, 70, "Input",
   CellTags->"CloseGUIObject",
   CellID->20664],
  Cell[9515, 351, 104, 3, 70, "Output",
   CellTags->"CloseGUIObject",
   CellID->312947457]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12918, 468},
 {"CloseGUIObject", 13059, 472}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1599, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2222, 66, 52, 1, 70, "ObjectName",
 CellID->16453],
Cell[2277, 69, 902, 28, 70, "Usage",
 CellID->9503]
}, Open  ]],
Cell[CellGroupData[{
Cell[3216, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3694, 119, 230, 5, 70, "Notes",
 CellID->2307],
Cell[3927, 126, 713, 21, 70, "Notes",
 CellID->25518],
Cell[4643, 149, 446, 15, 70, "Notes",
 CellID->18333]
}, Closed]],
Cell[CellGroupData[{
Cell[5126, 169, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->144230363],
Cell[CellGroupData[{
Cell[5511, 183, 148, 5, 70, "ExampleSection",
 CellID->174656882],
Cell[5662, 190, 129, 3, 70, "Input",
 CellID->249568405],
Cell[5794, 195, 71, 1, 70, "ExampleText",
 CellID->20645],
Cell[CellGroupData[{
Cell[5890, 200, 197, 6, 70, "Input",
 CellTags->"CloseGUIObject",
 CellID->3592],
Cell[6090, 208, 307, 8, 70, "Output",
 CellTags->"CloseGUIObject",
 CellID->482302236]
}, Open  ]],
Cell[6412, 219, 75, 1, 70, "ExampleText",
 CellID->24196],
Cell[CellGroupData[{
Cell[6512, 224, 137, 4, 70, "Input",
 CellTags->"CloseGUIObject",
 CellID->6811],
Cell[6652, 230, 99, 3, 70, "Output",
 CellTags->"CloseGUIObject",
 CellID->15535]
}, Open  ]],
Cell[6766, 236, 69, 1, 70, "ExampleText",
 CellID->15835],
Cell[6838, 239, 141, 4, 70, "Input",
 CellTags->"CloseGUIObject",
 CellID->1229],
Cell[6982, 245, 84, 1, 70, "ExampleText",
 CellID->3716],
Cell[CellGroupData[{
Cell[7091, 250, 138, 4, 70, "Input",
 CellTags->"CloseGUIObject",
 CellID->23532],
Cell[7232, 256, 100, 3, 70, "Output",
 CellTags->"CloseGUIObject",
 CellID->24956]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7381, 265, 216, 7, 70, "ExampleSection",
 CellID->29749],
Cell[7600, 274, 129, 3, 70, "Input",
 CellID->160911545],
Cell[7732, 279, 98, 2, 70, "ExampleText",
 CellID->23296],
Cell[CellGroupData[{
Cell[7855, 285, 272, 7, 70, "Input",
 CellTags->"CloseGUIObject",
 CellID->19724],
Cell[8130, 294, 306, 8, 70, "Output",
 CellTags->"CloseGUIObject",
 CellID->252025463]
}, Open  ]],
Cell[8451, 305, 69, 1, 70, "ExampleText",
 CellID->24526],
Cell[8523, 308, 142, 4, 70, "Input",
 CellTags->"CloseGUIObject",
 CellID->16406],
Cell[8668, 314, 80, 1, 70, "ExampleText",
 CellID->8983],
Cell[CellGroupData[{
Cell[8773, 319, 137, 4, 70, "Input",
 CellTags->"CloseGUIObject",
 CellID->3445],
Cell[8913, 325, 103, 3, 70, "Output",
 CellTags->"CloseGUIObject",
 CellID->459511350]
}, Open  ]],
Cell[9031, 331, 83, 1, 70, "ExampleText",
 CellID->21691],
Cell[9117, 334, 144, 4, 70, "Input",
 CellTags->"CloseGUIObject",
 CellID->26588],
Cell[9264, 340, 85, 1, 70, "ExampleText",
 CellID->30538],
Cell[CellGroupData[{
Cell[9374, 345, 138, 4, 70, "Input",
 CellTags->"CloseGUIObject",
 CellID->20664],
Cell[9515, 351, 104, 3, 70, "Output",
 CellTags->"CloseGUIObject",
 CellID->312947457]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9680, 361, 311, 9, 70, "SeeAlsoSection",
 CellID->23144],
Cell[9994, 372, 731, 26, 70, "SeeAlso",
 CellID->17659]
}, Open  ]],
Cell[CellGroupData[{
Cell[10762, 403, 314, 9, 70, "TutorialsSection",
 CellID->27437],
Cell[11079, 414, 269, 9, 70, "Tutorials",
 CellID->20695],
Cell[11351, 425, 392, 12, 70, "Tutorials",
 CellID->314964108]
}, Open  ]],
Cell[11758, 440, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

