(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14906,        502]
NotebookOptionsPosition[     10260,        347]
NotebookOutlinePosition[     12762,        421]
CellTagsIndexPosition[     12644,        415]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"GUIKit User Guide" :> 
         Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
         "Widget Basics in GUIKit User Guide" :> 
         Documentation`HelpLookup["paclet:GUIKit/tutorial/WidgetBasics"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
      2->"\<\"Widget Basics in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GUIInformation", "ObjectName",
 CellID->27580],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUIInformation", "[", 
       StyleBox["obj", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns information about a live interface object."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUIInformation", "[", 
       RowBox[{
        StyleBox["obj", "TI"], ",", 
        StyleBox["target", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns information about a specific widget in the \
interface."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUIInformation", "[", 
       RowBox[{
        StyleBox["obj", "TI"], ",", 
        StyleBox["target", "TI"], ",", 
        StyleBox["sets", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns only specific rule sets of information."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->32471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GUIInformation"], "InlineFormula"],
 " can be used within scripts or with a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " instance to find information about specific widgets or their properties."
}], "Notes",
 CellTags->"GUIInformation",
 CellID->21778]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->109796229],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->609882285],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->8255592],

Cell["Run an interface definition:", "ExampleText",
 CellID->24815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/AngleDialog\>\"", "]"}]}]], "Input",
 CellTags->"GUIInformation",
 CellLabel->"In[2]:=",
 CellID->6064],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject124804266983425, 
   JLink`Objects`vm1`JavaObject412479062540289]]], "Output",
 CellTags->"GUIInformation",
 CellLabel->"Out[2]=",
 CellID->387617073]
}, Open  ]],

Cell["Get information about the object:", "ExampleText",
 CellID->29472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIInformation", "[", "ref", "]"}]], "Input",
 CellTags->"GUIInformation",
 CellLabel->"In[3]:=",
 CellID->27479],

Cell[BoxData[
 RowBox[{"\<\"WidgetNames\"\>", "\[Rule]", 
  RowBox[{"{", 
   RowBox[{"\<\"actionMap\"\>", ",", "\<\"cancelAction\"\>", 
    ",", "\<\"cancelButton\"\>", ",", "\<\"degreesButton\"\>", 
    ",", "\<\"frame\"\>", ",", "\<\"inputField\"\>", ",", "\<\"inputMap\"\>", 
    ",", "\<\"okButton\"\>", ",", "\<\"radiansButton\"\>", 
    ",", "\<\"rootPane\"\>"}], "}"}]}]], "Output",
 CellTags->"GUIInformation",
 CellLabel->"Out[3]=",
 CellID->19593]
}, Open  ]],

Cell[TextData[{
 "Get information about the ",
 Cell[BoxData["\"\<okButton\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"GUIInformation",
 CellID->32482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GUIInformation", "[", 
   RowBox[{"ref", ",", " ", "\"\<okButton\>\""}], "]"}], " ", "//", " ", 
  "Shallow"}]], "Input",
 CellTags->"GUIInformation",
 CellLabel->"In[4]:=",
 CellID->3005],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"MethodNames\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[LeftSkeleton]", "324", "\[RightSkeleton]"}], "}"}]}], ",", 
   RowBox[{"\<\"EventNames\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[LeftSkeleton]", "45", "\[RightSkeleton]"}], "}"}]}], ",", 
   RowBox[{"\<\"PropertyNames\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[LeftSkeleton]", "128", "\[RightSkeleton]"}], "}"}]}]}], 
  "}"}]], "Output",
 CellTags->"GUIInformation",
 CellLabel->"Out[4]//Shallow=",
 CellID->18536]
}, Open  ]],

Cell["Ask for specific sets of information:", "ExampleText",
 CellTags->"GUIInformation",
 CellID->15333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIInformation", "[", 
  RowBox[{"ref", ",", " ", "\"\<okButton\>\"", ",", 
   RowBox[{"{", "\"\<EventNames\>\"", "}"}]}], "]"}]], "Input",
 CellTags->"GUIInformation",
 CellLabel->"In[5]:=",
 CellID->11105],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"EventNames\"\>", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"\<\"Action\"\>", ",", "\<\"ActionPerformed\"\>", 
     ",", "\<\"Ancestor\"\>", ",", "\<\"AncestorAdded\"\>", 
     ",", "\<\"AncestorMoved\"\>", ",", "\<\"AncestorRemoved\"\>", 
     ",", "\<\"AncestorResized\"\>", ",", "\<\"CaretPositionChanged\"\>", 
     ",", "\<\"Change\"\>", ",", "\<\"Component\"\>", 
     ",", "\<\"ComponentAdded\"\>", ",", "\<\"ComponentHidden\"\>", 
     ",", "\<\"ComponentMoved\"\>", ",", "\<\"ComponentRemoved\"\>", 
     ",", "\<\"ComponentResized\"\>", ",", "\<\"ComponentShown\"\>", 
     ",", "\<\"Container\"\>", ",", "\<\"Focus\"\>", 
     ",", "\<\"FocusGained\"\>", ",", "\<\"FocusLost\"\>", 
     ",", "\<\"Hierarchy\"\>", ",", "\<\"HierarchyBounds\"\>", 
     ",", "\<\"HierarchyChanged\"\>", ",", "\<\"InputMethod\"\>", 
     ",", "\<\"InputMethodTextChanged\"\>", ",", "\<\"Item\"\>", 
     ",", "\<\"ItemStateChanged\"\>", ",", "\<\"Key\"\>", 
     ",", "\<\"KeyPressed\"\>", ",", "\<\"KeyReleased\"\>", 
     ",", "\<\"KeyTyped\"\>", ",", "\<\"Mouse\"\>", 
     ",", "\<\"MouseClicked\"\>", ",", "\<\"MouseDragged\"\>", 
     ",", "\<\"MouseEntered\"\>", ",", "\<\"MouseExited\"\>", 
     ",", "\<\"MouseMotion\"\>", ",", "\<\"MouseMoved\"\>", 
     ",", "\<\"MousePressed\"\>", ",", "\<\"MouseReleased\"\>", 
     ",", "\<\"MouseWheel\"\>", ",", "\<\"MouseWheelMoved\"\>", 
     ",", "\<\"PropertyChange\"\>", ",", "\<\"StateChanged\"\>", 
     ",", "\<\"VetoableChange\"\>"}], "}"}]}], "}"}]], "Output",
 CellTags->"GUIInformation",
 CellLabel->"Out[5]=",
 CellID->27587]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24745],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIRun",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIRun"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "Extensions",
 CellID->4698]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27440],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->18456],

Cell[TextData[{
 ButtonBox["Widget Basics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics"]
}], "Tutorials",
 CellID->449844216]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIInformation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 22, 45.8229352}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "GUIInformation[obj] returns information about a live interface object. \
GUIInformation[obj, target] returns information about a specific widget in \
the interface. GUIInformation[obj, target, sets] returns only specific rule \
sets of information.", "synonyms" -> {}, "title" -> "GUIInformation", "type" -> 
    "Symbol", "uri" -> "GUIKit/ref/GUIInformation"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "GUIInformation"->{
  Cell[2993, 99, 372, 10, 70, "Notes",
   CellTags->"GUIInformation",
   CellID->21778],
  Cell[4160, 145, 198, 6, 70, "Input",
   CellTags->"GUIInformation",
   CellID->6064],
  Cell[4361, 153, 307, 8, 70, "Output",
   CellTags->"GUIInformation",
   CellID->387617073],
  Cell[4780, 169, 137, 4, 70, "Input",
   CellTags->"GUIInformation",
   CellID->27479],
  Cell[4920, 175, 457, 10, 70, "Output",
   CellTags->"GUIInformation",
   CellID->19593],
  Cell[5392, 188, 168, 6, 70, "ExampleText",
   CellTags->"GUIInformation",
   CellID->32482],
  Cell[5585, 198, 223, 7, 70, "Input",
   CellTags->"GUIInformation",
   CellID->3005],
  Cell[5811, 207, 553, 15, 70, "Output",
   CellTags->"GUIInformation",
   CellID->18536],
  Cell[6379, 225, 105, 2, 70, "ExampleText",
   CellTags->"GUIInformation",
   CellID->15333],
  Cell[6509, 231, 231, 6, 70, "Input",
   CellTags->"GUIInformation",
   CellID->11105],
  Cell[6743, 239, 1621, 29, 70, "Output",
   CellTags->"GUIInformation",
   CellID->27587]},
 "PrimaryExamplesSection"->{
  Cell[3402, 114, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->109796229]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"GUIInformation", 11470, 374},
 {"PrimaryExamplesSection", 12501, 408}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 766, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1389, 44, 52, 1, 70, "ObjectName",
 CellID->27580],
Cell[1444, 47, 1034, 30, 70, "Usage",
 CellID->32471]
}, Open  ]],
Cell[CellGroupData[{
Cell[2515, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2993, 99, 372, 10, 70, "Notes",
 CellTags->"GUIInformation",
 CellID->21778]
}, Closed]],
Cell[CellGroupData[{
Cell[3402, 114, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->109796229],
Cell[CellGroupData[{
Cell[3787, 128, 148, 5, 70, "ExampleSection",
 CellID->609882285],
Cell[3938, 135, 127, 3, 70, "Input",
 CellID->8255592],
Cell[4068, 140, 67, 1, 70, "ExampleText",
 CellID->24815],
Cell[CellGroupData[{
Cell[4160, 145, 198, 6, 70, "Input",
 CellTags->"GUIInformation",
 CellID->6064],
Cell[4361, 153, 307, 8, 70, "Output",
 CellTags->"GUIInformation",
 CellID->387617073]
}, Open  ]],
Cell[4683, 164, 72, 1, 70, "ExampleText",
 CellID->29472],
Cell[CellGroupData[{
Cell[4780, 169, 137, 4, 70, "Input",
 CellTags->"GUIInformation",
 CellID->27479],
Cell[4920, 175, 457, 10, 70, "Output",
 CellTags->"GUIInformation",
 CellID->19593]
}, Open  ]],
Cell[5392, 188, 168, 6, 70, "ExampleText",
 CellTags->"GUIInformation",
 CellID->32482],
Cell[CellGroupData[{
Cell[5585, 198, 223, 7, 70, "Input",
 CellTags->"GUIInformation",
 CellID->3005],
Cell[5811, 207, 553, 15, 70, "Output",
 CellTags->"GUIInformation",
 CellID->18536]
}, Open  ]],
Cell[6379, 225, 105, 2, 70, "ExampleText",
 CellTags->"GUIInformation",
 CellID->15333],
Cell[CellGroupData[{
Cell[6509, 231, 231, 6, 70, "Input",
 CellTags->"GUIInformation",
 CellID->11105],
Cell[6743, 239, 1621, 29, 70, "Output",
 CellTags->"GUIInformation",
 CellID->27587]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8425, 275, 311, 9, 70, "SeeAlsoSection",
 CellID->24745],
Cell[8739, 286, 465, 17, 70, "Extensions",
 CellID->4698]
}, Open  ]],
Cell[CellGroupData[{
Cell[9241, 308, 314, 9, 70, "TutorialsSection",
 CellID->27440],
Cell[9558, 319, 269, 9, 70, "Tutorials",
 CellID->18456],
Cell[9830, 330, 388, 12, 70, "Tutorials",
 CellID->449844216]
}, Open  ]],
Cell[10233, 345, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

