(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49347,       1271]
NotebookOptionsPosition[     36771,        906]
NotebookOutlinePosition[     44525,       1111]
CellTagsIndexPosition[     43890,       1094]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Widget Basics in GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/WidgetBasics"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Widget Basics in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIObject"], "GUIRun" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIRun"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GUIObject\"\>", 
       2->"\<\"GUIRun\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GUIScreenShot", "ObjectName",
 CellID->5881],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUIScreenShot", "[", 
       StyleBox["interface", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a graphic that captures the current state of \
the runtime user interface."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13467]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["interface", "TI"]], "InlineFormula"],
 " can be a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 ", a ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " Java user interface object, an interface expression, or a name of a widget \
definition."
}], "Notes",
 CellTags->"GUIScreenShot",
 CellID->26721],

Cell[TextData[{
 "When the argument is a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 ", the state of the interface is captured and left unchanged. "
}], "Notes",
 CellTags->"GUIScreenShot",
 CellID->16952],

Cell["\<\
When the argument is a widget definition expression, it is created, captured, \
and then closed.\
\>", "Notes",
 CellTags->"GUIScreenShot",
 CellID->17322],

Cell["\<\
When the argument is a widget, a screenshot is generated of only the \
requested widget, without the underlying native window.\
\>", "Notes",
 CellTags->"GUIScreenShot",
 CellID->1828],

Cell[TextData[{
 "When the argument consists of screen coordinates of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["xmin", "TI"], ",", 
      StyleBox["xmax", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["ymin", "TI"], ",", 
      StyleBox["ymax", "TI"]}], "}"}]}], "}"}]], "InlineFormula"],
 ", a rectangle from the current screen is captured."
}], "Notes",
 CellTags->"GUIScreenShot",
 CellID->18230],

Cell["\<\
When no arguments are given, the contents of the entire screen are captured.\
\>", "Notes",
 CellID->429],

Cell[TextData[{
 Cell[BoxData["GUIScreenShot"], "InlineFormula"],
 " is useful for creating previews of a definition within a notebook, \
documenting changes during the runtime of an interface, and also as an easy \
way of exchanging and submitting bug and problem reports to others. "
}], "Notes",
 CellTags->"GUIScreenShot",
 CellID->21424]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->653988360],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->297586527],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->287190376],

Cell["Run an interface definition:", "ExampleText",
 CellID->18213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/PrimeFinder\>\"", "]"}]}]], "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,22"},
 CellLabel->"In[2]:=",
 CellID->5202],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject327239967178753, 
   JLink`Objects`JavaObject331119731933185]]], "Output",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,22"},
 CellLabel->"Out[2]=",
 CellID->8658]
}, Open  ]],

Cell["Take a screenshot of the original interface:", "ExampleText",
 CellID->4202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,23"},
 CellLabel->"In[3]:=",
 CellID->23753],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{149, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,23"},
 CellLabel->"Out[3]=",
 CellID->372817032]
}, Open  ]],

Cell["Change the value and take another screenshot:", "ExampleText",
 CellID->5058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<WidgetNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", "ref", "]"}]}]], "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,24"},
 CellLabel->"In[4]:=",
 CellID->16575],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"nextButton\"\>", ",", "\<\"previousButton\"\>", 
   ",", "\<\"primeIndicator\"\>", ",", "\<\"valueField\"\>"}], 
  "}"}]], "Output",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,24"},
 CellLabel->"Out[4]=",
 CellID->8090]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<valueField\>\"", ",", " ", "\"\<text\>\""}], "}"}], ",", 
    " ", 
    RowBox[{"ToString", "[", 
     RowBox[{
      RowBox[{"6", "!"}], ",", " ", "InputForm"}], "]"}]}], "]"}]}]], "Input",\

 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,25"},
 CellLabel->"In[5]:=",
 CellID->24638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,26"},
 CellLabel->"In[6]:=",
 CellID->6823],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{149, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,26"},
 CellLabel->"Out[6]=",
 CellID->63089195]
}, Open  ]],

Cell["Take a screenshot of just a widget: ", "ExampleText",
 CellTags->"GUIScreenShot",
 CellID->24701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", 
  RowBox[{"ref", " ", "@", " ", 
   RowBox[{"WidgetReference", "[", "\"\<valueField\>\"", "]"}]}], 
  "]"}]], "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,27"},
 CellLabel->"In[7]:=",
 CellID->17205],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw9AKxiAIDiP0fyIQS
vf/r5+4EMphB9H8oYOgEkYwDLlUMJplBLoWLMYFIVpAQmAWWZCfNCGZcxjKw
IotBJICAjTTjWfAYhc1qFtzGl+A0ngXFeOqYzIomRoaDS3E6mArGEvQzGSYX
gUi05MQMZ+FJWAOVRWAZlhEAATZtrw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,27"},
 CellLabel->"Out[7]=",
 CellID->274981480]
}, Open  ]],

Cell["Capture a portion of the current screen:", "ExampleText",
 CellID->3123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"100", ",", "150"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"200", ",", "450"}], "}"}]}], "}"}], "]"}]], "Input",
 CellTags->"Ex--21907744555570480354,29",
 CellLabel->"In[8]:=",
 CellID->24287],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztGFtoXEV0dmfvbqMrvkDxkRAQsR+6Sr9twR/1J/jrbyhi8yFKzZ9UQRQR
pSBUULCQgEJFohQrVi1CBR8QbS32o0hTtXU37W62u5tNtjEGjjNn3nPn3huT
diOyCzNz5pw5jzmPmbk7Nj6556lnxicndo+PPrZ3/Lk9E7ufH3302b0MRXOE
kB2srY4SDgMDZbcD2I8RU4abcaB8PcgfGckklfhQ4JSihgocwtU0wJjnfR7N
ogIjiBYhEmiUyCYWt2JIpeU3SBPWFhwakVuM7bSvuq/DwfVjYTNWoJuzbXU1
RpYjqLYuI+QEqeuI9j0BjWWbFDZUuCY1s6/qQPWecQdFb2tiRmLrIhdnoJzk
NKGXYoyDqAt5WQLxajIJ5ZeeClVQmmRFdA6FrNOsUpIRRU0wWiMXJ1WExOJK
6lI9iSH3i2zz89yT7SWs5Q/XZTSYuo5QT71FyLDBQEWdImLTSlhA5abTJ3Gr
d/rhGHKz925Bvza1he4aVKFhHVThoAr7XIW3Bcy5I5MUczy5Rq9CVdOaZxv2
W/4+FCyCZ0seidKA1AdS39+OOV0XpjgkoBrG7yo+JAnZHtirfEJvTzFYvkD7
9oZMH146+MX/0YjBlR03a3BlW+oHV/Zmh6KOjYmSF4JQJWWe5Sbc5lQnZAiH
2G2UdrcUA95LWx+FVUgDTPUkvijiJR+5scm8bvPBvYc2kv6s2eid/2//pImZ
av6uoRqy7mI5mjh7Be7dynaRPuSrykZs9bVGbn2Te4SMTLF9jUwjxLphnE5R
BU07EC4enuZuKDxyhiF2zV0PZOdZDp1lpJ1zJT5FSOF2CRznKT1RrwB5vMP1
L1w64w8FHEQQGYSzvAwSnys8Op8TS/ZSm2xYKQepYXGlhzTiLBIWIXfIBI2O
fLRMRyHdNilgAlEGerjiOtaJHaKVYoh8BySKF+uLSc4LsUTrdF7IybRvVhaM
MJ0FIcvlhYlmsSQKRNCzzLXaSTBPXT49zrGU8M3LCPUGrHX9GYV4s0pF539K
qXiSFduNAba7ksv9hgDupgBumxARPEbSh//SN0XAQJaWzfqv0Gr+Bt3OPPSW
m3Cl14KVXnsUVq60y7C62sNo1Gun0Rv73v0I7n3yFXauPjyJhOofJ+Hp16bg
vrFXYWzf8QpMvHwZo3vh3I9w+9iL8PrMn+RB7Lm2C+dmOSufY2s0qrDQqN7P
uhrKUwveYETWKtBu1x3C/k9qsP/jKic0HMJbh+dZq5Wh01mQ8WOQnMVxed7L
i5fPI5uKTaSxWoUyMHNzuN5WfeDIRTjw6UWuuqnVNOWM95GNw0akyHSakZWE
4wY2zbePsuido3XWLpVhcVFxMEjOeB/ZOGziKnDXCw1xHE3E2Ua891UdDh5r
lKHbvSwfvAySpxKDVIsMjWoaScDRRJyteurrBd646pY81Rmkm5znleKWvNwD
a7SClvRZmEYDONugD4434f1vmmVYWmoT/E7hkG5qbo3MMAbJE5JzldK4Yqup
vZrlLO9tgz78tgWHvmMlvrzckTtjkG5c5DDSbKaZH9ow832nDL3eIobxFg5J
XQzC2RD2Ntvh2UXeKozQdQhHfurCZye6FVhZ6TmEz39egqOnlirsAPoLT/vz
c4Lw5S/LrPVgbW2NPMD6v+VhM8uPJTh2uscOG94r7AtvH+JnE8OemBfFXv39
JNTOn0KKdZTl/gHGzmxv\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{50, 250},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907744555570480354,29",
 CellLabel->"Out[8]=",
 CellID->361764511]
}, Open  ]],

Cell["Capture the entire screen:", "ExampleText",
 CellID->14026],

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "]"}]], "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,30"},
 CellLabel->"In[9]:=",
 CellID->2530]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14820],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->160911545],

Cell[TextData[{
 Cell[BoxData["GUIScreenShot"], "InlineFormula"],
 " works with any active user interface ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " produced by any ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " code:"
}], "ExampleText",
 CellID->7043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/PrimeFinder\>\"", "]"}]}]], "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,32"},
 CellLabel->"In[2]:=",
 CellID->12531],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject119429182521345, 
   JLink`Objects`JavaObject499516910338049]]], "Output",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,32"},
 CellLabel->"Out[2]=",
 CellID->25674]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"obj", " ", "=", " ", 
  RowBox[{"ref", " ", "@", " ", 
   RowBox[{
   "WidgetReference", "[", "\"\<previousButton\>\"", "]"}]}]}]], "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,33"},
 CellLabel->"In[3]:=",
 CellID->3902],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"javax", ".", "swing", ".", "JButton"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject96191664619521]], "Output",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,33"},
 CellLabel->"Out[3]=",
 CellID->8100]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "obj", "]"}]], "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,34"},
 CellLabel->"In[4]:=",
 CellID->23071],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVVc1rE1EQf8luFGmo4MWTpSD+Ad4VsRUVpUfBaynSFr9rb6WeBAU9CKLg
rVgEURAEqadSoYpQP1q1qdo2n2026W52Nx/NJt22GWcmu0naZqUGZjIfv5n3
m/eW97q6B/suXe0e7O/pbj8z0H2jr7/nVvvp6wMYknxCiPMoB9sF2YCmq/aA
rs6DqUehkEuBVdShZJlQtrLtUC5l28C2LYksQToPa+U8/ueED0si2EAGVZmF
zMpvGH76Co5cvNMJ4tgggg923YYrD55DcVVDcMkyGJyMT0Pv3RE4d/MRjL5+
exLmZj6KAIRmPkBoehLevBuDs9cewuX7o1hEpQIJLkW+cLuJT1OQiM5BLDIL
8UjoBDlYjCZEF3/Awq+vMDY+TlAsLuQULJaw+DMxgoymCD9oWhJjGS1JPseO
sw5QBlbScVhOzEMsPMtT+CBnJLZ0yWY10YlaxVlMIw0qV/yhnA+yRpyHdMG5
XIakg6sQb66Api5BMrHg4mNb8Pm8ThKkIlyTjsdpgd7OmJ80h2T2A41ZFjrh
Oop7+Dkou2kXyoBWbiMTXdyUZVCWFr2IGiREVK+R0h2PdKAxxiIcAv/O1Xt5
xWgc3V9Pu8lqYhuZFtY0UIbPXFkKNx+oUDBIgrT9Tg/nMNAjHWiMsQj+NLfi
qwR3xqRdxMjbXktelVP1wPRMElLLHjOsrpokQRpEBmaClmDTHZAkUM9JtZzw
iEm7iJHHJ7LfWZCoG7oC6WTEi2qWhKiauInVRmZNHN/vEjXFXi9MjZDpHFHz
nPTfMfJaWMv8uRt6CueJNp+nWMyRBGkosY97OCOyuH7DP86FlgSu5UzoUbUD
HWiGbkC1MkrmSeiaWlFizZlbVh6Z54NE3+nqDMNCXY9yTuZVsniFqSnPXgWS
IDXlr+4AWc6e0kLkHWItc/dcVgUNL1CPbqskHdSS8XnEa4hPNOLrN3O5XMKb
uVy2EFwqFfH+N/BlU5qDbdtGsG2vIdi2y/jS5BGjNoIDkAhXwZubGywbGxui
A/U6Nlpft8HCouorga9nrT0+gTDxbVGcgkqlgrFKZRP9BYojEt/a2pRDj1/A
heFn8H463An4Q3AomubQ0JOXCFZToeqjGZsGJfGdC7a9sL33RiC9/BPBpIkD
FnEBsheHIb441QbhuUmJLMzSTLQ2ImoL+P4C9eocqg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{75, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,34"},
 CellLabel->"Out[4]=",
 CellID->210605562]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5041],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIRun",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIRun"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15264]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17699],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->18456],

Cell[TextData[{
 ButtonBox["Widget Basics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics"]
}], "Tutorials",
 CellID->449844216]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIScreenShot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 22, 53.9006466}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "GUIScreenShot[interface] generates a graphic that captures the current \
state of the runtime user interface.", "synonyms" -> {"screen shot"}, "title" -> 
    "GUIScreenShot", "type" -> "Symbol", "uri" -> "GUIKit/ref/GUIScreenShot"},
   "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "GUIScreenShot"->{
  Cell[3079, 100, 426, 15, 70, "Notes",
   CellTags->"GUIScreenShot",
   CellID->26721],
  Cell[3508, 117, 293, 9, 70, "Notes",
   CellTags->"GUIScreenShot",
   CellID->16952],
  Cell[3804, 128, 165, 5, 70, "Notes",
   CellTags->"GUIScreenShot",
   CellID->17322],
  Cell[3972, 135, 194, 5, 70, "Notes",
   CellTags->"GUIScreenShot",
   CellID->1828],
  Cell[4169, 142, 483, 16, 70, "Notes",
   CellTags->"GUIScreenShot",
   CellID->18230],
  Cell[4773, 165, 342, 7, 70, "Notes",
   CellTags->"GUIScreenShot",
   CellID->21424],
  Cell[5912, 208, 230, 6, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,22"},
   CellID->5202],
  Cell[6145, 216, 326, 8, 70, "Output",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,22"},
   CellID->8658],
  Cell[6593, 232, 168, 4, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,23"},
   CellID->23753],
  Cell[6764, 238, 9805, 165, 70, "Output",
   Evaluatable->False,
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,23"},
   CellID->372817032],
  Cell[16692, 411, 221, 5, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,24"},
   CellID->16575],
  Cell[16916, 418, 275, 7, 70, "Output",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,24"},
   CellID->8090],
  Cell[17206, 428, 422, 13, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,25"},
   CellID->24638],
  Cell[17653, 445, 167, 4, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,26"},
   CellID->6823],
  Cell[17823, 451, 9865, 166, 70, "Output",
   Evaluatable->False,
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,26"},
   CellID->63089195],
  Cell[27703, 620, 103, 2, 70, "ExampleText",
   CellTags->"GUIScreenShot",
   CellID->24701],
  Cell[27831, 626, 264, 7, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,27"},
   CellID->17205],
  Cell[28098, 635, 488, 12, 70, "Output",
   Evaluatable->False,
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,27"},
   CellID->274981480],
  Cell[31076, 710, 160, 4, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,30"},
   CellID->2530],
  Cell[31996, 749, 231, 6, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,32"},
   CellID->12531],
  Cell[32230, 757, 327, 8, 70, "Output",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,32"},
   CellID->25674],
  Cell[32594, 770, 263, 7, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,33"},
   CellID->3902],
  Cell[32860, 779, 335, 9, 70, "Output",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,33"},
   CellID->8100],
  Cell[33232, 793, 168, 4, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,34"},
   CellID->23071],
  Cell[33403, 799, 1475, 28, 70, "Output",
   Evaluatable->False,
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,34"},
   CellID->210605562]},
 "PrimaryExamplesSection"->{
  Cell[5152, 177, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->653988360]},
 "Ex--21907744555570480354,22"->{
  Cell[5912, 208, 230, 6, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,22"},
   CellID->5202],
  Cell[6145, 216, 326, 8, 70, "Output",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,22"},
   CellID->8658]},
 "Ex--21907744555570480354,23"->{
  Cell[6593, 232, 168, 4, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,23"},
   CellID->23753],
  Cell[6764, 238, 9805, 165, 70, "Output",
   Evaluatable->False,
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,23"},
   CellID->372817032]},
 "Ex--21907744555570480354,24"->{
  Cell[16692, 411, 221, 5, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,24"},
   CellID->16575],
  Cell[16916, 418, 275, 7, 70, "Output",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,24"},
   CellID->8090]},
 "Ex--21907744555570480354,25"->{
  Cell[17206, 428, 422, 13, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,25"},
   CellID->24638]},
 "Ex--21907744555570480354,26"->{
  Cell[17653, 445, 167, 4, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,26"},
   CellID->6823],
  Cell[17823, 451, 9865, 166, 70, "Output",
   Evaluatable->False,
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,26"},
   CellID->63089195]},
 "Ex--21907744555570480354,27"->{
  Cell[27831, 626, 264, 7, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,27"},
   CellID->17205],
  Cell[28098, 635, 488, 12, 70, "Output",
   Evaluatable->False,
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,27"},
   CellID->274981480]},
 "Ex--21907744555570480354,29"->{
  Cell[28704, 655, 304, 10, 70, "Input",
   CellTags->"Ex--21907744555570480354,29",
   CellID->24287],
  Cell[29011, 667, 1982, 37, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907744555570480354,29",
   CellID->361764511]},
 "Ex--21907744555570480354,30"->{
  Cell[31076, 710, 160, 4, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,30"},
   CellID->2530]},
 "Ex--21907744555570480354,32"->{
  Cell[31996, 749, 231, 6, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,32"},
   CellID->12531],
  Cell[32230, 757, 327, 8, 70, "Output",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,32"},
   CellID->25674]},
 "Ex--21907744555570480354,33"->{
  Cell[32594, 770, 263, 7, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,33"},
   CellID->3902],
  Cell[32860, 779, 335, 9, 70, "Output",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,33"},
   CellID->8100]},
 "Ex--21907744555570480354,34"->{
  Cell[33232, 793, 168, 4, 70, "Input",
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,34"},
   CellID->23071],
  Cell[33403, 799, 1475, 28, 70, "Output",
   Evaluatable->False,
   CellTags->{"GUIScreenShot", "Ex--21907744555570480354,34"},
   CellID->210605562]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"GUIScreenShot", 37851, 931},
 {"PrimaryExamplesSection", 40815, 1011},
 {"Ex--21907744555570480354,22", 40969, 1015},
 {"Ex--21907744555570480354,23", 41245, 1022},
 {"Ex--21907744555570480354,24", 41553, 1030},
 {"Ex--21907744555570480354,25", 41832, 1037},
 {"Ex--21907744555570480354,26", 41990, 1041},
 {"Ex--21907744555570480354,27", 42298, 1049},
 {"Ex--21907744555570480354,29", 42606, 1057},
 {"Ex--21907744555570480354,30", 42878, 1065},
 {"Ex--21907744555570480354,32", 43034, 1069},
 {"Ex--21907744555570480354,33", 43314, 1076},
 {"Ex--21907744555570480354,34", 43592, 1083}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1437, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2060, 62, 50, 1, 70, "ObjectName",
 CellID->5881],
Cell[2113, 65, 451, 13, 70, "Usage",
 CellID->13467]
}, Open  ]],
Cell[CellGroupData[{
Cell[2601, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3079, 100, 426, 15, 70, "Notes",
 CellTags->"GUIScreenShot",
 CellID->26721],
Cell[3508, 117, 293, 9, 70, "Notes",
 CellTags->"GUIScreenShot",
 CellID->16952],
Cell[3804, 128, 165, 5, 70, "Notes",
 CellTags->"GUIScreenShot",
 CellID->17322],
Cell[3972, 135, 194, 5, 70, "Notes",
 CellTags->"GUIScreenShot",
 CellID->1828],
Cell[4169, 142, 483, 16, 70, "Notes",
 CellTags->"GUIScreenShot",
 CellID->18230],
Cell[4655, 160, 115, 3, 70, "Notes",
 CellID->429],
Cell[4773, 165, 342, 7, 70, "Notes",
 CellTags->"GUIScreenShot",
 CellID->21424]
}, Closed]],
Cell[CellGroupData[{
Cell[5152, 177, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->653988360],
Cell[CellGroupData[{
Cell[5537, 191, 148, 5, 70, "ExampleSection",
 CellID->297586527],
Cell[5688, 198, 129, 3, 70, "Input",
 CellID->287190376],
Cell[5820, 203, 67, 1, 70, "ExampleText",
 CellID->18213],
Cell[CellGroupData[{
Cell[5912, 208, 230, 6, 70, "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,22"},
 CellID->5202],
Cell[6145, 216, 326, 8, 70, "Output",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,22"},
 CellID->8658]
}, Open  ]],
Cell[6486, 227, 82, 1, 70, "ExampleText",
 CellID->4202],
Cell[CellGroupData[{
Cell[6593, 232, 168, 4, 70, "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,23"},
 CellID->23753],
Cell[6764, 238, 9805, 165, 70, "Output",
 Evaluatable->False,
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,23"},
 CellID->372817032]
}, Open  ]],
Cell[16584, 406, 83, 1, 70, "ExampleText",
 CellID->5058],
Cell[CellGroupData[{
Cell[16692, 411, 221, 5, 70, "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,24"},
 CellID->16575],
Cell[16916, 418, 275, 7, 70, "Output",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,24"},
 CellID->8090]
}, Open  ]],
Cell[17206, 428, 422, 13, 70, "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,25"},
 CellID->24638],
Cell[CellGroupData[{
Cell[17653, 445, 167, 4, 70, "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,26"},
 CellID->6823],
Cell[17823, 451, 9865, 166, 70, "Output",
 Evaluatable->False,
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,26"},
 CellID->63089195]
}, Open  ]],
Cell[27703, 620, 103, 2, 70, "ExampleText",
 CellTags->"GUIScreenShot",
 CellID->24701],
Cell[CellGroupData[{
Cell[27831, 626, 264, 7, 70, "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,27"},
 CellID->17205],
Cell[28098, 635, 488, 12, 70, "Output",
 Evaluatable->False,
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,27"},
 CellID->274981480]
}, Open  ]],
Cell[28601, 650, 78, 1, 70, "ExampleText",
 CellID->3123],
Cell[CellGroupData[{
Cell[28704, 655, 304, 10, 70, "Input",
 CellTags->"Ex--21907744555570480354,29",
 CellID->24287],
Cell[29011, 667, 1982, 37, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907744555570480354,29",
 CellID->361764511]
}, Open  ]],
Cell[31008, 707, 65, 1, 70, "ExampleText",
 CellID->14026],
Cell[31076, 710, 160, 4, 70, "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,30"},
 CellID->2530]
}, Open  ]],
Cell[CellGroupData[{
Cell[31273, 719, 216, 7, 70, "ExampleSection",
 CellID->14820],
Cell[31492, 728, 129, 3, 70, "Input",
 CellID->160911545],
Cell[31624, 733, 347, 12, 70, "ExampleText",
 CellID->7043],
Cell[CellGroupData[{
Cell[31996, 749, 231, 6, 70, "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,32"},
 CellID->12531],
Cell[32230, 757, 327, 8, 70, "Output",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,32"},
 CellID->25674]
}, Open  ]],
Cell[CellGroupData[{
Cell[32594, 770, 263, 7, 70, "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,33"},
 CellID->3902],
Cell[32860, 779, 335, 9, 70, "Output",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,33"},
 CellID->8100]
}, Open  ]],
Cell[CellGroupData[{
Cell[33232, 793, 168, 4, 70, "Input",
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,34"},
 CellID->23071],
Cell[33403, 799, 1475, 28, 70, "Output",
 Evaluatable->False,
 CellTags->{"GUIScreenShot", "Ex--21907744555570480354,34"},
 CellID->210605562]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34939, 834, 310, 9, 70, "SeeAlsoSection",
 CellID->5041],
Cell[35252, 845, 463, 17, 70, "SeeAlso",
 CellID->15264]
}, Open  ]],
Cell[CellGroupData[{
Cell[35752, 867, 314, 9, 70, "TutorialsSection",
 CellID->17699],
Cell[36069, 878, 269, 9, 70, "Tutorials",
 CellID->18456],
Cell[36341, 889, 388, 12, 70, "Tutorials",
 CellID->449844216]
}, Open  ]],
Cell[36744, 904, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

