(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29255,        763]
NotebookOptionsPosition[     23447,        580]
NotebookOutlinePosition[     26867,        677]
CellTagsIndexPosition[     26529,        666]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Access to the Java Object Layer in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/AccessToTheJavaObjectLayer"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Access to the Java Object Layer in GUIKit User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "Script" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Script"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"Script\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InvokeMethod", "ObjectName",
 CellID->13142],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InvokeMethod", "[", 
       RowBox[{
        StyleBox["name", "TI"], ",", 
        RowBox[{
         RowBox[{"{", "}"}], "|", 
         StyleBox["content", "TI"]}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]calls a widget method on the wrapping contexted \
widget."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InvokeMethod", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["target", "TI"], ",", 
          StyleBox["name", "TI"]}], 
         StyleBox["}", "TI"]}], ",", 
        StyleBox["content", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]calls a widget method on the specified target widget."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16448]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["InvokeMethod"], "InlineFormula"],
 " can be used to make a method call on a widget, with arguments to the call \
specified by ",
 Cell[BoxData[
  StyleBox["content", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"Call",
 CellID->25636],

Cell["\<\
If no target argument exists, then the target of the method call is the \
wrapping widget instance.\
\>", "Notes",
 CellTags->"Call",
 CellID->12353]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->47785171],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->803507732],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->6525362],

Cell["Run a simple widget definition:", "ExampleText",
 CellID->17624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Frame\>\"", ",", " ", 
     RowBox[{"Name", "->", "\"\<myFrame\>\""}]}], "]"}], "]"}]}]], "Input",
 CellTags->"Ex--21907744555570480354,36",
 CellLabel->"In[2]:=",
 CellID->14078],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject252594911969281, 
   JLink`Objects`JavaObject305969695293441]]], "Output",
 CellTags->"Ex--21907744555570480354,36",
 CellLabel->"Out[2]=",
 CellID->4985]
}, Open  ]],

Cell[TextData[{
 "Invoke a method that returns the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinate:"
}], "ExampleText",
 CellTags->"Call",
 CellID->10103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "@", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<myFrame\>\"", ",", "\"\<getX\>\""}], "}"}], "]"}]}]], "Input",\

 CellTags->{"Call", "Ex--21907744555570480354,37"},
 CellLabel->"In[3]:=",
 CellID->26781],

Cell[BoxData["450"], "Output",
 CellTags->{"Call", "Ex--21907744555570480354,37"},
 CellLabel->"Out[3]=",
 CellID->377]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907744555570480354,38",
 CellLabel->"In[4]:=",
 CellID->26350],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907744555570480354,38",
 CellLabel->"Out[4]=",
 CellID->81116432]
}, Open  ]],

Cell["\<\
Specify arguments to a method call that changes the size of the frame:\
\>", "ExampleText",
 CellID->20170],

Cell[BoxData[
 RowBox[{"ref", "@", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<myFrame\>\"", ",", "\"\<setSize\>\""}], "}"}], ",", "100", 
    ",", "100"}], "]"}]}]], "Input",
 CellTags->{"Call", "Ex--21907744555570480354,39"},
 CellLabel->"In[5]:=",
 CellID->18494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907744555570480354,40",
 CellLabel->"In[6]:=",
 CellID->20216],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907744555570480354,40",
 CellLabel->"Out[6]=",
 CellID->509647913]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9251],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6190]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7549],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->13888],

Cell[TextData[{
 ButtonBox["Access to the Java Object Layer in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/AccessToTheJavaObjectLayer"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/AccessToTheJavaObjectLayer"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/AccessToTheJavaObjectLayer"]
}], "Tutorials",
 CellID->84360427]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InvokeMethod - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 22, 56.9004930}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "InvokeMethod[name, {} | content] calls a widget method on the wrapping \
contexted widget. InvokeMethod[{target, name}, content] calls a widget method \
on the specified target widget.", "synonyms" -> {"invoke method"}, "title" -> 
    "InvokeMethod", "type" -> "Symbol", "uri" -> "GUIKit/ref/InvokeMethod"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Call"->{
  Cell[3616, 117, 275, 9, 70, "Notes",
   CellTags->"Call",
   CellID->25636],
  Cell[3894, 128, 159, 5, 70, "Notes",
   CellTags->"Call",
   CellID->12353],
  Cell[5460, 190, 180, 7, 70, "ExampleText",
   CellTags->"Call",
   CellID->10103],
  Cell[5665, 201, 257, 8, 70, "Input",
   CellTags->{"Call", "Ex--21907744555570480354,37"},
   CellID->26781],
  Cell[5925, 211, 119, 3, 70, "Output",
   CellTags->{"Call", "Ex--21907744555570480354,37"},
   CellID->377],
  Cell[13558, 355, 303, 9, 70, "Input",
   CellTags->{"Call", "Ex--21907744555570480354,39"},
   CellID->18494]},
 "PrimaryExamplesSection"->{
  Cell[4090, 138, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->47785171]},
 "Ex--21907744555570480354,36"->{
  Cell[4850, 169, 285, 8, 70, "Input",
   CellTags->"Ex--21907744555570480354,36",
   CellID->14078],
  Cell[5138, 179, 307, 8, 70, "Output",
   CellTags->"Ex--21907744555570480354,36",
   CellID->4985]},
 "Ex--21907744555570480354,37"->{
  Cell[5665, 201, 257, 8, 70, "Input",
   CellTags->{"Call", "Ex--21907744555570480354,37"},
   CellID->26781],
  Cell[5925, 211, 119, 3, 70, "Output",
   CellTags->{"Call", "Ex--21907744555570480354,37"},
   CellID->377]},
 "Ex--21907744555570480354,38"->{
  Cell[6081, 219, 149, 4, 70, "Input",
   CellTags->"Ex--21907744555570480354,38",
   CellID->26350],
  Cell[6233, 225, 7190, 122, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907744555570480354,38",
   CellID->81116432]},
 "Ex--21907744555570480354,39"->{
  Cell[13558, 355, 303, 9, 70, "Input",
   CellTags->{"Call", "Ex--21907744555570480354,39"},
   CellID->18494]},
 "Ex--21907744555570480354,40"->{
  Cell[13886, 368, 149, 4, 70, "Input",
   CellTags->"Ex--21907744555570480354,40",
   CellID->20216],
  Cell[14038, 374, 7465, 127, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907744555570480354,40",
   CellID->509647913]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Call", 24592, 606},
 {"PrimaryExamplesSection", 25201, 625},
 {"Ex--21907744555570480354,36", 25354, 629},
 {"Ex--21907744555570480354,37", 25593, 636},
 {"Ex--21907744555570480354,38", 25851, 643},
 {"Ex--21907744555570480354,39", 26120, 651},
 {"Ex--21907744555570480354,40", 26268, 655}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1483, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2106, 63, 50, 1, 70, "ObjectName",
 CellID->13142],
Cell[2159, 66, 942, 29, 70, "Usage",
 CellID->16448]
}, Open  ]],
Cell[CellGroupData[{
Cell[3138, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3616, 117, 275, 9, 70, "Notes",
 CellTags->"Call",
 CellID->25636],
Cell[3894, 128, 159, 5, 70, "Notes",
 CellTags->"Call",
 CellID->12353]
}, Closed]],
Cell[CellGroupData[{
Cell[4090, 138, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->47785171],
Cell[CellGroupData[{
Cell[4474, 152, 148, 5, 70, "ExampleSection",
 CellID->803507732],
Cell[4625, 159, 127, 3, 70, "Input",
 CellID->6525362],
Cell[4755, 164, 70, 1, 70, "ExampleText",
 CellID->17624],
Cell[CellGroupData[{
Cell[4850, 169, 285, 8, 70, "Input",
 CellTags->"Ex--21907744555570480354,36",
 CellID->14078],
Cell[5138, 179, 307, 8, 70, "Output",
 CellTags->"Ex--21907744555570480354,36",
 CellID->4985]
}, Open  ]],
Cell[5460, 190, 180, 7, 70, "ExampleText",
 CellTags->"Call",
 CellID->10103],
Cell[CellGroupData[{
Cell[5665, 201, 257, 8, 70, "Input",
 CellTags->{"Call", "Ex--21907744555570480354,37"},
 CellID->26781],
Cell[5925, 211, 119, 3, 70, "Output",
 CellTags->{"Call", "Ex--21907744555570480354,37"},
 CellID->377]
}, Open  ]],
Cell[CellGroupData[{
Cell[6081, 219, 149, 4, 70, "Input",
 CellTags->"Ex--21907744555570480354,38",
 CellID->26350],
Cell[6233, 225, 7190, 122, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907744555570480354,38",
 CellID->81116432]
}, Open  ]],
Cell[13438, 350, 117, 3, 70, "ExampleText",
 CellID->20170],
Cell[13558, 355, 303, 9, 70, "Input",
 CellTags->{"Call", "Ex--21907744555570480354,39"},
 CellID->18494],
Cell[CellGroupData[{
Cell[13886, 368, 149, 4, 70, "Input",
 CellTags->"Ex--21907744555570480354,40",
 CellID->20216],
Cell[14038, 374, 7465, 127, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907744555570480354,40",
 CellID->509647913]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21564, 508, 310, 9, 70, "SeeAlsoSection",
 CellID->9251],
Cell[21877, 519, 456, 17, 70, "SeeAlso",
 CellID->6190]
}, Open  ]],
Cell[CellGroupData[{
Cell[22370, 541, 313, 9, 70, "TutorialsSection",
 CellID->7549],
Cell[22686, 552, 269, 9, 70, "Tutorials",
 CellID->13888],
Cell[22958, 563, 447, 12, 70, "Tutorials",
 CellID->84360427]
}, Open  ]],
Cell[23420, 578, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

