(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12405,        447]
NotebookOptionsPosition[      8372,        312]
NotebookOutlinePosition[     10528,        376]
CellTagsIndexPosition[     10387,        369]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"GUIKit User Guide" :> 
         Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
         "Properties in GUIKit User Guide" :> 
         Documentation`HelpLookup[
          "paclet:GUIKit/tutorial/WidgetBasics#112718872"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
      2->"\<\"Properties in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PropertyValue", "ObjectName",
 CellID->6621],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PropertyValue", "[", 
       StyleBox["name", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gets a widget property value."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PropertyValue", "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["target", "TI"], ",", 
         StyleBox["name", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gets a widget property value, specifying the target \
widget."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PropertyValue", "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["target", "TI"], ",", 
         StyleBox["name", "TI"], ",", 
         StyleBox["index", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gets an indexed widget property value, specifying the \
target widget."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->3596]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PropertyValue"], "InlineFormula"],
 " returns the value of the property ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15004],

Cell[TextData[{
 "If the target argument is not present, the target is defaulted to the \
wrapping widget of the ",
 Cell[BoxData["PropertyValue"], "InlineFormula"],
 " expression. "
}], "Notes",
 CellTags->"PropertyValue",
 CellID->8514],

Cell[TextData[{
 "The target can either be specified as a string name of a widget reference \
or a component instance such as a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 StyleBox[".", "Output"]
}], "Notes",
 CellTags->"PropertyValue",
 CellID->20799],

Cell[TextData[{
 "Note that indices in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and XML widget definitions are 1-based, while Java and direct calls to \
Java objects using ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " follow the 0-based Java convention."
}], "Notes",
 CellTags->"PropertyValue",
 CellID->23210],

Cell["The following option can be given: ", "Notes",
 CellID->25269],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Name",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/Name"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
a name with which to register this returned value within the widget registry\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->19552]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->633835448],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->126153799],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->480884254],

Cell["Run an interface definition:", "ExampleText",
 CellID->28710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]}]], "Input",
 CellTags->"GUIRun",
 CellLabel->"In[2]:=",
 CellID->26758],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject31066085654529, 
   JLink`Objects`JavaObject48346601357313]]], "Output",
 CellTags->"GUIRun",
 CellLabel->"Out[2]=",
 CellID->7372]
}, Open  ]],

Cell[TextData[{
 "Get the value of the ",
 Cell[BoxData["\"\<text\>\""], "InlineFormula"],
 " property of the ",
 Cell[BoxData["\"\<SumField\>\""], "InlineFormula"],
 " widget reference:"
}], "ExampleText",
 CellID->2295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "@", 
  RowBox[{"PropertyValue", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<SumField\>\"", ",", "\"\<text\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellTags->"PropertyValue",
 CellLabel->"In[3]:=",
 CellID->17906],

Cell[BoxData["\<\"5\"\>"], "Output",
 CellTags->"PropertyValue",
 CellLabel->"Out[3]=",
 CellID->30014]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6382],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["SetPropertyValue",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/SetPropertyValue"],
  FontFamily->"Verdana"]], "InlineFormula"]], "RelatedLinks",
 CellID->11830]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32235],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->18456],

Cell[TextData[{
 ButtonBox["Properties in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics#112718872"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics#112718872"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics#112718872"]
}], "Tutorials",
 CellID->449844216]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PropertyValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 0.8221672}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "PropertyValue[name] gets a widget property value. PropertyValue[{target, \
name}] gets a widget property value, specifying the target widget. \
PropertyValue[{target, name, index}] gets an indexed widget property value, \
specifying the target widget.", "synonyms" -> {"property value"}, "title" -> 
    "PropertyValue", "type" -> "Symbol", "uri" -> "GUIKit/ref/PropertyValue"},
   "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PropertyValue"->{
  Cell[3270, 112, 238, 7, 70, "Notes",
   CellTags->"PropertyValue",
   CellID->8514],
  Cell[3511, 121, 341, 10, 70, "Notes",
   CellTags->"PropertyValue",
   CellID->20799],
  Cell[3855, 133, 329, 11, 70, "Notes",
   CellTags->"PropertyValue",
   CellID->23210],
  Cell[6348, 231, 237, 8, 70, "Input",
   CellTags->"PropertyValue",
   CellID->17906],
  Cell[6588, 241, 103, 3, 70, "Output",
   CellTags->"PropertyValue",
   CellID->30014]},
 "PrimaryExamplesSection"->{
  Cell[4860, 170, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->633835448]},
 "GUIRun"->{
  Cell[5620, 201, 180, 6, 70, "Input",
   CellTags->"GUIRun",
   CellID->26758],
  Cell[5803, 209, 284, 8, 70, "Output",
   CellTags->"GUIRun",
   CellID->7372]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PropertyValue", 9596, 339},
 {"PrimaryExamplesSection", 10068, 355},
 {"GUIRun", 10201, 359}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 780, 18, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1403, 45, 50, 1, 70, "ObjectName",
 CellID->6621],
Cell[1456, 48, 1097, 33, 70, "Usage",
 CellID->3596]
}, Open  ]],
Cell[CellGroupData[{
Cell[2590, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3068, 103, 199, 7, 70, "Notes",
 CellID->15004],
Cell[3270, 112, 238, 7, 70, "Notes",
 CellTags->"PropertyValue",
 CellID->8514],
Cell[3511, 121, 341, 10, 70, "Notes",
 CellTags->"PropertyValue",
 CellID->20799],
Cell[3855, 133, 329, 11, 70, "Notes",
 CellTags->"PropertyValue",
 CellID->23210],
Cell[4187, 146, 68, 1, 70, "Notes",
 CellID->25269],
Cell[4258, 149, 565, 16, 70, "3ColumnTableMod",
 CellID->19552]
}, Closed]],
Cell[CellGroupData[{
Cell[4860, 170, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->633835448],
Cell[CellGroupData[{
Cell[5245, 184, 148, 5, 70, "ExampleSection",
 CellID->126153799],
Cell[5396, 191, 129, 3, 70, "Input",
 CellID->480884254],
Cell[5528, 196, 67, 1, 70, "ExampleText",
 CellID->28710],
Cell[CellGroupData[{
Cell[5620, 201, 180, 6, 70, "Input",
 CellTags->"GUIRun",
 CellID->26758],
Cell[5803, 209, 284, 8, 70, "Output",
 CellTags->"GUIRun",
 CellID->7372]
}, Open  ]],
Cell[6102, 220, 221, 7, 70, "ExampleText",
 CellID->2295],
Cell[CellGroupData[{
Cell[6348, 231, 237, 8, 70, "Input",
 CellTags->"PropertyValue",
 CellID->17906],
Cell[6588, 241, 103, 3, 70, "Output",
 CellTags->"PropertyValue",
 CellID->30014]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6752, 251, 310, 9, 70, "SeeAlsoSection",
 CellID->6382],
Cell[7065, 262, 224, 6, 70, "RelatedLinks",
 CellID->11830]
}, Open  ]],
Cell[CellGroupData[{
Cell[7326, 273, 314, 9, 70, "TutorialsSection",
 CellID->32235],
Cell[7643, 284, 269, 9, 70, "Tutorials",
 CellID->18456],
Cell[7915, 295, 415, 12, 70, "Tutorials",
 CellID->449844216]
}, Open  ]],
Cell[8345, 310, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

