(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20889,        763]
NotebookOptionsPosition[     13420,        507]
NotebookOutlinePosition[     16743,        610]
CellTagsIndexPosition[     16623,        604]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "GUI Lifecycles in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/GUILifecycles"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"GUI Lifecycles in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CloseGUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/CloseGUIObject"], 
          "GUILoad" :> Documentation`HelpLookup["paclet:GUIKit/ref/GUILoad"], 
          "GUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIObject"], "GUIRun" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIRun"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CloseGUIObject\"\>", 
       2->"\<\"GUILoad\"\>", 3->"\<\"GUIObject\"\>", 
       4->"\<\"GUIRun\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReleaseGUIObject", "ObjectName",
 CellID->19140],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReleaseGUIObject", "[", 
       StyleBox["obj", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]closes and terminates all resources of a live ",
     Cell[BoxData[
      ButtonBox["GUIObject",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
     " instance."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10048]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ReleaseGUIObject"], "InlineFormula"],
 " programmatically ends an interface's session (which is normally ended \
interactively by user actions such as closing the window), both closing and \
disposing of all related resources."
}], "Notes",
 CellID->31655],

Cell[TextData[{
 Cell[BoxData["ReleaseGUIObject"], "InlineFormula"],
 " forces the termination of interface resources even if an initial ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " might have requested that the interface live on past its closing by using \
the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReleaseMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/ReleaseMethod"], "->", 
   ButtonBox["Manual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manual"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"ReleaseGUIObject",
 CellID->1807],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["CloseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/CloseGUIObject"]], "InlineFormula"],
 " instead of ",
 Cell[BoxData["ReleaseGUIObject"], "InlineFormula"],
 " to ensure the original lifecycle intent of a ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " call."
}], "Notes",
 CellID->14449]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->54310690],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->190727244],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->300726863],

Cell["Create a live interface object:", "ExampleText",
 CellID->6631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{
  "GUILoad", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]}]], "Input",
 CellTags->"ReleaseGUIObject",
 CellLabel->"In[2]:=",
 CellID->8324],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject161291607998465, 
   JLink`Objects`vm1`JavaObject194401208893441]]], "Output",
 CellTags->"ReleaseGUIObject",
 CellLabel->"Out[2]=",
 CellID->618428636]
}, Open  ]],

Cell["Verify that the interface is active:", "ExampleText",
 CellID->12725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", " ", "]"}]], "Input",
 CellTags->"ReleaseGUIObject",
 CellLabel->"In[3]:=",
 CellID->22301],

Cell[BoxData["True"], "Output",
 CellTags->"ReleaseGUIObject",
 CellLabel->"Out[3]=",
 CellID->251625738]
}, Open  ]],

Cell["Remove its resources:", "ExampleText",
 CellID->3969],

Cell[BoxData[
 RowBox[{"ReleaseGUIObject", "[", "ref", " ", "]"}]], "Input",
 CellTags->"ReleaseGUIObject",
 CellLabel->"In[4]:=",
 CellID->12488],

Cell["Confirm that the interface is no longer valid:", "ExampleText",
 CellID->21164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", " ", "]"}]], "Input",
 CellTags->"ReleaseGUIObject",
 CellLabel->"In[5]:=",
 CellID->13963],

Cell[BoxData["False"], "Output",
 CellTags->"ReleaseGUIObject",
 CellLabel->"Out[5]=",
 CellID->226338614]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27770],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->160911545],

Cell["Create a modeless live interface object:", "ExampleText",
 CellID->13997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]}]], "Input",
 CellTags->"ReleaseGUIObject",
 CellLabel->"In[2]:=",
 CellID->23724],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject545971276611585, 
   JLink`Objects`vm1`JavaObject194401208893441]]], "Output",
 CellTags->"ReleaseGUIObject",
 CellLabel->"Out[2]=",
 CellID->354020313]
}, Open  ]],

Cell["Shut it down:", "ExampleText",
 CellID->20067],

Cell[BoxData[
 RowBox[{"ReleaseGUIObject", "[", "ref", " ", "]"}]], "Input",
 CellTags->"ReleaseGUIObject",
 CellLabel->"In[3]:=",
 CellID->30265],

Cell["Verify that the interface is no longer valid:", "ExampleText",
 CellID->20840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", " ", "]"}]], "Input",
 CellTags->"ReleaseGUIObject",
 CellLabel->"In[4]:=",
 CellID->3379],

Cell[BoxData["False"], "Output",
 CellTags->"ReleaseGUIObject",
 CellLabel->"Out[4]=",
 CellID->345099269]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16028],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->502292478],

Cell[TextData[{
 "Create a modeless live interface object, specifying a manual ",
 Cell[BoxData[
  ButtonBox["ReleaseMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ReleaseMethod"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"\"\<Wolfram/Example/Calculator\>\"", ",", " ", 
    RowBox[{"ReleaseMethod", "\[Rule]", "Manual"}]}], "]"}]}]], "Input",
 CellTags->"ReleaseGUIObject",
 CellLabel->"In[2]:=",
 CellID->18227],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject43058674532353, 
   JLink`Objects`vm1`JavaObject273112641830913]]], "Output",
 CellTags->"ReleaseGUIObject",
 CellLabel->"Out[2]=",
 CellID->67813450]
}, Open  ]],

Cell["Attempt to close the interface:", "ExampleText",
 CellID->16139],

Cell[BoxData[
 RowBox[{"CloseGUIObject", "[", "ref", " ", "]"}]], "Input",
 CellTags->"ReleaseGUIObject",
 CellLabel->"In[3]:=",
 CellID->32666],

Cell["Test whether the interface is still valid:", "ExampleText",
 CellID->22237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", " ", "]"}]], "Input",
 CellTags->"ReleaseGUIObject",
 CellLabel->"In[4]:=",
 CellID->32048],

Cell[BoxData["True"], "Output",
 CellTags->"ReleaseGUIObject",
 CellLabel->"Out[4]=",
 CellID->519597364]
}, Open  ]],

Cell["Terminate the interface:", "ExampleText",
 CellID->24848],

Cell[BoxData[
 RowBox[{"ReleaseGUIObject", "[", "ref", " ", "]"}]], "Input",
 CellTags->"ReleaseGUIObject",
 CellLabel->"In[5]:=",
 CellID->24404],

Cell["Verify that it is no longer valid:", "ExampleText",
 CellID->7048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", " ", "]"}]], "Input",
 CellTags->"ReleaseGUIObject",
 CellLabel->"In[6]:=",
 CellID->25565],

Cell[BoxData["False"], "Output",
 CellTags->"ReleaseGUIObject",
 CellLabel->"Out[6]=",
 CellID->90159938]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30219],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CloseGUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/CloseGUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUILoad",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUILoad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIRun",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIRun"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30270]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8491],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->20695],

Cell[TextData[{
 ButtonBox["GUI Lifecycles in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/GUILifecycles"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/GUILifecycles"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/GUILifecycles"]
}], "Tutorials",
 CellID->314964108]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReleaseGUIObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 1.8689886}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "ReleaseGUIObject[obj] closes and terminates all resources of a live \
GUIObject instance.", "synonyms" -> {"release object"}, "title" -> 
    "ReleaseGUIObject", "type" -> "Symbol", "uri" -> 
    "GUIKit/ref/ReleaseGUIObject"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ReleaseGUIObject"->{
  Cell[3751, 117, 661, 20, 70, "Notes",
   CellTags->"ReleaseGUIObject",
   CellID->1807],
  Cell[5657, 190, 200, 6, 70, "Input",
   CellTags->"ReleaseGUIObject",
   CellID->8324],
  Cell[5860, 198, 309, 8, 70, "Output",
   CellTags->"ReleaseGUIObject",
   CellID->618428636],
  Cell[6284, 214, 140, 4, 70, "Input",
   CellTags->"ReleaseGUIObject",
   CellID->22301],
  Cell[6427, 220, 105, 3, 70, "Output",
   CellTags->"ReleaseGUIObject",
   CellID->251625738],
  Cell[6609, 229, 146, 4, 70, "Input",
   CellTags->"ReleaseGUIObject",
   CellID->12488],
  Cell[6868, 240, 140, 4, 70, "Input",
   CellTags->"ReleaseGUIObject",
   CellID->13963],
  Cell[7011, 246, 106, 3, 70, "Output",
   CellTags->"ReleaseGUIObject",
   CellID->226338614],
  Cell[7621, 274, 200, 6, 70, "Input",
   CellTags->"ReleaseGUIObject",
   CellID->23724],
  Cell[7824, 282, 309, 8, 70, "Output",
   CellTags->"ReleaseGUIObject",
   CellID->354020313],
  Cell[8203, 296, 146, 4, 70, "Input",
   CellTags->"ReleaseGUIObject",
   CellID->30265],
  Cell[8461, 307, 139, 4, 70, "Input",
   CellTags->"ReleaseGUIObject",
   CellID->3379],
  Cell[8603, 313, 106, 3, 70, "Output",
   CellTags->"ReleaseGUIObject",
   CellID->345099269],
  Cell[9261, 341, 274, 7, 70, "Input",
   CellTags->"ReleaseGUIObject",
   CellID->18227],
  Cell[9538, 350, 307, 8, 70, "Output",
   CellTags->"ReleaseGUIObject",
   CellID->67813450],
  Cell[9933, 364, 144, 4, 70, "Input",
   CellTags->"ReleaseGUIObject",
   CellID->32666],
  Cell[10186, 375, 140, 4, 70, "Input",
   CellTags->"ReleaseGUIObject",
   CellID->32048],
  Cell[10329, 381, 105, 3, 70, "Output",
   CellTags->"ReleaseGUIObject",
   CellID->519597364],
  Cell[10515, 390, 146, 4, 70, "Input",
   CellTags->"ReleaseGUIObject",
   CellID->24404],
  Cell[10761, 401, 140, 4, 70, "Input",
   CellTags->"ReleaseGUIObject",
   CellID->25565],
  Cell[10904, 407, 105, 3, 70, "Output",
   CellTags->"ReleaseGUIObject",
   CellID->90159938]},
 "PrimaryExamplesSection"->{
  Cell[4896, 159, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->54310690]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ReleaseGUIObject", 14499, 533},
 {"PrimaryExamplesSection", 16481, 597}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1693, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2316, 67, 54, 1, 70, "ObjectName",
 CellID->19140],
Cell[2373, 70, 573, 17, 70, "Usage",
 CellID->10048]
}, Open  ]],
Cell[CellGroupData[{
Cell[2983, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3461, 109, 287, 6, 70, "Notes",
 CellID->31655],
Cell[3751, 117, 661, 20, 70, "Notes",
 CellTags->"ReleaseGUIObject",
 CellID->1807],
Cell[4415, 139, 444, 15, 70, "Notes",
 CellID->14449]
}, Closed]],
Cell[CellGroupData[{
Cell[4896, 159, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->54310690],
Cell[CellGroupData[{
Cell[5280, 173, 148, 5, 70, "ExampleSection",
 CellID->190727244],
Cell[5431, 180, 129, 3, 70, "Input",
 CellID->300726863],
Cell[5563, 185, 69, 1, 70, "ExampleText",
 CellID->6631],
Cell[CellGroupData[{
Cell[5657, 190, 200, 6, 70, "Input",
 CellTags->"ReleaseGUIObject",
 CellID->8324],
Cell[5860, 198, 309, 8, 70, "Output",
 CellTags->"ReleaseGUIObject",
 CellID->618428636]
}, Open  ]],
Cell[6184, 209, 75, 1, 70, "ExampleText",
 CellID->12725],
Cell[CellGroupData[{
Cell[6284, 214, 140, 4, 70, "Input",
 CellTags->"ReleaseGUIObject",
 CellID->22301],
Cell[6427, 220, 105, 3, 70, "Output",
 CellTags->"ReleaseGUIObject",
 CellID->251625738]
}, Open  ]],
Cell[6547, 226, 59, 1, 70, "ExampleText",
 CellID->3969],
Cell[6609, 229, 146, 4, 70, "Input",
 CellTags->"ReleaseGUIObject",
 CellID->12488],
Cell[6758, 235, 85, 1, 70, "ExampleText",
 CellID->21164],
Cell[CellGroupData[{
Cell[6868, 240, 140, 4, 70, "Input",
 CellTags->"ReleaseGUIObject",
 CellID->13963],
Cell[7011, 246, 106, 3, 70, "Output",
 CellTags->"ReleaseGUIObject",
 CellID->226338614]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7166, 255, 216, 7, 70, "ExampleSection",
 CellID->27770],
Cell[7385, 264, 129, 3, 70, "Input",
 CellID->160911545],
Cell[7517, 269, 79, 1, 70, "ExampleText",
 CellID->13997],
Cell[CellGroupData[{
Cell[7621, 274, 200, 6, 70, "Input",
 CellTags->"ReleaseGUIObject",
 CellID->23724],
Cell[7824, 282, 309, 8, 70, "Output",
 CellTags->"ReleaseGUIObject",
 CellID->354020313]
}, Open  ]],
Cell[8148, 293, 52, 1, 70, "ExampleText",
 CellID->20067],
Cell[8203, 296, 146, 4, 70, "Input",
 CellTags->"ReleaseGUIObject",
 CellID->30265],
Cell[8352, 302, 84, 1, 70, "ExampleText",
 CellID->20840],
Cell[CellGroupData[{
Cell[8461, 307, 139, 4, 70, "Input",
 CellTags->"ReleaseGUIObject",
 CellID->3379],
Cell[8603, 313, 106, 3, 70, "Output",
 CellTags->"ReleaseGUIObject",
 CellID->345099269]
}, Open  ]],
Cell[8724, 319, 121, 3, 70, "ExampleDelimiter",
 CellID->16028],
Cell[8848, 324, 129, 3, 70, "Input",
 CellID->502292478],
Cell[8980, 329, 256, 8, 70, "ExampleText",
 CellID->2432],
Cell[CellGroupData[{
Cell[9261, 341, 274, 7, 70, "Input",
 CellTags->"ReleaseGUIObject",
 CellID->18227],
Cell[9538, 350, 307, 8, 70, "Output",
 CellTags->"ReleaseGUIObject",
 CellID->67813450]
}, Open  ]],
Cell[9860, 361, 70, 1, 70, "ExampleText",
 CellID->16139],
Cell[9933, 364, 144, 4, 70, "Input",
 CellTags->"ReleaseGUIObject",
 CellID->32666],
Cell[10080, 370, 81, 1, 70, "ExampleText",
 CellID->22237],
Cell[CellGroupData[{
Cell[10186, 375, 140, 4, 70, "Input",
 CellTags->"ReleaseGUIObject",
 CellID->32048],
Cell[10329, 381, 105, 3, 70, "Output",
 CellTags->"ReleaseGUIObject",
 CellID->519597364]
}, Open  ]],
Cell[10449, 387, 63, 1, 70, "ExampleText",
 CellID->24848],
Cell[10515, 390, 146, 4, 70, "Input",
 CellTags->"ReleaseGUIObject",
 CellID->24404],
Cell[10664, 396, 72, 1, 70, "ExampleText",
 CellID->7048],
Cell[CellGroupData[{
Cell[10761, 401, 140, 4, 70, "Input",
 CellTags->"ReleaseGUIObject",
 CellID->25565],
Cell[10904, 407, 105, 3, 70, "Output",
 CellTags->"ReleaseGUIObject",
 CellID->90159938]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11070, 417, 311, 9, 70, "SeeAlsoSection",
 CellID->30219],
Cell[11384, 428, 977, 35, 70, "SeeAlso",
 CellID->30270]
}, Open  ]],
Cell[CellGroupData[{
Cell[12398, 468, 313, 9, 70, "TutorialsSection",
 CellID->8491],
Cell[12714, 479, 269, 9, 70, "Tutorials",
 CellID->20695],
Cell[12986, 490, 392, 12, 70, "Tutorials",
 CellID->314964108]
}, Open  ]],
Cell[13393, 505, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

