(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9821,        339]
NotebookOptionsPosition[      6734,        240]
NotebookOutlinePosition[      8490,        290]
CellTagsIndexPosition[      8363,        284]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "XML Syntax in GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/XMLReference"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"XML Syntax in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WidgetToSymbolicGUIKitXML" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/ref/WidgetToSymbolicGUIKitXML"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"WidgetToSymbolicGUIKitXML\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SymbolicGUIKitXMLToWidget", "ObjectName",
 CellID->12205],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SymbolicGUIKitXMLToWidget", "[", 
       StyleBox["body", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts a GUIKitXML representation into the \
equivalent user interface expression."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22599]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["SymbolicGUIKitXMLToWidget"], "InlineFormula"],
 " is also used to support ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{
    StyleBox["file", "TI"], ",", " ", "\"\<GUIKitXML\>\""}], "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellTags->"SymbolicGUIKitXMLToWidget",
 CellID->788]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->275918519],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->927677460],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->588287697],

Cell["Convert GUIKitXML into a user interface definition:", "ExampleText",
 CellID->21054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolicGUIKitXMLToWidget", "[", "\[IndentingNewLine]", 
  RowBox[{"ImportString", "[", 
   RowBox[{
   "\"\<\n<widget src='Panel'>\n    <widget src='Label'>\n    <property \
name='text'>\n       <string value='Hello World!'/>\n    </property>\n    \
</widget>\n</widget>\n\>\"", ",", " ", "\"\<XML\>\""}], "]"}], "]"}]], "Input",\

 CellTags->"SymbolicGUIKitXMLToWidget",
 CellLabel->"In[2]:=",
 CellID->10167],

Cell[BoxData[
 RowBox[{"Widget", "[", 
  RowBox[{"\<\"Panel\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"Widget", "[", 
     RowBox[{"\<\"Label\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Hello World!\"\>"}], "}"}]}], 
     "]"}], "}"}]}], "]"}]], "Output",
 CellTags->"SymbolicGUIKitXMLToWidget",
 CellLabel->"Out[2]=",
 CellID->19212]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5732],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["WidgetToSymbolicGUIKitXML",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetToSymbolicGUIKitXML"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->30076]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13261],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->29045],

Cell[TextData[{
 ButtonBox["XML Syntax in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/XMLReference"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/XMLReference"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/XMLReference"]
}], "Tutorials",
 CellID->393062269]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SymbolicGUIKitXMLToWidget - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 8.9779996}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "SymbolicGUIKitXMLToWidget[body] converts a GUIKitXML representation into \
the equivalent user interface expression.", 
    "synonyms" -> {"symbolic kit to widget"}, "title" -> 
    "SymbolicGUIKitXMLToWidget", "type" -> "Symbol", "uri" -> 
    "GUIKit/ref/SymbolicGUIKitXMLToWidget"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SymbolicGUIKitXMLToWidget"->{
  Cell[3047, 99, 397, 14, 70, "Notes",
   CellTags->"SymbolicGUIKitXMLToWidget",
   CellID->788],
  Cell[4264, 149, 435, 10, 70, "Input",
   CellTags->"SymbolicGUIKitXMLToWidget",
   CellID->10167],
  Cell[4702, 161, 368, 11, 70, "Output",
   CellTags->"SymbolicGUIKitXMLToWidget",
   CellID->19212]},
 "PrimaryExamplesSection"->{
  Cell[3481, 118, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->275918519]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SymbolicGUIKitXMLToWidget", 7889, 267},
 {"PrimaryExamplesSection", 8220, 277}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1385, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2008, 61, 63, 1, 70, "ObjectName",
 CellID->12205],
Cell[2074, 64, 458, 13, 70, "Usage",
 CellID->22599]
}, Open  ]],
Cell[CellGroupData[{
Cell[2569, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3047, 99, 397, 14, 70, "Notes",
 CellTags->"SymbolicGUIKitXMLToWidget",
 CellID->788]
}, Closed]],
Cell[CellGroupData[{
Cell[3481, 118, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->275918519],
Cell[CellGroupData[{
Cell[3866, 132, 148, 5, 70, "ExampleSection",
 CellID->927677460],
Cell[4017, 139, 129, 3, 70, "Input",
 CellID->588287697],
Cell[4149, 144, 90, 1, 70, "ExampleText",
 CellID->21054],
Cell[CellGroupData[{
Cell[4264, 149, 435, 10, 70, "Input",
 CellTags->"SymbolicGUIKitXMLToWidget",
 CellID->10167],
Cell[4702, 161, 368, 11, 70, "Output",
 CellTags->"SymbolicGUIKitXMLToWidget",
 CellID->19212]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5131, 179, 310, 9, 70, "SeeAlsoSection",
 CellID->5732],
Cell[5444, 190, 237, 6, 70, "SeeAlso",
 CellID->30076]
}, Open  ]],
Cell[CellGroupData[{
Cell[5718, 201, 314, 9, 70, "TutorialsSection",
 CellID->13261],
Cell[6035, 212, 269, 9, 70, "Tutorials",
 CellID->29045],
Cell[6307, 223, 385, 12, 70, "Tutorials",
 CellID->393062269]
}, Open  ]],
Cell[6707, 238, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

