(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42236,       1004]
NotebookOptionsPosition[     36010,        826]
NotebookOutlinePosition[     39971,        928]
CellTagsIndexPosition[     39669,        918]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Widget Layout in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Widget Layout in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "WidgetFill" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetFill"], 
          "WidgetGroup" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetGroup"], 
          "WidgetSpace" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetSpace"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"WidgetFill\"\>", 3->"\<\"WidgetGroup\"\>", 
       4->"\<\"WidgetSpace\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WidgetAlign", "ObjectName",
 CellID->16461],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"WidgetAlign", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]is a widget layout placeholder that provides an \
alignment marker. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"WidgetAlign", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["ref", "TI"], ",", "After"}], "}"}], ",", "Before"}], 
       "]"}]], "InlineFormula"],
     " \[LineSeparator]makes a specific request for the next widget to align \
to another widget by named reference ",
     StyleBox["ref", "TI"],
     ", and aligned based on ",
     Cell[BoxData["Before"], "InlineFormula"],
     " and ",
     Cell[BoxData["After"], "InlineFormula"],
     " specifications on both widgets."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->21846]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["WidgetAlign"], "InlineFormula"],
 " provides a marker that other ",
 Cell[BoxData["WidgetAlign"], "InlineFormula"],
 " markers will align with if present. "
}], "Notes",
 CellID->23458]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57635664],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->20609425],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->91711584],

Cell[TextData[{
 "Without ",
 Cell[BoxData["WidgetAlign"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Label\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<These are inputs\>\""}], 
          "}"}], ",", "\[IndentingNewLine]", "   ", 
         RowBox[{"WidgetLayout", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Alignment\>\"", "\[Rule]", "Center"}], "}"}]}], ",", 
         RowBox[{"Name", "\[Rule]", "\"\<mainLabel\>\""}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<BB\>\""}], "}"}]}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<in\>\""}], "}"}]}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<CheckBox\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<label\>\"", "\[Rule]", "\"\<round\>\""}], "}"}]}], 
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<CCC\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<m\>\""}], "}"}]}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\< OR \>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<km\>\""}], "}"}]}], 
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"WidgetFill", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Submit\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetFill", "[", "]"}]}], "}"}]}], "\[IndentingNewLine]", 
      "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,24"},
 CellLabel->"In[2]:=",
 CellID->28735],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject236052895760385, 
   JLink`Objects`JavaObject400112962502657]]], "Output",
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,24"},
 CellLabel->"Out[2]=",
 CellID->16616]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,25"},
 CellLabel->"In[3]:=",
 CellID->20113],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXAl4VEW2vulOJwFJFFEGBAPIKgYk7FtYhCRAEiCQACEkBGIgQAAJKIIw
OI6OI+gbGHR8OjoDT58r6jijMriN+/gUH4iyCAlZe8lOll4Slv+dU3V7ze0k
bI7vG/v76t6qulWnzvnPqVOn6t6vE5ZsyM5avWTDiswlPWNzl9yVvSJzfc+Y
tblUpQ9QlIAOiqJs6alwHpR1XvRQbngKSqdHOSnga3uRVZRAKJ1fhxK+R017
wzgTzLlQztHlZlHky817gviBV04+2BukNhYE1KJ4EOoiFeydu8nVRFDh4l5m
R7DxHJegdPtjgMqnAUrXQwiJ/AGhsSdxXVIB2k//QQlG4OQTNNaE/BugROUR
oQl5VIzKD+OiyDnrJrjqJnCdZy60WQ/5lOlF5YeqlD1z7qfB3t0EKZYiKg/K
qMNQIt5naZpLcf0cIzqvrEZIcj5JETyr/ByUabWsKe456EOGWAlwK0ntpnbJ
QGXZCSUIVeUnUVNVgPpaM2zWKthtNXDYznSDw36mK5qabHrOUX+HvQ6Njjq6
11KH05miv56HlAO2Plggyk3fcw5bn3oVfRc8OAbK+A1U/YuEXyLn0f+GtaGC
xq++JNLGokNY/vAezFi3G8+9/tYoHDv8OYl39PBnOHroU7y5/x1MW7MTq3Y8
x8NcwhBBKDl9ULD6j39+heKCYyg8/T2KTh8dwQV6TFkU5B3BqePf4J0PPhBN
62tNzYYKb3UoPQ31NWODygqTokNFhZHqKiuMXBZ1w8Q1iJ+gzFKE0uKTKMz/
XvSprS6+rDHPnKlQxtC1nGytptqCckH/B/msukhpnXjw0GbqcRKvra3kNFqM
QvRrylBRXgJj8SmVfqE3/Qmsm71tp19XV8UplAcJZN+l55xOeDGDGJ3dmcdd
Ec90Ihvoeqg28K1W76KLGIJokiCkjFKYSvKulAjVnDoQ/SqmIcasEiWdT52i
8lglBdQ7K90PtBorIZ5EPZ8772GiGctWKczOVJJ/EbJpzE6nbPX11Zw6so5U
1lhjkvm21elEXYirTq33vYeJZlLlVZVGmEv9iNC26eEWoaGhhtO1LIdqO5Qj
D8yDq/KJ5CxLQbiN3qtO9gvx6ufx3HkPE80MQq7qKhMsxtNXSpAznEKJfo0Q
JJBz5FTk4DWupJZdwtbwIqS2UY1N1EojDPLs43kPU7uyfVdXmUmQgosQJDjy
hD9BrNZaTh1YGhVjVTZqxNcQzzqRnGX1rorm3V/RqJM0xeznrEHIxk6yzFTY
gjDNZr9/YWy2OhKmrgNLpA6sykfMNK8zaNSFatR1UFuzEGfI6Zabrxi/9ZxC
mXGBTAjn1NFZGC5d41OnCHPgOsE/as+Uo4KWmbZz1IJd22wNnEYzW4J+HdGv
IPrFfnxYfluWf/f66HDYaX10OGxE3G630hpfTVGU6SKIB/sn3tTURMSbmhqJ
eFOTg2KVOiJa7p+4hq58iBtQnC+Jnz9/TqRz584po+l6lrqcPdsEGw3CzykO
vAT6knkK5/CP/81TxuLChQvU9MKF81Q+JeopxrwEulKj9z3xEpK3/hc+OpQ/
BvSj6qMFFlF13x9eITs+2mxB0vAdzcPFwkMwFX8ryPtEost/uweW0u84XQJp
PbMkyBPqSjiK8r7qivxjn+o5R51YFywXt7hY5sGNDV5zI/9f36MLN07FtmcP
9HPlrvMl0NIc6KI2pn5Qf8p8cZV1vGPgFn3a2C7s58Fb8OT/roN7eHQdN9bL
kKd5zuB3SIPnkCLJGEG6FF7cPOrbuQjqnby5G6idvOsubWA3DXddiC8z8u7G
xglNkC80zg56baFarNaW8DJhDFGh8az27qL9LMTv8MFaw7fGhu9QWnZmaAam
jIebYxOoURd8ZfAK1iDtqx7Fj8qCfsasRcy0Jq1/FgJ9WdC1MIM0sRLB49XH
SptR6Y5cGzwnBm3FKtA9eS/RoCQX7bS4+NEhaov9a8+l1nFq3u7SFgJDc4Rc
z4K87c2N3L90IfBewq/zkaK5hFd+Ce3gpOEKv69C2OAtZkdXDwGWoeV5cgXY
vqqh1s+D/zy45uAtbQhbI9B8D/rv0kM4h78wYFPa0O2EVzcfNe7TUOPknyRR
vXplR+6se0FjIGFDoeieeH+fVof0eL9y2UNSDEJjoraWj8P5OLUBdrsNjY0O
cXrGJ2p85uWkyW2d/W/xZLS1d2UGVyBo8Leg+Oe75QjFf7TfXvBbU1PZmnw6
DfH8Lsvu9U3njnI8OdIOFFysOuvd4ZEGgAZfADUDKn9BllZYcuXhDZV4VZa1
BWIxILVX+dUOhfxuTLTg83tEoPO0MP/geszcnyy4FouxzQBfCriXWlfpGfH/
v0bYaCxuM8o/JYSbrT6X5WGD/GGoc2/g/WNYXHy6zTi6MPSgHKyFpg8ygZ51
Wkxd7PT/cXxrSEvG6eK2nQeYhYWn2gyo2yA1cNC7UQppCWAXFx5rWksLVf6/
DEyt+EWCdvr0D20GjkELb3W2ab4YukLxjPbGN8xDnry8422W6dLl8Q3Or4Ai
mPG2Ms+Me0W7rX3lcaWZbAujPz6TzXcBrbn+yxlysu9AGp8L/DQGanV/pkk0
2Ido8w1olPYb+xP+d7pXqEdISz38fH12sT1a5qqVj5Ge0PAqOT8qgVTRuG3R
lqukd61+7lyQe21rtl9rfs7ZWvjR6orpDm4EsUVXS+bLjTC1N7la8vjnSWut
v6SYzeOtTGt6TrmagIb4MK/Wy+q2xKotvy25XD36GimXFl7MCnWxeAS6VOc2
enfUE+jPXAyuuXUFhXfPuDRfkVv6zi1VQ6WVfnY3V2ZOBWnB6zNmS/PJz9xp
05Ty/35Xe8TUi4eyZfG0PLCPL9b7Y97tNQ0aEnsD2CpIanJbsLY7biZvu+En
2zJbJvvwz6WMiyGe4pooPjMoQoNyx8sdTTsCaB4ytdRj3EkovV7+sXvcdIhq
C2WKKyQLmHKIGgdMOYSAqYc50RZaF31Yz1kd1yt6+YRbUCmGS9HcLZrL4SoB
QW8wYTD0Yx7txt8r/BGAz2iE0kFuL4bRyWGUGWRJAQl5TGM2tUgooXsxL510
pbq5RZxzlmYX7+AmU6HEFHKZacaViFKQs24KcTFJJC5FieuEk7JOliZ51U04
yaON/YH39qNPcA7KiBMyz3fmfXQ5S8Yw7hDTySVYXIVkOamEiSwwMcQLqG5R
JZSMaiiL6/TQZ9UGQp/dQIPqs5sQsFIkaslXYiTrPALubOSkkGAZjYRuxjmR
YwgXNXJR3lMcUBZaaYR6KPNtYkQ7jzjfBiW5AUpiA991nAnkHHOaeAZKfI28
yzbcL76e8IqtCWDRAjxlC/aWbQHJkFrnvFNPfQZ/NK5fYmOJWB4qBa1spEvO
uWDoV50lva68EM1PMlk0emxYdhbL/mgVm45r1a2Hseq8qKNnzI6fdsGy3VP1
MCyxMyACBkO6Hcv+UE97PIhzIWPlOSzbXQvDrDoWjOUiWyj31ZpTsmIvyQIy
rCwNm2NWo6ohkofFobrgtef1CM49H4igdRfoYS7osgYvsYzKjVj+JxsOn6zF
gHmfInTiO+g49QNcH/0ebog+gOunHkCn6PfRKeYDXBf9IUKjP0L76I8RMvVT
BE3+CPqJHyFg4qfE0IfoMfMADp2oYnqKwE+JvOK0GVk2NTamZU9ZUX3sMN6e
OgAv3BaKfUM64tXI6/Hy0Bvw8pDrsW9oJ7xG6fXI6/DmkFD8dXB7vDUoBG8O
DMKbA/R4q38AXu+jYN/4Hij//pBAXxifE32JvOKEPtAXeh3jTtXSjpok6jnn
BOA6BjwIwRsu6FyoxzLqmSrqxurzGJBegE6zCtAtuQC9Fhaj76Ii9EsrRB+6
904vRi9K4ZS6LTaic7oRndJMCEs1ot0CEwKTTAiYSbxEf0fo/F1YkRP1q0Db
hTrb8jfTB+Dg6E44OKEbDk3thUOxfSn1w6GYPjgc2xvfxvTCkehwHI3uhqN3
dMaxSZ1wNCoMx8a0w9ERgfh2SAA+GajgVUJe0G4B9eYGrxq7MPUwJCcnC3AD
GdwXVXD5Fza7Ct1TazAg8wxuzz6DYatqMTynFpE5dYhcXYfBa+sw8K469L2r
Hj3W1qPr6gZ0WtmA0GUNCM6oh24h+ZoEGnbsAQ9wrxZtglalfWJUGE5N6Y78
+AE4Ped2FCQPQ+H84ShMjkThvEgUzRuM4uSBKJ3bF6Wze8AY3xXGaZ1gnBKK
0gnBKBytw7e3K3ilt+KkHV/PHtobXLG40WLR44i3N1ksvQmBiz/v3ROE0tJS
6lx88hTMFgsnMviKigq60mPGHAE5Fzg9yviECy8oBblhXj36Lm1A5KoGjFnX
gKgNVko2jLvbijH3WDFqoxVD77Uh4l47+m60o8c9dnTNtaPjGgeuybbDkNEA
3VyyxKgPnYIQ7cirQdu1OPEvf/wNKIzri6KkSJSkjkFpehRKF1NKHwdj+hhK
o2BKGwpzagQs8/uiLKkHymZ3RdmMjrBMvQalUQYcG6bDG/0CJG1fbx75hUsB
7aD0PqYuVGa56C52uXOB8IoVK0hy0oJOgN8ep06dwuc7HhV3UoRQC+f5zmXu
RJrQ8cIsINvOi3K4sDCDYKhLSj0G07o3loC7Y6OVphhz2Q4DtzjQZ7MDN290
4Mb1DoTlONAuswGGeWboJv7Dw1K16VwjWnTX6uda+fl3elIXFCUORsmisShd
egesH78t6k1ZUyhNhunOKJiXjoYlYyjKFg1EeUof8dz+970omxYG46R2OD7S
gL/0Fy/qdYwuG/hki8Q34ksXvoFufBn9xAodA8zRIEHMSLF5C3iJe0aRcvif
7OUoS03Eu+++K9Gm+8eP7xII19fXcz+50uoY2ZdFjCMRCU+rx8g1hAaZ4PT7
3MgO2kpmSMiGE7K/IGQ7rrYLX3BNilksdU5kGwk9DTqibsYv7Zj2Sxuit9kw
+X4ydbqP2Gb3os0/Ddoy1qK4iX8F5JiLF4wUyBuXT5fntQaYsqNhXj4Z5jvH
wbJ0BMrTB6lnue2FZZumhuL4uGvw5m1BkqTTohl1diAiRhGgG1SvwqCX0rjl
HEkqEvkOAvX169cLNBntt+MScPifX+B4ynwUr0hEwbo0fL1yIT7u3Rtv/e1v
UjmBeHz3brnQyhTLGszkQFKFvu/SekStb8A0gmvm/TY39Fvs6LfJgZ7kBbqu
t6PzWjs6rWjAdWkWtJ/qMmqic6MWHVE381c2xFE+liC/g9J4SiMZeg/a/PND
O7lWkZixVykhb2JcPg2mnJkwrZ7tPC43Z98Bc9Z4gn6kCnuQcCqW+M4oje2E
ExMpiBnUXrX3yRaxWymWu5WB+z39CUPP+zgBvdEdyJNfYeg/+eQT1eBD8UXq
Irw7sB8aFsWgMnEKzC/kYH9GFJ7sd7PAe9fO3+HdbRvFnXHncEdgtYOjznA2
KxW128jgpt5LiBEycx6wYe6vbUike8KvyGipbgqlKDLeEVtsGLSZUCPEem2w
o9s6O7qsoUSLY+fFZlwb65oMRDtckzb/2kJbuKjmtFkfYiPBv6JZt6E0cypM
q2bCvHYOpbkwrUmUGriONBIF5++CtRaWpF6wzO4Gc0IXlM7oguMU3Pw18lpJ
lifCpCL3JnLgfqdWfgGl55dyL8ZaSTR6ba9YKwe/Poj899/D9++/jy9mxaIk
MwrW51fB9PgSVC4dhVOjI/A/kf3x7rQROJM0AyePHcOf9vxZbGR0rIxXePVW
lTGUFsW4rVYkkRLmPWhH8q/tArgEMuFpW8mECajxm20YTgvkoHts6EfTohcp
ovtaG7qvpkSAdV9iwvXTXCbslzb/2kKbf35oJ1ZQHMK/4qShMK6Ig/muJJjX
zYPlrmShFFNOgpjjZLHm5H4wz+kF08zuMCV0R0l8dxyL6Y6/DLteKoHnBCuA
97zs+eXcEJFk5+ZaYNekaoK1sDk1BUVjKH6eMhIVi2ai7qksNH71IOr23Y3S
rUn4JnE8jH/agMrNc/DM9kdw8LPP8Myzz9B+Mq2SJyQrlMktqFCi+ZrJI6jA
jSJ3nkh+ZP5DdqT8xi7uc6icQJYbex+59E3k0ilqGU6RTEQuAUfKuIUAC19l
Q4+VNvRaWY9eS03oPN0VDRHtnpq0hVLaQJt/GrRZJQIf/pWkjIJ5dSIsufNh
WZ9CiplPM4SUsjKB/FisnCm0Js+PgHFuPxhn3wJjQjilHiie2QvHpvfCGyM6
S7LslpwHE7cehtJvn1M3XSnKfx/KyCPyNIPPSmgfoqTQlFpUJnTjDHGqNmSi
cvsiWHelCr0c2bka+5fNxT+Xx8F+4B5YHpiFvY88jOeffx6bNm9i1TgVwypK
sbzooZTxuQ1IediGtO12pD0iwZtLwM1k4DZbMZnczlgCbXguAbfWiv45VvQm
wHquIACzrei7gmJ8Aq5rnKdStGnzry20+eeHdkKJOlNK0mil2JACy8Y0WO5J
gzk3BSZyXcZVM50zpTSxP0pn9aYZ0hMlCbeQp+uLozP64o1RXaUynCdDjDkr
Q86UsK2kjS7e2piRp84Wo9CIcwEXweeBd3D8wTkUoo0RGvgyJxmfP7gR+1Mn
EmPTkL9wLIwjBqLwP5/mmaJqo0zHhMRRE2vDqCIWs8mKjEftWPqYAxk77Eh9
2I6kB+yYST4llvzJZEJr7DpCjMx90CorBqywos9yK25ZRmjR/dbsOtyaWYpu
cR+4tGFUFxFf2vxrC23+adCWB3ZxhSJvzIqBZXMGLFuWyvuGVJjXJDkXEQ5z
PX/FCX1QHHcL3fuicPat+D7+Vrw+ppu3Vlgj7K3EFBFKCWmulKQST6XoxL6s
A04N7o+/j4zAwaGD8GX8aOGxeN3Y0b2z0MeJ+TF459mnYCoswEtP7ta7dPGS
jy6yf+/Ayt0OZP3OgXSy4Pm0jswm651B7mQKbbSiCC+OUm8nvG4jvAYQTv1J
FwPJeiPIegcuLUX3eE9dGLRoq/uGUK1+8lzSA+eyX2Wj/NcrUfbLLLL+dNfn
BqVLpqA0LQolC5zx0zXkf/qjeDYZX2IEvksYiNfGdHeD7DR7CbLL9DtLlEd9
TcvIEYkyH94yygvNwvSTk5Nhefk5Yf6frc8ViwI7Hl4onCb/wogI5L/1tnBa
6lLNcZNZwLyDyYXzlFKxZje95kkH7npKYrL0UQdSyRMl3W9HArnv2I02TCIv
MZa8xPDVDRhCa/AgCjMjCPNBlAYTZhGZRtwc/75rTXVi7UNbxbqDVj8vrNm9
Vzy8BhXb72K8nbsEY3YCSu+Mpf3wJNobj0XxvOGK81nxnEEomDOYoI7Aa2Nv
drIy8gj73YgvJdR9XlA8DLrLq7wbhjKRoT4hz87ZqCXUToPmPde3r7+Oqvmz
UP9gJurvnYGKGUNx7L57kZe9BK8NH42zZ8+i0Wr1RvplD4PmIGXTnx3YsteB
dQTG8l3SEaQ8JF0+Ax1Da+Tk9Qx0A0aTYQ/PacDQHHnKMGRFLSLIMD1Adhm0
D23XRlijnxfIHNxU7tqEyt1bCOh1sB/8RNaTOzevnquiHUNoTxZol6SMFs/r
33sNxcmRKJg7BN/NdKHdDGwPu27XGti8WIq/vKkn9r+eHoOGMrnbbfj8Q5RG
9Bd5RriS9mx8HMSIy52wFtwLfmPDI6804rHXGrHtOQk52/ad/2FH+na50iYR
bIkUN8ZtsWIGJQ7yJ5JfGZvL0JMfWFKCLtPe84A74mrQ9lKJZcMCVD/7CGr2
PoaqJ7YJtQh/s/VOWO5Nh5lDoLVJtHVLJPXEUZohNhClGROFoy+cNxxH4gdi
38gubVTJ0I/lG6XY4+RqThKYBZRKhUr4wEeqxCDcjVMFnMrip1EtKYGoc1tW
IyUea4EpmtGKZvWGs/9SdZK1044n32rE0/ubBH6b9ziQ+7QDq59wCH+c9Tta
HwnDJY/ZRdTC0cscivPjyYdMoakxak0dBiwuwY0xrlNLoh1xNWhL61R1UrYt
C2defhK1+54WuqnctRkVO3JR/tBqsR5YaC0oo7W37L4lMiLawNHQHBhXxpNu
pqCIQtgjMwbglWE3qjoZ9bUfnxTopRNd9GGW8SQ3JrUwzBRWKvwPV/V61gJl
yz77VEwFqQk/+tjuq4p7nnFg5xuNePyvjXjoRQfupjK76ezf27Fsp4RqMYUr
6eyhfktbrYdsmE0mPX2LNOOhq+rQe1EJhiz6HMbKs6oqrhrt2YXKTYJ25WP3
oOa5nTjzwuOofvohVDx2N8ppmSgnNZRtWybUYNm0mFI6LHfTVMmdR7uF2TRN
pospUpg8FIdjeuOduCEwljfJhZadEuvilgOsCw9V9HlBqmLyVwiI91IFzxAl
3cy8LS0LQkBWhcjx68gltKdLL+OnnPQu7zTVZ060w7LdZcgznsd6slOODZMf
lFumaRSd88kb+QwaYMJ6qw7j1tFlWE6DEoQhtIMdcGcDeqTVYPjyQhw5VceU
dJdBtKM/oupb40Is22VGU1Eemf16MvMM2oUlyx3YsmkU+tzBLohPdRZP0JEX
GqejdXkYsVpM60NhwgDkRffA4bnDUXPiCJY9XKATR9B6ia0E3TkBdOL1QKAT
cumR5p5kH1/APRjUpWVOqLMqqOXyKh3n+NSPnrjhL+NAX64OL4qXynoYFhqx
7A8VMFadVd97Bosy14v9HiXNNo9Tm3klcrkiRAxzJCJsna42DxfAMO6g26JY
uIH7nR73xj3imwpRy0Fd3DfivbwqWaCnZCyNnuWi2hV1QkIprHwZLlM0byq3
s4hB7mku40T5Fn1ukZg3Ov4sgD8QyAvkVZfPqo/z9wrfMV68ErPrdyZySzrn
QarkVwhHumB+A31YFRwtr9JDl1PbDvo17I0oq77S5hfkdP2OX9xTLpP/v1G/
pEIoSJdWJhIzLuaGnjnXM+tuzhXxRYNEa4b4DDD2uBIoQ4cp30mcu7wqXnGI
2epilU2WgXXCSAMLttZYoV/bxK9Eoaw/z+zlsuLUsrg78/SE8zzoen6pzvVB
6y7wO1XlEX46ld848avXXPn+Se0UKNq3E18n8BssAUVWrTjt5wNQ8d0B38VX
AHycGSLLbsV6fvXAu3nGh53LInHCwwbIwkflKarkOjX65dnCmAYtbxDiSvY7
babl5qYH6NLrEd6m9H8MuG2nSPSUrnpEPo7vZY4eijod5/To/ZCzB/VV+8sr
PXHVCcoGHkMvRwtee15YY73YwTBzKqd6ufgRo/y1A7FJaHIXRXBIYDJZHi7y
UTBXOozdRZeoJ9AOE59ENOeiXTkD50huynI7zzspgHJBTEcnpAjkYfjVuDT5
yC/klkFGz+ILmG8EfsyasDPxRQ3FoSIK4P2XdPeuu8vL8CK7SHgbcf5WJo7d
+FI9lbe1gc5jH36zqZ7M6VWFJoosn2vwaVec2bVtEm/iRF2FzMeJCR1Tyl/n
iG2/WU0V8g3IxCMGdRYE/B/qyG8o\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{268, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,25"},
 CellLabel->"Out[3]=",
 CellID->444216856]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData["WidgetAlign"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->28592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Label\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<These are inputs\>\""}], 
          "}"}], ",", "\[IndentingNewLine]", "   ", 
         RowBox[{"WidgetLayout", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Alignment\>\"", "\[Rule]", "Center"}], "}"}]}], ",", 
         RowBox[{"Name", "\[Rule]", "\"\<mainLabel\>\""}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<BB\>\""}], "}"}]}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<in\>\""}], "}"}]}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<CheckBox\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<label\>\"", "\[Rule]", "\"\<round\>\""}], "}"}]}], 
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<CCC\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<m\>\""}], "}"}]}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\< OR \>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<km\>\""}], "}"}]}], 
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"WidgetFill", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<mainLabel\>\"", ",", "After"}], "}"}], ",", 
           "Before"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Submit\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetFill", "[", "]"}]}], "}"}]}], "\[IndentingNewLine]", 
      "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,26"},
 CellLabel->"In[4]:=",
 CellID->29018],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject480219605499905, 
   JLink`Objects`JavaObject553653094055937]]], "Output",
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,26"},
 CellLabel->"Out[4]=",
 CellID->9265]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,27"},
 CellLabel->"In[5]:=",
 CellID->9370],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{268, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,27"},
 CellLabel->"Out[5]=",
 CellID->57627169]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8246],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetFill",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetFill"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetGroup"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetSpace"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20420]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9594],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 ButtonBox["Widget Layout in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"]
}], "Tutorials",
 CellID->1000152870]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WidgetAlign - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 11.9465976}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "WidgetAlign[] is a widget layout placeholder that provides an alignment \
marker. WidgetAlign[{ref, After}, Before] makes a specific request for the \
next widget to align to another widget by named reference ref, and aligned \
based on Before and After specifications on both widgets.", 
    "synonyms" -> {"widget align"}, "title" -> "WidgetAlign", "type" -> 
    "Symbol", "uri" -> "GUIKit/ref/WidgetAlign"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4150, 133, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->57635664]},
 "LayoutExamples"->{
  Cell[4956, 168, 3537, 83, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,24"},
   CellID->28735],
  Cell[8496, 253, 328, 8, 70, "Output",
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,24"},
   CellID->16616],
  Cell[8861, 266, 169, 4, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,25"},
   CellID->20113],
  Cell[9033, 272, 9819, 165, 70, "Output",
   Evaluatable->False,
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,25"},
   CellID->444216856],
  Cell[19005, 449, 4186, 94, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,26"},
   CellID->29018],
  Cell[23194, 545, 327, 8, 70, "Output",
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,26"},
   CellID->9265],
  Cell[23558, 558, 168, 4, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,27"},
   CellID->9370],
  Cell[23729, 564, 9806, 165, 70, "Output",
   Evaluatable->False,
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,27"},
   CellID->57627169]},
 "Ex--21907280849161310363,24"->{
  Cell[4956, 168, 3537, 83, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,24"},
   CellID->28735],
  Cell[8496, 253, 328, 8, 70, "Output",
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,24"},
   CellID->16616]},
 "Ex--21907280849161310363,25"->{
  Cell[8861, 266, 169, 4, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,25"},
   CellID->20113],
  Cell[9033, 272, 9819, 165, 70, "Output",
   Evaluatable->False,
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,25"},
   CellID->444216856]},
 "Ex--21907280849161310363,26"->{
  Cell[19005, 449, 4186, 94, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,26"},
   CellID->29018],
  Cell[23194, 545, 327, 8, 70, "Output",
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,26"},
   CellID->9265]},
 "Ex--21907280849161310363,27"->{
  Cell[23558, 558, 168, 4, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,27"},
   CellID->9370],
  Cell[23729, 564, 9806, 165, 70, "Output",
   Evaluatable->False,
   CellTags->{"LayoutExamples", "Ex--21907280849161310363,27"},
   CellID->57627169]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37275, 854},
 {"LayoutExamples", 37415, 858},
 {"Ex--21907280849161310363,24", 38495, 885},
 {"Ex--21907280849161310363,25", 38777, 892},
 {"Ex--21907280849161310363,26", 39087, 900},
 {"Ex--21907280849161310363,27", 39370, 907}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1728, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2351, 68, 49, 1, 70, "ObjectName",
 CellID->16461],
Cell[2403, 71, 979, 29, 70, "Usage",
 CellID->21846]
}, Open  ]],
Cell[CellGroupData[{
Cell[3419, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3897, 122, 216, 6, 70, "Notes",
 CellID->23458]
}, Closed]],
Cell[CellGroupData[{
Cell[4150, 133, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57635664],
Cell[CellGroupData[{
Cell[4534, 147, 147, 5, 70, "ExampleSection",
 CellID->20609425],
Cell[4684, 154, 128, 3, 70, "Input",
 CellID->91711584],
Cell[4815, 159, 116, 5, 70, "ExampleText",
 CellID->25419],
Cell[CellGroupData[{
Cell[4956, 168, 3537, 83, 70, "Input",
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,24"},
 CellID->28735],
Cell[8496, 253, 328, 8, 70, "Output",
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,24"},
 CellID->16616]
}, Open  ]],
Cell[CellGroupData[{
Cell[8861, 266, 169, 4, 70, "Input",
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,25"},
 CellID->20113],
Cell[9033, 272, 9819, 165, 70, "Output",
 Evaluatable->False,
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,25"},
 CellID->444216856]
}, Open  ]],
Cell[18867, 440, 113, 5, 70, "ExampleText",
 CellID->28592],
Cell[CellGroupData[{
Cell[19005, 449, 4186, 94, 70, "Input",
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,26"},
 CellID->29018],
Cell[23194, 545, 327, 8, 70, "Output",
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,26"},
 CellID->9265]
}, Open  ]],
Cell[CellGroupData[{
Cell[23558, 558, 168, 4, 70, "Input",
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,27"},
 CellID->9370],
Cell[23729, 564, 9806, 165, 70, "Output",
 Evaluatable->False,
 CellTags->{"LayoutExamples", "Ex--21907280849161310363,27"},
 CellID->57627169]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33596, 736, 310, 9, 70, "SeeAlsoSection",
 CellID->8246],
Cell[33909, 747, 981, 35, 70, "SeeAlso",
 CellID->20420]
}, Open  ]],
Cell[CellGroupData[{
Cell[34927, 787, 313, 9, 70, "TutorialsSection",
 CellID->9594],
Cell[35243, 798, 273, 9, 70, "Tutorials",
 CellID->341631938],
Cell[35519, 809, 449, 12, 70, "Tutorials",
 CellID->1000152870]
}, Open  ]],
Cell[35983, 824, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

