(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14394,        499]
NotebookOptionsPosition[      9820,        349]
NotebookOutlinePosition[     12302,        422]
CellTagsIndexPosition[     12082,        413]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{" GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          " Definition Building Blocks in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/DefinitionBuildingBlocks"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\" GUIKit User Guide\"\>", 
       2->"\<\" Definition Building Blocks in GUIKit User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetWidgetReference" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/SetWidgetReference"], 
          "UnsetWidgetReference" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/UnsetWidgetReference"], 
          "InvokeMethod" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/InvokeMethod"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SetWidgetReference\"\>", 
       2->"\<\"UnsetWidgetReference\"\>", 
       3->"\<\"InvokeMethod\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WidgetReference", "ObjectName",
 CellID->3954],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"WidgetReference", "[", 
       StyleBox["id", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]looks up an existing widget instance using identifier \
",
     Cell[BoxData[
      StyleBox["id", "TI"]], "InlineFormula"],
     " and return the underlying object."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19601]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["WidgetReference"], "InlineFormula"],
 " is used to find an existing widget instance and return the underlying \
object; it never creates a new instance. It is most useful if you want to \
pass the object from a widget to another function."
}], "Notes",
 CellTags->"WidgetReference",
 CellID->13940],

Cell["\<\
Other interface definition functions can assign names or identifiers to \
widgets to make them available for lookup.\
\>", "Notes",
 CellTags->"WidgetReference",
 CellID->2043]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->24981826],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->78073971],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->123147695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", " ", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", " ", "\[IndentingNewLine]", " ", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<Label\>\"", ",", " ", 
        RowBox[{"{", 
         RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Hello World!\>\""}], "}"}], 
        ",", " ", 
        RowBox[{"Name", "->", "\"\<myLabel\>\""}]}], "]"}], 
      "\[IndentingNewLine]", " ", "}"}]}], " ", "]"}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
 CellLabel->"In[2]:=",
 CellID->14702],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject242175036096513, 
   JLink`Objects`vm1`JavaObject533886580817921]]], "Output",
 CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
 CellLabel->"Out[2]=",
 CellID->8304928]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WidgetReference",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetReference"]], "InlineFormula"],
 " allows you to use a name to access the underlying object:"
}], "ExampleText",
 CellID->10606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"obj", " ", "=", " ", 
  RowBox[{"ref", " ", "@", " ", 
   RowBox[{"WidgetReference", "[", "\"\<myLabel\>\"", "]"}]}]}]], "Input",
 CellTags->"JavaAccess",
 CellLabel->"In[3]:=",
 CellID->21216515],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"javax", ".", "swing", ".", "JLabel"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject96663909695489]], "Output",
 CellTags->"JavaAccess",
 CellLabel->"Out[3]=",
 CellID->199675520]
}, Open  ]],

Cell["\<\
With the underlying object you can call methods that are not exposed as \
properties:\
\>", "ExampleText",
 CellTags->"WidgetReference",
 CellID->12276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"obj", "@", 
  RowBox[{"hashCode", "[", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->201559558],

Cell[BoxData["5761618"], "Output",
 CellLabel->"Out[4]=",
 CellID->51460837]
}, Open  ]],

Cell[TextData[{
 "It is also possible to call a method of a named widget using ",
 Cell[BoxData[
  ButtonBox["InvokeMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/InvokeMethod"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->713278315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "@", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<myLabel\>\"", ",", "\"\<hashCode\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->642091530],

Cell[BoxData["5761618"], "Output",
 CellLabel->"Out[5]=",
 CellID->250057761]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11472],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetWidgetReference",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/SetWidgetReference"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnsetWidgetReference",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/UnsetWidgetReference"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InvokeMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/InvokeMethod"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27149]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19718],

Cell[TextData[{
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->695430475],

Cell[TextData[{
 ButtonBox[" Definition Building Blocks in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks"]
}], "Tutorials",
 CellID->121076760]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WidgetReference - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 17.6650548}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "WidgetReference[id] looks up an existing widget instance using \
identifier id and return the underlying object.", 
    "synonyms" -> {"widget reference"}, "title" -> "WidgetReference", "type" -> 
    "Symbol", "uri" -> "GUIKit/ref/WidgetReference"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "WidgetReference"->{
  Cell[3420, 108, 329, 7, 70, "Notes",
   CellTags->"WidgetReference",
   CellID->13940],
  Cell[3752, 117, 186, 5, 70, "Notes",
   CellTags->"WidgetReference",
   CellID->2043],
  Cell[6495, 215, 162, 5, 70, "ExampleText",
   CellTags->"WidgetReference",
   CellID->12276]},
 "PrimaryExamplesSection"->{
  Cell[3975, 127, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->24981826]},
 "GUIRun"->{
  Cell[4663, 155, 661, 16, 70, "Input",
   CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
   CellID->14702],
  Cell[5327, 173, 331, 8, 70, "Output",
   CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
   CellID->8304928]},
 "Ex--21907299533234115765,102"->{
  Cell[4663, 155, 661, 16, 70, "Input",
   CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
   CellID->14702],
  Cell[5327, 173, 331, 8, 70, "Output",
   CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
   CellID->8304928]},
 "JavaAccess"->{
  Cell[5950, 195, 220, 6, 70, "Input",
   CellTags->"JavaAccess",
   CellID->21216515],
  Cell[6173, 203, 307, 9, 70, "Output",
   CellTags->"JavaAccess",
   CellID->199675520]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"WidgetReference", 10921, 375},
 {"PrimaryExamplesSection", 11226, 385},
 {"GUIRun", 11358, 389},
 {"Ex--21907299533234115765,102", 11628, 396},
 {"JavaAccess", 11880, 403}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1700, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2323, 67, 52, 1, 70, "ObjectName",
 CellID->3954],
Cell[2378, 70, 527, 16, 70, "Usage",
 CellID->19601]
}, Open  ]],
Cell[CellGroupData[{
Cell[2942, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3420, 108, 329, 7, 70, "Notes",
 CellTags->"WidgetReference",
 CellID->13940],
Cell[3752, 117, 186, 5, 70, "Notes",
 CellTags->"WidgetReference",
 CellID->2043]
}, Closed]],
Cell[CellGroupData[{
Cell[3975, 127, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->24981826],
Cell[CellGroupData[{
Cell[4359, 141, 147, 5, 70, "ExampleSection",
 CellID->78073971],
Cell[4509, 148, 129, 3, 70, "Input",
 CellID->123147695],
Cell[CellGroupData[{
Cell[4663, 155, 661, 16, 70, "Input",
 CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
 CellID->14702],
Cell[5327, 173, 331, 8, 70, "Output",
 CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
 CellID->8304928]
}, Open  ]],
Cell[5673, 184, 252, 7, 70, "ExampleText",
 CellID->10606],
Cell[CellGroupData[{
Cell[5950, 195, 220, 6, 70, "Input",
 CellTags->"JavaAccess",
 CellID->21216515],
Cell[6173, 203, 307, 9, 70, "Output",
 CellTags->"JavaAccess",
 CellID->199675520]
}, Open  ]],
Cell[6495, 215, 162, 5, 70, "ExampleText",
 CellTags->"WidgetReference",
 CellID->12276],
Cell[CellGroupData[{
Cell[6682, 224, 124, 4, 70, "Input",
 CellID->201559558],
Cell[6809, 230, 76, 2, 70, "Output",
 CellID->51460837]
}, Open  ]],
Cell[6900, 235, 259, 8, 70, "ExampleText",
 CellID->713278315],
Cell[CellGroupData[{
Cell[7184, 247, 215, 7, 70, "Input",
 CellID->642091530],
Cell[7402, 256, 77, 2, 70, "Output",
 CellID->250057761]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7540, 265, 311, 9, 70, "SeeAlsoSection",
 CellID->11472],
Cell[7854, 276, 769, 26, 70, "SeeAlso",
 CellID->27149]
}, Open  ]],
Cell[CellGroupData[{
Cell[8660, 307, 314, 9, 70, "TutorialsSection",
 CellID->19718],
Cell[8977, 318, 360, 12, 70, "Tutorials",
 CellID->695430475],
Cell[9340, 332, 438, 12, 70, "Tutorials",
 CellID->121076760]
}, Open  ]],
Cell[9793, 347, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

