(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13239,        423]
NotebookOptionsPosition[      8697,        292]
NotebookOutlinePosition[     11493,        364]
CellTagsIndexPosition[     11271,        356]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "XML Syntax in GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/XMLReference"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"XML Syntax in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WidgetToSymbolicGUIKitXML", "ObjectName",
 CellID->14762],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"WidgetToSymbolicGUIKitXML", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts a user interface expression to a GUIKitXML \
SymbolicXML expression."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7639]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["WidgetToSymbolicGUIKitXML"], "InlineFormula"],
 " is also used to support ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "\"\<GUIKitXML\>\""}], "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellTags->"WidgetToSymbolicGUIKitXML",
 CellID->17508]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->187815761],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->358249905],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->5544169],

Cell["\<\
Convert a user interface expression to GUIKitXML SymbolicXML:\
\>", "ExampleText",
 CellID->5466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WidgetToSymbolicGUIKitXML", "[", " ", "\[IndentingNewLine]", "  ", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Panel\>\"", ",", " ", 
    RowBox[{"{", "\[IndentingNewLine]", "  ", 
     RowBox[{"Widget", "[", 
      RowBox[{"\"\<Label\>\"", ",", "  ", 
       RowBox[{"{", " ", 
        RowBox[{"\"\<text\>\"", "->", "\"\<Hello World!\>\""}], "}"}]}], 
      "]"}], "  ", "\[IndentingNewLine]", "    ", "}"}]}], " ", "]"}], " ", 
  "\[IndentingNewLine]", "  ", "]"}]], "Input",
 CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,193"},
 CellLabel->"In[2]:=",
 CellID->11373],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"widget\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"src\"\>", "\[Rule]", "\<\"Panel\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"group\"\>", ",", 
        RowBox[{"{", 
         RowBox[{"\<\"root\"\>", "\[Rule]", "\<\"true\"\>"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{"\<\"widget\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"src\"\>", "\[Rule]", "\<\"Label\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"group\"\>", ",", 
              RowBox[{"{", 
               RowBox[{"\<\"root\"\>", "\[Rule]", "\<\"true\"\>"}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"property\"\>", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\<\"name\"\>", "\[Rule]", "\<\"text\"\>"}], ",", 
                   
                   RowBox[{"\<\"value\"\>", 
                    "\[Rule]", "\<\"Hello World!\"\>"}]}], "}"}], ",", 
                 RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}], "}"}]}], "]"}], 
         "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,193"},
 CellLabel->"Out[2]=",
 CellID->30750]
}, Open  ]],

Cell["Export the result to XML:", "ExampleText",
 CellID->32060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"%", ",", " ", "\"\<XML\>\""}], "]"}]], "Input",
 CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,194"},
 CellLabel->"In[3]:=",
 CellID->9341],

Cell[BoxData["\<\"<widget src='Panel'>\\n <group root='true'>\\n  <widget \
src='Label'>\\n   <group root='true'>\\n    <property name='text'\\n        \
value='Hello World!'/>\\n   </group>\\n  </widget>\\n \
</group>\\n</widget>\"\>"], "Output",
 CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,194"},
 CellLabel->"Out[3]=",
 CellID->32093]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9122],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Widget",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Widget"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->3935]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17460],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->29045],

Cell[TextData[{
 ButtonBox["XML Syntax in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/XMLReference"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/XMLReference"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/XMLReference"]
}], "Tutorials",
 CellID->393062269]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WidgetToSymbolicGUIKitXML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 19.7743218}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "WidgetToSymbolicGUIKitXML[expr] converts a user interface expression to \
a GUIKitXML SymbolicXML expression.", 
    "synonyms" -> {"widget to symbolic kit"}, "title" -> 
    "WidgetToSymbolicGUIKitXML", "type" -> "Symbol", "uri" -> 
    "GUIKit/ref/WidgetToSymbolicGUIKitXML"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "WidgetToSymbolicGUIKitXML"->{
  Cell[2962, 97, 394, 14, 70, "Notes",
   CellTags->"WidgetToSymbolicGUIKitXML",
   CellID->17508],
  Cell[4191, 149, 613, 13, 70, "Input",
   CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,193"},
   CellID->11373],
  Cell[4807, 164, 1583, 39, 70, "Output",
   CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,193"},
   CellID->30750],
  Cell[6494, 211, 215, 5, 70, "Input",
   CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,194"},
   CellID->9341],
  Cell[6712, 218, 360, 6, 70, "Output",
   CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,194"},
   CellID->32093]},
 "PrimaryExamplesSection"->{
  Cell[3393, 116, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->187815761]},
 "Ex--21907299533234115765,193"->{
  Cell[4191, 149, 613, 13, 70, "Input",
   CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,193"},
   CellID->11373],
  Cell[4807, 164, 1583, 39, 70, "Output",
   CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,193"},
   CellID->30750]},
 "Ex--21907299533234115765,194"->{
  Cell[6494, 211, 215, 5, 70, "Input",
   CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,194"},
   CellID->9341],
  Cell[6712, 218, 360, 6, 70, "Output",
   CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,194"},
   CellID->32093]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"WidgetToSymbolicGUIKitXML", 9846, 319},
 {"PrimaryExamplesSection", 10516, 335},
 {"Ex--21907299533234115765,193", 10671, 339},
 {"Ex--21907299533234115765,194", 10979, 346}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1308, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1931, 59, 63, 1, 70, "ObjectName",
 CellID->14762],
Cell[1997, 62, 450, 13, 70, "Usage",
 CellID->7639]
}, Open  ]],
Cell[CellGroupData[{
Cell[2484, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2962, 97, 394, 14, 70, "Notes",
 CellTags->"WidgetToSymbolicGUIKitXML",
 CellID->17508]
}, Closed]],
Cell[CellGroupData[{
Cell[3393, 116, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->187815761],
Cell[CellGroupData[{
Cell[3778, 130, 148, 5, 70, "ExampleSection",
 CellID->358249905],
Cell[3929, 137, 127, 3, 70, "Input",
 CellID->5544169],
Cell[4059, 142, 107, 3, 70, "ExampleText",
 CellID->5466],
Cell[CellGroupData[{
Cell[4191, 149, 613, 13, 70, "Input",
 CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,193"},
 CellID->11373],
Cell[4807, 164, 1583, 39, 70, "Output",
 CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,193"},
 CellID->30750]
}, Open  ]],
Cell[6405, 206, 64, 1, 70, "ExampleText",
 CellID->32060],
Cell[CellGroupData[{
Cell[6494, 211, 215, 5, 70, "Input",
 CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,194"},
 CellID->9341],
Cell[6712, 218, 360, 6, 70, "Output",
 CellTags->{"WidgetToSymbolicGUIKitXML", "Ex--21907299533234115765,194"},
 CellID->32093]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7133, 231, 310, 9, 70, "SeeAlsoSection",
 CellID->9122],
Cell[7446, 242, 198, 6, 70, "SeeAlso",
 CellID->3935]
}, Open  ]],
Cell[CellGroupData[{
Cell[7681, 253, 314, 9, 70, "TutorialsSection",
 CellID->17460],
Cell[7998, 264, 269, 9, 70, "Tutorials",
 CellID->29045],
Cell[8270, 275, 385, 12, 70, "Tutorials",
 CellID->393062269]
}, Open  ]],
Cell[8670, 290, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

