(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28195,        690]
NotebookOptionsPosition[     23136,        538]
NotebookOutlinePosition[     26277,        624]
CellTagsIndexPosition[     25981,        614]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "Checkbox" :> 
          Documentation`HelpLookup["paclet:ref/Checkbox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"Checkbox\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"CheckBox\"", "ObjectName",
 CellID->32271],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<CheckBox\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a checkbox. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31825]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following properties are available:", "Notes",
 CellID->9228],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", "\"\<\>\"", Cell[
    "text label", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"selected\", \"TI\"]\)\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether the checkbox is selected", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->31173],

Cell["The following event is available: ", "Notes",
 CellID->13454],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<change\>\"", Cell[TextData[{
     "the event ",
     StyleBox["triggered when the checkbox is clicked", "Text"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->10309]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->102224079],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->136208896],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->800952925],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<CheckBox\>\"", ",", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<text\>\"", "->", "\"\<Choose\>\""}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"CheckBox", "Ex--21907280849161310363,32"},
 CellLabel->"In[2]:=",
 CellID->31197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"CheckBox", "Ex--21907280849161310363,33"},
 CellLabel->"In[3]:=",
 CellID->19056],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWgtYVdW2XuzNQywtRRCTVFSUCE0Q36Ii8pCXPFXkIaAgKL7AfKXZQ4+3
hzdNO147vfzq697K6tSpzLJu79M52adZqfkIhL3ZewNmPDYbNP3vGHOutdng
Rumc4/3uXd8315prrjnHHOMfY4455pwrMX9NceHy/DUli/KHxJTlryouWVQ+
JHplGRXpXRRFuY/SpCEK50FZ7aaH0m8fFK/HOSnrxV1RXKH4vAFl0Atq2u/B
GT3n3DjnDuVO8co3mdvfISc/7NeplQft5xYOH9ztpPTqVzV3a8e2/Lqf2RFs
vMhvUAb+yUXlkygMOIoeIT+hV8xp3J5egZ6zfyKZXCNOEY1p53pACT/LOb6F
n3NXX8PPaWXTZJmOc3qtssy5X9NC1utM6lqi4ed0HZsJUixF+FkoE45BCT7M
0lwrRd9UI3yW/oIeGedICo85tSuhxDYoetly1McMseLSriS1mdqkHPWWU1w5
tkE2uKayR6jzytO48v7fQXnQNZRDTnVduTNlj3bK3qJyAFsj5/4vPZVJHSA6
d31BXLlyL/ilPFDQGVknYHVspnhyOzQ0XERTUwOs1mbYbC1oa2vF5cuXcOXK
b7h69SqRpIvuXJd55JY6rTOVb37zd1I2oYNSznWHqZ6io4sX62/EmM4JX4KE
YEFy6ObIjR1hnb2W/rq5KTc0qR6due8l2am3dEcCFoDrS7Z19s4dQFRuVpno
bdI/KqDZbOy2kHYBO9mGLPNwpqHfJVK7Pbp2oEX5aZ2H0vW8jaN8RmNVt2X8
35FP++B+jd6m/Q69VVX93G3ZriuXrn2M3Txj5beJ/6iolZVnui3u9VXo6sjk
jb1Ge05mtdbdEuWUM1F+/vmnbovDorh1w/Lm3pAZh1nbkZmzZ092myFnuEoH
7MR6+O2OG84hzia2LmBjTrvLLXNa0I2OuoSku511ZWo3nj27I/m1kYDzgKy9
2f+bSCjceSR0nfjvdwWL/1yAG3baaeUpp6H4v+JY+Y6jVFopU3wljYPIo1TZ
JfIoXGYd40RBmS7qmJ6zOi5X9PIL16A3H37rx828+X2QSkDQG02shX7KvXk/
Sb15dO6NmD/C9UU3OtmNEkeuyiXxLNNIphqJ1fSs4gFKdypLO8857S25Koir
UP/RlfzONOOrxZu7VhZJXMwQSS4g+D7ttCyTbzM6lE07zb1N/kmhVdPEU5yD
Mu6UzPOTeZ9Yy5IxjI8pYuGiCRZfJ1lOr2Yi82sY4vlUll0PJe8XKAsb9dAX
NrhCX9xMneqLL8FlqUhUk+/ESOEVuCxu46SQYHltfPtN5BjC7DZ+lc/MVigL
rNRDE5R5LaJHG/c4rwVKRjOUlGZ+6jjjyjnmNOVXKAkX5VPW4XYJTYRXzEUX
Fs3FUTaPjrLNJxmyGrUntdTn8bpMn9/CErE89Oa+tI1upb95QL/sMul16VVv
/qJj0eizW9FlFP3JKqLl29SY2Xjhiiijb0rX9TxkvX1NcMu3MSACBrdcG4r+
2KTcLur0gLH+NxTtboDbnEYWjOUiW6jtrDVNsqoOkrnkWVkaNsfCNlVDJA+L
Q2UeK6/QerTsiivcV1+lj2Wg2wr0ZxkVbyx5rgXHTjcgcO7n6DX9PfSZ9RH6
Rn2IflGH0HfWIXhFHYZX9Ee4Pepj9Ir6BD2jPkWPWZ/DPeIT6Kd/ApfpnxND
H2Nw0iEcPXWB6SkCPyXkX06bkWVTY2Mq2mfFLyeO4d1ZgXj57l44MKYPXgvp
i1dC++GVMX1xINQLr1N6I+R2vDWmF94e3RPvjOqBt4Lc8VagHu+MdMEbwxUc
mDoYtT8cFegL49PQl8grGvSunaHXMe5ULO3okkS99DcBuI4Bd4fHGlpgaaj3
Z9R1KurGX64gMLcCXnMqMDCjAv4LqhCQfR4jcioxnJ7DcqvgT2kQpYELjfDJ
NcIrpwa9s4zwnF8D1/QauCQRL1HfEzrvCyvSUL8JtO2osy1/OzsQRyZ64ci0
gTg6yx9HYwIojcDR6OE4FjMM30X743jUIPwYNRA/zvTBiRle+DG8N05M8sSP
41zx3RgXfBak4DVCXtC+DurXGrxq7MLUeyMjI0OA68rg+qjg8tU7+QL8si4i
cNGvuKf4V4xd1oCw0gaElDYiZHkjRq9sRNCqRgSsasLglU0YsLwZXkub0auo
GR55TdAtIF+TSN1OPuQA7s2iTdCqtE9N6I0zkX44lxCIn1PvQUXGWFTOC0Nl
Rggq54bg/NzRqMoIgiEtAIbkwTAmDIAx1gvGyF4wTPNA5UQdvrtHwavDFI12
QhN76I7gismNJovBxzt6k4XSmxC4eH7/C+4wGAzUuOr0GZjMZk5k8HV1dXSn
z4w5XEqvchrggE+/uU0IKGhGyLJmTFrdjPA1VkotmHKvFZPWWjFhnRWh61sQ
vN6GgHU2DF5rw4AyG/qsaMUtxTa45TVDl0ZGGP6xJgM515CbQds+L/F1bmo/
VMYH4Hx6CKqzJsGQGw7DQkq5U2DMnURpAmpyQmHKCoZ5XgAs6YNhSR4AS1wf
mGfdAkO4G06M1eHNES6SdmdHHvKVHXtPKMNOqHOUSc63C+2eXIBbUlJCkpMC
dAL3njhz5gy+fOxx8SQdCI1wnp/8zo1ICTqekwVk/cV87CZ48c1swmia7SYT
ZjPXWWlgMYOeCNrUiuEbW3HnulZ4l7eid2krPBc1w22uCbrp/+1gn87p3CJq
+DlrZ5/v+fp5hi/Op4xGdfZkGApmwvrpu6K8pjCSUgRqFofDVDAR5rxQWLKD
UJs5XHy3vb8fltjeMM7wxMnxbvjzSLFlpWNg2awjzBLa4K/t0Lq2Q8vAp9Tp
GFuOAQldBomNWiBL3DOAlMPfipfAkpWCDz74QAJNz0/37BLgNjU1cTs5v+oY
VF8R2UhEBuU0YfwKQoOsb/Z97ciO2kwWSMgOImT7E7J9ltuEB7gl0yQmOA3Z
NkLPCR1RFne/DbH3tyBqSwsiHiArp+e4LbYOtPlyQltGWBQt8VVB7rhq/niB
vHHJbLkb6Yaa4iiYlkTAtHgKzAXjUJs7St2p7CmMumZWL5yccgveuttdktSM
mVFntyEiEwG6m+pLGHQD9VvL8aMikb9VoF5eXi7QZLTfjU/Esb9+hZOZ81BV
koKK1Tn4ZukCfDpsGN75y1+kclyxZ/duOb3K1J81qOPwUYU+oKAJ4eXNiCW4
kh5oaYd+kw0jNrRiCDmAAeU2+Ky0waukGbfnmNFzlt2oiY63MzqiLOnBFsRT
PoYgn0lpKqXxDL0Dbb66oJ3RoEjM2KFUkyMxLolFTWkSapYna5vBpuKZMBVO
JejHq7C7C39iTvCBIcYLp6ZT6DKqp2rvEWaxRqmSa5Sgg46uhKHnRZWA3tge
vpNLYeg/++wz1eB74ausbHwQNALN2dGoT4mE6eVSHMwLx94Rdwq8d+18Ah9s
WSeejDsHOQIrXxE9S8DuJlubtZ7AIlBSH2pB2sMtSKFn4oNkr1QWSSmc7Hbc
phaM2kiAEVj+a2wYuNoG3xWUaDb0WWjCbTH2cTC/SRnklDZf3aEtvNO1tFkV
YuXA1/k5d8OwaBZqliXBtDKVUhpqVqRI8G8nZYRDu65aG2BO94c5eSBMib4w
xPniJEUzb4fcJsnyGJhxvn3VGHRQU0h/KEO+losvVkiKscN6ihVy5JsjOHf4
Q/xw+DC+mhOD6kXhsL60DDV78lFfMAFnJgbjbyEj8UHsOPyaHofTJ07guRee
FysXHethAE/XqjJCaSqM32xFOilh7lYbMh62CeASyXpjN5P1ElBTN7YgjKbF
UWtbMIJGhD8pwm9lC/yWUyLA/PJr0DfWbr1d0uarO7T56oJ2Sh0FHnxVpYfC
WBIP06p0mFbPhXlVhlBKTWmiGN5krKaMETCl+qMmyQ81iX6oTvDDiWg//Hls
X6kEHg6sAF7kstOXw0KEjj7XaoG9kqoJ1sLGrEycn0QBc+R41GUnoXFfIdr+
vhWNB+6FYXM6vk2ZCuNza1C/MRXPPPoIjnzxBZ559hlaQObU81hkhTK5+XWE
Ft152NeqwE0gT55CLmTeNhsy/2ATz1R6TyTLjbmPvPkG8uYUq4RR/BJcRsCR
MoYSYIOWtWDw0hb4L22Cf0ENfGbbYyCiPcQpbaGUbtDmywltVonAh6/qzAkw
LU+BuWwezOWZpJh5NEJIKUsTyYXFyJFC0/G8YBjTRsCYPBTGxEGUBqMqyR8n
ZvvjzXE+kix7JG0n4q5jUEYc0HRD5nvHYSjjj8vtC94coYWHkklDKtsidKMF
NhfWLEL9o9mw7soSejm+czkOFqXhr0viYTu0FuaH5mD/I9vx0ksvYcPGDawa
TTGsokyzj4NSppY1I3N7C3IetSHnEQleGgGXxMBttCKC3M5kAi2sjIBbacXI
UiuGEWBDSgjAYisCSiioJ+AGxDsqxTltvrpDm68uaCdWqyOlOocmiTWZMK/L
gXltDkxlmagh12VclqSNFEPKSBjmDKMRMgTViUPJ0wXgx7gAvDlhgFSGthXE
mLMy5EjpvZm04dtRG3Fn1dFiFBrR5m4Rch56Dye3plJ0Nklo4OvSDHy5dR0O
Zk0nxmJxbsFkGMcFofI/nuaRomrDomNCYm+JtWFUEYveYEXe4zYU7GhF3mM2
ZG23If0hG5LIp8SQP4kgtCavJsTI3EctsyKwxIrhS6wYWkRo0fOu4kbctciA
gfEf2bVhVCeRzrT56g5tvpzQljt08ZUibyyMhnljHsybCuRzTRZMK9K1SYQj
XMerKnE4quKH0jMAlcl34YeEu/DGpIEdtcIaYW8lhohQSo9rlZJe7agUnViI
3Yozo0fi/fHBOBI6Cl8nTBQei+eNx/x8hD5OzYvGe8/uQ01lBf5r7269XRf9
O+mi+MlWLN3disInWpFLFjyP5pFkst44cieRtLwKJ7w4QL2H8Lqb8AoknEaS
LoLIeoPJeoMKDPBLcNSFmzPa6pKhl7N2ciPSAWfLg8WofXgpLPcXkvXn2s/R
DfmRMOSEo3q+FjrdQv5nJKqSyfhSgvF9YhBen+TXDrJm9hJku+n7SJQnfEPT
yHGJMu/WMsoLTML0MzIyYH7lRWH+X5SXiUmBHQ9PFJrJvzwuGOfeeVc4LXWq
5pDJJGD2dYCZPfSKva1YtU/CUfB4K7LICaU/YEMiee6YdS2YQQ5iMjmIsOXN
GEPT7ygKLoMJ7lGURhNcwYuMuDPhsH061WDuRFuF+VZn7TrAzJ69bvsK1D26
iqHW1gbG4kQYFsfQAngGLYYno2pumKJ9q0odhYrU0YRyMF6ffKfGyvjj7HKD
v5YoD39ZcbBl39d4+QtlOqN8Su6Tsz1LlDVb5pXWd2+8gQvz5qBp6yI0rY9D
XVwoTty3HmeL8/F62ERcvnwZbVZr1yBzfLLh+VZs2t+K1QTGkl3SB2Ruk96e
gY6m6TGinIFuxkSy6bDSZoSWym2FMSUNCCabdADZbsudaNuXv07adQCZ45r6
XRtQv3sTAb0atiOfyXLy5KblaSra0YR2hEC7OnOi+N704euoyghBRdoYfJ9k
R/sasB1M2vNGYPM8SUIR1sT+N7Oj0WyRa9zmLz+GIXikyDPC9bRS460fRlyu
f53BPf8PLXjk1TbseL0NW16UkLNtL/53G3IflZNsOsGWQiFj/CYr4ihxfD+d
XMrkMoaeXEB+NXxjP3SAO/hm0O6gEvOa+fjl2Udwcf8OXHhqi1CLcDWbF8O8
Phcmjn5WptOCLYXUE08pTqwdDHnThY+vnBuG4wlBODDet5sqCf1Unh7FnCQv
c5rArKBkECrhHR6pEjfhaTQVcLIkxFIpKYGoc11WIyXua36NN6OlE4c3Uh2F
O23Y+04bnj54SUC38YVWlD3diuVPtQovXPgEzYoEX/4Om4hVOGZJpeg+gdxH
JI2KCSsaEbiwGt7R9s3JtPOqOv7FtKVhquqwbCnEr6/sRcOBp4Va6ndtRN1j
ZajdtlzMAmaaASw041ruy5dx0BqOgVJhXJpAaonEeQpcj8cF4tWx3qo6JnzT
hTty7aAOXdQxlvE0VyaNMMIUTNIb6UDPCqCs5YvPxSiQSuhCFf0dtLD2mVbs
fLMNe95uw7b/bMW99M7OufhJG4p2SpQWUnySy37p32htta0FyWTIszdJ4w1d
1ohh2dUYk/0ljPWXVS3cNNrJlcodgnb9jrW4+OJO/PryHvzy9DbU7bgXtTQ5
1JIGLFuKhAbMGxZSyoX5XhogZXNpeZBMg2O2GBiVGaE4Fj0M78WPgbH2kpxZ
2RWxGoYeYjU4aGH4y1ILEX+HS0IHLfC4UHJNzFuBxR0uhXUixweO+bSIy7Xw
V056u0/q1z4SPFG0pxZnjVdQTtbJcWDGVrk8iqVInDfYyEkQ7WnlVh2mrKbb
2NJmxR1jaLUauLgZg3MuImxJJY6faUTRbosE35Ozv5ton66IqkfClSjaZcKl
82fJ2MvJuPNoxZUhV1tFsRTmzGSfw5s3C6fpyO1M0dFEPJZYraIJoTIxEGej
BuNYWhgunjqOou0VOrHJrJewSrw1s9eJvX9XDW3pgtJOs1Ov4BaMZ4FFQ7mw
jmouuaDjHG/u0Zd25C0c1MvpwEecGOvhtsCIoj/WwXjhsnqo6SHeuVys7Sg5
rbOH6sytlvMTIeKWKhFhw7TX2V4BtylH2o2JhQs6qLlY7xfEX0KilAO4+G/F
obsqmaujZCyNnuWi0pJGIaEUVp50y+TNC8i7WET39sEtY0J5RJ52XgwZHZ/5
8+n/WVeeZnlL+iT/jPA948VTL/t6LZEz0mn7pZJfIRzpgvl17cSq4GjJBT10
pQ2e0K9gH0RZ9byaT7/pPpNP5Sm3qJ461OfXCQXpciwiMeNiWOiZcz2z3s65
In5XkGjFiR/jYk4qrjJWiPxe4uz7mjjEEAPVziqbLAOrwUgdC7ZWWKFfeYnP
O6GUX2H2ylhx6rt4ann6wnnutJxPzLncffVVPjBVAvlrPz5O4nPVMnm4pDZy
FfU9xa8HfDwloChsEJv6vM8pfirgpzji513LHvK9XbGOvzTwyl2nbtpki90c
NkAWPvysokquU8NdHi2MqfuSZiGuZN9rI00ydzxEN/9HeEkycgdw906R6Cvd
9QjZg0iZo4+iTMc5PYZt01pQW7W9vNMXe5mg7MZ96GVvHiuvCGtsEqsVZk7l
VC+nPGKUf2UgNglNbqIIDglMJsvdhTwO5kqHybvoFv4UPDF9L7w518+ec+Mc
yU1Zruf4JAVQzp3p6IQUrtwNn3tLkw/5Sq4RZLgsfm/5VuDHrAk7E7/LUOAp
5n5ea0lPb3/avQxPrdnC24i9NovYYuvHe5P9eAnrqm3x8LGlugunVxWaIrK8
h8E7W/Em+zpJnLWJsjqZjxcDOtrAv96IJb5JTXXyoGP6cTd1FLj8D0nuo9o=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"CheckBox", "Ex--21907280849161310363,33"},
 CellLabel->"Out[3]=",
 CellID->5904814]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<CheckBox\>\"", ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<text\>\"", "->", "\"\<Choose\>\""}], ",", "  ", 
        RowBox[{"\"\<selected\>\"", "\[Rule]", "True"}]}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"CheckBox", "Ex--21907280849161310363,34"},
 CellLabel->"In[4]:=",
 CellID->30589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"CheckBox", "Ex--21907280849161310363,35"},
 CellLabel->"In[5]:=",
 CellID->26862],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"CheckBox", "Ex--21907280849161310363,35"},
 CellLabel->"Out[5]=",
 CellID->46334097]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24853],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Checkbox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Checkbox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20448]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6430],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"CheckBox\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 22.9929070}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"CheckBox\"Widget[\"CheckBox\"] represents a checkbox. ", 
    "synonyms" -> {"check box"}, "title" -> "CheckBox", "type" -> "Widget", 
    "uri" -> "GUIKit/widget/CheckBox"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4032, 135, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->102224079]},
 "CheckBox"->{
  Cell[4700, 161, 415, 11, 70, "Input",
   CellTags->{"CheckBox", "Ex--21907280849161310363,32"},
   CellID->31197],
  Cell[5140, 176, 163, 4, 70, "Input",
   CellTags->{"CheckBox", "Ex--21907280849161310363,33"},
   CellID->19056],
  Cell[5306, 182, 7769, 132, 70, "Output",
   Evaluatable->False,
   CellTags->{"CheckBox", "Ex--21907280849161310363,33"},
   CellID->5904814],
  Cell[13090, 317, 503, 13, 70, "Input",
   CellTags->{"CheckBox", "Ex--21907280849161310363,34"},
   CellID->30589],
  Cell[13618, 334, 163, 4, 70, "Input",
   CellTags->{"CheckBox", "Ex--21907280849161310363,35"},
   CellID->26862],
  Cell[13784, 340, 7859, 133, 70, "Output",
   Evaluatable->False,
   CellTags->{"CheckBox", "Ex--21907280849161310363,35"},
   CellID->46334097]},
 "Ex--21907280849161310363,32"->{
  Cell[4700, 161, 415, 11, 70, "Input",
   CellTags->{"CheckBox", "Ex--21907280849161310363,32"},
   CellID->31197]},
 "Ex--21907280849161310363,33"->{
  Cell[5140, 176, 163, 4, 70, "Input",
   CellTags->{"CheckBox", "Ex--21907280849161310363,33"},
   CellID->19056],
  Cell[5306, 182, 7769, 132, 70, "Output",
   Evaluatable->False,
   CellTags->{"CheckBox", "Ex--21907280849161310363,33"},
   CellID->5904814]},
 "Ex--21907280849161310363,34"->{
  Cell[13090, 317, 503, 13, 70, "Input",
   CellTags->{"CheckBox", "Ex--21907280849161310363,34"},
   CellID->30589]},
 "Ex--21907280849161310363,35"->{
  Cell[13618, 334, 163, 4, 70, "Input",
   CellTags->{"CheckBox", "Ex--21907280849161310363,35"},
   CellID->26862],
  Cell[13784, 340, 7859, 133, 70, "Output",
   Evaluatable->False,
   CellTags->{"CheckBox", "Ex--21907280849161310363,35"},
   CellID->46334097]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24162, 562},
 {"CheckBox", 24297, 566},
 {"Ex--21907280849161310363,32", 25092, 587},
 {"Ex--21907280849161310363,33", 25244, 591},
 {"Ex--21907280849161310363,34", 25540, 599},
 {"Ex--21907280849161310363,35", 25693, 603}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1243, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1866, 59, 50, 1, 70, "ObjectName",
 CellID->32271],
Cell[1919, 62, 366, 11, 70, "Usage",
 CellID->31825]
}, Open  ]],
Cell[CellGroupData[{
Cell[2322, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2800, 95, 71, 1, 70, "Notes",
 CellID->9228],
Cell[2874, 98, 626, 16, 70, "3ColumnTableMod",
 CellID->31173],
Cell[3503, 116, 67, 1, 70, "Notes",
 CellID->13454],
Cell[3573, 119, 422, 11, 70, "2ColumnTableMod",
 CellID->10309]
}, Closed]],
Cell[CellGroupData[{
Cell[4032, 135, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->102224079],
Cell[CellGroupData[{
Cell[4417, 149, 148, 5, 70, "ExampleSection",
 CellID->136208896],
Cell[4568, 156, 129, 3, 70, "Input",
 CellID->800952925],
Cell[4700, 161, 415, 11, 70, "Input",
 CellTags->{"CheckBox", "Ex--21907280849161310363,32"},
 CellID->31197],
Cell[CellGroupData[{
Cell[5140, 176, 163, 4, 70, "Input",
 CellTags->{"CheckBox", "Ex--21907280849161310363,33"},
 CellID->19056],
Cell[5306, 182, 7769, 132, 70, "Output",
 Evaluatable->False,
 CellTags->{"CheckBox", "Ex--21907280849161310363,33"},
 CellID->5904814]
}, Open  ]],
Cell[13090, 317, 503, 13, 70, "Input",
 CellTags->{"CheckBox", "Ex--21907280849161310363,34"},
 CellID->30589],
Cell[CellGroupData[{
Cell[13618, 334, 163, 4, 70, "Input",
 CellTags->{"CheckBox", "Ex--21907280849161310363,35"},
 CellID->26862],
Cell[13784, 340, 7859, 133, 70, "Output",
 Evaluatable->False,
 CellTags->{"CheckBox", "Ex--21907280849161310363,35"},
 CellID->46334097]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21704, 480, 311, 9, 70, "SeeAlsoSection",
 CellID->24853],
Cell[22018, 491, 454, 17, 70, "SeeAlso",
 CellID->20448]
}, Open  ]],
Cell[CellGroupData[{
Cell[22509, 513, 313, 9, 70, "TutorialsSection",
 CellID->6430],
Cell[22825, 524, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[23109, 536, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

