(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32914,        836]
NotebookOptionsPosition[     27599,        674]
NotebookOutlinePosition[     30689,        758]
CellTagsIndexPosition[     30435,        749]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "ColorSetter" :> 
          Documentation`HelpLookup["paclet:ref/ColorSetter"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"ColorSetter\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"ColorChooser\"", "ObjectName",
 CellID->12878],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<ColorChooser\>\"", "]"}]], "InlineFormula"],
     
     " \[LineSeparator]provides a panel for making a color selection from \
various color model interfaces."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3338]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An instance of ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<ColorChooser\>\"", "]"}]], "InlineFormula"],
 " can be placed within any user interface definition, and you can bind to \
the chooser's ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"selectionModel\", \"TI\"]\)\>\""], "InlineFormula"],
 " to be notified whenever the currently selected color changes."
}], "Notes",
 CellTags->"ColorChooser",
 CellID->6723],

Cell["The following properties are available:", "Notes",
 CellID->3005],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"selectionModel\", \"TI\"]\)\>\"", "DefaultColorSelectionModel", 
    Cell["\<\
model that intercedes selection operations between the user interface and the \
data\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"color\", \"TI\"]\)\>\"", "white", Cell[TextData[{
     "currently selected",
     StyleBox[" color", "Text"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->22411],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"selectionModel\", \"TI\"]\)\>\""], "InlineFormula"],
 " property allows for binding to its ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"change\", \"TI\"]\)\>\""], "InlineFormula"],
 " event to know when the selected color changes."
}], "Notes",
 CellID->4193]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->151619900],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->151905096],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->398912133],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", "\"\<ColorChooser\>\"", "]"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"ColorChooser", "Ex--21907280849161310363,37"},
 CellLabel->"In[2]:=",
 CellID->20012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GUIScreenShot", "[", " ", "ref", "]"}], " "}]], "Input",
 CellTags->{"ColorChooser", "Ex--21907280849161310363,38"},
 CellLabel->"In[3]:=",
 CellID->16274],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{437, 372},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"ColorChooser", "Ex--21907280849161310363,38"},
 CellLabel->"Out[3]=",
 CellID->538243653]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20183],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->356797873],

Cell[TextData[{
 "Get a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " style color primitive by binding to the active selected color:"
}], "ExampleText",
 CellTags->"ColorChooser",
 CellID->24828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\[IndentingNewLine]", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Panel\>\"", ",", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<ColorChooser\>\"", ",", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"PropertyValue", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<chooser\>\"", ",", "\"\<selectionModel\>\""}], 
             "}"}], ",", 
            RowBox[{"Name", "\[Rule]", "\"\<colorSelectionModel\>\""}]}], 
           "]"}], ",", 
          RowBox[{"BindEvent", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<colorSelectionModel\>\"", ",", "\"\<change\>\""}], 
             "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Script", "[", 
             RowBox[{"updateColor", "[", "]"}], "]"}]}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"Name", "\[Rule]", "\"\<chooser\>\""}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<TextField\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<    \>\""}], ",", 
            RowBox[{"\"\<editable\>\"", "\[Rule]", "False"}]}], "}"}], ",", 
          RowBox[{"WidgetLayout", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<Stretching\>\"", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"None", ",", "None"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"Name", "\[Rule]", "\"\<myColorWell\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<ComboBox\>\"", ",", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"\"\<items\>\"", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
              "\"\<RGBColor\>\"", ",", "\"\<GrayLevel\>\"", ",", 
               "\"\<CMYKColor\>\""}], "}"}]}], ",", 
            RowBox[{"BindEvent", "[", 
             RowBox[{"\"\<action\>\"", ",", 
              RowBox[{"Script", "[", 
               RowBox[{"updateColor", "[", "]"}], "]"}]}], "]"}]}], "}"}], 
          ",", 
          RowBox[{"Name", "\[Rule]", "\"\<myColorModel\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<TextField\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<\>\""}], "}"}], ",", 
          RowBox[{"Name", "\[Rule]", "\"\<myTextField\>\""}]}], "]"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Script", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"colorExpr", "=", 
         RowBox[{"RGBColor", "[", 
          RowBox[{"0", ",", "0", ",", "0"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"updateColor", "[", "]"}], ":=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", "newColor", "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"newColor", "=", 
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{
               "\"\<colorSelectionModel\>\"", ",", "\"\<selectedColor\>\""}], 
               "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"SetPropertyValue", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\"\<myColorWell\>\"", ",", "\"\<background\>\""}], 
               "}"}], ",", "newColor"}], "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"colorExpr", "=", 
             RowBox[{"RGBColor", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"newColor", ",", "\"\<red\>\""}], "}"}], "]"}], "/",
                 "255."}], ",", 
               RowBox[{
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"newColor", ",", "\"\<green\>\""}], "}"}], "]"}], 
                "/", "255."}], ",", 
               RowBox[{
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"newColor", ",", "\"\<blue\>\""}], "}"}], "]"}], 
                "/", "255."}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"colorExpr", "=", 
             RowBox[{
              RowBox[{
               RowBox[{"Chop", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"10", "^", 
                  RowBox[{"-", "5"}]}]}], "]"}], "&"}], "/@", 
              RowBox[{"ToColor", "[", 
               RowBox[{"colorExpr", ",", 
                RowBox[{"ToExpression", "[", 
                 RowBox[{"PropertyValue", "[", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<myColorModel\>\"", ",", "\"\<selectedItem\>\""}], 
                   "}"}], "]"}], "]"}]}], "]"}]}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"SetPropertyValue", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\"\<myTextField\>\"", ",", "\"\<text\>\""}], "}"}], 
              ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"NumberForm", "[", 
                RowBox[{"colorExpr", ",", "5"}], "]"}], "]"}]}], "]"}], 
            ";"}]}], "\[IndentingNewLine]", " ", "]"}]}], ";"}], 
       "\[IndentingNewLine]", "  ", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"BindEvent", "[", 
       RowBox[{"\"\<endModal\>\"", ",", 
        RowBox[{"Script", "[", "colorExpr", "]"}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellTags->{"ColorChooser", "Ex--21907280849161310363,40"},
 CellLabel->"In[2]:=",
 CellID->30633],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0.2`", ",", "0", ",", "1.`"}], "]"}]], "Output",
 CellTags->{"ColorChooser", "Ex--21907280849161310363,40"},
 CellLabel->"Out[2]=",
 CellID->437]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25290],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSetter"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20416]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23117],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1227],

Cell[TextData[Cell[BoxData[
 ButtonBox["Widget",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/ref/Widget"]], "InlineFormula"]], "RelatedLinks",\

 CellID->4514]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"ColorChooser\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 24.1178494}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "\"ColorChooser\"Widget[\"ColorChooser\"] provides a panel for making a \
color selection from various color model interfaces.", 
    "synonyms" -> {"color chooser"}, "title" -> "ColorChooser", "type" -> 
    "Widget", "uri" -> "GUIKit/widget/ColorChooser"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ColorChooser"->{
  Cell[2883, 97, 430, 11, 70, "Notes",
   CellTags->"ColorChooser",
   CellID->6723],
  Cell[5107, 173, 317, 8, 70, "Input",
   CellTags->{"ColorChooser", "Ex--21907280849161310363,37"},
   CellID->20012],
  Cell[5449, 185, 190, 5, 70, "Input",
   CellTags->{"ColorChooser", "Ex--21907280849161310363,38"},
   CellID->16274],
  Cell[5642, 192, 13192, 220, 70, "Output",
   Evaluatable->False,
   CellTags->{"ColorChooser", "Ex--21907280849161310363,38"},
   CellID->538243653],
  Cell[19257, 432, 204, 7, 70, "ExampleText",
   CellTags->"ColorChooser",
   CellID->24828],
  Cell[19486, 443, 5888, 138, 70, "Input",
   CellTags->{"ColorChooser", "Ex--21907280849161310363,40"},
   CellID->30633],
  Cell[25377, 583, 197, 5, 70, "Output",
   CellTags->{"ColorChooser", "Ex--21907280849161310363,40"},
   CellID->437]},
 "PrimaryExamplesSection"->{
  Cell[4439, 147, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->151619900]},
 "Ex--21907280849161310363,37"->{
  Cell[5107, 173, 317, 8, 70, "Input",
   CellTags->{"ColorChooser", "Ex--21907280849161310363,37"},
   CellID->20012]},
 "Ex--21907280849161310363,38"->{
  Cell[5449, 185, 190, 5, 70, "Input",
   CellTags->{"ColorChooser", "Ex--21907280849161310363,38"},
   CellID->16274],
  Cell[5642, 192, 13192, 220, 70, "Output",
   Evaluatable->False,
   CellTags->{"ColorChooser", "Ex--21907280849161310363,38"},
   CellID->538243653]},
 "Ex--21907280849161310363,40"->{
  Cell[19486, 443, 5888, 138, 70, "Input",
   CellTags->{"ColorChooser", "Ex--21907280849161310363,40"},
   CellID->30633],
  Cell[25377, 583, 197, 5, 70, "Output",
   CellTags->{"ColorChooser", "Ex--21907280849161310363,40"},
   CellID->437]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ColorChooser", 28705, 700},
 {"PrimaryExamplesSection", 29551, 723},
 {"Ex--21907280849161310363,37", 29705, 727},
 {"Ex--21907280849161310363,38", 29860, 731},
 {"Ex--21907280849161310363,40", 30167, 739}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1252, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1875, 59, 54, 1, 70, "ObjectName",
 CellID->12878],
Cell[1932, 62, 436, 13, 70, "Usage",
 CellID->3338]
}, Open  ]],
Cell[CellGroupData[{
Cell[2405, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2883, 97, 430, 11, 70, "Notes",
 CellTags->"ColorChooser",
 CellID->6723],
Cell[3316, 110, 71, 1, 70, "Notes",
 CellID->3005],
Cell[3390, 113, 693, 18, 70, "3ColumnTableMod",
 CellID->22411],
Cell[4086, 133, 316, 9, 70, "Notes",
 CellID->4193]
}, Closed]],
Cell[CellGroupData[{
Cell[4439, 147, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->151619900],
Cell[CellGroupData[{
Cell[4824, 161, 148, 5, 70, "ExampleSection",
 CellID->151905096],
Cell[4975, 168, 129, 3, 70, "Input",
 CellID->398912133],
Cell[5107, 173, 317, 8, 70, "Input",
 CellTags->{"ColorChooser", "Ex--21907280849161310363,37"},
 CellID->20012],
Cell[CellGroupData[{
Cell[5449, 185, 190, 5, 70, "Input",
 CellTags->{"ColorChooser", "Ex--21907280849161310363,38"},
 CellID->16274],
Cell[5642, 192, 13192, 220, 70, "Output",
 Evaluatable->False,
 CellTags->{"ColorChooser", "Ex--21907280849161310363,38"},
 CellID->538243653]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18883, 418, 239, 7, 70, "ExampleSection",
 CellID->20183],
Cell[19125, 427, 129, 3, 70, "Input",
 CellID->356797873],
Cell[19257, 432, 204, 7, 70, "ExampleText",
 CellTags->"ColorChooser",
 CellID->24828],
Cell[CellGroupData[{
Cell[19486, 443, 5888, 138, 70, "Input",
 CellTags->{"ColorChooser", "Ex--21907280849161310363,40"},
 CellID->30633],
Cell[25377, 583, 197, 5, 70, "Output",
 CellTags->{"ColorChooser", "Ex--21907280849161310363,40"},
 CellID->437]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25635, 595, 311, 9, 70, "SeeAlsoSection",
 CellID->25290],
Cell[25949, 606, 460, 17, 70, "SeeAlso",
 CellID->20416]
}, Open  ]],
Cell[CellGroupData[{
Cell[26446, 628, 314, 9, 70, "TutorialsSection",
 CellID->23117],
Cell[26763, 639, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[CellGroupData[{
Cell[27069, 653, 320, 9, 70, "RelatedLinksSection",
 CellID->1227],
Cell[27392, 664, 165, 5, 70, "RelatedLinks",
 CellID->4514]
}, Open  ]],
Cell[27572, 672, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

