(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34128,        835]
NotebookOptionsPosition[     29002,        679]
NotebookOutlinePosition[     32071,        763]
CellTagsIndexPosition[     31818,        754]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"FontChooser\"", "ObjectName",
 CellID->30562],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<FontChooser\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]",
     "provides a panel for making a font selection based on a name, style, \
and size.",
     " "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23865]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An instance of ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<FontChooser\>\"", "]"}]], "InlineFormula"],
 " can be placed within any user-interface definition, and you can bind to \
the chooser's ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"selectionModel\", \"TI\"]\)\>\""], "InlineFormula"],
 " to be notified whenever the currently selected font changes."
}], "Notes",
 CellTags->"FontChooser",
 CellID->17554],

Cell["The following properties are available:", "Notes",
 CellID->20700],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"selectionModel\", \"TI\"]\)\>\"", "DefaultFontSelectionModel", 
    Cell[TextData[Cell[BoxData[Cell["\<\
model that intercedes selection operations between the user interface and the \
data\
\>", "TableText"]]]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"font\", \"TI\"]\)\>\"", 
    RowBox[{"12", "-", 
     RowBox[{"point", " ", "plain", " ", "serif"}]}], Cell[TextData[StyleBox[
    "currently selected font", "Text"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"showLogicalFonts\", \"TI\"]\)\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[StyleBox[
    "whether logical font names will display as choices", "Text"]], 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"showPhysicalFonts\", \"TI\"]\)\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[StyleBox[
    "whether physical font names will display as choices", "Text"]], 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"sizes\", \"TI\"]\)\>\"", 
    RowBox[{
    "8", ",", "9", ",", "10", ",", "11", ",", "12", ",", "14", ",", "16", ",",
      "18", ",", "20", ",", "24", ",", "28", ",", "32", ",", "36", ",", "48", 
     ",", "72"}], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
      "font", " ", "size", " ", "choices", " ", "to", " ", "display"}], 
      TraditionalForm]]]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"allowAnySize\", \"TI\"]\)\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[StyleBox[
    "whether any size can be entered or only those values present in the \
list", "Text"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"familyNames\", \"TI\"]\)\>\"", "Null", Cell[TextData[StyleBox[
    "font family name choices to display", "Text"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"previewPanel\", \"TI\"]\)\>\"", "DefaultPreviewPanel", Cell[
    TextData[StyleBox["preview panel display widget", "Text"]], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->32302],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"selectionModel\", \"TI\"]\)\>\""], "InlineFormula"],
 " property allows for binding to its ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"change\", \"TI\"]\)\>\""], "InlineFormula"],
 " event to know when the selected color changes."
}], "Notes",
 CellID->29714]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->299404526],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->90386900],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->213653732],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", "\"\<FontChooser\>\"", "]"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"FontChooser", "Ex--21907296125549291768,23"},
 CellLabel->"In[2]:=",
 CellID->18442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", " ", "ref", "]"}]], "Input",
 CellTags->{"FontChooser", "Ex--21907296125549291768,24"},
 CellLabel->"In[3]:=",
 CellID->19280],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{269, 307},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"FontChooser", "Ex--21907296125549291768,24"},
 CellLabel->"Out[3]=",
 CellID->117389676]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9858],

Cell[TextData[{
 "Get ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " style font primitives by binding to the active selected font:"
}], "ExampleText",
 CellTags->"FontChooser",
 CellID->1730],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->356797873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\[IndentingNewLine]", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Panel\>\"", ",", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<FontChooser\>\"", ",", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\"\<showLogicalFonts\>\"", "\[Rule]", "False"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"PropertyValue", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<chooser\>\"", ",", "\"\<selectionModel\>\""}], 
             "}"}], ",", 
            RowBox[{"Name", "\[Rule]", "\"\<fontSelectionModel\>\""}]}], 
           "]"}], ",", 
          RowBox[{"BindEvent", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<fontSelectionModel\>\"", ",", "\"\<change\>\""}], 
             "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Script", "[", 
             RowBox[{"updateFont", "[", "]"}], "]"}]}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"Name", "\[Rule]", "\"\<chooser\>\""}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<TextField\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<\>\""}], "}"}], ",", 
        RowBox[{"Name", "\[Rule]", "\"\<myTextField\>\""}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Script", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"fontExpr", "=", 
         RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"updateFont", "[", "]"}], ":=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", "newFont", "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"newFont", "=", 
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{
               "\"\<fontSelectionModel\>\"", ",", "\"\<selectedFont\>\""}], 
               "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"fontExpr", "=", " ", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"FontFamily", "\[Rule]", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"newFont", ",", "\"\<family\>\""}], "}"}], "]"}]}], 
               ",", "\[IndentingNewLine]", " ", 
               RowBox[{"FontSize", "->", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"newFont", ",", "\"\<size\>\""}], "}"}], "]"}]}], 
               ",", " ", 
               RowBox[{"FontWeight", "\[Rule]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"PropertyValue", "[", 
                   RowBox[{"{", 
                    RowBox[{"newFont", ",", "\"\<bold\>\""}], "}"}], "]"}], 
                  ",", "\"\<Bold\>\"", ",", "\"\<Plain\>\""}], "]"}]}], ",", 
               " ", "\[IndentingNewLine]", 
               RowBox[{"FontSlant", "->", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"PropertyValue", "[", 
                   RowBox[{"{", 
                    RowBox[{"newFont", ",", "\"\<italic\>\""}], "}"}], "]"}], 
                  ",", "\"\<Italic\>\"", ",", "\"\<Plain\>\""}], "]"}]}]}], 
              "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"SetPropertyValue", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\"\<myTextField\>\"", ",", "\"\<text\>\""}], "}"}], 
              ",", 
              RowBox[{"ToString", "[", "fontExpr", "]"}]}], "]"}], ";"}]}], 
          "\[IndentingNewLine]", "  ", "]"}]}], ";"}], "\[IndentingNewLine]", 
       "  ", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"BindEvent", "[", 
       RowBox[{"\"\<endModal\>\"", ",", 
        RowBox[{"Script", "[", " ", "fontExpr", "]"}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellTags->{"FontChooser", "Ex--21907296125549291768,25"},
 CellLabel->"In[2]:=",
 CellID->29551],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FontFamily", "\[Rule]", "\<\"Arial\"\>"}], ",", 
   RowBox[{"FontSize", "\[Rule]", "12"}], ",", 
   RowBox[{"FontWeight", "\[Rule]", "\<\"Bold\"\>"}], ",", 
   RowBox[{"FontSlant", "\[Rule]", "\<\"Plain\"\>"}]}], "}"}]], "Output",
 CellTags->{"FontChooser", "Ex--21907296125549291768,25"},
 CellLabel->"Out[2]=",
 CellID->23262]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->528],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31748]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31629],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"FontChooser\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 27.9457784}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "\"FontChooser\"Widget[\"FontChooser\"] provides a panel for making a \
font selection based on a name, style, and size. ", 
    "synonyms" -> {"font chooser"}, "title" -> "FontChooser", "type" -> 
    "Widget", "uri" -> "GUIKit/widget/FontChooser"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FontChooser"->{
  Cell[2873, 98, 428, 11, 70, "Notes",
   CellTags->"FontChooser",
   CellID->17554],
  Cell[6996, 213, 310, 8, 70, "Input",
   CellTags->{"FontChooser", "Ex--21907296125549291768,23"},
   CellID->18442],
  Cell[7331, 225, 171, 4, 70, "Input",
   CellTags->{"FontChooser", "Ex--21907296125549291768,24"},
   CellID->19280],
  Cell[7505, 231, 14773, 246, 70, "Output",
   Evaluatable->False,
   CellTags->{"FontChooser", "Ex--21907296125549291768,24"},
   CellID->117389676],
  Cell[22568, 492, 199, 7, 70, "ExampleText",
   CellTags->"FontChooser",
   CellID->1730],
  Cell[22924, 508, 4209, 95, 70, "Input",
   CellTags->{"FontChooser", "Ex--21907296125549291768,25"},
   CellID->29551],
  Cell[27136, 605, 380, 9, 70, "Output",
   CellTags->{"FontChooser", "Ex--21907296125549291768,25"},
   CellID->23262]},
 "PrimaryExamplesSection"->{
  Cell[6329, 187, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->299404526]},
 "Ex--21907296125549291768,23"->{
  Cell[6996, 213, 310, 8, 70, "Input",
   CellTags->{"FontChooser", "Ex--21907296125549291768,23"},
   CellID->18442]},
 "Ex--21907296125549291768,24"->{
  Cell[7331, 225, 171, 4, 70, "Input",
   CellTags->{"FontChooser", "Ex--21907296125549291768,24"},
   CellID->19280],
  Cell[7505, 231, 14773, 246, 70, "Output",
   Evaluatable->False,
   CellTags->{"FontChooser", "Ex--21907296125549291768,24"},
   CellID->117389676]},
 "Ex--21907296125549291768,25"->{
  Cell[22924, 508, 4209, 95, 70, "Input",
   CellTags->{"FontChooser", "Ex--21907296125549291768,25"},
   CellID->29551],
  Cell[27136, 605, 380, 9, 70, "Output",
   CellTags->{"FontChooser", "Ex--21907296125549291768,25"},
   CellID->23262]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FontChooser", 30098, 705},
 {"PrimaryExamplesSection", 30938, 728},
 {"Ex--21907296125549291768,23", 31092, 732},
 {"Ex--21907296125549291768,24", 31246, 736},
 {"Ex--21907296125549291768,25", 31551, 744}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1234, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1857, 59, 53, 1, 70, "ObjectName",
 CellID->30562],
Cell[1913, 62, 445, 14, 70, "Usage",
 CellID->23865]
}, Open  ]],
Cell[CellGroupData[{
Cell[2395, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2873, 98, 428, 11, 70, "Notes",
 CellTags->"FontChooser",
 CellID->17554],
Cell[3304, 111, 72, 1, 70, "Notes",
 CellID->20700],
Cell[3379, 114, 2593, 57, 70, "3ColumnTableMod",
 CellID->32302],
Cell[5975, 173, 317, 9, 70, "Notes",
 CellID->29714]
}, Closed]],
Cell[CellGroupData[{
Cell[6329, 187, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->299404526],
Cell[CellGroupData[{
Cell[6714, 201, 147, 5, 70, "ExampleSection",
 CellID->90386900],
Cell[6864, 208, 129, 3, 70, "Input",
 CellID->213653732],
Cell[6996, 213, 310, 8, 70, "Input",
 CellTags->{"FontChooser", "Ex--21907296125549291768,23"},
 CellID->18442],
Cell[CellGroupData[{
Cell[7331, 225, 171, 4, 70, "Input",
 CellTags->{"FontChooser", "Ex--21907296125549291768,24"},
 CellID->19280],
Cell[7505, 231, 14773, 246, 70, "Output",
 Evaluatable->False,
 CellTags->{"FontChooser", "Ex--21907296125549291768,24"},
 CellID->117389676]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22327, 483, 238, 7, 70, "ExampleSection",
 CellID->9858],
Cell[22568, 492, 199, 7, 70, "ExampleText",
 CellTags->"FontChooser",
 CellID->1730],
Cell[22770, 501, 129, 3, 70, "Input",
 CellID->356797873],
Cell[CellGroupData[{
Cell[22924, 508, 4209, 95, 70, "Input",
 CellTags->{"FontChooser", "Ex--21907296125549291768,25"},
 CellID->29551],
Cell[27136, 605, 380, 9, 70, "Output",
 CellTags->{"FontChooser", "Ex--21907296125549291768,25"},
 CellID->23262]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27577, 621, 309, 9, 70, "SeeAlsoSection",
 CellID->528],
Cell[27889, 632, 448, 17, 70, "SeeAlso",
 CellID->31748]
}, Open  ]],
Cell[CellGroupData[{
Cell[28374, 654, 314, 9, 70, "TutorialsSection",
 CellID->31629],
Cell[28691, 665, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[28975, 677, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

