(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24633,        642]
NotebookOptionsPosition[     20218,        501]
NotebookOutlinePosition[     22771,        575]
CellTagsIndexPosition[     22572,        567]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], 
          "CreateDialog" :> 
          Documentation`HelpLookup["paclet:ref/CreateDialog"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"CreateDialog\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"Frame\"", "ObjectName",
 CellID->16327],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<Frame\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a complete window. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14274]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<Frame\>\"", "]"}]], "InlineFormula"],
 " is a container component where you can place all other components with \
visual content. ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<Frame\>\"", "]"}]], "InlineFormula"],
 " represents a complete window including any window title bar that, for \
example, allows you to set the window's text using the ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"title\", \"TI\"]\)\>\""], "InlineFormula"],
 " property."
}], "Notes",
 CellTags->"Frame",
 CellID->5760],

Cell[TextData[{
 "However, if you are interested in designing reusable complex groups of \
interacting widgets that can function together as their own compound widget \
in other user interfaces, it is recommended you build them within a ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"Widget", "[", "\"\<Panel\>\"", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/Panel"]], "InlineFormula"],
 " and not ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<Frame\>\"", "]"}]], "InlineFormula"],
 " because using ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<Frame\>\"", "]"}]], "InlineFormula"],
 " forces this definition to only be deployable as its own stand-alone \
window."
}], "Notes",
 CellTags->"Frame",
 CellID->99],

Cell["The following property is available:", "Notes",
 CellID->25042],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"title\", \"TI\"]\)\>\"", "\"\<\>\"", Cell[
    "window title", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->3055],

Cell["The following method is available: ", "Notes",
 CellID->24393],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"dispose\", \"TI\"]\)\>\"", Cell[
    "requests that the frame close", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->31065]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->148124238],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->220759169],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->523419159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Frame\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\"\<title\>\"", "\[Rule]", " ", "\"\<My Title\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"WidgetGroup", "[", 
        RowBox[{
         RowBox[{"{", " ", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Panel\>\"", ",", " ", 
            RowBox[{"WidgetLayout", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<Stretching\>\"", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"Maximize", ",", " ", "Maximize"}], "}"}]}], " ", 
              "}"}]}]}], "]"}], "\[IndentingNewLine]", " ", "}"}], ",", " ", 
         RowBox[{"WidgetLayout", "\[Rule]", 
          RowBox[{"{", " ", 
           RowBox[{"\"\<Border\>\"", "->", "\"\<Content\>\""}], " ", 
           "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"WidgetFill", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<OK\>\""}], "}"}]}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Cancel\>\""}], "}"}]}], 
          "]"}]}], "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", 
      "}"}]}], "]"}], " ", "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"Frame", "Ex--21907299533234115765,2"},
 CellLabel->"In[2]:=",
 CellID->11652],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject324110747959297, 
   JLink`Objects`JavaObject140226957672449]]], "Output",
 CellTags->{"Frame", "Ex--21907299533234115765,2"},
 CellLabel->"Out[2]=",
 CellID->19175]
}, Open  ]],

Cell["The interface has been resized to display the entire title:", \
"ExampleText",
 CellID->25750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Frame", "Ex--21907299533234115765,3"},
 CellLabel->"In[3]:=",
 CellID->10678],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXAl4VEW2vukl3WETQRgQCCKrGJCwb2GHACGQQMKekIBA2CXgAuK4oY4L
TxlRnss48HR03EcFURRXFBeUPSAkZOst6exJpzuB8L9zqu7tdIcOCS7zzfe+
d7+v7q1bderUqfOfOnWq+ibRyRtTlq5J3rhiSfINkanJt6WsWLLhhknrUqlI
H6Qoyk5KyTconAdltZseynXPQWn9BCdlh7grigFK23eghO5S024zZwycM3GO
bp3EK9867dJzhV9OVuzWq8SCgfoqKkxeVgb/XAsvieDCr7sVgyrGy/wGpcML
QaqcRijtj8Ac/guaR55Fy7hMNJnyC5Ebxp6hvkZlNIUSkU6tR6XTa0SGmV9F
Tisb5S0bxWW+OdNlLWQt84vIMKmcfXO1tQb/ZoKVIrJQhhyFEvYpj+byUbSa
aUXblUUwxzO5aUb+Y1AmlzJI3LLPZ6xiJagWJLWZ2qQjCvLOKMEozD+L4sJM
lJfaUekqhLuyGJ7KklbwuEtaorq6Us85au9xl6HKU0bPUmpwXn/l9h24Vfva
9qa67VlWKWnDUhqQbzvJOdzz3JvoPndrTygjN1Lxn6L/jNVP/AOuCid1XKQP
TD1MUJvqUl+NBHpYs49g+SO7sPXh9cpNsNIM0ePBreuw6vGXmaGi9a3RTV3/
NF5+Z88QpB39RgnBqaMHcerI13hv34eYvPYprVmtDKGNwCr3/GExiOK9U+B5
vx88H1B6/xYdZ8xc0o5zes4xYFRbuDdStCgvtenrMPn80A/IyUxD1vmTyD5/
ahC/kKCURWb6cZw7/RM+PHBAa30FQU39Awj6I+scVXsGwbN3EJxOKwqc1q50
s1E1v+Y5skWVh0iYtLQoR6+qWmvNxDomZuUKDjZRNkDcQ7xsLDlnkZVxUmMj
RR3FuO5uSFRDragfjUDVvhE9UFKST5OsuMgBzz4uGi6qS4qylbrylZQ4lWGC
3izo84Usv2j0vnI0aOAaz+r9Y1G1f1wPwZzEKM6j17EiSbZZXkvTmpSWFnAa
KpqYRRNnfi6sOee0Jr7gNVqSqgNTUP3ZlBbMW88LgJ5zishqfRI8l5c1EXcj
i4NqYlJ1YHK9speVFXKq04lOrDcGwVHjXI8AtY1Ern55zEKeAqcFttz0hhVj
Cj9TL0RfxKD6y5jmxLaQ3bHoqtCbFFWM+uq0diUlBcQqllldQT1FnGQTUyB2
/l1Kxel9K1VZ9H7E+kaWNRNlZiErz0BbbkYA1e1uvOq+novqg/OaMeZqV6oF
0Jt/mRTpcrqm4m4U6FYfFOzqVV95eRGnQN0ZxN3kW6Z1W2/3ilh+Gxad35qI
u1mIWVhghd3SCM1dYTZeOJSMC98lNePxqF2po6M3vgd7y9R4Tcu3ENVCblQz
F0r1KayiophToF6MfDeoetG64QpdHWKpJcoZAxA3FXezEKao0AaH9by/WkZl
8HLcaLVc/GEFLvywkgUu9spQrL7x3eAtU586TSfFQidF3FywqV8nJZwCdWEQ
92Dfssu60tVpp+mkMWWyT7MQs6jQTtrKbFhbpito6+f1nJrxeNSu1NHRm3+Z
dCmX08m2RiHihSOpxC61Xs25XKWcAnVn5Lvqsfnd4NuxdOkagb4OqT+jJuJu
FvLwGpxny7pcRZd7qPpVdHwzp+YsuOrA1WGIJNVSf53WjsW7eHwTLh7bXK96
KivLiLrsSl21F3V63zoaMd/NoosSWuvz7b9txDWnHmBRW7A8qsIpp3bKMvKb
LkBZE3E3CsF4rDWn7r/CWMs51XZyfb0MzYJhaUk+nBRP+Y8s4EJd/8jOPMqC
9eCehZxlUk4qrl/OCk5DRROzaFJKYYPTkfPbJDn3pJTE46kkSdxul5SEiv0l
qQ0uPR43BZdMbxb05aVFtNey1VlEMq5KjEsZz0gxqqurSIzqao8Qg4vrE6O6
uprEYHqzoHdVlBFd/q8Qw4icDFWMzOfl5Lh4UelB9wvURKgj6wVRT9tJfZ0m
NTUXReImQ0UTEy5cqEYliaM2qRXlsu1cPSqhrSGK0t/mvnuyVahicBFX0c7W
Vxtc9PnP6cpwXLp0ibq/dKmG3s9ppFff/d3P/BPbXtqNYsfxnkDJEd6yFZ4Q
RXc/+wbN61P6OtTx9/wPvjiSMQx0kQSnMh2iSKX2jSsalsCadQS2nGOCb50d
9fK/7ILDcoKTPjC1747ah/oKEgTYUbPIzJcwVtogO/2HlshI+1rPOWrEyPO4
mcKrCv9GoUzavraRqW6jxsnzpMr66onF8vvHEF+VGA0Q65j4cTYa3VU3ewz/
eHknhTh88ZEKJ5/WV25MPVFrra3ysLibfMvq8mtAmv9n+H+T4Zn/cIY+50ZX
zbChM7Pfh+FvGfK/h+FvGnLGv4PhbzHsho5w/zNACXDQ/TszNP0WhhkBQ5cr
Mgzmu7pt0XI6tYb3FloHohP5rvPSNJo68arFbkCxRpVhPZ2qJwKyXUNlul/J
a1FDbjBAtHLFQRnqdFJbdvXC6QLw0jeC19UP6goGRhe9ybtPR78aPcHfWFvt
ZVh3tF6KhaL3q3KzdYYTLAK4QPI3YoIEBOXq24neE+qLJBs4fg8JYAnGOrPX
6Nudd5i1BI0jXaxlG6PcJnW4+ehCaR5A5GYBypIb7NBnBWnqHUiLX8v+Sr9z
XrYLuow4ZODZP4jYVA/xCNpVd3n9VxNff4RKs2SKyiLrHH+EiIPGH0HQhKOc
lBDoJh7Vc1bH5Ype1jAFvXXmt1BuFsrvoSoDwa8vjaP/l9xbm79Sb6a6vdFI
DzO96EYnu1GmEn5B0enMI4YoonPpmUO1fKeyWdmc095iciKYpBOUSXwsI3hG
5Yq3YK1sPEkxRiRF/OzP91FnZZl8G+NXNuos9zb8F8UMZegZzkEZdEbm+cmy
D83nkbEaH1fE5wbawKKcUuS4XGYy18YqnktlCwugJBVBWVSmh35pqQH6lArq
VJ9SjaCVIhEl30mQpTUIurWKk0IDS6oinSZdFDlW4cIqfpXPeR4o813UQzmU
OZWiRzf3OKcSSnwFlNgKfuo4Y+AcSxpbAmVasXxKGm43rZz0FVkcxEML8h2b
yX9sc2kMC8q0J7XUJ/HZqz65kkfE46G34JVVdFt90QT9qguE68pLoVzThodG
1cZlF7DsBZfw2teoK4e1sEaUUR2LUw+dSdI9Vw5jspsVItRgTHRj2bPlSktB
Y4a14CKWPV0K44wyHhiPi2whvy5q2shy/EYWlOTi0bA5Lq1SEaLx8HCozLSu
Rg9Tao0BwesvUWUq6LYWTXmMRNyk3YMwT/kJxiXlSndR1gbLX6rE0bOl6DX7
azQf/SGunXAArSZ+gusmfoxWEz5G64mfovWkA2g58TM0n/gFmkz8EuYJXyN4
7BfQj/4CQaO/JiE/Q+fpH+PImULmpwidKuG/O2/WNpsfG9iy51woSjuKvRN6
4dWbm+OtftfizfBWeL3/dXi9Xyu81b813qb0TnhLvNevOd7v2wR7+pjxXu9g
vNdLjz09g/BONwVvjeyM/JNHBCLCIDVEJBqKBoehLhw6xoKKpW1VSyRWXxQg
6BiEYJg2XtJ5kWjGSBA9X2fTC3D/Xz5HyIi9Lbm4jQqGtagGvRIz0XpGJjrE
Z6LL/Bx0X5iNHglZ6EbProk56EIplFKHRVa0TbSidYINLRZYETLXBkOcDUHT
ScSJJ0hpHwmD08D4A3h7wWCz/2lKLxwe2hqHR3XAkQldcCSyO6UeODKpG45G
dsWxSV1wfGIoTk3sgFPj2iJtTGucimiBtGEhODXIgGP9gvBVbwVvEiCC9xXA
uHxuqPNCzIoWiI+PFzo3sHJDWAE6dSKXVl4S0yA4wal0U7XOV4uYQnRcUIxe
S0pwS0oJBqwqxcDVpQhfXYbwNWXou64MvW8rQ/fbytF5XTnar6lA65UVaL6s
Aqakcujmk7+KJnmGf+yj9T+KN+lc5X1mSAucG98RGdN64fzMW5AZPwBZcwYi
Kz4cWbPDkT27L3Lie8MyqzssMZ1hndYe1smtYR3fHJZRJmQN1eHYLQre6Kpo
vKeVs5f317pYIGnB6Xzc3yMtkh6JtI6/794VDIvFQo1zzp6D3eHgRAbvdDrp
TtUMBoJWX+Kkk6AQFOT0Kcs+SQDDT1adqJNaNGDbp5fEaF965WeYo0+EeBsb
vDmd6uNMC+yCD3OWZSEMNkL6/ROmubmiL1PcefHOdCHD9gp/qPcB7LrZ5ei+
uALhqyowbH0FIja6KFVixO0uDLvDhSF3utD/rkqE3eVG9zvd6HyHG+1T3bh2
rQdNU9wwJlVAN4umS8RnmlJpxQj/I3h7F1u+MkZeh6yo7siOC0fugmGwJEbA
sohS4ghYE4dRGgJbQn/YF4TBMac78uI6Iy+mPfKmXgvHhKawRBiRNkCHd3sE
Sd51V6fwb73GEAKla5q68NplELHIuzwJtFesWEEjJ4vQCUNognPnzuGbx58Q
TzIKYSKc5ye/cyMBJwcaZuFctIuR2vLuBZFnx2mOPqVTl1zz2INaPIIVL0uS
4ycdwgDMXCoJDYKHRugt1nuLX/ueV1DwATuHNk3wwlcX4am6iL37fxEEnx9z
weORHZS6anDfjmMsh16QG0Vxu3nl6EtxxnACdtydLpKO+whB7y0edNvsQac7
PWizwYMWqz0IWVIB42w7dKM/95nVgfk0FRQdA7XzRlp8nR/TDtmxfZG7cDgs
i8fB9eVeUW5bOp7SWNhujYB98VA4kvojb2Fv5M/rJurdH+1G3uQWsI4JwenB
Rvyrp6oJQp+dwViHxD/sOy/+hlr82TpinTo2AI6+yQQYSXYFAn6SnlGmHL5P
WY68BbHYv3+/tAZ6frlju7CA8vJybicjGw2D7IJLXvwPpUt7+P5wLkIGfSDy
OZYSmEcf1Ino04gDaf4mEzwzl9eKJD8bEHGZTLLY6C32VHu7UyTPEN8yL//P
v87E+0dqRB2JxcpI0mwgNKEcg9cSbjSZp9xdawN97qEJTTYQSjbwJ7KBa9e4
hYdvOs8uAh7NBqoI5wB8RNnUP7sx+c+VmHhvJcbeR06DnoPudfvx5isAbxmF
U0TNVyatwzlzBwsbsS6folfVYEuZCPvysbDfOgKOxYOQn9hHPTtpInyEbUJz
nB7RFO/dLI8AvL6B7YOXBRG9CvMwqmsFm4eF+s3nPYYibaSZsI8NGzYI3Nku
9kZF4+ihb3F63hzkrIhF5voE/LhyPr7s2hV7PvhAmtE12PH00zLcUhObWnZB
jRcenpXa7OR3zUJM0acVGa4ZvTR8vfHuSbKeLwkiqvNzE8RYTX4mMt/la148
nPkuXz+i2ook13OtahTdF5cjYkMFJhOQ0++rrDWKLW702OTBDeTp229wo+06
N1qvqEDLBHJgE7yOgfi0CcRHlE2/vxJRlI8kYxhHaSSlwWwUPrz5qod3fKl6
oMMrRy6tGNblk2FbPR22NTHawZk9ZRzsS0eSUQxWDSJYLByOaW1hiWyNM6Mp
yO7TRPUZYx1ih50jd9i99/muGWwUfH4gjMJau/mktYON4quvvlKdRnN8u2Ah
9vfugYqFk1AQOx72V1djX1IEdvboJCxh+1NPYv+9d4qnag2qrlrhwMnatUIg
/VGueN73bJp3ApumnBJbqte+rfajybG7BJiGOc5gJvDzHby5lMnPMKiojmFo
BHqvJUoufG+PkLBXfHmJyptpwk64i3Al/GY+UIlZD1Yilp7R99Okp7LxlCJo
8g/aUok+mwlbwrXLRjc6rHej3VpKFDK2XWTHNZFeZzK3XAkNyJuvxvDmKwBv
thqxRecre8bNsCyZANuq6bCvm0lpFmxrY6WdtCS7ifDq5pKrFI64LnDEdIA9
uh0sU9vhNO0F3g+/RrJlRzImu/Z4pvc+zXb+BOWG7+QpB9tOrNXv4IJt5/CP
h5Hx6Sc4+emn+HZGJHKXRMD1yirYdiSjYPEQnBsahu/De2L/5EEoiZuKs2lp
eGnX38URgQBMaS2C2gMnpT3wOlNaXg3ThJ9R4rqE79IqvLZjjMkWtOxNSss8
Xhq+1t6xl2wrjU94eJfoYzwcMcvkZzxUVMd4NAKzr1cReWIs8hyImMd9r2da
1Tf0p4gy6h4X4shuZm91I/5Bt8A6mnzD5HvINxC2IzdXYiBFl33uqEQP8jdd
yHY6rqtExzWUCOOOyTa0muz1DfXy5qsxvPmqh3csf+gu5ltcf1hXRMF+Wxzs
62fDcVu8sCPb6mjhPMkV2ON7wD6zC2zTO8IW3RG50zoibVJH/GtAK2k37GzY
ZvgAjMMS6XTEXrHt5YbDq5FqPGw4mxfMQ/Yw2iGPHwznwukoe24pqn7YirK3
boflnjj8FDsS1pc2omDzTLz42KM4fPAgXvzbizroEwqU66QNErsn9sh5xfbA
tmOYmYNDZ6u9K872nYfIbs7j+QNur31pNHxxnBkyZC+bjdPfbJxa8iumUaiX
3Ec18S0SJEczpRfc+02h2DrxdSxdnLXlq8AOoQgjlhaQOQ+5Me9ht3jOpPdo
cgaRd1OUsYmiDNqSDKRtSlgqAUvGciMBGrqqEp1XVqLLynJ0WWxD2ynerQ7x
viEgb2E0jeDNVwDebDICP75y5w2BfU0sHKlz4NgwjwxnDjkdMpqV0bSARUrn
QwHtnDBYZ/WANeZGWKNDKXVGzvQuSJvSBe8OaivZ8nqknaLedBRKj7c02+kA
5fpPoQw+Lo9e+WB3ro2ibfJSC/OE7Wj7l8KNS1Dw2EK4ti8QdnP8qTXYt2wW
Di2PgvvjO+B4YAZ2P/oIXnnlFWzavIlNx2s4zO+JPRWKtmDct+OkgHLLa1pZ
iDAeLst2XhRCU51GI97zSmo40o3P9111hKETHNoy7mMf2lYnQAuyGq8obEG1
XGrNZmRqBeY9UomEx9xIeFTCO4ugnc7QbnZhLK01wwnWgakE7ToXeq52oStB
esMKgjjFhe4ryiiWsaF9lK/ZBObNV2N481UP7+hc1dfkJlAQs3EeHHcmwHFH
Auyp82Cj9cq6arrmayyxPWGZ0ZV8zA3Ijb6RlrfuODW1O94d0l5qTjtoZ6tg
c5G+psU9ZC/t/O1larrqb6wCYy3qFXvfjz/E6a0zaQc2TNjId6vj8c3WO7Fv
wWgSbDIy5g+HdVBvZP338+xrVHvJ0zEjcWhv8/oa07hDrD7+C6sSlzcYpnCZ
yvyxFaIIXVNFyKD3mVG81esyQvq9qauvkVncJUCTNrmQ9IQbi7d5kPS4Gwse
cSPuATem0yIQSQvAWAJn+HoCiOZ/n1Uu9FrhQrflLty4jMCh500pZbhpiQUd
og54wbeqgUpd3nw1hjdfAXjLn1uiskTeunQSHJuT4NiyWD43LoB9bZwWqPCm
2ffKie6GnKgb6dkdWTE34eS0m/DOsA7+RsAGwMuL8BnCBsyX20Bcrq8N6MSJ
WDOc69sTHw0Ow+H+ffDdtKFiieHY5PGObQX8Z+ZMwod/ew62rEz8c+fTem4v
f7QREuO7E8UwzEhXNPAP/SJPgczDPiYzFjiKczG6xIrBMXvJReQXehh7IRE3
IZvR+6Ie0ntXvain/NWDlU97sPRJDxJpas6hECOGpuVU8uTjb3chgpDhPest
hMzNhEwvQqQnod6bpmUYTcveiy3oOM0XdWMg3up5R/NA7eTvVz6I5t2fgvwH
VyLvz0tpWid6nZ0leTwsCRHInavtWZqS6++JnBiaVbFhOBHdG28P61gLpzaf
JZzeOd1W4jnkR4owjks8+Uc+1tB8u5jT8fHxcLz+spjXBzekiniBfT7HENpc
fnVQGDL27BXrhRp48l7FrgHK/LKdF8ifl8o3ulNelPFbM76bvX7cKqCkJJw+
EzMhB4r81sQHNl5s1+704LbnpHoXP+HBAvLWcfe5EU2LcOSdlRhDnnQ4edKB
ayrQjyK9PrRLDCP4+lDqS+oPW2JFp2mfarDFarDV4a3C1ixQOz/YeJF2PrIW
zsduY+i04wdrSjQst0bCsmgMchcMR87sgYpWlzOzDzJn9iXUwvD28E6aKIOP
szrCvpOodXtV8ZmF7d7kA0sooxm1M/LnWp6JEjVtFvKx07F33kHhnBko37oE
5XdNhXNqf6TdfRfSU5Lx9sChuHDhAqpcLn/QBvoomUPhTX/3YMtuD9aTMpZv
l95r3kNyWWRFT6JIZ+wGVnQFhtIcGbi6Av1Xy4PgfitKEUY27qNk79yow9t7
FhignZ+SOYQu2L4JBU9vIUWvh/vwV7Kcljz7mlmqtieRtscKbefOGyrqyz95
Gznx4cic1Q8npnu1fZmyfaZISEPK5pBH/BVVOYn/45RJqMiTB34V33wGS1hP
kWcNF1gs4tcD1rg8DAyk7rkPV+LRN6qw7e0q3PuyVDnb9q3/5UbiYzIaiSO1
xdLuJGqLC1Mp8e53NLmo4amsenIpybloN/kTH3WH/RG8/SBxbJyLor89iuLd
21D4zL0CFuG67rkVjrsSYedAdl0cbBTYWlOiKE0VO2tL0mixOmXNHojj03rj
rcHtGglJ/y/lRwyRp8lrnSVlZlKyCEj4TF5CYhSeS4OAU960yVRKIBB3pmUY
KXFfc22hrK024hsCCcfSp9zYuacKz++rFqrbvMuD1Oc9WPOMR3j1pU/Sek7q
S97mFkEdB3czaSM5jdzHeJoVQ9aWodeiXLSZ5P19a1a2CsfvzFsapgpH3r1L
UfL6TpS+9byApWD7ZjgfT0X+Q2vEquKgFSWPYoW8u5NlwLiRg8WZsK6cRrCM
RzbtQY5P7YU3BrRR4RjyYz3uyOAHh27iUR7jWSYmRFjDtC9Q+M8Hy/UMAGXz
Dn4tZoEEoR4oBvigcMeLHjz1bhV2vF+Fh17z4HZ6Z+ec8lc3lj0ltbSIIqtE
9kt/oW38Q5WIIUOeskUab/9VZei6MBf9Fn4Da8EFFYU/jHdMlnK94F2w7Q4U
v/wUSl7dgaLnH4Jz2+3Ip8UhnxDIu3eZQMCxaRGlRDhupwmSOpt2ejE0OaaI
iZEV3x9HJ3XFh1H9YM2vlis1uyKG4caPGQYfFLq9KlEY+wOCpvmhwPNCSbSz
bIvzghG01Cly/N1LMm2AEvO4lpPe65M61c6EECzbkY90aw02kHVyBBu/Ve50
J9OWhc/wyUkQ71EbXDqMWE+3AasrKCLrt7ICvW6tQOeEYgxcnoXj58qw7Ok8
qfwQzl4102vrY6p+mZSFZdvtqM5OJ2PfQMadRJvneLlxXjaZwqZx7HP4FHbR
KB25nRE6WogHkKg5tCBkRfdC+sTOODprIIrPHMeyRzJ14mdBvVSr1Ldm9jrx
87FB07Z0QbPOslPP5Basz8V5mpaXOolyeaGOc/z7AdXUaj6Pdz9yOeivhkzG
+VYse9YJa+EF9dsak3jncrFNpxSQZgfRzM6V6xNpxDhTaoQN00vzSCaMIw7X
GhMPrvc+zcW22SW+iBSlHBBG/SS+/VJHZvAdGY9Gz+Oi0hVlYoRysPKDK5lC
+SxgJA8xuHZyyxhTfqk1K1tMGR1/esYfofF/nZnKH2tGnuZv4k6wvnjpZV+v
JXJGOu0nGSmvGBxhwfIa6ogqJFpeqIdudWkI9GvZB1FW/WyKDyLonsgfh1Fu
Cf9vCH2yUwCkS8gTiQUX00IEqHoWvVZyRXw1J7U1lT+WJckVg4wVxp+Qem73
pvjZWUxUr6hssqxYTY38uQCLtdYF/bpq/sQGyoYaFi+VgVPfxVPLUw3nudMN
/OEWlwevv8Tf6CgjuLYTf5HAn/Kkyu8T1EYGQR8ivoDjLxyEKpaWil+G+AcL
8W3bojL1SzP++cEs32uB9f2yTp61iFM8/i1MLw2QBx+Rrqgj186FebawToOX
V4jhSvFbb6ZF5voH6NblUd4H9NwG3PyUSFRLdz3Cd2CRzFGlKNNxTo+uD2kt
qK3aXt6pxlsmOBu5D73szbSuRlhjudj9sHCqpHq55JGg/EUdiUna5CaKkJCU
yWy5u/AnwFLpMHw73SKeQQhG70Qo50K9OSPnaNyUZTrfJwFAuWDmoxOjMHA3
/KmVNPnwb+UeQYbL4ivLn4T+WDRhZ+KrTQo8xdrPezfp6b1Pr5fhpXWh8DbM
ZmFeKKPFt6JOvPkW30oKbRRpB7LizSlPs/XysIcPKaPs3n2S+DpClDllPkpM
6EkW3rmJwwm7mpzyt1QekzYF6Bn0vxwV10w=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{151, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Frame", "Ex--21907299533234115765,3"},
 CellLabel->"Out[3]=",
 CellID->466935613]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28798],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20523]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4928],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"Frame\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 29.2425870}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"Frame\"Widget[\"Frame\"] represents a complete window. ", 
    "synonyms" -> {}, "title" -> "Frame", "type" -> "Widget", "uri" -> 
    "GUIKit/widget/Frame"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Frame"->{
  Cell[2824, 96, 552, 14, 70, "Notes",
   CellTags->"Frame",
   CellID->5760],
  Cell[3379, 112, 736, 19, 70, "Notes",
   CellTags->"Frame",
   CellID->99],
  Cell[5763, 194, 1783, 40, 70, "Input",
   CellTags->{"Frame", "Ex--21907299533234115765,2"},
   CellID->11652],
  Cell[7549, 236, 318, 8, 70, "Output",
   CellTags->{"Frame", "Ex--21907299533234115765,2"},
   CellID->19175],
  Cell[8007, 253, 159, 4, 70, "Input",
   CellTags->{"Frame", "Ex--21907299533234115765,3"},
   CellID->10678],
  Cell[8169, 259, 10548, 177, 70, "Output",
   Evaluatable->False,
   CellTags->{"Frame", "Ex--21907299533234115765,3"},
   CellID->466935613]},
 "PrimaryExamplesSection"->{
  Cell[5073, 166, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->148124238]},
 "Ex--21907299533234115765,2"->{
  Cell[5763, 194, 1783, 40, 70, "Input",
   CellTags->{"Frame", "Ex--21907299533234115765,2"},
   CellID->11652],
  Cell[7549, 236, 318, 8, 70, "Output",
   CellTags->{"Frame", "Ex--21907299533234115765,2"},
   CellID->19175]},
 "Ex--21907299533234115765,3"->{
  Cell[8007, 253, 159, 4, 70, "Input",
   CellTags->{"Frame", "Ex--21907299533234115765,3"},
   CellID->10678],
  Cell[8169, 259, 10548, 177, 70, "Output",
   Evaluatable->False,
   CellTags->{"Frame", "Ex--21907299533234115765,3"},
   CellID->466935613]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Frame", 21208, 525},
 {"PrimaryExamplesSection", 21878, 545},
 {"Ex--21907299533234115765,2", 22031, 549},
 {"Ex--21907299533234115765,3", 22292, 556}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1266, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1889, 60, 47, 1, 70, "ObjectName",
 CellID->16327],
Cell[1939, 63, 370, 11, 70, "Usage",
 CellID->14274]
}, Open  ]],
Cell[CellGroupData[{
Cell[2346, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2824, 96, 552, 14, 70, "Notes",
 CellTags->"Frame",
 CellID->5760],
Cell[3379, 112, 736, 19, 70, "Notes",
 CellTags->"Frame",
 CellID->99],
Cell[4118, 133, 69, 1, 70, "Notes",
 CellID->25042],
Cell[4190, 136, 382, 10, 70, "3ColumnTableMod",
 CellID->3055],
Cell[4575, 148, 68, 1, 70, "Notes",
 CellID->24393],
Cell[4646, 151, 390, 10, 70, "2ColumnTableMod",
 CellID->31065]
}, Closed]],
Cell[CellGroupData[{
Cell[5073, 166, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->148124238],
Cell[CellGroupData[{
Cell[5458, 180, 148, 5, 70, "ExampleSection",
 CellID->220759169],
Cell[5609, 187, 129, 3, 70, "Input",
 CellID->523419159],
Cell[CellGroupData[{
Cell[5763, 194, 1783, 40, 70, "Input",
 CellTags->{"Frame", "Ex--21907299533234115765,2"},
 CellID->11652],
Cell[7549, 236, 318, 8, 70, "Output",
 CellTags->{"Frame", "Ex--21907299533234115765,2"},
 CellID->19175]
}, Open  ]],
Cell[7882, 247, 100, 2, 70, "ExampleText",
 CellID->25750],
Cell[CellGroupData[{
Cell[8007, 253, 159, 4, 70, "Input",
 CellTags->{"Frame", "Ex--21907299533234115765,3"},
 CellID->10678],
Cell[8169, 259, 10548, 177, 70, "Output",
 Evaluatable->False,
 CellTags->{"Frame", "Ex--21907299533234115765,3"},
 CellID->466935613]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18778, 443, 311, 9, 70, "SeeAlsoSection",
 CellID->28798],
Cell[19092, 454, 462, 17, 70, "SeeAlso",
 CellID->20523]
}, Open  ]],
Cell[CellGroupData[{
Cell[19591, 476, 313, 9, 70, "TutorialsSection",
 CellID->4928],
Cell[19907, 487, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[20191, 499, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

