(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17221,        466]
NotebookOptionsPosition[     13654,        354]
NotebookOutlinePosition[     15825,        416]
CellTagsIndexPosition[     15624,        408]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "LabelStyle" :> 
          Documentation`HelpLookup["paclet:ref/LabelStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"LabelStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"Label\"", "ObjectName",
 CellID->10733],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<Label\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a textual label."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11452]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following property is available:", "Notes",
 CellID->7811],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", "\"\<\>\"", Cell[
    "text label", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->12229]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->468558973],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->309288012],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->166489809],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Label\>\"", ",", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<text\>\"", "->", "\"\<Parameter:\>\""}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"Label", "Ex--21907299533234115765,67"},
 CellLabel->"In[2]:=",
 CellID->22371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Label", "Ex--21907299533234115765,68"},
 CellLabel->"In[3]:=",
 CellID->11986],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1Wgl4VEW2vunuJAQFkUAIEpYIgRACkhC2QIAQspCNrEDIQhLIBmFLkE0c
3BgfKk8QHJ+OWz79eE9FHB0VQfSJ2zgjfiAqIJBJSLrT3UkQs3Q6EfF/51Td
2+mERpnvjff76t66datOnfOfU6dOVd2kgo2lRWsKNpatKBgVW1GwvrRsReWo
mHUVVKR3UxTlHkohoxTOg7LaTQ9l0NNQvB/jpGwRd0UxQPE5BGXEi2qq8uSM
nnPunPOAMly88k3mqnrk5IcqnVp5RBW3cPrg4SClV7+quVt7tuXXKmZHsPES
v0EZ9mc3lU+iMPQk+oR8j36x5zEgowZ9F35PMhkizxGNOdV9oERc5BzfIqo9
1NeIaq1sjizTcU6vVZY5j+tayHq9SV1PNKJa17OZIMVSRFyEMv0UlOBjLM31
UgxMM8Fn1Q/ok1lNUngualwHJa5F0cuWEz9kiBW3biWpzdQmlWi2nuPKcS2y
wYjfpfKc6h5sSO49uysLy/LgFjqRNXCWc9rT8CvfdKIng6PIuVjvyOlclDEj
To3UhkpkD9Z7yumadXetRTc1RXKrd+ZW7dVVPfceUmmc9K7voNirTNbzdCWN
o050D+25Ukgfl1L9OlX9TdSR3Hn0lk57urvWnytMo66zwKobW6CgKPgzuFCF
04ebx97gwgIpubugv+A6I6r6DbhdKVbfCxvVC7tC1KlzaVKezi1uoDhXZvTr
ZP//cjneXCHce4S6YtDQm0F9L7U4o+RytDvTvH609xbIM/S3BRruoizxN/2l
E2Uh1KjfpFLt0uueu6GLduH8XVdmyYf3Hk2ev0L5Oja8ws7fJBt3nIQyq1am
hFoyq6iTVNkt6iTcFpzipHhBF31Kz1kdlyt6+YVr0JsPvw3iZoP5fYRKQNCb
RL2FHufeBj8hBkGv3oifE1xfdKOT3SjxZCZuSReZRgrVSKqnZx17ZrpTWfol
zmlvKXVBXIX6j6nld6aZUC/ePLSyKOJinkhyJub7nPOyTL7N61E25zz3Fv69
QuHHjHOcgzL1nMzzk3mf0ciSMYyPStPUBEtokixn1DORpQ0M8VIqy2mGkv8D
lOWteuiLWgzQl7ZTp/rSn+C2SiSqyXdipOga3FZ2cVJIsPwuvv0scgxhThe/
ymdWJ5RlNuqhDcqSDtGjnXtc0gElsx1Kajs/dZwxcI45Tf0RSuIV+ZR1uF1i
G+EVe8WNRXNzls2zp2xLSYbsVu1JLfX5HODoCzpYIpaH3jxWddGt/GdP6Fdf
Jb2u+mUwf9GxaPTZvfgqiv9sA13KbeKuh+nyNVFG35Qb1/OU9Z5ug3uBnQER
MLjn2VH8pzZlgKjTB6bmn1G8rwXui1pZMJaLbKGxt9Y0yep6SOaWb2Np2ByL
ulQNkTwsDpV5rrtGgV3FNQM8NvxCHytAt7UYwjIqg1HyfAdOnW9B4OJP0G/u
u7h9wQcYGP0+BkUfwcAFR+AdfQzeMR9gQPSH6Bf9EfpGH0efBZ/AI/Ij6Od+
BLe5nxBDH2Jk8hGcPHeZ6SkCPyXk306bkWVTY2MqftqGH86cwjsLAnFgQj8c
nHw7XgsZiFdCB+GVyQNxMNQbr1M6FDIAb07uh7cm9cXbE/vgzSAPvBmox9vj
3HBojIKDs0ei8duTAn1hfBr6EnlFg97QG3od407F0o5+kqiX/ywA1zHgHvDc
+IvOgfoQRl2nom764RoC82rgvagGwzJr4L+sDgE5lzA2txZj6Dk6rw7+lEZQ
GracQvQ8E7xzG9A/2wSvpQ0wZDTALZl4if6G0HlPWJGG+u9A24E62/JXCwNx
YoY3TswZhpML/HEyNoDSWJyMGYNTsaPxdYw/TkePwHfRw/DdfB+cmeeN7yL6
48xML3w31YCvJ7vh4yAFrxHygvavoH69wavGLky9PzIzMwW4BgbXRwWXr/4p
l+GXfQWBK37EXaU/YsrqFoSVtyCkvBUha1oxaV0rgta3ImB9G0aua8PQNe3w
XtWOfsXt8Mxvg24Z+Zok6jb8iBO4vxdtglalfW56f1yI8kN1YiD+mXYXajKn
oHZJGGozQ1C7OASXFk9CXWYQjOkBMKaMhClxKExx3jBF9YNxjidqZ+jw9V0K
Xh2taLQT29hD9wRXTG40WYw83dObLJfehMDFC1W0jjYajdS47vwFmC0WTmTw
TU1NdKfPjDncyn/hNNQJn0GL2xBQ2I6Q1e2YuaEdERttlDow624bZm6yYfpm
G0K3dCB4ix0Bm+0YucmOoRV23L62E7eU2uGe3w5dOhlhxIeaDORcQ34P2o55
ia/q2YNQmxCASxkhqM+eCWNeBIzLKeXNgilvJqXpaMgNhTk7GJYlAbBmjIQ1
ZSis8bfDsuAWGCPccWaKDm+MdZO0ezvykM8d2HtBGX1GnaPMcr5d7vDkAtyy
sjKSnBSgE7j3xYULF/DZo4+JJ+lAaITz/OR3bkRK0PGcLCAbIuZjd8GLb1Yb
JtFsF06Yzd9so4HFDHohaHsnxmzrxPDNnRhc2Yn+5Z3wWtEO98Vm6Ob+r5N9
uqZzi6jh56qdY77n65/zfHEpdRLqc8JhLJwP2/F3RHlDURSlSDSsjIC5cAYs
+aGw5gShMWuM+G5/rwrWuP4wzfPC2Wnu+Ms4HRfrGFg260iLhDb4Cwe0hm5o
GfjUJh1jyzEgocsgsVELZIl7BpBy+HtpCazZqTh69KgEmp7H9+8V4La1tXE7
Ob/qGFRfEdlIREbktmHaWkKDrG/hPd3ITryXLJCQHUHIDiFkb19jFx7gliyz
mOA0ZLsIPRd0RFn8H+yI+0MHond0IPI+snJ6Tt1h70GbLxe0ZYRF0RJfNeSO
65ZOE8ibShbqxXd3NJRGw1wSCfPKWbAUTkVj3kRFfusrjLphQT+cnXUL3pzg
IUlqxsyos9sQkYkA3V31JQy6kfpt5PhRkcjfKlCvrKwUaDLa7yQk4dTfPsfZ
rCWoK0tFzYZcfLlqGY6PHo23//pXqRwD9u/bJ6dXmYawBnUcPqrQBxS2IaKy
HXEEV/J9Hd3Qb7dj7NZOjCIHMLTSDp91dniXtWNArgV9FziMmugMdkVHlCXf
34EEyscS5PMpzaY0jaF3os3XDWhntigSM3Yo9eRITCVxaChPRsOaFAmxHubS
+TAXzSbop6mwewh/Ykn0gTHWG+fmUugysa9q75EWsUapk2uUoMPOroSh53WS
gN7UHb6TS2HoP/74Y9Xg++Hz7BwcDRqL9pwYNKdGwXygHIfzI/DU2OEC7717
HsfRHZvFk3HnIEdg5SuiZwnYBLK1BVsILAIl7YEOpD/YgVR6Jt1P9kplUZQi
yG6nbu/AxG0EGIHlv9GOYRvs8F1LiWZDn+Vm3BbrGAdL25QRLmnzdTO0hXe6
njarQqwc+Lq0aAKMKxagYXUyzOvSKKWjYW2qBH8AKSMC2vWLrQWWDH9YUobB
nOQLY7wvzlI081bIbZIsj4F5l7pXjUGHNYUMgTLqC7n4YoWkmnqsp1ghJ748
gepj7+PbY8fw+aJY1K+IgO3l1WjYX4Dmwum4MCMYfw8Zh6NxU/FjRjzOnzmD
5198QaxcdKyHoTxdq8oIpakw4V4bMkgJix+yI/NBuwAuiaw37l6yXgJq9rYO
hNG0OHFTB8bSiPAnRfit64DfGkoEmF9BAwbGOaz3hrT5uhnafN2AdmoTBR58
1WWEwlSWAPP6DJg3LIZlfaZQSkN5khjeZKzmzLEwp/mjIdkPDUl+qE/0w5kY
P/xlykCpBB4OrABe5LLTl8NChI4+12uBvZKqCdbCtuwsXJpJAXPUNDTlJKP1
6SJ0/eMhtB68G8Z7M/BV6myYnt+I5m1pePaRXTjx6ad49rlnaQGZ28xjkRXK
5JY2EVp052HfqAI3nTx5KrmQJTvtyPqjXTzT6D2JLDf2HvLmW8mbU6wSRvFL
cAUBR8q4kwAbsboDI1d1wH9VG/wLG+Cz0BEDEe1RLmkLpdwEbb5c0GaVCHz4
qs+aDvOaVFgqlsBSmUWKWUIjhJSyKolcWKwcKTQdLwmGKX0sTCl3wpQ0gtJI
1CX748xCf7wx1UeSZY+k7USMPwVl7EFNN2S+dxyDMu203L7gzRFaeChZNKRy
rEI3WmBzeeMKND+SA9vebKGX03vW4HBxOv5WkgD7kU2wPLAIVbsexssvv4yt
27ayajTFsIqyLD5OSpld0Y6shzuQ+4gdubskeOkEXDIDt82GSHI74QRaWAUB
t86GceU2jCbARpURgKU2BJRRUE/ADU1wVopr2nzdDG2+bkA7qV4dKfW5NEls
zIJlcy4sm3JhrshCA7ku0+pkbaQYU8fBuGg0jZBRqE+6kzxdAL6LD8Ab04dK
ZWhbQYw5K0OOlP73kjZ8e2oj/qI6WkxCI9rcLULOI+/i7ENpFJ3NFBr4ojwT
nz20GYez5xJjcaheFg7T1CDU/tczPFJUbVh1TEjsLbE2TCpiMVttyH/MjsLd
nch/1I7sh+3IeMCOZPIpseRPIgmt8A2EGJn7xNU2BJbZMKbEhjuLCS16ji9t
xfgVRgxL+MChDZM6ifSmzdfN0ObLBW25Q5dQK/KmohhYtuXDsr1QPjdmw7w2
Q5tEOMJ1vuqSxqAu4U56BqA2ZTy+TRyPQzOH9dQKa4S9lRgiQil9rldKRr2z
UnRiIXYrLkwah/emBeNE6ER8kThDeCyeNx718xH6OLckBu8+9zQaamvwP0/t
0zt0MaSXLkqf6MSqfZ0oerwTeWTBS2geSSHrjSd3EkXLqwjCiwPUuwivCYRX
IOE0jnQRRNYbTNYbVGiEX6KzLtxd0VaXDP1ctZMbkU44W+8vReODq2D9QxFZ
f56ihU7GgigYcyNQv1QLnW4h/zMOdSlkfKnB+CYpCK/P9OsGWTN7CbLD9H0k
ytO/pGnktESZd2sZ5WVmYfqZmZmwvPKSMP9PKyvEpMCOhycKzeQPTA1G9dvv
CKelTtUcMpkFzL5OMLOHXvtUJ9Y/LeEofKwT2eSEMu6zI4k8d+zmDswjBxFO
DiJsTTsm0/Q7kYLLYIJ7IqVJBFfwChOGJx5zTKcazL1oqzDf6qpdD5jZszc9
vBZNj6xnqLW1gak0CcaVsbQAnkeL4XDULQ5TtG91aRNRkzaJUA7G6+HDNVam
nWaXG/yFRHnMAcXJln1f4+UvlLmM8jm5T872LFHWbJlXWl8fOoTLSxah7aEV
aNsSj6b4UJy5Zwsulhbg9bAZuHr1KrpsthuDzPHJ1hc6sb2qExsIjJK90gdk
7ZTenoGOoekxspKBbscMsumw8naElstthcllLQgmm3QC2WHLvWg7lr8u2vUA
meOa5r1b0bxvOwG9AfYTH8ty8uTmNekq2jGEdqRAuz5rhvje9v7rqMsMQU36
ZHyT7ED7OrCdTNrrt8DmeZKEIqyJ/S8XxqDdKte47Z99CGPwOJFnhJtppcZb
P4y4XP+6gnvpHzuw69Uu7H69CztekpCzba/8TzvyHpGTbAbBlkohY8J2G+Ip
cXw/l1xKeAVDTy6goB6+ce87wR38e9DuoRLLxqX44blduFK1G5ef3CHUIlzN
vSth2ZIHM0c/6zJowZZK6kmgFC/WDsb8ucLH1y4Ow+nEIByc5nuTKgk9Lk+P
Ys+SlzlPYNZQMgqV8A6PVIm78DSaCjhZE+OolJRA1Lkuq5ES97W0YTCjpROH
N1IdRXvseOrtLjxz+CcB3bYXO1HxTCfWPNkpvHDR4zQrEnwFu+0iVuGYJY2i
+0RyH1E0KqavbUXg8noMjnFsTqZfUtXxb6YtDVNVh3VHEX585Sm0HHxGqKV5
7zY0PVqBxp1rxCxgoRnASjOu9Z4CGQdt5BgoDaZViaSWKFyiwPV0fCBenTJY
Vcf0L2/gjgw91KGLPsUynufKpBFGmIJJeiMd6FkBlLV++okYBVIJN1DFECct
bHq2E3ve6ML+t7qw8787cTe9s3MufcKO4j0SpeUUn+SxX/oPWlvt7EAKGfLC
7dJ4Q1e3YnROPSbnfAZT81VVC78b7ZRa5Q5Bu3n3Jlx5aQ9+PLAfPzyzE027
70YjTQ6NpAHrjmKhAcvW5ZTyYLmbBkjFYloepNDgWCgGRm1mKE7FjMa7CZNh
avxJzqzsilgNdx5hNThpYcwBqYXIf8AtsYcWeFwoeWbmrdDqAbeiJpHjA8cC
WsTlWfkrJ73DJw3qHgleKN7fiIuma6gk6+Q4MPMhuTyKo0icN9jISRDtOZU2
HWZtoNuU8nbFA5NptRq4sh0jc68grKQWpy+0onifVYLvxdl/mejtNyKqHgnX
onivGT9dukjGXknGnU8rrky52iqOozBnPvsc3rxZPkdHbmeWjibiKcRqHU0I
tUmBuBg9EqfSw3Dl3GkUP1yjE5vMegmrxFsze53Y+zdoaEsXlH6enXoNt2A8
C60aykVNVLPkso5zvLlHX7qRt3JQL6cDH3FirIf7MhOK/9QE0+Wr6qGmp3jn
crG2o+Syzn6qs7hezk+EiHuaRIQN01Hn4Rq4zzrRbUwsXNBhzcUOflH8VCFK
OYBL+EocuquSGZwlY2n0LBeVlrUKCaWw8qRbpsG8gBzPInp0D24ZE8oj8vRL
Ysjo+MyfT/8vGnia5S3ps/wzwjeMF0+97Ou1RM5Ip+2XSn6FcKQL5tfQi1XB
UcllPXTlLV7Qr2UfRFn1vJpPv+k+n0/lKbeimTrUFzQJBelyrSIx42JY6Jlz
PbPezbkifleQaMWLX8hizyoGGStEfSNx9n1NHGKIgepglU2WgdVgpI4FW2tt
0K/7ic87oVReY/YqWHHqu3hqefrCee60kk/Mudxjwy98YKoE8tdBfJzE56oV
8nBJbWQQ9b3Erwd8PCWgKGoRm/q8zyl+KuCnOOLnXcs+8r1bsc6/NPDKXadu
2uSI3Rw2QBY+4qKiSq5Tw10eLYypR0m7EFey772NJpk7HqCb/y5ekozbDUzY
IxJ9pbseIfsRJXP0UZTpOKfH6J1aC2qrtpd3+uIoE5TduQ+97M1z3TVhjW1i
tcLMqZzq5ZRHjPKvDMQmoclNFMEhgclkubuQx8Bc6RC+l24RT8ILc5/CYM4N
cuTcOUdyU5brOT9JAZTzYDo6IYWBu+Fzb2nyIZ/LNYIMl8XvLV8J/Jg1YWfi
dxkKPMXcz2st6ekdT4eX4ak1R3gbsddmFVtsg3hvchAvYQ3aFg8fW6q7cHpV
oakiy3sYvLOVYHask8RZmyhrkvkEMaBjjPzrjVjim9XUJA865p52V0eB2/8B
NMhrvg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Label", "Ex--21907299533234115765,68"},
 CellLabel->"Out[3]=",
 CellID->43822796]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3845],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LabelStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LabelStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13950]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2224],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"Label\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 35.5078912}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"Label\"Widget[\"Label\"] represents a textual label.", 
    "synonyms" -> {}, "title" -> "Label", "type" -> "Widget", "uri" -> 
    "GUIKit/widget/Label"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3292, 113, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->468558973]},
 "Label"->{
  Cell[3960, 139, 418, 11, 70, "Input",
   CellTags->{"Label", "Ex--21907299533234115765,67"},
   CellID->22371],
  Cell[4403, 154, 160, 4, 70, "Input",
   CellTags->{"Label", "Ex--21907299533234115765,68"},
   CellID->11986],
  Cell[4566, 160, 7592, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"Label", "Ex--21907299533234115765,68"},
   CellID->43822796]},
 "Ex--21907299533234115765,67"->{
  Cell[3960, 139, 418, 11, 70, "Input",
   CellTags->{"Label", "Ex--21907299533234115765,67"},
   CellID->22371]},
 "Ex--21907299533234115765,68"->{
  Cell[4403, 154, 160, 4, 70, "Input",
   CellTags->{"Label", "Ex--21907299533234115765,68"},
   CellID->11986],
  Cell[4566, 160, 7592, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"Label", "Ex--21907299533234115765,68"},
   CellID->43822796]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14658, 378},
 {"Label", 14790, 382},
 {"Ex--21907299533234115765,67", 15195, 393},
 {"Ex--21907299533234115765,68", 15344, 397}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1249, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1872, 59, 47, 1, 70, "ObjectName",
 CellID->10733],
Cell[1922, 62, 367, 11, 70, "Usage",
 CellID->11452]
}, Open  ]],
Cell[CellGroupData[{
Cell[2326, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2804, 95, 68, 1, 70, "Notes",
 CellID->7811],
Cell[2875, 98, 380, 10, 70, "3ColumnTableMod",
 CellID->12229]
}, Closed]],
Cell[CellGroupData[{
Cell[3292, 113, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->468558973],
Cell[CellGroupData[{
Cell[3677, 127, 148, 5, 70, "ExampleSection",
 CellID->309288012],
Cell[3828, 134, 129, 3, 70, "Input",
 CellID->166489809],
Cell[3960, 139, 418, 11, 70, "Input",
 CellTags->{"Label", "Ex--21907299533234115765,67"},
 CellID->22371],
Cell[CellGroupData[{
Cell[4403, 154, 160, 4, 70, "Input",
 CellTags->{"Label", "Ex--21907299533234115765,68"},
 CellID->11986],
Cell[4566, 160, 7592, 129, 70, "Output",
 Evaluatable->False,
 CellTags->{"Label", "Ex--21907299533234115765,68"},
 CellID->43822796]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12219, 296, 310, 9, 70, "SeeAlsoSection",
 CellID->3845],
Cell[12532, 307, 458, 17, 70, "SeeAlso",
 CellID->13950]
}, Open  ]],
Cell[CellGroupData[{
Cell[13027, 329, 313, 9, 70, "TutorialsSection",
 CellID->2224],
Cell[13343, 340, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[13627, 352, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

