(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19214,        488]
NotebookOptionsPosition[     15941,        386]
NotebookOutlinePosition[     18082,        447]
CellTagsIndexPosition[     17882,        439]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "DockedCells" :> 
          Documentation`HelpLookup["paclet:ref/DockedCells"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"DockedCells\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"Menu\"", "ObjectName",
 CellID->22424],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<Menu\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a menu."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->70]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->106572378],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->310982997],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", "  ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{
     StyleBox["Widget", "Output"], "[", 
     RowBox[{"\"\<Frame\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\"\<menus\>\"", "\[Rule]", "\[IndentingNewLine]", 
         RowBox[{
          StyleBox["Widget", "Output"], "[", 
          RowBox[{"\"\<MenuBar\>\"", ",", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              StyleBox["Widget", "Output"], "[", 
              RowBox[{"\"\<Menu\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Menu A\>\""}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", 
                  RowBox[{"\"\<MenuItem\>\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "->", "\"\< Item A-1\>\""}], 
                    "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", 
                  RowBox[{"\"\<MenuItem\>\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "->", "\"\< Item A-2\>\""}], 
                    "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", "\"\<MenuSeparator\>\"", 
                  "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", 
                  RowBox[{"\"\<MenuItem\>\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "->", "\"\< Item A-3\>\""}], 
                    "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], "]"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{
              StyleBox["Widget", "Output"], "[", 
              RowBox[{"\"\<Menu\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Menu B\>\""}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", 
                  RowBox[{"\"\<MenuItem\>\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "->", "\"\< Item B-1\>\""}], 
                    "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], "]"}]}],
             "\[IndentingNewLine]", "}"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         StyleBox["Widget", "Output"], "[", "\"\<TextArea\>\"", "]"}]}], 
       "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->{"Menu", "Ex--21907299533234115765,80"},
 CellLabel->"In[2]:=",
 CellID->30883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Menu", "Ex--21907299533234115765,82"},
 CellLabel->"In[3]:=",
 CellID->15905],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Menu", "Ex--21907299533234115765,82"},
 CellLabel->"Out[3]=",
 CellID->161224643]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7483],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DockedCells",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DockedCells"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19221]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11183],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"Menu\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 39.7420494}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"Menu\"Widget[\"Menu\"] represents a menu.", 
    "synonyms" -> {}, "title" -> "Menu", "type" -> "Widget", "uri" -> 
    "GUIKit/widget/Menu"}, "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2315, 78, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "Menu"->{
  Cell[2975, 104, 2894, 65, 70, "Input",
   CellTags->{"Menu", "Ex--21907299533234115765,80"},
   CellID->30883],
  Cell[5894, 173, 159, 4, 70, "Input",
   CellTags->{"Menu", "Ex--21907299533234115765,82"},
   CellID->15905],
  Cell[6056, 179, 8386, 142, 70, "Output",
   Evaluatable->False,
   CellTags->{"Menu", "Ex--21907299533234115765,82"},
   CellID->161224643]},
 "Ex--21907299533234115765,80"->{
  Cell[2975, 104, 2894, 65, 70, "Input",
   CellTags->{"Menu", "Ex--21907299533234115765,80"},
   CellID->30883]},
 "Ex--21907299533234115765,82"->{
  Cell[5894, 173, 159, 4, 70, "Input",
   CellTags->{"Menu", "Ex--21907299533234115765,82"},
   CellID->15905],
  Cell[6056, 179, 8386, 142, 70, "Output",
   Evaluatable->False,
   CellTags->{"Menu", "Ex--21907299533234115765,82"},
   CellID->161224643]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16928, 409},
 {"Menu", 17050, 413},
 {"Ex--21907299533234115765,80", 17454, 424},
 {"Ex--21907299533234115765,82", 17603, 428}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1252, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1875, 59, 46, 1, 70, "ObjectName",
 CellID->22424],
Cell[1924, 62, 354, 11, 70, "Usage",
 CellID->70]
}, Open  ]],
Cell[CellGroupData[{
Cell[2315, 78, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2692, 92, 148, 5, 70, "ExampleSection",
 CellID->106572378],
Cell[2843, 99, 129, 3, 70, "Input",
 CellID->310982997],
Cell[2975, 104, 2894, 65, 70, "Input",
 CellTags->{"Menu", "Ex--21907299533234115765,80"},
 CellID->30883],
Cell[CellGroupData[{
Cell[5894, 173, 159, 4, 70, "Input",
 CellTags->{"Menu", "Ex--21907299533234115765,82"},
 CellID->15905],
Cell[6056, 179, 8386, 142, 70, "Output",
 Evaluatable->False,
 CellTags->{"Menu", "Ex--21907299533234115765,82"},
 CellID->161224643]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14503, 328, 310, 9, 70, "SeeAlsoSection",
 CellID->7483],
Cell[14816, 339, 460, 17, 70, "SeeAlso",
 CellID->19221]
}, Open  ]],
Cell[CellGroupData[{
Cell[15313, 361, 314, 9, 70, "TutorialsSection",
 CellID->11183],
Cell[15630, 372, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[15914, 384, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

