(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19317,        490]
NotebookOptionsPosition[     16013,        387]
NotebookOutlinePosition[     18184,        449]
CellTagsIndexPosition[     17984,        441]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "DockedCells" :> 
          Documentation`HelpLookup["paclet:ref/DockedCells"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"DockedCells\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"MenuBar\"", "ObjectName",
 CellID->5984],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<MenuBar\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a menu bar."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27110]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->197069973],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->52614173],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", "  ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{
     StyleBox["Widget", "Output"], "[", 
     RowBox[{"\"\<Frame\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\"\<menus\>\"", "\[Rule]", "\[IndentingNewLine]", 
         RowBox[{
          StyleBox["Widget", "Output"], "[", 
          RowBox[{"\"\<MenuBar\>\"", ",", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              StyleBox["Widget", "Output"], "[", 
              RowBox[{"\"\<Menu\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Menu A\>\""}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", 
                  RowBox[{"\"\<MenuItem\>\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "->", "\"\< Item A-1\>\""}], 
                    "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", 
                  RowBox[{"\"\<MenuItem\>\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "->", "\"\< Item A-2\>\""}], 
                    "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", "\"\<MenuSeparator\>\"", 
                  "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", 
                  RowBox[{"\"\<MenuItem\>\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "->", "\"\< Item A-3\>\""}], 
                    "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], "]"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{
              StyleBox["Widget", "Output"], "[", 
              RowBox[{"\"\<Menu\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Menu B\>\""}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", 
                  RowBox[{"\"\<MenuItem\>\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "->", "\"\< Item B-1\>\""}], 
                    "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], "]"}]}],
             "\[IndentingNewLine]", "}"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         StyleBox["Widget", "Output"], "[", "\"\<TextArea\>\"", "]"}]}], 
       "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->{"Menu", "Ex--21907299533234115765,84"},
 CellLabel->"In[2]:=",
 CellID->28599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Menu", "Ex--21907299533234115765,85"},
 CellLabel->"In[3]:=",
 CellID->14643],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXAl4lcXV/nKXLFioEEmhrBFCYgxIwr6ExZCF7CshZCEJJAQIW4IgiMVa
qXXhLxRaf6xt5dHH1opaW5Wi1N+9tuIDYgUKpAlJbu4NCWKWm5uI+P7nzHzf
XcINBAyL1u955pv5Zjkz5z1nzpyZuUlCwdqSohUFa5cuKhgeXVawumTpovLh
UavKKEvvoSjKyxReGq5wGpTUXnoot+yC4vsoB+Ul8VYUAxS/F6AMfVINu3tx
wsApH07Ra4j45NeQJ41cYNDydhu1gt0GtbJopn4aOeVtJ2VwTfWztxVU+nKe
YlCH8RR/QRn0aw91nFRn4EF4h/4bvaOP4+b0SvSa+2+qbph9jIpmVPSGEn6S
Ws84SZ/hFd78KVIij18VPlqVCqM9ZeAUF9hLwx2l8tNR4FJlhmvlcCdSikhC
mXQISsh+5uZCLvqlmuC37DN4Z3B1r6TTv4cS08RC4paj32CIFQ+HkNRmapM9
oIcrxzTJBt/6ykNv0MpeYe4rz2AGd38LKt8gOF+eUEKPdV35AjS+gZW7QmNG
xWVMqxu5stdFKruB7sau7F5Fvz2Vwyv+Cyp3W0VvlMrujcw3r/JFLf83rLKw
dTd+5SysWbU47SItjJ1boOlstZKJPX/YRS2oMdRHSbnAqjioeLqjwvUz0Fh/
jBoROY2YknoRQl5dERJ0NEYorVFU0r6j9o2m5scJPe9sdZzS2VOOPFZr2vfa
NVHL1jtndzvPYCfev0cZ+YH7oepF7OWSrRZpcVdcGrrJkezC6K4L5ZZrx6O7
QXVfcp6c5eOmtN8140AgSDg6i8dVRN1nUdQ0Xld2rkzpjO6zvTnWXa1Z0xnX
C22ASEm+RF1FrDpuh9rreqHuZ8fIS+RcixnpMJ9O4HDU3z4Yb3uVnhXdjbyq
fEftSqlJx+9yqR3r0bF9R+1KqDkdBl4etU4nbxends39NcfSfEnLeVmMXG9/
zTXP79rx1gN+mqeb0ksuLm456GoKXFM/zR0uV6ZsV8JOj/pp7jxo36vAyvX3
2HoC/x7y2C5rKD3rsV2WWbj0SlDxX03tin2sLhTgO2o9OXG6RW3I9aF2I59i
XRYj188rcndY0i3L2zO89YBX5NVjHHh9c72iCnc7k+vtFXlfI1Z61Cu6VoO+
iFfkOPW79P7EXcdfwwdy58h26+hsSI/usv+LqXWlNZe7qnt2Re2Sl4OdCBnd
EVLmqS2cqSSLt1HkiWR3fmA0X5CTl57ckE/CksXb0JlIlzRCEbrsvXtUvrrV
6ze6hZPj577FxX475Mkt1PlPKfXLXZ6wCZw0OheIALECU0rIyOCmuc5Nnuja
UxssWRjWZfnlLk8Yb04anQtEULQyg/R1tFR6TyMhlfzK8rqC4WtBI433leXx
18UQTbt89AwuqmHXGFdgjCLPy50WXRo8sUx7O+AxuAzdriOunBtFnpc7Lm84
dAwO/rX8C1SkK4T07rvxuUy4DA5AtHy39XoeMp/xx10h83Hmuav4a03JS2Pm
48x0V/HXn4XdtFgXQOR1UWiE6jiMt8Ghdu7NuPGScHhdFAbBisNYGy5ltg09
qi+qd6+lBthTvezj10ETgupS3wD9d1P0Xo7eLlzopx2H4v/st7HFDw9SbpUM
cVWEWsRBquwRcRAecw5xoBmqizyk56SO8xW9LOEa9HUbfwVysyD+HqoSEPTG
EM5hb3Fv/X8hfW7X3kgSB7i+6EYnu1FiScE9Ek4yjWSqkVBDcTWV8pvy0k5x
SvtKrk7mKtR/VBV/M824GvHlqeVF0ChmicBf4eI947jMk1+zXPJmHOfepv6b
tobK5GOcgjLhmExzzGOffJo5YxgfkV67xlhcgxxyeg0TmV/HEM+nvJxGKPmf
QVnYrIe+qMkAfUkrdaov+QIey0SgmvymgRSdh8fiDg4KMZbfwa8vRYohzOng
TxlntUNZYKUeWqBktokebdxjZhuUjFYoKa0c6zhh4BSPNOVzKPFnZSzrcLv4
FsIr+qwHs+bhzJuXK2/ziYfsZi2mlvp8/kMgfUEbc8T80Jfnsg56lX7pBf3y
cyTXZV8FcUkQs0bFxuJzKP61VVjE76tLh+nMeZFHZTycLup5yXq7WmAssDEg
AgZjng3Fv2pRbhZ1vGFq/BLFO5pgTGpmxpgv0oXTnaWmcVbtwplHvpW5YXUs
6lAlRPwwO5Tnteq8Hl5l5w3wXPMVFZaRPdKvRDLzSDv7Jb9tw6HjTQia9w56
z3wVfef8Df0iX8ctkfvQb84++Ebuh2/U33Bz5BvoHfkmekW+Be8578Bz9pvQ
z3wTHjPfoQG9gWGJ+3Dw2Bmmpwj8lNAep83IsqqxMhXvsuKzI4fwypwgPHN7
b+wZ2xfPhfbDs2G34Nmx/bAnzBfPU3gh9Ga8NLY3/jymF14e7Y2Xgj3xUpAe
Lwd64IWRCvZMH4bT/zoo0BfKp6EvkVc06A2dodcx7pQt9egLiXrplwJwHQPu
Ca+1X+nsqAcz6kEq6qbPziMorxK+SZUYlFEJ/wXVCMg5hVG5VRhJ8Yi8avhT
GEph0EIT/PJM8M2tQ59sE3zm18GQXgePRBpL5CeEzl/VlV2ifhVo21FnXf5o
bhAOTPbFgRmDcHCOPw5GB1AYhYNRI3EoegQ+jvLH4cih+DRyED690w9HZvni
0/A+ODLFB59OMODjsR54O1jBc4S8oH0R1C9UeFXZhar3QUZGhgDXwOAmqeDy
0yf5DAZnn0XQos9xR8nnGLe8CeNLmxBa2ozQFc0Ys6oZwaubEbC6BcNWtWDg
ilb4LmtF7+JWeOW3QLeAbE0CdTt1nxO4V4s2QavSPjapD05EDEZFfBD+k3oH
KjPGoSpzPKoyQlE1LxSn5o1BdUYwatMCUJs8DKb4gTDF+MIU0Ru1M7xQNVmH
j+9Q8McRikY7voUttCu4YnGjxWLYYVdrslBaEwIXv9v9pCdqa2upcfXxEzBb
LBxI4RsaGuhNxYw5PEq/4pAi8PETisLPLfNaEFDYitDlrZiyphXha60U2jDt
LiumrLNi0norwu5uQ8jdNgSst2HYOhsGltnQd2U7biqxwZjfCl0aKWL4G9JD
ZfsaejVI25cmfiqm34KquACcSg9FTfYU1OaFo3YhhbxpMOVNoTAJdblhMGeH
wJIZgPr0YahPHoj62L6wzLkJteFGHBmnw4ujPCTtzrY89H07/LSNGHFEXabM
csldaDfmAt+lS5eSAEkGOgF9L5w4cQLvPfKoiEkMQiic5pi/uRHJQcfLsoAs
SSzJnoJH4YBmtWAMLXpTCbc711vl3YgPgje1Y+TGdgxZ347+5e3oU9oOn0Wt
MM4zQzfz/5y01OiOjHKTqDHYXTv7qs/Pf2YNwKmUMajJmYrawjthfesVkV9X
FEFhNuoWh8NcOBmW/DDU5wTjdNZIUW77627Ux/SBaZYPjk404k+B2oVe9FlW
7tkWiW7IB3Z0DQ50GfuUBh3Dy54gAcw4sWoLcGn0jCGl8I+SJajPTsFrr70m
sab4rZ3bBb4tLS3cTq6yOsY1Rfg3EpGhuS2YuJLQIAWce49V0ZAdfS8pISE7
lJD9ASHbd4VN2IGbssximdOQ7SD03NARebE/siHmR22I3NyG2feRolM8YbPN
hTY/bmhLP4t8Jn4qyShXz58okDctmav9QL2uJBLmJbNhXjwNlsIJOJ03Wm6J
SeFYr+vm9MbRaTfhpds9JUlNnxl1Nh7CPxGgG1WLwqDXUr+n2YtUJPLfE6iX
l5cLNBntV+IScOjv7+NoViaql6agck0uPly2AG+NGIGX//IXKRwDdu7YIRdZ
GYJZgkHsRKrQBxS2ILy8FTEEV+J9bQ7oN9kwakM7hpMNGFhug98qG3yXtuLm
XAt6zbErNdHp746OyEv8cRviKB1NkN9JYTqFiQy9E21+uqCd0SSvkYRNqSFb
YloSg7rSRNStSNYu8swld8JcNJ2gn6jC7ilMiiXeD7XRvjg2kxyY0b1UfZ9t
ETuVarlTCd7rbE0Yet4nCuhNDieerApD//bbb6sK3xvvZ+fgteBRaM2JQmNK
BMzPlGJvfjgeGzVE4L1928/x2ub1Imbc2dURWCULH9pP6BU/t5O+zbmbACNg
Uu9vQ9pP2pBCccKPSWcpL4JCOOnuhE1tGL2RQCPA/NfaMGiNDQNWUqB10W+h
Gd+PflPlcH6LMtQtaX66Q1oYqAtJszTEFoKfU0m3o3bRHNQtT4R5VSqFNNSt
TJH430zyCIf2fGVtgiXdH5bkQTAnDEBt7AAcJbfmz6Hfl2R5Gsw65dg+Bu/V
ZPIDKMM/kLswlkmKyWVjxTI58OEBVOx/Hf/avx/vJ0WjZlE4rE8vR93OAjQW
TsKJySH4R2ggXouZgM/TY3H8yBH89snfiS2MjkWRyuu2qsBhtCDG3WtFOslg
3gM2ZPzEJoBLIAWOuZcUmICavrEN42lxHL2uDaNoUviTHAavasPgFRQIsMEF
degXY1fgLmnz0x3a/HRBO6VB3mSiOj0MpqVxMK9Oh3nNPFhWZwih1JUmyJvj
3jBnjII51R91iYNRlzAYNfGDcSRqMP40rp8UAs8IFgDvdtnuy5khfEi/C6XA
hkmVBEthY3YWTk0hzzliIhpyEtG8qwgd/3wAzXvuQu296fgoZTpMv12Lxo2p
eOLhh3Dg3XfxxG+eoJ1kbiNPRxYok5vfoATxO4h7UIGbRMY8haxI5hYbsn5q
E3EqfSeQ5kbfQwZ9Axl08ljGkxcTUkbAkTBuJcCGLm/DsGVt8F/WAv/COvjN
fcNuVU4rw93SFkLpBm1+3NBmkQh8+KnJmgTzihRYyjJhKc8iwWTSDCGhLEsg
KxYtZwqtyJkhMKWNgin5VpgShlIYhupEfxyZ648XJ/hJsmyUtCOJ2w5BGbVH
k81A8u/3Q5l4WJ5j8CkJ7UCULJpSOfVCNpp7c2btIjQ+nAPr9mwhl8PbVmBv
cRr+viQOtn3rYLk/CbsfehBPP/00NmzcwKLRBMMiyrIkOQllelkrsh5sQ+7D
NuQ+JMFLI+ASGbiNVswmszOVQBtfRsCtsiKw1IoRBNjwpQRgiRUBS8m7J+AG
xjkLxT1tfrpDm58uaCfUqDOlJpfWibVZsKzPhWVdLsxlWagj02VanqjNlNqU
QNQmjaAZMhw1CbeSpQvAp7EBeHHSQCkM7UyIMWdhyJnS516SxgBXacSeVGeL
SUhEW76F47nvVRx9IJUctClCAh+UZuC9B9Zjb/ZMGlgMKhZMhWlCMKr+93Ge
Kao06nVMSBwysTRMKmJRG6zIf9SGwq3tyH/EhuwHbUi/34ZEsinRZE9mE1pT
1xBipO6jl1sRtNSKkUusuLWY0KL4tpJm3LaoFoPi/maXhkldRDrT5qc7tPlx
Q1se1cVVibSpKAqWjfmwbCqU8dpsmFema4sIO7nOT3XCSFTH3UpxAKqSb8O/
4m/DC1MGuUqFJcLWSkwRIRTvC4WSXuMsFJ3YkX0PJ8YE4q8TQ3AgbDQ+iJ8s
LBavG48M9hPyOJYZhVd/swt1VZX4w2M79HZZJHeSRckv2rFsRzuKft6OPNLg
TFpHkkl7Y8mcRNAmK5zwYh/1DsLrdsIriHAKJFkEk/aGkPYGF9ZicLyzLIzu
aKu7ht7u2skTSSec639cgtM/WYb6HxWR9ucpmvdUWxCB2txw1MzXvKebyP4E
ojqZlC8lBJ8kBOP5KYMdIGtqL0G2q76fRHnSh7SMHJYo87Eto7zALFQ/IyMD
lmefEur/bnmZWBTY8PBCoan8MxNCUPHyK8JoqUs1e01mJ5j97BaWrfTKx9qx
epeEpPDRdmSTIUq/z4YEst7R69swi4zEVDIS41e0YiwtwaPJxwwhyEdTGEOQ
hSwyYUj8fibHK6qGdCfSKtLfc9fMBWk27g0PrkTDw6sZbW2HYCpJQO3iaNoJ
z6Jd8VRUzxuvaGXVqaNRmTqGgA7B81OHaEKfeJitbsgHEuiRzyhO6jzgOd4H
Q5nJQB+TZ+as0hJoTZ15v/XxCy/gTGYSWh5YhJa7Y9EQG4Yj99yNkyUFeH78
ZJw7dw4dVqsrzilO6swuyobftWPT7nasITCWbJdmIGuLNPiMcxStkLPLGedW
TCa1Hl/airBSeb4wdmkTQkgtVbBc1LkTbfsm2E07F5DZtWncvgGNOzYR0Gtg
O/C2zCdjbl6RpqIdRWjPFmjXZE0W5S2vP4/qjFBUpo3FJ4l2tC8A20mrfS4F
Ni+VxBRhTcP/cG4UWuvlTrf1vTdQGxIo0oxwI+3X+BiIEZe7YHdwz/9pGx76
Ywe2Pt+BzU9JyFm1F/+PDXkPy3U2nWBLIa8xbpMVsRTYxZ9JVmVqGUNPVqCg
BgNiXneCO+Rq0HYRiWXtfHz2m4dwdvdWnPnlZiEWYW3uXQzL3XkwswO0Kp22
bSkknjgKsWL7UJs/U5j5qnnjcTg+GHsmDuimSMLekjdJ0UfJ0BwnMCsp1AqR
8FGPFIlRGBtNBBzq42Mol4RA1Lkui5EC9zW/jt1OU6C4yPET5oufom02PPZy
Bx7f+4WAb+OT7Sh7vB0rftkujHHRz2lxJAgLttqEy8KuSyo5+fFkQiJoZkxa
2YyghTXoH7VPZS3tlCqRHiYtdVOVSP3mInz+7GNo2vO4kEzj9o1oeKQMp7es
EGuBhdaBelp36+8pkN7QWvaEUmFaFk+SicApcl8Pxwbhj+O0Hy9O+rALi2Rw
kYgu8hDzeJwrk1AYZHIp6YvEoGcZULL+3XfERJBy6EIaSZ0Ese6Jdmx7sQM7
/9yBLb9vx130zTa65Bc2FG+TSC0kTyWPzdPPaJe1pQ3JpM9zN0kdDlvejBE5
NRib8x5MjeekIPpfDdLi5rJK+aGg3bh1Hc4+tQ2fP7MTnz2+BQ1b78JpWiJO
kxDqNxcLIVg2LKSQB8tdNE3K5tE+IZmmyFwxPaoywnAoagRejRsL0+kv5BLL
Boklces+loSTIEY+IwUx+5/wiHcRBM8OJc/MYyus94RHUYNI8RVkAe3m8uq5
lIPebpkCHfOhlxBD8Y56nDSdRzkpKTuFGQ/IvVIMueV84EbmQocZ5fSatoZe
40pbFU+MpZ1r0OJWDMs9i/FLqnD4RDMTkvj7dIem0plo366IqvfEVSjebsYX
p06SypeTiufT7itD7ryKY8jluZOND5/lLJyhI/szTUcr8jgaajWtDFUJQTgZ
OQyH0sbj7LHDKH6wUieOnfUSWQm5pvw6cSFg0ACXtijtOFv3Sm7BkBbWa0AX
NVDNJWd0nOKzPipxgF/PDr5cF5LENbIexgUmFP+qAaYz59SbTi/xzflin0fB
bZ2dVGdejVyoCBFjqkSEddNe58FKGKcdcOgTMxe8V7O1/Z8Uv6oQuezMxX0k
buJVzgzOnDE3euaLcpc2Cw4ls/L6W4Yg3kwmMYuejiku/UN5b552SswaHf8Q
gH8SwP+0MpZ/0hF9lH+h8AnjxWswG30tkEnSacencryCOZIFj9fQaahiREvO
6KErbfKBfiVbIkqql9h8JU7ve/iqnlKLGqlDfUGDEJAut14EHriYGXoeuZ6H
7hi5In7DINGK5Z8g0cgVg3QaIj6ROA94TlxrKIr241seKqssA6vBSB2LYa20
Qr/qC74EhVJ+nodXxoJTv0WspamE09xpOV+jc77nmq/4FlVJ5NJAvmPiy9Yy
eeOkNjKI+j7i9wh8ZyWgKGoSZ/x87Cl+acCxuPfnQ0xv+e0QrPPvHHgXz/iw
ackRJzusgMx8+ElF5Vyn+r08WxhTzyWtgl05fN+NtNT88H56+T/E25PArcDt
20SgUnrrEboTm2SKCkWejlN6jNiitaC2anv5phJ7nqBs5D70sjevVeeFNraI
nQsPTh2p+iMvGij/voGGSWhyE0WMkMBkstxd6KPgUekwdTu9wn8JH8x8DEGc
CrSnjJwivinJ9ZxjEgClPJmOTnBh4G74MlyqfOj7crPg+GOiuI8Efjw0oWfi
NzTkgQoPgPdd0tjbY7uV4QU2R1gbce5WL47bAvmcMpC3swbtuIfvMtUTOb0q
0BSR5PMMPuWKEzNBbJjE7ZvIa5DpODGho2r53kxs981qaJD3HjMPG9VZ4PH/
+G2kTw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Menu", "Ex--21907299533234115765,85"},
 CellLabel->"Out[3]=",
 CellID->13122263]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11410],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DockedCells",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DockedCells"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28463]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24417],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"MenuBar\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 37.7265276}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"MenuBar\"Widget[\"MenuBar\"] represents a menu bar.", 
    "synonyms" -> {"menu bar"}, "title" -> "MenuBar", "type" -> "Widget", 
    "uri" -> "GUIKit/widget/MenuBar"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2327, 78, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "Menu"->{
  Cell[2986, 104, 2894, 65, 70, "Input",
   CellTags->{"Menu", "Ex--21907299533234115765,84"},
   CellID->28599],
  Cell[5905, 173, 159, 4, 70, "Input",
   CellTags->{"Menu", "Ex--21907299533234115765,85"},
   CellID->14643],
  Cell[6067, 179, 8446, 143, 70, "Output",
   Evaluatable->False,
   CellTags->{"Menu", "Ex--21907299533234115765,85"},
   CellID->13122263]},
 "Ex--21907299533234115765,84"->{
  Cell[2986, 104, 2894, 65, 70, "Input",
   CellTags->{"Menu", "Ex--21907299533234115765,84"},
   CellID->28599]},
 "Ex--21907299533234115765,85"->{
  Cell[5905, 173, 159, 4, 70, "Input",
   CellTags->{"Menu", "Ex--21907299533234115765,85"},
   CellID->14643],
  Cell[6067, 179, 8446, 143, 70, "Output",
   Evaluatable->False,
   CellTags->{"Menu", "Ex--21907299533234115765,85"},
   CellID->13122263]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17032, 411},
 {"Menu", 17154, 415},
 {"Ex--21907299533234115765,84", 17557, 426},
 {"Ex--21907299533234115765,85", 17706, 430}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1252, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1875, 59, 48, 1, 70, "ObjectName",
 CellID->5984],
Cell[1926, 62, 364, 11, 70, "Usage",
 CellID->27110]
}, Open  ]],
Cell[CellGroupData[{
Cell[2327, 78, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2704, 92, 148, 5, 70, "ExampleSection",
 CellID->197069973],
Cell[2855, 99, 128, 3, 70, "Input",
 CellID->52614173],
Cell[2986, 104, 2894, 65, 70, "Input",
 CellTags->{"Menu", "Ex--21907299533234115765,84"},
 CellID->28599],
Cell[CellGroupData[{
Cell[5905, 173, 159, 4, 70, "Input",
 CellTags->{"Menu", "Ex--21907299533234115765,85"},
 CellID->14643],
Cell[6067, 179, 8446, 143, 70, "Output",
 Evaluatable->False,
 CellTags->{"Menu", "Ex--21907299533234115765,85"},
 CellID->13122263]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14574, 329, 311, 9, 70, "SeeAlsoSection",
 CellID->11410],
Cell[14888, 340, 460, 17, 70, "SeeAlso",
 CellID->28463]
}, Open  ]],
Cell[CellGroupData[{
Cell[15385, 362, 314, 9, 70, "TutorialsSection",
 CellID->24417],
Cell[15702, 373, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[15986, 385, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

