(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19294,        489]
NotebookOptionsPosition[     15983,        386]
NotebookOutlinePosition[     18161,        448]
CellTagsIndexPosition[     17961,        440]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "DockedCells" :> 
          Documentation`HelpLookup["paclet:ref/DockedCells"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"DockedCells\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"MenuItem\"", "ObjectName",
 CellID->25532],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<MenuItem\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a menu item."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3083]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->374410581],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->111557418],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", "  ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{
     StyleBox["Widget", "Output"], "[", 
     RowBox[{"\"\<Frame\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\"\<menus\>\"", "\[Rule]", "\[IndentingNewLine]", 
         RowBox[{
          StyleBox["Widget", "Output"], "[", 
          RowBox[{"\"\<MenuBar\>\"", ",", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              StyleBox["Widget", "Output"], "[", 
              RowBox[{"\"\<Menu\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Menu A\>\""}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", 
                  RowBox[{"\"\<MenuItem\>\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "->", "\"\< Item A-1\>\""}], 
                    "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", 
                  RowBox[{"\"\<MenuItem\>\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "->", "\"\< Item A-2\>\""}], 
                    "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", "\"\<MenuSeparator\>\"", 
                  "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", 
                  RowBox[{"\"\<MenuItem\>\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "->", "\"\< Item A-3\>\""}], 
                    "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], "]"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{
              StyleBox["Widget", "Output"], "[", 
              RowBox[{"\"\<Menu\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Menu B\>\""}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox["Widget", "Output"], "[", 
                  RowBox[{"\"\<MenuItem\>\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "->", "\"\< Item B-1\>\""}], 
                    "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], "]"}]}],
             "\[IndentingNewLine]", "}"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         StyleBox["Widget", "Output"], "[", "\"\<TextArea\>\"", "]"}]}], 
       "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->{"Menu", "Ex--21907299533234115765,87"},
 CellLabel->"In[2]:=",
 CellID->7849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Menu", "Ex--21907299533234115765,88"},
 CellLabel->"In[3]:=",
 CellID->19205],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{166, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Menu", "Ex--21907299533234115765,88"},
 CellLabel->"Out[3]=",
 CellID->169324058]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12238],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DockedCells",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DockedCells"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5241]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29719],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"MenuItem\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 38.7264764}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"MenuItem\"Widget[\"MenuItem\"] represents a menu item.", 
    "synonyms" -> {"menu item"}, "title" -> "MenuItem", "type" -> "Widget", 
    "uri" -> "GUIKit/widget/MenuItem"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2330, 78, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "Menu"->{
  Cell[2990, 104, 2893, 65, 70, "Input",
   CellTags->{"Menu", "Ex--21907299533234115765,87"},
   CellID->7849],
  Cell[5908, 173, 159, 4, 70, "Input",
   CellTags->{"Menu", "Ex--21907299533234115765,88"},
   CellID->19205],
  Cell[6070, 179, 8414, 142, 70, "Output",
   Evaluatable->False,
   CellTags->{"Menu", "Ex--21907299533234115765,88"},
   CellID->169324058]},
 "Ex--21907299533234115765,87"->{
  Cell[2990, 104, 2893, 65, 70, "Input",
   CellTags->{"Menu", "Ex--21907299533234115765,87"},
   CellID->7849]},
 "Ex--21907299533234115765,88"->{
  Cell[5908, 173, 159, 4, 70, "Input",
   CellTags->{"Menu", "Ex--21907299533234115765,88"},
   CellID->19205],
  Cell[6070, 179, 8414, 142, 70, "Output",
   Evaluatable->False,
   CellTags->{"Menu", "Ex--21907299533234115765,88"},
   CellID->169324058]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17009, 410},
 {"Menu", 17131, 414},
 {"Ex--21907299533234115765,87", 17534, 425},
 {"Ex--21907299533234115765,88", 17682, 429}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1252, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1875, 59, 50, 1, 70, "ObjectName",
 CellID->25532],
Cell[1928, 62, 365, 11, 70, "Usage",
 CellID->3083]
}, Open  ]],
Cell[CellGroupData[{
Cell[2330, 78, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2707, 92, 148, 5, 70, "ExampleSection",
 CellID->374410581],
Cell[2858, 99, 129, 3, 70, "Input",
 CellID->111557418],
Cell[2990, 104, 2893, 65, 70, "Input",
 CellTags->{"Menu", "Ex--21907299533234115765,87"},
 CellID->7849],
Cell[CellGroupData[{
Cell[5908, 173, 159, 4, 70, "Input",
 CellTags->{"Menu", "Ex--21907299533234115765,88"},
 CellID->19205],
Cell[6070, 179, 8414, 142, 70, "Output",
 Evaluatable->False,
 CellTags->{"Menu", "Ex--21907299533234115765,88"},
 CellID->169324058]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14545, 328, 311, 9, 70, "SeeAlsoSection",
 CellID->12238],
Cell[14859, 339, 459, 17, 70, "SeeAlso",
 CellID->5241]
}, Open  ]],
Cell[CellGroupData[{
Cell[15355, 361, 314, 9, 70, "TutorialsSection",
 CellID->29719],
Cell[15672, 372, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[15956, 384, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

