(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18248,        494]
NotebookOptionsPosition[     14414,        377]
NotebookOutlinePosition[     16711,        440]
CellTagsIndexPosition[     16502,        432]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "InputField" :> 
          Documentation`HelpLookup["paclet:ref/InputField"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"InputField\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"PasswordField\"", "ObjectName",
 CellID->20267],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<PasswordField\>\"", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]represents a password field."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12341]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following properties are available:", "Notes",
 CellID->617],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", "\"\<\>\"", Cell[
    "text content", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"enabled\", \"TI\"]\)\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the password field is enabled", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->24968],

Cell["The following event is available: ", "Notes",
 CellID->25065],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"action\", \"TI\"]\)\>\"", Cell[TextData[{
     "the event triggered when ",
     StyleBox["Return", "KeyEvent"],
     " is pressed"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->27321]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->362048836],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->717763104],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->192884334],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<PasswordField\>\"", ",", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<text\>\"", "->", "\"\<Should not see\>\""}], "}"}]}], 
     "]"}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"PasswordField", "Ex--21907299533234115765,93"},
 CellLabel->"In[2]:=",
 CellID->28592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"PasswordField", "Ex--21907299533234115765,94"},
 CellLabel->"In[3]:=",
 CellID->25135],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"PasswordField", "Ex--21907299533234115765,94"},
 CellLabel->"Out[3]=",
 CellID->41438489]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2137],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputField"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6932]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18655],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"PasswordField\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 41.8669406}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "\"PasswordField\"Widget[\"PasswordField\"] represents a password field.",
     "synonyms" -> {"password field"}, "title" -> "PasswordField", "type" -> 
    "Widget", "uri" -> "GUIKit/widget/PasswordField"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4101, 138, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->362048836]},
 "PasswordField"->{
  Cell[4769, 164, 439, 11, 70, "Input",
   CellTags->{"PasswordField", "Ex--21907299533234115765,93"},
   CellID->28592],
  Cell[5233, 179, 168, 4, 70, "Input",
   CellTags->{"PasswordField", "Ex--21907299533234115765,94"},
   CellID->25135],
  Cell[5404, 185, 7514, 127, 70, "Output",
   Evaluatable->False,
   CellTags->{"PasswordField", "Ex--21907299533234115765,94"},
   CellID->41438489]},
 "Ex--21907299533234115765,93"->{
  Cell[4769, 164, 439, 11, 70, "Input",
   CellTags->{"PasswordField", "Ex--21907299533234115765,93"},
   CellID->28592]},
 "Ex--21907299533234115765,94"->{
  Cell[5233, 179, 168, 4, 70, "Input",
   CellTags->{"PasswordField", "Ex--21907299533234115765,94"},
   CellID->25135],
  Cell[5404, 185, 7514, 127, 70, "Output",
   Evaluatable->False,
   CellTags->{"PasswordField", "Ex--21907299533234115765,94"},
   CellID->41438489]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15480, 402},
 {"PasswordField", 15620, 406},
 {"Ex--21907299533234115765,93", 16049, 417},
 {"Ex--21907299533234115765,94", 16206, 421}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1249, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1872, 59, 55, 1, 70, "ObjectName",
 CellID->20267],
Cell[1930, 62, 383, 12, 70, "Usage",
 CellID->12341]
}, Open  ]],
Cell[CellGroupData[{
Cell[2350, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2828, 96, 70, 1, 70, "Notes",
 CellID->617],
Cell[2901, 99, 630, 16, 70, "3ColumnTableMod",
 CellID->24968],
Cell[3534, 117, 67, 1, 70, "Notes",
 CellID->25065],
Cell[3604, 120, 460, 13, 70, "2ColumnTableMod",
 CellID->27321]
}, Closed]],
Cell[CellGroupData[{
Cell[4101, 138, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->362048836],
Cell[CellGroupData[{
Cell[4486, 152, 148, 5, 70, "ExampleSection",
 CellID->717763104],
Cell[4637, 159, 129, 3, 70, "Input",
 CellID->192884334],
Cell[4769, 164, 439, 11, 70, "Input",
 CellTags->{"PasswordField", "Ex--21907299533234115765,93"},
 CellID->28592],
Cell[CellGroupData[{
Cell[5233, 179, 168, 4, 70, "Input",
 CellTags->{"PasswordField", "Ex--21907299533234115765,94"},
 CellID->25135],
Cell[5404, 185, 7514, 127, 70, "Output",
 Evaluatable->False,
 CellTags->{"PasswordField", "Ex--21907299533234115765,94"},
 CellID->41438489]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12979, 319, 310, 9, 70, "SeeAlsoSection",
 CellID->2137],
Cell[13292, 330, 457, 17, 70, "SeeAlso",
 CellID->6932]
}, Open  ]],
Cell[CellGroupData[{
Cell[13786, 352, 314, 9, 70, "TutorialsSection",
 CellID->18655],
Cell[14103, 363, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[14387, 375, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

