(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21085,        533]
NotebookOptionsPosition[     17704,        429]
NotebookOutlinePosition[     19936,        492]
CellTagsIndexPosition[     19731,        484]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "PopupMenu" :> 
          Documentation`HelpLookup["paclet:ref/PopupMenu"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"PopupMenu\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"PopupMenu\"", "ObjectName",
 CellID->20552],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<PopupMenu\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a popup menu."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26830]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->93086819],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->689294683],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", "  ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{
     StyleBox["Widget", "Output"], "[", 
     RowBox[{"\"\<Frame\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         StyleBox["Widget", "Output"], "[", 
         RowBox[{"\"\<TextArea\>\"", ",", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\"\<columns\>\"", "\[Rule]", "30"}], ",", " ", 
            RowBox[{"\"\<rows\>\"", "\[Rule]", "5"}]}], "}"}], ",", " ", 
          RowBox[{"Name", "->", "\"\<messageArea\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         StyleBox["Widget", "Output"], "[", 
         RowBox[{"\"\<PopupMenu\>\"", ",", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             StyleBox["Widget", "Output"], "[", 
             RowBox[{"\"\<MenuItem\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<Item 1\>\""}], "}"}]}], 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             StyleBox["Widget", "Output"], "[", 
             RowBox[{"\"\<MenuItem\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<Item 2\>\""}], "}"}]}], 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             StyleBox["Widget", "Output"], "[", "\"\<MenuSeparator\>\"", 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             StyleBox["Widget", "Output"], "[", 
             RowBox[{"\"\<MenuItem\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<Item 3\>\""}], "}"}]}], 
             "]"}]}], "\[IndentingNewLine]", "}"}], ",", 
          RowBox[{"Name", "\[Rule]", "\"\<popupMenu\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"BindEvent", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<messageArea\>\"", ",", "\"\<mousePressed\>\""}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Script", "[", " ", "\[IndentingNewLine]", " ", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"TrueQ", "[", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"{", 
                 RowBox[{"\"\<#\>\"", ",", "\"\<popupTrigger\>\""}], "}"}], 
                "]"}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"InvokeMethod", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"\"\<popupMenu\>\"", ",", "\"\<show\>\""}], "}"}], 
                ",", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"\"\<#\>\"", ",", "\"\<component\>\""}], "}"}], 
                 "]"}], ",", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"\"\<#\>\"", ",", "\"\<x\>\""}], "}"}], "]"}], ",", 
                
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"\"\<#\>\"", ",", "\"\<y\>\""}], "}"}], "]"}]}], 
               "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", "]"}]}], "]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"BindEvent", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<messageArea\>\"", ",", "\"\<mouseReleased\>\""}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Script", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"TrueQ", "[", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"{", 
                 RowBox[{"\"\<#\>\"", ",", "\"\<popupTrigger\>\""}], "}"}], 
                "]"}], "]"}], ",", 
              RowBox[{"InvokeMethod", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"\"\<popupMenu\>\"", ",", "\"\<show\>\""}], "}"}], 
                ",", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"\"\<#\>\"", ",", "\"\<component\>\""}], "}"}], 
                 "]"}], ",", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"\"\<#\>\"", ",", "\"\<x\>\""}], "}"}], "]"}], ",", 
                
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"\"\<#\>\"", ",", "\"\<y\>\""}], "}"}], "]"}]}], 
               "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", "]"}]}], "]"}]}],
        "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}], "]"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"PopupMenu", "Ex--21907299533234115765,96"},
 CellLabel->"In[2]:=",
 CellID->6923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"PopupMenu", "Ex--21907299533234115765,97"},
 CellLabel->"In[3]:=",
 CellID->17399],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{218, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"PopupMenu", "Ex--21907299533234115765,97"},
 CellLabel->"Out[3]=",
 CellID->114121433]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2900],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupMenu"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29700]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20474],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"PopupMenu\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 42.9762588}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "\"PopupMenu\"Widget[\"PopupMenu\"] represents a popup menu.", 
    "synonyms" -> {"popup menu"}, "title" -> "PopupMenu", "type" -> "Widget", 
    "uri" -> "GUIKit/widget/PopupMenu"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2328, 78, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "PopupMenu"->{
  Cell[2987, 104, 4916, 113, 70, "Input",
   CellTags->{"PopupMenu", "Ex--21907299533234115765,96"},
   CellID->6923],
  Cell[7928, 221, 164, 4, 70, "Input",
   CellTags->{"PopupMenu", "Ex--21907299533234115765,97"},
   CellID->17399],
  Cell[8095, 227, 8114, 137, 70, "Output",
   Evaluatable->False,
   CellTags->{"PopupMenu", "Ex--21907299533234115765,97"},
   CellID->114121433]},
 "Ex--21907299533234115765,96"->{
  Cell[2987, 104, 4916, 113, 70, "Input",
   CellTags->{"PopupMenu", "Ex--21907299533234115765,96"},
   CellID->6923]},
 "Ex--21907299533234115765,97"->{
  Cell[7928, 221, 164, 4, 70, "Input",
   CellTags->{"PopupMenu", "Ex--21907299533234115765,97"},
   CellID->17399],
  Cell[8095, 227, 8114, 137, 70, "Output",
   Evaluatable->False,
   CellTags->{"PopupMenu", "Ex--21907299533234115765,97"},
   CellID->114121433]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18742, 454},
 {"PopupMenu", 18869, 458},
 {"Ex--21907299533234115765,96", 19288, 469},
 {"Ex--21907299533234115765,97", 19442, 473}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1246, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1869, 59, 51, 1, 70, "ObjectName",
 CellID->20552],
Cell[1923, 62, 368, 11, 70, "Usage",
 CellID->26830]
}, Open  ]],
Cell[CellGroupData[{
Cell[2328, 78, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2705, 92, 147, 5, 70, "ExampleSection",
 CellID->93086819],
Cell[2855, 99, 129, 3, 70, "Input",
 CellID->689294683],
Cell[2987, 104, 4916, 113, 70, "Input",
 CellTags->{"PopupMenu", "Ex--21907299533234115765,96"},
 CellID->6923],
Cell[CellGroupData[{
Cell[7928, 221, 164, 4, 70, "Input",
 CellTags->{"PopupMenu", "Ex--21907299533234115765,97"},
 CellID->17399],
Cell[8095, 227, 8114, 137, 70, "Output",
 Evaluatable->False,
 CellTags->{"PopupMenu", "Ex--21907299533234115765,97"},
 CellID->114121433]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16270, 371, 310, 9, 70, "SeeAlsoSection",
 CellID->2900],
Cell[16583, 382, 456, 17, 70, "SeeAlso",
 CellID->29700]
}, Open  ]],
Cell[CellGroupData[{
Cell[17076, 404, 314, 9, 70, "TutorialsSection",
 CellID->20474],
Cell[17393, 415, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[17677, 427, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

