(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18545,        496]
NotebookOptionsPosition[     14844,        380]
NotebookOutlinePosition[     17026,        442]
CellTagsIndexPosition[     16822,        434]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "Slider" :> 
          Documentation`HelpLookup["paclet:ref/Slider"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"Slider\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"Slider\"", "ObjectName",
 CellID->21797],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<Slider\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a slider."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12066]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following properties are available:", "Notes",
 CellID->6460],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"value\", \"TI\"]\)\>\"", "50", Cell[
    "the current value of the slider (an integer)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"minimum\", \"TI\"]\)\>\"", "0", Cell[
    "the minimum value of the slider (an integer)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"maximum\", \"TI\"]\)\>\"", "100", Cell[
    "the maximum value of the slider (an integer)", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->20391],

Cell["The following event is available: ", "Notes",
 CellID->30573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"change\", \"TI\"]\)\>\"", Cell[TextData[{
     "the event ",
     StyleBox["triggered when the slider position moves", "Text"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->25465]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68401138],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->629101662],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->458600619],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", "\"\<Slider\>\"", "]"}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellTags->{"Slider", "Ex--21907299533234115765,108"},
 CellLabel->"In[2]:=",
 CellID->19323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Slider", "Ex--21907299533234115765,109"},
 CellLabel->"In[3]:=",
 CellID->3569],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Slider", "Ex--21907299533234115765,109"},
 CellLabel->"Out[3]=",
 CellID->30043596]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27518],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28262]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26605],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"Slider\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 45.2886404}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"Slider\"Widget[\"Slider\"] represents a slider.", 
    "synonyms" -> {}, "title" -> "Slider", "type" -> "Widget", "uri" -> 
    "GUIKit/widget/Slider"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4189, 136, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->68401138]},
 "Slider"->{
  Cell[4856, 162, 301, 8, 70, "Input",
   CellTags->{"Slider", "Ex--21907299533234115765,108"},
   CellID->19323],
  Cell[5182, 174, 161, 4, 70, "Input",
   CellTags->{"Slider", "Ex--21907299533234115765,109"},
   CellID->3569],
  Cell[5346, 180, 8008, 135, 70, "Output",
   Evaluatable->False,
   CellTags->{"Slider", "Ex--21907299533234115765,109"},
   CellID->30043596]},
 "Ex--21907299533234115765,108"->{
  Cell[4856, 162, 301, 8, 70, "Input",
   CellTags->{"Slider", "Ex--21907299533234115765,108"},
   CellID->19323]},
 "Ex--21907299533234115765,109"->{
  Cell[5182, 174, 161, 4, 70, "Input",
   CellTags->{"Slider", "Ex--21907299533234115765,109"},
   CellID->3569],
  Cell[5346, 180, 8008, 135, 70, "Output",
   Evaluatable->False,
   CellTags->{"Slider", "Ex--21907299533234115765,109"},
   CellID->30043596]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15846, 404},
 {"Slider", 15978, 408},
 {"Ex--21907299533234115765,108", 16388, 419},
 {"Ex--21907299533234115765,109", 16539, 423}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1237, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1860, 59, 48, 1, 70, "ObjectName",
 CellID->21797],
Cell[1911, 62, 361, 11, 70, "Usage",
 CellID->12066]
}, Open  ]],
Cell[CellGroupData[{
Cell[2309, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2787, 95, 71, 1, 70, "Notes",
 CellID->6460],
Cell[2861, 98, 763, 16, 70, "3ColumnTableMod",
 CellID->20391],
Cell[3627, 116, 67, 1, 70, "Notes",
 CellID->30573],
Cell[3697, 119, 455, 12, 70, "2ColumnTableMod",
 CellID->25465]
}, Closed]],
Cell[CellGroupData[{
Cell[4189, 136, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68401138],
Cell[CellGroupData[{
Cell[4573, 150, 148, 5, 70, "ExampleSection",
 CellID->629101662],
Cell[4724, 157, 129, 3, 70, "Input",
 CellID->458600619],
Cell[4856, 162, 301, 8, 70, "Input",
 CellTags->{"Slider", "Ex--21907299533234115765,108"},
 CellID->19323],
Cell[CellGroupData[{
Cell[5182, 174, 161, 4, 70, "Input",
 CellTags->{"Slider", "Ex--21907299533234115765,109"},
 CellID->3569],
Cell[5346, 180, 8008, 135, 70, "Output",
 Evaluatable->False,
 CellTags->{"Slider", "Ex--21907299533234115765,109"},
 CellID->30043596]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13415, 322, 311, 9, 70, "SeeAlsoSection",
 CellID->27518],
Cell[13729, 333, 450, 17, 70, "SeeAlso",
 CellID->28262]
}, Open  ]],
Cell[CellGroupData[{
Cell[14216, 355, 314, 9, 70, "TutorialsSection",
 CellID->26605],
Cell[14533, 366, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[14817, 378, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

