(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30102,        721]
NotebookOptionsPosition[     24677,        567]
NotebookOutlinePosition[     28122,        655]
CellTagsIndexPosition[     27856,        646]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], 
          "SystemInformation" :> 
          Documentation`HelpLookup["paclet:ref/SystemInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"SystemInformation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"SystemPropertiesPanel\"", "ObjectName",
 CellID->13912],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<SystemPropertiesPanel\>\"", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]displays the current system property values of the \
underlying runtime engine."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17723]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<SystemPropertiesPanel\>\"", "]"}]], 
  "InlineFormula"],
 " is a useful panel for displaying all the current system property values of \
the underlying runtime engine. This panel supports copying table values (with \
the optional alternate mouse popdown menu) for pasting into other \
applications, as well as extracting them into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session with its ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"items\", \"TI\"]\)\>\""], "InlineFormula"],
 " property value."
}], "Notes",
 CellTags->"SystemPropertiesPanel",
 CellID->5714],

Cell["The following property is available:", "Notes",
 CellID->5371],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"items\", \"TI\"]\)\>\"", Cell[TextData[StyleBox[
    "current system properties", "TableText"]], "TableText"], Cell[TextData[
    StyleBox["system property settings of the current runtime engine", 
     "TableText"]], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->16808]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->97873867],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->28115882],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->15897234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<SystemPropertiesPanel\>\"", ",", " ", 
     RowBox[{"Name", "->", "\"\<systemPanel\>\""}]}], "]"}], " ", 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,116"},
 CellLabel->"In[2]:=",
 CellID->26392],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject115901286318081, 
   JLink`Objects`JavaObject206031007252481]]], "Output",
 CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,116"},
 CellLabel->"Out[2]=",
 CellID->13531]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,117"},
 CellLabel->"In[3]:=",
 CellID->10204],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztfQd8FEey92iDhODABJsDgwkmGgsfwiSDRTAZIUwSwWQwEhkTnDgczjbP
5/SdfeaeP/t8Bzzz7LOPaJuM+cgWSQhEEOkQyiIapZWQRH1VPWF3Z3tmZ1e7
YgXa329mZ3qma6r+VV1dXd2zGzVl8Yzpc6csnjltSpP+C6e8NGPmtEVN+s1f
iEXmIEEIWoibtYlAxyAIys4MwsNfglDnY9oEoP1L7FAQLCDUXQdCo5XStqoO
HVSlo9p0hKePrQylo1D5aFVV5Ui5IB7Vkao9RrdIF2orREMVoox8C+e6dLqK
2GFsfENnIDT4e5DEpxWE+sehSvg5qN7/PNQceRmqDjwnhIKlVxJW736pIQgR
F+noIhKPuFRbOo24VJXK2C1yWXcqk47olot1XGpIpEKVCxpEI0QC9mp0yyWS
IuIiCJ0TQAjbSdK4SlF7eDrUnXUTqkRfQilCnr+KWhlwewrtSF1Uve0uwlkI
smtKqivVA7ienTSbdlRjwG2xlm9rmOhmoE8s7Uxe1P3fb76IoZ0QzOhQGW0O
JPQp4OOwtlxXYPup7DDE8YKaqBu+/ETV4lIZ3vrHtkm0M5WdutWlMtIVPqEC
lOftt98G6SNsZ/tQVnYqIQ5u3M6FH3ZfgeUbz8Gfv0uCd1cnwhsrT8GbK04K
Jli6ItFMp/iAd1afgeUbLsH1HBus2HSSPcAt5418zrlZ4XzfqUyhulS2bn/6
vWQqWGGKPhdSC2HLwduw9VCOGbYdyhWq0iH8FJfPth/j8mDjwVzYsD8HzqUW
sCrrdp8xZAn+Zv2H3bmw5UgRbIsvNsHO+DtCNdgRj6fHi2HzsWL4EbcNeHnt
oSJYF2eDDQdyWLWVmxL9Cz0Ql4NphwzLzK7Zmw/bj5XAroQS2HMSGd51ogSx
/iWxGLYklsDmE8gwMr7+aDFjeOOBXFZNspN7gHWIE9Zr9xUw1vcir/sSSxG8
vaeJ/6gpy2D7qRImw08nSmB9fDGsO3wHNsaVD/9hVGChAGGCpiRWJ0k2/lpA
UuCdB86UmEkAMyGPd208cofZvAPf/jOSdhK7FNnI7L6gKYLFSYSf4wqQ+9Ml
VuLeBJvjiftNx+7ApkO5ZeQ+pL0h7s0SsA7ci+wyQvhhgpkk3h3vUoqdRWdl
Jnt95aKnZFwpKISD1YS1HiB9m+zXjEnKEUnzqtkdcXUlKjMbFNkdaBrFroyQ
D+M/VEOidRJ9R3PdcjjfBHFnilljQ5+xB30e+Q15Q/tlDnvbEdF6JQeta7zd
KdJY5XvjFa+F8K6pNOOCobZyrE4knMm4x7UsNu1sPiFuBeeZW6geGAbq8yQ0
ALCn0FWVhHNwnsr9wTqCr3WoJ1vs1iMFcCiJ+gjmYNFgEQUyU0ez3YYmu/1I
HqtgKKYoi82qYeOpwDC0WrbrVVWLgapq8trcOxtQMKeM73pcy0S+gtXsOkvs
G3vl0dJA63fs21srdY7Jfom3wbELJXDsfAnzrCZmsxYMgkuZcdLG7BcPsHjn
UdG9rt7qX/fqZ1NlerV45VeNaJEfBfA0rGmcVjs5+aJ4pknqPjDGXQmFkHCp
BOIvlcLhc6XIAPb4uCdjpHEP2aCJjhws8V87TvnIEl0rI12V+PpuRB86To8s
XgjW0oW6+3KkadGiqTIa4y3JmWerqp6KNU1rV8h50uVrkNAK77Vxt6oJaeJS
TbrfF3a7/5QNTl0pgRPJpeRMJSeK1nu6mA140X6xjPZWyjEotrtx72lf9fj6
xqsXrWoPMcSrirE5lrur5Ko9i6I9V2o83WnREsVRGoB3MmldVc54ozmlUZTJ
4HmPVNui4/3ubbGOky0eTiqC8xl3ISkV7fE/pRB/gflSskga7sOBRDEBQ3a5
E4f724+K0ecvR877N/qspcJOEqIFBw+ebxsolTnmNZg5eQpQwuUSuHL1LgNJ
brSs05GAiksqpqwOA4ka6zYpH3L87CUvATKYzamlI8jjKkR4PQCVNeAg11Zl
XY502WjOYdDtDFXGzRIGF9nU/pM22J1gYwHjjmP5bHiDg3LYFGeDn37Nh/UH
8uBiRhGrdznlyr3PlpeW3hFqsDIxgUr+UKYh0XSZw/E9P9UUfnJvX4c82nJv
Qn7eLSjI/w1stlwoKsyDoiIbFBcXImDFxUXIL/IOd+8WK5vE/z3As5L/8uDf
Idtf1SizlVir+6HwJF9l+8tZEpce1ZgknqX/K4ZMlZMCPEl9OinQTLrGiwd4
kZfZHqJzLvwvO6z4xlWZtHcZTPs2ad9U4sHTAbfeOG81O6gYxleZfde6Tzxz
LfNR9t1bw6vCofU/bF9pcMKDnUO//02qMhnuWBZ4yXBvLTBYgTIwA7fKPLYn
MmldVc408tjNpWd6mnAOWP/lUYq1fHPQgRS/dr/k/drqe5ueDlaORL9lX8VL
67mXrz8nruNecSqElnDj5TdXnYZlq08rK7j9DY+RlPRXmy4qC7h/2Jsm8+Rm
SsEvTGku4LbQhIeJjpAhWsmqXrm9ef/Ze8W086yrtMAKDiexSRtk6ODpUqEq
LS1mywNp255QAlvElQPKOisjy4n9w7/zArGf4wpoRk5g6xpNNOeEzNMU3V5p
207roY+X8Fbl+o157rpzmudBHtnUGOP14BkG9OlSNktG2/YTJS5rML3mNaRi
GQonqvFw3fnvJUkc/eKjylW5e6qocvLy1A9zyhpxyuSe5Z42Jm8Ff9CS2Tpj
do1HugVAl1U+Oc1UtVl1iyGsLNJeFZ7YQ3eLVngu1+RhsoIVODdflZcVfO1m
/WHF93XW3KrU0xx9aScZjI0C3TLMI1329Zx0Jgaizoat3TTUoxhX6pp52pUS
g3q2HgwfbyjEfXnb9oOZlDeezuLV4+VIPKfFSyXoeZqHpDscUhZcfspsqMFa
MVUw3My7i5LqhFDuB0UBaqgBk8y3qtTnwoOF4xbtOTmL1i38DlpwTVOAF3Zo
Dyx4sw0a0htgcKXEh2agK7tN/wW2lfMALtbpZgm6+2Xpzk8w/Bqbv0MBZ5sO
0aQfrAWbZqPmOVaHCEBxrNrBrRvHyl8OVrlEXiLrWElwGQe5HYPZb9UbdgVz
qNaUODNmWHrSOXMGkpNfwa75MbQ0ZFh+mWt4hFMWLt3tq5BdXwkOpISv2YEf
Q6MyA122iQleAo6HNujkGPSMWE8XPFfwd+l+//T8ZQDb6IyCxKzIqmQc2hk4
/xmH0RyxX5MvlfxXWP658yGqRLsv8+wRl/yBdTnlyv3DfPkZSnnwr3r9DPk/
kUz8y6+gya+hqV8/O3jiol/518u2c2NF48GD+7jWfUKUE+ZI0ewIg8CrXmbD
p+xOsNGvZ0kvtMkvtalfZsvMTPUR8AbG0kYzA9oZNZ0RjFHiHt08UhP+MryK
5wM4tSM0l0BZnUYUYdTAxYtUp9EybSjLcXWV36CXL/BW5fKW8LI7jKTyFJ2W
yVrLF2L3Sx48g1i/TOM99jKsZzX0lAdJAcqZdjepdGoGs0w6o0XNu2TbN+v3
jIGGNT8k6cLBeHgFl6kNR6Zq96GcAfGWcCX/gfge8APB/z15o/8BxZrHf1/a
s4hkQQWXRH7pwLF3mFeBZPJJYqEKL8px/HY7f2V/I1A7gnKo6HDXIJVSBM6Q
UTDMgtvHaU60yQUOtAzMHbudvNNTzWxWGGh25uc8ijgY1VwlxFue4HBZdzKu
7LkDOusvlRkzyDK9P61V5gZkI3Iam5hUPczrVZIz2D7Q3lLzawrLzevzbqzD
u5+McC6LksocuzO7C3a//tpu2PoG5XbRGLeFG3sn19u1kjzl3T9GKF/gJfNE
xNzYnZV3WSx1v97cveUx0xIjJ6PLJdzyZaA7YYal+UKAJ2Znp+RFLwb3ia3p
l2lkNfkaFPuJEMfbXTD3wN96nBzl9eAhvHdenesZZ9srXuxlms3V/oMBellJ
H8UN958JK2f6eWGHFcSG37+SPm5GNzqr/8SBjQErNDDQAY9S1+o3sXh+0tDP
YPCoBfyAxuCruI9y5H3JgMrUKwy11PjnCoeFixueL4nl/IMMrrDx3jatzinT
zELwmvXbFQi/gE3xVSD+2avqlfxXSP7LOx3/IGPtyL8c3vHe9ltfQWVih/gJ
5ci0rgLJ5JPEvPuxjhc/V8AIjONA7tHwQS+P8G1568kHQwsfJbZ9/LdpWmof
I6HP+4kx+0P4w6X7S28+SeN6+39NmuP6iTr6cZMSMPLaeXn/uqD/FCVf0E51
un1b2XhLYverf8PdmZp2A7z/NaJfxk8IluEfowytVtdzdB6lxdyU0dn/3Ac6
VM6MrJTUyV5pY8bPTGnGE4bn0/U6pnL/JceKPpj2If+Ef0Xmv6LjX8l/Jf8B
nYx5gLFuTQWsQ6yhHD1fwWUKk/h3jCge4pQNruBy+iFBo0lSb/hjeM2gFysM
eT+p7Xax5IaAVGK5ZG+8nE7X1b2Xxe4zcP1UyjU6JKKzcs+kBkqmx7sFmb4u
U/tOQdBfZlcRm6S3+R611rxv0zwOPPr1ugEcNRl9Z/Z+aGH6ZRorxAzdWuYX
48u8/EnbexpaGnM/qFc5M5Ir0lzKwU8ieRAFGVtb5CaUceFiY0AqyNO1SBU3
vL4fZarow9VK/iv5r0wtVQysefy/THvW01XleFfeT3+2qeASv86RibfaiSf7
ExVI9nJaLcQNmKQKmgvAx0n3q1ZF6zPDxnf2F2oNLCJ3w5nD4/R/vNp+t/3l
Ck/Scc5DB/tPnqs04P0rL9pKtv+Um8+WYon/ZBlojSAAlmJ5sahHe32Cxltw
nASUw7osjdeePBrner+KTB8DvT9bdN9o9Ef3fCqecOfRS9durMllOYNeVtbT
BXUVsfUF8oI653SNOgjimajW44y8eOyGJePvTvMMxjfvPKvjHvszDb3+bfQx
Yl1P/ma5TMsbm7CD+6HZyBe0093ethSdV6l5KxzLp62U7f1ue2jIzLos72er
1iZa/dBZgqxgHoxlX1B6P7QB/bJ7uaDUd41Du8wLVo3Pk+hGaAYGSJpBkl0J
RnpyvWbv7X/7VeFR01OrlhqMrvt9jO3veVNLul/W/RoZfmlOKqlZMRZ0ePrS
vGxx9hvsGQODc1vOpqvZCZlVN4vCC4K6O3JqNW5nwzTN3YF575dbN2YHgdYg
PJ1nMjQo1/0FEudbW3LK6muSdF+mEafX5dza6T5UCEjGqrnq4wmDeDNdsRpV
+IjywNf4/6iOFQjoAJ7hqOS/kn/v+Q9pH5CzkRHcPzoyxmsgYO1r/gN/NtLX
Elek2ciyyO7j2UiQw1rtX9+axb4r5xiduaicYyyDaZfzCwNauGsYt4bmKucI
K+cIK0Dr8ckcobHMziypfuXEnxOtyok/v7UFH2RijUz8Bbr5V87lORKtUHN5
/jBr/TK37wIpCLsYAR7NlG6unJNzoVk5J1dxm4xypj+9ZteumEzQcyUzpPqV
022u8lROt/nU1vmpoUYc4OdIyqucbgsAhZBB8RQCldNtZQM6YFP4lfwHWO4k
gPnn/v94gE63lYHXio51V44LHVrBZerGkSkQfiurLDL5YaLMg6ksdcLNIdLW
6ul5gNtnnthRef9wvDH8A/mNMY+mN7g5YX0lKcp3kw6hszWBoL17+8NOdljL
nmrXUhtPvWoHraWigFAbPxC7Bz/wFMiasrfucneKftCPfplGBtdbxXj4i096
+VMj7hBk2yvvn/3xV0Mymjfk3ldFT2kK5mKKXYkaVLe4BhrODKr/fVark/op
IBXCD+fac+TkvS8UsJ3xPZAd5MYemC4ygMeHfsmFhCr837idCz/svgLLN56D
P3+XBO+uToQ3Vp6CN1ecRL6Xrkg00yk+4J3VZ2D5hktwPccmMy645fwxn3Nu
VjjfdypT+f/AdfvT7yVTwQpT9LmQWghbDt6GrYdyzLDtUC56UDyEn+Ly2fZj
XB5sPJgLG/bnwLnUAlZl3e4zhizBW9YdsjJWhc8fdufCliNFsC2+GEHbGX8H
zXpHPJ4fL4bNx4rhR9w24PW1h4pgXZwNNhzIYfVWbkq8V0CHOAG9Zm8+bD9W
ArsSSmDPSRJi14kSRPuXxGLYklgCm0+gECjM+qPFTIiNB3JZvRWbTvoVbfWf
f9LZdIMyrd1XwOTZi/zvSyxFmfaeJpn2nC6G7adKmFw/nSiB9fHFsO7wHdgY
F4gy1XGSaeOvBUyeA2dKIGrKMva973QpScZkIh1ROX1vPHKHtRIHmfxnaPbJ
OfcJFJ21wKo8jCqqBccVf5qLG9TzhDr/Z6Q5w6g5ONFMLT3N0SBviTF3NKbD
ogoWzfG4XlJMY2zPbmaPXixx4WhqP8cVwAFsMGYyKNzjMTMzdAlSmRU2HbsD
mw45NRsvTCyk7AtlPFpabXz6WGt06mZBB3+tlGdLAPUX07jS1Reno0TTXVDt
7Qo2b2UDpQkYWbnkjIHjs3iLw9nrMtKkrGzUWw7nmyDuTLFowNgXJIr+Ut42
x4sd9rYjolFLHbT7jJzLK1XG3Kb69XBJHs/gNL4u3Nvcj6eei2damj/4b8Ac
+M7VlR5/EZz752rV5ZmVEQx5P8zNe0eJ53e3HimAQ0klyOPhpFIrs9MQZpdb
MD7bhra5/Ugeu9FY8FgG47R7NG/sxo69Tu/GqAe7u4u3nsgZauNmqLmu1GGt
q7Pf6SDd7Gh8qq6AV83oYjyrQkD1WhJvCa+9q+f9Xe8itnceQv0Sb4NjF0rg
2PkSE9mV6PmqMEuSLYq2nUdFj7d6q688nrfJUkM/B++fPtzo2y0OT+LSsnNo
NBvsvkzdhYPcTRpf7urJawVGOx9v4wJ+P86z6oXScxyteldCISRcKoH4S6Vw
+ByN7bBTRySoD98RX8rGsmjVJjrAYtm4/7XjlF+7c/UQwVhe2L4qUx3n6/xu
jEOo79hMuPG+dAN/NkgwME4yPOqhGiGqGnxN66/wVANhfICkMdbhvTXMM6z9
p2xw6koJnEguJbcpMJ+J9eJOF7NkAhoXltHeSnkexbI27j3t3844nCMALzzh
ldUyqDleyNhEB//qnPv19CWGO84ZjcNJRXA+4y4kpSLo/ymF+AusRRPsbMh5
IFHM4BD4O3G4uf2oGP38cuR8xQYcZDOtzbnZ/u92NbQeyYpe5iCacLkErly9
y1CVTZn5SgnZuKRiljciVMmEt0kD+ONnL3mJaJmTkc4CZNwsYUKQaew/aYPd
CTYWxuw4ls+iYxzEwaY4G/z0az6sP5AHFzOKWL3LKVfcC0A/gPGYzwWw59JL
S+9IOguW8+gKDYmm+AizL/hZMP9FJETneMTOttO+tlSJ83DBi6cHa0VyH8Ga
f32JtOjhVCwC4lxGBGr6lh/tyPL2rRThA+lhyIYjY+zaVulhDtewsVYyJzLQ
VSaIvkZWXS1OWZdyFcKDgYWWELU5ZZ39JQR/zbJnQrThMGzmlDFaUtxD5xbl
qhIwat0gbSblLg/widRiT85CyxxI3yatazJzowIXcKsaMSl85cJtUpEROODy
yhRdllEJPBrudWJ2vMalMaJi6se9Iqwe0tBzfYM0nxnKo6/+5j5vbEAAb7Hb
dtngtmjaW4geRB7DblG4djV8Tb6iAwJrKZPDQcJk14KRe3ja0HBYzr2Chn/q
qKODgTq2YSpjE+DxEiD+yJhQHnfSavmN+Whv9ePu6a5PCqQumy9TAw7Xz+rg
M4ArpWuZlVM2KSCAYEbV8EES229DqUrmHmDmNHMdHzIOLGq+trFiv7LET/58
zMipcy/OZVTbcO7F2PpeiwszRHmStyvmVNTNjpUFtp9aSfW+phra4bwe1d9x
up4wThm7u7mvn16d86Qny+3prNtlHbuF80xVWGmP/DXTPZwQTyFUfskmjRSQ
vTITvoqvwdSEUHdIqz8sNTJ01VAEjx2/J5yC1VzI30bHXQxKq69VE6rPnNW4
KatR8srq/ZdR4mmrihbMwb6EWYwLgCYVr2skfRWBNFPCVruAaoS1IS6H3JFV
zY291O4aRa9DH3lBq/fAsiBRRdqNG+BJZCSX4wC3Mxjuq/olVeQDF4LYMQCl
XyfnwK+JfiiHoMVdgzOreh1HeTTzHtruoRyTPoZ6SiVC0l5grw8gT9RqnDJ5
WMMDmpdwYdzVc+Su23kQmn6vzV1VxWHU0Hq+Q57Dxc2zB/7ekweyGrMfjBqP
HsfSZHGLTMbW3/s43hzU+zgE9UmgDS3b1DfBTIcmKhfM4hW6A89m0FksVYul
80YSAUbvKTS79nvoaY/8VaAlYKqnoWEepfvZY0ziY4RBaMRBUReJxlC8IyoV
v1NoumooDaiFEVfoSD4bmnKcbokBoV8ynRPNyFR2FiyX9UYuerKNziLYvvt5
sUw86+lU1v08Pa3rOVqn1yWJjkDomCQe0zfx3uUqSUYwfsScsSJY5DWR5ZGp
RGRMBkE8BsvGXwdh8k0QJuWYwTz9tgXMM/LwoeYZdyBoFtvwTtojI9NLIejF
ItoEFGxyEaI7uYQdEYTji+hU/B5bCMIL+fiEXBBGF7An2uiJowtAiM4DYVge
fZvowEJHxOmw30AYfEv8Fu+heoNzEa/+t4JItCBH2UKcZRuDMozLkb+xpnny
bZJjSgFJRPLgWfCsItzNKQkB8+xi1Ousu7F05TsSDS9bY4oh5u/sFTThISkG
Sb9RysrwGrGjcV+IeN+XuWCdYiNAGAzWiTaI+e9coSa7pwqkXy+BmM9vg/X5
HBKM5EJbuKrWmixZipNkQZPzSRoyx+lFkoZQHhIHy0Lml5ohZGGpBYIX3MWL
CwF38/CxKONDtBMegdh/FkDC+dvQetQ+qN5jM9Tq8wvU7rsDHu67DWr32QZ1
+u6EOv1+gZp9d0H1vruhat89UKXPPgjutRvMPXZDUI99yNUuaDxkGxxPukH0
BAaiEO5z2gQv2RtZVMyX+XDzTAJs6tMavn2yOqxpVwv+HV4bvm//MHzfrjas
aV8H1uK2LrwmbGxXHX58qir83LYKbGwTDBtbm+HnVkGwrrkAa55tDFdPHWcq
YBYoq0CEX5Dxt6jxNxH4WCwa0x0R+jklDHUToR4MIYvvmhToZxL030mop98s
hdYTL0Od5y9Dg+jL0PSFFGgx/gq0nJAMzfG72cQUaIpbI9waTEqHuhPToc6E
DKgxLh1Cx2SAZWQGBA1BXvomIjpbpUSYiLofaCuok0EfG9gajnapA0e7N4Dj
fZrC8f4tcGsJx/s1h4T+zeBEv6Zwsm8jON23AZx+ri6c6VkHTkfUgDPPhMLp
jhY40S4I9rYR4N+IPKOtg7qr1UsWz+y9BkRHRzNwLYpd15AQpk+NoTeg4bhb
0Hrab/CHGb/B07NvQ4c5tyF8Tg6Ez82Bp+bnQJuXcqDFS7nQeH4u1J+bB3Vm
5UH1mDwImZwLphfQ60Ths7tuc0DYX7QRX4l2UucacKF3Q7g0uDX8Z/gf4HL0
05A8ugMkR4dD8qhwuDLqKUiJbgNpI1pA2tDGkD64PqQPqAPpvatDWvcQSO5i
ghN/EOCHZvJbZ4gv+WpnhFk3h91G45POfmWS6FcQYVixamUwpKWlYeWU8xcg
MyuLNrT6a9eu4R4vM+CD5tylLYHw6cn8oSjIw6NyocXUPAifnQfPLMiDiMX5
uBVAt5fz4ZlX8qHzq/nQ/rUCCHvNBi1etUHjV2xQf6ENas0rhGozbGCdnAem
EWiOEbtkQZB2uD9oK90UfS49+zAkR7aAKyPDIXXcM5A2MQLSJuE2sRukT3wG
t86QMaE9ZI4Lg6zRLSB7ZGPIHlofsgfVgqw+1SAtwgpnnjbB+pZBIm21Xw8/
qCgAQ/FmZ6QuK1Psficpjp0hPHPmTJQctWBi4FeFCxcuwIGPPmbfqAimFjqm
bzqnSqgJE3XRDLJ46p57MgsT30CqNzYXnsIesCsC99yr+dKLXaHQZmkhNF9S
CI+9WgiPLCqEGnMKIXRaHlhHZYKpx/9zsFQ+nWrsjoa8ekoMQJ//9KwHV4Y9
Banju0La1Ocgf88mVp4xvTduvSDjxQjInNoFsia3h+zxbeDq2Obsum3rKsge
UAPSe4bC2U5W2NBKfhmm/y0y8F5ZIr5hcQq+Fju+hP6wayYCmOJChJiQIvNm
8CL3hCIewaEZsZA9bhhs375dRBu/9yz/jCGcm5tL9cQ+18SCH+rca7KQR4Sl
0YRc6DQPIUE7HPhHO7xt30BbRHgbIby/R3hrzbUxh1BtbCbr9GR4ixBCDh1W
NuhNGwx4swD6vlUAvd5Ge8fvjm/ZnGjTh0NbDL2ixcXnl9FFp4zpxOBPjx0o
v9GSMaMvZMb2gswXu0HW1I5wdWJbMemCdkfmndGnOpztVg02Pin9L5ds1gQ9
eREWsjDkrZJrIeTT8LlXKbAURPh/x6BftGgRg5Qg3xQZBQm/HoSzY0dDysxh
cHnBBDgy6wXY06wZ/PzTT6KGLLD888/FLlfcZpIav6O4UoK+xdRciFiUBwMQ
riFvF9ihX2qDlq8XQhN0BfUX2aDufBvUmZkHNSdkQdU+imUjnUd4dFjZkD8V
QCQe90fIn8PtWdw6EfQOtOmjQTv6tpQtINeSii4lPXYAZMwZAhlzh8qvkmTO
eA4ypz+L0HcS5J9qJM+SNbgupPWvA0k9MJxpW1Uy+l5ZbPCSIg5e2mxxdCoE
PY2kGfTp9rgenQtBv3fvXsnqq8PBceNhe5uWkDe+H1wf1hsyv50DWyZHwBct
H2N4f/bpX2D7W6+yb8KdAh+G1XEKQnuSWUmoPYkG1+c1RAyRGf5OAYx4twCG
4XfUn9Bosaw3bhFovB2XFkDbJYgaItZ0sQ0aLLBBvXm4YQ9Zd1ImPNRfaQxI
uxGXNn2M0GZ+ypU26YONK+hz5fknIW1aH8iYPQQy5w/HbQRkzBsmaqAmaiQC
5M/d/NuQNbIpZA1tAJlR9SBtUD04i2HOj+EPiWSpIfS8Yh9Tttkia+X3IDSJ
E4dmpJVh6U6jLdLK0SNH4dLOHXBq5044+Hx/SJ0WAfmrZ0PG8ilwfWpnuNAl
DA6Ft4LtAzrCbyMHwfkzZ+CfK1ewcY2JjQioC69FO0kj7bF7jHwjH0aiJka9
Z4Pod20MvSi04wFvoB0jWs8uKYAO2FW2faUAWmLbaIraaDi/ABrOxQ1Razgl
A2oPUOxYkzZ9jNCmjwbtYdek/zNIGdke0mdGQuZLIyFzwSjIeimaaSZjTpSY
+6wOmdEtIXN4U8gY0hAyohpC6uCGcKZfQ9jwdG1RE9QwSAs0DqY+QGwgLLCs
66oK8k+SOkgVS8aNhSvPYDjduxNcGz8Ecr6cDkWH34OcNS9D2hsj4diwZyH9
n4vh+pLh8PWHH8DR/fvh6398jWPMCdepVZJWidyYa0Is7b+jJ0jAdUafPgyd
yehlNhj7Xzb2PRzPo9B8+/8R/frr6NcxfumAMU3YQgQOlfE4AtZodgE0nlUA
TWflQtOpGVB3oBIXIe0mXNpMKQZo04dDm1TC8KFP6tjOkDl3GGQtHA1Zi8ai
YkZjM0GlzIpCZ9ZfbC7YO48Og/QRLSF96OOQHtUIt8aQMqQpnBnYFNZ3rCuS
Jd8kJyueSACh5RpZN/Ux6N8JQqeTYoaD8ic4LBHGYrsan810Iwc7NxZPg+sf
jof8z8YxvZz8dC5siRkBv8ZGgm3bK5D1zvOw6oP3YfXq1fD6ktdJNbJiSEVI
kYCr4aCZZxfmwdj3C2DChzaY8IGI4AhEbwihtyQfeqED6orIdViI6M3Ph1Zz
8qEZotZkJqI4Ix9azMSQH9GrH+moGT5t+hihTR8N2lGpUnNJnYB9xuKxkPXq
BMh6ZQJkLhwLGejE0mcPkZtL2rBWkPZ8M2wmTSA16nH0eS3g9KAWsL5zfVEj
csqIgCeNiM2lxhuoknrOKhl0UWoy6QxEuStnsei2zXD2veEYsT3D1BA3JxoO
vPcqbBnXAxkbAJde6ArpHdtA8v/9ipqLpJJsExFiOShSSTqpJF2Crd/r+TD5
YxtM/aQQJn9kg3Hv22DkOzYYgt6lP3qWXghZ1wUIGxp+29n50HpmPjSPzYfH
YxAy/H5iRg48MS0NGkT+oqgkXepT1LTpY4Q2fTi0xXReZDI7Tp/eD7KWTIas
pVPF78XjIHPeSLlPodDX8ZMS1RxSIh/H7xaQPPQJODX4CVj3TANn1ZBayG+x
xsI0U8VVMyNTHTVjYmO138GFp1rB1k5hcLR9W4gb3IX5LupGPmpYlyklaXQ/
2PyPLyEj+TL864vPzc4KeUilkBl/LYRZnxfC9L8UwkS05dHYrQxFOx6E3qU3
jsAiEDSKXP+AoD2JoLVGsFqhQtqgHYehHbeZmgYNBzsqxMqjLQ0oqvPqialL
B7Cz/zQDrr47C7LfnI7tYKIgx1RpU3pD2oQISB0jx1TV0B21gpShaIbDwiAx
qg2sfaahHWm5AYhIK42grgh15yPYq5wUoab8LkH9QiZrBNHR0ZD1/TesIexf
tJD1EeSHqN+Qjf/bjmFw6edNzIdJ3TfFUpkM6+NEric1Lglr8trzviiEl74U
MZn6cSGMQ5808m0bRKE37/9qAfREf9EV/UWHuXnQDrvkthh6hiHmbXF7CjEL
m5YOjw3eqXSxMtYq2hLWv+PVc8KavP219+fBtQ9fIrzlkUP6jChIe7E/DpR7
4qC5K6SM6iDI11KGt4XLw59CqMNgbdfHZFY6nSQ3HBYnQt38W8HBquv9m4bJ
IPQgqJPE9DpZtgi1bNU0GDuxbh3cGP085L43DXJfGwTXBrWHM398DS7OmAJr
O3SB4uJiKMrPd0aaWXVNB6umwOX1FYWwdFUhLEBEYj8TXcLYZWIPQGj3w36z
1yJCOw+6oHV3mJMH7eeIOYh2M29DGFqnA9KKVatoK8NkTj0npCnguf7Z63D9
86WI9gKwHd0rlqN3z5w7QoK8H0Lei0GeOrYLu567Yy2kRIfD5RHtIHGIArkL
4g7GHeoOcepAUSgEHNk/MrAf5GWLY+G8A7sgLawVOyaYr+NgjpJFBLs4TtbE
fMx/FcAHPxTBJ2uL4K1vRNzJyl/8PzaY+KHY+45E7IZhQBm5NB8G4UZDgB7o
YbouJPzRI0xJhXoDdjhgHuYP2k56yVo8Bm7+4wO4teoTuPG3t5humOd540XI
em0iZFJsNH8kDuyGoY4icRvEhhdpk3swv588qgOcHNwG1nSqZ1Av7feI00/9
z6LTOY+IXsYtjemFckKiXqzM8ch6oC178AAsRU0gdbqXdIkbPWtMRiyhFUs6
7kmeTNLJ9E9t8MXPRfDVljsMvyUrC2HhV4Uw92+FzDNP/wt2l4jhlE9sLJKh
iGY4DgAGozfpje2j87wcaD0pFR7ppyQ2kXaYP2iLJirpJPut6fDb91/A7TVf
Md1c/2wJXPtoIVxdNpf1DFnYK2RjV5z9xylilLSYIqThkD5rMOqmN1zB2Pbk
oNbww9OPSDrpfETDO1mcdGLqm0AynqebUS0EM8abeIaKMJMW8DB7/z7WHkRN
aOgjXq2KV74uhE/XF8HyH4tg2XeF8DKek8Oe8VcbxHwqQjUJo5eJ5Kb+jGOw
ZQUwFE164FLRjNvPzoFm41Oh3fgDkH69WFKF32gPTRYeZbSvf/IK3PrmU/jt
2+Vw86tlcO2Tl+EqdhhXUQ3Zb8UwNWS9Pgm3iZD1MjaVhaNwGDEUm8lA1kSS
o9tDQr9msDmyHaRfvSN2ueSZSBePbyNdOKii+beiKnodhqDBTqqgFiJMzCTe
pmYHQ9D0a+yI5i6n4GBvYjZdpc2suKgYVZsIhZjPs+FieiksQjulUDH6PXEs
NQAjdsrLoc/AB3RflG+Cbgtw9/ScPCEY2uHQtvWLedB4wi3oEJsMJy/kECVT
GYjW0iIqTTEnQ8xnmXDnykU0+0Vo5pNxeBYtDs1iBmAQ9By5IMr5TOpuQi/U
zYQ99NPIagp2EslRreFi38aQMKID3Eo6CTHvXzaxLLVZxFYEXW4AJjaDYJEh
Fz3SiPPk6C9TDQJ1arYM9fRreGfsDRMdUU4Qr9jhz6bgX+wiKHWRUYNNQ5vB
+kI6xPz3NUi/USzNlIawcypno0HcuPcsx3tGpYodF8JiHS7CQiaq3PP+ZbB2
O2o3K5KwzRbZ7T6yUly7QqUU40UeYzP5kngWR/FIJDMJh6Uzc5iYosTi9Lm4
xdKQM57kDLa3dTFsFOfdR1xhjcdECwloScFFC/W/lNM+SyscEgk06pPJ/8sb
+iaTnGsV+WXCoUKIX4uKVcZR7A0zmObcDgXzPHJJeChNgtOUOh3RVH9X2uHp
tOv4VPOUa0xVpgnZbCPuWSsxE/tm4t/OvsAWQoiQDWJv7PY/K1jESKJ3ogh2
vX+z+RBB+eUf4peMl9CVscQHM97m5YN5/h2aRAVhEf1ijXkhaU86Z9/yMV6h
Y3roIpqLp/LgBXdpFlY4RldjaHqKJmsXipNVUiULuz+ULWqg6S6Gx/TbbGqA
EqVsuQJ9s8UDlPasIp7bteu4WILG+oQPuZnxLAlEVkjCR1wUJMnl3xOidkOY
BsfmMXFF9usswY7n0Xdw1/QDGrq0+gTgyU/Zhldxb4bw5cDOu4mneAe7YKIj
MzRbJldDAhIRcY9XlDJG3koPMouPDJlfyuwylw1tiEOJXelnapFbWimBvCKk
VEVgbCKiRJYeF/4xEGsm6PoZ7iL+BqHQ4wuIpaNY5chKRyg8HtJ9jt+oBTwK
JjomJoWFHkMz6qLxhx8UxxL2X4CKPMZAJNaYsbHVOBibsqCABmai91e+FadD
fe545nxYni6bpedodzOGBr0WOT1Ec6FSBs8saXUYO6TUB2XFIjOV8RSbu2Nl
18TjSNa0+6XRyh6WFMiUtmvidEmPk1apKQT9fxKjIPo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{370, 261},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,117"},
 CellLabel->"Out[3]=",
 CellID->120276969]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "@", " ", 
   RowBox[{"PropertyValue", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<systemPanel\>\"", ",", " ", "\"\<items\>\""}], "}"}], 
    "]"}]}], " ", "//", " ", "Shallow"}]], "Input",
 CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,118"},
 CellLabel->"In[4]:=",
 CellID->27294],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"awt.toolkit\"\>", ",", "\<\"sun.awt.windows.WToolkit\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"file.encoding\"\>", ",", "\<\"Cp1252\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"file.encoding.pkg\"\>", ",", "\<\"sun.io\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"file.separator\"\>", ",", "\<\"\\\\\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"java.awt.graphicsenv\"\>", 
     ",", "\<\"sun.awt.Win32GraphicsEnvironment\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"java.awt.printerjob\"\>", 
     ",", "\<\"sun.awt.windows.WPrinterJob\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"java.class.path\"\>", 
     ",", "\<\"C:\\\\Program Files\\\\Wolfram Research\\\\Mathematica\\\\6.0 \
DocumentationMilestone\\\\AddOns\\\\JLink\\\\JLink.jar\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"java.class.version\"\>", ",", "\<\"48.0\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"java.endorsed.dirs\"\>", 
     ",", "\<\"C:\\\\Program Files\\\\Wolfram Research\\\\Mathematica\\\\6.0 \
DocumentationMilestone\\\\SystemFiles\\\\Java\\\\Windows\\\\lib\\\\endorsed\"\
\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"java.ext.dirs\"\>", 
     ",", "\<\"C:\\\\Program Files\\\\Wolfram Research\\\\Mathematica\\\\6.0 \
DocumentationMilestone\\\\SystemFiles\\\\Java\\\\Windows\\\\lib\\\\ext\"\>"}],
     "}"}], ",", 
   RowBox[{"\[LeftSkeleton]", "49", "\[RightSkeleton]"}]}], "}"}]], "Output",
 CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,118"},
 CellLabel->"Out[4]//Shallow=",
 CellID->5450]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30149],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemInformation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32145]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1620],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"SystemPropertiesPanel\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 46.4135828}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "\"SystemPropertiesPanel\"Widget[\"SystemPropertiesPanel\"] displays the \
current system property values of the underlying runtime engine.", 
    "synonyms" -> {"system properties panel"}, "title" -> 
    "SystemPropertiesPanel", "type" -> "Widget", "uri" -> 
    "GUIKit/widget/SystemPropertiesPanel"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SystemPropertiesPanel"->{
  Cell[2927, 98, 633, 16, 70, "Notes",
   CellTags->"SystemPropertiesPanel",
   CellID->5714],
  Cell[4896, 164, 398, 9, 70, "Input",
   CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,116"},
   CellID->26392],
  Cell[5297, 175, 336, 8, 70, "Output",
   CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,116"},
   CellID->13531],
  Cell[5670, 188, 177, 4, 70, "Input",
   CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,117"},
   CellID->10204],
  Cell[5850, 194, 15272, 254, 70, "Output",
   Evaluatable->False,
   CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,117"},
   CellID->120276969],
  Cell[21159, 453, 342, 9, 70, "Input",
   CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,118"},
   CellID->27294],
  Cell[21504, 464, 1662, 38, 70, "Output",
   CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,118"},
   CellID->5450]},
 "PrimaryExamplesSection"->{
  Cell[4209, 136, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->97873867]},
 "Ex--21907299533234115765,116"->{
  Cell[4896, 164, 398, 9, 70, "Input",
   CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,116"},
   CellID->26392],
  Cell[5297, 175, 336, 8, 70, "Output",
   CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,116"},
   CellID->13531]},
 "Ex--21907299533234115765,117"->{
  Cell[5670, 188, 177, 4, 70, "Input",
   CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,117"},
   CellID->10204],
  Cell[5850, 194, 15272, 254, 70, "Output",
   Evaluatable->False,
   CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,117"},
   CellID->120276969]},
 "Ex--21907299533234115765,118"->{
  Cell[21159, 453, 342, 9, 70, "Input",
   CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,118"},
   CellID->27294],
  Cell[21504, 464, 1662, 38, 70, "Output",
   CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,118"},
   CellID->5450]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SystemPropertiesPanel", 25847, 594},
 {"PrimaryExamplesSection", 26789, 617},
 {"Ex--21907299533234115765,116", 26943, 621},
 {"Ex--21907299533234115765,117", 27240, 628},
 {"Ex--21907299533234115765,118", 27568, 636}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1281, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1904, 60, 63, 1, 70, "ObjectName",
 CellID->13912],
Cell[1970, 63, 442, 13, 70, "Usage",
 CellID->17723]
}, Open  ]],
Cell[CellGroupData[{
Cell[2449, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2927, 98, 633, 16, 70, "Notes",
 CellTags->"SystemPropertiesPanel",
 CellID->5714],
Cell[3563, 116, 68, 1, 70, "Notes",
 CellID->5371],
Cell[3634, 119, 538, 12, 70, "3ColumnTableMod",
 CellID->16808]
}, Closed]],
Cell[CellGroupData[{
Cell[4209, 136, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->97873867],
Cell[CellGroupData[{
Cell[4593, 150, 147, 5, 70, "ExampleSection",
 CellID->28115882],
Cell[4743, 157, 128, 3, 70, "Input",
 CellID->15897234],
Cell[CellGroupData[{
Cell[4896, 164, 398, 9, 70, "Input",
 CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,116"},
 CellID->26392],
Cell[5297, 175, 336, 8, 70, "Output",
 CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,116"},
 CellID->13531]
}, Open  ]],
Cell[CellGroupData[{
Cell[5670, 188, 177, 4, 70, "Input",
 CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,117"},
 CellID->10204],
Cell[5850, 194, 15272, 254, 70, "Output",
 Evaluatable->False,
 CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,117"},
 CellID->120276969]
}, Open  ]],
Cell[CellGroupData[{
Cell[21159, 453, 342, 9, 70, "Input",
 CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,118"},
 CellID->27294],
Cell[21504, 464, 1662, 38, 70, "Output",
 CellTags->{"SystemPropertiesPanel", "Ex--21907299533234115765,118"},
 CellID->5450]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23227, 509, 311, 9, 70, "SeeAlsoSection",
 CellID->30149],
Cell[23541, 520, 472, 17, 70, "SeeAlso",
 CellID->32145]
}, Open  ]],
Cell[CellGroupData[{
Cell[24050, 542, 313, 9, 70, "TutorialsSection",
 CellID->1620],
Cell[24366, 553, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[24650, 565, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

