(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    230351,       4920]
NotebookOptionsPosition[    197447,       3985]
NotebookOutlinePosition[    218453,       4534]
CellTagsIndexPosition[    216478,       4490]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "TableForm" :> 
          Documentation`HelpLookup["paclet:ref/TableForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"TableForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"Table\"", "ObjectName",
 CellID->17368],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<Table\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a table."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12048]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "By default, all cells are editable. All cells in ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<DisplayOnlyTable\>\"", "]"}]], 
  "InlineFormula"],
 " are noneditable."
}], "Notes",
 CellID->15781],

Cell["\<\
By default, most data stored in tables will be strings and left-aligned \
within the cells. However, it is possible to store, display, and retrieve \
Booleans, numbers, and images within table columns with more native controls \
using checkboxes, right-aligned text, and icons, respectively. \
\>", "Notes",
 CellTags->"Table",
 CellID->23833],

Cell[TextData[{
 "To display images you will need to set ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"columnEditable\", \"TI\"]\)\>\""], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", to avoid corrupting the original images. "
}], "Notes",
 CellID->10574],

Cell[TextData[{
 "It is important that all data within a given column match either the first \
row's types or the ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"prototype\", \"TI\"]\)\>\""], "InlineFormula"],
 " property types if specified, because tables currently do not support \
rendering different data types on different rows within the same column."
}], "Notes",
 CellTags->"Table",
 CellID->24688],

Cell["The following properties are available:", "Notes",
 CellID->21884],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"items\", \"TI\"]\)\>\"", 
    RowBox[{"{", "}"}], Cell["the contents of the table", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"tableHeader\", \"TI\"]\)\>\"", "Null", Cell[
    "the table header", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"rowSelectionAllowed\", \"TI\"]\)\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether each row can be selected", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"columnSelectionAllowed\", \"TI\"]\)\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether each column can be selected", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"columnEditable\", \"TI\"]\)\>\"", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"], Cell[
    "whether cells in each column can be edited", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"columnSortable\", \"TI\"]\)\>\"", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"], Cell[
    "whether each column can be sorted by clicking the header", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"prototype\", \"TI\"]\)\>\"", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"], Cell[
    "how to format a typical row of data", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"model\", \"TI\"]\)\>\"", " ", Cell["\<\
the model that intercedes between the user interface and the data in the \
table\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->7668]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->90968459],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->203585120],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->499352286],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{
     StyleBox["Widget", "Output"], "[", 
     RowBox[{"\"\<Table\>\"", ",", 
      RowBox[{"{", "}"}], ",", " ", 
      RowBox[{"InitialArguments", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,120"},
 CellLabel->"In[2]:=",
 CellID->10342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,121"},
 CellLabel->"In[3]:=",
 CellID->630],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{233, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,121"},
 CellLabel->"Out[3]=",
 CellID->22887079]
}, Open  ]],

Cell["Create a basic table inside a scroll view:", "ExampleText",
 CellID->19451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{
    StyleBox["Widget", "Output"], "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       StyleBox["Widget", "Output"], "[", 
       RowBox[{"\"\<ScrollPane\>\"", ",", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
           RowBox[{
            StyleBox["Widget", "Output"], "[", 
            RowBox[{"\"\<Dimension\>\"", ",", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<width\>\"", "\[Rule]", "200"}], ",", " ", 
               RowBox[{"\"\<height\>\"", "\[Rule]", "110"}]}], "}"}]}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"\"\<viewportView\>\"", "\[Rule]", 
           RowBox[{
            StyleBox["Widget", "Output"], "[", 
            RowBox[{"\"\<Table\>\"", ",", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"\"\<items\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<a1\>\"", ",", "\"\<b1\>\"", ",", "\"\<c1\>\""}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<a2\>\"", ",", "\"\<b2\>\"", ",", "\"\<c2\>\""}], 
                   "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"\"\<model\>\"", ",", 
                 RowBox[{"Name", "->", " ", "\"\<myTableModel\>\""}]}], 
                "]"}]}], "\[IndentingNewLine]", "}"}], ",", " ", 
             RowBox[{"Name", "->", "\"\<myTable\>\""}]}], "]"}]}]}], 
         "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
      "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,123"},
 CellLabel->"In[4]:=",
 CellID->17720],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject114476850348033, 
   JLink`Objects`JavaObject203368664399873]]], "Output",
 CellTags->{"Table", "Ex--21907299533234115765,123"},
 CellLabel->"Out[4]=",
 CellID->10198]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,124"},
 CellLabel->"In[5]:=",
 CellID->28527],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,124"},
 CellLabel->"Out[5]=",
 CellID->364472226]
}, Open  ]],

Cell["Get the entire table contents:", "ExampleText",
 CellID->24405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"PropertyValue", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<myTable\>\"", ",", " ", "\"\<items\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,125"},
 CellLabel->"In[6]:=",
 CellID->21382],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"a1\"\>", ",", "\<\"b1\"\>", ",", "\<\"c1\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"a2\"\>", ",", "\<\"b2\"\>", ",", "\<\"c2\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->{"Table", "Ex--21907299533234115765,125"},
 CellLabel->"Out[6]=",
 CellID->12425]
}, Open  ]],

Cell["Get and set individual rows:", "ExampleText",
 CellID->21614],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<myTable\>\"", ",", " ", "\"\<items\>\""}], "}"}], ",", 
    "\[IndentingNewLine]", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"ToString", "[", 
       RowBox[{"{", 
        RowBox[{"i", ",", "j"}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "3"}], "}"}]}], "]"}]}], "]"}]}]], "Input",\

 CellTags->{"Table", "Ex--21907299533234115765,126"},
 CellLabel->"In[7]:=",
 CellID->16612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,127"},
 CellLabel->"In[8]:=",
 CellID->3192],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,127"},
 CellLabel->"Out[8]=",
 CellID->209479745]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"PropertyValue", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<myTable\>\"", ",", " ", "\"\<item\>\"", ",", "2"}], "}"}], 
   "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,128"},
 CellLabel->"In[9]:=",
 CellID->14938],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"{2, 1}\"\>", ",", "\<\"{2, 2}\"\>", ",", "\<\"{2, 3}\"\>"}], 
  "}"}]], "Output",
 CellTags->{"Table", "Ex--21907299533234115765,128"},
 CellLabel->"Out[9]=",
 CellID->25005]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<myTable\>\"", ",", " ", "\"\<item\>\"", ",", "1"}], "}"}], 
    ",", "\[IndentingNewLine]", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<10\>\"", ",", "\"\<100\>\"", ",", "\"\<1000\>\""}], "}"}]}],
    "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,129"},
 CellLabel->"In[10]:=",
 CellID->26866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,130"},
 CellLabel->"In[11]:=",
 CellID->16666],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,130"},
 CellLabel->"Out[11]=",
 CellID->545526408]
}, Open  ]],

Cell["Change the column headers:", "ExampleText",
 CellID->3080],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<myTableModel\>\"", ",", " ", "\"\<columnIdentifiers\>\""}], 
     "}"}], ",", " ", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"\"\<One\>\"", ",", "\"\<Two\>\"", ",", "\"\<Three\>\""}], 
     "}"}]}], "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,131"},
 CellLabel->"In[12]:=",
 CellID->6964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,132"},
 CellLabel->"In[13]:=",
 CellID->27541],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,132"},
 CellLabel->"Out[13]=",
 CellID->113928888]
}, Open  ]],

Cell[TextData[{
 "Use the ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"model\", \"TI\"]\)\>\""], "InlineFormula"],
 " component to add rows:"
}], "ExampleText",
 CellID->7886],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<myTableModel\>\"", ",", " ", "\"\<addRow\>\""}], "}"}], ",",
     " ", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}], 
   "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,133"},
 CellLabel->"In[14]:=",
 CellID->1935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,134"},
 CellLabel->"In[15]:=",
 CellID->12733],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,134"},
 CellLabel->"Out[15]=",
 CellID->342225268]
}, Open  ]],

Cell["Add columns:", "ExampleText",
 CellID->10724],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<myTableModel\>\"", ",", " ", "\"\<addColumn\>\""}], "}"}], 
    ",", " ", "\"\<Id\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
     "\"\<1\>\"", ",", "\"\<2\>\"", ",", "\"\<3\>\"", ",", "\"\<4\>\"", ",", 
      "\"\<5\>\""}], "}"}]}], "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,135"},
 CellLabel->"In[16]:=",
 CellID->23076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,136"},
 CellLabel->"In[17]:=",
 CellID->15292],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,136"},
 CellLabel->"Out[17]=",
 CellID->94539290]
}, Open  ]],

Cell["Remove rows:", "ExampleText",
 CellID->30951],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<myTableModel\>\"", ",", " ", "\"\<removeRow\>\""}], "}"}], 
    ",", "0"}], "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,137"},
 CellLabel->"In[18]:=",
 CellID->15596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,138"},
 CellLabel->"In[19]:=",
 CellID->9527],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,138"},
 CellLabel->"Out[19]=",
 CellID->15564236]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<myTableModel\>\"", ",", " ", "\"\<insertRow\>\""}], "}"}], 
    ",", " ", "2", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<i\>\"", ",", "\"\<j\>\"", ",", "\"\<k\>\""}], "}"}]}], 
   "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,139"},
 CellLabel->"In[20]:=",
 CellID->4287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,140"},
 CellLabel->"In[21]:=",
 CellID->12027],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,140"},
 CellLabel->"Out[21]=",
 CellID->62046626]
}, Open  ]],

Cell["Query and change individual cells:", "ExampleText",
 CellID->10805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<myTableModel\>\"", ",", " ", "\"\<getValueAt\>\""}], "}"}], 
    ",", " ", "1", ",", "1"}], "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,141"},
 CellLabel->"In[22]:=",
 CellID->11127],

Cell[BoxData["\<\"{3, 2}\"\>"], "Output",
 CellTags->{"Table", "Ex--21907299533234115765,141"},
 CellLabel->"Out[22]=",
 CellID->24837]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<myTableModel\>\"", ",", " ", "\"\<setValueAt\>\""}], "}"}], 
    ",", " ", "\"\<Test\>\"", ",", "1", ",", "1"}], "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,142"},
 CellLabel->"In[23]:=",
 CellID->29710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,143"},
 CellLabel->"In[24]:=",
 CellID->16583],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,143"},
 CellLabel->"Out[24]=",
 CellID->167550811]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30080],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Table Headers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->16434],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->356797873],

Cell[TextData[{
 "Set the ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"tableHeader\", \"TI\"]\)\>\""], "InlineFormula"],
 " property to ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " to suppress display of column headers:"
}], "ExampleText",
 CellID->22229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{
    StyleBox["Widget", "Output"], "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       StyleBox["Widget", "Output"], "[", 
       RowBox[{"\"\<ScrollPane\>\"", ",", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
           RowBox[{
            StyleBox["Widget", "Output"], "[", 
            RowBox[{"\"\<Dimension\>\"", ",", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<width\>\"", "\[Rule]", "200"}], ",", " ", 
               RowBox[{"\"\<height\>\"", "\[Rule]", "80"}]}], "}"}]}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"\"\<viewportView\>\"", "\[Rule]", 
           RowBox[{
            StyleBox["Widget", "Output"], "[", 
            RowBox[{"\"\<Table\>\"", ",", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"\"\<tableHeader\>\"", "\[Rule]", "Null"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"\"\<items\>\"", "\[Rule]", 
                RowBox[{"Script", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    "\"\<a1\>\"", ",", "\"\<b1\>\"", ",", "\"\<c1\>\""}], 
                    "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    "\"\<a2\>\"", ",", "\"\<b2\>\"", ",", "\"\<c2\>\""}], 
                    "}"}]}], "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"\"\<model\>\"", ",", 
                 RowBox[{"Name", "->", " ", "\"\<myTableModel\>\""}]}], 
                "]"}]}], "\[IndentingNewLine]", "}"}], ",", " ", 
             RowBox[{"Name", "->", "\"\<myTable\>\""}]}], "]"}]}]}], 
         "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
      "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,145"},
 CellLabel->"In[2]:=",
 CellID->8853],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject64940106842113, 
   JLink`Objects`JavaObject390716077375489]]], "Output",
 CellTags->{"Table", "Ex--21907299533234115765,145"},
 CellLabel->"Out[2]=",
 CellID->21930]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,146"},
 CellLabel->"In[3]:=",
 CellID->5408],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,146"},
 CellLabel->"Out[3]=",
 CellID->50356114]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Editability",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7448],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->337910415],

Cell[TextData[{
 "Always set ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"columnEditable\", \"TI\"]\)\>\""], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if displaying images:"
}], "ExampleText",
 CellID->19141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<ScrollPane\>\"", ",", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Dimension\>\"", ",", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<width\>\"", "\[Rule]", "200"}], ",", " ", 
               RowBox[{"\"\<height\>\"", "\[Rule]", "110"}]}], "}"}]}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"\"\<viewportView\>\"", "\[Rule]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Table\>\"", ",", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"\"\<columnEditable\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"False", ",", " ", "True", ",", " ", "True"}], 
                 "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"\"\<items\>\"", "\[Rule]", 
                RowBox[{"{", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Widget", "[", 
                    RowBox[{"\"\<Icon\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<path\>\"", "->", 
                    "\"\<Wolfram/Example/Play16.gif\>\""}], "}"}]}], "]"}], 
                    ",", "True", ",", "45.0"}], "}"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Widget", "[", 
                    RowBox[{"\"\<Icon\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<data\>\"", "->", 
                    RowBox[{"Script", "[", 
                    RowBox[{"ExportString", "[", 
                    RowBox[{
                    RowBox[{"ToBoxes", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"f", "''"}], "[", "\[Beta]", "]"}], ",", 
                    "TraditionalForm"}], "]"}], ",", " ", "\"\<GIF\>\"", ",", 
                    " ", 
                    RowBox[{"\"\<TransparentColor\>\"", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "1", "]"}]}]}], "]"}], "]"}]}], 
                    "}"}]}], "]"}], ",", "False", ",", "67.9"}], "}"}]}], 
                 "\[IndentingNewLine]", "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"\"\<model\>\"", ",", 
                 RowBox[{"Name", "->", " ", "\"\<myTableModel\>\""}]}], 
                "]"}]}], "\[IndentingNewLine]", "}"}], ",", " ", 
             RowBox[{"Name", "->", "\"\<myTable\>\""}]}], "]"}]}]}], 
         "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
      "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,148"},
 CellLabel->"In[2]:=",
 CellID->2670],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject223656999387137, 
   JLink`Objects`JavaObject482280871034881]]], "Output",
 CellTags->{"Table", "Ex--21907299533234115765,148"},
 CellLabel->"Out[2]=",
 CellID->15416]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,149"},
 CellLabel->"In[3]:=",
 CellID->3063],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWwtYVNe1PswwIFhNfEYjPlBRQ9AI4ltEowIKqCioqKCgICr4AKPRmGrS
2Nw8vNVqa02TNn7Jl9s0JmnaJNbE5jbPpo35NKZRoxIQGGZ4qEEYBjT637X2
PmeYGc7AaLC1vT3ft8/ZZ5+9117rX2uvvdfeM4kZG3Ky8jI2rFyW0S82P2Nd
zsplBf1i1uZTkdFHUZTjlHb1UzgPymo3I5Su+6F0eZqT8rm4K4ovlO6vQenz
vJoOtOeMiXOBnKPX3uKVbzJ3wCUnP8hcoNqs9wE/x4dABymTa66ba9uuXMbs
CDZe4DcovX7po/JJdXoeQ7vwr9Eh9gzuTC5C4PSvqdR38mn6NLHwDihR5zh3
jrqOKgxUX6MKRZmoopVN5DLnXPtmLVRSJtcPTTk/x1eTazOuUshSRJ2DMvo4
lLAjLE1zKTrPMaP7qotol1JIpf6zKj+AElfDSuKWQ99jiBWfJiWpzdQmn2Lb
c4e5clyNbOBU2eReWdT9BNUVp4kQ5Z1b3daN+vzTGvlHtNJoIst04F+q0e0O
efhpLxq5A3F7N2oViImFNzE02qyRvzeNmgPxL95I1/Zum0ZRhf+ejW7Y9v6B
jXSH+23dyDsP+2/WSLiw27jRTcn0n0b/3xtt3779Rht1Al0GjuuGcY4CASIC
9VKiPZaZRJlbV60EDp1UahxDiixdHR39+7l95beuOv334HsHBCVtv7tNueuq
03+guPs6l3litYsnVpUA5hU1NZdQW1sDm60Odns9GhsbcPXqFVy79h2uX79O
LWV7ruva/lYKGKAjIF2iwFenfmePUgYKzi9dqm5NUoOXgobyXfSuQePMiH6Z
o3Lb4mNyx0eYrrGFbx4NVxGWi+rqCm+wEg2pvqJn6ve00L8GsrMsplbr3wxq
3XR6aqdTJntoNpT09OjZyCR4VqvZawDbCrwAVTDn+jpguWN1+p+Nldlc4jVe
N4OVHk/C0AT3N2JWbQOVukl5M1CVlHzjNVwtQuXRe/q2AOTNQyV8jegoQKdP
oxtAan96Nt4aQMXFZ70GqWVbcu1Xbzptybl6D5X77lY3L6jqfTO1HYjffPO1
10DezIDUs7sbBlPuqrUCZnc3UNShpweKXplgyuCphefllITx3LlTXkPpCcam
FYbgQOBjcpTpLiS8AuYuh2SSnLvZ6OrIpFPW2iqCQfAWCE8gRN+0mHe76V+V
boCXTHvD+Pdn2t1ZTvbE3Y1FFDfdV3Sb9tAs5NPfQ3dnK3zVx23Elp+eZTB9
jSBlNaJKz5vAudC77oJUgiNGZDsI9vPEghqRSfdQ65iyrlxpxHffXaWl0LXv
H5HdEOMG5jvYI7uBbgGkR5a9Da1GinuzqK8Ft6cnjVsk4K6G/fuP8rMFNXTQ
CRlrEXwgWE82waEnf6AnkEOWFhbtrsOlFbF8HWJlZ+/nfF+Pkvm6B3lGFos6
0BPMw3iI4HvTnNRmYphcxFBFUfp4lEWaU2VlOctDrVkQUzNBPGkmQl8zfm0q
ktFZJJrM+e7qC3q1Ip7FUsoiUlsWr50wSDZELTmL60FfI9Qyp+WQXFf4erua
8NNz156kNOpIebdHKf3VYPC8kJQlcjJORVqn0SGlJ2V6FNFDnNNM2N43KeyN
qbSdELa0tMghsGq9msAGVd7WgpVIvhta3oL6XlLe6FjUAtXClqQT6tVmiRvx
mGgpatcVzN+TYDfgK5tkak0ubYa4sVVhoUtc2ArfNzZ1aUx7w/gtZ5qBRkvL
nptYeTWLp9t0KanXQ/PF6vq1y4ladcVpzom3aI9lJlHmsifQ2x1G98FIVzQO
/obdCxNjApJlT2V+jjK3jrR+/D31g5pLJUqUONsxMSln4l5+83f55klSf12D
uaUcuM1l/+GgNQ66CkpySmEq8q15Wb8WuOnGbyYZdXuudRe/GZtq3Vbcu9U3
3CCN7uo3p/oi8dKkf5tJ6x3ObSGPHo2QtpXDA1r/GpK5xwCudtBEnSUa+L1H
zk3x3PuW8vzP0MJtLdH38gBeS3aXDletWk5beuZmnAZEnvnHzmz/4UCHA/9/
JAfjz0AJftk9LGjOwURByte9gxaLvevSpNelMonJNFsreyrTWT/LXlz/o+DU
ict/FNw4osp3H6PSYpniiylen3KMKvtMOQafqcc5KQEwTDtu5KyByxWj/MI1
6C2C38K5WTi/91EJCHrDSOkR73Nv3X4qle7aG5nFUa4vujHIbpQZNKZ9Es8x
jdlUI7GUniX0le9UNvc857S32SXLuMpwKDHF/M4040vFm59WNoW4mCSSIv7W
wfeJZ2SZfJvkUjbxDPc27mveYRtzmnMU8Z+WeX4y72MqWTKG8SmpWE2w+CrJ
cnIpE1lQzhAvoLLF1VCWXoSy5LIRxqwaXxhz6qhTY84V+KwSiWrynRjJugaf
5Y2cFBJsaSOhu/Q7kWMIFzfyq3ymNkBZaKMeaqHMrxc92rnH+fVQUuqgJNXx
08AZX84xp0nfQkm4JJ+yDrdLqCW8Yi/5sGg+zrL5u8q2gGRYdFl7UkvjUv63
jDGjniVieejNb1Uj3XK/84dx9VXS66rr4fxlPItGn03ZV5H9S5uw5ztUSzdf
uCbK6Buz46Gev6y3vxamDDsDImAwpduR/fNa5U5Rpx3M1d8he08NTLMus2As
F9lCpbvWNMlKXCTzWWpjadgcsxpVDZE8LA6V+a+9ZoR//jVf+K2/Th/zQbc1
yGUZadpa8at6HD9TgyHzPkSH6LfRaeqf0Hnau+g67TA6Tz2MLtOOoEvMn3Dn
tPfQYdqfETjtfbSb+iH8Jv8Zxug/wyf6Q2LoPfSdeRjHTl9georATwlvc9qM
LJsaG1P2fhsunjyOt6YOwUv3dsDB4Z3wSnhnvBzRFS8P74yDEV3wKqXXwu/E
G8M74PfDAvHm0HZ4I9QPbwwx4s3BPnhtoIKDE/qi8u/HBPrC+DT0JfKKBr2v
O/QGxp2KpR1dkajnficANzDgfvDfcN3gQH0Eoz5eRd188RqGpBehy6wi9Eop
QvDCEoQsPo9BacUYSM8B6SUIptSHUq8lZnRPN6NLWjk6LjIjYEE5fJPL4TOT
eJn2JaHzR2FFGuq3gLYDdbblz6cPwdExXXB0Yi8cmxqMY7EhlAbhWMxAHI8d
gC9ignFiWh98Na0Xvrq/O05O6oKvojri5NgAfDXSF18M98EHoQpeIeQF7RZQ
b27wqrELU++IlJQUAa4vg7taBZevjrMvIGjRJQxZ9i3uy/kWI1bXIDK3BuG5
lxGedxnD1l5G6LrLCFlXi75ra9Ezrw5dVtWhQ3Yd/JfWwrCQfE0idTvusBO4
t4o2QavSPj26I85OCUJhwhB8M+c+FKWMQPH8SBSnhKN4XjjOzxuGkpRQlM0N
QdnsvjAn9IQ5rgvMUzqgbKI/iscY8MV9Cn47QNFoJ9Syh3YFV0xuNFn0PeHq
TZZIb0Lg4tcHnvdDWVkZNS45cxYWq5UTGXxVVRXd6TNjDp/c65yWMz6BwgtK
QbrOq0VIZh3CV9dh7Po6RG2wUarH+AdsGLvRhtGbbIh4sB5hD9oRssmOvhvt
6JlvR6c1DWifY4dpaR0Mc8kSo97TBCHa4beCtmNy4qtwQlcUx4fgfHI4SheN
RVl6FMqWUEofD3P6WEqjUZ4WAcuiMFjnh6AiuS8qZvdExYxOsE5tj7IoE06O
MOD1QT6Strs3D//EoYAAKANOqhOVRU66SxzuXCC8cuVKkpy0YBDgB+Ls2bP4
+KmnxZMUIdTCeX7yOzciTRh4YhaQZfKkHCgsTP44pUdqLYbRvDeOgLt/k42G
GMQReejWBgzc0oDemxrQraABHXMbELCsDqZ5Fhii/9fJUvXptBc1gvTaOWZ+
vr6Z1APnk4ahdPE4lGXeD9v7b4ny8qwplCajfHkULJljYF0agYrFoahMHSi+
2/94ABVxHWGeFIBTo0z43WBxbmFgdNnAJ1slvmGfOvD1bcKX0U+qMjDAvBok
iBkpNm8BL3HPKFIOf81ZgYpFSXjnnXck2vR8f+9ugXBtbS23kzOtgZHNE2sc
iUiftFqMWkNokAlOf6gJ2aEPkxkSsn0I2bsI2U55duEL2qdaxFSnIduoBOnR
EWUzfmhH3A/rMW1bPSZvJ1On58htdhfafOnQlmstWjfxVUSOuWTBKIG8ecV0
7UyrPGcaLCsmw7J8PKyZI1GZPlQ97woUll0+tQNOjW+PN+71kyQ1i2bU2YGI
NYoA3aR6FQa9jPqt5JWkIpH/gUC9oKBAoMlovxWfiON/+QSnUuejZGUSitan
4bNVC/H+gAF48w9/kMrxxd49e+REK9MI1uB4Xkiq0Idk1iKqoA5xBNfM7fVN
0G+1Y9DmBvQjL9CzwI7ua+3osrIOd6ZZETjVYdREp5seHVE285F6xFM+liC/
n9IESqMYeifafHmgnVIjT7+FVyklb2JeEYfy3Jkoz5utHTNacu6HJWsCQT9K
hd1POBVrQneUxXbB6WhaxAwNVO19slVEKyUyWgk95OxPGHoOXAX05qaFPPkV
hv6DDz5QDb4DPlm0GO+EDkLd4hhUJ02B5aVcHFoahX2Degu8d+/6Cd7Ztkk8
GXde7gislvGqM5DNSkXtXjK4qQ8SYoTMnEfrMfdH9UiiZ+IjZLRUNoVSFBnv
yK31GLqFUCPEgjfY0Wu9HT3WUKLJsfsSC+6IdQwGot1HlzZf3tAWLqo5bdaH
CCT4Oj/rXpQtm4ry1TNhWTuH0lyUr0mSGriTNBIF7bpuq4E1ORjW2b1gSeyB
shk9cIoWN78Pv0OS5YEw6XxTEBl6SNPKXVD6fSpjMdZKktklvGKtHP3sKAqP
vIu/HzmCT2bFonRZFGwvrkb53gxUZ47G2TFh+Gv4YLwTNxLfJs/AmZMn8avn
fy0CGQMrYw3P3qoyImhSjH/YhmRSwrzH7Ej5kV0Al0gmHPcwmTABNWFLPSJp
ghy6sR6DaFgEkyKC1tYjKI8SARaUUY7OcQ4T9kibL29o8+WBdlKV/J03SpIj
YF4ZD8u6ZFjWz4N1XYpQSnluovxBTAdYUgbBMicY5TODUJ4YhNKEIJyMCcLv
RnSWSuAxwQrgmJc9vxwbYiXZvbkW2DWpmmAtbFmUivNjaf08ZRSqFs/E5f1Z
aPzbY7h88AGUPZyMz5MmwPyrDajeMgfPPvkEjn70EZ597lmKJ9OqeUCyQpnc
gipaptB9PPegAjea3HkS+ZH5O+xI/bFdPOfQeyJZbuxD5NI3k0unVUskrWTC
8gk4UkZ/AqzP6nr0XVWP4FW1CM4sR/fpjtUQ0e6nS1soxQvafOnQZpUIfPgq
TR0NS14SrPnzYS1IJcXMpxFCSlmVSH4sVo4UmpPnh8E8dxDMs/vDnNiHUl+U
zAzGyenBeH1kd0mW3ZK2MXHPcSiDDmq66Umr/CNQRp2Quxm8V0JxiJJKQ2px
hdCNtsS5sGEZqp9cDNvuRUIvJ3bl4VD2XPxlRTzshzfC+ugsHHjicbz44ovY
vGUzq0ZTDKso1braSSkT8uuQ+ng90p60I+0JCd5cAm4mA7fFhsnkdsYRaJH5
BNxaGwbn2jCAAOu3kgDMsSFkJa3xCbie8c5K0afNlze0+fJAO7FUHSmlaTRT
bEiFdVMarBvTYMlPRTm5LvPqmdpIKUsajLJZA2iE9ENpYn/ydCH4akYIXh/d
UypD2xlizFkZcqR0fJi00cNVGzPOqaPFLDSiTeBi8Xn4bZx6bA4t0cYKDXya
m4KPH9uEQ4uiibE4FC4cB/PIUBT/4hkeKao2KgxMSGw1sTbMKmIxm21Y+rQd
mTsbsPQpOxY9bkfyo3bMJJ8SS/5kMqE1bj0hRuY+dLUNQ1baMHCFDf2zCS16
3pNzGfcsK0Ov+D85tGFWJxF32nx5Q5svHdpywy6+WOTNWTGwblkK69ZM+dyw
CJY1ydokwstc56skcSBK4vvTMwTFs+/B3xPuwWtje7lqhTXC3koMEaGUds2V
klzqrBSDiMt+gLPDBuOPo8JwNGIoPk0YIzwWzxtPBXUX+jg9PwZvP7cf5cVF
+M2+PUaHLnLddJHz0was2tOArJ80IJ0seD7NI7PJemeQO5lCgVYU4cWr1PsI
r3sJryGE02DSRShZbxhZb2hmGYISnHVh0qOtxg0d9NrJfUknnCseyUHlj1ah
4odZZP3pjp9plWVMQVlaFEoXaOun9uR/BqNkNhlfUhi+TAzFq2ODmkDWzF6C
7DD97hLl0Z/RNHJCosybt4zyQosw/ZSUFFhffkGY/0cF+WJSYMfDE4Vm8i+N
DEPhm28Jp6VO1bxusgiYlzG5QB5SKtbsptfsa8C6/RKTzKcbsIg8UfJ2OxLJ
fcduqsck8hLjyEtE5tVhOM3BQ2mZGUaYD6U0jDALW2ZG74QjjjlVw9qNtor1
D/TauWDN7r3q8TWoenId461FCeacRJQtj6V4eBLFxuNQMi/S8au4kjlDUTRn
GEEdhlfH9dZYGXWC/W7YpxLqgS8pTgbd4xWOhqFEM9Sn5d45G7WEWjNojrm+
eO01XJg/C7WPLUPtgzNQNSMCJx96EOdyMvBq5BhcvXoVjTabK9J5TgbNi5TN
v27A1gMNWE9grNgtHUHqDunyGegYmiMnFzDQdRhDhh2ZW4eIXLnLMHxlDcLI
MJ1Adhi0G21HIKzTzgVkXtxU796M6j1bCej1sB/9QJaTO7fkzVXRjiG0Jwu0
S1PHiO+1776KkpRwFM0dji9nOtBuBraTXQe0BjZPliQUYU3sfzY9BnUVMtqt
+/g9lIUNFnlGuJpiNt4OYsRlJKwH94If1+OJ3zZi56uN2PaChJxte/l/25H+
pJxpkwm2JFo3xm+1YQYlXuRHk18Zl8/Qkx/IKEWPuHed4A67FbRdVGLdsAAX
n3sClw7sxIWfbRNqEf7m4eWwPpgOCy+B1iZT6JZE6omnNEMEEGVLo4WjL54X
iRMJoTg4qoeXKol4X54oxZ4iV3OGwCyiVCZUwhs+UiUm4W40FXCqSIijUlIC
Uee6rEZK3NeC8nBGK5zVG8j+S9VJ1i479r3ZiGcOXRH4bXm+AfnPNCDvZw3C
H2f9hOZHwjBjp12sWnj1MofW+QnkQ6bQ0Bi95jKGLClFtxjHriXRDrsVtKV1
qjqp2JaFb1/eh5qDzwjdVO/egqqn8lG5I0/MB1aaCypo7q14KEOuiDbwamgO
zKsSSDdTcJ6WsCdmDMFvR3RTdTL6Mw8+yddFJ4Zpx1nGM1yZ1MIw07KS3kgR
RtYCZSs++lAMBakJD/rIdFfFxmcbsOv1Ruz9fSN2/E8DHqB3dtM5P7Uje5eE
agktV9LZQ/0XhVo76jGbTHr6VmnGEasvY8DiUgxf/DHM1VdVVdwy2rOL5S9Z
Ub1zIy69sAvfvrQXF5/ZgaqdD6CSpolKUkPFtmyhBuvmJZTSYX2Ahkr+PIoW
ZtMwmS6GSHFKBI7HDMDb8cNhrrwiJ1p2SqyL/odZF06qGPiSVMXkv8EnwUUV
PEKUdAvzllnhB5+sKpHj48gMiunSK/grJ6PDOw13GxMByN5TgXPmayggO+W1
YcpjMmSKo9U577yRz6AOJhbYDBi/nm4jcusUPwynCHbI8jr0TbuEyBXFOHH2
MlMyfA+inTwRVU+Ni5G924Ir58+R2ReQmS+lKCxFRmDZcbT0uZ9dEO/qLJlo
IC803kDz8ghitYTmh+LEITg3rS+Oz43EpdMnkP14kUFsQRslthJ0bQAYxPGA
rwa59Ehzz7CPL+IWDGpmhQZ1VhXVXHHBwDne9aMvTfBX8EJfzg6rxaGyEaaF
ZmT/vArmC1fVc09/8c7lIt6jpFtnL9WZVyqnK0LENEciwtbpqPN4EUzjjzZZ
FAsXekjzuN2eF7/pF6W8qIv/XJzLq5L5OkvG0hhZLipdeVlIKIWVh+EyhXNQ
mcki+jUNc7lOlKfoc8+LcWPgnwXwDwTO+fKsy3vVp/j3Cl8yXjwTs+vXErkl
g7aR+rz2HwShC+bX141VwdGKC0YYcmsCYFzD3oiy6pE2H5DTfR8f3FNuWTV1
aMyoEgoypFWIxIyLsWFkzo3MehPnivhFg0RrBv9IizhXfOXSYcqXEucer4gj
DkX9g6tklU2WgdVgpI4FW2tsMK69wkeiUAquMXv5rDj1XTy1PH3hPHdawIfq
XO63/jqfqSoZ/HU4nzjx0Wu+PH9SG/mK+gHi1wl8giWgyKoRu/28ASp+d8BP
8SsA3s5sJ9+bFOv8qweO5hkfdi6LxQ4PGyALH3VOUSXX/jrBo4Ux9VtRJ8SV
7HfZQtPN3Y/SLfgJDlMG7wTu3SUSfaW7EeF78QuZo4+izMA5Iwbs0FpQW7W9
vNMXR5mgbOI+jLI3/7XXhDXWigiGmVM5Vf9+TYzyrx2ITUKTmyiCQwKTyXJ3
4U+DuTJg3G66Rf0MAYjeh3DOhTtyJs6R3JTles5PUgDl/JiOQUjhy93w0bg0
+fBPZMjQ9A/o+M8FfsyasDPxixpah4pVAMdf0t07ng4vw5PsYuFtxP5bhdh2
49vF4RzW+mrbPnyyqe7MGVWFJoks72vwble8xRE2iZM4UVYl8/FiQMeU8a9z
RNhvUVOVPAGJPmFSR4HP/wG+JYTY\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,149"},
 CellLabel->"Out[3]=",
 CellID->451584944]
}, Open  ]],

Cell["Allow only the Boolean checkbox column to be editable:", "ExampleText",
 CellID->18815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<ScrollPane\>\"", ",", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Dimension\>\"", ",", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<width\>\"", "\[Rule]", "200"}], ",", " ", 
               RowBox[{"\"\<height\>\"", "\[Rule]", "110"}]}], "}"}]}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"\"\<viewportView\>\"", "\[Rule]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Table\>\"", ",", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"\"\<columnEditable\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"True", ",", " ", "False", ",", " ", "False"}], 
                 "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"\"\<items\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"True", ",", "\"\<b1\>\"", ",", "45.0"}], "}"}], 
                  ",", 
                  RowBox[{"{", 
                   RowBox[{"False", ",", "\"\<b2\>\"", ",", "67.9"}], "}"}]}],
                  "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"\"\<model\>\"", ",", 
                 RowBox[{"Name", "->", " ", "\"\<myTableModel\>\""}]}], 
                "]"}]}], "\[IndentingNewLine]", "}"}], ",", " ", 
             RowBox[{"Name", "->", "\"\<myTable\>\""}]}], "]"}]}]}], 
         "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
      "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,150"},
 CellLabel->"In[4]:=",
 CellID->19984],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject483395666706433, 
   JLink`Objects`JavaObject454913339424769]]], "Output",
 CellTags->{"Table", "Ex--21907299533234115765,150"},
 CellLabel->"Out[4]=",
 CellID->26509]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907299533234115765,151",
 CellLabel->"In[5]:=",
 CellID->17974],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907299533234115765,151",
 CellLabel->"Out[5]=",
 CellID->53589102]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sorting",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21885],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->149522330],

Cell["Allow sorting of just the first two columns:", "ExampleText",
 CellID->30960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{
    StyleBox["Widget", "Output"], "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       StyleBox["Widget", "Output"], "[", 
       RowBox[{"\"\<ScrollPane\>\"", ",", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
           RowBox[{
            StyleBox["Widget", "Output"], "[", 
            RowBox[{"\"\<Dimension\>\"", ",", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<width\>\"", "\[Rule]", "200"}], ",", " ", 
               RowBox[{"\"\<height\>\"", "\[Rule]", "110"}]}], "}"}]}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"\"\<viewportView\>\"", "\[Rule]", 
           RowBox[{
            StyleBox["Widget", "Output"], "[", 
            RowBox[{"\"\<Table\>\"", ",", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"\"\<columnSortable\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"True", ",", " ", "True", ",", " ", "False"}], 
                 "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"\"\<items\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"\"\<Alpha\>\"", ",", "65", ",", "True"}], "}"}], 
                  ",", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Beta\>\"", ",", "89", ",", "False"}], "}"}], 
                  ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Gamma\>\"", ",", "40", ",", "True"}], "}"}]}],
                  "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"\"\<model\>\"", ",", 
                 RowBox[{"Name", "->", " ", "\"\<myTableModel\>\""}]}], "]"}],
                ",", "\[IndentingNewLine]", 
               RowBox[{"SetPropertyValue", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<myTableModel\>\"", ",", "\"\<columnIdentifiers\>\""}], 
                  "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<Name\>\"", ",", "\"\<Value\>\"", ",", 
                   "\"\<Display\>\""}], "}"}]}], "]"}], ","}], 
              "\[IndentingNewLine]", "}"}], ",", " ", 
             RowBox[{"Name", "->", "\"\<myTable\>\""}]}], "]"}]}]}], 
         "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", " ", "]"}], 
      "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,152"},
 CellLabel->"In[2]:=",
 CellID->19748],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject195091893321729, 
   JLink`Objects`JavaObject418161119723521]]], "Output",
 CellTags->{"Table", "Ex--21907299533234115765,152"},
 CellLabel->"Out[2]=",
 CellID->23085]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,154"},
 CellLabel->"In[3]:=",
 CellID->5778],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,154"},
 CellLabel->"Out[3]=",
 CellID->189678336]
}, Open  ]],

Cell["After re-sorting:", "ExampleText",
 CellID->8171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,155"},
 CellLabel->"In[4]:=",
 CellID->32505],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,155"},
 CellLabel->"Out[4]=",
 CellID->28579159]
}, Open  ]],

Cell["\<\
Print the new ordering whenever the sort order is changed (useful for \
re-sorting externally stored data): \
\>", "ExampleText",
 CellID->24796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{
    StyleBox["Widget", "Output"], "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        StyleBox["Widget", "Output"], "[", 
        RowBox[{"\"\<ScrollPane\>\"", ",", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
            RowBox[{
             StyleBox["Widget", "Output"], "[", 
             RowBox[{"\"\<Dimension\>\"", ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\"\<width\>\"", "\[Rule]", "200"}], ",", " ", 
                RowBox[{"\"\<height\>\"", "\[Rule]", "110"}]}], "}"}]}], 
             "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"\"\<viewportView\>\"", "\[Rule]", 
            RowBox[{
             StyleBox["Widget", "Output"], "[", 
             RowBox[{"\"\<Table\>\"", ",", 
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"\"\<columnSortable\>\"", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"True", ",", " ", "True", ",", " ", "False"}], 
                  "}"}]}], ",", "\[IndentingNewLine]", 
                RowBox[{"\"\<items\>\"", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"\"\<Alpha\>\"", ",", "65", ",", "True"}], "}"}], 
                   ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<Beta\>\"", ",", "89", ",", "False"}], "}"}], 
                   ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"\"\<Gamma\>\"", ",", "40", ",", "True"}], 
                    "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"\"\<model\>\"", ",", 
                  RowBox[{"Name", "->", " ", "\"\<myTableModel\>\""}]}], 
                 "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"SetPropertyValue", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<myTableModel\>\"", ",", "\"\<columnIdentifiers\>\""}],
                    "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<Name\>\"", ",", "\"\<Value\>\"", ",", 
                    "\"\<Display\>\""}], "}"}]}], "]"}]}], 
               "\[IndentingNewLine]", "}"}], ",", " ", 
              RowBox[{"Name", "->", "\"\<myTable\>\""}]}], "]"}]}]}], 
          "\[IndentingNewLine]", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"BindEvent", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<myTableModel\>\"", ",", "\"\<tableSorted\>\""}], "}"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"Script", "[", 
          RowBox[{"Print", "[", " ", 
           RowBox[{"PropertyValue", "[", 
            RowBox[{"{", 
             RowBox[{"\"\<myTableModel\>\"", ",", "\"\<ordering\>\""}], "}"}],
             "]"}], "]"}], "\[IndentingNewLine]", "]"}]}], " ", "]"}]}], 
      "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,156"},
 CellLabel->"In[5]:=",
 CellID->4172],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject337234322522113, 
   JLink`Objects`JavaObject187949429817345]]], "Output",
 CellTags->{"Table", "Ex--21907299533234115765,156"},
 CellLabel->"Out[5]=",
 CellID->21109]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Data Types",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20731],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->253994663],

Cell["\<\
Construct a table with Booleans in the first column and numbers in the third:\
\
\>", "ExampleText",
 CellID->11670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<ScrollPane\>\"", ",", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Dimension\>\"", ",", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<width\>\"", "\[Rule]", "200"}], ",", " ", 
               RowBox[{"\"\<height\>\"", "\[Rule]", "110"}]}], "}"}]}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"\"\<viewportView\>\"", "\[Rule]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Table\>\"", ",", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"\"\<items\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"True", ",", "\"\<b1\>\"", ",", "45.0"}], "}"}], 
                  ",", 
                  RowBox[{"{", 
                   RowBox[{"False", ",", "\"\<b2\>\"", ",", "67.9"}], "}"}]}],
                  "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"\"\<model\>\"", ",", 
                 RowBox[{"Name", "->", " ", "\"\<myTableModel\>\""}]}], 
                "]"}]}], "\[IndentingNewLine]", "}"}], ",", " ", 
             RowBox[{"Name", "->", "\"\<myTable\>\""}]}], "]"}]}]}], 
         "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
      "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,158"},
 CellLabel->"In[2]:=",
 CellID->3525],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject441141744893953, 
   JLink`Objects`JavaObject249083960754177]]], "Output",
 CellTags->{"Table", "Ex--21907299533234115765,158"},
 CellLabel->"Out[2]=",
 CellID->10184]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,159"},
 CellLabel->"In[3]:=",
 CellID->15802],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,159"},
 CellLabel->"Out[3]=",
 CellID->69687140]
}, Open  ]],

Cell["Get the values in appropriate forms:", "ExampleText",
 CellID->13746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "@", " ", 
   RowBox[{"PropertyValue", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<myTable\>\"", ",", " ", "\"\<items\>\""}], "}"}], "]"}]}], 
  " ", "//", " ", "InputForm"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,160"},
 CellLabel->"In[4]:=",
 CellID->19688],

Cell["{{True, \"b1\", 45.}, {False, \"b2\", 67.9}}", "Output",
 CellTags->{"Table", "Ex--21907299533234115765,160"},
 CellLabel->"Out[4]//InputForm=",
 CellID->5352]
}, Open  ]],

Cell[TextData[{
 "Use the ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"prototype\", \"TI\"]\)\>\""], "InlineFormula"],
 " property to override the default rendering for a data type:"
}], "ExampleText",
 CellID->9197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<ScrollPane\>\"", ",", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Dimension\>\"", ",", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<width\>\"", "\[Rule]", "200"}], ",", " ", 
               RowBox[{"\"\<height\>\"", "\[Rule]", "110"}]}], "}"}]}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"\"\<viewportView\>\"", "\[Rule]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Table\>\"", ",", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"\"\<prototype\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<a\>\"", ",", "\"\<a\>\"", ",", "\"\<a\>\""}], 
                 "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"\"\<items\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"True", ",", "\"\<b1\>\"", ",", "45.0"}], "}"}], 
                  ",", 
                  RowBox[{"{", 
                   RowBox[{"False", ",", "\"\<b2\>\"", ",", "67.9"}], "}"}]}],
                  "}"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"\"\<model\>\"", ",", 
                 RowBox[{"Name", "->", " ", "\"\<myTableModel\>\""}]}], 
                "]"}]}], "\[IndentingNewLine]", "}"}], ",", " ", 
             RowBox[{"Name", "->", "\"\<myTable\>\""}]}], "]"}]}]}], 
         "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
      "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,161"},
 CellLabel->"In[5]:=",
 CellID->20989],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject276051322208257, 
   JLink`Objects`JavaObject196265795125249]]], "Output",
 CellTags->{"Table", "Ex--21907299533234115765,161"},
 CellLabel->"Out[5]=",
 CellID->17895]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Table", "Ex--21907299533234115765,162"},
 CellLabel->"In[6]:=",
 CellID->398],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Table", "Ex--21907299533234115765,162"},
 CellLabel->"Out[6]=",
 CellID->93373015]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30921],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TableForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14960]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10468],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"Table\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 47.8353850}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"Table\"Widget[\"Table\"] represents a table.", 
    "synonyms" -> {}, "title" -> "Table", "type" -> "Widget", "uri" -> 
    "GUIKit/widget/Table"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Table"->{
  Cell[3012, 104, 353, 7, 70, "Notes",
   CellTags->"Table",
   CellID->23833],
  Cell[3718, 126, 398, 9, 70, "Notes",
   CellTags->"Table",
   CellID->24688],
  Cell[6982, 222, 498, 14, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,120"},
   CellID->10342],
  Cell[7505, 240, 159, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,121"},
   CellID->630],
  Cell[7667, 246, 7519, 127, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,121"},
   CellID->22887079],
  Cell[15307, 381, 2049, 47, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,123"},
   CellID->17720],
  Cell[17359, 430, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,123"},
   CellID->10198],
  Cell[17716, 443, 161, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,124"},
   CellID->28527],
  Cell[17880, 449, 8400, 142, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,124"},
   CellID->364472226],
  Cell[26389, 599, 278, 8, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,125"},
   CellID->21382],
  Cell[26670, 609, 345, 11, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,125"},
   CellID->12425],
  Cell[27100, 626, 634, 19, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,126"},
   CellID->16612],
  Cell[27759, 649, 160, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,127"},
   CellID->3192],
  Cell[27922, 655, 9055, 153, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,127"},
   CellID->209479745],
  Cell[37014, 813, 287, 8, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,128"},
   CellID->14938],
  Cell[37304, 823, 218, 6, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,128"},
   CellID->25005],
  Cell[37537, 832, 441, 12, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,129"},
   CellID->26866],
  Cell[38003, 848, 162, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,130"},
   CellID->16666],
  Cell[38168, 854, 8958, 151, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,130"},
   CellID->545526408],
  Cell[47208, 1011, 453, 12, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,131"},
   CellID->6964],
  Cell[47686, 1027, 162, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,132"},
   CellID->27541],
  Cell[47851, 1033, 9129, 154, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,132"},
   CellID->113928888],
  Cell[57168, 1198, 404, 12, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,133"},
   CellID->1935],
  Cell[57597, 1214, 162, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,134"},
   CellID->12733],
  Cell[57762, 1220, 9267, 156, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,134"},
   CellID->342225268],
  Cell[67098, 1382, 472, 13, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,135"},
   CellID->23076],
  Cell[67595, 1399, 162, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,136"},
   CellID->15292],
  Cell[67760, 1405, 9559, 161, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,136"},
   CellID->94539290],
  Cell[77388, 1572, 314, 9, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,137"},
   CellID->15596],
  Cell[77727, 1585, 161, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,138"},
   CellID->9527],
  Cell[77891, 1591, 9453, 159, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,138"},
   CellID->15564236],
  Cell[87359, 1753, 422, 12, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,139"},
   CellID->4287],
  Cell[87806, 1769, 162, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,140"},
   CellID->12027],
  Cell[87971, 1775, 9551, 161, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,140"},
   CellID->62046626],
  Cell[97635, 1944, 330, 9, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,141"},
   CellID->11127],
  Cell[97968, 1955, 135, 3, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,141"},
   CellID->24837],
  Cell[98118, 1961, 351, 9, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,142"},
   CellID->29710],
  Cell[98494, 1974, 162, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,143"},
   CellID->16583],
  Cell[98659, 1980, 9633, 162, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,143"},
   CellID->167550811],
  Cell[109311, 2188, 2216, 50, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,145"},
   CellID->8853],
  Cell[111530, 2240, 319, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,145"},
   CellID->21930],
  Cell[111886, 2253, 160, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,146"},
   CellID->5408],
  Cell[112049, 2259, 8078, 137, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,146"},
   CellID->50356114],
  Cell[120867, 2431, 3185, 68, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,148"},
   CellID->2670],
  Cell[124055, 2501, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,148"},
   CellID->15416],
  Cell[124412, 2514, 160, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,149"},
   CellID->3063],
  Cell[124575, 2520, 8957, 151, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,149"},
   CellID->451584944],
  Cell[133665, 2679, 2084, 45, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,150"},
   CellID->19984],
  Cell[135752, 2726, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,150"},
   CellID->26509],
  Cell[145520, 2918, 2863, 64, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,152"},
   CellID->19748],
  Cell[148386, 2984, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,152"},
   CellID->23085],
  Cell[148743, 2997, 160, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,154"},
   CellID->5778],
  Cell[148906, 3003, 9567, 161, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,154"},
   CellID->189678336],
  Cell[158568, 3172, 161, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,155"},
   CellID->32505],
  Cell[158732, 3178, 9566, 161, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,155"},
   CellID->28579159],
  Cell[168493, 3350, 3412, 76, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,156"},
   CellID->4172],
  Cell[171908, 3428, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,156"},
   CellID->21109],
  Cell[172790, 3464, 1863, 41, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,158"},
   CellID->3525],
  Cell[174656, 3507, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,158"},
   CellID->10184],
  Cell[175013, 3520, 161, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,159"},
   CellID->15802],
  Cell[175177, 3526, 8753, 148, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,159"},
   CellID->69687140],
  Cell[184045, 3682, 322, 9, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,160"},
   CellID->19688],
  Cell[184370, 3693, 165, 3, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,160"},
   CellID->5352],
  Cell[184786, 3709, 2082, 45, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,161"},
   CellID->20989],
  Cell[186871, 3756, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,161"},
   CellID->17895],
  Cell[187228, 3769, 159, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,162"},
   CellID->398],
  Cell[187390, 3775, 8549, 144, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,162"},
   CellID->93373015]},
 "PrimaryExamplesSection"->{
  Cell[6315, 196, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->90968459]},
 "Ex--21907299533234115765,120"->{
  Cell[6982, 222, 498, 14, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,120"},
   CellID->10342]},
 "Ex--21907299533234115765,121"->{
  Cell[7505, 240, 159, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,121"},
   CellID->630],
  Cell[7667, 246, 7519, 127, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,121"},
   CellID->22887079]},
 "Ex--21907299533234115765,123"->{
  Cell[15307, 381, 2049, 47, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,123"},
   CellID->17720],
  Cell[17359, 430, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,123"},
   CellID->10198]},
 "Ex--21907299533234115765,124"->{
  Cell[17716, 443, 161, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,124"},
   CellID->28527],
  Cell[17880, 449, 8400, 142, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,124"},
   CellID->364472226]},
 "Ex--21907299533234115765,125"->{
  Cell[26389, 599, 278, 8, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,125"},
   CellID->21382],
  Cell[26670, 609, 345, 11, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,125"},
   CellID->12425]},
 "Ex--21907299533234115765,126"->{
  Cell[27100, 626, 634, 19, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,126"},
   CellID->16612]},
 "Ex--21907299533234115765,127"->{
  Cell[27759, 649, 160, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,127"},
   CellID->3192],
  Cell[27922, 655, 9055, 153, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,127"},
   CellID->209479745]},
 "Ex--21907299533234115765,128"->{
  Cell[37014, 813, 287, 8, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,128"},
   CellID->14938],
  Cell[37304, 823, 218, 6, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,128"},
   CellID->25005]},
 "Ex--21907299533234115765,129"->{
  Cell[37537, 832, 441, 12, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,129"},
   CellID->26866]},
 "Ex--21907299533234115765,130"->{
  Cell[38003, 848, 162, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,130"},
   CellID->16666],
  Cell[38168, 854, 8958, 151, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,130"},
   CellID->545526408]},
 "Ex--21907299533234115765,131"->{
  Cell[47208, 1011, 453, 12, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,131"},
   CellID->6964]},
 "Ex--21907299533234115765,132"->{
  Cell[47686, 1027, 162, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,132"},
   CellID->27541],
  Cell[47851, 1033, 9129, 154, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,132"},
   CellID->113928888]},
 "Ex--21907299533234115765,133"->{
  Cell[57168, 1198, 404, 12, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,133"},
   CellID->1935]},
 "Ex--21907299533234115765,134"->{
  Cell[57597, 1214, 162, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,134"},
   CellID->12733],
  Cell[57762, 1220, 9267, 156, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,134"},
   CellID->342225268]},
 "Ex--21907299533234115765,135"->{
  Cell[67098, 1382, 472, 13, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,135"},
   CellID->23076]},
 "Ex--21907299533234115765,136"->{
  Cell[67595, 1399, 162, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,136"},
   CellID->15292],
  Cell[67760, 1405, 9559, 161, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,136"},
   CellID->94539290]},
 "Ex--21907299533234115765,137"->{
  Cell[77388, 1572, 314, 9, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,137"},
   CellID->15596]},
 "Ex--21907299533234115765,138"->{
  Cell[77727, 1585, 161, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,138"},
   CellID->9527],
  Cell[77891, 1591, 9453, 159, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,138"},
   CellID->15564236]},
 "Ex--21907299533234115765,139"->{
  Cell[87359, 1753, 422, 12, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,139"},
   CellID->4287]},
 "Ex--21907299533234115765,140"->{
  Cell[87806, 1769, 162, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,140"},
   CellID->12027],
  Cell[87971, 1775, 9551, 161, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,140"},
   CellID->62046626]},
 "Ex--21907299533234115765,141"->{
  Cell[97635, 1944, 330, 9, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,141"},
   CellID->11127],
  Cell[97968, 1955, 135, 3, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,141"},
   CellID->24837]},
 "Ex--21907299533234115765,142"->{
  Cell[98118, 1961, 351, 9, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,142"},
   CellID->29710]},
 "Ex--21907299533234115765,143"->{
  Cell[98494, 1974, 162, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,143"},
   CellID->16583],
  Cell[98659, 1980, 9633, 162, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,143"},
   CellID->167550811]},
 "Ex--21907299533234115765,145"->{
  Cell[109311, 2188, 2216, 50, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,145"},
   CellID->8853],
  Cell[111530, 2240, 319, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,145"},
   CellID->21930]},
 "Ex--21907299533234115765,146"->{
  Cell[111886, 2253, 160, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,146"},
   CellID->5408],
  Cell[112049, 2259, 8078, 137, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,146"},
   CellID->50356114]},
 "Ex--21907299533234115765,148"->{
  Cell[120867, 2431, 3185, 68, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,148"},
   CellID->2670],
  Cell[124055, 2501, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,148"},
   CellID->15416]},
 "Ex--21907299533234115765,149"->{
  Cell[124412, 2514, 160, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,149"},
   CellID->3063],
  Cell[124575, 2520, 8957, 151, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,149"},
   CellID->451584944]},
 "Ex--21907299533234115765,150"->{
  Cell[133665, 2679, 2084, 45, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,150"},
   CellID->19984],
  Cell[135752, 2726, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,150"},
   CellID->26509]},
 "Ex--21907299533234115765,151"->{
  Cell[136109, 2739, 150, 4, 70, "Input",
   CellTags->"Ex--21907299533234115765,151",
   CellID->17974],
  Cell[136262, 2745, 8742, 148, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907299533234115765,151",
   CellID->53589102]},
 "Ex--21907299533234115765,152"->{
  Cell[145520, 2918, 2863, 64, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,152"},
   CellID->19748],
  Cell[148386, 2984, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,152"},
   CellID->23085]},
 "Ex--21907299533234115765,154"->{
  Cell[148743, 2997, 160, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,154"},
   CellID->5778],
  Cell[148906, 3003, 9567, 161, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,154"},
   CellID->189678336]},
 "Ex--21907299533234115765,155"->{
  Cell[158568, 3172, 161, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,155"},
   CellID->32505],
  Cell[158732, 3178, 9566, 161, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,155"},
   CellID->28579159]},
 "Ex--21907299533234115765,156"->{
  Cell[168493, 3350, 3412, 76, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,156"},
   CellID->4172],
  Cell[171908, 3428, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,156"},
   CellID->21109]},
 "Ex--21907299533234115765,158"->{
  Cell[172790, 3464, 1863, 41, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,158"},
   CellID->3525],
  Cell[174656, 3507, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,158"},
   CellID->10184]},
 "Ex--21907299533234115765,159"->{
  Cell[175013, 3520, 161, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,159"},
   CellID->15802],
  Cell[175177, 3526, 8753, 148, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,159"},
   CellID->69687140]},
 "Ex--21907299533234115765,160"->{
  Cell[184045, 3682, 322, 9, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,160"},
   CellID->19688],
  Cell[184370, 3693, 165, 3, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,160"},
   CellID->5352]},
 "Ex--21907299533234115765,161"->{
  Cell[184786, 3709, 2082, 45, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,161"},
   CellID->20989],
  Cell[186871, 3756, 320, 8, 70, "Output",
   CellTags->{"Table", "Ex--21907299533234115765,161"},
   CellID->17895]},
 "Ex--21907299533234115765,162"->{
  Cell[187228, 3769, 159, 4, 70, "Input",
   CellTags->{"Table", "Ex--21907299533234115765,162"},
   CellID->398],
  Cell[187390, 3775, 8549, 144, 70, "Output",
   Evaluatable->False,
   CellTags->{"Table", "Ex--21907299533234115765,162"},
   CellID->93373015]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Table", 198426, 4009},
 {"PrimaryExamplesSection", 206671, 4227},
 {"Ex--21907299533234115765,120", 206825, 4231},
 {"Ex--21907299533234115765,121", 206976, 4235},
 {"Ex--21907299533234115765,123", 207268, 4243},
 {"Ex--21907299533234115765,124", 207537, 4250},
 {"Ex--21907299533234115765,125", 207834, 4258},
 {"Ex--21907299533234115765,126", 208102, 4265},
 {"Ex--21907299533234115765,127", 208254, 4269},
 {"Ex--21907299533234115765,128", 208550, 4277},
 {"Ex--21907299533234115765,129", 208817, 4284},
 {"Ex--21907299533234115765,130", 208969, 4288},
 {"Ex--21907299533234115765,131", 209266, 4296},
 {"Ex--21907299533234115765,132", 209418, 4300},
 {"Ex--21907299533234115765,133", 209717, 4308},
 {"Ex--21907299533234115765,134", 209869, 4312},
 {"Ex--21907299533234115765,135", 210168, 4320},
 {"Ex--21907299533234115765,136", 210321, 4324},
 {"Ex--21907299533234115765,137", 210619, 4332},
 {"Ex--21907299533234115765,138", 210771, 4336},
 {"Ex--21907299533234115765,139", 211068, 4344},
 {"Ex--21907299533234115765,140", 211220, 4348},
 {"Ex--21907299533234115765,141", 211518, 4356},
 {"Ex--21907299533234115765,142", 211787, 4363},
 {"Ex--21907299533234115765,143", 211939, 4367},
 {"Ex--21907299533234115765,145", 212238, 4375},
 {"Ex--21907299533234115765,146", 212510, 4382},
 {"Ex--21907299533234115765,148", 212809, 4390},
 {"Ex--21907299533234115765,149", 213081, 4397},
 {"Ex--21907299533234115765,150", 213381, 4405},
 {"Ex--21907299533234115765,151", 213654, 4412},
 {"Ex--21907299533234115765,152", 213932, 4420},
 {"Ex--21907299533234115765,154", 214205, 4427},
 {"Ex--21907299533234115765,155", 214505, 4435},
 {"Ex--21907299533234115765,156", 214805, 4443},
 {"Ex--21907299533234115765,158", 215077, 4450},
 {"Ex--21907299533234115765,159", 215349, 4457},
 {"Ex--21907299533234115765,160", 215649, 4465},
 {"Ex--21907299533234115765,161", 215919, 4472},
 {"Ex--21907299533234115765,162", 216192, 4479}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1246, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1869, 59, 47, 1, 70, "ObjectName",
 CellID->17368],
Cell[1919, 62, 359, 11, 70, "Usage",
 CellID->12048]
}, Open  ]],
Cell[CellGroupData[{
Cell[2315, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2793, 95, 216, 7, 70, "Notes",
 CellID->15781],
Cell[3012, 104, 353, 7, 70, "Notes",
 CellTags->"Table",
 CellID->23833],
Cell[3368, 113, 347, 11, 70, "Notes",
 CellID->10574],
Cell[3718, 126, 398, 9, 70, "Notes",
 CellTags->"Table",
 CellID->24688],
Cell[4119, 137, 72, 1, 70, "Notes",
 CellID->21884],
Cell[4194, 140, 2084, 51, 70, "3ColumnTableMod",
 CellID->7668]
}, Closed]],
Cell[CellGroupData[{
Cell[6315, 196, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->90968459],
Cell[CellGroupData[{
Cell[6699, 210, 148, 5, 70, "ExampleSection",
 CellID->203585120],
Cell[6850, 217, 129, 3, 70, "Input",
 CellID->499352286],
Cell[6982, 222, 498, 14, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,120"},
 CellID->10342],
Cell[CellGroupData[{
Cell[7505, 240, 159, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,121"},
 CellID->630],
Cell[7667, 246, 7519, 127, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,121"},
 CellID->22887079]
}, Open  ]],
Cell[15201, 376, 81, 1, 70, "ExampleText",
 CellID->19451],
Cell[CellGroupData[{
Cell[15307, 381, 2049, 47, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,123"},
 CellID->17720],
Cell[17359, 430, 320, 8, 70, "Output",
 CellTags->{"Table", "Ex--21907299533234115765,123"},
 CellID->10198]
}, Open  ]],
Cell[CellGroupData[{
Cell[17716, 443, 161, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,124"},
 CellID->28527],
Cell[17880, 449, 8400, 142, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,124"},
 CellID->364472226]
}, Open  ]],
Cell[26295, 594, 69, 1, 70, "ExampleText",
 CellID->24405],
Cell[CellGroupData[{
Cell[26389, 599, 278, 8, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,125"},
 CellID->21382],
Cell[26670, 609, 345, 11, 70, "Output",
 CellTags->{"Table", "Ex--21907299533234115765,125"},
 CellID->12425]
}, Open  ]],
Cell[27030, 623, 67, 1, 70, "ExampleText",
 CellID->21614],
Cell[27100, 626, 634, 19, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,126"},
 CellID->16612],
Cell[CellGroupData[{
Cell[27759, 649, 160, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,127"},
 CellID->3192],
Cell[27922, 655, 9055, 153, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,127"},
 CellID->209479745]
}, Open  ]],
Cell[CellGroupData[{
Cell[37014, 813, 287, 8, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,128"},
 CellID->14938],
Cell[37304, 823, 218, 6, 70, "Output",
 CellTags->{"Table", "Ex--21907299533234115765,128"},
 CellID->25005]
}, Open  ]],
Cell[37537, 832, 441, 12, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,129"},
 CellID->26866],
Cell[CellGroupData[{
Cell[38003, 848, 162, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,130"},
 CellID->16666],
Cell[38168, 854, 8958, 151, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,130"},
 CellID->545526408]
}, Open  ]],
Cell[47141, 1008, 64, 1, 70, "ExampleText",
 CellID->3080],
Cell[47208, 1011, 453, 12, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,131"},
 CellID->6964],
Cell[CellGroupData[{
Cell[47686, 1027, 162, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,132"},
 CellID->27541],
Cell[47851, 1033, 9129, 154, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,132"},
 CellID->113928888]
}, Open  ]],
Cell[56995, 1190, 170, 6, 70, "ExampleText",
 CellID->7886],
Cell[57168, 1198, 404, 12, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,133"},
 CellID->1935],
Cell[CellGroupData[{
Cell[57597, 1214, 162, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,134"},
 CellID->12733],
Cell[57762, 1220, 9267, 156, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,134"},
 CellID->342225268]
}, Open  ]],
Cell[67044, 1379, 51, 1, 70, "ExampleText",
 CellID->10724],
Cell[67098, 1382, 472, 13, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,135"},
 CellID->23076],
Cell[CellGroupData[{
Cell[67595, 1399, 162, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,136"},
 CellID->15292],
Cell[67760, 1405, 9559, 161, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,136"},
 CellID->94539290]
}, Open  ]],
Cell[77334, 1569, 51, 1, 70, "ExampleText",
 CellID->30951],
Cell[77388, 1572, 314, 9, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,137"},
 CellID->15596],
Cell[CellGroupData[{
Cell[77727, 1585, 161, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,138"},
 CellID->9527],
Cell[77891, 1591, 9453, 159, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,138"},
 CellID->15564236]
}, Open  ]],
Cell[87359, 1753, 422, 12, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,139"},
 CellID->4287],
Cell[CellGroupData[{
Cell[87806, 1769, 162, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,140"},
 CellID->12027],
Cell[87971, 1775, 9551, 161, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,140"},
 CellID->62046626]
}, Open  ]],
Cell[97537, 1939, 73, 1, 70, "ExampleText",
 CellID->10805],
Cell[CellGroupData[{
Cell[97635, 1944, 330, 9, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,141"},
 CellID->11127],
Cell[97968, 1955, 135, 3, 70, "Output",
 CellTags->{"Table", "Ex--21907299533234115765,141"},
 CellID->24837]
}, Open  ]],
Cell[98118, 1961, 351, 9, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,142"},
 CellID->29710],
Cell[CellGroupData[{
Cell[98494, 1974, 162, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,143"},
 CellID->16583],
Cell[98659, 1980, 9633, 162, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,143"},
 CellID->167550811]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[108341, 2148, 233, 7, 70, "ExampleSection",
 CellID->30080],
Cell[CellGroupData[{
Cell[108599, 2159, 230, 7, 70, "ExampleSubsection",
 CellID->16434],
Cell[108832, 2168, 129, 3, 70, "Input",
 CellID->356797873],
Cell[108964, 2173, 322, 11, 70, "ExampleText",
 CellID->22229],
Cell[CellGroupData[{
Cell[109311, 2188, 2216, 50, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,145"},
 CellID->8853],
Cell[111530, 2240, 319, 8, 70, "Output",
 CellTags->{"Table", "Ex--21907299533234115765,145"},
 CellID->21930]
}, Open  ]],
Cell[CellGroupData[{
Cell[111886, 2253, 160, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,146"},
 CellID->5408],
Cell[112049, 2259, 8078, 137, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,146"},
 CellID->50356114]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[120176, 2402, 227, 7, 70, "ExampleSubsection",
 CellID->7448],
Cell[120406, 2411, 129, 3, 70, "Input",
 CellID->337910415],
Cell[120538, 2416, 304, 11, 70, "ExampleText",
 CellID->19141],
Cell[CellGroupData[{
Cell[120867, 2431, 3185, 68, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,148"},
 CellID->2670],
Cell[124055, 2501, 320, 8, 70, "Output",
 CellTags->{"Table", "Ex--21907299533234115765,148"},
 CellID->15416]
}, Open  ]],
Cell[CellGroupData[{
Cell[124412, 2514, 160, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,149"},
 CellID->3063],
Cell[124575, 2520, 8957, 151, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,149"},
 CellID->451584944]
}, Open  ]],
Cell[133547, 2674, 93, 1, 70, "ExampleText",
 CellID->18815],
Cell[CellGroupData[{
Cell[133665, 2679, 2084, 45, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,150"},
 CellID->19984],
Cell[135752, 2726, 320, 8, 70, "Output",
 CellTags->{"Table", "Ex--21907299533234115765,150"},
 CellID->26509]
}, Open  ]],
Cell[CellGroupData[{
Cell[136109, 2739, 150, 4, 70, "Input",
 CellTags->"Ex--21907299533234115765,151",
 CellID->17974],
Cell[136262, 2745, 8742, 148, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907299533234115765,151",
 CellID->53589102]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[145053, 2899, 224, 7, 70, "ExampleSubsection",
 CellID->21885],
Cell[145280, 2908, 129, 3, 70, "Input",
 CellID->149522330],
Cell[145412, 2913, 83, 1, 70, "ExampleText",
 CellID->30960],
Cell[CellGroupData[{
Cell[145520, 2918, 2863, 64, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,152"},
 CellID->19748],
Cell[148386, 2984, 320, 8, 70, "Output",
 CellTags->{"Table", "Ex--21907299533234115765,152"},
 CellID->23085]
}, Open  ]],
Cell[CellGroupData[{
Cell[148743, 2997, 160, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,154"},
 CellID->5778],
Cell[148906, 3003, 9567, 161, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,154"},
 CellID->189678336]
}, Open  ]],
Cell[158488, 3167, 55, 1, 70, "ExampleText",
 CellID->8171],
Cell[CellGroupData[{
Cell[158568, 3172, 161, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,155"},
 CellID->32505],
Cell[158732, 3178, 9566, 161, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,155"},
 CellID->28579159]
}, Open  ]],
Cell[168313, 3342, 155, 4, 70, "ExampleText",
 CellID->24796],
Cell[CellGroupData[{
Cell[168493, 3350, 3412, 76, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,156"},
 CellID->4172],
Cell[171908, 3428, 320, 8, 70, "Output",
 CellTags->{"Table", "Ex--21907299533234115765,156"},
 CellID->21109]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[172277, 3442, 227, 7, 70, "ExampleSubsection",
 CellID->20731],
Cell[172507, 3451, 129, 3, 70, "Input",
 CellID->253994663],
Cell[172639, 3456, 126, 4, 70, "ExampleText",
 CellID->11670],
Cell[CellGroupData[{
Cell[172790, 3464, 1863, 41, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,158"},
 CellID->3525],
Cell[174656, 3507, 320, 8, 70, "Output",
 CellTags->{"Table", "Ex--21907299533234115765,158"},
 CellID->10184]
}, Open  ]],
Cell[CellGroupData[{
Cell[175013, 3520, 161, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,159"},
 CellID->15802],
Cell[175177, 3526, 8753, 148, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,159"},
 CellID->69687140]
}, Open  ]],
Cell[183945, 3677, 75, 1, 70, "ExampleText",
 CellID->13746],
Cell[CellGroupData[{
Cell[184045, 3682, 322, 9, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,160"},
 CellID->19688],
Cell[184370, 3693, 165, 3, 70, "Output",
 CellTags->{"Table", "Ex--21907299533234115765,160"},
 CellID->5352]
}, Open  ]],
Cell[184550, 3699, 211, 6, 70, "ExampleText",
 CellID->9197],
Cell[CellGroupData[{
Cell[184786, 3709, 2082, 45, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,161"},
 CellID->20989],
Cell[186871, 3756, 320, 8, 70, "Output",
 CellTags->{"Table", "Ex--21907299533234115765,161"},
 CellID->17895]
}, Open  ]],
Cell[CellGroupData[{
Cell[187228, 3769, 159, 4, 70, "Input",
 CellTags->{"Table", "Ex--21907299533234115765,162"},
 CellID->398],
Cell[187390, 3775, 8549, 144, 70, "Output",
 Evaluatable->False,
 CellTags->{"Table", "Ex--21907299533234115765,162"},
 CellID->93373015]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[196012, 3927, 311, 9, 70, "SeeAlsoSection",
 CellID->30921],
Cell[196326, 3938, 456, 17, 70, "SeeAlso",
 CellID->14960]
}, Open  ]],
Cell[CellGroupData[{
Cell[196819, 3960, 314, 9, 70, "TutorialsSection",
 CellID->10468],
Cell[197136, 3971, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[197420, 3983, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

