(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19766,        532]
NotebookOptionsPosition[     15763,        406]
NotebookOutlinePosition[     18202,        476]
CellTagsIndexPosition[     17968,        467]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "InputField" :> 
          Documentation`HelpLookup["paclet:ref/InputField"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"InputField\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"TextArea\"", "ObjectName",
 CellID->17901],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<TextArea\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a text area."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->189]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox[
   RowBox[{"Widget", "[", "\"\<TextField\>\"", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/TextField"]], "InlineFormula"],
 " is typically used for single line input using a single font, while ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<TextArea\>\"", "]"}]], "InlineFormula"],
 " would typically be used to display or take multiple line input also in a \
single font style."
}], "Notes",
 CellTags->"TextPanel",
 CellID->22216],

Cell["The following properties are available:", "Notes",
 CellID->25956],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", "\"\<\>\"", Cell[
    "the contents of the text area", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"rows\", \"TI\"]\)\>\"", "0", Cell[
    "the number of rows", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"columns\", \"TI\"]\)\>\"", "0", Cell[
    "the number of columns", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"lineWrap\", \"TI\"]\)\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to line wrap", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->23239]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30828516],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->31874915],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->147934943],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<TextArea\>\"", ",", " ", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
        "\"\<text\>\"", "->", "\"\<Multiple lines of running text\>\""}], ",",
         " ", "\[IndentingNewLine]", 
        RowBox[{"\"\<rows\>\"", "\[Rule]", "4"}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"\"\<lineWrap\>\"", "\[Rule]", "True"}]}], "}"}]}], "]"}], 
    " ", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"TextArea", "Ex--21907299533234115765,170"},
 CellLabel->"In[2]:=",
 CellID->25530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"TextArea", "Ex--21907299533234115765,171"},
 CellLabel->"In[3]:=",
 CellID->4605],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{131, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"TextArea", "Ex--21907299533234115765,171"},
 CellLabel->"Out[3]=",
 CellID->451239843],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"TextArea",
 CellLabel->"Out[3]=",
 CellID->3799]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20421],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputField"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8716]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23725],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"TextArea\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 50.2258876}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"TextArea\"Widget[\"TextArea\"] represents a text area.", 
    "synonyms" -> {"text area"}, "title" -> "TextArea", "type" -> "Widget", 
    "uri" -> "GUIKit/widget/TextArea"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "TextPanel"->{
  Cell[2804, 95, 502, 13, 70, "Notes",
   CellTags->"TextPanel",
   CellID->22216]},
 "PrimaryExamplesSection"->{
  Cell[4354, 140, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->30828516]},
 "TextArea"->{
  Cell[5020, 166, 689, 17, 70, "Input",
   CellTags->{"TextArea", "Ex--21907299533234115765,170"},
   CellID->25530],
  Cell[5734, 187, 163, 4, 70, "Input",
   CellTags->{"TextArea", "Ex--21907299533234115765,171"},
   CellID->4605],
  Cell[5900, 193, 8118, 137, 70, "Output",
   Evaluatable->False,
   CellTags->{"TextArea", "Ex--21907299533234115765,171"},
   CellID->451239843],
  Cell[14021, 332, 245, 9, 70, "Output",
   CellTags->"TextArea",
   CellID->3799]},
 "Ex--21907299533234115765,170"->{
  Cell[5020, 166, 689, 17, 70, "Input",
   CellTags->{"TextArea", "Ex--21907299533234115765,170"},
   CellID->25530]},
 "Ex--21907299533234115765,171"->{
  Cell[5734, 187, 163, 4, 70, "Input",
   CellTags->{"TextArea", "Ex--21907299533234115765,171"},
   CellID->4605],
  Cell[5900, 193, 8118, 137, 70, "Output",
   Evaluatable->False,
   CellTags->{"TextArea", "Ex--21907299533234115765,171"},
   CellID->451239843]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"TextPanel", 16776, 430},
 {"PrimaryExamplesSection", 16890, 434},
 {"TextArea", 17024, 438},
 {"Ex--21907299533234115765,170", 17526, 452},
 {"Ex--21907299533234115765,171", 17680, 456}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1249, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1872, 59, 50, 1, 70, "ObjectName",
 CellID->17901],
Cell[1925, 62, 364, 11, 70, "Usage",
 CellID->189]
}, Open  ]],
Cell[CellGroupData[{
Cell[2326, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2804, 95, 502, 13, 70, "Notes",
 CellTags->"TextPanel",
 CellID->22216],
Cell[3309, 110, 72, 1, 70, "Notes",
 CellID->25956],
Cell[3384, 113, 933, 22, 70, "3ColumnTableMod",
 CellID->23239]
}, Closed]],
Cell[CellGroupData[{
Cell[4354, 140, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30828516],
Cell[CellGroupData[{
Cell[4738, 154, 147, 5, 70, "ExampleSection",
 CellID->31874915],
Cell[4888, 161, 129, 3, 70, "Input",
 CellID->147934943],
Cell[5020, 166, 689, 17, 70, "Input",
 CellTags->{"TextArea", "Ex--21907299533234115765,170"},
 CellID->25530],
Cell[CellGroupData[{
Cell[5734, 187, 163, 4, 70, "Input",
 CellTags->{"TextArea", "Ex--21907299533234115765,171"},
 CellID->4605],
Cell[5900, 193, 8118, 137, 70, "Output",
 Evaluatable->False,
 CellTags->{"TextArea", "Ex--21907299533234115765,171"},
 CellID->451239843],
Cell[14021, 332, 245, 9, 70, "Output",
 CellTags->"TextArea",
 CellID->3799]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14327, 348, 311, 9, 70, "SeeAlsoSection",
 CellID->20421],
Cell[14641, 359, 457, 17, 70, "SeeAlso",
 CellID->8716]
}, Open  ]],
Cell[CellGroupData[{
Cell[15135, 381, 314, 9, 70, "TutorialsSection",
 CellID->23725],
Cell[15452, 392, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[15736, 404, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

