(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18361,        497]
NotebookOptionsPosition[     14585,        380]
NotebookOutlinePosition[     16832,        443]
CellTagsIndexPosition[     16625,        435]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "InputField" :> 
          Documentation`HelpLookup["paclet:ref/InputField"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"InputField\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"TextField\"", "ObjectName",
 CellID->15089],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<TextField\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a text field."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7688]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following properties are available:", "Notes",
 CellID->22414],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", "\"\<\>\"", Cell[
    "text content ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"enabled\", \"TI\"]\)\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the text field is enabled", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->12296],

Cell["The following event is available: ", "Notes",
 CellID->20268],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"action\", \"TI\"]\)\>\"", Cell[TextData[{
     "the event ",
     "triggered when ",
     StyleBox["Return", "KeyEvent"],
     " is pressed"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->4346]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->418771138],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->188201022],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->12950453],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<TextField\>\"", ",", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<text\>\"", "->", "\"\<Enter text here\>\""}], "}"}]}], 
     "]"}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"TextField", "Ex--21907299533234115765,173"},
 CellLabel->"In[2]:=",
 CellID->29907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"TextField", "Ex--21907299533234115765,174"},
 CellLabel->"In[3]:=",
 CellID->3670],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"TextField", "Ex--21907299533234115765,174"},
 CellLabel->"Out[3]=",
 CellID->486484801]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10797],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputField"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30825]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25358],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"TextField\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 51.3352058}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "\"TextField\"Widget[\"TextField\"] represents a text field.", 
    "synonyms" -> {"text field"}, "title" -> "TextField", "type" -> "Widget", 
    "uri" -> "GUIKit/widget/TextField"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4088, 138, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->418771138]},
 "TextField"->{
  Cell[4755, 164, 433, 11, 70, "Input",
   CellTags->{"TextField", "Ex--21907299533234115765,173"},
   CellID->29907],
  Cell[5213, 179, 164, 4, 70, "Input",
   CellTags->{"TextField", "Ex--21907299533234115765,174"},
   CellID->3670],
  Cell[5380, 185, 7707, 130, 70, "Output",
   Evaluatable->False,
   CellTags->{"TextField", "Ex--21907299533234115765,174"},
   CellID->486484801]},
 "Ex--21907299533234115765,173"->{
  Cell[4755, 164, 433, 11, 70, "Input",
   CellTags->{"TextField", "Ex--21907299533234115765,173"},
   CellID->29907]},
 "Ex--21907299533234115765,174"->{
  Cell[5213, 179, 164, 4, 70, "Input",
   CellTags->{"TextField", "Ex--21907299533234115765,174"},
   CellID->3670],
  Cell[5380, 185, 7707, 130, 70, "Output",
   Evaluatable->False,
   CellTags->{"TextField", "Ex--21907299533234115765,174"},
   CellID->486484801]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15623, 405},
 {"TextField", 15759, 409},
 {"Ex--21907299533234115765,173", 16180, 420},
 {"Ex--21907299533234115765,174", 16335, 424}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1249, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1872, 59, 51, 1, 70, "ObjectName",
 CellID->15089],
Cell[1926, 62, 367, 11, 70, "Usage",
 CellID->7688]
}, Open  ]],
Cell[CellGroupData[{
Cell[2330, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2808, 95, 72, 1, 70, "Notes",
 CellID->22414],
Cell[2883, 98, 627, 16, 70, "3ColumnTableMod",
 CellID->12296],
Cell[3513, 116, 67, 1, 70, "Notes",
 CellID->20268],
Cell[3583, 119, 468, 14, 70, "2ColumnTableMod",
 CellID->4346]
}, Closed]],
Cell[CellGroupData[{
Cell[4088, 138, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->418771138],
Cell[CellGroupData[{
Cell[4473, 152, 148, 5, 70, "ExampleSection",
 CellID->188201022],
Cell[4624, 159, 128, 3, 70, "Input",
 CellID->12950453],
Cell[4755, 164, 433, 11, 70, "Input",
 CellTags->{"TextField", "Ex--21907299533234115765,173"},
 CellID->29907],
Cell[CellGroupData[{
Cell[5213, 179, 164, 4, 70, "Input",
 CellTags->{"TextField", "Ex--21907299533234115765,174"},
 CellID->3670],
Cell[5380, 185, 7707, 130, 70, "Output",
 Evaluatable->False,
 CellTags->{"TextField", "Ex--21907299533234115765,174"},
 CellID->486484801]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13148, 322, 311, 9, 70, "SeeAlsoSection",
 CellID->10797],
Cell[13462, 333, 458, 17, 70, "SeeAlso",
 CellID->30825]
}, Open  ]],
Cell[CellGroupData[{
Cell[13957, 355, 314, 9, 70, "TutorialsSection",
 CellID->25358],
Cell[14274, 366, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[14558, 378, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

