(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26093,        663]
NotebookOptionsPosition[     21991,        531]
NotebookOutlinePosition[     24202,        595]
CellTagsIndexPosition[     23999,        587]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"Timer\"", "ObjectName",
 CellID->21229],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<Timer\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a timed action."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9624]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<Timer\>\"", "]"}]], "InlineFormula"],
 " is a useful nonuser interface widget that creates a timed action that you \
can bind calls to. It can be started and stopped, and its ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"delay\", \"TI\"]\)\>\""], "InlineFormula"],
 " property in units of milliseconds can be changed while it is running."
}], "Notes",
 CellTags->"Timer",
 CellID->11781],

Cell["The following properties are available:", "Notes",
 CellID->4638],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"delay\", \"TI\"]\)\>\"", " ", Cell[
    "the time in milliseconds between events", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"initialDelay\", \"TI\"]\)\>\"", " ", Cell["\<\
the initial delay in millliseconds before the first event fires\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->12706],

Cell["The following event is available:", "Notes",
 CellID->25561],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"action\", \"TI\"]\)\>\"", Cell[TextData[StyleBox[
    "the event triggered each time the timer is set", "Text"]], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->32350],

Cell["The following methods are available:", "Notes",
 CellID->12547],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"start\", \"TI\"]\)\>\"", Cell[TextData[StyleBox[
    "requests that the timer begin firing actions", "Text"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"stop\", \"TI\"]\)\>\"", Cell[TextData[StyleBox[
    "requests that the timer stop firing actions", "Text"]], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->4458]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->239102878],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->259921740],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->324945885],

Cell["Create a timer with controls:", "ExampleText",
 CellID->27045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{
    StyleBox["Widget", "Output"], "[", 
    RowBox[{"\"\<Frame\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\"\<title\>\"", "->", "\"\<Timer Example\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          StyleBox["Widget", "Output"], "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\"\<text\>\"", "->", "\"\<Start\>\""}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"BindEvent", "[", 
              RowBox[{"\"\<action\>\"", ",", "\[IndentingNewLine]", 
               RowBox[{"InvokeMethod", "[", 
                RowBox[{"{", 
                 RowBox[{"\"\<myTimer\>\"", ",", "\"\<start\>\""}], "}"}], 
                "]"}]}], "]"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         
         RowBox[{
          StyleBox["Widget", "Output"], "[", 
          RowBox[{"\"\<Button\>\"", ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\"\<text\>\"", "->", "\"\<Stop\>\""}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"BindEvent", "[", 
              RowBox[{"\"\<action\>\"", ",", "\[IndentingNewLine]", 
               RowBox[{"InvokeMethod", "[", 
                RowBox[{"{", 
                 RowBox[{"\"\<myTimer\>\"", ",", "\"\<stop\>\""}], "}"}], 
                "]"}]}], "]"}]}], "}"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        StyleBox["Widget", "Output"], "[", 
        RowBox[{"\"\<Slider\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<minimum\>\"", "\[Rule]", "50"}], ",", 
           RowBox[{"\"\<maximum\>\"", "\[Rule]", "3000"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"\"\<value\>\"", "\[Rule]", "1000"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"BindEvent", "[", 
            RowBox[{"\"\<change\>\"", ",", "\[IndentingNewLine]", 
             RowBox[{"Script", "[", " ", 
              RowBox[{"SetPropertyValue", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"\"\<myTimer\>\"", ",", " ", "\"\<delay\>\""}], 
                 "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"\"\<slider\>\"", ",", "\"\<value\>\""}], "}"}], 
                 "]"}]}], " ", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Name", "->", "\"\<slider\>\""}]}], "]"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        StyleBox["Widget", "Output"], "[", 
        RowBox[{"\"\<Timer\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<delay\>\"", "\[Rule]", "1000"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"BindEvent", "[", 
            RowBox[{"\"\<action\>\"", ",", "\[IndentingNewLine]", 
             RowBox[{"Script", "[", 
              RowBox[{"Print", "[", "\"\<timer triggered!\>\"", "]"}], 
              "]"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Name", "->", "\"\<myTimer\>\""}]}], "]"}]}], 
      "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellTags->{"Timer", "Ex--21907299533234115765,185"},
 CellLabel->"In[2]:=",
 CellID->10039],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject383315580289025, 
   JLink`Objects`JavaObject314314497982465]]], "Output",
 CellTags->{"Timer", "Ex--21907299533234115765,185"},
 CellLabel->"Out[2]=",
 CellID->16163]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907299533234115765,186",
 CellLabel->"In[3]:=",
 CellID->10600],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{208, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907299533234115765,186",
 CellLabel->"Out[3]=",
 CellID->267044438]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8414],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Widget",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Widget"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->15601]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19039],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"Timer\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 53.8819504}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"Timer\"Widget[\"Timer\"] creates a timed action.", 
    "synonyms" -> {}, "title" -> "Timer", "type" -> "Widget", "uri" -> 
    "GUIKit/widget/Timer"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Timer"->{
  Cell[2688, 93, 442, 10, 70, "Notes",
   CellTags->"Timer",
   CellID->11781],
  Cell[5817, 191, 3514, 82, 70, "Input",
   CellTags->{"Timer", "Ex--21907299533234115765,185"},
   CellID->10039],
  Cell[9334, 275, 320, 8, 70, "Output",
   CellTags->{"Timer", "Ex--21907299533234115765,185"},
   CellID->16163]},
 "PrimaryExamplesSection"->{
  Cell[5056, 160, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->239102878]},
 "Ex--21907299533234115765,185"->{
  Cell[5817, 191, 3514, 82, 70, "Input",
   CellTags->{"Timer", "Ex--21907299533234115765,185"},
   CellID->10039],
  Cell[9334, 275, 320, 8, 70, "Output",
   CellTags->{"Timer", "Ex--21907299533234115765,185"},
   CellID->16163]},
 "Ex--21907299533234115765,186"->{
  Cell[9691, 288, 150, 4, 70, "Input",
   CellTags->"Ex--21907299533234115765,186",
   CellID->10600],
  Cell[9844, 294, 10909, 183, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907299533234115765,186",
   CellID->267044438]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Timer", 22974, 555},
 {"PrimaryExamplesSection", 23315, 565},
 {"Ex--21907299533234115765,185", 23470, 569},
 {"Ex--21907299533234115765,186", 23737, 576}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1138, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1761, 57, 47, 1, 70, "ObjectName",
 CellID->21229],
Cell[1811, 60, 362, 11, 70, "Usage",
 CellID->9624]
}, Open  ]],
Cell[CellGroupData[{
Cell[2210, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2688, 93, 442, 10, 70, "Notes",
 CellTags->"Timer",
 CellID->11781],
Cell[3133, 105, 71, 1, 70, "Notes",
 CellID->4638],
Cell[3207, 108, 606, 14, 70, "3ColumnTableMod",
 CellID->12706],
Cell[3816, 124, 66, 1, 70, "Notes",
 CellID->25561],
Cell[3885, 127, 434, 10, 70, "2ColumnTableMod",
 CellID->32350],
Cell[4322, 139, 69, 1, 70, "Notes",
 CellID->12547],
Cell[4394, 142, 625, 13, 70, "2ColumnTableMod",
 CellID->4458]
}, Closed]],
Cell[CellGroupData[{
Cell[5056, 160, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->239102878],
Cell[CellGroupData[{
Cell[5441, 174, 148, 5, 70, "ExampleSection",
 CellID->259921740],
Cell[5592, 181, 129, 3, 70, "Input",
 CellID->324945885],
Cell[5724, 186, 68, 1, 70, "ExampleText",
 CellID->27045],
Cell[CellGroupData[{
Cell[5817, 191, 3514, 82, 70, "Input",
 CellTags->{"Timer", "Ex--21907299533234115765,185"},
 CellID->10039],
Cell[9334, 275, 320, 8, 70, "Output",
 CellTags->{"Timer", "Ex--21907299533234115765,185"},
 CellID->16163]
}, Open  ]],
Cell[CellGroupData[{
Cell[9691, 288, 150, 4, 70, "Input",
 CellTags->"Ex--21907299533234115765,186",
 CellID->10600],
Cell[9844, 294, 10909, 183, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907299533234115765,186",
 CellID->267044438]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20814, 484, 310, 9, 70, "SeeAlsoSection",
 CellID->8414],
Cell[21127, 495, 199, 6, 70, "SeeAlso",
 CellID->15601]
}, Open  ]],
Cell[CellGroupData[{
Cell[21363, 506, 314, 9, 70, "TutorialsSection",
 CellID->19039],
Cell[21680, 517, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[21964, 529, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

