(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21669,        562]
NotebookOptionsPosition[     18047,        450]
NotebookOutlinePosition[     20262,        512]
CellTagsIndexPosition[     20057,        504]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "DockedCells" :> 
          Documentation`HelpLookup["paclet:ref/DockedCells"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"DockedCells\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"ToolBar\"", "ObjectName",
 CellID->11493],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<ToolBar\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a toolbar."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following properties are available:", "Notes",
 CellID->15404],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"floatable\", \"TI\"]\)\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the toolbar can be detached", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"rollover\", \"TI\"]\)\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
draw toolbar buttons only when the mouse pointer hovers over them\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->17213]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->576018309],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->949274754],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->162717733],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", "  ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{
     StyleBox["Widget", "Output"], "[", 
     RowBox[{"\"\<Frame\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         StyleBox["Widget", "Output"], "[", 
         RowBox[{"\"\<ToolBar\>\"", ",", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             StyleBox["Widget", "Output"], "[", 
             RowBox[{"\"\<Button\>\"", ",", 
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{"\"\<icon\>\"", "\[Rule]", 
                RowBox[{
                 StyleBox["Widget", "Output"], "[", 
                 RowBox[{"\"\<Icon\>\"", ",", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<path\>\"", "->", 
                    "\"\<Wolfram/Example/Stop16.gif\>\""}], "}"}]}], "]"}]}], 
               "\[IndentingNewLine]", "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             StyleBox["Widget", "Output"], "[", 
             RowBox[{"\"\<Button\>\"", ",", 
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{"\"\<icon\>\"", "\[Rule]", 
                RowBox[{
                 StyleBox["Widget", "Output"], "[", 
                 RowBox[{"\"\<Icon\>\"", ",", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<path\>\"", "->", 
                    "\"\<Wolfram/Example/Play16.gif\>\""}], "}"}]}], "]"}]}], 
               "\[IndentingNewLine]", "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             StyleBox["Widget", "Output"], "[", "\"\<MenuSeparator\>\"", 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             StyleBox["Widget", "Output"], "[", 
             RowBox[{"\"\<Button\>\"", ",", 
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{"\"\<icon\>\"", "\[Rule]", 
                RowBox[{
                 StyleBox["Widget", "Output"], "[", 
                 RowBox[{"\"\<Icon\>\"", ",", 
                  RowBox[{"{", 
                   RowBox[{
                   "\"\<path\>\"", "->", 
                    "\"\<Wolfram/Example/Delete16.gif\>\""}], "}"}]}], 
                 "]"}]}], "\[IndentingNewLine]", "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             StyleBox["Widget", "Output"], "[", 
             RowBox[{"\"\<Label\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<Search: \>\""}], "}"}]}], 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             StyleBox["Widget", "Output"], "[", "\"\<TextField\>\"", "]"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"\"\<floatable\>\"", "\[Rule]", "False"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"\"\<rollover\>\"", "\[Rule]", "True"}]}], "}"}], ",", 
          RowBox[{"Name", "\[Rule]", "\"\<toolBar\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         StyleBox["Widget", "Output"], "[", 
         RowBox[{"\"\<TextArea\>\"", ",", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\"\<columns\>\"", "\[Rule]", "30"}], ",", " ", 
            RowBox[{"\"\<rows\>\"", "\[Rule]", "5"}]}], "}"}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->{"ToolBar", "Ex--21907299533234115765,190"},
 CellLabel->"In[2]:=",
 CellID->14838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"ToolBar", "Ex--21907299533234115765,191"},
 CellLabel->"In[3]:=",
 CellID->19232],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{218, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"ToolBar", "Ex--21907299533234115765,191"},
 CellLabel->"Out[3]=",
 CellID->157123283]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29221],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DockedCells",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DockedCells"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5848]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10032],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"ToolBar\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 54.9756444}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"ToolBar\"Widget[\"ToolBar\"] represents a toolbar.", 
    "synonyms" -> {"tool bar"}, "title" -> "ToolBar", "type" -> "Widget", 
    "uri" -> "GUIKit/widget/ToolBar"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3679, 123, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->576018309]},
 "ToolBar"->{
  Cell[4347, 149, 3616, 84, 70, "Input",
   CellTags->{"ToolBar", "Ex--21907299533234115765,190"},
   CellID->14838],
  Cell[7988, 237, 163, 4, 70, "Input",
   CellTags->{"ToolBar", "Ex--21907299533234115765,191"},
   CellID->19232],
  Cell[8154, 243, 8394, 142, 70, "Output",
   Evaluatable->False,
   CellTags->{"ToolBar", "Ex--21907299533234115765,191"},
   CellID->157123283]},
 "Ex--21907299533234115765,190"->{
  Cell[4347, 149, 3616, 84, 70, "Input",
   CellTags->{"ToolBar", "Ex--21907299533234115765,190"},
   CellID->14838]},
 "Ex--21907299533234115765,191"->{
  Cell[7988, 237, 163, 4, 70, "Input",
   CellTags->{"ToolBar", "Ex--21907299533234115765,191"},
   CellID->19232],
  Cell[8154, 243, 8394, 142, 70, "Output",
   Evaluatable->False,
   CellTags->{"ToolBar", "Ex--21907299533234115765,191"},
   CellID->157123283]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19065, 474},
 {"ToolBar", 19199, 478},
 {"Ex--21907299533234115765,190", 19616, 489},
 {"Ex--21907299533234115765,191", 19770, 493}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1252, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1875, 59, 49, 1, 70, "ObjectName",
 CellID->11493],
Cell[1927, 62, 361, 11, 70, "Usage",
 CellID->695]
}, Open  ]],
Cell[CellGroupData[{
Cell[2325, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2803, 95, 72, 1, 70, "Notes",
 CellID->15404],
Cell[2878, 98, 764, 20, 70, "3ColumnTableMod",
 CellID->17213]
}, Closed]],
Cell[CellGroupData[{
Cell[3679, 123, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->576018309],
Cell[CellGroupData[{
Cell[4064, 137, 148, 5, 70, "ExampleSection",
 CellID->949274754],
Cell[4215, 144, 129, 3, 70, "Input",
 CellID->162717733],
Cell[4347, 149, 3616, 84, 70, "Input",
 CellTags->{"ToolBar", "Ex--21907299533234115765,190"},
 CellID->14838],
Cell[CellGroupData[{
Cell[7988, 237, 163, 4, 70, "Input",
 CellTags->{"ToolBar", "Ex--21907299533234115765,191"},
 CellID->19232],
Cell[8154, 243, 8394, 142, 70, "Output",
 Evaluatable->False,
 CellTags->{"ToolBar", "Ex--21907299533234115765,191"},
 CellID->157123283]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16609, 392, 311, 9, 70, "SeeAlsoSection",
 CellID->29221],
Cell[16923, 403, 459, 17, 70, "SeeAlso",
 CellID->5848]
}, Open  ]],
Cell[CellGroupData[{
Cell[17419, 425, 314, 9, 70, "TutorialsSection",
 CellID->10032],
Cell[17736, 436, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[18020, 448, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

