(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21885,        573]
NotebookOptionsPosition[     17943,        447]
NotebookOutlinePosition[     20286,        515]
CellTagsIndexPosition[     20056,        506]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"WizardDialog\"", "ObjectName",
 CellID->21430],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<WizardDialog\>\"", "]"}]], "InlineFormula"],
     
     " \[LineSeparator]represents the dialog inside which a wizard is \
displayed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox[
   RowBox[{"Widget", "[", "\"\<Wizard\>\"", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/Wizard"]], "InlineFormula"],
 " definitions are not themselves graphical user interface widgets, but must \
be displayed within either a ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"Widget", "[", "\"\<WizardFrame\>\"", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/WizardFrame"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<WizardDialog\>\"", "]"}]], "InlineFormula"],
 ". You would typically run a wizard within a ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"Widget", "[", "\"\<WizardFrame\>\"", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/WizardFrame"]], "InlineFormula"],
 " for stand-alone or modeless wizard tools, but you might choose to use a ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<WizardDialog\>\"", "]"}]], "InlineFormula"],
 " when the wizard runs in a modal session relative to another user interface \
frame."
}], "Notes",
 CellTags->"WizardFrame",
 CellID->12606],

Cell["The following property is available:", "Notes",
 CellID->23058],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"wizard\", \"TI\"]\)\>\"", "  ", Cell[TextData[{
     "the ",
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<Wizard\>\"", "]"}]], "InlineFormula"],
     " that defines the wizard"
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->19787]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->669609463],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->301291531],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->187318622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<WizardDialog\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"\"\<wizard\>\"", "\[Rule]", " ", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Wizard\>\"", ",", " ", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
           "\"\<title\>\"", " ", "\[Rule]", " ", 
            "\"\<Hello World Wizard\>\""}], ",", "\[IndentingNewLine]", 
           RowBox[{"\"\<pages\>\"", "\[Rule]", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{"Widget", "[", 
              RowBox[{"\"\<WizardPage\>\"", ",", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"\"\<navigationNames\>\"", "\[Rule]", 
                  RowBox[{"{", "\"\<Finish\>\"", "}"}]}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                 "\"\<title\>\"", " ", "\[Rule]", " ", 
                  "\"\<Hello World Wizard Page\>\""}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"\"\<content\>\"", "\[Rule]", 
                  RowBox[{"Widget", "[", 
                   RowBox[{"\"\<WizardHTMLPanel\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<text\>\"", "\[Rule]", 
                    "\"\<A simple one-page <b>Hello World</b> wizard.\>\""}], 
                    "}"}]}], "]"}]}]}], "\[IndentingNewLine]", "}"}], ",", 
               " ", 
               RowBox[{"Name", "->", "\"\<myWizardPage\>\""}]}], "]"}], 
             "\[IndentingNewLine]", "}"}]}]}], "\[IndentingNewLine]", "}"}], 
         ",", " ", 
         RowBox[{"Name", "->", "\"\<myWizard\>\""}]}], "]"}]}], 
      "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellTags->{"Wizard", "Ex--21907323008292834369,2"},
 CellLabel->"In[2]:=",
 CellID->15406],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject112776613724161, 
   JLink`Objects`JavaObject355831648354305]]], "Output",
 CellTags->{"Wizard", "Ex--21907323008292834369,2"},
 CellLabel->"Out[2]=",
 CellID->18810]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907323008292834369,3",
 CellLabel->"In[3]:=",
 CellID->12515],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{606, 449},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907323008292834369,3",
 CellLabel->"Out[3]=",
 CellID->206575125]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10747],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Widget",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Widget"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->13407]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32051],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"WizardDialog\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 57.0849114}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "\"WizardDialog\"Widget[\"WizardDialog\"] represents the dialog inside \
which a wizard is displayed.", "synonyms" -> {"wizard dialog"}, "title" -> 
    "WizardDialog", "type" -> "Widget", "uri" -> 
    "GUIKit/widget/WizardDialog"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "WizardFrame"->{
  Cell[2744, 95, 1118, 29, 70, "Notes",
   CellTags->"WizardFrame",
   CellID->12606]},
 "PrimaryExamplesSection"->{
  Cell[4487, 148, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->669609463]},
 "Wizard"->{
  Cell[5177, 176, 2016, 44, 70, "Input",
   CellTags->{"Wizard", "Ex--21907323008292834369,2"},
   CellID->15406],
  Cell[7196, 222, 319, 8, 70, "Output",
   CellTags->{"Wizard", "Ex--21907323008292834369,2"},
   CellID->18810]},
 "Ex--21907323008292834369,2"->{
  Cell[5177, 176, 2016, 44, 70, "Input",
   CellTags->{"Wizard", "Ex--21907323008292834369,2"},
   CellID->15406],
  Cell[7196, 222, 319, 8, 70, "Output",
   CellTags->{"Wizard", "Ex--21907323008292834369,2"},
   CellID->18810]},
 "Ex--21907323008292834369,3"->{
  Cell[7552, 235, 148, 4, 70, "Input",
   CellTags->"Ex--21907323008292834369,3",
   CellID->12515],
  Cell[7703, 241, 9001, 152, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907323008292834369,3",
   CellID->206575125]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"WizardFrame", 19023, 473},
 {"PrimaryExamplesSection", 19140, 477},
 {"Wizard", 19273, 481},
 {"Ex--21907323008292834369,2", 19536, 488},
 {"Ex--21907323008292834369,3", 19799, 495}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1138, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1761, 57, 54, 1, 70, "ObjectName",
 CellID->21430],
Cell[1818, 60, 411, 13, 70, "Usage",
 CellID->3611]
}, Open  ]],
Cell[CellGroupData[{
Cell[2266, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2744, 95, 1118, 29, 70, "Notes",
 CellTags->"WizardFrame",
 CellID->12606],
Cell[3865, 126, 69, 1, 70, "Notes",
 CellID->23058],
Cell[3937, 129, 513, 14, 70, "3ColumnTableMod",
 CellID->19787]
}, Closed]],
Cell[CellGroupData[{
Cell[4487, 148, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->669609463],
Cell[CellGroupData[{
Cell[4872, 162, 148, 5, 70, "ExampleSection",
 CellID->301291531],
Cell[5023, 169, 129, 3, 70, "Input",
 CellID->187318622],
Cell[CellGroupData[{
Cell[5177, 176, 2016, 44, 70, "Input",
 CellTags->{"Wizard", "Ex--21907323008292834369,2"},
 CellID->15406],
Cell[7196, 222, 319, 8, 70, "Output",
 CellTags->{"Wizard", "Ex--21907323008292834369,2"},
 CellID->18810]
}, Open  ]],
Cell[CellGroupData[{
Cell[7552, 235, 148, 4, 70, "Input",
 CellTags->"Ex--21907323008292834369,3",
 CellID->12515],
Cell[7703, 241, 9001, 152, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907323008292834369,3",
 CellID->206575125]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16765, 400, 311, 9, 70, "SeeAlsoSection",
 CellID->10747],
Cell[17079, 411, 199, 6, 70, "SeeAlso",
 CellID->13407]
}, Open  ]],
Cell[CellGroupData[{
Cell[17315, 422, 314, 9, 70, "TutorialsSection",
 CellID->32051],
Cell[17632, 433, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[17916, 445, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

