(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26187,        644]
NotebookOptionsPosition[     21959,        512]
NotebookOutlinePosition[     24570,        586]
CellTagsIndexPosition[     24340,        577]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"WizardFrame\"", "ObjectName",
 CellID->10047],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<WizardFrame\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents the frame inside which a wizard is \
displayed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8505]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox[
   RowBox[{"Widget", "[", "\"\<Wizard\>\"", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/Wizard"]], "InlineFormula"],
 " definitions are not themselves graphical user interface widgets, but must \
be displayed within either a ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<WizardFrame\>\"", "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"Widget", "[", "\"\<WizardDialog\>\"", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/WizardDialog"]], "InlineFormula"],
 ". You would typically run a wizard within a ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<WizardFrame\>\"", "]"}]], "InlineFormula"],
 " for stand-alone or modeless wizard tools, but you might choose to use a ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"Widget", "[", "\"\<WizardDialog\>\"", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/WizardDialog"]], "InlineFormula"],
 " when the wizard runs in a modal session relative to another user interface \
frame."
}], "Notes",
 CellTags->"WizardFrame",
 CellID->10607],

Cell["The following property is available:", "Notes",
 CellID->3278],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"wizard\", \"TI\"]\)\>\"", "  ", Cell[TextData[{
     "the ",
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<Wizard\>\"", "]"}]], "InlineFormula"],
     " that defines the wizard"
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->4958]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->530016],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->341379007],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->13293138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<WizardFrame\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"\"\<wizard\>\"", "\[Rule]", " ", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Wizard\>\"", ",", " ", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
           "\"\<title\>\"", " ", "\[Rule]", " ", 
            "\"\<Hello World Wizard\>\""}], ",", "\[IndentingNewLine]", 
           RowBox[{"\"\<pages\>\"", "\[Rule]", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{"Widget", "[", 
              RowBox[{"\"\<WizardPage\>\"", ",", 
               RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"\"\<navigationNames\>\"", "\[Rule]", 
                  RowBox[{"{", "\"\<Finish\>\"", "}"}]}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                 "\"\<title\>\"", " ", "\[Rule]", " ", 
                  "\"\<Hello World Wizard Page\>\""}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"\"\<content\>\"", "\[Rule]", 
                  RowBox[{"Widget", "[", 
                   RowBox[{"\"\<WizardHTMLPanel\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<text\>\"", "\[Rule]", 
                    "\"\<A simple one-page <b>Hello World</b> wizard.\>\""}], 
                    "}"}]}], "]"}]}]}], "\[IndentingNewLine]", "}"}], ",", 
               " ", 
               RowBox[{"Name", "->", "\"\<myWizardPage\>\""}]}], "]"}], 
             "\[IndentingNewLine]", "}"}]}]}], "\[IndentingNewLine]", "}"}], 
         ",", " ", 
         RowBox[{"Name", "->", "\"\<myWizard\>\""}]}], "]"}]}], 
      "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellTags->{"Wizard", "Ex--21907323008292834369,5"},
 CellLabel->"In[2]:=",
 CellID->27576],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject264755675660289, 
   JLink`Objects`JavaObject459737158123521]]], "Output",
 CellTags->{"Wizard", "Ex--21907323008292834369,5"},
 CellLabel->"Out[2]=",
 CellID->16924]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GUIScreenShot", "[", "ref", "]"}], " "}]], "Input",
 CellTags->{"Wizard", "Ex--21907323008292834369,6"},
 CellLabel->"In[3]:=",
 CellID->10657],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{606, 449},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Wizard", "Ex--21907323008292834369,6"},
 CellLabel->"Out[3]=",
 CellID->342246753]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24592],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Widget",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Widget"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->6413]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16281],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"WizardFrame\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 58.4129684}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "\"WizardFrame\"Widget[\"WizardFrame\"] represents the frame inside which \
a wizard is displayed.", "synonyms" -> {"wizard frame"}, "title" -> 
    "WizardFrame", "type" -> "Widget", "uri" -> "GUIKit/widget/WizardFrame"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "WizardFrame"->{
  Cell[2735, 94, 1120, 29, 70, "Notes",
   CellTags->"WizardFrame",
   CellID->10607]},
 "PrimaryExamplesSection"->{
  Cell[4478, 147, 357, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->530016]},
 "Wizard"->{
  Cell[5164, 175, 2015, 44, 70, "Input",
   CellTags->{"Wizard", "Ex--21907323008292834369,5"},
   CellID->27576],
  Cell[7182, 221, 319, 8, 70, "Output",
   CellTags->{"Wizard", "Ex--21907323008292834369,5"},
   CellID->16924],
  Cell[7538, 234, 178, 5, 70, "Input",
   CellTags->{"Wizard", "Ex--21907323008292834369,6"},
   CellID->10657],
  Cell[7719, 241, 13002, 217, 70, "Output",
   Evaluatable->False,
   CellTags->{"Wizard", "Ex--21907323008292834369,6"},
   CellID->342246753]},
 "Ex--21907323008292834369,5"->{
  Cell[5164, 175, 2015, 44, 70, "Input",
   CellTags->{"Wizard", "Ex--21907323008292834369,5"},
   CellID->27576],
  Cell[7182, 221, 319, 8, 70, "Output",
   CellTags->{"Wizard", "Ex--21907323008292834369,5"},
   CellID->16924]},
 "Ex--21907323008292834369,6"->{
  Cell[7538, 234, 178, 5, 70, "Input",
   CellTags->{"Wizard", "Ex--21907323008292834369,6"},
   CellID->10657],
  Cell[7719, 241, 13002, 217, 70, "Output",
   Evaluatable->False,
   CellTags->{"Wizard", "Ex--21907323008292834369,6"},
   CellID->342246753]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"WizardFrame", 23027, 537},
 {"PrimaryExamplesSection", 23144, 541},
 {"Wizard", 23274, 545},
 {"Ex--21907323008292834369,5", 23795, 559},
 {"Ex--21907323008292834369,6", 24058, 566}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1138, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1761, 57, 53, 1, 70, "ObjectName",
 CellID->10047],
Cell[1817, 60, 403, 12, 70, "Usage",
 CellID->8505]
}, Open  ]],
Cell[CellGroupData[{
Cell[2257, 77, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2735, 94, 1120, 29, 70, "Notes",
 CellTags->"WizardFrame",
 CellID->10607],
Cell[3858, 125, 68, 1, 70, "Notes",
 CellID->3278],
Cell[3929, 128, 512, 14, 70, "3ColumnTableMod",
 CellID->4958]
}, Closed]],
Cell[CellGroupData[{
Cell[4478, 147, 357, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->530016],
Cell[CellGroupData[{
Cell[4860, 161, 148, 5, 70, "ExampleSection",
 CellID->341379007],
Cell[5011, 168, 128, 3, 70, "Input",
 CellID->13293138],
Cell[CellGroupData[{
Cell[5164, 175, 2015, 44, 70, "Input",
 CellTags->{"Wizard", "Ex--21907323008292834369,5"},
 CellID->27576],
Cell[7182, 221, 319, 8, 70, "Output",
 CellTags->{"Wizard", "Ex--21907323008292834369,5"},
 CellID->16924]
}, Open  ]],
Cell[CellGroupData[{
Cell[7538, 234, 178, 5, 70, "Input",
 CellTags->{"Wizard", "Ex--21907323008292834369,6"},
 CellID->10657],
Cell[7719, 241, 13002, 217, 70, "Output",
 Evaluatable->False,
 CellTags->{"Wizard", "Ex--21907323008292834369,6"},
 CellID->342246753]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20782, 465, 311, 9, 70, "SeeAlsoSection",
 CellID->24592],
Cell[21096, 476, 198, 6, 70, "SeeAlso",
 CellID->6413]
}, Open  ]],
Cell[CellGroupData[{
Cell[21331, 487, 314, 9, 70, "TutorialsSection",
 CellID->16281],
Cell[21648, 498, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[21932, 510, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

