(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61293,       1556]
NotebookOptionsPosition[     57289,       1423]
NotebookOutlinePosition[     58992,       1471]
CellTagsIndexPosition[     58918,       1466]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " Example: ActionApp"
}], "Title",
 CellTags->"JavaAccess",
 CellID->398992916],

Cell["", "Text",
 CellID->233392490],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 ImageSize->{332, 327},
 CellID->188528214],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 CellID->144341],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[1]:=",
 CellID->802295259],

Cell[BoxData[
 RowBox[{
  RowBox[{"ActionApp", "[", "]"}], ":=", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/ActionApp\>\"", "]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[2]:=",
 CellID->542224],

Cell[CellGroupData[{

Cell["Definition", "SubsubsectionOpener",
 CellID->273401260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"def", " ", "=", " ", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"$Path", " ", "=", " ", "$GUIPath"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Get", "[", "\"\<Wolfram/Example/ActionApp.m\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->661990160],

Cell[BoxData[
 RowBox[{"Widget", "[", 
  RowBox[{"\<\"Frame\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"title\"\>", "\[Rule]", "\<\"ActionApp\"\>"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Action\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"name\"\>", "\[Rule]", "\<\"Stop\"\>"}], ",", 
         RowBox[{"\<\"icon\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"Icon\"\>", ",", 
            RowBox[{"{", 
             RowBox[{"\<\"path\"\>", "\[Rule]", "\<\"Stop16.gif\"\>"}], 
             "}"}]}], "]"}]}], ",", 
         RowBox[{"\<\"shortDescription\"\>", 
          "\[Rule]", "\<\"Switch to stopped state\"\>"}], ",", 
         RowBox[{"\<\"accelerator\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"MenuShortcut\"\>", ",", 
            RowBox[{"InitialArguments", "\[Rule]", 
             RowBox[{"{", "\<\"T\"\>", "}"}]}]}], "]"}]}], ",", 
         RowBox[{"BindEvent", "[", 
          RowBox[{"\<\"action\"\>", ",", 
           RowBox[{"Script", "[", 
            RowBox[{
             RowBox[{"setRunning", "[", "False", "]"}], ";", 
             RowBox[{"InvokeMethod", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\<\"messageArea\"\>", ",", "\<\"append\"\>"}], "}"}],
                ",", "\<\"Stop called...\\n\"\>"}], "]"}], ";"}], "]"}]}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"stopAction\"\>"}]}], "]"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Action\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"name\"\>", "\[Rule]", "\<\"Start\"\>"}], ",", 
         RowBox[{"\<\"icon\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"Icon\"\>", ",", 
            RowBox[{"{", 
             RowBox[{"\<\"path\"\>", "\[Rule]", "\<\"Play16.gif\"\>"}], 
             "}"}]}], "]"}]}], ",", 
         RowBox[{"\<\"shortDescription\"\>", 
          "\[Rule]", "\<\"Switch to running state\"\>"}], ",", 
         RowBox[{"\<\"accelerator\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"MenuShortcut\"\>", ",", 
            RowBox[{"InitialArguments", "\[Rule]", 
             RowBox[{"{", "\<\"S\"\>", "}"}]}]}], "]"}]}], ",", 
         RowBox[{"BindEvent", "[", 
          RowBox[{"\<\"action\"\>", ",", 
           RowBox[{"Script", "[", 
            RowBox[{
             RowBox[{"setRunning", "[", "True", "]"}], ";", 
             RowBox[{"InvokeMethod", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\<\"messageArea\"\>", ",", "\<\"append\"\>"}], "}"}],
                ",", "\<\"Start called...\\n\"\>"}], "]"}], ";"}], "]"}]}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"startAction\"\>"}]}], "]"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Action\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"name\"\>", "\[Rule]", "\<\"Forward\"\>"}], ",", 
         RowBox[{"\<\"icon\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"Icon\"\>", ",", 
            RowBox[{"{", 
             RowBox[{"\<\"path\"\>", "\[Rule]", "\<\"StepForward16.gif\"\>"}],
              "}"}]}], "]"}]}], ",", 
         RowBox[{"\<\"shortDescription\"\>", 
          "\[Rule]", "\<\"Move forward one step\"\>"}], ",", 
         RowBox[{"\<\"accelerator\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"MenuShortcut\"\>", ",", 
            RowBox[{"InitialArguments", "\[Rule]", 
             RowBox[{"{", "\<\"F\"\>", "}"}]}]}], "]"}]}], ",", 
         RowBox[{"BindEvent", "[", 
          RowBox[{"\<\"action\"\>", ",", 
           RowBox[{"Script", "[", 
            RowBox[{
             RowBox[{"InvokeMethod", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\<\"messageArea\"\>", ",", "\<\"append\"\>"}], "}"}],
                ",", "\<\"Forward called...\\n\"\>"}], "]"}], ";"}], "]"}]}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"stepForwardAction\"\>"}]}], "]"}], ",",
      
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Action\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"name\"\>", "\[Rule]", "\<\"Back\"\>"}], ",", 
         RowBox[{"\<\"icon\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"Icon\"\>", ",", 
            RowBox[{"{", 
             RowBox[{"\<\"path\"\>", "\[Rule]", "\<\"StepBack16.gif\"\>"}], 
             "}"}]}], "]"}]}], ",", 
         RowBox[{"\<\"shortDescription\"\>", 
          "\[Rule]", "\<\"Move back one step\"\>"}], ",", 
         RowBox[{"\<\"accelerator\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"MenuShortcut\"\>", ",", 
            RowBox[{"InitialArguments", "\[Rule]", 
             RowBox[{"{", "\<\"B\"\>", "}"}]}]}], "]"}]}], ",", 
         RowBox[{"BindEvent", "[", 
          RowBox[{"\<\"action\"\>", ",", 
           RowBox[{"Script", "[", 
            RowBox[{
             RowBox[{"InvokeMethod", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\<\"messageArea\"\>", ",", "\<\"append\"\>"}], "}"}],
                ",", "\<\"Back called...\\n\"\>"}], "]"}], ";"}], "]"}]}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"stepBackAction\"\>"}]}], "]"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Action\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"name\"\>", "\[Rule]", "\<\"Clear\"\>"}], ",", 
         RowBox[{"\<\"icon\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"Icon\"\>", ",", 
            RowBox[{"{", 
             RowBox[{"\<\"path\"\>", "\[Rule]", "\<\"Delete16.gif\"\>"}], 
             "}"}]}], "]"}]}], ",", 
         RowBox[{"\<\"shortDescription\"\>", 
          "\[Rule]", "\<\"Clear message area\"\>"}], ",", 
         RowBox[{"\<\"accelerator\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"MenuShortcut\"\>", ",", 
            RowBox[{"InitialArguments", "\[Rule]", 
             RowBox[{"{", "\<\"K\"\>", "}"}]}]}], "]"}]}], ",", 
         RowBox[{"BindEvent", "[", 
          RowBox[{"\<\"action\"\>", ",", 
           RowBox[{"Script", "[", 
            RowBox[{
             RowBox[{"SetPropertyValue", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\<\"messageArea\"\>", ",", "\<\"text\"\>"}], "}"}], 
               ",", "\<\"\"\>"}], "]"}], ";"}], "]"}]}], "]"}]}], "}"}], ",", 
       
       RowBox[{"Name", "\[Rule]", "\<\"clearAction\"\>"}]}], "]"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"ToolBar\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Button\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"action\"\>", "\[Rule]", 
              RowBox[{"WidgetReference", "[", "\<\"stopAction\"\>", "]"}]}], 
             ",", 
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"\"\>"}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Button\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"action\"\>", "\[Rule]", 
              RowBox[{"WidgetReference", "[", "\<\"startAction\"\>", "]"}]}], 
             ",", 
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"\"\>"}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"Widget", "[", "\<\"MenuSeparator\"\>", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Button\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"action\"\>", "\[Rule]", 
              RowBox[{
              "WidgetReference", "[", "\<\"stepBackAction\"\>", "]"}]}], ",", 
             
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"\"\>"}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Button\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"action\"\>", "\[Rule]", 
              RowBox[{
              "WidgetReference", "[", "\<\"stepForwardAction\"\>", "]"}]}], 
             ",", 
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"\"\>"}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"Widget", "[", "\<\"MenuSeparator\"\>", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Button\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"action\"\>", "\[Rule]", 
              RowBox[{"WidgetReference", "[", "\<\"clearAction\"\>", "]"}]}], 
             ",", 
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"\"\>"}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"\<\"floatable\"\>", "\[Rule]", "False"}], ",", 
         RowBox[{"\<\"rollover\"\>", "\[Rule]", "True"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"toolBar\"\>"}]}], "]"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"ScrollPane\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"viewportView\"\>", "\[Rule]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"TextArea\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"columns\"\>", "\[Rule]", "30"}], ",", 
             RowBox[{"\<\"rows\"\>", "\[Rule]", "12"}]}], "}"}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"messageArea\"\>"}]}], "]"}]}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"WidgetFill", "[", "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Button\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"action\"\>", "\[Rule]", 
            RowBox[{"WidgetReference", "[", "\<\"stopAction\"\>", "]"}]}], 
           ",", 
           RowBox[{"\<\"icon\"\>", "\[Rule]", "Null"}]}], "}"}]}], "]"}], ",",
        
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Button\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"action\"\>", "\[Rule]", 
            RowBox[{"WidgetReference", "[", "\<\"startAction\"\>", "]"}]}], 
           ",", 
           RowBox[{"\<\"icon\"\>", "\[Rule]", "Null"}]}], "}"}]}], "]"}], ",",
        
       RowBox[{"WidgetSpace", "[", "5", "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Button\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"action\"\>", "\[Rule]", 
            RowBox[{"WidgetReference", "[", "\<\"stepBackAction\"\>", "]"}]}],
            ",", 
           RowBox[{"\<\"icon\"\>", "\[Rule]", "Null"}]}], "}"}]}], "]"}], ",",
        
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Button\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"action\"\>", "\[Rule]", 
            RowBox[{
            "WidgetReference", "[", "\<\"stepForwardAction\"\>", "]"}]}], ",",
            
           RowBox[{"\<\"icon\"\>", "\[Rule]", "Null"}]}], "}"}]}], "]"}], ",",
        
       RowBox[{"WidgetSpace", "[", "10", "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Button\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"action\"\>", "\[Rule]", 
            RowBox[{"WidgetReference", "[", "\<\"clearAction\"\>", "]"}]}], 
           ",", 
           RowBox[{"\<\"icon\"\>", "\[Rule]", "Null"}]}], "}"}]}], "]"}], ",",
        
       RowBox[{"WidgetFill", "[", "]"}]}], "}"}], ",", 
     RowBox[{"\<\"menus\"\>", "\[Rule]", 
      RowBox[{"Widget", "[", 
       RowBox[{"\<\"MenuBar\"\>", ",", 
        RowBox[{"{", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Menu\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Actions\"\>"}], ",", 
             RowBox[{"Widget", "[", 
              RowBox[{"\<\"MenuItem\"\>", ",", 
               RowBox[{"{", 
                RowBox[{"\<\"action\"\>", "\[Rule]", 
                 RowBox[{
                 "WidgetReference", "[", "\<\"stopAction\"\>", "]"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"Widget", "[", 
              RowBox[{"\<\"MenuItem\"\>", ",", 
               RowBox[{"{", 
                RowBox[{"\<\"action\"\>", "\[Rule]", 
                 RowBox[{
                 "WidgetReference", "[", "\<\"startAction\"\>", "]"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"Widget", "[", "\<\"MenuSeparator\"\>", "]"}], ",", 
             RowBox[{"Widget", "[", 
              RowBox[{"\<\"MenuItem\"\>", ",", 
               RowBox[{"{", 
                RowBox[{"\<\"action\"\>", "\[Rule]", 
                 RowBox[{
                 "WidgetReference", "[", "\<\"stepForwardAction\"\>", "]"}]}],
                 "}"}]}], "]"}], ",", 
             RowBox[{"Widget", "[", 
              RowBox[{"\<\"MenuItem\"\>", ",", 
               RowBox[{"{", 
                RowBox[{"\<\"action\"\>", "\[Rule]", 
                 RowBox[{
                 "WidgetReference", "[", "\<\"stepBackAction\"\>", "]"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"Widget", "[", "\<\"MenuSeparator\"\>", "]"}], ",", 
             RowBox[{"Widget", "[", 
              RowBox[{"\<\"MenuItem\"\>", ",", 
               RowBox[{"{", 
                RowBox[{"\<\"action\"\>", "\[Rule]", 
                 RowBox[{
                 "WidgetReference", "[", "\<\"clearAction\"\>", "]"}]}], 
                "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"PopupMenu\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"MenuItem\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"action\"\>", "\[Rule]", 
             RowBox[{"WidgetReference", "[", "\<\"stopAction\"\>", "]"}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"MenuItem\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"action\"\>", "\[Rule]", 
             RowBox[{"WidgetReference", "[", "\<\"startAction\"\>", "]"}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"Widget", "[", "\<\"MenuSeparator\"\>", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"MenuItem\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"action\"\>", "\[Rule]", 
             RowBox[{
             "WidgetReference", "[", "\<\"stepForwardAction\"\>", "]"}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"MenuItem\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"action\"\>", "\[Rule]", 
             RowBox[{
             "WidgetReference", "[", "\<\"stepBackAction\"\>", "]"}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"Widget", "[", "\<\"MenuSeparator\"\>", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"MenuItem\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"action\"\>", "\[Rule]", 
             RowBox[{"WidgetReference", "[", "\<\"clearAction\"\>", "]"}]}], 
            "}"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"popupMenu\"\>"}]}], "]"}], ",", 
     RowBox[{"BindEvent", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"messageArea\"\>", ",", "\<\"mousePressed\"\>"}], "}"}], 
       ",", 
       RowBox[{"Script", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"TrueQ", "[", 
            RowBox[{"PropertyValue", "[", 
             RowBox[{"{", 
              RowBox[{"\<\"#\"\>", ",", "\<\"popupTrigger\"\>"}], "}"}], 
             "]"}], "]"}], ",", 
           RowBox[{"InvokeMethod", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"popupMenu\"\>", ",", "\<\"show\"\>"}], "}"}], ",", 
             
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"#\"\>", ",", "\<\"component\"\>"}], "}"}], "]"}], 
             ",", 
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"#\"\>", ",", "\<\"x\"\>"}], "}"}], "]"}], ",", 
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"#\"\>", ",", "\<\"y\"\>"}], "}"}], "]"}]}], 
            "]"}]}], "]"}], ";"}], "]"}]}], "]"}], ",", 
     RowBox[{"BindEvent", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"messageArea\"\>", ",", "\<\"mouseReleased\"\>"}], "}"}], 
       ",", 
       RowBox[{"Script", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"TrueQ", "[", 
            RowBox[{"PropertyValue", "[", 
             RowBox[{"{", 
              RowBox[{"\<\"#\"\>", ",", "\<\"popupTrigger\"\>"}], "}"}], 
             "]"}], "]"}], ",", 
           RowBox[{"InvokeMethod", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"popupMenu\"\>", ",", "\<\"show\"\>"}], "}"}], ",", 
             
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"#\"\>", ",", "\<\"component\"\>"}], "}"}], "]"}], 
             ",", 
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"#\"\>", ",", "\<\"x\"\>"}], "}"}], "]"}], ",", 
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"#\"\>", ",", "\<\"y\"\>"}], "}"}], "]"}]}], 
            "]"}]}], "]"}], ";"}], "]"}]}], "]"}], ",", 
     RowBox[{"Script", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"setRunning", "[", "isActive_", "]"}], ":=", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"SetPropertyValue", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\<\"stopAction\"\>", ",", "\<\"enabled\"\>"}], "}"}], 
            ",", 
            RowBox[{"TrueQ", "[", "isActive", "]"}]}], "]"}], ";", 
          RowBox[{"SetPropertyValue", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\<\"startAction\"\>", ",", "\<\"enabled\"\>"}], "}"}], 
            ",", 
            RowBox[{"!", 
             RowBox[{"TrueQ", "[", "isActive", "]"}]}]}], "]"}], ";", 
          RowBox[{"SetPropertyValue", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\<\"stepForwardAction\"\>", ",", "\<\"enabled\"\>"}], 
             "}"}], ",", 
            RowBox[{"!", 
             RowBox[{"TrueQ", "[", "isActive", "]"}]}]}], "]"}], ";", 
          RowBox[{"SetPropertyValue", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\<\"stepBackAction\"\>", ",", "\<\"enabled\"\>"}], 
             "}"}], ",", 
            RowBox[{"!", 
             RowBox[{"TrueQ", "[", "isActive", "]"}]}]}], "]"}], ";"}], 
         ")"}]}], ";", 
       RowBox[{"setRunning", "[", "False", "]"}], ";"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"Name", "\[Rule]", "\<\"actionFrame\"\>"}]}], "]"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->163514699]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellID->79900125],

Cell[TextData[{
 "This example illustrates how to take advantage of ",
 StyleBox["Widget[\"Action\"]", "Output"],
 " objects and easily connect and construct typical user interface elements, \
such as menu items, toolbars, contextual popup menus and buttons."
}], "Text",
 CellID->146556853],

Cell["This example also highlights the following:", "Text",
 CellID->476336445],

Cell["Using icon resources relative to the widget definition", "BulletedText",
 CellID->55907975],

Cell["Constructing menu item widgets", "BulletedText",
 CellID->373627014],

Cell["\<\
Assigning a contextual popup menu (alternate mouse clicking) to another \
widget\
\>", "BulletedText",
 CellID->63081802],

Cell[CellGroupData[{

Cell["\<\
Defining names, tooltips, accelerator keystrokes, and icons for an action \
reused by all other widgets and globally controlling application state though \
the action widgets\
\>", "BulletedText",
 CellID->20283235],

Cell[BoxData[
 RowBox[{
  RowBox[{"ActionApp", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->445921351]
}, Open  ]],

Cell[CellGroupData[{

Cell["Optional: Localization Example", "SubsectionOpener",
 CellID->152832919],

Cell["\<\
Since the ActionApp example centralizes most definitions of the user \
interface with the action widgets, it is also relatively easy to add \
localized versions of the application for many languages and locales. The \
following variant of the ActionApp widget definition demonstrates one way in \
which to organize localized data for a widget definition.\
\>", "Text",
 CellID->43561255],

Cell[TextData[{
 StyleBox["NOTE",
  FontWeight->"Bold"],
 ": The localized strings for the sample languages are ",
 StyleBox["not",
  FontWeight->"Bold"],
 " accurate and are only implemented to illustrate how a localized version \
might appear. Some localizations may not display completely on your machine",
 " ",
 "if certain language fonts and resources are not installed."
}], "Text",
 CellID->53111094],

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Language", "=", "\"\<French\>\""}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
   "GUIRun", "[", "\"\<Wolfram/Example/ActionAppLocalized\>\"", "]"}]}], 
  "]"}]], "Input",
 CellID->71316946],

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Language", "=", "\"\<Korean\>\""}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
   "GUIRun", "[", "\"\<Wolfram/Example/ActionAppLocalized\>\"", "]"}]}], 
  "]"}]], "Input",
 CellID->569678288],

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Language", "=", "\"\<Russian\>\""}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
   "GUIRun", "[", "\"\<Wolfram/Example/ActionAppLocalized\>\"", "]"}]}], 
  "]"}]], "Input",
 CellID->70859713],

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Language", "=", "\"\<English\>\""}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
   "GUIRun", "[", "\"\<Wolfram/Example/ActionAppLocalized\>\"", "]"}]}], 
  "]"}]], "Input",
 CellID->118693396],

Cell[TextData[{
 "In this sample technique for localizing content, you add a ",
 StyleBox["KeyString[\"key\"]", "Output"],
 " function that uses ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to load and find localized definitions in the filesystem relative to the \
widget definition. One benefit of the definition itself being a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression is that you can write tools to identify what keys you are using \
to implement a localized resource."
}], "Text",
 CellID->80182602],

Cell[BoxData[
 RowBox[{
  RowBox[{"def", " ", "=", " ", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"$Path", " ", "=", " ", "$GUIPath"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
     "Get", "[", "\"\<Wolfram/Example/ActionAppLocalized.m\>\"", "]"}]}], 
    "]"}]}], " ", ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->117287063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cases", "[", 
   RowBox[{"def", ",", " ", 
    RowBox[{
     RowBox[{"KeyString", "[", "str_String", "]"}], " ", "\[RuleDelayed]", 
     " ", "str"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], " ", "//", " ", 
  "Union"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->244054297],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ACTIONS-NAME\"\>", ",", "\<\"BACK-MESSAGE\"\>", 
   ",", "\<\"BACK-NAME\"\>", ",", "\<\"BACK-TOOLTIP\"\>", 
   ",", "\<\"CLEAR-NAME\"\>", ",", "\<\"CLEAR-TOOLTIP\"\>", 
   ",", "\<\"FORWARD-MESSAGE\"\>", ",", "\<\"FORWARD-NAME\"\>", 
   ",", "\<\"FORWARD-TOOLTIP\"\>", ",", "\<\"START-MESSAGE\"\>", 
   ",", "\<\"START-NAME\"\>", ",", "\<\"START-TOOLTIP\"\>", 
   ",", "\<\"STOP-MESSAGE\"\>", ",", "\<\"STOP-NAME\"\>", 
   ",", "\<\"STOP-TOOLTIP\"\>", ",", "\<\"TITLE\"\>"}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->12932090]
}, Open  ]],

Cell[CellGroupData[{

Cell["Definition", "SubsubsectionOpener",
 CellID->232899119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"def", " ", "=", " ", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"$Path", " ", "=", " ", "$GUIPath"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
    "Get", "[", "\"\<Wolfram/Example/ActionAppLocalized.m\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->93497571],

Cell[BoxData[
 RowBox[{"Widget", "[", 
  RowBox[{"\<\"Frame\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Script", "[", 
      RowBox[{
       RowBox[{"$Keys", "=", "Null"}], ";", 
       RowBox[{
        RowBox[{"KeyString", "[", "key_String", "]"}], ":=", 
        RowBox[{"KeyString", "[", 
         RowBox[{"$Keys", ",", "key"}], "]"}]}], ";", 
       RowBox[{
        RowBox[{"KeyString", "[", 
         RowBox[{"keys_List", ",", "key_String"}], "]"}], ":=", 
        RowBox[{"key", "/.", "\[InvisibleSpace]", "keys"}]}], ";", 
       RowBox[{
        RowBox[{"KeyString", "[", 
         RowBox[{"Null", ",", "key_String"}], "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"lang", ",", "rscFile"}], "}"}], ",", 
          RowBox[{
           RowBox[{"lang", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"StringQ", "[", "Language", "]"}], ",", "Language", 
              ",", "\<\"English\"\>"}], "]"}]}], ";", 
           RowBox[{"rscFile", "=", 
            RowBox[{"First", "[", 
             RowBox[{"Flatten", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"FileNames", "[", 
                 RowBox[{
                  RowBox[{"lang", "<>", "\<\".m\"\>"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"ToFileName", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "$Path", "]"}], 
                    ",", "\<\"ActionAppResources\"\>"}], "]"}], "}"}]}], 
                 "]"}], ",", 
                RowBox[{"FileNames", "[", 
                 RowBox[{"\<\"English.m\"\>", ",", 
                  RowBox[{"{", 
                   RowBox[{"ToFileName", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "$Path", "]"}], 
                    ",", "\<\"ActionAppResources\"\>"}], "]"}], "}"}]}], 
                 "]"}]}], "}"}], "]"}], "]"}]}], ";", 
           RowBox[{"$Keys", "=", 
            RowBox[{"Get", "[", "rscFile", "]"}]}], ";", 
           RowBox[{"KeyString", "[", 
            RowBox[{"$Keys", ",", "key"}], "]"}]}]}], "]"}]}], ";"}], "]"}], 
     ",", 
     RowBox[{"\<\"title\"\>", "\[Rule]", 
      RowBox[{"Script", "[", 
       RowBox[{"KeyString", "[", "\<\"TITLE\"\>", "]"}], "]"}]}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Action\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"name\"\>", "\[Rule]", 
          RowBox[{"Script", "[", 
           RowBox[{"KeyString", "[", "\<\"STOP-NAME\"\>", "]"}], "]"}]}], ",",
          
         RowBox[{"\<\"icon\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"Icon\"\>", ",", 
            RowBox[{"{", 
             RowBox[{"\<\"path\"\>", "\[Rule]", "\<\"Stop16.gif\"\>"}], 
             "}"}]}], "]"}]}], ",", 
         RowBox[{"\<\"shortDescription\"\>", "\[Rule]", 
          RowBox[{"Script", "[", 
           RowBox[{"KeyString", "[", "\<\"STOP-TOOLTIP\"\>", "]"}], "]"}]}], 
         ",", 
         RowBox[{"\<\"accelerator\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"MenuShortcut\"\>", ",", 
            RowBox[{"InitialArguments", "\[Rule]", 
             RowBox[{"{", "\<\"T\"\>", "}"}]}]}], "]"}]}], ",", 
         RowBox[{"BindEvent", "[", 
          RowBox[{"\<\"action\"\>", ",", 
           RowBox[{"Script", "[", 
            RowBox[{
             RowBox[{"setRunning", "[", "False", "]"}], ";", 
             RowBox[{"InvokeMethod", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\<\"messageArea\"\>", ",", "\<\"append\"\>"}], "}"}],
                ",", 
               RowBox[{"KeyString", "[", "\<\"STOP-MESSAGE\"\>", "]"}]}], 
              "]"}], ";"}], "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"stopAction\"\>"}]}], "]"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Action\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"name\"\>", "\[Rule]", 
          RowBox[{"Script", "[", 
           RowBox[{"KeyString", "[", "\<\"START-NAME\"\>", "]"}], "]"}]}], 
         ",", 
         RowBox[{"\<\"icon\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"Icon\"\>", ",", 
            RowBox[{"{", 
             RowBox[{"\<\"path\"\>", "\[Rule]", "\<\"Play16.gif\"\>"}], 
             "}"}]}], "]"}]}], ",", 
         RowBox[{"\<\"shortDescription\"\>", "\[Rule]", 
          RowBox[{"Script", "[", 
           RowBox[{"KeyString", "[", "\<\"START-TOOLTIP\"\>", "]"}], "]"}]}], 
         ",", 
         RowBox[{"\<\"accelerator\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"MenuShortcut\"\>", ",", 
            RowBox[{"InitialArguments", "\[Rule]", 
             RowBox[{"{", "\<\"S\"\>", "}"}]}]}], "]"}]}], ",", 
         RowBox[{"BindEvent", "[", 
          RowBox[{"\<\"action\"\>", ",", 
           RowBox[{"Script", "[", 
            RowBox[{
             RowBox[{"setRunning", "[", "True", "]"}], ";", 
             RowBox[{"InvokeMethod", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\<\"messageArea\"\>", ",", "\<\"append\"\>"}], "}"}],
                ",", 
               RowBox[{"KeyString", "[", "\<\"START-MESSAGE\"\>", "]"}]}], 
              "]"}], ";"}], "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"startAction\"\>"}]}], "]"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Action\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"name\"\>", "\[Rule]", 
          RowBox[{"Script", "[", 
           RowBox[{"KeyString", "[", "\<\"FORWARD-NAME\"\>", "]"}], "]"}]}], 
         ",", 
         RowBox[{"\<\"icon\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"Icon\"\>", ",", 
            RowBox[{"{", 
             RowBox[{"\<\"path\"\>", "\[Rule]", "\<\"StepForward16.gif\"\>"}],
              "}"}]}], "]"}]}], ",", 
         RowBox[{"\<\"shortDescription\"\>", "\[Rule]", 
          RowBox[{"Script", "[", 
           RowBox[{"KeyString", "[", "\<\"FORWARD-TOOLTIP\"\>", "]"}], 
           "]"}]}], ",", 
         RowBox[{"\<\"accelerator\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"MenuShortcut\"\>", ",", 
            RowBox[{"InitialArguments", "\[Rule]", 
             RowBox[{"{", "\<\"F\"\>", "}"}]}]}], "]"}]}], ",", 
         RowBox[{"BindEvent", "[", 
          RowBox[{"\<\"action\"\>", ",", 
           RowBox[{"Script", "[", 
            RowBox[{
             RowBox[{"InvokeMethod", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\<\"messageArea\"\>", ",", "\<\"append\"\>"}], "}"}],
                ",", 
               RowBox[{"KeyString", "[", "\<\"FORWARD-MESSAGE\"\>", "]"}]}], 
              "]"}], ";"}], "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"stepForwardAction\"\>"}]}], "]"}], ",",
      
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Action\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"name\"\>", "\[Rule]", 
          RowBox[{"Script", "[", 
           RowBox[{"KeyString", "[", "\<\"BACK-NAME\"\>", "]"}], "]"}]}], ",",
          
         RowBox[{"\<\"icon\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"Icon\"\>", ",", 
            RowBox[{"{", 
             RowBox[{"\<\"path\"\>", "\[Rule]", "\<\"StepBack16.gif\"\>"}], 
             "}"}]}], "]"}]}], ",", 
         RowBox[{"\<\"shortDescription\"\>", "\[Rule]", 
          RowBox[{"Script", "[", 
           RowBox[{"KeyString", "[", "\<\"BACK-TOOLTIP\"\>", "]"}], "]"}]}], 
         ",", 
         RowBox[{"\<\"accelerator\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"MenuShortcut\"\>", ",", 
            RowBox[{"InitialArguments", "\[Rule]", 
             RowBox[{"{", "\<\"B\"\>", "}"}]}]}], "]"}]}], ",", 
         RowBox[{"BindEvent", "[", 
          RowBox[{"\<\"action\"\>", ",", 
           RowBox[{"Script", "[", 
            RowBox[{
             RowBox[{"InvokeMethod", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\<\"messageArea\"\>", ",", "\<\"append\"\>"}], "}"}],
                ",", 
               RowBox[{"KeyString", "[", "\<\"BACK-MESSAGE\"\>", "]"}]}], 
              "]"}], ";"}], "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"stepBackAction\"\>"}]}], "]"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"Action\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\<\"name\"\>", "\[Rule]", 
          RowBox[{"Script", "[", 
           RowBox[{"KeyString", "[", "\<\"CLEAR-NAME\"\>", "]"}], "]"}]}], 
         ",", 
         RowBox[{"\<\"icon\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"Icon\"\>", ",", 
            RowBox[{"{", 
             RowBox[{"\<\"path\"\>", "\[Rule]", "\<\"Delete16.gif\"\>"}], 
             "}"}]}], "]"}]}], ",", 
         RowBox[{"\<\"shortDescription\"\>", "\[Rule]", 
          RowBox[{"Script", "[", 
           RowBox[{"KeyString", "[", "\<\"CLEAR-TOOLTIP\"\>", "]"}], "]"}]}], 
         ",", 
         RowBox[{"\<\"accelerator\"\>", "\[Rule]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\<\"MenuShortcut\"\>", ",", 
            RowBox[{"InitialArguments", "\[Rule]", 
             RowBox[{"{", "\<\"K\"\>", "}"}]}]}], "]"}]}], ",", 
         RowBox[{"BindEvent", "[", 
          RowBox[{"\<\"action\"\>", ",", 
           RowBox[{"SetPropertyValue", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"messageArea\"\>", ",", "\<\"text\"\>"}], "}"}], 
             ",", "\<\"\"\>"}], "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"clearAction\"\>"}]}], "]"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"ScrollPane\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"viewportView\"\>", "\[Rule]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"TextArea\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"columns\"\>", "\[Rule]", "30"}], ",", 
             RowBox[{"\<\"rows\"\>", "\[Rule]", "12"}]}], "}"}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"messageArea\"\>"}]}], "]"}]}], 
        "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"WidgetFill", "[", "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Button\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"action\"\>", "\[Rule]", 
            RowBox[{"WidgetReference", "[", "\<\"stopAction\"\>", "]"}]}], 
           ",", 
           RowBox[{"\<\"icon\"\>", "\[Rule]", "Null"}]}], "}"}]}], "]"}], ",",
        
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Button\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"action\"\>", "\[Rule]", 
            RowBox[{"WidgetReference", "[", "\<\"startAction\"\>", "]"}]}], 
           ",", 
           RowBox[{"\<\"icon\"\>", "\[Rule]", "Null"}]}], "}"}]}], "]"}], ",",
        
       RowBox[{"WidgetSpace", "[", "5", "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Button\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"action\"\>", "\[Rule]", 
            RowBox[{"WidgetReference", "[", "\<\"stepBackAction\"\>", "]"}]}],
            ",", 
           RowBox[{"\<\"icon\"\>", "\[Rule]", "Null"}]}], "}"}]}], "]"}], ",",
        
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Button\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"action\"\>", "\[Rule]", 
            RowBox[{
            "WidgetReference", "[", "\<\"stepForwardAction\"\>", "]"}]}], ",",
            
           RowBox[{"\<\"icon\"\>", "\[Rule]", "Null"}]}], "}"}]}], "]"}], ",",
        
       RowBox[{"WidgetSpace", "[", "10", "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"Button\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"action\"\>", "\[Rule]", 
            RowBox[{"WidgetReference", "[", "\<\"clearAction\"\>", "]"}]}], 
           ",", 
           RowBox[{"\<\"icon\"\>", "\[Rule]", "Null"}]}], "}"}]}], "]"}], ",",
        
       RowBox[{"WidgetFill", "[", "]"}]}], "}"}], ",", 
     RowBox[{"\<\"menus\"\>", "\[Rule]", 
      RowBox[{"Widget", "[", 
       RowBox[{"\<\"MenuBar\"\>", ",", 
        RowBox[{"{", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Menu\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", 
              RowBox[{"Script", "[", 
               RowBox[{"KeyString", "[", "\<\"ACTIONS-NAME\"\>", "]"}], 
               "]"}]}], ",", 
             RowBox[{"Widget", "[", 
              RowBox[{"\<\"MenuItem\"\>", ",", 
               RowBox[{"{", 
                RowBox[{"\<\"action\"\>", "\[Rule]", 
                 RowBox[{
                 "WidgetReference", "[", "\<\"stopAction\"\>", "]"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"Widget", "[", 
              RowBox[{"\<\"MenuItem\"\>", ",", 
               RowBox[{"{", 
                RowBox[{"\<\"action\"\>", "\[Rule]", 
                 RowBox[{
                 "WidgetReference", "[", "\<\"startAction\"\>", "]"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"Widget", "[", "\<\"MenuSeparator\"\>", "]"}], ",", 
             RowBox[{"Widget", "[", 
              RowBox[{"\<\"MenuItem\"\>", ",", 
               RowBox[{"{", 
                RowBox[{"\<\"action\"\>", "\[Rule]", 
                 RowBox[{
                 "WidgetReference", "[", "\<\"stepForwardAction\"\>", "]"}]}],
                 "}"}]}], "]"}], ",", 
             RowBox[{"Widget", "[", 
              RowBox[{"\<\"MenuItem\"\>", ",", 
               RowBox[{"{", 
                RowBox[{"\<\"action\"\>", "\[Rule]", 
                 RowBox[{
                 "WidgetReference", "[", "\<\"stepBackAction\"\>", "]"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"Widget", "[", "\<\"MenuSeparator\"\>", "]"}], ",", 
             RowBox[{"Widget", "[", 
              RowBox[{"\<\"MenuItem\"\>", ",", 
               RowBox[{"{", 
                RowBox[{"\<\"action\"\>", "\[Rule]", 
                 RowBox[{
                 "WidgetReference", "[", "\<\"clearAction\"\>", "]"}]}], 
                "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"PopupMenu\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"MenuItem\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"action\"\>", "\[Rule]", 
             RowBox[{"WidgetReference", "[", "\<\"stopAction\"\>", "]"}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"MenuItem\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"action\"\>", "\[Rule]", 
             RowBox[{"WidgetReference", "[", "\<\"startAction\"\>", "]"}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"Widget", "[", "\<\"MenuSeparator\"\>", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"MenuItem\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"action\"\>", "\[Rule]", 
             RowBox[{
             "WidgetReference", "[", "\<\"stepForwardAction\"\>", "]"}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"MenuItem\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"action\"\>", "\[Rule]", 
             RowBox[{
             "WidgetReference", "[", "\<\"stepBackAction\"\>", "]"}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"Widget", "[", "\<\"MenuSeparator\"\>", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"MenuItem\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"action\"\>", "\[Rule]", 
             RowBox[{"WidgetReference", "[", "\<\"clearAction\"\>", "]"}]}], 
            "}"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"popupMenu\"\>"}]}], "]"}], ",", 
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"ToolBar\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Button\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"action\"\>", "\[Rule]", 
              RowBox[{"WidgetReference", "[", "\<\"stopAction\"\>", "]"}]}], 
             ",", 
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"\"\>"}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Button\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"action\"\>", "\[Rule]", 
              RowBox[{"WidgetReference", "[", "\<\"startAction\"\>", "]"}]}], 
             ",", 
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"\"\>"}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"Widget", "[", "\<\"MenuSeparator\"\>", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Button\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"action\"\>", "\[Rule]", 
              RowBox[{
              "WidgetReference", "[", "\<\"stepBackAction\"\>", "]"}]}], ",", 
             
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"\"\>"}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Button\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"action\"\>", "\[Rule]", 
              RowBox[{
              "WidgetReference", "[", "\<\"stepForwardAction\"\>", "]"}]}], 
             ",", 
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"\"\>"}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"Widget", "[", "\<\"MenuSeparator\"\>", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Button\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"action\"\>", "\[Rule]", 
              RowBox[{"WidgetReference", "[", "\<\"clearAction\"\>", "]"}]}], 
             ",", 
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"\"\>"}]}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"\<\"floatable\"\>", "\[Rule]", "True"}], ",", 
         RowBox[{"\<\"rollover\"\>", "\[Rule]", "True"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"toolBar\"\>"}]}], "]"}], ",", 
     RowBox[{"BindEvent", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"messageArea\"\>", ",", "\<\"mousePressed\"\>"}], "}"}], 
       ",", 
       RowBox[{"Script", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"TrueQ", "[", 
            RowBox[{"PropertyValue", "[", 
             RowBox[{"{", 
              RowBox[{"\<\"#\"\>", ",", "\<\"popupTrigger\"\>"}], "}"}], 
             "]"}], "]"}], ",", 
           RowBox[{"InvokeMethod", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"popupMenu\"\>", ",", "\<\"show\"\>"}], "}"}], ",", 
             
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"#\"\>", ",", "\<\"component\"\>"}], "}"}], "]"}], 
             ",", 
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"#\"\>", ",", "\<\"x\"\>"}], "}"}], "]"}], ",", 
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"#\"\>", ",", "\<\"y\"\>"}], "}"}], "]"}]}], 
            "]"}]}], "]"}], ";"}], "]"}]}], "]"}], ",", 
     RowBox[{"BindEvent", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"messageArea\"\>", ",", "\<\"mouseReleased\"\>"}], "}"}], 
       ",", 
       RowBox[{"Script", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"TrueQ", "[", 
            RowBox[{"PropertyValue", "[", 
             RowBox[{"{", 
              RowBox[{"\<\"#\"\>", ",", "\<\"popupTrigger\"\>"}], "}"}], 
             "]"}], "]"}], ",", 
           RowBox[{"InvokeMethod", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"popupMenu\"\>", ",", "\<\"show\"\>"}], "}"}], ",", 
             
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"#\"\>", ",", "\<\"component\"\>"}], "}"}], "]"}], 
             ",", 
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"#\"\>", ",", "\<\"x\"\>"}], "}"}], "]"}], ",", 
             RowBox[{"PropertyValue", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"#\"\>", ",", "\<\"y\"\>"}], "}"}], "]"}]}], 
            "]"}]}], "]"}], ";"}], "]"}]}], "]"}], ",", 
     RowBox[{"Script", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"setRunning", "[", "isActive_", "]"}], ":=", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"SetPropertyValue", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\<\"stopAction\"\>", ",", "\<\"enabled\"\>"}], "}"}], 
            ",", 
            RowBox[{"TrueQ", "[", "isActive", "]"}]}], "]"}], ";", 
          RowBox[{"SetPropertyValue", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\<\"startAction\"\>", ",", "\<\"enabled\"\>"}], "}"}], 
            ",", 
            RowBox[{"!", 
             RowBox[{"TrueQ", "[", "isActive", "]"}]}]}], "]"}], ";", 
          RowBox[{"SetPropertyValue", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\<\"stepForwardAction\"\>", ",", "\<\"enabled\"\>"}], 
             "}"}], ",", 
            RowBox[{"!", 
             RowBox[{"TrueQ", "[", "isActive", "]"}]}]}], "]"}], ";", 
          RowBox[{"SetPropertyValue", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\<\"stepBackAction\"\>", ",", "\<\"enabled\"\>"}], 
             "}"}], ",", 
            RowBox[{"!", 
             RowBox[{"TrueQ", "[", "isActive", "]"}]}]}], "]"}], ";"}], 
         ")"}]}], ";", 
       RowBox[{"setRunning", "[", "False", "]"}], ";"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"Name", "\[Rule]", "\<\"actionFrame\"\>"}]}], "]"}]], "Output",
 CellLabel->"Out[6]=",
 CellID->175248263]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIKit Example: ActionApp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 3.6002028}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "This example illustrates how to take advantage of Widget[\"Action\"] \
objects and easily connect and construct typical user interface elements, \
such as menu items, toolbars, contextual popup menus and buttons. This \
example also highlights the following:", "synonyms" -> {}, "title" -> 
    "GUIKit Example: ActionApp", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/ActionApp"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "JavaAccess"->{
  Cell[731, 29, 140, 6, 70, "Title",
   CellTags->"JavaAccess",
   CellID->398992916]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"JavaAccess", 58807, 1459}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 140, 6, 70, "Title",
 CellTags->"JavaAccess",
 CellID->398992916],
Cell[874, 37, 36, 1, 70, "Text",
 CellID->233392490],
Cell[913, 40, 8365, 139, 70, "Graphics",
 CellID->188528214],
Cell[CellGroupData[{
Cell[9303, 183, 49, 1, 70, "SubsectionOpener",
 CellID->144341],
Cell[9355, 186, 142, 4, 70, "Input",
 InitializationCell->True,
 CellID->802295259],
Cell[9500, 192, 216, 7, 70, "Input",
 InitializationCell->True,
 CellID->542224],
Cell[CellGroupData[{
Cell[9741, 203, 61, 1, 70, "SubsubsectionOpener",
 CellID->273401260],
Cell[CellGroupData[{
Cell[9827, 208, 330, 10, 70, "Input",
 CellID->661990160],
Cell[10160, 220, 19100, 457, 70, "Output",
 CellID->163514699]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29321, 684, 45, 1, 70, "Section",
 CellID->79900125],
Cell[29369, 687, 291, 6, 70, "Text",
 CellID->146556853],
Cell[29663, 695, 79, 1, 70, "Text",
 CellID->476336445],
Cell[29745, 698, 97, 1, 70, "BulletedText",
 CellID->55907975],
Cell[29845, 701, 74, 1, 70, "BulletedText",
 CellID->373627014],
Cell[29922, 704, 131, 4, 70, "BulletedText",
 CellID->63081802],
Cell[CellGroupData[{
Cell[30078, 712, 225, 5, 70, "BulletedText",
 CellID->20283235],
Cell[30306, 719, 118, 4, 70, "Input",
 CellID->445921351]
}, Open  ]],
Cell[CellGroupData[{
Cell[30461, 728, 78, 1, 70, "SubsectionOpener",
 CellID->152832919],
Cell[30542, 731, 397, 7, 70, "Text",
 CellID->43561255],
Cell[30942, 740, 408, 11, 70, "Text",
 CellID->53111094],
Cell[31353, 753, 278, 9, 70, "Input",
 CellID->71316946],
Cell[31634, 764, 279, 9, 70, "Input",
 CellID->569678288],
Cell[31916, 775, 279, 9, 70, "Input",
 CellID->70859713],
Cell[32198, 786, 280, 9, 70, "Input",
 CellID->118693396],
Cell[32481, 797, 537, 13, 70, "Text",
 CellID->80182602],
Cell[33021, 812, 375, 12, 70, "Input",
 CellID->117287063],
Cell[CellGroupData[{
Cell[33421, 828, 348, 11, 70, "Input",
 CellID->244054297],
Cell[33772, 841, 579, 11, 70, "Output",
 CellID->12932090]
}, Open  ]],
Cell[CellGroupData[{
Cell[34388, 857, 61, 1, 70, "SubsubsectionOpener",
 CellID->232899119],
Cell[CellGroupData[{
Cell[34474, 862, 343, 11, 70, "Input",
 CellID->93497571],
Cell[34820, 875, 22379, 539, 70, "Output",
 CellID->175248263]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[57262, 1421, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

