(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26449,        629]
NotebookOptionsPosition[     23447,        537]
NotebookOutlinePosition[     25154,        579]
CellTagsIndexPosition[     25111,        576]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " Example: CellularGroup"
}], "Title",
 CellID->554471618],

Cell["", "Text",
 CellID->55940749],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 ImageSize->{262, 212},
 CellID->60170568],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 CellID->993651209],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[1]:=",
 CellID->465438322],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CellularGroupDialog", "[", "]"}], ":=", 
   RowBox[{
   "GUIRunModal", "[", "\"\<Wolfram/Example/CellularGroup\>\"", "]"}]}], 
  ";"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[2]:=",
 CellID->24105892],

Cell[CellGroupData[{

Cell["Definition", "SubsubsectionOpener",
 CellID->277781331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"def", " ", "=", " ", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"$Path", " ", "=", " ", "$GUIPath"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Get", "[", "\"\<Wolfram/Example/CellularGroup.m\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->147049807],

Cell[BoxData[
 RowBox[{"Widget", "[", 
  RowBox[{"\<\"Panel\"\>", ",", 
   RowBox[{"WidgetGroup", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"TextField\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"30\"\>"}], ",", 
             RowBox[{"\<\"columns\"\>", "\[Rule]", "5"}], ",", 
             RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
              RowBox[{"PropertyValue", "[", "\<\"RIGHT\"\>", "]"}]}], ",", 
             RowBox[{"BindEvent", "[", 
              RowBox[{"\<\"action\"\>", ",", 
               RowBox[{"Script", "[", 
                RowBox[{"updatePlot", "[", "]"}], "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"WidgetLayout", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"None", ",", "None"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"ruleField\"\>"}]}], "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Slider\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"value\"\>", "\[Rule]", "5"}], ",", 
             RowBox[{"\<\"minimum\"\>", "\[Rule]", "0"}], ",", 
             RowBox[{"\<\"maximum\"\>", "\[Rule]", "50"}], ",", 
             RowBox[{"BindEvent", "[", 
              RowBox[{"\<\"change\"\>", ",", 
               RowBox[{"Script", "[", 
                RowBox[{"updatePlot", "[", "]"}], "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"WidgetLayout", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Maximize", ",", "None"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"stepSlider\"\>"}]}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"MathPanel\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"preferredSize\"\>", "\[Rule]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\<\"Dimension\"\>", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\<\"width\"\>", "\[Rule]", "150"}], ",", 
               RowBox[{"\<\"height\"\>", "\[Rule]", "150"}]}], "}"}]}], 
            "]"}]}], "}"}], ",", 
         RowBox[{"WidgetLayout", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Maximize", ",", "Maximize"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"Name", "\[Rule]", "\<\"canvas\"\>"}]}], "]"}], ",", 
       RowBox[{"BindEvent", "[", 
        RowBox[{"\<\"componentResized\"\>", ",", 
         RowBox[{"Script", "[", 
          RowBox[{"updatePlot", "[", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"BindEvent", "[", 
        RowBox[{"\<\"endModal\"\>", ",", 
         RowBox[{"Script", "[", 
          RowBox[{"Show", "[", "expr", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"Script", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"RasterGraphics", "[", 
           RowBox[{
            RowBox[{"state_", "?", "MatrixQ"}], ",", 
            RowBox[{"colors_Integer", ":", "2"}], ",", "opts___"}], "]"}], ":=",
           
          RowBox[{"(", 
           TagBox[
            RowBox[{
            "\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
            False,
            Editable->False], ")"}]}], ";", 
         RowBox[{
          RowBox[{"updatePlot", "[", "]"}], ":=", 
          RowBox[{"Block", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"steps", ",", "ruleNum", ",", 
              RowBox[{"$DisplayFunction", "=", "Identity"}]}], "}"}], ",", 
            RowBox[{
             RowBox[{"ruleNum", "=", 
              RowBox[{"Round", "[", 
               RowBox[{"ToExpression", "[", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"\<\"ruleField\"\>", ",", "\<\"text\"\>"}], "}"}], 
                 "]"}], "]"}], "]"}]}], ";", 
             RowBox[{"ruleNum", "=", 
              RowBox[{"Min", "[", 
               RowBox[{
                RowBox[{"Max", "[", 
                 RowBox[{"ruleNum", ",", "0"}], "]"}], ",", "255"}], "]"}]}], 
             ";", 
             RowBox[{"SetPropertyValue", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\<\"ruleField\"\>", ",", "\<\"text\"\>"}], "}"}], 
               ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"ruleNum", ",", "InputForm"}], "]"}]}], "]"}], ";", 
             RowBox[{"steps", "=", 
              RowBox[{"Round", "[", 
               RowBox[{"ToExpression", "[", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"\<\"stepSlider\"\>", ",", "\<\"value\"\>"}], "}"}],
                  "]"}], "]"}], "]"}]}], ";", 
             RowBox[{"expr", "=", 
              RowBox[{"Show", "[", 
               RowBox[{
                RowBox[{"RasterGraphics", "[", 
                 RowBox[{"CellularAutomaton", "[", 
                  RowBox[{"ruleNum", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
                   "steps"}], "]"}], "]"}], ",", 
                RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";", 
             RowBox[{"SetPropertyValue", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\<\"canvas\"\>", ",", "\<\"mathCommand\"\>"}], "}"}],
                ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"expr", ",", "InputForm"}], "]"}]}], "]"}], ";", 
             RowBox[{"InvokeMethod", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"canvas\"\>", ",", "\<\"repaintNow\"\>"}], "}"}], 
              "]"}], ";"}]}], "]"}]}], ";", 
         RowBox[{"updatePlot", "[", "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"WidgetLayout", "\[Rule]", "Column"}]}], "]"}], ",", 
   RowBox[{"WidgetLayout", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}]}], "]"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->136960308]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellID->879713665],

Cell[TextData[{
 "This example demonstrates how to create a reusable ",
 StyleBox["GUIKit`", "Output"],
 " widget for a cellular automaton."
}], "Text",
 CellID->377454225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularGroupDialog", "[", "]"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[3]:=",
 CellID->229352667],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyVkdERwjAMQy224JMRWIURukD3/yPFVuykTkh6lPp6kqyXvo7zczxE5Fnu
t1wXUH7Q4fdfHhCONplKX5jOXusDwR5UzFO32Bo1uf2aqhPeAFYK7AhONUP1
viNygCEaxBXu6Dj8MMBi4vqMAzXeghD1GQcaYZufc7TCXn/n4LeTev6Jo+Hg
d8Ct/4ij7kvzEw62G+QnHCQZ6nsOSc5/ygFM+qcc0/4Jx5/+CcdCftyxlh93
rOoDx45jI18de/pJ/heTdAVc
   "]],
  AspectRatio->Automatic,
  PlotRange->All]], "Output",
 Evaluatable->False,
 CellLabel->"Out[3]=",
 CellID->199063257]
}, Open  ]],

Cell["\<\
You can easily treat the CellularGroup example as a single reusable user \
interface element within other panels, as well as expose widgets within the \
definition uniquely.
Here we expose the canvas widget with unique names and create a modal result \
expression extracting the current graphics.\
\>", "Text",
 CellID->285601069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\[IndentingNewLine]", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Panel\>\"", ",", " ", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<Label\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<text\>\"", "\[Rule]", "\"\<Multiple \nCellular sessions\>\""}], 
         "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Wolfram/Example/CellularGroup\>\"", ",", " ", 
          RowBox[{"ExposeWidgetReferences", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<canvas\>\"", "->", "\"\<canvas1\>\""}], "}"}]}]}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Wolfram/Example/CellularGroup\>\"", ",", 
          RowBox[{"ExposeWidgetReferences", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<canvas\>\"", "->", "\"\<canvas2\>\""}], "}"}]}]}], 
         "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Wolfram/Example/CellularGroup\>\"", ",", " ", 
          RowBox[{"ExposeWidgetReferences", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<canvas\>\"", "->", "\"\<canvas3\>\""}], "}"}]}]}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Wolfram/Example/CellularGroup\>\"", ",", " ", 
          RowBox[{"ExposeWidgetReferences", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<canvas\>\"", "->", "\"\<canvas4\>\""}], "}"}]}]}], 
         "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"BindEvent", "[", 
       RowBox[{"\"\<endModal\>\"", ",", "\[IndentingNewLine]", 
        RowBox[{"Script", "[", " ", 
         RowBox[{"Show", "[", " ", 
          RowBox[{"GraphicsArray", "[", "\[IndentingNewLine]", " ", 
           RowBox[{"Partition", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"ToExpression", "[", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"#", ",", "\"\<mathCommand\>\""}], "}"}], "]"}], 
                "]"}], "&"}], " ", "/@", " ", "\[IndentingNewLine]", 
              RowBox[{"Select", "[", " ", 
               RowBox[{
                RowBox[{"\"\<WidgetNames\>\"", "/.", 
                 RowBox[{"GUIInformation", "[", "]"}]}], ",", " ", 
                RowBox[{
                 RowBox[{"StringMatchQ", "[", 
                  RowBox[{"#", ",", "\"\<canvas*\>\""}], "]"}], "&"}]}], 
               "]"}]}], ",", "\[IndentingNewLine]", "2"}], "]"}], "]"}], 
          "]"}], "  ", "]"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], 
   "]"}], "\[IndentingNewLine]", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->187480466],

Cell[BoxData[
 GraphicsBox[{{{}, {}}, {{InsetBox[
      GraphicsBox[
       RasterBox[{{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0}, {
        1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 0,
         1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1}, {1, 1, 1, 0, 0, 1, 1, 
        0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0,
         1, 0, 0, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 
        1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1,
         1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1,
         1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
        1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}}],
       AspectRatio->Automatic,
       PlotRange->All], {192., -130.0155903271693}, 
      ImageScaled[{0.5, 0.5}], {360., 243.77923186344242`}], InsetBox[
      GraphicsBox[
       RasterBox[{{0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0,
         0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 
        1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 
        1, 1, 0, 0, 1, 1, 1, 0, 1}, {1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1,
         0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 
        1}, {0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0,
         0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0}, {1, 1, 1, 1, 0, 1, 0, 
        0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 
        0, 0, 1, 0, 0, 1, 1}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1,
         1, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0}, {1, 
        1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1, 0, 
        0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 1,
         0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 
        1, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0,
         1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 
        0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 
        0, 1, 1, 1, 0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1,
         0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 
        1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0,
         0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 
        0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
         1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0}, {1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 
        1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
        0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1,
         1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 
        0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
         1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
        1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
         1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
        0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
         1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}],
       AspectRatio->Automatic,
       PlotRange->All], {576., -130.0155903271693}, ImageScaled[{0.5, 0.5}], 
      {360., 243.77923186344242`}]}, {InsetBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJytlNENwyAMRE036U+X6V9HyALd/68tEhFcCfb5QEIny/H5EZDvx/t13Mzs
8d1Pq6v8VlN29fXNIedUhvrql2Q6eRqbwIT1ChPWa05jfTtvdqOvsmfnzers
vFlFruEuyBi5TIiRS4mRS4mxz9V7ieSxz9V7ieSxb69sHvv2yuax7/JuiPnm
/Qdmvrl3Q8w3927CTv78YhYznyJcK2W5VspyRedThCs6nyJcq5jycmLKS3hP
f14l/55mXL1KXqCS14b/dHqVPUzVaxNT9Qp99QH+5gvQ
        "]],
       AspectRatio->Automatic,
       PlotRange->All], {192., -390.04677098150785`}, 
      ImageScaled[{0.5, 0.5}], {360., 243.77923186344248`}], InsetBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJyt080NgCAMhuF+bmLcyBFYwP1vBkUDpO170Cbcmgfoz1qOvSxmtrWjJEyG
caehoYx60tBIlDEtNUKl/zIagTKWDQ1XmUuPhqPMxqy4xUJjutQvOBrD96Om
odE1Im48Gu9IpMNDRhvOzJDQuNYkNyQ0agIYEhuGxr35X40/3lHjBOCOBEE=

        "]],
       AspectRatio->Automatic,
       PlotRange->All], {576., -390.04677098150785`}, 
      ImageScaled[{0.5, 0.5}], {360., 243.77923186344248`}]}}, {{}, 
    StyleBox[{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}},
     Antialiasing->False]}},
  PlotRange->{{0, 768.}, {0, -520.0623613086772}},
  PlotRangePadding->{5, 5}]], "Output",
 Evaluatable->False,
 ImageSize->{360, 228},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->758136814]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIKit Example: CellularGroup - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 6.2563168}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "This example demonstrates how to create a reusable GUIKit` widget for a \
cellular automaton. You can easily treat the CellularGroup example as a \
single reusable user interface element within other panels, as well as expose \
widgets within the definition uniquely. Here we expose the canvas widget with \
unique names and create a modal result expression extracting the current \
graphics.", "synonyms" -> {}, "title" -> "GUIKit Example: CellularGroup", 
    "type" -> "Tutorial", "uri" -> "GUIKit/tutorial/CellularGroup"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 119, 5, 70, "Title",
 CellID->554471618],
Cell[853, 36, 35, 1, 70, "Text",
 CellID->55940749],
Cell[891, 39, 5334, 89, 70, "Graphics",
 CellID->60170568],
Cell[CellGroupData[{
Cell[6250, 132, 52, 1, 70, "SubsectionOpener",
 CellID->993651209],
Cell[6305, 135, 166, 5, 70, "Input",
 InitializationCell->True,
 CellID->465438322],
Cell[6474, 142, 285, 10, 70, "Input",
 InitializationCell->True,
 CellID->24105892],
Cell[CellGroupData[{
Cell[6784, 156, 61, 1, 70, "SubsubsectionOpener",
 CellID->277781331],
Cell[CellGroupData[{
Cell[6870, 161, 334, 10, 70, "Input",
 CellID->147049807],
Cell[7207, 173, 6417, 151, 70, "Output",
 CellID->136960308]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[13685, 331, 46, 1, 70, "Section",
 CellID->879713665],
Cell[13734, 334, 172, 5, 70, "Text",
 CellID->377454225],
Cell[CellGroupData[{
Cell[13931, 343, 134, 4, 70, "Input",
 CellID->229352667],
Cell[14068, 349, 452, 12, 70, "Output",
 Evaluatable->False,
 CellID->199063257]
}, Open  ]],
Cell[14535, 364, 340, 7, 70, "Text",
 CellID->285601069],
Cell[CellGroupData[{
Cell[14900, 375, 2939, 65, 70, "Input",
 CellID->187480466],
Cell[17842, 442, 5539, 88, 70, "Output",
 Evaluatable->False,
 CellID->758136814]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[23420, 535, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

