(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22239,        559]
NotebookOptionsPosition[     19490,        470]
NotebookOutlinePosition[     20897,        509]
CellTagsIndexPosition[     20854,        506]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " Example: ColorChooser"
}], "Title",
 CellID->554471618],

Cell["", "Text",
 CellID->451251365],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 ImageSize->{417, 399},
 CellID->230352961],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 CellID->36823909],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[1]:=",
 CellID->239207382],

Cell[BoxData[
 RowBox[{
  RowBox[{"ChooseColorDialog", "[", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"!", 
       RowBox[{"GUIObjectQ", "[", "$ChooseColorDialogObject", "]"}]}], ",", 
      RowBox[{"$ChooseColorDialogObject", " ", "=", 
       RowBox[{
       "GUILoad", "[", "\"\<Wolfram/Example/ChooseColorDialog\>\"", "]"}]}]}],
      "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"GUIRunModal", "[", 
     RowBox[{"$ChooseColorDialogObject", ",", 
      RowBox[{"ReleaseMethod", "\[Rule]", "Manual"}]}], "]"}]}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[2]:=",
 CellID->112010573],

Cell[CellGroupData[{

Cell["Definition", "SubsubsectionOpener",
 CellID->28159547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"def", " ", "=", " ", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"$Path", " ", "=", " ", "$GUIPath"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
    "Get", "[", "\"\<Wolfram/Example/ChooseColorDialog.m\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27412454],

Cell[BoxData[
 RowBox[{"Widget", "[", 
  RowBox[{"\<\"Panel\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Widget", "[", 
      RowBox[{"\<\"ColorChooser\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PropertyValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\<\"chooser\"\>", ",", "\<\"selectionModel\"\>"}], "}"}],
            ",", 
           RowBox[{"Name", "\[Rule]", "\<\"colorSelectionModel\"\>"}]}], 
          "]"}], ",", 
         RowBox[{"BindEvent", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\<\"colorSelectionModel\"\>", ",", "\<\"change\"\>"}], 
            "}"}], ",", 
           RowBox[{"Script", "[", 
            RowBox[{"updateColor", "[", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Name", "\[Rule]", "\<\"chooser\"\>"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"TextField\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"    \"\>"}], ",", 
           RowBox[{"\<\"editable\"\>", "\[Rule]", "False"}]}], "}"}], ",", 
         RowBox[{"WidgetLayout", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"None", ",", "None"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"Name", "\[Rule]", "\<\"myColorWell\"\>"}]}], "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"ComboBox\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"items\"\>", "\[Rule]", 
            RowBox[{"{", 
             
             RowBox[{"\<\"RGBColor\"\>", ",", "\<\"GrayLevel\"\>", 
              ",", "\<\"CMYKColor\"\>"}], "}"}]}], ",", 
           RowBox[{"BindEvent", "[", 
            RowBox[{"\<\"action\"\>", ",", 
             RowBox[{"Script", "[", 
              RowBox[{"updateColor", "[", "]"}], "]"}]}], "]"}]}], "}"}], ",",
          
         RowBox[{"Name", "\[Rule]", "\<\"myColorModel\"\>"}]}], "]"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"TextField\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"\"\>"}], "}"}], ",", 
         RowBox[{"Name", "\[Rule]", "\<\"myTextField\"\>"}]}], "]"}]}], "}"}],
      ",", 
     RowBox[{"Script", "[", 
      RowBox[{
       RowBox[{"colorExpr", "=", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"0", ",", "0", ",", "0"}], "]"}]}], ";", 
       RowBox[{
        RowBox[{"updateColor", "[", "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", "newColor", "}"}], ",", 
          RowBox[{
           RowBox[{"newColor", "=", 
            RowBox[{"PropertyValue", "[", 
             RowBox[{"{", 
              
              RowBox[{"\<\"colorSelectionModel\"\>", 
               ",", "\<\"selectedColor\"\>"}], "}"}], "]"}]}], ";", 
           RowBox[{"SetPropertyValue", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"myColorWell\"\>", ",", "\<\"background\"\>"}], 
              "}"}], ",", "newColor"}], "]"}], ";", 
           RowBox[{"colorExpr", "=", 
            RowBox[{"RGBColor", "[", 
             RowBox[{
              FractionBox[
               RowBox[{"PropertyValue", "[", 
                RowBox[{"{", 
                 RowBox[{"newColor", ",", "\<\"red\"\>"}], "}"}], "]"}], 
               "255.`"], ",", 
              FractionBox[
               RowBox[{"PropertyValue", "[", 
                RowBox[{"{", 
                 RowBox[{"newColor", ",", "\<\"green\"\>"}], "}"}], "]"}], 
               "255.`"], ",", 
              FractionBox[
               RowBox[{"PropertyValue", "[", 
                RowBox[{"{", 
                 RowBox[{"newColor", ",", "\<\"blue\"\>"}], "}"}], "]"}], 
               "255.`"]}], "]"}]}], ";", 
           RowBox[{"colorExpr", "=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Chop", "[", 
                RowBox[{"#1", ",", 
                 FractionBox["1", 
                  SuperscriptBox["10", "5"]]}], "]"}], "&"}], ")"}], "/@", 
             RowBox[{"ToColor", "[", 
              RowBox[{"colorExpr", ",", 
               RowBox[{"ToExpression", "[", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  
                  RowBox[{"\<\"myColorModel\"\>", 
                   ",", "\<\"selectedItem\"\>"}], "}"}], "]"}], "]"}]}], 
              "]"}]}]}], ";", 
           RowBox[{"SetPropertyValue", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"myTextField\"\>", ",", "\<\"text\"\>"}], "}"}], 
             ",", 
             RowBox[{"ToString", "[", 
              TagBox["colorExpr",
               NumberForm[#, 5]& ], "]"}]}], "]"}], ";"}]}], "]"}]}], ";"}], 
      "]"}], ",", 
     RowBox[{"BindEvent", "[", 
      RowBox[{"\<\"endModal\"\>", ",", 
       RowBox[{"Script", "[", "colorExpr", "]"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->116261242]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellID->133845090],

Cell[TextData[{
 "This example uses ",
 StyleBox["Widget[\"ColorChooser\"]", "Program"],
 " and includes sample code demonstrating how to"
}], "Text",
 CellID->572206693],

Cell[TextData[{
 "Bind a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " script to execute each time the selected color changes."
}], "BulletedText",
 CellID->795774740],

Cell["\<\
Create a custom color well whose background color changes with the selection.\
\
\>", "BulletedText",
 CellID->240991337],

Cell[TextData[{
 "Add a modal result binding so a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " color primitive is returned to the kernel when the dialog session ends."
}], "BulletedText",
 CellID->150069553],

Cell[CellGroupData[{

Cell[TextData[{
 "Define a utility wrapper function around the ",
 StyleBox["GUIRunModal", "Program"],
 " call, demonstrating a single reusable instance of the dialog used",
 " ",
 "throughout the lifetime of the kernel session."
}], "BulletedText",
 CellID->522721743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChooseColorDialog", "[", "]"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[3]:=",
 CellID->108132071],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0", ",", "0", ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->25227980]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIKit Example: ColorChooser - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 7.2406414}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "This example uses Widget[\"ColorChooser\"] and includes sample code \
demonstrating how to", "synonyms" -> {}, "title" -> 
    "GUIKit Example: ColorChooser", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/ColorChooser"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 118, 5, 70, "Title",
 CellID->554471618],
Cell[852, 36, 36, 1, 70, "Text",
 CellID->451251365],
Cell[891, 39, 10573, 175, 70, "Graphics",
 CellID->230352961],
Cell[CellGroupData[{
Cell[11489, 218, 51, 1, 70, "SubsectionOpener",
 CellID->36823909],
Cell[11543, 221, 166, 5, 70, "Input",
 InitializationCell->True,
 CellID->239207382],
Cell[11712, 228, 734, 20, 70, "Input",
 InitializationCell->True,
 CellID->112010573],
Cell[CellGroupData[{
Cell[12471, 252, 60, 1, 70, "SubsubsectionOpener",
 CellID->28159547],
Cell[CellGroupData[{
Cell[12556, 257, 342, 11, 70, "Input",
 CellID->27412454],
Cell[12901, 270, 5107, 130, 70, "Output",
 CellID->116261242]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18069, 407, 46, 1, 70, "Section",
 CellID->133845090],
Cell[18118, 410, 170, 5, 70, "Text",
 CellID->572206693],
Cell[18291, 417, 176, 6, 70, "BulletedText",
 CellID->795774740],
Cell[18470, 425, 131, 4, 70, "BulletedText",
 CellID->240991337],
Cell[18604, 431, 217, 6, 70, "BulletedText",
 CellID->150069553],
Cell[CellGroupData[{
Cell[18846, 441, 269, 7, 70, "BulletedText",
 CellID->522721743],
Cell[CellGroupData[{
Cell[19140, 452, 132, 4, 70, "Input",
 CellID->108132071],
Cell[19275, 458, 137, 4, 70, "Output",
 CellID->25227980]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[19463, 468, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

