(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30678,        735]
NotebookOptionsPosition[     25189,        557]
NotebookOutlinePosition[     28848,        664]
CellTagsIndexPosition[     28777,        659]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Creating Reusable Definitions", "Title",
 CellTags->"Reusable",
 CellID->134383825],

Cell[TextData[{
 "The ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " framework makes it relatively easy to reuse interface definitions because \
of its automatic use of private symbol contexts for each instance of a \
definition. There are, however, a number of points to keep in mind when \
writing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " script code for user interfaces."
}], "Text",
 CellTags->"Reusable",
 CellID->471484976],

Cell[TextData[{
 "Use ",
 StyleBox["Needs[\"Package`\"]", "Output"],
 " instead of ",
 StyleBox["Get[\"Package`\"]", "Output"],
 " to avoid unnecessary package reloading if multiple instances of an \
interface are possible."
}], "BulletedText",
 CellTags->"Reusable",
 CellID->105345872],

Cell[TextData[{
 "Avoid explicit use of contexted symbols such as ",
 StyleBox["MyPackage`MySymbol", "Output"],
 ", since this will be the same global variable for all instances of the \
interface.",
 " ",
 "This may, however, be a desired way of creating a global state shared \
between instances if that is what you intend."
}], "BulletedText",
 CellTags->"Reusable",
 CellID->260137090],

Cell[CellGroupData[{

Cell[TextData[{
 "Consider designing your definition with a root widget of ",
 Cell[BoxData["\"\<Panel\>\""], "InlineFormula"],
 " and not ",
 Cell[BoxData["\"\<Frame\>\""], "InlineFormula"],
 StyleBox[".", "Output"],
 " ",
 StyleBox["GUIKit`", "Output"],
 " will automatically wrap a panel in a window when it is displayed, and by \
not forcing a specific frame instance in your definition, another user can \
load your definition into their own window."
}], "BulletedText",
 CellTags->"Reusable",
 CellID->504073961],

Cell["\<\
Here is an example that shows how one definition can be easily used in \
another window with multiple instances, all separate in state but accessible \
in the new window.\
\>", "Text",
 CellTags->"Reusable",
 CellID->27241875],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Reusable",
 CellLabel->"In[1]:=",
 CellID->428057014],

Cell["\<\
As it is defined, the Counter example is a fully functional stand-alone \
compound widget comprising three individual widgets.\
\>", "Text",
 CellTags->"Reusable",
 CellID->59554323],

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\"\<Wolfram/Example/Counter\>\"", 
  "]"}]], "Input",
 CellTags->"Reusable",
 CellLabel->"In[2]:=",
 CellID->313019136],

Cell["\<\
Here is a screen shot of what a single Counter widget renders.\
\>", "Text",
 CellTags->"Reusable",
 CellID->64731098],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{159, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->151194373],

Cell[TextData[{
 "The Counter definition is also written so that multiple instances can be \
reused in the same window, and by using the ",
 Cell[BoxData[
  ButtonBox["ExposeWidgetReferences",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ExposeWidgetReferences"]], 
  "InlineFormula"],
 " option of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"], "[", "]"}]], "InlineFormula"],
 ", you can make sure each instance is registered with unique names within \
the new parent window."
}], "Text",
 CellTags->"Reusable",
 CellID->1021190],

Cell[BoxData[
 RowBox[{
  RowBox[{"def", " ", "=", " ", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", " ", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Wolfram/Example/Counter\>\"", ",", 
           RowBox[{
            StyleBox["ExposeWidgetReferences", "Output"], "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<textField\>\"", " ", "\[Rule]", " ", "\"\<textField1\>\""}],
              "}"}]}]}], "]"}], ",", " ", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Wolfram/Example/Counter\>\"", ",", 
           RowBox[{
            StyleBox["ExposeWidgetReferences", "Output"], "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<textField\>\"", " ", "\[Rule]", " ", "\"\<textField2\>\""}],
              "}"}]}]}], "]"}]}], " ", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Wolfram/Example/Counter\>\"", ",", 
           RowBox[{
            StyleBox["ExposeWidgetReferences", "Output"], "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<textField\>\"", " ", "\[Rule]", " ", "\"\<textField3\>\""}],
              "}"}]}]}], "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Wolfram/Example/Counter\>\"", ",", 
           RowBox[{
            StyleBox["ExposeWidgetReferences", "Output"], "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<textField\>\"", " ", "\[Rule]", " ", "\"\<textField4\>\""}],
              "}"}]}]}], "]"}]}], "}"}]}], "\[IndentingNewLine]", " ", 
      "}"}]}], "]"}]}], ";"}]], "Input",
 CellTags->"Reusable",
 CellLabel->"In[3]:=",
 CellID->14291425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "def", "]"}]}]], "Input",
 CellTags->"Reusable",
 CellLabel->"In[4]:=",
 CellID->344725960],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject399742488018945, 
   JLink`Objects`JavaObject189145326551041]]], "Output",
 CellTags->"Reusable",
 CellLabel->"Out[4]=",
 CellID->162958990]
}, Open  ]],

Cell["\<\
Here is a screen shot of what the multiple Counter widgets in a single panel \
renders.\
\>", "Text",
 CellTags->"Reusable",
 CellID->786234654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Reusable",
 CellLabel->"In[5]:=",
 CellID->46104741],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{313, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Reusable",
 CellLabel->"Out[5]=",
 CellID->63754310]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<WidgetNames\>\"", "/.", " ", 
  RowBox[{"GUIInformation", "[", "ref", " ", "]"}]}]], "Input",
 CellTags->"Reusable",
 CellLabel->"In[6]:=",
 CellID->511465398],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"textField1\"\>", ",", "\<\"textField2\"\>", 
   ",", "\<\"textField3\"\>", ",", "\<\"textField4\"\>"}], "}"}]], "Output",
 CellTags->"Reusable",
 CellLabel->"Out[6]=",
 CellID->539477962]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Creating Reusable Definitions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 8.1624692}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "The GUIKit framework makes it relatively easy to reuse interface \
definitions because of its automatic use of private symbol contexts for each \
instance of a definition. There are, however, a number of points to keep in \
mind when writing Mathematica script code for user interfaces. Here is an \
example that shows how one definition can be easily used in another window \
with multiple instances, all separate in state but accessible in the new \
window. As it is defined, the Counter example is a fully functional \
stand-alone compound widget comprising three individual widgets.", 
    "synonyms" -> {}, "title" -> "Creating Reusable Definitions", "type" -> 
    "Tutorial", "uri" -> "GUIKit/tutorial/CreatingReusableDefinitions"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Reusable"->{
  Cell[731, 29, 89, 2, 70, "Title",
   CellTags->"Reusable",
   CellID->134383825],
  Cell[823, 33, 446, 13, 70, "Text",
   CellTags->"Reusable",
   CellID->471484976],
  Cell[1272, 48, 287, 9, 70, "BulletedText",
   CellTags->"Reusable",
   CellID->105345872],
  Cell[1562, 59, 389, 10, 70, "BulletedText",
   CellTags->"Reusable",
   CellID->260137090],
  Cell[1976, 73, 518, 13, 70, "BulletedText",
   CellTags->"Reusable",
   CellID->504073961],
  Cell[2497, 88, 236, 6, 70, "Text",
   CellTags->"Reusable",
   CellID->27241875],
  Cell[2736, 96, 156, 5, 70, "Input",
   CellTags->"Reusable",
   CellID->428057014],
  Cell[2895, 103, 192, 5, 70, "Text",
   CellTags->"Reusable",
   CellID->59554323],
  Cell[3090, 110, 163, 5, 70, "Input",
   CellTags->"Reusable",
   CellID->313019136],
  Cell[3256, 117, 128, 4, 70, "Text",
   CellTags->"Reusable",
   CellID->64731098],
  Cell[12078, 271, 614, 18, 70, "Text",
   CellTags->"Reusable",
   CellID->1021190],
  Cell[12695, 291, 1826, 46, 70, "Input",
   CellTags->"Reusable",
   CellID->14291425],
  Cell[14546, 341, 162, 5, 70, "Input",
   CellTags->"Reusable",
   CellID->344725960],
  Cell[14711, 348, 293, 8, 70, "Output",
   CellTags->"Reusable",
   CellID->162958990],
  Cell[15019, 359, 154, 5, 70, "Text",
   CellTags->"Reusable",
   CellID->786234654],
  Cell[15198, 368, 133, 4, 70, "Input",
   CellTags->"Reusable",
   CellID->46104741],
  Cell[15334, 374, 9331, 158, 70, "Output",
   Evaluatable->False,
   CellTags->"Reusable",
   CellID->63754310],
  Cell[24702, 537, 187, 5, 70, "Input",
   CellTags->"Reusable",
   CellID->511465398],
  Cell[24892, 544, 231, 6, 70, "Output",
   CellTags->"Reusable",
   CellID->539477962]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Reusable", 27059, 597}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 89, 2, 70, "Title",
 CellTags->"Reusable",
 CellID->134383825],
Cell[823, 33, 446, 13, 70, "Text",
 CellTags->"Reusable",
 CellID->471484976],
Cell[1272, 48, 287, 9, 70, "BulletedText",
 CellTags->"Reusable",
 CellID->105345872],
Cell[1562, 59, 389, 10, 70, "BulletedText",
 CellTags->"Reusable",
 CellID->260137090],
Cell[CellGroupData[{
Cell[1976, 73, 518, 13, 70, "BulletedText",
 CellTags->"Reusable",
 CellID->504073961],
Cell[2497, 88, 236, 6, 70, "Text",
 CellTags->"Reusable",
 CellID->27241875],
Cell[2736, 96, 156, 5, 70, "Input",
 CellTags->"Reusable",
 CellID->428057014],
Cell[2895, 103, 192, 5, 70, "Text",
 CellTags->"Reusable",
 CellID->59554323],
Cell[3090, 110, 163, 5, 70, "Input",
 CellTags->"Reusable",
 CellID->313019136],
Cell[3256, 117, 128, 4, 70, "Text",
 CellTags->"Reusable",
 CellID->64731098],
Cell[3387, 123, 8688, 146, 70, "Output",
 Evaluatable->False,
 CellID->151194373],
Cell[12078, 271, 614, 18, 70, "Text",
 CellTags->"Reusable",
 CellID->1021190],
Cell[12695, 291, 1826, 46, 70, "Input",
 CellTags->"Reusable",
 CellID->14291425],
Cell[CellGroupData[{
Cell[14546, 341, 162, 5, 70, "Input",
 CellTags->"Reusable",
 CellID->344725960],
Cell[14711, 348, 293, 8, 70, "Output",
 CellTags->"Reusable",
 CellID->162958990]
}, Open  ]],
Cell[15019, 359, 154, 5, 70, "Text",
 CellTags->"Reusable",
 CellID->786234654],
Cell[CellGroupData[{
Cell[15198, 368, 133, 4, 70, "Input",
 CellTags->"Reusable",
 CellID->46104741],
Cell[15334, 374, 9331, 158, 70, "Output",
 Evaluatable->False,
 CellTags->"Reusable",
 CellID->63754310]
}, Open  ]],
Cell[CellGroupData[{
Cell[24702, 537, 187, 5, 70, "Input",
 CellTags->"Reusable",
 CellID->511465398],
Cell[24892, 544, 231, 6, 70, "Output",
 CellTags->"Reusable",
 CellID->539477962]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[25162, 555, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

