(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    339694,       7717]
NotebookOptionsPosition[    303226,       6511]
NotebookOutlinePosition[    322414,       7098]
CellTagsIndexPosition[    322135,       7087]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"], 
         "Center" :> Documentation`HelpLookup["paclet:ref/Center"], "False" :> 
         Documentation`HelpLookup["paclet:ref/False"], "Left" :> 
         Documentation`HelpLookup["paclet:ref/Left"], "Maximize" :> 
         Documentation`HelpLookup["paclet:ref/Maximize"], "None" :> 
         Documentation`HelpLookup["paclet:ref/None"], "True" :> 
         Documentation`HelpLookup["paclet:ref/True"], "Widget" :> 
         Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "WidgetGroup" :> 
         Documentation`HelpLookup["paclet:GUIKit/ref/WidgetGroup"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Automatic\"\>", 2->"\<\"Center\"\>", 
      3->"\<\"False\"\>", 4->"\<\"Left\"\>", 5->"\<\"Maximize\"\>", 
      6->"\<\"None\"\>", 7->"\<\"True\"\>", 8->"\<\"Widget\"\>", 
      9->"\<\"WidgetGroup\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Definition Building Blocks", "Title",
 CellTags->"BuildingBlocks",
 CellID->207257751],

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " definitions are defined as a hierarchy of widgets, whether they are \
defined in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression format or in the XML format, GUIKitXML. A single self-contained \
user interface definition should always begin with an outermost user \
interface widget\[LongDash]either an instance of a window or frame. The ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " framework also optionally provides an appropriate top-level window wrapper \
if the root interface definition widget is at least a user interface class \
that can live inside a window or frame, so you are not actually required to \
always use a top-level frame or window widget. This is convenient because it \
allows you to write reusable complex widgets by designing them with the root \
widget as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"], "[", "\"\<Panel\>\"", "]"}]], 
  "InlineFormula"],
 ". This could be run by itself or reused as content in other developer\
\[CloseCurlyQuote]s window definitions. Examples of reusing panel-designed \
higher-level widgets exist in subsequent documentation sections."
}], "Text",
 CellTags->"BuildingBlocks",
 CellID->77066093],

Cell[TextData[{
 "A ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " definition expression consists of a hierarchy of widget expressions."
}], "Text",
 CellTags->"BuildingBlocks",
 CellID->481889059],

Cell[BoxData[
 RowBox[{
  StyleBox["Widget",
   FontWeight->"Bold"], 
  StyleBox["[",
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox[
    RowBox[{"\<\"path/Frame\"\>", " ", "|", " ", "\<\"class:className\"\>"}], 
    "Output",
    FontWeight->"Plain"], 
   StyleBox[",", "Output",
    FontWeight->"Plain"], 
   StyleBox[" ", "Output",
    FontWeight->"Plain"], 
   RowBox[{
    StyleBox["{", "Output",
     FontWeight->"Plain"], 
    StyleBox["\n", "Output",
     FontWeight->"Plain"], 
    StyleBox["   ", "Output",
     FontWeight->"Plain"], 
    RowBox[{
     RowBox[{
      StyleBox["Widget",
       FontWeight->"Bold"], 
      StyleBox["[", "Output",
       FontWeight->"Plain"], 
      StyleBox[
       RowBox[{
        StyleBox["\<\"path/Button\"\>",
         FontWeight->"Plain"], 
        StyleBox[",",
         FontWeight->"Plain"], 
        StyleBox[" ",
         FontWeight->"Plain"], 
        RowBox[{
         StyleBox["{",
          FontWeight->"Plain"], 
         StyleBox["\n",
          FontWeight->"Plain"], 
         StyleBox["        ",
          FontWeight->"Plain"], 
         RowBox[{
          StyleBox["BindEvent",
           FontWeight->"Bold"], 
          StyleBox["[",
           FontWeight->"Plain"], 
          RowBox[{
           StyleBox["\<\"event name\"\>",
            FontWeight->"Plain"], 
           StyleBox[",",
            FontWeight->"Plain"], 
           StyleBox[" ",
            FontWeight->"Plain"], 
           RowBox[{
            StyleBox["Script",
             FontWeight->"Bold"], 
            StyleBox["[",
             FontWeight->"Plain"], 
            StyleBox["expr",
             FontWeight->"Plain"], 
            StyleBox["]",
             FontWeight->"Plain"]}]}], 
          StyleBox["]",
           FontWeight->"Plain"]}], 
         StyleBox["\n",
          FontWeight->"Plain"], 
         StyleBox["        ",
          FontWeight->"Plain"], 
         StyleBox["}",
          FontWeight->"Plain"]}], 
        StyleBox[",",
         FontWeight->"Plain"], 
        StyleBox[" ",
         FontWeight->"Plain"], 
        StyleBox[
         RowBox[{"Name", "\[Rule]", " ", "\<\"button obj\"\>"}],
         FontWeight->"Plain"]}], "Output"], 
      StyleBox["]", "Output",
       FontWeight->"Plain"]}], 
     StyleBox[",", "Output",
      FontWeight->"Plain"], 
     StyleBox["\n", "Output",
      FontWeight->"Plain"], 
     StyleBox["   ", "Output",
      FontWeight->"Plain"], 
     RowBox[{
      StyleBox["Script", "Output",
       FontWeight->"Bold"], 
      StyleBox["[", "Output",
       FontWeight->"Plain"], 
      StyleBox["\n", "Output",
       FontWeight->"Plain"], 
      StyleBox["      ", "Output",
       FontWeight->"Plain"], 
      RowBox[{
       StyleBox["expr", "Output",
        FontWeight->"Plain"], 
       StyleBox[";", "Output",
        FontWeight->"Plain"], 
       StyleBox["\n", "Output",
        FontWeight->"Plain"], 
       StyleBox["      ", "Output",
        FontWeight->"Plain"], 
       RowBox[{
        StyleBox["WidgetReference",
         FontWeight->"Bold"], 
        StyleBox["[", "Output",
         FontWeight->"Plain"], 
        StyleBox["\<\"model obj\"\>", "Output",
         FontWeight->"Plain"], 
        StyleBox["]", "Output",
         FontWeight->"Plain"]}]}], 
      StyleBox["\n", "Output",
       FontWeight->"Plain"], 
      StyleBox["      ", "Output",
       FontWeight->"Plain"], 
      StyleBox["]", "Output",
       FontWeight->"Plain"]}]}], 
    StyleBox["\n", "Output",
     FontWeight->"Plain"], 
    StyleBox["   ", "Output",
     FontWeight->"Plain"], 
    StyleBox["}", "Output",
     FontWeight->"Plain"]}], 
   StyleBox[",", "Output",
    FontWeight->"Plain"], 
   StyleBox[" ", "Output",
    FontWeight->"Plain"], 
   StyleBox[
    RowBox[{"Name", " ", "\[Rule]", " ", "\<\"root frame\"\>"}], "Output",
    FontWeight->"Plain"]}], 
  StyleBox["]",
   FontWeight->"Plain"]}]], "Output",
 CellFrame->True,
 CellDingbat->None,
 CellEditDuplicate->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"BuildingBlocks",
 CellID->400894521],

Cell["\<\
Some of the building blocks that make up a user interface definition include \
the following.\
\>", "Text",
 CellTags->"BuildingBlocks",
 CellID->20616337],

Cell["Request the creation of a new widget instance.", "Text",
 CellTags->"BuildingBlocks",
 CellID->108740951],

Cell[BoxData[
 StyleBox[
  RowBox[{"Widget", 
   StyleBox["[", "Output"], 
   StyleBox[
    RowBox[{
     RowBox[{"\<\"path\"\>", " ", "|", " ", "\<\"class:className\"\>"}], ",", 
     
     RowBox[{"{", 
      StyleBox[
       RowBox[{"definitions", " ", "and", " ", "child", " ", "widgets"}],
       FontSlant->"Italic"], "}"}], ",", " ", 
     RowBox[{"Name", " ", "\[Rule]", " ", "\<\"myName\"\>"}]}], "Output"], 
   StyleBox["]", "Output"]}],
  CellFrame->True,
  FontWeight->"Plain"]], "Input",
 CellDingbat->None,
 CellTags->"BuildingBlocks",
 CellID->14581203],

Cell[TextData[{
 StyleBox["Reference an existing widget previously registered under ",
  FontWeight->"Plain"],
 Cell[BoxData["myName"], "InlineFormula"],
 StyleBox[" (using the ",
  FontWeight->"Plain"],
 StyleBox["Name", "Output",
  FontWeight->"Plain"],
 StyleBox[" option). ",
  FontWeight->"Plain"]
}], "Text",
 CellDingbat->None,
 CellTags->"BuildingBlocks",
 CellID->422341648],

Cell[BoxData[
 StyleBox[
  RowBox[{"WidgetReference", "[", "\<\"myName\"\>", "]"}], "Output",
  FontWeight->"Plain"]], "Input",
 CellDingbat->None,
 CellTags->"BuildingBlocks",
 CellID->654150589],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " scripting code blocks contain arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programming code executed within the context of the user interface \
instance with access to the widget objects defined in the user interface. "
}], "Text",
 CellDingbat->None,
 CellTags->"BuildingBlocks",
 CellID->202996451],

Cell[BoxData[
 StyleBox[
  RowBox[{
   StyleBox[
    RowBox[{"Script", "[", 
     StyleBox["expr",
      FontSlant->"Italic"], "]"}], "Output"], " "}],
  FontWeight->"Plain"]], "Input",
 CellDingbat->None,
 CellTags->"BuildingBlocks",
 CellID->544168609],

Cell[TextData[{
 "Event binding provides triggers for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code to execute when certain events happen within the user interface."
}], "Text",
 CellDingbat->None,
 CellTags->"BuildingBlocks",
 CellID->30802201],

Cell[BoxData[
 StyleBox[
  RowBox[{"BindEvent", "[", 
   RowBox[{"\<\"eventName\"\>", ",", " ", 
    RowBox[{"Script", "[", 
     StyleBox["expr",
      FontSlant->"Italic"], "]"}]}], "]"}], "Output",
  FontWeight->"Plain"]], "Input",
 CellDingbat->None,
 CellTags->"BuildingBlocks",
 CellID->271983246],

Cell["\<\
Set or get the state and values of live widgets in the interface.\
\>", "Text",
 CellDingbat->None,
 CellTags->"BuildingBlocks",
 CellID->150937629],

Cell[BoxData[{
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"SetPropertyValue", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"widgetName\"\>", ",", "\<\"propertyName\"\>"}], "}"}], 
       ",", " ", "val"}], "]"}], "  ", "or", "   ", 
     RowBox[{"{", 
      RowBox[{"\<\"widgetName\"\>", ",", " ", "\<\"propertyName\"\>"}], 
      "}"}]}], " ", "\[Rule]", " ", "val"}], "  "}], "Output",
  FontWeight->"Plain"], "\n", 
 StyleBox[
  RowBox[{"PropertyValue", "[", 
   RowBox[{"{", 
    RowBox[{"\<\"widgetName\"\>", ",", " ", "\<\"propertyName\"\>"}], "}"}], 
   "]"}], "Output",
  FontWeight->"Plain"], "\n", 
 StyleBox[
  RowBox[{"PropertyValue", "[", 
   RowBox[{"{", 
    RowBox[{"\<\"widgetName\"\>", ",", " ", "\<\"propertyName\"\>", ",", " ", 
     "index"}], "}"}], "]"}], "Output",
  FontWeight->"Plain"]}], "Input",
 CellDingbat->None,
 CellTags->"BuildingBlocks",
 CellID->652084101],

Cell[TextData[{
 "If the widget definition requires arguments when it is created, you can set \
these with",
 " ",
 Cell[BoxData[
  ButtonBox["InitialArguments",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/InitialArguments"]], "InlineFormula"],
 "."
}], "Text",
 CellDingbat->None,
 CellTags->"BuildingBlocks",
 CellID->93279392],

Cell[TextData[{
 "There is an equivalent set of XML elements that define a user interface \
definition analogous to the previous ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " building block expressions."
}], "Text",
 CellTags->"BuildingBlocks",
 CellID->58215101],

Cell[CellGroupData[{

Cell["Widget Layout", "Section",
 CellTags->"LayoutIntro",
 CellID->4183354],

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " definitions are defined as a hierarchy, a \[OpenCurlyDoubleQuote]tree\
\[CloseCurlyDoubleQuote] expression, of widgets, but at the same time the \
definition\[CloseCurlyQuote]s nesting structure and list depth also \
determines how the widgets will visually lay themselves out at runtime. The \
goal of the layout rules is to make the most common and useful forms easy to \
represent in the definition, and at the same time provide the necessary \
optional rules to allow for finer control over the layout.",
 " ",
 "Additionally, the layout rules follow familiar ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list structures and do not require knowledge of the underlying Java \
rendering implementation layout APIs. This high-level abstraction of \
determining layout provides a simple, immediate, and intuitive layout as well \
as the necessary dynamic layout resizing features that all modern user \
interface dialogs are expected to adhere to when resized."
}], "Text",
 CellTags->"LayoutIntro",
 CellID->676891081],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[33]:=",
 CellID->530625823],

Cell[TextData[{
 "One can achieve a majority of the desired layout appearance of interface \
definitions by simply nesting widget expressions within other widget \
expressions and choosing the desired level of ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["\[Ellipsis]", "TR"], "}"}]], "InlineFormula"],
 " nesting to determine the resulting automatic vertical or horizontal \
grouping."
}], "Text",
 CellTags->"LayoutIntro",
 CellID->710281079],

Cell[TextData[{
 "The following basic heuristics are followed in the ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " widget layout system. "
}], "Text",
 CellTags->"LayoutIntro",
 CellID->426407796],

Cell[TextData[{
 "The outermost, top-level, list of widgets, children in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"], "[", 
   RowBox[{
    StyleBox["comp", "TI"], ",", 
    StyleBox["children_List", "TI"]}], "]"}]], "InlineFormula"],
 ", default to using a vertical (column) layout."
}], "BulletedText",
 CellTags->"LayoutIntro",
 CellID->312857142],

Cell["\<\
Each subsequent nested list alternates between a horizontal (row) and \
vertical (column) layout.\
\>", "BulletedText",
 CellTags->"LayoutIntro",
 CellID->477855102],

Cell[CellGroupData[{

Cell["\<\
Each type of widget has its own default horizontal and vertical stretching \
characteristics. For example, text fields automatically stretch in the \
horizontal direction but not vertically.\
\>", "BulletedText",
 CellTags->"LayoutIntro",
 CellID->413439933],

Cell["Here are some examples of these default layout features.", "Text",
 CellTags->"LayoutIntro",
 CellID->52547629],

Cell["\<\
By default, a list of children widgets are laid out vertically in a column \
starting from the left edge of the panel.\
\>", "Text",
 CellTags->"LayoutIntro",
 CellID->48674293],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Button\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}]}], "]"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Button\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Button B\>\""}], "}"}]}], "]"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Button\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Button C\>\""}], "}"}]}], 
         "]"}]}], " ", "}"}]}], "\[IndentingNewLine]", "]"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[34]:=",
 CellID->281756696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[35]:=",
 CellID->151235697],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutIntro",
 CellLabel->"Out[35]=",
 CellID->189450959]
}, Open  ]],

Cell["\<\
Nesting lists within a vertical layout creates horizontal layouts of these \
internal groupings.\
\>", "Text",
 CellTags->"LayoutIntro",
 CellID->78512451],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Button\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}]}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Button\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<Button B\>\""}], "}"}]}], 
           "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Button\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Button C\>\""}], "}"}]}], 
         "]"}]}], " ", "}"}]}], "\[IndentingNewLine]", "]"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[36]:=",
 CellID->3835829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[37]:=",
 CellID->927690540],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{159, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutIntro",
 CellLabel->"Out[37]=",
 CellID->640152825]
}, Open  ]],

Cell["\<\
Further nesting alternates with vertical and horizontal layout nesting.\
\>", "Text",
 CellTags->"LayoutIntro",
 CellID->119866090],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Button\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}]}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Button\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<Button B-1\>\""}], "}"}]}], 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Button\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<Button B-2\>\""}], "}"}]}], 
             "]"}]}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Button\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Button C\>\""}], "}"}]}], 
         "]"}]}], " ", "}"}]}], "\[IndentingNewLine]", "]"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[40]:=",
 CellID->782599332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[41]:=",
 CellID->13816330],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{169, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutIntro",
 CellLabel->"Out[41]=",
 CellID->204711540]
}, Open  ]],

Cell["\<\
Here you see how certain types of widgets default to maximize their sizes \
over other types of widgets, which adheres to typical user expectations.\
\>", "Text",
 CellTags->"LayoutIntro",
 CellID->160162000],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Frame\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Label\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<Label:\>\""}], "}"}]}], "]"}],
           ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<TextField\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<Input\>\""}], "}"}]}], 
           "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<TextArea\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Content\>\""}], "}"}]}], 
         "]"}]}], " ", "}"}], ",", " ", 
      RowBox[{"Name", " ", "\[Rule]", " ", "\"\<myFrame\>\""}]}], "]"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[45]:=",
 CellID->222451426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[43]:=",
 CellID->529367344],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutIntro",
 CellLabel->"Out[43]=",
 CellID->566679834]
}, Open  ]],

Cell["\<\
Note that with the new size of the window, the defaults cause the text field \
to resize horizontally, while the text area expands in both directions.\
\>", "Text",
 CellTags->"LayoutIntro",
 CellID->20250038],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"Script", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetPropertyValue", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<myFrame\>\"", ",", " ", "\"\<size\>\""}], "}"}], ",", " ",
       "\[IndentingNewLine]", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<Dimension\>\"", ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<width\>\"", "\[Rule]", "250"}], ",", " ", 
          RowBox[{"\"\<height\>\"", "\[Rule]", "150"}]}], "}"}]}], "]"}]}], 
     "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"InvokeMethod", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<myFrame\>\"", ",", " ", "\"\<validate\>\""}], "}"}], "]"}],
     ";"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[46]:=",
 CellID->92405274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[47]:=",
 CellID->184436626],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{250, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutIntro",
 CellLabel->"Out[47]=",
 CellID->350434148]
}, Open  ]],

Cell[TextData[{
 "When simple nesting of widgets is not enough to achieve the desired layout \
or resizing characteristics, there are a number of additional ",
 Cell[BoxData[
  ButtonBox["Widget",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Widget"]], "InlineFormula"],
 " interface definition expressions and options that can aid in tweaking the \
results. Namely, the additional definition expressions include ",
 Cell[BoxData[
  ButtonBox["WidgetGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetGroup"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["WidgetFill",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetFill"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["WidgetSpace",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetSpace"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["WidgetAlign",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetAlign"]], "InlineFormula"],
 ", and the ",
 Cell[BoxData[
  ButtonBox["Widget",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Widget"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["WidgetGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetGroup"]], "InlineFormula"],
 " options that can choose alternate default values for features, such as ",
 Cell[BoxData["\"\<Stretching\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Alignment\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Grouping\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Spacing\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<Border\>\""], "InlineFormula"],
 " elements."
}], "Text",
 CellTags->"LayoutIntro",
 CellID->468626323],

Cell["\<\
These additional expressions and options are introduced through the following \
visual examples.\
\>", "Text",
 CellTags->"LayoutIntro",
 CellID->447939170]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["WidgetGroup", "Section",
 CellTags->"WidgetGroup-Layout",
 CellID->254213160],

Cell[TextData[{
 "When the default layout alignment based on the depth of the list nesting is \
not appropriate, you can use the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WidgetGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetGroup"], "[", 
   RowBox[{
    RowBox[{"{", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], ",", 
    RowBox[{"WidgetLayout", "->", 
     ButtonBox["Row",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Row"]}]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WidgetGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetGroup"], "[", 
   RowBox[{
    RowBox[{"{", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], ",", 
    RowBox[{"WidgetLayout", "->", 
     ButtonBox["Column",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Column"]}]}], "]"}]], "InlineFormula"],
 " to explicitly specify the next alignment."
}], "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->736174],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["WidgetGroup",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/WidgetGroup"], "[", 
     RowBox[{
      RowBox[{"{", 
       StyleBox["\[Ellipsis]", "TR"], "}"}], ",", 
      RowBox[{"WidgetLayout", "->", "Row"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "explicitly force a horizontal layout of the child widgets", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["WidgetGroup",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/WidgetGroup"], "[", 
     RowBox[{
      RowBox[{"{", 
       StyleBox["\[Ellipsis]", "TR"], "}"}], ",", 
      RowBox[{"WidgetLayout", " ", "->", "Column"}]}], "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell[
    "explicitly force a vertical layout of the child widgets", "TableText"]}
  }]], "DefinitionBox",
 CellID->5810395],

Cell[TextData[{
 "The basic forms of ",
 Cell[BoxData[
  ButtonBox["WidgetGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetGroup"]], "InlineFormula"],
 " usage."
}], "Caption",
 CellTags->"WidgetGroup-Layout",
 CellID->47404517],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["WidgetGroup",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/WidgetGroup"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["group", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["group", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", " ", "\n", "\t", 
      RowBox[{"WidgetLayout", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<Grouping\>\"", "->", 
         RowBox[{"{", 
          RowBox[{"Tabs", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<Tab \!\(\*SubscriptBox[\"Label\", 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<Tab \!\(\*SubscriptBox[\"Label\", 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
             StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "}"}]}]}], 
     "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "place the labeled tabs at the top of the generated tab pane ", 
     "TableText"]},
   {
    RowBox[{
     RowBox[{
      RowBox[{
       ButtonBox["WidgetGroup",
        BaseStyle->"Link",
        ButtonData->"paclet:GUIKit/ref/WidgetGroup"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["group", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["group", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", " ", "\n", "\t", 
        RowBox[{"WidgetLayout", "->", 
         RowBox[{"{", 
          RowBox[{"\"\<Grouping\>\"", "->", 
           RowBox[{"{", 
            RowBox[{
            "Tabs", ",", "Bottom", ",", 
             "\"\<Tab \!\(\*SubscriptBox[\"Label\", 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<Tab \!\(\*SubscriptBox[\"Label\", 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
             StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}]}]}], "}"}], 
     "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
 
 place the labeled tabs at the bottom\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->27265271],

Cell["Groups displayed in tabbed panes.", "Caption",
 CellTags->"WidgetGroup-Layout",
 CellID->651244033],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["WidgetGroup",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/WidgetGroup"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["group", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["group", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      RowBox[{"WidgetLayout", "->", "Split"}], ",", 
      RowBox[{"Name", "->", "\"\<mySplitPane\>\""}]}], "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "place a resizable split bar between the two groups and optionally name \
the generated split pane as ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"mySplitPane\", \"TI\"]\)\>\""], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["WidgetGroup",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/WidgetGroup"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["group", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["group", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      RowBox[{"WidgetLayout", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<Grouping\>\"", "->", 
         RowBox[{"{", 
          RowBox[{"Split", ",", "Vertical"}], "}"}]}], "}"}]}]}], "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell["use a vertical split bar", "TableText"]},
   {
    RowBox[{
     ButtonBox["WidgetGroup",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/WidgetGroup"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["group", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["group", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      RowBox[{"WidgetLayout", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<Grouping\>\"", "->", 
         RowBox[{"{", 
          RowBox[{"Split", ",", "Horizontal"}], "}"}]}], "}"}]}]}], "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell["use a horizontal split bar", "TableText"]}
  }]], "DefinitionBox",
 CellID->677181514],

Cell["Groups displayed in split panes.", "Caption",
 CellTags->"WidgetGroup-Layout",
 CellID->102489988],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["WidgetGroup",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/WidgetGroup"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         StyleBox["\[Ellipsis]", "TR"], "}"}], ",", 
        RowBox[{"{", 
         StyleBox["\[Ellipsis]", "TR"], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"WidgetLayout", "->", "Grid"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
use a grid of evenly aligned elements as an alternative to multiple nested \
row and column lists (but this form has some limits as to resizing and \
staggering of child widget lists)\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->276454172],

Cell["Grid-based groupings.", "Caption",
 CellTags->"WidgetGroup-Layout",
 CellID->124603550],

Cell["\<\
You can override what would normally be a vertical layout by explicitly \
choosing a top-level row layout.\
\>", "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->74965106],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"WidgetGroup", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Button\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}]}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Button\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<Button B\>\""}], "}"}]}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Button\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<Button C\>\""}], "}"}]}], 
           "]"}]}], " ", "}"}], ",", " ", 
        RowBox[{"WidgetLayout", "\[Rule]", "Row"}]}], "]"}]}], 
     "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[48]:=",
 CellID->152636715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[49]:=",
 CellID->38526110],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{235, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"WidgetGroup-Layout",
 CellLabel->"Out[49]=",
 CellID->371634057]
}, Open  ]],

Cell["\<\
Nested lists still use the automatic alternating horizontal and vertical \
layouts and so the child list will now be a column.\
\>", "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->693032320],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"WidgetGroup", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Button\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}]}], 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Button\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<Button B\>\""}], "}"}]}], 
             "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Button\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<Button C\>\""}], "}"}]}], 
           "]"}]}], " ", "}"}], ",", " ", 
        RowBox[{"WidgetLayout", "\[Rule]", "Row"}]}], "]"}]}], 
     "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[51]:=",
 CellID->105481360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[52]:=",
 CellID->606050450],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{159, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"WidgetGroup-Layout",
 CellLabel->"Out[52]=",
 CellID->53054195]
}, Open  ]],

Cell[TextData[{
 "You can explicitly replace any and all lists of widgets with ",
 Cell[BoxData[
  ButtonBox["WidgetGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetGroup"]], "InlineFormula"],
 " expressions."
}], "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->105430984],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"WidgetGroup", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Button\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}]}], 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"WidgetGroup", "[", 
             RowBox[{
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"Widget", "[", 
                 RowBox[{"\"\< Button\>\"", ",", 
                  RowBox[{"{", 
                   RowBox[{"\"\<text\>\"", "->", "\"\<Button B-1\>\""}], 
                   "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"Widget", "[", 
                 RowBox[{"\"\<Button\>\"", ",", 
                  RowBox[{"{", 
                   RowBox[{"\"\<text\>\"", "->", "\"\<Button B-2\>\""}], 
                   "}"}]}], "]"}]}], "}"}], ",", " ", 
              RowBox[{"WidgetLayout", "\[Rule]", "Column"}]}], "]"}]}], "}"}],
           ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Button\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<Button C\>\""}], "}"}]}], 
           "]"}]}], " ", "}"}], ",", " ", 
        RowBox[{"WidgetLayout", "\[Rule]", "Row"}]}], "]"}]}], 
     "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[53]:=",
 CellID->20625932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[54]:=",
 CellID->282733247],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"WidgetGroup-Layout",
 CellLabel->"Out[54]=",
 CellID->317523812]
}, Open  ]],

Cell[TextData[{
 "Here you see an example of the ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " grouping."
}], "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->238292314],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
      RowBox[{"WidgetGroup", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Label\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<A:\>\""}], "}"}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<TextField\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<A content\>\""}], "}"}]}], 
             "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Label\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<B:\>\""}], "}"}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<TextField\>\"", ",", 
              RowBox[{"{", 
               RowBox[{
               "\"\<text\>\"", "->", 
                "\"\<B content is the largest of all\>\""}], "}"}]}], "]"}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Label\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<C:\>\""}], "}"}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<TextField\>\"", ",", 
              RowBox[{"{", 
               RowBox[{
               "\"\<text\>\"", "->", "\"\<C content is larger than A\>\""}], 
               "}"}]}], "]"}]}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
        " ", 
        RowBox[{"WidgetLayout", "\[Rule]", "Grid"}]}], "]"}]}], 
     "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[55]:=",
 CellID->604589238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[56]:=",
 CellID->86790732],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{170, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"WidgetGroup-Layout",
 CellLabel->"Out[56]=",
 CellID->94171741]
}, Open  ]],

Cell["\<\
Here is an example that generates content within a set of tabbed panes.\
\>", "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->88637711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"WidgetGroup", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Button\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}]}], 
            "]"}], ",", " ", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<TextField\>\"", ",", " ", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<someA\>\""}], "}"}]}], 
            "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Button\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<Button B\>\""}], "}"}]}], 
            "]"}], ",", " ", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<TextField\>\"", ",", " ", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<someB\>\""}], "}"}]}], 
            "]"}]}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", " ", 
       RowBox[{"Name", "->", "\"\<myTabPane\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"WidgetLayout", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Grouping\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Tabs", ",", " ", "Bottom", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<One\>\"", ",", "\"\<Two\>\""}], "}"}]}], "}"}]}], 
         "}"}]}]}], "]"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[57]:=",
 CellID->160310503],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject222464458096641, 
   JLink`Objects`JavaObject508012070436865]]], "Output",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"Out[57]=",
 CellID->171533550]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[58]:=",
 CellID->99108442],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"WidgetGroup-Layout",
 CellLabel->"Out[58]=",
 CellID->23138463]
}, Open  ]],

Cell[TextData[{
 "Each element of the tabbed ",
 Cell[BoxData[
  ButtonBox["WidgetGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetGroup"]], "InlineFormula"],
 " can be a list of widgets that populate one tab panel or a single widget \
whose contents will be placed within one pane."
}], "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->372875710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"WidgetGroup", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Widget", "[", "\"\<Wolfram/Example/PrimeFinder\>\"", "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{
         "Widget", "[", "\"\<Wolfram/Example/CellularGroup\>\"", "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", " ", 
       RowBox[{"Name", "->", "\"\<myTabPane\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"WidgetLayout", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Grouping\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Tabs", ",", " ", "Top", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<One\>\"", ",", "\"\<Two\>\""}], "}"}]}], "}"}]}], 
         "}"}]}]}], "]"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[59]:=",
 CellID->190877378],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject88630878011393, 
   JLink`Objects`JavaObject453175706386433]]], "Output",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"Out[59]=",
 CellID->187427382]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[60]:=",
 CellID->1255302],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{267, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"WidgetGroup-Layout",
 CellLabel->"Out[60]=",
 CellID->58094532]
}, Open  ]],

Cell["\<\
Here is an example that uses a split pane and illustrates how you can \
optionally name the split pane so it can be manipulated using its properties \
at runtime.\
\>", "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->553675268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"WidgetGroup", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "->", "\"\<Button B\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetGroup", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Widget", "[", 
              RowBox[{"\"\<Button\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}]}], 
              "]"}], ",", " ", 
             RowBox[{"Widget", "[", 
              RowBox[{"\"\<TextField\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{"\"\<text\>\"", "->", "\"\<some\>\""}], "}"}]}], 
              "]"}]}], "}"}], ",", " ", 
           RowBox[{"WidgetLayout", "\[Rule]", "Column"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", " ", 
       RowBox[{"WidgetLayout", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Grouping\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Split", ",", " ", "Vertical"}], "}"}]}], "}"}]}], ",", 
       " ", 
       RowBox[{"Name", "->", "\"\<mySplitPane\>\""}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[68]:=",
 CellID->46931197],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject521827688382465, 
   JLink`Objects`JavaObject97792714342401]]], "Output",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"Out[68]=",
 CellID->343244913]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[62]:=",
 CellID->85223380],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"WidgetGroup-Layout",
 CellLabel->"Out[62]=",
 CellID->12616129]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"PropertyValue", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<mySplitPane\>\"", ",", " ", "\"\<dividerLocation\>\""}], 
    "}"}], "]"}]}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[64]:=",
 CellID->12352742],

Cell[BoxData["24"], "Output",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"Out[64]=",
 CellID->829365268]
}, Open  ]],

Cell["\<\
If you resize the panel a little larger, you can see that you can \
programmatically move the divider position.\
\>", "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->333061563],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<mySplitPane\>\"", ",", " ", "\"\<dividerLocation\>\""}], 
     "}"}], ",", " ", "50"}], "]"}]}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[69]:=",
 CellID->42677794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[70]:=",
 CellID->57595616],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 160},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"WidgetGroup-Layout",
 CellLabel->"Out[70]=",
 CellID->255428165]
}, Open  ]],

Cell["\<\
You can also call a method by taking a percentage value instead of using the \
integer property value.\
\>", "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->132321816],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<mySplitPane\>\"", ",", " ", "\"\<setDividerLocation\>\""}], 
     "}"}], ",", " ", "0.50"}], "]"}]}]], "Input",
 CellTags->"WidgetGroup-Layout",
 CellLabel->"In[71]:=",
 CellID->126564805]
}, Open  ]],

Cell[CellGroupData[{

Cell["WidgetFill", "Section",
 CellTags->"WidgetFill",
 CellID->743211123],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["WidgetFill",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetFill"], "[", "]"}]], 
  "InlineFormula"],
 " elements can be useful as \"expanding springs\" that force themselves to \
expand as much as possible along the layout direction they are placed and \
force other widgets within their group to be \"pushed\" to one side."
}], "Text",
 CellTags->"WidgetFill",
 CellID->130533395],

Cell[TextData[{
 "Perhaps the most common use of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WidgetFill",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetFill"], "[", "]"}]], 
  "InlineFormula"],
 " is to force a set of horizontal buttons to be right aligned in a dialog \
when resizing."
}], "Text",
 CellTags->"WidgetFill",
 CellID->90465118],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<TextArea\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
            "\"\<text\>\"", " ", "\[Rule]", " ", "\"\<Some content\>\""}], 
            ",", " ", 
            RowBox[{"\"\<rows\>\"", "\[Rule]", "4"}], ",", " ", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "30"}]}], "}"}]}], "]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"WidgetFill", "[", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Button\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<OK\>\""}], "}"}]}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Button\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Cancel\>\""}], "}"}]}], 
           "]"}]}], "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", 
       "}"}]}], "]"}], " ", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->"WidgetFill",
 CellLabel->"In[72]:=",
 CellID->548476858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"WidgetFill",
 CellLabel->"In[73]:=",
 CellID->86405417],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{218, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"WidgetFill",
 CellLabel->"Out[73]=",
 CellID->474215232]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["WidgetSpace", "Section",
 CellTags->"WidgetSpace",
 CellID->298395669],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["WidgetSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetSpace"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " elements can be useful as simple spacers that create an explicit spacing \
element between widgets along the layout direction they are placed."
}], "Text",
 CellTags->"WidgetSpace",
 CellID->596062023],

Cell["Here you add a little explicit spacing between the buttons.", "Text",
 CellTags->"WidgetSpace",
 CellID->200946096],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<TextArea\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
            "\"\<text\>\"", " ", "\[Rule]", " ", "\"\<Some content\>\""}], 
            ",", " ", 
            RowBox[{"\"\<rows\>\"", "\[Rule]", "4"}], ",", " ", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "30"}]}], "}"}]}], "]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"WidgetFill", "[", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Button\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<OK\>\""}], "}"}]}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"WidgetSpace", "[", "10", "]"}], ",", "\[IndentingNewLine]",
           
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Button\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Cancel\>\""}], "}"}]}], 
           "]"}]}], "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", 
       "}"}]}], "]"}], " ", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->"WidgetSpace",
 CellLabel->"In[74]:=",
 CellID->275948564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"WidgetSpace",
 CellLabel->"In[75]:=",
 CellID->333960826],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{218, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"WidgetSpace",
 CellLabel->"Out[75]=",
 CellID->164314015]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["WidgetAlign", "Section",
 CellTags->"WidgetAlign",
 CellID->508749644],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["WidgetAlign",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetAlign"], "[", "]"}]], 
  "InlineFormula"],
 " elements work as placeholder elements within groups of widget lists, and, \
for each one that exists within sibling lists, they will attempt to align \
themselves with other instances of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WidgetAlign",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetAlign"], "[", "]"}]], 
  "InlineFormula"],
 " forcing a certain grid structure to exist without forcing the same number \
of widgets to exist between each align markers. They function somewhat \
analogous to tab markers in word processing documents."
}], "Text",
 CellTags->"WidgetAlign",
 CellID->68187356],

Cell[TextData[{
 "Another more advanced form of ",
 Cell[BoxData[
  ButtonBox["WidgetAlign",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetAlign"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WidgetAlign",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetAlign"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"widgetName\", \"TI\"]\)\>\"", ",", 
      RowBox[{"After", "|", "Before"}]}], "}"}], ",", 
    RowBox[{"Before", "|", "After"}]}], "]"}]], "InlineFormula"],
 ", which specifies that the very next widget following the ",
 Cell[BoxData[
  ButtonBox["WidgetAlign",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetAlign"]], "InlineFormula"],
 " should align its beginning or end (",
 Cell[BoxData["Before"], "InlineFormula"],
 " or ",
 Cell[BoxData["After"], "InlineFormula"],
 ") with another widget named ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"widgetName\", \"TI\"]\)\>\""], "InlineFormula"],
 " along either its beginning or end. This form has somewhat limited use and \
requires properly named widget dependencies in an appropriate location to \
work well."
}], "Text",
 CellTags->"WidgetAlign",
 CellID->213398956],

Cell[TextData[{
 "Here you place ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WidgetAlign",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetAlign"], "[", "]"}]], 
  "InlineFormula"],
 " marker elements where ",
 "you",
 " would like sibling widget lists to align."
}], "Text",
 CellTags->"WidgetAlign",
 CellID->373462017],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"WidgetAlign",
 CellLabel->"In[76]:=",
 CellID->36416744],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<TextField\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<A1\>\""}], "}"}]}], "]"}], 
          ",", " ", "\[IndentingNewLine]", 
          RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<TextField\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<A2\>\""}], "}"}]}], "]"}], 
          ",", " ", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<TextField\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<A3\>\""}], "}"}]}], "]"}], 
          ",", " ", "\[IndentingNewLine]", 
          RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<TextField\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<A4\>\""}], "}"}]}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<TextField\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<B1\>\""}], "}"}]}], "]"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<TextField\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<B2\>\""}], "}"}]}], "]"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<TextField\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<B3\>\""}], "}"}]}], "]"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<TextField\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<B4\>\""}], "}"}]}], "]"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<TextField\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<text\>\"", "->", "\"\<B5\>\""}], "}"}]}], "]"}]}], 
         "\[IndentingNewLine]", "}"}]}], " ", "\[IndentingNewLine]", "}"}]}], 
     "]"}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->"WidgetAlign",
 CellLabel->"In[77]:=",
 CellID->17672610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"WidgetAlign",
 CellLabel->"In[78]:=",
 CellID->151409983],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{169, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"WidgetAlign",
 CellLabel->"Out[78]=",
 CellID->181369110]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["WidgetLayout Options", "Section",
 CellTags->"LayoutOptions",
 CellID->433011481],

Cell[TextData[{
 "As you have seen earlier, ",
 Cell[BoxData["WidgetLayout"], "InlineFormula"],
 " is an option for ",
 Cell[BoxData[
  ButtonBox["WidgetGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetGroup"]], "InlineFormula"],
 " that can specify the grouping directions for the containing widgets. \
Actually, this form of ",
 Cell[BoxData[
  RowBox[{"WidgetLayout", "->", 
   StyleBox["groupValue", "TI"]}]], "InlineFormula"],
 " is a shorthand form for ",
 Cell[BoxData[
  RowBox[{"WidgetLayout", "->", 
   RowBox[{"{", 
    RowBox[{"\"\<Grouping\>\"", "->", 
     StyleBox["groupValue", "TI"]}], "}"}]}]], "InlineFormula"],
 ". As it turns out, there are a number of different suboptions of ",
 Cell[BoxData["WidgetLayout"], "InlineFormula"],
 " that provide different tweaks to layouts. The short form for grouping is \
available as it is very common to only use ",
 Cell[BoxData["WidgetLayout"], "InlineFormula"],
 " to specify a grouping choice. "
}], "Text",
 CellTags->"LayoutOptions",
 CellID->49063638],

Cell[TextData[{
 "One other short form use of ",
 Cell[BoxData["WidgetLayout"], "InlineFormula"],
 " is used with ",
 Cell[BoxData[
  ButtonBox["Widget",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Widget"]], "InlineFormula"],
 " and that is for the special case when you want to create a user interface \
widget, but you do not want to have the widget automatically added to the \
layout of its parent widget. In this case, you would turn off any widget \
layout work using ",
 Cell[BoxData[
  RowBox[{"WidgetLayout", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"LayoutOptions",
 CellID->474391247],

Cell[BoxData[GridBox[{
   {
    RowBox[{"WidgetLayout", "->", 
     StyleBox["groupValue", "TI"]}], Cell[TextData[{
     "shorthand form of ",
     Cell[BoxData[
      RowBox[{"WidgetLayout", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<Grouping\>\"", "->", 
         StyleBox["groupValue", "TI"]}], "}"}]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"WidgetLayout", "->", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell[TextData[{
     "an option to ",
     Cell[BoxData[
      ButtonBox["Widget",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/Widget"]], "InlineFormula"],
     " to turn off any automatic interface layouts with its parent widget"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->571368704],

Cell[TextData[{
 "Forms of ",
 Cell[BoxData["WidgetLayout"], "InlineFormula"],
 " use."
}], "Caption",
 CellTags->"LayoutOptions",
 CellID->346286636],

Cell[TextData[{
 "Along with ",
 Cell[BoxData["\"\<Grouping\>\""], "InlineFormula"],
 ", which allows all forms previously documented for the short form of ",
 Cell[BoxData["WidgetLayout"], "InlineFormula"],
 ": ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", the following other ",
 Cell[BoxData["WidgetLayout"], "InlineFormula"],
 " suboptions exist."
}], "Text",
 CellTags->"LayoutOptions",
 CellID->92411903],

Cell[CellGroupData[{

Cell["\"Grouping\"", "Subsection",
 CellTags->"LayoutOptions",
 CellID->280771899],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<Grouping\>\"", "->", 
   StyleBox["groupValue", "TI",
    FontSlant->"Italic"]}]], "InlineFormula"],
 " takes on all grouping values documented for ",
 Cell[BoxData["WidgetLayout"], "InlineFormula"],
 " short forms mentioned so far, and this suboption form must be used when \
combined with other ",
 Cell[BoxData["WidgetLayout"], "InlineFormula"],
 " suboptions for a given ",
 Cell[BoxData[
  ButtonBox["WidgetGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetGroup"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"LayoutOptions",
 CellID->59596289],

Cell[TextData[{
 "See examples of ",
 Cell[BoxData[
  RowBox[{"WidgetLayout", "->", 
   StyleBox["groupValue", "TI",
    FontSlant->"Italic"]}]], "InlineFormula"],
 " in the previous sections for examples of ",
 Cell[BoxData["\"\<Grouping\>\""], "InlineFormula"],
 " use."
}], "Text",
 CellTags->"LayoutOptions",
 CellID->588448603]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Stretching\"", "Subsection",
 CellTags->"LayoutOptions",
 CellID->849005102],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Stretching\>\""], "InlineFormula"],
 " suboption is supported both for ",
 Cell[BoxData[
  ButtonBox["Widget",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Widget"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["WidgetGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetGroup"]], "InlineFormula"],
 " and is useful to specify an explicit horizontal and vertical stretching \
for a widget that may be different than the default stretching \
characteristics for a given widget type.",
 " ",
 "Both a horizontal and vertical stretching value can be specified with \
allowable values: ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["WidgetAlign",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetAlign"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"LayoutOptions",
 CellID->5389376],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\"\<Stretching\>\"", "->", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["horizontal", "TI"], ",", 
       StyleBox["vertical", "TI"]}], "}"}]}], Cell["\<\
override any default stretching characteristics for a given widget\
\>", "TableText"]},
   {
    RowBox[{"\"\<Stretching\>\"", "->", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell[
    "keep a widget from stretching from its initial size", "TableText"]},
   {
    RowBox[{"\"\<Stretching\>\"", "->", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell[TextData[{
     "same as ",
     Cell[BoxData[
      RowBox[{"\"\<Stretching\>\"", "->", 
       ButtonBox["None",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/None"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"\"\<Stretching\>\"", "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell[TextData[{
     "allow stretching, but another widget with ",
     Cell[BoxData[
      ButtonBox["Maximize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
     " stretching may limit stretching if it exists"
    }], "TableText"]},
   {
    RowBox[{"\"\<Stretching\>\"", "->", "Maximize"}], Cell["\<\
allow stretching and also prioritize this widget's stretching over others \
that may simply allow stretching\
\>", "TableText"]},
   {
    RowBox[{"\"\<Stretching\>\"", "->", "WidgetAlign"}], Cell["\<\
allow stretching, but only to the extent needed to make a widget the same \
size as sibling widgets in its list\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->3017254],

Cell[TextData[{
 "Uses of ",
 Cell[BoxData["\"\<Stretching\>\""], "InlineFormula"],
 StyleBox[" ", "MR"],
 "suboption."
}], "Caption",
 CellTags->"LayoutOptions",
 CellID->153553618],

Cell[TextData[{
 "By default, labels do not stretch and text fields do, but ",
 "you",
 " can override this with explicit ",
 Cell[BoxData["\"\<Stretching\>\""], "InlineFormula"],
 " values."
}], "Text",
 CellTags->"LayoutOptions",
 CellID->40932611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Frame\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "->", "\"\<Label:\>\""}], "}"}], ",", " ",
            
           RowBox[{"WidgetLayout", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<Stretching\>\"", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"True", ",", " ", "False"}], "}"}]}], "}"}]}]}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "->", "\"\<Input\>\""}], "}"}], ",", " ", 
           
           RowBox[{"WidgetLayout", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<Stretching\>\"", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"False", ",", " ", "False"}], "}"}]}], "}"}]}]}], 
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<TextArea\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "->", "\"\<Content\>\""}], "}"}]}], "]"}]}],
       " ", "}"}], ",", " ", 
     RowBox[{"Name", " ", "\[Rule]", " ", "\"\<myFrame\>\""}]}], "]"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[81]:=",
 CellID->73138050],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject214184314798081, 
   JLink`Objects`JavaObject69177746391041]]], "Output",
 CellTags->"LayoutOptions",
 CellLabel->"Out[81]=",
 CellID->262141554]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[80]:=",
 CellID->632320240],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutOptions",
 CellLabel->"Out[80]=",
 CellID->214181374]
}, Open  ]],

Cell["This is more apparent with a window resize.", "Text",
 CellTags->"LayoutOptions",
 CellID->143992460],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<myFrame\>\"", ",", " ", "\"\<size\>\""}], "}"}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"ref", " ", "@", " ", 
     RowBox[{"Widget", "[", 
      RowBox[{"\"\<Dimension\>\"", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<width\>\"", "\[Rule]", "250"}], ",", " ", 
         RowBox[{"\"\<height\>\"", "\[Rule]", "150"}]}], "}"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[82]:=",
 CellID->753371332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[83]:=",
 CellID->83844549],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{250, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutOptions",
 CellLabel->"Out[83]=",
 CellID->150723109]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Alignment\"", "Subsection",
 CellTags->"LayoutOptions",
 CellID->365057109],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Alignment\>\""], "InlineFormula"],
 " suboption is supported both for ",
 Cell[BoxData[
  ButtonBox["Widget",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Widget"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["WidgetGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetGroup"]], "InlineFormula"],
 " and can be used to specify both horizontal and vertical alignments. The \
default alignment value along the vertical axis is ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 " and can take values of ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 ", and alignment on the horizontal axis defaults to ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ", allowing values of ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ".",
 " ",
 "Using ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " for either of these axes will choose the appropriate default."
}], "Text",
 CellTags->"LayoutOptions",
 CellID->6028309],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\"\<Alignment\>\"", "->", 
     RowBox[{"{", 
      RowBox[{
       ButtonBox["Automatic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Automatic"], ",", 
       ButtonBox["Automatic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Automatic"]}], "}"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "equivalent to ",
     Cell[BoxData[
      RowBox[{"\"\<Alignment\>\"", "->", 
       RowBox[{"{", 
        RowBox[{
         ButtonBox["Left",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Left"], ",", 
         ButtonBox["Center",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Center"]}], "}"}]}]], "InlineFormula"],
     "."
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->33423162],

Cell[TextData[{
 "Uses of ",
 Cell[BoxData["\"\<Alignment\>\""], "InlineFormula"],
 " suboption."
}], "Caption",
 CellTags->"LayoutOptions",
 CellID->272144837],

Cell["\<\
It is very common to have a set of labels for text fields right align with \
the corresponding input fields.\
\>", "Text",
 CellTags->"LayoutOptions",
 CellID->369674388],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
      RowBox[{"WidgetGroup", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Label\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<One:\>\""}], "}"}], ",", 
              " ", 
              RowBox[{"WidgetLayout", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"\"\<Alignment\>\"", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"Right", ",", " ", "Automatic"}], "}"}]}], 
                "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<TextField\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<A content\>\""}], "}"}]}], 
             "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Label\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<OneLonger:\>\""}], "}"}], 
              ",", " ", 
              RowBox[{"WidgetLayout", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"\"\<Alignment\>\"", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"Right", ",", " ", "Automatic"}], "}"}]}], 
                "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<TextField\>\"", ",", 
              RowBox[{"{", 
               RowBox[{
               "\"\<text\>\"", "->", 
                "\"\<B content is the largest of all\>\""}], "}"}]}], "]"}]}],
            "}"}]}], "\[IndentingNewLine]", "}"}], ",", " ", 
        RowBox[{"WidgetLayout", "\[Rule]", "Grid"}]}], "]"}]}], 
     "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[84]:=",
 CellID->215568927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[85]:=",
 CellID->10653807],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{216, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutOptions",
 CellLabel->"Out[85]=",
 CellID->196187098]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Border\"", "Subsection",
 CellTags->"LayoutOptions",
 CellID->987318962],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Border\>\""], "InlineFormula"],
 " suboption is a convenient way of building common border styles around \
groups of widgets.",
 " ",
 "Three common types include borders specifying spacing only, a titled border \
with a name and ruled frame, and a simple line border with a thickness and \
optional color value."
}], "Text",
 CellTags->"LayoutOptions",
 CellID->504544216],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\"\<Border\>\"", "->", "\"\<title\>\""}], Cell[
    "create a titled border style with a ruled outline", "TableText"]},
   {
    RowBox[{"\"\<Border\>\"", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox["left", "TI"], ",", 
         StyleBox["right", "TI"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["top", "TI"], ",", 
         StyleBox["bottom", "TI"]}], "}"}]}], "}"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
create a border of spacing different for each of the four edges\
\>", "TableText"]},
   {
    RowBox[{"\"\<Border\>\"", "->", 
     StyleBox["n", "TI"]}], Cell[
    "create a spacing border of equal margins in all directions", 
     "TableText"]},
   {
    RowBox[{"\"\<Border\>\"", "->", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["color", "TI"], ",", 
       StyleBox["n", "TI"]}], "}"}]}], Cell[TextData[{
     "create a framed line border of thickness ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["color", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"\"\<Border\>\"", "->", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["color", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           StyleBox["left", "TI"], ",", 
           StyleBox["right", "TI"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["top", "TI"], ",", 
           StyleBox["bottom", "TI"]}], "}"}]}], "}"}]}], "}"}]}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "create a framed line border of different edge thicknesses with ",
     Cell[BoxData[
      StyleBox["color", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"\"\<Border\>\"", "->", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["border", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["border", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], Cell["\<\
create a compound border style with each of any possible border styles nested \
together\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->365620475],

Cell[TextData[{
 "Uses of ",
 Cell[BoxData["\"\<Border\>\""], "InlineFormula"],
 " suboption."
}], "Caption",
 CellTags->"LayoutOptions",
 CellID->140910037],

Cell["Here is a simple titled border.", "Text",
 CellTags->"LayoutOptions",
 CellID->375482874],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
      RowBox[{"WidgetGroup", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Label\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<Label:\>\""}], "}"}]}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<TextField\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<Input\>\""}], "}"}]}], 
            "]"}]}], "}"}], " ", "\[IndentingNewLine]", " ", "}"}], ",", " ", 
        
        RowBox[{"WidgetLayout", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<Border\>\"", " ", "->", "\"\<TitleName\>\""}], 
          "}"}]}]}], "]"}]}], " ", "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[86]:=",
 CellID->32115670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[87]:=",
 CellID->168553238],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutOptions",
 CellLabel->"Out[87]=",
 CellID->399222148]
}, Open  ]],

Cell[TextData[{
 "Note that some widgets, especially ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"], "[", "\"\<Panel\>\"", "]"}]], 
  "InlineFormula"],
 ", can set a \"border\" property directly, and so a widget layout ",
 Cell[BoxData["\"\<Border\>\""], "InlineFormula"],
 " option can be specified directly with some widgets."
}], "Text",
 CellTags->"LayoutOptions",
 CellID->54742645],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "->", "\"\<Label:\>\""}], "}"}]}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "->", "\"\<Input\>\""}], "}"}]}], "]"}]}],
         "}"}], " ", "\[IndentingNewLine]", " ", "}"}], ",", " ", 
      RowBox[{"WidgetLayout", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Border\>\"", " ", "->", "\"\<TitleName\>\""}], "}"}]}]}],
      "]"}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[88]:=",
 CellID->5893187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[89]:=",
 CellID->412272052],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWwlYVEe2vvQCotFEUcRIVKIoIhpBFEVxQxbZZFWRRUBBQBQF4xYzziRx
Mll8o6MzvmSSmfglL+9lYpLJTBJjYvIm62Qm5tOYiTouA0I33SzGsDQNMeZ/
51TdbhpoFFzmm/e9d7+v7q1bt+pUnf+cOudUVXd87qbC/HW5m4pW5Y6JKsvd
UFi0qnxMZGkZFWldFEV5gFLSGIXzoKztpoUy9CkoHk9yUraKu6LooHi+CmXU
c2o66MYZLef0nHOFco945ZvMHeyUkx8OatTKow5yC4cPrnZSWvWrmrujc1t+
PcjDEcN4nt+gjPy1izpOojDiOPoF/h0Do87irtQK9F/8d+JJt+AM0Zh7oR+U
sPOc41vYBVf1NeyCrWyuLNNwTmurLHOu3VrIel1JdScadkHTuZkgxVyEnYcS
cgJKwFHmpjsXQ5KN8Cz+Bv3SLhAXbkvqSqFENypa2XLy+wyx4tIhJLWZ2qQc
DbVnuHJ0o2xwyypruHIp6NJ0bTaqazO3oM7N1uM/nj+guHJjfhVJtJ7LnR68
dmPqiVrb2irF4u7mWNaV3nWY6AtB5+wFnrkWQR++R2Hns0c01yXdday9IU1l
RBvqpYSLu16U2TpQ2yjdRdVHcG6qw7kXnKiUW9871Kp3tla2srC+DMIJzLdk
EHonZdP/9w/Muc53GZiuq1bruTfxTSMci16qOo3A4amIb1rOau311YGq1WTD
6zCpCCqc0TmW8UPtwZaTWdtH2b9/r6fMhd5Aoe8+wR3YsLFm516yD5sDdgaB
1kmZ203AIrrpXlXTE0r/RIDcHAHqqjJOgXAGbN905sbKJvUFlOvbPeeguHJO
10VNpOp0R8JZPdd/KSSc+7g+qIdrT+qh6cl89G3u9DBPejV9bj003bzxNZTE
wX7qOpnZmzCwzo3pNSHpKFYvXd8s7E3AMMCJIXC/QePAb4OdlE3sLSMi2Pm/
w8jtjtpuUaz6/4P4lxpE75cON9rh9dddN0L6uotOJwSvuZD7FyB4M+tsp8vi
mxnhP4fgTbHsLNK95VsL1yHoqt6vFRMRJYeiHgOBBicxZYN9idKZhpNAw7FY
EAi91eJ1VQn2wGuf1k7aa6DjbLXaF/r8FnI95p0sB24L8zJC6NeVka5PZxhp
nOiWw/ew606OPuxl2R2S9gb51HWE9T0NWLbT9VG6OrtWh4hR9oXhrgrtym1v
lEPZTu9Mer2urzhuunSf0840eWaftmo7GB7gxD7Y4e+dRXLGmf2t58rd+hSV
5trq92YX11n8rXVu8NzsJsMZekv60quI8PXXMrfOo//rWfDrD+L2HRi4B5/t
fWW3HirPPgvF56Ubrnz3cSqtlCm2kmQVfpwqu4Qfh8uiE5xobaWJOKHlrIbL
Fa38wjXozZPfhnKzYfw+SiUg6E0hPoI+4N6G/UJoQ5feiNNjXF90o5HdKDGk
ki7x55lGItWIr6ZnFU9KulNZykXO2d4Sq/y5CvUfWcnvTDO2Wry52srCaRTz
RVLEuRDf556VZfJtfqeyuWe5t9C/s2OYeYZzUKafkXl+8thn1jFnDOMTwmDa
GYutl0NOrWYiy2sY4uVUltkAJecbKCubtNDmN+qgLWyhTrWF38GlWCSqyXca
SP5VuKxu56QQYzntfPte5BjCzHZ+lc/0NigrLNRDM5RlraJHK/e4rBVKWguU
pBZ+ajij4xyPNOlbKHGX5VPW4XZxzYRX1GUXZs3FkTe3zrwtJx4ymmxPaqnN
4eM2bW4rc8T80JtrcTvdSr53g3btFZJr8Q/D+IuGWaPP+oIrKPi1RXiMO1Xv
Zrx0VZTRN6Xnem6y3lPN0OdaGRABgz7bioJfNSt3iTr9YGz4HgX7GqFf0sSM
MV+kC3VdpWbjrKoTZy45FuaG1TG/XZUQ8cPsUJlb6VUt3Mqu6uC68Qf6WEY+
Wbsew5lHZRjW/KYVJ842wm/pRxg47y0MXvQehkS8i6ERRzBk0RF4RByFR+R7
uCvifQyM+BP6R3yAfos+guuCP0E7709wmfcRDeh9jE44guNnLjE9ReCnBN5y
2owsqxorU8FTFnxz6gTeXOSHFycNxKGpg/Fy4BC8FDQUL00dgkNBHniF0quB
d+H1qQPxhyn98cbkfnjd3xWv+2nxxgQXvDpOwaE5o1H3t+MCfaF8NvQl8ooN
el1X6DWMOxVLPfpOol7yvQBcw4C7wm3TDxo76sMZdY2KuvGbq/DLroDHkgqM
TKuAz4oq+GZexPisSoyj59jsKvhQGkVp5EojPLON8MiqwaAMI9yX10CXWgOX
BBpLxFeEztvq+lqifhto21FnXf5isR+OzfTAsbkjcXyRD45H+VIaj+OR43Ai
aiy+jPTByYhR+DpiJL5e6IlT8z3wddggnJrljq+n6/DlVBd86K/gZUJe0L4G
6t0VXlV2oeqDkJaWJsDVMbieKrh8DUq8BO+My/Bb9S3uK/wW09Y2IrikEYEl
TQhc14QppU3w39AE3w3NGF3ajBHrWuBR3IKBBS1wy2mGZgXZmnjqNvSIA7i3
izZBq9I+EzII58K9cSHOD/9Ivg8VadNQuSwYlWmBqFwaiItLp6AqzR+GFF8Y
EkfDGDcCxmgPGMMHwjDXDZUzNfjyPgW/G2s/DotrZgvdGVzh3MhZjD7Z2Zqs
lNaEwMVvDz7nCoPBQI2rzp6DyWzmRApfX19Pd/rMmMOl5AdOIxzwGbq0Gb55
LQhc24JZG1sQtslCqRWz77dg1mYLQrZYELS1FQFbrfDdYsXozVaMKLNi8Po2
DCi0Qp/TAk0KKWHY+zYeyLgG3g7adr/E14U5Q1EZ64uLqYGozpgFQ3YYDCsp
Zc+GMXsWpRDUZAXBlBEA8zJf1KaORm3iCNTGDIZ50QAYwvQ4NU2D18a7SNpd
DXngp3bs3aGMPaX6KJP0tyvtllyAW1RURJyTADQC9/44d+4cPnniSfEkGQiJ
cJ6f/M6NSAga9skCsuHCH4ujYnilN2MKebtQwmzhFgtNLB6gO/x3tGHc9jbc
s6UNw8rbMKikDe6rWqBfaoJm3n876KdzOgNEDW9n7ez+nq9/zPfCxaQpqM4M
hSFvISwfvCnKa/LDKS1AzeowmPJmwpwThNpMf9SljxPfrW8fRG30IBjnu+P0
DD1+P8F2phl1mdV6gVlCG/CZHVpdB7QMfFK9hrHlGJDQZZBYqQWyNHoGkHL4
S+Ea1GYk4Z133pFA0/OD/XsFuM3NzdxO+lcNg+olIhuJyKisZsxYT2iQ9i1+
oAPZyQ+SBhKyowjZ4YTs4HVWYQEGpJuEg7Mh207oOaEjymJ+ZEX0j1oRsbMV
C35MWk7P6TutnWjz5YS2jLAoWuKrgsxx1fIZAnnjmsVyq1iPmsIImNYsgGn1
bJjzpqMue7K6jdxfKHXNooE4PXsAXp8k14t2ZWbU2WyIyESArldtCYNuoH7r
OH5UJPJ3CNTLy8sFmoz2m7HxOPHnT3E6fRmqipJQsTELnxevwAdjx+KNP/5R
CkeH/fv2Sfcq03CWoIbDRxV637xmhJW3IJrgSvhxawf0O6wYv60NY8gAjCi3
wrPUCo+iFtyVZUb/RXalJjrDnNERZQk/aUUs5aMI8oWU5lCawdA70OarB9pp
jeoamw1KNRkS45po1JQkoGZdom2n3lS4EKb8OQT9DBV2V2FPzHGeMER54Mw8
Cl0m91f1fYFZrFGq5BrF/7CjKWHoeQUmoDd2hO9kUhj6Dz/8UFX4gfg0IxPv
+I9HS2YkGpLCYXqxBIdzwnBg/D0C7717fo53dm4RT8adgxyBlZeIniVgk0jX
Fm0lsAiU5IdakfJwK5LoGf8T0lcqC6cURno7fUcrJm8nwAgsn01WjNxohdd6
SuQNPVeacGeUfR4sb1ZGOaXNV29oC+vUnTaLQqwc+Lq4ZBIMqxahZm0CTKXJ
lFJQsz5Jgn8XCUMcmIjrB0sjzKk+MCeOhCneC4YYL5ymaOYPgXdKsjwH5l/s
WDX6H7YJZDiUMZ/JxRcLJMnYaT3FAjn2+TFcOPou/nb0KD5dEoXqVWGwvLAW
Nftz0ZAXgnMzA/CXwAl4J3o6vk2NwdlTp/Cb534rVi4alsMIdteqMILIFcY+
aEEqCWHpI1akPWwVwMWT9kY/SNpLQM3Z3opgcouTN7diPM0IHxKEd2krvNdR
IsC8c2swJNquvT3S5qs3tPnqgXZSPQUefFWlBsFYFAvThlSYNi6FeUOaEEpN
Sbz8edNAmNLGw5Tsg5oEb9TEe6M6zhunIr3x+2lDpBB4OrAAeJHLRl9OCxE6
enaXAlslVRIshe0Z6bg4iwLm8Bmoz0xA01P5aP/rI2g6dD8MD6bii6Q5MP5m
Exq2J+OZxx/DsY8/xjPPPkMLyKwGnossUCa3vJ7QojtP+zoVuBCy5ElkQpbt
siL9p1bxTKb3eNLcqAfImm8ja06xSjDFLwFlBBwJ414CbNTaVowuboVPcTN8
8mrgudgeAxHtMU5pC6H0gjZfTmizSAQ+fFWnh8C0LgnmsmUwl6eTYJbRDCGh
FMeTCYuSM4Xc8bIAGFPGw5h4L4zxoyiNRlWCD04t9sFr0z0lWbZItp2IiSeg
jD9kkw2p791Hocw4KbcveHOEFh5KOk2pzFohG1tgc2nTKjQ8ngnL3gwhl5N7
1uFwQQr+vCYW1iObYX5oCQ4+9iheeOEFbNu+jUVjEwyLKN3s6SCUOWUtSH+0
FVmPW5H1mAQvhYBLYOC2W7CAzE4ogRZcRsCVWjChxIKxBNiYIgKw0ALfIgrq
CbgRsY5CcU6br97Q5qsH2vHV6kypziInsSkd5i1ZMG/OgqksHTVkuoxrE2wz
xZA0AYYlY2mGjEF1/L1k6XzxdYwvXgsZIYVh2wpizFkYcqYMepCk4dVZGjHn
1dliFBKx+W4Rch55C6cfSabobJaQwGclafjkkS04nDGPBhaNCytCYZzuj8p/
f5pniiqNWg0TEntLLA2jiljkNgtynrQib3cbcp6wIuNRK1IfsiKBbEoU2ZMF
hFboRkKM1H3yWgv8iiwYt8aCewsILXpOLGzCxFUGjIx9zy4No+pEutLmqze0
+XJCW+7QxVaKvDE/EubtOTDvyJPPTRkwrU+1ORGOcB2vqvhxqIq9l56+qEyc
iL/FTcSrs0Z2lgpLhK2VmCJCKP26CyW12lEoGrEQuwPnpkzA2zMCcCxoMj6L
myksFvuNJ7w9hTzOLIvEW88+hZrKCvzXgX1auyyGd5FF4S/aULyvDfk/b0M2
afAy8iOJpL0xZE7CaXkVRnhxgHof4TWJ8PIjnCaQLPxJewNIe/3zDPCOc5SF
3hltdckw0Fk7uRHpgHPtTwpR93Axan+UT9qfbf+RgyE3HIasMFQvt4VOA8j+
TEBVIilfUgC+ivfHK7O8O0C2qb0E2a76nhLlkM/JjZyUKPNuLaO8wiRUPy0t
DeaXnhfq/3F5mXAKbHjYUdhU/sXpAbjwxpvCaKmumkMmk4DZywFmttDrD7Rh
w1MSjrwn25BBRij1x1bEk+WO2tKK+WQgQslABK9rwVRyv5MpuAwguCdTmkJw
Bawy4p64o3Z3aoO5C20V5juctesEM1v2+kfXo/7xDQy1bW1gLIyHYXUULYDn
02I4FFVLgxXbt6rkyahInkIoB+CV0HtsQ5lxkk1uwGcS5XEvKg667PUyL3+h
zGOUz8h9ctZnibJNl3ml9eWrr+LSsiVofmQVmrfGoD4mCKce2Irzhbl4JXgm
rly5gnaLpWeQOT7Z9ts27DjYho0Expq90gak75LWnoGOJPe4oJyBbsFM0ung
khYElchthalFjQggnXQA2a7LXWjbl79O2nUCmeOahr3b0LBvBwG9EdZjH8py
suSmdSkq2pGE9gKBdnX6TPG9+d1XUJUWiIqUqfgqwY52N7AdVNr9emCznySm
CGsa/ueLI9FSK9e4LZ+8D0PABJFnhBtopcZbP4y4XP86g3v5T1vx2O/asfuV
dux8XkLOur3636zIflw62VSCLYlCxtgdFsRQ4vh+HpmU0DKGnkxAbjW8ot91
gDvgdtDuJBLzpuX45tnHcPngblz65U4hFmFqHlwN89ZsmDj6KU2lBVsSiSeW
UoxYOxhy5gkbX7k0GCfj/HFohlcvRRL0gTw9ijpNVuYsgVlBySBEwjs8UiR6
YWlsIuBUGxdNpSQEos51WYyUuK/lNcMYLY04vJHiyN9jxYE32vH04e8EdNuf
a0PZ021Y98s2YYXzf05ekeDL3W0VsQrHLMkU3ceR+QinWRGyvgl+K6sxLNK+
OZlyURXHLaYtFVMVR+3OfHz70gE0HnpaiKVh73bUP1GGul3rhBcwkweoJY9b
+0CujIM2cQyUDGNxHIklHBcpcD0Z44ffTRumiiPk8x7Mka6TODQRJ5jHs1yZ
JMIIUzBJbyQDLQuAsrUffyRmgRRCD6IY7iCFzc+0Yc9r7dj/h3bs+s823E/v
bJwLf2FFwR6J0kqKT7LZLv2M1la7WpFIirx4h1TeoLVNGJtZjamZn8DYcEWV
wm2jnVip3C1oN+zejMvP78G3L+7HN0/vQv3u+1FHzqGOJFC7s0BIwLxtJaVs
mO+nCVK2lJYHiTQ5FouJUZkWhBORY/FW7FQY676TnpVNEYvh3iMsBgcpjHtR
SmHBX+ES10kKPC+UbBOPLa/WFS759SLHB465tIjLruWvnLR2mzS0Yya4o2B/
Hc4br6KctJPjwLRH5PIomiJx3mAjI0G055ZbNJi9kW7TSloUV0yl1arf6haM
zrqM4DWVOHmuCQX7aiX47pztM9HBPRFVj4QrUbDXhO8unidlLyflzqEVV5pc
bRVEU5izkG0Ob96snKshszNbQ454Gg21ihxCZbwfzkeMxomUYFw+cxIFj1Zo
xCazVsIq8bapvUbs/etsaEsTlHKWjXoFt2A882ptKOfXU801lzSc4809+tKB
fC0H9dIdeIoTYy30K4wo+FU9jJeuqIeabuKdy8XajpLTOvupztJq6Z8IEX2y
RIQV017n0QroZx/rUCZmzv+wzcQOe078WEOUcgAX+4U4dFc50zlyxtxomS8q
LWoSHEpm5Um3TMN4ATmRWXTtmNwyJpRH5CkXxZTR8Jk/n/6f17Gb5S3p0/xj
hK8YL3a9bOttiYyRxrZfKscrmCNZ8Hh1XYYqRrTmkhaakkZ3aNezDaKsel7N
p990X8in8pRb1UAdanPrhYA0WbUi8cDFtNDyyLU89I6RK+LnChKtGPHroajT
ik7GCuFfSZy9XhaHGGKi2ofKKsvA2mCkjsWw1lugLf2OzzuhlF/l4ZWx4NR3
8bTl6QvnudNyPjHncteNP/CBqeLHX4fycRKfq5bJwyW1kU7Udxc/PeDjKQFF
fqPY1Od9TvGjAn6KI37etewn3zsE6/iTBl65a9RNm0yxm8MKyMyHnVdUzjVq
uMuzhTF1XdMi2JXD99hOTubuh+jm8xgvSSbsBibtEYm+0l2LwP0Ilzn6KMo0
nNNi7C5bC2qrtpd3+mIvE5T13IdW9uZWelVoY7NYrfDg1JGq/4ajgfJPGWiY
hCY3UcQICUwmy90FPgkelQahe+kW9ku4Y94BDOPcUHtOzznim7Jcz/FJAqCc
K9PRCC503A2fe0uVD/xUrhE6/qAY+4XAj4cm9Ez8XIYCT+H7ea0lLb39abcy
7FozhbURe221YottKO9NDuUlrM62xcPHluounFYVaJLI8h4G72zFmuzrJHHW
JsrqZT5WTOhIA//0RizxTWqqlwcd807q1Vng8j9lZphv\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutOptions",
 CellLabel->"Out[89]=",
 CellID->78831104]
}, Open  ]],

Cell["\<\
You can add a little inner spacing with a compound border of a title with a \
spacing border.\
\>", "Text",
 CellTags->"LayoutOptions",
 CellID->137504615],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
      RowBox[{"WidgetGroup", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Label\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<Label:\>\""}], "}"}]}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<TextField\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<Input\>\""}], "}"}]}], 
            "]"}]}], "}"}], " ", "\[IndentingNewLine]", " ", "}"}], ",", " ", 
        
        RowBox[{"WidgetLayout", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<Border\>\"", " ", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<TitleName\>\"", ",", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"5", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"10", ",", "30"}], "}"}]}], "}"}]}], " ", "}"}]}], 
          "  ", "}"}]}]}], "\[IndentingNewLine]", "]"}]}], " ", "]"}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[90]:=",
 CellID->443689879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[91]:=",
 CellID->105736691],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutOptions",
 CellLabel->"Out[91]=",
 CellID->354570337]
}, Open  ]],

Cell["Here we have added a simple red border three points thick.", "Text",
 CellTags->"LayoutOptions",
 CellID->337229302],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
      RowBox[{"WidgetGroup", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Label\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<Label:\>\""}], "}"}]}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<TextField\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<Input\>\""}], "}"}]}], 
            "]"}]}], "}"}], " ", "\[IndentingNewLine]", " ", "}"}], ",", " ", 
        
        RowBox[{"WidgetLayout", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<Border\>\"", " ", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"RGBColor", "[", 
              RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", "3"}], "}"}]}], 
          "}"}]}]}], "]"}]}], " ", "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[92]:=",
 CellID->56664331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[93]:=",
 CellID->277758043],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutOptions",
 CellLabel->"Out[93]=",
 CellID->120716542]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Spacing\"", "Subsection",
 CellTags->"LayoutOptions",
 CellID->27932753],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"\"\<Spacing\>\"", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " suboption allows a ",
 Cell[BoxData[
  ButtonBox["WidgetGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetGroup"]], "InlineFormula"],
 " to specify an overall spacing element to exist between all widgets in the \
group."
}], "Text",
 CellTags->"LayoutOptions",
 CellID->142223799],

Cell["\<\
Here you have forced a spacing of 30 points between all widgets in the group.\
\
\>", "Text",
 CellTags->"LayoutOptions",
 CellID->395621882],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
      RowBox[{"WidgetGroup", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Label\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<A:\>\""}], "}"}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<TextField\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<A content\>\""}], "}"}]}], 
             "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Label\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<B:\>\""}], "}"}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<TextField\>\"", ",", 
              RowBox[{"{", 
               RowBox[{
               "\"\<text\>\"", "->", 
                "\"\<B content is the largest of all\>\""}], "}"}]}], "]"}]}],
            "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Label\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "->", "\"\<C:\>\""}], "}"}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<TextField\>\"", ",", 
              RowBox[{"{", 
               RowBox[{
               "\"\<text\>\"", "->", "\"\<C content is larger than A\>\""}], 
               "}"}]}], "]"}]}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
        " ", 
        RowBox[{"WidgetLayout", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<Grouping\>\"", "->", "Grid"}], ",", " ", 
           RowBox[{"\"\<Spacing\>\"", "\[Rule]", "30"}]}], "}"}]}]}], "]"}]}],
      "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[94]:=",
 CellID->4972173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutOptions",
 CellLabel->"In[95]:=",
 CellID->81124669],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{197, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutOptions",
 CellLabel->"Out[95]=",
 CellID->113072620]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Definition Building Blocks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 9.4280294}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "GUIKit definitions are defined as a hierarchy of widgets, whether they \
are defined in the Mathematica expression format or in the XML format, \
GUIKitXML. A single self-contained user interface definition should always \
begin with an outermost user interface widget--either an instance of a window \
or frame. The GUIKit framework also optionally provides an appropriate \
top-level window wrapper if the root interface definition widget is at least \
a user interface class that can live inside a window or frame, so you are not \
actually required to always use a top-level frame or window widget. This is \
convenient because it allows you to write reusable complex widgets by \
designing them with the root widget as Widget[\"Panel\"]. This could be run \
by itself or reused as content in other developer's window definitions. \
Examples of reusing panel-designed higher-level widgets exist in subsequent \
documentation sections. A GUIKit definition expression consists of a \
hierarchy of widget expressions. Some of the building blocks that make up a \
user interface definition include the following.", "synonyms" -> {}, "title" -> 
    "Definition Building Blocks", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/DefinitionBuildingBlocks"}, "SearchTextTranslated" -> "",
   "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "BuildingBlocks"->{
  Cell[1929, 51, 92, 2, 70, "Title",
   CellTags->"BuildingBlocks",
   CellID->207257751],
  Cell[2024, 55, 1319, 29, 70, "Text",
   CellTags->"BuildingBlocks",
   CellID->77066093],
  Cell[3346, 86, 200, 7, 70, "Text",
   CellTags->"BuildingBlocks",
   CellID->481889059],
  Cell[3549, 95, 4078, 141, 70, "Output",
   CellTags->"BuildingBlocks",
   CellID->400894521],
  Cell[7630, 238, 165, 5, 70, "Text",
   CellTags->"BuildingBlocks",
   CellID->20616337],
  Cell[7798, 245, 111, 2, 70, "Text",
   CellTags->"BuildingBlocks",
   CellID->108740951],
  Cell[7912, 249, 568, 18, 70, "Input",
   CellTags->"BuildingBlocks",
   CellID->14581203],
  Cell[8483, 269, 383, 13, 70, "Text",
   CellTags->"BuildingBlocks",
   CellID->422341648],
  Cell[8869, 284, 196, 6, 70, "Input",
   CellTags->"BuildingBlocks",
   CellID->654150589],
  Cell[9068, 292, 388, 11, 70, "Text",
   CellTags->"BuildingBlocks",
   CellID->202996451],
  Cell[9459, 305, 254, 10, 70, "Input",
   CellTags->"BuildingBlocks",
   CellID->544168609],
  Cell[9716, 317, 259, 8, 70, "Text",
   CellTags->"BuildingBlocks",
   CellID->30802201],
  Cell[9978, 327, 303, 10, 70, "Input",
   CellTags->"BuildingBlocks",
   CellID->271983246],
  Cell[10284, 339, 158, 5, 70, "Text",
   CellTags->"BuildingBlocks",
   CellID->150937629],
  Cell[10445, 346, 926, 28, 70, "Input",
   CellTags->"BuildingBlocks",
   CellID->652084101],
  Cell[11374, 376, 341, 12, 70, "Text",
   CellTags->"BuildingBlocks",
   CellID->93279392],
  Cell[11718, 390, 272, 8, 70, "Text",
   CellTags->"BuildingBlocks",
   CellID->58215101]},
 "LayoutIntro"->{
  Cell[12015, 402, 76, 2, 70, "Section",
   CellTags->"LayoutIntro",
   CellID->4183354],
  Cell[12094, 406, 1092, 21, 70, "Text",
   CellTags->"LayoutIntro",
   CellID->676891081],
  Cell[13189, 429, 160, 5, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->530625823],
  Cell[13352, 436, 445, 11, 70, "Text",
   CellTags->"LayoutIntro",
   CellID->710281079],
  Cell[13800, 449, 200, 7, 70, "Text",
   CellTags->"LayoutIntro",
   CellID->426407796],
  Cell[14003, 458, 425, 13, 70, "BulletedText",
   CellTags->"LayoutIntro",
   CellID->312857142],
  Cell[14431, 473, 175, 5, 70, "BulletedText",
   CellTags->"LayoutIntro",
   CellID->477855102],
  Cell[14631, 482, 268, 6, 70, "BulletedText",
   CellTags->"LayoutIntro",
   CellID->413439933],
  Cell[14902, 490, 117, 2, 70, "Text",
   CellTags->"LayoutIntro",
   CellID->52547629],
  Cell[15022, 494, 187, 5, 70, "Text",
   CellTags->"LayoutIntro",
   CellID->48674293],
  Cell[15212, 501, 1013, 26, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->281756696],
  Cell[16250, 531, 138, 4, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->151235697],
  Cell[16391, 537, 9442, 159, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutIntro",
   CellID->189450959],
  Cell[25848, 699, 165, 5, 70, "Text",
   CellTags->"LayoutIntro",
   CellID->78512451],
  Cell[26016, 706, 1082, 28, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->3835829],
  Cell[27123, 738, 138, 4, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->927690540],
  Cell[27264, 744, 9665, 163, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutIntro",
   CellID->640152825],
  Cell[36944, 910, 141, 4, 70, "Text",
   CellTags->"LayoutIntro",
   CellID->119866090],
  Cell[37088, 916, 1386, 35, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->782599332],
  Cell[38499, 955, 137, 4, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->13816330],
  Cell[38639, 961, 10337, 174, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutIntro",
   CellID->204711540],
  Cell[48991, 1138, 218, 5, 70, "Text",
   CellTags->"LayoutIntro",
   CellID->160162000],
  Cell[49212, 1145, 1133, 29, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->222451426],
  Cell[50370, 1178, 138, 4, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->529367344],
  Cell[50511, 1184, 7945, 135, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutIntro",
   CellID->566679834],
  Cell[58471, 1322, 219, 5, 70, "Text",
   CellTags->"LayoutIntro",
   CellID->20250038],
  Cell[58693, 1329, 844, 22, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->92405274],
  Cell[59562, 1355, 138, 4, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->184436626],
  Cell[59703, 1361, 8072, 137, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutIntro",
   CellID->350434148],
  Cell[67790, 1501, 1698, 51, 70, "Text",
   CellTags->"LayoutIntro",
   CellID->468626323],
  Cell[69491, 1554, 166, 5, 70, "Text",
   CellTags->"LayoutIntro",
   CellID->447939170]},
 "WidgetGroup-Layout"->{
  Cell[69706, 1565, 83, 2, 70, "Section",
   CellTags->"WidgetGroup-Layout",
   CellID->254213160],
  Cell[69792, 1569, 981, 31, 70, "Text",
   CellTags->"WidgetGroup-Layout",
   CellID->736174],
  Cell[71627, 1630, 249, 9, 70, "Caption",
   CellTags->"WidgetGroup-Layout",
   CellID->47404517],
  Cell[74001, 1706, 105, 2, 70, "Caption",
   CellTags->"WidgetGroup-Layout",
   CellID->651244033],
  Cell[76258, 1779, 104, 2, 70, "Caption",
   CellTags->"WidgetGroup-Layout",
   CellID->102489988],
  Cell[77116, 1806, 93, 2, 70, "Caption",
   CellTags->"WidgetGroup-Layout",
   CellID->124603550],
  Cell[77212, 1810, 182, 5, 70, "Text",
   CellTags->"WidgetGroup-Layout",
   CellID->74965106],
  Cell[77397, 1817, 1183, 30, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->152636715],
  Cell[78605, 1851, 144, 4, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->38526110],
  Cell[78752, 1857, 9371, 158, 70, "Output",
   Evaluatable->False,
   CellTags->"WidgetGroup-Layout",
   CellID->371634057],
  Cell[88138, 2018, 203, 5, 70, "Text",
   CellTags->"WidgetGroup-Layout",
   CellID->693032320],
  Cell[88344, 2025, 1251, 32, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->105481360],
  Cell[89620, 2061, 145, 4, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->606050450],
  Cell[89768, 2067, 9667, 163, 70, "Output",
   Evaluatable->False,
   CellTags->"WidgetGroup-Layout",
   CellID->53054195],
  Cell[99450, 2233, 295, 9, 70, "Text",
   CellTags->"WidgetGroup-Layout",
   CellID->105430984],
  Cell[99748, 2244, 1778, 43, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->20625932],
  Cell[101551, 2291, 145, 4, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->282733247],
  Cell[101699, 2297, 9929, 167, 70, "Output",
   Evaluatable->False,
   CellTags->"WidgetGroup-Layout",
   CellID->317523812],
  Cell[111643, 2467, 241, 9, 70, "Text",
   CellTags->"WidgetGroup-Layout",
   CellID->238292314],
  Cell[111887, 2478, 2204, 55, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->604589238],
  Cell[114116, 2537, 144, 4, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->86790732],
  Cell[114263, 2543, 8643, 146, 70, "Output",
   Evaluatable->False,
   CellTags->"WidgetGroup-Layout",
   CellID->94171741],
  Cell[122921, 2692, 147, 4, 70, "Text",
   CellTags->"WidgetGroup-Layout",
   CellID->88637711],
  Cell[123093, 2700, 1841, 46, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->160310503],
  Cell[124937, 2748, 304, 8, 70, "Output",
   CellTags->"WidgetGroup-Layout",
   CellID->171533550],
  Cell[125278, 2761, 144, 4, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->99108442],
  Cell[125425, 2767, 9928, 167, 70, "Output",
   Evaluatable->False,
   CellTags->"WidgetGroup-Layout",
   CellID->23138463],
  Cell[135368, 2937, 369, 10, 70, "Text",
   CellTags->"WidgetGroup-Layout",
   CellID->372875710],
  Cell[135762, 2951, 1110, 27, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->190877378],
  Cell[136875, 2980, 303, 8, 70, "Output",
   CellTags->"WidgetGroup-Layout",
   CellID->187427382],
  Cell[137215, 2993, 143, 4, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->1255302],
  Cell[137361, 2999, 10506, 177, 70, "Output",
   Evaluatable->False,
   CellTags->"WidgetGroup-Layout",
   CellID->58094532],
  Cell[147882, 3179, 239, 6, 70, "Text",
   CellTags->"WidgetGroup-Layout",
   CellID->553675268],
  Cell[148146, 3189, 1633, 40, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->46931197],
  Cell[149782, 3231, 303, 8, 70, "Output",
   CellTags->"WidgetGroup-Layout",
   CellID->343244913],
  Cell[150122, 3244, 144, 4, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->85223380],
  Cell[150269, 3250, 9513, 160, 70, "Output",
   Evaluatable->False,
   CellTags->"WidgetGroup-Layout",
   CellID->12616129],
  Cell[159819, 3415, 276, 8, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->12352742],
  Cell[160098, 3425, 106, 3, 70, "Output",
   CellTags->"WidgetGroup-Layout",
   CellID->829365268],
  Cell[160219, 3431, 188, 5, 70, "Text",
   CellTags->"WidgetGroup-Layout",
   CellID->333061563],
  Cell[160410, 3438, 312, 9, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->42677794],
  Cell[160747, 3451, 144, 4, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->57595616],
  Cell[160894, 3457, 9580, 162, 70, "Output",
   Evaluatable->False,
   CellTags->"WidgetGroup-Layout",
   CellID->255428165],
  Cell[170489, 3622, 179, 5, 70, "Text",
   CellTags->"WidgetGroup-Layout",
   CellID->132321816],
  Cell[170671, 3629, 314, 9, 70, "Input",
   CellTags->"WidgetGroup-Layout",
   CellID->126564805]},
 "WidgetFill"->{
  Cell[171022, 3643, 74, 2, 70, "Section",
   CellTags->"WidgetFill",
   CellID->743211123],
  Cell[171099, 3647, 455, 12, 70, "Text",
   CellTags->"WidgetFill",
   CellID->130533395],
  Cell[171557, 3661, 359, 12, 70, "Text",
   CellTags->"WidgetFill",
   CellID->90465118],
  Cell[171919, 3675, 1410, 34, 70, "Input",
   CellTags->"WidgetFill",
   CellID->548476858],
  Cell[173354, 3713, 136, 4, 70, "Input",
   CellTags->"WidgetFill",
   CellID->86405417],
  Cell[173493, 3719, 9311, 157, 70, "Output",
   Evaluatable->False,
   CellTags->"WidgetFill",
   CellID->474215232]},
 "WidgetSpace"->{
  Cell[182853, 3882, 76, 2, 70, "Section",
   CellTags->"WidgetSpace",
   CellID->298395669],
  Cell[182932, 3886, 403, 11, 70, "Text",
   CellTags->"WidgetSpace",
   CellID->596062023],
  Cell[183338, 3899, 121, 2, 70, "Text",
   CellTags->"WidgetSpace",
   CellID->200946096],
  Cell[183462, 3903, 1502, 36, 70, "Input",
   CellTags->"WidgetSpace",
   CellID->275948564],
  Cell[184989, 3943, 138, 4, 70, "Input",
   CellTags->"WidgetSpace",
   CellID->333960826],
  Cell[185130, 3949, 9312, 157, 70, "Output",
   Evaluatable->False,
   CellTags->"WidgetSpace",
   CellID->164314015]},
 "WidgetAlign"->{
  Cell[194491, 4112, 76, 2, 70, "Section",
   CellTags->"WidgetAlign",
   CellID->508749644],
  Cell[194570, 4116, 795, 21, 70, "Text",
   CellTags->"WidgetAlign",
   CellID->68187356],
  Cell[195368, 4139, 1221, 35, 70, "Text",
   CellTags->"WidgetAlign",
   CellID->213398956],
  Cell[196592, 4176, 336, 13, 70, "Text",
   CellTags->"WidgetAlign",
   CellID->373462017],
  Cell[196931, 4191, 159, 5, 70, "Input",
   CellTags->"WidgetAlign",
   CellID->36416744],
  Cell[197093, 4198, 2812, 64, 70, "Input",
   CellTags->"WidgetAlign",
   CellID->17672610],
  Cell[199930, 4266, 138, 4, 70, "Input",
   CellTags->"WidgetAlign",
   CellID->151409983],
  Cell[200071, 4272, 8144, 138, 70, "Output",
   Evaluatable->False,
   CellTags->"WidgetAlign",
   CellID->181369110]},
 "LayoutOptions"->{
  Cell[208264, 4416, 87, 2, 70, "Section",
   CellTags->"LayoutOptions",
   CellID->433011481],
  Cell[208354, 4420, 1037, 27, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->49063638],
  Cell[209394, 4449, 703, 20, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->474391247],
  Cell[210901, 4497, 150, 6, 70, "Caption",
   CellTags->"LayoutOptions",
   CellID->346286636],
  Cell[211054, 4505, 970, 35, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->92411903],
  Cell[212049, 4544, 82, 2, 70, "Subsection",
   CellTags->"LayoutOptions",
   CellID->280771899],
  Cell[212134, 4548, 619, 18, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->59596289],
  Cell[212756, 4568, 332, 11, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->588448603],
  Cell[213125, 4584, 84, 2, 70, "Subsection",
   CellTags->"LayoutOptions",
   CellID->849005102],
  Cell[213212, 4588, 1348, 46, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->5389376],
  Cell[216292, 4688, 182, 7, 70, "Caption",
   CellTags->"LayoutOptions",
   CellID->153553618],
  Cell[216477, 4697, 250, 8, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->40932611],
  Cell[216752, 4709, 1589, 40, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->73138050],
  Cell[218344, 4751, 298, 8, 70, "Output",
   CellTags->"LayoutOptions",
   CellID->262141554],
  Cell[218679, 4764, 140, 4, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->632320240],
  Cell[218822, 4770, 7951, 135, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutOptions",
   CellID->214181374],
  Cell[226788, 4908, 107, 2, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->143992460],
  Cell[226898, 4912, 602, 17, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->753371332],
  Cell[227525, 4933, 139, 4, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->83844549],
  Cell[227667, 4939, 8074, 137, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutOptions",
   CellID->150723109],
  Cell[235790, 5082, 83, 2, 70, "Subsection",
   CellTags->"LayoutOptions",
   CellID->365057109],
  Cell[235876, 5086, 1827, 64, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->6028309],
  Cell[238507, 5180, 160, 6, 70, "Caption",
   CellTags->"LayoutOptions",
   CellID->272144837],
  Cell[238670, 5188, 180, 5, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->369674388],
  Cell[238853, 5195, 2196, 53, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->215568927],
  Cell[241074, 5252, 139, 4, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->10653807],
  Cell[241216, 5258, 8532, 144, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutOptions",
   CellID->196187098],
  Cell[249797, 5408, 80, 2, 70, "Subsection",
   CellTags->"LayoutOptions",
   CellID->987318962],
  Cell[249880, 5412, 417, 11, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->504544216],
  Cell[252590, 5500, 157, 6, 70, "Caption",
   CellTags->"LayoutOptions",
   CellID->140910037],
  Cell[252750, 5508, 95, 2, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->375482874],
  Cell[252848, 5512, 1131, 29, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->32115670],
  Cell[254004, 5545, 140, 4, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->168553238],
  Cell[254147, 5551, 8093, 137, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutOptions",
   CellID->399222148],
  Cell[262255, 5691, 459, 13, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->54742645],
  Cell[262717, 5706, 990, 25, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->5893187],
  Cell[263732, 5735, 140, 4, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->412272052],
  Cell[263875, 5741, 8092, 137, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutOptions",
   CellID->78831104],
  Cell[271982, 5881, 165, 5, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->137504615],
  Cell[272150, 5888, 1460, 37, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->443689879],
  Cell[273635, 5929, 140, 4, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->105736691],
  Cell[273778, 5935, 8135, 138, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutOptions",
   CellID->354570337],
  Cell[281928, 6076, 122, 2, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->337229302],
  Cell[282053, 6080, 1276, 33, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->56664331],
  Cell[283354, 6117, 140, 4, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->277758043],
  Cell[283497, 6123, 7703, 131, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutOptions",
   CellID->120716542],
  Cell[291249, 6260, 80, 2, 70, "Subsection",
   CellTags->"LayoutOptions",
   CellID->27932753],
  Cell[291332, 6264, 424, 14, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->142223799],
  Cell[291759, 6280, 151, 5, 70, "Text",
   CellTags->"LayoutOptions",
   CellID->395621882],
  Cell[291913, 6287, 2364, 59, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->4972173],
  Cell[294302, 6350, 139, 4, 70, "Input",
   CellTags->"LayoutOptions",
   CellID->81124669],
  Cell[294444, 6356, 8704, 147, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutOptions",
   CellID->113072620]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"BuildingBlocks", 305619, 6558},
 {"LayoutIntro", 307215, 6610},
 {"WidgetGroup-Layout", 310224, 6709},
 {"WidgetFill", 314939, 6853},
 {"WidgetSpace", 315538, 6873},
 {"WidgetAlign", 316144, 6893},
 {"LayoutOptions", 316937, 6919}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1304, 24, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1929, 51, 92, 2, 70, "Title",
 CellTags->"BuildingBlocks",
 CellID->207257751],
Cell[2024, 55, 1319, 29, 70, "Text",
 CellTags->"BuildingBlocks",
 CellID->77066093],
Cell[3346, 86, 200, 7, 70, "Text",
 CellTags->"BuildingBlocks",
 CellID->481889059],
Cell[3549, 95, 4078, 141, 70, "Output",
 CellTags->"BuildingBlocks",
 CellID->400894521],
Cell[7630, 238, 165, 5, 70, "Text",
 CellTags->"BuildingBlocks",
 CellID->20616337],
Cell[7798, 245, 111, 2, 70, "Text",
 CellTags->"BuildingBlocks",
 CellID->108740951],
Cell[7912, 249, 568, 18, 70, "Input",
 CellTags->"BuildingBlocks",
 CellID->14581203],
Cell[8483, 269, 383, 13, 70, "Text",
 CellTags->"BuildingBlocks",
 CellID->422341648],
Cell[8869, 284, 196, 6, 70, "Input",
 CellTags->"BuildingBlocks",
 CellID->654150589],
Cell[9068, 292, 388, 11, 70, "Text",
 CellTags->"BuildingBlocks",
 CellID->202996451],
Cell[9459, 305, 254, 10, 70, "Input",
 CellTags->"BuildingBlocks",
 CellID->544168609],
Cell[9716, 317, 259, 8, 70, "Text",
 CellTags->"BuildingBlocks",
 CellID->30802201],
Cell[9978, 327, 303, 10, 70, "Input",
 CellTags->"BuildingBlocks",
 CellID->271983246],
Cell[10284, 339, 158, 5, 70, "Text",
 CellTags->"BuildingBlocks",
 CellID->150937629],
Cell[10445, 346, 926, 28, 70, "Input",
 CellTags->"BuildingBlocks",
 CellID->652084101],
Cell[11374, 376, 341, 12, 70, "Text",
 CellTags->"BuildingBlocks",
 CellID->93279392],
Cell[11718, 390, 272, 8, 70, "Text",
 CellTags->"BuildingBlocks",
 CellID->58215101],
Cell[CellGroupData[{
Cell[12015, 402, 76, 2, 70, "Section",
 CellTags->"LayoutIntro",
 CellID->4183354],
Cell[12094, 406, 1092, 21, 70, "Text",
 CellTags->"LayoutIntro",
 CellID->676891081],
Cell[13189, 429, 160, 5, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->530625823],
Cell[13352, 436, 445, 11, 70, "Text",
 CellTags->"LayoutIntro",
 CellID->710281079],
Cell[13800, 449, 200, 7, 70, "Text",
 CellTags->"LayoutIntro",
 CellID->426407796],
Cell[14003, 458, 425, 13, 70, "BulletedText",
 CellTags->"LayoutIntro",
 CellID->312857142],
Cell[14431, 473, 175, 5, 70, "BulletedText",
 CellTags->"LayoutIntro",
 CellID->477855102],
Cell[CellGroupData[{
Cell[14631, 482, 268, 6, 70, "BulletedText",
 CellTags->"LayoutIntro",
 CellID->413439933],
Cell[14902, 490, 117, 2, 70, "Text",
 CellTags->"LayoutIntro",
 CellID->52547629],
Cell[15022, 494, 187, 5, 70, "Text",
 CellTags->"LayoutIntro",
 CellID->48674293],
Cell[15212, 501, 1013, 26, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->281756696],
Cell[CellGroupData[{
Cell[16250, 531, 138, 4, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->151235697],
Cell[16391, 537, 9442, 159, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutIntro",
 CellID->189450959]
}, Open  ]],
Cell[25848, 699, 165, 5, 70, "Text",
 CellTags->"LayoutIntro",
 CellID->78512451],
Cell[26016, 706, 1082, 28, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->3835829],
Cell[CellGroupData[{
Cell[27123, 738, 138, 4, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->927690540],
Cell[27264, 744, 9665, 163, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutIntro",
 CellID->640152825]
}, Open  ]],
Cell[36944, 910, 141, 4, 70, "Text",
 CellTags->"LayoutIntro",
 CellID->119866090],
Cell[37088, 916, 1386, 35, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->782599332],
Cell[CellGroupData[{
Cell[38499, 955, 137, 4, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->13816330],
Cell[38639, 961, 10337, 174, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutIntro",
 CellID->204711540]
}, Open  ]],
Cell[48991, 1138, 218, 5, 70, "Text",
 CellTags->"LayoutIntro",
 CellID->160162000],
Cell[49212, 1145, 1133, 29, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->222451426],
Cell[CellGroupData[{
Cell[50370, 1178, 138, 4, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->529367344],
Cell[50511, 1184, 7945, 135, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutIntro",
 CellID->566679834]
}, Open  ]],
Cell[58471, 1322, 219, 5, 70, "Text",
 CellTags->"LayoutIntro",
 CellID->20250038],
Cell[58693, 1329, 844, 22, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->92405274],
Cell[CellGroupData[{
Cell[59562, 1355, 138, 4, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->184436626],
Cell[59703, 1361, 8072, 137, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutIntro",
 CellID->350434148]
}, Open  ]],
Cell[67790, 1501, 1698, 51, 70, "Text",
 CellTags->"LayoutIntro",
 CellID->468626323],
Cell[69491, 1554, 166, 5, 70, "Text",
 CellTags->"LayoutIntro",
 CellID->447939170]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[69706, 1565, 83, 2, 70, "Section",
 CellTags->"WidgetGroup-Layout",
 CellID->254213160],
Cell[69792, 1569, 981, 31, 70, "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->736174],
Cell[70776, 1602, 848, 26, 70, "DefinitionBox",
 CellID->5810395],
Cell[71627, 1630, 249, 9, 70, "Caption",
 CellTags->"WidgetGroup-Layout",
 CellID->47404517],
Cell[71879, 1641, 2119, 63, 70, "DefinitionBox",
 CellID->27265271],
Cell[74001, 1706, 105, 2, 70, "Caption",
 CellTags->"WidgetGroup-Layout",
 CellID->651244033],
Cell[74109, 1710, 2146, 67, 70, "DefinitionBox",
 CellID->677181514],
Cell[76258, 1779, 104, 2, 70, "Caption",
 CellTags->"WidgetGroup-Layout",
 CellID->102489988],
Cell[76365, 1783, 748, 21, 70, "DefinitionBox",
 CellID->276454172],
Cell[77116, 1806, 93, 2, 70, "Caption",
 CellTags->"WidgetGroup-Layout",
 CellID->124603550],
Cell[77212, 1810, 182, 5, 70, "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->74965106],
Cell[77397, 1817, 1183, 30, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->152636715],
Cell[CellGroupData[{
Cell[78605, 1851, 144, 4, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->38526110],
Cell[78752, 1857, 9371, 158, 70, "Output",
 Evaluatable->False,
 CellTags->"WidgetGroup-Layout",
 CellID->371634057]
}, Open  ]],
Cell[88138, 2018, 203, 5, 70, "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->693032320],
Cell[88344, 2025, 1251, 32, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->105481360],
Cell[CellGroupData[{
Cell[89620, 2061, 145, 4, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->606050450],
Cell[89768, 2067, 9667, 163, 70, "Output",
 Evaluatable->False,
 CellTags->"WidgetGroup-Layout",
 CellID->53054195]
}, Open  ]],
Cell[99450, 2233, 295, 9, 70, "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->105430984],
Cell[99748, 2244, 1778, 43, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->20625932],
Cell[CellGroupData[{
Cell[101551, 2291, 145, 4, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->282733247],
Cell[101699, 2297, 9929, 167, 70, "Output",
 Evaluatable->False,
 CellTags->"WidgetGroup-Layout",
 CellID->317523812]
}, Open  ]],
Cell[111643, 2467, 241, 9, 70, "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->238292314],
Cell[111887, 2478, 2204, 55, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->604589238],
Cell[CellGroupData[{
Cell[114116, 2537, 144, 4, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->86790732],
Cell[114263, 2543, 8643, 146, 70, "Output",
 Evaluatable->False,
 CellTags->"WidgetGroup-Layout",
 CellID->94171741]
}, Open  ]],
Cell[122921, 2692, 147, 4, 70, "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->88637711],
Cell[CellGroupData[{
Cell[123093, 2700, 1841, 46, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->160310503],
Cell[124937, 2748, 304, 8, 70, "Output",
 CellTags->"WidgetGroup-Layout",
 CellID->171533550]
}, Open  ]],
Cell[CellGroupData[{
Cell[125278, 2761, 144, 4, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->99108442],
Cell[125425, 2767, 9928, 167, 70, "Output",
 Evaluatable->False,
 CellTags->"WidgetGroup-Layout",
 CellID->23138463]
}, Open  ]],
Cell[135368, 2937, 369, 10, 70, "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->372875710],
Cell[CellGroupData[{
Cell[135762, 2951, 1110, 27, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->190877378],
Cell[136875, 2980, 303, 8, 70, "Output",
 CellTags->"WidgetGroup-Layout",
 CellID->187427382]
}, Open  ]],
Cell[CellGroupData[{
Cell[137215, 2993, 143, 4, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->1255302],
Cell[137361, 2999, 10506, 177, 70, "Output",
 Evaluatable->False,
 CellTags->"WidgetGroup-Layout",
 CellID->58094532]
}, Open  ]],
Cell[147882, 3179, 239, 6, 70, "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->553675268],
Cell[CellGroupData[{
Cell[148146, 3189, 1633, 40, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->46931197],
Cell[149782, 3231, 303, 8, 70, "Output",
 CellTags->"WidgetGroup-Layout",
 CellID->343244913]
}, Open  ]],
Cell[CellGroupData[{
Cell[150122, 3244, 144, 4, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->85223380],
Cell[150269, 3250, 9513, 160, 70, "Output",
 Evaluatable->False,
 CellTags->"WidgetGroup-Layout",
 CellID->12616129]
}, Open  ]],
Cell[CellGroupData[{
Cell[159819, 3415, 276, 8, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->12352742],
Cell[160098, 3425, 106, 3, 70, "Output",
 CellTags->"WidgetGroup-Layout",
 CellID->829365268]
}, Open  ]],
Cell[160219, 3431, 188, 5, 70, "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->333061563],
Cell[160410, 3438, 312, 9, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->42677794],
Cell[CellGroupData[{
Cell[160747, 3451, 144, 4, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->57595616],
Cell[160894, 3457, 9580, 162, 70, "Output",
 Evaluatable->False,
 CellTags->"WidgetGroup-Layout",
 CellID->255428165]
}, Open  ]],
Cell[170489, 3622, 179, 5, 70, "Text",
 CellTags->"WidgetGroup-Layout",
 CellID->132321816],
Cell[170671, 3629, 314, 9, 70, "Input",
 CellTags->"WidgetGroup-Layout",
 CellID->126564805]
}, Open  ]],
Cell[CellGroupData[{
Cell[171022, 3643, 74, 2, 70, "Section",
 CellTags->"WidgetFill",
 CellID->743211123],
Cell[171099, 3647, 455, 12, 70, "Text",
 CellTags->"WidgetFill",
 CellID->130533395],
Cell[171557, 3661, 359, 12, 70, "Text",
 CellTags->"WidgetFill",
 CellID->90465118],
Cell[171919, 3675, 1410, 34, 70, "Input",
 CellTags->"WidgetFill",
 CellID->548476858],
Cell[CellGroupData[{
Cell[173354, 3713, 136, 4, 70, "Input",
 CellTags->"WidgetFill",
 CellID->86405417],
Cell[173493, 3719, 9311, 157, 70, "Output",
 Evaluatable->False,
 CellTags->"WidgetFill",
 CellID->474215232]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[182853, 3882, 76, 2, 70, "Section",
 CellTags->"WidgetSpace",
 CellID->298395669],
Cell[182932, 3886, 403, 11, 70, "Text",
 CellTags->"WidgetSpace",
 CellID->596062023],
Cell[183338, 3899, 121, 2, 70, "Text",
 CellTags->"WidgetSpace",
 CellID->200946096],
Cell[183462, 3903, 1502, 36, 70, "Input",
 CellTags->"WidgetSpace",
 CellID->275948564],
Cell[CellGroupData[{
Cell[184989, 3943, 138, 4, 70, "Input",
 CellTags->"WidgetSpace",
 CellID->333960826],
Cell[185130, 3949, 9312, 157, 70, "Output",
 Evaluatable->False,
 CellTags->"WidgetSpace",
 CellID->164314015]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[194491, 4112, 76, 2, 70, "Section",
 CellTags->"WidgetAlign",
 CellID->508749644],
Cell[194570, 4116, 795, 21, 70, "Text",
 CellTags->"WidgetAlign",
 CellID->68187356],
Cell[195368, 4139, 1221, 35, 70, "Text",
 CellTags->"WidgetAlign",
 CellID->213398956],
Cell[196592, 4176, 336, 13, 70, "Text",
 CellTags->"WidgetAlign",
 CellID->373462017],
Cell[196931, 4191, 159, 5, 70, "Input",
 CellTags->"WidgetAlign",
 CellID->36416744],
Cell[197093, 4198, 2812, 64, 70, "Input",
 CellTags->"WidgetAlign",
 CellID->17672610],
Cell[CellGroupData[{
Cell[199930, 4266, 138, 4, 70, "Input",
 CellTags->"WidgetAlign",
 CellID->151409983],
Cell[200071, 4272, 8144, 138, 70, "Output",
 Evaluatable->False,
 CellTags->"WidgetAlign",
 CellID->181369110]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[208264, 4416, 87, 2, 70, "Section",
 CellTags->"LayoutOptions",
 CellID->433011481],
Cell[208354, 4420, 1037, 27, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->49063638],
Cell[209394, 4449, 703, 20, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->474391247],
Cell[210100, 4471, 798, 24, 70, "DefinitionBox",
 CellID->571368704],
Cell[210901, 4497, 150, 6, 70, "Caption",
 CellTags->"LayoutOptions",
 CellID->346286636],
Cell[211054, 4505, 970, 35, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->92411903],
Cell[CellGroupData[{
Cell[212049, 4544, 82, 2, 70, "Subsection",
 CellTags->"LayoutOptions",
 CellID->280771899],
Cell[212134, 4548, 619, 18, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->59596289],
Cell[212756, 4568, 332, 11, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->588448603]
}, Open  ]],
Cell[CellGroupData[{
Cell[213125, 4584, 84, 2, 70, "Subsection",
 CellTags->"LayoutOptions",
 CellID->849005102],
Cell[213212, 4588, 1348, 46, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->5389376],
Cell[214563, 4636, 1726, 50, 70, "DefinitionBox",
 CellID->3017254],
Cell[216292, 4688, 182, 7, 70, "Caption",
 CellTags->"LayoutOptions",
 CellID->153553618],
Cell[216477, 4697, 250, 8, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->40932611],
Cell[CellGroupData[{
Cell[216752, 4709, 1589, 40, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->73138050],
Cell[218344, 4751, 298, 8, 70, "Output",
 CellTags->"LayoutOptions",
 CellID->262141554]
}, Open  ]],
Cell[CellGroupData[{
Cell[218679, 4764, 140, 4, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->632320240],
Cell[218822, 4770, 7951, 135, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutOptions",
 CellID->214181374]
}, Open  ]],
Cell[226788, 4908, 107, 2, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->143992460],
Cell[226898, 4912, 602, 17, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->753371332],
Cell[CellGroupData[{
Cell[227525, 4933, 139, 4, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->83844549],
Cell[227667, 4939, 8074, 137, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutOptions",
 CellID->150723109]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[235790, 5082, 83, 2, 70, "Subsection",
 CellTags->"LayoutOptions",
 CellID->365057109],
Cell[235876, 5086, 1827, 64, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->6028309],
Cell[237706, 5152, 798, 26, 70, "DefinitionBox",
 CellID->33423162],
Cell[238507, 5180, 160, 6, 70, "Caption",
 CellTags->"LayoutOptions",
 CellID->272144837],
Cell[238670, 5188, 180, 5, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->369674388],
Cell[238853, 5195, 2196, 53, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->215568927],
Cell[CellGroupData[{
Cell[241074, 5252, 139, 4, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->10653807],
Cell[241216, 5258, 8532, 144, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutOptions",
 CellID->196187098]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[249797, 5408, 80, 2, 70, "Subsection",
 CellTags->"LayoutOptions",
 CellID->987318962],
Cell[249880, 5412, 417, 11, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->504544216],
Cell[250300, 5425, 2287, 73, 70, "DefinitionBox",
 CellID->365620475],
Cell[252590, 5500, 157, 6, 70, "Caption",
 CellTags->"LayoutOptions",
 CellID->140910037],
Cell[252750, 5508, 95, 2, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->375482874],
Cell[252848, 5512, 1131, 29, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->32115670],
Cell[CellGroupData[{
Cell[254004, 5545, 140, 4, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->168553238],
Cell[254147, 5551, 8093, 137, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutOptions",
 CellID->399222148]
}, Open  ]],
Cell[262255, 5691, 459, 13, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->54742645],
Cell[262717, 5706, 990, 25, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->5893187],
Cell[CellGroupData[{
Cell[263732, 5735, 140, 4, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->412272052],
Cell[263875, 5741, 8092, 137, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutOptions",
 CellID->78831104]
}, Open  ]],
Cell[271982, 5881, 165, 5, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->137504615],
Cell[272150, 5888, 1460, 37, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->443689879],
Cell[CellGroupData[{
Cell[273635, 5929, 140, 4, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->105736691],
Cell[273778, 5935, 8135, 138, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutOptions",
 CellID->354570337]
}, Open  ]],
Cell[281928, 6076, 122, 2, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->337229302],
Cell[282053, 6080, 1276, 33, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->56664331],
Cell[CellGroupData[{
Cell[283354, 6117, 140, 4, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->277758043],
Cell[283497, 6123, 7703, 131, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutOptions",
 CellID->120716542]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[291249, 6260, 80, 2, 70, "Subsection",
 CellTags->"LayoutOptions",
 CellID->27932753],
Cell[291332, 6264, 424, 14, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->142223799],
Cell[291759, 6280, 151, 5, 70, "Text",
 CellTags->"LayoutOptions",
 CellID->395621882],
Cell[291913, 6287, 2364, 59, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->4972173],
Cell[CellGroupData[{
Cell[294302, 6350, 139, 4, 70, "Input",
 CellTags->"LayoutOptions",
 CellID->81124669],
Cell[294444, 6356, 8704, 147, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutOptions",
 CellID->113072620]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[303199, 6509, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

