(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17489,        576]
NotebookOptionsPosition[     11819,        406]
NotebookOutlinePosition[     15459,        501]
CellTagsIndexPosition[     15386,        496]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Deployment", "Title",
 CellTags->"Deployment",
 CellID->534864338],

Cell[TextData[{
 "There are a number of features of the ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " framework that aid deployment of user interface definitions with your own \
AddOns so that they can be easily executed when needed. Instead of \
programmatically building up an expression that represents a user interface \
and calling ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GUIRunModal",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRunModal"]], "InlineFormula"],
 " dynamically, there is also a filesystem directory within every AddOn where \
user interface definitions will automatically be discovered. Any definitions \
placed within a subdirectory folder of an AddOn named ",
 Cell[BoxData["\"\<GUI/\>\""], "InlineFormula"],
 " can be loaded with a relative pathname beginning with the path within the \
",
 Cell[BoxData["\"\<GUI/\>\""], "InlineFormula"],
 " directory.",
 " ",
 "This follows the similar convention of Java classes and jars being \
discovered by ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " for files located within the ",
 Cell[BoxData["\"\<Java/\>\""], "InlineFormula"],
 " subdirectory of an AddOn."
}], "Text",
 CellTags->"Deployment",
 CellID->356556734],

Cell[TextData[{
 "Upon startup of the ",
 Cell[BoxData["GUIKit`"], "InlineFormula"],
 " package all AddOns are checked for a ",
 Cell[BoxData["\"\<GUI/\>\""], "InlineFormula"],
 " subdirectory and these paths are combined into a stored path list as ",
 Cell[BoxData[
  ButtonBox["$GUIPath",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/$GUIPath"]], "InlineFormula"],
 ". This path list is used when loading user interface definitions from the \
filesystem. Some typical locations for AddOns applications are shown below."
}], "Text",
 CellTags->"Deployment",
 CellID->667336070],

Cell[BoxData[GridBox[{
   {
    RowBox[{"     ", 
     RowBox[{"\[FilledSmallSquare]", " ", 
      RowBox[{"$UserBaseDirectory", "/", "Applications"}]}]}]},
   {
    RowBox[{"     ", 
     RowBox[{"\[FilledSmallSquare]", " ", 
      RowBox[{"$UserBaseDirectory", "/", "Autoload"}]}]}]},
   {
    RowBox[{"     ", 
     RowBox[{"\[FilledSmallSquare]", " ", 
      RowBox[{"$BaseDirectory", "/", "Applications"}]}]}]},
   {
    RowBox[{"     ", 
     RowBox[{"\[FilledSmallSquare]", " ", 
      RowBox[{"$BaseDirectory", "/", "Autoload"}]}]}]}
  }]], "DefinitionBox1Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22831],

Cell[TextData[{
 "Locations for user ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications which are searched by ",
 StyleBox["GUIKit.",
  FontSlant->"Italic"]
}], "Caption",
 CellID->274185680],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Deployment",
 CellLabel->"In[1]:=",
 CellID->179863205],

Cell[TextData[{
 "This path list is generated on startup of the ",
 StyleBox["GUIKit`", "MR"],
 " package by finding all ",
 Cell[BoxData["\"\<GUI/\>\""], "InlineFormula"],
 " subdirectories in all AddOns."
}], "Text",
 CellTags->"Deployment",
 CellID->211348074],

Cell[CellGroupData[{

Cell[BoxData["$GUIPath"], "Input",
 CellTags->"Deployment",
 CellLabel->"In[2]:=",
 CellID->81239045],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\SystemFiles\\\\GUI\\\\\"\>", 
   ",", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\AddOns\\\\Packages\\\\EquationTrekker\\\\\
GUI\\\\\"\>", 
   ",", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\AddOns\\\\Packages\\\\GUIKit\\\\GUI\\\\\"\>\
", ",", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\SystemFiles\\\\Links\\\\DatabaseLink\\\\GUI\
\\\\\"\>", 
   ",", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\SystemFiles\\\\Links\\\\WebServices\\\\GUI\\\
\\\"\>"}], "}"}]], "Output",
 CellTags->"Deployment",
 CellLabel->"Out[2]=",
 CellID->163682868]
}, Open  ]],

Cell[TextData[{
 "The relative path ",
 Cell[BoxData["\"\<Wolfram/Example/Calculator\>\""], "InlineFormula"],
 " is all that is needed to load a file located at ",
 Cell[BoxData[
 "\"\<SomeAddOn/GUI/Wolfram/Example/Calculator.xml\>\""], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Deployment",
 CellID->80349495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\"\<Wolfram/Example/Calculator\>\"", 
  "]"}]], "Input",
 CellTags->"Deployment",
 CellLabel->"In[3]:=",
 CellID->90861042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"FirstArgumentField\"\>", "\[Rule]", "34"}], ",", 
   RowBox[{"\<\"SecondArgumentField\"\>", "\[Rule]", "3434"}], ",", 
   RowBox[{"\<\"SumField\"\>", "\[Rule]", "3468"}], ",", 
   RowBox[{"\<\"DifferenceField\"\>", "\[Rule]", 
    RowBox[{"-", "3400"}]}], ",", 
   RowBox[{"\<\"ProductField\"\>", "\[Rule]", "116756"}], ",", 
   RowBox[{"\<\"QuotientField\"\>", "\[Rule]", 
    FractionBox["1", "101"]}]}], "}"}]], "Output",
 CellTags->"Deployment",
 CellLabel->"Out[3]=",
 CellID->673780129]
}, Open  ]],

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " definitions can be stored on the filesystem and used in either the XML \
format, GUIKitXML, using an .xml extension, or the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression format using a .m extension. The possible extension of a user \
interface definition can be excluded when specifying its relative pathname. \
First, a file with the given relative pathname and extension \".xml\" is \
searched for, followed by a file with extension \".m\" if an XML version is \
not found. This allows you to freely mix XML and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " definitions when defining interfaces. One implementation detail is that \
all interface definitions at runtime are converted to the XML form when \
created so there is some minor benefit of deploying your final AddOn \
interface definitions in the XML representation.",
 " ",
 "You do not however have to recreate the XML version of your expressions by \
hand, but can simply use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", "\"\<file.xml\>\"", ",", "expr", 
   ",", "\"\<GUIKitXML\>\"", "]"}]], "InlineFormula"],
 " to let the ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " system create the equivalent XML definition for you, since it \
automatically registers a \"GUIKitXML\" format with ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " when the ",
 StyleBox["GUIKit` ", "MR"],
 "package is loaded."
}], "Text",
 CellTags->"Deployment",
 CellID->51118948],

Cell[CellGroupData[{

Cell["A Sample Application", "Section",
 CellTags->"Deployment",
 CellID->374389741],

Cell[TextData[{
 "The layout of a sample application that contains a specialized user \
interface driven by ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " is shown below."
}], "Text",
 CellID->21481789],

Cell["\<\
Compute
\tKernel
\t\tinit.m
\tCompute.m
\tGUI
\t\tZoroCorp
\t\t\tComputeGUI.m
\t\t\tComputeScript.m\
\>", "Code",
 CellID->1150478942],

Cell["Layout of a sample application.", "Caption",
 CellID->123726621],

Cell[TextData[{
 "The application is called ",
 StyleBox["Compute", "MR"],
 ", and the main ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code lives in the file ",
 StyleBox["Compute.m", "MR"],
 ". This is all in the standard way for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications. The user interface definitions go into the GUI directory and \
can be accessed from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code in ",
 StyleBox["Compute.m", "MR"],
 ". A sample of how this could be arranged is shown below."
}], "Text",
 CellID->67340648],

Cell["\<\
Needs[\"GUIKit`\"]

...
  Module[ {ref},
    ref = GUIRun[ \"ZoroCorp/ComputeGUI\"] ;
    ...
  ]
\
\>", "Code",
 CellID->93315676],

Cell["Running a GUI from application code.", "Caption",
 CellID->67141141],

Cell[TextData[{
 "This application could be installed in one of the standard locations for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications, for example ",
 StyleBox["$UserBaseDirectory/Applications", "MR"],
 ", and then it could be used."
}], "Text",
 CellID->53197538],

Cell["\<\
As can be seen the GUI definitions are placed in a subdirectory named \
ZoroCorp, this is done to make sure that there is no conflict if somebody \
else releases a GUI named ComputeGUI.\
\>", "Text",
 CellID->37094360],

Cell[TextData[{
 "To be even more reusable and modular the design has broken out the code \
used in scripts for the GUI into a separate file ",
 StyleBox["ComputeScript.m", "MR"],
 ". This is loaded from the GUI as shown below."
}], "Text",
 CellID->27476174],

Cell["\<\
Widget[\"Frame\",
  {
  ...
  Script[{}, ScriptSource -> \"ComputeScript.m\"]
  }
]\
\>", "Program",
 CellID->237214188],

Cell["Using an external script from inside a GUI definition.", "Caption",
 CellID->417588409],

Cell[TextData[{
 "Breaking out the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code into a separate script file is most useful when you have more than \
one GUI component that uses the same code."
}], "Text",
 CellID->56708157],

Cell[TextData[{
 "The ",
 ButtonBox["Wolfram ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/workbench"], None}],
 StyleBox[ButtonBox["Workbench",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/workbench"], None}],
  FontSlant->"Italic"],
 " is a development environment for ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"],
 " It contains a number of useful features for working with ",
 StyleBox["GUIKit. ",
  FontSlant->"Italic"],
 "These include creating ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications that contain GUI definitions and helping you to develop your \
GUI with debugging tools. It is described in the tutorial ",
 ButtonBox["Wolfram ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WolframWorkbench"],
 StyleBox[ButtonBox["Workbench",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WolframWorkbench"],
  FontSlant->"Italic"],
 ButtonBox[" Support",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WolframWorkbench"],
 "."
}], "Text",
 CellTags->"Deployment",
 CellID->175937612]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Deployment - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 12.3966274}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "There are a number of features of the GUIKit framework that aid \
deployment of user interface definitions with your own AddOns so that they \
can be easily executed when needed. Instead of programmatically building up \
an expression that represents a user interface and calling GUIRun or \
GUIRunModal dynamically, there is also a filesystem directory within every \
AddOn where user interface definitions will automatically be discovered. Any \
definitions placed within a subdirectory folder of an AddOn named \"GUI/\" \
can be loaded with a relative pathname beginning with the path within the \
\"GUI/\" directory. This follows the similar convention of Java classes and \
jars being discovered by J/Link for files located within the \"Java/\" \
subdirectory of an AddOn. Upon startup of the GUIKit` package all AddOns are \
checked for a \"GUI/\" subdirectory and these paths are combined into a \
stored path list as $GUIPath. This path list is used when loading user \
interface definitions from the filesystem. Some typical locations for AddOns \
applications are shown below. Locations for user Mathematica applications \
which are searched by GUIKit.", "synonyms" -> {}, "title" -> "Deployment", 
    "type" -> "Tutorial", "uri" -> "GUIKit/tutorial/Deployment"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Deployment"->{
  Cell[731, 29, 72, 2, 70, "Title",
   CellTags->"Deployment",
   CellID->534864338],
  Cell[806, 33, 1328, 35, 70, "Text",
   CellTags->"Deployment",
   CellID->356556734],
  Cell[2137, 70, 589, 14, 70, "Text",
   CellTags->"Deployment",
   CellID->667336070],
  Cell[3848, 124, 158, 5, 70, "Input",
   CellTags->"Deployment",
   CellID->179863205],
  Cell[4009, 131, 263, 8, 70, "Text",
   CellTags->"Deployment",
   CellID->211348074],
  Cell[4297, 143, 101, 3, 70, "Input",
   CellTags->"Deployment",
   CellID->81239045],
  Cell[4401, 148, 763, 17, 70, "Output",
   CellTags->"Deployment",
   CellID->163682868],
  Cell[5179, 168, 315, 9, 70, "Text",
   CellTags->"Deployment",
   CellID->80349495],
  Cell[5519, 181, 167, 5, 70, "Input",
   CellTags->"Deployment",
   CellID->90861042],
  Cell[5689, 188, 548, 13, 70, "Output",
   CellTags->"Deployment",
   CellID->673780129],
  Cell[6252, 204, 1783, 46, 70, "Text",
   CellTags->"Deployment",
   CellID->51118948],
  Cell[8060, 254, 84, 2, 70, "Section",
   CellTags->"Deployment",
   CellID->374389741],
  Cell[10636, 365, 1129, 35, 70, "Text",
   CellTags->"Deployment",
   CellID->175937612]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Deployment", 14208, 453}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 72, 2, 70, "Title",
 CellTags->"Deployment",
 CellID->534864338],
Cell[806, 33, 1328, 35, 70, "Text",
 CellTags->"Deployment",
 CellID->356556734],
Cell[2137, 70, 589, 14, 70, "Text",
 CellTags->"Deployment",
 CellID->667336070],
Cell[2729, 86, 905, 26, 70, "DefinitionBox1Col",
 CellID->22831],
Cell[3637, 114, 208, 8, 70, "Caption",
 CellID->274185680],
Cell[3848, 124, 158, 5, 70, "Input",
 CellTags->"Deployment",
 CellID->179863205],
Cell[4009, 131, 263, 8, 70, "Text",
 CellTags->"Deployment",
 CellID->211348074],
Cell[CellGroupData[{
Cell[4297, 143, 101, 3, 70, "Input",
 CellTags->"Deployment",
 CellID->81239045],
Cell[4401, 148, 763, 17, 70, "Output",
 CellTags->"Deployment",
 CellID->163682868]
}, Open  ]],
Cell[5179, 168, 315, 9, 70, "Text",
 CellTags->"Deployment",
 CellID->80349495],
Cell[CellGroupData[{
Cell[5519, 181, 167, 5, 70, "Input",
 CellTags->"Deployment",
 CellID->90861042],
Cell[5689, 188, 548, 13, 70, "Output",
 CellTags->"Deployment",
 CellID->673780129]
}, Open  ]],
Cell[6252, 204, 1783, 46, 70, "Text",
 CellTags->"Deployment",
 CellID->51118948],
Cell[CellGroupData[{
Cell[8060, 254, 84, 2, 70, "Section",
 CellTags->"Deployment",
 CellID->374389741],
Cell[8147, 258, 205, 7, 70, "Text",
 CellID->21481789],
Cell[8355, 267, 144, 10, 70, "Code",
 CellID->1150478942],
Cell[8502, 279, 70, 1, 70, "Caption",
 CellID->123726621],
Cell[8575, 282, 582, 19, 70, "Text",
 CellID->67340648],
Cell[9160, 303, 141, 10, 70, "Code",
 CellID->93315676],
Cell[9304, 315, 74, 1, 70, "Caption",
 CellID->67141141],
Cell[9381, 318, 289, 8, 70, "Text",
 CellID->53197538],
Cell[9673, 328, 228, 5, 70, "Text",
 CellID->37094360],
Cell[9904, 335, 259, 6, 70, "Text",
 CellID->27476174],
Cell[10166, 343, 130, 8, 70, "Program",
 CellID->237214188],
Cell[10299, 353, 93, 1, 70, "Caption",
 CellID->417588409],
Cell[10395, 356, 238, 7, 70, "Text",
 CellID->56708157],
Cell[10636, 365, 1129, 35, 70, "Text",
 CellTags->"Deployment",
 CellID->175937612]
}, Open  ]]
}, Open  ]],
Cell[11792, 404, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

