(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40959,       1272]
NotebookOptionsPosition[     35096,       1071]
NotebookOutlinePosition[     36957,       1123]
CellTagsIndexPosition[     36882,       1118]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " Example: GraphEditor"
}], "Title",
 CellID->554471618],

Cell["", "Text",
 CellID->79083],

Cell["", "Text",
 CellID->550597613],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 ImageSize->{308, 342},
 CellID->535191259],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 CellContext->Notebook,
 CellID->852620852],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[11]:=",
 CellID->222635711],

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphEdit", "[", "expr_", "]"}], ":=", 
  RowBox[{"GUIRunModal", "[", 
   RowBox[{"PrepareInterfaceReference", "[", "expr", "]"}], "]"}]}]], "Input",\

 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[13]:=",
 CellID->205793578],

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphEditNonModal", "[", "expr_", "]"}], ":=", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"PrepareInterfaceReference", "[", "expr", "]"}], "]"}]}]], "Input",\

 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[14]:=",
 CellID->139560938],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrepareInterfaceReference", "[", "expr_", "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "ref", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ref", "=", 
      RowBox[{"GUILoad", "[", "\"\<Graph/GraphEditor\>\"", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ref", " ", "@", " ", 
      RowBox[{"InvokeMethod", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<graphFrame\>\"", ",", "\"\<pack\>\""}], "}"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"JavaShow", "[", 
      RowBox[{"ref", " ", "@", " ", 
       RowBox[{"WidgetReference", "[", "\"\<graphFrame\>\"", "]"}]}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"ref", " ", "@", " ", 
      RowBox[{"SetPropertyValue", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<graphPanel\>\"", ",", "\"\<expr\>\""}], "}"}], ",", 
        RowBox[{"CreateGraphExpr", "[", "expr", "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "ref"}]}], "]"}]}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[15]:=",
 CellID->924525846],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateGraphExpr", "[", "gr_Graph", "]"}], ":=", "gr"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[16]:=",
 CellID->547048266],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateGraphExpr", "[", "mat_SparseArray", "]"}], ":=", 
  RowBox[{"ArrayRules", "[", "mat", "]"}]}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[17]:=",
 CellID->449169350],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateGraphExpr", "[", 
   RowBox[{"mat_", "?", "MatrixQ"}], "]"}], ":=", 
  RowBox[{"ArrayRules", "[", "mat", "]"}]}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[18]:=",
 CellID->148454754],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateGraphExpr", "[", 
   RowBox[{"r", ":", 
    RowBox[{"{", "___Rule", "}"}]}], "]"}], ":=", "r"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[19]:=",
 CellID->370470370],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateGraphExpr", "[", "x___", "]"}], ":=", 
  RowBox[{"{", "}"}]}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[20]:=",
 CellID->219588887]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", "Section",
 CellID->45055220],

Cell[TextData[{
 "This example demonstrates the benefit of supplementing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functionality with ",
 StyleBox["GUIKit ",
  FontSlant->"Italic"],
 "user interface elements leveraging existing third-party graph model and \
editing libraries.",
 " ",
 StyleBox["GraphEdit", "MR"],
 " widgets take advantage of the ",
 StyleBox["Graph", "Program"],
 " expression supported by ",
 StyleBox["Combinatorica`", "Output"],
 " and also ",
 StyleBox["SparseArray", "Output"],
 " ",
 StyleBox["ArrayRules", "Output"],
 ".",
 StyleBox[" ", "Output"]
}], "Text",
 CellID->593308782],

Cell["The user interface of the graph editing canvas allows you to", "Text",
 CellID->402621341],

Cell[TextData[{
 "Create a new node (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["mouse click", "PointerEvent"],
 " or ",
 StyleBox["Right (alternate) mouse click", "PointerEvent"],
 ")."
}], "BulletedText",
 CellID->49249496],

Cell[TextData[{
 "Create a new edge (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["mouse click", "PointerEvent"],
 " or ",
 StyleBox["Right (alternate) mouse click", "PointerEvent"],
 " inside a node)."
}], "BulletedText",
 CellID->40781091],

Cell[TextData[{
 "Move selection (",
 StyleBox["Drag", "PointerEvent"],
 " mouse on selected nodes and edges)."
}], "BulletedText",
 CellID->800285923],

Cell[TextData[{
 "Change selection (",
 StyleBox["Drag", "PointerEvent"],
 ", ",
 StyleBox["click", "PointerEvent"],
 ", and ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["click", "PointerEvent"],
 ")."
}], "BulletedText",
 CellID->132656768],

Cell[TextData[{
 "Delete currently selected nodes and edges (",
 StyleBox["Del", "KeyEvent"],
 " or ",
 StyleBox["Backspace", "KeyEvent"],
 " key)."
}], "BulletedText",
 CellID->288413676],

Cell[CellGroupData[{

Cell["Matrix", "SubsubsectionOpener",
 CellContext->Notebook,
 CellID->331035999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "+", "b"}], ",", 
      RowBox[{"f", "[", 
       RowBox[{"x", ",", 
        RowBox[{"x", "'"}]}], "]"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      SqrtBox["c"], ",", 
      FractionBox["d", "e"]}], "}"}]}], "}"}]}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[21]:=",
 CellID->292462136],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", 
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None]}], "]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     SqrtBox["c"], ",", 
     FractionBox["d", "e"]}], "}"}]}], "}"}]], "Output",
 CellContext->Notebook,
 CellLabel->"Out[21]=",
 CellID->237195264]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "mat", "]"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[22]:=",
 CellID->282081962],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"a", "+", "b"}], 
      RowBox[{"f", "[", 
       RowBox[{"x", ",", 
        SuperscriptBox["x", "\[Prime]",
         MultilineFunction->None]}], "]"}], "0"},
     {"x", 
      SqrtBox["c"], 
      FractionBox["d", "e"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellContext->Notebook,
 CellLabel->"Out[22]//MatrixForm=",
 CellID->102440979]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"outRules", " ", "=", " ", 
  RowBox[{"GraphEdit", "[", "mat", "]"}]}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[23]:=",
 CellID->57506141],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
    RowBox[{"a", "+", "b"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "x"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      SuperscriptBox["x", "\[Prime]",
       MultilineFunction->None]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
    SqrtBox["c"]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
    FractionBox["d", "e"]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "0"}]}], "}"}]], "Output",
 CellContext->Notebook,
 CellLabel->"Out[23]=",
 CellID->363392494]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"SparseArray", "[", "outRules", "]"}], "]"}], " ", "//", " ", 
  "MatrixForm"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[24]:=",
 CellID->197684172],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"a", "+", "b"}], 
      RowBox[{"f", "[", 
       RowBox[{"x", ",", 
        SuperscriptBox["x", "\[Prime]",
         MultilineFunction->None]}], "]"}], "0"},
     {"x", 
      SqrtBox["c"], 
      FractionBox["d", "e"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellContext->Notebook,
 CellLabel->"Out[24]//MatrixForm=",
 CellID->127543533]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray", "SubsubsectionOpener",
 CellContext->Notebook,
 CellID->113065322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"-", 
        FractionBox["1", "i"]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"i", "-", "j"}], "]"}], ",", "5"}], "]"}], "==", "1"}]}], 
       "\[Rule]", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "6"}], "}"}]}], "]"}]}]], "Input",
 CellContext->Notebook,
 CellTags->"SparseArray",
 CellLabel->"In[29]:=",
 CellID->133215316],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "16", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 16, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "6"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 CellContext->Notebook,
 CellTags->"SparseArray",
 CellLabel->"Out[29]=",
 CellID->95865706]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", " ", "//", " ", "MatrixForm"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[30]:=",
 CellID->86280808],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1"}], "1", "0", "0", "0", "0"},
     {"1", 
      RowBox[{"-", 
       FractionBox["1", "2"]}], "1", "0", "0", "0"},
     {"0", "1", 
      RowBox[{"-", 
       FractionBox["1", "3"]}], "1", "0", "0"},
     {"0", "0", "1", 
      RowBox[{"-", 
       FractionBox["1", "4"]}], "1", "0"},
     {"0", "0", "0", "1", 
      RowBox[{"-", 
       FractionBox["1", "5"]}], "1"},
     {"0", "0", "0", "0", "1", 
      RowBox[{"-", 
       FractionBox["1", "6"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {6, 6}, 0, {
     1, {{0, 2, 5, 8, 11, 14, 16}, {{2}, {1}, {2}, {3}, {1}, {3}, {4}, {2}, {
       4}, {5}, {3}, {4}, {6}, {5}, {5}, {6}}}, {
      1, -1, Rational[-1, 2], 1, 1, Rational[-1, 3], 1, 1, Rational[-1, 4], 1,
        1, 1, 1, Rational[-1, 5], 1, Rational[-1, 6]}}]]]]], "Output",
 CellContext->Notebook,
 CellLabel->"Out[30]//MatrixForm=",
 CellID->16640909]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"outRules", " ", "=", " ", 
  RowBox[{"GraphEdit", "[", "mat", "]"}]}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[31]:=",
 CellID->107575190],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", 
    RowBox[{"-", 
     FractionBox["1", "2"]}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
    RowBox[{"-", 
     FractionBox["1", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", 
    RowBox[{"-", 
     FractionBox["1", "4"]}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}], "\[Rule]", 
    RowBox[{"-", 
     FractionBox["1", "5"]}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"6", ",", "5"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"6", ",", "6"}], "}"}], "\[Rule]", 
    RowBox[{"-", 
     FractionBox["1", "6"]}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "0"}]}], "}"}]], "Output",
 CellContext->Notebook,
 CellLabel->"Out[31]=",
 CellID->627343390]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"SparseArray", "[", "outRules", "]"}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[32]:=",
 CellID->658265351],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1"}], "1", "0", "0", "0", "0"},
     {"1", 
      RowBox[{"-", 
       FractionBox["1", "2"]}], "1", "0", "0", "0"},
     {"0", "1", 
      RowBox[{"-", 
       FractionBox["1", "3"]}], "1", "0", "0"},
     {"0", "0", "1", 
      RowBox[{"-", 
       FractionBox["1", "4"]}], "1", "0"},
     {"0", "0", "0", "1", 
      RowBox[{"-", 
       FractionBox["1", "5"]}], "1"},
     {"0", "0", "0", "0", "1", 
      RowBox[{"-", 
       FractionBox["1", "6"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellContext->Notebook,
 CellLabel->"Out[32]//MatrixForm=",
 CellID->241579349]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Create", "SubsubsectionOpener",
 CellContext->Notebook,
 CellID->491429705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gr", " ", "=", " ", 
  RowBox[{"GraphEdit", "[", " ", 
   RowBox[{"Graph", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}], ",", " ", 
     RowBox[{"EdgeDirection", "\[Rule]", "True"}]}], "]"}], "]"}]}]], "Input",\

 CellContext->Notebook,
 CellLabel->"In[33]:=",
 CellID->61054957],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", "\<\"Undirected\"\>", 
   "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
  SequenceForm[
  "\[SkeletonIndicator]Graph:<", 4, ", ", 4, ", ", "Undirected", 
   ">\[SkeletonIndicator]"],
  Editable->False]], "Output",
 CellContext->Notebook,
 CellLabel->"Out[33]=",
 CellID->294294686]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowGraph", "[", "gr", "]"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[34]:=",
 CellID->603993105],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.6987951807228916, 0.42168674698795183`}, {1., 
      0.28192771084337354`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.6987951807228916, 0.42168674698795183`}, {0.9060240963855423,
       0.47469879518072294`}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{1., 0.28192771084337354`}, {0.8506024096385543, 0.}}], 
     {GrayLevel[0]}}, 
    {GrayLevel[0], Thickness[0.005], 
     LineBox[{{0.9060240963855423, 0.47469879518072294`}, {1., 
      0.28192771084337354`}}], 
     {GrayLevel[0]}}}, {
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.6987951807228916, 0.42168674698795183`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{0.8506024096385543, 0.}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], PointBox[{1., 0.28192771084337354`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0]}}, 
    {GrayLevel[0], 
     {PointSize[0.025], 
      PointBox[{0.9060240963855423, 0.47469879518072294`}]}, 
     {GrayLevel[0]}, 
     {GrayLevel[0]}}}},
  AlignmentPoint->Center,
  AspectRatio->1,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0.6487951807228916, 1.05}, {-0.05, 0.5246987951807229}},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellContext->Notebook,
 CellLabel->"Out[34]=",
 CellID->246004727]
}, Open  ]],

Cell["\<\
Here is another version run in a modeless session where you can interact with \
and change the displayed graph.\
\>", "Text",
 CellContext->Notebook,
 CellID->146841691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GraphEditNonModal", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "c", ",", "d"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[35]:=",
 CellID->303124189],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject60400678731777, 
   JLink`Objects`vm1`JavaObject520491701895169]]], "Output",
 CellContext->Notebook,
 CellLabel->"Out[35]=",
 CellID->782258206]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<graphPanel\>\"", ",", "\"\<expr\>\""}], "}"}], ",", 
    RowBox[{"ArrayRules", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"e", ",", "f", ",", "g", ",", "n"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"h", ",", "i", ",", "j", ",", "m"}], "}"}]}], "}"}], "]"}]}], 
   "]"}]}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[36]:=",
 CellID->648167033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"PropertyValue", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<graphPanel\>\"", ",", " ", "\"\<expr\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[37]:=",
 CellID->218791334],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "e"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "h"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "f"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "i"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "g"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "j"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "n"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "m"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "0"}]}], "}"}]], "Output",
 CellContext->Notebook,
 CellLabel->"Out[37]=",
 CellID->343602665]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIKit Example: GraphEditor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 15.5527158}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "This example demonstrates the benefit of supplementing Mathematica \
functionality with GUIKit user interface elements leveraging existing \
third-party graph model and editing libraries. GraphEdit widgets take \
advantage of the Graph expression supported by Combinatorica` and also \
SparseArray ArrayRules. ", "synonyms" -> {}, "title" -> 
    "GUIKit Example: GraphEditor", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/GraphEditor"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SparseArray"->{
  Cell[22656, 616, 759, 26, 70, "Input",
   CellTags->"SparseArray",
   CellID->133215316],
  Cell[23418, 644, 443, 16, 70, "Output",
   CellTags->"SparseArray",
   CellID->95865706]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SparseArray", 36674, 1108}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 117, 5, 70, "Title",
 CellID->554471618],
Cell[851, 36, 32, 1, 70, "Text",
 CellID->79083],
Cell[886, 39, 36, 1, 70, "Text",
 CellID->550597613],
Cell[925, 42, 12179, 201, 70, "Graphics",
 CellID->535191259],
Cell[CellGroupData[{
Cell[13129, 247, 76, 2, 70, "SubsectionOpener",
 CellID->852620852],
Cell[13208, 251, 167, 5, 70, "Input",
 InitializationCell->True,
 CellID->222635711],
Cell[13378, 258, 281, 9, 70, "Input",
 InitializationCell->True,
 CellID->205793578],
Cell[13662, 269, 284, 9, 70, "Input",
 InitializationCell->True,
 CellID->139560938],
Cell[13949, 280, 1139, 29, 70, "Input",
 InitializationCell->True,
 CellID->924525846],
Cell[15091, 311, 195, 6, 70, "Input",
 InitializationCell->True,
 CellID->547048266],
Cell[15289, 319, 240, 7, 70, "Input",
 InitializationCell->True,
 CellID->449169350],
Cell[15532, 328, 259, 8, 70, "Input",
 InitializationCell->True,
 CellID->148454754],
Cell[15794, 338, 242, 8, 70, "Input",
 InitializationCell->True,
 CellID->370470370],
Cell[16039, 348, 208, 7, 70, "Input",
 InitializationCell->True,
 CellID->219588887]
}, Closed]],
Cell[CellGroupData[{
Cell[16284, 360, 46, 1, 70, "Section",
 CellID->45055220],
Cell[16333, 363, 618, 22, 70, "Text",
 CellID->593308782],
Cell[16954, 387, 96, 1, 70, "Text",
 CellID->402621341],
Cell[17053, 390, 263, 9, 70, "BulletedText",
 CellID->49249496],
Cell[17319, 401, 277, 9, 70, "BulletedText",
 CellID->40781091],
Cell[17599, 412, 151, 5, 70, "BulletedText",
 CellID->800285923],
Cell[17753, 419, 278, 11, 70, "BulletedText",
 CellID->132656768],
Cell[18034, 432, 188, 7, 70, "BulletedText",
 CellID->288413676],
Cell[CellGroupData[{
Cell[18247, 443, 81, 2, 70, "SubsubsectionOpener",
 CellID->331035999],
Cell[CellGroupData[{
Cell[18353, 449, 450, 16, 70, "Input",
 CellID->292462136],
Cell[18806, 467, 451, 16, 70, "Output",
 CellID->237195264]
}, Open  ]],
Cell[CellGroupData[{
Cell[19294, 488, 133, 4, 70, "Input",
 CellID->282081962],
Cell[19430, 494, 872, 27, 70, "Output",
 CellID->102440979]
}, Open  ]],
Cell[CellGroupData[{
Cell[20339, 526, 171, 5, 70, "Input",
 CellID->57506141],
Cell[20513, 533, 852, 30, 70, "Output",
 CellID->363392494]
}, Open  ]],
Cell[CellGroupData[{
Cell[21402, 568, 219, 7, 70, "Input",
 CellID->197684172],
Cell[21624, 577, 872, 27, 70, "Output",
 CellID->127543533]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22545, 610, 86, 2, 70, "SubsubsectionOpener",
 CellID->113065322],
Cell[CellGroupData[{
Cell[22656, 616, 759, 26, 70, "Input",
 CellTags->"SparseArray",
 CellID->133215316],
Cell[23418, 644, 443, 16, 70, "Output",
 CellTags->"SparseArray",
 CellID->95865706]
}, Open  ]],
Cell[CellGroupData[{
Cell[23898, 665, 138, 4, 70, "Input",
 CellID->86280808],
Cell[24039, 671, 1409, 41, 70, "Output",
 CellID->16640909]
}, Open  ]],
Cell[CellGroupData[{
Cell[25485, 717, 172, 5, 70, "Input",
 CellID->107575190],
Cell[25660, 724, 1908, 67, 70, "Output",
 CellID->627343390]
}, Open  ]],
Cell[CellGroupData[{
Cell[27605, 796, 214, 7, 70, "Input",
 CellID->658265351],
Cell[27822, 805, 1113, 35, 70, "Output",
 CellID->241579349]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28984, 846, 81, 2, 70, "SubsubsectionOpener",
 CellID->491429705],
Cell[CellGroupData[{
Cell[29090, 852, 332, 11, 70, "Input",
 CellID->61054957],
Cell[29425, 865, 529, 13, 70, "Output",
 CellID->294294686]
}, Open  ]],
Cell[CellGroupData[{
Cell[29991, 883, 131, 4, 70, "Input",
 CellID->603993105],
Cell[30125, 889, 2258, 76, 70, "Output",
 CellID->246004727]
}, Open  ]],
Cell[32398, 968, 179, 5, 70, "Text",
 CellID->146841691],
Cell[CellGroupData[{
Cell[32602, 977, 348, 11, 70, "Input",
 CellID->303124189],
Cell[32953, 990, 302, 8, 70, "Output",
 CellID->782258206]
}, Open  ]],
Cell[33270, 1001, 525, 16, 70, "Input",
 CellID->648167033],
Cell[CellGroupData[{
Cell[33820, 1021, 255, 8, 70, "Input",
 CellID->218791334],
Cell[34078, 1031, 940, 32, 70, "Output",
 CellID->343602665]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]],
Cell[35069, 1069, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

