(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24068,        709]
NotebookOptionsPosition[     16839,        476]
NotebookOutlinePosition[     21447,        609]
CellTagsIndexPosition[     21372,        604]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["XML Syntax", "Title",
 CellTags->"ImportExport",
 CellID->24127298],

Cell[TextData[{
 "Interface definitions can be defined using either a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression or an XML definition. For many usages the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax is preferred. However, in cases where you want to launch GUIs \
before ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has been launched the XML definition is useful. "
}], "Text",
 CellTags->"ImportExport",
 CellID->658435030],

Cell[CellGroupData[{

Cell["Import and Export", "Section",
 CellTags->"ImportExport",
 CellID->298444187],

Cell[TextData[{
 "You can work with the XML definition for ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " interfaces from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "/",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " format type ",
 Cell[BoxData["\"\<GUIKitXML\>\""], "InlineFormula"],
 ". The ",
 Cell[BoxData["GUIKit`"], "InlineFormula"],
 " package adds support for this format type so that you can convert between \
the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and the XML format."
}], "Text",
 CellTags->"ImportExport",
 CellID->199048354],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"ImportExport",
 CellLabel->"In[105]:=",
 CellID->163211397],

Cell[TextData[{
 "Knowing that ",
 Cell[BoxData[
  ButtonBox["$GUIPath",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/$GUIPath"]], "InlineFormula"],
 " provides access to all your interfaces, you can use this to easily import \
XML definitions into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as the equivalent expression format.\nHere is what the contents of the XML \
file looks like for your base frame definition."
}], "Text",
 CellTags->"ImportExport",
 CellID->11189640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$Path", "=", " ", "$GUIPath"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<Frame.xml\>\"", ",", "\"\<Text\>\""}], "]"}]}], 
  "]"}]], "Input",
 CellTags->"ImportExport",
 CellLabel->"In[2]:=",
 CellID->181219874],

Cell[BoxData["\<\"<?xml version=\\\"1.0\\\"?>\\n<widget \
class=\\\"com.wolfram.guikit.swing.GUIKitJFrame\\\">\\n\\t<args \
ref=\\\"##\\\"/>\\n</widget>\\n\"\>"], "Output",
 CellTags->"ImportExport",
 CellLabel->"Out[2]=",
 CellID->348347503]
}, Open  ]],

Cell[TextData[{
 "Here is that same definition imported as the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression."
}], "Text",
 CellTags->"ImportExport",
 CellID->43626405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$Path", "=", " ", "$GUIPath"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<Frame.xml\>\"", ",", "\"\<GUIKitXML\>\""}], "]"}]}], 
  "]"}]], "Input",
 CellTags->"ImportExport",
 CellLabel->"In[3]:=",
 CellID->689271263],

Cell[BoxData[
 RowBox[{"Widget", "[", 
  RowBox[{"\<\"class:com.wolfram.guikit.swing.GUIKitJFrame\"\>", ",", 
   RowBox[{"InitialArguments", "\[Rule]", 
    RowBox[{"WidgetReference", "[", "\<\"##\"\>", "]"}]}]}], "]"}]], "Output",\

 CellTags->"ImportExport",
 CellLabel->"Out[3]=",
 CellID->640686094]
}, Open  ]],

Cell[TextData[{
 "You can easily switch between the XML or expression format and can even use \
the SymbolicXML expression in your calls to ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GUIRunModal",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRunModal"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"ImportExport",
 CellID->61232698],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "xmlString", " ", "=", " ", 
   "\"\<\n<widget src='Panel'>\n  <group>\n    <widget src='Label'>\n    \
<args>\n    <string value='Hello World!'/>\n    </args>\n    </widget>\n  \
</group>\n</widget>\n\>\""}], ";"}]], "Input",
 CellTags->"ImportExport",
 CellLabel->"In[106]:=",
 CellID->2242722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", " ", 
   RowBox[{"ImportString", "[", 
    RowBox[{"xmlString", ",", " ", "\"\<XML\>\""}], "]"}], "]"}]}]], "Input",
 CellTags->"ImportExport",
 CellLabel->"In[107]:=",
 CellID->750547620],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject128715455463425, 
   JLink`Objects`JavaObject395686797377537]]], "Output",
 CellTags->"ImportExport",
 CellLabel->"Out[107]=",
 CellID->757409210]
}, Open  ]],

Cell["\<\
Here is a screen shot of what the previous definition renders.\
\>", "Text",
 CellTags->"ImportExport",
 CellID->386042488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"ImportExport",
 CellLabel->"In[108]:=",
 CellID->94021421],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"ImportExport",
 CellLabel->"Out[108]=",
 CellID->286022635]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{"ImportString", "[", 
   RowBox[{"xmlString", ",", "\"\<GUIKitXML\>\""}], "]"}]}]], "Input",
 CellTags->"ImportExport",
 CellLabel->"In[7]:=",
 CellID->194666056],

Cell[BoxData[
 RowBox[{"Widget", "[", 
  RowBox[{"\<\"Panel\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"Widget", "[", 
     RowBox[{"\<\"Label\"\>", ",", 
      RowBox[{"InitialArguments", "\[Rule]", 
       RowBox[{"{", "\<\"Hello World!\"\>", "}"}]}]}], "]"}], "}"}]}], 
  "]"}]], "Output",
 CellTags->"ImportExport",
 CellLabel->"Out[7]=",
 CellID->269561420]
}, Open  ]],

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "expr", "]"}]], "Input",
 CellTags->"ImportExport",
 CellLabel->"In[8]:=",
 CellID->170946531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"expr", ",", " ", "\"\<GUIKitXML\>\""}], "]"}]], "Input",
 CellTags->"ImportExport",
 CellLabel->"In[9]:=",
 CellID->877148464],

Cell[BoxData["\<\"<widget src='Panel'>\\n <group root='true'>\\n  <widget \
src='Label'>\\n   <args>\\n    <string>Hello World!</string>\\n   </args>\\n  \
 <group root='true'/>\\n  </widget>\\n </group>\\n</widget>\"\>"], "Output",
 CellTags->"ImportExport",
 CellLabel->"Out[9]=",
 CellID->634527996]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"symbolic", " ", "=", " ", 
  RowBox[{"ImportString", "[", 
   RowBox[{"xmlString", ",", " ", "\"\<XML\>\""}], "]"}]}]], "Input",
 CellTags->"ImportExport",
 CellLabel->"In[10]:=",
 CellID->43507406],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"widget\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"src\"\>", "\[Rule]", "\<\"Panel\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"group\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{"\<\"widget\"\>", ",", 
           RowBox[{"{", 
            RowBox[{"\<\"src\"\>", "\[Rule]", "\<\"Label\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"args\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"XMLElement", "[", 
                RowBox[{"\<\"string\"\>", ",", 
                 RowBox[{"{", 
                  
                  RowBox[{"\<\"value\"\>", 
                   "\[Rule]", "\<\"Hello World!\"\>"}], "}"}], ",", 
                 RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}], "}"}]}], "]"}], 
         "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 CellTags->"ImportExport",
 CellLabel->"Out[10]=",
 CellID->16862254]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " deployment functions can also take the SymbolicXML definition forms as \
direct input."
}], "Text",
 CellTags->"ImportExport",
 CellID->226635402],

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "symbolic", "]"}]], "Input",
 CellTags->"ImportExport",
 CellLabel->"In[11]:=",
 CellID->227860728]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XML Syntax - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 18.1463330}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "Interface definitions can be defined using either a Mathematica \
expression or an XML definition. For many usages the Mathematica syntax is \
preferred. However, in cases where you want to launch GUIs before Mathematica \
has been launched the XML definition is useful. You can work with the XML \
definition for GUIKit interfaces from within Mathematica using the \
Import/Export format type \"GUIKitXML\". The GUIKit` package adds support for \
this format type so that you can convert between the Mathematica and the XML \
format. Knowing that $GUIPath provides access to all your interfaces, you can \
use this to easily import XML definitions into Mathematica as the equivalent \
expression format. Here is what the contents of the XML file looks like for \
your base frame definition.", "synonyms" -> {}, "title" -> "XML Syntax", 
    "type" -> "Tutorial", "uri" -> "GUIKit/tutorial/ImportAndExport"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ImportExport"->{
  Cell[731, 29, 73, 2, 70, "Title",
   CellTags->"ImportExport",
   CellID->24127298],
  Cell[807, 33, 474, 14, 70, "Text",
   CellTags->"ImportExport",
   CellID->658435030],
  Cell[1306, 51, 83, 2, 70, "Section",
   CellTags->"ImportExport",
   CellID->298444187],
  Cell[1392, 55, 780, 28, 70, "Text",
   CellTags->"ImportExport",
   CellID->199048354],
  Cell[2175, 85, 162, 5, 70, "Input",
   CellTags->"ImportExport",
   CellID->163211397],
  Cell[2340, 92, 498, 14, 70, "Text",
   CellTags->"ImportExport",
   CellID->11189640],
  Cell[2863, 110, 332, 11, 70, "Input",
   CellTags->"ImportExport",
   CellID->181219874],
  Cell[3198, 123, 242, 5, 70, "Output",
   CellTags->"ImportExport",
   CellID->348347503],
  Cell[3455, 131, 188, 7, 70, "Text",
   CellTags->"ImportExport",
   CellID->43626405],
  Cell[3668, 142, 337, 11, 70, "Input",
   CellTags->"ImportExport",
   CellID->689271263],
  Cell[4008, 155, 303, 8, 70, "Output",
   CellTags->"ImportExport",
   CellID->640686094],
  Cell[4326, 166, 468, 15, 70, "Text",
   CellTags->"ImportExport",
   CellID->61232698],
  Cell[4797, 183, 333, 9, 70, "Input",
   CellTags->"ImportExport",
   CellID->2242722],
  Cell[5155, 196, 259, 7, 70, "Input",
   CellTags->"ImportExport",
   CellID->750547620],
  Cell[5417, 205, 299, 8, 70, "Output",
   CellTags->"ImportExport",
   CellID->757409210],
  Cell[5731, 216, 133, 4, 70, "Text",
   CellTags->"ImportExport",
   CellID->386042488],
  Cell[5889, 224, 139, 4, 70, "Input",
   CellTags->"ImportExport",
   CellID->94021421],
  Cell[6031, 230, 7561, 129, 70, "Output",
   Evaluatable->False,
   CellTags->"ImportExport",
   CellID->286022635],
  Cell[13629, 364, 209, 6, 70, "Input",
   CellTags->"ImportExport",
   CellID->194666056],
  Cell[13841, 372, 360, 11, 70, "Output",
   CellTags->"ImportExport",
   CellID->269561420],
  Cell[14216, 386, 137, 4, 70, "Input",
   CellTags->"ImportExport",
   CellID->170946531],
  Cell[14378, 394, 182, 5, 70, "Input",
   CellTags->"ImportExport",
   CellID->877148464],
  Cell[14563, 401, 302, 5, 70, "Output",
   CellTags->"ImportExport",
   CellID->634527996],
  Cell[14902, 411, 222, 6, 70, "Input",
   CellTags->"ImportExport",
   CellID->43507406],
  Cell[15127, 419, 1280, 34, 70, "Output",
   CellTags->"ImportExport",
   CellID->16862254],
  Cell[16422, 456, 218, 8, 70, "Text",
   CellTags->"ImportExport",
   CellID->226635402],
  Cell[16643, 466, 142, 4, 70, "Input",
   CellTags->"ImportExport",
   CellID->227860728]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ImportExport", 18864, 518}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 73, 2, 70, "Title",
 CellTags->"ImportExport",
 CellID->24127298],
Cell[807, 33, 474, 14, 70, "Text",
 CellTags->"ImportExport",
 CellID->658435030],
Cell[CellGroupData[{
Cell[1306, 51, 83, 2, 70, "Section",
 CellTags->"ImportExport",
 CellID->298444187],
Cell[1392, 55, 780, 28, 70, "Text",
 CellTags->"ImportExport",
 CellID->199048354],
Cell[2175, 85, 162, 5, 70, "Input",
 CellTags->"ImportExport",
 CellID->163211397],
Cell[2340, 92, 498, 14, 70, "Text",
 CellTags->"ImportExport",
 CellID->11189640],
Cell[CellGroupData[{
Cell[2863, 110, 332, 11, 70, "Input",
 CellTags->"ImportExport",
 CellID->181219874],
Cell[3198, 123, 242, 5, 70, "Output",
 CellTags->"ImportExport",
 CellID->348347503]
}, Open  ]],
Cell[3455, 131, 188, 7, 70, "Text",
 CellTags->"ImportExport",
 CellID->43626405],
Cell[CellGroupData[{
Cell[3668, 142, 337, 11, 70, "Input",
 CellTags->"ImportExport",
 CellID->689271263],
Cell[4008, 155, 303, 8, 70, "Output",
 CellTags->"ImportExport",
 CellID->640686094]
}, Open  ]],
Cell[4326, 166, 468, 15, 70, "Text",
 CellTags->"ImportExport",
 CellID->61232698],
Cell[4797, 183, 333, 9, 70, "Input",
 CellTags->"ImportExport",
 CellID->2242722],
Cell[CellGroupData[{
Cell[5155, 196, 259, 7, 70, "Input",
 CellTags->"ImportExport",
 CellID->750547620],
Cell[5417, 205, 299, 8, 70, "Output",
 CellTags->"ImportExport",
 CellID->757409210]
}, Open  ]],
Cell[5731, 216, 133, 4, 70, "Text",
 CellTags->"ImportExport",
 CellID->386042488],
Cell[CellGroupData[{
Cell[5889, 224, 139, 4, 70, "Input",
 CellTags->"ImportExport",
 CellID->94021421],
Cell[6031, 230, 7561, 129, 70, "Output",
 Evaluatable->False,
 CellTags->"ImportExport",
 CellID->286022635]
}, Open  ]],
Cell[CellGroupData[{
Cell[13629, 364, 209, 6, 70, "Input",
 CellTags->"ImportExport",
 CellID->194666056],
Cell[13841, 372, 360, 11, 70, "Output",
 CellTags->"ImportExport",
 CellID->269561420]
}, Open  ]],
Cell[14216, 386, 137, 4, 70, "Input",
 CellTags->"ImportExport",
 CellID->170946531],
Cell[CellGroupData[{
Cell[14378, 394, 182, 5, 70, "Input",
 CellTags->"ImportExport",
 CellID->877148464],
Cell[14563, 401, 302, 5, 70, "Output",
 CellTags->"ImportExport",
 CellID->634527996]
}, Open  ]],
Cell[CellGroupData[{
Cell[14902, 411, 222, 6, 70, "Input",
 CellTags->"ImportExport",
 CellID->43507406],
Cell[15127, 419, 1280, 34, 70, "Output",
 CellTags->"ImportExport",
 CellID->16862254]
}, Open  ]],
Cell[16422, 456, 218, 8, 70, "Text",
 CellTags->"ImportExport",
 CellID->226635402],
Cell[16643, 466, 142, 4, 70, "Input",
 CellTags->"ImportExport",
 CellID->227860728]
}, Open  ]]
}, Open  ]],
Cell[16812, 474, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

