(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32226,        881]
NotebookOptionsPosition[     24425,        640]
NotebookOutlinePosition[     29509,        779]
CellTagsIndexPosition[     29435,        774]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Scripting GUIs", "Title",
 CellTags->"Interaction",
 CellID->399677482],

Cell[TextData[{
 "Dynamic behavior is added to a ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " user interface by executing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. This lets one part of the definition interact with another, for \
example specifying the behavior when a button is clicked or a menu choice is \
made."
}], "Text",
 CellID->31373743],

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " definitions call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " expression; this can be placed in a definition as described in ",
 ButtonBox["GUI Building Blocks",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks"],
 ". ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " defines an initially unevaluated block of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. The ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " symbol has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ".",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " blocks in interface definitions are typically used either by themselves in \
the interface definitions to define common ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions used throughout the interface or as arguments to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BindEvent",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/BindEvent"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"eventName\", \"TI\"]\)\>\"", ",", " ", 
    RowBox[{
     ButtonBox["Script",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/Script"], "[", 
     StyleBox["expr", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " to define ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions to execute when a particular interface event occurs. The use of \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", "]"}]], "InlineFormula"],
 " in user interface definitions is in many ways identical to the techniques \
of supplementing HTML pages with JavaScript embedded code."
}], "Text",
 CellTags->"Interaction",
 CellID->35460127],

Cell[TextData[{
 "This example shows both of the common cases of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", "]"}]], "InlineFormula"],
 " usage.",
 " ",
 "There is a stand-alone ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", "]"}]], "InlineFormula"],
 " block that defines the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  RowBox[{"printMessage", "[", "]"}]], "InlineFormula"],
 "and ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " blocks attached to events of the button to execute the ",
 Cell[BoxData[
  RowBox[{"printMessage", "[", "]"}]], "InlineFormula"],
 " function whenever the events are triggered."
}], "Text",
 CellTags->"Interaction",
 CellID->594306160],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Interaction",
 CellLabel->"In[1]:=",
 CellID->327932526],

Cell["\<\
Here is a screen shot of what the user interface renders as on a typical \
platform.\
\>", "Text",
 CellTags->"Interaction",
 CellID->597467064],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->54507667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\[IndentingNewLine]", "  ", 
  RowBox[{
   StyleBox["Widget",
    CellFrame->True], "[", 
   RowBox[{"\"\<Button\>\"", ",", " ", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<text\>\"", "->", "\"\<execute\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"BindEvent", "[", 
       RowBox[{"\"\<action\>\"", ",", "\[IndentingNewLine]", "  ", 
        RowBox[{"Script", "[", 
         RowBox[{"printMessage", "[", "\"\<button pressed\>\"", "]"}], 
         "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"BindEvent", "[", 
       RowBox[{"\"\<mouseEntered\>\"", ",", "\[IndentingNewLine]", "  ", 
        RowBox[{"Script", "[", 
         RowBox[{
         "printMessage", "[", "\"\<mouse entered button area\>\"", "]"}], 
         "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"BindEvent", "[", 
       RowBox[{"\"\<mouseExited\>\"", ",", "\[IndentingNewLine]", "  ", 
        RowBox[{"Script", "[", 
         RowBox[{"printMessage", "[", "\"\<mouse left button area\>\"", "]"}],
          "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Script", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"printMessage", "[", "message_", "]"}], ":=", " ", 
        RowBox[{"Print", "[", "message", "]"}]}], "]"}]}], 
     "\[IndentingNewLine]", " ", "}"}]}], "]"}], "\[IndentingNewLine]", "   ",
   "]"}]], "Input",
 CellTags->"Interaction",
 CellLabel->"In[2]:=",
 CellID->394914276],

Cell[CellGroupData[{

Cell[BoxData["\<\"mouse entered button area\"\>"], "Print",
 CellTags->"Interaction",
 CellLabel->"From In[2]:=",
 CellID->321483568],

Cell[BoxData["\<\"mouse left button area\"\>"], "Print",
 CellTags->"Interaction",
 CellLabel->"From In[2]:=",
 CellID->375479],

Cell[BoxData["\<\"mouse entered button area\"\>"], "Print",
 CellTags->"Interaction",
 CellLabel->"From In[2]:=",
 CellID->318465520],

Cell[BoxData["\<\"mouse left button area\"\>"], "Print",
 CellTags->"Interaction",
 CellLabel->"From In[2]:=",
 CellID->152282955],

Cell[BoxData["\<\"mouse entered button area\"\>"], "Print",
 CellTags->"Interaction",
 CellLabel->"From In[2]:=",
 CellID->578754862],

Cell[BoxData["\<\"button pressed\"\>"], "Print",
 CellTags->"Interaction",
 CellLabel->"From In[2]:=",
 CellID->305284733],

Cell[BoxData["\<\"button pressed\"\>"], "Print",
 CellTags->"Interaction",
 CellLabel->"From In[2]:=",
 CellID->32953365],

Cell[BoxData["\<\"mouse left button area\"\>"], "Print",
 CellTags->"Interaction",
 CellLabel->"From In[2]:=",
 CellID->14531319],

Cell[BoxData["\<\"mouse entered button area\"\>"], "Print",
 CellTags->"Interaction",
 CellLabel->"From In[2]:=",
 CellID->142216023],

Cell[BoxData["\<\"mouse left button area\"\>"], "Print",
 CellTags->"Interaction",
 CellLabel->"From In[2]:=",
 CellID->60747577]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "You can create a working definition with just a button because the ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " framework has the convenient feature of automatically wrapping a \
definition with an appropriate window if the root widget of the definition is \
not already a window or frame, but is at least a widget that can be added to \
a window."
}], "Text",
 CellTags->"Interaction",
 CellID->13371243],

Cell[TextData[{
 "How can you learn the event names to use when attaching the scripts to the \
events of the button?",
 " ",
 "If you have knowledge of the underlying Java event objects that are \
provided, you can determine the proper string name following Java naming \
conventions for the widget, or, if you interact with a running instance of \
the ",
 Cell[BoxData["\"\<Button\>\""], "InlineFormula"],
 " widget, you can query its list of valid names using the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GUIInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIInformation"], "[", "\"\<\!\(\*
StyleBox[\"widgetName\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " function which works with ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " instances or within ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", "]"}]], "InlineFormula"],
 " blocks."
}], "Text",
 CellTags->"Interaction",
 CellID->344205971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", "  ", 
   RowBox[{
    StyleBox["Widget",
     CellFrame->True], "[", 
    RowBox[{"\"\<Button\>\"", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<text\>\"", "->", "\"\<execute\>\""}], "}"}], ",", " ", 
     RowBox[{"Name", " ", "->", "\"\<myButton\>\""}]}], "]"}], "  ", 
   "]"}]}]], "Input",
 CellTags->"Interaction",
 CellLabel->"In[3]:=",
 CellID->69848204],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject19342569766913, 
   JLink`Objects`JavaObject210201571491841]]], "Output",
 CellTags->"Interaction",
 CellLabel->"Out[3]=",
 CellID->799562878]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<WidgetNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", "ref", " ", "]"}]}]], "Input",
 CellTags->"Interaction",
 CellLabel->"In[4]:=",
 CellID->63427485],

Cell[BoxData[
 RowBox[{"{", "\<\"myButton\"\>", "}"}]], "Output",
 CellTags->"Interaction",
 CellLabel->"Out[4]=",
 CellID->95705989]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<EventNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", 
   RowBox[{"ref", ",", "\"\<myButton\>\""}], "]"}]}]], "Input",
 CellTags->"Interaction",
 CellLabel->"In[5]:=",
 CellID->47079406],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Action\"\>", ",", "\<\"ActionPerformed\"\>", 
   ",", "\<\"Ancestor\"\>", ",", "\<\"AncestorAdded\"\>", 
   ",", "\<\"AncestorMoved\"\>", ",", "\<\"AncestorRemoved\"\>", 
   ",", "\<\"AncestorResized\"\>", ",", "\<\"CaretPositionChanged\"\>", 
   ",", "\<\"Change\"\>", ",", "\<\"Component\"\>", 
   ",", "\<\"ComponentAdded\"\>", ",", "\<\"ComponentHidden\"\>", 
   ",", "\<\"ComponentMoved\"\>", ",", "\<\"ComponentRemoved\"\>", 
   ",", "\<\"ComponentResized\"\>", ",", "\<\"ComponentShown\"\>", 
   ",", "\<\"Container\"\>", ",", "\<\"Focus\"\>", ",", "\<\"FocusGained\"\>",
    ",", "\<\"FocusLost\"\>", ",", "\<\"Hierarchy\"\>", 
   ",", "\<\"HierarchyBounds\"\>", ",", "\<\"HierarchyChanged\"\>", 
   ",", "\<\"InputMethod\"\>", ",", "\<\"InputMethodTextChanged\"\>", 
   ",", "\<\"Item\"\>", ",", "\<\"ItemStateChanged\"\>", ",", "\<\"Key\"\>", 
   ",", "\<\"KeyPressed\"\>", ",", "\<\"KeyReleased\"\>", 
   ",", "\<\"KeyTyped\"\>", ",", "\<\"Mouse\"\>", ",", "\<\"MouseClicked\"\>",
    ",", "\<\"MouseDragged\"\>", ",", "\<\"MouseEntered\"\>", 
   ",", "\<\"MouseExited\"\>", ",", "\<\"MouseMotion\"\>", 
   ",", "\<\"MouseMoved\"\>", ",", "\<\"MousePressed\"\>", 
   ",", "\<\"MouseReleased\"\>", ",", "\<\"MouseWheel\"\>", 
   ",", "\<\"MouseWheelMoved\"\>", ",", "\<\"PropertyChange\"\>", 
   ",", "\<\"StateChanged\"\>", ",", "\<\"VetoableChange\"\>"}], 
  "}"}]], "Output",
 CellTags->"Interaction",
 CellLabel->"Out[5]=",
 CellID->326672126]
}, Open  ]],

Cell[TextData[{
 "This is just an alternate version that uses the fact that a no-argument ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GUIInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIInformation"], "[", "]"}]], 
  "InlineFormula"],
 " or one dropping the first argument ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " can be called inside a ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", "]"}]], "InlineFormula"],
 " block as well, since it inherits the contexted environment of the ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " it is running within."
}], "Text",
 CellTags->"Interaction",
 CellID->522885490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\[IndentingNewLine]", "  ", 
  RowBox[{
   StyleBox["Widget",
    CellFrame->True], "[", 
   RowBox[{"\"\<Button\>\"", ",", "\[IndentingNewLine]", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<text\>\"", "->", "\"\<execute\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Script", "[", "  ", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<EventNames\>\"", " ", "/.", " ", 
         RowBox[{"GUIInformation", "[", "\"\<myButton\>\"", "]"}]}], "]"}], 
       "]"}]}], "}"}], ",", " ", "\[IndentingNewLine]", 
    RowBox[{"Name", " ", "->", "\"\<myButton\>\""}]}], "]"}], 
  "\[IndentingNewLine]", "   ", "]"}]], "Input",
 CellTags->"Interaction",
 CellLabel->"In[6]:=",
 CellID->347805420],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Action\"\>", ",", "\<\"ActionPerformed\"\>", 
   ",", "\<\"Ancestor\"\>", ",", "\<\"AncestorAdded\"\>", 
   ",", "\<\"AncestorMoved\"\>", ",", "\<\"AncestorRemoved\"\>", 
   ",", "\<\"AncestorResized\"\>", ",", "\<\"CaretPositionChanged\"\>", 
   ",", "\<\"Change\"\>", ",", "\<\"Component\"\>", 
   ",", "\<\"ComponentAdded\"\>", ",", "\<\"ComponentHidden\"\>", 
   ",", "\<\"ComponentMoved\"\>", ",", "\<\"ComponentRemoved\"\>", 
   ",", "\<\"ComponentResized\"\>", ",", "\<\"ComponentShown\"\>", 
   ",", "\<\"Container\"\>", ",", "\<\"Focus\"\>", ",", "\<\"FocusGained\"\>",
    ",", "\<\"FocusLost\"\>", ",", "\<\"Hierarchy\"\>", 
   ",", "\<\"HierarchyBounds\"\>", ",", "\<\"HierarchyChanged\"\>", 
   ",", "\<\"InputMethod\"\>", ",", "\<\"InputMethodTextChanged\"\>", 
   ",", "\<\"Item\"\>", ",", "\<\"ItemStateChanged\"\>", ",", "\<\"Key\"\>", 
   ",", "\<\"KeyPressed\"\>", ",", "\<\"KeyReleased\"\>", 
   ",", "\<\"KeyTyped\"\>", ",", "\<\"Mouse\"\>", ",", "\<\"MouseClicked\"\>",
    ",", "\<\"MouseDragged\"\>", ",", "\<\"MouseEntered\"\>", 
   ",", "\<\"MouseExited\"\>", ",", "\<\"MouseMotion\"\>", 
   ",", "\<\"MouseMoved\"\>", ",", "\<\"MousePressed\"\>", 
   ",", "\<\"MouseReleased\"\>", ",", "\<\"MouseWheel\"\>", 
   ",", "\<\"MouseWheelMoved\"\>", ",", "\<\"PropertyChange\"\>", 
   ",", "\<\"StateChanged\"\>", ",", "\<\"VetoableChange\"\>"}], 
  "}"}]], "Print",
 CellTags->"Interaction",
 CellLabel->"From In[6]:=",
 CellID->570832308]
}, Open  ]],

Cell[TextData[{
 "If you have several different GUIs that all use the same script \
functionality, then you can place your code into a separate file and \
reference it from the ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]]],
 " definition with a ",
 Cell[BoxData[
  ButtonBox["ScriptSource",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ScriptSource"]]],
 " option. This is discussed in the tutorials on ",
 ButtonBox["Scoping",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Scoping"],
 ", and on ",
 ButtonBox["Deployment",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Deployment#374389741"],
 "."
}], "Text",
 CellID->605861084]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Scripting GUIs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 20.6774534}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "Dynamic behavior is added to a GUIKit user interface by executing \
Mathematica code. This lets one part of the definition interact with another, \
for example specifying the behavior when a button is clicked or a menu choice \
is made. GUIKit definitions call Mathematica with the Script[expr] \
expression; this can be placed in a definition as described in GUI Building \
Blocks. Script defines an initially unevaluated block of Mathematica code. \
The Script symbol has the attribute HoldAllComplete. Script[expr] blocks in \
interface definitions are typically used either by themselves in the \
interface definitions to define common Mathematica functions used throughout \
the interface or as arguments to BindEvent[\"eventName\", Script[expr]] to \
define Mathematica functions to execute when a particular interface event \
occurs. The use of Script[] in user interface definitions is in many ways \
identical to the techniques of supplementing HTML pages with JavaScript \
embedded code. This example shows both of the common cases of Script[] usage. \
There is a stand-alone Script[] block that defines the Mathematica function \
printMessage[]and Script blocks attached to events of the button to execute \
the printMessage[] function whenever the events are triggered.", 
    "synonyms" -> {}, "title" -> "Scripting GUIs", "type" -> "Tutorial", 
    "uri" -> "GUIKit/tutorial/InteractionWithMathematica"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Interaction"->{
  Cell[731, 29, 77, 2, 70, "Title",
   CellTags->"Interaction",
   CellID->399677482],
  Cell[1184, 46, 2342, 74, 70, "Text",
   CellTags->"Interaction",
   CellID->35460127],
  Cell[3529, 122, 944, 32, 70, "Text",
   CellTags->"Interaction",
   CellID->594306160],
  Cell[4476, 156, 159, 5, 70, "Input",
   CellTags->"Interaction",
   CellID->327932526],
  Cell[4638, 163, 154, 5, 70, "Text",
   CellTags->"Interaction",
   CellID->597467064],
  Cell[13149, 314, 1503, 34, 70, "Input",
   CellTags->"Interaction",
   CellID->394914276],
  Cell[14677, 352, 133, 3, 70, "Print",
   CellTags->"Interaction",
   CellID->321483568],
  Cell[14813, 357, 127, 3, 70, "Print",
   CellTags->"Interaction",
   CellID->375479],
  Cell[14943, 362, 133, 3, 70, "Print",
   CellTags->"Interaction",
   CellID->318465520],
  Cell[15079, 367, 130, 3, 70, "Print",
   CellTags->"Interaction",
   CellID->152282955],
  Cell[15212, 372, 133, 3, 70, "Print",
   CellTags->"Interaction",
   CellID->578754862],
  Cell[15348, 377, 122, 3, 70, "Print",
   CellTags->"Interaction",
   CellID->305284733],
  Cell[15473, 382, 121, 3, 70, "Print",
   CellTags->"Interaction",
   CellID->32953365],
  Cell[15597, 387, 129, 3, 70, "Print",
   CellTags->"Interaction",
   CellID->14531319],
  Cell[15729, 392, 133, 3, 70, "Print",
   CellTags->"Interaction",
   CellID->142216023],
  Cell[15865, 397, 129, 3, 70, "Print",
   CellTags->"Interaction",
   CellID->60747577],
  Cell[16021, 404, 428, 10, 70, "Text",
   CellTags->"Interaction",
   CellID->13371243],
  Cell[16452, 416, 1089, 30, 70, "Text",
   CellTags->"Interaction",
   CellID->344205971],
  Cell[17566, 450, 454, 13, 70, "Input",
   CellTags->"Interaction",
   CellID->69848204],
  Cell[18023, 465, 288, 8, 70, "Output",
   CellTags->"Interaction",
   CellID->799562878],
  Cell[18348, 478, 194, 5, 70, "Input",
   CellTags->"Interaction",
   CellID->63427485],
  Cell[18545, 485, 133, 4, 70, "Output",
   CellTags->"Interaction",
   CellID->95705989],
  Cell[18715, 494, 227, 6, 70, "Input",
   CellTags->"Interaction",
   CellID->47079406],
  Cell[18945, 502, 1501, 26, 70, "Output",
   CellTags->"Interaction",
   CellID->326672126],
  Cell[20461, 531, 889, 27, 70, "Text",
   CellTags->"Interaction",
   CellID->522885490],
  Cell[21375, 562, 757, 19, 70, "Input",
   CellTags->"Interaction",
   CellID->347805420],
  Cell[22135, 583, 1505, 26, 70, "Print",
   CellTags->"Interaction",
   CellID->570832308]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Interaction", 26963, 689}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 77, 2, 70, "Title",
 CellTags->"Interaction",
 CellID->399677482],
Cell[811, 33, 370, 11, 70, "Text",
 CellID->31373743],
Cell[1184, 46, 2342, 74, 70, "Text",
 CellTags->"Interaction",
 CellID->35460127],
Cell[3529, 122, 944, 32, 70, "Text",
 CellTags->"Interaction",
 CellID->594306160],
Cell[4476, 156, 159, 5, 70, "Input",
 CellTags->"Interaction",
 CellID->327932526],
Cell[4638, 163, 154, 5, 70, "Text",
 CellTags->"Interaction",
 CellID->597467064],
Cell[4795, 170, 8329, 140, 70, "Output",
 Evaluatable->False,
 CellID->54507667],
Cell[CellGroupData[{
Cell[13149, 314, 1503, 34, 70, "Input",
 CellTags->"Interaction",
 CellID->394914276],
Cell[CellGroupData[{
Cell[14677, 352, 133, 3, 70, "Print",
 CellTags->"Interaction",
 CellID->321483568],
Cell[14813, 357, 127, 3, 70, "Print",
 CellTags->"Interaction",
 CellID->375479],
Cell[14943, 362, 133, 3, 70, "Print",
 CellTags->"Interaction",
 CellID->318465520],
Cell[15079, 367, 130, 3, 70, "Print",
 CellTags->"Interaction",
 CellID->152282955],
Cell[15212, 372, 133, 3, 70, "Print",
 CellTags->"Interaction",
 CellID->578754862],
Cell[15348, 377, 122, 3, 70, "Print",
 CellTags->"Interaction",
 CellID->305284733],
Cell[15473, 382, 121, 3, 70, "Print",
 CellTags->"Interaction",
 CellID->32953365],
Cell[15597, 387, 129, 3, 70, "Print",
 CellTags->"Interaction",
 CellID->14531319],
Cell[15729, 392, 133, 3, 70, "Print",
 CellTags->"Interaction",
 CellID->142216023],
Cell[15865, 397, 129, 3, 70, "Print",
 CellTags->"Interaction",
 CellID->60747577]
}, Open  ]]
}, Open  ]],
Cell[16021, 404, 428, 10, 70, "Text",
 CellTags->"Interaction",
 CellID->13371243],
Cell[16452, 416, 1089, 30, 70, "Text",
 CellTags->"Interaction",
 CellID->344205971],
Cell[CellGroupData[{
Cell[17566, 450, 454, 13, 70, "Input",
 CellTags->"Interaction",
 CellID->69848204],
Cell[18023, 465, 288, 8, 70, "Output",
 CellTags->"Interaction",
 CellID->799562878]
}, Open  ]],
Cell[CellGroupData[{
Cell[18348, 478, 194, 5, 70, "Input",
 CellTags->"Interaction",
 CellID->63427485],
Cell[18545, 485, 133, 4, 70, "Output",
 CellTags->"Interaction",
 CellID->95705989]
}, Open  ]],
Cell[CellGroupData[{
Cell[18715, 494, 227, 6, 70, "Input",
 CellTags->"Interaction",
 CellID->47079406],
Cell[18945, 502, 1501, 26, 70, "Output",
 CellTags->"Interaction",
 CellID->326672126]
}, Open  ]],
Cell[20461, 531, 889, 27, 70, "Text",
 CellTags->"Interaction",
 CellID->522885490],
Cell[CellGroupData[{
Cell[21375, 562, 757, 19, 70, "Input",
 CellTags->"Interaction",
 CellID->347805420],
Cell[22135, 583, 1505, 26, 70, "Print",
 CellTags->"Interaction",
 CellID->570832308]
}, Open  ]],
Cell[23655, 612, 728, 23, 70, "Text",
 CellID->605861084]
}, Open  ]],
Cell[24398, 638, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

