(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36353,        871]
NotebookOptionsPosition[     30093,        677]
NotebookOutlinePosition[     34358,        794]
CellTagsIndexPosition[     34255,        788]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction", "Title",
 CellTags->"Introduction",
 CellID->193498214],

Cell[TextData[{
 "The Java toolkit ",
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/guide/JavaInterface"],
  FontSlant->"Italic"],
 " introduced ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users to a powerful new technology for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs to access the functionality of Java classes and, in particular, \
the extensive class library of Java graphical user interfaces. ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " builds on this ",
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/guide/JavaInterface"],
  FontSlant->"Italic"],
 " foundation by providing a higher-level ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression syntax for defining a graphical user interface along with a \
runtime environment for managing and deploying these reusable definitions."
}], "Text",
 CellTags->"Introduction",
 CellID->3463780],

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " simplifies the construction and layout of common user interface \
programming and eliminates the need to write code using the underlying Java \
programming language. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users will find that ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " allows them to quickly define interfaces as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions and to program the logic of these user interfaces with \
familiar ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programming language constructs."
}], "Text",
 CellTags->"Introduction",
 CellID->358289972],

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " also expands on the set of tools available to existing ",
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/guide/JavaInterface"],
  FontSlant->"Italic"],
 " and Java programmers by providing a reusable deployment model that easily \
integrates interface definitions into their existing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " add-ons and to develop a library of reusable ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-enhanced user interface widgets."
}], "Text",
 CellTags->"Introduction",
 CellID->367190362],

Cell[CellGroupData[{

Cell["Intended Audience", "Section",
 CellTags->"QuickTour",
 CellID->478556457],

Cell[TextData[{
 "These tutorials are intended to teach you how to use ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " to build graphical user interfaces. They will show the building blocks of \
GUI definitions, how they can be programmed or scripted by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It will show how you can build up libraries of GUI definitions, and how \
you can add user interfaces to your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications."
}], "Text",
 CellID->232733904],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " contains a number of applications that contain ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " user interfaces; for example, the ",
 ButtonBox["Database Explorer",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TheDatabaseExplorer"],
 " and ",
 ButtonBox["Equation Trekker",
  BaseStyle->"Link",
  ButtonData->"paclet:EquationTrekker/guide/EquationTrekkerPackage"],
 ". These tutorials will not describe all the uses of ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 ". If you do not want to learn how to build user interfaces with ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 ", then perhaps they are not useful. However, you might still care to look \
at some of the ",
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Examples"],
  FontSlant->"Italic"],
 ButtonBox[" Examples",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Examples"],
 StyleBox[".",
  FontSlant->"Italic"]
}], "Text",
 CellID->492996481]
}, Open  ]],

Cell[CellGroupData[{

Cell["First Steps", "Section",
 CellTags->"QuickTour",
 CellID->497865031],

Cell[TextData[{
 "One powerful feature of ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " is to make it easy for users to load and execute prepackaged custom user \
interfaces whenever they need them."
}], "Text",
 CellTags->"QuickTour",
 CellID->586946671],

Cell[TextData[{
 "Load the ",
 StyleBox["GUIKit`", "MR",
  FontVariations->{"CompatibilityType"->0}],
 " package before calling any ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " functions."
}], "Text",
 CellTags->"QuickTour",
 CellID->336917017],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"QuickTour",
 CellLabel->"In[1]:=",
 CellID->677154444],

Cell[TextData[{
 "Here you execute an existing ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " definition and, after closing the dialog, the current values of the \
calculations are returned as results back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"QuickTour",
 CellID->29450219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\"\<Wolfram/Example/Calculator\>\"", 
  "]"}]], "Input",
 CellTags->"QuickTour",
 CellLabel->"In[2]:=",
 CellID->719640683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"FirstArgumentField\"\>", "\[Rule]", "45.6`"}], ",", 
   RowBox[{"\<\"SecondArgumentField\"\>", "\[Rule]", "489"}], ",", 
   RowBox[{"\<\"SumField\"\>", "\[Rule]", "534.6`"}], ",", 
   RowBox[{"\<\"DifferenceField\"\>", "\[Rule]", 
    RowBox[{"-", "443.4`"}]}], ",", 
   RowBox[{"\<\"ProductField\"\>", "\[Rule]", "22298.4`"}], ",", 
   RowBox[{"\<\"QuotientField\"\>", "\[Rule]", "0.0932515337423313`"}]}], 
  "}"}]], "Output",
 CellTags->"QuickTour",
 CellLabel->"Out[2]=",
 CellID->455172537]
}, Open  ]],

Cell["\<\
Here is a screen shot of what the previous interface would look like on a \
typical platform.\
\>", "Text",
 CellTags->"QuickTour",
 CellID->13932343],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{270, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->677879225],

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " also provides a convenient ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression syntax for defining and executing your own simple or complex \
user interfaces."
}], "Text",
 CellTags->"QuickTour",
 CellID->256361887],

Cell["\<\
Here you create a simple resizable dialog with three very common user \
interface components.\
\>", "Text",
 CellTags->"QuickTour",
 CellID->246927443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Frame\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "->", "\"\<Label:\>\""}], "}"}]}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "->", "\"\<Input\>\""}], "}"}]}], "]"}]}],
         "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<TextArea\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "->", "\"\<Content\>\""}], "}"}]}], "]"}]}],
       " ", "}"}], ",", " ", 
     RowBox[{"Name", " ", "\[Rule]", " ", "\"\<myFrame\>\""}]}], "]"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"QuickTour",
 CellLabel->"In[3]:=",
 CellID->815325636],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject308033074757633, 
   JLink`Objects`JavaObject195727330377729]]], "Output",
 CellTags->"QuickTour",
 CellLabel->"Out[3]=",
 CellID->34318226]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"QuickTour",
 CellLabel->"In[4]:=",
 CellID->171555472],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"QuickTour",
 CellLabel->"Out[4]=",
 CellID->52864428]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 21.5680328}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "The Java toolkit J/Link introduced Mathematica users to a powerful new \
technology for Mathematica programs to access the functionality of Java \
classes and, in particular, the extensive class library of Java graphical \
user interfaces. GUIKit builds on this J/Link foundation by providing a \
higher-level Mathematica expression syntax for defining a graphical user \
interface along with a runtime environment for managing and deploying these \
reusable definitions. GUIKit simplifies the construction and layout of common \
user interface programming and eliminates the need to write code using the \
underlying Java programming language. Mathematica users will find that GUIKit \
allows them to quickly define interfaces as Mathematica expressions and to \
program the logic of these user interfaces with familiar Mathematica \
programming language constructs. GUIKit also expands on the set of tools \
available to existing J/Link and Java programmers by providing a reusable \
deployment model that easily integrates interface definitions into their \
existing Mathematica add-ons and to develop a library of reusable \
Mathematica-enhanced user interface widgets.", "synonyms" -> {}, "title" -> 
    "Introduction", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/Introduction"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Introduction"->{
  Cell[731, 29, 76, 2, 70, "Title",
   CellTags->"Introduction",
   CellID->193498214],
  Cell[810, 33, 961, 28, 70, "Text",
   CellTags->"Introduction",
   CellID->3463780],
  Cell[1774, 63, 679, 21, 70, "Text",
   CellTags->"Introduction",
   CellID->358289972],
  Cell[2456, 86, 626, 18, 70, "Text",
   CellTags->"Introduction",
   CellID->367190362]},
 "QuickTour"->{
  Cell[3107, 108, 80, 2, 70, "Section",
   CellTags->"QuickTour",
   CellID->478556457],
  Cell[4806, 165, 74, 2, 70, "Section",
   CellTags->"QuickTour",
   CellID->497865031],
  Cell[4883, 169, 259, 8, 70, "Text",
   CellTags->"QuickTour",
   CellID->586946671],
  Cell[5145, 179, 249, 10, 70, "Text",
   CellTags->"QuickTour",
   CellID->336917017],
  Cell[5397, 191, 157, 5, 70, "Input",
   CellTags->"QuickTour",
   CellID->677154444],
  Cell[5557, 198, 323, 11, 70, "Text",
   CellTags->"QuickTour",
   CellID->29450219],
  Cell[5905, 213, 167, 5, 70, "Input",
   CellTags->"QuickTour",
   CellID->719640683],
  Cell[6075, 220, 551, 13, 70, "Output",
   CellTags->"QuickTour",
   CellID->455172537],
  Cell[6641, 236, 160, 5, 70, "Text",
   CellTags->"QuickTour",
   CellID->13932343],
  Cell[20046, 465, 292, 10, 70, "Text",
   CellTags->"QuickTour",
   CellID->256361887],
  Cell[20341, 477, 161, 5, 70, "Text",
   CellTags->"QuickTour",
   CellID->246927443],
  Cell[20527, 486, 1084, 28, 70, "Input",
   CellTags->"QuickTour",
   CellID->815325636],
  Cell[21614, 516, 293, 8, 70, "Output",
   CellTags->"QuickTour",
   CellID->34318226],
  Cell[21944, 529, 135, 4, 70, "Input",
   CellTags->"QuickTour",
   CellID->171555472],
  Cell[22082, 535, 7945, 135, 70, "Output",
   Evaluatable->False,
   CellTags->"QuickTour",
   CellID->52864428]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Introduction", 32506, 725},
 {"QuickTour", 32878, 738}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 76, 2, 70, "Title",
 CellTags->"Introduction",
 CellID->193498214],
Cell[810, 33, 961, 28, 70, "Text",
 CellTags->"Introduction",
 CellID->3463780],
Cell[1774, 63, 679, 21, 70, "Text",
 CellTags->"Introduction",
 CellID->358289972],
Cell[2456, 86, 626, 18, 70, "Text",
 CellTags->"Introduction",
 CellID->367190362],
Cell[CellGroupData[{
Cell[3107, 108, 80, 2, 70, "Section",
 CellTags->"QuickTour",
 CellID->478556457],
Cell[3190, 112, 523, 14, 70, "Text",
 CellID->232733904],
Cell[3716, 128, 1053, 32, 70, "Text",
 CellID->492996481]
}, Open  ]],
Cell[CellGroupData[{
Cell[4806, 165, 74, 2, 70, "Section",
 CellTags->"QuickTour",
 CellID->497865031],
Cell[4883, 169, 259, 8, 70, "Text",
 CellTags->"QuickTour",
 CellID->586946671],
Cell[5145, 179, 249, 10, 70, "Text",
 CellTags->"QuickTour",
 CellID->336917017],
Cell[5397, 191, 157, 5, 70, "Input",
 CellTags->"QuickTour",
 CellID->677154444],
Cell[5557, 198, 323, 11, 70, "Text",
 CellTags->"QuickTour",
 CellID->29450219],
Cell[CellGroupData[{
Cell[5905, 213, 167, 5, 70, "Input",
 CellTags->"QuickTour",
 CellID->719640683],
Cell[6075, 220, 551, 13, 70, "Output",
 CellTags->"QuickTour",
 CellID->455172537]
}, Open  ]],
Cell[6641, 236, 160, 5, 70, "Text",
 CellTags->"QuickTour",
 CellID->13932343],
Cell[6804, 243, 13239, 220, 70, "Output",
 Evaluatable->False,
 CellID->677879225],
Cell[20046, 465, 292, 10, 70, "Text",
 CellTags->"QuickTour",
 CellID->256361887],
Cell[20341, 477, 161, 5, 70, "Text",
 CellTags->"QuickTour",
 CellID->246927443],
Cell[CellGroupData[{
Cell[20527, 486, 1084, 28, 70, "Input",
 CellTags->"QuickTour",
 CellID->815325636],
Cell[21614, 516, 293, 8, 70, "Output",
 CellTags->"QuickTour",
 CellID->34318226]
}, Open  ]],
Cell[CellGroupData[{
Cell[21944, 529, 135, 4, 70, "Input",
 CellTags->"QuickTour",
 CellID->171555472],
Cell[22082, 535, 7945, 135, 70, "Output",
 Evaluatable->False,
 CellTags->"QuickTour",
 CellID->52864428]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[30066, 675, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

