(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    174487,       3675]
NotebookOptionsPosition[    158902,       3145]
NotebookOutlinePosition[    167340,       3404]
CellTagsIndexPosition[    167261,       3399]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Layout Samples", "Title",
 CellTags->"LayoutExamples",
 CellID->52635598],

Cell["\<\
It is perhaps easiest to see when to use certain layout elements by visually \
illustrating how they each combine to create a resizable dialog. Here are a \
number of further examples that combine some of the previous layout features \
and common interface layout design patterns.\
\>", "Text",
 CellTags->"LayoutExamples",
 CellID->285217236],

Cell[CellGroupData[{

Cell["Tabbed Pane Samples", "Section",
 CellTags->"LayoutExamples",
 CellID->199898174],

Cell["\<\
Here is an example that generates content within a set of tabbed panes.\
\>", "Text",
 CellTags->"LayoutExamples",
 CellID->66782214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"WidgetGroup", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Button\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}]}], 
            "]"}], ",", " ", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<TextField\>\"", ",", " ", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<someA\>\""}], "}"}]}], 
            "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Button\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<Button B\>\""}], "}"}]}], 
            "]"}], ",", " ", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<TextField\>\"", ",", " ", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "->", "\"\<someB\>\""}], "}"}]}], 
            "]"}]}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", " ", 
       RowBox[{"Name", "->", "\"\<myTabPane\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"WidgetLayout", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Grouping\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Tabs", ",", " ", "Bottom", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<One\>\"", ",", "\"\<Two\>\""}], "}"}]}], "}"}]}], 
         "}"}]}]}], "]"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[6]:=",
 CellID->612126701],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject195364086874113, 
   JLink`Objects`JavaObject305969695293441]]], "Output",
 CellTags->"LayoutExamples",
 CellLabel->"Out[6]=",
 CellID->26681991]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[7]:=",
 CellID->518633173],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutExamples",
 CellLabel->"Out[7]=",
 CellID->160719166]
}, Open  ]],

Cell[TextData[{
 "Each element of the tabbed ",
 Cell[BoxData[
  ButtonBox["WidgetGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetGroup"]], "InlineFormula"],
 " can be a list of widgets to populate one tab panel or a single widget \
whose contents will be placed within one pane."
}], "Text",
 CellTags->"LayoutExamples",
 CellID->31592730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"WidgetGroup", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Widget", "[", "\"\<Wolfram/Example/PrimeFinder\>\"", "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{
         "Widget", "[", "\"\<Wolfram/Example/CellularGroup\>\"", "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", " ", 
       RowBox[{"Name", "->", "\"\<myTabPane\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"WidgetLayout", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Grouping\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Tabs", ",", " ", "Top", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<One\>\"", ",", "\"\<Two\>\""}], "}"}]}], "}"}]}], 
         "}"}]}]}], "]"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[8]:=",
 CellID->257642540],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject107842149285889, 
   JLink`Objects`JavaObject54918253641729]]], "Output",
 CellTags->"LayoutExamples",
 CellLabel->"Out[8]=",
 CellID->25280119]
}, Open  ]],

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[9]:=",
 CellID->1078586]
}, Open  ]],

Cell[CellGroupData[{

Cell["Split Pane Samples", "Section",
 CellTags->"LayoutExamples",
 CellID->283150106],

Cell["\<\
Here is an example that uses a split pane and shows how you can optionally \
name the split pane so it can be manipulated using its properties at runtime.\
\
\>", "Text",
 CellTags->"LayoutExamples",
 CellID->969986490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"WidgetGroup", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "->", "\"\<Button B\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetGroup", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Widget", "[", 
              RowBox[{"\"\<Button\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}]}], 
              "]"}], ",", " ", 
             RowBox[{"Widget", "[", 
              RowBox[{"\"\<TextField\>\"", ",", " ", 
               RowBox[{"{", 
                RowBox[{"\"\<text\>\"", "->", "\"\<some\>\""}], "}"}]}], 
              "]"}]}], "}"}], ",", 
           RowBox[{"WidgetLayout", "\[Rule]", "Column"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", " ", 
       RowBox[{"WidgetLayout", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Grouping\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Split", ",", " ", "Vertical"}], "}"}]}], "}"}]}], ",", 
       " ", 
       RowBox[{"Name", "->", "\"\<mySplitPane\>\""}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[6]:=",
 CellID->53429594],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject95133710155777, 
   JLink`Objects`JavaObject305969695293441]]], "Output",
 CellTags->"LayoutExamples",
 CellLabel->"Out[6]=",
 CellID->44052295]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[7]:=",
 CellID->122979141],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutExamples",
 CellLabel->"Out[7]=",
 CellID->853017038]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"PropertyValue", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<mySplitPane\>\"", ",", " ", "\"\<dividerLocation\>\""}], 
    "}"}], "]"}]}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[8]:=",
 CellID->608006929],

Cell[BoxData["24"], "Output",
 CellTags->"LayoutExamples",
 CellLabel->"Out[8]=",
 CellID->67149394]
}, Open  ]],

Cell["\<\
If you resize the panel a little larger, you can see that you can \
programmatically move the divider position.\
\>", "Text",
 CellTags->"LayoutExamples",
 CellID->3863624],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<mySplitPane\>\"", ",", " ", "\"\<dividerLocation\>\""}], 
     "}"}], ",", " ", "50"}], "]"}]}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[9]:=",
 CellID->10416097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[10]:=",
 CellID->510146123],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutExamples",
 CellLabel->"Out[10]=",
 CellID->2371630]
}, Open  ]],

Cell["\<\
You can also use a method with percentage value instead of using the integer \
property value.\
\>", "Text",
 CellTags->"LayoutExamples",
 CellID->26811474],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<mySplitPane\>\"", ",", " ", "\"\<setDividerLocation\>\""}], 
     "}"}], ",", " ", "0.50"}], "]"}]}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[11]:=",
 CellID->458425160]
}, Open  ]],

Cell[CellGroupData[{

Cell["Layout Sample 1", "Section",
 CellTags->"LayoutExamples",
 CellID->357909852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<File\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Select\>\""}], "}"}]}], 
          "]"}]}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Label\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Display File\>\""}], 
          "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<TextArea\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<File contents here.\>\""}], 
          "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], "]"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[12]:=",
 CellID->570103228],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject63875626041345, 
   JLink`Objects`JavaObject238612595605505]]], "Output",
 CellTags->"LayoutExamples",
 CellLabel->"Out[12]=",
 CellID->424937204]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[13]:=",
 CellID->226002130],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{184, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutExamples",
 CellLabel->"Out[13]=",
 CellID->4726152]
}, Open  ]],

Cell["After resizing:", "Text",
 CellTags->"LayoutExamples",
 CellID->92833581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[14]:=",
 CellID->18563110],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{198, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutExamples",
 CellLabel->"Out[14]=",
 CellID->265840096]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Layout Sample 2", "Section",
 CellTags->"LayoutExamples",
 CellID->33583277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"WidgetGroup", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Inputs\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetGroup", "[", 
          RowBox[{
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Widget", "[", 
                RowBox[{"\"\<Label\>\"", ",", 
                 RowBox[{"{", 
                  RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<A\>\""}], "}"}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Widget", "[", 
                RowBox[{"\"\<TextField\>\"", ",", 
                 RowBox[{"{", 
                  RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Widget", "[", 
                RowBox[{"\"\<Label\>\"", ",", 
                 RowBox[{"{", 
                  RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<ft\>\""}], "}"}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"WidgetSpace", "[", "5", "]"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Widget", "[", 
                RowBox[{"\"\<Label\>\"", ",", 
                 RowBox[{"{", 
                  RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<BB\>\""}], "}"}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Widget", "[", 
                RowBox[{"\"\<TextField\>\"", ",", 
                 RowBox[{"{", 
                  RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Widget", "[", 
                RowBox[{"\"\<Label\>\"", ",", 
                 RowBox[{"{", 
                  RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<in\>\""}], "}"}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Widget", "[", 
                RowBox[{"\"\<CheckBox\>\"", ",", 
                 RowBox[{"{", 
                  RowBox[{"\"\<label\>\"", "\[Rule]", "\"\<round\>\""}], 
                  "}"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Widget", "[", 
                RowBox[{"\"\<Label\>\"", ",", 
                 RowBox[{"{", 
                  RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<CCC\>\""}], "}"}]}],
                 "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Widget", "[", 
                RowBox[{"\"\<TextField\>\"", ",", 
                 RowBox[{"{", 
                  RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"Widget", "[", 
                RowBox[{"\"\<Label\>\"", ",", 
                 RowBox[{"{", 
                  RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<m\>\""}], "}"}]}], 
                "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"WidgetGroup", "[", 
                RowBox[{
                 RowBox[{"{", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"Widget", "[", 
                    RowBox[{"\"\<Label\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "\[Rule]", "\"\< OR \>\""}], 
                    "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"Widget", "[", 
                    RowBox[{"\"\<TextField\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"Widget", "[", 
                    RowBox[{"\"\<Label\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<km\>\""}], 
                    "}"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                 "           ", 
                 RowBox[{"WidgetLayout", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"\"\<Grouping\>\"", "\[Rule]", "Row"}], ",", 
                    RowBox[{"\"\<Border\>\"", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", "3"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"5", ",", "5"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", "5"}], "}"}]}], "}"}]}], "}"}]}]}], 
                   "}"}]}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], 
            "\[IndentingNewLine]", "}"}], ",", 
           RowBox[{"WidgetLayout", "\[Rule]", "Grid"}]}], "]"}]}], "}"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"WidgetLayout", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Border\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"RGBColor", "[", 
               RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", "3"}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"5", ",", "5"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"5", ",", "5"}], "}"}]}], "}"}]}], "}"}]}], "}"}]}]}], 
      "]"}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[15]:=",
 CellID->210530786],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject31575005724673, 
   JLink`Objects`JavaObject463836251422721]]], "Output",
 CellTags->"LayoutExamples",
 CellLabel->"Out[15]=",
 CellID->41535235]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[16]:=",
 CellID->1636904],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutExamples",
 CellLabel->"Out[16]=",
 CellID->14984543]
}, Open  ]],

Cell["After resizing:", "Text",
 CellTags->"LayoutExamples",
 CellID->241656631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[18]:=",
 CellID->17514448],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{366, 200},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutExamples",
 CellLabel->"Out[18]=",
 CellID->151615202]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Layout Sample 3", "Section",
 CellTags->"LayoutExamples",
 CellID->17882252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"WidgetGroup", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"WidgetGroup", "[", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"WidgetGroup", "[", 
               RowBox[{
                RowBox[{"{", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Widget", "[", 
                    RowBox[{"\"\<Label\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<A\>\""}], "}"}], 
                    ",", "\[IndentingNewLine]", "    ", 
                    RowBox[{"WidgetLayout", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Alignment\>\"", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"Right", ",", "Automatic"}], "}"}]}], "}"}]}]}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Widget", "[", 
                    RowBox[{"\"\< TextField\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Widget", "[", 
                    RowBox[{"\"\<Label\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<ft\>\""}], 
                    "}"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Widget", "[", 
                    RowBox[{"\"\<Label\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<BB\>\""}], "}"}], 
                    ",", "\[IndentingNewLine]", "    ", 
                    RowBox[{"WidgetLayout", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Alignment\>\"", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"Right", ",", "Automatic"}], "}"}]}], "}"}]}]}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Widget", "[", 
                    RowBox[{"\"\< TextField\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Widget", "[", 
                    RowBox[{"\"\<Label\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<in\>\""}], 
                    "}"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Widget", "[", 
                    RowBox[{"\"\<Label\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<CCC\>\""}], "}"}],
                     ",", "\[IndentingNewLine]", "    ", 
                    RowBox[{"WidgetLayout", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Alignment\>\"", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"Right", ",", "Automatic"}], "}"}]}], "}"}]}]}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Widget", "[", 
                    RowBox[{"\"\< TextField\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Widget", "[", 
                    RowBox[{"\"\<Label\>\"", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<m\>\""}], "}"}]}],
                     "]"}]}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
                RowBox[{"WidgetLayout", "\[Rule]", 
                 RowBox[{"{", "\[IndentingNewLine]", "       ", 
                  RowBox[{
                   RowBox[{"\"\<Grouping\>\"", "\[Rule]", "Grid"}], ",", 
                   "\[IndentingNewLine]", "       ", 
                   RowBox[{"\"\<Border\>\"", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", "3"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"5", ",", "5"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", "5"}], "}"}]}], "}"}]}], "}"}]}]}], 
                  "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"WidgetFill", "[", "]"}]}], "}"}], ",", 
            "\[IndentingNewLine]", "        ", 
            RowBox[{"WidgetLayout", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<Border\>\"", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "1", ",", "0"}], "]"}], ",", "3"}], 
                  "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"5", ",", "5"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"5", ",", "5"}], "}"}]}], "}"}]}], "}"}]}], 
              "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"WidgetSpace", "[", "5", "]"}], ",", "\[IndentingNewLine]", 
          
          RowBox[{"{", 
           RowBox[{
            RowBox[{"WidgetFill", "[", "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Widget", "[", 
             RowBox[{"\"\<Button\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<foo\>\""}], "}"}]}], 
             "]"}]}], "}"}]}], "}"}], ",", 
        RowBox[{"WidgetLayout", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<Grouping\>\"", "\[Rule]", "Row"}], ",", 
           RowBox[{"\"\<Border\>\"", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", "3"}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"5", ",", "5"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"5", ",", "5"}], "}"}]}], "}"}]}], "}"}]}]}], 
          "}"}]}]}], "]"}], "\[IndentingNewLine]", "}"}]}], "]"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[19]:=",
 CellID->30464223],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject64448484081665, 
   JLink`Objects`JavaObject289294031781889]]], "Output",
 CellTags->"LayoutExamples",
 CellLabel->"Out[19]=",
 CellID->368641675]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[20]:=",
 CellID->320550770],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{237, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutExamples",
 CellLabel->"Out[20]=",
 CellID->4045776]
}, Open  ]],

Cell["After resizing:", "Text",
 CellTags->"LayoutExamples",
 CellID->495000385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[21]:=",
 CellID->991224489],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{312, 251},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutExamples",
 CellLabel->"Out[21]=",
 CellID->235877604]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Layout Sample 4", "Section",
 CellTags->"LayoutExamples",
 CellID->304228728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Label\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<These are inputs\>\""}], 
          "}"}], ",", "\[IndentingNewLine]", "   ", 
         RowBox[{"WidgetLayout", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Alignment\>\"", "\[Rule]", "Center"}], "}"}]}], ",", 
         RowBox[{"Name", "\[Rule]", "\"\<mainLabel\>\""}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<BB\>\""}], "}"}]}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<in\>\""}], "}"}]}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<CheckBox\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<label\>\"", "\[Rule]", "\"\<round\>\""}], "}"}]}], 
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<CCC\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<m\>\""}], "}"}]}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\< OR \>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<km\>\""}], "}"}]}], 
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"WidgetFill", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetAlign", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<mainLabel\>\"", ",", "After"}], "}"}], ",", 
           "Before"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Submit\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetFill", "[", "]"}]}], "}"}]}], "\[IndentingNewLine]", 
      "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[22]:=",
 CellID->57833530],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject114503928774657, 
   JLink`Objects`JavaObject12571235057665]]], "Output",
 CellTags->"LayoutExamples",
 CellLabel->"Out[22]=",
 CellID->281700919]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[23]:=",
 CellID->372618146],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{268, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutExamples",
 CellLabel->"Out[23]=",
 CellID->29112492]
}, Open  ]],

Cell["After resizing:", "Text",
 CellTags->"LayoutExamples",
 CellID->123669284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[24]:=",
 CellID->319384556],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXAl4VEW2vuklCwKyKAOCLLKKAQl7gLAIJCELEEiACIQESAgQQAKKIIgL
DOP2BgYdno7OwNPnjPs4ozIg4u44ig9EWYSErJ3ubIQsvSQs/zun6vaSzs1C
AAcd+/vq3qq6VafO+c+pU6fq3q+jk9amJq9IWrt0UVL3sPSke1KXLlrTPXRV
OlXpfRTFZ66iKH/urnAelHVe9FBuehZK+yc5KeBrvMgqigFKhzehdN2tpj3t
OBPAubaco8utosiXW3f784MAZ90ef+eDPQFqY9FNLfpzrp2LVEDt3G2uvoJK
T65jdgQbL3IJSuc/+Kh8GqF0Ogz/oB/QKuwU2sRmocWUH5QAGCacpO5jM2+B
EpJB1MZmUDEksx0XRU7U8SWzrbNJpr8rF8A5fuB6GuJ+KovuB7WajK3dOMSD
FEsRkgFlxBEogQdYmrpStJthQodlZ+Efl0lS+E0rIq2El0fwhdXF3QccZJwV
H7em1L5qP6Ck8GQsX7hHeLns9XPp0fXn2sNvcAM9xjJWe34SPa5PdJuhj6CT
jfSog9V12aNBycdmXu4c/An18Gushwa6P70e2rb7k+sRkvmf3OPybPd66HFU
NPZFadEplJVmobLcDJu1FHZbGRy2c53hsJ/rhJoam55z1N9hr0C1o4Lu5dTh
zPgmuDqvwQwoKviec9j07GvoPWdLMJQxa6n6V9EPIu3J/4W1qpjGP9ss0qac
w1iybTciVu/Ei2++MwLHj3xO4h078hmOHf4Ub+99D+Ert2P5Ey/yMM0Ywhd5
Zw4JVj/851fIzTqO7DPfI+fMsWFcoMeURVbGUZw+8Q3e++AD0bSyvKDxofy9
h9LTUF8zNigpLlB0KC42UV1JsYnLom6IuPryExRacpCfewrZmd+LPuVnc69o
zHPnipVguhZRWFt21oIiQf8H+exsjtIM4gYX8fLyEk4jxShEv6wQxUV5MOWe
VulnXxn9iopSTq14EANvk/Sc04kNk1GMzjsnj7sinulE1uB6qDbwrlbvoosY
gmiSIKSMfBTkZVwtEc5yakn0S5mGGLNUlHRedYrKY6kUUO+sdD/Qaqz4exL1
fO68txbNWLYSYXYFeZnasol1+zJkq6w8y6kt60hljTUmmW9anU7U+bvq1Hrv
e2vRTKq8tMQEc/5VEqGqqozTjSyHajuUU/zE4Kp8IjnLUhBuo69VJ/v51+rn
8dx5by2aGYVcZ0sLYDGduVqCnOPUiuiXCUEMnCOnIgcvcyW17BK2jPe7ahvV
2EStNEJfzz6e99ZqV7bvs6VmEiTr6ghitZZzasnSqBirslEjvvp71onkLKt3
VbTa/RWNOklTzH7OGoVs7CQLC7KvjjA2WwUJU9GSJVIHVuUjZurWGTXqWmnU
tVRbsxDnyOkWmevj9zK9lc1WyakVMy6Q8eecOjoLw6UbvOoUYQ5cJ/hH+bki
FNMyc5U4quI0ktkS9CuIfjHRz70S+u710eGw0/rocNiIuN1upTX+LEVRBVeH
eE1NDRGvqakm4jU1DopVKoho0ZUQNyI3UxK/ePGCSBcuXFBG0vU8dTl/vgY2
GoSfUxzYbOYpnMOH/5ehjMKlS5eo6aVLF6l8WtRTjNlsjT7wzF8Qt+l/8NHh
zGDQj6qPZVlE1QO/f5Xs+FizSJuyD6Mg91tB3isSXfKb3bDkf8epWWgQS4I8
oa50RU7GV52QefxTPeeoE+uC5eIWl8t8Pfu0f3OPjtx4Mza/sK8P537NuTaX
TYAaUz+oP+UBcZV1vGPgFr002j2i0a71L4P/MnhDg+u4sV6GPHVzxnpZM3oO
KZKMEaRL4cXNoz7ARVDv5M3dQO1Uu05r4EcaHdhNw13n782MvLuxcULjW2f6
qx302kI1WK0t4RXC6K9C41ldu4v2M/96wfTTGr4xNryH0rIz51sg9wmvjIfr
YmPQqPO7Onj5aZD2Vo9Sj8p8f8GsQcy0Jq0WCxIzgzcLugZm0L8TK21GpTty
bfCcGDQVK4N78jbToCQXAVpc/OgQNcX+tedS4zjVbde8hcBYFyHXM9/a9lb/
QnDyx1wIai/hbbykqCvh1V9CWzpp1Bs2eLxAbW7YUFvMtq4eAixjw/OkCWw3
9jb6moZavwzuFWSe/GXwRjeEjRG4Gl9caL/Huy57aO6lDzQBsMs29P3XJVG9
emVH7qy7V2OgfnxthS4xD239UYekGITGRHk5H4fzcWoV7HYbqqsd4vSMT9T4
zMtJk9s6+z96OWZvdAWCItfysvhuOELRWpe7imsLwW9ZWUlj8uk0xKt3WXav
bzp3lOPJkXag4GLVWa8kewPo8U5bO9jzDqjqC7ICfhR4W0m8SgqbArEYkNqr
/GqHQvVuTLTgq/eIQDRO+VmAa7GYmgxwc8Btbh2XFv8sEDaZcpuM8vWEcJ1P
7q7Iw/rWh6HOvYGvH8Pc3DNNxtGFoQdlPy00vZAxeNZpMdXQ9M/U2Ej7/SjG
6d+Qcbq47eEBZnb26SYD6jZIDRz0bpT8GwLYxYXHmtbQQvXvA1MrfpGgnTnz
Q5OBY9C6NjrbtD92vDqzTXvj28dDnoyME02WqfnyNLKpao4imPGmMs+M14p2
6/lm+5ox2RRGf3wm6+4CruWQ+6+fgfwuf4/f+P7Mm2gTN6CNf8v+H9DjAw2v
srNRAh7b0yYRaOhrernHbFq05SrpXaufO+frXtvq7NfqnnM2Fn40umK6gxtB
rM5W+WrJfKURpvYmV0ue+nnSWuubFbN5vJVpTM8PXUtA/b2YV+tldVNi1Ybf
llypHr2NlEsPN4pHwNBTzcXD4FKd2+iNruliqM9cjK65dRWFd8+4LZcvssFb
ZM3dzdWZU75a8HqN2dB8qmfuNGlK1f9+V3vERy4fyobF0/LAXr5YXx/zbq9p
1JC4NoCNgqQmtwU30R03cbZM0FD/tssh/rBronjNoEANym2bNZqfe7S6EcDo
U1B6vHL997jlMNVmyxSZTRYw8TA19pl4GD6TjnCinaRu8hE9Z3Vcr+jlE25B
pSQuJXC3RC53VQkIegMJtcEf82g3/07hjwC8RiNcD3F7MYxODqNEkCX5RGcw
jenUIjqP7rm8dNKV6mbmcM5Zmp77ITdZACU0m8tMMzJPlHyddROJi/EicSlE
XMeeknWyNL5W3dhTPNqoH3hvP/Ik56AMOynzfGfeRxaxZAzjE2I6uQSLLJYs
x+YxkTkFDPEcqptXAiXxLJQFFXrok8sN0KdW0aD61Br4LBOJWvKVGEm+CJ/F
1ZwUEiyxmtBNvCByDOG8ai7Ke7wDyt1WGqESymybGNHOI862QYmrghJTxXcd
ZwycY05jzkGJKpN32Yb7RVUSXmFlPiyaj6dsfrVlm0MyzK1w3qmnPpE/Gtcn
2VgilodKvsuq6ZJ2wQ/65edJr8suJfKTXSwaPTamnEfKH6xi03GjuvUwlV4U
dfSM2amnnZ9s92wljEl2BkTAYEywI+X3lUob0cYfppILSNlZDuO0ChaM5SJb
KPLWmlOy3FqS+SRaWRo2x+RqVUMkD4tDdX6rLurhl37RAN/Vl+hhOuiyEnaW
UbkZS/5ow5FT5eg361O0Gvce2k76AO0mv4+bJu9Du0n70H7yAbQP/QBtJh9E
q8kfocXkj+E/6VP4TvgI+nEfwWfcp8TQQXSbug+HT5YyPUXgpwRdddqMLJsa
G1PKs1acPX4E707qh5fvaIXXB7XFa0Ht8Mrgm/DKoHZ4fXB7vEHpzaA2eHtQ
K/xtYAu8M8Afb/f3xdv99Hinrw/e7KXg9THdUPT9YYG+MD4n+hJ5xQm9wRt6
HeNO1dKOaiTqaRcE4DoG3Bd+ay/pXKgvZNR3qaibzl5Ev4QstJ+Whc5xWehx
dy56z8tBn/nZ6EX3ngm56EGpK6XOC0zokGBC+/kFaD3XhIA5BTDEFsBnKvEy
+TtC5x/CipyoXwPaLtTZlr+Z0g+HRrbHobGdcXhSDxwO602pDw6H9sKRsJ74
NrQHjk7uimOTO+PYXR1wfHx7HAtpjePBATg2zIBvB/ngk/4KXiPkBe0GUK9r
8KqxC1Nvjbi4OAGugcG1qeDyr/X0UnSZW4Z+i87hztRzGLK8HEPTyhGUVoGg
FRUYuKoC/e+pQO97KtFtVSU6rahC+2VVaJVSBb/ESujuJl8TTcOO2ucB7rWi
TdCqtE+OaI3TE7sgM6ofzsy4E1lxQ5A9eyiy44KQPSsIObMGIjeuP/Jn9kb+
9G4wRXWCKbw9TBNbIX+sH7JH6vDtnQpe7ak4aUdVsoeuDa5Y3Gix6Ha0tjdZ
IL0JgYs/7dnti/z8fOqce+o0zBYLJzL44uJiutJjxhw+aZc4fcT4BAsvKAW5
aVYlei+sQtDyKgSvrkLIWislG0bfa0XwfVaMWGfF4PttCLzfjt7r7Oh2nx2d
0u1ou9KBG1LtMCZWQTeTLDHkoFMQoh10LWi7Fif+ZY65CdmRvZETG4S8ucHI
TwhB/gJKCaNhSgimNAIF8wfDPDcQltm9URjbDYXTO6Ewoi0sk25AfogRx4fo
8FYfH0nb25sHfeFSQACUnsfVhcosF90FLncuEF66dClJTlrQCfBb4PTp0/j8
iSfFnRQh1MJ5vnOZO5EmdLwwC8gO8qIcLCzMKBjqGF+JgbTujSLg7lpnpSnG
XAag/0YHem1w4NZ1Dty8xoHWaQ4ELKqCcZYZunEfeliqNp0bRIsuWv1cKz//
zozviJyYgcibNwr5C++C9eN3RX1B8kRKE1CwOATmhSNhSRyMwnn9URTfSzy3
/2MPCsNbwzQ+ACeGG/HXvuJFvY7RZQOfYJH4Bn7pwtfgxpfRjynWMcAcDRLE
jBSbt4CXuGcUKYd/pS5B4dwY7N+/X6JN94+f3iEQrqys5H5ypdUxsg4R40hE
us6vxPCVhAaZ4JQH3MgO2ERmSMh2JWR/Rci2XWEXvuCGeLNY6pzIVhN6GnRE
XcSDdoQ/aMPkzTZMeIhMne7DNttr0eafBm0Za1HcxL8scsy5c4YL5E1Lpsjz
WiMKUifDvGQCzItHw7JwGIoSBqhnuS2EZRdMaoUTo2/A23f4SpJOi2bU2YGI
GEWAblS9CoOeT+MWcSSpSORbCtTXrFkj0GS0342MxpF/foET8bORuzQGWavn
4+tld+Pjnj3xzt//LpVjwNM7d8qFVqaFrMFdHEiq0PdeWImQNVUIJ7imPmRz
Q7/Rjj7rHehOXqDTGjs6rLKj/dIqtJlvQYtJLqMmOjdr0RF1Ux+2IZLyYQT5
XZTGUBrO0HvQ5l89tOPKFYkZe5U88iamJeEoSJuKghXTncfl5tS7YE4eQ9AP
V2H3FU7FEtUB+WHtcXIcBTEDWqj2PsEidiu5crfSf6+nP2HoeecnoDe5A3ny
Kwz9J598ohp8K3wxdx729++DqnmhKImZCPPLadibGIJdfW4VeO/Y/lvs37xO
3Bl3DncEVh9y1BnMZqWidgcZ3KT7CTFCZsYjNsx81IYYukc/TEZLdRMphZDx
Dttow4ANhBoh1mOtHZ1X29FxJSVaHDssMOPGMNdkINpdNWnzrym0hYuqS5v1
ITYS/MuZdgfyF01CwfKpMK+aQWkmClbGSA20IY2EwPm7ZC2HJbYHLNM7wxzd
EfkRHXGCgpu/Bd0oyfJEGJ/j3kT23+vUyq+gdP9S7sVYKzGmWtsr1sqhrw8h
88D7+P7AAXwxLQx5i0JgfWk5Cp5OQsnCETg9MhD/CuqL/eHDcC42AqeOH8cf
d/9JbGR0rIxqXr1VZQymRTFykxWxpIRZW+yIe9QugIsmEw7fRCZMQI3ZYMNQ
WiAH3GdDH5oWPUgRXVbZ0GUFJQKsS1IB2oW7TLhe2vxrCm3+1UM7ppjiEP7l
xg6GaWkkzPfEwrx6Fiz3xAmlFKRFizlOFmuO6wPzjB4omNoFBdFdkBfVBcdD
u+CvQ9pJJfCcYAXwnpc9v5wbIpLsUFcL7JpUTbAWNsyNR04wxc8Th6N43lRU
PJuM6q+2oOL1e5G/KRbfxIyB6Y9rUbJhBp5//DEc+uwzPP/C87SfnF/CE5IV
yuTmFCuJfN3FI6jAjSB3HkN+ZPZWO+J/bRf3GVSOJssNe4Bc+npy6RS1DKVI
JjCdgCNl3EaAdV1uQ7dlNvRYVokeCwvQYYorGiLa3TVpC6U0gTb/NGizSgQ+
/MuLHwHzihhY0mfDsiaeFDObZggpZVk0+bEwOVNoTZ4dCNPMPjBNvw2m6K6U
uiF3ag8cn9IDbw3rIMmyW3IeTNx+BEqf15266URR/gEow4/K0ww+K6F9iBJP
U2peodCNM8QpXbsIJY/Pg3XHXKGXo9tXYG/KTPxzSSTs++6D5ZFp2PPYNrz0
0ktYv2E9q8apGFZRvMXmoZQx6VWI32bD/MftmP+YBG8mATeVgdtgxQRyO6MI
tKHpBNwqK/qmWdGTAOu+lABMtaL3UorxCbhOkZ5K0abNv6bQ5l89tKPz1JmS
N59WirXxsKybD8t982FOj0cBuS7T8qnOmZIf0xf503rSDOmOvOjbyNP1xrGI
3nhrRCepDOfJEGPOypAzpfUm0kbH2tqIyFBni0loxLmAi+Bz33s4sWUGhWjB
QgNfpsXh8y3rsHfuOGIsHJl3j4JpWH9k//dzPFNUbRTqmJA4amJtmFTEQtdb
kfikHQufciDxCTvmbrMj9hE7ppJPCSN/MoHQGrWaECNzH7Dcin5Lrei1xIrb
Uggtut+eWoHbF+Wjc+QHLm2Y1EXEmzb/mkKbfxq05YFdZLbIm5JDYdmQCMvG
hfK+di7MK2OdiwiHuZ6/3OheyI28je69kT39dnwfdTveDO5cWyusEfZWYooI
pfjXVUpsnqdSdGJf1hKnB/bFP4YH4tDgAfgyaqTwWLxuPNGlg9DHydmheO+F
Z1GQnYW/7Nqpd+nC7qWL1N85sGynA8m/dSCBLHg2rSPTyXojyJ1MpI1WCOHF
UeqdhNcdhFc/wqkv6aI/WW8gWW//hfnoEuWpC6MWbXXf0EqrnzyX9MC58OFU
FD26DIUPJpP1J7g+N8hPmoj8+SHIm+OMn24g/9MXudPJ+GIC8V10f7wR3MUN
stPsJcgu0+8gUR7xNS0jRyXKfHjLKN9tFqYfFxcHyysvCvP/bE26WBTY8fBC
4TT5l4cFIvOdd4XTUpdqjpvMAuYPmVwwTykVa3bTK3c5cM+zEpOFTzowlzxR
7EN2RJP7Dltnw3jyEqPISwxdUYVBtAYPoDAzkDAfQGkgYRa4yIRbow641lQn
1l60VaxbavWrhTW79+JtK1H8+D2Mt3OXYEqNRv7iMNoPj6e98SjkzhqqOJ/l
zhiArBkDCepAvDHqVicrw4+y3w38UkLd62XFw6A7vsa7YSjjGOqT8uycjVpC
7TRo3nN9++abKJ09DZVbFqHy/ggURwzG8QfuR0ZqEt4YOhLnz59HtdVaG2mH
h0FzkLL+Tw5s3OPAagJjyQ7pCOK3SpfPQIfSGjlhDQNdhZFk2EPTqjA4TZ4y
DFpajkAyTA+QXQbtRdu1EdboVwtkDm5KdqxHyc6NBPRq2A99IuvJnZtXzFTR
DiW0Jwi08+JHiueV77+B3LggZM0chO+mutCuA7aHXQc0BjYvluIvbyqJ/a+n
hKKqUO52qz4/iPzAviLPCJfQno2PgxhxuRPWgnvOr2147NVqPPVGNTa/KCFn
2178X3YkPC5X2liCLYbixsiNVkRQ4iB/HPmVUekMPfmBpDx0DH/fA+7Aa0G7
lkosa+fg7AuPoWzPUyh9ZrNQi/A3mxbDcn8CzBwCrYqlrVsMqSeSUoTYQOQn
jhOOPnvWUByN6o/Xh3dsokoGfyzfKIWdIFdzisDMopQvVMIHPlIlRuFunCrg
VBgVTrWkBKLObVmNlHisOQWJjFYCqzeY/Zeqk+Ttdux6pxrP7a0R+G3Y7UD6
cw6seMYh/HHyb2l9JAyTnrKLqIWjlxkU50eRD5lIU2PEygr0W5CHm0Ndp5ZE
O/Ba0JbWqeqkcHMyzr2yC+WvPyd0U7JjA4qfSEfR1hViPbDQWlBIa2/hA0ky
IlrL0dAMmJZFkW4mIodC2KMR/fDqkJtVnYz4uh6fZKilE93kIyzjKW5MamGY
KaxU+B+uKvWsBcoWfvapmApSE/Xo46C3Ku573oHtb1Xj6b9VY+ufHbiXyuym
U39nR8p2CdUCClcS2EP9hrZaW22YTiY9ZaM048HLK9BzXh4GzfscppLzqiqu
Ge3p2cotgnbJU/eh7MXtOPfy0zj73FYUP3UvimiZKCI1FG5OEWqwrF9AKQGW
e2mqpM+i3cJ0miZTxBTJjhuMI6E98V7kIJiKauRCy06JdXHbPtaFhyp6vSxV
MeEr+ETVUgXPECXBzLwtLPSFT3KxyPHryCTa0yUU8lNOepd3WuA1JwKQsrMQ
GaaLWEN2yrFh3Ba5ZQqn6JxP3shn0ABj11h1GL2aLkPSqhRfDKIdbL/FVeg2
vwxDl2Tj6OkKpqS7AqJt6yOqvjXORsoOM2pyMsjs15CZJ9IuLE7uwFLCKfS5
i10Qn+osGKsjLzRaR+vyEGI1l9aH7Oh+yJjcDUdmDkXZyaNI2ZalE0fQeomt
BN05AXTi9YDBCbn0SDNPsY/P4h4M6sJCJ9TJxdRySamOc3zqR0/c8BdyoC9X
B5t4qayH8W4TUn5fDFPpefW9p58oc73Y71HSbPM0tZmVJ5crQsQ4QyLC1ulq
sy0LxtGH3BbFwvXf6/S4N+8W31SIWg7qIr8R7+VVyQyekrE0epaLapdWCAml
sPJluEyJvKk8yCL6uqe5jBPlW/SZOWLe6PizAP5AIMPAqy6fVZ/g7xW+Y7x4
JWbX70zklnTOg1TJrxCOdMH8GrxYFRwtKdVDl1YeAP1K9kaUVV9p8wtyzvGL
+558oeIi/hNHfVKx0JJufqFIzL2YIHpmX8/8u9lXxGcNErII8S1g2AnFIOOH
id9JsDu+Jt5ziCnr4pftltF1YkkDC95WWqFfVcPvRaGsucg8prP21LK4O/P0
hPM86Bp+s871vqsv8YtV5QN+uoBfO/H713T5EkrtZBDtA8QnCvwaS+CRXC6O
/PkUVHx8wHfxKQCfafrLslu7np8+8Jae8WEPM08c87AVsvAhGYoquU4NgXnK
MKa+S6qEuJL99htozbnlEbr0eIz3Kn2fAu7YLhI9paseQU9DlHvJIrUQD3Sc
06PnVmc3IqASkVd64qoT5I08kF4O6bfqorDLSrGXYQ5VdvVyGSRu+bsH4pUg
5S6KYJMQZbI8XNCTYNZ0GLWDLiHPIADjdiGRcwmunJFzJDxluZ3nnbRAOV+m
oxNSGHgYfkkujT/oC7l5kHG0+BbmGwEisyaMTXxbQxGpiAd4JyYdv+vu8je8
3M4TfkecxBWKA7gEPrlcwBtcg/MAiN9xqmd0elWrMSLLJxx87hVpdm2gxDs5
UVcs85Fiaofm83c64gDArKZi+S5k3FGjOhV8/h+KWs/j\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{347, 167},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutExamples",
 CellLabel->"Out[24]=",
 CellID->64667630]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Layout Sample 5", "Section",
 CellTags->"LayoutExamples",
 CellID->325163635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<int\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "5"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<double\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "5"}], "}"}], ",", 
           "\[IndentingNewLine]", "   ", 
           RowBox[{"WidgetLayout", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<Stretching\>\"", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Maximize", ",", "None"}], "}"}]}], "}"}]}]}], "]"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<double\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "5"}], "}"}], ",", 
           "\[IndentingNewLine]", "   ", 
           RowBox[{"WidgetLayout", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<Stretching\>\"", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Maximize", ",", "None"}], "}"}]}], "}"}]}]}], "]"}]}],
         "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Label\>\"", ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<text\>\"", "\[Rule]", 
               "\"\<reallyreallyreallyreallyreallylonglabel\>\""}], "}"}]}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<TextArea\>\"", ",", 
             RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "    ", 
             RowBox[{"WidgetLayout", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"\"\<Stretching\>\"", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"WidgetAlign", ",", "True"}], "}"}]}], "}"}]}]}], 
            "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"WidgetFill", "[", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Button\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Submit\>\""}], "}"}]}], 
            "]"}]}], "}"}]}], "\[IndentingNewLine]", "}"}]}], 
      "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[25]:=",
 CellID->40283409],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject122643512557569, 
   JLink`Objects`JavaObject469274015563777]]], "Output",
 CellTags->"LayoutExamples",
 CellLabel->"Out[25]=",
 CellID->75066070]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[26]:=",
 CellID->237931799],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{251, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutExamples",
 CellLabel->"Out[26]=",
 CellID->65059267]
}, Open  ]],

Cell["After resizing:", "Text",
 CellTags->"LayoutExamples",
 CellID->553658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutExamples",
 CellLabel->"In[27]:=",
 CellID->307645359],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{366, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"LayoutExamples",
 CellLabel->"Out[27]=",
 CellID->741996005]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Layout Samples - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 22.4742364}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "It is perhaps easiest to see when to use certain layout elements by \
visually illustrating how they each combine to create a resizable dialog. \
Here are a number of further examples that combine some of the previous \
layout features and common interface layout design patterns. Here is an \
example that generates content within a set of tabbed panes. Each element of \
the tabbed WidgetGroup can be a list of widgets to populate one tab panel or \
a single widget whose contents will be placed within one pane.", 
    "synonyms" -> {}, "title" -> "Layout Samples", "type" -> "Tutorial", 
    "uri" -> "GUIKit/tutorial/LayoutExamples"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "LayoutExamples"->{
  Cell[731, 29, 79, 2, 70, "Title",
   CellTags->"LayoutExamples",
   CellID->52635598],
  Cell[813, 33, 353, 7, 70, "Text",
   CellTags->"LayoutExamples",
   CellID->285217236],
  Cell[1191, 44, 87, 2, 70, "Section",
   CellTags->"LayoutExamples",
   CellID->199898174],
  Cell[1281, 48, 143, 4, 70, "Text",
   CellTags->"LayoutExamples",
   CellID->66782214],
  Cell[1449, 56, 1836, 46, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->612126701],
  Cell[3288, 104, 298, 8, 70, "Output",
   CellTags->"LayoutExamples",
   CellID->26681991],
  Cell[3623, 117, 140, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->518633173],
  Cell[3766, 123, 9924, 167, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutExamples",
   CellID->160719166],
  Cell[13705, 293, 362, 10, 70, "Text",
   CellTags->"LayoutExamples",
   CellID->31592730],
  Cell[14092, 307, 1105, 27, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->257642540],
  Cell[15200, 336, 297, 8, 70, "Output",
   CellTags->"LayoutExamples",
   CellID->25280119],
  Cell[15512, 347, 138, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->1078586],
  Cell[15687, 356, 86, 2, 70, "Section",
   CellTags->"LayoutExamples",
   CellID->283150106],
  Cell[15776, 360, 229, 6, 70, "Text",
   CellTags->"LayoutExamples",
   CellID->969986490],
  Cell[16030, 370, 1623, 40, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->53429594],
  Cell[17656, 412, 297, 8, 70, "Output",
   CellTags->"LayoutExamples",
   CellID->44052295],
  Cell[17990, 425, 140, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->122979141],
  Cell[18133, 431, 9489, 160, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutExamples",
   CellID->853017038],
  Cell[27659, 596, 272, 8, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->608006929],
  Cell[27934, 606, 100, 3, 70, "Output",
   CellTags->"LayoutExamples",
   CellID->67149394],
  Cell[28049, 612, 182, 5, 70, "Text",
   CellTags->"LayoutExamples",
   CellID->3863624],
  Cell[28234, 619, 307, 9, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->10416097],
  Cell[28566, 632, 141, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->510146123],
  Cell[28710, 638, 9586, 162, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutExamples",
   CellID->2371630],
  Cell[38311, 803, 166, 5, 70, "Text",
   CellTags->"LayoutExamples",
   CellID->26811474],
  Cell[38480, 810, 310, 9, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->458425160],
  Cell[38827, 824, 83, 2, 70, "Section",
   CellTags->"LayoutExamples",
   CellID->357909852],
  Cell[38935, 830, 1518, 37, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->570103228],
  Cell[40456, 869, 299, 8, 70, "Output",
   CellTags->"LayoutExamples",
   CellID->424937204],
  Cell[40792, 882, 141, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->226002130],
  Cell[40936, 888, 9337, 158, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutExamples",
   CellID->4726152],
  Cell[50288, 1049, 79, 2, 70, "Text",
   CellTags->"LayoutExamples",
   CellID->92833581],
  Cell[50392, 1055, 140, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->18563110],
  Cell[50535, 1061, 9384, 158, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutExamples",
   CellID->265840096],
  Cell[59968, 1225, 82, 2, 70, "Section",
   CellTags->"LayoutExamples",
   CellID->33583277],
  Cell[60075, 1231, 6135, 138, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->210530786],
  Cell[66213, 1371, 298, 8, 70, "Output",
   CellTags->"LayoutExamples",
   CellID->41535235],
  Cell[66548, 1384, 139, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->1636904],
  Cell[66690, 1390, 8684, 147, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutExamples",
   CellID->14984543],
  Cell[75389, 1540, 80, 2, 70, "Text",
   CellTags->"LayoutExamples",
   CellID->241656631],
  Cell[75494, 1546, 140, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->17514448],
  Cell[75637, 1552, 8778, 148, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutExamples",
   CellID->151615202],
  Cell[84464, 1706, 82, 2, 70, "Section",
   CellTags->"LayoutExamples",
   CellID->17882252],
  Cell[84571, 1712, 7210, 158, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->30464223],
  Cell[91784, 1872, 299, 8, 70, "Output",
   CellTags->"LayoutExamples",
   CellID->368641675],
  Cell[92120, 1885, 141, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->320550770],
  Cell[92264, 1891, 9138, 154, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutExamples",
   CellID->4045776],
  Cell[101417, 2048, 80, 2, 70, "Text",
   CellTags->"LayoutExamples",
   CellID->495000385],
  Cell[101522, 2054, 141, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->991224489],
  Cell[101666, 2060, 9258, 156, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutExamples",
   CellID->235877604],
  Cell[110973, 2222, 83, 2, 70, "Section",
   CellTags->"LayoutExamples",
   CellID->304228728],
  Cell[111081, 2228, 4157, 94, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->57833530],
  Cell[115241, 2324, 299, 8, 70, "Output",
   CellTags->"LayoutExamples",
   CellID->281700919],
  Cell[115577, 2337, 141, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->372618146],
  Cell[115721, 2343, 9762, 165, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutExamples",
   CellID->29112492],
  Cell[125498, 2511, 80, 2, 70, "Text",
   CellTags->"LayoutExamples",
   CellID->123669284],
  Cell[125603, 2517, 141, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->319384556],
  Cell[125747, 2523, 9802, 165, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutExamples",
   CellID->64667630],
  Cell[135598, 2694, 83, 2, 70, "Section",
   CellTags->"LayoutExamples",
   CellID->325163635],
  Cell[135706, 2700, 3485, 83, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->40283409],
  Cell[139194, 2785, 299, 8, 70, "Output",
   CellTags->"LayoutExamples",
   CellID->75066070],
  Cell[139530, 2798, 141, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->237931799],
  Cell[139674, 2804, 9362, 158, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutExamples",
   CellID->65059267],
  Cell[149051, 2965, 77, 2, 70, "Text",
   CellTags->"LayoutExamples",
   CellID->553658],
  Cell[149153, 2971, 141, 4, 70, "Input",
   CellTags->"LayoutExamples",
   CellID->307645359],
  Cell[149297, 2977, 9539, 161, 70, "Output",
   Evaluatable->False,
   CellTags->"LayoutExamples",
   CellID->741996005]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"LayoutExamples", 160664, 3184}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 79, 2, 70, "Title",
 CellTags->"LayoutExamples",
 CellID->52635598],
Cell[813, 33, 353, 7, 70, "Text",
 CellTags->"LayoutExamples",
 CellID->285217236],
Cell[CellGroupData[{
Cell[1191, 44, 87, 2, 70, "Section",
 CellTags->"LayoutExamples",
 CellID->199898174],
Cell[1281, 48, 143, 4, 70, "Text",
 CellTags->"LayoutExamples",
 CellID->66782214],
Cell[CellGroupData[{
Cell[1449, 56, 1836, 46, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->612126701],
Cell[3288, 104, 298, 8, 70, "Output",
 CellTags->"LayoutExamples",
 CellID->26681991]
}, Open  ]],
Cell[CellGroupData[{
Cell[3623, 117, 140, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->518633173],
Cell[3766, 123, 9924, 167, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutExamples",
 CellID->160719166]
}, Open  ]],
Cell[13705, 293, 362, 10, 70, "Text",
 CellTags->"LayoutExamples",
 CellID->31592730],
Cell[CellGroupData[{
Cell[14092, 307, 1105, 27, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->257642540],
Cell[15200, 336, 297, 8, 70, "Output",
 CellTags->"LayoutExamples",
 CellID->25280119]
}, Open  ]],
Cell[15512, 347, 138, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->1078586]
}, Open  ]],
Cell[CellGroupData[{
Cell[15687, 356, 86, 2, 70, "Section",
 CellTags->"LayoutExamples",
 CellID->283150106],
Cell[15776, 360, 229, 6, 70, "Text",
 CellTags->"LayoutExamples",
 CellID->969986490],
Cell[CellGroupData[{
Cell[16030, 370, 1623, 40, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->53429594],
Cell[17656, 412, 297, 8, 70, "Output",
 CellTags->"LayoutExamples",
 CellID->44052295]
}, Open  ]],
Cell[CellGroupData[{
Cell[17990, 425, 140, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->122979141],
Cell[18133, 431, 9489, 160, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutExamples",
 CellID->853017038]
}, Open  ]],
Cell[CellGroupData[{
Cell[27659, 596, 272, 8, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->608006929],
Cell[27934, 606, 100, 3, 70, "Output",
 CellTags->"LayoutExamples",
 CellID->67149394]
}, Open  ]],
Cell[28049, 612, 182, 5, 70, "Text",
 CellTags->"LayoutExamples",
 CellID->3863624],
Cell[28234, 619, 307, 9, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->10416097],
Cell[CellGroupData[{
Cell[28566, 632, 141, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->510146123],
Cell[28710, 638, 9586, 162, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutExamples",
 CellID->2371630]
}, Open  ]],
Cell[38311, 803, 166, 5, 70, "Text",
 CellTags->"LayoutExamples",
 CellID->26811474],
Cell[38480, 810, 310, 9, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->458425160]
}, Open  ]],
Cell[CellGroupData[{
Cell[38827, 824, 83, 2, 70, "Section",
 CellTags->"LayoutExamples",
 CellID->357909852],
Cell[CellGroupData[{
Cell[38935, 830, 1518, 37, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->570103228],
Cell[40456, 869, 299, 8, 70, "Output",
 CellTags->"LayoutExamples",
 CellID->424937204]
}, Open  ]],
Cell[CellGroupData[{
Cell[40792, 882, 141, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->226002130],
Cell[40936, 888, 9337, 158, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutExamples",
 CellID->4726152]
}, Open  ]],
Cell[50288, 1049, 79, 2, 70, "Text",
 CellTags->"LayoutExamples",
 CellID->92833581],
Cell[CellGroupData[{
Cell[50392, 1055, 140, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->18563110],
Cell[50535, 1061, 9384, 158, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutExamples",
 CellID->265840096]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59968, 1225, 82, 2, 70, "Section",
 CellTags->"LayoutExamples",
 CellID->33583277],
Cell[CellGroupData[{
Cell[60075, 1231, 6135, 138, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->210530786],
Cell[66213, 1371, 298, 8, 70, "Output",
 CellTags->"LayoutExamples",
 CellID->41535235]
}, Open  ]],
Cell[CellGroupData[{
Cell[66548, 1384, 139, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->1636904],
Cell[66690, 1390, 8684, 147, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutExamples",
 CellID->14984543]
}, Open  ]],
Cell[75389, 1540, 80, 2, 70, "Text",
 CellTags->"LayoutExamples",
 CellID->241656631],
Cell[CellGroupData[{
Cell[75494, 1546, 140, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->17514448],
Cell[75637, 1552, 8778, 148, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutExamples",
 CellID->151615202]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84464, 1706, 82, 2, 70, "Section",
 CellTags->"LayoutExamples",
 CellID->17882252],
Cell[CellGroupData[{
Cell[84571, 1712, 7210, 158, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->30464223],
Cell[91784, 1872, 299, 8, 70, "Output",
 CellTags->"LayoutExamples",
 CellID->368641675]
}, Open  ]],
Cell[CellGroupData[{
Cell[92120, 1885, 141, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->320550770],
Cell[92264, 1891, 9138, 154, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutExamples",
 CellID->4045776]
}, Open  ]],
Cell[101417, 2048, 80, 2, 70, "Text",
 CellTags->"LayoutExamples",
 CellID->495000385],
Cell[CellGroupData[{
Cell[101522, 2054, 141, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->991224489],
Cell[101666, 2060, 9258, 156, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutExamples",
 CellID->235877604]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[110973, 2222, 83, 2, 70, "Section",
 CellTags->"LayoutExamples",
 CellID->304228728],
Cell[CellGroupData[{
Cell[111081, 2228, 4157, 94, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->57833530],
Cell[115241, 2324, 299, 8, 70, "Output",
 CellTags->"LayoutExamples",
 CellID->281700919]
}, Open  ]],
Cell[CellGroupData[{
Cell[115577, 2337, 141, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->372618146],
Cell[115721, 2343, 9762, 165, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutExamples",
 CellID->29112492]
}, Open  ]],
Cell[125498, 2511, 80, 2, 70, "Text",
 CellTags->"LayoutExamples",
 CellID->123669284],
Cell[CellGroupData[{
Cell[125603, 2517, 141, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->319384556],
Cell[125747, 2523, 9802, 165, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutExamples",
 CellID->64667630]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[135598, 2694, 83, 2, 70, "Section",
 CellTags->"LayoutExamples",
 CellID->325163635],
Cell[CellGroupData[{
Cell[135706, 2700, 3485, 83, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->40283409],
Cell[139194, 2785, 299, 8, 70, "Output",
 CellTags->"LayoutExamples",
 CellID->75066070]
}, Open  ]],
Cell[CellGroupData[{
Cell[139530, 2798, 141, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->237931799],
Cell[139674, 2804, 9362, 158, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutExamples",
 CellID->65059267]
}, Open  ]],
Cell[149051, 2965, 77, 2, 70, "Text",
 CellTags->"LayoutExamples",
 CellID->553658],
Cell[CellGroupData[{
Cell[149153, 2971, 141, 4, 70, "Input",
 CellTags->"LayoutExamples",
 CellID->307645359],
Cell[149297, 2977, 9539, 161, 70, "Output",
 Evaluatable->False,
 CellTags->"LayoutExamples",
 CellID->741996005]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[158875, 3143, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

