(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37310,       1156]
NotebookOptionsPosition[     26878,        809]
NotebookOutlinePosition[     32338,        975]
CellTagsIndexPosition[     32261,        970]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " Example:",
 " ",
 "Making Progress (Extended)"
}], "Title",
 CellID->554471618],

Cell["", "Text",
 CellID->208224786],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWnt0VOW133POzCRcRGB1ra5eKy7W6lV51VWpRqS1tuJFK3gtCqUwIKQh
kCD4AAzIVXtpcVmVKl6xQHmoLQsQkLbyCIkRBQJ5khd5kgRm8iQPzJsAgZu7
f/s732QGJjaRULTkj73Pfp/v++3vnPOdOfNo6KKI8PmhiyLDQgc/tCD02YjI
sIWDxz6zgE2mjcj2CyJaPJggt7NosXaaPfvlCWCsmXJsu3BRqB38UTDbZf6t
H35CkjoOzAbdFjgSx3ZynywdB2ZT4b2RvZG9kd2O7I+g9nZmQ8G+1eUctrXz
pb5j+2b6zcsv8RkjIiJuB2MHDDu2b5GA/t2piKTFixdTXV0dV2Q+RERTjDgV
wm7sekW7DGX//v1ShqkdY7oNzLAqIwChoH7dqYyp6spcz0lrElcY15n0pLTY
Ti0tLSIBC8alGz0PgONbcb81rjNJ43j27Nmew/F3O6OM60zSOLa1tfXi+DXC
kclBUZvncugi5igJ6rX9a9umg+sHLdZDzzxovxaXyDf7grzW87nWOJ4/f74X
xx7AsXfD0jM49ugG+msxs2uDY2NjYy+OPYCjhUEvjleIY319fS+OPYBjU1NT
z+H4B++r93UjXZXnzKbsNcZ1Jl2Vfc+h0ljjOpOuyvvM12KFXJv12IM/1Dhp
beKb1hmuG2kGpCv+pUJ/bLDQdNK7u940rjNppgUiMFi2bFl3v9iY8pkHn3tQ
oB18iIiqLbt27ep+xXb5TrWl4zvVUOs7FUbarUZ/U77qPapmLt/j9QTPX9XE
/gES7eBiMgJ4DX+vT5zDLw7fJ0n7DIjBnWbafTMDnFiOnY5INNN7mo7iZoBg
z1dFRRULCjhH7xA7w6t7eXLs8xVrqRjnpYjqo+nfqn84jEviL29tz+IbyBb4
5Pav2KNrgKvjS6ZR3WW87N7F7ejojLdmp5dqF4KvPi72S3HpdFTiqOj6IurK
heV39i+9r/VepwEg/pKige7Jgbwdkt3f1ukzwfRfIB1F7QFO2aEFqnKFj4HA
0785QNHBAWyOALba7l3zg672qZ4IkNjclcRvyr6qN7I3sjfymxrZ2nqO1qzZ
wpGLF//vODAbdBscl0fGfXqUI5mPB+skqKy0lIOYjwcLEFTf0Czvn+3qpwaI
pmSt3xRDTz3/FmvgdpoXtVIkHJn6iOKUMDmJ9ZeKui++oCNJx+z04UcxnLWN
OaRtivqI4kSEROqs2upqVLLT5nsf5Kwtox8UCUemPqKYci5EIkN+GrFh+Ho+
35ZjiaeEgb1AbW0XBPkLbRdZVv/uhv0CbDi26eMFOSqfzlFxKu+CIQ67N7VN
Ui8OkzgnnT1zlgrzPJR8+BglHMyko4m50IfD7UJ+iBQ1vYi+8trfaIBwp+iw
t1l/QAcwDNFA+nR/FruBFkxt1igRylgMpG0/nsRuwAKTnhAqMAAaEbsc3W4P
neGlwK03ROjL/KysjlY+nhFSstjOaP2cHA2R7Jbd6zNFMH1KnaMhwoOp8lQV
TZs2k2767s1044AB9P077qCwsNmCTnpK/jCEuZAfIgmmF5X1G/czMuBO0WHX
xQFFSurxgXTocDafg0UxtVpDAhQA5eDjLjoycWo/OjJpGoexKCa4ENLqM1MG
RiPllOOJYg818PUAwnVR39h8I02aNInrNDS0UEOj5WpsUWGNEgJ5KMe3cNgj
48bToFtuoejoT8Xy7uq1gsAPfxhCSfFZr8AYIrXVpD/ek0Fbth7kSYM7RYe9
3hoBZpiaVjiQklPyedvDopjUSFpkRobMz6SUiVPo6JQnhfoKDxYbvCDE1uvJ
cT5PVs8+SI5FhW6qrqlXVFtPVTV19N4H7/OoysrK+AQlxwu5s6eE7FRTU8Me
+Ktr6zryakQ20GpTLNj3Vkrns9KOi+VEcTmw0DaJNbxZVyLxK0pqWhatfPOP
ooE+2hYtDcBSxIkxAIOOJuWaKstPGgTJhcmHyEzs0ou9MVxm5xFQsHV/hLpD
mSzNFB2hSDGsdPQqI6OI0njqTDcg3RStj9jh19ChP+ia9PGXLkqbMoP7mDF1
BsMMGTbdY8TKoPk0NjTO/4ovKDhJpeXVVFpWbbBQw2Y0KjIyUlrJZEgX+1Fh
YSEdfmOFHNFRWCHjCB1pViWmGpENAbSvwIvioK3bdop1/LhfiL5u45+9V/8T
EydbOU5vDjSQpV8996Rf/spuuYeNGCHjQsio0T+iu+66h1IScxRCpq+JAtkG
weYCEiECg0M6Hbc/mz7+OFkIa8NJT8/HM/PWW0O8dodwp8QiRwBlQvezjp00
KDOzyPoVeNWq9UJ9wE1xOBAjsboB6qrHOrBThmsmZU+boR+kQVDk0cglYIdf
3xWQ520mzw/LxH8zkJd/gopOVLAGPlDab60YISwNHJMi5lCVawLFxsaqJcTH
A6velmWDL+HIKyqukCoG83LfNcMqHc3Io+/y+sAayck9Kbahw0dIFC7ZTVt2
+K0Z+H3b6i15Ze7ggO57Ro0W+YON29RtxaRUXgAFBR4JNRBgqiJ+0l/FrdbF
ZwdyaV9MmtCl60LbHcKdEoscZIPQ6+xct0HZOSd81gW0oAA2FdcHKZKqylR4
byiZU5+k7Omh9MStg1Wmg3JnhJnWIoEVXkTpRaIr4Igl4X93ycktppx8N+Xm
ewwRbpB+L1y4UPqP9bFn3KOUkXCE8qZMppLICXTyuemUMncqHfje92j3rl2G
BDlo1TvvSIGcfI+iPLfVdYfgnsv6zx74T7GsXf0B+9ji21gE+Hbun+M2RY2N
ixdN2x4YM1aWbhJvA4cj2MUIuUNkYmpNHDpcwDv1TCGAH4TVECSqU5wI0lig
k3n5JZiyx6fh0IIC2FScAymSmpOn4FT3ipzpMzk+f2YoFYT+msbecpPKNqGa
1jMNVngRpTIckq0bI0duvV4MwXLMyi6m9KwiyhAqliNWw8GDB1WX+9IR1zSK
HXYbNU8bS7UTxlDl5nkUPfM+Wn3bIFkBb698i2J/s1iOdhTwXQIvLv2daL+a
PJ2Sk3J5ZN4A1SWc0LdL/xy3unEMGTpM3yho6/Zd3p0e+4Yj1sXQFIdIFbXd
S0wqpEPxubzdA3eKDnuGhSA6d7yQn87HC0t9GgwtKIDN8HrKJFU3Am3LmzFD
2sm3p/BwBhPt1W9bIFhNaxnCB10T8pCvFg9XtKG0Dc3W3f93OWZkFVLK0XxK
PlpAKWk45kv3U1NSqTjuE8qOi6Mjjz1EpWH3Ucump6hiVSjV/voeKhw1gpLu
vJ1iH76b6ic+Qsdzc2nj++9RclqB1EvheqjpEEjtNCv8KQE8MSEHPt8WIdS3
RZe4k1PyOty86eye+9LiHO5dnBzt60pKzvPeCqxKQkPBeeeWVhAiU1MLISX1
BCUmF/A6Ajd5IRSIZGnM7V4bYjnHkHT1Slh8otL7tLAWRLAoHetDPanA+0g4
0pKtVun1UThrFrnnhJN7djjHnpgzx7oN6DWinxGwwQtCLHKQq9cI2obhFdiw
Ivy3FOnpx+lwYjZr4GpLsdQ1hTz33knlY0KoZtp/UePacDqXvJwadzxPZS9N
pKMTfkzlGxdR7dLHaf3rr1FqfDyt37CeDidkSxUDkgI7SMCP53XxzHMviOXZ
p6PoyIEMsfn2Erpvw1jX7h18235/w4ei3X//GIrnN8yuugdcVjxQ+E9++qDo
7/OdAncL7Tscf2w4kl0Un5gdwlK2tUAyMt2UklLE5cGdosOOCBDa6XZXcde4
tx1dhxYUwGZYHk6R1HhBMke6h06eDJ+FX9XnRgS4U0BXPlPiEK/uDDxmG7ci
x4Yu+28SUvkd5yBfBgfi+f3sAAsDpPP63eL0ojCqfX0atbztkq5nrZxP0bOf
oIQ546g1JopO/fYx+uC1V2nTpk30wtIXUMpEGd+mc2kh/XqnbRJjqDNriRFE
2M/59US/ltzH8G/dEa3cQZ25xWt2uY5DVD2ikfwsmP9sFI2Az4XxhwgoqsXH
jpVQekYxIwPuFB12RIDQp5ISfoPzeHzbCS0ogM2wPJwiqQqeLG+LPZF4DLjn
RTrUHpAl1IkM9zb0YHymNwv98+9ocmo+7f88nT79PN1gIY2+5d32yZtjzF7K
W/44VU+5V7qYOG8SHV6+mKJd99OpqIepeOpoKr97GLnX/EmuZZRCFX303Vop
e4ftoKWDvgPOS+/z9NGQXDyetBDxKFRzc8sYSTejCu4UHXadD2jKyvidsbT0
lA+COAZbO3Xo8GricKQZ1lkAFe6CnrlzGZrSefNM6z9ul1w44uN4xCFeXTM8
XxsK2QCo/w8wScn5tHdfIsXEpfDuEpQqEBsC8A1UeMfttC9kBKWO/D4ljh8l
t0g8Qd+4+dsCb/7ksbR3w1qqcJ+kravfMbhQKg8r9pNUKWndn/QrzaywuWKa
OMlFN0moST8YeTeNZDrETRkNmwuDCJHRKHjz88sZWI/A62GsoMMea40Z8FZU
nDZ4GVZZ8O6LThQKFq7ghVcThyt4MV/1m6Y7MoI88+dR2XPzmZ6hsmef9t2m
stqxiTVEDZZY5CAXNfS0gSgj679xSUjKo917E8S5d18S7Y1JEqjxY9+pD/8i
gMcvXCBPItyP8HTSq3jz3SOoePceuZfpjYuuEW0d7dbK/Y/bhlBE5AKx3wRu
0A/uvOtHkFxIChGP3btyAWd+foUJweGVDEiGODsWNBJBXsTLy2sDIt5PEIdX
k4U4Rceo0QKusqcZ6kXPUCXg5qOqpJ4G0DV5ced9gW888lFHIwF0gbL/buBI
osLdFN5fMAfWIPxwkLlzJ52e/Bg1LQ+jpiWPUM0jIyn3v5dQUUQofXTXKPkb
6bmWFsG8SWqoV6ucnFIqKqwUKma6USSn2OFHJAizZgRMqqw83Vf9xsISTwWw
wKkDMZXKhTy95xdQddRCql4SpT45WEuw6uUlQqbwYL9rH7HIQS5qcC2Zrw3T
vxyPv+9KZA1c4YHnHbAApfx8LDVXqR9Vmg/vp7IRt4sMDGr57Qq/yQIT5DVZ
lQSPbHzcrubLFNwpOuyIAFk4DKSqqjqf2Wu3/L74wkKqenEJ1S1bSo2vLePZ
Y45BVLPmDapet4JOr379MtmwNguIRx7yUUd9vuHKnUCwLzqdtb/uTLB+Uta/
I4GspWHInBnu8Q/LjEGmxZGCZFCDcIXC6ZomqjrVwCiAO0WHXcdiys1NrQOp
vq6Zbwwsikm7MeqG/3me6pe/SC0rllPrhjepcfsfqeHjdXR69zqq3bO+Uxlx
iEce8lFHPQC4sg0TDgDF5wcyKUG2gDu2x1vzwg4IMBjgpgYh/lBAEJAGarAK
YLJZmaXU2NDKIIA7RYddx2LGHk/VQGpqPMNuFsWk3Rh08+svGdSy8pV+1Lhv
o0gcyEZx6kAMnCfgv2nAjLKyTtKe3UnttOkv+x1g7Fu+4s8yiNSUYnzb6uf9
l/gFMcHFIYYVHf2Jd5h08eJFHc2id7gcoqKD6O0122Rg7e/9gf7vs010viia
ztcwVe1lFM8xt4t8ziKWlfnfVBiHIw3pKINyKMxTkKn4zFF9Ndq65TO5o2Zl
uSkuLp3+/rf4dhjt4jG9cwX1tz6pwgYvyLDi9CxB/YUr26VxyMXAQP2FO8XG
55XzYxwYD0d37C+A2KuvrpPfh/C1sIz3NRkZbkpOPo6PyHHpYyTXKQY4EIBA
JHCiTSqQtUdC1XdXbfdWa2xootqaL8hTUtMO48/EEwRd7PDrYshDvlVR31R1
ycxM/KLJwXIvHaOe8Mg1xaWzVZreAcBi0u9f3SB+wCQdeEBEuxjhRBiTenyR
7INlLg+BOawZ2v4fCYcaEA==\
\>"], "Graphics",
 ImageSize->{336, 119},
 CellID->97074467],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 CellID->827429082],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[14]:=",
 CellID->88933248]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellID->52467304],

Cell["\<\
This example demonstrates various techniques of designing a progress bar \
dialog and a number of options available to wrap the reusable widget \
involved.\
\>", "Text",
 CellID->124911694],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Basic implementation",
 FontWeight->"Bold"]], "Subsection",
 CellTags->"MakingProgress",
 CellID->1128676],

Cell[TextData[{
 "Here is one technique of defining a progress bar using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression syntax."
}], "Text",
 CellTags->"MakingProgress",
 CellID->291029362],

Cell[BoxData[
 RowBox[{
  RowBox[{"expr", " ", "=", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Frame\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"WidgetGroup", "[", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<Label\>\"", ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<text\>\"", "\[Rule]", "\"\<Percent \ncomplete:\>\""}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Name", "\[Rule]", "\"\<label\>\""}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<ProgressBar\>\"", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<minimum\>\"", "\[Rule]", "0"}], ",", 
               RowBox[{"\"\<maximum\>\"", "\[Rule]", "100"}], ",", 
               RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
                RowBox[{"Widget", "[", 
                 RowBox[{"\"\<Dimension\>\"", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"\"\<width\>\"", "\[Rule]", "300"}], ",", 
                    RowBox[{"\"\<height\>\"", "\[Rule]", "25"}]}], "}"}]}], 
                 "]"}]}]}], "}"}], ",", 
             RowBox[{"Name", "\[Rule]", "\"\<bar\>\""}]}], "]"}]}], "}"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"WidgetLayout", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\"\<Grouping\>\"", "\[Rule]", "Column"}], ",", 
            RowBox[{"\"\<Border\>\"", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"15", ",", "15"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"25", ",", "20"}], "}"}]}], "}"}]}]}], "}"}]}]}], 
        "]"}], ",", 
       RowBox[{"\"\<location\>\"", "\[Rule]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Point\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\"\<x\>\"", "\[Rule]", "400"}], ",", 
            RowBox[{"\"\<y\>\"", "\[Rule]", "400"}]}], "}"}]}], "]"}]}], ",", 
       
       RowBox[{"\"\<title\>\"", "\[Rule]", "\"\<Computation Progress\>\""}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"\"\<resizable\>\"", "\[Rule]", "False"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Name", "\[Rule]", "\"\<frame\>\""}]}], "]"}]}], ";"}]], "Input",\

 CellContext->Notebook,
 CellTags->"MakingProgress",
 CellLabel->"In[15]:=",
 CellID->390785113],

Cell["\<\
A progress bar would be most useful in a modeless session where it could be \
used to update the state of another ongoing kernel evaluation.\
\>", "Text",
 CellTags->"MakingProgress",
 CellID->56086954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "expr", "]"}]}]], "Input",
 CellContext->Notebook,
 CellTags->"MakingProgress",
 CellLabel->"In[16]:=",
 CellID->3451810],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject427198636883969, 
   JLink`Objects`vm1`JavaObject300336375922689]]], "Output",
 CellTags->"MakingProgress",
 CellLabel->"Out[16]=",
 CellID->79598776]
}, Open  ]],

Cell["\<\
There are three important widgets in the dialog that have been registered \
with reference names for easy lookup. Here are the most common properties \
worth setting during the lifetime of the dialog.\
\>", "Text",
 CellTags->"MakingProgress",
 CellID->200573530],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<bar\>\"", ",", " ", "\"\<value\>\""}], "}"}], ",", " ", 
    "70"}], "]"}]}]], "Input",
 CellContext->Notebook,
 CellTags->"MakingProgress",
 CellLabel->"In[17]:=",
 CellID->608635928],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<frame\>\"", ",", " ", "\"\<title\>\""}], "}"}], ",", " ", 
    "\"\<Running...\>\""}], "]"}]}]], "Input",
 CellContext->Notebook,
 CellTags->"MakingProgress",
 CellLabel->"In[18]:=",
 CellID->573145836],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<label\>\"", ",", " ", "\"\<text\>\""}], "}"}], ",", " ", 
    "\"\<Finding...\>\""}], "]"}]}]], "Input",
 CellContext->Notebook,
 CellTags->"MakingProgress",
 CellLabel->"In[19]:=",
 CellID->649945521],

Cell[TextData[{
 "Once the dialog is not needed, you can call ",
 StyleBox["ReleaseGUIObject", "Output"],
 " to dispose of the instance."
}], "Text",
 CellTags->"MakingProgress",
 CellID->745821889],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReleaseGUIObject", "[", "ref", "]"}], ";"}]], "Input",
 CellContext->Notebook,
 CellTags->"MakingProgress",
 CellLabel->"In[20]:=",
 CellID->129514889],

Cell["\<\
The following variants also show different techniques for defining a reusable \
progress dialog within the layout of an AddOn, and discuss the many options \
available for exposing only a subset of the properties and widgets that make \
up the user interface.\
\>", "Text",
 CellTags->"MakingProgress",
 CellID->123934458],

Cell[CellGroupData[{

Cell["Example 1 of a progress bar implementation", "SubsubsectionOpener",
 CellTags->"MakingProgress",
 CellID->806972922],

Cell[TextData[{
 "Here is an example that provides a progress bar implementation similar to \
the ",
 StyleBox["J/Link ",
  FontSlant->"Italic"],
 "example."
}], "Text",
 CellTags->"MakingProgress",
 CellID->171008067],

Cell[TextData[{
 "In this version, you postmanipulate the Java objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by looking up the instances from their names after loading the definition \
file. After modifying the frame's title and the label's text, you will then \
call ",
 StyleBox["GUIRun,",
  FontFamily->"Courier"],
 " which displays the dialog."
}], "Text",
 CellTags->"MakingProgress",
 CellID->284715506],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateProgressBar1", "[", 
   RowBox[{
    RowBox[{"title_String", ":", "\"\<Computation Progress\>\""}], ",", 
    RowBox[{"caption_String", ":", "\"\<Percent complete:\>\""}], ",", 
    RowBox[{"percent_Integer", ":", "0"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "uiObj", "}"}], ",", 
    RowBox[{
     RowBox[{"uiObj", "=", 
      RowBox[{"GUILoad", "[", "\"\<Wolfram/Example/ProgressBar1\>\"", "]"}]}],
      ";", 
     RowBox[{"uiObj", "[", 
      RowBox[{"SetPropertyValue", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<frame\>\"", ",", "\"\<title\>\""}], "}"}], ",", 
        "title"}], "]"}], "]"}], ";", 
     RowBox[{"uiObj", "[", 
      RowBox[{"SetPropertyValue", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<label\>\"", ",", "\"\<text\>\""}], "}"}], ",", 
        "caption"}], "]"}], "]"}], ";", 
     RowBox[{"uiObj", "[", 
      RowBox[{"SetPropertyValue", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<bar\>\"", ",", "\"\<value\>\""}], "}"}], ",", 
        "percent"}], "]"}], "]"}], ";", 
     RowBox[{"GUIRun", "[", "uiObj", "]"}]}]}], "]"}]}]], "Input",
 CellTags->"MakingProgress",
 CellLabel->"In[21]:=",
 CellID->297596541],

Cell[TextData[{
 "Here is a function that simulates a typical interaction with",
 " ",
 "the ",
 StyleBox["GUIObject",
  FontFamily->"Courier"],
 " representing a progress bar dialog."
}], "Text",
 CellTags->"MakingProgress",
 CellID->706083507],

Cell[BoxData[
 RowBox[{
  RowBox[{"RunProgressBar", "[", "ref_", "]"}], " ", ":=", " ", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "n", "}"}], ",", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{"ref", " ", "@", " ", 
       RowBox[{"PropertyValue", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<bar\>\"", ",", "\"\<value\>\""}], "}"}], "]"}]}]}], ";",
      "\n", "      ", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"n", "\[LessEqual]", "100"}], ",", "\[IndentingNewLine]", 
       "     ", 
       RowBox[{
        RowBox[{"ref", " ", "@", " ", 
         RowBox[{"SetPropertyValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<bar\>\"", ",", "\"\<value\>\""}], "}"}], ",", "n"}], 
          "]"}]}], ";", "\[IndentingNewLine]", "     ", 
        RowBox[{"Pause", "[", "1", "]"}], ";", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"This", " ", "simulates", " ", "the", " ", "time"}], "-", 
          RowBox[{"consuming", " ", 
           RowBox[{"computation", "."}]}]}], " ", "*)"}], 
        "\[IndentingNewLine]", "     ", 
        RowBox[{"n", "+=", "15"}]}]}], "]"}], ";", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "This", " ", "simulates", " ", "progress", " ", "in", " ", "15", "%", 
       " ", 
       RowBox[{"increments", "."}]}], " ", "*)"}], "\n", "     ", 
     RowBox[{"ReleaseGUIObject", "[", "ref", "]"}], ";"}]}], 
   "\[IndentingNewLine]", "  ", "]"}]}]], "Input",
 CellTags->"MakingProgress",
 CellLabel->"In[22]:=",
 CellID->389481447],

Cell[TextData[{
 "To use the progress bar in a computation, you call ",
 StyleBox["CreateProgressBar1", "MR"],
 ",",
 StyleBox[" which", "MR",
  FontFamily->"Times"],
 " loads the user interface definition and returns a GUI",
 StyleBox["Object",
  FontFamily->"Courier"],
 ". Then, while the computation is running, you periodically change the value \
property to update the bar\[CloseCurlyQuote]s appearance. When the \
computation is done, you call ",
 StyleBox["ReleaseGUIObject",
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->"MakingProgress",
 CellID->324832665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"CreateProgressBar1", "[", "]"}]}]], "Input",
 CellLabel->"In[23]:=",
 CellID->138770893],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject367987580207105, 
   JLink`Objects`vm1`JavaObject154338072723457]]], "Output",
 CellLabel->"Out[23]=",
 CellID->145107978]
}, Open  ]],

Cell[CellGroupData[{

Cell["RunProgressBar[ref]", "Input",
 CellTags->"MakingProgress",
 CellLabel->"In[24]:=",
 CellID->89790354],

Cell[BoxData[
 RowBox[{
  RowBox[{"Remove", "::", "\<\"remal\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(\\*TagBox[\\(Removed[\\\"JavaObject154338072723457\\\
\"]\\), False, Rule[Editable, False]]\\) already removed. \\!\\(\\*ButtonBox[\
\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Remove/remal\\\", ButtonNote -> \
\\\"Remove::remal\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"MakingProgress",
 CellLabel->"During evaluation of In[24]:=",
 CellID->211726448]
}, Open  ]],

Cell[TextData[{
 "You can also expose certain properties as optional arguments to the ",
 StyleBox["CreateProgressBar1",
  FontFamily->"Courier"],
 " function to reuse the dialog in multiple situations."
}], "Text",
 CellTags->"MakingProgress",
 CellID->64859110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"CreateProgressBar1", "[", 
   RowBox[{
   "\"\<Modified title\>\"", ",", "\"\<Modified caption\>\"", ",", "45"}], 
   "]"}]}]], "Input",
 CellLabel->"In[25]:=",
 CellID->314751404],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject402285544865793, 
   JLink`Objects`vm1`JavaObject2436689297409]]], "Output",
 CellLabel->"Out[25]=",
 CellID->352627647]
}, Open  ]],

Cell[CellGroupData[{

Cell["RunProgressBar[ref]", "Input",
 CellTags->"MakingProgress",
 CellLabel->"In[26]:=",
 CellID->205851099],

Cell[BoxData[
 RowBox[{
  RowBox[{"Remove", "::", "\<\"remal\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(\\*TagBox[\\(Removed[\\\"JavaObject402285544865793\\\
\"]\\), False, Rule[Editable, False]]\\) already removed. \\!\\(\\*ButtonBox[\
\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Remove/remal\\\", ButtonNote -> \
\\\"Remove::remal\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"MakingProgress",
 CellLabel->"During evaluation of In[26]:=",
 CellID->11157420]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2A of a progress bar implementation", "SubsubsectionOpener",
 CellTags->"MakingProgress",
 CellID->249281981],

Cell[TextData[{
 "This example illustrates how you can alternatively create reusable versions \
of a progress bar or any widget by placeholding dynamic properties that may \
need to change for each instance. This is done by using ",
 StyleBox["WidgetReference[\"#", "Program"],
 StyleBox["n",
  FontSlant->"Italic"],
 StyleBox["\"]", "Program"],
 " within a base .m and creating various wrapper .m files that define these \
needed arguments to the base script externally."
}], "Text",
 CellTags->"MakingProgress",
 CellID->383667452],

Cell[TextData[{
 "In this example, you use a base user interface called ProgressBar2Base.m \
that contains uses of ",
 StyleBox["WidgetReference[\"#", "Program"],
 StyleBox["n",
  FontSlant->"Italic"],
 StyleBox["\"]", "Program"],
 " and expects these values to be passed as initial arguments when called."
}], "Text",
 CellTags->"MakingProgress",
 CellID->33226825],

Cell["\<\
The source of ProgressBar2Base.m clarifies what dynamic elements of the \
progress bar are unique to this instance by only exposing certain properties \
within ProgressBar2Base.m, but setting all these modifiable properties within \
the wrapping .m file.\
\>", "Text",
 CellTags->"MakingProgress",
 CellID->3943695],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CreateProgressBar2A", "[", "]"}], ":=", 
   RowBox[{"GUIRun", "[", "\"\<Wolfram/Example/ProgressBar2\>\"", "]"}]}], 
  ";"}]], "Input",
 CellTags->"MakingProgress",
 CellLabel->"In[27]:=",
 CellID->272995031],

Cell[TextData[{
 "Here is the revised ",
 StyleBox["CreateProgressBar2A",
  FontFamily->"Courier"],
 " implementation reusing the same ",
 StyleBox["RunProgressBar",
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->"MakingProgress",
 CellID->74715480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"CreateProgressBar2A", "[", "]"}]}]], "Input",
 CellLabel->"In[28]:=",
 CellID->70838205],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject115877412339713, 
   JLink`Objects`vm1`JavaObject157892426596353]]], "Output",
 CellLabel->"Out[28]=",
 CellID->346651614]
}, Open  ]],

Cell[BoxData[
 RowBox[{"RunProgressBar", "[", "ref", "]"}]], "Input",
 CellTags->"MakingProgress",
 CellLabel->"In[29]:=",
 CellID->374286817]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2B of a progress bar implementation", "SubsubsectionOpener",
 CellTags->"MakingProgress",
 CellID->117709487],

Cell[TextData[{
 "Taking this wrapper and base .m a step further, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions that load and run ",
 StyleBox["GUIObject",
  FontFamily->"Courier"],
 " instances can also pass script arguments when they are called using an \
optional second argument. Here you show how the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code can dynamically pass arguments to the base .m file that you used \
previously, duplicating the functionality of example 1, but greatly \
simplifying the interaction with the reusable user interface by not seeing \
all the individual property processing calls within the ",
 StyleBox["CreateProgressBar1",
  FontFamily->"Courier"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code."
}], "Text",
 CellTags->"MakingProgress",
 CellID->391194381],

Cell[TextData[{
 "Notice how the second argument to ",
 StyleBox["GUILoad",
  FontFamily->"Courier"],
 " is simply: ",
 StyleBox["{title,",
  FontFamily->"Courier"],
 " ",
 StyleBox["caption,",
  FontFamily->"Courier"],
 " ",
 StyleBox["percent}",
  FontFamily->"Courier"],
 ", which will be registered in the widget name registry as ",
 StyleBox["\"#1\"", "Program",
  FontFamily->"Courier"],
 ", ",
 StyleBox["\"#2\"", "Program",
  FontFamily->"Courier"],
 ", and ",
 StyleBox["\"#3\"", "Program"],
 ", respectively. "
}], "Text",
 CellTags->"MakingProgress",
 CellID->276867605],

Cell[TextData[{
 "The two-argument call to GUI",
 StyleBox["Load",
  FontFamily->"Courier"],
 " using ProgressBar2Base.m is the equivalent of example 2A of wrapping \
ProgressBar2Base.m with ProgressBar2.m containing the values desired."
}], "Text",
 CellTags->"MakingProgress",
 CellID->435614941],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CreateProgressBar2B", "[", 
    RowBox[{
     RowBox[{"title_String", ":", "\"\<Computation Progress\>\""}], ",", 
     RowBox[{"caption_String", ":", "\"\<Percent complete:\>\""}], ",", 
     RowBox[{"percent_Integer", ":", "0"}]}], "]"}], ":=", 
   RowBox[{"GUIRun", "[", 
    RowBox[{"\"\<Wolfram/Example/ProgressBar2Base\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"title", ",", "caption", ",", "percent"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"MakingProgress",
 CellLabel->"In[30]:=",
 CellID->131701709],

Cell[TextData[{
 "Here is the revised ",
 StyleBox["CreateProgressBar2B",
  FontFamily->"Courier"],
 " implementation reusing the same ",
 StyleBox["RunProgressBar",
  FontFamily->"Courier"],
 "."
}], "Text",
 CellTags->"MakingProgress",
 CellID->805228188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"CreateProgressBar2B", "[", 
   RowBox[{
   "\"\<Yet another title\>\"", ",", "\"\<Another caption\>\"", ",", "65"}], 
   "]"}]}]], "Input",
 CellLabel->"In[31]:=",
 CellID->374136624],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject228683268751361, 
   JLink`Objects`vm1`JavaObject273317994954753]]], "Output",
 CellLabel->"Out[31]=",
 CellID->515790468]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RunProgressBar", "[", "ref", "]"}]], "Input",
 CellTags->"MakingProgress",
 CellLabel->"In[32]:=",
 CellID->114562288],

Cell[BoxData[
 RowBox[{
  RowBox[{"Remove", "::", "\<\"remal\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(\\*TagBox[\\(Removed[\\\"JavaObject273317994954753\\\
\"]\\), False, Rule[Editable, False]]\\) already removed. \\!\\(\\*ButtonBox[\
\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Remove/remal\\\", ButtonNote -> \
\\\"Remove::remal\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"MakingProgress",
 CellLabel->"During evaluation of In[32]:=",
 CellID->36159848]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIKit Example: Making Progress (Extended) - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 24.9116116}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "This example demonstrates various techniques of designing a progress bar \
dialog and a number of options available to wrap the reusable widget \
involved. Here is one technique of defining a progress bar using the \
Mathematica expression syntax.", "synonyms" -> {}, "title" -> 
    "GUIKit Example: Making Progress Extended", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/MakingProgressExtended"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "MakingProgress"->{
  Cell[7455, 170, 130, 3, 70, "Subsection",
   CellTags->"MakingProgress",
   CellID->1128676],
  Cell[7588, 175, 212, 7, 70, "Text",
   CellTags->"MakingProgress",
   CellID->291029362],
  Cell[7803, 184, 2605, 64, 70, "Input",
   CellTags->"MakingProgress",
   CellID->390785113],
  Cell[10411, 250, 212, 5, 70, "Text",
   CellTags->"MakingProgress",
   CellID->56086954],
  Cell[10648, 259, 192, 6, 70, "Input",
   CellTags->"MakingProgress",
   CellID->3451810],
  Cell[10843, 267, 307, 8, 70, "Output",
   CellTags->"MakingProgress",
   CellID->79598776],
  Cell[11165, 278, 273, 6, 70, "Text",
   CellTags->"MakingProgress",
   CellID->200573530],
  Cell[11441, 286, 314, 10, 70, "Input",
   CellTags->"MakingProgress",
   CellID->608635928],
  Cell[11758, 298, 332, 10, 70, "Input",
   CellTags->"MakingProgress",
   CellID->573145836],
  Cell[12093, 310, 331, 10, 70, "Input",
   CellTags->"MakingProgress",
   CellID->649945521],
  Cell[12427, 322, 198, 6, 70, "Text",
   CellTags->"MakingProgress",
   CellID->745821889],
  Cell[12628, 330, 186, 6, 70, "Input",
   CellTags->"MakingProgress",
   CellID->129514889],
  Cell[12817, 338, 332, 7, 70, "Text",
   CellTags->"MakingProgress",
   CellID->123934458],
  Cell[13174, 349, 122, 2, 70, "SubsubsectionOpener",
   CellTags->"MakingProgress",
   CellID->806972922],
  Cell[13299, 353, 218, 8, 70, "Text",
   CellTags->"MakingProgress",
   CellID->171008067],
  Cell[13520, 363, 429, 12, 70, "Text",
   CellTags->"MakingProgress",
   CellID->284715506],
  Cell[13952, 377, 1275, 35, 70, "Input",
   CellTags->"MakingProgress",
   CellID->297596541],
  Cell[15230, 414, 245, 9, 70, "Text",
   CellTags->"MakingProgress",
   CellID->706083507],
  Cell[15478, 425, 1613, 42, 70, "Input",
   CellTags->"MakingProgress",
   CellID->389481447],
  Cell[17094, 469, 575, 17, 70, "Text",
   CellTags->"MakingProgress",
   CellID->324832665],
  Cell[18158, 508, 108, 3, 70, "Input",
   CellTags->"MakingProgress",
   CellID->89790354],
  Cell[18269, 513, 522, 10, 70, "Message",
   CellTags->"MakingProgress",
   CellID->211726448],
  Cell[18806, 526, 263, 7, 70, "Text",
   CellTags->"MakingProgress",
   CellID->64859110],
  Cell[19648, 558, 109, 3, 70, "Input",
   CellTags->"MakingProgress",
   CellID->205851099],
  Cell[19760, 563, 521, 10, 70, "Message",
   CellTags->"MakingProgress",
   CellID->11157420],
  Cell[20330, 579, 123, 2, 70, "SubsubsectionOpener",
   CellTags->"MakingProgress",
   CellID->249281981],
  Cell[20456, 583, 533, 12, 70, "Text",
   CellTags->"MakingProgress",
   CellID->383667452],
  Cell[20992, 597, 366, 10, 70, "Text",
   CellTags->"MakingProgress",
   CellID->33226825],
  Cell[21361, 609, 325, 7, 70, "Text",
   CellTags->"MakingProgress",
   CellID->3943695],
  Cell[21689, 618, 255, 8, 70, "Input",
   CellTags->"MakingProgress",
   CellID->272995031],
  Cell[21947, 628, 256, 10, 70, "Text",
   CellTags->"MakingProgress",
   CellID->74715480],
  Cell[22670, 658, 142, 4, 70, "Input",
   CellTags->"MakingProgress",
   CellID->374286817],
  Cell[22849, 667, 123, 2, 70, "SubsubsectionOpener",
   CellTags->"MakingProgress",
   CellID->117709487],
  Cell[22975, 671, 845, 23, 70, "Text",
   CellTags->"MakingProgress",
   CellID->391194381],
  Cell[23823, 696, 581, 24, 70, "Text",
   CellTags->"MakingProgress",
   CellID->276867605],
  Cell[24407, 722, 298, 8, 70, "Text",
   CellTags->"MakingProgress",
   CellID->435614941],
  Cell[24708, 732, 570, 15, 70, "Input",
   CellTags->"MakingProgress",
   CellID->131701709],
  Cell[25281, 749, 257, 10, 70, "Text",
   CellTags->"MakingProgress",
   CellID->805228188],
  Cell[26122, 784, 142, 4, 70, "Input",
   CellTags->"MakingProgress",
   CellID->114562288],
  Cell[26267, 790, 521, 10, 70, "Message",
   CellTags->"MakingProgress",
   CellID->36159848]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"MakingProgress", 28437, 846}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 142, 7, 70, "Title",
 CellID->554471618],
Cell[876, 38, 36, 1, 70, "Text",
 CellID->208224786],
Cell[915, 41, 5985, 100, 70, "Graphics",
 CellID->97074467],
Cell[CellGroupData[{
Cell[6925, 145, 52, 1, 70, "SubsectionOpener",
 CellID->827429082],
Cell[6980, 148, 166, 5, 70, "Input",
 InitializationCell->True,
 CellID->88933248]
}, Closed]],
Cell[CellGroupData[{
Cell[7183, 158, 45, 1, 70, "Section",
 CellID->52467304],
Cell[7231, 161, 199, 5, 70, "Text",
 CellID->124911694],
Cell[CellGroupData[{
Cell[7455, 170, 130, 3, 70, "Subsection",
 CellTags->"MakingProgress",
 CellID->1128676],
Cell[7588, 175, 212, 7, 70, "Text",
 CellTags->"MakingProgress",
 CellID->291029362],
Cell[7803, 184, 2605, 64, 70, "Input",
 CellTags->"MakingProgress",
 CellID->390785113],
Cell[10411, 250, 212, 5, 70, "Text",
 CellTags->"MakingProgress",
 CellID->56086954],
Cell[CellGroupData[{
Cell[10648, 259, 192, 6, 70, "Input",
 CellTags->"MakingProgress",
 CellID->3451810],
Cell[10843, 267, 307, 8, 70, "Output",
 CellTags->"MakingProgress",
 CellID->79598776]
}, Open  ]],
Cell[11165, 278, 273, 6, 70, "Text",
 CellTags->"MakingProgress",
 CellID->200573530],
Cell[11441, 286, 314, 10, 70, "Input",
 CellTags->"MakingProgress",
 CellID->608635928],
Cell[11758, 298, 332, 10, 70, "Input",
 CellTags->"MakingProgress",
 CellID->573145836],
Cell[12093, 310, 331, 10, 70, "Input",
 CellTags->"MakingProgress",
 CellID->649945521],
Cell[12427, 322, 198, 6, 70, "Text",
 CellTags->"MakingProgress",
 CellID->745821889],
Cell[12628, 330, 186, 6, 70, "Input",
 CellTags->"MakingProgress",
 CellID->129514889],
Cell[12817, 338, 332, 7, 70, "Text",
 CellTags->"MakingProgress",
 CellID->123934458],
Cell[CellGroupData[{
Cell[13174, 349, 122, 2, 70, "SubsubsectionOpener",
 CellTags->"MakingProgress",
 CellID->806972922],
Cell[13299, 353, 218, 8, 70, "Text",
 CellTags->"MakingProgress",
 CellID->171008067],
Cell[13520, 363, 429, 12, 70, "Text",
 CellTags->"MakingProgress",
 CellID->284715506],
Cell[13952, 377, 1275, 35, 70, "Input",
 CellTags->"MakingProgress",
 CellID->297596541],
Cell[15230, 414, 245, 9, 70, "Text",
 CellTags->"MakingProgress",
 CellID->706083507],
Cell[15478, 425, 1613, 42, 70, "Input",
 CellTags->"MakingProgress",
 CellID->389481447],
Cell[17094, 469, 575, 17, 70, "Text",
 CellTags->"MakingProgress",
 CellID->324832665],
Cell[CellGroupData[{
Cell[17694, 490, 145, 4, 70, "Input",
 CellID->138770893],
Cell[17842, 496, 279, 7, 70, "Output",
 CellID->145107978]
}, Open  ]],
Cell[CellGroupData[{
Cell[18158, 508, 108, 3, 70, "Input",
 CellTags->"MakingProgress",
 CellID->89790354],
Cell[18269, 513, 522, 10, 70, "Message",
 CellTags->"MakingProgress",
 CellID->211726448]
}, Open  ]],
Cell[18806, 526, 263, 7, 70, "Text",
 CellTags->"MakingProgress",
 CellID->64859110],
Cell[CellGroupData[{
Cell[19094, 537, 237, 7, 70, "Input",
 CellID->314751404],
Cell[19334, 546, 277, 7, 70, "Output",
 CellID->352627647]
}, Open  ]],
Cell[CellGroupData[{
Cell[19648, 558, 109, 3, 70, "Input",
 CellTags->"MakingProgress",
 CellID->205851099],
Cell[19760, 563, 521, 10, 70, "Message",
 CellTags->"MakingProgress",
 CellID->11157420]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20330, 579, 123, 2, 70, "SubsubsectionOpener",
 CellTags->"MakingProgress",
 CellID->249281981],
Cell[20456, 583, 533, 12, 70, "Text",
 CellTags->"MakingProgress",
 CellID->383667452],
Cell[20992, 597, 366, 10, 70, "Text",
 CellTags->"MakingProgress",
 CellID->33226825],
Cell[21361, 609, 325, 7, 70, "Text",
 CellTags->"MakingProgress",
 CellID->3943695],
Cell[21689, 618, 255, 8, 70, "Input",
 CellTags->"MakingProgress",
 CellID->272995031],
Cell[21947, 628, 256, 10, 70, "Text",
 CellTags->"MakingProgress",
 CellID->74715480],
Cell[CellGroupData[{
Cell[22228, 642, 145, 4, 70, "Input",
 CellID->70838205],
Cell[22376, 648, 279, 7, 70, "Output",
 CellID->346651614]
}, Open  ]],
Cell[22670, 658, 142, 4, 70, "Input",
 CellTags->"MakingProgress",
 CellID->374286817]
}, Open  ]],
Cell[CellGroupData[{
Cell[22849, 667, 123, 2, 70, "SubsubsectionOpener",
 CellTags->"MakingProgress",
 CellID->117709487],
Cell[22975, 671, 845, 23, 70, "Text",
 CellTags->"MakingProgress",
 CellID->391194381],
Cell[23823, 696, 581, 24, 70, "Text",
 CellTags->"MakingProgress",
 CellID->276867605],
Cell[24407, 722, 298, 8, 70, "Text",
 CellTags->"MakingProgress",
 CellID->435614941],
Cell[24708, 732, 570, 15, 70, "Input",
 CellTags->"MakingProgress",
 CellID->131701709],
Cell[25281, 749, 257, 10, 70, "Text",
 CellTags->"MakingProgress",
 CellID->805228188],
Cell[CellGroupData[{
Cell[25563, 763, 240, 7, 70, "Input",
 CellID->374136624],
Cell[25806, 772, 279, 7, 70, "Output",
 CellID->515790468]
}, Open  ]],
Cell[CellGroupData[{
Cell[26122, 784, 142, 4, 70, "Input",
 CellTags->"MakingProgress",
 CellID->114562288],
Cell[26267, 790, 521, 10, 70, "Message",
 CellTags->"MakingProgress",
 CellID->36159848]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[26851, 807, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

