(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     82366,       1597]
NotebookOptionsPosition[     79543,       1508]
NotebookOutlinePosition[     81106,       1549]
CellTagsIndexPosition[     81063,       1546]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " Example: ",
 "PlotGroup"
}], "Title",
 CellID->554471618],

Cell["", "Text",
 CellID->653117532],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 ImageSize->{305, 360},
 CellID->270610215],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 CellID->89710034],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[1]:=",
 CellID->201670878],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PlotGroupDialog", "[", "]"}], ":=", 
   RowBox[{"GUIRunModal", "[", "\"\<Wolfram/Example/PlotGroup\>\"", "]"}]}], 
  ";"}]], "Input",
 CellContext->Notebook,
 InitializationCell->True,
 CellLabel->"In[2]:=",
 CellID->310912980],

Cell[CellGroupData[{

Cell["Definition", "SubsubsectionOpener",
 CellID->100788800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"def", " ", "=", " ", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"$Path", " ", "=", " ", "$GUIPath"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Get", "[", "\"\<Wolfram/Example/PlotGroup.m\>\"", "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->42794702],

Cell[BoxData[
 RowBox[{"Widget", "[", 
  RowBox[{"\<\"Panel\"\>", ",", 
   RowBox[{"WidgetGroup", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Label\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"f[x]: \"\>"}], ",", 
             RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
              RowBox[{"PropertyValue", "[", "\<\"Right\"\>", "]"}]}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"TextField\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Sin[x]\"\>"}], ",", 
             RowBox[{"BindEvent", "[", 
              RowBox[{"\<\"action\"\>", ",", 
               RowBox[{"Script", "[", 
                RowBox[{"updatePlot", "[", "]"}], "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"WidgetLayout", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Maximize", ",", "None"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"functionField\"\>"}]}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Label\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"x min: \"\>"}], ",", 
             RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
              RowBox[{"PropertyValue", "[", "\<\"Right\"\>", "]"}]}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"TextField\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"0\"\>"}], ",", 
             RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
              RowBox[{"PropertyValue", "[", "\<\"Right\"\>", "]"}]}], ",", 
             RowBox[{"BindEvent", "[", 
              RowBox[{"\<\"action\"\>", ",", 
               RowBox[{"Script", "[", 
                RowBox[{"updatePlot", "[", "]"}], "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"WidgetLayout", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Maximize", ",", "None"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"xminField\"\>"}]}], "]"}], ",", 
         RowBox[{"WidgetSpace", "[", "10", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Label\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"x max: \"\>"}], ",", 
             RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
              RowBox[{"PropertyValue", "[", "\<\"Right\"\>", "]"}]}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"TextField\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"2 Pi\"\>"}], ",", 
             RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
              RowBox[{"PropertyValue", "[", "\<\"Right\"\>", "]"}]}], ",", 
             RowBox[{"BindEvent", "[", 
              RowBox[{"\<\"action\"\>", ",", 
               RowBox[{"Script", "[", 
                RowBox[{"updatePlot", "[", "]"}], "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"WidgetLayout", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Maximize", ",", "None"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"xmaxField\"\>"}]}], "]"}]}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Label\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"Line: color: \"\>"}], 
             ",", 
             RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
              RowBox[{"PropertyValue", "[", "\<\"Right\"\>", "]"}]}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"ComboBox\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"items\"\>", "\[Rule]", 
              RowBox[{"{", 
               
               RowBox[{"\<\"Black\"\>", ",", "\<\"Red\"\>", 
                ",", "\<\"Green\"\>", ",", "\<\"Blue\"\>"}], "}"}]}], ",", 
             RowBox[{"\<\"editable\"\>", "\[Rule]", "False"}], ",", 
             RowBox[{"BindEvent", "[", 
              RowBox[{"\<\"action\"\>", ",", 
               RowBox[{"Script", "[", 
                RowBox[{"updatePlot", "[", "]"}], "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"WidgetLayout", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Maximize", ",", "None"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"colorName\"\>"}]}], "]"}], ",", 
         RowBox[{"WidgetSpace", "[", "10", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"Label\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"text\"\>", "\[Rule]", "\<\"style: \"\>"}], ",", 
             RowBox[{"\<\"horizontalAlignment\"\>", "\[Rule]", 
              RowBox[{"PropertyValue", "[", "\<\"Right\"\>", "]"}]}]}], 
            "}"}]}], "]"}], ",", 
         RowBox[{"WidgetAlign", "[", "]"}], ",", 
         RowBox[{"Widget", "[", 
          RowBox[{"\<\"ComboBox\"\>", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\<\"items\"\>", "\[Rule]", 
              RowBox[{"{", 
               
               RowBox[{"\<\"Solid Thin\"\>", ",", "\<\"Solid Thick\"\>", 
                ",", "\<\"Dashed\"\>"}], "}"}]}], ",", 
             RowBox[{"\<\"editable\"\>", "\[Rule]", "False"}], ",", 
             RowBox[{"BindEvent", "[", 
              RowBox[{"\<\"action\"\>", ",", 
               RowBox[{"Script", "[", 
                RowBox[{"updatePlot", "[", "]"}], "]"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"WidgetLayout", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Maximize", ",", "None"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Name", "\[Rule]", "\<\"lineStyleName\"\>"}]}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"Widget", "[", 
        RowBox[{"\<\"MathPanel\"\>", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\<\"preferredSize\"\>", "\[Rule]", 
            RowBox[{"Widget", "[", 
             RowBox[{"\<\"Dimension\"\>", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\<\"width\"\>", "\[Rule]", "150"}], ",", 
                RowBox[{"\<\"height\"\>", "\[Rule]", "150"}]}], "}"}]}], 
             "]"}]}], ",", 
           RowBox[{"\<\"usesFE\"\>", "\[Rule]", "True"}]}], "}"}], ",", 
         RowBox[{"WidgetLayout", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Maximize", ",", "Maximize"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"Name", "\[Rule]", "\<\"canvas\"\>"}]}], "]"}], ",", 
       RowBox[{"BindEvent", "[", 
        RowBox[{"\<\"componentResized\"\>", ",", 
         RowBox[{"Script", "[", 
          RowBox[{"updatePlot", "[", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"BindEvent", "[", 
        RowBox[{"\<\"endModal\"\>", ",", 
         RowBox[{"Script", "[", 
          RowBox[{"Show", "[", "expr", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"Script", "[", 
        RowBox[{
         RowBox[{"Needs", "[", "\<\"Graphics`Colors`\"\>", "]"}], ";"}], 
        "]"}], ",", 
       RowBox[{"Script", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"updatePlot", "[", "]"}], ":=", 
          RowBox[{"Block", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "functionExpr", ",", "xmin", ",", "xmax", ",", "col", ",", 
              "style", ",", 
              RowBox[{"$DisplayFunction", "=", "Identity"}]}], "}"}], ",", 
            RowBox[{
             RowBox[{"functionExpr", "=", 
              RowBox[{"ToExpression", "[", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"{", 
                 RowBox[{"\<\"functionField\"\>", ",", "\<\"text\"\>"}], 
                 "}"}], "]"}], "]"}]}], ";", 
             RowBox[{"xmin", "=", 
              RowBox[{"ToExpression", "[", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"{", 
                 RowBox[{"\<\"xminField\"\>", ",", "\<\"text\"\>"}], "}"}], 
                "]"}], "]"}]}], ";", 
             RowBox[{"xmax", "=", 
              RowBox[{"ToExpression", "[", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"{", 
                 RowBox[{"\<\"xmaxField\"\>", ",", "\<\"text\"\>"}], "}"}], 
                "]"}], "]"}]}], ";", 
             RowBox[{"col", "=", 
              RowBox[{"ToExpression", "[", 
               RowBox[{"PropertyValue", "[", 
                RowBox[{"{", 
                 RowBox[{"\<\"colorName\"\>", ",", "\<\"selectedItem\"\>"}], 
                 "}"}], "]"}], "]"}]}], ";", 
             RowBox[{"style", "=", 
              RowBox[{"PropertyValue", "[", 
               RowBox[{"{", 
                
                RowBox[{"\<\"lineStyleName\"\>", 
                 ",", "\<\"selectedItem\"\>"}], "}"}], "]"}]}], ";", 
             RowBox[{"Switch", "[", 
              RowBox[{"style", ",", "\n", "\<\"Solid Thick\"\>", ",", 
               RowBox[{"style", "=", 
                RowBox[{"{", 
                 RowBox[{"col", ",", 
                  RowBox[{"Thickness", "[", "0.02`", "]"}]}], "}"}]}], ",", 
               "\n", "\<\"Dashed\"\>", ",", 
               RowBox[{"style", "=", 
                RowBox[{"{", 
                 RowBox[{"col", ",", 
                  RowBox[{"Dashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"0.05`", ",", "0.05`"}], "}"}], "]"}]}], "}"}]}], 
               ",", "\n", "_", ",", 
               RowBox[{"style", "=", 
                RowBox[{"{", "col", "}"}]}]}], "]"}], ";", 
             RowBox[{"expr", "=", 
              RowBox[{"Show", "[", 
               RowBox[{
                RowBox[{"Plot", "[", 
                 RowBox[{"functionExpr", ",", 
                  RowBox[{"{", 
                   RowBox[{"x", ",", "xmin", ",", "xmax"}], "}"}], ",", 
                  RowBox[{"PlotStyle", "\[Rule]", "style"}]}], "]"}], ",", 
                RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";", 
             RowBox[{"SetPropertyValue", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\<\"canvas\"\>", ",", "\<\"mathCommand\"\>"}], "}"}],
                ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"expr", ",", "InputForm"}], "]"}]}], "]"}], ";", 
             RowBox[{"InvokeMethod", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"canvas\"\>", ",", "\<\"repaintNow\"\>"}], "}"}], 
              "]"}], ";"}]}], "]"}]}], ";", 
         RowBox[{"updatePlot", "[", "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"WidgetLayout", "\[Rule]", "Column"}]}], "]"}], ",", 
   RowBox[{"WidgetLayout", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Stretching\"\>", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}]}], "]"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->356569653]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellID->349400308],

Cell[TextData[{
 "This example demonstrates how to create a reusable ",
 StyleBox["GUIKit`", "Output"],
 " widget for wrapping ",
 StyleBox["Plot", "InlineCode"],
 " and some of its options."
}], "Text",
 CellID->33478473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlotGroupDialog", "[", "]"}]], "Input",
 CellContext->Notebook,
 CellLabel->"In[3]:=",
 CellID->123230267],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 1], Dashing[{0.05, 0.05}], LineBox[CompressedData["
1:eJwV13c8Ve8fAHB73XutjIhQ0iBpGJV8noyMqCSrjFRI00rRVyRJiEhIklSI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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[3]=",
 CellID->931292965]
}, Open  ]],

Cell[TextData[{
 "You can easily treat the ",
 StyleBox["PlotGroup", "InlineCode"],
 " example as a single reusable user interface element within other panels",
 " ",
 "and even use multiple instances."
}], "Text",
 CellID->90920067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\[IndentingNewLine]", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Panel\>\"", ",", " ", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<Label\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<text\>\"", "\[Rule]", "\"\<Multiple Plot \nsessions\>\""}], 
         "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Wolfram/Example/PlotGroup\>\"", ",", " ", 
          RowBox[{"ExposeWidgetReferences", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<canvas\>\"", "->", "\"\<canvas1\>\""}], "}"}]}]}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Wolfram/Example/PlotGroup\>\"", ",", 
          RowBox[{"ExposeWidgetReferences", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<canvas\>\"", "->", "\"\<canvas2\>\""}], "}"}]}]}], 
         "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"BindEvent", "[", 
       RowBox[{"\"\<endModal\>\"", ",", "\[IndentingNewLine]", 
        RowBox[{"Script", "[", " ", 
         RowBox[{"Show", "[", " ", 
          RowBox[{"GraphicsArray", "[", "\[IndentingNewLine]", " ", 
           RowBox[{"Partition", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"ToExpression", "[", 
                RowBox[{"PropertyValue", "[", 
                 RowBox[{"{", 
                  RowBox[{"#", ",", "\"\<mathCommand\>\""}], "}"}], "]"}], 
                "]"}], "&"}], " ", "/@", " ", "\[IndentingNewLine]", 
              RowBox[{"Select", "[", " ", 
               RowBox[{
                RowBox[{"\"\<WidgetNames\>\"", "/.", 
                 RowBox[{"GUIInformation", "[", "]"}]}], ",", " ", 
                RowBox[{
                 RowBox[{"StringMatchQ", "[", 
                  RowBox[{"#", ",", "\"\<canvas*\>\""}], "]"}], "&"}]}], 
               "]"}]}], ",", "\[IndentingNewLine]", "2"}], "]"}], "]"}], 
          "]"}], "  ", "]"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], 
   "]"}], "\[IndentingNewLine]", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->42868135],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, {}, 
       {RGBColor[0, 1, 0], LineBox[CompressedData["
1:eJwU23c8ld8fAHB7j2urUHy1kBWJ5BQSkl0kKVmFskdo2bOIUKGS2UKIVM6R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         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->All,
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {192., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}], InsetBox[
     GraphicsBox[{{}, {}, 
       {RGBColor[1, 0, 0], Dashing[{0.05, 0.05}], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->All,
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], {576., -116.80842387373012`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.49223594996212`}]}, {{}, 
    StyleBox[{{}, {}, {}, {{}, {}}, {{}, {}}},
     Antialiasing->False]}},
  PlotRange->{{0, 768.}, {0, -233.61684774746024`}},
  PlotRangePadding->{5, 5}]], "Output",
 CellLabel->"Out[4]=",
 CellID->469985557]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIKit Example: PlotGroup - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 29.9582282}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "This example demonstrates how to create a reusable GUIKit` widget for \
wrapping Plot and some of its options. You can easily treat the PlotGroup \
example as a single reusable user interface element within other panels and \
even use multiple instances.", "synonyms" -> {}, "title" -> 
    "GUIKit Example: PlotGroup", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/PlotGroup"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 120, 6, 70, "Title",
 CellID->554471618],
Cell[854, 37, 36, 1, 70, "Text",
 CellID->653117532],
Cell[893, 40, 8739, 145, 70, "Graphics",
 CellID->270610215],
Cell[CellGroupData[{
Cell[9657, 189, 51, 1, 70, "SubsectionOpener",
 CellID->89710034],
Cell[9711, 192, 166, 5, 70, "Input",
 InitializationCell->True,
 CellID->201670878],
Cell[9880, 199, 274, 9, 70, "Input",
 InitializationCell->True,
 CellID->310912980],
Cell[CellGroupData[{
Cell[10179, 212, 61, 1, 70, "SubsubsectionOpener",
 CellID->100788800],
Cell[CellGroupData[{
Cell[10265, 217, 329, 10, 70, "Input",
 CellID->42794702],
Cell[10597, 229, 12028, 275, 70, "Output",
 CellID->356569653]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22686, 511, 46, 1, 70, "Section",
 CellID->349400308],
Cell[22735, 514, 222, 7, 70, "Text",
 CellID->33478473],
Cell[CellGroupData[{
Cell[22982, 525, 130, 4, 70, "Input",
 CellID->123230267],
Cell[23115, 531, 8768, 151, 70, "Output",
 CellID->931292965]
}, Open  ]],
Cell[31898, 685, 233, 7, 70, "Text",
 CellID->90920067],
Cell[CellGroupData[{
Cell[32156, 696, 2273, 51, 70, "Input",
 CellID->42868135],
Cell[34432, 749, 45045, 752, 70, "Output",
 CellID->469985557]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[79516, 1506, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

