(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10604,        354]
NotebookOptionsPosition[      6295,        222]
NotebookOutlinePosition[      9496,        310]
CellTagsIndexPosition[      9425,        305]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Resolving Arbitrary Objects", "Title",
 CellTags->"Resolving",
 CellID->58020245],

Cell[TextData[{
 "Even though the ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " widget expression was designed with user interface issues in mind, you can \
construct object trees unrelated to user interface widgets and still take \
advantage of scripting with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code and setting and getting state through the use of properties."
}], "Text",
 CellTags->"Resolving",
 CellID->89091856],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GUIResolve",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIResolve"]], "InlineFormula"],
 " allows you to resolve definitions into their runtime Java objects, but not \
expose a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " runtime system or hold on to internal context state.",
 " ",
 "This is useful if the object definition simply resolves to a set of Java \
objects, which you can then use in other ways through standard ",
 StyleBox["J/Link ",
  FontSlant->"Italic"],
 "calls."
}], "Text",
 CellTags->"Resolving",
 CellID->53036366],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Resolving",
 CellLabel->"In[1]:=",
 CellID->202811026],

Cell[TextData[{
 "Notice in this example, a simple Java collections object is the root object \
in the expression though ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " script code is involved in populating the container with data."
}], "Text",
 CellTags->"Resolving",
 CellID->36166079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myList", "=", 
  RowBox[{"GUIResolve", "[", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<class:java.util.ArrayList\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"InvokeMethod", "[", 
        RowBox[{"\"\<addAll\>\"", ",", 
         RowBox[{"InvokeMethod", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<class:java.util.Arrays\>\"", ",", "\"\<asList\>\""}],
             "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Widget", "[", 
              RowBox[{"\"\<Label\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Label1\>\""}], "}"}], 
               ",", 
               RowBox[{"WidgetLayout", "\[Rule]", "None"}]}], "]"}], ",", 
             "\"\<string1\>\"", ",", "\"\<string2\>\"", ",", 
             RowBox[{"Widget", "[", 
              RowBox[{"\"\<Label\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Label2\>\""}], "}"}], 
               ",", 
               RowBox[{"WidgetLayout", "\[Rule]", "None"}]}], "]"}], ",", 
             RowBox[{"Widget", "[", "\"\<class:java.util.Date\>\"", "]"}]}], 
            "}"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"Script", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"InvokeMethod", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\"\<myList\>\"", ",", "\"\<add\>\""}], "}"}], ",", 
              "#1"}], "]"}], "&"}], ")"}], "/@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"10", "!"}], "]"}], ",", "34"}], "}"}]}], ";"}], "]"}]}],
       "}"}], ",", 
     RowBox[{"Name", "\[Rule]", "\"\<myList\>\""}]}], "]"}], "]"}]}]], "Input",\

 CellTags->"Resolving",
 CellLabel->"In[2]:=",
 CellID->284216062],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]JavaObject", "[", "\<\"java.util.ArrayList\"\>", "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject29175703060611073]], "Output",
 CellTags->"Resolving",
 CellLabel->"Out[2]=",
 CellID->775462158]
}, Open  ]],

Cell[TextData[{
 "Once a ",
 Cell[BoxData["JavaObject"], "InlineFormula"],
 " is resolved by the definition, you can continue to use ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " calls on the object instance."
}], "Text",
 CellTags->"Resolving",
 CellID->106135466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myList", " ", "@", " ", 
  RowBox[{"size", "[", "]"}]}]], "Input",
 CellTags->"Resolving",
 CellLabel->"In[3]:=",
 CellID->136627276],

Cell[BoxData["7"], "Output",
 CellTags->"Resolving",
 CellLabel->"Out[3]=",
 CellID->608561530]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"myList", " ", "@", " ", 
   RowBox[{"toString", "[", "]"}]}], " ", "//", " ", "InputForm"}]], "Input",
 CellTags->"Resolving",
 CellLabel->"In[4]:=",
 CellID->110871354],

Cell["\<\

\"[javax.swing.JLabel[,0,0,0x0,invalid,alignmentX=0.0,alignmentY=null,border=,\

flags=0,maximumSize=,minimu\\

mSize=,preferredSize=,defaultIcon=,disabledIcon=,horizontalAlignment=LEADING,
horizontalTextPosition=TRAI\\

LING,iconTextGap=4,labelFor=,text=Label1,verticalAlignment=CENTER,
verticalTextPosition=CENTER], string1, \\

string2, \\

javax.swing.JLabel[,0,0,0x0,invalid,alignmentX=0.0,alignmentY=null,border=,
flags=0,maximumSize=,minimumS\\

ize=,preferredSize=,defaultIcon=,disabledIcon=,horizontalAlignment=LEADING,
horizontalTextPosition=TRAILI\\

NG,iconTextGap=4,labelFor=,text=Label2,verticalAlignment=CENTER,
verticalTextPosition=CENTER], Mon Sep 01 \\

23:56:28 CDT 2003, 3628800, 34]\"
\
\>", "Output",
 CellTags->"Resolving",
 CellLabel->"Out[4]//InputForm=",
 CellID->59448277]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Resolving Arbitrary Objects - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 33.5830426}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "Even though the GUIKit widget expression was designed with user \
interface issues in mind, you can construct object trees unrelated to user \
interface widgets and still take advantage of scripting with Mathematica code \
and setting and getting state through the use of properties. GUIResolve \
allows you to resolve definitions into their runtime Java objects, but not \
expose a GUIObject runtime system or hold on to internal context state. This \
is useful if the object definition simply resolves to a set of Java objects, \
which you can then use in other ways through standard J/Link calls. Notice in \
this example, a simple Java collections object is the root object in the \
expression though Mathematica script code is involved in populating the \
container with data.", "synonyms" -> {}, "title" -> 
    "Resolving Arbitrary Objects", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/ResolvingArbitraryObjects"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Resolving"->{
  Cell[731, 29, 87, 2, 70, "Title",
   CellTags->"Resolving",
   CellID->58020245],
  Cell[821, 33, 441, 12, 70, "Text",
   CellTags->"Resolving",
   CellID->89091856],
  Cell[1265, 47, 682, 20, 70, "Text",
   CellTags->"Resolving",
   CellID->53036366],
  Cell[1950, 69, 157, 5, 70, "Input",
   CellTags->"Resolving",
   CellID->202811026],
  Cell[2110, 76, 294, 8, 70, "Text",
   CellTags->"Resolving",
   CellID->36166079],
  Cell[2429, 88, 1908, 50, 70, "Input",
   CellTags->"Resolving",
   CellID->284216062],
  Cell[4340, 140, 283, 9, 70, "Output",
   CellTags->"Resolving",
   CellID->775462158],
  Cell[4638, 152, 269, 9, 70, "Text",
   CellTags->"Resolving",
   CellID->106135466],
  Cell[4932, 165, 157, 5, 70, "Input",
   CellTags->"Resolving",
   CellID->136627276],
  Cell[5092, 172, 95, 3, 70, "Output",
   CellTags->"Resolving",
   CellID->608561530],
  Cell[5224, 180, 204, 6, 70, "Input",
   CellTags->"Resolving",
   CellID->110871354],
  Cell[5431, 188, 810, 28, 70, "Output",
   CellTags->"Resolving",
   CellID->59448277]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Resolving", 8356, 265}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 87, 2, 70, "Title",
 CellTags->"Resolving",
 CellID->58020245],
Cell[821, 33, 441, 12, 70, "Text",
 CellTags->"Resolving",
 CellID->89091856],
Cell[1265, 47, 682, 20, 70, "Text",
 CellTags->"Resolving",
 CellID->53036366],
Cell[1950, 69, 157, 5, 70, "Input",
 CellTags->"Resolving",
 CellID->202811026],
Cell[2110, 76, 294, 8, 70, "Text",
 CellTags->"Resolving",
 CellID->36166079],
Cell[CellGroupData[{
Cell[2429, 88, 1908, 50, 70, "Input",
 CellTags->"Resolving",
 CellID->284216062],
Cell[4340, 140, 283, 9, 70, "Output",
 CellTags->"Resolving",
 CellID->775462158]
}, Open  ]],
Cell[4638, 152, 269, 9, 70, "Text",
 CellTags->"Resolving",
 CellID->106135466],
Cell[CellGroupData[{
Cell[4932, 165, 157, 5, 70, "Input",
 CellTags->"Resolving",
 CellID->136627276],
Cell[5092, 172, 95, 3, 70, "Output",
 CellTags->"Resolving",
 CellID->608561530]
}, Open  ]],
Cell[CellGroupData[{
Cell[5224, 180, 204, 6, 70, "Input",
 CellTags->"Resolving",
 CellID->110871354],
Cell[5431, 188, 810, 28, 70, "Output",
 CellTags->"Resolving",
 CellID->59448277]
}, Open  ]]
}, Open  ]],
Cell[6268, 220, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

