(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28524,        649]
NotebookOptionsPosition[     24482,        509]
NotebookOutlinePosition[     27155,        594]
CellTagsIndexPosition[     27016,        587]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Dialog Style Samples", "Title",
 CellTags->"WidgetGalleryDialogs",
 CellID->422857646],

Cell[CellGroupData[{

Cell["Modal OK/Cancel Dialog", "Subsection",
 CellTags->"OKCancel",
 CellID->209678753],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"OKCancel",
 CellLabel->"In[1]:=",
 CellID->32418380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"WidgetGroup", "[", 
        RowBox[{
         RowBox[{"{", " ", "\[IndentingNewLine]", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Panel\>\"", ",", " ", 
            RowBox[{"WidgetLayout", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<Stretching\>\"", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"Maximize", ",", " ", "Maximize"}], "}"}]}], " ", 
              "}"}]}]}], "]"}], "\[IndentingNewLine]", " ", "}"}], ",", " ", 
         RowBox[{"WidgetLayout", "\[Rule]", 
          RowBox[{"{", " ", 
           RowBox[{"\"\<Border\>\"", "->", "\"\<Content\>\""}], " ", 
           "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"WidgetFill", "[", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<OK\>\""}], "}"}]}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Cancel\>\""}], "}"}]}], 
          "]"}]}], "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", 
      "}"}]}], "]"}], " ", "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"OKCancel",
 CellLabel->"In[2]:=",
 CellID->104209965],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject261847160717313, 
   JLink`Objects`JavaObject166510026817537]]], "Output",
 CellTags->"OKCancel",
 CellLabel->"Out[2]=",
 CellID->19887119]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"OKCancel",
 CellLabel->"In[3]:=",
 CellID->46196818],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{124, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"OKCancel",
 CellLabel->"Out[3]=",
 CellID->44062898]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input-Header, Output-Body", "Subsection",
 CellTags->"HeaderBody",
 CellID->621009640],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"HeaderBody",
 CellLabel->"In[1]:=",
 CellID->146803693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", " ", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Label\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<File\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<TextField\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<columns\>\"", "\[Rule]", "10"}], "}"}]}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Select\>\""}], "}"}]}], 
          "]"}]}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Label\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Display File\>\""}], 
          "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<TextArea\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<File contents here.\>\""}], 
          "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], "]"}], " ", 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"HeaderBody",
 CellLabel->"In[2]:=",
 CellID->412177497],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject176925003743233, 
   JLink`Objects`JavaObject292309350481921]]], "Output",
 CellTags->"HeaderBody",
 CellLabel->"Out[2]=",
 CellID->224229201]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"HeaderBody",
 CellLabel->"In[3]:=",
 CellID->246919262],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{184, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"HeaderBody",
 CellLabel->"Out[3]=",
 CellID->160457930]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dialog Style Samples - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 34.2861316}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "", "synonyms" -> {}, "title" -> "Dialog Style Samples", 
    "type" -> "Tutorial", "uri" -> "GUIKit/tutorial/SampleDialogStyles"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "WidgetGalleryDialogs"->{
  Cell[731, 29, 92, 2, 70, "Title",
   CellTags->"WidgetGalleryDialogs",
   CellID->422857646]},
 "OKCancel"->{
  Cell[848, 35, 87, 2, 70, "Subsection",
   CellTags->"OKCancel",
   CellID->209678753],
  Cell[938, 39, 155, 5, 70, "Input",
   CellTags->"OKCancel",
   CellID->32418380],
  Cell[1118, 48, 1651, 38, 70, "Input",
   CellTags->"OKCancel",
   CellID->104209965],
  Cell[2772, 88, 292, 8, 70, "Output",
   CellTags->"OKCancel",
   CellID->19887119],
  Cell[3101, 101, 133, 4, 70, "Input",
   CellTags->"OKCancel",
   CellID->46196818],
  Cell[3237, 107, 9493, 160, 70, "Output",
   Evaluatable->False,
   CellTags->"OKCancel",
   CellID->44062898]},
 "HeaderBody"->{
  Cell[12779, 273, 92, 2, 70, "Subsection",
   CellTags->"HeaderBody",
   CellID->621009640],
  Cell[12874, 277, 158, 5, 70, "Input",
   CellTags->"HeaderBody",
   CellID->146803693],
  Cell[13057, 286, 1551, 37, 70, "Input",
   CellTags->"HeaderBody",
   CellID->412177497],
  Cell[14611, 325, 295, 8, 70, "Output",
   CellTags->"HeaderBody",
   CellID->224229201],
  Cell[14943, 338, 136, 4, 70, "Input",
   CellTags->"HeaderBody",
   CellID->246919262],
  Cell[15082, 344, 9334, 158, 70, "Output",
   Evaluatable->False,
   CellTags->"HeaderBody",
   CellID->160457930]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"WidgetGalleryDialogs", 25742, 540},
 {"OKCancel", 25854, 544},
 {"HeaderBody", 26418, 564}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 92, 2, 70, "Title",
 CellTags->"WidgetGalleryDialogs",
 CellID->422857646],
Cell[CellGroupData[{
Cell[848, 35, 87, 2, 70, "Subsection",
 CellTags->"OKCancel",
 CellID->209678753],
Cell[938, 39, 155, 5, 70, "Input",
 CellTags->"OKCancel",
 CellID->32418380],
Cell[CellGroupData[{
Cell[1118, 48, 1651, 38, 70, "Input",
 CellTags->"OKCancel",
 CellID->104209965],
Cell[2772, 88, 292, 8, 70, "Output",
 CellTags->"OKCancel",
 CellID->19887119]
}, Open  ]],
Cell[CellGroupData[{
Cell[3101, 101, 133, 4, 70, "Input",
 CellTags->"OKCancel",
 CellID->46196818],
Cell[3237, 107, 9493, 160, 70, "Output",
 Evaluatable->False,
 CellTags->"OKCancel",
 CellID->44062898]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12779, 273, 92, 2, 70, "Subsection",
 CellTags->"HeaderBody",
 CellID->621009640],
Cell[12874, 277, 158, 5, 70, "Input",
 CellTags->"HeaderBody",
 CellID->146803693],
Cell[CellGroupData[{
Cell[13057, 286, 1551, 37, 70, "Input",
 CellTags->"HeaderBody",
 CellID->412177497],
Cell[14611, 325, 295, 8, 70, "Output",
 CellTags->"HeaderBody",
 CellID->224229201]
}, Open  ]],
Cell[CellGroupData[{
Cell[14943, 338, 136, 4, 70, "Input",
 CellTags->"HeaderBody",
 CellID->246919262],
Cell[15082, 344, 9334, 158, 70, "Output",
 Evaluatable->False,
 CellTags->"HeaderBody",
 CellID->160457930]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[24455, 507, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

