(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33724,       1103]
NotebookOptionsPosition[     23522,        783]
NotebookOutlinePosition[     29735,        959]
CellTagsIndexPosition[     29625,        953]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Scoping", "Title",
 CellID->509267359],

Cell[CellGroupData[{

Cell["Scoping of Widget References", "Section",
 CellTags->"ScopingWidgets",
 CellID->478066400],

Cell["\<\
Widgets created within a user interface definition can be named and \
registered in an object registry for easy lookup reference by script code and \
other widgets. Complete interface definitions can also be reused within other \
definitions and the issue of scoping access to widget references arises. Here \
are two design issues to keep in mind when working with widget references.\
\>", "Text",
 CellTags->"ScopingWidgets",
 CellID->489839399],

Cell[TextData[{
 "By default, widget references are scoped by a single interface definition \
expression or file. All widget references are accessible across all ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", "]"}]], "InlineFormula"],
 " blocks and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WidgetReference",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetReference"], "[", "]"}]], 
  "InlineFormula"],
 " requests within a single definition."
}], "BulletedText",
 CellTags->"ScopingWidgets",
 CellID->215701279],

Cell[TextData[{
 "When another interface definition is loaded using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"path\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " by a wrapping definition, only the outermost root widget is exposed by \
default and can be named within the wrapping definition using the option",
 " ",
 Cell[BoxData[
  RowBox[{"Name", "->", "\"\<\!\(\*
StyleBox[\"myName\", \"TI\"]\)\>\""}]], "InlineFormula"],
 ". ",
 StyleBox["If it is desired that other widgets be exposed from within this \
external definition, you can use the option ", "Text"],
 Cell[BoxData[
  RowBox[{"ExposeWidgetReferences", "->", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"name1\", \"TI\"]\)\>\"", ",", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"name2\", \"TI\"]\)\>\"", "->", "\"\<\!\(\*
StyleBox[\"newName2\", \"TI\"]\)\>\""}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 StyleBox[" to include named access to other widgets inside the child \
definition.", "Text"]
}], "BulletedText",
 CellTags->"ScopingWidgets",
 CellID->169583645]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scoping of Scripts", "Section",
 CellTags->"ScopingScripts",
 CellID->335606158],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " blocks are typically used within interface definitions to define ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programming functions, dynamically change the state of interface widgets, \
and to bind events from widgets into calls to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions.",
 " ",
 "Since this involves the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel and multiple interface definitions with their own script code \
running at the same time, the question of script code scoping and their use \
of kernel contexts arises. Here are several design issues to keep in mind \
when developing ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " code blocks."
}], "Text",
 CellTags->"ScopingScripts",
 CellID->960060221],

Cell[TextData[{
 "All ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", "]"}]], "InlineFormula"],
 " blocks are scoped by a single interface definition expression or file. A \
new private kernel context is created for each instance of an interface \
definition and all ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", "]"}]], "InlineFormula"],
 " blocks are evaluated within this new context. Even when ",
 Cell[BoxData[
  ButtonBox["BindEvent",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/BindEvent"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " blocks are subsequently called when the interface is live, this same \
private context is set while the script code is executing, thus also making \
available any functions defined by other top-level ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", "]"}]], "InlineFormula"],
 " blocks defined when the interface definition was first loaded. This is \
quite similar to the loading of JavaScript code in HTML pages. This private \
new context for each instance of a definition also allows you to use global \
variables within your scripts without worrying about them being overwritten \
by other definitions."
}], "BulletedText",
 CellTags->"ScopingScripts",
 CellID->17275438],

Cell[TextData[{
 "When another interface definition is accessed using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"path\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " , it receives its own new internal kernel context to run its internal \
scripts in, so external definition ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " blocks will not by default share or have access to the parent or wrapping \
definition and the parent ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " code and function definitions."
}], "BulletedText",
 CellTags->"ScopingScripts",
 CellID->441243664],

Cell[TextData[{
 "The use of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"ScriptSource", "->", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).m\>\""}]}], "]"}]], "InlineFormula"],
 " to break out large script code blocks will still use the same shared \
kernel context with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", "]"}]], "InlineFormula"],
 " blocks that explicitly contain the code in the definition, as this form of \
",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " does not qualify as another separate external definition. "
}], "BulletedText",
 CellTags->"ScopingScripts",
 CellID->46115574],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " is initially defined to ",
 StyleBox["{\"GUIKit`\", \"JLink`\", \"System`\"}", "MR"],
 " for each new interface definition instance and is reset to the external \
global ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " when exiting a ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " call. This means that you must explicitly call ",
 Cell[BoxData[
  ButtonBox["Needs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Needs"]], "InlineFormula"],
 " on any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages that are used by our scripts. Since a unique ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " is maintained for scripts inside each user interface instance, ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " definitions will also not expose their use of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages to the global ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ", preventing the potential symbol shadowing by multiple packages using the \
same symbol names."
}], "BulletedText",
 CellTags->"ScopingScripts",
 CellID->595906753],

Cell[TextData[{
 "You can still use explicit contexted symbol and function calls to access \
shared kernel code. In certain cases, during development or for interactive \
notebook work, it may be more desirable to allow the scripts of a ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " user interface definition to access shared ",
 StyleBox["Global`", "MR"],
 " contexted symbols and functions, though this may break the ability of this \
definition to work when multiple instances of it are active at the same time. \
",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GUIRunModal",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRunModal"]], "InlineFormula"],
 ", and similar functions support the ",
 StyleBox["IncludedScriptContexts", "MR"],
 " option for specifying a list of additional contexts that should be \
included on a user interface's scripts ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 "."
}], "BulletedText",
 CellTags->"ScopingScripts",
 CellID->268908679],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 " so code blocks will not automatically evaluate their code.",
 " ",
 "If you are interactively building up an interface definition in a notebook, \
you may notice some of the ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " functions showing up in the ",
 Cell[BoxData["Global`"], "InlineFormula"],
 " context while working with the expressions, but at runtime the definition \
and scripts will still get defined within a new private context when the \
interface is live."
}], "BulletedText",
 CellTags->"ScopingScripts",
 CellID->5372085],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"ScopingScripts",
 CellLabel->"In[1]:=",
 CellID->316966492],

Cell[TextData[{
 "Here are a few examples that demonstrate the nature of ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 "'s ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " context and ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " management."
}], "Text",
 CellTags->"ScopingScripts",
 CellID->436826957],

Cell[TextData[{
 "Here you can show the default global ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " state."
}], "Text",
 CellTags->"ScopingScripts",
 CellID->391167044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"$Context", ",", " ", "$ContextPath"}], "}"}]], "Input",
 CellTags->"ScopingScripts",
 CellLabel->"In[2]:=",
 CellID->8039969],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Global`\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"GUIKit`\"\>", ",", "\<\"JLink`\"\>", ",", "\<\"Global`\"\>", 
     ",", "\<\"System`\"\>"}], "}"}]}], "}"}]], "Output",
 CellTags->"ScopingScripts",
 CellLabel->"Out[2]=",
 CellID->254758538]
}, Open  ]],

Cell[TextData[{
 "Here you run a ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " definition which shows its ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " state and prints these values each time you click its button."
}], "Text",
 CellTags->"ScopingScripts",
 CellID->225003400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Button\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Print\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"BindEvent", "[", 
       RowBox[{"\"\<action\>\"", ",", 
        RowBox[{"Script", "[", 
         RowBox[{"printContextInfo", "[", "]"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Script", "[", " ", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"printContextInfo", "[", "]"}], ":=", 
         RowBox[{"Print", "[", 
          RowBox[{"{", 
           RowBox[{"$Context", ",", " ", "$ContextPath"}], "}"}], " ", 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"printContextInfo", "[", "]"}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellTags->"ScopingScripts",
 CellLabel->"In[3]:=",
 CellID->38635903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"GUIKit`Private`Script1`\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"GUIKit`\"\>", ",", "\<\"JLink`\"\>", 
     ",", "\<\"System`\"\>"}], "}"}]}], "}"}]], "Print",
 CellTags->"ScopingScripts",
 CellLabel->"From In[3]:=",
 CellID->464553527],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject119499244175361, 
   JLink`Objects`JavaObject245809316626433]]], "Output",
 CellTags->"ScopingScripts",
 CellLabel->"Out[3]=",
 CellID->403104896]
}, Open  ]],

Cell[TextData[{
 "Now load a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package which updates the global ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 StyleBox[".", "MR"]
}], "Text",
 CellTags->"ScopingScripts",
 CellID->416161301],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<Graphics`FilledPlot`\>\"", "]"}], 
  ";"}], "\n", "$ContextPath"}], "Input",
 CellTags->"ScopingScripts",
 CellLabel->"In[4]:=",
 CellID->33570780],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Graphics`FilledPlot`\"\>", 
   ",", "\<\"Utilities`FilterOptions`\"\>", ",", "\<\"GUIKit`\"\>", 
   ",", "\<\"JLink`\"\>", ",", "\<\"Global`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",
 CellTags->"ScopingScripts",
 CellLabel->"Out[5]=",
 CellID->54821130]
}, Open  ]],

Cell[TextData[{
 "Notice that if you run a new definition, the definition's ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " does not include the externally loaded ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package, and conversely, if you call ",
 Cell[BoxData[
  ButtonBox["Needs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Needs"]], "InlineFormula"],
 " on a package internal to the ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " block of the ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " definition, it does not change the global ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"ScopingScripts",
 CellID->11404020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Button\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Print\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Script", "[", " ", 
       RowBox[{
        RowBox[{"Needs", "[", "\"\<Graphics`Colors`\>\"", "]"}], ";"}], "]"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"BindEvent", "[", 
       RowBox[{"\"\<action\>\"", ",", 
        RowBox[{"Script", "[", 
         RowBox[{"printContextInfo", "[", "]"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Script", "[", " ", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"printContextInfo", "[", "]"}], ":=", 
         RowBox[{"Print", "[", 
          RowBox[{"{", 
           RowBox[{"$Context", ",", " ", "$ContextPath"}], "}"}], " ", 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"printContextInfo", "[", "]"}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellTags->"ScopingScripts",
 CellLabel->"In[6]:=",
 CellID->11078655],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"GUIKit`Private`Script2`\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Graphics`Colors`\"\>", ",", "\<\"GUIKit`\"\>", 
     ",", "\<\"JLink`\"\>", ",", "\<\"System`\"\>"}], "}"}]}], "}"}]], "Print",\

 CellTags->"ScopingScripts",
 CellLabel->"From In[6]:=",
 CellID->103407692],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject296151920148481, 
   JLink`Objects`JavaObject8990289297409]]], "Output",
 CellTags->"ScopingScripts",
 CellLabel->"Out[6]=",
 CellID->593473681]
}, Open  ]],

Cell[TextData[{
 "Here you see that the external ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " is unaffected by the ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 "'s ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " block loading of packages."
}], "Text",
 CellTags->"ScopingScripts",
 CellID->244064488],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellTags->"ScopingScripts",
 CellLabel->"In[7]:=",
 CellID->203577932],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Graphics`FilledPlot`\"\>", 
   ",", "\<\"Utilities`FilterOptions`\"\>", ",", "\<\"GUIKit`\"\>", 
   ",", "\<\"JLink`\"\>", ",", "\<\"Global`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",
 CellTags->"ScopingScripts",
 CellLabel->"Out[7]=",
 CellID->725185786]
}, Open  ]],

Cell[TextData[{
 "Because ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " definitions use their own private ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 " by default, access to globally stored symbols or functions are not visible \
within ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " code."
}], "Text",
 CellTags->"ScopingScripts",
 CellID->63528932],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", " ", "7"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "y_", "]"}], ":=", " ", 
   RowBox[{"y", "^", "3"}]}], ";"}]}], "Input",
 CellTags->"ScopingScripts",
 CellLabel->"In[8]:=",
 CellID->307208287],

Cell["\<\
Here you see that the user interface does not see globally defined symbols \
and functions by default.\
\>", "Text",
 CellTags->"ScopingScripts",
 CellID->54225410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Button\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Print\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"BindEvent", "[", 
       RowBox[{"\"\<action\>\"", ",", 
        RowBox[{"Script", "[", " ", 
         RowBox[{"Print", "[", 
          RowBox[{"f", "[", "x", "]"}], "]"}], "]"}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellTags->"ScopingScripts",
 CellLabel->"In[10]:=",
 CellID->15072147],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject66194757386241, 
   JLink`Objects`JavaObject22567402340353]]], "Output",
 CellTags->"ScopingScripts",
 CellLabel->"Out[10]=",
 CellID->312413758],

Cell[BoxData[
 RowBox[{"f", "[", "x", "]"}]], "Print",
 CellTags->"ScopingScripts",
 CellID->370283946]
}, Open  ]],

Cell[TextData[{
 "If you were instead to use the ",
 StyleBox["IncludedScriptContexts", "MR"],
 " option of ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " to include the ",
 StyleBox["\"Global`\"", "MR"],
 " context as a visible context for the user interface, then the ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " blocks would see these externally defined symbols."
}], "Text",
 CellTags->"ScopingScripts",
 CellID->410870633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Button\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Print\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"BindEvent", "[", 
        RowBox[{"\"\<action\>\"", ",", 
         RowBox[{"Script", "[", " ", 
          RowBox[{"Print", "[", 
           RowBox[{"f", "[", "x", "]"}], "]"}], "]"}]}], "]"}]}], 
      "\[IndentingNewLine]", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"IncludedScriptContexts", " ", "->", " ", 
    RowBox[{"{", "$Context", "}"}]}]}], "\[IndentingNewLine]", "]"}]], "Input",\

 CellTags->"ScopingScripts",
 CellLabel->"In[11]:=",
 CellID->51070750],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject411664126050305, 
   JLink`Objects`JavaObject536599423090689]]], "Output",
 CellTags->"ScopingScripts",
 CellLabel->"Out[11]=",
 CellID->48998740]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Scoping - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 35.1610868}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "Widgets created within a user interface definition can be named and \
registered in an object registry for easy lookup reference by script code and \
other widgets. Complete interface definitions can also be reused within other \
definitions and the issue of scoping access to widget references arises. Here \
are two design issues to keep in mind when working with widget references. \
Script blocks are typically used within interface definitions to define \
Mathematica programming functions, dynamically change the state of interface \
widgets, and to bind events from widgets into calls to Mathematica functions. \
Since this involves the Mathematica kernel and multiple interface definitions \
with their own script code running at the same time, the question of script \
code scoping and their use of kernel contexts arises. Here are several design \
issues to keep in mind when developing Script code blocks. Here are a few \
examples that demonstrate the nature of GUIKit's Script context and \
$ContextPath management.", "synonyms" -> {}, "title" -> "Scoping", "type" -> 
    "Tutorial", "uri" -> "GUIKit/tutorial/Scoping"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ScopingWidgets"->{
  Cell[800, 34, 96, 2, 70, "Section",
   CellTags->"ScopingWidgets",
   CellID->478066400],
  Cell[899, 38, 457, 8, 70, "Text",
   CellTags->"ScopingWidgets",
   CellID->489839399],
  Cell[1359, 48, 608, 18, 70, "BulletedText",
   CellTags->"ScopingWidgets",
   CellID->215701279],
  Cell[1970, 68, 1289, 34, 70, "BulletedText",
   CellTags->"ScopingWidgets",
   CellID->169583645]},
 "ScopingScripts"->{
  Cell[3296, 107, 86, 2, 70, "Section",
   CellTags->"ScopingScripts",
   CellID->335606158],
  Cell[3385, 111, 981, 28, 70, "Text",
   CellTags->"ScopingScripts",
   CellID->960060221],
  Cell[4369, 141, 1567, 40, 70, "BulletedText",
   CellTags->"ScopingScripts",
   CellID->17275438],
  Cell[5939, 183, 958, 27, 70, "BulletedText",
   CellTags->"ScopingScripts",
   CellID->441243664],
  Cell[6900, 212, 890, 27, 70, "BulletedText",
   CellTags->"ScopingScripts",
   CellID->46115574],
  Cell[7793, 241, 1541, 46, 70, "BulletedText",
   CellTags->"ScopingScripts",
   CellID->595906753],
  Cell[9337, 289, 1183, 31, 70, "BulletedText",
   CellTags->"ScopingScripts",
   CellID->268908679],
  Cell[10545, 324, 900, 25, 70, "BulletedText",
   CellTags->"ScopingScripts",
   CellID->5372085],
  Cell[11448, 351, 162, 5, 70, "Input",
   CellTags->"ScopingScripts",
   CellID->316966492],
  Cell[11613, 358, 471, 17, 70, "Text",
   CellTags->"ScopingScripts",
   CellID->436826957],
  Cell[12087, 377, 385, 14, 70, "Text",
   CellTags->"ScopingScripts",
   CellID->391167044],
  Cell[12497, 395, 165, 5, 70, "Input",
   CellTags->"ScopingScripts",
   CellID->8039969],
  Cell[12665, 402, 289, 8, 70, "Output",
   CellTags->"ScopingScripts",
   CellID->254758538],
  Cell[12969, 413, 495, 17, 70, "Text",
   CellTags->"ScopingScripts",
   CellID->225003400],
  Cell[13489, 434, 996, 26, 70, "Input",
   CellTags->"ScopingScripts",
   CellID->38635903],
  Cell[14488, 462, 285, 8, 70, "Print",
   CellTags->"ScopingScripts",
   CellID->464553527],
  Cell[14776, 472, 292, 8, 70, "Output",
   CellTags->"ScopingScripts",
   CellID->403104896],
  Cell[15083, 483, 328, 12, 70, "Text",
   CellTags->"ScopingScripts",
   CellID->416161301],
  Cell[15436, 499, 201, 6, 70, "Input",
   CellTags->"ScopingScripts",
   CellID->33570780],
  Cell[15640, 507, 308, 8, 70, "Output",
   CellTags->"ScopingScripts",
   CellID->54821130],
  Cell[15963, 518, 915, 30, 70, "Text",
   CellTags->"ScopingScripts",
   CellID->11404020],
  Cell[16903, 552, 1162, 30, 70, "Input",
   CellTags->"ScopingScripts",
   CellID->11078655],
  Cell[18068, 584, 320, 9, 70, "Print",
   CellTags->"ScopingScripts",
   CellID->103407692],
  Cell[18391, 595, 290, 8, 70, "Output",
   CellTags->"ScopingScripts",
   CellID->593473681],
  Cell[18696, 606, 471, 17, 70, "Text",
   CellTags->"ScopingScripts",
   CellID->244064488],
  Cell[19192, 627, 110, 3, 70, "Input",
   CellTags->"ScopingScripts",
   CellID->203577932],
  Cell[19305, 632, 309, 8, 70, "Output",
   CellTags->"ScopingScripts",
   CellID->725185786],
  Cell[19629, 643, 650, 23, 70, "Text",
   CellTags->"ScopingScripts",
   CellID->63528932],
  Cell[20282, 668, 257, 9, 70, "Input",
   CellTags->"ScopingScripts",
   CellID->307208287],
  Cell[20542, 679, 174, 5, 70, "Text",
   CellTags->"ScopingScripts",
   CellID->54225410],
  Cell[20741, 688, 616, 17, 70, "Input",
   CellTags->"ScopingScripts",
   CellID->15072147],
  Cell[21360, 707, 291, 8, 70, "Output",
   CellTags->"ScopingScripts",
   CellID->312413758],
  Cell[21654, 717, 103, 3, 70, "Print",
   CellTags->"ScopingScripts",
   CellID->370283946],
  Cell[21772, 723, 591, 18, 70, "Text",
   CellTags->"ScopingScripts",
   CellID->410870633],
  Cell[22388, 745, 761, 20, 70, "Input",
   CellTags->"ScopingScripts",
   CellID->51070750],
  Cell[23152, 767, 292, 8, 70, "Output",
   CellTags->"ScopingScripts",
   CellID->48998740]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ScopingWidgets", 25772, 828},
 {"ScopingScripts", 26177, 841}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 44, 1, 70, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[800, 34, 96, 2, 70, "Section",
 CellTags->"ScopingWidgets",
 CellID->478066400],
Cell[899, 38, 457, 8, 70, "Text",
 CellTags->"ScopingWidgets",
 CellID->489839399],
Cell[1359, 48, 608, 18, 70, "BulletedText",
 CellTags->"ScopingWidgets",
 CellID->215701279],
Cell[1970, 68, 1289, 34, 70, "BulletedText",
 CellTags->"ScopingWidgets",
 CellID->169583645]
}, Open  ]],
Cell[CellGroupData[{
Cell[3296, 107, 86, 2, 70, "Section",
 CellTags->"ScopingScripts",
 CellID->335606158],
Cell[3385, 111, 981, 28, 70, "Text",
 CellTags->"ScopingScripts",
 CellID->960060221],
Cell[4369, 141, 1567, 40, 70, "BulletedText",
 CellTags->"ScopingScripts",
 CellID->17275438],
Cell[5939, 183, 958, 27, 70, "BulletedText",
 CellTags->"ScopingScripts",
 CellID->441243664],
Cell[6900, 212, 890, 27, 70, "BulletedText",
 CellTags->"ScopingScripts",
 CellID->46115574],
Cell[7793, 241, 1541, 46, 70, "BulletedText",
 CellTags->"ScopingScripts",
 CellID->595906753],
Cell[9337, 289, 1183, 31, 70, "BulletedText",
 CellTags->"ScopingScripts",
 CellID->268908679],
Cell[CellGroupData[{
Cell[10545, 324, 900, 25, 70, "BulletedText",
 CellTags->"ScopingScripts",
 CellID->5372085],
Cell[11448, 351, 162, 5, 70, "Input",
 CellTags->"ScopingScripts",
 CellID->316966492],
Cell[11613, 358, 471, 17, 70, "Text",
 CellTags->"ScopingScripts",
 CellID->436826957],
Cell[12087, 377, 385, 14, 70, "Text",
 CellTags->"ScopingScripts",
 CellID->391167044],
Cell[CellGroupData[{
Cell[12497, 395, 165, 5, 70, "Input",
 CellTags->"ScopingScripts",
 CellID->8039969],
Cell[12665, 402, 289, 8, 70, "Output",
 CellTags->"ScopingScripts",
 CellID->254758538]
}, Open  ]],
Cell[12969, 413, 495, 17, 70, "Text",
 CellTags->"ScopingScripts",
 CellID->225003400],
Cell[CellGroupData[{
Cell[13489, 434, 996, 26, 70, "Input",
 CellTags->"ScopingScripts",
 CellID->38635903],
Cell[14488, 462, 285, 8, 70, "Print",
 CellTags->"ScopingScripts",
 CellID->464553527],
Cell[14776, 472, 292, 8, 70, "Output",
 CellTags->"ScopingScripts",
 CellID->403104896]
}, Open  ]],
Cell[15083, 483, 328, 12, 70, "Text",
 CellTags->"ScopingScripts",
 CellID->416161301],
Cell[CellGroupData[{
Cell[15436, 499, 201, 6, 70, "Input",
 CellTags->"ScopingScripts",
 CellID->33570780],
Cell[15640, 507, 308, 8, 70, "Output",
 CellTags->"ScopingScripts",
 CellID->54821130]
}, Open  ]],
Cell[15963, 518, 915, 30, 70, "Text",
 CellTags->"ScopingScripts",
 CellID->11404020],
Cell[CellGroupData[{
Cell[16903, 552, 1162, 30, 70, "Input",
 CellTags->"ScopingScripts",
 CellID->11078655],
Cell[18068, 584, 320, 9, 70, "Print",
 CellTags->"ScopingScripts",
 CellID->103407692],
Cell[18391, 595, 290, 8, 70, "Output",
 CellTags->"ScopingScripts",
 CellID->593473681]
}, Open  ]],
Cell[18696, 606, 471, 17, 70, "Text",
 CellTags->"ScopingScripts",
 CellID->244064488],
Cell[CellGroupData[{
Cell[19192, 627, 110, 3, 70, "Input",
 CellTags->"ScopingScripts",
 CellID->203577932],
Cell[19305, 632, 309, 8, 70, "Output",
 CellTags->"ScopingScripts",
 CellID->725185786]
}, Open  ]],
Cell[19629, 643, 650, 23, 70, "Text",
 CellTags->"ScopingScripts",
 CellID->63528932],
Cell[20282, 668, 257, 9, 70, "Input",
 CellTags->"ScopingScripts",
 CellID->307208287],
Cell[20542, 679, 174, 5, 70, "Text",
 CellTags->"ScopingScripts",
 CellID->54225410],
Cell[CellGroupData[{
Cell[20741, 688, 616, 17, 70, "Input",
 CellTags->"ScopingScripts",
 CellID->15072147],
Cell[21360, 707, 291, 8, 70, "Output",
 CellTags->"ScopingScripts",
 CellID->312413758],
Cell[21654, 717, 103, 3, 70, "Print",
 CellTags->"ScopingScripts",
 CellID->370283946]
}, Open  ]],
Cell[21772, 723, 591, 18, 70, "Text",
 CellTags->"ScopingScripts",
 CellID->410870633],
Cell[CellGroupData[{
Cell[22388, 745, 761, 20, 70, "Input",
 CellTags->"ScopingScripts",
 CellID->51070750],
Cell[23152, 767, 292, 8, 70, "Output",
 CellTags->"ScopingScripts",
 CellID->48998740]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[23495, 781, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

