(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33486,        858]
NotebookOptionsPosition[     28060,        683]
NotebookOutlinePosition[     31795,        792]
CellTagsIndexPosition[     31725,        787]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Threads", "Title",
 CellTags->"Threads",
 CellID->51472476],

Cell[TextData[{
 "By default, any interface definition executes within a single thread, and \
since currently ",
 Cell[BoxData["GUIKit`"], "InlineFormula"],
 " definitions execute at runtime as Java components, this means that \
execution occurs in the single Java AWT event dispatch thread."
}], "Text",
 CellTags->"Threads",
 CellID->648831117],

Cell[TextData[{
 "In most cases, complete user interface dialogs or tools can run within a \
single Java thread, make synchronous requests to ",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " and never require any explicit threading code to handle how requests are \
processed. Also note that since the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel is not multithreaded, the only reason for attempting a \
multithreaded interface definition is to allow user interface updates to \
occur while a long calculation may be proceeding in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"Threads",
 CellID->26105955],

Cell["Consider, for example, the following definition.", "Text",
 CellTags->"Threads",
 CellID->446297019],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Threads",
 CellID->350525506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", " ", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", " ", 
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Button\>\"", ",", " ", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"\"\<text\>\"", "->", "\"\<Run\>\""}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"BindEvent", "[", 
            RowBox[{"\"\<action\>\"", ",", "\[IndentingNewLine]", 
             RowBox[{"Script", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"Do", "[", " ", "\[IndentingNewLine]", " ", 
                RowBox[{
                 RowBox[{"SetPropertyValue", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"\"\<label\>\"", ",", " ", "\"\<text\>\""}], 
                    "}"}], ",", " ", 
                   RowBox[{"\"\<Current value is \>\"", " ", "<>", " ", 
                    RowBox[{"ToString", "[", "i", "]"}]}]}], "]"}], ",", 
                 "\[IndentingNewLine]", " ", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "300", ",", "0", ",", 
                   RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"SetPropertyValue", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"\"\<label\>\"", ",", " ", "\"\<text\>\""}], "}"}], 
                 ",", " ", 
                 "\"\<Press the button to count from 300 to 0.\>\""}], "]"}], 
               ";"}], "\[IndentingNewLine]", "]"}]}], "]"}]}], 
          "\[IndentingNewLine]", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Label\>\"", ",", " ", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
          "\"\<text\>\"", " ", "\[Rule]", " ", 
           "\"\<Press the button to count from 300 to 0.\>\""}], 
          "\[IndentingNewLine]", "}"}], ",", " ", 
         RowBox[{"Name", "->", "\"\<label\>\""}]}], "]"}]}], 
      "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellTags->"Threads",
 CellID->8987385],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject21239468916737, 
   JLink`Objects`JavaObject70855786758145]]], "Output",
 CellTags->"Threads",
 CellID->60119462]
}, Open  ]],

Cell["Take a screen shot of what this definition renders.", "Text",
 CellTags->"Threads",
 CellID->505852412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", " ", "ref", "]"}]], "Input",
 CellTags->"Threads",
 CellID->10041527],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{199, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Threads",
 CellID->477551160]
}, Open  ]],

Cell[TextData[{
 "If you try running this example and pressing the button, you will not \
actually see the label's text update at all. Why is this? The reason is that \
the button's bind event is executing in the default single AWT thread, and \
while it is executing (during its action call), the user interface is busy \
while all the attempts at setting the label's text are occurring from the ",
 Cell[BoxData[
  ButtonBox["Script",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
 " code. The user interface thread is busy evaluating the button action call \
and is not receptive to any other requests to update the label's text and \
repaint the window. If you want to see the user interface update while a \
possibly long ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " calculation is going on, you would need to have the ",
 Cell[BoxData[
  ButtonBox["BindEvent",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/BindEvent"]], "InlineFormula"],
 " code execute in a new thread asynchronously, so that the user interface \
event dispatching thread is not busy and can take requests for updating other \
user interface widgets. However, there is an important subsequent requirement \
that needs to be satisfied. User interface widgets cannot be updated from \
calls in any other threads but the AWT event dispatching thread, so requests \
for updating widgets, such as through ",
 Cell[BoxData[
  ButtonBox["SetPropertyValue",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/SetPropertyValue"]], "InlineFormula"],
 ", must be made and queued for execution on the AWT event dispatching \
thread."
}], "Text",
 CellTags->"Threads",
 CellID->167275170],

Cell[TextData[{
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " attempts to simplify issues related to spawning execution in new separate \
threads and also makes sure certain executions happen on the AWT event \
dispatch thread when this is required. Many of the execution functions in ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 StyleBox[",", "MR"],
 " such as ",
 Cell[BoxData[
  ButtonBox["BindEvent",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/BindEvent"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SetPropertyValue",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/SetPropertyValue"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InvokeMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/InvokeMethod"], ","}]], "InlineFormula"],
 " take two optional options: ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InvokeThread",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/InvokeThread"], " ", "->", " ", 
   "\"\<Name\>\""}]], "InlineFormula"],
 ", which chooses which thread a snippet of code will execute in, and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InvokeWait",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/InvokeWait"], " ", "->", " ", 
   RowBox[{
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], " ", "|", " ", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], " ", "|", " ", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"]}]}]], "InlineFormula"],
 ", which determines whether the thread that initiates this new request, \
possibly in a different thread, will wait for the response from this new \
request to finish before continuing, or whether it ignores any response and \
immediately continues with its execution."
}], "Text",
 CellTags->"Threads",
 CellID->372457028],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InvokeThread",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/InvokeThread"]], "InlineFormula"],
 " currently accepts the following three values: ",
 Cell[BoxData["\"\<Current\>\""], "InlineFormula"],
 " (the default), ",
 Cell[BoxData["\"\<New\>\""], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  RowBox[{"\"\<Dispatch\>\"", ".", " "}]], "InlineFormula"],
 "The choice of ",
 Cell[BoxData["\"\<Current\>\""], "InlineFormula"],
 " makes no attempt to create a new thread to execute the request in and \
operates within the same current active thread. ",
 Cell[BoxData["\"\<New\>\""], "InlineFormula"],
 " will create a new thread and execute the code within this new thread. ",
 Cell[BoxData["\"\<Dispatch\>\""], "InlineFormula"],
 " requests that the code execute within the AWT event dispatching thread. \
The default value for ",
 Cell[BoxData[
  ButtonBox["InvokeWait",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/InvokeWait"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " and the default behavior is based on the value of ",
 Cell[BoxData[
  ButtonBox["InvokeThread",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/InvokeThread"]], "InlineFormula"],
 ", if an explicit setting of ",
 Cell[BoxData[
  ButtonBox["InvokeWait",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/InvokeWait"]], "InlineFormula"],
 " is not included. The following table summarizes the default automatic \
behavior of ",
 Cell[BoxData[
  ButtonBox["InvokeWait",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/InvokeWait"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Threads",
 CellID->509091011],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[
     ButtonBox["InvokeThread",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/InvokeThread"]], "InlineFormula",
     FontSlant->"Plain"]], "TableHeader"], Cell[
    "Current Thread", "TableHeader"], Cell[TextData[{
     "Default Behavior of ",
     Cell[BoxData[
      ButtonBox["InvokeWait",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/InvokeWait"]], "InlineFormula",
      FontSlant->"Plain"],
     " "
    }], "TableHeader"], Cell["Notes", "TableHeader"]},
   {Cell["Current", "TableText"], Cell["Any", "TableText"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
execution occurs on the current thread synchronously waiting for the result \
of the code before continuing\
\>", "TableText"]},
   {Cell["New", "TableText"], Cell["Any", "TableText"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
execution is occurring in a new thread and by default the code will not wait \
for a response before continuing\
\>", "TableText"]},
   {
    ButtonBox["Dispatch",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dispatch"], 
    ButtonBox["Dispatch",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dispatch"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "if you request the ",
     Cell[BoxData[
      ButtonBox["Dispatch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dispatch"]], "InlineFormula"],
     " thread, and you are currently running in the ",
     Cell[BoxData[
      ButtonBox["Dispatch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dispatch"]], "InlineFormula"],
     " thread, the response will be returned synchronously"
    }], "TableText"]},
   {
    ButtonBox["Dispatch",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dispatch"], Cell[TextData[{
     "not ",
     Cell[BoxData[
      ButtonBox["Dispatch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dispatch"]], "InlineFormula"]
    }], "TableText"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "if you are not already in the ",
     Cell[BoxData[
      ButtonBox["Dispatch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dispatch"]], "InlineFormula"],
     " thread, asynchronously have the execution queued to occur on the \
dispatch thread as soon as possible without waiting for the response"
    }], "TableText"]}
  }]], "DefinitionBox4Col",
 GridBoxOptions->{
 GridBoxDividers->{"Columns" -> {{"True"}}, "Rows" -> {{"True"}}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.15], 
     Scaled[0.2], 
     Scaled[0.2], {
      Scaled[0.45]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->"Threads",
 CellID->214866900],

Cell[TextData[{
 "Using the ",
 Cell[BoxData[
  ButtonBox["InvokeThread",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/InvokeThread"]], "InlineFormula"],
 " option and the default behavior of ",
 Cell[BoxData[
  ButtonBox["InvokeWait",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/InvokeWait"]], "InlineFormula"],
 ", you can now thread the execution of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " calculation using a new thread on the ",
 Cell[BoxData[
  ButtonBox["BindEvent",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/BindEvent"]], "InlineFormula"],
 " and update the user interface in the event dispatch thread when calling ",
 Cell[BoxData[
  ButtonBox["SetPropertyValue",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/SetPropertyValue"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Threads",
 CellID->26358016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", " ", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", " ", 
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Button\>\"", ",", " ", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"\"\<text\>\"", "->", "\"\<Run\>\""}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            StyleBox["BindEvent",
             FontColor->RGBColor[1, 0, 1]], "[", 
            RowBox[{"\"\<action\>\"", ",", "\[IndentingNewLine]", 
             RowBox[{"Script", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                StyleBox["SetPropertyValue",
                 FontColor->RGBColor[0, 0, 1]], "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"\"\<button\>\"", ",", " ", "\"\<enabled\>\""}], 
                  "}"}], ",", " ", "False", ",", " ", 
                 StyleBox[
                  RowBox[{"InvokeThread", "->", "\"\<Dispatch\>\""}],
                  FontColor->RGBColor[0, 0, 1]]}], "]"}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"Do", "[", "\[IndentingNewLine]", "   ", 
                RowBox[{
                 RowBox[{
                  StyleBox["SetPropertyValue",
                   FontColor->RGBColor[0, 0, 1]], "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"\"\<label\>\"", ",", " ", "\"\<text\>\""}], 
                    "}"}], ",", " ", 
                   RowBox[{"\"\<Current value is \>\"", " ", "<>", " ", 
                    RowBox[{"ToString", "[", "i", "]"}]}], ",", " ", 
                   StyleBox[
                    RowBox[{"InvokeThread", "->", "\"\<Dispatch\>\""}],
                    FontColor->RGBColor[0, 0, 1]]}], "]"}], ",", 
                 "\[IndentingNewLine]", "   ", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "300", ",", "0", ",", 
                   RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{
                StyleBox["SetPropertyValue",
                 FontColor->RGBColor[0, 0, 1]], "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"\"\<label\>\"", ",", " ", "\"\<text\>\""}], "}"}], 
                 ",", " ", "\"\<Press the button to count from 300 to 0.\>\"",
                  ",", " ", 
                 StyleBox[
                  RowBox[{"InvokeThread", "->", "\"\<Dispatch\>\""}],
                  FontColor->RGBColor[0, 0, 1]]}], "]"}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{
                StyleBox["SetPropertyValue",
                 FontColor->RGBColor[0, 0, 1]], "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"\"\<button\>\"", ",", " ", "\"\<enabled\>\""}], 
                  "}"}], ",", " ", "True", ",", " ", 
                 StyleBox[
                  RowBox[{"InvokeThread", "->", "\"\<Dispatch\>\""}],
                  FontColor->RGBColor[0, 0, 1]]}], "]"}], ";"}], 
              "\[IndentingNewLine]", "]"}], ",", " ", "\[IndentingNewLine]", 
             StyleBox[
              RowBox[{"InvokeThread", "->", "\"\<New\>\""}],
              FontColor->RGBColor[1, 0, 1]]}], "]"}]}], "\[IndentingNewLine]",
           "}"}], ",", " ", 
         RowBox[{"Name", "->", "\"\<button\>\""}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Label\>\"", ",", " ", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
          "\"\<text\>\"", " ", "\[Rule]", " ", 
           "\"\<Press the button to count from 300 to 0.\>\""}], 
          "\[IndentingNewLine]", "}"}], ",", " ", 
         RowBox[{"Name", "->", "\"\<label\>\""}]}], "]"}]}], 
      "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellTags->"Threads",
 CellID->506845415],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject166707192659969, 
   JLink`Objects`JavaObject372810627153921]]], "Output",
 CellTags->"Threads",
 CellID->31611540]
}, Open  ]],

Cell[TextData[{
 "Notice also the desire to disable the button while the execution is \
threaded since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot evaluate requests from multiple threads, and allowing another \
request can lead to unpredictable results in the kernel evaluation \
sequences."
}], "Text",
 CellTags->"Threads",
 CellID->594234059],

Cell["\<\
For a more detailed description of issues related to using Java user \
interfaces in a multithreaded environment, see Sun's Java documentation.\
\>", "Text",
 CellTags->"Threads",
 CellID->18927158]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Threads - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 42.5044608}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "By default, any interface definition executes within a single thread, \
and since currently GUIKit` definitions execute at runtime as Java \
components, this means that execution occurs in the single Java AWT event \
dispatch thread. In most cases, complete user interface dialogs or tools can \
run within a single Java thread, make synchronous requests to Mathematica, \
and never require any explicit threading code to handle how requests are \
processed. Also note that since the Mathematica kernel is not multithreaded, \
the only reason for attempting a multithreaded interface definition is to \
allow user interface updates to occur while a long calculation may be \
proceeding in Mathematica. Consider, for example, the following definition.", 
    "synonyms" -> {}, "title" -> "Threads", "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/Threads"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Threads"->{
  Cell[731, 29, 65, 2, 70, "Title",
   CellTags->"Threads",
   CellID->51472476],
  Cell[799, 33, 346, 8, 70, "Text",
   CellTags->"Threads",
   CellID->648831117],
  Cell[1148, 43, 664, 17, 70, "Text",
   CellTags->"Threads",
   CellID->26105955],
  Cell[1815, 62, 106, 2, 70, "Text",
   CellTags->"Threads",
   CellID->446297019],
  Cell[1924, 66, 132, 4, 70, "Input",
   CellTags->"Threads",
   CellID->350525506],
  Cell[2081, 74, 2288, 50, 70, "Input",
   CellTags->"Threads",
   CellID->8987385],
  Cell[4372, 126, 266, 7, 70, "Output",
   CellTags->"Threads",
   CellID->60119462],
  Cell[4653, 136, 109, 2, 70, "Text",
   CellTags->"Threads",
   CellID->505852412],
  Cell[4787, 142, 114, 3, 70, "Input",
   CellTags->"Threads",
   CellID->10041527],
  Cell[4904, 147, 8958, 151, 70, "Output",
   Evaluatable->False,
   CellTags->"Threads",
   CellID->477551160],
  Cell[13877, 301, 1714, 35, 70, "Text",
   CellTags->"Threads",
   CellID->167275170],
  Cell[15594, 338, 1898, 54, 70, "Text",
   CellTags->"Threads",
   CellID->372457028],
  Cell[17495, 394, 1776, 49, 70, "Text",
   CellTags->"Threads",
   CellID->509091011],
  Cell[19274, 445, 2904, 82, 70, "DefinitionBox4Col",
   CellTags->"Threads",
   CellID->214866900],
  Cell[22181, 529, 881, 27, 70, "Text",
   CellTags->"Threads",
   CellID->26358016],
  Cell[23087, 560, 4078, 89, 70, "Input",
   CellTags->"Threads",
   CellID->506845415],
  Cell[27168, 651, 261, 7, 70, "Output",
   CellTags->"Threads",
   CellID->31611540],
  Cell[27444, 661, 363, 10, 70, "Text",
   CellTags->"Threads",
   CellID->594234059],
  Cell[27810, 673, 208, 5, 70, "Text",
   CellTags->"Threads",
   CellID->18927158]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Threads", 30030, 725}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 65, 2, 70, "Title",
 CellTags->"Threads",
 CellID->51472476],
Cell[799, 33, 346, 8, 70, "Text",
 CellTags->"Threads",
 CellID->648831117],
Cell[1148, 43, 664, 17, 70, "Text",
 CellTags->"Threads",
 CellID->26105955],
Cell[1815, 62, 106, 2, 70, "Text",
 CellTags->"Threads",
 CellID->446297019],
Cell[1924, 66, 132, 4, 70, "Input",
 CellTags->"Threads",
 CellID->350525506],
Cell[CellGroupData[{
Cell[2081, 74, 2288, 50, 70, "Input",
 CellTags->"Threads",
 CellID->8987385],
Cell[4372, 126, 266, 7, 70, "Output",
 CellTags->"Threads",
 CellID->60119462]
}, Open  ]],
Cell[4653, 136, 109, 2, 70, "Text",
 CellTags->"Threads",
 CellID->505852412],
Cell[CellGroupData[{
Cell[4787, 142, 114, 3, 70, "Input",
 CellTags->"Threads",
 CellID->10041527],
Cell[4904, 147, 8958, 151, 70, "Output",
 Evaluatable->False,
 CellTags->"Threads",
 CellID->477551160]
}, Open  ]],
Cell[13877, 301, 1714, 35, 70, "Text",
 CellTags->"Threads",
 CellID->167275170],
Cell[15594, 338, 1898, 54, 70, "Text",
 CellTags->"Threads",
 CellID->372457028],
Cell[17495, 394, 1776, 49, 70, "Text",
 CellTags->"Threads",
 CellID->509091011],
Cell[19274, 445, 2904, 82, 70, "DefinitionBox4Col",
 CellTags->"Threads",
 CellID->214866900],
Cell[22181, 529, 881, 27, 70, "Text",
 CellTags->"Threads",
 CellID->26358016],
Cell[CellGroupData[{
Cell[23087, 560, 4078, 89, 70, "Input",
 CellTags->"Threads",
 CellID->506845415],
Cell[27168, 651, 261, 7, 70, "Output",
 CellTags->"Threads",
 CellID->31611540]
}, Open  ]],
Cell[27444, 661, 363, 10, 70, "Text",
 CellTags->"Threads",
 CellID->594234059],
Cell[27810, 673, 208, 5, 70, "Text",
 CellTags->"Threads",
 CellID->18927158]
}, Open  ]],
Cell[28033, 681, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

