(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     81556,       1992]
NotebookOptionsPosition[     68670,       1548]
NotebookOutlinePosition[     75593,       1766]
CellTagsIndexPosition[     75421,       1758]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Widget Basics", "Title",
 CellTags->"InteractingIntro",
 CellID->486709749],

Cell[TextData[{
 "Widgets are the basic component of GUIs built with ",
 StyleBox["GUIKit.",
  FontSlant->"Italic"],
 " This tutorial discusses some of the basics of widgets and how they work. \
More detailed information on widgets can be found in ",
 ButtonBox["GUI Building Blocks",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks"],
 "."
}], "Text",
 CellTags->"InteractingIntro",
 CellID->77467686],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[1]:=",
 CellID->100234074],

Cell["\<\
This creates a basic widget that consists of a panel with three buttons. It \
does not display anything yet.\
\>", "Text",
 CellID->26353438],

Cell[BoxData[
 RowBox[{
  RowBox[{"widget", " ", "=", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Button\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}]}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Button\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "->", "\"\<Button B\>\""}], "}"}]}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Button\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "->", "\"\<Button C\>\""}], "}"}]}], 
        "]"}]}], " ", "}"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",\

 CellTags->"LayoutIntro",
 CellLabel->"In[2]:=",
 CellID->281756696],

Cell["\<\
This runs the widget, now you should see the panel appear on your screen.\
\>", "Text",
 CellID->692782477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{"GUIRun", "[", "widget", "]"}]}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[3]:=",
 CellID->63616072],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject93432466898945, 
   JLink`Objects`vm1`JavaObject8748512837633]]], "Output",
 CellTags->"LayoutIntro",
 CellLabel->"Out[3]=",
 CellID->136094279]
}, Open  ]],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " expression; this can be used as a handle to the executing GUI."
}], "Text",
 CellID->81966939],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GUIScreenShot",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIScreenShot"]]],
 " takes a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " expression and returns a picture that shows how the GUI appears on screen. \
The image you see may be more appropriate for your system."
}], "Text",
 CellID->221353247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[4]:=",
 CellID->545247944],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnXuTHcV5xlWVL5CAQ7BDQuUbBMd2HG79FYzv3KtSlT9TKRMS29z8FQgx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   "], {{0, 0}, {123, 109}},
   ColorFunction->RGBColor,
   ColorFunctionScaling->False],
  AspectRatio->Automatic,
  ImageSize->{123, 109},
  PlotRange->{{0, 123}, {0, 109}}]], "Output",
 CellTags->"LayoutIntro",
 CellLabel->"Out[4]=",
 CellID->96262905]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget Naming", "Section",
 CellTags->"Referencing",
 CellID->23288840],

Cell[TextData[{
 "One of the key features of ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " is that you can give widgets names."
}], "Text",
 CellTags->"Referencing",
 CellID->263117627],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[1]:=",
 CellID->327580673],

Cell["This creates and runs a widget, and it gives it a name.", "Text",
 CellID->687775841],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", 
   RowBox[{"GUIRun", "[", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Button\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}]}], "]"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Button\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Button B\>\""}], "}"}]}], "]"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Button\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Button C\>\""}], "}"}]}], 
         "]"}]}], " ", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Name", "\[Rule]", "\"\<MyWidget\>\""}]}], 
     "\[IndentingNewLine]", "]"}], "]"}]}], ";"}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[2]:=",
 CellID->588292665],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GUIInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " takes a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " expression and returns information about its internals. This example \
extracts all the named widgets from the ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 ". There is only one name: ",
 StyleBox["MyWidget", "MR"],
 ".",
 " "
}], "Text",
 CellID->512974184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<WidgetNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", "ref", "]"}]}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[3]:=",
 CellID->203540885],

Cell[BoxData[
 RowBox[{"{", "\<\"MyWidget\"\>", "}"}]], "Output",
 CellTags->"Referencing",
 CellLabel->"Out[3]=",
 CellID->148652637]
}, Open  ]],

Cell["\<\
Widget names will be used in many places for scripting GUIs. \
\>", "Text",
 CellID->157503692]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget Properties", "Section",
 CellTags->"Properties",
 CellID->112718872],

Cell[TextData[{
 "Manipulation of widgets through their properties is a key concept of ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 ". There are a number of property-based functions that aid in discovering \
what properties exist on widgets in an interface and also querying and \
modifying their current values."
}], "Text",
 CellTags->"Properties",
 CellID->123613120],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Properties",
 CellLabel->"In[1]:=",
 CellID->95290409],

Cell["This runs a GUI that has two named widgets.", "Text",
 CellTags->"Properties",
 CellID->50294623],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", 
   RowBox[{"GUIRun", "[", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Button\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}], ",", 
          " ", 
          RowBox[{"Name", "\[Rule]", "\"\<button1\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Button\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Button B\>\""}], "}"}]}], "]"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Button\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Button C\>\""}], "}"}]}], 
         "]"}]}], " ", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Name", "\[Rule]", "\"\<MyWidget\>\""}]}], 
     "\[IndentingNewLine]", "]"}], "]"}]}], ";"}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[2]:=",
 CellID->101449194],

Cell["This shows that there are two named widgets.", "Text",
 CellID->63986956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<WidgetNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", "ref", "]"}]}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[3]:=",
 CellID->338408275],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"button1\"\>", ",", "\<\"MyWidget\"\>"}], "}"}]], "Output",
 CellTags->"Referencing",
 CellLabel->"Out[3]=",
 CellID->89894061]
}, Open  ]],

Cell[TextData[{
 "This requests a list of all property names available with the widget \
referred to by ",
 Cell[BoxData["\"\<button1\>\""], "InlineFormula"],
 " in the dialog."
}], "Text",
 CellTags->"Properties",
 CellID->721104775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<PropertyNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", 
   RowBox[{"ref", " ", ",", "\"\<button1\>\""}], "]"}]}]], "Input",
 CellTags->"Properties",
 CellLabel->"In[4]:=",
 CellID->134890228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AccessibleContext\"\>", ",", "\<\"Action\"\>", 
   ",", "\<\"ActionCommand\"\>", ",", "\<\"ActionListeners\"\>", 
   ",", "\<\"ActionMap\"\>", ",", "\<\"AlignmentX\"\>", 
   ",", "\<\"AlignmentY\"\>", ",", "\<\"AncestorListeners\"\>", 
   ",", "\<\"Autoscrolls\"\>", ",", "\<\"Background\"\>", 
   ",", "\<\"BackgroundSet\"\>", ",", "\<\"Border\"\>", 
   ",", "\<\"BorderPainted\"\>", ",", "\<\"Bounds\"\>", 
   ",", "\<\"ChangeListeners\"\>", ",", "\<\"Class\"\>", 
   ",", "\<\"ColorModel\"\>", ",", "\<\"Component\"\>", 
   ",", "\<\"ComponentCount\"\>", ",", "\<\"ComponentListeners\"\>", 
   ",", "\<\"ComponentOrientation\"\>", ",", "\<\"ComponentPopupMenu\"\>", 
   ",", "\<\"Components\"\>", ",", "\<\"ContainerListeners\"\>", 
   ",", "\<\"ContentAreaFilled\"\>", ",", "\<\"Cursor\"\>", 
   ",", "\<\"CursorSet\"\>", ",", "\<\"DebugGraphicsOptions\"\>", 
   ",", "\<\"DefaultButton\"\>", ",", "\<\"DefaultCapable\"\>", 
   ",", "\<\"DisabledIcon\"\>", ",", "\<\"DisabledSelectedIcon\"\>", 
   ",", "\<\"Displayable\"\>", ",", "\<\"DisplayedMnemonicIndex\"\>", 
   ",", "\<\"DoubleBuffered\"\>", ",", "\<\"DropTarget\"\>", 
   ",", "\<\"Enabled\"\>", ",", "\<\"Focusable\"\>", 
   ",", "\<\"FocusCycleRoot\"\>", ",", "\<\"FocusCycleRootAncestor\"\>", 
   ",", "\<\"FocusListeners\"\>", ",", "\<\"FocusOwner\"\>", 
   ",", "\<\"FocusPainted\"\>", ",", "\<\"FocusTraversable\"\>", 
   ",", "\<\"FocusTraversalKeys\"\>", 
   ",", "\<\"FocusTraversalKeysEnabled\"\>", 
   ",", "\<\"FocusTraversalPolicy\"\>", 
   ",", "\<\"FocusTraversalPolicyProvider\"\>", 
   ",", "\<\"FocusTraversalPolicySet\"\>", ",", "\<\"Font\"\>", 
   ",", "\<\"FontSet\"\>", ",", "\<\"Foreground\"\>", 
   ",", "\<\"ForegroundSet\"\>", ",", "\<\"Graphics\"\>", 
   ",", "\<\"GraphicsConfiguration\"\>", ",", "\<\"Height\"\>", 
   ",", "\<\"HierarchyBoundsListeners\"\>", ",", "\<\"HierarchyListeners\"\>",
    ",", "\<\"HorizontalAlignment\"\>", ",", "\<\"HorizontalTextPosition\"\>",
    ",", "\<\"Icon\"\>", ",", "\<\"IconTextGap\"\>", 
   ",", "\<\"IgnoreRepaint\"\>", ",", "\<\"InheritsPopupMenu\"\>", 
   ",", "\<\"InputContext\"\>", ",", "\<\"InputMap\"\>", 
   ",", "\<\"InputMethodListeners\"\>", ",", "\<\"InputMethodRequests\"\>", 
   ",", "\<\"InputVerifier\"\>", ",", "\<\"Insets\"\>", 
   ",", "\<\"ItemListeners\"\>", ",", "\<\"KeyListeners\"\>", 
   ",", "\<\"Label\"\>", ",", "\<\"Layout\"\>", ",", "\<\"Lightweight\"\>", 
   ",", "\<\"Locale\"\>", ",", "\<\"Location\"\>", 
   ",", "\<\"LocationOnScreen\"\>", ",", "\<\"ManagingFocus\"\>", 
   ",", "\<\"Margin\"\>", ",", "\<\"MaximumSize\"\>", 
   ",", "\<\"MaximumSizeSet\"\>", ",", "\<\"MinimumSize\"\>", 
   ",", "\<\"MinimumSizeSet\"\>", ",", "\<\"Mnemonic\"\>", 
   ",", "\<\"Model\"\>", ",", "\<\"MouseListeners\"\>", 
   ",", "\<\"MouseMotionListeners\"\>", ",", "\<\"MousePosition\"\>", 
   ",", "\<\"MouseWheelListeners\"\>", ",", "\<\"MultiClickThreshhold\"\>", 
   ",", "\<\"Name\"\>", ",", "\<\"NextFocusableComponent\"\>", 
   ",", "\<\"Opaque\"\>", ",", "\<\"OptimizedDrawingEnabled\"\>", 
   ",", "\<\"PaintingTile\"\>", ",", "\<\"Parent\"\>", ",", "\<\"Peer\"\>", 
   ",", "\<\"PreferredSize\"\>", ",", "\<\"PreferredSizeSet\"\>", 
   ",", "\<\"PressedIcon\"\>", ",", "\<\"PropertyChangeListeners\"\>", 
   ",", "\<\"RegisteredKeyStrokes\"\>", ",", "\<\"RequestFocusEnabled\"\>", 
   ",", "\<\"RolloverEnabled\"\>", ",", "\<\"RolloverIcon\"\>", 
   ",", "\<\"RolloverSelectedIcon\"\>", ",", "\<\"RootPane\"\>", 
   ",", "\<\"Selected\"\>", ",", "\<\"SelectedIcon\"\>", 
   ",", "\<\"SelectedObjects\"\>", ",", "\<\"Showing\"\>", 
   ",", "\<\"Size\"\>", ",", "\<\"Text\"\>", ",", "\<\"Toolkit\"\>", 
   ",", "\<\"ToolTipText\"\>", ",", "\<\"TopLevelAncestor\"\>", 
   ",", "\<\"TransferHandler\"\>", ",", "\<\"TreeLock\"\>", ",", "\<\"UI\"\>",
    ",", "\<\"UIClassID\"\>", ",", "\<\"Valid\"\>", 
   ",", "\<\"ValidateRoot\"\>", ",", "\<\"VerifyInputWhenFocusTarget\"\>", 
   ",", "\<\"VerticalAlignment\"\>", ",", "\<\"VerticalTextPosition\"\>", 
   ",", "\<\"VetoableChangeListeners\"\>", ",", "\<\"Visible\"\>", 
   ",", "\<\"VisibleRect\"\>", ",", "\<\"Width\"\>", ",", "\<\"X\"\>", 
   ",", "\<\"Y\"\>"}], "}"}]], "Output",
 CellTags->"Properties",
 CellLabel->"Out[4]=",
 CellID->645564620]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["SetPropertyValue",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/SetPropertyValue"]], "InlineFormula"],
 " to include conversion to ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 ", or ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression values using common optional arguments found with ",
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 ". This changes the text property, and the new value shows up immediately."
}], "Text",
 CellTags->"Properties",
 CellID->306493269],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<button1\>\"", ",", " ", "\"\<text\>\""}], "}"}], ",", " ", 
    "\"\<TextChanged\>\""}], "]"}]}]], "Input",
 CellTags->"Properties",
 CellLabel->"In[5]:=",
 CellID->306604920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Properties",
 CellLabel->"In[6]:=",
 CellID->256335558],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnXuTHcV5xlWVL5CAQ7BDQuUbBMd2HG79FYzv3KtSlT9TKRMS29z8FQgx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   "], {{0, 0}, {123, 109}},
   ColorFunction->RGBColor,
   ColorFunctionScaling->False],
  AspectRatio->Automatic,
  ImageSize->{123, 109},
  PlotRange->{{0, 123}, {0, 109}}]], "Output",
 Evaluatable->False,
 ImageSize->{207, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Properties",
 CellLabel->"Out[6]=",
 CellID->964509593]
}, Open  ]],

Cell["\<\
The property value can be extracted directly from the widget reference.\
\>", "Text",
 CellID->585431335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"PropertyValue", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<button1\>\"", ",", " ", "\"\<text\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellTags->"Properties",
 CellLabel->"In[7]:=",
 CellID->772739336],

Cell[BoxData["\<\"TextChanged\"\>"], "Output",
 CellTags->"Properties",
 CellLabel->"Out[7]=",
 CellID->13174359]
}, Open  ]],

Cell["\<\
This shows that the property value that was returned is a string.\
\>", "Text",
 CellID->1368325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellTags->"Properties",
 CellLabel->"In[8]:=",
 CellID->25461823],

Cell["\"TextChanged\"", "Output",
 CellTags->"Properties",
 CellLabel->"Out[8]//InputForm=",
 CellID->84681293]
}, Open  ]],

Cell[TextData[{
 "Property values that automatically have equivalent ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions as defined by ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " can be returned or set using the standard ",
 Cell[BoxData[
  ButtonBox["PropertyValue",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/PropertyValue"]], "InlineFormula"],
 " function."
}], "Text",
 CellTags->"Properties",
 CellID->308558814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"PropertyValue", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<button1\>\"", ",", " ", "\"\<visible\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellTags->"Properties",
 CellLabel->"In[9]:=",
 CellID->399283820],

Cell[BoxData["True"], "Output",
 CellTags->"Properties",
 CellLabel->"Out[9]=",
 CellID->433784640]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Further Widget Details", "Section",
 CellTags->"Properties",
 CellID->85085113],

Cell[TextData[{
 "In addition to names and properties widgets have a number of other details \
that are important for creating GUIs. These can be investigated using the",
 " ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " reference."
}], "Text",
 CellID->120843150],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"Properties",
 CellLabel->"In[7]:=",
 CellID->916887658],

Cell["This runs a built-in GUI.", "Text",
 CellTags->"Properties",
 CellID->263428567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/AngleDialog\>\"", "]"}]}]], "Input",
 CellTags->"LayoutIntro",
 CellLabel->"In[8]:=",
 CellID->41989888],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject389580024971265, 
   JLink`Objects`vm1`JavaObject72142649556993]]], "Output",
 CellTags->"LayoutIntro",
 CellLabel->"Out[8]=",
 CellID->290460860]
}, Open  ]],

Cell["This shows a dynamic snapshot of the interface.", "Text",
 CellTags->"Referencing",
 CellID->57228793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[10]:=",
 CellID->466067545],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3XmTZUd55/GOmDdgg9gHiHkHgBHGBpRvAbMIm00REzF/zwgwixnktwDa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   "], {{0, 0}, {211, 173}},
   ColorFunction->RGBColor,
   ColorFunctionScaling->False],
  AspectRatio->Automatic,
  ImageSize->{211, 173},
  PlotRange->{{0, 211}, {0, 173}}]], "Output",
 CellTags->"Referencing",
 CellLabel->"Out[10]=",
 CellID->61665611]
}, Open  ]],

Cell["\<\
You can retrieve a list of all widgets in the interface that have been \
registered with unique string names and reference these widget instances by \
these reference names.\
\>", "Text",
 CellTags->"Referencing",
 CellID->498904818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<WidgetNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", "ref", "]"}]}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[4]:=",
 CellID->26370402],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"actionMap\"\>", ",", "\<\"cancelAction\"\>", 
   ",", "\<\"cancelButton\"\>", ",", "\<\"degreesButton\"\>", 
   ",", "\<\"frame\"\>", ",", "\<\"inputField\"\>", ",", "\<\"inputMap\"\>", 
   ",", "\<\"okButton\"\>", ",", "\<\"radiansButton\"\>", 
   ",", "\<\"rootPane\"\>"}], "}"}]], "Output",
 CellTags->"Referencing",
 CellLabel->"Out[4]=",
 CellID->330874142]
}, Open  ]],

Cell[TextData[{
 "This discovers all property names available with the widget registered with \
the name ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"inputField\", \"TI\"]\)\>\""], "InlineFormula"],
 ". You can query and set these values using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PropertyValue",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/PropertyValue"], "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"inputField\", \"TI\"]\)\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"propertyName\", \"TI\"]\)\>\""}], "}"}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPropertyValue",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/SetPropertyValue"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"inputField\", \"TI\"]\)\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"propertyName\", \"TI\"]\)\>\""}], "}"}], ",", " ", 
    StyleBox["newValue", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Referencing",
 CellID->38549142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<PropertyNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", 
   RowBox[{"ref", ",", "\"\<inputField\>\""}], "]"}]}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[5]:=",
 CellID->816309410],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AccessibleContext\"\>", ",", "\<\"Action\"\>", 
   ",", "\<\"ActionCommand\"\>", ",", "\<\"ActionListeners\"\>", 
   ",", "\<\"ActionMap\"\>", ",", "\<\"Actions\"\>", 
   ",", "\<\"AlignmentX\"\>", ",", "\<\"AlignmentY\"\>", 
   ",", "\<\"AncestorListeners\"\>", ",", "\<\"Autoscrolls\"\>", 
   ",", "\<\"Background\"\>", ",", "\<\"BackgroundSet\"\>", 
   ",", "\<\"Border\"\>", ",", "\<\"Bounds\"\>", ",", "\<\"Caret\"\>", 
   ",", "\<\"CaretColor\"\>", ",", "\<\"CaretListeners\"\>", 
   ",", "\<\"CaretPosition\"\>", ",", "\<\"Class\"\>", 
   ",", "\<\"ColorModel\"\>", ",", "\<\"Columns\"\>", 
   ",", "\<\"Component\"\>", ",", "\<\"ComponentCount\"\>", 
   ",", "\<\"ComponentListeners\"\>", ",", "\<\"ComponentOrientation\"\>", 
   ",", "\<\"ComponentPopupMenu\"\>", ",", "\<\"Components\"\>", 
   ",", "\<\"ContainerListeners\"\>", ",", "\<\"Cursor\"\>", 
   ",", "\<\"CursorSet\"\>", ",", "\<\"DebugGraphicsOptions\"\>", 
   ",", "\<\"DisabledTextColor\"\>", ",", "\<\"Displayable\"\>", 
   ",", "\<\"Document\"\>", ",", "\<\"DoubleBuffered\"\>", 
   ",", "\<\"DragEnabled\"\>", ",", "\<\"DropTarget\"\>", 
   ",", "\<\"Editable\"\>", ",", "\<\"Enabled\"\>", ",", "\<\"Focusable\"\>", 
   ",", "\<\"FocusAccelerator\"\>", ",", "\<\"FocusCycleRoot\"\>", 
   ",", "\<\"FocusCycleRootAncestor\"\>", ",", "\<\"FocusListeners\"\>", 
   ",", "\<\"FocusOwner\"\>", ",", "\<\"FocusTraversable\"\>", 
   ",", "\<\"FocusTraversalKeys\"\>", 
   ",", "\<\"FocusTraversalKeysEnabled\"\>", 
   ",", "\<\"FocusTraversalPolicy\"\>", 
   ",", "\<\"FocusTraversalPolicyProvider\"\>", 
   ",", "\<\"FocusTraversalPolicySet\"\>", ",", "\<\"Font\"\>", 
   ",", "\<\"FontSet\"\>", ",", "\<\"Foreground\"\>", 
   ",", "\<\"ForegroundSet\"\>", ",", "\<\"Graphics\"\>", 
   ",", "\<\"GraphicsConfiguration\"\>", ",", "\<\"Height\"\>", 
   ",", "\<\"HierarchyBoundsListeners\"\>", ",", "\<\"HierarchyListeners\"\>",
    ",", "\<\"Highlighter\"\>", ",", "\<\"HorizontalAlignment\"\>", 
   ",", "\<\"HorizontalVisibility\"\>", ",", "\<\"IgnoreRepaint\"\>", 
   ",", "\<\"InheritsPopupMenu\"\>", ",", "\<\"InputContext\"\>", 
   ",", "\<\"InputMap\"\>", ",", "\<\"InputMethodListeners\"\>", 
   ",", "\<\"InputMethodRequests\"\>", ",", "\<\"InputVerifier\"\>", 
   ",", "\<\"Insets\"\>", ",", "\<\"KeyListeners\"\>", ",", "\<\"Keymap\"\>", 
   ",", "\<\"Layout\"\>", ",", "\<\"Lightweight\"\>", ",", "\<\"Locale\"\>", 
   ",", "\<\"Location\"\>", ",", "\<\"LocationOnScreen\"\>", 
   ",", "\<\"ManagingFocus\"\>", ",", "\<\"Margin\"\>", 
   ",", "\<\"MaximumSize\"\>", ",", "\<\"MaximumSizeSet\"\>", 
   ",", "\<\"MinimumSize\"\>", ",", "\<\"MinimumSizeSet\"\>", 
   ",", "\<\"MouseListeners\"\>", ",", "\<\"MouseMotionListeners\"\>", 
   ",", "\<\"MousePosition\"\>", ",", "\<\"MouseWheelListeners\"\>", 
   ",", "\<\"Name\"\>", ",", "\<\"NavigationFilter\"\>", 
   ",", "\<\"NextFocusableComponent\"\>", ",", "\<\"NotifyAction\"\>", 
   ",", "\<\"Opaque\"\>", ",", "\<\"OptimizedDrawingEnabled\"\>", 
   ",", "\<\"PaintingTile\"\>", ",", "\<\"Parent\"\>", ",", "\<\"Peer\"\>", 
   ",", "\<\"PreferredScrollableViewportSize\"\>", 
   ",", "\<\"PreferredSize\"\>", ",", "\<\"PreferredSizeSet\"\>", 
   ",", "\<\"PropertyChangeListeners\"\>", 
   ",", "\<\"RegisteredKeyStrokes\"\>", ",", "\<\"RequestFocusEnabled\"\>", 
   ",", "\<\"RootPane\"\>", ",", "\<\"ScrollableTracksViewportHeight\"\>", 
   ",", "\<\"ScrollableTracksViewportWidth\"\>", ",", "\<\"ScrollOffset\"\>", 
   ",", "\<\"SelectedText\"\>", ",", "\<\"SelectedTextColor\"\>", 
   ",", "\<\"SelectionColor\"\>", ",", "\<\"SelectionEnd\"\>", 
   ",", "\<\"SelectionStart\"\>", ",", "\<\"Showing\"\>", ",", "\<\"Size\"\>",
    ",", "\<\"Text\"\>", ",", "\<\"Toolkit\"\>", ",", "\<\"ToolTipText\"\>", 
   ",", "\<\"TopLevelAncestor\"\>", ",", "\<\"TransferHandler\"\>", 
   ",", "\<\"TreeLock\"\>", ",", "\<\"UI\"\>", ",", "\<\"UIClassID\"\>", 
   ",", "\<\"Valid\"\>", ",", "\<\"ValidateRoot\"\>", 
   ",", "\<\"VerifyInputWhenFocusTarget\"\>", 
   ",", "\<\"VetoableChangeListeners\"\>", ",", "\<\"Visible\"\>", 
   ",", "\<\"VisibleRect\"\>", ",", "\<\"Width\"\>", ",", "\<\"X\"\>", 
   ",", "\<\"Y\"\>"}], "}"}]], "Output",
 CellTags->"Referencing",
 CellLabel->"Out[5]=",
 CellID->240812383]
}, Open  ]],

Cell[TextData[{
 "You can also find out what method names exist that can be executed on this \
widget with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InvokeMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/InvokeMethod"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"inputField\", \"TI\"]\)\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"methodName\", \"TI\"]\)\>\""}], "}"}], ",", " ", 
    StyleBox["arguments", "TI"]}], "]"}]], "InlineFormula"],
 " and even filter these names using string patterns."
}], "Text",
 CellTags->"Referencing",
 CellID->561993925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"\"\<MethodNames\>\"", " ", "/.", " ", 
    RowBox[{"GUIInformation", "[", 
     RowBox[{"ref", ",", "\"\<inputField\>\""}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"#", ",", "\"\<*text*\>\"", ",", " ", 
      RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}], "&"}]}], 
  "]"}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[6]:=",
 CellID->572426759],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"GetAccessibleContext\"\>", ",", "\<\"GetDisabledTextColor\"\>",
    ",", "\<\"GetInputContext\"\>", ",", "\<\"GetSelectedText\"\>", 
   ",", "\<\"GetSelectedTextColor\"\>", ",", "\<\"GetText\"\>", 
   ",", "\<\"GetToolTipText\"\>", ",", "\<\"SetDisabledTextColor\"\>", 
   ",", "\<\"SetSelectedTextColor\"\>", ",", "\<\"SetText\"\>", 
   ",", "\<\"SetToolTipText\"\>"}], "}"}]], "Output",
 CellTags->"Referencing",
 CellLabel->"Out[6]=",
 CellID->429602482]
}, Open  ]],

Cell[TextData[{
 "Additionally, you can discover what event names can be used to cause ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code to execute whenever the event occurs by using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BindEvent",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/BindEvent"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"inputField\", \"TI\"]\)\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"eventName\", \"TI\"]\)\>\""}], "}"}], ",", " ", 
    RowBox[{
     ButtonBox["Script",
      BaseStyle->"Link",
      ButtonData->"paclet:GUIKit/ref/Script"], "[", 
     StyleBox["code", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"Referencing",
 CellID->186212963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<EventNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", 
   RowBox[{"ref", ",", "\"\<inputField\>\""}], "]"}]}]], "Input",
 CellTags->"Referencing",
 CellLabel->"In[7]:=",
 CellID->430865221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Action\"\>", ",", "\<\"ActionPerformed\"\>", 
   ",", "\<\"Ancestor\"\>", ",", "\<\"AncestorAdded\"\>", 
   ",", "\<\"AncestorMoved\"\>", ",", "\<\"AncestorRemoved\"\>", 
   ",", "\<\"AncestorResized\"\>", ",", "\<\"Caret\"\>", 
   ",", "\<\"CaretPositionChanged\"\>", ",", "\<\"CaretUpdate\"\>", 
   ",", "\<\"Component\"\>", ",", "\<\"ComponentAdded\"\>", 
   ",", "\<\"ComponentHidden\"\>", ",", "\<\"ComponentMoved\"\>", 
   ",", "\<\"ComponentRemoved\"\>", ",", "\<\"ComponentResized\"\>", 
   ",", "\<\"ComponentShown\"\>", ",", "\<\"Container\"\>", 
   ",", "\<\"Focus\"\>", ",", "\<\"FocusGained\"\>", ",", "\<\"FocusLost\"\>",
    ",", "\<\"Hierarchy\"\>", ",", "\<\"HierarchyBounds\"\>", 
   ",", "\<\"HierarchyChanged\"\>", ",", "\<\"InputMethod\"\>", 
   ",", "\<\"InputMethodTextChanged\"\>", ",", "\<\"Key\"\>", 
   ",", "\<\"KeyPressed\"\>", ",", "\<\"KeyReleased\"\>", 
   ",", "\<\"KeyTyped\"\>", ",", "\<\"Mouse\"\>", ",", "\<\"MouseClicked\"\>",
    ",", "\<\"MouseDragged\"\>", ",", "\<\"MouseEntered\"\>", 
   ",", "\<\"MouseExited\"\>", ",", "\<\"MouseMotion\"\>", 
   ",", "\<\"MouseMoved\"\>", ",", "\<\"MousePressed\"\>", 
   ",", "\<\"MouseReleased\"\>", ",", "\<\"MouseWheel\"\>", 
   ",", "\<\"MouseWheelMoved\"\>", ",", "\<\"PropertyChange\"\>", 
   ",", "\<\"VetoableChange\"\>"}], "}"}]], "Output",
 CellTags->"Referencing",
 CellLabel->"Out[7]=",
 CellID->82881011]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Widget Basics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 44.3637406}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "Widgets are the basic component of GUIs built with GUIKit. This tutorial \
discusses some of the basics of widgets and how they work. More detailed \
information on widgets can be found in GUI Building Blocks. This creates a \
basic widget that consists of a panel with three buttons. It does not display \
anything yet. This runs the widget, now you should see the panel appear on \
your screen.", "synonyms" -> {}, "title" -> "Widget Basics", "type" -> 
    "Tutorial", "uri" -> "GUIKit/tutorial/WidgetBasics"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "InteractingIntro"->{
  Cell[731, 29, 81, 2, 70, "Title",
   CellTags->"InteractingIntro",
   CellID->486709749],
  Cell[815, 33, 438, 12, 70, "Text",
   CellTags->"InteractingIntro",
   CellID->77467686]},
 "Referencing"->{
  Cell[1256, 47, 159, 5, 70, "Input",
   CellTags->"Referencing",
   CellID->100234074],
  Cell[15327, 344, 77, 2, 70, "Section",
   CellTags->"Referencing",
   CellID->23288840],
  Cell[15407, 348, 189, 7, 70, "Text",
   CellTags->"Referencing",
   CellID->263117627],
  Cell[15599, 357, 159, 5, 70, "Input",
   CellTags->"Referencing",
   CellID->327580673],
  Cell[17564, 421, 190, 5, 70, "Input",
   CellTags->"Referencing",
   CellID->203540885],
  Cell[17757, 428, 134, 4, 70, "Output",
   CellTags->"Referencing",
   CellID->148652637],
  Cell[20007, 505, 190, 5, 70, "Input",
   CellTags->"Referencing",
   CellID->338408275],
  Cell[20200, 512, 170, 5, 70, "Output",
   CellTags->"Referencing",
   CellID->89894061],
  Cell[41249, 996, 108, 2, 70, "Text",
   CellTags->"Referencing",
   CellID->57228793],
  Cell[41382, 1002, 138, 4, 70, "Input",
   CellTags->"Referencing",
   CellID->466067545],
  Cell[41523, 1008, 16547, 277, 70, "Output",
   CellTags->"Referencing",
   CellID->61665611],
  Cell[58085, 1288, 243, 6, 70, "Text",
   CellTags->"Referencing",
   CellID->498904818],
  Cell[58353, 1298, 189, 5, 70, "Input",
   CellTags->"Referencing",
   CellID->26370402],
  Cell[58545, 1305, 406, 9, 70, "Output",
   CellTags->"Referencing",
   CellID->330874142],
  Cell[58966, 1317, 1016, 30, 70, "Text",
   CellTags->"Referencing",
   CellID->38549142],
  Cell[60007, 1351, 233, 6, 70, "Input",
   CellTags->"Referencing",
   CellID->816309410],
  Cell[60243, 1359, 4280, 69, 70, "Output",
   CellTags->"Referencing",
   CellID->240812383],
  Cell[64538, 1431, 597, 17, 70, "Text",
   CellTags->"Referencing",
   CellID->561993925],
  Cell[65160, 1452, 481, 14, 70, "Input",
   CellTags->"Referencing",
   CellID->572426759],
  Cell[65644, 1468, 501, 10, 70, "Output",
   CellTags->"Referencing",
   CellID->429602482],
  Cell[66160, 1481, 745, 23, 70, "Text",
   CellTags->"Referencing",
   CellID->186212963],
  Cell[66930, 1508, 230, 6, 70, "Input",
   CellTags->"Referencing",
   CellID->430865221],
  Cell[67163, 1516, 1441, 25, 70, "Output",
   CellTags->"Referencing",
   CellID->82881011]},
 "LayoutIntro"->{
  Cell[1572, 60, 908, 25, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->281756696],
  Cell[2625, 94, 157, 5, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->63616072],
  Cell[2785, 101, 301, 8, 70, "Output",
   CellTags->"LayoutIntro",
   CellID->136094279],
  Cell[3964, 144, 137, 4, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->545247944],
  Cell[4104, 150, 11186, 189, 70, "Output",
   CellTags->"LayoutIntro",
   CellID->96262905],
  Cell[15855, 367, 1046, 27, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->588292665],
  Cell[18774, 469, 1126, 29, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->101449194],
  Cell[40729, 977, 199, 6, 70, "Input",
   CellTags->"LayoutIntro",
   CellID->41989888],
  Cell[40931, 985, 303, 8, 70, "Output",
   CellTags->"LayoutIntro",
   CellID->290460860]},
 "Properties"->{
  Cell[18048, 443, 81, 2, 70, "Section",
   CellTags->"Properties",
   CellID->112718872],
  Cell[18132, 447, 373, 9, 70, "Text",
   CellTags->"Properties",
   CellID->123613120],
  Cell[18508, 458, 157, 5, 70, "Input",
   CellTags->"Properties",
   CellID->95290409],
  Cell[18668, 465, 103, 2, 70, "Text",
   CellTags->"Properties",
   CellID->50294623],
  Cell[20385, 520, 234, 7, 70, "Text",
   CellTags->"Properties",
   CellID->721104775],
  Cell[20644, 531, 234, 6, 70, "Input",
   CellTags->"Properties",
   CellID->134890228],
  Cell[20881, 539, 4304, 70, 70, "Output",
   CellTags->"Properties",
   CellID->645564620],
  Cell[25200, 612, 1103, 37, 70, "Text",
   CellTags->"Properties",
   CellID->306493269],
  Cell[26306, 651, 305, 9, 70, "Input",
   CellTags->"Properties",
   CellID->306604920],
  Cell[26636, 664, 136, 4, 70, "Input",
   CellTags->"Properties",
   CellID->256335558],
  Cell[26775, 670, 11434, 195, 70, "Output",
   Evaluatable->False,
   CellTags->"Properties",
   CellID->964509593],
  Cell[38364, 875, 252, 8, 70, "Input",
   CellTags->"Properties",
   CellID->772739336],
  Cell[38619, 885, 113, 3, 70, "Output",
   CellTags->"Properties",
   CellID->13174359],
  Cell[38879, 898, 125, 4, 70, "Input",
   CellTags->"Properties",
   CellID->25461823],
  Cell[39007, 904, 111, 3, 70, "Output",
   CellTags->"Properties",
   CellID->84681293],
  Cell[39133, 910, 451, 15, 70, "Text",
   CellTags->"Properties",
   CellID->308558814],
  Cell[39609, 929, 255, 8, 70, "Input",
   CellTags->"Properties",
   CellID->399283820],
  Cell[39867, 939, 99, 3, 70, "Output",
   CellTags->"Properties",
   CellID->433784640],
  Cell[40015, 948, 85, 2, 70, "Section",
   CellTags->"Properties",
   CellID->85085113],
  Cell[40457, 964, 158, 5, 70, "Input",
   CellTags->"Properties",
   CellID->916887658],
  Cell[40618, 971, 86, 2, 70, "Text",
   CellTags->"Properties",
   CellID->263428567]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"InteractingIntro", 70307, 1585},
 {"Referencing", 70510, 1592},
 {"LayoutIntro", 72643, 1662},
 {"Properties", 73482, 1690}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 81, 2, 70, "Title",
 CellTags->"InteractingIntro",
 CellID->486709749],
Cell[815, 33, 438, 12, 70, "Text",
 CellTags->"InteractingIntro",
 CellID->77467686],
Cell[1256, 47, 159, 5, 70, "Input",
 CellTags->"Referencing",
 CellID->100234074],
Cell[1418, 54, 151, 4, 70, "Text",
 CellID->26353438],
Cell[1572, 60, 908, 25, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->281756696],
Cell[2483, 87, 117, 3, 70, "Text",
 CellID->692782477],
Cell[CellGroupData[{
Cell[2625, 94, 157, 5, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->63616072],
Cell[2785, 101, 301, 8, 70, "Output",
 CellTags->"LayoutIntro",
 CellID->136094279]
}, Open  ]],
Cell[3101, 112, 390, 13, 70, "Text",
 CellID->81966939],
Cell[3494, 127, 445, 13, 70, "Text",
 CellID->221353247],
Cell[CellGroupData[{
Cell[3964, 144, 137, 4, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->545247944],
Cell[4104, 150, 11186, 189, 70, "Output",
 CellTags->"LayoutIntro",
 CellID->96262905]
}, Open  ]],
Cell[CellGroupData[{
Cell[15327, 344, 77, 2, 70, "Section",
 CellTags->"Referencing",
 CellID->23288840],
Cell[15407, 348, 189, 7, 70, "Text",
 CellTags->"Referencing",
 CellID->263117627],
Cell[15599, 357, 159, 5, 70, "Input",
 CellTags->"Referencing",
 CellID->327580673],
Cell[15761, 364, 91, 1, 70, "Text",
 CellID->687775841],
Cell[15855, 367, 1046, 27, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->588292665],
Cell[16904, 396, 635, 21, 70, "Text",
 CellID->512974184],
Cell[CellGroupData[{
Cell[17564, 421, 190, 5, 70, "Input",
 CellTags->"Referencing",
 CellID->203540885],
Cell[17757, 428, 134, 4, 70, "Output",
 CellTags->"Referencing",
 CellID->148652637]
}, Open  ]],
Cell[17906, 435, 105, 3, 70, "Text",
 CellID->157503692]
}, Open  ]],
Cell[CellGroupData[{
Cell[18048, 443, 81, 2, 70, "Section",
 CellTags->"Properties",
 CellID->112718872],
Cell[18132, 447, 373, 9, 70, "Text",
 CellTags->"Properties",
 CellID->123613120],
Cell[18508, 458, 157, 5, 70, "Input",
 CellTags->"Properties",
 CellID->95290409],
Cell[18668, 465, 103, 2, 70, "Text",
 CellTags->"Properties",
 CellID->50294623],
Cell[18774, 469, 1126, 29, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->101449194],
Cell[19903, 500, 79, 1, 70, "Text",
 CellID->63986956],
Cell[CellGroupData[{
Cell[20007, 505, 190, 5, 70, "Input",
 CellTags->"Referencing",
 CellID->338408275],
Cell[20200, 512, 170, 5, 70, "Output",
 CellTags->"Referencing",
 CellID->89894061]
}, Open  ]],
Cell[20385, 520, 234, 7, 70, "Text",
 CellTags->"Properties",
 CellID->721104775],
Cell[CellGroupData[{
Cell[20644, 531, 234, 6, 70, "Input",
 CellTags->"Properties",
 CellID->134890228],
Cell[20881, 539, 4304, 70, 70, "Output",
 CellTags->"Properties",
 CellID->645564620]
}, Open  ]],
Cell[25200, 612, 1103, 37, 70, "Text",
 CellTags->"Properties",
 CellID->306493269],
Cell[26306, 651, 305, 9, 70, "Input",
 CellTags->"Properties",
 CellID->306604920],
Cell[CellGroupData[{
Cell[26636, 664, 136, 4, 70, "Input",
 CellTags->"Properties",
 CellID->256335558],
Cell[26775, 670, 11434, 195, 70, "Output",
 Evaluatable->False,
 CellTags->"Properties",
 CellID->964509593]
}, Open  ]],
Cell[38224, 868, 115, 3, 70, "Text",
 CellID->585431335],
Cell[CellGroupData[{
Cell[38364, 875, 252, 8, 70, "Input",
 CellTags->"Properties",
 CellID->772739336],
Cell[38619, 885, 113, 3, 70, "Output",
 CellTags->"Properties",
 CellID->13174359]
}, Open  ]],
Cell[38747, 891, 107, 3, 70, "Text",
 CellID->1368325],
Cell[CellGroupData[{
Cell[38879, 898, 125, 4, 70, "Input",
 CellTags->"Properties",
 CellID->25461823],
Cell[39007, 904, 111, 3, 70, "Output",
 CellTags->"Properties",
 CellID->84681293]
}, Open  ]],
Cell[39133, 910, 451, 15, 70, "Text",
 CellTags->"Properties",
 CellID->308558814],
Cell[CellGroupData[{
Cell[39609, 929, 255, 8, 70, "Input",
 CellTags->"Properties",
 CellID->399283820],
Cell[39867, 939, 99, 3, 70, "Output",
 CellTags->"Properties",
 CellID->433784640]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40015, 948, 85, 2, 70, "Section",
 CellTags->"Properties",
 CellID->85085113],
Cell[40103, 952, 351, 10, 70, "Text",
 CellID->120843150],
Cell[40457, 964, 158, 5, 70, "Input",
 CellTags->"Properties",
 CellID->916887658],
Cell[40618, 971, 86, 2, 70, "Text",
 CellTags->"Properties",
 CellID->263428567],
Cell[CellGroupData[{
Cell[40729, 977, 199, 6, 70, "Input",
 CellTags->"LayoutIntro",
 CellID->41989888],
Cell[40931, 985, 303, 8, 70, "Output",
 CellTags->"LayoutIntro",
 CellID->290460860]
}, Open  ]],
Cell[41249, 996, 108, 2, 70, "Text",
 CellTags->"Referencing",
 CellID->57228793],
Cell[CellGroupData[{
Cell[41382, 1002, 138, 4, 70, "Input",
 CellTags->"Referencing",
 CellID->466067545],
Cell[41523, 1008, 16547, 277, 70, "Output",
 CellTags->"Referencing",
 CellID->61665611]
}, Open  ]],
Cell[58085, 1288, 243, 6, 70, "Text",
 CellTags->"Referencing",
 CellID->498904818],
Cell[CellGroupData[{
Cell[58353, 1298, 189, 5, 70, "Input",
 CellTags->"Referencing",
 CellID->26370402],
Cell[58545, 1305, 406, 9, 70, "Output",
 CellTags->"Referencing",
 CellID->330874142]
}, Open  ]],
Cell[58966, 1317, 1016, 30, 70, "Text",
 CellTags->"Referencing",
 CellID->38549142],
Cell[CellGroupData[{
Cell[60007, 1351, 233, 6, 70, "Input",
 CellTags->"Referencing",
 CellID->816309410],
Cell[60243, 1359, 4280, 69, 70, "Output",
 CellTags->"Referencing",
 CellID->240812383]
}, Open  ]],
Cell[64538, 1431, 597, 17, 70, "Text",
 CellTags->"Referencing",
 CellID->561993925],
Cell[CellGroupData[{
Cell[65160, 1452, 481, 14, 70, "Input",
 CellTags->"Referencing",
 CellID->572426759],
Cell[65644, 1468, 501, 10, 70, "Output",
 CellTags->"Referencing",
 CellID->429602482]
}, Open  ]],
Cell[66160, 1481, 745, 23, 70, "Text",
 CellTags->"Referencing",
 CellID->186212963],
Cell[CellGroupData[{
Cell[66930, 1508, 230, 6, 70, "Input",
 CellTags->"Referencing",
 CellID->430865221],
Cell[67163, 1516, 1441, 25, 70, "Output",
 CellTags->"Referencing",
 CellID->82881011]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[68643, 1546, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

