/*
 * @(#)ThreadPool.java
 *
 * Copyright (c) 2004 Wolfram Research Inc., All Rights Reserved.
 */
package com.wolfram.bsf.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;

/**
 * ThreadPool
 */
public class ThreadPool extends PooledExecutor {
 
  /** 
   * Create a new pool with all default settings
   **/
  public ThreadPool() {
    super();
    }

  /** 
   * Create a new pool with all default settings except
   * for maximum pool size.
   **/
  public ThreadPool(int maxPoolSize) {
    super(maxPoolSize);
    }

  /** 
   * Create a new pool that uses the supplied Channel for queuing, and
   * with all default parameter settings.
   **/
  public ThreadPool(Channel channel) {
    super(channel);
    }

  /** 
   * Create a new pool that uses the supplied Channel for queuing, and
   * with all default parameter settings except for maximum pool size.
   **/
  public ThreadPool(Channel channel, int maxPoolSize) {
    super(channel, maxPoolSize);
    }
    
}
